
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rnnoise_data.h"


#ifndef USE_WEIGHTS_FILE

#define WEIGHTS_conv1_weights_float_DEFINED
#define WEIGHTS_conv1_weights_float_TYPE WEIGHT_TYPE_float
static const float conv1_weights_float[24960] = {
    -0.17171920835971832, -0.010909800417721272, -0.05144204944372177, 0.004952955991029739, -0.026956260204315186, -0.00921531580388546, -0.045888300985097885, 0.01908729411661625,
    0.04261411726474762, -0.003500391962006688, 0.01849198341369629, -0.011512386612594128, 0.05212428420782089, -0.03018050827085972, 0.01146917138248682, -0.011422001756727695,
    0.0605970099568367, -0.023331183940172195, 0.026728855445981026, 0.056247513741254807, 0.0029107057489454746, 0.030598552897572517, -0.0011967446189373732, 0.040448013693094254,
    -0.019005823880434036, 0.013244853354990482, 0.09333901852369308, 0.004622482229024172, -0.053561020642519, -0.01583864353597164, -0.0036769844591617584, 0.007799055892974138,
    0.018669521436095238, -0.01453246921300888, -0.0026979672256857157, -0.022963721305131912, -0.022827910259366035, -0.011782917194068432, -0.025811506435275078, -0.05931277573108673,
    -0.021096553653478622, -0.020686326548457146, -0.06300510466098785, 0.011782017536461353, -0.04161396622657776, 0.011218128725886345, -0.029055984690785408, 0.032122205942869186,
    0.03750435635447502, -0.015116585418581963, -0.0805726945400238, -0.0011963084107264876, -0.0217695664614439, 0.040880825370550156, -0.0013000831240788102, 0.011951104737818241,
    0.028353065252304077, 0.01655292697250843, 0.00019920579507015646, 0.048614341765642166, 0.015005639754235744, 0.027574623003602028, 0.006802861113101244, 0.004921526648104191,
    -0.0016914133448153734, -0.025228718295693398, -0.009960546158254147, 0.024085547775030136, 0.00640082499012351, -0.0644463375210762, -0.045054249465465546, -0.033245544880628586,
    -0.012027334421873093, 0.0027317155618220568, 0.007908836007118225, 0.02737140655517578, -0.02752086892724037, -0.011257573962211609, -0.007963922806084156, -0.0016969647258520126,
    0.015276028774678707, 0.01010353583842516, 0.006376527715474367, 0.028555598109960556, -0.008490709587931633, -0.0157045628875494, 0.0034895804710686207, -0.01886523887515068,
    0.04002984240651131, 0.037168413400650024, -0.0014958820538595319, -0.060844432562589645, 0.011514449492096901, 9.382013377035037e-05, 0.02628488466143608, 0.0058845700696110725,
    -0.08246839791536331, 0.002665754407644272, -0.028604397550225258, -0.07405458390712738, 0.036556076258420944, -0.05216887965798378, -0.03766576945781708, 0.05067674443125725,
    0.014453206211328506, 0.0030626009684056044, -0.02693243697285652, -0.011116295121610165, -0.10796181857585907, 0.02826385572552681, 0.0020517127122730017, -0.01703006774187088,
    -0.024064496159553528, -0.003582217264920473, -0.04460102319717407, 0.023677697405219078, 0.0006732884212397039, -0.012299073860049248, -0.015704764053225517, -0.016719244420528412,
    0.023755839094519615, 0.027740228921175003, -0.026594117283821106, -0.02953166700899601, 0.01884010247886181, 0.0546945221722126, -0.020682523027062416, -0.014973368495702744,
    -0.10680926591157913, -0.014777235686779022, -0.03260388225317001, 0.037077296525239944, 0.012743718922138214, 0.002009717281907797, -0.03439515829086304, 0.03725241869688034,
    -0.011454585008323193, -0.041340313851833344, 0.06430791318416595, 0.07309868186712265, -0.06786971539258957, -0.006764389108866453, 0.0021069743670523167, -0.017109470441937447,
    -0.03212539851665497, 0.007912521250545979, 0.030761344358325005, 0.032854266464710236, 0.024183550849556923, 0.04586244374513626, -0.009272851049900055, 0.027204060927033424,
    -0.009401052258908749, -0.0034616030752658844, -0.08031024038791656, -0.04564444720745087, -0.005569671746343374, -0.023832229897379875, 0.057286012917757034, 0.042318668216466904,
    0.03878423571586609, -0.04054006561636925, 0.014510765671730042, -0.02476642280817032, 0.025900067761540413, 0.02792627550661564, -0.0013045759405940771, -0.018139583989977837,
    -0.02110232785344124, -0.045499518513679504, 0.06690427660942078, 0.021549098193645477, -0.02586638182401657, -0.03516928106546402, -0.031104801222682, -0.01957513764500618,
    -0.04766706004738808, -0.07827970385551453, -0.08019909262657166, 0.018465634435415268, -0.0617787204682827, -0.04311598092317581, 0.07147537916898727, -0.015507393516600132,
    0.06239517778158188, -0.039513371884822845, 0.0112836305052042, 0.10212380439043045, 0.07752208411693573, 0.0353517085313797, 0.0023839331697672606, -0.003410774515941739,
    -0.01812915876507759, -0.04058318957686424, -0.0012323899427428842, -0.014927862212061882, 0.003720695385709405, -0.03284789249300957, -0.07057330757379532, 0.010056734085083008,
    0.030289405956864357, -0.021296141669154167, -0.007760335225611925, -0.008962305262684822, 0.011444407515227795, 0.008579540997743607, 0.007850196212530136, 0.0035205616150051355,
    -0.035685621201992035, -0.015454252250492573, -0.011322331614792347, 0.009083247743546963, 0.04656526818871498, 0.036276642233133316, -0.009214196354150772, 0.027753403410315514,
    0.035640452057123184, -0.027848578989505768, 0.0236030425876379, 0.005357477813959122, -0.05478200688958168, 0.01739720068871975, 0.0043372237123548985, 0.0024552522227168083,
    0.06947975605726242, 0.015625275671482086, -0.021133869886398315, 0.07567831873893738, -0.026146478950977325, 0.0673360601067543, -0.06896823644638062, -0.003640261245891452,
    -0.008304555900394917, -0.015971986576914787, 0.021596156060695648, -0.052978891879320145, 0.009856169112026691, -0.012560912407934666, -0.02912549115717411, 0.00870382972061634,
    -0.03735395148396492, 0.0018766712164506316, -0.017035527154803276, 0.011841618455946445, 0.01464012823998928, 0.0006423266604542732, -0.04723517224192619, -0.022951893508434296,
    0.000748927763197571, 0.013058837503194809, -0.03719359636306763, 0.036805737763643265, 0.0052735148929059505, 0.05143771693110466, -0.007440078072249889, 0.047322094440460205,
    0.09171371906995773, 0.03628237545490265, -0.049200162291526794, -0.030939020216464996, -0.002579423366114497, -0.006415202282369137, -0.004503216128796339, 0.02213726006448269,
    0.037670280784368515, -0.06917992979288101, 0.02262945845723152, 0.03916216641664505, 0.019046613946557045, -0.02931583859026432, 0.01005192007869482, -0.00479450449347496,
    0.044938694685697556, -0.020460909232497215, -0.018829282373189926, -0.00039921709685586393, -0.05642102286219597, 0.0008520677220076323, -0.01592772826552391, -0.02390979416668415,
    0.013532171957194805, -0.009770236909389496, 0.10682084411382675, -0.04910251498222351, -0.05060857906937599, 0.012691618874669075, 0.001059499103575945, -0.05342019721865654,
    -0.03948672115802765, 0.0014859532238915563, 0.035435885190963745, -0.05565589666366577, -0.03276635706424713, -0.0238149743527174, -0.010842258110642433, -0.030650030821561813,
    0.011023418977856636, 0.04233726114034653, 0.01576496846973896, -0.03178926184773445, -0.04453779757022858, -0.0022131912410259247, -0.05304810032248497, 0.00778307905420661,
    -0.0795169472694397, 0.03172147274017334, -0.040114931762218475, 0.022375110536813736, 0.03517604619264603, -0.04229383543133736, 0.09824973344802856, 0.016584644094109535,
    -0.0426894836127758, 0.032541610300540924, 0.009883422404527664, -0.01498872134834528, 0.021746214479207993, -0.008181652054190636, 0.007659731432795525, 0.030381515622138977,
    0.0026285378262400627, 0.01580793596804142, -0.011252873577177525, 0.02408369816839695, -0.03731227293610573, 0.02515028789639473, -0.048330675810575485, -0.017209654673933983,
    0.01596057415008545, 0.0002870769239962101, -0.011826667003333569, 0.010576634667813778, 0.011334606446325779, -0.009008553810417652, 0.009831259027123451, -0.004448474384844303,
    0.015024486929178238, 0.04405096918344498, 0.043184924870729446, -0.020566841587424278, 0.06885822117328644, -0.011759129352867603, -0.012214024551212788, 0.002092591021209955,
    0.02806040085852146, -0.028513828292489052, -0.053784821182489395, -0.010146076790988445, 0.009473063051700592, -0.019209865480661392, -0.07968292385339737, 0.032986611127853394,
    -0.04752294719219208, 0.007297644857317209, -0.0354035459458828, -0.010201006196439266, 0.039625588804483414, -0.009583791717886925, -0.019173312932252884, -0.006978887598961592,
    0.004023962188512087, -0.028276938945055008, -0.0009846845641732216, -0.027675269171595573, 0.07378596067428589, 0.012095835991203785, -0.047317586839199066, 0.008735578507184982,
    -0.0472550131380558, -0.006553686689585447, -0.04745924472808838, 0.025133047252893448, 0.0019043617649003863, 0.00018482314771972597, 0.007076271343976259, -0.02186351828277111,
    -0.061131469905376434, 0.008988666348159313, -0.019821537658572197, -0.04964686185121536, 0.015621375292539597, 0.014486052095890045, 0.049342043697834015, 0.0048730699345469475,
    0.05572860315442085, 0.01109213475137949, -0.013454567641019821, -0.01892993226647377, 0.0121789975091815, 0.017899155616760254, 0.02669387497007847, 0.03445454686880112,
    0.03557821735739708, 0.01845473237335682, -0.006957203149795532, 0.009908373467624187, 0.013654676266014576, 0.030497822910547256, -0.03946519270539284, -0.029371842741966248,
    -0.05177048593759537, -0.0015757011715322733, 0.016025938093662262, 0.008553373627364635, -0.02159040793776512, 0.028498008847236633, -0.01566159725189209, 0.009977500885725021,
    -0.03448570892214775, 0.023008013144135475, -0.06669580191373825, -0.04494492709636688, 0.007832298055291176, -0.058121636509895325, 0.026819227263331413, 0.03274478390812874,
    0.06040407344698906, -0.07353348284959793, 0.0034152900334447622, -0.040110569447278976, -9.450189099879935e-05, -0.008148787543177605, 0.018554793670773506, 0.024703526869416237,
    -0.031367965042591095, -0.06597812473773956, -0.010820368304848671, 0.07776345312595367, -0.0009280885569751263, -0.014816535636782646, 0.07079266011714935, -0.032426729798316956,
    0.05852591618895531, -0.04891550913453102, -0.007551299408078194, -0.034330617636442184, -0.0304169412702322, 0.004449167288839817, -0.016077809035778046, -0.022697044536471367,
    -0.027744796127080917, -0.047472693026065826, 0.03644609823822975, -0.03127661719918251, 0.052938658744096756, -0.006820439826697111, -0.052968256175518036, -0.01180313155055046,
    -0.009314928203821182, 0.016422206535935402, 0.03569716587662697, -0.01964458078145981, 0.04553104192018509, -0.07668561488389969, 0.0037744324654340744, 0.05506238341331482,
    -0.004542569629848003, -0.007717953063547611, -0.03854292631149292, -0.008754022419452667, -0.005207355599850416, -0.0036086293403059244, 0.02207866683602333, 0.05729322135448456,
    0.014403429813683033, 0.07478009164333344, 0.0124588618054986, 0.009082554839551449, 0.01522904448211193, 0.04441754147410393, 0.027607392519712448, 0.045060478150844574,
    -0.0559309758245945, -0.017727313563227654, 0.0650678500533104, -0.03748912364244461, 0.023854417726397514, -0.04311199113726616, 0.06618959456682205, -0.007961849682033062,
    -0.027242343872785568, -0.0006295690545812249, 0.016150731593370438, -0.026909114792943, -0.011738695204257965, 0.017488369718194008, 0.041725121438503265, -0.00466007087379694,
    0.0408167690038681, -0.022164292633533478, -0.008579414337873459, -0.020733961835503578, -0.031705450266599655, 0.025790011510252953, 0.024389099329710007, 0.016236331313848495,
    0.012626204639673233, 0.014229699037969112, 0.016377359628677368, -0.02572297491133213, -0.06261194497346878, 0.008197587914764881, -0.07443355768918991, 0.01619936339557171,
    0.055491868406534195, 0.0391043946146965, -0.06876415014266968, 0.06389515101909637, 0.010730150155723095, 0.03352687135338783, -0.027419758960604668, 0.06523529440164566,
    0.007025738246738911, -0.042858101427555084, -0.0033796443603932858, 0.031015545129776, -0.004121149890124798, -0.004664506297558546, 0.02937072329223156, -0.01850021630525589,
    0.01084852684289217, 0.03112773597240448, 0.01937686651945114, -0.004524650983512402, 0.02723572589457035, -0.0606195405125618, -0.025892673060297966, -0.015867318958044052,
    0.045987412333488464, -0.007595004513859749, 0.0035762127954512835, 0.0025686100125312805, -0.03249189630150795, 0.03082960657775402, -0.027996335178613663, 0.035380978137254715,
    0.0013940933858975768, 0.05114196613430977, -0.013365847989916801, -0.011625468730926514, -0.03227514028549194, -0.010102671571075916, -0.03775368630886078, 0.017536640167236328,
    -0.03414097800850868, 0.024711912497878075, -0.042695917189121246, -0.037620216608047485, -0.03776358440518379, -0.01305328868329525, 0.06190294027328491, 0.013447263278067112,
    0.023554818704724312, 0.008082527667284012, 0.013261565938591957, -0.04399293661117554, -0.04143891483545303, 0.031850337982177734, -0.07077490538358688, 0.05710669979453087,
    0.05047238618135452, 0.08482955396175385, 0.047175414860248566, 0.02138725481927395, -0.019371047616004944, 0.05058940500020981, 0.038283590227365494, 0.02422649785876274,
    -0.03959685564041138, 0.040685851126909256, -0.0377778559923172, 0.0024571376852691174, 0.0015238950727507472, 0.0016300345305353403, 0.03828040882945061, 0.022457735612988472,
    -0.023212572559714317, -0.06911679357290268, -0.009964833036065102, 0.008843868970870972, 0.0339030846953392, -0.011153548024594784, -0.0379788912832737, -0.03012952394783497,
    -0.014588349498808384, 0.027446331456303596, 0.055031128227710724, -0.009003929793834686, -0.016073258593678474, 0.025221677497029305, -0.018123332411050797, 0.03055628016591072,
    0.0007722213631495833, -0.017855370417237282, -0.02057759463787079, 0.0006050896481610835, -0.06332752108573914, -0.07387929409742355, 0.02367103472352028, 0.0038114304188638926,
    0.0662187784910202, 0.014600900001823902, -0.04300053417682648, -0.06890019029378891, 0.045019060373306274, -1.7106396626331843e-05, -0.09913240373134613, 0.04136037454009056,
    0.06561765819787979, 0.014140820130705833, 0.023492339998483658, 0.03369530290365219, 0.003204320790246129, 0.01518560852855444, -0.008015621453523636, -0.0050336136482656,
    0.02314494550228119, 0.0047885761596262455, 0.04931449145078659, 0.006371683441102505, 0.04491562768816948, -0.039455246180295944, 0.008343026973307133, -0.03808220848441124,
    0.05675196647644043, 0.0012827396858483553, 0.028066160157322884, -0.011239081621170044, 0.04562676325440407, 0.03268152475357056, -0.013289651833474636, -0.01309332624077797,
    0.02378804422914982, 0.02648671343922615, 0.028163274750113487, -0.06377046555280685, -0.031594932079315186, 0.005102620925754309, 0.06905721873044968, -0.0040208203718066216,
    0.028957894071936607, 0.04116913303732872, 0.02818579412996769, -0.027888000011444092, 0.04489618539810181, 0.017430713400244713, -0.03280989080667496, -0.036114443093538284,
    0.011912127025425434, 0.0006799070979468524, 0.03326040878891945, 0.06715532392263412, -0.10159676522016525, -0.01281169056892395, 0.025668079033493996, -0.005890218075364828,
    0.01620376482605934, 0.04828321188688278, -0.04206260293722153, 0.022530825808644295, 0.016053250059485435, 0.023334957659244537, -0.010497668758034706, -0.02930009923875332,
    -0.017402414232492447, -0.038744959980249405, 0.08479908108711243, -0.04151125252246857, -0.017934788018465042, 0.05833835154771805, -0.004844389855861664, 0.08324887603521347,
    0.03225230425596237, 0.004296944476664066, -0.01827315054833889, -0.007230406627058983, -0.017744386568665504, -0.01137557439506054, -0.07012496143579483, 0.025075100362300873,
    -0.031438857316970825, -0.03375636786222458, 0.04460311681032181, 0.034427352249622345, -0.018277427181601524, 0.02088306099176407, 0.04635399207472801, 0.01860096864402294,
    0.021114977076649666, -0.05976280942559242, 0.025233888998627663, 0.024239102378487587, 0.02745089679956436, -0.0469573438167572, -0.005745043512433767, 0.025991078466176987,
    0.10751251876354218, -0.04244577884674072, 0.0047686281614005566, 0.07307185977697372, 0.06780306249856949, 0.014967507682740688, 0.027881434187293053, -0.005729286931455135,
    0.011444741860032082, -0.01820298470556736, 0.005459159146994352, 0.03521517291665077, -0.008738487958908081, 0.034038711339235306, 0.008154545910656452, 0.04260874167084694,
    -0.021045060828328133, -0.014374945312738419, -0.041182879358530045, -0.008219296112656593, 0.007156819105148315, -0.011956099420785904, 0.02098878286778927, -0.016489926725625992,
    0.0075823841616511345, 0.03628324717283249, 0.012219849042594433, 0.011784008704125881, 0.02645399421453476, 0.09717313200235367, -0.002822552341967821, -0.004884533118456602,
    -0.04066789522767067, 0.014389291405677795, 0.01046760380268097, 0.03358311206102371, -0.03495396301150322, 0.02025718055665493, 0.07889244705438614, 0.01385282538831234,
    -0.026229150593280792, -0.0019976445473730564, 0.05344092473387718, -0.044329266995191574, 0.02062063291668892, 0.06323715299367905, -0.07365598529577255, 0.031168239191174507,
    -0.022794144228100777, -0.0006582029745914042, -0.04413273185491562, -0.030992964282631874, -0.026871027424931526, 0.03614211454987526, -0.022754691541194916, -0.0376892164349556,
    -0.035466887056827545, -0.0068688951432704926, 0.042854562401771545, 0.0176377035677433, -0.09595797210931778, 0.036863043904304504, -0.020689582452178, 0.03553139790892601,
    -0.0653805360198021, -0.015344679355621338, 0.06258507072925568, 0.05246942862868309, 0.006820790935307741, 0.009163538925349712, -0.004750934895128012, 0.008628275245428085,
    0.03917689248919487, -0.032398730516433716, -0.025042353197932243, -0.02521587163209915, -0.007198494393378496, -0.024769043549895287, -0.022434938699007034, 0.04067710041999817,
    -0.001074517029337585, 0.023332450538873672, 0.014880744740366936, 0.026332078501582146, 0.061769068241119385, 0.03366051986813545, 0.033271413296461105, -0.055717114359140396,
    -0.014133669435977936, -0.0588526651263237, 0.04272807389497757, 0.06657479703426361, 0.009646394290030003, -0.02786395698785782, 0.00280898530036211, -0.024755803868174553,
    0.03473637253046036, -0.0059683131985366344, -0.07260973006486893, 0.014853784814476967, -0.011045084334909916, -0.025087472051382065, 0.07984690368175507, -0.08027134090662003,
    0.007276394870132208, -0.007467974442988634, 0.0679599791765213, -0.03116193413734436, 0.03723801299929619, 0.018166569992899895, -0.007201663684099913, -0.013903883285820484,
    0.07204096764326096, -0.06156204268336296, -0.004381743259727955, -0.021141283214092255, 0.036802180111408234, 0.0122294332832098, 0.018949616700410843, -0.003660202957689762,
    -0.018305880948901176, 0.013407116755843163, -0.03736720606684685, 0.06428501754999161, -0.0010523054515942931, 0.06018030270934105, 0.030639125034213066, -0.06083657965064049,
    -0.04994520545005798, 0.03158123418688774, 0.02174203097820282, 0.019326793029904366, 0.008618621155619621, -0.013267030008137226, -0.05165557190775871, 0.020537113770842552,
    0.018055247142910957, 0.0275894608348608, -0.021548010408878326, -0.02618272230029106, 0.013044842518866062, -0.03524619713425636, 0.04739552363753319, -0.01032290793955326,
    0.028262909501791, -0.001174412900581956, -6.399494304787368e-05, 0.016515426337718964, -0.02152186445891857, -0.0002661785401869565, -0.024148279801011086, 0.029892390593886375,
    -0.0003307192528154701, 0.011410491541028023, -0.051580481231212616, 0.016979651525616646, -0.014063550159335136, -0.05961829423904419, 0.052302613854408264, 0.0077123274095356464,
    0.0010016892338171601, -0.04350382089614868, 0.030354734510183334, 0.01869376376271248, 0.009654941968619823, 0.040029458701610565, -0.057796411216259, 0.03697151318192482,
    0.007566449698060751, 0.011772303842008114, 0.05534622073173523, 0.03684254363179207, 0.024565009400248528, -0.02598653733730316, 0.018492011353373528, -0.019205017015337944,
    -0.0071680666878819466, -0.02206389047205448, -0.022409621626138687, -0.023768531158566475, -0.038375381380319595, 0.010882052592933178, -0.05161912366747856, 0.010009425692260265,
    -0.08211706578731537, 0.009846387431025505, -0.01033661887049675, 0.043652065098285675, 0.0397256463766098, -0.05727015435695648, -0.013960511423647404, -0.0012200046330690384,
    0.0979907289147377, -0.014849414117634296, 0.005193280056118965, -0.03757477179169655, 0.0004913207376375794, 0.08883757144212723, 0.015163635835051537, 0.050295960158109665,
    0.004066296387463808, -0.014185507781803608, 0.04970797523856163, 0.04129752889275551, -0.020826539024710655, 0.013211756013333797, -0.0670236200094223, -0.03287731111049652,
    0.0025896586012095213, -0.013082391582429409, 0.0015150390099734068, -0.03881514072418213, -0.05250942334532738, -0.041860975325107574, -0.014092311263084412, -0.017634734511375427,
    0.07148224115371704, 0.0063935453072190285, -0.01786760613322258, 0.03270723298192024, 0.00977020338177681, 0.012357191182672977, -0.03238687291741371, -0.019707612693309784,
    0.0391392819583416, 0.032001130282878876, 0.11445217579603195, 0.012356763705611229, -0.055642466992139816, 0.04686075448989868, 0.0067096673883497715, 0.059174444526433945,
    0.03099864535033703, 0.018959008157253265, 0.02913741208612919, 0.07435908913612366, -0.02750171720981598, -0.002174294786527753, 0.0391961894929409, 0.06569322943687439,
    -0.029928110539913177, 0.06490866094827652, 0.05438296124339104, 0.017899325117468834, 0.006588886957615614, 0.006068304181098938, -0.0011009578593075275, 0.033124178647994995,
    0.0015690309228375554, -0.032406147569417953, -0.05321139469742775, -0.01616390235722065, 0.008603083901107311, -0.04209928587079048, -0.026787029579281807, 0.05631833150982857,
    -0.00669544842094183, -0.04073797166347504, -0.033864494413137436, 0.014560593292117119, -0.0012490201042965055, -0.01022438332438469, 0.04691662639379501, 0.012842218391597271,
    -0.002039713319391012, -0.009591905400156975, -0.0012024604948237538, 0.02408825419843197, 0.031922340393066406, 0.008282811380922794, -0.0324164442718029, 0.006866686977446079,
    -0.01473461277782917, 0.022429049015045166, -0.015506350435316563, 0.015519388020038605, -0.0018265831749886274, 0.0064096455462276936, -0.04252460598945618, -0.005139099434018135,
    0.013004501350224018, 0.002930411836132407, 0.059351321309804916, 0.004799106623977423, 0.028305353596806526, 0.07489491999149323, -0.017085641622543335, -0.03957166522741318,
    -0.008378191851079464, 0.0020347842946648598, -0.047136228531599045, -0.04730280861258507, 0.020019855350255966, 0.004805156961083412, -0.01116417720913887, -0.022535433992743492,
    -0.03605714440345764, 0.017151569947600365, -0.05378599464893341, 0.01416994258761406, -0.07831133157014847, 0.10511212795972824, 0.05238029733300209, -0.02369730733335018,
    0.03219960629940033, 0.030288098379969597, 0.03826586902141571, 0.0005926170269958675, -0.04427548870444298, 0.014586059376597404, 0.00325217773206532, 0.011922825127840042,
    -0.001300137140788138, 0.005057880189269781, -0.02066471241414547, -0.014067171141505241, 0.027095869183540344, 0.009469384327530861, 0.029028568416833878, -0.042704105377197266,
    -0.048979971557855606, -0.042415112257003784, -0.004898953251540661, 0.029596561565995216, -0.04239169508218765, 0.036749690771102905, 0.08585160970687866, -0.08555072546005249,
    -0.008474667556583881, -0.013281386345624924, 0.03200941160321236, -0.027543189004063606, -2.754742126853671e-05, -0.0030573538970202208, 0.024126149713993073, 0.04079817235469818,
    0.005263440310955048, 0.047845009714365005, -0.01208256371319294, 0.06253845989704132, -0.03234075754880905, 0.0007113938336260617, -0.055973272770643234, -0.0257541686296463,
    -0.05691355839371681, -0.03852325305342674, 0.015520086511969566, 0.0014883518451824784, -0.05081767961382866, 0.038511794060468674, -0.024074938148260117, 0.041829027235507965,
    -0.022057486698031425, 0.006400179583579302, -0.07697097957134247, -0.016797693446278572, -0.01729387417435646, -0.05358363315463066, -0.05522262677550316, 0.014254875481128693,
    0.012013658881187439, -0.04027619957923889, -0.052061982452869415, -0.05654945969581604, -0.033463120460510254, -0.008968654088675976, -0.040423374623060226, -0.02723774127662182,
    -0.007685199845582247, -0.02985185571014881, -0.027956921607255936, 0.020650506019592285, 0.017040777951478958, 0.05326693132519722, 0.011066824197769165, -0.018185174092650414,
    -0.059121936559677124, -0.020806871354579926, 0.042331743985414505, 0.06890629976987839, -0.023010414093732834, 0.04244391992688179, 0.0571456141769886, 0.04168509691953659,
    0.021582163870334625, 0.041896700859069824, -0.01856919936835766, 0.021872179582715034, 0.0673300176858902, -0.005666584707796574, -0.012233571149408817, 0.0015656179748475552,
    -0.0045225899666547775, -0.00730255339294672, -0.01601729728281498, -0.02427954226732254, -0.002149448497220874, 0.00336847105063498, 0.05383862927556038, -0.04186403751373291,
    -0.011773096397519112, -0.030270691961050034, -0.007800080347806215, 0.0294257290661335, -0.01688387617468834, 0.00010479891352588311, 0.0007722279988229275, -0.007303751073777676,
    0.024257179349660873, -0.007632922846823931, -0.06190807744860649, 0.01480795256793499, -0.058309104293584824, -0.08565019816160202, -0.007616030517965555, 0.04154122993350029,
    -0.001905563403852284, 0.06761530041694641, 0.05688857287168503, 0.05851507559418678, 0.03979591652750969, 0.047279924154281616, 0.012783046811819077, -0.0053956229239702225,
    -0.03746747970581055, -0.006046936381608248, -0.03687799721956253, 0.028140176087617874, 0.1068376675248146, -0.06105794757604599, 0.0023128518369048834, 0.001893944339826703,
    0.00498521002009511, -0.02145065739750862, -0.08338640630245209, 0.03004317730665207, 0.03871283680200577, 0.04816076532006264, -0.03291457146406174, 0.07119970768690109,
    0.09075567126274109, -0.022019097581505775, 0.044512007385492325, 0.006457919720560312, -0.06859376281499863, -0.00014389950956683606, 0.013014287687838078, -0.05041050538420677,
    0.03117867186665535, -0.0067896475084125996, -0.002324014203622937, -0.023067964240908623, 0.0563102550804615, -0.009731165133416653, -0.01450627576559782, 0.0751865953207016,
    0.022454777732491493, 0.019983535632491112, -0.037859074771404266, 0.013540089130401611, 0.046678707003593445, 0.01013980433344841, -0.024034535512328148, 0.035597771406173706,
    0.008071317337453365, 0.004046372603625059, 0.05150950327515602, 0.015042086131870747, 0.01640867441892624, 0.005455530248582363, 0.01523122563958168, 0.006500301416963339,
    0.031066710129380226, 0.024955907836556435, -0.021760499104857445, -0.007736042141914368, -0.01993732713162899, -0.0019060815684497356, -0.028401929885149002, -0.011122421361505985,
    0.04087948054075241, -0.06699962168931961, 0.049076907336711884, 0.02900141291320324, -0.04053759574890137, -0.02507186494767666, 0.04169753938913345, -0.010150822810828686,
    -0.046776413917541504, -0.028435463085770607, 0.03958947956562042, 0.06336506456136703, -0.0049473196268081665, 0.01993321254849434, 0.07149390131235123, 0.0510566309094429,
    -0.010626385919749737, 0.009796191938221455, -0.006952247116714716, -0.01579619199037552, -0.010601363144814968, -0.03355088084936142, -0.010591920465230942, 0.012089733965694904,
    0.019476663321256638, -0.00621584989130497, 0.00730166956782341, -0.055342499166727066, 0.026665473356842995, 0.012677590362727642, -0.010355865582823753, -0.003401906928047538,
    -0.0029001953080296516, -0.0427301786839962, -0.005805531516671181, 0.027078136801719666, -0.027354642748832703, 0.02593953348696232, -0.007121581584215164, 0.008045858703553677,
    0.009792592376470566, 0.053411755710840225, -0.0002180070587201044, -0.07041177898645401, 0.00038551888428628445, 0.008375181816518307, -0.04559854790568352, 0.013934768736362457,
    0.05329093337059021, -0.008824382908642292, 0.021923856809735298, -0.018062688410282135, 0.03024001233279705, -1.0261446732329205e-05, 0.005504149477928877, 0.01508699543774128,
    -0.005150058772414923, 0.024037042632699013, 0.020259704440832138, 0.008935435675084591, 0.026661574840545654, 0.10239563137292862, -0.0008886372088454664, -0.02980627678334713,
    -0.03485364094376564, -0.005112285725772381, -0.05199729651212692, -0.056653205305337906, -0.04733901843428612, -0.007592023350298405, 0.01626620627939701, 0.04346518963575363,
    0.06261042505502701, -0.022639401257038116, 0.026601340621709824, -0.003906859550625086, -0.09229355305433273, -0.07565843313932419, 0.038682494312524796, 0.04865042120218277,
    -0.034129586070775986, 0.0029718601144850254, 0.05413845181465149, 0.016156451776623726, -0.04835832118988037, -0.038991834968328476, 0.0039481548592448235, 0.0220797136425972,
    0.035255126655101776, 0.03923087567090988, -0.007669795770198107, -0.0046848272904753685, 0.08386559784412384, 0.015703748911619186, -0.012630177661776543, 0.014644457958638668,
    -0.06471209973096848, -0.06942511349916458, 0.016077950596809387, 0.030914494767785072, 0.03435544669628143, 0.060597725212574005, -0.025049621239304543, -0.0238936934620142,
    -0.038084477186203, -0.04842677339911461, 0.0013983724638819695, -0.03240795060992241, -0.02303808368742466, -0.012252061627805233, 0.014006766490638256, -0.009732075966894627,
    0.016100924462080002, -0.011550810188055038, -0.03902805224061012, -0.015922533348202705, -0.02922659181058407, -0.009518603794276714, -0.036012206226587296, -0.0434073731303215,
    0.06140856817364693, -0.016278071328997612, -0.014077531173825264, 0.021100526675581932, -0.012961788102984428, -0.004329195246100426, 0.03141142427921295, -0.012255009263753891,
    -0.007494854740798473, 0.07017678767442703, 0.06781470775604248, -0.006170996930450201, 0.004682235885411501, 0.018435807898640633, -0.008773917332291603, 0.03469052165746689,
    0.017488405108451843, 0.008975931443274021, 0.050122298300266266, 0.03941705450415611, 0.023372137919068336, -0.025079689919948578, -0.041581422090530396, 0.01850992441177368,
    -0.006033339072018862, -0.0005727842217311263, -0.018690641969442368, 0.0062159039080142975, -0.011780258268117905, 0.03224553167819977, 0.046350616961717606, 0.009533260017633438,
    0.0186668299138546, -0.04017630219459534, 0.0013148984871804714, 0.01701848767697811, 0.019047141075134277, -0.03418506309390068, 0.0035556708462536335, -0.0026333085261285305,
    -0.008941569365561008, 0.03176242485642433, -0.00046991658746264875, -0.03229440748691559, 0.014668384566903114, -0.0016856305301189423, -0.05182788521051407, 0.002667015651240945,
    0.0006323425332084298, -0.03692447394132614, -0.00933142937719822, -0.022029278799891472, -0.03523247689008713, -0.03258490189909935, -0.02763032726943493, -0.02011915110051632,
    -0.021385464817285538, 0.009635673835873604, -0.008527557365596294, 0.021298537030816078, -0.022532066330313683, 0.01438679825514555, -0.009788441471755505, -0.0706859603524208,
    0.01297809462994337, -0.0038151985500007868, -0.035931386053562164, 0.02524258755147457, 0.006544420961290598, -0.0699683129787445, 0.01866493932902813, -0.004703621845692396,
    0.038357123732566833, -0.019543621689081192, 0.02025187760591507, -0.01841941475868225, 0.07093244791030884, 0.03883017599582672, -0.04982689023017883, -0.004730019718408585,
    0.008083722554147243, 0.03203733637928963, 0.05470355972647667, -0.024734899401664734, 0.049486808478832245, 0.059121403843164444, 0.019037961959838867, -0.03352023661136627,
    0.007537804078310728, -0.0400218591094017, -0.05109405145049095, 0.018511975184082985, -0.022301090881228447, 0.05039563402533531, -0.02659960836172104, 0.022264251485466957,
    -0.009039326570928097, -0.006900496315211058, 0.018912388011813164, -0.026125239208340645, 0.01765017956495285, -0.05063213035464287, 0.016696853563189507, -0.06945019960403442,
    0.03401927277445793, 0.011964048258960247, -0.007531887851655483, -0.021795039996504784, -0.00624112319201231, 0.03273506835103035, -0.03233567625284195, -0.013780477456748486,
    0.010195951908826828, 0.004121568985283375, -0.004701163154095411, 0.045999232679605484, 0.01591631770133972, 0.003961160778999329, 0.010603736154735088, -0.005358352325856686,
    0.019398793578147888, 0.03135087713599205, 0.023398488759994507, -0.007805546745657921, -0.009461886249482632, -0.0007072098669596016, -0.015114552341401577, -0.0007449888507835567,
    -0.07901352643966675, -0.038440220057964325, -0.022105347365140915, -0.006268742494285107, 0.01164462510496378, 0.007303690537810326, 0.03047432005405426, 0.012675251811742783,
    -0.006721349898725748, -0.06420479714870453, -0.03869641572237015, -0.014596624299883842, 0.033789120614528656, 0.019722886383533478, 0.014825478196144104, -0.020576968789100647,
    0.0421096570789814, -0.004934713244438171, -0.024153517559170723, -0.044165439903736115, 0.06945741176605225, 0.019492877647280693, -0.010682441294193268, 0.04438481852412224,
    -0.06430355459451675, -0.08739674836397171, 0.04052887111902237, -0.010006940923631191, -0.030185868963599205, 0.02252790331840515, -0.010336516425013542, 0.008668229915201664,
    0.011332033202052116, -0.005709942430257797, 0.010924262925982475, 0.02847505547106266, -0.02339829131960869, 0.045133039355278015, -0.015199752524495125, -0.002306661568582058,
    0.039974696934223175, -0.039550602436065674, 0.042537614703178406, 0.0661608874797821, -0.0011985013261437416, 0.027723068371415138, -0.014521162025630474, 0.016340147703886032,
    0.011351757682859898, -0.0401943065226078, -0.0345446914434433, -0.02047671005129814, -6.0449241573223844e-05, 0.0867362692952156, 0.03984959051012993, -0.026275448501110077,
    0.036701515316963196, 0.004344037268310785, -0.020290158689022064, -0.006989913992583752, 0.011264434084296227, -0.008621024899184704, -0.019727278500795364, 0.030564241111278534,
    0.010821852833032608, 0.0037291490007191896, 0.017609596252441406, 0.006913261022418737, 0.038144975900650024, 0.0952409878373146, 0.031862564384937286, 0.0308819767087698,
    -0.023606115952134132, 0.0019777838606387377, -0.026371369138360023, -0.011299152858555317, -0.03957170248031616, -0.008992019109427929, -0.04047947749495506, -0.008836964145302773,
    -0.02390826866030693, 0.0018870364874601364, -0.06352464109659195, 0.03248383477330208, 0.007018993142992258, -0.05648164451122284, -0.029482204467058182, -0.030530482530593872,
    -0.050079651176929474, 0.0031593400053679943, 0.0114696454256773, 0.0058794813230633736, 0.006983502767980099, -0.018021315336227417, -0.010937787592411041, -0.0192056093364954,
    0.004535411484539509, 0.03841772302985191, 0.04215368628501892, -0.000678452430292964, -0.01259901374578476, 0.011145816184580326, -0.002640104852616787, 0.012036662548780441,
    -0.030774561688303947, -0.023736950010061264, 0.028093285858631134, -0.012120954692363739, -0.020635541528463364, -0.04032645374536514, 0.017668889835476875, 0.02301754057407379,
    0.004510054364800453, -0.04011030122637749, -0.020535986870527267, 0.03156724199652672, 0.02270478941500187, -0.00176045426633209, -0.0314052551984787, 0.04121548682451248,
    0.014984678477048874, -0.018109073862433434, 0.028794607147574425, -0.01964643970131874, 0.029730085283517838, 0.02534986287355423, -0.013692706823348999, 0.040855780243873596,
    0.015093684196472168, -0.051577627658843994, -0.047682054340839386, 0.013650204055011272, 0.031009066849946976, 0.016532162204384804, -0.04868905991315842, -0.04253029450774193,
    0.023166367784142494, 0.021038714796304703, 0.051195088773965836, 0.046715106815099716, 0.026617368683218956, -0.01309920847415924, -0.06570890545845032, -0.022061094641685486,
    -0.041824765503406525, -0.0114003149792552, 0.03144804760813713, 0.03485715016722679, 0.010003218427300453, -0.0039525264874100685, -0.05849413946270943, 0.030397944152355194,
    0.05917542427778244, 0.07587160170078278, 0.016034116968512535, -0.02721661888062954, -0.0030037902761250734, -0.03833437338471413, -0.091402068734169, 0.06662166863679886,
    -0.023862404748797417, -0.023936819285154343, -0.01737804524600506, 0.003352278610691428, 0.01943623647093773, -0.012187042273581028, 0.03266458213329315, 0.013345827348530293,
    -0.018031403422355652, 0.026657456532120705, -0.03451571241021156, 0.01756591908633709, -0.039396412670612335, 0.007273396477103233, 0.045243989676237106, 0.004423083737492561,
    -0.018599171191453934, 0.012198016047477722, 0.010698246769607067, 0.027026353403925896, 0.010098500177264214, -0.06574498116970062, 0.02701292559504509, 0.012491694651544094,
    0.017244061455130577, -0.035566043108701706, 0.04720624163746834, 0.0006699435762129724, -0.018609974533319473, 0.011692329309880733, -0.043518029153347015, -0.0412074476480484,
    -0.017378995195031166, 0.02669319324195385, 0.050154104828834534, 0.0041620079427957535, -0.019088398665189743, -0.10019560903310776, 0.027383144944906235, 0.025365883484482765,
    0.039010241627693176, -0.028231509029865265, 0.008517567999660969, 0.03630899637937546, 0.07983718067407608, -0.03677221015095711, 0.021420737728476524, -0.024183277040719986,
    -0.014292918145656586, -0.015425307676196098, 0.016471005976200104, -0.07248538732528687, 0.049306850880384445, 0.005066514015197754, 0.01654238998889923, 0.022826751694083214,
    0.04688302055001259, 0.015565893612802029, -0.007091643288731575, -0.00773200485855341, 0.03184230253100395, -0.009147311560809612, -0.034605734050273895, -0.017215989530086517,
    0.045690372586250305, 0.008894912898540497, -0.010455244220793247, -0.007060939446091652, 0.02237914502620697, 0.0006831963546574116, 0.04599776491522789, -0.026000546291470528,
    0.02509228140115738, -0.008578461594879627, -0.0036299144849181175, 0.01710624434053898, 0.03040744736790657, -0.007959666661918163, -0.0028072509448975325, -0.045272283256053925,
    -0.010602910071611404, -0.007024372462183237, 0.06272004544734955, 0.01813429594039917, 0.0053202263079583645, -0.00466500036418438, 0.05660831183195114, -0.024787241593003273,
    0.01633615791797638, 0.011696383357048035, -0.013053897768259048, 0.029354393482208252, 0.016626207157969475, 0.03729298710823059, 0.0033350754529237747, 0.019515328109264374,
    -0.03250688314437866, 0.013037805445492268, 0.03423846513032913, 0.0033472224604338408, 0.048309799283742905, -0.027157189324498177, 0.008968229405581951, 0.012979479506611824,
    -0.02962382882833481, 0.017273759469389915, -0.029378505423665047, 0.010629072785377502, -0.06925304234027863, -0.014388089999556541, 0.03863014653325081, 0.030058076605200768,
    0.020492516458034515, -0.036905914545059204, 0.022808488458395004, -0.020763317123055458, 0.03474162146449089, -0.00939731951802969, 0.03378020226955414, 0.011508947238326073,
    -0.008756804279983044, 0.004846632946282625, -0.05442068725824356, 0.05496770516037941, 0.0421040840446949, 0.014262362383306026, 0.0061897835694253445, 0.026286115869879723,
    -0.02349717542529106, 0.022863293066620827, 0.05571531504392624, 0.004649431444704533, 0.035302117466926575, -0.009586431086063385, -0.01827513985335827, -0.0402316190302372,
    0.019989604130387306, -0.03298178315162659, 0.02456063963472843, -0.024572232738137245, -0.010259999893605709, -0.005281237419694662, -0.03611594811081886, -0.02527446858584881,
    0.021831681951880455, -0.026922326534986496, 0.01482607051730156, 0.008713904768228531, 0.020299440249800682, 0.06770824640989304, 0.02097441256046295, 0.022111492231488228,
    -0.02312043122947216, 0.020401958376169205, -0.02205469459295273, -0.003357331734150648, -0.006713132839649916, 0.031287457793951035, -0.020452946424484253, 0.001822092686779797,
    0.04536987096071243, -0.0046545215882360935, -0.011676255613565445, 0.027535803616046906, -0.013947762548923492, 0.11248304694890976, -0.0015155876753851771, 0.01525024138391018,
    -0.006440623663365841, 0.018511496484279633, -0.019995661452412605, -0.0001960246154339984, -0.031642574816942215, -0.04586769640445709, 0.0028455040883272886, 0.006677753292024136,
    -0.02424784190952778, -0.014135218225419521, -0.012674087658524513, 0.052982259541749954, 0.009839479811489582, -0.007605137303471565, -0.02955811657011509, 0.023823391646146774,
    -0.0031671493779867887, -0.027096377685666084, 0.01148043293505907, -0.02901376225054264, -0.0722423568367958, 0.03976338356733322, 0.016002457588911057, 0.01855144090950489,
    -0.017606554552912712, 0.006135651841759682, -0.005736455321311951, -0.004944550804793835, -0.03284231945872307, -0.0385177917778492, -0.021999351680278778, 0.026868417859077454,
    0.01826140657067299, -0.008546235039830208, -0.02333558350801468, -0.02228384278714657, -0.015156297944486141, -0.010444159619510174, 0.010342423804104328, -0.013532305136322975,
    -0.010636290535330772, -0.0002074719377560541, 0.006385382264852524, 0.00519853550940752, 0.0397484190762043, -0.02426392398774624, -0.008022562600672245, 0.02367323264479637,
    0.010362492874264717, 0.007570362184196711, -0.010817836970090866, -0.04899558797478676, 0.030577227473258972, -0.03350343182682991, 0.037567008286714554, -0.037299785763025284,
    0.01849670708179474, -0.061501797288656235, -0.04120291769504547, -0.012750367633998394, -0.052354585379362106, 0.001615727785974741, -0.01404531393200159, 0.016521530225872993,
    -0.03896009176969528, -0.005854123737663031, 0.008507490158081055, -0.03013981692492962, 0.040346410125494, 0.04108522832393646, 0.011972708627581596, 0.0024032362271100283,
    0.015265395864844322, -0.05880095064640045, -0.0563826784491539, -0.01666422374546528, 0.06686554104089737, 0.008390671573579311, 0.01851155050098896, -0.0197382140904665,
    -0.023785300552845, 0.0362280048429966, 0.009637980721890926, -0.041207656264305115, 0.027478883042931557, -0.009089947678148746, 0.015700500458478928, 0.013569580391049385,
    0.026945283636450768, -0.07201240211725235, 0.03263714537024498, 0.008917727507650852, -0.02858450450003147, 0.023971715942025185, 0.04084235057234764, 0.01071650069206953,
    -0.024448107928037643, 0.04277384281158447, -0.012056575156748295, -0.0012121446197852492, 0.040022339671850204, -0.0226739514619112, 0.029016364365816116, 0.028818728402256966,
    -0.008682950399816036, 0.003438979620113969, -0.0008921075495891273, 0.02997419238090515, -0.010706746019423008, 0.008936733938753605, 0.020576097071170807, -0.013211097568273544,
    0.005691006779670715, 0.026915324851870537, 0.025991424918174744, 0.0003696493513416499, 0.008772669360041618, -0.03641008213162422, 0.007595481816679239, 0.0054395319893956184,
    -0.035248588770627975, -0.0678425133228302, -0.027967968955636024, 0.04934855177998543, -0.05239833891391754, -0.08115208148956299, -0.027574434876441956, 0.02184426784515381,
    0.039043303579092026, -0.048724085092544556, 0.002947792410850525, -0.0017030516173690557, 0.014261825941503048, 0.008423482067883015, 0.040607623755931854, 0.023041998967528343,
    0.040297165513038635, 0.019623516127467155, 0.010869940742850304, 0.032415471971035004, -0.005935101304203272, -0.07374662905931473, -0.03131371736526489, -0.05842313542962074,
    -0.0189690999686718, -0.004424842540174723, 0.018390696495771408, 0.019812507554888725, 0.018500789999961853, -0.006874513812363148, -0.03058532625436783, -0.014158697798848152,
    -0.02523547224700451, -0.006471782922744751, -0.03900506719946861, -0.017345799133181572, 0.06416019052267075, -0.022314447909593582, 0.019239189103245735, 0.0013737604022026062,
    0.027660490944981575, 0.00999547354876995, -0.024561960250139236, 0.014857872389256954, 0.0008324584923684597, 0.010334900580346584, 0.03902764618396759, 0.017478853464126587,
    0.013111021369695663, 0.012957552447915077, 0.03811141476035118, 0.026412157341837883, 0.008877908810973167, 0.0062292772345244884, 0.04512747377157211, 0.04116009548306465,
    0.0037028908263891935, -0.0042106993496418, 0.028964946046471596, 0.038816723972558975, 0.008343284949660301, 0.014636964537203312, 0.016932135447859764, 0.032099783420562744,
    0.07335346937179565, 0.018241066485643387, -0.007087875623255968, 0.009337366558611393, -0.040378689765930176, 0.009433402679860592, 0.006057568360120058, -0.0004051085561513901,
    -0.008329767733812332, 0.009948614053428173, 0.008724226616322994, 0.036008402705192566, -0.04168989509344101, -0.009974125772714615, -0.006174313370138407, -0.0018729474395513535,
    -0.023852020502090454, 0.005672279745340347, 0.04919922351837158, 0.022569095715880394, -0.023458290845155716, -0.013412632048130035, -0.0006322840927168727, 0.027902936562895775,
    -0.03571469709277153, 0.025227298960089684, -0.009200342930853367, -0.0037998699117451906, 0.035356782376766205, -0.007919506169855595, 0.06174755468964577, -0.022781142964959145,
    0.01476629450917244, 6.689226574962959e-05, -0.00025490508414804935, -0.01241662073880434, 0.04045357555150986, 0.010031130164861679, -0.023096533492207527, 0.003737476421520114,
    0.0493335947394371, -0.06133716180920601, -0.027107756584882736, 0.0014946862356737256, 0.004783077165484428, -0.011728713288903236, 0.0011742719216272235, -0.0033230269327759743,
    0.014566197991371155, -0.012727124616503716, 0.025367669761180878, -0.028197310864925385, 0.01892036944627762, 0.039415691047906876, 0.02556540071964264, 0.0004887594259344041,
    0.00924917496740818, -0.03542828932404518, 0.013283454813063145, -0.052531659603118896, 0.015819750726222992, 0.011059753596782684, 0.03575744479894638, -0.011850817129015923,
    0.009593977592885494, 0.038762666285037994, 0.059119656682014465, 0.0187204722315073, 0.00010382138134445995, 0.057051677256822586, -0.001241937279701233, 0.031029455363750458,
    0.027073761448264122, 0.01657051034271717, -0.014828166924417019, 0.04257683828473091, 0.0002558243868406862, 0.03770260512828827, 0.03503420203924179, -0.04957692697644234,
    0.018044259399175644, -0.009209970943629742, -0.052514851093292236, 0.002989761997014284, -0.010395838879048824, 0.00863275583833456, -0.02309170737862587, -0.02740100957453251,
    -0.01670723222196102, 0.020759351551532745, -0.006523799616843462, 0.034763507544994354, 0.0013743595918640494, 0.027439717203378677, 0.06529834866523743, 0.027011975646018982,
    0.02987198531627655, 0.016462979838252068, 0.011507440358400345, -0.00696897367015481, -0.021907398477196693, 0.03787734732031822, -0.02036253735423088, -0.04714806750416756,
    0.01713740825653076, -0.038297053426504135, -0.013718970119953156, -0.010722745209932327, 0.01441569346934557, -0.012592078186571598, 0.040898289531469345, -0.012552890926599503,
    0.002727491781115532, -0.018184741958975792, -0.023145314306020737, 0.014542682096362114, -0.035425517708063126, -0.0377202071249485, 0.009926853701472282, -0.03217338025569916,
    0.0013574502663686872, 0.00476578576490283, -0.0014729348476976156, -0.02276916243135929, 0.008710152469575405, 0.0219221543520689, -0.026261309161782265, -0.007098939269781113,
    0.04447260871529579, -0.01413966529071331, 0.021215010434389114, 0.0022655315697193146, 0.010436998680233955, 0.008930937387049198, -0.04667368903756142, -0.008294819854199886,
    -0.026615850627422333, 0.0022960794158279896, 0.0030519855208694935, 0.011928810738027096, 0.0032917321659624577, -0.010964962653815746, 0.02849765121936798, -0.01429164782166481,
    -0.03775504603981972, 0.01531769149005413, 0.04249318689107895, -0.00815680529922247, 0.05468795448541641, -0.018790440633893013, -0.024109333753585815, -0.0019813186954706907,
    0.03052159957587719, 0.010835557244718075, -0.023309968411922455, 0.017175793647766113, -0.032690998166799545, 0.03422016277909279, -0.0038999635726213455, 0.011735370382666588,
    -0.019708707928657532, -0.004479233641177416, 0.02496766671538353, 0.060122713446617126, -0.004847316537052393, -0.021438434720039368, 0.0511009506881237, -0.008433273062109947,
    -0.004822291433811188, 0.06605213135480881, 0.050671614706516266, 0.04081888869404793, -0.020676104351878166, 0.022712823003530502, -0.02821960486471653, -0.015691420063376427,
    0.016373688355088234, 0.002563080983236432, 0.034063104540109634, -0.013539135456085205, -0.007380257826298475, 0.0012546662474051118, -0.002715036505833268, 0.019966479390859604,
    -0.03157997876405716, 0.035542260855436325, 0.02586286887526512, 0.03298640251159668, -0.01632431335747242, 0.017614418640732765, -0.04256855323910713, 0.029841937124729156,
    0.024920545518398285, -0.016853127628564835, -0.0239541158080101, 0.004278927110135555, -0.040213990956544876, -0.037317220121622086, -0.00136886618565768, -0.003395511070266366,
    0.0014099052641540766, 0.002647476503625512, 0.03256428614258766, 0.016343217343091965, 0.04045676440000534, 0.02090269885957241, -0.011746359057724476, 0.015614524483680725,
    -0.007482863496989012, 0.012459168210625648, -0.02443118952214718, -0.0032570387702435255, 0.03339403122663498, 0.0011646036291494966, -0.012211645022034645, 0.06330198049545288,
    -0.019429141655564308, -0.02092352695763111, 0.02124904654920101, 0.010791323147714138, -0.009288243018090725, 0.0028562990482896566, -0.02519441582262516, -0.037217285484075546,
    0.047710712999105453, -0.022303875535726547, 0.02049146220088005, 0.020575040951371193, 0.013195665553212166, -0.0887376219034195, -0.01069487165659666, -0.014072912745177746,
    0.020188389346003532, 0.017871834337711334, -3.452263626968488e-05, 0.008994152769446373, 0.02665029652416706, 0.006003864575177431, -0.0017928784945979714, 0.020720669999718666,
    0.02218884602189064, 0.016218282282352448, -0.006055088713765144, 0.06676559895277023, -0.008190921507775784, 0.024422932416200638, 0.001922162133269012, 0.017996419221162796,
    -0.007783160079270601, -0.006505480967462063, 0.011533105745911598, -0.016095653176307678, -0.03199321776628494, -0.004754139110445976, 0.007708793971687555, 0.030849715694785118,
    0.018695374950766563, 0.04913776367902756, -0.010968105867505074, -0.04958648607134819, 0.02790481224656105, 0.04355845972895622, -0.0007365367491729558, 0.00041799567406997085,
    0.04571789875626564, -0.0007456051534973085, 0.011600961908698082, 0.0046795872040092945, 0.014963463880121708, 0.008060511201620102, -0.0012847104808315635, 0.021364038810133934,
    0.009404470212757587, -0.021513216197490692, -0.02473834902048111, 0.02297675423324108, 0.025225671008229256, 0.003751427633687854, -0.0069756233133375645, 0.05379737541079521,
    -0.03315994516015053, -0.05300397798418999, 0.019326098263263702, 0.00397125817835331, 0.0010338935535401106, 0.006446131505072117, 0.032446689903736115, 0.03432067856192589,
    0.009089307859539986, -0.026595862582325935, -0.006864685565233231, -0.014234758913516998, -0.005032783839851618, 0.014477040618658066, 0.002659475663676858, 0.01411973126232624,
    0.033915914595127106, -0.07691221684217453, 0.00830728467553854, 0.010285374708473682, -0.026033915579319, 0.00011714551510522142, 0.012573692947626114, -0.00907823070883751,
    -0.008178895339369774, -0.0086622703820467, 0.010967712849378586, 0.07459354400634766, 0.004509258083999157, 0.020412959158420563, 0.03808029368519783, -0.0006519360467791557,
    -0.007903211750090122, 0.012311392463743687, 0.01886809431016445, 0.011012156493961811, 0.040359318256378174, -0.03730861842632294, 0.01152126956731081, 0.05163959786295891,
    -0.02593121863901615, 0.01903124339878559, 0.04031864553689957, 0.03784024342894554, -0.04430684819817543, 0.04147336259484291, -0.01089505199342966, -0.05900008976459503,
    0.015614554286003113, -0.021512843668460846, -0.03453528881072998, 0.01859774813055992, -0.029597168788313866, 0.062467653304338455, -0.026503879576921463, 0.010700417682528496,
    -0.02430601231753826, -0.07157924771308899, 0.043680693954229355, 0.053713418543338776, -0.039312105625867844, 0.019067345187067986, 0.0004587980220094323, -0.05220064893364906,
    -0.021311640739440918, -0.003928763326257467, -0.021217454224824905, 0.0301230289041996, -0.006354567129164934, 0.013267308473587036, 0.02964675985276699, -0.03535747900605202,
    -0.00182242167647928, 0.0360197015106678, -0.02036042883992195, 0.01847224123775959, -0.004854812286794186, 0.05365427955985069, 0.02322915755212307, -0.0020458840299397707,
    -0.021166400983929634, 0.025321729481220245, 0.00373708363622427, -0.027907012030482292, 0.006788815371692181, -0.028083376586437225, -0.01115840021520853, -0.019164999946951866,
    -0.025088533759117126, -0.01087438315153122, 0.027526794001460075, -0.016169611364603043, 0.0315825492143631, 0.02245277538895607, -0.01208251528441906, 0.01960575394332409,
    -0.01022340077906847, -0.004325879272073507, -0.011485478840768337, -0.045960523188114166, 0.024421490728855133, 0.0255136638879776, 0.027406474575400352, -0.024058865383267403,
    -0.01689871959388256, 0.024924729019403458, 0.055574819445610046, -0.005073328968137503, -0.02415512129664421, -0.033968694508075714, -0.020862506702542305, 0.010991394519805908,
    0.004025117494165897, 0.042425353080034256, 0.005830558482557535, -0.02042529173195362, -0.04844297841191292, -0.05701900273561478, -0.0519709438085556, -0.004634362179785967,
    -0.012474285438656807, -0.030022479593753815, 0.006429483648389578, 0.03717944398522377, 0.028669755905866623, -0.014660991728305817, -0.057324185967445374, -0.0006377609679475427,
    0.025630157440900803, 0.02650408260524273, -0.03583449125289917, -0.019057512283325195, -0.0006824042648077011, -0.01409436296671629, 0.01983005926012993, 0.021911529824137688,
    -0.013129694387316704, 0.01576618105173111, 0.01716763712465763, 0.0033646237570792437, 0.04698356240987778, 0.0068452018313109875, 0.03288278728723526, -0.012525219470262527,
    0.023838363587856293, 0.06941186636686325, -0.07117968797683716, 0.038287412375211716, 0.016270004212856293, -0.001633131760172546, -0.00118463474791497, 0.009202291257679462,
    -0.008987822569906712, 0.007493657525628805, -0.01655104011297226, 0.023999767377972603, 0.028294028714299202, -0.02851441316306591, -0.01494359690696001, -0.05541118606925011,
    0.007524455431848764, -0.03204633295536041, -0.018533851951360703, -0.018771501258015633, 0.014143601059913635, 0.05638522282242775, 0.031375955790281296, -0.05501646548509598,
    0.019126834347844124, -0.010136148892343044, -0.012239539064466953, 0.040681757032871246, -0.041324831545352936, -0.05596450716257095, 0.0019538041669875383, -0.02169172093272209,
    0.043703559786081314, -0.01039606798440218, 0.02879924513399601, -0.02879790961742401, 0.04801269620656967, 0.06450489908456802, -0.06531310081481934, -0.03829946741461754,
    -0.058791253715753555, -0.029833031818270683, 0.032506510615348816, 0.008815090171992779, 0.06438418477773666, -0.017933741211891174, 0.05136316642165184, -0.0028632525354623795,
    -0.02338213287293911, 0.0191773921251297, -0.014783062040805817, 0.04649430885910988, 0.013055973686277866, 0.048013247549533844, 0.0037333869840949774, 0.020030904561281204,
    -0.027580542489886284, -0.023972075432538986, 0.0013486186508089304, -0.06612838804721832, -0.004132078029215336, 0.014918298460543156, 0.01494049746543169, -0.019385170191526413,
    0.02214784361422062, -0.00846654362976551, -0.013071078807115555, 0.038811858743429184, -0.04455151781439781, 0.028222311288118362, -0.020095091313123703, 0.07189100235700607,
    -0.0019190466264262795, 0.007575036492198706, -0.0027041612192988396, -0.05196954682469368, 0.020982608199119568, -0.02374337427318096, -0.03971750661730766, -0.04597431421279907,
    0.014676502905786037, -0.06294475495815277, -0.009903461672365665, -0.01780264638364315, -0.0910661369562149, 0.008466551080346107, 0.005881037563085556, -0.02607724256813526,
    0.03868637979030609, 0.00977432169020176, -0.0047513567842543125, 0.027266856282949448, 0.03588104248046875, -0.0007090918952599168, 0.010173913091421127, 0.03324609622359276,
    -0.008455210365355015, -0.04868220165371895, 0.013805761002004147, -0.004172225948423147, 0.027641499415040016, 0.004588991869240999, 0.05402565374970436, 0.046366434544324875,
    0.04144914820790291, -0.007225969340652227, 0.025708084926009178, -0.013810848817229271, 0.0553743913769722, 0.0189037062227726, -0.0018975608982145786, 0.0057980939745903015,
    -0.08067741245031357, 0.03520885109901428, 0.002816611435264349, -0.00409395806491375, 0.047258421778678894, -0.005810140166431665, 0.010446484200656414, 0.013790401630103588,
    0.023157326504588127, -0.009554199874401093, -0.0194142684340477, 0.0050133513286709785, -0.017276598140597343, 0.029910556972026825, -0.026796136051416397, 0.023695332929491997,
    0.010868716984987259, -0.07658974826335907, -0.0026649620849639177, 0.017003405839204788, -0.01731608249247074, -0.009305785410106182, -0.03269331529736519, 0.01466945931315422,
    -0.0053413123823702335, -0.005311780609190464, 0.030427025631070137, 0.0055406647734344006, 0.04084070771932602, 0.0065737441182136536, -0.03288251906633377, 0.029199915006756783,
    -0.0057726455852389336, -0.0024401373229920864, -0.02162858657538891, 0.03787018731236458, -0.005600783973932266, -0.028423551470041275, 0.01395582128316164, 0.0269493218511343,
    0.018259985372424126, -0.018656833097338676, 0.008255510590970516, 0.01657416857779026, 0.018478430807590485, 0.015888528898358345, 0.05592150613665581, -0.03707047551870346,
    0.0004924525856040418, 0.019317438825964928, -0.004796185065060854, 0.025783348828554153, -0.011216944083571434, 0.03694312646985054, 0.05545707046985626, -0.0012108571827411652,
    0.053637124598026276, 0.02673393487930298, -0.00550773786380887, 0.009950595907866955, -0.031484317034482956, 0.045973483473062515, 0.05770590528845787, -0.00024304112594109029,
    0.010211176238954067, -0.018135501071810722, 0.003557395888492465, 0.0026786401867866516, -0.0446167066693306, -0.05173265561461449, 0.008775075897574425, 0.026100696995854378,
    -0.04838306084275246, -0.011240349151194096, 0.004335029982030392, 0.001475819735787809, -0.05000624805688858, -0.05380213260650635, 0.019847527146339417, -0.019044550135731697,
    -0.044796302914619446, -0.005430057179182768, 0.023555126041173935, -0.03588210046291351, 0.059281378984451294, -0.03822654113173485, 0.005749584641307592, 0.0014802198857069016,
    -0.002085392829030752, 0.009549522772431374, -0.03402334451675415, -0.0009984360076487064, 0.016512110829353333, -0.0020028320141136646, -0.044345080852508545, -0.027384566143155098,
    0.021038595587015152, 0.008212335407733917, 0.023875169456005096, -0.01758507452905178, 0.05827399343252182, -0.06858130544424057, 0.033655714243650436, 0.0070787048898637295,
    0.012532558292150497, 0.05097170174121857, -0.02738698199391365, -0.022979041561484337, -0.00831536389887333, -0.009125973097980022, -0.0032963710837066174, 0.027245011180639267,
    0.03476869314908981, 0.008606752380728722, -0.001848725019954145, 0.05254716798663139, -0.0018817445961758494, -0.014693094417452812, -0.044064830988645554, -0.024993717670440674,
    0.0026694489642977715, -0.002023526234552264, -0.02523883990943432, 0.016647344455122948, -0.037494998425245285, -0.010767501778900623, -0.04761926829814911, -0.036286525428295135,
    0.002827283227816224, -0.006691222079098225, -0.04305418208241463, -0.03722734749317169, 0.03132110834121704, -0.025359809398651123, 0.04670612886548042, 0.0093546062707901,
    -0.011208300478756428, -0.006052159704267979, 0.018386105075478554, -0.009440268389880657, -0.030211661010980606, 0.03562130033969879, 0.038944803178310394, 0.04724206402897835,
    0.007649420294910669, 0.058349087834358215, -0.047399625182151794, 0.013593485578894615, 0.002139750402420759, 0.002602851949632168, 0.030799513682723045, -0.03471267595887184,
    0.02359946444630623, 0.03206154704093933, 0.005097586195915937, 0.033138521015644073, 0.0012745021376758814, 0.017581449821591377, -0.00657142186537385, 0.0030526132322847843,
    0.02678515389561653, 0.0163510050624609, 0.04084491729736328, -0.02344484254717827, -0.023103106766939163, -0.0085957245901227, 0.018969543278217316, 0.014873349107801914,
    0.017292657867074013, -0.01370244100689888, 0.03571045771241188, 0.010103009641170502, -0.04206134378910065, -0.05109596624970436, -0.006290609948337078, -0.013433163985610008,
    0.033777400851249695, -0.026165850460529327, 0.010721680708229542, 0.01052195392549038, -0.0022587121929973364, -0.0028403466567397118, -0.013108039274811745, 0.025550391525030136,
    -0.00206929724663496, -0.031033944338560104, -0.07353110611438751, 0.03464627265930176, 0.0043542948551476, 0.042496293783187866, -0.02730359137058258, 0.028355833142995834,
    0.049441806972026825, -0.028150886297225952, -0.03387024998664856, 0.015156129375100136, 0.050856854766607285, 0.04525978863239288, 0.018241871148347855, 0.039243388921022415,
    0.06800529360771179, 0.030014943331480026, 0.015962516888976097, 0.016330450773239136, -0.013024420477449894, 0.008611624129116535, 0.056837160140275955, -0.020150093361735344,
    0.016646362841129303, 0.022762399166822433, -0.0057367789559066296, 0.04522661492228508, 0.0062012760899960995, -0.020141039043664932, 0.03666438162326813, 0.012379353865981102,
    0.0014341940404847264, 0.013360853306949139, 0.031728241592645645, -0.023172177374362946, -0.0369233600795269, 0.0021460542920976877, 0.02406930923461914, 0.030964255332946777,
    0.0005503760767169297, 0.017934024333953857, 0.015195521526038647, 0.0028042164631187916, 0.0014114261139184237, 0.005467107053846121, 0.03547506779432297, -0.04149012267589569,
    -0.03535493090748787, 0.00466610211879015, 0.028667381033301353, 0.007416520267724991, -0.01831149123609066, -0.015266640111804008, -0.005530199501663446, -0.07363344728946686,
    -0.0033548481296747923, 0.0309776421636343, 0.013239669613540173, -0.007932317443192005, -0.009297288954257965, -0.02230919897556305, 0.021815961226820946, 0.03891092911362648,
    0.016325311735272408, -0.009268690831959248, 0.01507178507745266, 0.03797411546111107, 0.02817225083708763, 0.0104827294126153, 0.0181008018553257, 0.033088140189647675,
    -0.015167901292443275, -0.016328033059835434, 0.010414625518023968, 0.06351351737976074, -0.01346641220152378, -0.0065527711994946, -0.004420400597155094, 0.009659881703555584,
    0.06289537996053696, 0.017593828961253166, -0.0072189439088106155, -0.01447799988090992, 0.015497156418859959, 0.0004971100715920329, -0.08881880342960358, 0.002734825946390629,
    0.032423388212919235, -0.06187698617577553, 0.023233160376548767, 0.012486756779253483, 0.004712440073490143, -0.017274850979447365, -0.023399334400892258, 0.012861989438533783,
    -0.019416633993387222, -0.021174293011426926, -0.008300501853227615, -0.023875081911683083, 0.03661874681711197, 0.03600388020277023, 0.03173203021287918, 0.02781524509191513,
    0.038299623876810074, -0.04483689367771149, -0.05164176598191261, 0.013183359988033772, -0.00909618940204382, 0.023596517741680145, -0.012277969159185886, 0.01189766451716423,
    -0.03811020031571388, 0.02173302136361599, -0.04168365150690079, 0.0642809197306633, -0.029988761991262436, 0.030333593487739563, -0.014158790931105614, -0.03266771137714386,
    -0.0212247297167778, -0.004186826758086681, 0.013234110549092293, -0.017322394996881485, 0.019965600222349167, -0.044762466102838516, 0.010253436863422394, 0.008531607687473297,
    -0.04137882962822914, -0.035336971282958984, -0.008837994188070297, -0.03944868966937065, 0.012135240249335766, 0.04988196864724159, -0.03345346823334694, -0.036234546452760696,
    -0.010624525137245655, 0.02735103853046894, 0.006325825117528439, -0.036260757595300674, -0.020858509466052055, 0.007464252877980471, -0.00022596311464440078, 0.021845098584890366,
    0.013604730367660522, -0.01948458142578602, 0.006929578725248575, 0.03382686898112297, 0.0008046249859035015, -0.028484433889389038, -0.010519484058022499, -0.042047884315252304,
    -0.0013440505135804415, 0.0004477598413359374, 0.015208091586828232, -0.057307593524456024, -0.06358246505260468, 0.001922790426760912, 0.022249523550271988, 0.03432686999440193,
    0.029912881553173065, -0.01250256784260273, 0.017081771045923233, 0.021482940763235092, -0.004023029003292322, -0.015130267478525639, 0.016183732077479362, -0.024079671129584312,
    -0.003697772044688463, -0.03236363083124161, -0.009174829348921776, -0.015997083857655525, -0.054769936949014664, -0.07826008647680283, 0.03296368941664696, 0.03274627402424812,
    0.03619314357638359, -0.007597121875733137, -0.02715328149497509, 0.0011447680881246924, -0.024038150906562805, -0.003955323714762926, 0.030849283561110497, 0.0060799019411206245,
    -0.03234575316309929, -0.08244025707244873, 0.01833317242562771, -0.031969815492630005, 0.06189393624663353, 0.06610410660505295, 0.02842394821345806, -0.032191839069128036,
    0.009951533749699593, 0.049756571650505066, -0.0337095707654953, -0.0030177608132362366, 0.03893899917602539, -0.013411179184913635, 0.0038578452076762915, -0.014161664061248302,
    0.005380808375775814, 0.03404947370290756, -0.010847794823348522, -0.030867120251059532, -0.0137470168992877, -0.026795292273163795, -0.018511701375246048, -0.04531555622816086,
    -0.011074715293943882, 0.01697496511042118, -0.020908288657665253, 0.005095869768410921, -0.01216454990208149, 0.05629398301243782, -0.03213625028729439, 0.017309030517935753,
    0.00032025089603848755, 0.030135011300444603, -0.012704120017588139, -0.05825203284621239, -0.06245143339037895, 0.015147976577281952, -0.015467235818505287, 0.03289772570133209,
    0.0036675988230854273, 0.019026655703783035, 0.04068633168935776, 0.005057284142822027, -0.026560183614492416, -0.007841123268008232, 0.011859836988151073, -0.009924214333295822,
    -0.007301548961549997, 0.021440574899315834, -0.001775378710590303, 0.006075948942452669, -0.056154265999794006, -0.028137115761637688, 0.04933420941233635, 0.05352224037051201,
    0.03377526253461838, 0.016478559002280235, 0.03505169600248337, 0.011234555393457413, -0.04562928155064583, -0.008045018650591373, 0.02582041546702385, 0.002393262693658471,
    0.024390392005443573, 0.00598027603700757, -0.017387064173817635, -0.002801606897264719, -0.00550129683688283, -0.045432593673467636, -0.019396113231778145, -0.08770757168531418,
    0.03169109299778938, 0.004685970954596996, 0.022836411371827126, 0.03387963026762009, -0.02362840063869953, -0.03907456621527672, 0.01483605895191431, -0.026780275627970695,
    0.013179010711610317, -0.002958728699013591, -0.004840285051614046, 0.016613027080893517, -0.0036909005139023066, 0.0012379316613078117, -0.020028894767165184, 0.0026105123106390238,
    -0.025693731382489204, -0.004126448649913073, 0.017208386212587357, -0.038172945380210876, -0.0007561739766970277, -0.026265596970915794, 0.00976016279309988, -0.04187864810228348,
    -0.04036456346511841, 0.0005501672858372331, -0.04480333998799324, 0.031815458089113235, 0.0626121386885643, -0.048655424267053604, 0.027525419369339943, -0.037451304495334625,
    -0.0016298620030283928, 0.03937944769859314, -0.0025492229033261538, -0.026381153613328934, 0.011014170944690704, -0.0016757126431912184, -0.03211731091141701, -0.016101958230137825,
    0.01318665873259306, -0.01759648695588112, 0.007568179164081812, -0.016136804595589638, -0.005071710329502821, 0.022177640348672867, 0.0450335331261158, 0.0010757959680631757,
    0.0033342603128403425, -0.0857369601726532, 0.0486438125371933, -0.021003447473049164, -0.006084367632865906, 0.03508850932121277, -0.008464873768389225, 0.006523610558360815,
    0.06370328366756439, 0.02209782786667347, -0.0025358565617352724, -0.010441082529723644, 0.038368239998817444, 0.014073727652430534, -0.004032801371067762, -0.025232555344700813,
    0.04225057736039162, -0.04094283655285835, -0.014160732738673687, 0.0196087509393692, 0.01312624104321003, 0.008394611068069935, 0.0067137242294847965, 0.0031574522145092487,
    -0.0033827517181634903, -0.043228525668382645, -0.019278716295957565, -0.02646673657000065, -0.01835220493376255, -0.019692979753017426, 0.022062284871935844, 0.01421383023262024,
    -9.497720748186111e-05, -0.053057216107845306, 0.00564931845292449, -0.018105892464518547, -0.008619686588644981, 0.007442783564329147, 0.05525925010442734, 0.024589283391833305,
    0.02153143286705017, -0.004351621959358454, 0.003278607502579689, 0.030553799122571945, -0.01377317775040865, -0.02645399235188961, 0.0010654140496626496, -0.024686280637979507,
    -0.001510492991656065, 0.02537078782916069, -0.002499169670045376, 0.033554885536432266, -0.008860049769282341, -0.017639366909861565, -0.027177250012755394, 0.02070986106991768,
    0.04464428499341011, 0.024834077805280685, 0.01716790534555912, -0.030367400497198105, -0.07287710905075073, 0.01944812387228012, -0.020423950627446175, -0.047448817640542984,
    -0.0031974094454199076, -0.018640298396348953, 0.005815601907670498, 0.042173899710178375, 0.0363013930618763, -0.001817100215703249, 0.04303700104355812, 0.03050711378455162,
    0.055586010217666626, -0.03234758600592613, 0.00037706686998717487, 0.041975900530815125, 0.0035501618403941393, -0.09849867969751358, -0.028477678075432777, -0.0034547520335763693,
    -0.022838570177555084, -0.03634990379214287, -0.002774949884042144, 0.043731361627578735, -0.0057047223672270775, 0.04058651998639107, -0.02229531854391098, 0.07516328245401382,
    -0.025136714801192284, -0.029804470017552376, 0.018042776733636856, 0.022466780617833138, -0.044205471873283386, 0.04528176411986351, 0.030200578272342682, 0.009090498089790344,
    -0.03415854275226593, -0.007915974594652653, -0.024721425026655197, 0.014123485423624516, -0.013935527764260769, 0.02326875366270542, 0.009118247777223587, -0.07486220449209213,
    0.02738761156797409, 0.05233423784375191, 0.031195510178804398, -0.022969238460063934, 0.04641127958893776, -0.035901445895433426, -0.036551013588905334, 0.029674647375941277,
    -0.00163556938059628, -0.011357330717146397, -0.016059255227446556, -0.007760708220303059, 0.004917559213936329, 0.006805124692618847, 0.058836594223976135, 0.0035216191317886114,
    0.009990573860704899, 0.025700392201542854, 0.015982048586010933, -0.015531332232058048, -0.007790088187903166, -0.004890403710305691, -0.02420101687312126, -0.022101033478975296,
    -0.02701202593743801, -0.0704173892736435, -0.018621547147631645, -0.009452815167605877, 0.02316349931061268, -0.00590446637943387, 0.022551702335476875, -0.05257156863808632,
    -0.01260104589164257, 0.057491447776556015, -0.0015859996201470494, -0.0028316406533122063, -0.010185819119215012, -0.05995325371623039, 0.013075914233922958, -0.022877251729369164,
    -0.01717955432832241, -0.008444407023489475, 0.038946326822042465, -0.004479440860450268, 0.029254592955112457, -0.008489993400871754, 0.026473840698599815, -0.006142636761069298,
    -0.006264796946197748, 0.01837299019098282, -0.004786887671798468, -0.012705158442258835, -0.07617699354887009, 0.011247429065406322, 0.011887389235198498, 0.005392942111939192,
    0.0016976759070530534, 0.04697326943278313, 0.03302379697561264, 0.042373985052108765, -0.0002964955347124487, -0.020826175808906555, -0.02506284974515438, -0.010722234845161438,
    -0.01730392873287201, -0.024779796600341797, 0.0023723840713500977, 0.0027845939621329308, 0.025548668578267097, -0.00246460922062397, -0.029158063232898712, 0.048370447009801865,
    -0.009923374280333519, 0.0011336887255311012, -0.034865573048591614, -0.024825086817145348, -0.013781702145934105, 0.03908178582787514, -0.00324565009213984, 0.0010901510249823332,
    -0.03180037811398506, -0.055112939327955246, -0.005547655746340752, -0.018258007243275642, -0.014522296376526356, 0.011622780933976173, 0.06604976952075958, 0.02155369706451893,
    -0.03666684031486511, 0.021138710901141167, -0.06293775141239166, 0.04627880081534386, -0.010582088492810726, -0.003067675046622753, 0.008629660122096539, 0.015552280470728874,
    -0.0524270124733448, 0.005993776489049196, -0.015392743051052094, -0.03261096775531769, 0.022809948772192, -0.07539153099060059, -0.004578152671456337, 0.03824353218078613,
    -0.0025433492846786976, -0.04358283057808876, 0.0019053049618378282, -0.032391756772994995, -6.740938988514245e-05, -0.005903644021600485, 0.04270103946328163, -0.0030220344197005033,
    -0.0411677323281765, 0.017441336065530777, -0.03556320071220398, -0.015646617859601974, -0.009073530323803425, -0.020632049068808556, -0.009590600617229939, 0.04257383942604065,
    -0.01624041609466076, -0.00388561119325459, 0.02314438298344612, -0.011611123569309711, -0.006991656497120857, -0.04566051438450813, 0.01004484947770834, -0.015991773456335068,
    -0.047919560223817825, -0.040525972843170166, 0.005170696880668402, 0.008084050379693508, -0.03816165030002594, 0.012140627019107342, -0.0010280163260176778, -0.010346952825784683,
    -0.0029890257865190506, 0.05791518837213516, 0.07046150416135788, 0.04972168058156967, -0.001382236834615469, -0.011196644976735115, -0.011509477160871029, 0.0016023012576624751,
    -0.01456610206514597, -0.03656969964504242, -0.025528671219944954, 0.0008049863972701132, -0.016698570922017097, -0.02983802743256092, -0.004224810283631086, 0.03138968348503113,
    0.027626173570752144, -0.03983647748827934, -0.011842881329357624, -0.005223334301263094, 0.00798803474754095, -0.01065927091985941, -0.009674247354269028, -0.03284792602062225,
    0.0173826664686203, -0.07435595244169235, 0.0003541970218066126, 0.014419008046388626, -0.008645904250442982, 0.05535418540239334, 0.03799135237932205, -0.030838843435049057,
    0.04428063705563545, -0.04099918156862259, -0.03031422570347786, -0.01921873353421688, -0.04166681692004204, -0.0028397953137755394, 0.0276847705245018, 0.007601422257721424,
    -0.06864411383867264, -0.03584669902920723, -0.004346517380326986, 0.033753152936697006, 0.024703674018383026, -0.007514439057558775, -0.059443723410367966, 0.04315607622265816,
    -0.0033207079395651817, -0.047277431935071945, 0.02790067344903946, -0.06304040551185608, -0.004364781081676483, -0.014986972324550152, -0.0492570661008358, 0.07133937627077103,
    0.0132384542375803, 0.02437949925661087, 0.00353608769364655, 0.02445894479751587, -0.008057049475610256, 0.014949571341276169, 0.01543475966900587, -0.018858211115002632,
    0.025249065831303596, 0.07431816309690475, 0.0227214265614748, -0.00708254287019372, -0.010215549729764462, -0.013608465902507305, 0.016395235434174538, -0.012014664709568024,
    0.03055490180850029, 0.02578669972717762, 0.00480251619592309, 0.019947752356529236, -0.002953474409878254, -0.009759421460330486, -0.030767036601901054, 0.01991104707121849,
    0.03325994312763214, -0.016238313168287277, 0.06508128345012665, -0.003272346220910549, -0.017772922292351723, 0.010713282972574234, 0.04857174679636955, 0.03962105140089989,
    0.026989465579390526, -0.01122368685901165, 0.02673066407442093, 0.025771364569664, 0.01355403009802103, -0.054812587797641754, -0.0058030313812196255, 0.04393872991204262,
    0.02352227456867695, -0.0010143113322556019, -0.0072488985024392605, 0.03198753669857979, -0.02518904022872448, 0.008914623409509659, -0.02475946582853794, -0.04153526574373245,
    0.01793055608868599, 0.027255268767476082, 0.000729316205251962, -0.009233425371348858, 0.01964508555829525, 0.032294999808073044, 0.031387217342853546, 0.045193664729595184,
    0.004204521421343088, 0.01730489358305931, 0.009062458761036396, 0.0034418965224176645, 0.026139313355088234, 0.0245957151055336, -0.0028734602965414524, -0.0058696456253528595,
    -0.05719958618283272, -0.00464980211108923, -0.008621539920568466, -0.011565596796572208, 0.08563489466905594, -0.05728071182966232, 0.007038417737931013, -0.001984878210350871,
    0.003998416941612959, -0.020449591800570488, -0.006152359768748283, -0.01933196559548378, 0.0372212752699852, -0.005882663186639547, -0.03182518109679222, 0.011520436964929104,
    -0.017616335302591324, 0.0007084759999997914, 0.04617692157626152, -0.03975818306207657, 0.014318829402327538, 0.037612512707710266, 0.02391238324344158, -0.028129817917943,
    -0.010732680559158325, -0.10272978246212006, -0.03642335906624794, 0.008828772231936455, -0.020778294652700424, -0.015947582200169563, 0.01563243567943573, -0.01076297927647829,
    -0.004332144744694233, 0.04529683664441109, 0.017482466995716095, 0.027368709444999695, 0.020914290100336075, 0.03302599862217903, 0.02145814523100853, -0.04043938219547272,
    0.023242101073265076, -0.015351621434092522, 0.07400684803724289, -0.01488722674548626, 0.04072573408484459, -0.025041939690709114, -0.023062286898493767, 0.006828604266047478,
    0.07249072939157486, 0.07505372911691666, 0.011122054420411587, -0.008694669231772423, -0.04254449903964996, -0.025946831330657005, 0.03981485590338707, 0.0012235901085659862,
    0.017855152487754822, 0.032083138823509216, -0.019923072308301926, 0.06582164764404297, 0.03602999076247215, 0.05765935033559799, -0.05310202017426491, -0.026218969374895096,
    -0.009608222171664238, -0.03961869701743126, 0.0682736411690712, 0.004164382349699736, -0.03840550035238266, -0.027244703844189644, -0.013763152062892914, 0.030799303203821182,
    -0.017101461067795753, -0.02485787495970726, -0.031049039214849472, 0.036852624267339706, 0.005304885562509298, 0.020332327112555504, 0.04212438315153122, 0.035215120762586594,
    -0.017191819846630096, 0.02893032692372799, 0.0346321165561676, -0.03528217226266861, -0.008068189024925232, 0.019842449575662613, -0.009932300075888634, -0.03213734179735184,
    0.009627730585634708, 0.019252009689807892, -0.007838639430701733, 0.059429995715618134, 0.02950848639011383, -0.000542007910553366, 0.03185887262225151, -0.040474191308021545,
    -0.015070696361362934, 0.03131299465894699, -0.043294865638017654, 0.018744096159934998, 0.0035069638397544622, -0.06781795620918274, 0.023998845368623734, -0.06403030455112457,
    -0.014706550166010857, 0.02785002999007702, -0.031107967719435692, -0.020938528701663017, 0.026189353317022324, -0.03565892204642296, 0.01566815935075283, -0.03696829825639725,
    0.05026276037096977, 0.05746067687869072, 0.007615497801452875, -0.02915886417031288, -0.038203392177820206, -0.0016178666846826673, -0.030056091025471687, 0.009820126928389072,
    0.0015737760113552213, -0.009922992438077927, -0.03383106738328934, -0.011148958466947079, 0.027297217398881912, -0.008919076062738895, -0.026418648660182953, -0.037877488881349564,
    0.03664590045809746, 0.004900815896689892, -0.027278006076812744, 0.009687293320894241, -0.06005861610174179, 0.026043234393000603, 0.00597033416852355, -0.02017633430659771,
    0.02121288701891899, 0.04242787882685661, 0.011364487931132317, 0.018552524968981743, -0.014715403318405151, 0.007847564294934273, -0.045983318239450455, -0.009372481144964695,
    0.053821463137865067, -0.01096290908753872, -0.0016797302523627877, 0.025330016389489174, -0.048820093274116516, -0.07152093946933746, 0.016138726845383644, 0.03211211785674095,
    -0.028561042621731758, -0.025018267333507538, 0.04354386031627655, -0.04269744083285332, -0.011489368043839931, 0.013262882828712463, 0.007332374807447195, 0.02354932203888893,
    -0.00044012031867168844, 0.018050506711006165, 0.03715208172798157, -0.019298499450087547, -0.01565861888229847, -0.020379865542054176, 0.03352666273713112, 0.0367814302444458,
    0.017104988917708397, -0.02795594371855259, -0.06099916622042656, -0.001420921878889203, 0.018407713621854782, 0.06564033776521683, 0.010067114606499672, -0.015142803080379963,
    -0.022422533482313156, -0.03119603917002678, -0.009284468367695808, -0.021747050806879997, 0.02887003682553768, -0.04057040810585022, -0.0029132768977433443, -0.008222478441894054,
    -0.0077116284519433975, -0.0002427019499009475, 0.05713125690817833, -0.01864245906472206, -0.03234105929732323, -0.04133745655417442, 0.0014679641462862492, 0.003230319358408451,
    0.03404603525996208, 0.02891068160533905, -0.004371460527181625, 0.0023354068398475647, 0.017231643199920654, -0.003623361000791192, 0.034841638058423996, -0.018540313467383385,
    0.023485355079174042, -0.015158788301050663, -0.03460720553994179, 0.018769092857837677, 0.022849174216389656, 0.04322008416056633, -0.01658613607287407, -0.007752606179565191,
    0.04904384911060333, -0.05314091965556145, -0.02217419072985649, 0.008998068980872631, 0.04735581576824188, -0.02989969402551651, -0.023442422971129417, -0.01842668280005455,
    -0.026220005005598068, -0.0195304024964571, 0.00813510175794363, -0.008823062293231487, 0.022940324619412422, 0.00985623523592949, -0.0006496843998320401, -0.035893142223358154,
    0.00033913468359969556, 0.014832288026809692, 0.04885770380496979, 0.01234350260347128, 0.002162697957828641, 0.01974959298968315, 0.003930796403437853, 0.06743944436311722,
    -0.06596170365810394, -0.03647560998797417, 0.002185964258387685, 0.026050593703985214, -0.009556560777127743, 0.04377404600381851, -0.017676260322332382, 0.03297582268714905,
    -0.006340201944112778, -0.05243130028247833, -0.018552612513303757, -0.023018240928649902, -0.015694979578256607, -0.008237894624471664, 0.016017088666558266, -0.03009883500635624,
    -0.028338370844721794, 0.011304757557809353, 0.01608247682452202, 0.018236637115478516, 0.008257088251411915, 0.010941799730062485, 0.009743502363562584, 0.0028646092396229506,
    -0.021446093916893005, -0.01418643444776535, -0.007777344901114702, -0.019722944125533104, 0.030778855085372925, -0.008868659846484661, 0.02154236100614071, -0.033527638763189316,
    -0.02345847152173519, -0.040401801466941833, -0.05505409091711044, -0.041729141026735306, -0.01026848517358303, -0.005196682643145323, 0.03492552042007446, -0.01709355041384697,
    -0.040751874446868896, -0.05077311396598816, 0.0455995537340641, -0.03806450217962265, -0.023601418361067772, 0.04218094423413277, -0.03197445347905159, 0.008152894675731659,
    0.008244816213846207, -0.09281940013170242, -0.015670403838157654, 0.012210237793624401, 0.02467411570250988, 0.03246749937534332, 0.012715832330286503, 0.020722869783639908,
    0.0165956299751997, -0.041004691272974014, -0.02169576846063137, 0.00945065077394247, -0.0343838632106781, -0.0013423789059743285, -0.018301449716091156, -0.003595913527533412,
    0.008585362695157528, -0.02950015850365162, 0.07728555053472519, -0.0010389507515355945, -0.023983238264918327, -0.05031310021877289, -0.015612367540597916, -0.0026475570630282164,
    -0.001272255671210587, 0.027955632656812668, -0.016196146607398987, -0.009167966432869434, 0.025521177798509598, -0.018952079117298126, -0.013660578057169914, -0.010313964448869228,
    -0.009541857056319714, 0.02059035375714302, 0.021771222352981567, -0.009689701721072197, 0.008741187863051891, 0.0509830042719841, 0.07921040058135986, 0.002439516596496105,
    -0.0042673093266785145, -0.0369998961687088, -0.022125156596302986, 0.02092830277979374, -0.07183533906936646, 0.013809573836624622, -0.03733430057764053, 0.012494649738073349,
    -0.01756640337407589, -0.00039126595947891474, 0.03353957459330559, -0.03214583173394203, -0.0159907229244709, -0.054909661412239075, -0.012423748150467873, 0.051808152347803116,
    0.02067120373249054, 0.04670475050806999, 0.08054396510124207, 0.01617061160504818, 0.05536128953099251, -0.003040147013962269, -0.011367127299308777, -0.022859983146190643,
    0.03789529949426651, -0.01817844808101654, -0.015977900475263596, 0.05182372406125069, -0.017636554315686226, 0.002810286357998848, -0.017251353710889816, -0.015326175838708878,
    -0.0063309320248663425, -0.0382363423705101, -0.04378238692879677, -0.016755932942032814, 0.03327317535877228, 0.022678082808852196, -0.022815540432929993, 0.01523183286190033,
    0.06182034686207771, 0.025812523439526558, -0.020427612587809563, 0.005607248283922672, -0.004506859462708235, -0.043513622134923935, 0.037832338362932205, 0.017877358943223953,
    -0.00372041342779994, -0.014013022184371948, -0.05731496587395668, 0.01949344016611576, -0.005106702446937561, -0.003941426053643227, -0.03712071478366852, 0.030306458473205566,
    0.028765317052602768, -0.0005644887569360435, -0.014179525896906853, -0.023252611979842186, 0.03006875328719616, 0.03129689022898674, -0.049502089619636536, -0.008232698775827885,
    -0.015254326164722443, 0.00809415802359581, 0.02016124501824379, 0.013521329499781132, 0.015511506237089634, 0.043199218809604645, -0.02058258280158043, 0.013528604060411453,
    0.023769181221723557, 0.051013510674238205, 0.029012531042099, 0.02971031330525875, -0.01566615141928196, 0.005461786407977343, 0.01867840252816677, 0.04422586038708687,
    -0.014297310262918472, 0.019201694056391716, -0.04998210445046425, -0.05194025859236717, -0.044351931661367416, -0.03099711611866951, 0.02807183936238289, 0.006498623173683882,
    0.020652180537581444, -0.017509914934635162, -0.014407279901206493, 0.008774504996836185, 0.026669315993785858, -0.03582679107785225, -0.004815609659999609, -0.09542882442474365,
    -0.059273749589920044, 0.00031791251967661083, 0.032744091004133224, 0.03038143366575241, -0.0413336455821991, 0.026165414601564407, 0.0528746098279953, -0.04525408521294594,
    0.040144454687833786, -0.01041193213313818, -0.015086603350937366, 0.017331896349787712, 0.09120750427246094, -0.02161896787583828, -0.01795724593102932, -0.05268486961722374,
    -0.07176744192838669, -0.026554280892014503, 0.045971788465976715, 0.010887131094932556, -0.029466433450579643, 0.010680987499654293, -0.06731171160936356, 0.04017587751150131,
    0.020471379160881042, -0.017057253047823906, 0.035913120955228806, 0.008256080560386181, 0.03786444291472435, 0.02943222038447857, -0.0820198580622673, 0.05757085606455803,
    0.0636412724852562, 0.029820775613188744, 0.02015734277665615, 0.0143983019515872, -0.02353093773126602, -0.040626704692840576, -0.016028283163905144, -0.008957033045589924,
    -0.0012157895835116506, -0.006184954661875963, 0.05063530057668686, 0.04631629213690758, 0.014630273915827274, 0.0287521630525589, 0.05659663304686546, -0.0726979449391365,
    -0.011302836239337921, 0.010161270387470722, -0.04693082720041275, -0.048136722296476364, 0.11639079451560974, 0.013547000475227833, -0.02803851291537285, -0.008439124561846256,
    -0.030066853389143944, -0.010897211730480194, 0.01657184399664402, 0.0014797324547544122, -0.028062352910637856, 0.019293371587991714, 0.027410028502345085, 0.047273848205804825,
    0.059551771730184555, 0.05895407870411873, 0.03596753627061844, -0.025529958307743073, -0.015804095193743706, 0.05959596484899521, 0.030467554926872253, -0.009079950861632824,
    -0.014643974602222443, -0.013386666774749756, 0.08721984177827835, 0.024724269285798073, -0.026276210322976112, -0.049972161650657654, 0.03260025009512901, -0.05209174007177353,
    -0.0374385230243206, 0.0610625296831131, 0.02074591815471649, 0.011530613526701927, -0.0010702820727601647, 0.05024329572916031, 0.050601281225681305, -0.0026373821310698986,
    0.04614035040140152, 0.00598036777228117, 0.00010110603034263477, -0.03373298421502113, -0.03673747926950455, -0.03010863997042179, -0.007685523480176926, 0.0337645523250103,
    -0.01179991103708744, 0.009846261702477932, 0.02280241623520851, -0.0260585006326437, 0.016434818506240845, -0.016756122931838036, 0.018404360860586166, -0.036267638206481934,
    0.014124991372227669, -0.01201474480330944, 0.0016778323333710432, 0.02249583974480629, 0.045957066118717194, 0.0009799350518733263, 0.010515538044273853, -0.015274959616363049,
    -0.0030569988302886486, -0.04358404502272606, 0.02902986854314804, -0.011191514320671558, 0.005608834326267242, 0.07410962879657745, -0.0013963021337985992, 0.028165031224489212,
    0.010823769494891167, -0.043750032782554626, -0.04235122352838516, 0.011802548542618752, 0.026204867288470268, 0.031513866037130356, 0.01862841658294201, 0.010978572070598602,
    0.014996069483458996, 0.03396245092153549, -0.03669096156954765, 0.0020438339561223984, -0.03717990964651108, -0.03441730886697769, -0.03516004607081413, -0.004322213586419821,
    -0.03259653225541115, 0.0004019945045001805, -0.0080751096829772, -0.0040670051239430904, -0.035951487720012665, 0.00612412765622139, 0.016604507341980934, 0.07691304385662079,
    0.08841269463300705, -0.006281387992203236, 0.010997343808412552, 0.03823012113571167, -0.06461164355278015, -0.042705778032541275, -0.00876686442643404, 0.0473804771900177,
    -0.006358458194881678, 0.06036365404725075, 0.00699304835870862, 0.02024499885737896, 0.02441367320716381, -0.006504483055323362, 0.019460802897810936, -0.018313245847821236,
    -0.008609090931713581, -0.02152598649263382, 0.017185518518090248, 0.06865725666284561, -0.035150688141584396, -0.016750195994973183, -0.0029859670903533697, -0.009797456674277782,
    -0.0138919148594141, -0.01932895928621292, -0.009104033932089806, 0.026143275201320648, -0.0306677408516407, 0.006640907377004623, 0.002000832464545965, 0.04857117310166359,
    -0.03274700790643692, -0.019605018198490143, -0.009060988202691078, -0.002113209804520011, 0.06327761709690094, -0.013537468388676643, -0.03977474942803383, 0.0027949591167271137,
    0.0010175183415412903, 0.0329187773168087, -0.04050255939364433, 0.0198493804782629, 0.026807177811861038, -0.04423335939645767, -0.05295668914914131, 0.030990565195679665,
    -0.029986616224050522, 0.06236354634165764, -0.027773499488830566, -0.01418390218168497, 0.03634529560804367, 0.022134628146886826, -0.016141002997756004, -0.034715618938207626,
    0.0005823646788485348, -0.06983940303325653, -0.0808493047952652, 0.02869265340268612, -0.02765907719731331, -0.01865101046860218, -0.021681685000658035, -0.06591951102018356,
    0.0188314076513052, 0.02492303028702736, 0.008620791137218475, -0.029019774869084358, 0.08307074010372162, -0.01923210173845291, -0.0683489665389061, -0.006916041485965252,
    -0.015621445141732693, 0.022643642500042915, 0.00943848304450512, -0.044483084231615067, -0.04244173690676689, 0.04979121685028076, -0.0056487442925572395, 0.015908552333712578,
    -0.009964089840650558, 0.012187788262963295, 0.00996992364525795, 0.022751381620764732, 0.009844412095844746, 0.016307754442095757, 0.06504743546247482, -0.016342490911483765,
    -0.009104127995669842, 0.02523910440504551, 0.03809119388461113, 0.005222609732300043, -0.03863499313592911, -0.002409794367849827, -0.006852670572698116, -0.02469560131430626,
    0.01811908930540085, -0.00971231609582901, 0.000333599018631503, -0.02471846528351307, -0.031135326251387596, -0.025945670902729034, 0.029251573607325554, 0.017033755779266357,
    0.0022195226047188044, -0.020187759771943092, 0.0032901428639888763, 0.017916565760970116, -0.025456009432673454, -0.00979518610984087, -0.009858396835625172, -0.015817733481526375,
    0.002882690168917179, -0.026146480813622475, 0.049843110144138336, -0.042075976729393005, 0.005711379460990429, 0.008594196289777756, 0.01672523468732834, 0.013549714349210262,
    0.032450512051582336, -0.018473371863365173, 0.009274807758629322, 0.035231608897447586, 0.016554446890950203, -0.0013169015292078257, -0.001536669093184173, -0.018958814442157745,
    -0.07431260496377945, -0.029729438945651054, -0.012409569695591927, -0.007076864596456289, 0.04253365844488144, -0.0117951026186347, -5.858984150108881e-05, 0.009647081606090069,
    -0.026311691850423813, -0.021979352459311485, -0.02884458377957344, -0.030458200722932816, 0.024405036121606827, 0.0692562460899353, 0.037075549364089966, -0.010516176000237465,
    0.006457666400820017, 0.01523573137819767, 0.017704498022794724, -0.026142114773392677, 0.007857057265937328, 0.0003361152485013008, 0.016910765320062637, 0.012905418872833252,
    0.01977485604584217, -0.010816613212227821, -0.02379058673977852, -0.051914580166339874, 0.029235562309622765, 0.024737242609262466, -0.023854976519942284, -0.029550770297646523,
    0.07042786478996277, -0.0037289350293576717, 0.009309470653533936, 0.006631873548030853, 0.08101485669612885, 0.0013410013634711504, -0.0037633501924574375, -0.038606416434049606,
    -0.003138265572488308, -0.05269636958837509, 0.0011493116617202759, 0.021142520010471344, -0.014675607904791832, 0.03851858898997307, 0.033903662115335464, -0.04040827602148056,
    0.015057465061545372, -0.0662965402007103, 0.021666042506694794, -0.018165186047554016, 0.0030469626653939486, 0.092563197016716, 0.05145956203341484, 0.02195192314684391,
    -0.005162591114640236, 0.01900434121489525, -0.0069200992584228516, 0.00037262466503307223, -0.02892613783478737, -0.0033476329408586025, 0.004352995194494724, 0.07764963060617447,
    -0.019484519958496094, -0.01585724949836731, -0.005567069631069899, 0.026890868321061134, -0.06882055103778839, 0.015363350510597229, 0.005951015744358301, 0.012148061767220497,
    -0.009737273678183556, 0.00909525528550148, -0.01677018776535988, 0.014061099849641323, 0.014493235386908054, -0.024469301104545593, -0.009922527708113194, -0.004177345894277096,
    0.003401655936613679, -0.0039001652039587498, 0.02868635207414627, -0.011027977801859379, -0.029220372438430786, 0.016187941655516624, -0.022942213341593742, 0.03052688203752041,
    0.009076121263206005, -0.01094850804656744, 0.04353775829076767, -0.03918015956878662, 0.016235163435339928, -0.0020522153936326504, -0.00859497208148241, -0.05319887399673462,
    -0.0026328263338655233, 0.01139768399298191, 0.032916899770498276, 0.009869478642940521, -0.029878627508878708, 0.0667925700545311, -0.03717860206961632, 0.006837883964180946,
    -0.03322146460413933, -0.07351420074701309, -0.03662174195051193, 0.02990146167576313, 0.026315700262784958, -0.0577198751270771, 0.032095007598400116, -0.012272966094315052,
    -0.03777088224887848, -0.0017624759348109365, 0.0043976386077702045, 0.015495809726417065, -0.017376141622662544, -0.013138466514647007, -0.018885625526309013, 0.028272654861211777,
    -0.00031226713326759636, 0.038394950330257416, -0.021693171933293343, 0.001979952212423086, -0.004139795899391174, -0.0005443120026029646, -0.0036652067210525274, 0.017288152128458023,
    0.06371839344501495, -0.006677556317299604, 0.00538341561332345, 0.035574473440647125, 0.006160793825984001, -0.021844347938895226, 0.024148479104042053, -0.04865827411413193,
    -0.02984713390469551, -0.008826831355690956, -0.030238067731261253, 0.01698950305581093, 0.061956342309713364, -0.015978531911969185, 0.015358531847596169, 0.0018070314545184374,
    -0.03937593102455139, 0.01519604492932558, -0.04979851841926575, -0.02409663237631321, 0.019533079117536545, -0.018800778314471245, -0.021519243717193604, 0.0007813420961610973,
    -0.0016405569622293115, -0.01106592919677496, -0.011258657090365887, -0.0092527586966753, 0.01288398914039135, 0.056702543050050735, 0.016460303217172623, 0.06687719374895096,
    -0.03185439109802246, 0.012907047756016254, 0.04883205518126488, 0.03006793186068535, -0.054081991314888, 0.02048627845942974, 0.03976276144385338, 0.0032319973688572645,
    0.0038014515303075314, 0.02779351733624935, -0.04190699756145477, -0.032923150807619095, 0.11134158819913864, 0.012923258356750011, -0.033720917999744415, -0.025104064494371414,
    -0.07006572932004929, -0.021176466718316078, 0.004467181395739317, -0.007690416183322668, -0.021283021196722984, 0.01725734770298004, 0.022879503667354584, -0.003550008637830615,
    -0.0029337049927562475, 0.028609905391931534, -0.06476237624883652, 0.025831708684563637, -0.025698266923427582, -0.016213539987802505, 0.0511619932949543, 0.006016517523676157,
    0.0058723133988678455, 0.03212782368063927, 0.03675791621208191, 0.005771939642727375, 0.036428481340408325, -0.020312443375587463, 0.01824278011918068, -0.03679677098989487,
    -0.009929911233484745, 0.008415943942964077, 0.016527611762285233, -0.032019585371017456, -0.024005696177482605, 0.004583734553307295, -0.027583541348576546, -0.011086717247962952,
    -0.05815206468105316, 0.02500111050903797, -0.01289670541882515, 0.015803731977939606, -0.0579574815928936, -0.029211081564426422, -0.003480631625279784, 0.0007685266900807619,
    -0.0004152078181505203, 0.016536664217710495, -0.0049948967061936855, -0.011005084030330181, -0.04036222770810127, 0.00470244325697422, -0.014964963309466839, 0.0036732004955410957,
    0.0030350524466484785, -0.01917736977338791, 0.020392391830682755, -0.008374476805329323, -0.03350920230150223, 0.0336536206305027, -0.007301725447177887, -0.011276747100055218,
    0.022274687886238098, -0.057076603174209595, -0.004828790668398142, -0.000668180757202208, 0.042568884789943695, -0.02005830965936184, -0.005348591599613428, -0.01831560954451561,
    -0.008394153788685799, 0.0005597498966380954, -0.00400199880823493, -0.06454522907733917, -0.009987249970436096, 0.007378232665359974, 0.03167631849646568, -0.02475554868578911,
    0.009724963456392288, 0.013174166902899742, 0.02358243614435196, 0.0011634716065600514, 0.034332990646362305, -0.013046549633145332, -0.0005247457884252071, -0.0176374614238739,
    -0.006994999945163727, -0.024666735902428627, 0.009505147114396095, -0.012568463571369648, -0.02925671637058258, -0.0008638357976451516, 0.011330968700349331, 0.0029906705021858215,
    -0.022132612764835358, -0.010903370566666126, 0.004431050270795822, 0.007069604471325874, -0.02345985732972622, 0.006146958563476801, -0.02358909882605076, -0.0008236942230723798,
    -0.003602499607950449, -0.0076531399972736835, 0.0015994542045518756, -0.009411932900547981, 0.008738276548683643, -0.021667631343007088, 0.006257912144064903, 0.02321964129805565,
    0.014274366199970245, -0.001684750197455287, 0.04618969187140465, -0.02518901415169239, 0.024859122931957245, -0.02623629756271839, 0.008623677305877209, 0.015639953315258026,
    -0.016843533143401146, -0.0019427310908213258, 0.01787341758608818, 0.013051928021013737, -0.05034695193171501, -0.014822113327682018, 0.027742354199290276, -0.013508503325283527,
    -0.005898281000554562, 0.0018375900108367205, 0.006911019328981638, 0.012460275553166866, 0.04987257719039917, -1.1598001037782524e-05, 0.0037131954450160265, -0.03243739902973175,
    -0.020805753767490387, -0.0682600811123848, -0.02705439180135727, -0.040490102022886276, 0.019673587754368782, 0.05419593304395676, 0.000847386836539954, 0.042829953134059906,
    0.011075190268456936, -0.01559912133961916, -0.01695638708770275, 0.019351933151483536, -0.009777297265827656, -0.02062412165105343, -0.011005818843841553, 0.021633446216583252,
    0.011831660754978657, -0.035703375935554504, -0.01594693958759308, -0.011004135012626648, 0.022406697273254395, -0.003423113375902176, 0.007191288750618696, -0.005058486945927143,
    0.01256835088133812, -0.00047863463987596333, 0.02827145904302597, -0.017635269090533257, -0.030275188386440277, -0.03175584226846695, -0.021405572071671486, -0.005358126945793629,
    -0.023459838703274727, 0.028679562732577324, 0.009621606208384037, -0.011767574585974216, -0.0016318344278261065, 0.0013502236688509583, 0.017909197136759758, -0.004059107042849064,
    -0.004982930142432451, -0.007784332614392042, -0.001006377744488418, 0.008576911874115467, 0.020044516772031784, 0.0037270458415150642, -0.008203101344406605, -0.0008407492423430085,
    0.0220615454018116, -0.03290693834424019, -0.007032101973891258, 0.008546567521989346, 0.010581277310848236, 0.010912238620221615, 0.022206798195838928, 0.0027577069122344255,
    0.0022654703352600336, -0.00771597633138299, 0.01578054390847683, 0.004552680067718029, -0.023404208943247795, 0.008600435219705105, 0.0023383304942399263, 0.019726593047380447,
    0.014221548102796078, 0.011253324337303638, -0.028426434844732285, -0.032265886664390564, -0.020234445109963417, -0.009376787580549717, 0.010041280649602413, -0.024271704256534576,
    -0.0023919050581753254, 0.017259297892451286, -0.012306119315326214, -0.002054000971838832, 0.024324245750904083, 0.004496532958000898, -0.0017553124343976378, -0.01269424520432949,
    -0.01772402599453926, -0.0019817904103547335, 0.024859635159373283, -0.015706179663538933, -0.0056863646022975445, 0.033211931586265564, 0.008629231713712215, -0.017215758562088013,
    -0.00795918982475996, -0.016539715230464935, -0.024627741426229477, -0.017354564741253853, -0.05223619565367699, -0.013669976964592934, -0.01374450046569109, 0.009140648879110813,
    0.004599087405949831, -0.003461138578131795, 0.0011039087548851967, 0.020238446071743965, -0.0029254048131406307, -0.002894483506679535, 0.012045309878885746, -0.016403479501605034,
    0.008149934001266956, -0.006911910139024258, 0.009411029517650604, 0.010935977101325989, -0.008172255009412766, -0.004122267477214336, 0.0005227908841334283, -0.009560246020555496,
    -0.005764340981841087, -0.00853211060166359, -0.019348621368408203, 0.021059079095721245, -0.01816914789378643, -0.01202394999563694, -0.011184005066752434, 0.005185187794268131,
    -0.004657775163650513, -0.003911103121936321, 0.009726217947900295, 0.019076216965913773, -0.07223086804151535, -0.003111759200692177, 0.005246974527835846, 0.014518019743263721,
    -0.0050246454775333405, -0.01744849607348442, 0.02041259966790676, -0.02786487527191639, 0.00047439688933081925, 0.002512178849428892, 0.011074179783463478, -0.006730234250426292,
    -0.018270375207066536, -0.005640218500047922, 0.007557801436632872, 0.0019588046707212925, 0.018356235697865486, 0.011971092782914639, -0.02038065530359745, 0.005967587698251009,
    0.008686665445566177, -0.006894305348396301, -0.009586131200194359, 0.008917064405977726, 0.029699215665459633, -0.015501761808991432, -0.007421067450195551, -0.005084441043436527,
    -0.040882281959056854, 0.009097862057387829, -0.0012839918490499258, -0.010661241598427296, 0.0407014936208725, -0.014683755114674568, -0.009373760782182217, 0.005784834269434214,
    -0.014890543185174465, -0.012728768400847912, -0.005152042955160141, 0.0034303003922104836, 0.014506016857922077, 0.0188090018928051, -0.014204994775354862, -0.017776718363165855,
    0.006854655686765909, -0.005821553990244865, 0.009148193523287773, -0.029853953048586845, 0.024633118882775307, -0.007893572561442852, -0.013435102067887783, -0.007533334661275148,
    -0.012438755482435226, 0.02393503487110138, 0.01849276013672352, 0.01968398317694664, -0.02116008661687374, 0.013208799995481968, -0.027432316914200783, 0.015528475865721703,
    0.00031130178831517696, 0.008747279644012451, 0.00907520018517971, 0.01096987072378397, 0.001387718366459012, -0.014795876108109951, 0.004384282976388931, 0.01427674200385809,
    -0.010979173704981804, -0.0011414202162995934, 0.013025459833443165, -0.022227013483643532, -0.03084512986242771, -0.014258679002523422, -0.005641622934490442, 0.03424985334277153,
    -0.0005345894023776054, 0.0001524754479760304, -0.005184344947338104, 0.02071833610534668, 0.02290269173681736, 0.010043158195912838, 0.00371300196275115, -0.01905522495508194,
    0.004123599734157324, -0.009391342289745808, 0.0006056076381355524, 0.008898294530808926, 0.017528634518384933, -0.02404192090034485, 0.008203414268791676, 0.03061090037226677,
    -0.00769944628700614, -0.018119413405656815, 0.01480128150433302, 0.02176586724817753, 0.03332962468266487, 0.030970081686973572, -0.009473517537117004, 0.0029830955900251865,
    -0.019997436553239822, 0.00939196813851595, 0.016617372632026672, -0.03125713765621185, 0.0013959661591798067, -0.0041050235740840435, -0.018947763368487358, 0.006417770404368639,
    -0.0037630372680723667, 0.008123080246150494, -0.0065106977708637714, -0.016537096351385117, 0.021384084597229958, 0.0295365359634161, 0.02213152125477791, 0.003139284672215581,
    0.006997423246502876, 0.007391714490950108, 0.005046972073614597, 0.002150521147996187, -0.032103992998600006, 0.015904655680060387, 0.009794346988201141, 0.004837585147470236,
    0.007446368224918842, 0.0027233681175857782, -0.012475288473069668, 0.003356689354404807, 0.06737525761127472, -0.0029851305298507214, -0.006791120395064354, -0.023177538067102432,
    0.005924420431256294, 0.027116524055600166, -0.003922221716493368, -0.00647695129737258, -0.006723206955939531, -0.019190458580851555, -0.001434137113392353, -0.02520071156322956,
    0.005213957279920578, 0.0005617145216092467, -0.036438100039958954, -0.005088889971375465, 0.011639569886028767, -0.00043930861284025013, 0.05010133236646652, -0.017560970038175583,
    -0.01186964102089405, 0.01795056089758873, 0.02277732454240322, 0.019815675914287567, 0.021578149870038033, 0.025818604975938797, 0.008328982628881931, -0.026527663692831993,
    0.002718165749683976, 0.0020617139525711536, -0.01410464383661747, -0.021897079423069954, -0.024255607277154922, 0.023843059316277504, 0.012393584474921227, 0.00257676444016397,
    -0.010981215164065361, 0.0037157780025154352, 0.02896398864686489, -0.0026910733431577682, -0.0019213592167943716, -0.008462985046207905, -0.014099660329520702, 0.00613252492621541,
    -0.02504589594900608, -0.003222003811970353, 0.0027836791705340147, -0.018572766333818436, -0.010902500711381435, -0.009106717072427273, -0.02560371905565262, -0.022357776761054993,
    0.025789005681872368, -0.01859160140156746, 0.0038936829660087824, -0.002974996343255043, 0.025984199717640877, -0.011810180731117725, 4.369300586404279e-05, -0.008873545564711094,
    -0.026882324367761612, -0.03321148827672005, -0.025709807872772217, -0.03450179845094681, -0.0492740198969841, -0.028544900938868523, 0.012507764622569084, -0.0035395973827689886,
    0.006117547396570444, 0.00836178194731474, -0.009146160446107388, 0.03477189689874649, 0.01103711687028408, -0.023000188171863556, -0.018310921266674995, 0.015524027869105339,
    0.014623227529227734, 0.026408730074763298, 0.0031412451062351465, -0.0038999326061457396, 0.01175394281744957, -0.010519408620893955, -0.007309370674192905, 0.002002593595534563,
    0.008866549469530582, -0.0017709439853206277, 0.0075139193795621395, 0.01593867503106594, 0.01696629449725151, 0.0022457835730165243, -0.0036855186335742474, -0.0036464689765125513,
    -0.013142739422619343, 0.008312668651342392, -0.011195509694516659, -0.021690307185053825, 0.019800176844000816, -0.016481513157486916, 0.03062315657734871, -0.0026807913091033697,
    -0.02154131792485714, -0.002329375362023711, 4.380972677608952e-05, 0.0021214857697486877, -0.000911600305698812, -0.012182725593447685, -0.013590526767075062, 0.017563018947839737,
    0.01518351212143898, -0.008041899651288986, 0.014071086421608925, -0.01183436531573534, 0.012462973594665527, -0.013118777424097061, 0.018787575885653496, 0.022178281098604202,
    -0.007838701829314232, -0.0063468897715210915, 0.025524232536554337, 0.02587016485631466, -0.0230056494474411, -0.011901864781975746, 0.019825603812932968, 0.011814153753221035,
    -0.029636386781930923, 0.015760179609060287, -0.013613392598927021, 0.027150120586156845, 0.07627173513174057, 0.013563030399382114, -0.012156961485743523, -0.01939430832862854,
    -0.014894891530275345, -0.021408407017588615, 0.0020206852350383997, 0.0026437134947627783, -0.00524218799546361, 0.0103024085983634, -0.01581612043082714, 0.014902851544320583,
    0.019313815981149673, 0.0052175335586071014, 0.005544205196201801, 0.010065635666251183, 0.005751289892941713, -0.0043618869967758656, 0.05359469726681709, 0.018131420016288757,
    -0.01908056065440178, 0.00239768554456532, -0.018162691965699196, -0.007115841843187809, -0.013089846819639206, -0.0011433084728196263, -0.0025352442171424627, -0.004166066646575928,
    -0.006852911319583654, -0.012659876607358456, 0.013464532792568207, -0.011746476404368877, -0.021055489778518677, -0.03405805677175522, -0.0293281227350235, -0.017216352745890617,
    -0.01510081347078085, -0.0021867325995117426, -0.025940289720892906, 0.003206089837476611, -0.03917354717850685, -0.0017008192371577024, -0.005686759017407894, -0.0021831977646797895,
    0.0020645696204155684, 0.027587613090872765, -0.013204020448029041, 0.004229143261909485, -0.004318858962506056, 0.007547659799456596, 0.039019905030727386, 0.027377957478165627,
    -0.013978336937725544, 0.003363558556884527, -0.0034413968678563833, -0.010655864141881466, 0.01164495013654232, 0.009277377277612686, 0.02700948715209961, 0.013918851502239704,
    0.028169473633170128, 0.013462076894938946, -0.029698915779590607, -0.007141136098653078, 0.006801816169172525, 0.013749598525464535, 0.004289268050342798, -0.0011831017909571528,
    0.01905953139066696, 0.006062217056751251, -0.020779702812433243, 0.008077644743025303, 0.0027678636834025383, 0.012073049321770668, 0.0010632365010678768, 0.009064281359314919,
    3.899475359503413e-06, -0.007376549765467644, -0.03368046134710312, 0.007153139915317297, 0.021499432623386383, -0.012199812568724155, -0.0012477895943447948, 0.020257171243429184,
    0.004039654042571783, 0.013187462463974953, -0.0010935901664197445, 0.024053579196333885, 0.0022580192890018225, 0.018243908882141113, -0.03411084786057472, -0.002918045734986663,
    0.007316366769373417, -0.009926165454089642, -0.026863135397434235, -0.01167239062488079, 0.007273676805198193, -6.5616350184427574e-06, 0.005321035161614418, 0.0063780141063034534,
    0.014680083841085434, 0.008968362584710121, -3.0167748263920657e-05, 0.037335243076086044, 0.020167414098978043, 0.020370373502373695, 0.0044725933112204075, -0.02405625954270363,
    -0.022590981796383858, -0.006864713504910469, -0.01195146981626749, 0.003224356798455119, -0.009706770069897175, -0.005235244520008564, 0.0017804621020331979, -0.009599699638783932,
    -0.028822872787714005, -0.01597442291676998, -0.012383784167468548, 0.02392011694610119, -0.014070522971451283, -0.0016593524487689137, -0.011536931619048119, -0.02218525856733322,
    -0.0008263986674137414, -0.014410397037863731, -0.006415459327399731, 0.018460573628544807, 0.040181707590818405, -0.022997191175818443, -0.02025376819074154, -0.001274626236408949,
    -0.003651093691587448, -0.0045074960216879845, 0.014017393812537193, -0.002689461689442396, -0.01796010136604309, 0.006889271549880505, -0.0129972193390131, 0.01630372181534767,
    -0.014354248531162739, -0.015039629302918911, -0.012221002019941807, 0.007836539298295975, -0.030141355469822884, 0.007318930234760046, -0.004683456849306822, -0.0022151032462716103,
    0.001313295098952949, -0.0010284462478011847, 0.0004174396744929254, 0.02088523469865322, 5.4973159421933815e-05, 0.0036433483473956585, 0.005143996328115463, -0.008093616925179958,
    0.028361525386571884, 0.008164052851498127, 0.013394099660217762, 0.0018167732050642371, -0.0042953710071742535, -0.003688512369990349, 0.02579314447939396, -0.0193408764898777,
    0.007647301070392132, 0.008181600831449032, 0.008290247991681099, -0.0027285064570605755, 0.03186226263642311, -0.008642297238111496, 0.014750281348824501, 0.018143119290471077,
    0.010592357255518436, -0.03168756514787674, 0.010370473377406597, -0.03954702988266945, 0.01567668654024601, -0.0002497814712114632, -0.02578725665807724, -0.0038309781812131405,
    0.011658049188554287, -0.01334619615226984, 0.03816727548837662, 0.00805171113461256, 0.0022129882127046585, -0.012020253576338291, -0.01602143608033657, -0.015314947813749313,
    -0.02700001932680607, 0.007614245638251305, 0.014009152539074421, 0.00898708775639534, -0.0032135716173797846, -0.010218426585197449, -0.02010289579629898, 0.030679959803819656,
    -0.009648722596466541, -0.016272258013486862, 0.012401481159031391, -0.02983531728386879, 0.0031897013541311026, 0.025529799982905388, 0.004715783521533012, 0.012437834404408932,
    -0.0008602465386502445, -0.00205795094370842, 0.004412032198160887, -0.004504768643528223, -0.010102075524628162, 0.007032733876258135, -0.025308828800916672, 0.0167388953268528,
    0.022306382656097412, 0.012947131879627705, -0.01902952417731285, -0.013552296906709671, 0.01225389912724495, 0.010822761803865433, 0.03308148682117462, 0.0013575468910858035,
    0.017004193738102913, -0.014862749725580215, 0.019365202635526657, 0.007364567834883928, -0.0336025096476078, 0.010701382532715797, 0.0024037465918809175, 0.006101500242948532,
    -0.0040323492139577866, -0.0019350057700648904, 0.00450800359249115, -0.011432279832661152, -0.002205660566687584, 0.012691895477473736, -0.00687638483941555, -0.008683055639266968,
    0.007599509786814451, -0.0010526312980800867, 0.03872939571738243, -0.03115069679915905, -0.018741102889180183, 0.00703907897695899, -0.023209452629089355, -0.006791414227336645,
    0.026433255523443222, 0.008025003597140312, -0.020982587710022926, -0.022161321714520454, 0.012751325033605099, -0.0019068988040089607, -0.021725963801145554, -0.0023406827822327614,
    0.005515044555068016, 0.00785808451473713, 0.01020192913711071, 0.004508213140070438, -0.010398832149803638, 0.009324004873633385, -0.0006705582491122186, -0.009143148548901081,
    0.011483514681458473, 0.0036662225611507893, 0.004623118322342634, 0.00787490513175726, 0.007098915986716747, -0.02062884345650673, -0.011852415278553963, 0.008923923596739769,
    0.00480062747374177, -0.0005293386057019234, -0.01605023443698883, -0.019552497193217278, 0.006761941127479076, 0.01581384427845478, -0.0009232222218997777, -0.01193368062376976,
    -0.00440975371748209, 0.019559580832719803, 0.012079669162631035, -0.013425334356725216, 0.02049705944955349, -0.004369313362985849, -0.002694438211619854, -0.0031082092318683863,
    -0.0031279711984097958, 0.018649522215127945, -0.0022550509311258793, -0.004436839371919632, -0.0009653659071773291, 0.021936073899269104, -0.016592182219028473, -0.020123178139328957,
    0.0077118296176195145, -0.00387947796843946, -0.017167091369628906, 0.004075710661709309, -0.009562105871737003, 0.0078909145668149, -0.004146128427237272, 0.003977837506681681,
    0.005022434052079916, 0.018500152975320816, -0.011911416426301003, 0.006139799486845732, 0.017742715775966644, 0.0038076061755418777, 0.013183485716581345, -0.008287218399345875,
    -0.016503510996699333, 0.003401773050427437, -0.007525667082518339, 0.009224826470017433, 0.0025066081434488297, -0.024311210960149765, 0.002291931537911296, -0.01950276829302311,
    -0.0006359188701026142, 0.005643302109092474, 0.02486756257712841, -0.010970553383231163, 0.0153764383867383, -0.0010959848295897245, 0.0050946492701768875, -0.020694905892014503,
    -0.0008689555688761175, -0.009091449901461601, -0.017938828095793724, 0.0053140646778047085, -0.028787951916456223, 0.012186524458229542, 0.006730100605636835, -0.009133202955126762,
    0.0047439346089959145, -0.0011829648865386844, 0.0013890918344259262, 0.010726269334554672, -0.013105925172567368, -0.0005206828936934471, 0.009105338715016842, -0.029654238373041153,
    -0.020258866250514984, -0.03343476355075836, -0.008140401914715767, 0.029202595353126526, -0.027100255712866783, -0.022555416449904442, -0.015989042818546295, -0.007652471773326397,
    -0.02737232856452465, 0.0006573416176252067, -0.005682764109224081, -0.011793866753578186, -0.021538805216550827, 0.0013813124969601631, -0.0018295746995136142, -0.0036419241223484278,
    0.011763274669647217, 0.0019021477783098817, -0.0032340604811906815, 0.03626927360892296, -0.012376580387353897, -0.0012958061415702105, 0.024405889213085175, 0.01265496015548706,
    -0.010815402492880821, -0.009733345359563828, 0.014097999781370163, 0.011952114291489124, 0.01887350156903267, -0.001475552562624216, -0.02127133309841156, -0.009286082349717617,
    -0.004485974088311195, -0.006887613795697689, -0.007991393096745014, 0.020779503509402275, 0.015727290883660316, -0.0001707071060081944, 0.02015811763703823, 0.012714704498648643,
    -0.015125581063330173, 0.005353947635740042, -0.0038312843535095453, 0.005781835410743952, -0.047593045979738235, -0.006674622185528278, -0.001488391077145934, 0.0036378377117216587,
    -0.008200535550713539, -0.01407951582223177, 0.003712377278134227, -0.012390078976750374, -0.0024423699360340834, 0.0022934742737561464, 0.010714319534599781, -0.02948325127363205,
    0.0003385042364243418, 0.006201473996043205, 0.029899602755904198, -0.011563077569007874, -0.030784497037529945, -0.02127073146402836, -0.0076142409816384315, 0.016938593238592148,
    0.005517040379345417, -0.03809337317943573, -0.014269274659454823, -0.010189972817897797, 0.0240457933396101, 0.011234874837100506, 0.009353443048894405, -0.008184392005205154,
    -0.011335805989801884, -0.013402228243649006, 0.015817034989595413, 0.012592891231179237, 0.001356861786916852, -0.023581475019454956, 0.010121310129761696, -0.005077922251075506,
    -0.003995384555310011, 0.0028943344950675964, 0.0079296063631773, -0.0025204119738191366, 0.008780022151768208, 0.00321562634781003, 0.022859901189804077, -0.02222834900021553,
    -0.0023711840622127056, -0.006534786894917488, 0.04124459996819496, -0.001994768623262644, 0.005768430419266224, -0.006131436210125685, -0.026041481643915176, -0.0179386418312788,
    -0.007863792590796947, 0.012889066711068153, 0.01162813138216734, 0.025693129748106003, 0.009068013168871403, 0.02082938514649868, -0.015116224065423012, 0.009490184485912323,
    0.011030280031263828, -0.0316503643989563, 0.014832977205514908, -0.03541054204106331, -0.012643101625144482, -0.0109350411221385, -0.006436976604163647, -0.002857882995158434,
    0.009391704574227333, 0.028468480333685875, 0.021218901500105858, -0.011718721129000187, -0.016649577766656876, -0.033147528767585754, -0.012751361355185509, 0.016631752252578735,
    -0.02162740007042885, 0.0010839971946552396, -0.012043729424476624, -0.009240038692951202, -0.012475325725972652, -0.014820762909948826, -0.0016257824609056115, 0.0327274389564991,
    0.038785792887210846, -0.0010322402231395245, -0.0034389481879770756, 0.028987469151616096, -0.0010120775550603867, -0.015265296213328838, 0.009857479482889175, 0.004910617135465145,
    0.002014163648709655, -0.013813324272632599, -0.0014827280538156629, 0.012654997408390045, 0.02665671706199646, 0.01099914126098156, 0.017567811533808708, -0.012850846163928509,
    -0.01898539811372757, 0.0005793769378215075, 0.0011576511897146702, -0.03345911204814911, -0.006091098766773939, -0.01715373992919922, 0.005907675251364708, -0.01762649044394493,
    -0.0003947064687963575, 0.0011727290693670511, -0.015254671685397625, 0.02029299922287464, -0.005584960803389549, -0.0075451466254889965, 0.023913217708468437, 0.01280531007796526,
    -0.02445642650127411, 0.0011541753774508834, 0.01152887661010027, -0.013713769614696503, 0.0009067344944924116, 0.004603884648531675, -0.010460256598889828, -0.020155074074864388,
    0.008265354670584202, 0.01374777127057314, -0.02232806198298931, 0.0033339967485517263, 0.09272401034832001, 0.001042819581925869, -0.0005374423344619572, -0.00350697198882699,
    -0.039982907474040985, 0.0017083920538425446, 0.0026128648314625025, 0.0044275675900280476, -0.004833901766687632, -0.0005379157955758274, 0.026084881275892258, 0.0059103406965732574,
    0.004572856239974499, 0.006921534426510334, 0.0018940306035801768, 0.03986205533146858, 0.011095542460680008, -0.01735205389559269, 0.04222853481769562, 0.005248320754617453,
    -0.005686566699296236, 0.028830232098698616, 0.003762120846658945, -0.0026948561426252127, 0.005533848889172077, -0.014294887892901897, 0.0003295435744803399, 0.008738797158002853,
    -0.008487926796078682, -0.011203447356820107, -0.030435796827077866, -0.021637270227074623, 0.028147349134087563, 0.007189828436821699, -0.0024189897812902927, -0.016255725175142288,
    0.015046036802232265, -0.02932453341782093, -0.001115218736231327, -0.005571591667830944, -0.01741921529173851, -0.015209255740046501, 0.008423276245594025, -0.0018650477286428213,
    -0.000902676023542881, 0.0072454665787518024, -0.008574629202485085, -0.02197609469294548, -0.00820430088788271, 0.005340509582310915, 0.014821002259850502, -0.012519142590463161,
    0.001540077617391944, 0.011061474680900574, -0.009470825083553791, -0.008123490959405899, -0.019167186692357063, 0.018232299014925957, 0.005785221233963966, 0.009264451451599598,
    -0.0022802315652370453, -0.02235022373497486, -0.0076250843703746796, -0.0020523390267044306, 0.012432453222572803, -0.015180342830717564, -0.013707970269024372, -0.00843701884150505,
    0.0065285274758934975, -0.02177019603550434, -0.018016191199421883, -0.010126667097210884, 0.010663710534572601, 0.016065498813986778, -0.013800873421132565, -0.0045205517672002316,
    0.03556210175156593, -0.013585583306849003, -0.012658371590077877, -0.00435629254207015, 0.014778252691030502, 0.018951190635561943, 0.009835172444581985, -0.003963555209338665,
    -0.020748859271407127, 0.004275467246770859, -0.0036606790963560343, -0.003069486003369093, 0.026793289929628372, 0.00666988268494606, -0.010759783908724785, 0.011751117184758186,
    -0.018262425437569618, 0.009277663193643093, -0.003462177701294422, 0.026027845218777657, 0.0042578959837555885, 0.002651805756613612, 0.00033238931791856885, 0.014949151314795017,
    -0.006487842183560133, 0.0006788618629798293, 0.01729542762041092, 0.02510707639157772, 0.029529869556427002, -0.0008067196467891335, -0.007833798415958881, 0.012060167267918587,
    -0.019604407250881195, 0.00837374571710825, -0.007408834993839264, -0.004525899887084961, -0.0056237648241221905, 0.00294766528531909, -0.025867337360978127, 0.014388551004230976,
    -0.025446992367506027, -0.0010228394530713558, 0.011503510177135468, 0.010714493691921234, -0.00586333591490984, -0.0007233403739519417, 0.005073751322925091, 0.0016697044484317303,
    0.010345019400119781, -0.02014952152967453, -0.017324181273579597, 0.023947568610310555, 0.03947015479207039, -0.0073993937112390995, -0.026135070249438286, -0.017302317544817924,
    0.0185867752879858, 0.005484211724251509, -0.003633188083767891, -0.00106713711284101, -0.02867290750145912, -0.02315369062125683, -0.012091564945876598, 0.02885781228542328,
    -0.0009063881007023156, -0.003348416881635785, -0.04633204638957977, -0.012957985512912273, -0.02053077518939972, -0.022298872470855713, 0.014842959120869637, -0.02369614876806736,
    -0.008814708329737186, 0.0013309256173670292, 0.0046699256636202335, 0.004209942650049925, 0.006430366076529026, 0.029512014240026474, -0.010822459124028683, -0.018484430387616158,
    0.0413549467921257, 0.00747543852776289, 0.02638922445476055, -0.006854692008346319, -0.023148804903030396, 0.01114933006465435, 0.017573542892932892, -0.009324249811470509,
    -0.020790793001651764, -2.8389009457896464e-05, 0.015297564677894115, 0.000666422420181334, 0.017870677635073662, 0.00835158210247755, -0.00874180905520916, 0.006641610059887171,
    -0.008411585353314877, -0.007578176911920309, -0.007418250199407339, 0.004568376112729311, 0.02212570421397686, -0.002895682817324996, 0.010798853822052479, 0.011041020043194294,
    0.008507037535309792, -0.033768124878406525, 0.011674689128994942, -0.004787437617778778, -0.018628334626555443, 0.001985239563509822, -0.007766117341816425, -0.02206621877849102,
    -0.029655136168003082, 0.006787374150007963, -0.007026794366538525, -0.014857672154903412, 0.01464836299419403, -0.002280638786032796, 0.00787312537431717, 0.030767258256673813,
    -0.03313909471035004, 0.008555902168154716, 0.004379983991384506, 0.006102486047893763, 0.025398269295692444, -0.013980836607515812, -0.009438379667699337, -0.027930544689297676,
    -0.0018012431683018804, 0.010323707014322281, -0.0008250355022028089, 0.032926592975854874, 0.003574106842279434, -0.015546220354735851, -0.006006309762597084, 0.0014120556879788637,
    0.013982251286506653, -0.013059446588158607, -0.0006660393555648625, 0.0033905101008713245, -0.027676144614815712, -0.012575889937579632, 0.02321300096809864, -0.031393863260746,
    0.01670713722705841, -0.018670616671442986, 0.028384868055582047, -0.007020283490419388, -0.027225371450185776, -0.00983073003590107, -0.02664506621658802, -0.010889168828725815,
    -0.03116508387029171, -0.00012395373778417706, -0.01237117312848568, -0.001384518458507955, -0.017103200778365135, 0.012711185030639172, 0.007567261811345816, 0.010756881907582283,
    0.020236697047948837, -0.009211425669491291, 0.005724108312278986, 0.025635968893766403, 0.011934499256312847, 0.027697419747710228, -0.014869770035147667, 0.004737094044685364,
    0.011853797361254692, 0.004041390493512154, -0.00019919057376682758, 0.02064076066017151, 0.0047507863491773605, -0.0008726706728339195, 0.02461310103535652, 0.026066118851304054,
    -0.010905054397881031, 0.004998529329895973, 0.004947388544678688, -0.03311694413423538, -0.06095755845308304, 0.007564106024801731, 0.036173999309539795, 0.021426323801279068,
    -0.017722852528095245, 0.01617780514061451, 0.006588389631360769, 0.014427082613110542, 0.011018848046660423, -0.018124138936400414, 0.0002204086194979027, -0.008533082902431488,
    0.019686436280608177, 0.018691953271627426, 0.021649489179253578, -0.009479816071689129, 0.024482743814587593, -0.018993200734257698, -0.03650136664509773, 0.034180331975221634,
    -0.001179694663733244, -0.007257728837430477, -0.017870115116238594, -0.010199773125350475, -0.013733933679759502, -0.01895967684686184, -0.015515082515776157, 0.015716036781668663,
    -0.009780718013644218, 0.004644203931093216, -0.009076664224267006, 0.010549147613346577, 0.009925534948706627, 0.00010172976908506826, 0.0022035359870642424, 0.009037209674715996,
    -0.009374579414725304, 0.010206162929534912, 0.004184638615697622, 0.007585234008729458, 0.0037711879704147577, 0.03129196539521217, 0.010195164009928703, -0.01522985938936472,
    -0.010934574529528618, 0.01047030184417963, 0.015404760837554932, 0.002741038566455245, -0.029185893014073372, 0.00803445652127266, -0.024148009717464447, 0.014791302382946014,
    -0.026881180703639984, 0.011655919253826141, -0.005834344308823347, 0.0012815074296668172, 0.02273612469434738, 0.011926922015845776, -0.006575887091457844, 0.013745518401265144,
    0.013856754638254642, 0.006042518187314272, 0.01572786457836628, -0.01530255377292633, -0.0036143132019788027, 0.005094811785966158, -0.008661436848342419, -0.022412797436118126,
    0.022300997748970985, -0.018821943551301956, 0.006053427699953318, 0.0002457546943333, -0.0379919558763504, -0.023705782368779182, 0.02947031706571579, 0.01582690328359604,
    0.0004526222764980048, -0.003317201277241111, 0.01828176900744438, -0.037910379469394684, -0.011329872533679008, -0.001969792414456606, -0.004008731804788113, -0.008082929998636246,
    0.005045368801802397, 0.0044104354456067085, 0.007626664824783802, 0.0062781390734016895, 0.013470453210175037, 0.004470298066735268, -0.0068576764315366745, 0.03392213210463524,
    -0.003869197331368923, 0.0008270084508694708, -0.016166510060429573, 0.0017148463521152735, -0.001691297977231443, -0.00872905645519495, -0.008614594116806984, 0.010166552849113941,
    0.03472330793738365, -0.0011041525285691023, -0.023587670177221298, -0.011154593899846077, 0.023416493088006973, -0.011597671546041965, -0.00032065677805803716, 0.004287795163691044,
    -0.013117670081555843, 0.00465625012293458, 0.023087430745363235, -0.04282507300376892, 0.0016778054414317012, -0.002157840644940734, 0.02071540616452694, 0.00048802918172441423,
    -0.024423353374004364, -0.02767723798751831, -0.01395945344120264, -0.03942934051156044, -0.00878209713846445, -0.00519983284175396, -0.010378667153418064, -0.005628638900816441,
    -0.0028055834118276834, 0.013709857128560543, -0.013586696237325668, -0.005958923604339361, 0.013574452139437199, -0.002224481198936701, -0.03221448138356209, -0.013232674449682236,
    -0.007027750834822655, -0.02099117450416088, -0.005196859128773212, -0.010401987470686436, -0.0007196480291895568, -0.01144354697316885, -0.007098850794136524, 0.0013157024513930082,
    -0.012450095266103745, -0.030451500788331032, 0.013912818394601345, -0.0018046662444248796, -0.04210194572806358, 0.014442740008234978, 0.02948460355401039, 0.001382388873025775,
    0.003013450652360916, -0.01908925548195839, 0.010170917958021164, 0.0341806560754776, 0.028503622859716415, 0.0015683075180277228, -0.00689597986638546, -0.009660094045102596,
    -0.008855588734149933, 0.0057743629440665245, 0.010668487288057804, -0.008324196562170982, -0.004980080295354128, -0.009334046393632889, -0.015494302846491337, -0.0023535103537142277,
    0.005348346661776304, 0.0010490744607523084, 0.009450758807361126, -0.006060673389583826, -0.003694330109283328, -0.027989348396658897, -0.013028251938521862, 0.012623664923012257,
    -0.006536663509905338, -0.02087920904159546, 0.00787136610597372, -0.02497541345655918, 0.0024368073791265488, 0.00279650348238647, 0.016225965693593025, -0.032476041465997696,
    0.027260012924671173, -0.0034504279028624296, 0.010613765567541122, 0.0109546585008502, -0.02212843857705593, -0.004784727469086647, -0.013383157551288605, 0.020351149141788483,
    -0.025929098948836327, -0.010024447925388813, -0.022255422547459602, 0.012858368456363678, -0.009749209508299828, -0.0011297535384073853, 0.01658964715898037, 0.012890747748315334,
    -0.0018308396684005857, 0.02462591975927353, 0.0054706996306777, 0.002772662788629532, 0.01356067880988121, 0.003054417436942458, -0.03456776216626167, -0.012673579156398773,
    0.01271452009677887, 0.011205275543034077, 0.002085767686367035, 0.01895463466644287, 0.008455686271190643, 0.01044456660747528, 0.0016195476055145264, -0.0053227562457323074,
    0.0179146658629179, -0.005931728985160589, 0.01569540612399578, -0.0070485565811395645, 0.0007267507025972009, 0.014637612737715244, -0.0020803851075470448, -0.04048365354537964,
    -0.0026753435377031565, 0.008614174090325832, 0.013885155320167542, 0.010202373377978802, -0.0329565592110157, -0.012382586486637592, -0.003147432580590248, 0.011676888912916183,
    -0.02994060143828392, -0.0008079464314505458, 0.020623838528990746, 0.00347915175370872, -0.04077548533678055, -0.0055898018181324005, -0.01931864582002163, 0.0025338141713291407,
    0.010991940274834633, -0.020457010716199875, -0.013904348947107792, -0.008494551293551922, -0.0010595570784062147, 0.010791370645165443, -0.004385307431221008, 0.0026429861318320036,
    -0.0029269696678966284, 0.027248570695519447, 0.023135246708989143, 0.026706095784902573, 0.00644343439489603, 0.006176771596074104, -0.017785686999559402, 0.0056836348958313465,
    0.022127268835902214, 0.03360644355416298, 0.005051541142165661, -0.033369749784469604, 0.04214755818247795, 0.002573559060692787, 0.010678470134735107, 0.007237151265144348,
    -0.00038421235512942076, 0.0020604615565389395, -0.0006237030611373484, 0.018076632171869278, -0.013307527638971806, -0.03747737407684326, 0.014094019308686256, -0.001019375748001039,
    0.01682230830192566, 0.030740495771169662, -0.0036862355191260576, -0.003675440326333046, 0.020602097734808922, -0.01441102847456932, 0.01421196199953556, 0.001269953791052103,
    0.009827550500631332, -0.002271495060995221, 0.006383565254509449, -0.00139956537168473, 0.02414100058376789, 0.008860675618052483, -0.0003376187523826957, 0.00681057246401906,
    -0.019240424036979675, -0.017780939117074013, -0.000994824804365635, -0.02177920937538147, -0.016613975167274475, 0.00882870052009821, -0.0016523218946531415, -0.009613428264856339,
    -0.003812481416389346, 0.02378932759165764, -0.009654004126787186, 0.006631658412516117, -0.018727395683526993, 0.002017900114879012, -0.010880432091653347, -0.014940562658011913,
    0.006131688132882118, 0.03547164052724838, 0.008035865612328053, -0.006915662437677383, -0.026554957032203674, 0.002215559361502528, -0.0014556866372004151, -0.00964408554136753,
    0.012952004559338093, -0.01886190101504326, -0.025881793349981308, -0.008414105512201786, 0.011295409873127937, -0.007308774162083864, 0.021282603964209557, 0.01060685608536005,
    0.03697899729013443, 0.02727421373128891, 0.024249933660030365, 0.02771005965769291, 0.0056471615098416805, -0.004035636782646179, 0.003994891420006752, -0.013755768537521362,
    -0.008809229359030724, -0.02322578988969326, -0.004452237859368324, -0.005658923182636499, -0.0025965801905840635, 0.012237554416060448, 0.020514706149697304, 0.025041915476322174,
    0.008518679067492485, -0.023196827620267868, -0.026808569207787514, -0.008741166442632675, 0.006289038807153702, -0.008727972395718098, 0.007672332227230072, 0.038443028926849365,
    -0.013391547836363316, 0.009117725305259228, -0.006874837912619114, 0.007509210612624884, -9.330855391453952e-05, 0.010385357774794102, -0.028647376224398613, 0.0029624796006828547,
    -0.004558684770017862, -0.0013239429099485278, -0.025402432307600975, 0.01317258644849062, 0.02077607437968254, -0.01335662230849266, -0.0006331215263344347, -0.0014251235406845808,
    -0.01210777461528778, -0.009540867060422897, -0.008810221217572689, -0.005179296247661114, 0.017246436327695847, -0.006394702475517988, 0.0016861314652487636, 0.011914552189409733,
    -0.008580724708735943, 0.01532517559826374, -0.01833820715546608, -0.008676226250827312, 0.024514734745025635, 0.01339988224208355, 0.018032342195510864, 0.016906287521123886,
    0.00707394490018487, -0.01759438030421734, -0.004567213822156191, 0.017090875655412674, 0.002384657971560955, -0.014986892230808735, 0.005041860975325108, -0.01399610098451376,
    -0.029880549758672714, 0.010148431174457073, -0.004249680321663618, -0.002698644297197461, 0.016729513183236122, -0.003928266931325197, -0.0029118347447365522, 0.0028438386507332325,
    -0.005388516467064619, -0.02688419818878174, 0.021760405972599983, 0.018242664635181427, 0.004751427099108696, 0.016037192195653915, -0.008743862621486187, 0.02487967535853386,
    0.00011840646766358986, -0.005086036864668131, -0.017503738403320312, 0.0029362114146351814, 0.013807217590510845, 0.0026356708258390427, 0.008654977194964886, -0.008605767972767353,
    0.004978869576007128, -0.014474496245384216, -0.00023218146816361696, 0.03414415568113327, -0.02091318741440773, 0.00454101013019681, 0.014383319765329361, -0.013700658455491066,
    0.014985265210270882, 0.009847110137343407, -0.01345869805663824, -0.0058661517687141895, 0.00433192728087306, -0.020693443715572357, -0.0043987068347632885, 0.003971499390900135,
    0.0143358139321208, 0.0015402203425765038, -0.006256582215428352, -0.00268778158351779, 0.010420002043247223, -0.002265695482492447, 0.0015156439039856195, 0.019875476136803627,
    0.008393465541303158, -0.02026285044848919, 0.012072513811290264, 0.04099588468670845, 0.006948625203222036, -0.002949031535536051, 0.011516798287630081, 0.02496311068534851,
    -0.001913752406835556, 0.003422484965994954, 0.007574504241347313, 0.005143431015312672, 0.02473653107881546, -0.02283049188554287, -0.009709744714200497, -0.00880699884146452,
    -0.03909960016608238, 0.04126115143299103, -0.007363439071923494, -0.03989311680197716, 0.010790033265948296, 0.016733095049858093, 0.012180311605334282, 0.00801155436784029,
    -0.01416249293833971, 0.001854770234785974, -0.0011092264903709292, -0.010283599607646465, -0.007909015752375126, -0.021179888397455215, -0.004358591977506876, -0.0061677866615355015,
    -0.02307976223528385, 0.0031336976680904627, 0.0031758903060108423, 0.006932087708264589, -0.016750959679484367, 0.00348121440038085, 0.003021586686372757, -0.009973959997296333,
    -0.012059403583407402, 0.0011734586441889405, 0.026356762275099754, -0.007806797046214342, 0.0032914713956415653, 0.023006601259112358, 0.030342528596520424, -0.0030914207454770803,
    -0.011236990801990032, 0.01134851761162281, -0.011364630423486233, -0.034830398857593536, -0.001491820439696312, 0.001490765600465238, -0.024152664467692375, 0.02384028211236,
    0.007553865201771259, -0.0007981303497217596, -0.012208724394440651, 0.02213870733976364, 0.00924206618219614, 0.01766378805041313, -0.006354156415909529, 0.009761583060026169,
    0.010483467020094395, -0.016679421067237854, -0.004006415139883757, -0.0009117464651353657, -0.0025589135475456715, -0.0036353161558508873, -0.01133514940738678, -0.02230236493051052,
    0.008209699764847755, 0.012574095278978348, 0.0038156004156917334, 0.0021218820475041866, 0.022277841344475746, -0.009369305334985256, 0.005009952001273632, 0.025970546528697014,
    0.0017434129258617759, 0.0007972559542395175, -0.0031965041998773813, -0.0019905806984752417, -0.01979505643248558, 0.006427106913179159, -0.011401763185858727, 0.01615840382874012,
    0.013593172654509544, 0.016742320731282234, -0.006893377285450697, 0.006316655315458775, 0.00453773932531476, -0.026751842349767685, 0.005854201037436724, -0.026961201801896095,
    0.00301463739015162, -0.01753399707376957, -0.02540719136595726, -0.013227631337940693, 0.004586194641888142, 0.01850878819823265, -0.030507801100611687, -0.015232274308800697,
    -0.00826573371887207, 0.01240201573818922, -0.016532588750123978, -0.013004375621676445, -0.0026760664768517017, -0.009519844315946102, -0.02373305894434452, 0.00949117261916399,
    -0.002129003405570984, 0.00846527237445116, -0.00016496307216584682, 0.02132289484143257, -0.004804643802344799, 0.004106808453798294, 0.011635608039796352, -0.013501834124326706,
    0.009714556857943535, -0.013283866457641125, 0.013311059214174747, 0.0004132065223529935, 0.009913967922329903, 0.005533444695174694, 0.005301536060869694, -0.02527048997581005,
    -0.011011729016900063, -0.00522132171317935, 0.014914385974407196, -0.009285840205848217, 0.0054249996319413185, 0.0056591639295220375, -0.010003273375332355, -0.008774258196353912,
    0.015794316306710243, -0.001566815422847867, -0.013604703359305859, -0.004315654281526804, -0.01024217065423727, -0.004290168639272451, 0.011466250754892826, -0.014369131065905094,
    0.025936737656593323, 0.0078206742182374, -0.012974748387932777, 0.012657958082854748, -0.002397082280367613, 0.014893834479153156, -0.00357304560020566, -0.006950461771339178,
    -0.010661285370588303, -0.015077855437994003, -0.016370272263884544, -0.00770355062559247, -0.0013696147361770272, 0.011786545626819134, 0.005359699483960867, -0.00630419235676527,
    0.004068750888109207, 0.01123074721544981, 0.01091827917844057, -0.0029451230075210333, -0.01767059415578842, 0.01676703430712223, -0.004573290701955557, -0.0008148966589942575,
    0.005711033008992672, 0.0038293383549898863, 0.021093824878335, -0.02612615004181862, 0.007026101928204298, 0.01476740837097168, -0.011576198972761631, 0.009947383776307106,
    0.006152353249490261, 0.0010844392236322165, -0.01643010973930359, 0.003636494278907776, -0.008835874497890472, 0.005534383933991194, -0.011439763940870762, -0.009666571393609047,
    -0.017496393993496895, 0.0020131515339016914, 0.011803954839706421, -0.025836369022727013, 0.020236555486917496, -0.008894032798707485, 0.004109471570700407, -0.0020213895477354527,
    -0.007973379455506802, 0.01394390594214201, -0.015058591961860657, -0.022528020665049553, -0.018716461956501007, -0.011331595480442047, 0.004850363824516535, 0.012128584086894989,
    -0.002786250552162528, 0.006080508232116699, -0.020635277032852173, -0.0027815308421850204, -0.02299371175467968, 0.009176556952297688, -0.012375518679618835, 0.014884499832987785,
    0.014102986082434654, 0.0008993244846351445, -0.0008584936731494963, 0.031916894018650055, -0.0018237568438053131, -0.006956880912184715, 0.01253226213157177, 0.01256260834634304,
    0.005355003755539656, -0.0122621925547719, 0.007743707858026028, 0.01606404408812523, -0.0027894049417227507, -0.011824238114058971, 0.013730380684137344, -0.006812702864408493,
    -0.002591518685221672, 0.019435323774814606, 0.03459954634308815, 0.013403339311480522, 0.0053711202926933765, -0.018791284412145615, 0.011902829632163048, -0.0016739643178880215,
    0.010550860315561295, 0.008152754046022892, 0.030173903331160545, 0.040448348969221115, 0.0047415210865437984, 0.01030312106013298, -0.020077751949429512, 0.004883572459220886,
    -0.01823381707072258, -0.011817585676908493, -0.008412112481892109, -0.01706625521183014, 0.005327586084604263, 0.0049791038036346436, 0.0035329186357557774, -0.0067228092812001705,
    0.01387647446244955, 0.00619042944163084, -0.0032385035883635283, 0.005724392831325531, -0.0086433170363307, -0.008529349230229855, -0.012063499540090561, 0.007428364362567663,
    0.002147787483409047, 0.0010590986348688602, 0.023437796160578728, -0.019291261211037636, -0.0017062196275219321, -0.0022531310096383095, -0.012136717326939106, 0.000566032889764756,
    0.02167385071516037, 0.01580296829342842, 0.010239033959805965, 0.001699310028925538, -0.009729255922138691, 0.001414673519320786, -0.005331031512469053, 0.003342036623507738,
    -0.0067680589854717255, 0.0033749581780284643, 0.0020425075199455023, 0.01824082061648369, 0.008676811121404171, -0.012570921331644058, 0.01837112382054329, -0.0027986459899693727,
    -0.020779592916369438, -0.004003063775599003, 0.008236302062869072, 0.002840355271473527, -0.005028760060667992, 0.009410669095814228, -0.0045847599394619465, -0.0003578817122615874,
    -0.010524927638471127, 0.006013016682118177, -0.009288699366152287, 0.0023007045965641737, -0.018043629825115204, -0.011079434305429459, -0.010744533501565456, 0.0049979048781096935,
    -0.006884847767651081, 0.006283578462898731, -0.004226036369800568, -0.0010207738960161805, -0.009245689958333969, -0.005910078063607216, -0.023376483470201492, -0.02473711408674717,
    0.010969860479235649, -0.013127954676747322, 0.0033129961229860783, 0.004967294633388519, -0.013817532919347286, 0.005195746198296547, 0.006218896247446537, -0.02964400313794613,
    0.009289083071053028, -0.00463717058300972, -0.02600982040166855, -0.004018580541014671, -0.0352247953414917, -0.005984654650092125, 0.03453395515680313, 0.006904842332005501,
    0.009484879672527313, -0.02058713510632515, 0.005799239035695791, 0.016283713281154633, 0.02778867818415165, 0.015462188050150871, -0.0010453128488734365, -0.01759374514222145,
    0.022021403536200523, -0.007808454800397158, 0.009709811769425869, -0.008554401807487011, 0.020879458636045456, -0.007952469401061535, -0.018065335229039192, -0.018446367233991623,
    -0.018540723249316216, 0.011650331318378448, 0.0007468602852895856, 0.005924730561673641, 0.042267367243766785, 0.0017824172973632812, 0.017816267907619476, 0.0043207453563809395,
    -0.017132529988884926, 0.004877238068729639, 0.0008312306017614901, -0.017530441284179688, 0.0033613955602049828, 0.001343708485364914, -0.002652350813150406, -0.02080186828970909,
    -0.004244851414114237, 0.011442738585174084, 5.198457802180201e-05, 0.01126193255186081, 0.004029552917927504, 0.0045904433354735374, 0.018740059807896614, 0.00014592852676287293,
    -0.011327838525176048, -0.0025802566669881344, -0.00032259413274005055, 0.017141306772828102, -0.004805024713277817, -0.010745206847786903, -0.0018714837497100234, -0.013988194055855274,
    0.0018355485517531633, -0.0014972110511735082, -0.00920522678643465, 0.006418988108634949, -0.011323860846459866, -0.009234071709215641, 0.013692564330995083, 0.013725843280553818,
    0.027220185846090317, -0.009603911079466343, -0.0023503361735492945, 0.0028858946170657873, 0.029653452336788177, 0.004233446903526783, 0.021332260221242905, -0.007504770532250404,
    -0.002070631133392453, 0.00747283361852169, -0.014312975108623505, 0.030787097290158272, -0.03310506045818329, 0.011364883743226528, 0.007414192892611027, 0.0069284820929169655,
    -0.0069837807677686214, -0.010612474754452705, -0.006639337167143822, -0.02774021215736866, 0.018799424171447754, -0.026606200262904167, 0.00456490321084857, -0.0074754748493433,
    0.007399856112897396, 0.02379770763218403, -0.011774279177188873, 0.004014145117253065, -0.009961645118892193, -0.015200989320874214, -0.010293330997228622, -0.0017965484876185656,
    -0.005403365474194288, -0.016033850610256195, -0.03068724274635315, 0.02670745924115181, 4.131705645704642e-05, 0.020142458379268646, -0.006602858658879995, -0.01216471940279007,
    -0.005953582469373941, -0.011910432018339634, -0.004840697627514601, -0.019638894125819206, 0.005626793950796127, 0.009929374791681767, 0.022311797365546227, -0.009404283948242664,
    0.00011935521615669131, 0.026063766330480576, 0.034102875739336014, -0.016667138785123825, -0.003298221854493022, 0.02744181454181671, 0.018378226086497307, -0.009038325399160385,
    -0.006473908666521311, -0.002878989093005657, -0.015781329944729805, 0.005109452176839113, 0.018946988508105278, -0.03485787287354469, -0.005312677938491106, 0.012316607870161533,
    0.01085258275270462, 0.004640801809728146, 0.008773826994001865, 0.02438484877347946, 0.00020570305059663951, -0.002171862870454788, -0.01355085801333189, 0.019093763083219528,
    -0.020737359300255775, 0.013327944092452526, -0.006742939818650484, -0.02237759530544281, -0.006077909842133522, 0.005062461830675602, 0.018690096214413643, -0.002534936647862196,
    -0.016262464225292206, 0.015288351103663445, 0.001670102123171091, -0.013992940075695515, -0.0017622030572965741, 0.00020045919518452138, -0.006892282981425524, 0.007140655070543289,
    -0.00532141700387001, -0.009839514270424843, -0.003227521665394306, 0.03811279311776161, 0.033558640629053116, -0.005900069605559111, -0.021082237362861633, 0.017265815287828445,
    -0.006447254214435816, -0.011862662620842457, -0.005624034907668829, -0.004618803039193153, 0.000916278047952801, 0.037309590727090836, -0.013105133548378944, 0.00675266794860363,
    -0.010308485478162766, -0.003329564817249775, 0.008728687651455402, -0.009360658936202526, -0.01172146201133728, 0.008028029464185238, -0.015150156803429127, -0.02446591481566429,
    0.019914181903004646, -0.002340683015063405, 0.0030819883104413748, -0.02996169961988926, -0.000331954681314528, 0.01662539690732956, -0.01516580767929554, 0.003869809443131089,
    -0.0199899785220623, -0.014840464107692242, 0.005291994661092758, 0.016821134835481644, 0.0008454029448330402, -0.007856308482587337, -0.004139186814427376, -0.013277941383421421,
    0.012060335837304592, 0.016807708889245987, 0.009255347773432732, -0.007830418646335602, -0.004921369254589081, -0.01128655020147562, -0.022455323487520218, -0.002740448573604226,
    -0.015505407005548477, -0.034865424036979675, 0.03327016904950142, -0.0016392460092902184, 0.00651285145431757, -0.0012754997005686164, -0.005233132280409336, -0.022366195917129517,
    0.0029631596989929676, -0.02742038667201996, -0.004951054230332375, 0.018497273325920105, -0.03127918019890785, 0.034906771034002304, 0.006281109992414713, -0.02090258151292801,
    -0.008311858400702477, 0.018272724002599716, -0.02272702381014824, 0.008084703236818314, -0.0018582551274448633, 0.027517616748809814, -0.0018334758933633566, 0.007812516763806343,
    -0.007821572944521904, 0.01644122041761875, 0.008395541459321976, -0.00855982955545187, -0.006984695792198181, -0.0165440384298563, 0.006364224478602409, 0.017108164727687836,
    -0.01400953158736229, -0.001584540936164558, 0.01999441161751747, 0.006044506095349789, -0.04034953936934471, -0.011471716687083244, -0.005739614367485046, -0.020127329975366592,
    -0.0064596510492265224, -0.025360673666000366, -0.01620604656636715, 0.009876633062958717, 0.029920725151896477, -0.0019244896247982979, -0.003003989113494754, 0.01630827784538269,
    0.011124983429908752, 0.016794584691524506, -0.008443436585366726, -0.0050457245670259, -0.013588259927928448, -0.011372799053788185, -0.012413066811859608, 0.0003360286937095225,
    -0.025996848940849304, -0.003323174314573407, -0.009300127625465393, -0.02114182338118553, 0.006623450201004744, 0.005239773076027632, -0.016725780442357063, -0.033898428082466125,
    0.010221968404948711, 0.0011194983962923288, -0.00299203977920115, 0.010197729803621769, -0.0034671532921493053, -0.007126199081540108, 0.013262872584164143, 0.008792385458946228,
    0.005294039845466614, -0.001357150380499661, 0.009903134778141975, 0.03325493633747101, -0.007250761613249779, 0.013736708089709282, -0.013815019279718399, 0.0153289083391428,
    0.017722440883517265, -0.0065356045961380005, -0.0033866583835333586, -0.01367692369967699, -0.04984983801841736, 0.0062498669140040874, 0.0330398865044117, -0.015595047734677792,
    -0.005990336649119854, 0.006247576326131821, 0.007941768504679203, 0.0452611967921257, 0.011370847001671791, -0.02625233307480812, 0.02155771665275097, 0.022140497341752052,
    0.005700909998267889, -0.0023528425954282284, -0.010782976634800434, 0.01292599830776453, 0.025212954729795456, -0.015304981730878353, 0.010317998938262463, 0.008347447961568832,
    -0.00853283703327179, 0.01254414115101099, 0.004407781176269054, 0.024877138435840607, 0.010533038526773453, -0.01415221393108368, 0.008317611180245876, 0.01176465954631567,
    -0.009562067687511444, 0.00809338316321373, -0.03332311287522316, -0.038057804107666016, -0.010249952785670757, 0.016762500628829002, -0.005804843734949827, 0.01315745897591114,
    -0.026933440938591957, 0.0038391295820474625, -0.015277339145541191, 0.008527114987373352, -0.0139686344191432, -0.0033309143036603928, -0.002112769056111574, 0.0070068505592644215,
    0.009422174654901028, -0.0062254490330815315, -0.05139319226145744, 0.0012129839742556214, -0.008861666545271873, 0.0027084292378276587, -0.007832284085452557, 0.020760050043463707,
    -0.015251051634550095, -0.01023411750793457, 0.007175401318818331, 0.005593670066446066, -0.007362611126154661, 0.013828659430146217, 0.005053132772445679, -0.029042329639196396,
    -0.0008503865101374686, 0.0013031956041231751, 0.010877983644604683, 0.004145328886806965, -0.01627311110496521, -0.010161671787500381, 0.014189157634973526, 0.003314161440357566,
    0.020860891789197922, -0.009746458381414413, -0.009146950207650661, -0.003634647000581026, 0.010484607890248299, -0.007950215600430965, -0.0004924914101138711, -0.013986610807478428,
    -0.01015827152878046, 0.016661062836647034, 0.00807216390967369, 0.005961641203612089, -0.0219217911362648, -0.000518276821821928, -0.015220141038298607, 0.004320560954511166,
    0.009067205712199211, -0.009642739780247211, -0.0004886634997092187, 0.008040040731430054, 0.006516831461340189, 0.014958947896957397, 0.010069410316646099, -0.019115684553980827,
    -0.0002854573249351233, 0.009792299941182137, -0.013140353374183178, -0.020410502329468727, -0.017288465052843094, 0.026235980913043022, -0.005651024170219898, 0.011062066070735455,
    0.011821034364402294, 0.0021722624078392982, -0.0081451665610075, -0.01785525493323803, 0.002276558429002762, 1.781167884473689e-05, 0.022115051746368408, 0.01035911962389946,
    0.00965928751975298, -0.029481325298547745, 0.00415050471201539, -0.00016060099005699158, -0.009594832547008991, -0.016988344490528107, -0.013400571420788765, 0.015425372868776321,
    0.01197036076337099, 0.005847064778208733, -0.0032732326071709394, -0.018357228487730026, 0.021326538175344467, -0.009495535865426064, 0.016030140221118927, -0.008923184126615524,
    -0.016802003607153893, 0.014642100781202316, -0.0030358820222318172, 0.012278811074793339, -0.002715002978220582, 0.0007561602396890521, -0.013727610930800438, -0.0033901133574545383,
    -0.01375113520771265, 0.00020773170399479568, -0.015317268669605255, -0.006712055765092373, -0.002974398899823427, 0.04515962302684784, 0.011652573011815548, -0.03309379890561104,
    0.014261716045439243, 0.021206649020314217, 0.04279865324497223, -0.009732785634696484, -0.03744019195437431, 0.013285478577017784, 0.0018461669096723199, 0.012467451393604279,
    0.012857210822403431, 0.011574918404221535, -0.020303942263126373, -0.02646506391465664, -0.035587359219789505, -0.0034735703375190496, -0.023327447474002838, -0.00870597641915083,
    -0.025216519832611084, -0.0008202524040825665, -0.026235120370984077, 0.019392607733607292, 0.0036120153963565826, -0.010300611145794392, -0.004781338851898909, 0.003842348698526621,
    0.010791118256747723, 0.020020348951220512, 2.2423611881094985e-05, -0.007600568700581789, 0.016778845340013504, 0.011977308429777622, -0.005317768547683954, -0.0028396404813975096,
    0.0005679004825651646, -0.029252544045448303, -0.02558683231472969, -0.0007512767915613949, 0.007530666422098875, 0.006284590344876051, -0.02670658566057682, -0.008402654901146889,
    -0.0016103505622595549, 0.017770661041140556, -0.005302465986460447, -0.02289426699280739, 0.036297813057899475, -0.03578835725784302, 0.021755527704954147, -0.0047844829969108105,
    -0.006952345836907625, -0.017920896410942078, -0.005974493455141783, -0.02945784106850624, -0.0047448123805224895, -0.007164287380874157, 0.00540099898353219, 0.014271482825279236,
    -0.012265593744814396, -0.0027498286217451096, -0.005865715444087982, 0.00725046219304204, 0.011516139842569828, 0.007140605244785547, -0.00600023427978158, 0.00031148741254583,
    0.011030804365873337, 0.012727959081530571, -0.015220127068459988, -0.005190205294638872, 0.003213312244042754, 0.012157472781836987, -0.008947527967393398, -0.015700751915574074,
    -0.0037417958956211805, 0.017729736864566803, 0.034005358815193176, -0.018529238179326057, -0.0151174021884799, 0.004032068885862827, 0.03637790307402611, -0.01736631989479065,
    -0.027490878477692604, -0.007929283194243908, -0.008837535046041012, -0.0033590972889214754, -0.015275025740265846, -0.0044693672098219395, 0.005098599474877119, -0.0024496063124388456,
    0.031261466443538666, 0.00572621263563633, 0.0107778524979949, 0.012140394188463688, 0.009170668199658394, 0.003422593930736184, 0.014867785386741161, -0.004651361610740423,
    -0.010966467671096325, 0.004578609950840473, 0.003550225170329213, 0.0031572375446558, 0.004889306612312794, 0.00017941780970431864, 0.011472097598016262, 0.009288972243666649,
    -0.01917003095149994, -0.016138963401317596, -0.000940637313760817, -0.012621489353477955, -0.014675609767436981, -0.00352626945823431, -0.02730421908199787, 0.018736476078629494,
    -0.025951901450753212, 0.0037469989620149136, -0.006927364505827427, 0.03608572483062744, 0.06088726595044136, 0.008678588084876537, -0.028114978224039078, -0.00045937992399558425,
    -0.03323782607913017, -0.017571860924363136, 0.015269093215465546, -0.026877375319600105, -0.007480171043425798, 0.00281102629378438, 0.016013383865356445, -0.020271480083465576,
    -0.004631037823855877, 0.008360802195966244, -0.03610125556588173, -0.010814166627824306, -0.030351027846336365, -0.0031289502512663603, -0.01634208858013153, -0.04477452486753464,
    -0.013375073671340942, 0.0025156440678983927, 0.017178978770971298, 0.03347771242260933, 0.03572320193052292, -7.271821959875524e-05, -0.0031980560161173344, -0.010442208498716354,
    0.03448045998811722, 0.0012303231051191688, 0.023941058665513992, -0.016157623380422592, 0.0029019664507359266, -0.000634917349088937, -0.004267613869160414, -0.010523454286158085,
    -0.011468971148133278, -0.006876331754028797, -0.006407823413610458, 0.00611289544031024, -0.010291393846273422, 0.00931975431740284, -0.01762787625193596, -0.021785469725728035,
    -0.009374648332595825, 0.050104718655347824, 0.02037699893116951, -0.003763186512514949, 0.02306419610977173, 0.002843455644324422, 0.026962855830788612, -0.012244013138115406,
    0.02248414233326912, 0.008362814784049988, -0.01172694656997919, -0.0006909896619617939, -0.04758904501795769, 0.01110108569264412, -0.003313465742394328, -0.006332036107778549,
    0.02671014331281185, 0.006339978892356157, 0.020532207563519478, 0.008086436428129673, 0.01502017118036747, -0.005958595313131809, -0.002506962511688471, -0.011324403807520866,
    -0.006131007336080074, 0.005022907163947821, 0.0004304440226405859, -0.027156606316566467, -0.004036708269268274, -0.017684750258922577, 0.025175033137202263, -0.010192889720201492,
    -0.0024478521663695574, 0.01195556577295065, 0.021088048815727234, 0.012956291437149048, -0.012640178203582764, -0.009468642063438892, -0.0045913951471447945, 0.013674119487404823,
    0.01826353929936886, -0.028370290994644165, -0.012889042496681213, -0.02011524885892868, 0.03889623284339905, -0.00733235664665699, -0.020902354270219803, -0.011954535730183125,
    0.03998066857457161, 0.0250106081366539, -0.008774935267865658, 0.01739918254315853, 0.008162876591086388, -0.020082836970686913, 0.022065304219722748, 0.0005453178891912103,
    -0.04754984378814697, -0.004583276808261871, 0.003092593979090452, -0.014478562399744987, 0.01400307659059763, -0.0034211394377052784, -0.0008940528496168554, -0.010351189412176609,
    0.021473659202456474, 0.012693021446466446, -0.034247420728206635, -0.014989756979048252, 0.0052845231257379055, -0.0024195509031414986, 0.023030215874314308, 0.02310500293970108,
    0.01601528748869896, 0.02052353508770466, -0.01026773452758789, 0.036173928529024124, 0.003946214448660612, 0.001088797114789486, 0.008352335542440414, 0.0003144558286294341,
    0.020773421972990036, -0.013880130834877491, -0.004543344024568796, 0.0027078234124928713, -0.014067455194890499, -0.004551892634481192, 0.036727819591760635, 0.005651348736137152,
    0.03378019854426384, -0.004223383963108063, -0.016219448298215866, 0.02691580355167389, 0.002473635831847787, -0.05453192815184593, -0.0339990109205246, 0.026617737486958504,
    -0.001984293106943369, 0.019906291738152504, -0.0017494364874437451, 0.02057059109210968, 0.046170011162757874, -0.018909944221377373, 0.015138570219278336, -0.007983223535120487,
    -0.0038282577879726887, 0.02161961980164051, -0.0037496264558285475, 0.0015066625783219934, -0.0025213039480149746, -0.01104519423097372, 0.006487784441560507, 0.005263107363134623,
    -0.028189223259687424, -0.01639925315976143, -0.03887985274195671, -0.02200711891055107, -0.023999497294425964, 0.013067413121461868, -0.0021206005476415157, 0.00270178634673357,
    0.012078717350959778, -0.0034809282515197992, -0.0045301420614123344, -0.002485838485881686, -0.0068617090582847595, -0.001797536388039589, -0.02473781444132328, 0.017263295128941536,
    0.022368472069501877, -0.009213661774992943, -0.03166329488158226, 0.024195991456508636, 0.030130119994282722, 0.0007573197362944484, -0.006972053088247776, 0.015191292390227318,
    -0.0008804563549347222, -0.010673655197024345, 0.015227394178509712, -0.026966197416186333, -0.006711913272738457, -0.02144332230091095, -0.017517970874905586, 0.011523920111358166,
    -0.02840837836265564, 0.00694222841411829, -0.005068656988441944, -0.009584125131368637, -0.0321694016456604, 0.03867333382368088, 0.019172118976712227, -0.009178715758025646,
    0.030286552384495735, 0.002002015011385083, -0.016797009855508804, 0.0053478931076824665, -0.00014604163879994303, 0.00714137265458703, -0.018286021426320076, -0.007997347041964531,
    0.0026623187586665154, -0.016773873940110207, -0.018339497968554497, 0.013005416840314865, -0.0038123761769384146, -0.007774015888571739, -0.002440514275804162, -0.008156456053256989,
    -0.013693094253540039, 0.008780749514698982, 0.03247261047363281, 0.011562291532754898, 0.009725267998874187, -0.00015569094102829695, 0.02415420301258564, -0.007953427731990814,
    -0.025697611272335052, 0.015224404633045197, -0.033778782933950424, -0.008516068570315838, -0.034811947494745255, 0.01914326846599579, -0.015952274203300476, 0.017350342124700546,
    0.004011182580143213, 0.00661483034491539, -0.004549616482108831, 0.01987130381166935, -0.02378390170633793, 0.014118372462689877, -0.013212434947490692, -0.014729193411767483,
    -0.011304465122520924, 0.010860544629395008, 0.026914838701486588, -0.007959313690662384, 0.004932107403874397, -0.007669747341424227, 0.023076815530657768, 0.018495241180062294,
    -0.0014658101135864854, 0.006768628489226103, 0.007064842153340578, -0.0038802106864750385, 0.004479710012674332, 0.010671885684132576, 0.00044988846639171243, 0.0054210214875638485,
    -0.015293274074792862, 0.017176389694213867, -0.012639304623007774, 0.010170265100896358, 0.006798018701374531, 0.0004981720121577382, -0.006376326084136963, -0.021476570516824722,
    0.005777315236628056, -0.004602926317602396, -0.004023294895887375, -0.016293315216898918, -0.02741638571023941, -0.029021484777331352, 0.019913924857974052, -0.01815010979771614,
    0.00789809599518776, 0.0034837545827031136, 0.012440918013453484, -0.01408455427736044, -0.03325929492712021, 0.009455320425331593, -0.016743555665016174, 0.020212069153785706,
    -0.0072485278360545635, -0.009053119458258152, -0.0028117294423282146, -0.02051457390189171, -0.027712654322385788, 0.002015042584389448, -0.01872044987976551, -0.02877550944685936,
    0.008039380423724651, 0.02780083566904068, 0.012840836308896542, 0.01887992024421692, -0.006169918924570084, 0.002354072406888008, 0.01039157621562481, -0.017147429287433624,
    -0.040679652243852615, -0.033402543514966965, -0.010875889100134373, 0.01569526270031929, 0.010265878401696682, -0.01673821732401848, 0.01663416437804699, -0.016936440020799637,
    -0.013577815145254135, 0.010347694158554077, 0.011393144726753235, 0.0038588116876780987, -0.03293352574110031, 0.008101609535515308, -0.023611504584550858, -0.0010361658642068505,
    -0.005870915483683348, 0.027278965339064598, -0.0193699449300766, 0.013833990320563316, 0.02400710992515087, 0.0003409219207242131, 0.021408386528491974, -0.01129910908639431,
    -0.0042723435908555984, -0.010189559310674667, -0.00578463077545166, -0.00318804825656116, -0.01338324323296547, -0.006493274588137865, -0.011655761860311031, -0.0030396997462958097,
    -0.021234069019556046, 0.0068109952844679356, -0.003919488750398159, 0.005002833902835846, 0.02487153932452202, -0.021681319922208786, 0.03368956595659256, 0.00449847849085927,
    -0.016982747241854668, 0.012486228719353676, -0.0019923646468669176, -0.017167435958981514, 0.007315411698073149, 0.008406778797507286, -0.0021543328184634447, 0.003171144751831889,
    0.0008845067932270467, 0.030823610723018646, -0.015631744638085365, -0.018341854214668274, -0.012775142677128315, -0.004046484362334013, 0.002036391757428646, 0.002829428529366851,
    -0.00029495838680304587, -0.008567015640437603, -0.027410786598920822, -0.0269030649214983, 0.0018015881069004536, -0.014464139938354492, -0.018224423751235008, -0.004941004328429699,
    0.024292608723044395, 0.0028107056859880686, 0.007851013913750648, -0.01689847931265831, 0.017299553379416466, 0.0034363460727036, 0.01930268108844757, 0.015824122354388237,
    0.0028810789808630943, -0.0022443237248808146, 0.01183252315968275, -0.014525962062180042, 0.00110687967389822, 0.0125304339453578, -0.010821384377777576, -0.011141651310026646,
    -0.020983001217246056, -0.03215373679995537, -0.010448136366903782, 0.001999703934416175, -0.00664908904582262, -0.007182947359979153, 0.0031081996858119965, -0.01462042611092329,
    -0.015166540630161762, 0.0010313077364116907, -0.0018349363235756755, 0.006555572152137756, -0.005187630653381348, -0.008275311440229416, -0.018711041659116745, 0.011335322633385658,
    -0.0044387890957295895, -0.017016412690281868, 0.0009603083017282188, -0.02024395577609539, -0.008346850983798504, -0.010992784984409809, 0.017713638022542, -0.011186596937477589,
    -0.023254891857504845, -0.0008955656085163355, 0.041605640202760696, -0.006668939720839262, 0.002224062802270055, -0.01141360867768526, -0.017231443896889687, -0.03535368666052818,
    0.012982800602912903, -0.0022776692640036345, -0.0037271303590387106, -0.021889735013246536, 0.0030218111351132393, -0.004495649598538876, -0.0034486819058656693, -0.004572425968945026,
    0.0201143529266119, 0.0045034741051495075, 0.020585590973496437, -0.025125378742814064, 0.006139866076409817, 0.0010043438524007797, -0.013051302172243595, -0.023158520460128784,
    -0.00015866232570260763, 0.005685587413609028, 0.002341319341212511, -0.0026855766773223877, 0.011508146300911903, 0.013544896617531776, 0.01892911083996296, -0.008961674757301807,
    3.312778062536381e-05, 0.006362598855048418, -0.015342412516474724, 0.005497595760971308, 0.00408468721434474, -0.003938123118132353, -0.0072428700514137745, 0.019891822710633278,
    0.009030344896018505, 0.008426010608673096, 0.013855502009391785, -0.015667514875531197, -0.006964211817830801, 0.012431425973773003, -0.02196851186454296, 0.021219205111265182,
    -0.03146417438983917, -0.02002972923219204, -0.009862757287919521, -0.012891883961856365, -0.04733181744813919, 0.02623734436929226, -0.00785345770418644, 0.004242198076099157,
    -0.0013008745154365897, -0.014972084201872349, 0.018893543630838394, 0.008095314726233482, 0.003721296787261963, -0.015694882720708847, 0.0012968278024345636, 0.017710218206048012,
    -0.0015184759395197034, 0.014519944787025452, -0.002037838101387024, 0.01268552616238594, 0.0016346406191587448, -0.016264449805021286, 0.0032063398975878954, 0.015414505265653133,
    0.02329997532069683, 0.015704168006777763, -0.000646191299892962, 0.011029984802007675, -0.0058000339195132256, 0.019171448424458504, 0.008324799127876759, 0.004021598491817713,
    0.0005813312600366771, 0.010930283926427364, -0.0156316589564085, -0.0032412000000476837, -0.010874849744141102, 0.012738103047013283, 0.034431494772434235, 0.003147299401462078,
    -0.03887827321887016, 0.0039433022029697895, -0.0013684637378901243, -0.003951188176870346, -0.02905217371881008, 0.011750130914151669, 0.006637142971158028, -0.0217126477509737,
    0.004145461600273848, 0.006118398625403643, 0.0002828227006830275, 0.012410689145326614, 0.008351491764187813, 0.0012039522407576442, 0.025171782821416855, 0.02637590281665325,
    -0.0174822099506855, 0.010587843134999275, -0.0068623945116996765, 0.005169398616999388, 0.032257869839668274, 0.010359936393797398, -0.006745251826941967, 0.005508921109139919,
    0.014087948016822338, -0.0027383791748434305, -0.009400584734976292, 0.0043183546513319016, 0.014440124854445457, 0.0104709817096591, 0.013564656488597393, -0.008600343018770218,
    -0.004046228714287281, 0.008638317696750164, 0.01244816742837429, 0.014729510061442852, -0.019892821088433266, -0.02322951890528202, 0.0031881334725767374, 0.0068995957262814045,
    0.012139356695115566, 0.012668725103139877, -0.033271826803684235, -0.004849237389862537, 0.009941312484443188, -0.006994506344199181, -0.01311399880796671, -0.007005786057561636,
    -0.005031082779169083, 0.018696561455726624, 0.008882264606654644, -0.009958574548363686, 0.007337270304560661, 0.0007730238139629364, -0.0030441780108958483, -0.017777645960450172,
    0.009401824325323105, 0.015595627017319202, -0.011921829544007778, 0.018410421907901764, 0.007466263137757778, -0.011654750443994999, 0.003059516893699765, 0.007439610082656145,
    0.008297441527247429, -0.003244058694690466, -0.01698477193713188, 0.00040678668301552534, -0.0219587255269289, 0.007858370430767536, 0.004118039272725582, -0.0024336641654372215,
    -0.016018519178032875, 0.007969547994434834, 0.014958680607378483, -0.007726386189460754, -0.013953135348856449, 0.0031997733749449253, -0.002911959309130907, 0.009448046796023846,
    -0.024600153788924217, 0.011464186012744904, -0.012397674843668938, -0.0037566558457911015, 0.00047749961959198117, 0.014144107699394226, 0.013500087894499302, -0.013709194958209991,
    0.0021837621461600065, -0.03714971989393234, 0.031854793429374695, 0.015180245041847229, 0.006930829491466284, 0.006620256695896387, -0.021498270332813263, -0.0008724167128093541,
    0.013759751804172993, 0.016064628958702087, -0.000993043533526361, -0.009699392132461071, -0.0072777774184942245, -0.008517206646502018, 0.04011119157075882, 0.010394087061285973,
    -0.012732616625726223, -0.020515920594334602, 0.012474644929170609, -0.034600239247083664, 0.026729896664619446, 0.00598644744604826, -0.001962521579116583, 0.010590394958853722,
    0.008287057280540466, 0.004337080288678408, -0.015287940390408039, -0.015954481437802315, 0.022165140137076378, -0.01754746586084366, -0.025573503226041794, 0.02925759367644787,
    -0.02774978056550026, 0.017807677388191223, 0.007347055245190859, -0.01350452471524477, 0.010684095323085785, -0.003079031128436327, -0.007415156811475754, -0.000294736644718796,
    0.008213462308049202, -0.0014322873903438449, 0.0004008777323178947, 0.018704434856772423, 0.010235200636088848, -0.0027469925116747618, 0.009881955571472645, 0.014357466250658035,
    -0.004377570003271103, 0.020027460530400276, 0.04322004318237305, 6.446437328122556e-05, -0.0022699704859405756, -0.005538305267691612, 0.0038903262466192245, 0.0004927853588014841,
    -0.0017194242682307959, 0.00022443731722887605, -0.005400163121521473, 0.0010234244400635362, 0.0004991675959900022, -0.003581240540370345, -0.02658601850271225, -0.012415843084454536,
    -0.014682651497423649, 0.007896392606198788, -0.015591857023537159, 0.016925696283578873, 0.009396824985742569, -0.017916006967425346, -0.00775326369330287, -0.00580664211884141,
    -0.018470218405127525, -0.008437938056886196, -0.004104453604668379, -0.003971285652369261, 0.00226800050586462, -0.021967550739645958, 0.011960983276367188, -0.0026090696919709444,
    -0.008862806484103203, -0.019073419272899628, 0.026516150683164597, 0.0236849095672369, 0.0019787228666245937, 0.00150099431630224, 0.044225793331861496, -0.004339020699262619,
    -8.234609595092479e-06, -0.018841026350855827, -0.014172926545143127, -0.009347537532448769, -0.019958045333623886, 0.008712383918464184, 0.030744321644306183, -0.0022750392090529203,
    0.00292833149433136, -0.011550909839570522, 0.01468314602971077, -0.014409132301807404, -0.0020920541137456894, -0.005865457933396101, -0.011548618786036968, -0.019694089889526367,
    0.005958761554211378, -0.021162642166018486, 0.004183181561529636, -0.0012482795864343643, -0.012890396639704704, -0.04024529829621315, 0.023146281018853188, -0.012048504315316677,
    0.02054009959101677, -0.006326867733150721, -0.003201011335477233, 0.012712979689240456, 0.032201800495386124, -0.0010337310377508402, 0.04352886229753494, 0.01129962969571352,
    0.017248116433620453, 0.010034064762294292, 0.020239705219864845, 0.01813322864472866, -0.012495162896811962, 0.021336926147341728, 0.007800174877047539, -0.010396294295787811,
    -0.02369125932455063, 0.050659582018852234, -0.005241480190306902, 0.012013861909508705, -0.007164500653743744, -0.004656319972127676, 0.006094522308558226, -0.01249005738645792,
    -0.016235629096627235, 0.007277326192706823, -0.0208794753998518, 0.013917258940637112, -0.015453829430043697, -0.008121655322611332, -0.010783445090055466, -0.034578002989292145,
    -0.032524727284908295, 0.004052441101521254, 0.010405651293694973, 0.016727495938539505, -0.012172901071608067, -0.0071419719606637955, 0.0017741565825417638, -0.011562200263142586,
    0.02005498670041561, -0.010611740872263908, 0.04225429892539978, 0.00838319119066, -0.03008165769279003, 0.017768224701285362, 0.006944563705474138, -0.014102731831371784,
    0.02061481401324272, -0.006230247672647238, -0.007640560157597065, -0.009611140936613083, -0.010959790088236332, -0.018120840191841125, 0.0007020526682026684, 0.030531302094459534,
    -0.020670760422945023, 0.00448997737839818, -0.01573784463107586, -0.029162485152482986, 0.0008482940611429513, 0.007290474604815245, -0.0054044234566390514, -0.023758959025144577,
    0.015036050230264664, -0.01545589230954647, -0.02199658192694187, 0.04159135743975639, -0.019718842580914497, 0.03612238168716431, 0.003160095075145364, -0.007204404100775719,
    0.014748582616448402, -0.015198927372694016, 0.020539984107017517, 0.0040407669730484486, 0.03750965744256973, 0.004756596405059099, 0.008149382658302784, 0.024916039779782295,
    -0.0038648336194455624, -0.004605741240084171, -0.011989484541118145, -0.0074280742555856705, -0.01915077306330204, 0.006705176085233688, -0.00038850290002301335, 0.02331099472939968,
    -0.004816284403204918, -0.006630595773458481, 0.004054557532072067, -0.009978920221328735, -0.023398585617542267, -0.055759821087121964, 0.018279261887073517, -0.034920766949653625,
    0.024524373933672905, 0.0015917947748675942, 0.011938058771193027, -0.0005562546430155635, 0.011944449506700039, 0.014571845531463623, -0.07079364359378815, -0.009132640436291695,
    0.024822520092129707, 0.005867726635187864, 0.0023104576393961906, 0.014541322365403175, -0.028500251471996307, -0.02627691440284252, -0.0013032985152676702, 0.03377164155244827,
    -0.026876015588641167, 0.0255960114300251, -0.008305082097649574, 0.051487747579813004, 0.010842535644769669, 0.021776681765913963, 0.006447374355047941, 0.0019939374178647995,
    0.01565583236515522, -0.003126537660136819, -0.003434024751186371, 0.0074343010783195496, -0.01025181170552969, 0.034553345292806625, 0.02216651290655136, -0.01756139099597931,
    -0.0034317958634346724, -0.009610961191356182, 0.04060841351747513, -0.0020277216099202633, -0.019028332084417343, 0.006856138352304697, -0.045687220990657806, 0.0002992966619785875,
    -0.030287103727459908, 0.03309808298945427, -0.010239318944513798, -0.03794340789318085, 0.0026414254680275917, -0.0058204978704452515, 0.018233967944979668, 0.022290658205747604,
    -0.004628671333193779, -0.030032029375433922, 0.000997171620838344, -0.04633601754903793, -0.03150736540555954, 0.004179397132247686, -0.005062280222773552, -0.0036165304481983185,
    -0.003236490534618497, -0.015909958630800247, -0.0033412824850529432, 0.02323922887444496, -0.018156779929995537, -0.004818372428417206, 0.02898380160331726, 0.04277893155813217,
    0.022230073809623718, 0.009478145278990269, -0.015597357414662838, -0.07057125866413116, 0.03636808693408966, -0.0009303250117227435, -0.010529769584536552, -0.02550813928246498,
    0.007269501220434904, 0.03446003049612045, -0.006798300892114639, -0.011599506251513958, -0.038256462663412094, -0.009123118594288826, -0.004721531178802252, 0.02142002247273922,
    -0.002723761834204197, -0.008675920777022839, -0.021450385451316833, -0.019644413143396378, 0.015090655535459518, -0.012892319820821285, -0.012732673436403275, -0.01326761394739151,
    0.019843051210045815, 0.003117496846243739, 0.0049433112144470215, 0.042062725871801376, 0.023985914885997772, -0.002845321549102664, -0.007365467492491007, -0.0004130522720515728,
    -0.003913606517016888, 0.029120810329914093, 0.021654728800058365, 0.0028495979495346546, 0.011145161464810371, -0.012059913948178291, -0.015941163524985313, 0.013102725148200989,
    -0.03755059465765953, 0.014963185414671898, 0.0023933579213917255, 0.034917645156383514, -0.010731937363743782, -0.0023860500659793615, -0.013590056449174881, 0.005127269309014082,
    0.018290698528289795, 0.009536865167319775, -0.017785590142011642, 0.00043583192746154964, 0.055063165724277496, -0.009966397657990456, -0.009622303768992424, -0.028219537809491158,
    -0.016943227499723434, 0.021176660433411598, 0.004028653260320425, 0.002854293445125222, -0.019071927294135094, -0.011738177388906479, 0.00655721127986908, 0.021507510915398598,
    -0.024092303588986397, 0.0006843103328719735, -0.005410423967987299, 0.013261052779853344, 0.004774169530719519, -0.029396962374448776, 0.015091925859451294, 0.01392695028334856,
    -0.02166486158967018, -0.002403722843155265, -0.010419970378279686, 0.01978795789182186, 0.013838724233210087, 0.017820851877331734, -0.0005952417850494385, -0.011081976816058159,
    0.05034129321575165, -0.004739720840007067, -0.003690760349854827, -0.005558772012591362, 0.022381087765097618, -0.04186003655195236, 0.011743699200451374, 0.024920491501688957,
    -0.005496342666447163, 0.011707982048392296, -0.009570160880684853, -0.0007853759452700615, -0.03582923114299774, -0.019342323765158653, -0.0058769830502569675, 0.014082087203860283,
    0.0057659936137497425, -0.02742268517613411, -0.02261403575539589, -0.00875021144747734, 0.013180331327021122, 0.0007132312166504562, 0.027501199394464493, -2.0202955056447536e-05,
    0.0008549082558602095, 0.028207462280988693, -0.0034925651270896196, 0.03674619272351265, 0.007240467704832554, 0.012080173939466476, -0.0016698213294148445, 0.0032911598682403564,
    0.011914934031665325, -0.0014083097921684384, -2.477025191183202e-05, 0.01327928714454174, 0.01144358143210411, -0.0012231107102707028, 0.0051038130186498165, -0.006291311699897051,
    -0.033900514245033264, 0.013657776638865471, 0.017744841054081917, -0.0009482712484896183, 0.019764496013522148, -0.04602363333106041, -0.02258286438882351, -0.037935566157102585,
    -0.031485263258218765, 0.025627512484788895, 0.026249093934893608, 0.045084625482559204, 0.012874568812549114, 0.0034225527197122574, -0.015306968241930008, -0.0017789668636396527,
    0.02688531018793583, -0.014944746159017086, -0.004700994119048119, 0.006030858028680086, -0.03020372800529003, 0.009531842544674873, 0.005389771889895201, 0.002324333181604743,
    0.015177001245319843, -0.01792331226170063, 0.002292667282745242, 9.690046863397583e-05, 0.01705401949584484, 0.005226319655776024, 0.02354893647134304, 0.019403139129281044,
    0.00045574698015116155, 0.0003633892920333892, 0.00958802830427885, -0.012019895948469639, -0.03312769532203674, 0.0046857246197760105, -0.007977940142154694, 0.020405618473887444,
    0.008157972246408463, -0.01272994838654995, 0.005677510518580675, 0.017478570342063904, 0.009273151867091656, 0.013773610815405846, 0.008850054815411568, -0.01782827265560627,
    0.008817002177238464, -0.020917829126119614, -0.0183052197098732, -0.054695867002010345, 0.0529080405831337, -0.006682289764285088, 0.016062311828136444, 0.007995075546205044,
    -0.01814671978354454, 0.0033609536476433277, -0.0048906514421105385, -0.018764959648251534, -0.029402894899249077, 0.005992082413285971, 0.015087096020579338, 0.02366793341934681,
    -0.016143670305609703, -0.009691140614449978, -0.009205421432852745, -0.008468877524137497, -0.013020026497542858, -0.03741146996617317, -0.018081536516547203, -0.00817942712455988,
    0.011517098173499107, 0.013920584693551064, 0.00843727309256792, -0.003751241834834218, -0.020204680040478706, -0.011982660740613937, -0.004077171441167593, -0.0512065626680851,
    0.01483174879103899, 0.03627302870154381, -0.007210286799818277, -0.04803215712308884, 0.00953303650021553, -0.019894173368811607, -0.018697770312428474, 0.017108792439103127,
    -0.03372104465961456, -0.005301053170114756, -0.008353057317435741, -0.004915650933980942, -0.003134871833026409, 0.010427527129650116, 0.004264174960553646, -0.029599275439977646,
    0.013406850397586823, 0.022381672635674477, -0.0013570479350164533, 0.007160028908401728, -0.013753696344792843, 0.02431882731616497, -0.0006401804275810719, -0.04653312638401985,
    -0.0031191406305879354, 0.024145906791090965, -0.029293084517121315, 0.009492278099060059, -0.035459186881780624, 0.0030738047789782286, 0.026879463344812393, -0.0005538772675208747,
    -0.0145964240655303, -0.019320262596011162, -0.025481121614575386, -0.024337438866496086, -0.012921306304633617, 0.0011863040272146463, -0.01231701672077179, -0.01100077386945486,
    -0.005724229384213686, -0.017709091305732727, 0.0119547788053751, 0.004065132234245539, -0.010982250794768333, -0.0032748188823461533, -0.0007556141936220229, 0.0022261161357164383,
    0.016132928431034088, -0.012337750755250454, 0.0008095448138192296, 0.006502021104097366, -0.01781301386654377, 0.036021534353494644, 0.016060834750533104, -0.008444719947874546,
    0.00982271321117878, -0.029080966487526894, 0.0014168977504596114, -0.021608369424939156, 0.00550053222104907, -0.004143936093896627, 0.000301147170830518, 0.016240546479821205,
    -0.03515481948852539, -0.02458363212645054, -0.004700628109276295, 0.0003376607783138752, 0.027625886723399162, -0.0007456199382431805, 0.00316619616933167, -0.0005167759372852743,
    -0.002308351919054985, 0.001212049275636673, 0.007237893994897604, 0.013961711898446083, 0.005430177785456181, 0.0038165387231856585, -0.023741433396935463, 0.009025846607983112,
    0.013943396508693695, -0.00492971483618021, 0.012419430539011955, 0.009809578768908978, 0.007389597594738007, 0.00491933710873127, 0.012206905521452427, 0.00980969425290823,
    -0.012355049140751362, -0.004131893161684275, 0.028748909011483192, -0.0032625815365463495, -0.009800774976611137, -0.011055851355195045, -0.005775518715381622, 0.020401254296302795,
    0.010414320044219494, 0.002451112028211355, 0.014326991513371468, 0.053831230849027634, -0.0038945928681641817, 0.013002833351492882, -0.04526705667376518, -0.00324556534178555,
    -0.009147973731160164, -0.01286095567047596, -0.0033469877671450377, 0.01934409700334072, 0.0060020433738827705, -0.011169875971972942, -0.01452136691659689, -0.004831722006201744,
    0.010499967262148857, -0.0056542931124567986, 0.004768703132867813, -0.0044228737242519855, 0.004409923683851957, 0.0391463004052639, -9.631985449232161e-05, 0.011032403446733952,
    0.002180966781452298, -0.0013413542183116078, 0.010042684152722359, 0.00667262077331543, 0.012358610518276691, -0.008801004849374294, -0.011165490373969078, 0.03157540783286095,
    0.004539064131677151, -0.03315551578998566, 0.0107450932264328, -0.0008121962891891599, -0.007204830646514893, 0.020083991810679436, 0.02313830330967903, -0.02388034760951996,
    -0.019135653972625732, 0.009397369809448719, 0.01542495284229517, -0.0029017108026891947, -0.038510169833898544, 0.021789491176605225, 0.005590459797531366, 0.01678619161248207,
    0.0064239101484417915, -0.024500595405697823, 0.018748944625258446, 0.0007400985923595726, 0.01188125554472208, -0.008852347731590271, 0.005686088465154171, 0.03789709880948067,
    -0.018487093970179558, -0.019914535805583, 0.049323566257953644, 0.002526803407818079, 0.020100168883800507, 0.017594439908862114, 0.0025612362660467625, -0.0023785815574228764,
    0.018714040517807007, 0.0167843010276556, 0.021297955885529518, 0.005138296168297529, -0.005171576049178839, 0.0046843248419463634, -0.008170975372195244, 0.029291464015841484,
    -0.006579367909580469, 0.0260130874812603, -0.007896329276263714, 0.007971448823809624, -0.01001829281449318, -0.013717628084123135, -0.019675258547067642, 0.019037213176488876,
    -0.009990658611059189, 0.011472499929368496, 0.01870758831501007, -0.0018461833242326975, 0.0018555785063654184, -0.004729992710053921, 0.009051335044205189, 0.00486923661082983,
    0.0008648426737636328, 0.027815423905849457, 0.011445545591413975, 0.013925008475780487, 0.008471949957311153, 0.005141144618391991, -0.011842338368296623, -0.006190938875079155,
    0.04934009909629822, 0.017825346440076828, -0.004911732394248247, -0.03988441452383995, 0.015704501420259476, -0.01081595104187727, 0.015525950118899345, 0.0036998309660702944,
    0.01548043917864561, -0.01241088006645441, -0.00993606261909008, 0.0043662176467478275, 0.020327147096395493, -0.026127750054001808, 0.01777718961238861, -4.804995842278004e-05,
    -0.029694586992263794, 0.00942931231111288, 0.009047393687069416, -0.0038905073888599873, 0.03429030254483223, -0.015078725293278694, -0.031246477738022804, -0.02413596771657467,
    -0.0012727316934615374, -0.01530043501406908, -0.021733488887548447, 0.014549735933542252, 0.014497407712042332, -0.0054664649069309235, -0.007293191738426685, -0.004973321687430143,
    -0.020838892087340355, 0.003698036540299654, 0.007279118523001671, -0.017496081069111824, 0.016486868262290955, -0.004290740936994553, 0.020924875512719154, 0.0031750970520079136,
    0.034239623695611954, -0.014703025110065937, -0.024678342044353485, -0.02136320061981678, -0.021527519449591637, 0.013517966493964195, 0.02145344205200672, -0.00230705295689404,
    0.00607423996552825, 0.03673744201660156, -0.012810700573027134, 0.020744401961565018, 5.967777383375505e-07, 0.026416828855872154, 0.00011212418758077547, 0.01768769882619381,
    0.00651802122592926, 0.02145186811685562, 0.0065581523813307285, -0.01792891137301922, 0.030237950384616852, -0.02037527598440647, 0.001678479602560401, 0.024360304698348045,
    -0.008915825746953487, 0.022694909945130348, -0.006824362091720104, 0.013600116595625877, 0.029893571510910988, -0.003291073953732848, 0.0042827799916267395, -0.0047922017984092236,
    -0.0019264854490756989, -0.006042063236236572, 0.0029119066894054413, 0.01761297881603241, 0.0035579856485128403, 0.013102168217301369, -0.009850828908383846, 0.006278106011450291,
    -0.01041383482515812, 0.012416025623679161, -0.019646303728222847, -0.0009209204581566155, -0.04126017913222313, 0.014156880788505077, 0.003914196509867907, 0.010777688585221767,
    0.01825900562107563, -0.004779249895364046, -0.01603436842560768, 0.028428014367818832, -0.037551961839199066, -0.0011554593220353127, 0.014730256050825119, 0.011301949620246887,
    1.2813643479603343e-05, -0.010089864023029804, -0.0033979988656938076, -0.0019477619789540768, 0.009778560139238834, -0.008911162614822388, 0.011104428209364414, 0.011214610189199448,
    0.007526408415287733, 0.035501644015312195, 0.0031200735829770565, -0.018848033621907234, -0.0069813900627195835, 0.00492238299921155, 0.015620128251612186, -0.029964104294776917,
    -0.011577649973332882, -0.027095215395092964, -0.01700093224644661, 0.007569486740976572, -0.024818018078804016, -0.007624556310474873, -0.009690146893262863, -0.007350565865635872,
    -0.014345476403832436, 0.0063266269862651825, -0.0008327973773702979, 0.022033201530575752, -0.003168450202792883, -0.008217846974730492, -0.007031523156911135, 0.011619181372225285,
    -0.012460662052035332, -0.007059882860630751, 0.019909216091036797, 0.02849535457789898, -0.05861600860953331, 0.018341733142733574, -0.0012628828408196568, 0.025622965767979622,
    -0.011543444357812405, -0.009153857827186584, -0.0020189578644931316, -0.023759864270687103, 0.023384034633636475, 0.032519206404685974, -0.03961598128080368, 0.006656329613178968,
    0.0040882909670472145, -0.0031131403520703316, 0.028836682438850403, 0.012631835415959358, -0.03759564086794853, 0.006145539227873087, -0.0006078829756006598, 0.02566087245941162,
    0.005203481297940016, 0.002022339263930917, 0.02034064196050167, -0.0034644154366105795, 0.015761446207761765, -0.002491918858140707, 0.0013849380193278193, -0.02576661854982376,
    -0.016999607905745506, -0.004135271534323692, -0.026712976396083832, -0.016105644404888153, -0.005714771803468466, -0.028576212003827095, 0.010174762457609177, 0.001342416275292635,
    -0.03249172866344452, 0.022920707240700722, 0.0007049679406918585, -0.006002354901283979, -0.018634509295225143, -0.01544081512838602, -0.02959303930401802, 0.009397738613188267,
    0.009903017431497574, -0.02921464666724205, 0.018079249188303947, -0.017226969823241234, -0.008094120770692825, -0.010270018130540848, 0.0022326542530208826, -0.04421548545360565,
    0.02130485698580742, -0.02951752580702305, 0.0038838062901049852, 0.008193420246243477, -0.012233035638928413, -0.0047089653089642525, -0.02395719662308693, -0.016718849539756775,
    0.0038127158768475056, -0.0018761679530143738, -0.002985779894515872, -0.005292346701025963, -0.007887190207839012, 0.014862427487969398, -0.005854557268321514, 0.0011953022330999374,
    0.028540121391415596, 0.008738866075873375, -0.005968069192022085, -0.013126992620527744, -2.4628139726701193e-05, -0.008187344297766685, 0.010395906865596771, -0.00875093787908554,
    0.02004386857151985, 0.01579095982015133, 0.00788110215216875, -0.001330624450929463, 0.00803934782743454, 0.014332721941173077, -0.010302150622010231, -0.03714432194828987,
    -0.007480868604034185, -0.01009889505803585, -0.0018552421825006604, 0.0009552629198879004, -0.010847378522157669, -0.0008785217069089413, 0.0026134236250072718, -0.011858084239065647,
    0.004323900677263737, -0.006368829868733883, -0.0028157823253422976, -0.000887110538315028, -0.006573163904249668, -0.00015687398263253272, -0.007972193881869316, -0.003239529440179467,
    -0.0073355454951524734, 0.023870564997196198, -0.005893124267458916, 0.0070267412811517715, -0.0009757155203260481, -0.002277371473610401, -0.001529117813333869, 0.00028999787173233926,
    -0.0011300224578008056, 0.004246636293828487, 0.004204335622489452, -0.014178531244397163, 0.002938102697953582, -0.008337999694049358, -0.0037164115346968174, 0.003026458667591214,
    -0.00017764230142347515, 0.003122258698567748, 0.002067417837679386, 0.006970517337322235, -0.004707407671958208, 0.002276565181091428, 0.007257947698235512, 0.004542089067399502,
    0.0017351150745525956, 0.0006791556370444596, 0.0007283975719474256, -0.002520426642149687, 0.00307732867076993, 0.007890594191849232, 0.023525027558207512, 0.001566150807775557,
    0.0022411546669900417, -0.0020546521991491318, 0.0012785590952262282, 0.006317027844488621, -0.0006717548822052777, 0.0006066769710741937, -0.006176026072353125, 0.0024808994494378567,
    -0.011163548566401005, 7.642774289706722e-05, 0.0013037450844421983, -0.0028566124383360147, 0.006529875099658966, -0.0048981537111103535, -0.01937836967408657, -0.0038106462452560663,
    -0.0008463954436592758, -0.013595642521977425, -0.005458605941385031, 0.004736045375466347, -0.0010976542253047228, 0.002927386201918125, -0.006552053615450859, 0.0024271460715681314,
    -0.003255041316151619, 0.0006288358708843589, 0.011453204788267612, -0.0014315112493932247, 0.004877162165939808, 0.0006850474164821208, -0.014006870798766613, 0.007745316717773676,
    -0.00036146098864264786, -0.00031543202931061387, -0.004298684652894735, -0.014576118439435959, -0.005441979039460421, 0.005052575375884771, -8.898384112399071e-05, -0.00102179404348135,
    -0.00781408604234457, 0.0011767679825425148, 0.0007295064860954881, 0.012901727110147476, 0.008104427717626095, -0.007649677339941263, 0.0069146235473454, 0.006554591469466686,
    0.005544927902519703, 0.0029985227156430483, -0.006611444987356663, -0.01002933643758297, 0.005783200263977051, 0.002070612972602248, 0.002994387410581112, 0.008328335359692574,
    -0.003641250543296337, -0.0011196857085451484, 0.003489925293251872, -0.007662363350391388, 0.0021693429443985224, -0.0008577129920013249, -0.004194874316453934, 0.0029122279956936836,
    0.001564957550726831, -0.0006690140580758452, 0.001220704521983862, 0.0018571558175608516, -0.0013879409525543451, 0.0014613914536312222, -0.0017217360436916351, -0.007387906778603792,
    -0.009820099920034409, 0.0011639944277703762, 0.0030810346361249685, 0.0020265576895326376, -0.005379798356443644, 0.0026359616313129663, 0.0037771305069327354, 0.007862777449190617,
    0.020802870392799377, 0.052331894636154175, 0.001976755680516362, -0.04711395129561424, -0.002258298685774207, -0.02223074436187744, -0.006323746871203184, -0.0059147728607058525,
    -0.022422388195991516, -0.005708899814635515, 0.001957122003659606, -0.022748319432139397, 0.024496810510754585, -0.049739375710487366, -0.033434025943279266, -0.011785664595663548,
    -0.01480674184858799, 0.04247812554240227, -0.02967090532183647, 0.03499600663781166, 0.08198684453964233, -0.01584637351334095, -0.02669239416718483, -0.03562633693218231,
    -0.034479450434446335, 0.028890255838632584, 0.0030600393656641245, -0.010345857590436935, -0.015237102285027504, 0.017366280779242516, -0.05952458456158638, 0.05029737204313278,
    -0.04328608885407448, 0.018557274714112282, 0.02898765169084072, -0.040711794048547745, 0.03751886636018753, 0.00939763244241476, 0.09833226352930069, -0.012551667168736458,
    0.013949403539299965, -0.010547772981226444, 0.020652202889323235, -0.039882317185401917, 0.03652957081794739, -0.0059624332934618, -0.05197844281792641, 0.01362412329763174,
    0.04825131222605705, -0.029409941285848618, -0.008430547080934048, 0.046714454889297485, -0.0649227723479271, 0.06578090786933899, 0.010027003474533558, 0.024671483784914017,
    0.011275765486061573, -0.0036752568557858467, -0.022464098408818245, 0.054331619292497635, -0.04724111035466194, -0.02529534511268139, -0.05438944697380066, 0.006464904174208641,
    0.0007024477235972881, 0.0248746145516634, 0.03751456364989281, -0.006479786708950996, -0.030780067667365074, 0.033882178366184235, -0.02422935701906681, 0.056116629391908646,
    -0.021952884271740913, -0.030893143266439438, -0.03694697096943855, -0.02483464777469635, 0.023528126999735832, -0.03951360285282135, -0.030327122658491135, 0.041994765400886536,
    0.01571197435259819, 0.014894603751599789, 0.031147174537181854, -0.04118529334664345, -0.0027342962566763163, -0.008307712152600288, -0.014887376688420773, -0.04119449481368065,
    -0.014507505111396313, 0.006525952368974686, -0.001866471255198121, 0.011274375952780247, -0.041686803102493286, 0.03155169636011124, -0.009825091809034348, 0.03297694772481918,
    -0.0478639118373394, 0.04061807319521904, -0.0008716270094737411, 0.020700469613075256, 0.042459286749362946, -0.004191079176962376, -0.03447474539279938, -0.0013509547570720315,
    -0.057186827063560486, 0.002752202097326517, -0.008687881752848625, -0.014796373434364796, -0.0164522472769022, -0.012211637571454048, -0.027069024741649628, 0.0024840296246111393,
    -0.006574884057044983, -0.005868586711585522, -0.019551320001482964, 0.005355007015168667, 0.0462898425757885, 0.043012019246816635, -0.02269972674548626, -0.05698782205581665,
    -0.003538783872500062, -0.024674439802765846, -0.02836097963154316, 0.019050749018788338, -0.03006931208074093, 0.023095514625310898, 0.007092204876244068, 0.013687321916222572,
    -0.01048344001173973, -0.04290331155061722, -0.047912564128637314, -0.036089733242988586, -0.03393884375691414, -0.005558719392865896, -0.017235537990927696, 0.04864504933357239,
    0.01359094213694334, 0.03863636776804924, 0.03271477296948433, 0.02367403171956539, 0.039522793143987656, -0.017912769690155983, -0.011761019006371498, -0.014439969323575497,
    -0.031599391251802444, -0.007961499504745007, -0.029249664396047592, 0.004530852194875479, 0.052579768002033234, -0.017839238047599792, 0.013653994537889957, 0.01262975949794054,
    0.0050817993469536304, -0.06517473608255386, -0.044178400188684464, -0.05208679661154747, -0.0553702786564827, 0.013224436901509762, 0.055862803012132645, 0.04693550989031792,
    -0.10767125338315964, -0.0463300459086895, 0.05550506338477135, 0.02033095620572567, -0.044704370200634, -0.019002851098775864, 0.008989067748188972, 0.012773298658430576,
    0.02368691936135292, -0.011193972080945969, 0.03821535408496857, 0.020810671150684357, -0.05322424694895744, -0.07219849526882172, -0.024984994903206825, 0.004666249267756939,
    0.030125809833407402, -0.017057035118341446, 0.050241678953170776, 0.038590267300605774, -0.004997506737709045, -0.03380916267633438, -0.0036897296085953712, 0.031188741326332092,
    0.055379994213581085, 0.010553337633609772, 0.01783706620335579, -0.001390515943057835, -0.018516018986701965, -0.002609150717034936, -0.015543252229690552, 0.018798239529132843,
    0.01034410297870636, 0.01484996173530817, 0.005639347713440657, 0.02325638011097908, 0.05325274541974068, -0.04299004003405571, 0.006388014182448387, 0.0443374365568161,
    0.00040447356877848506, 0.06219730153679848, -0.0064781117253005505, -0.025267429649829865, 0.03652585297822952, 0.020389217883348465, -0.02662920579314232, -0.032425567507743835,
    -0.025289414450526237, 0.035825252532958984, -0.038676727563142776, -0.014272511936724186, 0.05722174793481827, -0.01723865419626236, 0.005746469367295504, -0.04323805496096611,
    0.09221316128969193, 0.05958961695432663, -0.02007303014397621, 0.0014902569819241762, -0.04513593018054962, 0.02078578993678093, 0.020891115069389343, -0.027850961312651634,
    0.006148433778434992, -0.07006968557834625, -0.08063741028308868, -0.019980279728770256, 0.04948095604777336, 0.028845632448792458, 0.026993440464138985, 0.025223763659596443,
    0.0034553101286292076, 0.01503644697368145, 0.07529477030038834, -0.01775454357266426, -0.0061150784604251385, 0.01273131649941206, -0.023735422641038895, 0.009649562649428844,
    -0.03927776217460632, 0.02483847178518772, 0.04280127212405205, -0.023313239216804504, 0.049617648124694824, 0.00383658055216074, 0.03145165368914604, -0.040616054087877274,
    -0.04798072949051857, -0.023204859346151352, -0.043753981590270996, -0.008099675178527832, -0.057936809957027435, -0.04242885485291481, -0.01937706023454666, -0.017926214262843132,
    -0.01176576130092144, 0.06998459994792938, -0.03709060326218605, 0.0400138795375824, -0.03013329952955246, -0.008729830384254456, 0.07069337368011475, -0.09006351232528687,
    -0.011421620845794678, -0.01061661820858717, 0.05561826005578041, 0.03155207633972168, 0.004178997594863176, -0.05643570050597191, 0.03812180086970329, -0.05446569621562958,
    -0.004882389679551125, 0.01953917182981968, -0.12153823673725128, 0.013410564512014389, -0.02841588482260704, -0.0038374713622033596, -0.028815606608986855, 0.004924703389406204,
    -0.04794979467988014, -0.028875555843114853, 0.08204537630081177, 0.004149924032390118, -0.012816188856959343, 0.05736633390188217, 0.0028109033592045307, -0.056977279484272,
    -0.03062032349407673, -0.06110716238617897, 0.023736951872706413, -0.012238412164151669, -0.0035400879569351673, 0.014664657413959503, 0.026101063936948776, 0.01518368162214756,
    -0.0181343462318182, 0.00940078217536211, 0.004369223490357399, -0.01031074021011591, 0.006784126162528992, -0.09678351879119873, -0.005251934751868248, -0.021336784586310387,
    -0.09637566655874252, -0.030459236353635788, 0.0613422729074955, -0.007728669326752424, 0.022456366568803787, 0.0105899041518569, 0.013942910358309746, -0.041539426892995834,
    -0.009496726095676422, -0.003469760762527585, -0.019963903352618217, -0.054623834788799286, 0.052073847502470016, 0.004629319068044424, 0.036743298172950745, -0.011986054480075836,
    0.006584472954273224, 0.028255928307771683, 0.00907989777624607, -0.007354008033871651, -0.017475731670856476, 0.03461423143744469, 0.021750405430793762, 0.005488105583935976,
    0.05732438340783119, -0.014428879134356976, -0.005018912721425295, 0.03763112053275108, -0.019452949985861778, 0.016167500987648964, 0.007253644522279501, 0.0034597977064549923,
    0.004100761376321316, -0.018725313246250153, -0.04051070660352707, 0.009036552160978317, 0.09918505698442459, -0.012397785671055317, 0.001484618871472776, 0.006950628478080034,
    0.06970220804214478, 0.01043104100972414, 0.014494524337351322, -0.00021140986063983291, -0.021542048081755638, 0.02611749805510044, 0.013287699781358242, 0.014090701006352901,
    -0.054646085947752, 0.02768808975815773, -0.09894814342260361, -0.027110841125249863, -0.038100466132164, 0.05373692139983177, 0.02855939418077469, 0.019497573375701904,
    0.04195414111018181, -0.008083909749984741, -0.029590655118227005, -0.02635752037167549, 0.029859261587262154, -0.06018528342247009, -0.025752218440175056, -0.06564533710479736,
    -0.09346291422843933, -0.022398632019758224, -0.0037737556267529726, 0.011234717443585396, -0.07131987810134888, -0.020087955519557, 0.02190975844860077, 0.018085207790136337,
    -0.00210623349994421, 0.024684341624379158, -0.02675287425518036, 0.00823307503014803, -0.0431634820997715, -0.02864382416009903, -0.022401683032512665, 0.059457629919052124,
    0.04057128354907036, 0.03266841545701027, 0.05452407896518707, 0.09499119222164154, -0.024471787735819817, -0.0019392159301787615, -0.0325007401406765, -0.01178787648677826,
    0.020170951262116432, 0.01002014521509409, -0.03225531429052353, -0.04578166455030441, 0.008637966588139534, 0.06084565445780754, -0.04422913119196892, 0.07837177813053131,
    0.029427068307995796, 0.013783575966954231, -0.0747823715209961, 0.024753063917160034, 0.05966709554195404, -0.01569070667028427, 0.03316733241081238, -0.024681532755494118,
    0.025400705635547638, 0.01960728131234646, -0.016243917867541313, 0.02137606590986252, 0.011340096592903137, -0.026213103905320168, -0.009976345114409924, 0.014571295119822025,
    0.021757982671260834, -0.08538065105676651, -0.0003637330955825746, -0.03344227746129036, -0.02514738216996193, -0.03444531559944153, -0.021917017176747322, -0.042260751128196716,
    0.006282778922468424, -0.0074813454411923885, -0.02113659493625164, 0.008063153363764286, -0.019398309290409088, -0.03489185497164726, -0.0029833943117409945, -0.005616005510091782,
    -0.0283285453915596, 0.03691745921969414, 0.05400216206908226, -0.052769314497709274, -0.005310692824423313, -0.019806813448667526, -0.010281482711434364, -0.05189700424671173,
    -0.0036222594790160656, 0.028065139427781105, -0.027693582698702812, 0.038479287177324295, -0.02375752106308937, 0.06286974996328354, -0.01676606386899948, -0.06980636715888977,
    0.011451967060565948, 0.052719924598932266, 0.04491866007447243, 0.038679685443639755, -0.05710308253765106, -0.044707849621772766, -0.024704722687602043, 0.0642046257853508,
    -0.07455329596996307, -0.011987638659775257, 0.03329459950327873, 0.020242564380168915, 0.03395714610815048, -0.06707487255334854, 0.02276434749364853, 0.054079316556453705,
    0.0017818778287619352, 0.028226835653185844, 0.04594894126057625, -0.0019654438365250826, 0.042962633073329926, -0.013097395189106464, 0.07620757073163986, 0.04318913817405701,
    0.02691010944545269, 0.06135474145412445, -0.06448730081319809, -0.07869744300842285, -0.002030047122389078, 0.01534047070890665, 0.02106643281877041, -0.004401104524731636,
    -0.007565597537904978, 0.0239030122756958, -0.05865892395377159, -0.04764838516712189, -0.05482221394777298, 0.06936470419168472, -0.03445356339216232, -0.02477005496621132,
    0.009760331362485886, -0.02687128819525242, 0.010612314566969872, 0.011707663536071777, 0.0286847110837698, 0.028082529082894325, 0.014690936543047428, 0.02057342231273651,
    -0.06538599729537964, 0.04063834995031357, 0.010789561085402966, -0.033754635602235794, 0.02451815828680992, 0.04082423821091652, 0.031976595520973206, -0.04803365468978882,
    0.034773748368024826, -0.0112918047234416, 0.06591494381427765, -0.039287496358156204, -0.0729994848370552, 0.021071864292025566, -0.0038174742367118597, 0.017641546204686165,
    -0.03456109017133713, -0.07033978402614594, 0.006762155331671238, 0.07508769631385803, 0.0351257361471653, -0.004699355456978083, -0.017702847719192505, 0.004188484512269497,
    -0.020821671932935715, -0.05959831923246384, -0.019029801711440086, -0.004953055642545223, 0.0435764417052269, -0.005002384074032307, 0.02172442525625229, -0.0539582185447216,
    0.033327747136354446, 0.01281866803765297, -0.08035877346992493, 0.04749703034758568, -0.011179493740200996, 0.02187594212591648, -0.009312419220805168, 0.0191111508756876,
    -0.05011656507849693, 0.029618222266435623, -0.03613034635782242, -0.0858912542462349, 0.024923881515860558, -0.0819605365395546, -0.017012299969792366, 0.05893157422542572,
    0.047489315271377563, 0.05083803832530975, -0.029393313452601433, -0.06280699372291565, 0.010325836017727852, 0.04132875055074692, 0.06380254775285721, 0.028958069160580635,
    0.12900744378566742, -0.007533854804933071, 0.01848902925848961, -0.03329974785447121, 0.0012522960314527154, 0.03465383127331734, 0.009346661157906055, -0.03445614129304886,
    -0.01669693924486637, 0.043541666120290756, 0.05791861563920975, 0.04529639333486557, 0.0310059804469347, 0.015913162380456924, 0.02442672848701477, 0.058767370879650116,
    0.009845523163676262, -0.02499840408563614, -0.043943002820014954, -0.010698802769184113, -0.050516095012426376, 0.006978039629757404, 0.0008348409901373088, 0.023286251351237297,
    0.020953234285116196, -0.006397311110049486, -0.0026739516761153936, -0.05044782534241676, 0.03301438316702843, -0.03247913718223572, -0.05749943107366562, 0.030151821672916412,
    -0.0032478051725775003, -0.022227628156542778, -0.033939968794584274, -0.015408175066113472, 0.0015868979971855879, 0.018635107204318047, 0.0002968685294035822, -0.02864387072622776,
    -0.004603279754519463, -0.02910793572664261, -0.03822179511189461, -0.019766921177506447, -0.044836271554231644, 0.014982637949287891, 0.05437342822551727, 0.009885545819997787,
    -0.009674835950136185, -0.03855203092098236, 0.038725595921278, -0.012017537839710712, -0.04275887832045555, 0.00900517962872982, 0.003172817872837186, -0.025584381073713303,
    -0.0377102755010128, 0.005706225987523794, 0.10397057980298996, 0.01759289763867855, 0.02312101610004902, -0.003853412112221122, -0.021547598764300346, 0.0314740426838398,
    0.04738021269440651, -0.020160088315606117, -0.049101874232292175, 0.014036133885383606, 0.01327626034617424, -0.043069228529930115, 0.03403252735733986, -0.02082161046564579,
    -0.026274695992469788, -0.0009135779109783471, -0.06639200448989868, 0.038236815482378006, 0.07387285679578781, 0.04069916531443596, 0.025830276310443878, -0.030649881809949875,
    -0.0684647187590599, -0.021541718393564224, 0.07161086052656174, 0.011215762235224247, 0.04228762164711952, -0.02677702158689499, 0.02290312945842743, 0.006251959595829248,
    -0.005983610637485981, 0.053538817912340164, 0.019513241946697235, -0.0023007020354270935, 0.032555583864450455, 0.003804005915299058, -0.04759090766310692, 0.014708777889609337,
    0.05059310048818588, 0.0020089964382350445, -0.007874220609664917, 0.06029534339904785, -0.0124763622879982, -0.06560416519641876, -0.05954331159591675, -0.07779785990715027,
    -0.039396438747644424, -0.046032700687646866, -0.1224861666560173, 0.002634917153045535, -0.022941388189792633, -0.017743626609444618, -0.0025163667742162943, -0.010814031586050987,
    -0.045566242188215256, -0.04162761569023132, -0.014519109390676022, 0.011306767351925373, 0.0028620532248169184, -0.034711290150880814, 0.02632276527583599, -0.06216750293970108,
    -0.004271911922842264, 0.053947143256664276, 0.087077796459198, 0.014464197680354118, 0.010615294799208641, -0.0075015295296907425, 0.0038603944703936577, -0.04338175803422928,
    -0.04066269099712372, 0.05813306197524071, 0.03419600427150726, 0.05975491553544998, -0.014608653262257576, 0.08104217797517776, 0.03606150671839714, -0.0008649147348478436,
    0.004599882289767265, -0.06892836093902588, 0.06450960040092468, -0.060421183705329895, -0.01585853099822998, 7.115279004210606e-05, 0.025753740221261978, 0.027895422652363777,
    -0.012676035985350609, 0.0329434908926487, -0.026583334431052208, -0.014066671952605247, -0.0037252933252602816, -0.03481991961598396, 0.030251704156398773, 0.04103140905499458,
    0.012457608245313168, -0.03740135580301285, -0.016123061999678612, -0.004092732910066843, -3.906474375980906e-05, -0.06808125227689743, 0.03083285316824913, 0.06741943210363388,
    0.02269785664975643, 0.014888656325638294, -0.008477870374917984, -0.004386468790471554, 0.001221829792484641, -0.019546356052160263, -0.0102385263890028, 0.028146469965577126,
    -0.0077040730975568295, -0.017525041475892067, -0.02033250406384468, 0.008839785121381283, -0.02136123925447464, -0.02157430350780487, -0.02863462083041668, 0.0006960245664231479,
    0.03756760433316231, -0.0010572075843811035, -0.023059552535414696, 0.011698241345584393, -0.036763377487659454, -0.03195562958717346, -0.027149079367518425, 0.03557346388697624,
    -0.03833526372909546, -0.045526325702667236, 0.13658097386360168, -0.08456161618232727, -0.03648429736495018, -0.04289062321186066, 0.002376255579292774, 0.06570674479007721,
    0.03485089913010597, 0.021060053259134293, -0.02710733562707901, 0.009909259155392647, -0.0412621833384037, 0.023335358127951622, 0.05159304663538933, 0.07429471611976624,
    -0.07334194332361221, -0.014032219536602497, -0.04941502958536148, -0.038864199072122574, 0.021925315260887146, -0.01707218401134014, -0.0022345553152263165, 0.06025927886366844,
    0.03623378649353981, 0.04779716581106186, 0.029099393635988235, -0.007441992871463299, 0.007921225391328335, -0.07817522436380386, -0.06910894066095352, -0.12476533651351929,
    0.02832454815506935, 0.041110679507255554, -0.031005611643195152, -0.02581305429339409, 0.024410981684923172, 0.04488570615649223, -0.010482724756002426, -4.929462738800794e-05,
    -0.04706272482872009, -0.004609102848917246, -0.004464919678866863, 0.02114102616906166, 0.023002425208687782, -0.02692517638206482, 0.03838983178138733, 0.04674927145242691,
    -0.008684108965098858, -0.0452689453959465, -0.0660262256860733, 0.04562310874462128, 0.021126115694642067, -0.03637394309043884, -0.06167786195874214, -0.054233744740486145,
    -0.009482665918767452, 0.0057816533371806145, 0.024912960827350616, 0.07267042994499207, 0.01315267849713564, -0.08378075063228607, 0.08511756360530853, 0.03817354887723923,
    0.011778702959418297, -0.04481039196252823, -0.018389645963907242, 0.017838716506958008, 0.013634636066854, -0.002865355461835861, 0.012452530674636364, -0.05926990881562233,
    0.018142743036150932, 0.09629595279693604, -0.009587953798472881, 0.030266480520367622, 0.019028037786483765, -0.025613263249397278, 0.027158992365002632, -0.0199655182659626,
    -0.02212740294635296, 0.07009448111057281, 0.07867015898227692, 0.04020913690328598, 0.03606031835079193, 0.001461500534787774, 0.05486653372645378, -0.048715438693761826,
    0.02969294786453247, -0.05058160424232483, -0.03777625784277916, 0.039133474230766296, 0.012237906455993652, 0.016249094158411026, -0.019129179418087006, -0.027832070365548134,
    -0.03203810006380081, -0.015858493745326996, -0.0047323815524578094, -0.04543257877230644, 0.06798750907182693, -0.026266783475875854, 0.004055860918015242, -0.05581628531217575,
    -0.07460107654333115, -0.02257341891527176, 0.05519628897309303, 0.0338970422744751, -0.02706814371049404, -0.004615321289747953, 0.00012769989552907646, 0.017547601833939552,
    -0.021354299038648605, 0.08485565334558487, 0.03202483803033829, -0.018958978354930878, 0.007432551123201847, -0.04146287590265274, -0.034151189029216766, 0.018655406311154366,
    0.028263431042432785, -0.06703663617372513, -0.028137600049376488, 0.01378538552671671, -0.015388371422886848, 0.04251246899366379, -0.0021129779051989317, -0.022697970271110535,
    0.015359317883849144, 0.027294324710965157, -0.02520866133272648, -0.007391311693936586, 0.006322251632809639, 0.008281436748802662, -0.004008968360722065, -0.008298858068883419,
    0.010054070502519608, -0.034798864275217056, 0.044847190380096436, 0.02097763679921627, 0.01796797662973404, -0.000609569950029254, -0.04040909558534622, -0.04025883227586746,
    -0.05747957155108452, 0.005648972932249308, 0.011098118498921394, -0.01935761235654354, -0.030611496418714523, 0.07112627476453781, 0.002992388093844056, 0.008591873571276665,
    0.030763989314436913, 0.035690031945705414, -0.0026242961175739765, 0.016740743070840836, 0.018211880698800087, 0.09132390469312668, -0.09738713502883911, -0.029290495440363884,
    0.019048631191253662, -0.01457824558019638, 0.02041289024055004, 0.035823430866003036, -0.02136792242527008, -0.04046104848384857, 0.07700546085834503, -0.05997352674603462,
    0.018395474180579185, 0.027366040274500847, -0.06790567189455032, -0.039468683302402496, 0.022517476230859756, -0.010801274329423904, 0.02159717120230198, -0.005744225345551968,
    -0.003785137552767992, 0.03358649089932442, -0.03868994489312172, 0.06216106563806534, 0.011692327447235584, 0.02465277910232544, 0.0005325606325641274, 0.02906619943678379,
    0.014795398339629173, 0.016445333138108253, -0.047939226031303406, 0.007024054415524006, 0.024267133325338364, -0.044857241213321686, 0.033184874802827835, 0.008632956072688103,
    0.10891050845384598, 0.0007056858739815652, 0.06887944787740707, -0.03849179670214653, 0.04290320724248886, 0.010659150779247284, 0.09702982008457184, -0.015945013612508774,
    -0.012010853737592697, -0.005832246039062738, -0.10723449289798737, -0.02437179908156395, -0.011989390477538109, 0.017204733565449715, -0.024148857221007347, 0.07574332505464554,
    0.013272360898554325, -0.04395843297243118, 0.014438431710004807, 0.006340821739286184, 0.01838827319443226, -0.03831198439002037, -0.02234875038266182, 0.12085295468568802,
    0.026524312794208527, 0.08437952399253845, 0.0275060273706913, -0.028585271909832954, -0.059998247772455215, -0.02447119541466236, 0.06375838071107864, -0.03945966809988022,
    0.020370757207274437, 0.018444400280714035, 0.00444968044757843, -0.008120881393551826, -0.02254245989024639, 0.02104300633072853, 0.038082148879766464, -0.03934292122721672,
    0.034665174782276154, -0.039000242948532104, 0.03460622951388359, -0.04932943359017372, -0.033188652247190475, 0.010056156665086746, 0.010846870020031929, 0.02095845155417919,
    -0.008038205094635487, 0.08074942231178284, 0.047987259924411774, -0.016156207770109177, -0.003046249272301793, 0.04502825811505318, -0.07752663642168045, 0.02104218676686287,
    0.07394079118967056, 0.06336051970720291, 0.024382198229432106, -0.0226560290902853, -0.010833748616278172, 0.041217248886823654, -0.03158409893512726, -0.05384840443730354,
    -0.029903210699558258, -0.017541855573654175, -0.07425505667924881, 0.008714765310287476, -0.003072298364713788, 0.015718648210167885, 0.0022698778193444014, -0.1287868618965149,
    -0.03764966502785683, -0.015431815758347511, -0.022329766303300858, -0.024723278358578682, 0.011425109580159187, -0.06019970774650574, -0.0023239958100020885, 0.055377449840307236,
    0.020293598994612694, -0.02271936647593975, 0.026419619098305702, -0.016513008624315262, -0.051169246435165405, 0.014865751378238201, 0.008705873973667622, 0.0709342435002327,
    -0.03389866650104523, 0.0502588152885437, 0.04366332292556763, -0.019555874168872833, -0.04154064133763313, 0.024573901668190956, 0.013493862934410572, -0.007696338463574648,
    -0.00763736804947257, -0.02487092837691307, 0.015459992922842503, 0.06629517674446106, 0.03187483176589012, 0.022463351488113403, -0.03565574064850807, 0.04841732978820801,
    -0.00362063548527658, 0.06584685295820236, -0.03811774030327797, 0.025067631155252457, 0.024604029953479767, 0.038635216653347015, -0.035397157073020935, 0.00858659390360117,
    -0.010548134334385395, 0.08841855823993683, -0.016122082248330116, 0.07965228706598282, 0.0024436605162918568, -0.025362098589539528, -0.034625325351953506, -0.018395451828837395,
    -0.012633373960852623, -0.023516938090324402, 0.012079278938472271, 0.004527949262410402, 0.059265606105327606, 0.05016789212822914, -0.02760789543390274, 0.030331768095493317,
    -0.09095548838376999, 0.02475278079509735, -0.08635760843753815, 0.05694110691547394, 0.05776309594511986, -0.013968243263661861, -0.07914970070123672, -0.005185406655073166,
    0.010435794480144978, -0.06612202525138855, 0.06452032923698425, -0.03165679797530174, 0.007018160540610552, 0.011825339868664742, -0.005081850104033947, 0.022994929924607277,
    -0.03783411905169487, -0.03661121800541878, 0.015737220644950867, 0.03668799623847008, 0.009076597169041634, -0.021499985828995705, -0.047685761004686356, 0.06090210750699043,
    0.05963911488652229, -0.09699815511703491, 0.0668688416481018, -0.02412099950015545, -0.02282310277223587, 0.0030215561855584383, 0.08353407680988312, 0.05465753749012947,
    -0.0034844479523599148, 0.07427937537431717, -0.05252498388290405, 0.0020527278538793325, -0.04037468135356903, -0.024157647043466568, -0.007337779272347689, 0.002159949392080307,
    0.040313951671123505, 0.019440457224845886, 0.027421606704592705, -0.013194331899285316, 0.0023081013932824135, -0.02067684754729271, -0.032646626234054565, 0.12122887372970581,
    -0.016389600932598114, -0.042803529649972916, 0.02406684309244156, -0.012103834189474583, -0.05250471085309982, -0.04171299934387207, 0.034507133066654205, 0.03512909635901451,
    -0.04598883539438248, -0.013842829503118992, -0.05209120735526085, -0.004558349959552288, 0.025183314457535744, 0.01567899063229561, 0.008641027845442295, 0.0008155989344231784,
    -0.009989859536290169, 0.019158529117703438, 0.0007004659273661673, 0.0302147027105093, -0.0685499832034111, 0.011149062775075436, 0.027622532099485397, -0.017295798286795616,
    0.021813111379742622, 0.009681406430900097, 0.014517583884298801, 0.045325569808483124, -0.04701078310608864, 0.010683870874345303, -0.0069456640630960464, 0.08898336440324783,
    0.05065041035413742, 0.01195430476218462, 0.03097161464393139, 0.043392885476350784, 0.029242688789963722, -0.012404220178723335, 0.004631087649613619, -0.012723732739686966,
    -0.027109453454613686, 0.037027690559625626, 0.03414449095726013, 0.012684282846748829, -0.0006388371111825109, -0.0101283248513937, 0.01267134677618742, 0.10713066160678864,
    0.009811118245124817, 0.03823531046509743, -0.09293319284915924, -0.039689160883426666, -0.029269155114889145, 0.01212697010487318, 0.04574470594525337, -0.003183455904945731,
    0.07272961735725403, 0.0328640416264534, -0.034065183252096176, 0.06255758553743362, 0.08816903829574585, -0.018778156489133835, -0.03292419761419296, 0.03451690822839737,
    0.034550487995147705, 0.023153377696871758, -0.0041511510498821735, 0.02296219952404499, -0.01953067071735859, 0.006546646822243929, 0.029739568009972572, -0.014690489508211613,
    0.014711791649460793, -0.03408282995223999, -0.05860158056020737, 0.0322347953915596, -0.05075710639357567, -0.012270561419427395, -0.03215953707695007, -0.0018616614397615194,
    -0.1456969529390335, 0.08482740819454193, -0.057943277060985565, 0.05589227378368378, -0.028782805427908897, 0.003930801525712013, -0.014055927284061909, 0.014299750328063965,
    0.07018911093473434, 0.04771236702799797, -0.08906713128089905, -0.026338404044508934, -0.08890540897846222, -0.01027325727045536, 0.04719145968556404, -0.010013536550104618,
    0.009382471442222595, -0.03094126097857952, 0.011848500929772854, -0.12026622146368027, -0.019967341795563698, -0.02985956147313118, 0.016878953203558922, 0.0569755882024765,
    0.07428287714719772, 0.10772742331027985, 0.011600732803344727, -0.007946239784359932, 0.03532648831605911, -0.008806129917502403, -0.005362495314329863, -0.0057786800898611546,
    0.02506585419178009, 0.018395045772194862, 0.05161875858902931, -0.06953795999288559, 0.028996387496590614, -0.0035920918453484774, 0.05254350230097771, -0.015546048060059547,
    -0.006999445613473654, -0.007510222494602203, -0.025868861004710197, -0.010805808007717133, -0.033551499247550964, -0.021749945357441902, -0.08360686898231506, -0.029233558103442192,
    -0.007026112638413906, 0.03218095749616623, -0.00412506191059947, 0.03413103520870209, -0.011487431824207306, -0.019193390384316444, 0.06606608629226685, 0.022829139605164528,
    0.017753276973962784, 0.003115772269666195, 0.05641555413603783, -0.012258417904376984, 0.07640880346298218, -0.0026378349866718054, 0.058271877467632294, -0.02941187471151352,
    -0.013862532563507557, 0.05625380203127861, 0.10125289857387543, 0.07314455509185791, -0.012369838543236256, 0.03205162659287453, -0.03559695556759834, 0.07214217633008957,
    -0.03469911590218544, -0.014957974664866924, 0.06418442726135254, -0.014547458849847317, -0.03438139334321022, -0.0018602494383230805, 0.0731927901506424, 0.022256720811128616,
    -0.007747291587293148, -0.01495503168553114, 0.00019064579100813717, 0.07819708436727524, -0.002100511686876416, 0.02701723203063011, 0.03797973319888115, 9.721390961203724e-05,
    -0.029166262596845627, 0.025104299187660217, 0.05077393725514412, -0.037057988345623016, -0.02459130808711052, 0.0008175494149327278, -0.07424619793891907, -0.030246028676629066,
    -0.0011755600571632385, 0.016689611598849297, -0.06702739000320435, 0.050073400139808655, -0.046403780579566956, -0.026270389556884766, 0.022205611690878868, 0.039527129381895065,
    -0.03651393949985504, -0.0015046843327581882, -0.002947750501334667, -0.02065443992614746, 0.020764727145433426, -0.0014439092483371496, -0.053528301417827606, -0.003815446514636278,
    -0.06563255190849304, -0.02219703607261181, 0.007489928510040045, -0.06356099247932434, 0.027850650250911713, -0.038952477276325226, -0.1193389892578125, 0.024134691804647446,
    0.029853975400328636, 0.06878715753555298, 0.034010615199804306, -0.030221525579690933, -0.06520409882068634, 0.042052216827869415, -0.02197256125509739, 0.1006927415728569,
    0.030333347618579865, -0.03039194643497467, -0.006379132159054279, -0.0007915674359537661, 0.04731035977602005, 0.006723857019096613, 0.012388912960886955, -0.026522196829319,
    0.01950494945049286, 0.03453468903899193, 0.009022683836519718, 0.043495215475559235, -0.009604138322174549, -0.0182116087526083, -0.029079115018248558, -0.01846458576619625,
    0.007394046522676945, 0.0480307899415493, -0.009674894623458385, 0.01788804680109024, -0.05070175230503082, 0.07536955177783966, -0.021416667848825455, -0.025826208293437958,
    0.02845882624387741, -0.08282524347305298, -0.0003132381825707853, 0.003835761221125722, 0.05605212599039078, -0.048115525394678116, -0.015384551137685776, -0.06903431564569473,
    -0.006930812261998653, 0.048058923333883286, 0.016334332525730133, -0.06736164540052414, -0.03398425132036209, 0.11028256267309189, 0.0011311032576486468, 0.03342986851930618,
    -0.017411168664693832, -0.026237545534968376, 0.06467467546463013, 0.036604125052690506, -0.024940751492977142, 0.06183197349309921, -0.059735339134931564, -0.09992077201604843,
    0.011311703361570835, -0.008279895409941673, -0.01666523702442646, 0.00727064348757267, 0.0412268340587616, 0.03981226310133934, 0.04033791646361351, 0.016084611415863037,
    0.038757145404815674, -0.0974474623799324, -0.06161247938871384, -0.04029611870646477, -0.016293318942189217, 0.0070219081826508045, -0.012585383839905262, -0.0546993687748909,
    0.022373903542757034, 0.057212699204683304, 0.026750802993774414, -0.0035889639984816313, 0.035167593508958817, -0.004784037824720144, -0.03855083882808685, -0.08571991324424744,
    -0.029796535149216652, -0.021018244326114655, 0.020015500485897064, -0.004121087025851011, -0.053668130189180374, -0.10278120636940002, 0.012577224522829056, 0.02094547264277935,
    -0.057556260377168655, -0.010542849078774452, -0.007687089033424854, 0.04440654441714287, 0.011124975979328156, -0.019511252641677856, 0.018775982782244682, 0.057791389524936676,
    0.03747861087322235, 0.007465912960469723, 0.03239050880074501, 0.030121589079499245, 0.034189339727163315, -0.06998170912265778, -0.0056579262018203735, -0.10933759808540344,
    -0.0009959775488823652, 0.051169104874134064, -0.0615694522857666, 0.030115654692053795, 0.003545185783877969, 0.013711362145841122, -0.04134457930922508, -0.008766969665884972,
    0.0014614082174375653, 0.04212189093232155, -0.022586505860090256, 0.03966893255710602, -0.010165552608668804, 0.016163352876901627, -0.062185175716876984, -0.00936796423047781,
    0.03637685626745224, 0.010740266181528568, 0.04074488952755928, 0.09697241336107254, -0.00032439830829389393, 0.002968329004943371, -0.07457010447978973, 0.010412856936454773,
    0.07980284094810486, -0.03039252944290638, -0.10266224294900894, 0.026554016396403313, 0.03101273439824581, 0.08293437212705612, 0.05990555137395859, 0.02219446189701557,
    0.03526241332292557, 0.007784793619066477, -0.09814692288637161, 0.07360357791185379, 0.010410741902887821, -0.004070593509823084, 0.010452860966324806, -0.00036532492958940566,
    -0.029917346313595772, 0.04374797269701958, 0.06250932067632675, 0.00984979048371315, 0.0241786390542984, -0.01445162296295166, -0.017306143417954445, 0.030885454267263412,
    0.011645500548183918, 0.07390473783016205, 0.06680060923099518, -0.09809485822916031, 0.05331989750266075, -0.03698878735303879, 0.020701350644230843, -0.060281384736299515,
    0.00962449423968792, 0.07864115387201309, 0.03640545904636383, 0.02978767268359661, 0.05259294807910919, -0.02096792310476303, -0.043762288987636566, 0.005315432790666819,
    -0.03939351812005043, -0.11900003999471664, 0.017720816656947136, 0.031102601438760757, -0.028397751972079277, -0.04824790358543396, -0.04370001703500748, 0.0206659734249115,
    0.08654956519603729, 0.025454893708229065, 0.006122202146798372, -0.0076418123207986355, -0.055313143879175186, -0.038847874850034714, -0.03387168049812317, 0.0007122824899852276,
    0.007554813753813505, -0.010255263186991215, 0.01259309146553278, -0.010331043973565102, 0.011792468838393688, -0.05813862755894661, -0.0629594549536705, 0.07104510813951492,
    -0.0028163697570562363, 0.011789103038609028, 0.013908778317272663, -0.011763661168515682, -0.0037670100573450327, -0.05621420592069626, -0.01946180872619152, -0.0364484004676342,
    -0.04424738883972168, -0.013950363732874393, -0.013292266987264156, -0.021341541782021523, -0.03063063509762287, -0.08879586309194565, 0.04286781698465347, -0.10469727963209152,
    0.016444098204374313, 0.01476833876222372, -0.00299576367251575, 0.0015700424555689096, -0.012668786570429802, 0.1018451526761055, 0.03257005661725998, -0.023358236998319626,
    -0.013192705810070038, -0.02705456130206585, 0.023431852459907532, -0.01409821305423975, -0.025716720148921013, -0.013294276781380177, 0.05712289735674858, -0.04309168830513954,
    -0.004473049659281969, 0.013871025294065475, -0.005505038890987635, 0.017239786684513092, -0.05030285194516182, -0.020572038367390633, 0.017190242186188698, 0.03675703704357147,
    -0.019640304148197174, -0.030781051144003868, 0.08619076013565063, 0.01115094032138586, 0.032582491636276245, 0.027288878336548805, 0.019177565351128578, -0.006118683610111475,
    -0.04011969640851021, 0.01671075075864792, -0.035360731184482574, 0.06099385395646095, 0.0726567730307579, 0.08268566429615021, 0.07798639684915543, -0.04429737105965614,
    -0.1269548088312149, 0.0358390212059021, -0.022167647257447243, -0.04592948779463768, 0.0408538319170475, 0.01576611027121544, -0.022097522392868996, -0.04095549136400223,
    -0.0066552129574120045, 0.0006925452616997063, 0.011864127591252327, -0.032958488911390305, 0.0378480963408947, -0.0018764183623716235, 0.08548469096422195, -0.11821835488080978,
    -0.04316536709666252, 0.07842718064785004, 0.030638011172413826, 0.01545245386660099, 0.019092390313744545, -0.0331636443734169, 0.0557708665728569, 0.048260293900966644,
    -0.00871492549777031, 0.05524088069796562, -0.07719498127698898, 0.019584951922297478, -0.007135843392461538, 0.03259601071476936, -0.03679722920060158, 0.004920950159430504,
    0.01615140028297901, -0.01844344660639763, -0.015390751883387566, -0.04571286588907242, 0.02102019265294075, 0.06302905082702637, -0.004162514582276344, -0.005485448986291885,
    0.007440523710101843, -0.03787270560860634, -0.08463668823242188, -0.002395578660070896, 0.05891359969973564, 0.0005446801078505814, -0.02444532886147499, -0.017358865588903427,
    0.033463314175605774, 0.00966144260019064, -0.06021350249648094, 0.04224319010972977, 0.06391658633947372, -0.08990027010440826, -0.012139989994466305, -0.028140313923358917,
    -0.032505493611097336, -0.0627126693725586, 0.0025894625578075647, -0.016491517424583435, -0.035219594836235046, -0.01655690185725689, -0.04424561932682991, 0.06751453876495361,
    -0.0628095418214798, -0.11618609726428986, 0.07432422041893005, 0.017244558781385422, 0.011801335960626602, 0.035122599452733994, 0.010395141318440437, 0.034667517989873886,
    -0.017758889123797417, 0.04045937582850456, 0.031728699803352356, 0.0064476607367396355, 0.009781228378415108, -0.0008518079994246364, -0.01350394543260336, 0.02615009807050228,
    -0.033219851553440094, -0.020265409722924232, -0.021392570808529854, -0.030389532446861267, -0.0024377924855798483, 0.006717763375490904, -0.03515048325061798, 0.022905508056282997,
    -0.05063414201140404, -0.026985809206962585, 0.01999267376959324, 0.02690417505800724, 0.0029974018689244986, -0.03289645537734032, 0.008499129675328732, -0.01047876849770546,
    0.0710761547088623, -0.010589241981506348, 0.01817832887172699, 0.013704690150916576, 0.022298693656921387, -0.0017906113062053919, -0.02124326303601265, -0.04867429658770561,
    -0.08787613362073898, -0.0019958617631345987, 0.009631468914449215, -0.027116138488054276, 0.052546169608831406, 0.0220499187707901, -0.065202496945858, 0.06966692209243774,
    -0.015036225318908691, -0.13671013712882996, -0.04029792174696922, -0.01897968165576458, 0.02491948753595352, -0.014170954935252666, -0.014716872945427895, -0.0716799944639206,
    -0.007076668087393045, 0.02325528673827648, 0.012512503191828728, 0.025201398879289627, 0.025698410347104073, -0.007820592261850834, 0.1396675705909729, 0.054325006902217865,
    -0.10094089806079865, -0.05920613184571266, -0.0002067887398879975, -0.05135516822338104, -0.001784430118277669, 0.023527538403868675, -0.023983772844076157, -0.00604160176590085,
    0.008176248520612717, 0.018905557692050934, 0.06845708191394806, -0.03460947051644325, 0.026245327666401863, -0.05747583508491516, -0.05023687705397606, 0.04545840248465538,
    -0.029575206339359283, 0.04502078518271446, -0.046316467225551605, 0.032818831503391266, 0.04165895655751228, 0.06148607283830643, 0.01634587161242962, -0.04234277456998825,
    0.02556859701871872, -0.05558475852012634, -0.010609269142150879, 0.011569557711482048, 0.00849067885428667, 0.07551451772451401, 0.10374068468809128, 0.021801786497235298,
    0.015030238777399063, -0.06456970423460007, 0.07169467210769653, -0.0756143108010292, 0.0490187406539917, 0.00046801858115941286, 0.03427411615848541, -0.09220577031373978,
    -0.03865845501422882, -0.0026306170038878918, -0.0419042743742466, 0.04192836582660675, 0.029160212725400925, 0.031255658715963364, 0.057944294065237045, -0.04711785539984703,
    0.018096037209033966, -0.008311252109706402, -0.03354189917445183, -0.03406106308102608, 0.02553286962211132, -0.019762111827731133, 0.0161430761218071, 0.04804039001464844,
    -0.009309154003858566, -0.031161367893218994, -0.04799770191311836, 0.02484000287950039, 0.018071090802550316, 0.03930676728487015, -0.01544894091784954, -0.03547663241624832,
    0.059450529515743256, -0.006981315556913614, 0.095160111784935, 0.010996930301189423, 0.004465817008167505, -0.056793928146362305, 0.02459702640771866, -0.0742531344294548,
    0.10094927251338959, -0.06259860098361969, -0.052731774747371674, -0.05954653024673462, 0.0019185957498848438, 0.052388835698366165, 0.011909948661923409, 0.07221751660108566,
    -0.02714715339243412, 0.00026304475613869727, 0.0449717752635479, -0.036651089787483215, -0.02632272243499756, -0.02028394676744938, 0.015609118156135082, 0.03583439439535141,
    0.025517860427498817, 0.015889184549450874, -0.057288624346256256, 0.01591217704117298, -0.024678388610482216, -0.03606531396508217, -0.040325701236724854, 0.1256144493818283,
    0.04292396456003189, -0.0023129964247345924, -0.027828192338347435, -0.012971281073987484, 0.03376251086592674, 0.010530815459787846, 0.0013671581400558352, -0.005613130982965231,
    0.052991367876529694, 0.06756162643432617, -0.058356087654829025, 0.03694317862391472, 0.05063221603631973, -0.0560421422123909, 0.07755084335803986, -0.1413179337978363,
    0.038806527853012085, 0.05266439542174339, -0.007023878861218691, -0.03723900020122528, 0.0029824061784893274, -0.005030639469623566, 0.03412003442645073, -0.007860526442527771,
    0.06639692187309265, -0.011304283514618874, 0.0074842460453510284, 0.09883951395750046, -0.02226465567946434, 0.04225913807749748, 0.027806513011455536, -0.004818146117031574,
    0.11064451932907104, -0.0306868813931942, -0.020326368510723114, 0.06437086313962936, -0.04723503440618515, 0.0007014652946963906, 0.021907076239585876, 0.013305151835083961,
    0.08716309815645218, 0.03388235718011856, -0.04968227446079254, 0.05875061824917793, 0.03141142055392265, -0.0014819017378613353, -0.08993670344352722, 0.05434216186404228,
    0.07143721729516983, 0.0029514923226088285, 0.023313937708735466, -0.008221223019063473, 0.026474134996533394, -0.05944817513227463, 0.015824783593416214, -0.013495389372110367,
    0.014434152282774448, -0.014543049968779087, 0.045763082802295685, -0.0016648794990032911, 0.05305132642388344, -0.012732048518955708, 0.07259353995323181, 0.049799736589193344,
    0.020287835970520973, 0.03490535914897919, 0.008081493899226189, 0.04754212498664856, -0.007815134711563587, 0.02008816786110401, 0.033113155514001846, -0.03489415720105171,
    -0.02121739834547043, 0.03286152333021164, -0.02362067624926567, 0.04023800045251846, -0.009404576383531094, 0.025042789056897163, -0.013332508504390717, 0.015401295386254787,
    -0.010424161329865456, -0.02532048337161541, 0.051566172391176224, -0.0088732885196805, 0.0075496165081858635, 0.0852711945772171, 0.0649493858218193, 0.010973166674375534,
    0.06281468272209167, 0.05308854579925537, -0.0038061924278736115, 0.03726327046751976, -0.089046411216259, 0.03271615505218506, -0.015931319445371628, -0.023009097203612328,
    0.0034235953353345394, 0.08774405717849731, -0.05543535575270653, -0.0006006733165122569, -0.006857624743133783, 0.041840001940727234, -0.04802180454134941, -0.05875978618860245,
    -0.0015464253956452012, -0.04555557295680046, 0.07485032081604004, 0.021233413368463516, 0.0169278085231781, 0.051969412714242935, 0.028865279629826546, -0.07890255749225616,
    0.010175338014960289, -0.0759083554148674, 0.005170498974621296, 0.012086481787264347, 0.029717890545725822, -0.10710585117340088, -0.03337591513991356, -0.06448274105787277,
    0.06481954455375671, -0.029016995802521706, -0.02623121440410614, -0.032974716275930405, 0.03241279348731041, -0.022581301629543304, -0.02743605524301529, 0.009813837707042694,
    0.008747286163270473, 0.015537122264504433, 0.01368509791791439, 0.06348717212677002, 0.031618449836969376, -0.03838442265987396, 0.020425304770469666, -0.04512987285852432,
    0.027654433622956276, 0.07540850341320038, -0.04684643819928169, -0.034831419587135315, -0.21543438732624054, -0.10145260393619537, 0.09075252711772919, -0.07263834029436111,
    -0.025026971474289894, 0.07233910262584686, -0.023713184520602226, 0.019096536561846733, 0.03760490566492081, 0.012071551755070686, -0.0063368091359734535, 0.11062823981046677,
    -0.06324678659439087, 0.009811596013605595, -0.0622892864048481, 0.06668654084205627, -0.009061794728040695, 0.06249893084168434, 0.0450868085026741, 0.028223739936947823,
    0.015107888728380203, 0.009510020725429058, -0.0370296873152256, -0.07261116802692413, -0.06975318491458893, -0.008908350020647049, -0.035601358860731125, 0.018441684544086456,
    0.05482350289821625, -0.043505068868398666, 0.01728239841759205, 0.041949741542339325, -0.014363021589815617, 0.04822755977511406, 0.04634680598974228, 0.033800628036260605,
    0.10012245923280716, -0.009385810233652592, 0.04119456931948662, 0.023783206939697266, 0.04506397247314453, 0.001867708284407854, 0.04258796572685242, -0.060246650129556656,
    -0.09801739454269409, -0.027523864060640335, -0.061193060129880905, 0.023747241124510765, 0.05337848886847496, -0.07707088440656662, 0.0685422420501709, -0.005377728492021561,
    0.05140170082449913, 0.019501904025673866, -0.023590410128235817, 0.0749758780002594, -0.011566896922886372, -0.059898268431425095, -0.02682974934577942, -0.005475070793181658,
    0.01289315428584814, -0.07386774569749832, -0.055356673896312714, 0.05563089996576309, 0.10422497987747192, 0.016685768961906433, -0.031381286680698395, 0.06035037711262703,
    -0.0015607646200805902, 0.011152195744216442, 0.016369033604860306, -0.0020346709061414003, 0.04873565584421158, 0.026291918009519577, 0.02120826579630375, -0.006994777359068394,
    0.011926550418138504, -0.044862017035484314, 0.00012535580026451498, 0.013765032403171062, 0.018678590655326843, -0.038205210119485855, -0.07527180761098862, -0.04229605197906494,
    -0.07841585576534271, -0.05362002179026604, 0.028746049851179123, 0.010151281021535397, 0.04562114551663399, -0.019862178713083267, 0.0076847197487950325, -0.04146936163306236,
    -0.08944429457187653, 0.06213852018117905, -0.06487864255905151, 0.014339404180645943, 0.022052833810448647, 0.02802802249789238, -0.0030192737467586994, -0.0838959813117981,
    -0.04554705694317818, -0.00794142484664917, -0.02827702835202217, -0.07955054938793182, 0.01901552639901638, 0.0061760395765304565, 0.038455717265605927, -0.00674095144495368,
    0.029665298759937286, 0.0108804851770401, 0.010132167488336563, 0.006858870852738619, 0.08330148458480835, -0.016409041360020638, 0.0493851862847805, -0.04801574721932411,
    0.026470709592103958, -0.007491869851946831, -0.013861585408449173, 0.07009249925613403, -0.0020141059067100286, 0.029334232211112976, 0.01562667079269886, 0.040864791721105576,
    -0.07906210422515869, 0.033969517797231674, -0.0033056940883398056, 0.046094171702861786, -0.008515150286257267, 0.04502198100090027, 0.02386338636279106, 0.08974163234233856,
    -0.039101965725421906, -0.009428485296666622, -0.013908813707530499, 0.005204563494771719, 0.04294244199991226, 0.025289563462138176, 0.043062277138233185, -0.06810307502746582,
    0.01954687386751175, -0.004245970398187637, -0.019601916894316673, -0.0800013616681099, -0.007033197674900293, -0.06359687447547913, 0.0668373554944992, 0.03638618439435959,
    0.05078272521495819, 0.046041153371334076, 0.02946210838854313, 0.0010629898170009255, 0.00962782185524702, 0.01704998128116131, -0.011794617399573326, 0.018491286784410477,
    0.002549553755670786, -0.05861794948577881, 0.007411240134388208, -0.010289663448929787, 0.004789580125361681, -0.011512571945786476, 0.03060917556285858, -0.004862605128437281,
    0.012642514891922474, 0.11985333263874054, 0.004165214020758867, 0.02227178029716015, -0.00856588315218687, 0.08856846392154694, 0.11188948899507523, -0.018420575186610222,
    -0.032662492245435715, 0.01314261369407177, -0.03768240287899971, 0.023158490657806396, -0.05895041674375534, -0.03918028622865677, 0.09585192799568176, -0.07565562427043915,
    -0.025543518364429474, 0.05434799939393997, 0.0676041841506958, 0.037167586386203766, 0.055232223123311996, 0.0005015064962208271, -0.03880742937326431, -0.05242973938584328,
    0.11402710527181625, 0.10346729308366776, 0.007522112689912319, -0.0005232077674008906, 0.04080093279480934, -0.017721541225910187, 0.0244448184967041, -0.01706463098526001,
    -0.008189065381884575, 0.005669580306857824, -0.03813288360834122, -0.03145866468548775, 0.0185580775141716, -0.0320892408490181, 0.0766354575753212, 0.028956960886716843,
    -0.060541462153196335, -0.0311579667031765, 0.048904262483119965, -0.016426490619778633, 0.08359694480895996, 0.025617562234401703, 0.031486090272665024, 0.07339140772819519,
    0.0784757137298584, -0.03361586481332779, 0.10279792547225952, 0.013152139261364937, -0.01737634465098381, -0.008508705534040928, -0.01975877210497856, -0.0607009083032608,
    0.0840330421924591, -0.014738728292286396, 0.02704080380499363, -0.04585184156894684, -0.07457524538040161, 0.07685311138629913, -0.031464334577322006, 0.04028414189815521,
    0.038749802857637405, 0.02991296537220478, -0.016120702028274536, -0.008131024427711964, 0.005459367297589779, 0.09355663508176804, 0.001344044809229672, 0.054461438208818436,
    -0.05223739147186279, 0.013884113170206547, 0.05311151221394539, -0.021412476897239685, -0.06783317774534225, 0.01068213488906622, 0.07111136615276337, 0.10246530175209045,
    0.05453399941325188, 0.03737090528011322, -0.022661931812763214, 0.04052184149622917, 0.009248857386410236, 0.03640919551253319, -0.07452138513326645, -0.059827856719493866,
    0.006050328258424997, 0.06000261381268501, -0.03743951395153999, -0.034380294382572174, 0.02193787321448326, -0.05984650179743767, -0.026371678337454796, -0.017227835953235626,
    0.0016293516382575035, -0.0027872801292687654, 0.048064105212688446, 0.08696768432855606, 0.012888655066490173, -0.036497049033641815, -0.010822893120348454, -0.005014493130147457,
    0.09115663170814514, 0.05697079747915268, -0.02917402796447277, -0.009254547767341137, -0.025485292077064514, 0.01118343137204647, -0.024124814197421074, 0.08034725487232208,
    -0.054439567029476166, 0.055940333753824234, 0.04039758816361427, 0.02742099203169346, 0.06494468450546265, -0.048519209027290344, 0.012138842605054379, 0.01436579693108797,
    0.01864156499505043, 0.01082430500537157, -0.009054162539541721, -0.013062709011137486, 0.055340830236673355, 0.09141304343938828, -0.008248469792306423, 0.10972122102975845,
    -0.11256803572177887, 0.031151380389928818, -0.017407283186912537, 0.07047077268362045, -0.042377691715955734, -0.03368005156517029, -0.08225662261247635, -0.03100397065281868,
    0.015427397564053535, 0.04137944057583809, -0.08542148768901825, 0.07646634429693222, -0.049105800688266754, -0.013979052193462849, 0.023481236770749092, -0.025831306353211403,
    -0.0932968333363533, 0.11838993430137634, 0.03089349903166294, 0.04359487444162369, 0.06714046001434326, 0.09656579792499542, -0.03793153911828995, 0.03738008067011833,
    0.04091489687561989, -0.12503553926944733, -0.07764243334531784, 0.027946364134550095, 0.06041663512587547, -0.04789593443274498, -0.02166445553302765, -0.02035321481525898,
    0.0170121006667614, 0.008873964659869671, -0.027399981394410133, -0.04327508062124252, -0.1153436005115509, 0.028590930625796318, 0.004339057486504316, 0.0055253473110497,
    0.14756831526756287, 0.047062769532203674, -0.012486187741160393, -0.006029152777045965, -0.02055494114756584, 0.025281738489866257, 0.08860880136489868, 0.06581022590398788,
    -0.020955389365553856, 0.11248660087585449, 0.06543167680501938, 0.007818919606506824, 0.032421085983514786, -0.01251421868801117, 0.02932625263929367, -0.07108882069587708,
    0.012740889564156532, -0.006752497982233763, 0.0016795400297269225, 0.043435558676719666, -0.017373202368617058, 0.03780918940901756, -0.03341343253850937, 0.12104494124650955,
    0.01310874056071043, -0.027072729542851448, 0.044793762266635895, 0.045230261981487274, -0.010077917948365211, 0.04337221756577492, 0.0656617060303688, 0.003727446775883436,
    -0.06456836313009262, 0.0586838573217392, -0.040917202830314636, 0.02212224341928959, 0.0007672772044315934, -0.011515368707478046, 0.037412501871585846, -0.1694900393486023,
    0.021903710439801216, -0.034445058554410934, -0.019443439319729805, 0.050437554717063904, 0.03834041953086853, -0.06660609692335129, 0.03380336984992027, 0.07849166542291641,
    -0.0473138652741909, 0.06027202308177948, 0.017647037282586098, 0.03351573273539543, -0.09204889833927155, -0.014963343739509583, -0.029090719297528267, -0.07193542271852493,
    0.02220124937593937, 0.019414830952882767, -0.05768480524420738, -0.008250636979937553, -0.0537903755903244, 0.009711693041026592, 0.02267012745141983, 0.005305133759975433,
    0.0263040903955698, 0.00153590168338269, 0.02506045438349247, -0.0915941521525383, 0.13009409606456757, 0.04344597086310387, -0.09438982605934143, 0.03828958049416542,
    0.10074875503778458, 0.09561407566070557, 0.052394818514585495, -0.06311628222465515, 0.027309589087963104, 0.0023630857467651367, -0.02002447284758091, -0.009057862684130669,
    0.0033927566837519407, 0.010308373719453812, 0.04425714537501335, 0.045785386115312576, 0.03602835163474083, -0.001902097836136818, -0.02836349979043007, -0.04113269969820976,
    0.04504533112049103, -0.024930763989686966, -0.09171175211668015, -0.0842883512377739, 0.03178713470697403, -0.04166020452976227, -0.11332989484071732, 0.06664203852415085,
    0.10526571422815323, -0.00718609569594264, 0.043947819620370865, -0.1062440276145935, 0.011216634884476662, -0.06128416210412979, -0.02756335958838463, -0.006366722751408815,
    0.034556012600660324, -0.060967862606048584, 0.048116978257894516, 0.02273271419107914, 0.08555296808481216, -0.023206058889627457, 0.016824783757328987, -0.15973494946956635,
    0.02890424057841301, 0.13470983505249023, 0.015364829450845718, 0.051363248378038406, 0.011318130418658257, -0.009181637316942215, 0.010016174986958504, 0.08242297172546387,
    0.01107871439307928, -0.04170127585530281, 0.02206297591328621, 0.06638938188552856, -0.004022323992103338, -0.06411547213792801, 0.06258262693881989, -0.003459623549133539,
    0.06887144595384598, -0.03768046572804451, -0.02667389251291752, -0.02006964012980461, -0.03157937154173851, -0.030077733099460602, 0.07604119181632996, 0.06709102541208267,
    -0.06437692046165466, 0.021568538621068, -0.11534629017114639, 0.02380971610546112, -0.04620556905865669, 0.07400380820035934, 0.07120021432638168, -0.06531041115522385,
    -0.04864879325032234, -0.06357727199792862, -0.014702429994940758, -0.08465635776519775, 0.0074842399917542934, 0.04770923778414726, 0.03031742013990879, -0.061924874782562256,
    -0.045891083776950836, 0.026497449725866318, 0.012668822892010212, 0.016493909060955048, 0.049873508512973785, -0.02252683788537979, -0.08877193182706833, -0.07320000231266022,
    0.007127712015062571, -0.04577728733420372, 0.06646431982517242, -0.056960221379995346, -0.0035585835576057434, -0.004669795744121075, -0.11037585139274597, 0.013515708036720753,
    -0.021834278479218483, -0.005142765119671822, 0.04397051781415939, 0.06710509210824966, 0.03386899456381798, 0.03456849232316017, -0.033135175704956055, -0.014371913857758045,
    -0.05919549614191055, 0.030040554702281952, -0.010675552301108837, -0.033219482749700546, -0.06143020838499069, -0.025453832000494003, -0.032812412828207016, 0.05128718167543411,
    0.007773300167173147, -0.024991795420646667, -0.012404285371303558, 0.0320005901157856, -0.02136361040174961, -0.013915677554905415, 0.06385914236307144, 0.15502402186393738,
    0.05751500278711319, -0.05694910138845444, 0.04578906670212746, -0.07453855127096176, -0.017927713692188263, -0.05047043785452843, 0.08583593368530273, 0.03481101617217064,
    0.044849857687950134, 0.0638677179813385, 0.06715481728315353, 0.07870572805404663, 0.040962912142276764, -0.0078097800724208355, -0.06028829514980316, -0.0031221560202538967,
    0.035122428089380264, -0.05912453308701515, -0.03713535517454147, 0.0286422036588192, -0.06343887746334076, 0.10472313314676285, 0.011444463394582272, -0.01718638278543949,
    0.02568862959742546, 0.031090008094906807, -0.026515888050198555, -0.0358339287340641, 0.03494131192564964, 0.058590419590473175, 0.08109332621097565, 0.014098718762397766,
    0.07000010460615158, -0.002974015660583973, -0.01682991161942482, 0.004155488219112158, 0.06689384579658508, 0.013059763237833977, -0.005243353545665741, 0.05130816996097565,
    0.023608939722180367, 0.02328643761575222, 0.047625988721847534, 0.02700372226536274, -0.048205867409706116, -0.07265500724315643, 0.053307708352804184, -0.08113102614879608,
    -0.06564707309007645, -0.14596834778785706, -0.014835082925856113, 0.014654004015028477, -0.030022086575627327, -0.044996824115514755, 0.025999831035733223, 0.0006840041605755687,
    -0.013730291277170181, 0.069284588098526, 0.06586109846830368, 0.04648493975400925, -0.05024295672774315, 0.009257150813937187, 0.06617716699838638, 0.09591419249773026,
    -0.08295021951198578, -0.009482800960540771, -0.04843432083725929, -0.00427474919706583, -0.04625817388296127, 0.0075456430204212666, 0.0852217823266983, 0.0655408650636673,
    0.039678122848272324, -0.07638413459062576, -0.08887321501970291, 0.009656094014644623, -0.007431664038449526, -0.0014397790655493736, -0.04805436730384827, 0.026057099923491478,
    0.11685672402381897, -0.0020455634221434593, 0.03184017166495323, -0.050063490867614746, 0.008351434953510761, 0.04571191221475601, -0.01596541702747345, -0.15207354724407196,
    0.01965460553765297, -0.013321702368557453, 0.002967904321849346, 0.09215670078992844, -0.028661178424954414, -0.03420739993453026, 0.011277925223112106, 0.03578374907374382,
    0.058382995426654816, -0.023906834423542023, 0.0007318027783185244, -0.004405186977237463, 0.00243575032800436, 0.016122760251164436, -0.04888729751110077, 0.1673315018415451,
    -0.03665192052721977, 0.011731483973562717, -0.02940433658659458, -0.002589648123830557, -0.11047203838825226, -0.006370791234076023, 0.0033924442250281572, -0.001047726720571518,
    0.03631290793418884, 0.10291128605604172, 0.048302698880434036, 0.016394885256886482, 0.0749860629439354, 0.05460210144519806, -0.07005587965250015, 0.042184144258499146,
    -0.02868853695690632, -0.05151531100273132, 0.11697552353143692, 0.09214655309915543, 0.039999958127737045, -0.012583157978951931, -0.07485987991094589, 0.0079971794039011,
    -0.01152729894965887, -0.029391085729002953, -0.025900039821863174, 0.14235906302928925, 0.04844585806131363, 0.10538959503173828, 0.06498124450445175, -0.0020233518444001675,
    -0.06097785755991936, 0.02979046292603016, -0.11095204204320908, -0.0009792906930670142, -0.08474469184875488, -0.03281151130795479, -0.08567333966493607, -0.03986938297748566,
    -0.010643994435667992, 0.04947822913527489, 0.052930157631635666, 0.01702592521905899, 0.07474864274263382, 0.005162182729691267, -0.03293807804584503, -0.040972039103507996,
    -0.10208739340305328, 0.037944819778203964, 0.06041215360164642, 0.07116401940584183, 0.038247596472501755, -0.07020578533411026, 0.0315655954182148, -0.043742384761571884,
    -0.031048770993947983, -0.02614973857998848, -0.03593297302722931, 0.04316570609807968, -0.054003722965717316, -0.005255447700619698, -0.02687876857817173, 0.010992873460054398,
    0.021921431645751, -0.028817927464842796, 0.03769318759441376, 0.053270380944013596, -0.03320935368537903, 0.057633671909570694, -0.05291728302836418, 0.10846178978681564,
    0.07986526191234589, 0.15236113965511322, 0.0009107522200793028, -0.000299763836665079, -0.06447313725948334, -0.021194735541939735, -0.084258534014225, -0.10236132144927979,
    -0.022409619763493538, 0.13852350413799286, 0.016993679106235504, -0.04068988189101219, -0.0291899424046278, -0.050042614340782166, -0.010848102159798145, 0.07023030519485474,
    0.035889431834220886, 0.0907546877861023, -0.004833001643419266, 0.018795620650053024, -0.04916640371084213, 0.07286322116851807, 0.06002528592944145, -0.011778105050325394,
    0.02277286909520626, -0.018305635079741478, 0.02646944299340248, -0.01772705651819706, -0.022006940096616745, 0.05969610437750816, -0.04806124418973923, 0.05434802547097206,
    0.021983003243803978, 0.052467092871665955, -0.06269986927509308, 0.05572953447699547, 0.024410700425505638, -0.03360290080308914, -0.08043975383043289, -0.0010509933345019817,
    0.024524101987481117, 0.018130598589777946, 0.06425183266401291, -0.054496925324201584, -0.11416306346654892, -0.014676772989332676, 0.04019556939601898, 0.08095044642686844,
    0.055000580847263336, 0.019438013434410095, 0.0997483879327774, 0.05209695175290108, -0.05149106681346893, -0.11925401538610458, 0.014385753311216831, -0.14497749507427216,
    -0.033389538526535034, -0.04296501725912094, -0.03524459898471832, 0.016731228679418564, -0.06888198107481003, -0.013252953067421913, 0.030243298038840294, -0.0279481653124094,
    0.08326811343431473, 0.06392962485551834, 0.040522269904613495, -0.019924065098166466, -0.059518974274396896, -0.06199942156672478, 0.10726135224103928, 0.05340942367911339,
    -0.0037376186810433865, 0.06327641010284424, 0.01623116433620453, -0.13531315326690674, 0.013079297728836536, 0.033075373619794846, -0.040331024676561356, -0.04987403377890587,
    -0.006313942838460207, -0.06729254871606827, -0.08959508687257767, 0.09439756721258163, -0.0639045387506485, -0.05167770013213158, 0.022579604759812355, 0.02514670602977276,
    0.0026992512866854668, 0.03452085703611374, 0.020352382212877274, 0.04655172675848007, 0.008046086877584457, 0.03545280918478966, -0.06815330684185028, 0.016520308330655098,
    0.03187727928161621, 0.04638266563415527, -0.03761978819966316, 0.054589372128248215, -0.0383688360452652, 0.054674841463565826, -0.032827455550432205, 0.016022514551877975,
    -0.13490743935108185, 0.001976407365873456, -0.047254931181669235, -0.022798700258135796, 0.07437698543071747, 0.022607728838920593, 0.13355520367622375, -0.04338749125599861,
    0.03697328642010689, -0.020748186856508255, -0.03002580814063549, 0.026415260508656502, -0.07209718972444534, 0.0495852455496788, -0.03245250880718231, -0.1131640151143074,
    -0.01899435557425022, -0.03496263548731804, -0.011860460974276066, -0.1035938635468483, 0.0892830342054367, 0.0542762354016304, -0.023559628054499626, -0.10361088812351227,
    0.1592046469449997, -0.13836543262004852, 0.11140529066324234, 0.06741061061620712, -0.08426014333963394, 0.07875106483697891, -0.051885686814785004, 0.0542336069047451,
    0.04825688526034355, -0.04699794203042984, 0.06416782736778259, 0.027806852012872696, 0.08085937798023224, -0.0428822785615921, -0.04965905472636223, -0.10041499882936478,
    -0.012583407573401928, -0.10401717573404312, 0.030105961486697197, -0.05145116522908211, -0.058378420770168304, -0.07787884771823883, 0.148276224732399, -0.11946481466293335,
    -0.07946198433637619, 0.08328276872634888, -0.05603364109992981, 0.03584996610879898, -0.07147318124771118, -0.07585974782705307, -0.011493765749037266, 0.038752466440200806,
    -0.04395967349410057, -0.0743807777762413, 0.03599022328853607, 0.007930650375783443, 0.0677022710442543, -0.06477560102939606, 0.009600834921002388, 0.1409212350845337,
    0.015191221609711647, 0.02251465618610382, -0.07559455186128616, 0.0014315553708001971, 0.113578200340271, -0.029179079458117485, 0.048563845455646515, -0.017970507964491844,
    0.01224315632134676, 0.05101626366376877, -0.02096012607216835, -0.033861905336380005, 0.043458543717861176, 0.0600191131234169, 0.060490187257528305, -0.01278031338006258,
    0.031246140599250793, 0.043059878051280975, -0.05702444911003113, -0.005472060292959213, 0.021510204300284386, -0.04001403599977493, -0.0601266548037529, -0.07378019392490387,
    0.02313944138586521, 0.0115194795653224, 0.10193540155887604, 0.035211026668548584, -0.025329552590847015, -0.052499040961265564, 0.06237690895795822, 0.025075087323784828,
    0.01853613555431366, -0.051560744643211365, 0.049003709107637405, 0.00890008918941021, 0.05451628938317299, -0.03553541377186775, 0.010484791360795498, -0.039874713867902756,
    0.046315595507621765, -0.05375881865620613, 0.08054401725530624, -0.08096389472484589, -0.06781371682882309, 0.042183082550764084, -0.09621171653270721, -0.03590596467256546,
    0.06631909310817719, -0.025960346683859825, -0.02941705472767353, 0.02836902067065239, -0.00494668073952198, -0.051164884120225906, -0.027651909738779068, 0.04333168640732765,
    -0.01510392501950264, -0.10538355261087418, -0.041322603821754456, -0.046721201390028, -0.01924758404493332, 0.05375899747014046, -0.07226500660181046, -0.025056757032871246,
    0.13539858162403107, -0.10189463943243027, -0.011494629085063934, -0.037138812243938446, 0.06976427137851715, 0.033398665487766266, 0.07058340311050415, -0.027698157355189323,
    0.052351128309965134, 0.03161252662539482, -0.05519676208496094, 0.012137491255998611, 0.14201082289218903, -0.007773807272315025, -0.07536804676055908, 0.020666761323809624,
    -0.0019739747513085604, -0.05799715965986252, 0.056291613727808, -0.044883351773023605, 0.030506955459713936, -0.05149250477552414, 0.06357252597808838, 0.012765508145093918,
    -0.0017672087997198105, 0.14024823904037476, 0.025036392733454704, 0.023782575502991676, 0.02311077155172825, -0.04363706707954407, -0.027081793174147606, 0.010197937488555908,
    -0.020790308713912964, -0.05742592364549637, 0.05752892419695854, 0.0008991256472654641, 0.04606493189930916, 0.018243957310914993, 0.05564689263701439, 0.0070335897617042065,
    -0.0052266367711126804, 0.011862450279295444, 0.05764201283454895, 0.012704187072813511, -0.021839911118149757, 0.058691639453172684, 0.18433304131031036, -0.07785551249980927,
    0.08998556435108185, 0.0473145954310894, 0.015629615634679794, 0.051070839166641235, 0.07344381511211395, 0.006338790990412235, -0.016029782593250275, -0.0395786315202713,
    0.02139195241034031, -0.02481364645063877, -0.017611123621463776, 0.01686168648302555, 0.011672469787299633, -0.10254263132810593, 0.014618596993386745, -0.09762638062238693,
    0.03700048476457596, -0.0983080193400383, 0.06058623269200325, -0.056319572031497955, 0.0840524360537529, -0.0342833511531353, 0.10805074870586395, -0.047138310968875885,
    -0.03950968384742737, -0.05132484808564186, -0.021395234391093254, 0.007610512897372246, 0.006265793461352587, -0.031043941155076027, 0.08402407169342041, 0.13718585669994354,
    0.018455909565091133, -0.00655346317216754, 0.008487753570079803, 0.13603399693965912, -0.07269036024808884, 0.053261660039424896, 0.04366958886384964, -0.0014723626663908362,
    0.017042793333530426, 0.06192232668399811, -0.026765335351228714, -0.01268504187464714, 0.05003969371318817, 0.008873573504388332, -0.12968656420707703, -0.007245518267154694,
    -0.022559650242328644, -0.05507373809814453, 0.09737702459096909, -0.0028585041873157024, -0.0016191296745091677, -0.00931722391396761, 0.0425146259367466, 0.06865610182285309,
    -0.02030850015580654, -0.06470202654600143, 0.05723928287625313, 0.06630263477563858, -0.02135823294520378, 0.01937311328947544, -0.06207551807165146, 0.004673071671277285,
    0.057508330792188644, -0.08368391543626785, -0.03903545066714287, -0.02792009338736534, 0.0592912882566452, 0.0006044424371793866, 0.08763285726308823, 0.04779160022735596,
    0.13412725925445557, 0.04646635428071022, 0.08479482680559158, -0.005002742167562246, 0.007877766154706478, -0.018794110044836998, -0.014539527706801891, -0.07546281814575195,
    0.07119804620742798, -0.002185922348871827, -0.02805568091571331, -0.11455900967121124, -0.03981629014015198, -0.06890636682510376, 0.07248494774103165, 0.03534316271543503,
    -0.0364430770277977, 0.0670924186706543, 0.15177929401397705, -0.02239036001265049, 0.012809976935386658, -0.04777459800243378, 0.024057237431406975, 0.025799108669161797,
    -0.03152450546622276, 0.03482844680547714, -0.0024112779647111893, 0.16877572238445282, -0.09448596835136414, 0.11716263741254807, -0.06562269479036331, -0.02683093026280403,
    -0.02138974517583847, -0.13544084131717682, 0.010764911770820618, -0.008973224088549614, 0.0729641541838646, -0.029752759262919426, -0.005529995542019606, -0.08261542022228241,
    -0.023997806012630463, -0.0008970588678494096, -0.06463838368654251, -0.07196387648582458, 0.09973705559968948, 0.042002275586128235, -0.047263361513614655, -0.027698978781700134,
    0.09674090892076492, 0.07217087596654892, -0.030481047928333282, 0.059004295617341995, -0.04806908220052719, 0.015548461116850376, 0.1484779417514801, 0.07750546932220459,
    -0.006647894158959389, 0.16559672355651855, -0.038000576198101044, 0.05864756181836128, 0.07695592194795609, 0.01720580831170082, 0.06471122056245804, 0.05696383863687515,
    0.0444498173892498, 0.0597781166434288, 0.030603183433413506, 0.11915824562311172, -0.06364288926124573, -0.1060788556933403, 0.08430183678865433, 0.022714952006936073,
    -0.056945960968732834, -0.053118761628866196, -0.007807646878063679, 0.03918961435556412, -0.10435014218091965, 0.024078786373138428, -0.0606619231402874, 0.07842226326465607,
    -0.10636340081691742, -0.06511802971363068, 0.037822332233190536, 0.020731121301651, -0.026883479207754135, 0.01768624596297741, -0.006828689016401768, 0.07488790899515152,
    0.033877626061439514, -0.003748764283955097, -0.03586556017398834, 0.021237095817923546, 0.022020649164915085, 0.009488936513662338, 0.009689506143331528, 0.0905076116323471,
    0.0645287036895752, 0.015352386981248856, 0.02798398770391941, 0.04314547777175903, 0.004330065101385117, -0.007320525590330362, -0.04194366931915283, -0.010171215049922466,
    -0.028215531259775162, -0.016403064131736755, 0.014735475182533264, -0.012307984754443169, -0.02756122127175331, 0.02756761945784092, -0.08640050888061523, -0.11962242424488068,
    0.0044690812937915325, -0.07301685214042664, -0.06718602776527405, 0.03609631583094597, 0.05872994661331177, -0.007214066106826067, 0.07705940306186676, -0.005391540937125683,
    -0.07049139589071274, -0.10736850649118423, 0.0669737309217453, -0.10903280228376389, -0.03432280942797661, -0.012807871215045452, 0.014806564897298813, -0.07975487411022186,
    0.003788132220506668, 0.05901198834180832, 0.026492446660995483, 0.0797242596745491, 0.0014649942750111222, -0.04849090799689293, -0.05049243941903114, -0.02749587409198284,
    0.00018890024512074888, 0.10802555829286575, -0.007653728127479553, 0.016748618334531784, -0.0299375019967556, 0.08806350082159042, -0.13281215727329254, -0.02714391052722931,
    0.0025611084420233965, -0.05097320303320885, -0.02053029090166092, 0.023541754111647606, -0.06944552809000015, -0.02358262985944748, -0.0025164803955703974, -0.0666361153125763,
    -0.019061291590332985, 0.0037629299331456423, 0.0573674812912941, 0.058153461664915085, -0.07155326753854752, 0.01628727838397026, -0.043779175728559494, 0.07605757564306259,
    0.036511581391096115, 0.10701403021812439, 0.0800916776061058, 0.11331839114427567, 0.04134875535964966, 0.030600635334849358, -0.06745889037847519, 0.03671051934361458,
    0.032465074211359024, -0.04581914097070694, -0.0726972296833992, -0.00882524810731411, -0.06755293160676956, -0.06912638247013092, -0.008257526904344559, 0.0059265862219035625,
    -0.014089850708842278, -0.08409512788057327, -0.04010589420795441, -0.03143392130732536, 0.004631762858480215, -0.08572394400835037, 0.05589544400572777, 0.017852896824479103,
    -0.06698678433895111, -0.030380498617887497, -0.020360734313726425, 0.05106071010231972, -0.0421210415661335, -0.00476086838170886, 0.10720012336969376, -0.032013989984989166,
    0.03318411111831665, 0.00444976007565856, -0.012785331346094608, -0.008218921720981598, 0.030064180493354797, -0.09604399651288986, -0.1300744265317917, 0.1810164600610733,
    -0.02101125940680504, -0.02323194034397602, -0.0044598388485610485, -0.00971387792378664, -0.08984731882810593, -0.001014501671306789, 0.033950068056583405, -0.0043145050294697285,
    -0.10250663012266159, 0.05393142253160477, 0.015269153751432896, 0.0036656963638961315, -0.04820232465863228, 0.03047913685441017, -0.05622277781367302, 0.021892376244068146,
    0.014243856072425842, 0.013996745459735394, -0.02463250234723091, 0.014812988229095936, 0.04013892635703087, 0.035953834652900696, -0.056534089148044586, -0.06052403151988983,
    -0.08593650907278061, -0.01512506976723671, 0.08121797442436218, -0.01148091722279787, -0.13209962844848633, 0.02916639856994152, 0.13909485936164856, 0.024139877408742905,
    -0.02038493938744068, -0.1292628049850464, 0.05480938404798508, -0.008591328747570515, 0.008570738136768341, -0.03885846585035324, 0.013695573434233665, 0.03431757166981697,
    -0.06744232773780823, -0.05947322025895119, -0.03656935691833496, 0.0026635751128196716, -0.035235773772001266, -0.021628549322485924, -0.010694531723856926, 0.034441154450178146,
    -0.027909038588404655, -0.10657782852649689, -0.001626540208235383, 0.008521097712218761, -0.09261839091777802, 0.003492028219625354, 0.14302881062030792, -0.011842992156744003,
    0.06839597225189209, -0.11960593611001968, -0.015796517953276634, 0.05322114750742912, -0.05077628046274185, 0.15975253283977509, -0.1000446006655693, -0.02637670747935772,
    0.06615114957094193, -0.0020785462111234665, 0.06399381160736084, 0.008863665163516998, 0.015112504363059998, -0.012477106414735317, -0.020384546369314194, -0.05006350949406624,
    -0.026197124272584915, -0.0248674675822258, -0.09529414772987366, 0.026676734909415245, -0.04117053002119064, -0.03309188410639763, 0.0599433109164238, -0.05504131317138672,
    0.10773167759180069, -0.12257739156484604, 0.037601288408041, -0.030718527734279633, 0.09780669957399368, -0.06672348827123642, 0.12151263654232025, 0.060821305960416794,
    0.08780382573604584, -0.08876533061265945, 0.015874579548835754, -0.03748604282736778, -0.035669486969709396, -0.014908257871866226, -0.008853868581354618, -0.017906194552779198,
    -0.027455154806375504, -0.07714032381772995, 0.03227652609348297, 0.14570294320583344, 0.007832249626517296, 0.009202169254422188, 0.06278619915246964, 0.12884579598903656,
    0.05240670591592789, -0.0007013119757175446, -0.03590982034802437, -0.0073029357008636, 0.11356840282678604, 0.061088256537914276, 0.0181183572858572, 0.036480359733104706,
    0.06364007294178009, -0.12611123919487, 0.08298113197088242, 0.07649800181388855, 0.051166780292987823, -0.08735404908657074, 0.013433754444122314, 0.007836353033781052,
    0.0038623290602117777, -0.0644303560256958, -0.031825125217437744, -0.017392031848430634, 0.05592706799507141, -0.12099361419677734, -0.07758171856403351, -0.10237554460763931,
    -0.027851652354002, 0.08650404959917068, 0.0247646551579237, 0.007784484885632992, -0.08549814671278, 0.04393588379025459, -0.014526591636240482, -0.1149400845170021,
    0.052849169820547104, -0.01108501199632883, 0.06460234522819519, 0.0430782251060009, 0.03509862720966339, -0.08643186092376709, 0.07673590630292892, 0.1416727900505066,
    0.01701592653989792, -0.013760759495198727, 0.08172371983528137, 0.08248681575059891, 0.049226317554712296, -0.06683129817247391, -0.020022766664624214, -0.009347102604806423,
    -0.0496087446808815, 0.053116943687200546, -0.04797163978219032, 0.00404076324775815, -0.045709073543548584, 0.026224518194794655, -0.11098480224609375, 0.08263873308897018,
    0.0135866180062294, 0.03626302629709244, 0.01582176797091961, -0.05700113624334335, 0.05451664701104164, -0.0005602715536952019, -0.0633990466594696, -0.035550571978092194,
    0.06066694110631943, 0.024677949026226997, 0.040370095521211624, -0.05753782019019127, -0.06803230941295624, -0.14741763472557068, -0.11959183216094971, 0.13664676249027252,
    0.027865203097462654, -0.09147447347640991, 0.04373166710138321, -0.032427892088890076, 0.0011464637937024236, 0.03043733723461628, -0.013620126061141491, 0.001228053355589509,
    0.1424952745437622, 0.11165248602628708, -0.07139966636896133, 0.029814565554261208, -0.0688231810927391, 0.07165055721998215, 0.138578400015831, -0.03248447924852371,
    -0.054804228246212006, -0.08202920109033585, -0.05846790596842766, -0.05186072364449501, -0.00023370853159576654, -0.0748801976442337, 0.0855879858136177, -0.010999145917594433,
    -0.04194476082921028, 0.12390916049480438, 0.1070212870836258, -0.06347447633743286, 0.07899052649736404, -0.0556676983833313, 0.05343116074800491, 0.04629955813288689,
    0.010817266069352627, 0.0026227072812616825, 0.06403031200170517, 0.07867175340652466, -0.027633799239993095, 0.10949476808309555, -0.05417553335428238, -0.07978026568889618,
    0.055257249623537064, 0.05431722104549408, 0.01502248365432024, 0.014728439971804619, -0.03688638284802437, -0.004626380745321512, -0.05414360389113426, 0.007338743656873703,
    0.00023382922518067062, 0.013940783217549324, 0.0011877075303345919, 0.052609995007514954, 0.05194733664393425, -0.0008874194463714957, 0.0034314242657274008, 0.007950300350785255,
    -0.013638067059218884, 0.031868912279605865, 0.11623478680849075, -0.02154051512479782, 0.10906603932380676, 0.013219182379543781, 0.00929943472146988, 0.04829643294215202,
    -0.022673623636364937, -0.011849942617118359, -0.05789767578244209, 0.015598645433783531, 0.01888560876250267, 0.04817694425582886, -0.11424723267555237, -0.02899402379989624,
    -0.011356504634022713, 0.025850685313344002, 0.0674424096941948, -0.008283382281661034, 0.00991333182901144, -0.024065710604190826, -0.031729720532894135, -0.0498635359108448,
    0.02776462584733963, 0.15814830362796783, 0.0035158207174390554, 0.013345769606530666, 0.01957716979086399, 0.06972485780715942, 0.03628551959991455, 0.001429441967047751,
    0.038994040340185165, -0.022704821079969406, -0.08355119079351425, 0.016276013106107712, 0.045792125165462494, 0.10194241255521774, -0.06716370582580566, -0.11141059547662735,
    0.08800297230482101, 0.01804640330374241, 0.03488403931260109, 0.008897953666746616, 0.0011471809120848775, -0.006566245574504137, -0.06752300262451172, -0.062116943299770355,
    0.05952519550919533, 0.002274157013744116, -0.035771194845438004, -0.02174459770321846, 0.1555119752883911, -0.07781033217906952, 0.05595903843641281, -0.09681039303541183,
    -0.010171406902372837, -0.06777045130729675, -0.09587816894054413, 0.048623375594615936, -0.0390065535902977, -0.040214039385318756, -0.029624857008457184, -0.023907221853733063,
    0.00013312220107764006, -0.08409386873245239, 0.002632386051118374, 0.07790418714284897, 0.11842304468154907, -0.02260461449623108, -0.024496402591466904, -0.00016854317800607532,
    -0.040664125233888626, -0.12730538845062256, -0.01896016299724579, 0.03896335884928703, 0.009083530865609646, 0.024014633148908615, -0.03737516328692436, 0.003267967374995351,
    -0.02628985047340393, 0.02124127186834812, -0.110781729221344, 0.016943827271461487, -0.0036296870093792677, -0.019029879942536354, 0.030003536492586136, 0.08057668060064316,
    -0.08086511492729187, -0.1080188974738121, -0.08033721148967743, 0.06342961639165878, -0.0019255728693678975, 0.004668730311095715, 0.02854228764772415, 0.06838703155517578,
    -0.011943960562348366, 0.038596928119659424, 0.035217903554439545, 0.014388816431164742, 0.1471412181854248, -0.12284772098064423, 0.05465655028820038, 0.05289946496486664,
    -0.016003549098968506, -0.01926160790026188, 0.026692671701312065, -0.010188293643295765, 0.030129795894026756, -0.09691648930311203, -0.16461311280727386, 0.036157283931970596,
    -0.0073914909735322, -0.04377245530486107, -0.01696496456861496, -0.05936482921242714, -0.009325709193944931, -0.008503998629748821, -0.10718642175197601, 0.01016890350729227,
    -0.006684548687189817, -0.03897194564342499, -0.03852201625704765, 0.04661215841770172, -0.0033616176806390285, -0.06222771480679512, 0.07113657146692276, 0.012698637321591377,
    -0.0058253007009625435, -0.008585494011640549, 0.011067260056734085, 0.03025221824645996, 0.13199211657047272, -0.02235860750079155, -0.027252350002527237, 0.05307146534323692,
    -0.0550670400261879, -0.06812991201877594, -0.090643011033535, 0.05762200802564621, -0.03061859682202339, -0.04430970922112465, 0.09112444519996643, 0.03360914811491966,
    0.05607863888144493, -0.051634568721055984, -0.07293858379125595, 0.14070510864257812, -0.004421898163855076, -0.018808260560035706, 0.03819875419139862, 0.12492895126342773,
    -0.14133356511592865, 0.025899698957800865, 0.016831373795866966, 0.036662664264440536, -0.11527157574892044, -0.16208651661872864, -0.07992929220199585, -0.006907304283231497,
    0.04968848451972008, 0.016009492799639702, 0.11113261431455612, 0.044936954975128174, -0.07566528767347336, 0.0006649093702435493, 0.04943849891424179, -0.10557419806718826,
    -0.11065389961004257, -0.03067377395927906, -0.00959416851401329, -0.06381845474243164, -0.06560642272233963, -0.03302949666976929, 0.01906224712729454, 0.011865748092532158,
    -0.11881040036678314, 0.004504312761127949, -0.03690367564558983, 0.012767576612532139, 0.1296810507774353, -0.07412383705377579, 0.1535256952047348, -0.07653956115245819,
    0.005296917166560888, 0.13185545802116394, 0.06999316811561584, -0.021672362461686134, 0.05335823819041252, 0.019605953246355057, -0.04689483717083931, 0.1557171791791916,
    -0.04743065685033798, -0.04437961429357529, 0.018479416146874428, -0.21452510356903076, -0.03170881047844887, 0.048104602843523026, 0.1040026918053627, -0.12035036087036133,
    -0.038629453629255295, 0.01015262771397829, -0.01368453074246645, -0.06597037613391876, -0.07674891501665115, -0.017388835549354553, -0.09311479330062866, -0.02892230451107025,
    0.028885601088404655, -0.09714352339506149, 0.0560062900185585, -0.012151213362812996, 0.039812445640563965, -0.041456785053014755, 0.00898432545363903, 0.07591217011213303,
    0.14632025361061096, 0.06126824766397476, 0.08730640262365341, 0.00395802641287446, 0.1102520003914833, 0.044497400522232056, 0.14843477308750153, 0.015942491590976715,
    -0.1307952105998993, -0.03198213502764702, -0.11629502475261688, -0.026508251205086708, -0.040292784571647644, -0.08440732955932617, -0.061417195945978165, -0.1308576613664627,
    0.001979490974918008, 0.07530897855758667, 0.026924123987555504, 0.024755708873271942, -0.09797632694244385, 0.046775221824645996, 0.04844341427087784, -0.03056752122938633,
    0.09405696392059326, 0.03692379221320152, 0.06663528829813004, -0.013164524920284748, 0.05619705468416214, -0.02097206562757492, 0.05450248718261719, 0.022908929735422134,
    0.015770746394991875, -0.002043284708634019, 0.062037572264671326, -0.05085104703903198, -0.05895890295505524, 0.19472482800483704, 0.05679671838879585, 0.0735858604311943,
    -0.04466632381081581, 0.017462626099586487, -0.03968885540962219, 0.027867596596479416, 0.1974858194589615, 0.08074013888835907, -0.08494755625724792, -0.05679647624492645,
    0.05070716515183449, 0.026134734973311424, -0.014772207476198673, 0.03593623638153076, -0.02269710600376129, -0.08631869405508041, -0.06287449598312378, 0.1294631063938141,
    0.04824422299861908, -0.03600125014781952, 0.07066638022661209, -0.013417358510196209, -0.06684603542089462, -0.01162239070981741, 0.07798103243112564, 0.043656352907419205,
    -0.06734815239906311, -0.18494297564029694, 0.012067150324583054, -0.04172811284661293, -0.018393758684396744, 0.02978610247373581, 0.03420023247599602, 0.107528455555439,
    -0.06707347929477692, 0.005216581281274557, 0.026466481387615204, -0.06503064185380936, 0.02046636864542961, -0.06961283087730408, -0.06703682988882065, 0.1156931072473526,
    0.0390949584543705, 0.02223382703959942, -0.08103802800178528, -0.051604751497507095, 0.1072617918252945, 0.052289146929979324, 0.040780819952487946, 0.02099432423710823,
    -0.07980463653802872, -0.016857560724020004, 0.0763775110244751, 0.00634743832051754, -0.023517604917287827, 0.05774462968111038, -0.18740037083625793, 0.1242518424987793,
    -0.0167549978941679, 0.05442715063691139, -0.10221344232559204, -0.05926232784986496, 0.011004170402884483, -0.03337594494223595, 0.032362356781959534, -0.05337459594011307,
    0.11981811374425888, -0.004632032010704279, 0.05566530302166939, -0.022367462515830994, 0.0224415622651577, 0.04192899167537689, 0.031111333519220352, 0.09358090907335281,
    -0.07399152219295502, 0.028121134266257286, 0.09651676565408707, 0.11447480320930481, 0.06956833600997925, -0.002551730489358306, -0.005228271242231131, -0.03519841656088829,
    -0.017018739134073257, 0.07750583440065384, -0.054069794714450836, -0.06521905213594437, 0.03547429293394089, 0.05655630677938461, -0.07787624001502991, -0.05451088026165962,
    0.06105753779411316, -0.018489660695195198, 0.033769357949495316, 0.00654265284538269, -0.04511987790465355, -0.001297443057410419, 0.08075614273548126, -0.13323095440864563,
    0.14002898335456848, -0.04548266530036926, -0.018551845103502274, 0.021932343021035194, -0.0846688449382782, 0.04562278464436531, -0.046671416610479355, -0.00019595226331148297,
    -0.03301190212368965, -0.012766266241669655, 0.0004396589647512883, -0.06673838943243027, 0.06236228719353676, 0.07893107086420059, 0.06481964141130447, 0.065318763256073,
    -0.08979736268520355, -0.016915105283260345, 0.018647469580173492, -0.018038151785731316, -0.005566847510635853, 0.0339541994035244, 0.09236764907836914, -0.010112606920301914,
    -0.009248911403119564, 0.07190046459436417, -0.037828173488378525, -0.010734718292951584, -0.09533719718456268, -0.07056467980146408, -0.006058738101273775, 0.004797233734279871,
    0.05495520308613777, -0.05181801691651344, 0.0706188827753067, 0.0027923285961151123, 0.23383672535419464, -0.09095416963100433, 0.040065981447696686, -0.0983273983001709,
    -0.03150128945708275, 0.037455521523952484, -0.015122704207897186, 0.05850467458367348, 0.10334630310535431, 0.00896820891648531, 0.010877858847379684, -0.05547221377491951,
    0.055250514298677444, 0.08868621289730072, -0.02948346547782421, -0.021952170878648758, -0.08237890154123306, 0.013056132011115551, 0.029537763446569443, -0.26093432307243347,
    0.07219439744949341, -0.10077150166034698, -0.01736239716410637, -0.022429978474974632, -0.1640799641609192, -0.007279704790562391, 0.20445218682289124, -0.1326737403869629,
    -0.007925855927169323, 0.05640295520424843, -0.14223958551883698, 0.046444714069366455, 0.029757939279079437, 0.05894923210144043, 0.008650985546410084, -0.032458167523145676,
    0.07032044231891632, 0.02256387285888195, 0.09476765990257263, 0.021104557439684868, 0.04340296983718872, 0.006242590490728617, 0.0325821153819561, -0.045798782259225845,
    0.07115259766578674, 0.017225120216608047, 0.10033255815505981, 0.017831750214099884, -0.02344929613173008, 0.000721897988114506, 0.038924358785152435, -0.1295425146818161,
    -0.011538783088326454, -0.12410039454698563, -0.06954074651002884, -0.05889556556940079, 0.017190048471093178, -0.006498339585959911, -0.06363852322101593, 0.0892210453748703,
    -0.028323877602815628, 0.14330913126468658, 0.002741455100476742, 0.032510168850421906, -0.0010917825857177377, -0.06208919361233711, -0.16829948127269745, -0.14414657652378082,
    0.10890907794237137, 0.06447858363389969, -0.14938239753246307, -0.07935315370559692, 0.04549692943692207, 0.031513795256614685, 0.17071428894996643, 0.01066025160253048,
    0.03978149965405464, 0.05474890395998955, 0.059750668704509735, 0.0026414513122290373, 0.12049010396003723, -0.07365342229604721, -0.06784278154373169, 0.0012325906427577138,
    -0.00011257008736720309, -0.11517955362796783, -0.07049484550952911, 0.006378755904734135, -0.026362821459770203, 0.05252090096473694, -0.06499549746513367, 0.06280693411827087,
    -0.010171574540436268, -0.0034428758081048727, -0.06084724888205528, -0.019496414810419083, -0.09135604649782181, 0.06250540912151337, 0.05211237818002701, 0.03288586065173149,
    -0.08566290140151978, 0.02360711432993412, 0.062211353331804276, 0.12427268922328949, 0.014647658914327621, -0.04584956541657448, -0.04367920756340027, -0.09279152005910873,
    0.003757477505132556, 0.013046233914792538, 0.00907992385327816, 0.007312439847737551, 0.03429174795746803, 0.07375101745128632, 0.025654999539256096, 0.012918313033878803,
    0.07126767188310623, 0.1200103685259819, 0.05968177318572998, -0.0345720611512661, -0.006433217320591211, -0.07115136831998825, -0.03818747401237488, 0.01891879364848137,
    0.02535673975944519, -0.07084151357412338, -0.014888857491314411, -0.015053660608828068, 0.055566877126693726, 0.028346750885248184, -0.009467262774705887, -0.0341964028775692,
    -0.01831781305372715, 0.09508433192968369, 0.06636399030685425, 0.0029580716509371996, -0.0698201060295105, 0.05811943858861923, -0.007413859013468027, 0.0440346822142601,
    -0.1340017318725586, 0.09066358953714371, 0.0062059625051915646, 0.036168769001960754, 0.08754374086856842, 0.10845081508159637, 0.02092261053621769, 0.09867856651544571,
    -0.05259256437420845, -0.00783836841583252, 0.01592935435473919, 0.12624704837799072, 0.016321081668138504, 0.04644710570573807, -0.045186128467321396, -0.06997346132993698,
    -0.006895800586789846, -0.009472515434026718, -0.029287973418831825, -0.03484700620174408, 0.015920327976346016, -0.1135481595993042, -0.04155820608139038, 0.003213880816474557,
    -0.0761447474360466, -0.036928609013557434, -0.007884087972342968, -0.04604492709040642, -0.05441185086965561, 0.06985846161842346, -0.0018018916016444564, -0.10650395601987839,
    -0.02488577552139759, -0.0478915274143219, -0.13438592851161957, -0.02998284250497818, 0.2181604951620102, -0.11633455753326416, 0.04299584776163101, -0.1680126041173935,
    0.043578099459409714, -0.060112472623586655, -0.005777136422693729, 0.03313048556447029, 0.032491862773895264, -0.005055649671703577, 0.05564840883016586, -0.1485579013824463,
    -0.004914348479360342, -0.049779701977968216, 0.003408733056858182, -0.05738433450460434, 0.04428090527653694, 0.0014455465134233236, 0.11828210949897766, 0.02510330267250538,
    -0.02994038537144661, -0.020533837378025055, 0.051179032772779465, 0.08677017688751221, -0.05254160985350609, 0.0010757187847048044, -0.0023544994182884693, -0.003876620205119252,
    -0.04466467723250389, -0.10746956616640091, -0.043116435408592224, 0.024714374914765358, 0.024040089920163155, -0.03169235214591026, -0.07897192239761353, -0.10254011303186417,
    -0.011057723313570023, 0.008030964061617851, -0.012860313057899475, 0.10109706223011017, 0.06726107746362686, -0.06118924170732498, 0.05720072239637375, 0.046301327645778656,
    -0.11372748017311096, -0.083675317466259, 0.07118786871433258, -1.3415208741207607e-05, -0.038567204028367996, -0.11446590721607208, -0.14331012964248657, 0.004153781570494175,
    0.02343667671084404, -0.012757407501339912, -0.08290907740592957, 0.06248734891414642, -0.05659607797861099, 0.042867254465818405, 0.0426783412694931, -0.024063987657427788,
    0.0732870027422905, 0.005578305572271347, -0.05466948077082634, -0.044517625123262405, 0.031070293858647346, -0.009534657932817936, -0.012427318841218948, -0.02440059743821621,
    -0.08323217183351517, -0.03209655359387398, -0.039693258702754974, -0.05185025930404663, -0.022545546293258667, 0.07230163365602493, -0.07427137345075607, 0.03893357887864113,
    -0.043546151369810104, 0.07289670407772064, -0.0026022049132734537, 0.030504830181598663, 0.1267356276512146, 0.011713243089616299, -0.1325460821390152, -0.005134314298629761,
    0.0267192255705595, 0.06620201468467712, -0.028854116797447205, 0.043281543999910355, 0.0475948229432106, -0.06024647876620293, 0.01308566052466631, 0.028085706755518913,
    0.07316116243600845, -0.21509398519992828, 0.0015687458217144012, -0.09051676094532013, 0.09274497628211975, 0.07242351025342941, 0.007241552695631981, 0.05708491429686546,
    0.01782289706170559, 0.035971786826848984, -0.02888846956193447, -0.11110386252403259, -0.1981426179409027, -0.018157416954636574, -0.059573739767074585, 0.13627202808856964,
    -0.008611467666924, -0.012597057037055492, 0.07101299613714218, 0.055794607847929, -0.16632001101970673, 0.08411054313182831, 0.045467860996723175, -0.10986337065696716,
    0.0032919826917350292, -0.035446006804704666, 0.0015218225307762623, -0.04820860177278519, -0.06732486933469772, 0.024963153526186943, -0.006510342936962843, 0.01950119249522686,
    0.02397511713206768, 0.00826041679829359, -0.0021229484118521214, 0.030595479533076286, -0.18796150386333466, -0.12339397519826889, -0.10263294726610184, 0.06073372811079025,
    -0.006869318895041943, -0.02106841467320919, 0.00012911834346596152, -0.021126920357346535, -0.012764490209519863, -0.024457957595586777, 0.0293441042304039, -0.02151321992278099,
    0.022359520196914673, -0.005213378928601742, 0.021363824605941772, 0.004828878212720156, -0.03075110912322998, 0.019127625972032547, 0.02495506778359413, -0.04220539703965187,
    0.018868770450353622, -0.05753759667277336, -0.03334380313754082, 0.0045918733812868595, 0.03329920768737793, 8.253402484115213e-06, 0.022372420877218246, 0.010167828761041164,
    0.02958766557276249, -0.026285966858267784, 0.002356937387958169, -0.027811383828520775, 0.00840816367417574, 0.007822234183549881, -0.019360415637493134, -0.010517843998968601,
    0.021326815709471703, -0.0041905553080141544, 0.0032397995237261057, 0.008006168529391289, 0.01457308791577816, 0.013739644549787045, -0.005862702615559101, 0.01379559189081192,
    -0.028561875224113464, -0.044176653027534485, -0.017399953678250313, 0.04375509172677994, 0.010124473832547665, -0.018202634528279305, 0.04066013544797897, 0.012724850326776505,
    0.03430028632283211, 0.0590490885078907, -0.003423229558393359, -0.015738114714622498, 0.050408679991960526, -0.04947848618030548, -0.010635772719979286, -0.027660617604851723,
    -0.01846221089363098, -0.0035105771385133266, 0.0044759768061339855, 0.016382290050387383, 0.020103352144360542, -0.0006497917347587645, -0.01460825651884079, 0.00464367400854826,
    0.03068263828754425, 0.010234504006803036, -0.030078653246164322, 0.006412050221115351, -0.029205985367298126, 0.018363263458013535, -0.012576102279126644, 0.0208243690431118,
    0.005826860666275024, 0.009588383138179779, 0.00779298460111022, -0.023502729833126068, -0.0374453142285347, 0.03468189761042595, 0.060349442064762115, -0.0047935317270457745,
    0.0032702083699405193, -0.015218221582472324, -0.02180584892630577, -0.0029319259338080883, 0.05975768715143204, -0.013961998745799065, -0.018664637580513954, -0.009312274865806103,
    -0.018257703632116318, 0.025454219430685043, 0.008314702659845352, -0.018818628042936325, -0.015710806474089622, 0.0378623865544796, -0.01940622180700302, 0.03251279518008232,
    -0.027614548802375793, 0.019618935883045197, -0.0365603007376194, 0.03878828138113022, 0.0065562110394239426, 0.019855409860610962, 0.04784455895423889, 0.00994980987161398,
    0.04277319461107254, -0.019753670319914818, 0.035622283816337585, 0.02620229497551918, 0.029362667351961136, 0.038847170770168304, -0.020425688475370407, 0.021509937942028046,
    0.022404037415981293, -0.0039027321618050337, -0.016080334782600403, -0.005138260778039694, -0.024534542113542557, 0.035543542355298996, 0.00593138299882412, -0.02302580140531063,
    -0.0093843974173069, 0.01692882739007473, 0.00037664046976715326, 0.018052052706480026, 0.019283520057797432, -0.024880317971110344, -0.023358261212706566, -0.0008999904966913164,
    -0.023467300459742546, -0.006247932557016611, 0.036439843475818634, -0.0057981982827186584, -0.023422667756676674, 0.005925487261265516, -0.016211947426199913, 0.0010120752267539501,
    0.0347561351954937, -0.028962327167391777, 0.00668669817969203, -0.003392688697203994, -0.023965399712324142, 0.016125723719596863, 0.023668771609663963, 0.003909975290298462,
    0.03140304237604141, -0.018060509115457535, 0.014257650822401047, -0.04919098690152168, 0.027855830267071724, -0.031567953526973724, -0.027203409001231194, -0.023769836872816086,
    0.02290167100727558, 0.029509859159588814, 0.01597391813993454, -0.0038149908650666475, -0.006896656937897205, 0.010238067246973515, 0.009495297446846962, -0.016877826303243637,
    -0.01848774589598179, -0.021536732092499733, -0.020537978038191795, -0.04541459679603577, 0.023717055097222328, -0.00681287981569767, -0.028941815719008446, -0.01960834302008152,
    -0.016080588102340698, 0.013731490820646286, 0.015283527784049511, -0.0032178177498281, -0.01999696157872677, 0.006990210153162479, -0.003842454869300127, -0.005054001230746508,
    -0.015612686052918434, -0.03964685648679733, -0.008244741708040237, 0.016154732555150986, 0.005030907224863768, -0.0315810851752758, -0.014119056984782219, 0.034609150141477585,
    -0.002238126238808036, 0.0039163557812571526, -0.0006113286362960935, 0.0066049243323504925, 0.019903218373656273, -0.009800735861063004, 0.008463897742331028, 0.01157288532704115,
    -0.01201651431620121, 0.020752666518092155, 0.007723236456513405, -0.011369643732905388, 0.0025000220630317926, -0.018596436828374863, 0.04981540888547897, 0.023967111483216286,
    -0.02150535024702549, -0.0026894991751760244, 0.006850098259747028, 0.002389142755419016, -0.06022128835320473, -0.012968686409294605, 0.02571718394756317, -0.015783468261361122,
    0.00420151324942708, 0.009695173241198063, -0.010057725943624973, -0.006261193659156561, 0.04791131615638733, -0.0010041588684543967, 0.008414076641201973, 0.006724784150719643,
    -0.013695077039301395, -0.019192872568964958, -0.024488814175128937, -0.014943906106054783, 0.02361155115067959, 0.05219964683055878, -0.028190938755869865, 0.034446366131305695,
    0.028676988556981087, -0.002296190243214369, -0.01606868952512741, -0.008159141056239605, 0.0040342919528484344, -0.008215139620006084, 0.015372859314084053, 0.03561215475201607,
    0.02095756120979786, 0.028863156214356422, -0.06038805842399597, 0.03591275215148926, 0.004863971844315529, -0.0033105446491390467, 0.0026164508890360594, -0.015448135323822498,
    -0.016450852155685425, -0.026096267625689507, 0.022873496636748314, -0.03164659067988396, 0.005162836983799934, -0.04129265993833542, -0.03776779770851135, 0.012948809191584587,
    -0.00185486301779747, 0.006106863729655743, 0.005018118768930435, -0.024286508560180664, 0.0008798289927653968, 0.01285554375499487, 0.001832292997278273, -0.0010622965637594461,
    -0.0020903716795146465, -0.0033949697390198708, 0.01377878524363041, 0.012700462713837624, 0.0075003039091825485, -0.005857960786670446, -0.00021493187523446977, -0.01686789281666279,
    -0.00479867123067379, -0.032298743724823, -0.02066824398934841, 0.02265775017440319, 0.016676904633641243, 0.02255791798233986, -0.012045261450111866, 0.008312111720442772,
    -0.0023435356561094522, -0.007006539031863213, -0.012804368510842323, 0.02106771245598793, -0.028656037524342537, 0.019197171553969383, 0.016068296507000923, 0.03850896283984184,
    -0.017134157940745354, 0.015692060813307762, -0.006808577571064234, -0.02692277915775776, -0.051953285932540894, -0.0203335490077734, 0.0006590454140678048, -0.011705550365149975,
    0.01160528976470232, -0.00046363603905774653, -0.008432071655988693, 0.042551442980766296, 0.04122024402022362, 0.004722295794636011, -0.01546841487288475, -0.023386983200907707,
    -0.012413674034178257, 0.014153532683849335, 0.02538624219596386, -0.00843220204114914, -0.010617539286613464, 0.02167276106774807, 0.018860826268792152, -0.023934122174978256,
    -0.001421650405973196, -0.00699090538546443, -0.035991035401821136, -0.006296713836491108, -0.043759848922491074, -0.00027430738555267453, -0.0011830896837636828, -0.01263495720922947,
    0.01293846033513546, -0.009898426942527294, -0.01683969423174858, -0.004871990066021681, -0.0209098681807518, -0.00741503806784749, -0.001886108540929854, -0.003073836676776409,
    0.012559915892779827, -0.007328532170504332, 0.01267476100474596, 0.011185066774487495, 0.013744041323661804, -0.008061242289841175, 0.0010331877274438739, -0.014704981818795204,
    0.0003052221436519176, -0.005390612408518791, -0.021209683269262314, -0.02564726211130619, -0.015092849731445312, -0.022611133754253387, 0.028796250000596046, -0.01096312515437603,
    -0.003869521664455533, 0.0019607283174991608, 0.03879877179861069, 0.020630672574043274, -0.0997515395283699, -0.00935873668640852, 0.006320637185126543, -0.020551979541778564,
    -0.005310166161507368, -0.0016669250326231122, 0.01619422622025013, -0.028911545872688293, -0.0037871436215937138, -0.01886754482984543, -0.04023192077875137, 0.016159197315573692,
    -0.016455722972750664, -0.017081640660762787, -0.009230795316398144, 0.011693321168422699, 0.00907659251242876, -0.010020142421126366, -0.0021872997749596834, 0.01675407961010933,
    -0.0038597257807850838, -0.00939264241605997, 0.023159928619861603, -0.028139201924204826, 0.008399196900427341, 0.013016468845307827, -0.013851574622094631, 0.015609247609972954,
    -0.01734568178653717, -0.025043735280632973, 0.0129623394459486, -0.02101997286081314, 0.0190826915204525, -0.0058308993466198444, 0.005776293575763702, 0.0008895073551684618,
    0.010887029580771923, 0.026917481794953346, -0.002842727117240429, 0.030546685680747032, -0.00026661306037567556, 0.006561154033988714, -0.0061094267293810844, 0.016388677060604095,
    -0.0033143325708806515, -0.03892575576901436, -0.0093613276258111, -0.00811908207833767, 0.009651822969317436, -0.004729621112346649, -0.019061027094721794, 0.014470690861344337,
    -0.015565838664770126, 0.029307426884770393, 0.02009480446577072, 0.017596744000911713, -0.016898678615689278, -0.031878892332315445, 0.00471456116065383, -0.012806436978280544,
    0.019959725439548492, -0.012089517898857594, 0.005717119667679071, -0.03780866041779518, -0.018504410982131958, -0.02021445520222187, 0.02012423239648342, 0.008092908188700676,
    -0.015176176093518734, -0.014340926893055439, 0.0027440155390650034, 0.003104373812675476, -0.00919294636696577, 0.007544258143752813, -0.0022860600147396326, 0.01801791787147522,
    -0.01974678784608841, 0.010399755090475082, 0.010278698988258839, -0.013025748543441296, 0.0031730581540614367, -0.0022831582464277744, -0.00878740195184946, -0.02225652150809765,
    0.002452211221680045, -0.009705456905066967, -0.028600752353668213, 0.017292028293013573, 0.025634564459323883, -0.029534384608268738, 7.472082506865263e-05, 0.01902165077626705,
    0.004995063412934542, -0.00532977469265461, 0.027124295011162758, 0.0004897877806797624, 0.02223200537264347, 0.041529055684804916, -0.008474587462842464, -0.013002777472138405,
    -0.0025226937141269445, 0.010903415270149708, 0.054434094578027725, -0.021941667422652245, -0.011919978074729443, -0.0027500493451952934, -0.014362783171236515, -0.011846911162137985,
    -0.007441607303917408, -0.0032585866283625364, 0.006341963075101376, -0.035737816244363785, -0.0024842831771820784, 0.03477803245186806, 0.06301652640104294, 0.016163816675543785,
    -0.007482002954930067, -0.005913008004426956, 0.019808245822787285, -0.034988947212696075, -0.013688333332538605, 0.03842807188630104, -0.015618802979588509, 0.020741770043969154,
    0.012014856562018394, -0.00921300332993269, -0.0078061046078801155, 0.005875390022993088, 0.025824958458542824, 0.003297344781458378, -0.00232175481505692, -0.015121840871870518,
    0.028169255703687668, 0.0006149017135612667, -0.022185318171977997, 0.002049572765827179, -0.0011539317201822996, -0.016727019101381302, 0.009177010506391525, -0.004427595995366573,
    -0.0007200445979833603, -0.00045143626630306244, 0.004724786151200533, 0.005818639881908894, 0.01832369901239872, 0.010798772796988487, 0.01977565698325634, -0.03241943567991257,
    -0.005128716118633747, -0.003813540330156684, 0.03456283360719681, -0.04102581366896629, 0.044231902807950974, 0.011604048311710358, -0.00709118926897645, -0.014578700996935368,
    -8.055700891418383e-05, -0.010636883787810802, -0.02007439360022545, -0.021520990878343582, -0.022474348545074463, 0.03442986682057381, -0.014482793398201466, -0.005260010715574026,
    -0.02022531069815159, 0.013744316063821316, 0.007440950721502304, -0.008544293232262135, 9.391357161803171e-05, -0.001412383047863841, -0.0326269306242466, -0.023654980584979057,
    -0.006081294268369675, -0.0010138271609321237, -0.015196310356259346, -0.01283672172576189, -0.005606408696621656, 0.01705574057996273, 0.0037600707728415728, 0.010311980731785297,
    0.04098473861813545, -0.03285940736532211, 0.013015961274504662, -0.008337588980793953, -0.004217878915369511, -0.026839548721909523, 0.002957858145236969, -0.011201256886124611,
    -0.006344044115394354, -0.025186967104673386, -0.001286203390918672, -0.04242636263370514, -0.019186438992619514, -0.02691982127726078, 0.04593021795153618, -0.01618962362408638,
    0.023592602461576462, 0.020256411284208298, 0.015799006447196007, 0.030062736943364143, 0.004184824414551258, 0.0013712714426219463, -0.015236880630254745, -0.009058812633156776,
    0.03586356341838837, 0.007995367050170898, -0.018025629222393036, 0.012070249766111374, 0.03803559020161629, 0.011070108972489834, -0.006150624714791775, 0.020847124978899956,
    -0.026941431686282158, 0.004860082641243935, 0.011975321918725967, 0.03196923807263374, -0.018830768764019012, -0.020892281085252762, 0.010015739127993584, -0.0003290159802418202,
    -0.03143252432346344, 0.007312015630304813, 0.007843469269573689, -0.0016201632097363472, 0.03649413213133812, -0.027824249118566513, 0.036858540028333664, -0.004840746987611055,
    -0.042418625205755234, -0.011362065561115742, -0.058721259236335754, 0.023174520581960678, 0.021663911640644073, -0.018257303163409233, 0.010630149394273758, 0.016907421872019768,
    -0.008950775489211082, -0.013309557922184467, -0.011204960756003857, 0.026195676997303963, 0.008265380747616291, -0.005534312222152948, 0.015604192391037941, -0.0069289980456233025,
    0.026264803484082222, 0.019845426082611084, 0.023854676634073257, -0.002859032480046153, -0.019073020666837692, -0.026891449466347694, 0.010781709104776382, 0.009993067942559719,
    -0.010580391623079777, 0.008728553541004658, -0.00811704434454441, 0.006833059713244438, 0.11437363922595978, 0.014349909499287605, -0.012096570804715157, -0.019726185128092766,
    0.009646380320191383, 0.009540305472910404, 0.0026394836604595184, 0.03206401318311691, 0.0035555085632950068, 0.008424979634582996, -0.017740346491336823, 0.023055778816342354,
    -0.01304383110255003, -0.012581014074385166, -0.013582172803580761, 0.008731506764888763, -0.0008361421641893685, -0.02969738282263279, 0.006351117044687271, 0.00033603436895646155,
    -0.026379019021987915, -0.0002526854514144361, -0.05471811443567276, 0.01398896612226963, -0.031234215945005417, 0.017720744013786316, 0.008817792870104313, 0.014695029705762863,
    0.00892344955354929, 0.01395310927182436, 0.004145462531596422, -0.01893238164484501, -0.028982138261198997, -0.04636853188276291, -0.03269544616341591, -0.0198149885982275,
    0.013837124221026897, 0.018350724130868912, -0.011854740791022778, 0.005483932793140411, -0.017508825287222862, 0.014221047051250935, 0.03231985867023468, -0.014219601638615131,
    0.008829060010612011, 0.014851526357233524, -0.03383878618478775, -0.0032372253481298685, -0.020060952752828598, -0.012954962439835072, 0.04220642149448395, 0.04883623495697975,
    -0.010340818203985691, 0.01645796373486519, 0.005086872261017561, 0.01292793545871973, 0.011109989136457443, 0.011204813607037067, 0.03151223063468933, 0.011686299927532673,
    -0.015803193673491478, -0.016063030809164047, 0.0014357634354382753, 0.005519006866961718, 0.02199399657547474, -0.007876015268266201, 0.014705323614180088, -0.03447829931974411,
    -0.004107111133635044, 0.010200145654380322, 0.0009956773137673736, -0.004592748824506998, -0.012053524143993855, -0.016574742272496223, -0.0003919035370927304, 0.015215066261589527,
    -0.008441696874797344, -0.00736428564414382, -0.0070820944383740425, 0.023294255137443542, 0.04873434081673622, -0.02604455128312111, 0.003172942902892828, 0.01788104698061943,
    0.0046755108051002026, -0.018918493762612343, -0.006879716645926237, 0.006056332960724831, 0.029180966317653656, -0.025770841166377068, -0.0341251939535141, 0.008350354619324207,
    0.02100435644388199, 0.007400417700409889, -0.04072768986225128, 0.0026371623389422894, 0.03470347449183464, -3.1083818612387404e-05, -0.035369280725717545, 0.008711090311408043,
    -0.003567485837265849, 0.014320962131023407, -0.013617726974189281, -0.029748566448688507, 0.019040405750274658, 0.0012417981633916497, -0.008852233178913593, 0.0004152967594563961,
    -0.0012998756719753146, -0.021423477679491043, -0.048117317259311676, 0.023386994376778603, 0.007039849180728197, -0.007635058369487524, 0.005412537604570389, -8.239599992521107e-05,
    -0.02007300965487957, -0.02846439741551876, 0.020940952003002167, 0.005314167123287916, 0.017941493541002274, 0.01260465569794178, -0.0007114616455510259, 0.00023699399025645107,
    -0.01521771028637886, -0.02642853930592537, 0.00327515066601336, 0.027219317853450775, 0.02312815748155117, -0.018861163407564163, -0.023749500513076782, -0.006230479571968317,
    -0.03551372513175011, -0.05099895969033241, -0.004290382843464613, -0.015213113278150558, -0.003984249662607908, -0.0016672596102580428, -0.007478748448193073, -0.03314266353845596,
    -0.01089810486882925, -0.021488772705197334, -0.00194926664698869, 0.03134509548544884, -0.04324611648917198, 0.01297836471349001, -0.019724886864423752, -0.005640758201479912,
    -0.00039228389505296946, 0.01722777634859085, 0.031341418623924255, 0.01134729664772749, 0.022655531764030457, -0.036976248025894165, 0.003528691828250885, -0.001977049047127366,
    0.03414631262421608, 0.010486607439815998, -0.033981803804636, 0.0396430529654026, 0.02157718501985073, 0.008146916516125202, 0.0013809242518618703, -0.02101851813495159,
    0.0031812069937586784, -0.018039338290691376, -0.0019090230343863368, -0.004131291061639786, 0.015750600025057793, 0.025071967393159866, 0.037410374730825424, 0.03314625099301338,
    0.003098242450505495, -0.025984615087509155, -0.002913452684879303, -0.04645206034183502, -0.00909067690372467, -0.007435311563313007, -0.022809913381934166, -0.0025424701161682606,
    -0.00910945050418377, -0.006124868523329496, 0.02351319044828415, 0.0014994541415944695, -0.007801797240972519, -0.016073917970061302, 0.007958668284118176, -0.030966300517320633,
    -0.021610893309116364, 0.020495979115366936, 0.01073390245437622, -0.015459644608199596, -0.026659423485398293, 0.023677267134189606, -0.057559698820114136, 0.030266664922237396,
    -0.0006979762692935765, -0.0112149678170681, -0.0051772440783679485, -0.017762353643774986, 0.01768910512328148, 0.06132493168115616, 0.014766676351428032, 0.029581723734736443,
    -0.012634499929845333, 0.01367080956697464, 0.015321449376642704, 0.004506642464548349, -0.019013680517673492, 0.030618149787187576, -0.010444778017699718, -0.0012155200820416212,
    0.02386847324669361, -0.000277095939964056, 0.007512517273426056, -0.02437662146985531, -0.009239338338375092, 0.004046531859785318, 0.017590779811143875, -0.026112960651516914,
    0.04571837559342384, -0.0070327105931937695, 0.004469060339033604, 0.02568674460053444, -0.03683369979262352, 0.025405453518033028, 0.0001386984222335741, 0.01065819337964058,
    -0.02334095910191536, -0.009724915958940983, 0.028656907379627228, -0.010774804279208183, -0.03702062740921974, -0.023734161630272865, -0.0030759640503674746, -0.0091401357203722,
    0.029936285689473152, 0.029017457738518715, 0.05056653171777725, -0.036407582461833954, -0.03125522658228874, -0.0027025199960917234, 0.0057618701830506325, -0.013449927791953087,
    0.017308898270130157, 0.012964808382093906, 0.007731086574494839, 0.0003465360787231475, 0.01884944550693035, 0.01406361348927021, -0.0238109789788723, 0.005543599836528301,
    0.03219282999634743, -0.008814536035060883, -0.012535584159195423, 0.00275640026666224, -0.010216186754405499, 0.012278162874281406, 0.023551197722554207, 0.02173496223986149,
    0.01356645580381155, 0.028535090386867523, 0.010136593133211136, 0.02645438350737095, -0.0239234808832407, -0.02746657282114029, 0.005112892482429743, 0.020505016669631004,
    -0.01022427063435316, 0.019583048298954964, 0.0029142636340111494, 0.010492607951164246, 0.021118750795722008, 0.010368031449615955, 0.011410771869122982, -0.0011298327008262277,
    -0.0022831945680081844, -0.0021800855174660683, 0.00519041670486331, -0.034565724432468414, -0.015776239335536957, 0.009104752913117409, -0.045726630836725235, -0.03572273999452591,
    0.008030852302908897, -0.00400844682008028, 0.001089006196707487, -0.015464833937585354, 0.018704283982515335, 0.02829526923596859, -0.018381556496024132, -0.02816341444849968,
    -0.013078459538519382, 0.021798232570290565, -0.01950143650174141, 0.005274848081171513, -0.019032660871744156, -0.002274250378832221, -0.010859799571335316, 0.001296855160035193,
    0.02539617009460926, -0.004952430725097656, -0.016844412311911583, 0.020743630826473236, 0.02825194224715233, 0.012306845746934414, 0.005088660400360823, -0.029687425121665,
    0.02040683850646019, 0.0033106643240898848, 0.01896832510828972, 0.01642424426972866, 0.0315784327685833, -0.03255244344472885, -0.037516381591558456, -0.0422009713947773,
    -0.02112211287021637, 0.019963616505265236, 0.016443902626633644, -0.030795352533459663, 0.021834690123796463, -0.012587891891598701, 0.008239779621362686, -0.023273706436157227,
    -0.004420670215040445, 0.005143505521118641, -0.013003514148294926, 0.026475319638848305, -0.05589897558093071, -0.005571203306317329, 0.007607609499245882, -0.022506792098283768,
    -0.02345602586865425, -0.014207451604306698, 0.0012063333997502923, 0.012066059745848179, -0.010473692789673805, -0.011823032051324844, 0.01016324944794178, -0.021168790757656097,
    0.001470607123337686, -0.035123687237501144, -0.004134112037718296, 0.012595796026289463, 0.011285146698355675, 0.009328518994152546, 0.005695193074643612, 0.011838981881737709,
    -0.05225645378232002, 0.010914746671915054, 0.013288254849612713, -0.05013563856482506, -0.014642088674008846, 0.011897963471710682, -0.026562774553894997, 0.01747441291809082,
    -0.01912488229572773, -0.0021455504465848207, 0.015313467010855675, 0.0361560620367527, -0.008546498604118824, 0.02374940738081932, -0.006172013469040394, 0.025522010400891304,
    0.0017785221571102738, -0.032942675054073334, 0.01291700080037117, 0.015212740749120712, -0.005049637984484434, -0.0036758584901690483, 0.0034926251973956823, 0.006676747463643551,
    0.015768516808748245, 0.018015095964074135, 0.017054712399840355, 0.008923638612031937, -0.0006604397785849869, -0.0076468270272016525, 0.014223682694137096, 0.027082117274403572,
    -0.028377734124660492, 0.011966024525463581, -0.023828648030757904, 0.009993546642363071, -0.0463460236787796, -0.010160966776311398, 0.01722247153520584, 0.0020305963698774576,
    -0.014358940534293652, -0.02136618085205555, -0.00022728029580321163, 0.023988906294107437, -0.0016633191844448447, -0.014248708263039589, 0.008233338594436646, -0.018237672746181488,
    0.030486660078167915, 0.007176245097070932, -0.00025349948555231094, -0.021355319768190384, -0.010304783470928669, -0.023519815877079964, 0.028142085298895836, 0.025847194716334343,
    0.00015307473950088024, 0.009458777494728565, -0.009387221187353134, -0.03802669793367386, -1.65802521223668e-05, -0.003743821056559682, 0.01862763985991478, 0.022143632173538208,
    -0.008065902628004551, 0.03810792788863182, -0.015586376190185547, 0.03347158432006836, 0.007579383905977011, -0.015956027433276176, 0.0037694682832807302, -0.011741304770112038,
    0.005666238721460104, -0.03894759714603424, -0.012966958805918694, -0.008443768136203289, -0.023410366848111153, -0.023374496027827263, 0.01839701272547245, -0.038960739970207214,
    -0.006350862327963114, 0.028812075033783913, 0.057209279388189316, 0.014523089863359928, -0.01708230935037136, -0.00705059664323926, -0.0086048049852252, -0.009936008602380753,
    0.005758964456617832, -0.010263278149068356, 0.028748003765940666, 0.013962389901280403, -0.01606394164264202, 0.015335881151258945, -0.0016367548378184438, -0.0020292906556278467,
    0.03502555936574936, -0.0050386362709105015, 0.024871641770005226, -0.01698945090174675, -0.008982100524008274, -0.0027425293810665607, 0.00019462057389318943, -0.020750191062688828,
    0.020754393190145493, 0.002913626842200756, 0.03624797239899635, 0.0037708785384893417, 0.003911405801773071, 0.010805408470332623, 0.022129567340016365, 0.02767285890877247,
    -0.014220675453543663, 0.002200250281020999, -0.023813772946596146, 0.01158723421394825, -0.009064864367246628, 0.004290617071092129, 0.019645486027002335, 0.05399896949529648,
    -0.02045111358165741, -0.00693338131532073, 0.0038527175784111023, 0.0442839041352272, 0.004231004044413567, -0.025759072974324226, 0.02348960004746914, -0.011027705855667591,
    0.003175913356244564, 0.023742439225316048, -0.05558476969599724, 0.019754355773329735, 0.038801293820142746, -0.0007368993246927857, 0.02727806754410267, -0.04273010045289993,
    0.007273521739989519, -0.004296364262700081, -0.007805652916431427, -0.02368949167430401, -0.012510126456618309, -0.020938916131854057, 0.0030261739157140255, -0.015264838933944702,
    -0.0016208076849579811, 0.0009905045153573155, -0.022033723071217537, 0.03200994431972504, 0.02999781258404255, -0.009417451918125153, 0.017679916694760323, 0.008557372726500034,
    -0.0081397769972682, -0.03672250732779503, -0.007574176881462336, 0.002911222167313099, 0.014361163601279259, 0.005164142698049545, -0.012228397652506828, -0.04802829772233963,
    0.0019275317899882793, -0.0395059809088707, 0.022046411409974098, 0.0022917622700333595, 0.05930885300040245, 0.00892578437924385, 0.01894846372306347, -0.015585826709866524,
    -0.03047231212258339, -0.04593212530016899, 0.014359818771481514, -0.017150726169347763, -0.007555292919278145, -0.00759502686560154, 0.014352215453982353, -0.01181313768029213,
    -0.018868463113904, -0.01203569583594799, -0.010204610414803028, 0.01859833300113678, 0.0072332220152020454, 0.010016022250056267, -0.024853363633155823, -0.017210902646183968,
    0.015728916972875595, -0.022579750046133995, 0.0074696908704936504, 0.008976995944976807, -0.019861124455928802, 0.001909994171001017, -0.006601245142519474, 0.018954195082187653,
    0.008199217729270458, 0.0031492137350142, 0.0036386086139827967, -0.026084089651703835, 0.0444803349673748, 0.017173416912555695, -0.023867081850767136, -0.0060542868450284,
    0.01311258040368557, 0.008486098609864712, 0.01719260960817337, 0.005031237378716469, 0.014789678156375885, -0.016658885404467583, 0.008229193277657032, 0.01834944449365139,
    0.0018548679072409868, -0.00524628022685647, -0.007697046268731356, -0.03130142763257027, 0.026814021170139313, -0.003991218749433756, -0.00402066158130765, 0.008402151986956596,
    0.02369142696261406, -0.006214283872395754, -0.0016364885959774256, -0.038443781435489655, -0.025485830381512642, 0.03498663380742073, -0.021342124789953232, -0.006233588792383671,
    -0.013644824735820293, 0.006954333744943142, 0.032015569508075714, 0.004105431493371725, 0.004100407473742962, 0.011742928065359592, -0.025989947840571404, -0.001787620480172336,
    0.026681886985898018, -0.012149549089372158, -0.022829053923487663, -0.010733231902122498, -0.005833514034748077, 0.039817940443754196, -0.020266093313694, -0.02892397902905941,
    0.03511900454759598, -0.010700484737753868, 0.015491878613829613, -0.026639243587851524, 0.019242137670516968, 0.0016628543380647898, 0.0203857384622097, -0.011229029856622219,
    -0.014003986492753029, 0.01802590675652027, -0.029577501118183136, -0.02949494868516922, -0.026962950825691223, 0.02008448913693428, 0.017332443967461586, 0.019923148676753044,
    -0.007909187115728855, -0.0019975968170911074, 4.7842084313742816e-05, 0.02126196399331093, -0.006129604298621416, 0.014658205211162567, -0.015560047701001167, -0.005698700901120901,
    -0.01796402968466282, 0.009044456295669079, 0.039968524128198624, 0.008206048049032688, 0.026629650965332985, 0.011219908483326435, -0.010726864449679852, -0.0017136052483692765,
    0.006453223992139101, -0.015634270384907722, -0.003220171434804797, 0.006472344975918531, -0.025904105976223946, -0.022345159202814102, -0.01382999587804079, 0.010029608383774757,
    -0.009737090207636356, 0.02243582159280777, 0.00946087297052145, 0.02499091625213623, 0.003816040465608239, 0.00493610929697752, 0.01783803291618824, 0.03534208983182907,
    0.0020151359494775534, -0.0146313002333045, -0.007371852640062571, 0.01887257769703865, 0.03502705320715904, -0.006860409863293171, -0.02891317382454872, 0.02172141894698143,
    0.00545858358964324, 0.028971154242753983, -0.01672380231320858, 0.016298850998282433, -0.015589493326842785, -0.004087017383426428, -0.022738603875041008, 0.0022599278017878532,
    0.006148967891931534, 0.0024357843212783337, -0.01572362333536148, 0.009043123573064804, -0.030951863154768944, -0.003674932289868593, 0.021391019225120544, 0.011059577576816082,
    0.032558172941207886, 0.005768281873315573, 0.017697032541036606, 0.013165866956114769, -0.0031660771928727627, 0.012573528103530407, -0.045277390629053116, -0.020386550575494766,
    0.0065040974877774715, -0.0022528895642608404, -0.006618173327296972, 0.0378270149230957, -0.0067346664145588875, -0.00020991518977098167, 0.010660207830369473, -0.0044920132495462894,
    -0.028761107474565506, -0.02727791853249073, 0.009641163982450962, -0.0017457843059673905, 0.016798827797174454, 0.031837113201618195, 0.017346564680337906, 0.007191823795437813,
    -0.00046516870497725904, -0.03832437843084335, 0.05440114811062813, -0.0018308016005903482, 0.007384690456092358, -0.007793918717652559, -0.025851473212242126, 0.002707273233681917,
    -0.0059590330347418785, -0.05151602625846863, 0.0003643003583420068, 0.011344458907842636, 0.00048288574907928705, 0.00041104541742242873, -0.002047118730843067, 0.01732487976551056,
    0.01409058552235365, 0.021660273894667625, -0.01986248977482319, 0.005748346447944641, -0.006033165380358696, -0.0007170249591581523, -0.017071491107344627, 0.009665603749454021,
    -0.029802896082401276, 0.0015122037148103118, 0.0015863293083384633, 0.01348128356039524, 0.006867954041808844, 0.017932342365384102, 0.01964895986020565, -0.012629966251552105,
    0.03611214831471443, 0.038993969559669495, -0.037614502012729645, 0.026076866313815117, 0.009928086772561073, 0.011584214866161346, -0.030750209465622902, -0.006455081515014172,
    0.007071799598634243, -0.020074529573321342, 0.028697557747364044, 0.01417073979973793, -0.014188364148139954, -0.005238542798906565, -0.022669069468975067, 0.0104645611718297,
    0.0015547992661595345, -0.031511325389146805, -0.007606829516589642, 0.003670453792437911, -0.011352603323757648, -0.04191090539097786, 0.015151653438806534, -0.015662426128983498,
    -0.00511424383148551, -0.0046240827068686485, -0.03914634883403778, 0.02230772189795971, 0.015454534441232681, -0.010253731161355972, -0.013395432382822037, 0.01872446946799755,
    0.014582843519747257, 0.007787027396261692, 0.010629389435052872, 0.020395901054143906, 0.008365453220903873, 0.016718320548534393, -0.03704076632857323, -0.03861633688211441,
    0.010199012234807014, -0.011126156896352768, -0.019568435847759247, -0.03158482536673546, 0.02913985401391983, 0.002313596662133932, -0.014595339074730873, 0.04829857125878334,
    -0.008661814965307713, -0.009047137573361397, -0.02049136348068714, -0.037727005779743195, -0.011939897201955318, -0.0003859818389173597, 0.015249981544911861, -0.0007143457769416273,
    -0.008771872147917747, 0.01784915290772915, 0.01579234190285206, -0.014191164635121822, 0.040532417595386505, -0.014705714769661427, 0.005131661891937256, 0.031956639140844345,
    -0.0020095091313123703, 0.0013331397203728557, -0.001568197039887309, -0.010224402882158756, -0.010026340372860432, -0.020368430763483047, 0.004808430094271898, 0.01997975818812847,
    0.014433496631681919, 0.01457495242357254, -0.0230305977165699, -0.02460808865725994, -0.0011512787314131856, -0.017087118700146675, -0.013898154720664024, 0.0002065355220111087,
    0.03151918575167656, -0.004329413641244173, -0.014537641778588295, -0.006901037413626909, 0.014820214360952377, 0.00023431048612110317, -0.01670943759381771, -0.002499380148947239,
    -0.010050399228930473, 0.04873094707727432, -0.007021764293313026, 0.004349175374954939, -0.012312335893511772, 0.00743433553725481, -0.02615262195467949, -8.226517093135044e-05,
    0.020512321963906288, -0.0059845177456736565, -0.006347311194986105, 0.020366234704852104, -0.00881093181669712, -0.007854052819311619, 0.03303133696317673, 0.036248285323381424,
    -0.027370061725378036, 0.013962332159280777, -0.015319335274398327, 0.005590192973613739, 0.04235658422112465, -0.006945254281163216, -0.017345236614346504, 0.030063005164265633,
    -0.04836879298090935, -0.019164856523275375, -0.00047755055129528046, -0.032433878630399704, -0.009486054070293903, 0.00977382156997919, 0.026882465928792953, -0.014455458149313927,
    0.020423920825123787, -0.007363153621554375, 0.03012332320213318, 0.030696677044034004, -0.0359233133494854, -0.028399545699357986, 1.2603555660462007e-05, 0.030155232176184654,
    -0.021929066628217697, 0.0050932071171700954, 0.009771048091351986, -0.033765245229005814, -0.02519124373793602, -0.009360131807625294, 0.012690618634223938, 0.025868862867355347,
    0.02164669707417488, -0.026309357956051826, -0.017008380964398384, 0.022762484848499298, 0.03141888603568077, -0.0005359331262297928, 0.03843255341053009, -0.013772104866802692,
    0.018211647868156433, 0.0008860306697897613, -0.0065279086120426655, 0.007264882791787386, -0.025080054998397827, 0.008986919187009335, -0.019302450120449066, 0.008513989858329296,
    0.04723780229687691, 0.0045323544181883335, 0.004680523183196783, -0.0029295790009200573, -0.014881469309329987, 0.03148026019334793, -0.018819866701960564, -0.008048432879149914,
    -0.012860908173024654, 0.004735471215099096, 0.004750380292534828, -0.02365579828619957, -0.015969209372997284, 0.004123146180063486, 0.023162841796875, 0.027172742411494255,
    -0.040065620094537735, -0.021544871851801872, 0.017955265939235687, -0.010351588949561119, 0.01640711911022663, 0.013588746078312397, 0.034236446022987366, -0.008551775477826595,
    -0.004404283594340086, 0.00013925916573498398, -0.008893823251128197, 0.002423019614070654, -0.03489828482270241, -0.004983807448297739, -0.03615151718258858, -0.02668836899101734,
    0.031750988215208054, -0.01984318532049656, -0.00435319310054183, -0.001095556071959436, -0.02223270945250988, 0.006526615936309099, 0.004285736940801144, -0.05329813063144684,
    0.007972648367285728, -0.031030504032969475, 0.030637085437774658, -0.009910164400935173, -0.026740984991192818, 0.014246084727346897, 0.008087320253252983, -0.005641508381813765,
    -0.011280911043286324, -0.015392481349408627, 0.016118785366415977, -0.04917929694056511, 0.030913589522242546, 0.004796619992703199, -0.02726116217672825, 0.00567556032910943,
    -0.05100284516811371, 0.011044506914913654, 0.01409575343132019, -0.003149439347907901, -0.009941148571670055, 0.021068356931209564, -0.009215040132403374, 0.0034896833822131157,
    -0.010492105968296528, -0.0028588753193616867, -0.005427489522844553, 0.0019771545194089413, -0.010442852973937988, 0.005692532751709223, -0.022154973819851875, 0.03636046499013901,
    -0.005001016892492771, 0.010336748324334621, 0.008711078204214573, -0.04326305538415909, 0.002800402231514454, 0.007099850568920374, 0.014743270352482796, -0.0490209199488163,
    0.013504920527338982, 0.021656882017850876, 0.02008223347365856, -0.008829421363770962, -0.046391282230615616, -0.0024692860897630453, 0.013696768321096897, 0.009765521623194218,
    0.024716705083847046, -0.008019506931304932, -0.014555010944604874, 0.04873323440551758, 0.005571939516812563, 0.028985293582081795, 0.022344788536429405, -0.001832177978940308,
    0.01806466095149517, 0.015433092601597309, -0.015129588544368744, -0.012797052040696144, -0.01928117126226425, 0.02725321613252163, -0.014946040697395802, -0.0025944928638637066,
    0.03945310413837433, -0.010322600603103638, -0.006069491617381573, 0.02508498914539814, -0.016129445284605026, 0.02300356701016426, -0.02914479188621044, -0.013462145812809467,
    0.0013990435982123017, 0.008492737077176571, 0.007124073337763548, 0.0182435754686594, -0.02022758685052395, -0.003771779127418995, 0.0031740653794258833, -0.033777762204408646,
    0.020054643973708153, 0.000503862276673317, 0.038693346083164215, 0.03329550474882126, 0.00535708200186491, -0.007921065203845501, 0.01396319642663002, 0.01809879019856453,
    0.008517364971339703, 0.007606319151818752, 0.005339177791029215, -0.029590703547000885, -0.033067259937524796, -0.0382666140794754, 0.010479160584509373, -0.004106761422008276,
    -0.005591206718236208, -0.017054177820682526, -0.03519511595368385, 0.012734845280647278, 0.0013303076848387718, 0.029677879065275192, 0.008106745779514313, 0.012817124836146832,
    0.00327015807852149, 0.016537059098482132, 0.019582416862249374, 0.03727171942591667, 0.023741139099001884, -0.023039821535348892, 0.011145523749291897, -0.01583382673561573,
    0.0212151687592268, 0.0407877117395401, 0.023533562198281288, -0.004237185698002577, 0.06139903888106346, -0.00489939097315073, 0.018777823075652122, -0.007220283150672913,
    -0.007855406031012535, 0.014278496615588665, -0.013439947739243507, -2.8581272999872454e-05, 0.011636913754045963, -0.023340756073594093, -0.028415126726031303, 0.041336048394441605,
    0.015225892886519432, 0.03730768337845802, 0.03359411284327507, 0.05498000606894493, 0.024339206516742706, -0.001703417394310236, -0.012945706956088543, -0.005121828988194466,
    -0.002202973933890462, 0.017024151980876923, -0.016287291422486305, 0.025004224851727486, -0.004739508964121342, -0.0020320387557148933, 0.016111178323626518, 0.03545713797211647,
    -0.017128832638263702, -0.013235320337116718, -0.002078995807096362, -0.04933144524693489, 0.00021997373551130295, -0.009290356189012527, 0.0006230346043594182, -0.006410346366465092,
    0.002154511632397771, 0.012322163209319115, -0.0035089515149593353, -0.005274997558444738, -0.008658637292683125, 0.019724158570170403, 0.021431179717183113, -0.011019811034202576,
    0.004969199188053608, 0.009071086533367634, -0.01683078706264496, 0.01284023467451334, 0.006158411502838135, -0.006463330704718828, -0.010367150418460369, -0.0029950812458992004,
    0.004042267799377441, -0.005131662357598543, 0.005996589083224535, 0.010996720753610134, 0.0025729804765433073, -0.007693534716963768, 0.025131186470389366, -0.016609063372015953,
    0.049713216722011566, -0.012367661111056805, 0.02221960760653019, 0.01370968110859394, -0.019475938752293587, 0.00949845090508461, 0.03248513117432594, -0.009603409096598625,
    -0.0323953703045845, -0.006246704142540693, -0.00703564565628767, -0.0017503438284620643, -0.0006097608711570501, 0.01282048225402832, -0.0023819541092962027, 0.012035432271659374,
    0.024618985131382942, -0.033200208097696304, -0.011222545057535172, 0.0052860635332763195, 0.023113662376999855, -0.024778321385383606, 0.02381134033203125, 0.03400437533855438,
    -0.02008230797946453, -0.0026130839250981808, 0.0062339878641068935, -0.011868649162352085, 0.01339095551520586, -0.01679881475865841, -0.048854269087314606, 0.01758039928972721,
    -1.865993908722885e-05, -0.0012005624594166875, -0.03359081968665123, 0.007903436198830605, 0.04238216206431389, 0.004939304664731026, -0.015888355672359467, 0.006507813464850187,
    -0.007504231762140989, -0.0017468532314524055, -0.007358280476182699, 0.028594279661774635, 0.010753833688795567, -0.001643243944272399, 0.005192766897380352, 0.0031532347202301025,
    0.024083489552140236, 0.042613301426172256, -0.010485561564564705, -0.03609537333250046, 0.028326302766799927, -0.012279977090656757, -0.015871582552790642, -0.008784807287156582,
    0.023958830162882805, -0.006202332675457001, 0.008852124214172363, 0.006042684428393841, -0.011612911708652973, 0.016004091128706932, -0.009742796421051025, -0.017828239127993584,
    -0.017993682995438576, 0.02003118209540844, 0.007570246700197458, -0.0007192529155872762, -0.0065369438380002975, -0.0036658879835158587, 2.985097853525076e-05, 0.012278596870601177,
    -0.06939805299043655, -0.006425760220736265, 0.01585512049496174, 0.029106881469488144, 0.011015803553164005, -0.016503803431987762, 0.012354234233498573, 0.02728707529604435,
    0.0043861581943929195, 0.00832754373550415, -0.042795125395059586, -0.0007985903066582978, 0.06630320847034454, 0.003147433279082179, 0.018929248675704002, 0.01058129221200943,
    0.0006708139553666115, 0.006145576946437359, 0.01817314885556698, 0.027218934148550034, -0.02154800295829773, -0.024910427629947662, 0.0066271317191421986, -0.04328657314181328,
    0.050340257585048676, -0.012890919111669064, -0.03863935545086861, -3.117255255347118e-05, -0.02382490783929825, -0.014892629347741604, 0.0088655399158597, 0.005399924237281084,
    -0.019450807943940163, -0.00886746495962143, 0.03284306451678276, 0.000399393291445449, -0.0035344669595360756, -0.01985747367143631, 0.017406539991497993, 0.04447457566857338,
    0.016574377194046974, -0.028636349365115166, 0.03305021673440933, 0.042077094316482544, -0.03546210005879402, -0.0023517757654190063, 0.02677050046622753, 0.022153576835989952,
    -0.036563243716955185, 0.028486168012022972, 0.0035670462530106306, 0.003281892044469714, 0.03737272322177887, 0.001331888372078538, -0.017647599801421165, -0.005238704849034548,
    -0.01358943060040474, 0.047539032995700836, -0.02573269233107567, -0.018772779032588005, 0.021144503727555275, 0.012587200850248337, 0.002597525017336011, 0.022388793528079987,
    -0.010975880548357964, -0.004815218970179558, 0.022272415459156036, 0.0013790612574666739, 0.004987616557627916, 0.032984163612127304, 0.021715454757213593, -0.014742029830813408,
    -0.028936021029949188, 0.005979768466204405, 0.02099582552909851, 0.0005378028727136552, -0.012620808556675911, -0.0047776405699551105, -0.0012432355433702469, -0.015688089653849602,
    0.0010390892857685685, 0.0015875782119110227, 0.026081811636686325, 0.0070406547747552395, 0.028552476316690445, 0.04440948739647865, -0.018122760578989983, 0.013471504673361778,
    -0.024653039872646332, 0.013205187395215034, 0.015270067378878593, -0.035807278007268906, 0.0546148307621479, -0.004186620004475117, 0.012260455638170242, 0.022927943617105484,
    0.010110224597156048, -0.0053640506230294704, -0.02955743856728077, -0.009209007024765015, 0.0214748065918684, -0.00436635036021471, -0.05138075351715088, 0.006787883583456278,
    -0.010952533222734928, -0.00493138050660491, 0.004844541195780039, -0.0032934886403381824, 0.016169244423508644, -0.017379155382514, -0.007188545539975166, 0.0027144569903612137,
    0.005774256307631731, 0.020744923502206802, 0.005482587963342667, -0.021976817399263382, 0.008873464539647102, 0.0018509328365325928, -0.033897146582603455, 0.02305859886109829,
    -0.0023997139651328325, -0.051783617585897446, -0.03004780225455761, 0.008331707678735256, -0.07883121073246002, 0.010666059330105782, -0.034500397741794586, 0.009607973508536816,
    0.0002184624463552609, 0.036255236715078354, -0.009931394830346107, -0.03753364831209183, -0.026039477437734604, 0.006648974027484655, 0.023722805082798004, -0.016280636191368103,
    0.031144065782427788, -0.035121139138936996, 0.010933628305792809, -0.045475367456674576, -0.013701858930289745, -0.024074872955679893, -0.05800902098417282, 0.03269834443926811,
    0.013049066066741943, 0.009138159453868866, -0.012703846208751202, -0.015900369733572006, 0.007105107419192791, 0.002566075185313821, -0.028337471187114716, 0.007954022847115993,
    -0.044935207813978195, -0.007750286255031824, 0.005225987173616886, 0.011559256352484226, 0.023049814626574516, 0.02453005686402321, -0.025472600013017654, -0.025805238634347916,
    0.012143688276410103, -0.021633775904774666, 0.008058846928179264, 0.00033849437022581697, -0.012690247036516666, 0.028858652338385582, -0.03213861957192421, -0.015946093946695328,
    0.004453712143003941, -0.012997029349207878, 0.06436888128519058, 0.01529845129698515, 0.0011599846184253693, 0.008474924601614475, -0.024892672896385193, -0.029271045699715614,
    0.031593207269907, -0.01698809303343296, -0.016471276059746742, 0.011631791479885578, -0.006337536033242941, 0.01033698208630085, -0.018603835254907608, -0.0026104478165507317,
    -0.011842007748782635, 0.003636147826910019, -0.03584204241633415, 0.019270334392786026, 0.015012342482805252, 0.018903763964772224, -0.003956343047320843, 0.007472034078091383,
    -0.0020180544815957546, 0.013630497269332409, 0.004907060880213976, -0.010564908385276794, 0.01888047158718109, 0.022559642791748047, 0.0015456016408279538, -0.023541880771517754,
    -0.02093263901770115, 0.0367305614054203, 0.008312254212796688, 0.008299115113914013, -0.03622901067137718, 0.01784673146903515, -0.014602919109165668, -0.0025359264109283686,
    0.029996655881404877, -0.009709028527140617, -0.010670208372175694, -0.008008589036762714, 0.034374773502349854, 0.02393382228910923, 0.005795001983642578, 0.007277973927557468,
    0.0011573246447369456, 0.01054979395121336, -0.011877820827066898, -0.023693427443504333, -0.03441985324025154, 0.009607094340026379, -0.0009830216877162457, -0.015967849642038345,
    -0.010353568010032177, 0.0016584931872785091, 0.021220773458480835, -0.04940125718712807, -0.012513884343206882, 0.0035449948627501726, 0.016868842765688896, -0.017880240455269814,
    -0.007513093296438456, 0.0015296331839635968, 0.009875208139419556, -0.014570990577340126, -0.03993864730000496, -0.012410784140229225, -0.03274528309702873, 0.004038161598145962,
    0.014661380089819431, 0.023482363671064377, -0.018605617806315422, 0.017431387677788734, 0.011915011331439018, -0.011711801402270794, -0.015213357284665108, 0.022937726229429245,
    0.015041764825582504, -0.02180001698434353, 0.012635620310902596, 0.011923217214643955, 0.022076841443777084, -0.003115392290055752, 0.009954886510968208, -0.015085780061781406,
    0.052505750209093094, 0.014284616336226463, 0.006460251286625862, 0.026167307049036026, -0.02411758154630661, -0.030013717710971832, 0.018210656940937042, 0.021193435415625572,
    -0.014261072501540184, 0.025898518040776253, 0.0349496528506279, 0.043298687785863876, -0.0124187171459198, -0.02153998427093029, 0.03006138652563095, -0.017727112397551537,
    -0.013783738948404789, -0.0012838463298976421, 0.019411446526646614, 0.011902187019586563, -0.01986907795071602, 0.007933643646538258, -0.04508250951766968, 0.023343758657574654,
    -0.023307571187615395, 0.0004672799841500819, 0.022880714386701584, -0.0200364850461483, 0.02426278591156006, 0.01857818104326725, 0.003377579851076007, -0.005414594430476427,
    0.02928449772298336, -0.03987277299165726, -0.025377372279763222, -0.0007946463883854449, -0.0008527084137313068, 0.004803990013897419, -0.03785483166575432, -0.010759389959275723,
    0.014828125014901161, 0.015334776602685452, 6.27361296210438e-05, -0.002199178794398904, -0.014053702354431152, -0.010701869614422321, -0.019773514941334724, -0.009921521879732609,
    -0.0004631603369489312, 0.01191573403775692, -0.008038208819925785, -0.01365065947175026, 0.009727445431053638, 0.02867436222732067, -0.0022619240917265415, 0.003735749516636133,
    0.019198430702090263, 0.015644647181034088, 0.028786666691303253, 0.014821134507656097, -0.02127191051840782, -0.006595822051167488, 0.0030171156395226717, 0.0005547969485633075,
    -0.0026873124297708273, 0.003962317947298288, 0.0048385788686573505, -0.002242457587271929, -0.04275846853852272, 0.00028310625930316746, 0.007395633962005377, -0.011865856125950813,
    -0.008150643669068813, -0.015402247197926044, -0.004540688823908567, 0.002029649680480361, -0.02276439592242241, -0.009211941622197628, -0.03511687368154526, 0.0038019444327801466,
    -0.019336501136422157, -0.022659623995423317, 0.008785802870988846, 0.01285362709313631, -0.014809839427471161, 0.007435385137796402, -0.04930877313017845, -0.03235381096601486,
    -0.005533245392143726, -0.04982255399227142, 0.0058891805820167065, 0.0039512054063379765, -0.02402893640100956, 0.019213685765862465, 0.013748236000537872, -0.013049779459834099,
    0.027346165850758553, -0.00417736591771245, -0.03838557377457619, -0.0008496225927956402, -0.01628430187702179, -0.0018291163723915815, 0.01806160807609558, 0.004627442918717861,
    0.028070246800780296, -0.01939878612756729, -0.01602490060031414, 0.002721326658502221, 0.02918859012424946, 0.015474674291908741, -0.02556746080517769, 0.004625221714377403,
    0.029470743611454964, -0.02726900763809681, -0.005532054230570793, -0.010854791849851608, 0.007037956267595291, 0.005005513317883015, 0.010945036076009274, -0.03421444073319435,
    -0.009881465695798397, 0.03195822983980179, -0.025120995938777924, 0.015009025111794472, 0.046577174216508865, 0.014265252277255058, -0.004472165834158659, 0.00507231242954731,
    -0.018207861110568047, -0.013041984289884567, -0.004079490900039673, -0.020450664684176445, -0.0027847622986882925, 0.015509801916778088, -0.02028059773147106, 0.029446136206388474,
    0.0008879171800799668, -0.0005159037536941469, 6.277344073168933e-05, 0.0017611754592508078, -0.007823369465768337, -0.016332419589161873, 0.021496854722499847, -0.03578600287437439,
    -0.005606314167380333, 0.027596263214945793, -0.03405606001615524, 0.0010962462984025478, 0.030322974547743797, -0.01602049358189106, 0.016612928360700607, -0.037834033370018005,
    0.010731935501098633, -0.008470931090414524, -0.022255299612879753, -0.02641286887228489, -0.007991926744580269, -0.016614584252238274, 0.00016209557361435145, 0.016498863697052002,
    0.03604432940483093, -0.0217298436909914, 0.013243557885289192, -0.004481527954339981, 0.042112261056900024, 0.012945758178830147, 0.030161812901496887, 0.011971765197813511,
    -0.00273909792304039, -0.0018423062283545732, -0.05019872635602951, 0.0013508728006854653, 0.017086422070860863, 0.0017499251989647746, 0.0037392941303551197, 0.011229705065488815,
    -0.011956751346588135, -0.009237302467226982, 0.005759912542998791, -0.0133550725877285, 0.03064832277595997, -0.011263062246143818, 0.0037013355176895857, -0.018175499513745308,
    -0.023555206134915352, -0.003905731253325939, -0.0368209183216095, -0.0073520769365131855, 0.028220754116773605, -0.015900744125247, -0.001973396632820368, -0.02007133886218071,
    -0.017106158658862114, -0.013398180715739727, -0.017590340226888657, 0.022032316774129868, -0.0032167257741093636, 0.016973063349723816, -0.030463140457868576, -0.029251057654619217,
    -0.022572830319404602, -0.03541089594364166, -0.021243887022137642, -0.01332246232777834, 0.021009454503655434, -0.014342881739139557, 0.06878048181533813, -0.0066476305946707726,
    0.01949579268693924, 0.003217517165467143, -0.011949184350669384, -0.0026422550436109304, -0.004495141562074423, 0.011100281961262226, 0.036426518112421036, -0.0087150102481246,
    -0.02268393710255623, -0.04440886527299881, 0.016602875664830208, -0.007369630504399538, 0.04482785239815712, -0.027109501883387566, -0.002483914140611887, -0.011757626198232174,
    -0.012037459760904312, 0.003806372871622443, 0.02088565193116665, 0.02210327982902527, -0.025331584736704826, 0.01660972274839878, -0.015242296271026134, -0.0017897185171023011,
    -0.014228965155780315, 0.006893496494740248, -0.016866372898221016, 0.008462213911116123, -0.010083080269396305, 0.01735829934477806, 0.014697100035846233, -0.002757903654128313,
    -0.03962209075689316, 0.03320673853158951, 0.03066891059279442, 0.006212570238858461, -0.0282223429530859, 0.003941214643418789, -0.02366248145699501, -0.01226820144802332,
    -0.004631549585610628, -0.023141877725720406, -0.013027646578848362, -0.0056620496325194836, 0.021364279091358185, -0.01860416680574417, -0.002421064069494605, -0.010871868580579758,
    -0.04867421090602875, -0.03965679928660393, -0.005335570313036442, -0.003913550637662411, -0.009044048376381397, -0.00886749941855669, 0.007099595852196217, -0.004053464625030756,
    -0.005802060943096876, -0.03025563433766365, -0.034037429839372635, 0.0004814697022084147, -0.020528269931674004, 0.011016177013516426, -0.00823652558028698, -0.0003470091905910522,
    -0.004077374469488859, -0.008777482435107231, 0.02658701501786709, 0.032975707203149796, -0.006725024431943893, 0.006156380288302898, -0.011828948743641376, 0.010333005338907242,
    -0.013871937990188599, 0.034595005214214325, 0.013330343179404736, 0.036671556532382965, 0.011483892798423767, 0.007809268776327372, -0.009768548421561718, -0.009732901118695736,
    -0.00985187478363514, -0.005217661149799824, 0.026333656162023544, -0.004233440384268761, -0.01883121393620968, 0.013838726095855236, 0.01788748987019062, 0.006016403902322054,
    -0.002851332537829876, -0.010210209526121616, 0.03952906280755997, -0.0019405909115448594, -0.013721662573516369, -0.008696731179952621, 0.022474627941846848, -0.03539649769663811,
    -0.022329814732074738, -0.023300904780626297, 0.01606455072760582, 0.045216452330350876, -0.06332581490278244, 0.01873275823891163, 0.02152980864048004, -0.04339950159192085,
    0.005184621084481478, 0.022814054042100906, -0.04884687066078186, 0.0214201882481575, -0.002695676637813449, 0.017281608656048775, 0.003925348166376352, 0.049077827483415604,
    0.020860619843006134, 0.009266024455428123, 0.015463692136108875, -0.020045651122927666, -0.008182025514543056, -0.005229660775512457, 0.004433953668922186, 0.015662750229239464,
    -0.004246273078024387, 0.020295720547437668, 0.043298158794641495, -0.002113788388669491, -0.043928492814302444, 0.017778441309928894, -0.01007760874927044, -0.021114591509103775,
    -0.017862392589449883, -0.049078598618507385, -0.01843906380236149, -0.011979315429925919, -0.0031870484817773104, -0.014591194689273834, 0.013597528450191021, 0.017795544117689133,
    0.07554791122674942, 0.02735285647213459, -0.01038846280425787, 0.0007194086792878807, 0.020623181015253067, -0.02161252126097679, -0.011171278543770313, -0.025327131152153015,
    0.019003288820385933, -0.001711037359200418, 0.0008959561237134039, -0.0354764387011528, 0.013239073567092419, -0.004957033786922693, 0.016290869563817978, -0.004034482873976231,
    0.01838678866624832, 0.021236702799797058, 0.03012075275182724, 0.015715479850769043, 0.016783883795142174, 0.005759451072663069, 0.0014741347404196858, -0.007729111704975367,
    0.013109738007187843, -0.008981266058981419, 0.020490573719143867, -0.013113788329064846, 0.007984913885593414, -0.006535060238093138, -0.025929097086191177, 0.023571068421006203,
    0.03067050874233246, -0.03227142244577408, 0.0220223069190979, -0.017630012705922127, -0.02031654305756092, -0.009455655701458454, 0.03711758926510811, -0.00883693527430296,
    0.01927519403398037, 0.09155850112438202, 0.027891071513295174, 0.02661883272230625, -0.0037780748680233955, -0.01405899878591299, -0.011653682217001915, 0.05527627095580101,
    0.02207852713763714, -0.010071635246276855, -0.011189947836101055, -0.004535776562988758, 0.03404654189944267, -0.013466358184814453, -0.0023418262135237455, 0.0010484977392479777,
    -0.0010515761096030474, -0.009747727774083614, -0.03199637681245804, -0.004482743330299854, -0.01693144626915455, -0.005730721168220043, 0.008292632177472115, 0.03105476312339306,
    -0.0025498198810964823, -0.027802035212516785, 0.004890298470854759, -0.01776966266334057, -0.029897447675466537, 0.008747519925236702, -0.0005629060324281454, 0.00329542625695467,
    -0.020414026454091072, 0.03664218261837959, 0.0028522051870822906, 0.002412780188024044, -0.0244105476886034, 0.012165158987045288, -0.004669998772442341, -0.009789003059267998,
    -0.0038573609199374914, -0.027239304035902023, -0.06334318220615387, 0.017705293372273445, -0.050782460719347, -0.008384859189391136, -0.03057555854320526, 0.00697264913469553,
    -0.020516710355877876, -0.00675909873098135, -0.017687002196907997, 0.03677576407790184, 0.025745520368218422, 0.017288321629166603, 0.002265769988298416, -0.020805135369300842,
    -0.03984963148832321, -0.004837958142161369, 0.010075055062770844, -0.0319075845181942, 0.010414731688797474, -0.018140258267521858, -0.025819242000579834, -0.025800028815865517,
    0.01103837601840496, 0.009171274490654469, 0.002500694477930665, -0.005311532877385616, 0.022590022534132004, -0.03412475064396858, -0.036166463047266006, -0.02017165906727314,
    -0.032093293964862823, 0.009079053066670895, 0.003662646748125553, -0.0097226956859231, -0.011486897245049477, -0.005839354358613491, -0.044126685708761215, 0.002537220250815153,
    0.012518718838691711, -0.007666957564651966, -0.023191627115011215, 0.008603034541010857, 0.010072014294564724, -0.005470567382872105, -0.017165470868349075, 0.040165193378925323,
    -0.012746208347380161, 0.015712086111307144, 0.01297522708773613, -0.03712267428636551, -0.04658368229866028, 0.03161575645208359, -0.008853217586874962, 0.03901207074522972,
    0.02026227116584778, 0.003189426613971591, 0.057070594280958176, -0.009893016889691353, 0.0014905153075233102, 0.01972728781402111, 0.038242027163505554, 0.009345206432044506,
    0.0052850693464279175, -0.03734106570482254, 0.005446302704513073, -0.02716345712542534, 0.024385323747992516, 0.0051496452651917934, -0.02369002439081669, 0.023470841348171234,
    0.012259812094271183, 0.0075950357131659985, -0.0002576318511273712, 0.020046314224600792, -0.03607828915119171, 0.007795901969075203, 0.0002063620777335018, -0.0013127633137628436,
    -0.02809458039700985, 0.03127375245094299, 0.0001877401809906587, -0.010812646709382534, 0.004471905063837767, -0.011027409695088863, -0.014875663444399834, 0.01244047936052084,
    -0.014349776320159435, -0.026694439351558685, -0.011155746877193451, 0.02355181612074375, 0.007096365559846163, 0.003023203695192933, 0.045082107186317444, -0.06259472668170929,
    -0.008265197277069092, 0.005925004370510578, 0.017819905653595924, -0.01813049241900444, -0.058218780905008316, 0.0035518689546734095, -0.019341474398970604, 0.006651217583566904,
    0.0051933275535702705, -0.007983904331922531, 0.029495293274521828, 0.011393904685974121, 0.02454483136534691, -0.009462776593863964, -0.007924282923340797, -0.022383809089660645,
    -0.020885882899165154, -0.0010934460442513227, -0.0018584744539111853, 0.059478510171175, -0.02547634392976761, 0.02666592411696911, -0.016516711562871933, 0.0032065492123365402,
    0.030774084851145744, -0.011834751814603806, -0.018397687003016472, -0.006690596230328083, 0.03616957738995552, 0.02226370759308338, 0.025433337315917015, -0.03800765797495842,
    -0.007573838345706463, -0.024471653625369072, -0.03243317827582359, -0.018168320879340172, -0.021024199202656746, 0.003792553674429655, -0.011223440058529377, -0.02035667560994625,
    0.0011124698212370276, 0.03138625994324684, -0.02906936965882778, -0.04728428274393082, 0.05367622524499893, -0.01455963309854269, 0.009693082422018051, 0.0022617352660745382,
    -0.017021680250763893, -0.007622556760907173, 0.011075924150645733, -0.03609312325716019, 0.046077340841293335, 0.027966884896159172, -0.0011030681198462844, -0.02414041943848133,
    -0.012810948304831982, -0.016400134190917015, -0.0001642808347241953, 0.03347631171345711, -0.009928672574460506, -0.028049204498529434, 0.022082434967160225, -0.018408000469207764,
    0.00040382592123933136, -0.005854913964867592, -0.027953628450632095, 0.004383863881230354, -0.0004092745075467974, -0.00020468969887588173, -0.015753136947751045, -0.0008031438337638974,
    0.010250176303088665, 0.033899225294589996, -0.009687799029052258, -0.03385261073708534, -0.002675357973203063, 0.010794064961373806, -0.0054625654593110085, -0.011102967895567417,
    -0.04276879131793976, -0.008656609803438187, 0.024736369028687477, 0.003577738767489791, -0.03110746666789055, -0.024715103209018707, 0.015459442511200905, 0.003259798279032111,
    0.015658820047974586, 0.0034558482002466917, 0.01403758767992258, 0.008184803649783134, 0.01699739322066307, 0.020083112642169, -0.00531270494684577, -0.009889709763228893,
    -0.0013858589809387922, -0.044653572142124176, -0.025578951463103294, -0.023000286892056465, -0.01477012224495411, 0.022969301789999008, 0.02647336944937706, 0.006344578228890896,
    -0.034319497644901276, -0.0005614584079012275, -0.018526488915085793, -0.03225705400109291, -0.03824695572257042, 0.011049020104110241, -0.018381118774414062, 0.012817190028727055,
    0.023301847279071808, -0.009678136557340622, -0.020551327615976334, 0.02023906446993351, 0.05266872048377991, -0.00022088055266067386, -0.006804442033171654, 0.01620814949274063,
    -0.031497348099946976, -0.04098308086395264, 0.00751796830445528, -0.02648770436644554, -0.01253440324217081, 0.018509451299905777, 0.003587809856981039, 0.02585586905479431,
    -0.023292481899261475, 0.012654898688197136, -0.03566186875104904, 0.0017041987739503384, -0.0229151900857687, 0.018860988318920135, -0.016305558383464813, -0.07097423821687698,
    -0.0009684781543910503, -0.013268643990159035, 0.0011034662602469325, 0.00046521512558683753, 0.02217942103743553, 0.02177874930202961, -0.0247882641851902, 0.032131217420101166,
    -0.017372922971844673, 0.010245135985314846, 0.010867484845221043, -0.016957931220531464, 0.05952933058142662, -0.005063875112682581, -0.03135661035776138, 0.0008135480456985533,
    0.001816899050027132, -0.04674701392650604, -0.012589874677360058, 0.0039939600974321365, 0.01344815269112587, 0.023264368996024132, -0.004432365298271179, -0.033277854323387146,
    -0.010037600062787533, 0.08036670833826065, 0.01908532716333866, -0.008821668103337288, 0.02850727178156376, 0.0032199430279433727, 0.03465325012803078, -0.010776137933135033,
    0.003093233099207282, -0.006286240182816982, 0.018713675439357758, 0.008341572247445583, -0.05926424637436867, -0.025189124047756195, 0.00847482867538929, -0.0068484037183225155,
    0.046006571501493454, 0.01077557634562254, 0.012411156669259071, 0.026963816955685616, -0.004058935213834047, 0.02176489122211933, -0.0145766856148839, 0.011869748122990131,
    -0.0199726615101099, 0.008283035829663277, 0.013500343076884747, -0.02024737559258938, -0.01233627088367939, 0.0065676141530275345, 0.008673031814396381, 0.016721656545996666,
    0.03754894435405731, 0.010362839326262474, 0.01197146251797676, 0.050236646085977554, -0.009120081551373005, 0.0073656667955219746, 0.00867373775690794, 0.012584432028234005,
    0.007268087472766638, -0.06452193856239319, 0.027511874213814735, 0.027904395014047623, -0.0076879533007740974, -0.00756555050611496, 0.022058116272091866, 0.009822163730859756,
    0.058184269815683365, -0.030026117339730263, -0.001791571150533855, 0.03485005721449852, 0.03314289078116417, -0.021166985854506493, 0.011970935389399529, -0.05124729871749878,
    -0.03551569953560829, 0.0024313898757100105, -0.03469082713127136, -0.01750413328409195, 0.02829935774207115, -0.01642323099076748, 0.037775978446006775, 0.0010245137382298708,
    -0.0034943881910294294, 0.030481811612844467, -0.04669138416647911, 0.009528052061796188, 0.020303864032030106, 0.014609045349061489, -0.0003020330041181296, 0.002226866316050291,
    0.007525056134909391, 0.0018955389969050884, -0.04164941981434822, 0.037670839577913284, -0.003641536459326744, -0.009501190856099129, -0.03360883519053459, 0.02040078677237034,
    -0.001026803394779563, -0.05285663902759552, 0.008171910420060158, 0.0209745392203331, -0.005596843082457781, -0.009949512779712677, 0.056145694106817245, 0.015434334985911846,
    0.010314660146832466, 0.05307827889919281, 0.006779133807867765, 0.018389932811260223, -0.014796685427427292, -0.027208691462874413, 0.004185038153082132, 0.07440997660160065,
    -0.01360294595360756, -0.020088663324713707, 0.027929220348596573, 0.03732293099164963, 0.02525213174521923, -0.017046302556991577, 0.004576283972710371, 0.03853501006960869,
    -0.0022404107730835676, -0.016529442742466927, 0.006470558233559132, -0.012384324334561825, 0.02233555167913437, -0.010392322205007076, 0.013859153725206852, -0.0069141448475420475,
    0.062049008905887604, 0.003955209627747536, -0.014479847624897957, -0.04184108227491379, -0.018058493733406067, 0.004612407181411982, 0.010974355973303318, -0.002036407357081771,
    -0.00527579803019762, -0.029529739171266556, 0.020606189966201782, -0.012337957508862019, -0.013194957748055458, 0.024037424474954605, -0.01764083094894886, 0.03348338603973389,
    0.003394138067960739, -0.032052554190158844, -0.025050604715943336, 0.020991407334804535, -0.016385842114686966, -0.020990068092942238, -0.01991627737879753, 0.0474461168050766,
    -0.015708550810813904, 0.03469857573509216, -0.0036037084646523, -6.958768062759191e-05, 0.03731453791260719, 0.02126363292336464, 0.020513342693448067, -0.01753021590411663,
    0.0022930277045816183, 0.005832380149513483, -0.0039685629308223724, -0.03223050385713577, 0.004828137345612049, 0.02718489244580269, 0.02962968870997429, 0.0032152493949979544,
    0.010734503157436848, -0.04678020998835564, 0.006881770212203264, 0.025990186259150505, -0.02328168787062168, 0.022365281358361244, -0.047342363744974136, -0.015545729547739029,
    -0.021448833867907524, -0.0035125836730003357, 0.023892106488347054, 0.0001587674196343869, -0.02213911898434162, -0.0035819844342768192, -0.017667880281805992, 0.02711847610771656,
    0.05208763852715492, -0.003301908727735281, 0.023517943918704987, 0.036750681698322296, 0.05496938154101372, 0.00884599331766367, -0.02384882979094982, -0.006442471873015165,
    -0.044183168560266495, 0.04189025238156319, 0.02347353845834732, -0.03621964156627655, 0.02819833718240261, 0.050448156893253326, -0.029456213116645813, 0.04812493920326233,
    0.023218680173158646, 0.004881406668573618, -0.0014564302982762456, 0.010746321640908718, 0.03339757025241852, 0.05119910463690758, 0.01633387617766857, -0.011872164905071259,
    0.01889551244676113, -0.011630907654762268, 0.029197396710515022, 0.0026297958102077246, -0.026403754949569702, 0.0013398154405876994, 0.03099904954433441, 0.029888173565268517,
    0.003609665669500828, 0.013882918283343315, 0.027185533195734024, -0.00958685576915741, 0.006779709365218878, 0.01991622895002365, 0.001159573788754642, 0.007129209116101265,
    0.0036192797124385834, 0.012846529483795166, -0.03225185349583626, -0.003377531887963414, -0.03232024237513542, 0.008636957965791225, -0.047086603939533234, 0.011276140809059143,
    -0.013990412466228008, 0.013997801579535007, 0.0036579477600753307, -0.012988896109163761, 0.0008914946811273694, -0.012219718657433987, 0.043792761862277985, -0.0741465836763382,
    0.029425878077745438, 0.010684694163501263, -0.03129977732896805, -0.03459109738469124, -0.019663603976368904, 0.022550810128450394, -0.0731630027294159, -0.003094834741204977,
    -0.0025471290573477745, -0.030573183670639992, 0.0038683712482452393, -0.027150237932801247, -0.007048007566481829, 0.005582212936133146, -0.01615022122859955, -0.05904798209667206,
    -0.025259118527173996, 0.004201091825962067, 0.009402372874319553, 0.05941849574446678, 0.017772270366549492, 0.0036294555757194757, 0.00926485937088728, -0.01631033420562744,
    0.013867229223251343, -0.019815173000097275, -0.03023398481309414, 0.007957099936902523, 0.019391806796193123, 0.023523109033703804, -0.005877966061234474, -0.061802297830581665,
    -0.012487177737057209, 0.021525464951992035, 0.028010644018650055, 0.019119631499052048, -0.006459483411163092, 0.0038369817193597555, 0.014737577177584171, 0.021529128775000572,
    0.03085990808904171, 0.018968308344483376, -0.013097482733428478, 0.0025514764711260796, 0.01743033528327942, -0.006148603279143572, -0.004928227514028549, 0.029993543401360512,
    -0.06570574641227722, -0.0005293263820931315, -0.006284396164119244, -0.004446018021553755, 0.00019914722361136228, -0.010639014653861523, -0.017764780670404434, 0.003363455878570676,
    -0.006679272744804621, 0.0321386493742466, -0.01852118968963623, -0.01372695155441761, 0.012934754602611065, -0.018927978351712227, 0.027337221428751945, 0.006049972493201494,
    -0.024350091814994812, 0.014888872392475605, -0.0008882779511623085, -0.0023783971555531025, 0.03242023289203644, -0.0017524498980492353, -0.00540474196895957, 0.006139197386801243,
    0.04998564347624779, 0.022747838869690895, -0.035946641117334366, -0.013319339603185654, -0.058465439826250076, 0.029208265244960785, 0.02799939177930355, 0.004809374921023846,
    -0.01323588564991951, -0.003314147936180234, -0.019198352470993996, -0.02029542066156864, -0.020897837355732918, -0.03785379230976105, 0.0007834603311493993, -0.015171856619417667,
    -0.024039555341005325, 0.005010593682527542, -0.010407505556941032, -0.027757229283452034, -0.011005363427102566, -0.020712122321128845, 0.004747421480715275, -0.005082270130515099,
    -0.012179666198790073, -0.02407955192029476, 0.02045484259724617, -0.021170975640416145, -0.013133775442838669, 0.0010333199752494693, -0.0064110117964446545, -0.029781701043248177,
    -0.031717997044324875, -0.007467244286090136, -0.014903739094734192, 0.004050866235047579, -0.009573230519890785, -0.007826709188520908, 0.0057995314709842205, 0.004581750370562077,
    -0.0025471928529441357, 0.00010131150338565931, -0.037034884095191956, 0.0012628164840862155, -0.021968774497509003, 0.004947287030518055, -0.046072784811258316, -0.011012591421604156,
    -0.009356001392006874, -0.03892914205789566, -0.015282373875379562, -0.05058078467845917, -0.008265153504908085, -0.035255856812000275, 0.003162257606163621, -0.024669144302606583,
    -0.007514968514442444, 0.01581360213458538, 0.013216107152402401, -0.007382059469819069, 0.014118124730885029, -0.002547744894400239, -0.03160910680890083, 0.006779076065868139,
    0.02861081436276436, 0.03258911892771721, -0.015060657635331154, 0.007715890649706125, 0.008755996823310852, 0.012625932693481445, -0.016764620319008827, -0.018573548644781113,
    -0.002554615493863821, -0.011227584443986416, 0.011467431671917439, -0.013947741128504276, -0.00688136788085103, -0.009470363147556782, 0.008818692527711391, -0.030081335455179214,
    -0.003920228686183691, -0.028269503265619278, -0.024598458781838417, -0.013874150812625885, 0.0003418244596105069, 0.045343413949012756, 0.025261322036385536, -0.022690681740641594,
    0.000977440271526575, 0.022202232852578163, -0.0011635179398581386, -0.020559892058372498, 0.0008781072683632374, -0.0225865226238966, 0.017930196598172188, 0.03212513029575348,
    0.008929134346544743, 0.015579914674162865, -0.0020958036184310913, -0.03213634714484215, -0.015314697287976742, 0.00335762114264071, 0.0054848287254571915, 0.00620143162086606,
    0.025455638766288757, -0.003574237460270524, -0.010357117280364037, 0.006095970515161753, -0.026726173236966133, 0.024540584534406662, -0.03435709327459335, 0.001991472439840436,
    -0.01593027077615261, -0.02331509068608284, -0.017703816294670105, 0.0117659205570817, -0.010424593463540077, -0.021640505641698837, 0.030912987887859344, 0.010928519070148468,
    -0.012715410441160202, 0.0028060972690582275, -0.0221133753657341, 0.012639056891202927, 0.012331227771937847, -0.0027831471525132656, -0.0006834556697867811, 0.00022968280245549977,
    -0.009610035456717014, -0.022890612483024597, 0.01553900633007288, -0.0018071654485538602, 0.011625652201473713, 0.049509868025779724, -0.02722049131989479, 0.010999036021530628,
    0.013435203582048416, -0.010347899980843067, -0.014743815176188946, -0.01324988342821598, -0.024024341255426407, -0.034501321613788605, 0.024368716403841972, -0.015364022925496101,
    -0.01054966077208519, -0.003925297409296036, -0.02560501918196678, 0.008892573416233063, -0.006589058320969343, 0.009781057946383953, 0.015613655559718609, 0.0025500685442239046,
    0.02409873902797699, 0.022112440317869186, 0.011516925878822803, -0.002797811757773161, 0.0024050388019531965, 0.014732466079294682, -0.029114365577697754, -0.016083579510450363,
    -0.03591546788811684, 0.00952219683676958, -0.005537546239793301, -0.018206555396318436, 0.024304602295160294, 0.001676636398769915, -0.04518827795982361, -0.008213761262595654,
    0.010925003327429295, -0.01561290118843317, 0.009453173726797104, 0.003623159369453788, 0.06268315762281418, -0.012835542671382427, 0.024189818650484085, 0.003723902627825737,
    -0.007665496319532394, 0.010479423217475414, 0.007186445873230696, 0.006938384845852852, -0.020100165158510208, 0.02651011012494564, 0.013688657432794571, 0.04350386559963226,
    0.012638207525014877, 0.0029795526061207056, -0.02448616921901703, -0.011771945282816887, 0.017589516937732697, -0.012129127979278564, 0.024460449814796448, -0.027694685384631157,
    0.007189386989921331, -0.0018598472233861685, -0.012877295725047588, 0.017217762768268585, 0.013173650950193405, 0.007753103040158749, -0.0034784015733748674, -0.04205586016178131,
    0.07075212895870209, 0.00014232055400498211, -0.03068544529378414, -0.005825551692396402, 0.01596120372414589, -0.008664346300065517, 0.017022492364048958, 0.005133443512022495,
    0.02461196854710579, -0.006953509524464607, -0.014803651720285416, -0.0047942353412508965, 0.005967495962977409, -0.0376163050532341, -0.01106926891952753, 0.0045663644559681416,
    -0.014765544794499874, -0.006270573474466801, -0.007993489503860474, -0.026784047484397888, -0.022524122148752213, 0.009341863915324211, -0.03230062872171402, 0.026984473690390587,
    0.015587028115987778, 0.01653295010328293, 0.017128068953752518, -0.011258183978497982, 0.007169664371758699, 0.004797432105988264, 0.011473660357296467, 0.00673201447352767,
    -0.007373749744147062, 0.015211259014904499, 0.01351046934723854, 0.0162246935069561, -0.006330096162855625, -0.0037533282302320004, 0.008015133440494537, -0.01858283393085003,
    0.002955341013148427, -0.01602381281554699, 0.0010107617126777768, 0.012296391651034355, -0.012009702622890472, 0.003158236388117075, 0.0009717122884467244, 0.0215204618871212,
    0.004798911977559328, -0.03203410282731056, 0.0008883954724296927, -0.005296091549098492, 0.02812415361404419, -0.007848624140024185, 0.023087503388524055, 0.0137239471077919,
    0.0007562399259768426, 0.008368046954274178, -0.0018675676546990871, 0.019308030605316162, 0.0002442435943521559, 0.012598448432981968, -0.0013548569986596704, 0.027946626767516136,
    -0.04453594237565994, -0.004993670620024204, -0.017428837716579437, 0.009352860040962696, 0.015518588945269585, 0.024399565532803535, -0.03281276673078537, -0.03525184094905853,
    -0.018167296424508095, 0.00227416236884892, 0.002201878232881427, -0.010632934048771858, 0.008921870961785316, 0.0020942147821187973, -0.005172505043447018, 0.00831176619976759,
    -0.012226851657032967, 0.0548265278339386, 0.00902129989117384, -0.0034520355984568596, 0.017808208242058754, -0.03173939883708954, -0.027497882023453712, 0.009428959339857101,
    -0.013229169882833958, 0.013141726143658161, 0.004870607517659664, 0.03093678690493107, -0.00945950299501419, 5.012653491576202e-05, -0.008290546014904976, -0.02953624539077282,
    -0.011206994764506817, 0.030547885224223137, -0.032334234565496445, 0.007224129047244787, 0.02702193148434162, 0.0051935999654233456, 0.007706564851105213, -0.0022392533719539642,
    -0.02536245621740818, -0.0072336443699896336, -0.004227024503052235, 0.037118345499038696, 0.00230416189879179, 0.012156136333942413, 0.030558878555893898, -0.018493780866265297,
    -0.003921895753592253, -0.026199785992503166, 0.0028465958312153816, 0.0031456302385777235, -0.004754577297717333, -0.0071960678324103355, 0.023158568888902664, 0.030786698684096336,
    0.006026824004948139, 0.0015351972542703152, -0.006755393464118242, 0.02137409895658493, 0.006574240978807211, 0.008129858411848545, 0.028776679188013077, -0.011081201955676079,
    -0.030798425897955894, 0.030842017382383347, -0.024113791063427925, 0.02336909994482994, -0.008559918962419033, 0.0040849740616977215, 0.0342237688601017, -0.02732570841908455,
    -0.020371178165078163, -0.019453920423984528, -0.006202070042490959, 0.0007477971375919878, -0.02228507399559021, -0.03370099887251854, 0.01970774121582508, -0.012682365253567696,
    0.01394587755203247, 0.0038080934900790453, -0.010587569326162338, 0.027078095823526382, 0.02886212058365345, -0.007393892388790846, 0.031077461317181587, 0.022785745561122894,
    0.009351927787065506, 0.009438690729439259, -0.03675505518913269, 0.037992868572473526, -0.027026208117604256, 0.07575809210538864, -0.007458033971488476, -0.022264059633016586,
    0.006640041247010231, 0.05983780324459076, -0.008528171107172966, 0.02194269187748432, 0.017497653141617775, -0.0013798828003928065, -0.010929146781563759, 0.016850197687745094,
    -0.009139006026089191, 0.009774064645171165, 0.03527669236063957, -0.0022873436100780964, 0.009741075336933136, -0.019513042643666267, -0.038971398025751114, -0.05771547555923462,
    -0.03042294830083847, 0.002035282552242279, 0.036664094775915146, 0.025714518502354622, -0.021424995735287666, 0.012695636600255966, -0.019913487136363983, -0.02558382973074913,
    0.007977205328643322, -0.03677118942141533, 0.020441453903913498, -0.0106011051684618, 0.00970965251326561, 0.019301634281873703, -0.011854353360831738, 0.03946652263402939,
    -0.004453732166439295, 0.007433614227920771, 0.04437370225787163, -0.015864204615354538, -0.007685726974159479, -0.030223101377487183, -0.012351377867162228, 0.05162053182721138,
    -0.01995730586349964, -0.005274612456560135, -0.01749860681593418, -0.00026636847178451717, 0.019937433302402496, 0.027013065293431282, 0.03331821411848068, 0.0004858244501519948,
    0.011882925406098366, -0.03090975247323513, 0.022766146808862686, 0.03715064004063606, -0.003971850033849478, -0.001016876078210771, -0.02602579817175865, 0.009595301002264023,
    0.022239211946725845, -0.011489856988191605, 0.03640739992260933, -0.0025165702681988478, 0.015528254210948944, 0.025379350408911705, 0.026039063930511475, 0.003435581922531128,
    -0.009031028486788273, 0.019098345190286636, -0.031463589519262314, 0.008693824522197247, -0.061016835272312164, 0.00493726646527648, -0.021715572103857994, 0.029500391334295273,
    0.012537962757050991, 0.004398820456117392, -0.007576261181384325, -0.02001100406050682, -0.0018190582050010562, 0.0050741443410515785, 0.027330439537763596, -0.03500279784202576,
    0.05407737195491791, -0.007788744289427996, 0.0019266929011791945, -0.024000074714422226, 0.011602666229009628, 0.002744451630860567, -0.0261401180177927, 0.018054382875561714,
    0.020676614716649055, -0.011122804135084152, 0.003315940033644438, -0.0022542255464941263, -0.05656147003173828, -0.00044364164932630956, -0.022072065621614456, 0.01346329040825367,
    0.03787890076637268, -0.031731754541397095, 0.0027490989305078983, 0.02775612287223339, -0.0018236066680401564, 0.02545209974050522, 0.003132136072963476, 0.034203268587589264,
    0.03713810816407204, -0.024798162281513214, -0.010138585232198238, -0.006251519080251455, -0.010395785793662071, 0.01984660141170025, -0.02211492881178856, 0.0058469828218221664,
    -0.002066077431663871, -0.05489178001880646, 0.012007629498839378, -0.051985275000333786, 0.01642320118844509, -0.010194450616836548, -0.02730513922870159, 0.022128041833639145,
    -0.022784272208809853, 0.019823776558041573, 0.004204900003969669, -0.01903105340898037, 0.027705350890755653, -0.012704040855169296, 0.007022051140666008, 0.04824275150895119,
    -0.014835217036306858, -0.023450030013918877, 0.019075985997915268, -0.03521878644824028, -0.014515422284603119, -0.007684011943638325, -0.0013051016721874475, 0.008644345216453075,
    0.01243449468165636, -0.03195664659142494, 0.013124758377671242, 0.02013428695499897, -0.002140579978004098, 0.03420118987560272, 0.0253318939357996, 0.020861344411969185,
    0.02963963709771633, 0.01982758194208145, 0.0007490646676160395, -0.03671407699584961, 0.051781125366687775, -0.002057019853964448, -0.028642503544688225, -0.03143255040049553,
    0.02077329531311989, 0.049504462629556656, -0.0027892866637557745, -0.025687754154205322, -0.004969819914549589, 0.03128400817513466, -0.002486373297870159, 0.009004256688058376,
    0.009180204942822456, 0.020670350641012192, -0.03594173491001129, -0.021765757352113724, 0.012945825234055519, -0.005369293037801981, 0.0459609180688858, -0.048456721007823944,
    -0.007840871810913086, 0.0026180462446063757, -0.006861994508653879, 0.007483194116503, 0.0023445042315870523, -0.009348172694444656, -0.004243950359523296, -0.009849117137491703,
    0.0029781335033476353, 0.06295943260192871, 0.010591399855911732, -0.022134877741336823, 0.012875448912382126, -0.028079967945814133, -0.04128063842654228, 0.015885528177022934,
    -0.007611654233187437, 0.00986089464277029, -0.032228220254182816, 0.007202574051916599, -0.0281146839261055, -0.0066701206378638744, -0.05028078705072403, -0.011487722396850586,
    0.016358185559511185, -0.0027057374827563763, 0.02354496344923973, 0.003907328471541405, 0.04010592773556709, -0.005110288970172405, 0.03501903638243675, -0.014623475261032581,
    -0.03662055730819702, 0.007583669386804104, -0.007222451735287905, 0.0004050700808875263, -0.030818160623311996, 0.02262069843709469, 0.00541702238842845, 0.019779270514845848,
    -0.007063799072057009, 0.02838689275085926, -0.020886803045868874, -0.001375730149447918, 0.023417094722390175, -0.008291162550449371, 0.01699395850300789, 0.014962347224354744,
    -0.0167391300201416, 0.00012462119047995657, 0.002818501554429531, 0.06140675023198128, 0.04680393636226654, 0.013971200212836266, 0.00022635090863332152, 0.01591670513153076,
    -0.002339319558814168, 0.014120775274932384, -0.022129472345113754, 0.007025997154414654, 0.028498657047748566, -0.0022921666968613863, 0.02183670550584793, -0.009679765440523624,
    0.003553311573341489, -0.012585381977260113, -0.0016197731019929051, 0.003397625172510743, -0.06653464585542679, -0.03602772578597069, 0.007203775458037853, 0.014072726480662823,
    0.007242642343044281, -0.013620797544717789, -0.02252691425383091, 0.005707715637981892, -0.05589364841580391, 0.0009498785366304219, 0.08071832358837128, 0.003346951911225915,
    0.012692981399595737, -0.00010327596100978553, 0.0037493500858545303, 0.026416422799229622, -0.020794887095689774, 0.0008199803996831179, -0.01893896982073784, 0.04351983219385147,
    0.005908838473260403, 0.022508731111884117, 0.0056068082340061665, 0.02079649083316326, 0.014005329459905624, 0.004466090817004442, -0.03382497280836105, -0.05354069545865059,
    -0.022193675860762596, 0.02750006876885891, -0.00357356877066195, 0.002529069548472762, 0.003217094112187624, -0.049562811851501465, 0.002629463328048587, -0.015004738233983517,
    -0.03097141720354557, 0.02594645880162716, -0.01732953079044819, 0.03299105539917946, 0.0021389618050307035, 0.016120484098792076, 0.0033009054604917765, -0.008968009613454342,
    -0.002452039159834385, -0.04741761088371277, 0.00740768201649189, 0.0024848640896379948, 0.017185751348733902, 0.016338486224412918, -0.03393908217549324, 0.005760209634900093,
    -0.011909118853509426, -0.014348731376230717, 0.02642032876610756, -0.004653590731322765, -0.017023419961333275, -0.01738833822309971, 0.016576675698161125, 0.03897484019398689,
    0.012273350730538368, -0.0027632045093923807, 0.052355796098709106, -0.010785507969558239, -0.027573036029934883, 0.0026323662605136633, 0.030917946249246597, 0.02190442755818367,
    0.0019753300584852695, -0.03216968849301338, 0.007102036848664284, -0.013977430760860443, 0.057058677077293396, -0.02413598820567131, -0.009436370804905891, -0.008341803215444088,
    -0.01867702230811119, -0.019823241978883743, -0.04455116391181946, -0.014072449877858162, 0.037694722414016724, 0.010103886015713215, 0.07225847244262695, 0.0048943874426186085,
    -0.0015602170024067163, 0.023394107818603516, -0.046620406210422516, 0.0029264818876981735, -0.03727637231349945, 0.005007670260965824, -0.03671593591570854, 0.0429672934114933,
    -0.019842656329274178, -0.08485012501478195, 0.012454384937882423, -0.0352686308324337, 0.01699245721101761, -0.03277943283319473, -0.031627897173166275, 0.0024123038165271282,
    0.004927579313516617, 0.020287662744522095, -2.3066841094987467e-05, -0.0010102244559675455, -0.0007351916865445673, 0.004964974708855152, -0.030338820070028305, -0.03610846772789955,
    0.01722060889005661, 0.01754431612789631, -0.0033343909308314323, -0.026618165895342827, 0.003036357695236802, 0.012791489250957966, -0.02549828216433525, 0.007899508811533451,
    0.004314152058213949, 0.0004084905667696148, -0.003834805451333523, 0.013374517671763897, -0.02547776699066162, 0.036645591259002686, -0.009100661613047123, -0.026969313621520996,
    0.016956813633441925, -0.008640277199447155, 0.0007869678665883839, -0.00451224111020565, 0.009396735578775406, 0.010659504681825638, 0.030924316495656967, -0.055925153195858,
    -0.01051176618784666, -0.017684206366539, -0.0423186756670475, 0.03418608009815216, 0.013956952840089798, -0.006357742939144373, -0.024987976998090744, -0.002157463226467371,
    0.0015849592164158821, -0.033163439482450485, -0.0033397928345948458, -0.03942382335662842, -0.023470552638173103, -0.013967631384730339, 0.008451677858829498, -0.020861178636550903,
    -0.027525270357728004, -0.012895354069769382, -0.004106512293219566, -0.03420069068670273, -0.056230783462524414, 0.005188131704926491, 0.013040347956120968, 0.02144753746688366,
    -0.027094846591353416, -0.030119258910417557, -0.005429529584944248, 0.06759557873010635, -0.024373095482587814, 0.023287488147616386, 0.009535429999232292, -0.02856055460870266,
    -0.01065008994191885, -0.015219943597912788, 0.021740084514021873, -0.005349836777895689, -0.009477132000029087, -0.01059287041425705, -0.0036667780950665474, -0.011626174673438072,
    -0.017163049429655075, 0.019188249483704567, -0.0023009423166513443, -0.004278117790818214, -0.025346893817186356, -0.012516088783740997, 0.03011433407664299, -0.0001814437855500728,
    -0.0034959502518177032, -0.015278550796210766, -0.013632440008223057, 0.02519918605685234, 0.010294600389897823, 0.013798730447888374, -0.019169513136148453, -0.00029809479019604623,
    -0.021516650915145874, -0.0006271122256293893, 0.003927581012248993, 0.03284205496311188, 0.014775454066693783, 0.01371284481137991, -0.00743682449683547, -0.010896186344325542,
    0.007411968894302845, -0.00051359977805987, -0.011656414717435837, 0.011535290628671646, -0.04427411034703255, -0.002891075797379017, 0.017725162208080292, 0.02060152404010296,
    -0.016285976395010948, 0.011456558480858803, 0.028658179566264153, 0.0202369075268507, -0.03466692566871643, -0.022081969305872917, -0.02600785903632641, 0.00292093469761312,
    -0.01758451759815216, -0.019968565553426743, -0.029904713854193687, 0.008400285616517067, 0.03371085971593857, -0.002976025454699993, 0.022775694727897644, -0.013735873624682426,
    -0.02493375912308693, 0.050541892647743225, -0.018097830936312675, 0.004842373542487621, -0.0059302388690412045, 0.040028028190135956, 0.03356856852769852, 0.03854179009795189,
    0.014741686172783375, 0.013447591103613377, 0.018671490252017975, -0.0027266608085483313, 0.021825872361660004, -0.011711589060723782, 0.020617708563804626, 0.01557659450918436,
    -0.0155729278922081, -0.05080292373895645, 0.016187205910682678, 0.010230629704892635, -0.029920892789959908, -0.021496495231986046, 0.029536332935094833, -0.040776293724775314,
    0.020704185590147972, -0.0031364760361611843, -0.0058534638956189156, -0.005889847408980131, -0.0155522171407938, -0.028698092326521873, 0.00951443426311016, 0.06434963643550873,
    -0.02569013647735119, -0.02084423042833805, 0.016899602487683296, 0.006783440709114075, -0.021950451657176018, -0.008266735821962357, 0.011955197900533676, 0.03776384890079498,
    0.0019626806024461985, 0.03582155704498291, 0.02095820941030979, 0.016701513901352882, 0.03196943178772926, 0.011724104173481464, 0.021650932729244232, -0.018872661516070366,
    0.00536005524918437, -0.0012696472695097327, -0.027561290189623833, -0.009574615396559238, -0.05742770433425903, -0.022327329963445663, -0.008823174983263016, 0.03120170533657074,
    0.02934465929865837, -0.010116365738213062, -0.00042168155778199434, 0.010931024327874184, -0.02603698894381523, 0.003043272765353322, -0.03611528500914574, 0.02759171463549137,
    0.013592732138931751, 0.00829960498958826, 0.003997307736426592, -0.007031919900327921, 0.019809365272521973, 0.025693677365779877, 0.05119377002120018, 0.0294247604906559,
    0.033850546926259995, 0.05477036163210869, -0.00034477305598556995, -0.004332585260272026, 0.009859785437583923, 0.0020969535689800978, -0.02461145631968975, 0.002293950878083706,
    0.04437848925590515, 0.00505253067240119, 0.014962341636419296, -0.01273447833955288, 0.03648536279797554, -0.0290811900049448, 0.02456418052315712, -0.01376227755099535,
    0.051082003861665726, 0.012420333921909332, -0.046268705278635025, 0.02936224266886711, -0.0037102368660271168, -0.023973070085048676, 0.0028775441460311413, -0.023354187607765198,
    -3.62438295269385e-05, 0.00253139715641737, 0.026292454451322556, -0.03873158246278763, -0.00660747243091464, -0.011016619391739368, 0.0031027658842504025, -0.011505044996738434,
    -0.005443116649985313, -0.018624909222126007, -0.018525930121541023, -0.010251417756080627, 0.029643572866916656, -0.008795630186796188, 0.011466417461633682, 0.012092984281480312,
    -0.00299856998026371, 0.014015726745128632, 0.011234650388360023, 0.022876445204019547, 0.002838851185515523, -0.003956510219722986, -0.0010036041494458914, -0.005784993525594473,
    0.031738195568323135, -0.032818324863910675, 0.017850564792752266, 0.007914337329566479, 0.012776745483279228, 0.0008536988752894104, 0.04539338871836662, 0.035336416214704514,
    0.05958215519785881, 0.049565672874450684, -0.003044639714062214, -0.019327297806739807, -0.01516797486692667, -0.002377807628363371, -0.021848678588867188, -0.005118180066347122,
    -0.005573781672865152, 0.017048420384526253, 0.00716987531632185, 0.004229838028550148, 0.018666548654437065, -0.019308140501379967, -0.002366930479183793, 0.04125768318772316,
    -0.030439792200922966, -0.014253310859203339, 0.021973097696900368, 0.016393160447478294, 0.008790371008217335, 0.01730741374194622, 0.012791413813829422, 0.02065836824476719,
    0.004989821929484606, -0.0038473717868328094, -0.02735661156475544, -0.024885796010494232, -0.002450919710099697, 0.036507926881313324, 0.00584932928904891, 0.001797395059838891,
    -0.04131092503666878, -0.005393445026129484, -0.02116079442203045, 0.001992207020521164, -0.04999366030097008, 0.02565055713057518, -0.005217477213591337, 0.03262579068541527,
    0.010702853091061115, -0.04786239564418793, 0.003988434094935656, 0.018382573500275612, -0.04843132942914963, -0.0080223698168993, 0.03436370939016342, 0.018032072111964226,
    0.0018656165339052677, 0.0014871364692226052, 0.0014386967523023486, 0.02782314643263817, 0.05633385479450226, 0.02025682106614113, 0.021154021844267845, 0.02154754288494587,
    -0.022722000256180763, -0.02309093251824379, -0.006306438706815243, -0.036193810403347015, -0.021945316344499588, -0.02956024929881096, 0.0023543264251202345, -0.021318065002560616,
    -0.016726689413189888, 0.029915891587734222, -0.005727129522711039, 0.0014061495894566178, -0.038718994706869125, -0.027780238538980484, -0.027749404311180115, 0.007514065131545067,
    -0.028887229040265083, -0.0078307269141078, -0.0389295257627964, -0.005884724669158459, -0.00816521979868412, -0.014916077256202698, 0.007323770318180323, -0.02151077799499035,
    0.0060692038387060165, 0.026631901040673256, -0.006935468874871731, 0.018675221130251884, 0.008458931930363178, 0.022127747535705566, -0.02538641169667244, 0.0015052950475364923,
    -0.03294526785612106, -0.002184988697990775, -0.011814485304057598, -0.05366714671254158, 0.05775579437613487, 0.030257610604166985, 0.027972165495157242, 0.05966072157025337,
    0.032246071845293045, -0.0032672761008143425, 0.08403995633125305, 0.04505827650427818, 0.005318019073456526, 0.0057218559086322784, -0.005929260980337858, 0.02787983976304531,
    0.01024182140827179, -0.007200103253126144, 0.01639985479414463, -0.027003536000847816, 0.004775610286742449, -0.0006043936009518802, 0.0030762329697608948, -0.022730233147740364,
    -0.005027115345001221, -0.014966163784265518, -0.03822436183691025, -0.0264939833432436, -0.0008728003012947738, -0.0018584311474114656, 0.023172400891780853, -0.02013504132628441,
    -0.027341268956661224, 0.0038313043769448996, -0.03764239698648453, 0.009493369609117508, -0.03159107267856598, 0.017012614756822586, -0.10016489028930664, 0.041300177574157715,
    -0.05190536007285118, -0.06797873228788376, -0.0011099796975031495, -0.017014285549521446, -0.015618469566106796, -0.04083957523107529, 0.019141830503940582, -0.03695047274231911,
    0.014795242808759212, -0.0038433223962783813, -0.026068395003676414, -0.015516940504312515, 0.02329234778881073, -0.003662438364699483, -0.05517797917127609, -0.039800383150577545,
    0.0360930860042572, 0.010713362134993076, -0.0318116694688797, -0.011931028217077255, 0.01797148771584034, -0.0034417512360960245, -0.04626898840069771, -0.028993653133511543,
    -0.030669471248984337, 0.00691372761502862, 0.024740705266594887, 0.0030301737133413553, 0.011487571522593498, -0.003049093997105956, -0.008507682941854, -0.007179575506597757,
    0.028097113594412804, 0.0016429710667580366, 0.04012533649802208, 2.281897104694508e-05, 0.009317420423030853, 0.033136382699012756, -0.009134753607213497, -0.05701281130313873,
    -0.001966203562915325, -0.0029071648605167866, -0.0010221172124147415, 0.0028059266041964293, -0.003646530443802476, -0.0019159051589667797, 0.0068243155255913734, -0.009965678676962852,
    -0.0013164104893803596, 0.005781793035566807, -0.003898519091308117, 0.0022587671410292387, 0.00028665183344855905, 0.0055960617028176785, -0.003109321929514408, -0.0011598631972447038,
    0.011197764426469803, 0.002612393582239747, -0.006155156530439854, -0.0005177235580049455, 6.539611058542505e-05, -0.002940990962088108, 0.0023833056911826134, -0.004483421333134174,
    0.00820700079202652, -0.002423007506877184, -0.0009259051876142621, 0.0074256169609725475, 0.0018005756428465247, 7.58078385842964e-05, 0.0038910938892513514, -0.004226414952427149,
    -0.0016041615745052695, 0.003272629575803876, -0.004727869760245085, 0.005970054306089878, -0.006947549991309643, 0.001541700097732246, 0.005227174609899521, -0.009008525870740414,
    -0.0059860278852283955, 0.003349513281136751, 0.0018035820685327053, -0.009737259708344936, -0.010128431022167206, 0.002166427904739976, -0.004890133161097765, -0.004700687248259783,
    0.0020892806351184845, 0.004521350841969252, 0.006109731271862984, 0.011649812571704388, -0.00739165348932147, 0.004254247527569532, 0.011899376288056374, -4.159866148256697e-05,
    0.00563631858676672, 0.0023605639580637217, -0.0015901816077530384, 0.004466992802917957, -0.0039224773645401, 0.004892974626272917, -0.002233813051134348, -0.002185728633776307,
    -0.0035958481021225452, 6.318937084870413e-05, 0.003961578011512756, -0.009520931169390678, 0.005707951262593269, -0.003009212203323841, 0.00601537898182869, -0.0030411728657782078,
    0.006733820307999849, -0.0004325960762798786, -0.010084787383675575, -0.0008783750818111002, 0.013025334104895592, -0.002448516897857189, -0.006147634703665972, 0.00047490547876805067,
    0.0014258858282119036, 0.0003814535739365965, 0.004249083809554577, 0.006116784643381834, -0.004871962126344442, 0.0012703008251264691, 0.00015003059525042772, 0.005029566120356321,
    -0.012855125591158867, -0.00032909310539253056, 0.003093901788815856, -0.005084269680082798, -0.0008401465020142496, -0.004408734384924173, 0.004681447986513376, -0.01286235824227333,
    0.0010522935772314668, 0.0005318255280144513, 0.00760673638433218, -0.004088795278221369, -0.0005151827353984118, -0.0014406173722818494, -0.00241531478241086, 0.004052865784615278,
    -0.0007579968660138547, -0.011042413301765919, -0.0011865650303661823, 0.01087972056120634, 0.002248161705210805, -0.005144866649061441, -0.0023200386203825474, -0.0025814175605773926,
    -0.004714776296168566, 0.0026399747002869844, 0.004007099661976099, 0.012923228554427624, 0.008439409546554089, 0.008284593001008034, 0.006606417708098888, -0.006800709292292595,
    -0.002356740878894925, 0.02073759213089943, -0.0005248761735856533, -0.0009676553891040385, 0.005761499051004648, 0.001460691331885755, 0.006470634136348963, -0.015282796695828438,
    0.1601845920085907, -0.037890370935201645, 0.053173311054706573, 0.03753365948796272, 0.03565245866775513, 0.0690305233001709, 0.053091105073690414, -0.014142702333629131,
    -0.03687040135264397, -0.0024159180466085672, -0.04128466919064522, 0.03917962312698364, -0.07476746290922165, 0.08082915842533112, 0.021268848329782486, 0.021541068330407143,
    -0.04828081652522087, -0.015697533264756203, 0.004310861229896545, -0.0977570042014122, -0.08563388884067535, -0.018265532329678535, 0.029268089681863785, -0.006430397275835276,
    0.04186788573861122, -0.05063861235976219, -0.0964353159070015, 0.006497048307210207, 0.06671933829784393, -0.0048157828859984875, 0.06805846095085144, -0.056843169033527374,
    0.02338234707713127, -0.005661779083311558, -0.02434428036212921, 0.06449788063764572, -0.02714526280760765, 0.009565681219100952, -0.06941213458776474, 0.07969124615192413,
    0.0034424741752445698, 0.029937248677015305, 0.055900827050209045, 0.023863881826400757, 0.013473041355609894, -0.0071593658067286015, 0.0803346037864685, -0.05228757485747337,
    -0.09008237719535828, 0.04226646572351456, 0.09497768431901932, -0.04498928040266037, 0.08204743266105652, -0.10811904817819595, -0.0012115348363295197, -0.041755132377147675,
    -0.04255367070436478, -0.015057877637445927, 0.037976834923028946, -0.11687330156564713, 0.027447935193777084, -0.05009455606341362, 0.0471675768494606, -0.02303612045943737,
    0.032182663679122925, -0.006527227815240622, -0.02752421237528324, -0.030264047905802727, 0.02326831966638565, 0.02677960880100727, 0.07464862614870071, -0.025696543976664543,
    0.029300183057785034, 0.040199268609285355, 0.04533049091696739, -0.0839674323797226, 0.0074236695654690266, 0.057046420872211456, 0.04057973250746727, -0.041599053889513016,
    -0.0396183542907238, -0.02373897098004818, -0.03209639713168144, 0.010864156298339367, 0.007308982778340578, 0.04260435700416565, 0.014408432878553867, 0.05704062059521675,
    -0.026470812037587166, -0.03736668825149536, 0.009969252161681652, 0.05501385033130646, 0.026496121659874916, -0.032756123691797256, -0.01926244981586933, -0.044224098324775696,
    0.1341497004032135, -0.05117783322930336, 0.03112742491066456, 0.06518156826496124, -0.07752938568592072, 0.06080952286720276, 0.06121158227324486, -0.04850427806377411,
    0.046657711267471313, 0.022230874747037888, 0.03252070024609566, -0.07910952717065811, 0.12752699851989746, -0.026042642071843147, 0.021260302513837814, 0.015584410168230534,
    0.018713345751166344, 0.057481326162815094, 0.07934737205505371, -0.019217247143387794, -0.048654474318027496, -0.044068772345781326, 0.06111708655953407, 0.0711238831281662,
    -0.018585987389087677, -0.007521686144173145, 0.05802427604794502, 0.030447768047451973, 0.011104512959718704, -0.0848529040813446, 0.011229199357330799, 0.003254961920902133,
    0.11801397055387497, 0.03495147451758385, 0.07719121873378754, 0.000678673037327826, 0.04275913164019585, 0.0653449073433876, 0.0852373018860817, -0.09287059307098389,
    -0.01407754048705101, 0.022653546184301376, -0.11687228083610535, -0.10640190541744232, 0.039764560759067535, 0.008288546465337276, 0.015604098327457905, 0.02467629685997963,
    0.06672213971614838, -0.007676065433770418, 0.003186176298186183, -0.02764662727713585, -0.07722207903862, -0.03366195037961006, -0.004326358437538147, -0.01459679938852787,
    0.028132690116763115, 0.10482269525527954, 0.12095104902982712, 0.09578049927949905, 0.09297928214073181, 0.015797855332493782, -0.119122713804245, -0.08852250128984451,
    0.08308714628219604, 0.0825209990143776, -0.07292142510414124, 0.0032964220736175776, -0.01165749877691269, -0.06708215177059174, -0.01783495582640171, 0.005686421412974596,
    0.014682697132229805, 0.05553193762898445, -0.1012781485915184, -0.005953350570052862, 0.055349238216876984, 0.10323713719844818, 0.05345313251018524, 0.02422526478767395,
    0.025343410670757294, 0.09613769501447678, 0.03582380339503288, -0.07079246640205383, 0.06717116385698318, 0.08243002742528915, -0.05842801555991173, -0.00041314115514978766,
    -0.09838408976793289, 0.05044970288872719, -0.054362665861845016, -0.10622584819793701, -0.06670419126749039, -0.030898218974471092, -0.018213875591754913, 0.09999671578407288,
    0.09726452827453613, 0.06041226536035538, 0.009199827909469604, 0.005075421649962664, -0.06371500343084335, 0.10906162858009338, 0.06710390001535416, -0.042570561170578,
    -0.037623513489961624, -0.09419960528612137, 0.015443270094692707, 0.042342204600572586, -0.04505215212702751, -0.0774056687951088, 0.05734044685959816, 0.046367015689611435,
    0.11553739011287689, -0.02899273671209812, 0.03310903534293175, -0.007421601098030806, 0.03303176909685135, -0.03846370428800583, -0.01593753881752491, -0.006587663199752569,
    -0.1150340735912323, -0.0381009466946125, -0.06218338757753372, -0.004252126440405846, 0.11557833105325699, -0.032608747482299805, 0.0015851430362090468, 0.04783293977379799,
    -0.11376923322677612, 0.057272814214229584, -0.034620773047208786, -0.08994218707084656, -0.0022803908213973045, -0.10756117850542068, 0.08549215644598007, 0.06709272414445877,
    -0.003896239912137389, -0.0528530590236187, -0.029939016327261925, -0.05955212190747261, -0.013849862851202488, -0.006122957449406385, 0.0647878646850586, -0.02732888050377369,
    -0.06223179027438164, 0.041329409927129745, -0.012490430846810341, -0.006865371484309435, -0.05736641585826874, 0.0208289697766304, 0.01063238363713026, 0.07204438745975494,
    0.07298225164413452, 0.023138798773288727, 0.09319239109754562, -0.11407065391540527, 0.04984363913536072, 0.007358831819146872, 0.05770215392112732, -0.03336174041032791,
    -0.09839677810668945, -0.09569645673036575, 0.0511891171336174, 0.014431457966566086, 0.08346138149499893, 0.06419631093740463, -0.03943093493580818, 0.0928676649928093,
    -0.03713948279619217, 0.10870549082756042, -0.06778932362794876, -0.09481362253427505, -0.0530342273414135, 0.08771215379238129, -0.0570419616997242, 0.07402301579713821,
    -0.05000755190849304, -0.03690661862492561, 0.1631595343351364, 0.014161264523863792, 0.10160759836435318, -0.003956472501158714, 0.024633916094899178, 0.05666883662343025,
    0.05712094530463219, -0.01910950243473053, -0.20647847652435303, 0.0506511852145195, 0.14502055943012238, -0.04960714280605316, -0.0070022642612457275, 0.10447098314762115,
    0.09600094705820084, 0.03930099308490753, -0.07101287692785263, 0.05228768661618233, -0.01657838560640812, 0.09164079278707504, -0.01727311499416828, 0.0012238300405442715,
    0.06523626297712326, -0.058233629912137985, -0.053843945264816284, 0.10078680515289307, -0.06630873680114746, 0.09131591767072678, 0.034606724977493286, 0.09542883187532425,
    0.18827375769615173, -0.014576269313693047, -0.050233013927936554, -0.038981545716524124, -0.06953959167003632, 0.020720643922686577, -0.12846864759922028, 0.042072683572769165,
    0.07991743832826614, -0.09050546586513519, -0.05417350307106972, 0.07126247137784958, -0.07744522392749786, 0.024593936279416084, -0.09172503650188446, 0.005716316867619753,
    0.09226322174072266, -0.04770886152982712, -0.017147323116660118, -0.0429127961397171, 0.05954808369278908, -0.053989797830581665, 0.046904195100069046, 0.06336624175310135,
    -0.07897790521383286, 0.12656880915164948, -0.031421829015016556, 0.071086086332798, -0.002750030718743801, 0.007697479799389839, 0.0666443407535553, 0.01839526928961277,
    -0.08417144417762756, -0.04688558354973793, -0.051140446215867996, -0.004543525166809559, 0.07075068354606628, 0.06902672350406647, -0.04818961024284363, -0.04514689743518829,
    -0.08611084520816803, -0.011753164231777191, 0.1702156811952591, 0.05463111028075218, 0.05147463083267212, 0.014502213336527348, 0.08112408220767975, -0.009397750720381737,
    0.10599833726882935, 0.02191656082868576, -0.14623840153217316, 0.021665189415216446, -0.009343053214251995, -0.0670400932431221, 0.03570694103837013, 0.0550185963511467,
    -0.0964258685708046, -0.13373664021492004, -0.015116022899746895, -0.05747535824775696, -0.12230204045772552, -0.0023713710252195597, 0.09119442105293274, 0.07325547188520432,
    -0.09893540292978287, 0.06835842877626419, 0.05597986280918121, -0.0795745849609375, 0.10772009938955307, 0.10892686247825623, -0.04968207702040672, 0.0017331340350210667,
    0.12703916430473328, -0.012881000526249409, 0.06863496452569962, 0.10738563537597656, 0.019718822091817856, 0.005421861540526152, 0.026607530191540718, -0.046272940933704376,
    -0.09759444743394852, 0.0545484684407711, -0.09832041710615158, -0.05875023081898689, 0.06702102720737457, -0.03337607905268669, 0.022233862429857254, -0.028400395065546036,
    -0.10620715469121933, -0.08308715373277664, 0.09496409446001053, 0.010728413239121437, 0.042122263461351395, -0.03872368857264519, 0.09255997091531754, -0.03038308024406433,
    -0.03380969166755676, -0.06128641217947006, 0.03112626262009144, -0.0054773795418441296, -0.0448819138109684, -0.049192268401384354, -0.061539337038993835, -0.030670426785945892,
    0.012466322630643845, -0.16699020564556122, 0.12550406157970428, 0.009005841799080372, 0.04350258409976959, 0.12472513318061829, -0.021450238302350044, -0.034037478268146515,
    -0.08750206977128983, 0.16921904683113098, 0.0008121093269437551, 0.06474931538105011, -0.03931489214301109, 0.010339898988604546, 0.010962087661027908, -0.01693430356681347,
    0.062291551381349564, 0.028988974168896675, 0.009045296348631382, -0.15587306022644043, -0.05196024477481842, 0.07769771665334702, -0.08207356929779053, 0.11293471604585648,
    -0.06921441107988358, 0.025283420458436012, -0.10253576189279556, 0.15069584548473358, 0.02396080270409584, -0.04115151986479759, -0.03926974907517433, 0.0661955326795578,
    0.05136752873659134, 0.15955106914043427, -0.039829183369874954, 0.013163905590772629, -0.041423164308071136, -0.08036133646965027, 0.057310957461595535, -0.13628624379634857,
    0.0461510494351387, -0.1441706120967865, -0.11339746415615082, -0.04174468666315079, 0.04780247434973717, 0.10012711584568024, 0.017024660483002663, -0.0718325525522232,
    0.09443352371454239, 0.04021920636296272, -0.03299008309841156, 0.01006346195936203, -0.021394236013293266, 0.13834567368030548, 0.019418515264987946, -0.11419970542192459,
    -0.06821281462907791, -0.1150788888335228, -0.10683296620845795, -0.017912311479449272, -0.018650423735380173, -0.07781654596328735, -0.18677183985710144, -0.13238097727298737,
    0.006914560683071613, 0.0205617044121027, -0.15852272510528564, 0.1488582342863083, 0.022060468792915344, 0.05196647718548775, -0.08666481822729111, 0.050379615277051926,
    0.07035162299871445, 0.07051235437393188, -0.04427103325724602, 0.12505720555782318, 0.04131225124001503, -0.10106377303600311, -0.03386532515287399, -0.06615588068962097,
    -0.12103892862796783, -0.05235963314771652, -0.08393128961324692, -0.03780360892415047, -0.007677961140871048, 0.004525862634181976, 0.004200138617306948, 0.011164534837007523,
    -0.08885300904512405, -0.05265359207987785, -0.012324102222919464, 0.029886215925216675, 0.09457575529813766, 0.03578827157616615, 0.09898722171783447, 0.009947090409696102,
    -0.06956113129854202, 0.026633573696017265, -0.009131659753620625, -0.11424145847558975, 0.07313592731952667, -0.1004512682557106, 0.0004988742875866592, -0.06511993706226349,
    0.026753205806016922, 0.1545240879058838, -0.044731542468070984, -0.06638072431087494, 0.055237073451280594, -0.03780188784003258, -0.00722161028534174, -0.07817808538675308,
    -0.037593942135572433, -0.04059768468141556, 0.0870903953909874, -0.0018587399972602725, -0.0806792750954628, 0.1556861251592636, -0.009316962212324142, 0.09322720766067505,
    -0.10469432920217514, -0.07017938047647476, 0.07027923315763474, -0.058793943375349045, 0.07258176058530807, -0.0897597000002861, -0.003852723864838481, -0.15868936479091644,
    0.06784696131944656, 0.07014258205890656, -0.002866696799173951, 0.11429093033075333, 0.04580334946513176, 0.11643731594085693, 0.09743442386388779, -0.03998924046754837,
    -0.058293744921684265, -0.026748469099402428, 0.07141371816396713, 0.08260376751422882, -0.0744365006685257, -0.1332651674747467, -0.10715829581022263, -0.07264772057533264,
    -0.17352595925331116, -0.05300362408161163, -0.016958482563495636, -0.06124766170978546, 0.08218572288751602, -0.008662398904561996, 0.05938274413347244, -0.021711286157369614,
    -0.06930557638406754, -0.1891866773366928, -0.09523437172174454, -0.00818629190325737, -0.003425613045692444, -0.09014611691236496, -0.10842464119195938, -0.0611269511282444,
    -0.005641005467623472, -0.24153292179107666, 0.0854254812002182, -0.0019412161782383919, 0.06299114972352982, -0.03107009455561638, -0.04659026116132736, -0.0052015832625329494,
    -0.011449660174548626, 0.067908376455307, 0.025921916589140892, 0.056835439056158066, -0.06434345990419388, 0.01813664846122265, 0.10706068575382233, -0.018635284155607224,
    0.037861134856939316, -0.2392357438802719, -0.04784799739718437, -0.08906298130750656, 0.04091748595237732, -0.14689946174621582, -0.00997462309896946, -0.05653076991438866,
    0.1997351199388504, 0.1141766756772995, 0.05501764640212059, 0.029092732816934586, -0.04665648564696312, 0.13520793616771698, -0.12323154509067535, -0.06838364154100418,
    -0.0627264678478241, 0.14146946370601654, 0.08840689808130264, 0.05639686807990074, 0.026591794565320015, 0.03026431053876877, 0.13272733986377716, 0.03325456753373146,
    -0.06279783695936203, 0.04991777986288071, 0.19498859345912933, -0.07087311893701553, -0.06160321831703186, 0.019619248807430267, -0.020243268460035324, 0.022541865706443787,
    -0.0869947001338005, 0.01240374706685543, 0.11538980156183243, -0.03816811740398407, -0.023673614487051964, 0.06321354955434799, -0.03342343121767044, 0.12704603374004364,
    -0.06547090411186218, -0.004531580954790115, 0.01284814067184925, -0.007290271110832691, -0.1416870355606079, -0.10224223136901855, 0.050538670271635056, -0.0016384862828999758,
    0.05906454473733902, 0.05637418106198311, -0.10449106991291046, 0.11631803959608078, -0.03384147956967354, 0.037555139511823654, -0.2034008502960205, -0.07216957211494446,
    -0.04139265418052673, -0.1865210384130478, -0.04311972111463547, 0.12476319074630737, 0.022200772538781166, -0.02804628573358059, 0.03763975575566292, -0.09463773667812347,
    -0.08410508930683136, -0.01552801113575697, 0.037467747926712036, -0.13145682215690613, 0.045552413910627365, 0.13688483834266663, 0.02911982499063015, 0.10906290262937546,
    0.02236214652657509, -0.08211733400821686, 0.1531265377998352, -0.048991065472364426, 0.06696372479200363, -0.01916663907468319, 0.07471363991498947, 0.0038337530568242073,
    0.026916509494185448, 0.1215287372469902, -0.08459695428609848, 0.12121948599815369, 0.034829627722501755, -0.09999363869428635, 0.014799898490309715, 0.005023216363042593,
    -0.0949830710887909, -0.03215545788407326, -0.11600801348686218, -0.05824881047010422, -0.08313310891389847, 0.22693368792533875, 0.1803029179573059, 0.052567120641469955,
    0.024068254977464676, 0.0013784244656562805, -0.013592541217803955, -0.10602664947509766, 0.10957799106836319, -3.542042031767778e-05, -0.0905437171459198, -0.08939076215028763,
    -0.018164772540330887, 0.14660148322582245, -0.022413183003664017, 0.04490916058421135, -0.0267669428139925, 0.09720670431852341, 0.001764763379469514, -0.024033471941947937,
    -0.13393384218215942, 0.31665104627609253, 0.044127851724624634, -0.08986368030309677, 0.01578385941684246, 0.016438530758023262, -0.062461383640766144, 0.1556934416294098,
    -0.005018478725105524, 0.1735687255859375, 0.1171097457408905, 0.07648918777704239, 0.060671065002679825, 0.12321612983942032, -0.011568000540137291, -0.15101638436317444,
    0.05235913768410683, 0.15170209109783173, 0.026334917172789574, 0.029480453580617905, 0.026194840669631958, 0.06442157924175262, -0.10861862450838089, -0.08498106151819229,
    -0.08021305501461029, 0.06171957775950432, 0.031207920983433723, -0.00916427094489336, -0.10288060456514359, -0.15419654548168182, 0.08095815032720566, -0.05207844823598862,
    0.05809115618467331, -0.051927000284194946, 0.021421125158667564, -0.08998464792966843, 0.029768630862236023, 0.07459057122468948, -0.09084710478782654, 0.016613056883215904,
    0.07399380952119827, 0.0857241302728653, 0.20358824729919434, 0.051401134580373764, 0.019216688349843025, -0.07661746442317963, 0.07189664244651794, 0.18306894600391388,
    0.029657311737537384, -0.08415757119655609, 0.07499019056558609, -0.003826109692454338, 0.10546021163463593, -0.08734145015478134, -0.02938755415380001, 0.036722660064697266,
    -0.05410559102892876, 0.03823103383183479, 0.003319468582049012, 0.02121156081557274, -0.006125248968601227, -0.09754152595996857, 0.0029919506050646305, -0.16816653311252594,
    0.05983155220746994, 0.021241940557956696, -0.12346754223108292, -0.09937989711761475, -0.029431940987706184, 0.19665120542049408, -0.0009852215880528092, 0.11341866850852966,
    -0.10978152602910995, 0.025355860590934753, 0.12542445957660675, 0.11058656871318817, 0.02322983741760254, 0.010742569342255592, 0.046981677412986755, -0.06802651286125183,
    0.00036879483377560973, -0.011403819546103477, 0.020888440310955048, -0.11906756460666656, 0.004166858270764351, -0.01674664206802845, -0.10650832206010818, 0.06122484430670738,
    0.033700309693813324, 0.05417206510901451, -0.013935908675193787, -0.017293890938162804, 0.014139639213681221, 0.06773398816585541, 0.15408845245838165, 0.08660601824522018,
    -0.02882704697549343, -0.18442995846271515, 0.03494088351726532, -0.031066587194800377, 0.027868593111634254, 0.04585660621523857, -0.22501541674137115, 0.029843425378203392,
    -0.0444137267768383, 0.15880230069160461, -0.03325079381465912, -0.09094419330358505, -0.07184844464063644, -0.16163326799869537, 0.05776465684175491, 0.05948552489280701,
    -0.15895353257656097, 0.13763916492462158, 0.04096122458577156, 0.13517777621746063, 0.03943631052970886, -0.01605772227048874, -0.07234695553779602, 0.04714881628751755,
    0.0860479325056076, -0.11839073896408081, -0.00590849295258522, -0.07470577955245972, -0.0746140107512474, -0.1430635154247284, -0.07691112160682678, 0.1459786742925644,
    0.011380014941096306, -0.355857253074646, 0.05497859790921211, -0.09137777984142303, 0.09802622348070145, 0.021599622443318367, 0.13754993677139282, -0.13753663003444672,
    0.03573593869805336, 0.01852600835263729, 0.12244969606399536, 0.12503696978092194, -0.050440166145563126, 0.05180145427584648, -0.059773270040750504, 0.10625836998224258,
    0.12720300257205963, 0.06383629143238068, -0.10295086354017258, 0.0560150183737278, 0.07293561846017838, 0.06607196480035782, -0.038420286029577255, -0.12199503183364868,
    -0.151488795876503, -0.11041136831045151, 0.02475823648273945, 0.013651675544679165, 0.04069795086979866, 0.2320757359266281, 0.044559601694345474, -0.04032460227608681,
    -0.06718108057975769, 0.02041393518447876, -0.1451679915189743, -0.012120912782847881, -0.01725221425294876, 0.01182848121970892, 0.0721341148018837, 0.020354287698864937,
    0.007873247377574444, -0.08382119983434677, -0.033909544348716736, -0.0271155908703804, 0.026242166757583618, -0.030809752643108368, 0.013198726810514927, 0.005934713874012232,
    0.06261051446199417, -0.019518181681632996, -0.11814773082733154, -0.0008239926537498832, 0.027201002463698387, 0.08951330929994583, 0.09565814584493637, 0.030850112438201904,
    -0.06024738773703575, -0.009562762454152107, -0.05893508717417717, -0.027699464932084084, -0.07919573783874512, -0.06649703532457352, -0.042828455567359924, -0.10674531012773514,
    -0.10867010802030563, 0.016802258789539337, 0.0749933049082756, 0.061558328568935394, -0.04169580340385437, -0.09258978813886642, 0.061690639704465866, -0.04357702657580376,
    -0.04382236301898956, 0.11012838035821915, 0.025517765432596207, -0.12466422468423843, 0.011704442091286182, 0.011410146951675415, -0.05219653621315956, 0.16085022687911987,
    -0.07684829831123352, -0.029612375423312187, 0.08194076269865036, 0.04245757311582565, 9.715362830320373e-05, -0.013680621981620789, 0.05808548256754875, 0.16471558809280396,
    -0.0985618457198143, 0.009260439313948154, -0.004143677186220884, 0.03728513419628143, -0.00948476791381836, -0.04603027179837227, 0.08320646733045578, -0.0710970014333725,
    -0.04124145582318306, 0.08178392052650452, -0.0821465328335762, -0.02461286261677742, 0.07940760999917984, -0.0679829865694046, -0.10378360003232956, -0.14051617681980133,
    -0.139368936419487, 0.00328669510781765, -0.10845597088336945, -0.13930098712444305, 0.0069704907946288586, -0.0661630779504776, -0.15762625634670258, -0.030259158462285995,
    -0.060478780418634415, 0.05675974860787392, 0.03491012006998062, 0.06697618216276169, 0.021281981840729713, -0.0879199355840683, 0.09564913064241409, 0.03348047286272049,
    -0.06849022209644318, 0.05602771043777466, -0.06283488869667053, 0.043415315449237823, -0.09949672967195511, -0.029477780684828758, 0.045893214643001556, -0.19084249436855316,
    -0.025045813992619514, 0.35379332304000854, 0.062268711626529694, -0.008179091848433018, 0.11851787567138672, 0.05252254754304886, -0.057306595146656036, -0.05035854130983353,
    -0.047071512788534164, -0.10454017668962479, 0.05807540938258171, -0.10203547030687332, -0.0350862592458725, -0.05099065601825714, -0.007387418299913406, 0.14376018941402435,
    0.04417762905359268, -0.19824479520320892, 0.013702313415706158, 0.0320189967751503, 0.028220919892191887, -0.16414231061935425, 0.017248503863811493, -0.03089958429336548,
    0.19757309556007385, -0.13790635764598846, -0.14971528947353363, 0.03482901304960251, -0.09224647283554077, -0.25203773379325867, 0.1281512975692749, 0.10064318031072617,
    -0.10356345772743225, 0.052557915449142456, 0.2548860013484955, 0.04363662749528885, -0.0550447553396225, 0.02011927403509617, -0.07242301851511002, 0.059161629527807236,
    0.09451131522655487, -0.05854830518364906, -0.22600018978118896, 0.03494597226381302, 0.16213811933994293, -0.15664242208003998, -0.022764481604099274, -0.19575177133083344,
    0.0046708607114851475, 0.017422251403331757, 0.021188024431467056, 0.05836084857583046, 0.027773205190896988, -0.08705633133649826, 0.07122628390789032, -0.15480928122997284,
    0.004310927353799343, 0.016627518460154533, 0.02267935872077942, 0.05758592486381531, 0.06710744649171829, 0.0015586047666147351, -0.04484834149479866, -0.11798504739999771,
    0.11751515418291092, 0.06123174726963043, 0.036476749926805496, -0.05776507034897804, 0.08331287652254105, -0.06468987464904785, -0.1693878322839737, 0.1066848412156105,
    0.03500782325863838, -0.06291858851909637, 0.04622296616435051, -0.08016519993543625, -0.026549553498625755, -0.08389243483543396, 0.02681378833949566, -0.06657848507165909,
    -0.09959195554256439, -0.15083634853363037, 0.04022463783621788, -0.051920223981142044, -0.09907317906618118, -0.057988040149211884, 0.15843339264392853, 0.12076962739229202,
    0.12190081179141998, 0.07606770098209381, -0.06621039658784866, -0.03361305594444275, 0.09478054195642471, -0.024955693632364273, 0.0649791732430458, -0.12004014104604721,
    -0.03274327516555786, 0.16483217477798462, 0.12056677043437958, -0.025724926963448524, -0.03514781594276428, -0.06544869393110275, 0.06539458781480789, -0.13723166286945343,
    0.10604947060346603, -0.012088809162378311, -0.013499774970114231, -0.01651342771947384, -0.021747581660747528, 0.27655789256095886, 0.05976128578186035, 0.10378602147102356,
    -0.07904908061027527, 0.0387314073741436, -0.0433095283806324, -0.07905998826026917, -0.04234662279486656, -0.08096688240766525, 0.09989060461521149, 0.11517232656478882,
    0.036980848759412766, 0.0856492668390274, -0.11888346821069717, -0.1869584619998932, -0.02481672912836075, -0.02582055702805519, 0.03473833203315735, -0.10319150239229202,
    -0.07036999613046646, -0.3253207802772522, -0.05755825713276863, 0.0003492276882752776, -0.17872820794582367, 0.024341020733118057, -0.037480391561985016, 0.10410834848880768,
    -0.06797003746032715, 0.010475318878889084, 0.027996180579066277, -0.052142057567834854, -0.0900544747710228, 0.03388352319598198, 0.0186409093439579, 0.14179320633411407,
    0.04128912836313248, 0.15381468832492828, 0.05563361197710037, -0.08387350291013718, 0.005428025033324957, 0.09072485566139221, -0.05807037279009819, -0.12850157916545868,
    -0.015734896063804626, 0.030565619468688965, -0.004048306494951248, 0.008361715823411942, -0.0181758850812912, 0.3063182532787323, -0.01997852325439453, 0.01857091672718525,
    0.1168806329369545, 0.09220065921545029, -0.2759191393852234, -0.08881926536560059, -0.08112972229719162, -0.037415023893117905, -0.049158334732055664, 0.00483302678912878,
    0.054231878370046616, 0.016342544928193092, -0.07815493643283844, -0.11567892134189606, 0.047188375145196915, 0.06615263968706131, 0.02037464827299118, -0.03715077415108681,
    -0.09969843924045563, 0.061890069395303726, 0.14515239000320435, -0.010257534682750702, -0.017028363421559334, 0.084590382874012, 0.12960155308246613, -0.1986640989780426,
    0.040276218205690384, -0.019387809559702873, -0.031414370983839035, 0.09638247638940811, 0.11782390624284744, -0.03886930271983147, -0.012277044355869293, 0.07242511957883835,
    0.010878046043217182, 0.05461018159985542, -0.07177317887544632, 0.028613077476620674, -0.07118546962738037, 0.10763061791658401, 0.00941401906311512, -0.22471636533737183,
    -0.011189448647201061, -0.16283290088176727, 0.13436608016490936, 0.0015741331735625863, 0.014671551063656807, -0.025941263884305954, -0.052877675741910934, 0.028955494984984398,
    -0.13547979295253754, -0.009063865058124065, -0.00835955236107111, 0.023815536871552467, -0.043278418481349945, 0.03408823162317276, -0.06179509684443474, 0.040647368878126144,
    0.0385717935860157, 0.05954636260867119, -0.026943780481815338, -0.10764162242412567, 0.10281677544116974, -0.03204098716378212, 0.03585033118724823, 0.011713343672454357,
    -0.11714377254247665, -0.1317126750946045, -0.1156434640288353, -0.1033630296587944, 0.07950285822153091, 0.0447780005633831, -0.006251305807381868, 0.0038555513601750135,
    0.13381314277648926, -0.044907499104738235, -0.030977055430412292, -0.04145757481455803, 0.0051648966036736965, -0.2593385577201843, -0.08763402700424194, -0.03183833137154579,
    -0.12113312631845474, -0.14605171978473663, 0.025653822347521782, -0.09040068089962006, 0.053581204265356064, 0.07346656173467636, 0.04091683775186539, -0.06550248712301254,
    0.039451297372579575, 0.13646049797534943, -0.020169014111161232, 0.1690574288368225, -0.01639452762901783, -0.028079619631171227, 0.03107810765504837, 0.015135406516492367,
    -0.0412667952477932, 0.2804470360279083, -0.004382870625704527, -0.06410924345254898, -0.1363878697156906, -0.004107221495360136, 0.05285367742180824, -0.07368224859237671,
    -0.03840135410428047, -0.021638862788677216, -0.11600705981254578, 0.16980509459972382, -0.16017743945121765, -0.041012439876794815, 0.07671035081148148, 0.05612955242395401,
    -0.02695278450846672, -0.033234208822250366, 0.020056840032339096, 0.05023163929581642, -0.06451001763343811, 0.08375567942857742, -0.13314102590084076, -0.07929706573486328,
    -0.1432366967201233, -0.020558541640639305, -0.05555346608161926, -0.042094215750694275, -0.05578744783997536, -0.28643691539764404, -0.16356059908866882, 0.10820785909891129,
    0.19743692874908447, -0.07804753631353378, 0.2250092625617981, -0.043922219425439835, -0.027480771765112877, -0.011094022542238235, 0.05973200872540474, 0.042397208511829376,
    -0.15120427310466766, -0.051421862095594406, 0.11522217839956284, -0.09301011264324188, 0.1894376277923584, 0.149040088057518, 0.11933791637420654, 0.023891082033514977,
    0.026321154087781906, -0.06716983020305634, -0.16562511026859283, -0.01807786524295807, 0.026137957349419594, 0.06630797684192657, -0.022517550736665726, -0.014059806242585182,
    -0.026080483570694923, -0.011061794124543667, -0.04698069766163826, 0.015611308626830578, -0.09649825096130371, -0.12531226873397827, -0.0656580701470375, 0.014681629836559296,
    0.07118217647075653, 0.10372753441333771, -0.13401536643505096, 0.022793667390942574, -0.14211693406105042, 0.0175012219697237, 0.17260810732841492, -0.07336975634098053,
    0.0534132681787014, 0.12671589851379395, -0.09028207510709763, -0.078757144510746, 0.06528965383768082, 0.07156410068273544, -0.16806285083293915, -0.010489585809409618,
    -0.011516166850924492, 0.07087951898574829, 0.042966656386852264, 0.01565990038216114, 0.059671223163604736, 0.1530262678861618, -0.011361709795892239, 0.1561085730791092,
    -0.053558822721242905, 0.05221588909626007, -0.04164104908704758, -0.02250772714614868, -0.03406422212719917, 0.05466601625084877, 0.1289060264825821, -0.007066967431455851,
    -0.11761302500963211, -0.06594442576169968, -0.029121097177267075, 0.022254250943660736, 0.09164375811815262, -0.02684621326625347, -0.014388381503522396, -0.07812345772981644,
    -0.11962462216615677, -0.18264761567115784, 0.00998806394636631, -0.016074925661087036, -0.08329610526561737, 0.07276211678981781, 0.04707195982336998, -0.007532857824116945,
    -0.010211778804659843, -0.028295118361711502, 0.09305236488580704, -0.024369679391384125, -0.03004625253379345, 0.021673595532774925, -0.001347539946436882, -0.1674892157316208,
    0.004177205264568329, 0.14642775058746338, -0.04682164266705513, 0.037229474633932114, 0.02122301608324051, 0.04680469632148743, -0.005415291991084814, 0.017635144293308258,
    0.03192486613988876, -0.21805118024349213, 0.001088673947378993, 0.0505041666328907, -0.026835903525352478, 0.05820455029606819, 0.12399078905582428, -0.07443669438362122,
    0.015138264745473862, -0.03534766286611557, -0.042437803000211716, 0.043523531407117844, 0.1629173755645752, -0.09549695253372192, 0.06166667118668556, -0.11383381485939026,
    0.06310165673494339, -0.030215995386242867, -0.1234084889292717, -0.005361021962016821, -0.0811576321721077, -0.273969829082489, -0.14590641856193542, 0.2053898125886917,
    0.16160152852535248, -0.10121463239192963, 0.015122078359127045, -0.012216752395033836, -0.018885454162955284, 0.28598254919052124, -0.11431178450584412, 0.12387922406196594,
    0.05600093677639961, -0.07909997552633286, -0.09663049131631851, 0.03923078998923302, -0.07977993786334991, -0.04843612387776375, 0.05574033036828041, 0.012791545130312443,
    -0.007373879197984934, -0.03669288381934166, 0.05104323476552963, 0.1336880922317505, -0.025396626442670822, -0.08555492758750916, 0.12093370407819748, -0.1033666580915451,
    0.004803033079952002, -0.03366661071777344, 0.013823085464537144, -0.055760473012924194, 0.052124038338661194, -0.0794050320982933, 0.16007015109062195, 0.019883474335074425,
    -0.06314288079738617, 0.042656056582927704, -0.03595377877354622, 0.04158390685915947, -0.018732473254203796, 0.051171090453863144, -0.07866035401821136, 0.040338605642318726,
    -0.10379038006067276, 0.01990303210914135, 0.017883414402604103, -0.08229589462280273, -0.05622619763016701, 0.01610070839524269, 0.11528538912534714, 0.12266318500041962,
    0.007948908023536205, 0.057008422911167145, -0.01162238884717226, -0.18086841702461243, -0.02808944508433342, -0.03327668458223343, -0.04460414871573448, -0.13226953148841858,
    -0.056146830320358276, -0.1238328069448471, -0.03084024041891098, -0.2186259776353836, -0.07256690412759781, 0.09727679193019867, -0.010167271830141544, 0.08717282861471176,
    0.17741531133651733, 0.013544236309826374, -0.03174237161874771, -0.04503271356225014, -0.08713719248771667, 0.012778118252754211, 0.09023983031511307, -0.08797509968280792,
    0.009872306138277054, 0.2948203682899475, 0.16248896718025208, -0.1757303923368454, 0.04213005676865578, -0.051925260573625565, -0.06789080798625946, 0.1618022322654724,
    -0.1738751232624054, -0.053106650710105896, 0.230687215924263, 0.04300989955663681, -0.0427197590470314, 0.1409371793270111, -0.003405533730983734, -0.12353769689798355,
    0.11520828306674957, 0.19921404123306274, -0.1093185544013977, 0.10048536956310272, 0.04994184151291847, -0.1313057839870453, -0.08369912952184677, -0.18473123013973236,
    -0.04520120099186897, -0.1456688791513443, -0.08511357009410858, 0.05092930048704147, -0.05867564305663109, -0.04104495421051979, -0.045882292091846466, 0.025887707248330116,
    -0.08068905770778656, 0.1429903507232666, -0.18301941454410553, 0.04076920822262764, 0.023986874148249626, -0.01113772764801979, 0.12298201024532318, 0.12218344211578369,
    0.01459572184830904, 0.11792842298746109, 0.007973171770572662, -0.11889609694480896, 0.049003440886735916, -0.13395148515701294, -0.09721051156520844, -0.03576651215553284,
    -0.11569425463676453, 0.12477181851863861, 0.011721179820597172, 0.018128329887986183, -0.09241823107004166, 0.2532927393913269, -0.09236420691013336, 0.11059065163135529,
    -0.045317456126213074, -0.1985308825969696, -0.0736306831240654, 0.024372588843107224, 0.005812915973365307, -0.27266591787338257, 0.0016153455944731832, 0.06935548037290573,
    -0.0210666973143816, -0.006646782159805298, 0.05184387043118477, 0.03376923128962517, 0.12798433005809784, 0.029028497636318207, -0.011335077695548534, -0.05267970636487007,
    0.056807324290275574, -0.0584055595099926, -0.06453220546245575, -0.03738420829176903, 0.09396502375602722, 0.0644950196146965, -0.053715165704488754, -0.1319914013147354,
    0.02610846795141697, 0.0433451384305954, 0.08775805681943893, 0.04290496185421944, -0.008486690931022167, 0.07272196561098099, 0.05144863203167915, 0.09538303315639496,
    0.012554586865007877, -0.026776503771543503, -0.06841424107551575, 0.10286522656679153, -0.07289421558380127, 0.06220979988574982, -0.04703469201922417, 0.0968465656042099,
    0.06100635975599289, 0.08249957859516144, 0.02440657652914524, 0.08812064677476883, 0.03711453825235367, -0.0100702540948987, -0.03026692010462284, -0.15346623957157135,
    0.030961930751800537, -0.09758972376585007, -0.014535460621118546, -0.04245556518435478, -0.07476329803466797, -0.08480667322874069, -0.0868988037109375, 0.10394798964262009,
    -0.013742093928158283, -0.08078257739543915, -0.08000926673412323, -0.050079528242349625, -0.0384855754673481, -0.14798180758953094, 0.09304913133382797, 0.03839145973324776,
    0.09617104381322861, -0.12841635942459106, 0.118032306432724, 0.013188195414841175, 0.04784701392054558, 0.030825918540358543, 0.09660861641168594, 0.07339334487915039,
    0.12242273986339569, -0.2833094596862793, -0.07493681460618973, -0.14470569789409637, 0.040399473160505295, -0.06061866506934166, 0.018520640209317207, 0.17744575440883636,
    -0.049192991107702255, -0.06723794341087341, 0.06653785705566406, 0.10668028146028519, -0.025403933599591255, -0.2205355018377304, 0.14055155217647552, -0.10194829851388931,
    -0.036790572106838226, -0.07719582319259644, -0.04166899994015694, 0.10662111639976501, 0.012426828034222126, 0.11186423152685165, 0.07612215727567673, -0.052090369164943695,
    -0.07652170956134796, 0.09958977997303009, 0.007526382803916931, -0.04249100014567375, -0.009868794120848179, -0.006919394712895155, 0.023855656385421753, -0.07572929561138153,
    -0.0021924946922808886, -0.07730463892221451, 0.1376354694366455, 0.010265618562698364, -0.024109337478876114, 0.024674367159605026, 0.02679494023323059, 0.06192195415496826,
    -0.04935897886753082, -0.11737263202667236, -0.022952266037464142, -0.06727955490350723, -0.16790829598903656, 0.22536130249500275, -0.001602911506779492, -0.11105126142501831,
    0.03367410600185394, -0.07297225296497345, 0.002284785732626915, -0.012773171067237854, -0.006301902700215578, 0.030445028096437454, 0.04206070303916931, 0.014634809456765652,
    -0.04058148339390755, -0.012879583053290844, -0.24174706637859344, 0.027306770905852318, 0.006486555561423302, 0.31239354610443115, 0.08095280081033707, -0.006557865533977747,
    -0.05184951424598694, 0.06925855576992035, 0.01458886731415987, -0.13252268731594086, -0.13864491879940033, 0.014456558972597122, -0.07113474607467651, -0.005253765732049942,
    -0.026886820793151855, 0.0411689467728138, -0.1290750354528427, 0.02153913490474224, -0.05975111201405525, 0.0005888379528187215, -0.0721416026353836, 0.07153705507516861,
    0.036233529448509216, 0.059547003358602524, -0.03160291910171509, 0.05903434008359909, 0.02299867942929268, 0.014995996840298176, 0.0899268314242363, 0.07436686009168625,
    0.09951349347829819, 0.0005711359553970397, 0.16308559477329254, 0.06901449710130692, -0.197785422205925, 0.11131271719932556, -0.044086407870054245, 0.2192944884300232,
    0.10965856909751892, 0.08695074915885925, -0.12050614506006241, -0.12286510318517685, -0.1254560798406601, -0.0386100597679615, 0.060676585882902145, 0.0410040020942688,
    0.07975759357213974, 0.05502741038799286, 0.07414411008358002, 0.050223734229803085, 0.0070983655750751495, 0.06400804966688156, -0.07390576601028442, 0.08409474790096283,
    -0.027905907481908798, 0.001822988735511899, -0.004483667202293873, -0.039343010634183884, -0.059640850871801376, -0.07284537702798843, -0.06491770595312119, -0.11336123198270798,
    -0.012887000106275082, -0.17022979259490967, -0.08142346143722534, -0.05104171484708786, 0.03446295112371445, 0.0185331329703331, -0.022644463926553726, 0.09926264733076096,
    0.13973458111286163, -0.06455392390489578, 0.049078792333602905, -0.02034604549407959, 0.06604086607694626, -0.19449958205223083, -0.09167452156543732, -0.062384866178035736,
    0.050941966474056244, 0.08239194750785828, 0.01477057859301567, 0.16037583351135254, -0.042972784489393234, 0.13718554377555847, -0.07166089117527008, -0.14837811887264252,
    0.0011426298879086971, 0.10363835096359253, 0.04922045022249222, -0.09506078064441681, -0.08166088908910751, 0.05766213312745094, -0.07114327698945999, 0.06830203533172607,
    0.05258471518754959, -0.027419045567512512, -0.07668435573577881, -0.0001665274176048115, 0.06270643323659897, 0.02731546014547348, 0.06627024710178375, 0.026778265833854675,
    -0.00385988294146955, 0.006140661425888538, 0.0821196511387825, 0.019404778257012367, -0.0861264318227768, -0.026294486597180367, 0.05708111450076103, -0.06723297387361526,
    -0.055112604051828384, 0.0722104161977768, -0.003664707764983177, 0.09630396217107773, -0.26413702964782715, -0.15804514288902283, 0.09045964479446411, -0.0896284356713295,
    0.16441871225833893, 0.009601357392966747, 0.08909530937671661, -0.04472984001040459, -0.07989487797021866, -0.3251769542694092, -0.007279602345079184, -0.037132348865270615,
    0.047216158360242844, 0.09355945885181427, -0.22307907044887543, -0.04829758405685425, -0.036829207092523575, -0.26153436303138733, -0.03866748884320259, -0.07256217300891876,
    -0.05388035252690315, -0.17206192016601562, -0.11518718302249908, -0.05131109058856964, -0.06883016973733902, 0.04797277972102165, 0.07765799015760422, 0.04348430782556534,
    0.1124933585524559, 0.07334592193365097, 0.1086806058883667, -0.11713491380214691, -0.007184717804193497, 0.13410057127475739, -0.07336293160915375, 0.047675084322690964,
    0.052773475646972656, -0.024848945438861847, 0.029159843921661377, -0.06259016692638397, 0.13846883177757263, -0.04126353934407234, 0.13208967447280884, -0.17747025191783905,
    0.044491928070783615, 0.030117115005850792, -0.07298065721988678, 0.04434866085648537, 0.0029343878850340843, 0.01932390406727791, -0.008807883597910404, 0.017757270485162735,
    -0.10544925928115845, 0.06751352548599243, -0.1223154366016388, 0.1313084363937378, 0.1564776748418808, 0.056868646293878555, -0.007006824482232332, 0.1808978170156479,
    -0.02686947025358677, -0.06196329742670059, 0.1337825208902359, -0.13614818453788757, 0.015405653975903988, 0.06326986849308014, -0.006730973720550537, -0.050659000873565674,
    -0.029883481562137604, -0.01126053649932146, 0.01406010054051876, -0.0704132542014122, -0.014543387107551098, -0.15725162625312805, -0.06077611818909645, 0.1022573858499527,
    -0.04316307231783867, -0.0596434585750103, 0.10343882441520691, -0.024268867447972298, -0.0830393135547638, 0.032971084117889404, -0.20216713845729828, 0.18447723984718323,
    -0.15757639706134796, 0.2865888178348541, -0.16169561445713043, 0.00938399787992239, -0.009651514701545238, -0.09606194496154785, -0.09580204635858536, -0.09883962571620941,
    -0.13792432844638824, 0.04891052842140198, 0.23917610943317413, 0.03683263435959816, -0.07564409077167511, 0.029311323538422585, -0.05931653454899788, -0.0034970962442457676,
    0.0417952761054039, -0.07304590195417404, 0.07016556710004807, -0.01219673827290535, -0.11750701069831848, -0.034834861755371094, -0.16746264696121216, 0.06502677500247955,
    -0.01312833372503519, 0.06579578667879105, -0.04349309578537941, 0.08064219355583191, 0.16651755571365356, -0.051919177174568176, -0.09960848838090897, -0.18105590343475342,
    0.007599336095154285, 0.07431363314390182, -0.05290680751204491, -0.01790834404528141, -0.023428335785865784, 0.001117610838264227, 0.016051433980464935, -0.00877317413687706,
    -0.007670594844967127, -0.09497056901454926, 0.05600005015730858, -0.018407246097922325, -0.0821133479475975, -0.017492124810814857, -0.025608882308006287, 0.10304593294858932,
    -0.0382002629339695, 0.06974884122610092, -0.13212627172470093, 0.008386196568608284, -0.0008544407319277525, 0.3162468373775482, -0.08597295731306076, -0.023738279938697815,
    0.04791387543082237, 0.19767634570598602, 0.11545191705226898, -0.057689908891916275, 0.005163155496120453, 0.23603124916553497, 0.025930022820830345, -0.13673925399780273,
    -0.10026418417692184, -0.09955395758152008, 0.15060867369174957, 0.02802393026649952, -0.19362133741378784, 0.09983528405427933, -0.04354231804609299, -0.11557599902153015,
    -0.09938356280326843, -0.03346908837556839, 0.04361763224005699, -0.030749918892979622, -0.09730111062526703, 0.10926950722932816, 0.06689349561929703, -0.09403415024280548,
    0.06157687306404114, 0.04648217186331749, 0.06420830637216568, 0.03757953643798828, -0.04177432507276535, 0.14664722979068756, 0.24725979566574097, 0.1265966147184372,
    -0.08312114328145981, -0.04275495931506157, 0.007800360210239887, -0.0446220301091671, -0.08404876291751862, -0.027365243062376976, 0.0015600521583110094, 0.057604603469371796,
    -0.1188991442322731, 0.04469533637166023, 0.10298160463571548, -0.1362326294183731, 0.24931874871253967, 0.17056281864643097, -0.06373946368694305, 0.09466295689344406,
    -0.041806288063526154, -0.12448573112487793, 0.041968196630477905, -0.20269085466861725, -0.10950291901826859, -0.06499215215444565, -0.0067031471990048885, -0.13216066360473633,
    8.932231139624491e-05, 0.003400461282581091, -0.07961595058441162, -0.168223574757576, -0.04672059789299965, -0.12209250777959824, -0.13037046790122986, -0.07746861129999161,
    -0.10092125833034515, -0.06176817789673805, 0.06300608068704605, 0.09212252497673035, -0.13934282958507538, 0.023165887221693993, -0.08465572446584702, 0.08181441575288773,
    -0.005151867400854826, -0.14676916599273682, 0.13065950572490692, -0.1381511241197586, 0.2083604633808136, -0.06000468134880066, 0.04190874844789505, -0.15219366550445557,
    -0.037989579141139984, -0.15637041628360748, -0.16531041264533997, -0.03050353191792965, -0.027535216882824898, -0.1947372704744339, 0.05222533643245697, -0.025588447228074074,
    0.24342866241931915, -0.13872714340686798, 0.09811829030513763, 0.13738824427127838, -0.04250570014119148, -0.11665825545787811, -0.12517279386520386, 0.011384889483451843,
    -0.018390150740742683, 0.09145458042621613, 0.02523263730108738, 0.00978320837020874, -0.06643720716238022, -0.014775821007788181, -0.05207964777946472, 0.04368361830711365,
    -0.14153186976909637, -0.13638420403003693, 0.11735694855451584, 0.13415634632110596, 0.126015767455101, -0.02583279088139534, -0.1784510463476181, 0.058384351432323456,
    -0.07015445828437805, 0.04621302708983421, 0.044183485209941864, 0.03974789008498192, 0.048186708241701126, -0.08844433724880219, 0.15778282284736633, -0.08445101231336594,
    -0.032059721648693085, -0.10074350237846375, -0.08188446611166, 0.03461514040827751, -0.08693045377731323, -0.06889033317565918, -0.08447013050317764, -0.0501362644135952,
    -0.12554383277893066, -0.02181333117187023, 0.07286123931407928, 0.04440070688724518, -0.05860893055796623, -0.200180783867836, -0.09052868187427521, -0.14669039845466614,
    0.01992848515510559, 0.10153248906135559, -0.13385917246341705, -0.09671314805746078, -0.10001406073570251, 0.17474836111068726, -0.04699486121535301, -0.22583907842636108,
    0.019782179966568947, 0.00306790042668581, -0.06012330576777458, 0.17716003954410553, -0.008189937099814415, 0.062442995607852936, -0.11589954048395157, -0.0158338975161314,
    -0.02566790021955967, 0.04515961557626724, 0.0006461387383751571, 0.09344327449798584, -0.015711886808276176, -0.09628864377737045, 0.04767534136772156, -0.03749001771211624,
    0.005097827408462763, -0.03405367583036423, -0.04637623578310013, -0.1038561686873436, 0.07436647266149521, -0.14113426208496094, 0.05319514125585556, 0.03169843927025795,
    0.07381457835435867, 0.09980536252260208, 0.15792393684387207, 0.1292395293712616, 0.04994439706206322, 0.028578050434589386, -0.06768310815095901, -0.13316383957862854,
    0.01525232195854187, -0.034409668296575546, 0.09640934318304062, -0.10740850120782852, 0.018244758248329163, 0.07629077136516571, 0.025001315400004387, 0.1608591228723526,
    -0.049963198602199554, -0.19929827749729156, -0.01097419485449791, 0.14850600063800812, -0.031151771545410156, -0.016922960057854652, -0.18461818993091583, -0.09007108956575394,
    0.004288803320378065, 0.06427856534719467, 0.024320442229509354, 0.1692396104335785, -0.14168299734592438, -0.005463109817355871, -0.016916116699576378, 0.04060849919915199,
    0.09289992600679398, -0.10185986012220383, -0.09677811712026596, -0.06802335381507874, 0.03474324941635132, -0.036131273955106735, -0.07462775707244873, -0.022916750982403755,
    -0.02809040993452072, -0.13206851482391357, -0.011793768033385277, 0.004276660270988941, -0.004709061700850725, 0.18814870715141296, -0.1538931131362915, 0.18478071689605713,
    0.024037037044763565, -0.04190171882510185, -0.1313932090997696, -0.025128431618213654, -0.008128179237246513, -0.08564881235361099, -0.026304934173822403, -0.007064067758619785,
    0.032910339534282684, 0.0292946919798851, -0.07232250273227692, -0.26049721240997314, -0.01715535670518875, 0.07647702842950821, -0.18883474171161652, 0.14834342896938324,
    -0.06547075510025024, 0.18338832259178162, 0.03403608873486519, 0.06683172285556793, 0.07970856875181198, -0.007424934767186642, 0.07923157513141632, -0.04207965359091759,
    -0.044637080281972885, 0.14615942537784576, -0.20018218457698822, 0.13931548595428467, 0.08073180168867111, 0.11242798715829849, 0.06760628521442413, -0.05745347589254379,
    0.0015503020258620381, 0.02418322116136551, 0.06605906039476395, 0.041732240468263626, -0.07583410292863846, -0.2844889461994171, -0.05347336828708649, 0.07859113067388535,
    0.023687340319156647, -0.06812620908021927, 0.044969234615564346, 0.009686723351478577, -0.04403240978717804, 0.17693790793418884, -0.03920074924826622, -0.08187521994113922,
    -0.028916623443365097, -0.035598862916231155, 0.041508328169584274, -0.14767508208751678, -0.16817529499530792, 0.07476732134819031, 0.03814789280295372, 0.1036979928612709,
    -0.022236008197069168, 0.06113620847463608, 0.033513426780700684, -0.0441468320786953, -0.12114667147397995, -0.03549066558480263, -0.1344670206308365, 0.1438225954771042,
    -0.11376386135816574, -0.035574398934841156, -0.09796535968780518, 0.0037066906224936247, 0.14640484750270844, 0.08014649897813797, -0.12614193558692932, 0.03419256582856178,
    0.08977177739143372, -0.004425108432769775, -0.09131622314453125, 0.006323331966996193, -0.002366273198276758, 0.07721151411533356, 0.041767966002225876, -0.03049224615097046,
    0.008825971744954586, 9.099308954318985e-05, -0.025257747620344162, -0.14135663211345673, -0.157470241189003, -0.20381197333335876, -0.11708392202854156, -0.12819865345954895,
    -0.027607200667262077, 0.07799607515335083, 0.16834375262260437, -0.17765161395072937, 0.05696822330355644, 0.0006614609155803919, 0.10069265216588974, 0.1442718505859375,
    0.03212204948067665, -0.16607187688350677, -0.028576962649822235, 0.048353977501392365, 0.1309790462255478, -7.827226363588125e-05, 0.039808910340070724, -0.151685893535614,
    -0.1213112398982048, 0.2131483405828476, 0.10953200608491898, 0.09658508747816086, 0.028676660731434822, -0.035942282527685165, -0.011299802921712399, 0.15711967647075653,
    -0.053185753524303436, 0.27658912539482117, -0.08178849518299103, 0.02760891057550907, -0.01410970464348793, -0.060176972299814224, 0.03790619596838951, 0.0598260834813118,
    0.04698191210627556, 0.07752326875925064, 0.04225948825478554, -0.08147449791431427, 0.0341838039457798, -0.08225633203983307, -0.06162964552640915, -0.03498376905918121,
    -0.15837310254573822, 0.07240038365125656, 0.10581139475107193, 0.03197389096021652, -0.16816338896751404, -0.12531714141368866, 0.037559282034635544, -0.1067756935954094,
    -0.02828659862279892, 0.13505323231220245, 0.07089251279830933, 0.18719840049743652, 0.20597103238105774, 0.060701191425323486, 0.12020741403102875, 0.15120498836040497,
    -0.0020977118983864784, -0.23120233416557312, 0.027409477159380913, -0.019850505515933037, -0.01551495399326086, 0.05746511369943619, 0.16335104405879974, -0.06508289277553558,
    -0.0082700839266181, 0.076363205909729, 0.09905291348695755, -0.08536915481090546, 0.06100122630596161, -0.026036936789751053, 0.01585611328482628, -0.09683777391910553,
    -0.16162419319152832, 0.1147644892334938, 0.09063573181629181, 0.016575438901782036, -0.03940443694591522, 0.4743436574935913, 0.09534299373626709, -0.08541402220726013,
    0.1573818176984787, -0.1434350311756134, -0.1514715701341629, -0.04446985945105553, -0.08335360884666443, -0.14682839810848236, 0.11797551065683365, -0.11303961277008057,
    -0.14890974760055542, -0.0716119036078453, 0.024303492158651352, -0.2490594983100891, -0.009942686185240746, 0.07062963396310806, 0.06850142776966095, 0.11262434720993042,
    -0.04461924359202385, 0.15946969389915466, -0.02796606346964836, -0.14500853419303894, -0.028919614851474762, -0.09755174070596695, 0.10834242403507233, 0.08701841533184052,
    -0.22034960985183716, -0.022910038009285927, 0.003101809648796916, 0.03393096849322319, 0.06177176535129547, -0.0006503018666990101, -0.11188122630119324, 0.17786934971809387,
    0.02964349277317524, -0.0008496380760334432, 0.012987175956368446, -0.02815144695341587, -0.05426695570349693, -0.039487577974796295, -0.029288651421666145, -0.09710139781236649,
    0.038179174065589905, 0.010626966133713722, -0.2549736797809601, 0.15813720226287842, 0.11696989089250565, 0.002586929826065898, -0.06804575026035309, 0.02498014271259308,
    0.00623503839597106, 0.08080346882343292, -0.04016478732228279, 0.17793609201908112, -0.000442117074271664, -0.09649206697940826, -0.09966181963682175, -0.07494926452636719,
    0.1251189112663269, 0.03470883145928383, 0.00961141474545002, 0.006358343176543713, -0.1289282888174057, 0.08265789598226547, 0.026118244975805283, 0.059185903519392014,
    -0.12594348192214966, 0.07829257845878601, 0.08960665017366409, 0.04650717228651047, 0.07496538758277893, -0.05412103980779648, 0.2643115222454071, 0.20279943943023682,
    0.09875592589378357, -0.14634232223033905, 0.15810935199260712, 0.05493254214525223, -0.034235965460538864, -0.09613952785730362, 0.14043167233467102, -0.10732898116111755,
    -0.07182454317808151, -0.12316268682479858, -0.086866095662117, 0.06520234793424606, 0.06257912516593933, -0.1096404641866684, 0.055071279406547546, -0.07412448525428772,
    -0.05336002632975578, 0.03710206598043442, 0.18919655680656433, 0.0676780641078949, -0.0027132038958370686, -0.07529052346944809, -0.08607465773820877, 0.0338522344827652,
    0.24365302920341492, 0.0016766841290518641, 0.14720328152179718, -0.0423731654882431, 0.11994127184152603, -0.06762844324111938, 0.18563629686832428, 0.16783633828163147,
    -0.21603798866271973, 0.27251067757606506, 0.17341411113739014, -0.05473612993955612, -0.0014890783932060003, 0.06507404148578644, 0.1651993691921234, 0.0998828336596489,
    0.0025582818780094385, -0.13544774055480957, 0.1383662074804306, -0.22540226578712463, -0.14196240901947021, 0.009485213086009026, 0.03285122290253639, -0.041000865399837494,
    -0.2946794629096985, -0.1421174257993698, -0.008861308917403221, -0.06989068537950516, -0.07509507238864899, -0.38154277205467224, 0.1473338007926941, -0.12919624149799347,
    -0.17867842316627502, -0.07852812856435776, 0.07645513117313385, -0.0095480065792799, -0.01060780044645071, 0.10383673757314682, -0.12925541400909424, -0.08950299024581909,
    0.02869151532649994, -0.07965099811553955, -0.07043943554162979, 0.2545391023159027, -0.10699521750211716, 0.04695826768875122, 0.007737788371741772, -0.07788508385419846,
    0.01974736526608467, 0.1285620480775833, -0.055958155542612076, -0.10935553163290024, -0.25561726093292236, 0.05471288040280342, -0.0035178312100470066, -0.2940993309020996,
    -0.17707036435604095, 0.04102065786719322, 0.07636010646820068, -0.00189135258551687, -0.030152587220072746, -0.06853844225406647, 0.21215344965457916, -0.08847417682409286,
    0.026886601001024246, 0.05083629861474037, -0.032906532287597656, -0.10527905076742172, 0.07487361133098602, -0.029040057212114334, 0.07674891501665115, -0.15723471343517303,
    -0.026102449744939804, 0.020189687609672546, 0.039788536727428436, -0.15902632474899292, -0.048042599111795425, -0.04261894151568413, 0.07058844715356827, -0.009860500693321228,
    -0.029977506026625633, -0.12187543511390686, 0.12596046924591064, -0.013745213858783245, -0.05221446231007576, 0.12495196610689163, 0.16842642426490784, -0.021226217970252037,
    0.10438623279333115, 0.08373916149139404, 0.00936632789671421, 0.22706927359104156, 0.09607138484716415, -0.025286342948675156, -0.10762561112642288, -0.07164454460144043,
    -0.07146886736154556, 0.1578516811132431, 0.010883958078920841, -0.12724019587039948, -0.12233170866966248, -0.08934196084737778, 0.19120223820209503, -0.029107151553034782,
    -0.003120056353509426, -0.030699197202920914, 0.01515359990298748, -0.08987769484519958, 0.14550846815109253, 0.10675141960382462, 0.25650349259376526, 0.22469013929367065,
    -0.10994242876768112, -0.06338721513748169, 0.08732643723487854, -0.021097267046570778, -0.007522732485085726, 0.20977190136909485, 0.0015520668821409345, 0.04893992468714714,
    0.08470413088798523, -0.05610036104917526, 0.14977073669433594, -0.12401223182678223, 0.09933702647686005, -0.07049844413995743, -0.07736701518297195, 0.13037708401679993,
    0.02596750482916832, -0.06663796305656433, -0.06825822591781616, 0.0991322323679924, -0.09544479846954346, 0.11398276686668396, 0.10646603256464005, -0.19463270902633667,
    -0.1388695240020752, -0.2953592836856842, -0.053170789033174515, 0.11137104034423828, -0.07372444123029709, 0.02719072438776493, 0.13877572119235992, -0.03620179370045662,
    0.04164571687579155, 0.02383526973426342, -0.1315600723028183, 0.051871880888938904, -0.09278088063001633, 0.11774121969938278, 0.007473210338503122, 0.1355239450931549,
    -0.10436518490314484, 0.020758695900440216, 0.09663880616426468, 0.08291789889335632, -0.03660161793231964, -0.032002873718738556, 0.09149232506752014, -0.14775963127613068,
    0.07302545011043549, 0.13323667645454407, 0.09632263332605362, 0.05527564883232117, -0.030128352344036102, -0.1277897208929062, 0.050165146589279175, 0.13089165091514587,
    -0.11895638704299927, 0.0005617237184196711, 0.11286010593175888, 0.03411070257425308, 0.09317494183778763, -0.0466911680996418, -0.2444981038570404, 0.03571047633886337,
    -0.15961319208145142, 0.06268710643053055, -0.0006059414008632302, 0.10048861801624298, -0.018447089940309525, -0.17080643773078918, -0.036628492176532745, 0.19414275884628296,
    0.13547034561634064, -0.029900699853897095, -0.12587983906269073, 0.028834762051701546, 0.04240725561976433, 0.13218005001544952, 0.23857180774211884, -0.04351065307855606,
    0.04071349278092384, -0.013974098488688469, -0.006205067504197359, -0.01034496445208788, -0.044550541788339615, 0.07457033544778824, -0.07546962797641754, -0.039157718420028687,
    -0.06959131360054016, -0.013475212268531322, 0.11658693850040436, 0.13837499916553497, 0.028565071523189545, 0.040283121168613434, -0.19312185049057007, 0.008587510325014591,
    0.029640430584549904, 0.036140162497758865, -0.06677240133285522, -0.07369215041399002, -0.04635556414723396, -0.02770637534558773, 0.08959414809942245, -0.12449488043785095,
    -0.019741157069802284, -0.14398543536663055, 0.05512392893433571, -0.011057952418923378, -0.016626514494419098, 0.06711354106664658, -0.28797397017478943, -0.23571856319904327,
    -0.12024141848087311, 0.12957032024860382, 0.2581578493118286, 0.08009745180606842, -0.1155468076467514, 0.04601716622710228, 0.17258748412132263, -0.19293667376041412,
    -0.21069300174713135, 0.11944364011287689, -0.008644964545965195, -0.02569216676056385, -0.03403501957654953, 0.12142643332481384, 0.010230320505797863, 0.1316833794116974,
    0.22009119391441345, 0.1397583782672882, 0.14887773990631104, 0.10009701550006866, 0.07761406898498535, -0.14033757150173187, -0.04272005707025528, -0.1169915497303009,
    0.14859171211719513, 0.08989938348531723, 0.10020574182271957, -0.019095608964562416, 0.14614585041999817, -0.021731415763497353, -0.13451899588108063, 0.12847919762134552,
    0.10083678364753723, -0.036947086453437805, 0.06553753465414047, -0.14971356093883514, -0.12679587304592133, -0.10867974162101746, 0.01693318784236908, -0.17537613213062286,
    0.18850146234035492, 0.26876503229141235, 0.038836006075143814, 0.10831451416015625, 0.10395220667123795, 0.00972338393330574, -0.02100541815161705, -0.04721521586179733,
    -0.05311848595738411, 0.19692406058311462, -0.20436319708824158, -0.0144790168851614, -0.14003722369670868, 0.013677891343832016, 0.1909659504890442, -0.0019578468054533005,
    -0.11487029492855072, 0.16162081062793732, -0.012776722200214863, 0.04776502028107643, 0.06410354375839233, 0.3888389468193054, -0.0013026264496147633, -0.02907901629805565,
    0.12415999174118042, 0.01482884120196104, 0.023040350526571274, 0.056372713297605515, -0.09379621595144272, 0.07339096814393997, -0.016341762617230415, 0.1444905400276184,
    0.10255327820777893, 0.202047199010849, -0.12198758125305176, -0.12961670756340027, 0.03565981239080429, -0.1349300593137741, 0.07094564288854599, 0.24946452677249908,
    -0.031562402844429016, -0.09501278400421143, 0.07479629665613174, -0.04662337154150009, -0.08181878179311752, -0.07600794732570648, 0.05664524435997009, 0.22868362069129944,
    0.1582137793302536, -0.03514143452048302, -0.006033672951161861, 0.03999529033899307, -0.05962206795811653, -0.1222648099064827, 0.01761307753622532, -0.13883033394813538,
    0.08289439231157303, -0.016949869692325592, 0.036686547100543976, 0.09006048738956451, 0.10476293414831161, 0.0659455880522728, -0.01961793191730976, -0.0629226341843605,
    0.05351483076810837, -0.02225133776664734, -0.013898313976824284, -0.1326940655708313, 0.07309629023075104, -0.02855447120964527, 0.08435142040252686, 0.02252182736992836,
    0.05148981139063835, -0.1493435502052307, -0.0515022836625576, -0.04072875902056694, 0.005716333631426096, -0.04693162441253662, -0.02408756874501705, 0.1236778125166893,
    0.08449273556470871, -0.09179075062274933, 0.10337217897176743, 0.1099495142698288, -0.06640198081731796, 0.04048854485154152, -0.08966205269098282, 0.05256608873605728,
    -0.11378739029169083, 0.09618906676769257, -0.07348717749118805, -0.026132788509130478, 0.193470761179924, 0.06781377643346786, 0.1396709829568863, 0.10134739428758621,
    0.11210539937019348, 0.01814592257142067, 0.028456315398216248, 0.28647932410240173, 0.07025165855884552, -0.012490461580455303, -0.0971597284078598, -0.021108241751790047,
    0.019108233973383904, 0.10530021041631699, 0.08798271417617798, -0.0070089674554765224, -0.030783290043473244, -0.013834652490913868, 0.11840040236711502, 0.007496414240449667,
    -0.03695838153362274, 0.023788271471858025, -0.020269164815545082, 0.027492405846714973, -0.03278670832514763, 0.03750889375805855, -0.006220832001417875, 0.05740108713507652,
    -0.21743758022785187, 0.10183895379304886, -0.03036355786025524, 0.03020096942782402, 0.12807384133338928, -0.15616627037525177, 0.053398843854665756, 0.23360972106456757,
    0.054891690611839294, -0.2589060366153717, 0.003809022717177868, -0.06567864120006561, 0.13248121738433838, -0.04546751827001572, -0.010105414316058159, 0.09202335774898529,
    -0.03793874755501747, -0.19170458614826202, 0.1280282586812973, -0.14440925419330597, -0.10673440992832184, 0.09338099509477615, 0.2540825605392456, -0.1117028072476387,
    -0.20850495994091034, -0.17807455360889435, -0.002155048307031393, -0.05062035843729973, -0.013771457597613335, -0.46750715374946594, 0.09398261457681656, 0.11654110997915268,
    -0.21283358335494995, -0.062423355877399445, 0.2397695928812027, -0.0002499204420018941, -0.0300475861877203, -0.06496632844209671, 0.008027983829379082, 0.04163235053420067,
    0.20934432744979858, -0.12450196593999863, 0.1284336894750595, -0.16814778745174408, 0.020445840433239937, -0.2734014689922333, 0.16906248033046722, 0.10588929802179337,
    0.03671480715274811, 0.10959824919700623, 0.02955537475645542, 0.17105832695960999, -0.1528276801109314, -0.13774926960468292, 0.03927130624651909, -0.2852625548839569,
    0.19093774259090424, -0.010669409297406673, -0.08539989590644836, -0.07132746279239655, 0.11396186053752899, 0.16132259368896484, -0.027458805590867996, -0.25705793499946594,
    0.003796484088525176, 0.03181203827261925, -0.018912015482783318, -0.027903273701667786, 0.2857884466648102, -0.026007063686847687, 0.09386719018220901, 0.16033388674259186,
    0.14658676087856293, -0.007572762202471495, -0.12812043726444244, 0.09676873683929443, 0.04388473182916641, -0.027693789452314377, -0.02617468498647213, 0.1928030252456665,
    -0.018678434193134308, -0.03148150071501732, 0.08551294356584549, -0.23496346175670624, -0.014505987986922264, 0.03409365937113762, 0.050662022083997726, -0.14739729464054108,
    0.14779019355773926, 0.06919920444488525, 0.08685846626758575, -0.1723432093858719, 0.28674066066741943, -0.002448518993332982, -0.1841936707496643, -0.07339882105588913,
    0.10397513210773468, -0.028552357107400894, -0.1302129179239273, 0.005144196562469006, 0.08841788023710251, 0.020789310336112976, -0.1269691288471222, 0.11002375185489655,
    0.06949254125356674, -0.009764384478330612, -0.13902300596237183, -0.11800330132246017, -0.10843957960605621, -0.3132215738296509, 0.22696292400360107, 0.16399675607681274,
    0.07679908722639084, 0.19632402062416077, -0.024810589849948883, 0.024939678609371185, -0.04569045454263687, 0.15045730769634247, -0.20028792321681976, 0.03820524737238884,
    -0.2582661509513855, -0.15131957828998566, 0.05978706479072571, 0.021233854815363884, -0.12423823028802872, -0.080655038356781, 0.060095082968473434, -0.08860822767019272,
    -0.20331427454948425, -0.09930169582366943, 0.051255904138088226, 0.12124184519052505, 0.12459034472703934, -0.042056288570165634, -0.06247046962380409, 0.0775584727525711,
    -0.10529039055109024, 0.2339080572128296, 0.005856486968696117, 0.08500754833221436, -0.07366035878658295, 0.005707778502255678, 0.02161998488008976, 0.002870745025575161,
    0.030580706894397736, 0.0850498303771019, 0.03692244738340378, 0.10392807424068451, -0.08259844779968262, -0.01016117911785841, 0.013440750539302826, 0.04905667155981064,
    -0.02040811814367771, -0.024987200275063515, -0.02366611547768116, -0.058419808745384216, 0.07685152441263199, 0.2580364942550659, 0.19222012162208557, -0.2814924120903015,
    0.06978508830070496, -0.2553495168685913, 0.24762600660324097, 0.07227776944637299, 0.0855807289481163, 0.11151359975337982, -0.073373943567276, 0.02556825429201126,
    0.027452193200588226, -0.05067950487136841, -0.06500022113323212, 0.17944855988025665, 0.04371258616447449, -0.3115372657775879, -0.02322976477444172, -0.16940434277057648,
    -0.06750476360321045, 0.06521212309598923, -0.07227238267660141, 0.026812056079506874, -0.010301375761628151, -0.1286015808582306, -3.479665974737145e-05, -0.10114087909460068,
    -0.014581563882529736, 0.04251445457339287, 0.013849979266524315, 0.054584044963121414, -0.07064352184534073, -0.08035451918840408, -0.06824803352355957, -0.11244891583919525,
    -0.0038006999529898167, -0.02170947566628456, -0.09454002976417542, 0.1812766045331955, -0.02208106964826584, 0.1688050478696823, -0.05352954566478729, 0.08322028815746307,
    0.13498768210411072, -0.05044136196374893, 0.004072814714163542, -0.07781098783016205, -0.17887063324451447, 0.1052984818816185, 0.0005709757097065449, 0.1286812126636505,
    0.05882316827774048, -0.11587104946374893, -0.16177153587341309, 0.12782691419124603, -0.0927218422293663, -0.0209050290286541, -0.0008113742806017399, 0.08618300408124924,
    0.08011063188314438, 0.010963640175759792, -0.08591114729642868, 0.05886724963784218, -0.13502435386180878, -0.03693347051739693, 0.06731913238763809, -0.2995676100254059,
    0.20064519345760345, -0.1299794763326645, -0.05632798746228218, 0.019766326993703842, 0.15684284269809723, -0.05935163050889969, -0.08260171115398407, -0.0353122241795063,
    -0.06122410669922829, 0.06296063214540482, 0.037408050149679184, 0.01060659158974886, -0.15750457346439362, -0.05310981348156929, -0.07563579827547073, 0.08713096380233765,
    -0.0072749098762869835, 0.05940001830458641, -0.01551149133592844, -0.1523352414369583, 0.09011095762252808, -0.17426802217960358, -0.10080946981906891, 0.11635306477546692,
    -0.03393464535474777, 0.0661342442035675, 0.17641887068748474, -0.04655105248093605, -0.008064445108175278, -0.1097114160656929, -0.09385014325380325, -0.23191919922828674,
    0.05029769241809845, -0.05313832685351372, 0.031680237501859665, 0.13630765676498413, -0.14130814373493195, -0.00976029597222805, -0.06414517015218735, -0.227872833609581,
    -0.3923088312149048, -0.218970388174057, -0.06348524987697601, 0.059823811054229736, -0.09761249274015427, 0.01687340810894966, -0.11965453624725342, -0.03964002802968025,
    0.06888619065284729, 0.09360121190547943, -0.15936127305030823, 0.04694107919931412, 0.07553183287382126, -0.018527237698435783, 0.0854131206870079, -0.2016315907239914,
    0.014724408276379108, 0.15693770349025726, -0.11107444018125534, 0.06916392594575882, 0.2924595773220062, 0.11373602598905563, 0.17778638005256653, -0.016610074788331985,
    0.11476998776197433, -0.1293496936559677, 0.11691953241825104, 0.11857929080724716, -0.044035300612449646, -0.13990728557109833, -0.2406214326620102, 0.06965681910514832,
    -0.0640941932797432, 0.14162464439868927, 0.03613021969795227, -0.0590829998254776, -0.018061088398098946, -0.142999067902565, 0.066926971077919, -0.011533553712069988,
    0.14626437425613403, 0.11955832690000534, -0.018947400152683258, -0.046889714896678925, -0.06539717316627502, -0.10546109080314636, 0.09424683451652527, 0.19725382328033447,
    -0.1168772503733635, 0.03363585099577904, -0.07204265147447586, 0.06434744596481323, -0.08085107058286667, -0.13772954046726227, 0.2744963765144348, -0.07372032850980759,
    -0.01073185633867979, -0.003763208631426096, 0.202284574508667, 0.16808351874351501, -0.02935469150543213, -0.002315082121640444, -0.04432393237948418, 0.07207757979631424,
    -0.03345906361937523, -0.040690068155527115, 0.11413991451263428, 0.07183509320020676, -0.16154690086841583, -0.09154821932315826, -0.12722091376781464, 0.08035600185394287,
    -0.02017008326947689, 0.14043515920639038, 0.1580287516117096, 0.16644254326820374, 0.07089382410049438, -0.002219982910901308, -0.05664150416851044, 0.04373621195554733,
    -0.05114436894655228, 0.0882980078458786, 0.07721849530935287, 0.1037898063659668, 0.0399271622300148, -0.03232855722308159, 0.2584317624568939, -0.1614222526550293,
    0.15238037705421448, -0.1098327711224556, 0.19529208540916443, 0.10126461833715439, 0.058826934546232224, 0.010925482958555222, 0.21137158572673798, 0.004842778667807579,
    0.06872431933879852, 0.05085773393511772, -0.04830223694443703, 0.15868525207042694, 0.08546151965856552, 0.0951797217130661, -0.1708231270313263, 0.14143262803554535,
    -0.11986220628023148, -0.11900926381349564, 0.09396105259656906, -0.07052022963762283, -0.014442005194723606, 0.04616198688745499, -0.09622073918581009, -0.16405798494815826,
    0.06750373542308807, 0.03647249937057495, -0.044841259717941284, -0.08001619577407837, -0.027160126715898514, -0.040863871574401855, 0.13487958908081055, 0.03403770551085472,
    -0.03758079558610916, -0.062437620013952255, 0.05723775923252106, -0.07947202771902084, -0.17380456626415253, -0.10368061065673828, 0.003831924172118306, 0.030648717656731606,
    -0.27911555767059326, 0.18665504455566406, 0.04338335245847702, -0.018824268132448196, 0.12220871448516846, -0.008286303840577602, -0.24390825629234314, 0.087142713367939,
    0.004107300192117691, -0.11973797529935837, -0.06768219918012619, -0.0740419253706932, 0.03614284098148346, -0.1626358926296234, 0.013224069960415363, 0.0406612828373909,
    -0.003620551433414221, -0.05679282918572426, -0.0017785702366381884, 0.0182754248380661, 0.15089760720729828, -0.40334635972976685, -0.024460013955831528, -0.17911440134048462,
    -0.2150454819202423, 0.04928864538669586, 0.265703946352005, 0.06497733294963837, -0.05322115495800972, 0.13013893365859985, -0.23744826018810272, 0.038766007870435715,
    0.12065467238426208, -0.04148130118846893, 0.04152795672416687, -0.3405168354511261, 0.0464564748108387, -0.2109367996454239, -0.014774234034121037, 0.23130735754966736,
    0.10443929582834244, -0.06336015462875366, 0.032429926097393036, 0.09718824923038483, -0.10191456228494644, -0.0034587355330586433, 0.004645185079425573, -0.0028867353685200214,
    -0.09484950453042984, 0.00998641736805439, 0.03626050427556038, -0.03129884600639343, 0.053251344710588455, 0.21282228827476501, -0.04521864652633667, 0.023739175871014595,
    -0.08182650059461594, 0.004591562319546938, 0.009893406182527542, 0.0955687090754509, -0.11492367833852768, 0.029814593493938446, -0.06635399907827377, 0.1680503636598587,
    -0.18857619166374207, 0.024256549775600433, 0.07185027003288269, -0.1219942569732666, 0.1853739470243454, -0.18664948642253876, 0.016318876296281815, 0.05322040617465973,
    -0.01365591399371624, 0.01553024910390377, 0.22674840688705444, -0.10501895099878311, -0.0501965694129467, -0.028958210721611977, 0.09973081946372986, -0.06656835973262787,
    0.06490293145179749, -0.010888826102018356, 0.08337091654539108, -0.12311824411153793, 0.20811301469802856, -0.02815977856516838, 0.06690163910388947, -0.333120197057724,
    0.032467037439346313, -0.11867297440767288, 0.15753215551376343, 0.024560648947954178, 0.0896022692322731, 0.007636052090674639, 0.20003025233745575, -0.03922801464796066,
    -0.004497869871556759, 0.05197159945964813, -0.016387663781642914, 0.06217431649565697, 0.06820758432149887, 0.042960066348314285, -0.1605173647403717, 0.12537293136119843,
    -0.2589944899082184, 0.09296778589487076, -0.11239944398403168, 0.1589832901954651, 0.1341424435377121, 0.050750646740198135, -0.10262851417064667, -0.028846558183431625,
    -0.050285909324884415, -0.044048309326171875, 0.06206376850605011, 0.06265343725681305, -0.10261370241641998, 0.11771562695503235, 0.07946998625993729, 0.2213030755519867,
    -0.051043085753917694, 0.06414923071861267, 0.0266795065253973, 0.166934996843338, 0.027406901121139526, 0.09633523970842361, -0.016667429357767105, -0.24374522268772125,
    0.12622149288654327, -0.1992315649986267, 0.05056651309132576, -0.1329267919063568, 0.04673955217003822, 0.037942565977573395, -0.052917126566171646, -0.009865527041256428,
    -0.01842283084988594, 0.1216544359922409, 0.19526726007461548, -0.05222748965024948, 0.17443343997001648, -0.18634915351867676, -0.03254551813006401, 0.14197798073291779,
    -0.11084526777267456, -0.02411208674311638, 0.22746440768241882, -6.9315738073782995e-06, 0.18032658100128174, 0.4702756702899933, -0.17158132791519165, 0.03742572292685509,
    0.12016000598669052, -0.007365836761891842, 0.07934518158435822, 0.048523206263780594, 0.03163931518793106, -0.029801400378346443, -0.07349831610918045, -0.06459908187389374,
    0.12639696896076202, 0.007266787812113762, -0.07669299840927124, 0.061421625316143036, -0.13316626846790314, -0.18780618906021118, -0.03263811022043228, -0.06386047601699829,
    -0.1449434459209442, 0.19129444658756256, -0.09093445539474487, -0.1836715191602707, 0.17864581942558289, -0.07531896978616714, 0.1068764179944992, -0.2050689309835434,
    0.12758523225784302, -0.001519779092632234, 0.02064945362508297, 0.03475251793861389, 0.2697645425796509, -0.22996193170547485, -0.17488102614879608, 0.1100568026304245,
    0.013894972391426563, -0.009724220260977745, 0.0071235657669603825, 0.11720215529203415, 0.15170907974243164, -0.05758989229798317, -0.040744632482528687, 0.2350872904062271,
    -0.08543593436479568, -0.03693211078643799, 0.06461726129055023, 0.1149473711848259, 0.048746366053819656, 0.13901716470718384, 0.07630377262830734, 0.05606068670749664,
    0.01619124971330166, 0.12990915775299072, -0.12981759011745453, 0.025850262492895126, -0.06793008744716644, 0.007639366667717695, -0.05665632337331772, 0.0020121911074966192,
    0.018071575090289116, -0.09880251437425613, -0.035574741661548615, 0.14689572155475616, -0.10826106369495392, 0.022226333618164062, -0.1453247368335724, -0.30694228410720825,
    -0.12243245542049408, -0.06861629337072372, 0.034802429378032684, -0.13683752715587616, 0.06845961511135101, 0.05213814973831177, -0.08918499201536179, 0.07279468327760696,
    0.06349606066942215, -0.15556617081165314, 0.03640773892402649, -0.07578103989362717, 0.07226772606372833, -0.21971896290779114, 0.030727079138159752, -0.18065603077411652,
    -0.14776431024074554, 0.15608489513397217, -0.45393532514572144, 0.14729364216327667, 0.028813453391194344, -0.11813046783208847, -0.05806679278612137, 0.041594427078962326,
    -0.4051949083805084, 0.07621337473392487, 0.009569698013365269, -0.05633808672428131, -0.08143789321184158, -0.07402953505516052, -0.1735205054283142, 0.021843362599611282,
    0.16636702418327332, -0.09826622158288956, -0.10676207393407822, -0.020116090774536133, 0.09776561707258224, 0.06203025206923485, 0.06292323023080826, -0.0795312225818634,
    -0.02486223168671131, 0.22143436968326569, -0.19260722398757935, -0.028328558430075645, 0.10344230383634567, 0.06681378930807114, -0.06620783358812332, 0.009984259493649006,
    0.01188428234308958, 0.07432547956705093, 0.12352097034454346, -0.12837906181812286, -0.05586880445480347, -0.0649019181728363, -0.009975896216928959, 0.11070700734853745,
    -0.19109389185905457, 0.07469934225082397, -0.002403796650469303, -0.06246647238731384, 0.2603377401828766, -0.32506701350212097, -0.09842899441719055, 0.07347553968429565,
    0.045738618820905685, 0.14681220054626465, -0.01803620718419552, 0.04778795316815376, -0.012978854589164257, 0.04928138107061386, -0.09882047772407532, -0.15264928340911865,
    0.11113941669464111, 0.13884605467319489, 0.07013344764709473, 0.02696261741220951, -0.01476189587265253, -0.0851999893784523, -0.15014925599098206, -0.2451660931110382,
    0.00010862352064577863, -0.020104173570871353, 0.0699499174952507, 0.23442938923835754, 0.035992227494716644, 0.02769785374403, 0.0868639424443245, -0.1096111387014389,
    0.2772824466228485, 0.000840403838083148, -0.14868149161338806, -0.05576585233211517, 0.05837680771946907, 0.17917175590991974, 0.11350779235363007, 0.12180230766534805,
    0.07156810164451599, 0.034951481968164444, 0.05391494184732437, 0.012413782998919487, -0.049616750329732895, 0.11564901471138, 0.016953743994235992, 0.13857081532478333,
    0.04313640296459198, -0.012220688164234161, 0.08910339325666428, -0.09663041681051254, -0.2296849489212036, 0.11551187932491302, 0.11136814951896667, 0.05201266333460808,
    -0.0006335548823699355, -0.05526364967226982, -0.07774227112531662, -0.1440315693616867, -0.002193499356508255, 0.0404205359518528, 0.0902004987001419, 0.023685017600655556,
    -0.09245934337377548, 0.06490378081798553, 0.036750487983226776, 0.09044913947582245, 0.23289602994918823, 0.16809791326522827, -0.1666899174451828, -0.10256818681955338,
    0.15734533965587616, -0.07443712651729584, -0.008333396166563034, 0.10627387464046478, 0.14160466194152832, 0.060331959277391434, -0.231917142868042, 0.12618009746074677,
    0.06807880103588104, 0.10085493326187134, 0.11588110774755478, -0.04052114114165306, 0.14074285328388214, 0.14711129665374756, -0.014028651639819145, -0.043312568217515945,
    -0.0013053533621132374, 0.13839395344257355, -0.09137272834777832, -0.0714053064584732, -0.007977381348609924, 0.14857140183448792, -0.08729927986860275, -0.2537648677825928,
    -0.03786596655845642, 0.05650738626718521, 0.14528930187225342, 0.0006940248422324657, 0.10438138991594315, -0.19961144030094147, 0.12456082552671432, -0.12165027856826782,
    -0.08881089836359024, -0.059478193521499634, 0.022505685687065125, -0.20153024792671204, 0.10045839101076126, 0.005799282807856798, -0.22741492092609406, 0.20984140038490295,
    -0.2487681806087494, -0.21183989942073822, 0.006592283491045237, -0.058560073375701904, -0.16622906923294067, 0.037575092166662216, -0.002144337398931384, 0.003508713562041521,
    -0.051675401628017426, -0.0671611875295639, -0.3671656548976898, -0.006848817225545645, 0.20248664915561676, 0.19777041673660278, -0.025955162942409515, 0.14306969940662384,
    -0.2813338339328766, -0.050588253885507584, -0.04359125345945358, 0.0003732833720277995, 0.2522926926612854, 0.07669687271118164, -0.1637706607580185, -0.11545572429895401,
    -0.0713576227426529, 0.09229601919651031, -0.13539664447307587, 0.10687080770730972, 0.020392652601003647, -0.022198358550667763, 0.10218563675880432, -0.08573590219020844,
    0.07552682608366013, 0.03082531876862049, -0.06405781954526901, -0.08900287002325058, -0.12036322802305222, 0.043832242488861084, -0.17617547512054443, 0.18221840262413025,
    0.00321762403473258, -0.1813996434211731, -0.016145488247275352, 0.10036708414554596, 0.095225490629673, 0.02065926231443882, -0.05609023943543434, -0.02766461856663227,
    0.15657268464565277, -0.04852142184972763, 0.07784255594015121, 0.03289957344532013, -0.1120598092675209, -0.11187903583049774, 0.08145302534103394, -0.045165833085775375,
    -0.179336279630661, -0.04161980748176575, 0.05848534777760506, -0.0048824199475348, -0.11419886350631714, 0.003182950196787715, -0.0578564777970314, -0.062209613621234894,
    0.05842579901218414, -0.008055353537201881, -0.15937165915966034, 0.07580287009477615, 0.06371557712554932, -0.013943054713308811, -0.043592747300863266, 0.21825796365737915,
    0.06964804977178574, -0.15940698981285095, -0.06922966241836548, 0.11136043071746826, -0.0034487927332520485, 0.014153547585010529, -0.1649283468723297, -0.17589125037193298,
    0.12401671707630157, -0.0589928962290287, -0.046570878475904465, -0.04600517824292183, -0.1087024062871933, -0.005830307956784964, -0.003283014288172126, -0.16351410746574402,
    -0.03059091977775097, -0.03153487667441368, -0.12089572101831436, 0.10798869282007217, 0.03970860689878464, -0.018153708428144455, 0.014807128347456455, -0.11607237160205841,
    0.18152520060539246, -0.07913641631603241, -0.06248011067509651, 0.1320229172706604, -0.09490372240543365, 0.31893330812454224, 0.019684722647070885, 0.13334496319293976,
    0.024127740412950516, 0.06569512188434601, -0.04498883709311485, -0.033752650022506714, 0.09810502827167511, -0.07735826075077057, 0.059262022376060486, -0.05693602189421654,
    -0.007592872250825167, -0.1641622632741928, 0.025677811354398727, 0.05250265821814537, -0.13233761489391327, -0.21992474794387817, 0.11553533375263214, 0.0081730205565691,
    -0.06006389111280441, 0.03893422335386276, -0.01795702613890171, -0.09946153312921524, -0.12410618364810944, 0.07772065699100494, 0.000301063439110294, 0.06990902870893478,
    -0.08819598704576492, 0.15097641944885254, -0.03817466273903847, 0.003975164145231247, 0.09039627760648727, -0.015807809308171272, 0.24794220924377441, -0.045067064464092255,
    0.020463569089770317, -0.01543488074094057, -0.022020243108272552, -0.15715213119983673, -0.02221498265862465, -0.13311776518821716, 0.053003326058387756, 0.01002219133079052,
    -0.1797325313091278, 0.04420933127403259, -0.14631584286689758, 0.0019174542976543307, 0.13096268475055695, 0.08064982295036316, -0.07288466393947601, 0.10691086202859879,
    -0.009827838279306889, 0.147090882062912, -0.04896940290927887, 0.0016185540007427335, -0.11901500821113586, 0.15327881276607513, -0.19316188991069794, 0.15375253558158875,
    -0.11850299686193466, -0.05899612605571747, 0.0385771170258522, 0.025019507855176926, -0.13985230028629303, 0.08963961154222488, -0.1658797413110733, 0.08440244197845459,
    0.0021202806383371353, -0.25031065940856934, 0.04598171263933182, -0.1737276315689087, 0.3162238597869873, -0.04383349418640137, 0.11423235386610031, 0.21992214024066925,
    -0.13513556122779846, -0.02883121557533741, 0.02834300696849823, 0.01474603172391653, 0.10710804164409637, -0.08354475349187851, 0.03154364228248596, 0.03478275239467621,
    0.1532750278711319, -0.012779614888131618, -0.06740154325962067, 0.0046169995330274105, 0.1187925785779953, -0.041456758975982666, -0.0026807361282408237, -0.01756029576063156,
    0.13906000554561615, -0.033846206963062286, -0.09907101094722748, -0.09494072943925858, 0.41159722208976746, -0.0706527903676033, -0.028102438896894455, 0.10616004467010498,
    0.032326940447092056, -0.2100730985403061, -0.07274101674556732, 0.1992005705833435, 0.015026411972939968, -0.009947728365659714, 0.04571110010147095, -0.3164075016975403,
    0.023819798603653908, -0.2965392470359802, -0.05734311789274216, 0.34577304124832153, 0.30086860060691833, -0.08859830349683762, -0.03953945264220238, 0.18395429849624634,
    0.13588562607765198, -0.009407871402800083, 0.042973972856998444, -0.057238344103097916, 0.15571396052837372, 0.024051230400800705, -0.022921763360500336, -0.14687278866767883,
    -0.016096821054816246, 0.07565298676490784, -0.08988424390554428, 0.08763999491930008, 0.039455678313970566, -0.0495818667113781, 0.0018519432051107287, 0.02782549150288105,
    0.02826591394841671, -0.1825297474861145, 0.0006642949883826077, 0.31321874260902405, 0.003758601611480117, -0.10454990714788437, 0.005650095641613007, -0.02569151297211647,
    0.2654789090156555, -0.006507955491542816, 0.016845103353261948, -0.1574832648038864, -0.21465978026390076, -0.014223096892237663, 0.02202564850449562, 0.003936451394110918,
    0.23812010884284973, -0.0063635907135903835, -0.09822577983140945, 0.061776865273714066, 0.03935960680246353, 0.11497978866100311, 0.09625078737735748, 0.013156683184206486,
    -0.05493513494729996, -0.11147518455982208, -0.17237485945224762, -0.12851302325725555, 0.2775861620903015, 0.02446078695356846, 0.19214558601379395, 0.007244452368468046,
    0.0078163743019104, 0.03791157528758049, 0.20861925184726715, -0.20425771176815033, -0.06825345009565353, 0.048915546387434006, 0.09049790352582932, 0.042925991117954254,
    0.024973340332508087, 0.026740681380033493, 0.15833555161952972, -0.004804559517651796, 0.22335588932037354, -0.13749313354492188, -0.01117553561925888, 0.038296300917863846,
    0.10342837125062943, -0.22814609110355377, 0.09702746570110321, 0.0019172303145751357, 0.02947046607732773, -0.09183409065008163, -0.036775555461645126, -0.031778402626514435,
    -0.07185689359903336, 0.03984764590859413, -0.007742443587630987, 0.0014910927275195718, -0.16531851887702942, 0.051752910017967224, 0.119051493704319, -0.32269585132598877,
    0.05057326704263687, -0.015833474695682526, 0.024464266374707222, -0.012226623483002186, 0.20056462287902832, 0.02961205691099167, -0.00037793637602590024, -0.2034389227628708,
    -0.1302073746919632, 0.03950953856110573, -0.14580850303173065, 0.04779980704188347, 0.0812852680683136, 0.23250135779380798, -0.12458523362874985, -0.019715838134288788,
    0.05811084061861038, 0.017428794875741005, -0.06443377584218979, -0.10871178656816483, 0.07169017195701599, -0.04367946833372116, -0.07768607884645462, 0.00906346831470728,
    0.08639492839574814, -0.023465801030397415, 0.1501179039478302, 0.0985136479139328, -0.04248577356338501, -0.07339271157979965, 0.008104579523205757, 0.25467169284820557,
    0.06585923582315445, 0.06282518059015274, -0.038506101816892624, -0.14618730545043945, 0.030436186119914055, -0.04545319080352783, 0.15457484126091003, 0.13643376529216766,
    -0.03230513632297516, 0.009453280828893185, -0.10663100332021713, 0.08126622438430786, -0.026535995304584503, -0.15432116389274597, -0.19155125319957733, -0.17631007730960846,
    0.10700952261686325, 0.022967057302594185, 0.16637538373470306, -0.15607179701328278, 0.033706795424222946, -0.060145359486341476, 0.1831378936767578, 0.06694235652685165,
    0.20602037012577057, -0.1104506328701973, 0.11991243809461594, 0.13966423273086548, -0.03256605938076973, -0.1040613204240799, 0.11986061185598373, 0.03914618492126465,
    0.09459521621465683, -0.18553759157657623, -0.1465412974357605, 0.04466480389237404, -0.012145022861659527, 0.1711185723543167, 0.06304283440113068, -0.3331708014011383,
    0.2793003022670746, 0.07598072290420532, -0.15164834260940552, 0.04619769752025604, 0.052826520055532455, 0.2569926977157593, 0.09155497699975967, 0.05242212489247322,
    -0.14644616842269897, -0.008463281206786633, -0.1162772998213768, 0.10513859242200851, 0.06845460832118988, -0.07523881644010544, -0.2200964391231537, -0.07200110703706741,
    0.09178666770458221, 0.08281248062849045, 0.13057643175125122, -0.002017044695094228, -0.05960748717188835, -0.04793236032128334, 0.22185707092285156, 0.014315102249383926,
    -0.02241518907248974, -0.202499121427536, 0.08722828328609467, -0.03545168787240982, -0.018181726336479187, 0.13427582383155823, -0.164919912815094, 0.2896880507469177,
    -0.028605451807379723, -0.036824408918619156, -0.1931188851594925, -0.01810339279472828, 0.1856326311826706, 0.1339992880821228, -0.11215542256832123, -0.1344955563545227,
    -0.04515194147825241, -0.28832852840423584, 0.18851900100708008, 0.04028572142124176, 0.09233374893665314, 0.010836407542228699, -0.036869607865810394, 0.02490200474858284,
    0.010734344832599163, 0.020085332915186882, -0.00890490785241127, -0.2611832916736603, -0.006223461590707302, 0.16624759137630463, 0.12388095259666443, 0.14921903610229492,
    -0.09347550570964813, -0.1718948781490326, 0.05187790095806122, 0.041870951652526855, 0.015506147406995296, -0.03494415432214737, 0.010014044120907784, -0.13758555054664612,
    -0.04230286553502083, 0.08803567290306091, 0.2523612678050995, -0.00346840126439929, -0.11887609213590622, -0.2168639451265335, -0.03132719546556473, -0.046490296721458435,
    -0.1157616600394249, -0.0011434481712058187, 0.00391819141805172, -0.25805118680000305, -0.2071101814508438, -0.21812868118286133, -0.04268509894609451, -0.07672515511512756,
    -0.022767435759305954, -0.016103502362966537, 0.01355823501944542, -0.07412636280059814, -0.15708959102630615, 0.07631865888834, -0.12252088636159897, -0.01282036304473877,
    -0.017592933028936386, 0.04886298254132271, 0.06565915793180466, -0.18786117434501648, -0.1443157196044922, 0.03586303070187569, 0.08884097635746002, 0.029816338792443275,
    -0.05810990184545517, 0.09621192514896393, -0.02083892561495304, -0.10166982561349869, -0.13616451621055603, 0.27223730087280273, 0.17494502663612366, -0.2296435683965683,
    -0.07358770072460175, -0.15497104823589325, -0.01710919663310051, -0.1732175052165985, -0.11216989159584045, -0.08158624917268753, -0.11409324407577515, -0.055442262440919876,
    -0.05243130773305893, 0.09294161200523376, -0.056915026158094406, -0.05322381108999252, -0.11337024718523026, -0.08095655590295792, 0.04612850397825241, -0.09825560450553894,
    -0.06350445747375488, -0.0365840345621109, -0.3758324086666107, 0.0333530530333519, -0.07929898798465729, -0.13478456437587738, 0.32538214325904846, 0.0832415521144867,
    0.2936246395111084, 0.057092372328042984, 0.26229003071784973, -0.1365043967962265, 0.00782043021172285, -0.25762081146240234, 0.1532914787530899, 0.09389760345220566,
    -0.10810524225234985, -0.16252301633358002, -0.13301190733909607, 0.29013529419898987, 0.014665820635855198, 0.04913162440061569, 0.08222095668315887, 0.17107340693473816,
    0.13272911310195923, -0.05147214233875275, -0.14363111555576324, -0.08856075257062912, -0.14574724435806274, 0.026007631793618202, 0.14153939485549927, 0.0003588411200325936,
    0.1012917086482048, -0.11007092893123627, -0.33131667971611023, 0.019742781296372414, -0.31235796213150024, -0.21609583497047424, -0.02611975558102131, -0.0018419589614495635,
    0.039239924401044846, 0.06167225539684296, -0.17036043107509613, 0.00782318040728569, 0.0719556212425232, -0.05576201155781746, -0.06065547838807106, 0.18695294857025146,
    0.02200719527900219, 0.04327841103076935, 0.26636064052581787, 0.0664794072508812, 0.011296289972960949, 0.03450421616435051, 0.22501879930496216, 0.05604230985045433,
    -0.009480639360845089, -0.2118455171585083, 0.015780095010995865, 0.06996608525514603, -0.017238035798072815, 0.04926376789808273, -0.17730450630187988, 0.027912508696317673,
    0.1929771602153778, 0.11857879906892776, -0.043319929391145706, -0.2740003764629364, -0.006451878696680069, -0.15813924372196198, 0.0463806614279747, 0.3024725317955017,
    0.08233026415109634, -0.13987067341804504, -0.10085736960172653, 0.048115648329257965, 0.042927492409944534, 0.10520947724580765, 0.04916528984904289, -0.14552350342273712,
    0.032685115933418274, -0.016265129670500755, 0.09884288161993027, 0.11038356274366379, -0.16434666514396667, 0.04200458154082298, 0.04107321798801422, -0.14696058630943298,
    0.09948010742664337, -0.029663462191820145, 0.035655129700899124, 0.02204260788857937, -0.15811991691589355, -0.051281191408634186, -0.20487192273139954, -0.0854458436369896,
    -0.042492929846048355, -0.027009930461645126, 0.05691005662083626, -0.02134189009666443, -0.06677182763814926, -0.04501110315322876, -0.05758979916572571, 0.02034427598118782,
    -0.06461770087480545, -0.08936386555433273, 0.07643723487854004, -0.05336346849799156, -0.0402514711022377, -0.06274454295635223, -0.08004667609930038, -0.013317358680069447,
    0.027550917118787766, -0.09527350962162018, 0.023122558370232582, -0.07610411942005157, 0.04707318916916847, 0.2184317409992218, -0.0017252921825274825, -0.14054174721240997,
    -0.026126176118850708, -0.028039226308465004, -0.022878373041749, 0.07750701159238815, 0.0054982197470963, -0.04968957230448723, 0.09497670829296112, -0.05467574670910835,
    -0.08172691613435745, 0.022349581122398376, -0.06618635356426239, -0.14292123913764954, 0.13356761634349823, 0.01989135704934597, -0.00914799328893423, -0.07528258860111237,
    0.023937664926052094, -0.032194606959819794, -0.033641621470451355, 0.058885570615530014, -0.07976846396923065, -0.021808037534356117, 0.06408736109733582, -0.0264561977237463,
    0.10903917253017426, -0.0332089439034462, 0.0072873858734965324, 0.048645660281181335, 0.13723808526992798, 0.055108390748500824, 0.0812382623553276, 0.06013717129826546,
    -0.10591249167919159, 0.01723676174879074, 0.036942869424819946, 0.05306652560830116, 0.08370769023895264, -0.03462664783000946, 0.06479324400424957, 0.053036630153656006,
    -0.023599250242114067, 0.028846902772784233, -0.031054608523845673, -0.01758134365081787, 0.05121994391083717, 0.051680028438568115, 0.039368048310279846, 0.043456509709358215,
    0.1622467190027237, -0.026742618530988693, 0.10120031237602234, -0.07574351876974106, -0.11270245164632797, 0.09719878435134888, 0.0856577679514885, 0.051385439932346344,
    -0.02974342182278633, 0.05563868209719658, 0.010838394053280354, 0.09823789447546005, 0.10858450829982758, -9.563097410136834e-05, -0.05513196438550949, -0.005874914582818747,
    0.11442068219184875, 0.05794887989759445, -0.00564403785392642, -0.0853632390499115, 0.11411067098379135, 0.16028174757957458, 0.03988545015454292, 0.06440578401088715,
    -0.02964671142399311, -0.010643616318702698, -0.07474225014448166, -0.08896701782941818, -0.0037196094635874033, -0.08729575574398041, 0.07437701523303986, 0.013743080198764801,
    0.14254938066005707, 0.019742144271731377, 0.016140608116984367, -0.01211868692189455, -0.12312476336956024, -0.00645358394831419, 0.040904734283685684, -0.012341929599642754,
    -0.12212789058685303, 0.013111290521919727, 0.03789573907852173, -0.03481733798980713, -0.017978040501475334, 0.11478088796138763, 0.08560390025377274, -0.0685945451259613,
    -0.04465143755078316, -0.10807360708713531, 0.08821563422679901, 0.05406299978494644, 0.0316748209297657, -0.04151398316025734, 0.03156781569123268, 0.038425009697675705,
    0.012597254477441311, -0.053868550807237625, 0.09066295623779297, -0.008828407153487206, -0.008942092768847942, -0.010268923826515675, -0.0160088948905468, -0.0063332258723676205,
    0.06701679527759552, -0.04897405207157135, 0.044489067047834396, -0.026332838460803032, -0.03354697674512863, 0.03233344852924347, -0.07787463814020157, 0.057725075632333755,
    0.13310764729976654, -0.10625758022069931, 0.043742671608924866, 0.012434262782335281, -0.03226419538259506, 0.20414592325687408, -0.009182807989418507, -0.06592430174350739,
    -0.044456854462623596, 0.03414209187030792, 0.010422560386359692, -0.021719051524996758, -0.08586737513542175, 0.0780172348022461, -0.03198893368244171, -0.004660972394049168,
    -0.047362517565488815, 0.020011933520436287, -0.05938712880015373, -0.014131695963442326, 0.24605129659175873, -0.015584948472678661, 0.09389807283878326, -0.12012217938899994,
    -0.08711046725511551, -0.004777685273438692, -0.0408475361764431, -0.0377739816904068, -0.05597167834639549, 0.007170486263930798, 0.09570873528718948, -0.04306831955909729,
    0.051799360662698746, 0.11323495954275131, -0.04150645434856415, 0.0066842869855463505, -0.030498551204800606, -0.029276488348841667, -0.04523390159010887, 0.012493406422436237,
    -0.04380723088979721, -0.003933367785066366, -0.05917713791131973, 0.08724364638328552, 0.05882923677563667, -0.03125224635004997, 0.04418984428048134, 0.007356909569352865,
    0.05370493233203888, -0.026551207527518272, -0.031311627477407455, -0.021849067881703377, -0.004344326909631491, -0.14520449936389923, 0.10287546366453171, 0.07917497307062149,
    0.04252832755446434, 0.05432026460766792, 0.07344168424606323, -0.1073085367679596, -0.11376368999481201, -0.05357741937041283, 0.09597063809633255, -0.10889238864183426,
    0.020721929147839546, -0.02877291664481163, 0.014129828661680222, 0.13840243220329285, 0.07981473207473755, 0.010279080830514431, 0.024399928748607635, 0.03202676773071289,
    -0.029339827597141266, -0.06310003250837326, -0.03173530474305153, 0.11995039135217667, -0.020571695640683174, 0.1801890730857849, -0.0050727687776088715, 0.037379615008831024,
    -0.014161818660795689, 0.013127154670655727, -0.12321031093597412, 0.09104392677545547, -0.14827460050582886, -0.015040485188364983, -0.019667044281959534, 0.0652143806219101,
    0.052406828850507736, -0.07270593196153641, -0.06788458675146103, -0.01966933347284794, 0.03515702858567238, 0.0044976407662034035, -0.025645744055509567, -0.0055900318548083305,
    -0.18188819289207458, 0.023107120767235756, 0.06654256582260132, -0.04816386103630066, -0.03346851468086243, -0.0718052089214325, 0.011430722661316395, 0.038420360535383224,
    -0.027820108458399773, -0.18085631728172302, -0.08361034095287323, -0.03017943538725376, -0.0731305405497551, 0.05690634623169899, -0.09672312438488007, 0.037272147834300995,
    0.04288310930132866, -0.01423684787005186, -0.02655266597867012, -0.001339266076683998, -0.020380323752760887, 0.0009586801170371473, 0.006007814779877663, -0.06947707384824753,
    -0.020216355100274086, 0.05627642571926117, 0.08570346981287003, 0.15105567872524261, -0.006633784621953964, 0.03857404366135597, 0.051344290375709534, 0.048876259475946426,
    0.11136914789676666, 0.019693544134497643, 0.06363408267498016, 0.07328898459672928, -0.09752976149320602, -0.12957464158535004, 0.011726418510079384, 0.11019735783338547,
    0.006906038615852594, 0.01991356909275055, 0.010554134845733643, -0.07778827100992203, -0.09656868875026703, -0.014883395284414291, -0.022350359708070755, 0.009824265725910664,
    0.009691390208899975, -0.008168178610503674, -0.0028226140420883894, 0.11020618677139282, 0.28363466262817383, -0.004521925467997789, 0.06363538652658463, -0.0550013892352581,
    -0.1771666705608368, 0.06475042551755905, 0.11183451861143112, -0.07839381694793701, -0.0598309151828289, 0.08235719054937363, -0.03401394933462143, -0.0912710577249527,
    0.019189033657312393, 0.09113775193691254, 0.004683357663452625, 0.033070504665374756, -0.08880259096622467, 0.0394911989569664, -0.19844862818717957, 0.02929878979921341,
    0.013631126843392849, -0.011765622533857822, -0.0194239504635334, 0.027731794863939285, -0.05600905790925026, 0.01315347757190466, 0.008009383454918861, -0.003049168037250638,
    0.03256835788488388, -0.026339750736951828, 0.0833820104598999, 0.11542629450559616, -0.0720849260687828, -0.09353034943342209, 0.08257894963026047, -0.0009210454882122576,
    -0.0262510497123003, -0.00934678316116333, -0.05059538409113884, 0.022057531401515007, -0.09360329061746597, -0.035817548632621765, -0.022352121770381927, 0.004150543827563524,
    -0.007237855810672045, -0.04629114270210266, 0.016923554241657257, 0.0510355643928051, -0.06053110212087631, 0.019722705706954002, 0.11219669133424759, -0.06672096997499466,
    0.0033870458137243986, -0.02615021914243698, 0.02144116535782814, -0.04121631383895874, 0.06794825196266174, 0.03740309923887253, -0.038061682134866714, -0.02248513139784336,
    -0.04387501999735832, -0.08063637465238571, -0.0470365434885025, 0.06974998116493225, -0.0007778754225000739, 0.008433633483946323, -0.02759193815290928, 0.0012525912607088685,
    -0.07091870903968811, -0.0026319518219679594, 0.03657917305827141, -0.022958198562264442, 0.12120623141527176, -0.02609383873641491, -0.03233924135565758, -0.012018479406833649,
    -0.07708900421857834, 0.029021624475717545, 0.04095252975821495, -0.0157186109572649, 0.06615947932004929, -0.01209100428968668, 0.039860695600509644, 0.0659632757306099,
    0.02285807393491268, -0.1342947632074356, 0.024993153288960457, 0.00676549319177866, 0.06521131098270416, 0.00036685686791315675, -0.14686870574951172, -0.07441685348749161,
    -0.06004208326339722, -0.08614514768123627, -0.012341718189418316, -0.1803523749113083, 0.05966326221823692, 0.0019255357328802347, -0.09581801295280457, 0.012676266953349113,
    -0.018643440678715706, 0.07380497455596924, -0.005786025896668434, 0.06659350544214249, 0.040978725999593735, 0.10613434761762619, -0.03370396047830582, -0.02627677470445633,
    0.013567961752414703, -0.03578891232609749, 0.09496728330850601, -0.07534103095531464, -0.0042755273170769215, -0.2825841009616852, 0.04186487942934036, 0.016751045361161232,
    -0.036735616624355316, -0.024733755737543106, 0.02108016423881054, 0.06904391944408417, -0.05620012804865837, -0.05595920979976654, 0.01848779432475567, 0.06327231228351593,
    0.021390540525317192, -0.012920837849378586, 0.041311681270599365, -0.014316544868052006, 0.1190159022808075, 0.03224705159664154, 0.0325382798910141, -0.01056842040270567,
    -0.07806754857301712, -0.004375559277832508, 0.031016655266284943, 0.05494232103228569, -0.05801950767636299, -0.047019001096487045, -0.04655683785676956, 0.04598796367645264,
    -0.019396429881453514, -0.0819585993885994, 0.08312561362981796, -0.03038616105914116, 0.07332950085401535, 0.002542119240388274, -0.041444145143032074, 0.019126009196043015,
    -0.08468836545944214, 0.016623398289084435, 0.02845221571624279, -0.07619632035493851, -0.028107762336730957, -0.004240031819790602, -0.02149978093802929, 0.013351714238524437,
    -0.02659005858004093, 0.02996755950152874, 0.04336776211857796, -0.06964724510908127, -0.023973755538463593, 0.12516194581985474, 0.08462866395711899, 0.010186308063566685,
    0.11444726586341858, -0.03012775257229805, -0.03288362920284271, -0.02711619809269905, -0.12641757726669312, 0.08481641113758087, 0.02656383626163006, 0.1581711769104004,
    0.014735925942659378, 0.017968395724892616, -0.04129751771688461, 0.043762046843767166, 0.006606772541999817, -0.02206149324774742, -0.016581593081355095, -0.09217286854982376,
    0.134947270154953, 0.052669327706098557, -0.009240240789949894, -0.04829017072916031, -0.00024189222312998027, 0.025809021666646004, -0.004414531867951155, -0.07876064628362656,
    -0.017599619925022125, -0.0008506448939442635, 0.008126409724354744, -0.06555479019880295, 0.10983192175626755, 0.027074450626969337, 0.01748279668390751, -0.004326019901782274,
    -0.03782324492931366, 0.01879139617085457, 0.03358681499958038, 0.0367283932864666, 0.01831998862326145, 0.03898123279213905, -0.0248922947794199, -0.12427442520856857,
    -0.021855635568499565, 0.0002808737335726619, 0.0124875633046031, -0.06072866916656494, -0.0868481993675232, 0.09430015087127686, -0.018218258395791054, -0.04577965289354324,
    -0.06051349267363548, -0.08382610231637955, 0.180060014128685, 0.011481101624667645, 0.09473243355751038, -0.058936815708875656, -0.009348385967314243, -0.01261079590767622,
    -0.0438176691532135, 0.009615999646484852, 0.06816829741001129, -0.10011644661426544, 0.09728098660707474, 0.00873685535043478, -0.0008198745781555772, 0.07801131904125214,
    0.09214582294225693, -0.08004944026470184, -0.01886570267379284, -0.13107559084892273, 0.09801902621984482, -0.05978986993432045, -0.012582063674926758, -0.018725305795669556,
    0.003573989262804389, -0.04190327227115631, -0.11215102672576904, -0.07864397019147873, -0.05664999410510063, -0.288251668214798, 0.12471169233322144, -0.028160596266388893,
    0.04541478678584099, 0.05688285082578659, -0.007827690802514553, 0.11271384358406067, -0.05494346469640732, 0.07027164101600647, -0.0043450952507555485, 0.025935569778084755,
    0.02765703573822975, 0.028831643983721733, -0.060202401131391525, 0.07957076281309128, 0.11266458034515381, -0.019185619428753853, 0.011999252252280712, -0.006804177537560463,
    -0.02390454150736332, -0.09091392904520035, 0.028296062722802162, 0.027601340785622597, -0.04830140992999077, -0.08484753966331482, -0.06832586973905563, 0.0268601905554533,
    -0.017235521227121353, 0.06416679918766022, -0.0918402224779129, -0.12885263562202454, 0.03073236159980297, -0.05979776009917259, 0.12867048382759094, -0.022582996636629105,
    -0.04890000447630882, -0.005492452532052994, -0.06084557995200157, 0.03936116024851799, 0.04791242629289627, 0.013851187191903591, -0.024154826998710632, -0.005568826105445623,
    0.018146030604839325, 0.002609709044918418, -0.11953062564134598, -0.052706196904182434, 0.0850076824426651, -0.03234555572271347, 0.07631319761276245, 0.01834079995751381,
    0.095930315554142, 0.03657885640859604, 0.017496351152658463, -0.023032039403915405, -0.07694338262081146, -0.06868346780538559, -0.018756594508886337, 0.01872600056231022,
    -0.027688059955835342, 0.04963547736406326, -0.00859264936298132, 0.03235391899943352, 0.19808268547058105, -0.0022816837299615145, 0.009638356976211071, -0.04461398348212242,
    0.10598337650299072, -0.024289781227707863, 0.014212597161531448, 0.1410938948392868, -0.021931516006588936, 0.05278240516781807, 0.034307848662137985, 0.07245627790689468,
    0.06528367102146149, 0.002478834008798003, 0.06321856379508972, 0.007260136306285858, -0.04351002350449562, -0.04380645230412483, 0.000839180895127356, 0.00018636630557011813,
    -0.025946099311113358, -0.0009208619594573975, -0.14270447194576263, 0.04480774700641632, -0.10303004086017609, -0.013704845681786537, 0.013145490549504757, -0.025382261723279953,
    -0.03181541711091995, 0.01877102255821228, 0.06749620288610458, -0.10761318355798721, -0.14688260853290558, -0.08727628737688065, -0.040600962936878204, -0.07565450668334961,
    0.03400746360421181, -0.021693352609872818, -0.008172341622412205, 0.005722768604755402, -0.032346196472644806, 0.037973806262016296, 0.12148619443178177, 0.06003640592098236,
    0.028130773454904556, -0.02175399661064148, -0.08278415352106094, -0.07060758769512177, 0.001303786295466125, -0.01700752228498459, 0.23938004672527313, 0.14090369641780853,
    -0.07057396322488785, -0.02696343883872032, 0.010603709146380424, -0.038398489356040955, -0.06052350997924805, 0.04020944982767105, 0.13104411959648132, 0.049489930272102356,
    0.06496242433786392, -0.005615097936242819, -0.1663321703672409, -0.0607975497841835, 0.0013039649929851294, -0.11157895624637604, 0.04443984478712082, 0.017831405624747276,
    0.025871286168694496, -0.027140706777572632, 0.021253863349556923, 0.016541412100195885, -0.06613507121801376, 0.008961551822721958, -0.045517850667238235, 0.08595849573612213,
    -0.046878863126039505, -0.03741419315338135, -0.0406564399600029, 0.03580378741025925, 0.08250228315591812, 0.0015208147233352065, -0.04079112783074379, 0.02805340103805065,
    -0.027688032016158104, 0.06051642447710037, 0.05310864746570587, -0.01429715845733881, -0.03665735945105553, 0.02141926810145378, -0.14426949620246887, -0.01137732807546854,
    0.059371691197156906, -0.02197224460542202, -0.05070449411869049, -0.017368946224451065, 0.04096669703722, 0.10525640845298767, -0.04225626587867737, 0.013238427229225636,
    0.022163812071084976, 0.00216983282007277, -0.008468679152429104, -0.005041417200118303, 0.07661122828722, 0.022564535960555077, -0.003595568472519517, -0.007324230391532183,
    0.020168012008070946, -0.07972046732902527, -0.046572696417570114, 0.04429873079061508, -0.02716394141316414, -0.13564369082450867, 0.06990881264209747, -0.016685204580426216,
    -0.05653657391667366, -0.05912790074944496, 0.027592068538069725, -0.03969735652208328, -0.06636959314346313, 0.03363115340471268, 0.004634063690900803, -0.07066063582897186,
    0.01375681534409523, 0.0025416123680770397, 0.02551085501909256, -0.01205118466168642, 0.06392022967338562, 0.008299368433654308, -0.05304792895913124, -0.01596883311867714,
    -0.11860606074333191, -0.04644589126110077, 0.0026115085929632187, -0.062065232545137405, -0.044538140296936035, 0.01309262216091156, -0.06274331361055374, 0.03195461630821228,
    -0.05053338035941124, -0.06897985935211182, 0.008722428232431412, 0.05451349541544914, -0.13549987971782684, 0.05005604773759842, 0.03198637813329697, -0.05726373940706253,
    0.00848888698965311, 0.011515769176185131, 0.0714598298072815, 0.009397683665156364, -0.05480240285396576, -0.01808677241206169, -0.05459639057517052, 0.007990940473973751,
    0.020825257524847984, -0.026868917047977448, 0.007391311228275299, 0.0002995711693074554, 0.03186611086130142, -0.01909848488867283, -0.018686482682824135, -0.0858951061964035,
    0.06461060047149658, -0.01622334122657776, 0.001524115912616253, -0.003937387373298407, 0.029580133035779, 0.018928227946162224, 0.15917862951755524, 0.07116403430700302,
    0.025889281183481216, -0.01191408559679985, 0.009218903258442879, -0.17383866012096405, 0.10816962271928787, 0.010096528567373753, 0.09118259698152542, -0.07438398152589798,
    0.01597665436565876, 0.029712604358792305, 0.049143869429826736, 0.012917243875563145, -0.07160743325948715, 0.01371825486421585, 0.06240127235651016, -0.013979808427393436,
    -0.03302299603819847, 0.006478517781943083, 0.005806532688438892, 0.024687130004167557, -0.012629852630198002, 0.04025022312998772, -0.09011507034301758, 0.09783033281564713,
    -0.0520707406103611, -0.0059356605634093285, -0.010996369644999504, -0.0576321966946125, -0.023853790014982224, 0.1197480708360672, 0.09325450658798218, 0.059604767709970474,
    0.009917248971760273, -0.02449975535273552, -0.07169253379106522, 0.08141930401325226, -0.01863163523375988, 0.028070490807294846, -0.10520979762077332, 0.014018261805176735,
    0.014191219583153725, 0.06477668881416321, -0.09824145585298538, -0.040734272450208664, 0.027530670166015625, 0.101649709045887, 0.006265194620937109, -0.04594344273209572,
    0.11807916313409805, -0.026543419808149338, 0.020408742129802704, 0.1272735297679901, -0.10022234916687012, 0.044353872537612915, -0.07920731604099274, 0.031952738761901855,
    -0.12570323050022125, -0.007809844799339771, 0.10466758161783218, -0.061821673065423965, -0.04482469707727432, -0.028551682829856873, -0.05498509481549263, 0.02656882256269455,
    -0.023351188749074936, 0.010260660201311111, 0.20784741640090942, 0.016992587596178055, -0.06306222826242447, 0.043892595916986465, -0.012888717465102673, 0.0012488648062571883,
    0.06210225820541382, 0.022012215107679367, -0.030321892350912094, -0.0340537503361702, -0.06201118603348732, 0.03458728641271591, -0.04242708161473274, 0.05462876707315445,
    0.016251711174845695, -0.01295844092965126, 0.00270936475135386, -0.06345070153474808, -0.09481440484523773, 0.01612820290029049, 0.07715874910354614, 0.009667822159826756,
    0.10171761363744736, 0.07307944446802139, 0.0018627367680892348, -0.030600719153881073, -0.028019601479172707, -0.028511233627796173, -0.0009500857559032738, -0.03617524728178978,
    -0.058976203203201294, -0.04650770127773285, -0.04278652369976044, -0.03502305597066879, 0.0033293587621301413, 0.039775267243385315, 0.021326571702957153, -0.02028312161564827,
    0.047634709626436234, -0.002008887007832527, 0.023358048871159554, 0.01604820415377617, 0.08307037502527237, 0.022778015583753586, 0.01816253550350666, -0.01788652315735817,
    -0.11587169766426086, -0.0249144546687603, 0.03688881918787956, 0.018560802564024925, 0.07240841537714005, 0.1163165494799614, -0.04139105603098869, -0.05716013163328171,
    -0.019061340019106865, 0.08866021782159805, -0.03396059200167656, 0.008640067651867867, 0.046389512717723846, -0.15241174399852753, -0.05748415365815163, 0.04599017649888992,
    0.017553629353642464, -0.04036044329404831, 0.01716313324868679, 0.07237445563077927, 0.22400252521038055, -0.0008870700839906931, 0.0800955519080162, -0.03924356773495674,
    -0.016636695712804794, 0.02789490297436714, 0.03644206002354622, -0.039095982909202576, 0.11430304497480392, -0.053803179413080215, -0.034648794680833817, -0.17379264533519745,
    0.008522730320692062, 0.0043684374541044235, 0.09448791295289993, -0.1664673238992691, 0.058505378663539886, -0.07205387949943542, -0.01892649382352829, -0.029361087828874588,
    -0.06390336155891418, 0.021826855838298798, 0.005768324714154005, 0.015498021617531776, -0.1422537863254547, 0.05650617182254791, 0.027026141062378883, -0.0667303204536438,
    -0.09553297609090805, -0.05697786435484886, 0.0028291335329413414, 0.07557042688131332, -0.0034135873429477215, -0.013810224831104279, -0.014883864670991898, -0.0439341776072979,
    0.0030912458896636963, -0.07116559147834778, -0.03658461198210716, 0.09156019985675812, 0.027044856920838356, -0.03399088978767395, 0.012272851541638374, -0.03919566422700882,
    -0.056646678596735, 0.07306477427482605, -0.008171779103577137, -0.1290779858827591, -0.12104041874408722, -0.1140340194106102, 0.0047520301304757595, 0.03211471438407898,
    0.00963054969906807, 0.0032728747464716434, -0.048635028302669525, 0.12759625911712646, -0.09863457083702087, 0.020758770406246185, 0.0011624456383287907, -0.007773962337523699,
    0.042809244245290756, -0.062220241874456406, 0.11473650485277176, -0.037168558686971664, 0.03219790384173393, -0.008699890226125717, -0.033359888941049576, -0.02635219506919384,
    0.03199298679828644, 0.045903872698545456, -0.04205913096666336, 0.009941373951733112, -0.021837841719388962, -0.056325849145650864, -0.0009348164312541485, 0.05662811920046806,
    -0.02863609418272972, 0.09429997950792313, -0.05806349217891693, -0.09754155576229095, -0.10441743582487106, -0.02837885171175003, 0.022875702008605003, 0.06815258413553238,
    -0.040437016636133194, -0.04247330501675606, -0.021803511306643486, 0.06092369928956032, -0.04408983886241913, -0.009722243994474411, 0.05541764199733734, -0.03952616825699806,
    0.01908746547996998, 0.003540905425325036, 0.043544307351112366, -0.07137083262205124, -0.07456221431493759, -0.09101196378469467, -0.06508889049291611, 0.013488526456058025,
    0.018283037468791008, -0.0142024215310812, -0.11646271497011185, 0.026838932186365128, 0.07168471813201904, -0.012080465443432331, 0.009882141835987568, -0.009611641056835651,
    0.010240858420729637, 0.013161650858819485, -0.03838247433304787, 0.038323450833559036, 0.022355278953909874, -0.04664196819067001, -0.03813226521015167, -0.015516615472733974,
    0.062121499329805374, 0.16606386005878448, 0.004604407586157322, 0.001391937374137342, -0.03754063695669174, -0.059272993355989456, 0.0022532176226377487, -0.007609358057379723,
    0.013143339194357395, 0.08667697012424469, 0.033448342233896255, 0.0395049974322319, 0.020824290812015533, -0.004721998702734709, 0.023664895445108414, -0.0260650385171175,
    -0.008635769598186016, -0.00997195579111576, 0.0470464862883091, 0.053401488810777664, -0.07025802880525589, -0.06026758253574371, -0.09404478967189789, 0.02618372067809105,
    0.032709166407585144, -0.04942995309829712, 0.10708898305892944, -0.08349058777093887, -0.003999760840088129, -0.14622344076633453, -0.036922577768564224, -0.0689515471458435,
    0.05266641080379486, -0.004482395015656948, 0.07908126711845398, -0.0641014501452446, -5.461188834487984e-07, -0.08713206648826599, -0.00612266780808568, 0.06011037901043892,
    -0.06277520954608917, -0.03679211437702179, 0.07126662880182266, 0.0025143902748823166, -0.04099604859948158, 0.005390797276049852, 0.0720391720533371, 0.04637010022997856,
    -0.07166439294815063, 0.031424351036548615, 0.002515022875741124, 0.07911697030067444, 0.01202450506389141, -0.0303652286529541, 0.07689295709133148, -0.020195873454213142,
    0.009035808965563774, 0.017152614891529083, -0.0931885614991188, 0.02664269506931305, 0.09073758125305176, 0.009225202724337578, 0.09743104875087738, -0.024086054414510727,
    -0.03048783354461193, 0.0011614247923716903, -0.08571331948041916, -0.05438501387834549, -0.06148655712604523, -0.01528729498386383, 0.03440829738974571, -0.008446765132248402,
    -0.027599751949310303, 0.013830471783876419, -0.08962833881378174, 0.14401774108409882, 0.06206873431801796, -0.0827869400382042, 0.07504809647798538, -0.00018095318228006363,
    -0.04211962968111038, -0.10275097191333771, -0.04857083782553673, 0.0035577837843447924, -0.017083851620554924, 0.041749756783246994, -0.011055845767259598, -0.11890099197626114,
    -0.009525087662041187, 0.046209875494241714, -0.005116650834679604, -0.04292863979935646, 0.17403365671634674, 0.006116695236414671, 0.05957091227173805, -0.050417639315128326,
    -0.009799577295780182, -0.03594283387064934, 0.027406031265854836, -0.05087757855653763, -0.020826004445552826, 0.07578343152999878, 0.025250110775232315, -0.04299779236316681,
    -0.007279862649738789, -0.0028496901504695415, 0.005958808586001396, 0.03198888152837753, 0.019980547949671745, -0.05504590645432472, 0.03554650396108627, -0.054871466010808945,
    -0.045392684638500214, 0.03162715211510658, 0.056151919066905975, -0.0011526928283274174, -0.08717220276594162, -0.010881857946515083, -0.108758844435215, 0.012575355358421803,
    0.08367358148097992, -0.005984826013445854, 0.0030156096909195185, -0.006849444936960936, 0.06184862554073334, 0.037074845284223557, 0.01337622944265604, -0.036733828485012054,
    0.07108006626367569, 0.1512448787689209, 0.13191525638103485, -0.0016202032566070557, 0.05313638225197792, -0.06666433811187744, 0.11981215327978134, 0.10540957748889923,
    -0.016744790598750114, -0.04820765554904938, 0.023259731009602547, -0.08955615758895874, 0.009733772836625576, 0.02132297120988369, 0.0457967072725296, 0.0005392356542870402,
    0.058073244988918304, -0.04050903394818306, -0.012908048927783966, -0.0532756969332695, -0.08230281621217728, 0.09348205476999283, 0.047017015516757965, 0.03475503623485565,
    0.05313510820269585, 0.02285318449139595, -0.014971349388360977, -0.0059635573998093605, 0.04759826511144638, -0.0440126396715641, -0.0730653777718544, 0.05678604170680046,
    0.007721109315752983, -0.039464447647333145, -0.05228225514292717, -0.08603469282388687, 0.03234069049358368, 0.028006602078676224, -0.07977830618619919, -0.006429355125874281,
    0.07626023888587952, -0.06018552929162979, -0.005070546176284552, 0.04782496392726898, -0.04107741266489029, 0.00507014524191618, 0.03751025348901749, -0.08676143735647202,
    -0.08693618327379227, 0.04260511323809624, -0.030459119006991386, -0.11054212599992752, 0.0056760311126708984, 0.04327400028705597, 0.03148118034005165, 0.03255382925271988,
    -0.007786361966282129, -0.061838433146476746, 0.018590860068798065, 0.056807681918144226, -0.024808740243315697, 0.04753217101097107, 0.07603920996189117, 0.008055656217038631,
    -0.04950062185525894, -0.003903639269992709, 0.1571076661348343, 0.001836805255152285, 0.14438702166080475, -0.028893211856484413, 0.041817110031843185, 0.018395526334643364,
    -0.0028885863721370697, -0.029386775568127632, -0.030497487634420395, 0.1477409452199936, 0.05226363614201546, -0.012888461351394653, -0.005973839666694403, 0.0682075247168541,
    -0.1018182709813118, 0.08383166044950485, -0.026185479015111923, -0.08050184696912766, -0.026231417432427406, 0.02251269295811653, 0.0022335578687489033, 0.04144018515944481,
    0.060670722275972366, 0.021609965711832047, -0.022449519485235214, -0.056841012090444565, 0.12100036442279816, -0.0019410960376262665, -0.005805131513625383, 0.09228584915399551,
    -0.07314285635948181, 0.0780128464102745, -0.029179846867918968, 0.015051874332129955, -0.04756497964262962, 0.0969180166721344, -0.04554944112896919, 0.06489460915327072,
    0.021189812570810318, 0.10614000260829926, -0.009127792902290821, 0.004114666022360325, -0.020726248621940613, -0.002519940258935094, 0.07026561349630356, -0.0009421016438864172,
    0.010612178593873978, 0.016633912920951843, 0.018199462443590164, 0.04372809827327728, -0.04847930371761322, 0.03345856815576553, -0.10351365804672241, -0.14174914360046387,
    -0.09119020402431488, -0.03242144733667374, 0.06465920060873032, 0.026030298322439194, 0.0429668165743351, -0.010775375179946423, 0.01959727331995964, 0.0039647831581532955,
    -0.08510614186525345, 0.18778856098651886, 0.07986952364444733, 0.0030100687872618437, 0.03969801589846611, 0.02584615722298622, 0.03373429924249649, 0.02382498048245907,
    -0.00029633488156832755, 0.006402425467967987, 0.05512804910540581, -0.0032240990549325943, 0.08215738087892532, 0.03479991480708122, -0.04301157966256142, 0.048620302230119705,
    0.05159985274076462, -0.08260837942361832, -0.012431471608579159, -0.014507995918393135, -0.01903250813484192, -0.05639543756842613, 0.013104536570608616, 0.04308873414993286,
    -0.022314472123980522, 0.03508573770523071, -0.03388143330812454, -0.0005075383232906461, 0.041833411902189255, 0.2211926281452179, 0.07576366513967514, 0.1279773861169815,
    -0.07296232879161835, 0.02941047213971615, 0.01225257944315672, -0.051817528903484344, 0.0005145149189047515, -0.027761531993746758, 0.06721758842468262, -0.03854136914014816,
    0.08220374584197998, 0.09365715831518173, -0.05134109407663345, 0.18588094413280487, -0.04313117638230324, -0.003965437412261963, -0.013225690461695194, -0.06170782819390297,
    0.04494243115186691, -0.04645712673664093, -0.011264179833233356, -0.12233159691095352, -0.03804996982216835, -0.07244602590799332, -0.026342744007706642, -0.01416159886866808,
    0.013563426211476326, -0.004285695496946573, 0.014715778641402721, -0.020778227597475052, -0.04190114885568619, -0.050627920776605606, -0.07503468543291092, -0.05000333860516548,
    -0.057927533984184265, 0.0006099739111959934, 0.008476343005895615, 0.013881697319447994, 0.006076488643884659, -0.04726330190896988, -0.016135714948177338, 0.03679873049259186,
    -0.05092047527432442, 0.0004242188879288733, 0.0875309631228447, 0.11502876877784729, 0.10648474842309952, 0.08889368176460266, -0.0801098570227623, 0.013650615699589252,
    0.06772498041391373, 0.012601802125573158, -0.04399864375591278, -0.013280834071338177, 0.03856305778026581, -0.05157020315527916, -0.04598038271069527, 0.10394423454999924,
    -0.03292185813188553, 0.03278781846165657, 0.011785347014665604, -0.06458522379398346, -0.09950094670057297, -0.008076109923422337, 0.0027558926958590746, 0.09192139655351639,
    -0.010131868533790112, 0.02312571369111538, 0.014898808673024178, 0.029456956312060356, 0.10240844637155533, 0.031824175268411636, -0.007797970436513424, 0.06047976762056351,
    0.0013308103661984205, -0.022783301770687103, 0.016735538840293884, -0.04594588279724121, -0.03688984364271164, -0.017630215734243393, 0.06610266119241714, -0.0035450870636850595,
    0.010181531310081482, 0.005711663514375687, -0.03159952536225319, -0.02191871777176857, 0.040720950812101364, -0.033206816762685776, -0.03600199520587921, 0.0290896724909544,
    -0.13863830268383026, -0.01533080730587244, 0.01721111498773098, 0.03160371631383896, 0.04170885682106018, -0.03867073357105255, 0.016560148447752, 0.022698763757944107,
    0.002762917894870043, 0.24226808547973633, -0.02277289144694805, -0.002127121202647686, 0.012051377445459366, -0.020878123119473457, -0.05096452683210373, -0.046168435364961624,
    -0.018092406913638115, -0.0581400990486145, -0.04769999533891678, 0.004368038382381201, -0.024201499298214912, -0.04794047027826309, -0.04612734913825989, 0.07581238448619843,
    -0.06724659353494644, 0.03685653954744339, -0.02298247255384922, 0.002954290248453617, 0.12316002696752548, -0.06738896667957306, -0.01129407249391079, 0.02612566202878952,
    -0.08609270304441452, -0.01922796666622162, 0.010557451285421848, -0.14472666382789612, 0.002929241396486759, 0.10082625597715378, 0.05538538470864296, -0.06486786901950836,
    0.028250856325030327, -0.023504745215177536, 0.08581168204545975, -0.06418170779943466, -0.09401697665452957, -0.0876750573515892, 0.0010358361760154366, 0.0017572016222402453,
    -0.07232585549354553, 0.03599579632282257, 0.04541308432817459, -0.05992639809846878, -0.14113739132881165, -0.02428331784904003, 0.0056480769999325275, 0.009795953519642353,
    0.04622802138328552, 0.006632108241319656, 0.11518064886331558, 0.05363505333662033, 0.032583896070718765, 0.05927974358201027, 0.0451982244849205, -0.01243625022470951,
    0.044798824936151505, 0.035631999373435974, 0.0271722711622715, -0.08953536301851273, 0.00040415197145193815, -0.03309261426329613, -0.16101370751857758, 0.04415997117757797,
    0.09732601791620255, 0.007738335523754358, -0.19194382429122925, -0.017984235659241676, -0.06944449245929718, 0.06798508763313293, -0.020070061087608337, -0.04250817373394966,
    0.07730430364608765, -0.003581384429708123, 0.04186089336872101, -0.08176606893539429, -0.05409794673323631, 0.008753885515034199, 0.032397881150245667, -0.030745921656489372,
    -0.10037309676408768, -0.04655195400118828, -0.0014041869435459375, 0.0806175246834755, -0.005630346480756998, 0.05122370645403862, 0.03740684315562248, -0.018692946061491966,
    0.008793816901743412, 0.10267610847949982, -0.01491336990147829, -0.12629207968711853, -0.062124162912368774, -0.002021630760282278, -0.08834192901849747, -0.013848574832081795,
    -0.04686884209513664, -0.05197291821241379, 0.0049009001813828945, -0.0794053003191948, 0.018108054995536804, 0.07230653613805771, -0.006028537172824144, -0.08818408101797104,
    0.0076125445775687695, -0.0781157985329628, -0.007563185878098011, -0.01711639203131199, -0.0649794489145279, 0.013803603127598763, 0.031649135053157806, -0.04405219480395317,
    -0.07645601779222488, -0.0460224449634552, 0.02029893919825554, 0.015373380854725838, 0.0665506049990654, -0.022209063172340393, -0.15548616647720337, 0.015409128740429878,
    0.16832609474658966, 0.03994561359286308, -0.04885125160217285, 0.1690356433391571, -0.025031408295035362, -0.04362849146127701, -0.02319733239710331, -0.007371410261839628,
    0.00826186127960682, 0.3216870129108429, 0.03896356746554375, -0.0029998731333762407, -0.022276228293776512, -0.01866617426276207, -0.06721176207065582, 0.07070652395486832,
    -0.038327187299728394, 0.09497004747390747, 0.011052302084863186, -0.05024615675210953, -0.06385684013366699, -0.0072605060413479805, -0.05665832757949829, -0.13577018678188324,
    0.026483042165637016, 0.01896742358803749, -0.01145186647772789, -0.03538743779063225, -0.0986894965171814, -0.05354004725813866, 0.0769851878285408, 0.05933772772550583,
    0.0014946357114240527, -0.023480931296944618, 0.024004556238651276, 0.01665435917675495, -0.06212787702679634, 0.004741997923702002, 0.0017414904432371259, -0.06102633476257324,
    0.057101793587207794, 0.010079187341034412, -0.044201623648405075, -0.09886980801820755, -0.033046871423721313, 0.04997539892792702, 0.021971365436911583, -0.0207462590187788,
    0.08022161573171616, -0.03671705350279808, -0.014325203374028206, 0.05761026591062546, -0.02185736782848835, 0.035338614135980606, -0.060307636857032776, -0.01820688508450985,
    -0.01847211830317974, -0.01130929496139288, -0.03041497990489006, 0.06258810311555862, -0.03127092868089676, 0.07607437670230865, -0.04467859864234924, -0.03627314418554306,
    0.09808802604675293, 0.0031574901659041643, 0.08931300044059753, 0.09712007641792297, -0.00479502696543932, -0.035158101469278336, 0.007023146376013756, 0.07450173050165176,
    -0.04543926939368248, -0.0014583790907636285, 0.007767184637486935, -0.02911035157740116, -0.028044680133461952, -0.011309138499200344, 0.048949867486953735, 0.024343911558389664,
    -0.02387288399040699, 0.04702672362327576, -0.12336340546607971, 0.030610432848334312, 0.04638001322746277, 0.03350013494491577, 0.025256827473640442, 0.0778917670249939,
    -0.011283401399850845, 0.03845951706171036, -0.02812155894935131, -0.057296331971883774, 0.042282409965991974, -0.012906721793115139, 0.030890505760908127, -0.0431557223200798,
    0.014972089789807796, 0.12288795411586761, 0.017164677381515503, -0.014228235930204391, 0.16597014665603638, -0.005767958704382181, 0.10237018764019012, 0.0722011998295784,
    0.08034520596265793, 0.03978858143091202, -0.0023536274675279856, 0.004122080747038126, -0.040895942598581314, 0.08113717287778854, 0.09662849456071854, 0.03340707719326019,
    0.03034646064043045, 0.09802602231502533, 0.03331410512328148, 0.08000961691141129, 0.09319531172513962, -0.12890061736106873, -0.0734458938241005, -0.023104935884475708,
    -0.0285504087805748, 0.026834484189748764, -0.023324603214859962, -0.01510666310787201, 0.01409090030938387, 0.04837172105908394, -0.010442640632390976, -0.031168367713689804,
    -0.017846127972006798, 0.00109510135371238, 0.03412581980228424, 0.014328344725072384, -0.008922104723751545, -0.028497833758592606, -0.010858146473765373, 0.010828671976923943,
    0.05175218731164932, 0.17809776961803436, 0.018128467723727226, -0.0021084356121718884, 0.050527218729257584, -0.03644333407282829, 0.019730400294065475, 0.09371346235275269,
    0.039226632565259933, 0.03243706747889519, -0.027441872283816338, 0.026457149535417557, -0.014207844622433186, 0.04689260944724083, -0.033267874270677567, -0.00600429018959403,
    0.021373873576521873, -0.0072205038741230965, -0.012150349095463753, -0.007592211943119764, -0.020622074604034424, -0.00046803842997178435, 0.09695582091808319, 0.0027008801698684692,
    0.04807579144835472, -0.05555034801363945, 0.0028240529354661703, 0.05855347588658333, 0.002092713722959161, 0.12223726511001587, 0.12396170198917389, 0.16416165232658386,
    -0.04538066312670708, 0.007858270779252052, -0.06457839906215668, -0.032020751386880875, 0.019803190603852272, 0.09222371876239777, 0.008219784125685692, -0.012913011014461517,
    0.06652659922838211, -0.0017189253121614456, -0.023721769452095032, 0.11593926697969437, -0.06217563897371292, -0.021082434803247452, 0.02333022467792034, 0.07350625842809677,
    -0.043639250099658966, 0.04503840208053589, -0.09359002113342285, -0.07353924959897995, -0.035516928881406784, -0.04488278180360794, -0.08407771587371826, 0.027692385017871857,
    -0.055846549570560455, -0.029315918684005737, -0.07458581030368805, 0.03441064804792404, 0.15744979679584503, 0.04235244169831276, -0.020070886239409447, -0.03507499769330025,
    -0.02436826378107071, -0.0011690299725160003, 0.0447990857064724, 0.07195963710546494, -0.02973916195333004, -0.03106587752699852, 0.016498498618602753, 0.023271264508366585,
    -0.05364488437771797, 0.04414484649896622, -0.06321752071380615, -0.07232826948165894, 0.10267257690429688, 0.0118775749579072, 0.03588758036494255, 0.0590628907084465,
    0.057427212595939636, -0.020608846098184586, 0.00849172379821539, -0.06739956885576248, -0.021999487653374672, -0.010966355912387371, -0.02486293576657772, -0.04141613468527794,
    -0.016824016347527504, 0.016324179247021675, 0.022619768977165222, -0.024683644995093346, 0.04461669921875, -0.0035154398065060377, 0.005182638764381409, 0.04798462614417076,
    -0.09745889902114868, -0.027292102575302124, 0.020790424197912216, -0.006534111686050892, -0.06516667455434799, 0.06058751791715622, 0.026084382086992264, 0.05613774061203003,
    -0.00301385042257607, 0.04574733227491379, -0.015989704057574272, -0.0038269972428679466, 0.028935376554727554, 0.03708839416503906, -0.017615968361496925, -0.02894984558224678,
    0.10048704594373703, 0.013727649115025997, 0.0001745088375173509, -0.045473385602235794, -0.017309365794062614, -0.030868591740727425, -0.010103531181812286, 0.020927131175994873,
    -0.055082302540540695, -0.020610883831977844, -0.04293835163116455, 0.006446174345910549, 0.007383476942777634, 0.011479562148451805, 0.005367308855056763, -0.03732956945896149,
    0.0035940129309892654, 0.11291704326868057, 0.04892636463046074, -0.000448778853751719, 0.0036939799319952726, 0.030391644686460495, 0.011795731261372566, 0.010083138942718506,
    0.03064757026731968, 0.008685602806508541, 0.017291046679019928, 0.0398741252720356, -0.08341079205274582, -0.03239280730485916, 0.021912921220064163, 0.03171861916780472,
    -0.07518920302391052, 0.0844462513923645, -8.579396671848372e-05, 0.08174457401037216, 0.018934771418571472, -0.04907658323645592, -0.007740663830190897, -0.01110739354044199,
    -0.07502242177724838, -0.013445600867271423, -0.04676349461078644, -0.15549226105213165, 0.04396594688296318, 0.0680103749036789, 0.046535562723875046, 0.15501387417316437,
    0.011689504608511925, -0.022190425544977188, 0.014141025952994823, 0.009890780784189701, 0.02863653190433979, 0.026915233582258224, -0.01678391359746456, -0.009096815250813961,
    -0.012743772938847542, 0.010649751871824265, 0.04416018724441528, -0.007127871736884117, -0.07578452676534653, -0.010933716781437397, 0.00578755559399724, -0.0024866622406989336,
    0.020012974739074707, 0.008580963127315044, 0.05787181109189987, -0.09876997023820877, 0.05488811805844307, 0.05258999764919281, -0.02120080031454563, 0.03380180895328522,
    -0.07006223499774933, 0.08925240486860275, -0.030918020755052567, -0.07911203056573868, 0.12887164950370789, -0.06644150614738464, -0.08800911903381348, 0.06154908239841461,
    0.014514204114675522, -0.0028689918108284473, -0.01740829274058342, 0.01361436303704977, -0.016496263444423676, 0.050732411444187164, -0.11965250223875046, -0.02270331420004368,
    0.060090646147727966, 0.04325355589389801, 0.0499684102833271, -0.0625382587313652, 0.03226557746529579, -0.035618703812360764, 0.006095686927437782, -0.0404009148478508,
    -0.043088190257549286, 0.0064783054403960705, -0.028325434774160385, 0.02058684453368187, 0.028195947408676147, 0.03044847585260868, -0.006554402876645327, 0.03729488328099251,
    0.0010795140406116843, -0.05615483596920967, -0.053491100668907166, -0.004194123670458794, -0.176504448056221, 0.0012266967678442597, -0.053338516503572464, 0.0326567143201828,
    -0.025800662115216255, -0.00615167198702693, -0.025888904929161072, -0.07003363966941833, -0.06057750806212425, 0.06387820839881897, -0.015758559107780457, -0.0733105018734932,
    0.006397949531674385, -0.06816080957651138, 0.011564883403480053, -0.09494239091873169, -0.006356654688715935, 0.025593895465135574, -0.027247756719589233, 0.05541161820292473,
    0.03937080129981041, -0.03997580334544182, -0.0029294283594936132, 0.022152559831738472, -0.13698595762252808, -0.022526666522026062, -0.11170705407857895, 0.026586247608065605,
    0.048207931220531464, 0.02191876620054245, -0.06923168152570724, 0.13226373493671417, -0.007118139881640673, 0.054618366062641144, 0.0003638306516222656, -0.06816958636045456,
    0.00785950105637312, 0.050816137343645096, 0.04543076455593109, 0.008694784715771675, 0.0010866281809285283, 0.030451636761426926, -0.06835884600877762, -0.03080461174249649,
    -0.013173670507967472, 0.0459955632686615, 0.1495131403207779, 0.021312318742275238, -0.1321123093366623, -0.004111519083380699, -0.0037753169890493155, -0.09294711798429489,
    0.007133642677217722, 0.038108959794044495, -0.03882839158177376, 0.03566453233361244, -0.04735403507947922, -0.02457660436630249, -0.022532949224114418, 0.020535625517368317,
    -0.017166202887892723, -0.006350810639560223, -0.06482204049825668, -0.04023846983909607, -0.050566308200359344, -0.08750209212303162, -0.009696460328996181, -0.02746143564581871,
    0.07182640582323074, -0.019950609654188156, 0.000743519573006779, -0.11756430566310883, -0.01462822500616312, 0.06255844235420227, 0.0074051497504115105, -0.0034749279730021954,
    -0.0007633824134245515, 0.02277878113090992, -0.007912891916930676, -0.048397015780210495, -0.05136283114552498, 0.03494470566511154, -0.05123521387577057, -0.051961079239845276,
    0.004015532787889242, -0.06275720149278641, -0.010050814598798752, 0.026423614472150803, -0.02658708207309246, 0.0636274442076683, -0.07070307433605194, -0.013431773521006107,
    0.060467980802059174, 0.031101882457733154, 0.015163872390985489, -0.019604675471782684, -0.09808284789323807, -0.06119600683450699, -0.009892143309116364, -0.007051641587167978,
    0.005719903390854597, -0.004503472708165646, -0.0141739621758461, -0.06676822900772095, -0.021400727331638336, 0.01293602678924799, -0.0035713366232812405, -0.01101837120950222,
    0.018389735370874405, -0.0397256575524807, 0.007553305011242628, -0.04445565864443779, 0.020023446530103683, 0.007132732775062323, -0.06539025902748108, -0.0340811051428318,
    -0.017439797520637512, 0.011203615926206112, -0.07235712558031082, 0.003883150639012456, 0.06261975318193436, -0.021636424586176872, 0.013084773905575275, 0.06577607989311218,
    0.024663100019097328, 0.015299069695174694, -0.004332968033850193, 0.006686904933303595, -0.03017425164580345, 0.0005324575467966497, 0.033427946269512177, -0.013350816443562508,
    0.09637115150690079, 0.025343483313918114, 0.016721803694963455, 0.009418739937245846, -0.09788741916418076, 0.03457362577319145, 0.039987675845623016, -0.12943314015865326,
    0.041716061532497406, 0.05692927911877632, 0.04096907749772072, 0.0572938546538353, -0.03657267987728119, -0.13724835216999054, 0.04025089368224144, 0.03414425626397133,
    -0.04062037169933319, -0.0020868126302957535, -0.001437654602341354, -0.004271097015589476, -0.0015234212623909116, 0.01648665778338909, -0.06385081261396408, -0.0180831216275692,
    0.041338685899972916, 0.02560824528336525, 0.007115233223885298, 0.03900789096951485, -0.0030726478435099125, -0.03559037297964096, 0.00558184739202261, -0.01646081730723381,
    0.030755622312426567, 0.036631856113672256, -0.03383318707346916, -0.005768819712102413, 0.03792727738618851, 0.035051632672548294, -0.023368671536445618, -0.001600160263478756,
    -0.013891763985157013, 0.030415905639529228, 0.08281411230564117, 0.028493978083133698, -0.1183590516448021, 0.020580530166625977, -0.04156501218676567, -0.01636931113898754,
    0.026702821254730225, 0.007008974440395832, -0.04517033323645592, -0.038233041763305664, 0.05299755185842514, 0.04302794113755226, -0.034078944474458694, -0.004021686967462301,
    -0.0065098898485302925, 0.02862284518778324, -0.018869778141379356, 0.07003197073936462, -0.06346878409385681, -0.027093086391687393, 0.06046101450920105, 0.010023673065006733,
    -0.02791306935250759, 0.013594241812825203, -0.00908066425472498, -0.01356484554708004, -0.03204929083585739, 0.08905394375324249, 0.04967267066240311, -0.00028247747104614973,
    -0.02204362489283085, -0.032043904066085815, -0.07766705006361008, 0.055542897433042526, -0.054306481033563614, 0.00036243832437321544, -0.013837253674864769, 0.07082661986351013,
    -0.03243371099233627, 0.017045293003320694, -0.12135820090770721, 0.020505521446466446, -0.08154737949371338, 0.06201142817735672, -0.042424995452165604, -0.06064501404762268,
    0.01936427317559719, -0.15363368391990662, 0.0044660489074885845, 0.05737534537911415, -0.045235391706228256, -0.03510609641671181, -0.02740318886935711, -0.11319482326507568,
    -0.0145993297919631, -0.0012935383711010218, -0.02758749946951866, 0.03987778723239899, -0.06409595161676407, -0.052684810012578964, 0.040064264088869095, 0.03732859343290329,
    -0.03544767573475838, -0.10222304612398148, -0.06165290251374245, 0.0038974652998149395, 0.0676315650343895, 0.09172361344099045, -0.03587515652179718, -0.007980425842106342,
    0.06011752039194107, -0.03441609814763069, -0.019438982009887695, -0.031179513782262802, 0.041031766682863235, -0.008060132153332233, 0.018703430891036987, -0.05383380874991417,
    -0.033722396939992905, 0.05541182681918144, 0.012054498307406902, 0.013550463132560253, 0.02505774423480034, -0.0189053975045681, 0.02975163236260414, -0.03452731668949127,
    -0.011931058019399643, -0.08379785716533661, -0.012704534456133842, -0.04097467288374901, -0.09875139594078064, 0.10646673291921616, 0.010669977404177189, 0.0243986863642931,
    0.02300252392888069, 0.003444550558924675, -0.011459380388259888, -0.032722704112529755, -0.04197331890463829, 0.007462345529347658, 0.054883603006601334, -0.07760622352361679,
    -0.012399395927786827, 0.07148952037096024, 0.029215646907687187, -0.062063515186309814, 0.08072072267532349, -0.01966584473848343, -0.0062622386030852795, -0.029586102813482285,
    -0.06715521216392517, -0.015493854880332947, -0.053155697882175446, 0.032278019934892654, 0.04645629972219467, 0.010979431681334972, 0.04255371540784836, 0.020484937354922295,
    0.09764570742845535, -0.00309420982375741, 0.0004982890677638352, 0.004205297213047743, 0.08877316117286682, 0.03195546194911003, 0.08553097397089005, 0.028906185179948807,
    0.04022151976823807, -0.07098794728517532, -0.08070097863674164, 0.03895983099937439, -0.09274248778820038, -0.03344239294528961, -0.015100130811333656, 0.010114113800227642,
    -0.0663042664527893, 0.026988616213202477, 0.0013360788580030203, -0.05042864382266998, 0.05891019478440285, 0.011245002038776875, 0.037225592881441116, -0.07956641912460327,
    -0.09891372919082642, 0.04613448306918144, -0.03652089834213257, -0.04148833826184273, -0.0024710637517273426, -0.0238537285476923, -0.01193710882216692, 0.055345457047224045,
    -0.000254059792496264, -0.026955774053931236, -0.026478055864572525, 0.059166550636291504, -0.03208974748849869, 0.04578455910086632, -0.09198390692472458, -0.013126554898917675,
    -0.058653589338064194, -0.07008520513772964, -0.02238105796277523, -0.08176352828741074, -0.1629972606897354, -0.006037869490683079, 0.07862457633018494, -0.052290983498096466,
    -0.055549461394548416, 0.05060618370771408, 0.03198230266571045, 0.0077877407893538475, -0.06525267660617828, 0.072230763733387, 0.03822101652622223, -0.026928501203656197,
    -0.00996676180511713, -0.07678177207708359, -0.025291958823800087, -0.034782782196998596, 0.08175663650035858, -0.09895267337560654, 0.02541929855942726, -0.0365992896258831,
    0.037347014993429184, 0.0008468708256259561, -0.002106298925355077, 0.04655041545629501, -0.05415992811322212, 0.025999967008829117, -0.042885422706604004, -0.030699294060468674,
    0.0639767125248909, 0.016161134466528893, -0.052085235714912415, -0.08443596214056015, 0.03442690148949623, 0.01509315986186266, 0.08955778181552887, -0.02302738092839718,
    -0.10149258375167847, 0.027485039085149765, 0.09207874536514282, -0.0003442139714024961, -0.0415792353451252, 0.04533959925174713, 0.0025924965739250183, 0.01462056115269661,
    0.011476765386760235, -0.018175501376390457, -0.043843064457178116, 0.02083025500178337, 0.05055597424507141, 0.0033239289186894894, -0.008190970867872238, -0.03365980461239815,
    -0.14008769392967224, -0.02776373364031315, 0.020943593233823776, -0.04054403305053711, -0.08011703193187714, 0.05757896229624748, 0.001273128087632358, 0.04667183756828308,
    -0.018871432170271873, -0.05960468202829361, 0.03210291266441345, -0.00790747907012701, -0.05674180015921593, 0.02176811173558235, 0.006267318036407232, 0.024502577260136604,
    -0.06901751458644867, -0.0367271788418293, -0.02255377173423767, 0.007166494149714708, -0.037205904722213745, 0.016503963619470596, -0.07929366827011108, -0.06222094967961311,
    0.05282498523592949, -0.027347253635525703, -0.07761507481336594, 0.08184094727039337, -0.021476587280631065, 0.008176261559128761, -0.04485504701733589, -0.0036928514018654823,
    -0.008048220537602901, 0.034164607524871826, 0.07338771224021912, 0.0013378327712416649, -0.028996506705880165, 0.056668721139431, -0.008332773111760616, -0.006169725209474564,
    0.006201081443578005, 0.0817047730088234, 0.09500069171190262, 0.06881877034902573, -0.0807008147239685, 0.03589814156293869, -0.00932045467197895, -0.09462232887744904,
    0.0028587367851287127, 0.008204229176044464, 0.012495340779423714, 0.031246492639183998, -0.2010662853717804, -0.017306488007307053, 0.044803738594055176, -0.07912713289260864,
    0.0563041977584362, 0.09562255442142487, -0.06795348227024078, -0.0032073864713311195, 0.05302499979734421, 0.00958226341754198, -0.04305543377995491, 0.15123867988586426,
    0.04810455068945885, 0.011822384782135487, -0.038095925003290176, -0.06673558801412582, 0.02126067876815796, 0.01777743548154831, 0.02688397280871868, -0.010664298199117184,
    0.04046115279197693, 0.01768520101904869, 0.060822512954473495, -0.0012871992075815797, -0.12306639552116394, 0.01623748242855072, 0.00316940457560122, -0.09411290287971497,
    -0.009275845251977444, -0.04782556742429733, 0.021527141332626343, -0.10509555786848068, -0.053827691823244095, -0.018705984577536583, -0.08588338643312454, -0.011334211565554142,
    0.09020267426967621, 0.032994337379932404, -0.03869958594441414, 0.06434355676174164, 0.11430898308753967, -0.05689869448542595, 0.02579222433269024, -0.042095720767974854,
    -0.037871912121772766, -0.00399479316547513, 0.09792123734951019, -0.023193713277578354, -0.0026514807250350714, -0.04733022674918175, -0.013703442178666592, -0.016614802181720734,
    -0.08223581314086914, 0.100542351603508, -0.009549803100526333, 0.013804389163851738, 0.09088236838579178, 0.032486796379089355, 0.05278412997722626, 0.040425483137369156,
    0.019296696409583092, -0.008218890987336636, 0.07595828175544739, 0.02182196080684662, 0.025166744366288185, -0.026996269822120667, -0.10594582557678223, 0.06938331574201584,
    0.018447445705533028, -0.11188048124313354, 0.010956673882901669, -0.005869042593985796, -0.12483607977628708, 0.005265600513666868, 0.1462526023387909, -0.01166015025228262,
    0.12756980955600739, 0.1010245531797409, 0.009848913177847862, 0.1003546342253685, 0.09797970205545425, 0.022252950817346573, -0.03826397284865379, -0.021715229377150536,
    -0.03130878880620003, -0.01432099286466837, -0.02077297680079937, 0.04348253458738327, 0.04691397398710251, -0.14516450464725494, 0.07189782708883286, 0.08613661676645279,
    -0.07616060227155685, -0.023818619549274445, -0.014586322009563446, -0.02606511116027832, -0.06863215565681458, 0.015408555045723915, 0.039269544184207916, 0.02456369437277317,
    -0.014548396691679955, 0.008463861420750618, 0.005282153841108084, -0.10763140767812729, -0.02689518965780735, 0.023034561425447464, 0.02009555883705616, 0.0025306453462690115,
    0.024912888184189796, 0.12043565511703491, -0.003977180924266577, 0.0018041435396298766, -0.02077499032020569, -0.004364584572613239, -0.03247396647930145, -0.03475193679332733,
    0.028184054419398308, -0.059188101440668106, -0.02779064141213894, 0.07078105211257935, -0.14082497358322144, 0.0038551283068954945, -0.02641998790204525, 0.03585535287857056,
    0.01939781755208969, 0.011211595498025417, -0.022704338654875755, 0.04407791793346405, 0.09368397295475006, 0.05036333203315735, 0.02093397080898285, -0.10940032452344894,
    -0.04159559682011604, 0.10220629721879959, -0.03613077476620674, -0.07051606476306915, 0.03759205713868141, 0.042549651116132736, 0.026288563385605812, -0.06340314447879791,
    -0.02731923758983612, -0.005989884492009878, -0.017483731731772423, -0.0504208467900753, 0.0263189859688282, -0.04981067404150963, -0.034063566476106644, -0.0009113724227063358,
    -0.07855615764856339, -0.005768082104623318, -0.03394794836640358, -0.028343282639980316, -0.051934752613306046, -0.02287648245692253, -0.07633666694164276, 0.011264316737651825,
    0.04474282264709473, 0.0231404360383749, -0.021498819813132286, -0.04733380675315857, 0.0635245218873024, 0.00142909015994519, -0.05524803325533867, -0.026232274249196053,
    -0.010322296991944313, 0.03880083188414574, -0.023336589336395264, -0.0925803855061531, -0.18700367212295532, 0.010214126668870449, -0.07047618925571442, 0.03990424796938896,
    0.07469756156206131, 0.0006639106431975961, 0.010649215430021286, 0.039389852434396744, -0.004893760196864605, 0.019557569175958633, 0.07377756386995316, 0.027530955150723457,
    0.034179944545030594, -0.20134365558624268, 0.03047984093427658, -0.050047364085912704, 0.06818009912967682, 0.08987785875797272, 0.03213243931531906, 0.07036884129047394,
    0.02195057086646557, 0.005103121045976877, -0.013486889190971851, -0.04166639968752861, 0.014215695671737194, 0.004720803815871477, 0.09367810934782028, 0.023507557809352875,
    -0.03628980740904808, 0.04559694603085518, 0.003746097208932042, -0.06376298516988754, -0.10720948874950409, -0.00735026691108942, -0.05958889052271843, 0.0069779297336936,
    -0.08381211757659912, -0.039870887994766235, -0.025919539853930473, 0.01516025047749281, 0.03270893916487694, -0.06755848228931427, -0.0034573967568576336, -0.15829961001873016,
    0.0018826751038432121, 0.03501392528414726, 0.03051014617085457, -0.10455168038606644, -0.09508689492940903, 0.059287261217832565, 0.013811681419610977, -0.016249990090727806,
    0.039081819355487823, 0.0019091723952442408, 0.036897461861371994, -0.0950845405459404, 0.001698339357972145, -0.018643327057361603, -0.10269630700349808, -0.02222946472465992,
    -0.012623441405594349, 0.01148959156125784, -0.052904579788446426, 0.08767345547676086, -0.022346898913383484, 0.0073129646480083466, 0.04406297951936722, -0.037583015859127045,
    0.05575412139296532, 0.08254238218069077, -0.024225475266575813, -0.0062386104837059975, 0.08392078429460526, 0.09498561918735504, 0.03366919234395027, -0.06649329513311386,
    0.022940320894122124, -0.04018544405698776, -0.06712907552719116, -0.0089472196996212, -0.15479972958564758, -0.010583020746707916, -0.07839035987854004, -0.07446195185184479,
    0.0004359263984952122, 0.017558148130774498, -0.0839136466383934, -0.07857347279787064, 0.1065172404050827, -0.04735562950372696, -0.016532110050320625, 0.008394124917685986,
    -0.0380827896296978, 0.07297632098197937, 0.04529516026377678, -0.02815292775630951, 0.010715511627495289, -0.023863954469561577, -0.05898609012365341, -0.11115605384111404,
    -0.001200420199893415, -0.02428271807730198, 0.02001139707863331, 0.01381602417677641, -0.02113024704158306, -0.01943950355052948, -0.005405816715210676, 0.03835861384868622,
    -0.06145569309592247, -0.0686628669500351, -0.06535894423723221, -0.02114059403538704, -0.02191689983010292, -0.01193135417997837, -0.02957085706293583, -0.004823204595595598,
    -0.057998478412628174, 0.05300603434443474, -0.007278245408087969, 0.004700841382145882, 0.0054456149227917194, 0.10102415829896927, 0.001116287661716342, -0.022536201402544975,
    -0.01294860802590847, -0.005231181159615517, -0.010724730789661407, 0.010146122425794601, -0.1947685331106186, -0.09529002755880356, 0.05149572342634201, 0.0350918211042881,
    0.0410926379263401, 0.002634773263707757, -0.08941905945539474, -0.006788061931729317, -0.014250475913286209, 0.0148934256285429, 0.004077941179275513, -0.023774201050400734,
    0.020404433831572533, -0.06967809051275253, -0.11380118131637573, -0.0527440644800663, 0.049407508224248886, 0.09168857336044312, 0.049857888370752335, 0.05671708285808563,
    -0.05093247443437576, 0.03994361683726311, -0.0643942654132843, -0.05572344362735748, -0.052964624017477036, 0.02012491226196289, 0.12896612286567688, -0.04005136713385582,
    0.037216201424598694, 0.06380505114793777, -0.01374573353677988, 0.04866647347807884, 0.10585752874612808, 0.011763385497033596, -0.0031635493505746126, -0.04279840737581253,
    -0.05487547814846039, -0.0975981205701828, 0.048043567687273026, -0.051710765808820724, 0.014453783631324768, -0.11370901763439178, 0.11485685408115387, 0.07640068233013153,
    0.036954015493392944, -0.016139039769768715, 0.02719729207456112, -0.052094876766204834, -0.07247325032949448, 0.012565153650939465, 0.0185382142663002, -0.059002991765737534,
    0.067194364964962, 0.10206902772188187, -0.026831069961190224, 0.04262718930840492, 0.12883137166500092, 0.019498897716403008, -0.07275833934545517, -0.03669540956616402,
    0.034536078572273254, 0.008371230214834213, -0.025348512455821037, 0.016491174697875977, 0.06832418590784073, -0.027088459581136703, -0.011951304040849209, -0.02413789927959442,
    0.03904695808887482, 0.018717149272561073, 0.036820732057094574, 0.0058997441083192825, 0.07378065586090088, 0.04487879201769829, -0.04513469710946083, 0.024975735694169998,
    -0.04491134360432625, 0.15677541494369507, 0.08431731164455414, 0.05465308576822281, -0.013719621114432812, 0.044636230915784836, -0.020867187529802322, -0.06589167565107346,
    0.0200959499925375, -0.024776991456747055, -0.02935115620493889, -0.008219863288104534, -0.15357740223407745, -0.03159510716795921, -0.0024877761024981737, 0.01672288402915001,
    0.08355025202035904, -0.003551238914951682, 0.02208598144352436, 0.12506522238254547, 0.03974641487002373, 0.11556316912174225, -0.06586238741874695, 0.1194005161523819,
    0.006894978694617748, 0.026999905705451965, -0.0074696727097034454, 0.035176679491996765, -0.011079602874815464, 0.020533781498670578, 0.02467694878578186, 0.026185233145952225,
    0.07353731244802475, -0.0012709805741906166, 0.050538402050733566, 0.13009504973888397, -0.0794757604598999, 0.0069693028926849365, 0.013555435463786125, 0.052198633551597595,
    -0.008943624794483185, -0.08906633406877518, 0.005674091167747974, -0.011724602431058884, -0.05191999301314354, 0.0310724638402462, -0.07232929766178131, 0.028792742639780045,
    0.04346377030014992, -0.05320638790726662, -0.022864950820803642, 0.13232392072677612, 0.14578944444656372, -0.03788887336850166, 0.09747595340013504, -0.10351965576410294,
    -0.09355469793081284, 0.0009416148532181978, 0.05552925541996956, -0.041434239596128464, -0.013805943541228771, -0.08929914981126785, 0.03620794415473938, 0.02756953239440918,
    -0.09216045588254929, 0.12365485727787018, -0.09983130544424057, -0.05468880385160446, 0.10825232416391373, 0.026440491899847984, 0.06465855240821838, 0.06844096630811691,
    0.022940773516893387, -0.01353647094219923, -0.02644851990044117, -0.004283182322978973, -0.007757894229143858, -0.0309099443256855, -0.1419135332107544, 0.019252896308898926,
    -0.0033189996611326933, -0.11657578498125076, 0.03828202933073044, 0.007001702673733234, 0.08660458773374557, -0.00471037020906806, 0.12809976935386658, -0.004016106016933918,
    0.08260157704353333, 0.10741429775953293, -0.03787021338939667, 0.02125217579305172, 0.11162947863340378, -0.17483992874622345, 0.0022711260244250298, 0.07548109441995621,
    -0.022502021864056587, -0.07323138415813446, -0.0022884116042405367, 0.06194516271352768, 0.0202033594250679, -0.05898093059659004, 0.048454951494932175, 0.07501240074634552,
    0.05489183962345123, 0.03863448649644852, 0.019370559602975845, -0.01531810313463211, 0.05134676396846771, 0.0048845140263438225, 0.05044674500823021, -0.02313421107828617,
    -0.09707646071910858, -0.06996806710958481, -0.00882192887365818, -0.03850219026207924, 0.02854805812239647, 0.03288417309522629, -0.003104542614892125, -0.07182534784078598,
    0.03319164365530014, -0.04067960008978844, -0.019762761890888214, -0.021861571818590164, -0.014349959790706635, -0.0071592070162296295, -0.03861113265156746, -0.03102845698595047,
    0.011618816293776035, -0.045826174318790436, -0.022230276837944984, 0.07269532978534698, -0.06370999664068222, -0.02034018374979496, 0.011390024796128273, 0.07583931088447571,
    -0.06392130255699158, 0.022114979103207588, -0.010996862314641476, -0.0034657486248761415, 0.04357702657580376, 0.051053229719400406, 0.05226132646203041, -0.08766324818134308,
    -0.01624639891088009, 0.018402138724923134, -0.021490827202796936, -0.07593170553445816, 0.013955277390778065, 0.08950946480035782, 0.03777603432536125, 0.07348009198904037,
    0.017969291657209396, -0.10163277387619019, -0.015689577907323837, 0.007360347546637058, -0.03244972974061966, -0.004386777523905039, -0.10121867805719376, -0.03038995899260044,
    -0.05128622427582741, -0.002434580819681287, 0.05863489210605621, -0.053318630903959274, -0.050831034779548645, -0.027142612263560295, 0.000795690924860537, 0.06196725741028786,
    0.09241051971912384, 0.008548405021429062, 0.106977678835392, -0.018711715936660767, 0.06710941344499588, 0.03546345233917236, 0.06000219285488129, -0.03461548686027527,
    -0.09028883278369904, 0.03448937088251114, -0.013673833571374416, -0.0978880375623703, 0.09066489338874817, 0.01909143105149269, -0.09453844279050827, 0.05167800188064575,
    0.0588102713227272, 0.005523158702999353, -0.004138998221606016, 0.0470680370926857, 0.08520951867103577, 0.07023383677005768, 0.03883585333824158, -0.014341386035084724,
    0.0652814507484436, -0.00917190033942461, 0.03043200448155403, -0.023676922544836998, 0.0017496515065431595, 0.004040433093905449, 0.050773441791534424, 0.07710140943527222,
    -0.05471116676926613, 0.005537022836506367, 0.054666806012392044, 0.02204422652721405, 0.059067320078611374, 0.01449304074048996, 0.030809897929430008, 0.028994262218475342,
    -0.009472077712416649, 0.028078913688659668, -0.023312054574489594, -0.019463764503598213, -0.10687833279371262, -0.00794646143913269, -0.11560973525047302, -0.03753627836704254,
    -0.05041614919900894, 0.02409019134938717, 0.028715310618281364, 0.010737628675997257, 0.028887389227747917, -0.2100653499364853, 0.0032060910016298294, -0.13375341892242432,
    0.014973929151892662, 0.018422747030854225, 0.01008137408643961, -0.05040406808257103, -0.00513910036534071, 0.012333077378571033, -0.08431468158960342, 0.03999747335910797,
    -0.030121859163045883, -0.08464207500219345, 0.0035838703624904156, 0.05765552818775177, -0.12098618596792221, -0.022060295566916466, -0.05929231271147728, -0.09319550544023514,
    0.0904400572180748, 0.017337745055556297, -0.039918914437294006, 0.1485823094844818, -0.02926858514547348, 0.03309858590364456, 0.023652011528611183, -0.025167379528284073,
    0.025675499811768532, 0.04638940468430519, -0.016349272802472115, 0.0190642811357975, 0.005062319338321686, 0.12625239789485931, -0.04950084909796715, -0.06539152562618256,
    0.02564818225800991, 0.021237438544631004, 0.02808859944343567, 0.021769922226667404, -0.11357764154672623, 0.0038136206567287445, -0.002613635966554284, 0.02875448390841484,
    -0.013175252825021744, 0.04599384590983391, -0.06161867082118988, -0.025648850947618484, 0.026652606204152107, -0.028214070945978165, 0.017483755946159363, -0.05311710387468338,
    -0.0018849661573767662, -0.015097261406481266, -0.014857141301035881, -0.010950181633234024, -0.007180689834058285, -0.025632496923208237, -0.0043070618994534016, -0.030615143477916718,
    -0.026890680193901062, 0.016176491975784302, -0.048034220933914185, -0.02485162951052189, -0.010587592609226704, 0.00037294503999873996, 0.044663868844509125, -0.019540000706911087,
    -0.05079067870974541, 0.0060479226522147655, -0.04228469729423523, -0.020968791097402573, 0.020462259650230408, -0.00664670392870903, -0.07600318640470505, -0.028836706653237343,
    0.06475307792425156, 0.0413752906024456, -0.010600467212498188, -0.04111939296126366, -0.027623318135738373, 0.0900108590722084, -0.025614187121391296, -0.06389676779508591,
    -0.0013766472693532705, 0.018739722669124603, -0.02485520765185356, -0.026898659765720367, -0.1541864573955536, -0.03907658904790878, -0.051512591540813446, 0.03268541395664215,
    -0.03059942089021206, 0.00672741187736392, -0.0405886210501194, 0.025292638689279556, 0.0859634205698967, 0.021133439615368843, 0.04843920096755028, 0.020977726206183434,
    0.005447500851005316, -0.08570434898138046, 0.03849610686302185, -0.02128767967224121, 0.03410443291068077, 0.057896051555871964, -0.006791648920625448, 0.023831987753510475,
    -0.026758365333080292, 0.03527968376874924, -0.05238970369100571, -0.028991060331463814, 0.08775912970304489, -0.014733322896063328, 0.1592903435230255, 0.01174182165414095,
    0.016935424879193306, 0.06913711130619049, -0.0012676541227847338, -0.008075568825006485, -0.0038434972520917654, 0.003451454918831587, -0.021568195894360542, 0.046771034598350525,
    0.022500252351164818, -0.020134950056672096, -0.010979864746332169, -0.0031316925305873156, 0.007424706127494574, -0.15526093542575836, 0.04960307478904724, -0.06722058355808258,
    0.02084071934223175, 0.05505814403295517, 0.044130753725767136, -0.03670547530055046, -0.028379129245877266, -0.007334975991398096, -0.03922203555703163, -0.019427362829446793,
    -0.028600135818123817, 0.03929242864251137, -0.02968926541507244, -0.04675668850541115, 0.009532933123409748, 0.013646428473293781, -0.05268983170390129, -0.04670855402946472,
    -0.04748653620481491, 0.018192781135439873, 0.02535661868751049, 0.06584349274635315, 0.023904412984848022, -0.03949515521526337, 0.04053835943341255, -0.04954913258552551,
    -0.004966025240719318, 0.055363669991493225, -0.05247987434267998, -0.013280795887112617, 0.020533844828605652, 0.054957903921604156, 0.045242391526699066, -0.038794200867414474,
    -0.004452207125723362, 0.05996096134185791, 0.09721583127975464, 0.03986836224794388, -0.10720960795879364, 0.037520669400691986, 0.0096549391746521, 0.019722359254956245,
    -0.0324740968644619, 0.04074893519282341, 0.018001770600676537, -0.06359036266803741, -0.03341924026608467, -0.061991896480321884, -0.012874975800514221, -0.0015363197308033705,
    0.005518924444913864, -0.08641332387924194, 0.03829341009259224, 0.07065784186124802, -0.03311944007873535, -0.008073389530181885, -0.022310489788651466, -0.02621743269264698,
    -0.025118468329310417, -0.008156784810125828, -0.006247928366065025, 0.027904212474822998, 0.003240648889914155, -0.0007046248647384346, 0.0798947736620903, 0.0387607179582119,
    0.020594308152794838, 0.016095662489533424, -0.011792348697781563, 0.02559761516749859, -0.00275994511321187, 0.010487294755876064, 0.018647635355591774, -0.0247366800904274,
    -0.010574805550277233, -0.03594297915697098, 0.0021915859542787075, -0.04638049751520157, -0.059281181544065475, 0.06605210155248642, -0.03802984952926636, -0.06613101810216904,
    0.020587319508194923, -0.04311908036470413, -0.05633869767189026, 0.048459503799676895, -0.028048379346728325, -0.04890618473291397, 0.10405111312866211, -0.03622421994805336,
    -0.07380560040473938, 0.007811296731233597, 0.004840245004743338, -0.029040636494755745, 0.013470536097884178, -0.06334489583969116, -0.0030795044731348753, 0.009686985053122044,
    -0.05189645290374756, 0.08012185245752335, -0.04203929007053375, -0.05031777173280716, 0.09797196835279465, 0.02355974167585373, 0.03292235732078552, 0.003067558165639639,
    -0.04333510249853134, -0.008185927756130695, -0.07651310414075851, -0.01535747665911913, 0.0764756053686142, 0.0024905474856495857, -0.02140689082443714, 0.040621835738420486,
    0.005097328685224056, 0.01886541023850441, 0.0032781800255179405, 0.016032777726650238, 0.08292999863624573, -0.0008536927052773535, 0.0830792710185051, -0.009349950589239597,
    0.026435688138008118, -0.013429868966341019, 0.007695548702031374, 0.020681561902165413, 0.013637279160320759, -0.10112858563661575, 0.011265305802226067, 0.07297363132238388,
    -0.020451918244361877, 0.012810329906642437, -0.02088126912713051, -0.031180525198578835, 0.025323515757918358, -0.038153696805238724, 0.04989587143063545, -0.07636674493551254,
    -0.07256532460451126, 0.06395179033279419, 0.026585444808006287, -0.04618220403790474, 0.07359206676483154, 0.02667350508272648, 0.01344643346965313, -0.06579206138849258,
    -0.01624775491654873, -0.019329113885760307, 0.0039979927241802216, 0.054689519107341766, 0.02654552459716797, -0.01913001947104931, -0.007063549943268299, -0.013835359364748001,
    -0.0036129497457295656, 0.03249569237232208, 0.0102643221616745, -0.001302918535657227, 0.00420598266646266, -0.08693228662014008, 0.029871663078665733, -0.020441360771656036,
    0.006734590046107769, -0.04995300620794296, -0.03762732818722725, 0.01423763670027256, -0.050998710095882416, 0.004192989319562912, -0.0012131709372624755, 0.06288549304008484,
    -0.062028370797634125, 0.014974440447986126, -0.044365692883729935, -0.07203971594572067, 0.02475249581038952, 0.04779362678527832, 0.02301137149333954, -0.07323096692562103,
    0.019656367599964142, -0.034823156893253326, 0.04192483797669411, 0.06366134434938431, -0.011981189250946045, 0.02815229445695877, -0.02200493961572647, 0.04815138503909111,
    0.026949262246489525, -0.02298864535987377, 0.022476769983768463, 0.0859495997428894, -0.03799805790185928, 0.035256434231996536, 0.009708456695079803, -0.002693175571039319,
    -0.07040422409772873, -0.03837180137634277, 0.0848039761185646, -0.03703387826681137, -0.005740129388868809, -0.014722765423357487, 0.021289680153131485, 0.035995498299598694,
    -0.019349176436662674, -0.0008960306295193732, 0.07034055888652802, 0.012811793945729733, -0.02425972744822502, 0.10097319632768631, 0.02872261218726635, 0.048677969723939896,
    -0.060331299901008606, 0.013793961144983768, -0.012660099193453789, -0.06066707894206047, 0.04370132461190224, 0.015483124181628227, 0.06296025961637497, -0.004784116055816412,
    -0.013967422768473625, 0.007814956828951836, 0.011087603867053986, -0.006179273594170809, 0.09917011857032776, 0.0027874584775418043, 0.021547213196754456, -0.01585737243294716,
    0.000525114475749433, 0.038384292274713516, -0.00011417370842536911, 0.014739442616701126, 0.02052696980535984, -0.040430739521980286, 0.05905996635556221, 0.07518933713436127,
    -0.08212552219629288, 0.0022022794000804424, 0.03354620933532715, 0.004387726541608572, 0.06767571717500687, 0.0009798099054023623, -0.03406751900911331, 0.024732107296586037,
    -0.014042701572179794, 0.032722968608140945, -0.043009500950574875, -0.02499958500266075, 0.012856612913310528, -0.019819052889943123, -0.007187537848949432, -0.05912924185395241,
    -0.06428474187850952, 0.020367305725812912, 0.03488137945532799, 0.05487993732094765, 0.02262827754020691, -0.09421359747648239, 0.023787297308444977, -0.0031172449234873056,
    0.023625029250979424, 0.004753210116177797, -0.012032930739223957, -0.0015427737962454557, 0.02989239990711212, 0.020769765600562096, 0.006546347867697477, 0.051576778292655945,
    -0.028424393385648727, -0.01945549249649048, -0.006529428064823151, 0.022829443216323853, 0.010047596879303455, 0.0039137727580964565, 0.021457988768815994, -0.046768154948949814,
    0.030651940032839775, -0.028759146109223366, -0.08114868402481079, 0.12701401114463806, -0.0006650711875408888, 0.022787008434534073, 0.01520831324160099, -0.014787698164582253,
    -0.037861987948417664, -0.006618967745453119, -0.005697437096387148, 0.007028566673398018, -0.07719185948371887, 0.009845435619354248, 0.0330096036195755, -0.0697258859872818,
    -0.02072964422404766, 0.04383661970496178, 0.04613732174038887, 0.024574102833867073, -0.039016012102365494, -0.0034518535248935223, 0.02578035183250904, 0.019009530544281006,
    0.0029367238748818636, 0.029058067128062248, -0.04575743526220322, 0.03401481360197067, -0.0935484766960144, 0.09627754241228104, -0.01329015102237463, -0.08125628530979156,
    -0.02112714946269989, 0.08532548695802689, -0.023617444559931755, 0.04315829277038574, -0.0018844922306016088, -0.03324168547987938, -0.013881340622901917, 0.05979818105697632,
    -0.0058087375946342945, -0.008595138788223267, 0.010192657820880413, 0.004557411186397076, -0.022525997832417488, 0.011462974362075329, 0.025964554399251938, -0.05690131336450577,
    -0.07007963210344315, 0.0038471759762614965, 0.0067288801074028015, 0.006155124865472317, 0.0005306635866872966, -0.006047838367521763, -0.11489825695753098, 0.015056231059134007,
    0.09499312192201614, 0.03103972040116787, -0.004845208488404751, -0.053470902144908905, 0.00550821190699935, 0.057090453803539276, -0.03962143510580063, -0.03096112608909607,
    0.020026855170726776, 0.0292466189712286, 0.0447620153427124, 0.020172379910945892, -0.011427251622080803, -0.0008431224268861115, -0.036455780267715454, 0.0518624372780323,
    -0.03813164308667183, 0.0015110635431483388, -0.07349801808595657, 0.00481928838416934, 0.027463966980576515, 0.00791104044765234, 0.010465781204402447, -0.023328958079218864,
    0.02297363616526127, -0.11015565693378448, 0.11915601044893265, 0.061525240540504456, 0.033273182809352875, 0.0620652474462986, -0.022708812728524208, 0.025270549580454826,
    0.045971475541591644, -0.016564568504691124, 0.08510056138038635, 0.0023039118386805058, 0.1854458600282669, -0.005825203377753496, -0.012729170732200146, 0.019163142889738083,
    -0.008888266049325466, 0.02230982854962349, -0.030549760907888412, -0.03691232576966286, -0.12023869156837463, 0.009238396771252155, 0.0022289007902145386, 0.043998632580041885,
    0.06576651334762573, 0.110914446413517, -0.026916924864053726, -0.02944660559296608, 0.01711493358016014, -0.09232210367918015, 0.015126299113035202, -0.1047164797782898,
    0.019766606390476227, -0.015184417366981506, 0.024866687133908272, -0.018159793689846992, 0.046894922852516174, -0.017656972631812096, -0.11395604908466339, 0.05967749282717705,
    0.061361946165561676, -0.05057227611541748, -0.0010119260987266898, -0.0272896159440279, -0.11661485582590103, -0.04496784508228302, 0.02422645129263401, 0.05940728634595871,
    -0.029195211827754974, 0.02187102846801281, -0.07413303107023239, 0.061846569180488586, 0.002997787669301033, 0.026893166825175285, 0.026536276564002037, 0.026545142754912376,
    0.058124881237745285, 0.0074765668250620365, -0.1115843877196312, 0.005836627446115017, 0.0087694451212883, 0.04873338341712952, 0.0608338937163353, -0.027768613770604134,
    0.02184438705444336, -0.08988659828901291, 0.011079393327236176, -0.05948863551020622, -0.017326733097434044, 0.028723333030939102, 0.0005901503609493375, 0.049809426069259644,
    0.00018710060976445675, 0.025677155703306198, -0.012004715390503407, -0.061545517295598984, -0.0004768980434164405, -0.010135102085769176, 0.05223427712917328, 0.0011635352857410908,
    -0.045833390206098557, -0.0257271658629179, 0.03270085155963898, 0.0063194711692631245, -0.01053563505411148, 0.023445289582014084, -0.013824806548655033, 0.0423252210021019,
    -0.005205338820815086, -0.05304861441254616, -0.008711878210306168, 0.07055371254682541, -0.03649706020951271, 0.061975762248039246, 0.01328304223716259, 0.04423696920275688,
    0.009811299853026867, -0.010985596105456352, 0.04016765579581261, -0.034940771758556366, 0.033764079213142395, -0.004305706825107336, 0.0007446917006745934, -0.03903520852327347,
    -0.03398304432630539, 0.0958242416381836, 0.04631457477807999, -0.0615236796438694, 0.00826415978372097, 0.045676108449697495, 0.03679526969790459, 0.022274071350693703,
    -0.03468725085258484, 0.05034822225570679, -0.09733782708644867, -0.0708632543683052, 0.08930635452270508, -0.06242670863866806, 0.04616617038846016, -0.012238772585988045,
    -0.019836261868476868, 0.012063286267220974, -0.02552049607038498, -0.027970049530267715, 0.05559016391634941, -0.004545285366475582, 0.01146449614316225, 0.04088989645242691,
    -0.030416909605264664, 0.07285740226507187, -0.08117803931236267, -0.04091768339276314, 0.0607878603041172, -0.05008964613080025, 0.0060729943215847015, 0.06112920120358467,
    -0.04800720885396004, 0.04094373807311058, -0.03835375979542732, -0.04344606772065163, 0.048147186636924744, -0.01202317327260971, -0.003168057883158326, 0.0005853501497767866,
    0.02530810609459877, 0.044815901666879654, -0.012010176666080952, 0.058681901544332504, 0.15000447630882263, -0.024441858753561974, 0.012356582097709179, -0.09417857974767685,
    -0.04190368950366974, -0.03315107524394989, 0.0129982465878129, 0.03439886495471001, -0.01869262382388115, 0.02640245296061039, -0.0006587866810150445, 0.07353828102350235,
    -0.018697015941143036, 0.06018491089344025, 0.008886699564754963, 0.02063434198498726, 0.05873536691069603, 0.03813641890883446, -0.022517725825309753, -0.028951730579137802,
    -0.001651432947255671, 0.025655623525381088, -0.0029492115136235952, 0.03943543881177902, 0.03199306130409241, 0.011433623731136322, -0.008799032308161259, -0.020073331892490387,
    0.005928154103457928, -0.007192125543951988, -0.07171010226011276, 0.0781722366809845, -0.018888583406805992, 0.04181862622499466, 0.02682848647236824, -0.030828822404146194,
    0.021395977586507797, 0.04316123574972153, 0.039674755185842514, -0.00912675354629755, -0.08006501197814941, -0.00218374514952302, 0.016850192099809647, 0.02222636342048645,
    -0.022648923099040985, 0.004957892000675201, 0.0037752152420580387, 0.033701058477163315, -0.09881547093391418, 0.016682254150509834, 0.0679808035492897, -0.018870823085308075,
    0.0353783443570137, 0.02312609739601612, -0.034123748540878296, 0.02942996844649315, -0.0456233024597168, -0.016992464661598206, -0.02355601266026497, 0.0024250007700175047,
    -0.017655346542596817, 0.05945207178592682, 0.030676279217004776, 0.01986653171479702, 0.042201410979032516, -0.061537567526102066, -0.027990009635686874, -0.13513174653053284,
    -0.021692870184779167, 0.037018612027168274, 0.03338766470551491, 0.008402001112699509, 0.014876327477395535, -0.06245160102844238, 0.07583814114332199, 0.008646211586892605,
    -0.010399229824543, -0.00431628804653883, -0.01761520840227604, 0.06776046007871628, 0.024373942986130714, -0.004530324134975672, -0.04355325549840927, -0.023371083661913872,
    0.049481071531772614, -0.09137491881847382, -0.000890657480340451, 0.006479410920292139, 0.022608937695622444, 0.03426475450396538, -0.06179278716444969, -0.08077999949455261,
    0.026727138087153435, 0.02001839317381382, -0.004899137187749147, 0.01967047154903412, -0.09654546529054642, -0.009878672659397125, 0.03755617141723633, 0.05597645416855812,
    0.004206166602671146, -0.009600728750228882, 0.04563084617257118, -0.012098187580704689, -0.009313412941992283, -0.03144916892051697, -0.015224792063236237, -0.014173564501106739,
    0.00548979127779603, -0.10024330019950867, 0.046597156673669815, -7.033411384327337e-05, 0.08065680414438248, 0.003906807862222195, -0.018779564648866653, 0.013915719464421272,
    0.022663310170173645, -0.028706464916467667, -0.1232159361243248, -0.006952056661248207, 0.10346528887748718, -0.0024181597400456667, 0.05837395414710045, 0.006526212207973003,
    -0.02000981755554676, 0.02617710642516613, -0.05980746075510979, -0.04439924284815788, -0.05710798129439354, 0.011832378804683685, 0.004863508976995945, 0.04460708051919937,
    -0.0009254316100850701, -0.05703413486480713, -0.029328463599085808, -0.056928686797618866, 0.044135306030511856, -0.046826645731925964, -0.015885882079601288, -0.0004538885841611773,
    -0.009092382155358791, -0.012812822125852108, -0.023816803470253944, -0.06100901961326599, 0.024265803396701813, -0.02334081381559372, -0.0007455042796209455, -0.05541270226240158,
    0.005808454938232899, 0.05904941260814667, -0.005342607386410236, -0.048137396574020386, 0.06795287132263184, -0.002810560166835785, -0.03164120018482208, 0.007464301772415638,
    -0.05132158473134041, -0.00014950749755371362, -0.017668988555669785, 0.08823095262050629, -0.04859772324562073, 0.06486711651086807, 0.017976082861423492, -0.009697974659502506,
    -0.0008380484650842845, 0.051033128052949905, -0.026499571278691292, -0.003915612120181322, 0.08045533299446106, -0.022698916494846344, 0.027623748406767845, -0.064456045627594,
    0.01796797849237919, -0.09044831246137619, -0.09726949781179428, 0.028081173077225685, 0.01171006727963686, 0.004944223910570145, -0.0065599060617387295, 0.012162990868091583,
    -0.018726671114563942, -0.07181913405656815, -0.02680477686226368, -0.08721788972616196, -0.014837920665740967, 0.05798695981502533, -0.00021628323884215206, -0.0664849653840065,
    0.027127284556627274, 0.08962200582027435, -0.018244760110974312, 0.023878222331404686, -0.0002029347961070016, -0.008983471430838108, -0.024506544694304466, 0.09589952975511551,
    0.008175767958164215, -0.013111846521496773, 0.01053645834326744, 0.1043110191822052, -0.04104812815785408, 0.014453621581196785, -0.020952939987182617, -0.06595306098461151,
    -0.032729219645261765, -0.008290252648293972, 0.09239593148231506, 0.010246993973851204, -0.0062058912590146065, -0.015252267010509968, 0.006556034553796053, 0.013887422159314156,
    0.0011851656017825007, 0.006442678160965443, 0.052666228264570236, 0.03464246541261673, -0.027845349162817, 0.03852400183677673, 0.08314698189496994, -0.0017978600226342678,
    0.005885342601686716, -0.042768433690071106, -0.02557666040956974, 0.015831593424081802, -0.022916290909051895, 0.03346748277544975, 0.021450206637382507, -0.022733405232429504,
    0.0014385443646460772, -0.00038559510721825063, 0.010474863462150097, 0.03169345483183861, 0.07411567866802216, -0.0029964949935674667, 0.030433760955929756, -0.0013515421887859702,
    -0.017319267615675926, -0.04983837902545929, -0.027004681527614594, 0.02969474345445633, -0.01729515753686428, -0.02524327114224434, 0.01516531128436327, 0.06703495234251022,
    -0.02414291724562645, 0.015940232202410698, 0.11785123497247696, 0.026253126561641693, 0.055993787944316864, 0.0019061460625380278, 0.010569341480731964, 0.023949718102812767,
    -4.060313949594274e-05, -0.027727164328098297, -0.0020311945118010044, -0.006732172332704067, -0.050181400030851364, -0.015097761526703835, 0.0036575407721102238, -0.022983813658356667,
    -0.054894205182790756, 0.08121701329946518, 0.025385349988937378, 0.046576183289289474, -0.019683582708239555, -0.038288842886686325, 0.0454951748251915, -0.014765331521630287,
    0.015483940951526165, 0.024951273575425148, -0.05010056868195534, 0.01740293763577938, 0.003312442684546113, 0.0010096055921167135, -0.003449756419286132, 0.10265786200761795,
    -0.03074522875249386, -0.1433253139257431, -0.017925426363945007, 0.027757158502936363, 0.025752011686563492, 0.014324878342449665, 0.07372742891311646, -0.04878846928477287,
    0.009831230156123638, -0.02016102895140648, -0.057859454303979874, 0.019824611023068428, -0.04497634246945381, -0.021500706672668457, 0.04014114663004875, 0.05221002548933029,
    -0.012681238353252411, -0.03977791965007782, -0.00020252807007636875, -0.0057353731244802475, -0.08643413335084915, 0.04842282831668854, 0.01786365918815136, 0.009857077151536942,
    0.0018968998920172453, 0.040255170315504074, 0.04067229479551315, 0.00606443639844656, 0.018226968124508858, 0.00310552679002285, -0.03916899487376213, -0.06514722853899002,
    0.00889545027166605, 0.01611613668501377, 0.015316946431994438, 0.016251645982265472, -0.10467591136693954, -0.07421066612005234, -0.05496010184288025, 0.054404616355895996,
    -0.0311625637114048, 0.08103201538324356, -0.0006922680186107755, 0.019249064847826958, -0.06632596999406815, -0.08134075999259949, -0.08465220779180527, 0.00813017226755619,
    0.023630693554878235, -0.016235515475273132, 0.012016160413622856, -0.015328421257436275, -0.011102048680186272, -0.006174599751830101, 0.05926740542054176, 0.07018008828163147,
    0.05434729903936386, 0.010049667209386826, 0.008176583796739578, 0.007529937196522951, 0.004748726263642311, 0.024288827553391457, -0.03680889680981636, -0.02034357190132141,
    0.06888703256845474, 0.04305023327469826, -0.004571307450532913, 0.040327560156583786, -0.03985239937901497, 0.048172544687986374, 0.02470618672668934, -0.013262610882520676,
    0.06480306386947632, -0.0022279913537204266, -0.054241716861724854, 0.08566375076770782, 0.05145730450749397, -0.024269767105579376, 0.022141117602586746, -0.02654920145869255,
    -0.053483836352825165, -0.009742178954184055, 0.015608307905495167, -0.08352638781070709, -0.03184878081083298, 0.006446880288422108, -0.010993183590471745, -0.0219220370054245,
    -0.012413490563631058, 0.06993584334850311, -0.015460466034710407, -0.0035837467294186354, 0.015321450307965279, 0.001819770666770637, 0.005672851577401161, 0.02392234280705452,
    0.0074871317483484745, 0.0017686461796984076, -0.025830792263150215, 0.024541718885302544, 0.03607365861535072, 0.008112707175314426, 0.004929079208523035, -0.005609563086181879,
    0.041871342808008194, -0.022869296371936798, 0.007863672450184822, -0.0019226721487939358, 0.05127492547035217, 0.004579095169901848, 0.09208184480667114, -0.03276550769805908,
    0.14121465384960175, 0.07889436185359955, -0.021403998136520386, -0.003686925396323204, 0.03401125222444534, 0.06321853399276733, 0.04679146036505699, 0.01837402768433094,
    -0.009630554355680943, -0.03307761996984482, 0.09998127073049545, 0.04318694397807121, 0.07057677954435349, -0.1028921902179718, -0.005225125700235367, 0.02639833651483059,
    -0.0660465806722641, 0.05312560126185417, 0.04494030773639679, -0.04558597505092621, 0.005723271053284407, 0.0009971988620236516, 0.009398956783115864, 0.022951986640691757,
    0.04682779312133789, 0.021760622039437294, -0.00877754669636488, 0.014660839922726154, -0.03475705534219742, 0.02775452844798565, -0.026401523500680923, -0.012886716052889824,
    -0.008423788473010063, 0.003313923953101039, -0.031982265412807465, 0.0052125100046396255, 0.004305057227611542, -0.007670742925256491, -0.00417684018611908, 0.07105501741170883,
    0.01275611761957407, -0.04043729603290558, -0.0020108744502067566, 0.05968507379293442, -0.04490458965301514, -0.002585752634331584, 0.11196843534708023, 0.058674491941928864,
    0.011569954454898834, -0.004343156702816486, -0.03584056347608566, 0.030197864398360252, 0.041197456419467926, 0.06777366250753403, 0.050903189927339554, 2.4299446522491053e-05,
    0.017971042543649673, -0.029583711177110672, 0.004989622626453638, -0.06405868381261826, 0.03784865513443947, 0.025721823796629906, 0.06261560320854187, -0.06931695342063904,
    -0.08290953934192657, 0.02866354025900364, -0.00716412952169776, 0.00923339556902647, -0.0545952245593071, -0.017092762514948845, -0.02887790836393833, -0.021418258547782898,
    -0.004697043914347887, -0.002605237765237689, -0.015509696677327156, 0.08355039358139038, -0.024173200130462646, -0.023282324895262718, -0.0034475955180823803, 0.023241285234689713,
    0.009503242559731007, -0.01643860898911953, 0.02945784106850624, 0.010646351613104343, 0.03592011332511902, -0.021513046696782112, -0.0294650811702013, -0.010142521001398563,
    -0.04576672241091728, 0.041020117700099945, -0.04042533040046692, -0.0755978375673294, 0.0704864114522934, 0.04591483995318413, -0.034436341375112534, 0.07492910325527191,
    0.07989784330129623, 0.007036902476102114, 0.0782443955540657, 0.10440154373645782, 0.00019138763309456408, 0.036210592836141586, 0.0025537677574902773, 0.04318206384778023,
    0.02080569602549076, -0.08296311646699905, 0.011502854526042938, -0.09243115037679672, 0.034494929015636444, -0.02256414294242859, -0.012952407822012901, 0.025022460147738457,
    -0.006694768089801073, -0.024990489706397057, -0.0825447291135788, -0.0678214281797409, 0.04545876011252403, -0.030418897047638893, 0.07646885514259338, -0.017679832875728607,
    -0.06814192235469818, 0.028097668662667274, -0.04968191310763359, -0.011585184372961521, -0.07394448667764664, -0.002878734143450856, -0.1338098645210266, 0.05254802480340004,
    -0.093193918466568, -0.1385958194732666, 0.004603810142725706, -0.049198973923921585, -0.02231629006564617, -0.008962035179138184, -0.020605670288205147, -0.010712743736803532,
    -0.038169972598552704, 0.03828093409538269, -0.07069631665945053, -0.03109910897910595, -0.011503798887133598, 0.05565299093723297, -0.06684356182813644, -0.05940922349691391,
    0.06135183572769165, 0.00923993717879057, -0.03994591161608696, -0.002877135993912816, 0.05387686938047409, -0.02525351755321026, -0.08170560747385025, -0.023823175579309464,
    -0.022314276546239853, -0.002095266245305538, 0.013027697801589966, 0.052951961755752563, -0.05330955237150192, 0.04022457078099251, 0.0051048509776592255, -0.024750759825110435,
    0.02619103156030178, 0.07074040919542313, 0.01720081828534603, -0.0044883377850055695, 0.01681390032172203, 0.04364469274878502, -0.037291038781404495, -0.07524114847183228,
    -0.0009307796135544777, 0.005077208857983351, -0.021670663729310036, 0.0008694865391589701, -0.024529220536351204, 0.0053773666732013226, 0.0012794226640835404, 0.010471120476722717,
    0.0002838161017280072, 0.018217651173472404, 0.006587926764041185, -0.011527858674526215, -0.021377015858888626, -0.00866667926311493, 0.031877871602773666, 0.01550384983420372,
    -0.004442459437996149, 0.029773924499750137, -0.005860483273863792, -0.017201319336891174, 0.01796780340373516, -0.09464719146490097, 0.010346619412302971, -0.00880445260554552,
    -0.0429747998714447, 0.011846422217786312, 0.005685647018253803, -0.07305695116519928, -0.0006552834529429674, -0.001400973997078836, -0.005297186318784952, -0.010366933420300484,
    0.02960001304745674, 0.02006206475198269, 0.010807128623127937, 0.012187758460640907, -0.08070942759513855, 0.00025852874387055635, 0.0031988725531846285, -0.0019429164240136743,
    0.016975287348031998, 0.009561172686517239, -0.012030821293592453, 0.016940785571932793, 0.028563566505908966, -0.003998971544206142, 0.04445919767022133, 0.017573177814483643,
    0.006864351220428944, 0.003120481502264738, -0.005023843143135309, -0.003234890988096595, 0.016116676852107048, -0.01089145801961422, 0.011928563937544823, 0.016034027561545372,
    0.008177373558282852, 0.0009722642716951668, 0.0026094343047589064, 0.009893164969980717, -0.004361447412520647, -0.012549592182040215, -0.004988865926861763, 0.005468236282467842,
    -0.003477859776467085, 0.0073592388071119785, 0.01765824481844902, 0.027498239651322365, 0.021676233038306236, 0.015719344839453697, -0.032014280557632446, -0.012285132892429829,
    -0.000308048416627571, -0.005667061544954777, 0.012651794590055943, 0.01687661185860634, 0.053284984081983566, -0.003944283351302147, -0.018617847934365273, 0.0163813978433609,
    -0.0035498877987265587, 0.03294454514980316, -0.02321683242917061, -1.0555386543273926, -0.006373887415975332, 0.0069042835384607315, -0.026844751089811325, -0.006194438319653273,
    -0.003975834231823683, -0.02015039697289467, -0.002298104576766491, 0.009698961861431599, 0.03991805016994476, -0.02220175974071026, -0.011384321376681328, 0.014857850037515163,
    -0.009291430935263634, 0.02093486301600933, 0.0008157527190633118, 0.00043948704842478037, -0.00016589426377322525, -0.003500918857753277, -0.019634151831269264, -0.00503513403236866,
    0.0057211932726204395, -0.012202422134578228, 0.0042656282894313335, -0.004262568894773722, 0.005318222567439079, -0.006068032700568438, -0.011167109943926334, 0.01417454332113266,
    -0.0036279023624956608, -0.0021132351830601692, -0.004509821999818087, -0.008971434086561203, 0.010704734362661839, -0.03690730407834053, -0.0012483333703130484, 0.01707645133137703,
    0.016255727037787437, -0.4755660891532898, 0.019646476954221725, 0.0025818506255745888, -0.02213253825902939, -0.034371282905340195, -0.01736489124596119, 0.036811813712120056
};


#endif /* USE_WEIGHTS_FILE */

#ifndef USE_WEIGHTS_FILE

#define WEIGHTS_conv1_bias_DEFINED
#define WEIGHTS_conv1_bias_TYPE WEIGHT_TYPE_float
static const float conv1_bias[128] = {
    0.09537679702043533, 0.07275418192148209, -0.12045622617006302, 0.191632479429245, 0.09881845116615295, -0.8059209585189819, 0.051219064742326736, 0.26225364208221436,
    0.16800417006015778, 0.4009068012237549, -0.2909224331378937, 0.12511272728443146, 0.16848468780517578, -0.25028619170188904, 0.10014481097459793, -0.15417343378067017,
    -0.1239333525300026, 0.11667945235967636, 0.1183636337518692, 0.22979970276355743, -0.08728493750095367, -0.5438442230224609, -0.0332515574991703, 0.21428163349628448,
    0.08935315907001495, 0.030700303614139557, -0.05684885382652283, -0.08571984618902206, 0.09395923465490341, -0.06700779497623444, -0.18197347223758698, -0.017289428040385246,
    0.07203050702810287, -0.1881498545408249, 0.18110612034797668, 0.1768191009759903, -0.33031874895095825, -0.015522344037890434, -0.0640968605875969, 0.233056902885437,
    0.042948655784130096, 0.14121653139591217, 0.1835971623659134, -0.0992937833070755, -0.00860565435141325, -0.05664103478193283, -0.3291143774986267, -0.20049811899662018,
    -0.009488879702985287, -0.05930410325527191, 0.06524033099412918, -0.20331797003746033, -0.1945858895778656, 0.16073979437351227, -0.10015979409217834, -0.07971137762069702,
    0.246194526553154, 0.028630100190639496, 0.20534519851207733, 0.0008666709763929248, -0.0714971050620079, -0.2668875455856323, 0.03632215037941933, 0.4715617001056671,
    -0.6672757863998413, -0.0508718304336071, 0.24516580998897552, 0.15479443967342377, -0.09423503279685974, -0.038831695914268494, -0.1599247306585312, -0.19909635186195374,
    -0.3782906234264374, -0.27652016282081604, -0.3239835500717163, 0.37677937746047974, 0.13842272758483887, -0.17582795023918152, 0.104879230260849, -0.00573438685387373,
    0.2773270308971405, -0.16717690229415894, 0.19012880325317383, -0.4031441807746887, 0.10516821593046188, 0.40321171283721924, 0.19854138791561127, -0.22538131475448608,
    0.12660615146160126, -0.078760527074337, -0.3209674060344696, 0.01343380007892847, -0.23670026659965515, -0.15031088888645172, 0.05968106910586357, 0.3031329810619354,
    0.0586412250995636, -0.1983572244644165, -0.41392141580581665, -0.020802034065127373, 0.1543201059103012, 0.08042624592781067, -0.032153792679309845, 0.4491429626941681,
    0.15722382068634033, -0.46728286147117615, -0.17557282745838165, -0.15783819556236267, 0.05536988750100136, -0.02500525489449501, -0.01371042151004076, 0.00968928262591362,
    -0.6607820987701416, 0.8265531659126282, -0.3324108421802521, 0.08810462057590485, 0.1806108057498932, -0.15173602104187012, -0.44464948773384094, 0.06213320046663284,
    0.175425723195076, 0.4660654067993164, -0.09136167168617249, 0.6458766460418701, 0.027867401018738747, 0.09492262452840805, 0.11769095808267593, -0.09004982560873032
};


#endif /* USE_WEIGHTS_FILE */

#ifndef USE_WEIGHTS_FILE

#define WEIGHTS_conv2_weights_int8_DEFINED
#define WEIGHTS_conv2_weights_int8_TYPE WEIGHT_TYPE_int8
static const opus_int8 conv2_weights_int8[147456] = {
    14, -44, 3, -28, 24, 23, -27, 20,
    17, 13, -5, -40, -20, 3, -1, -24,
    -8, -14, -9, 14, -17, -9, 30, 15,
    -7, -1, 0, 6, -15, -17, -5, -22,
    -22, 9, -7, -17, 5, 14, 3, 23,
    12, 8, 2, 12, -16, 8, 20, -24,
    8, -5, 9, 8, -24, -12, -25, -4,
    3, 13, 9, 1, 0, 10, 15, -16,
    -24, -9, -9, -23, 3, -10, 14, -19,
    -13, -16, -25, 41, 28, 17, 16, 23,
    18, 5, -21, -21, 9, -1, -3, -14,
    3, -1, -6, 2, 3, -5, -13, 12,
    15, 40, -36, -52, 36, 9, 13, 1,
    -23, 1, -5, -42, -24, -22, 31, 7,
    -9, -27, 7, -6, -30, 1, 38, 18,
    -2, 8, 2, 3, 5, -12, 7, 10,
    -4, 4, -7, -1, 13, 45, 28, 4,
    39, 39, 30, 41, 27, -2, -12, -2,
    -30, -1, 23, -13, -5, 25, 12, -18,
    -4, 4, 0, 2, -4, 33, 0, -18,
    0, 11, -51, 13, 13, -13, 13, 3,
    29, 18, 7, 17, -1, 23, 18, -13,
    1, -9, 2, -1, 33, 10, -7, -34,
    2, 1, -8, -8, -7, 1, 28, 4,
    14, 16, 41, -15, 3, -71, -22, -14,
    -23, -30, 27, 8, -12, -12, 27, -30,
    37, 5, 5, -24, -4, 4, -4, -32,
    -3, -2, 13, -8, -19, -4, -12, 9,
    -6, -21, 33, 27, -8, -1, -9, -33,
    -18, -16, 0, 22, -32, -1, -6, -8,
    -4, 17, 16, -26, 8, 1, -31, 15,
    4, -3, -5, 2, 24, 16, -41, -11,
    3, 12, 23, 28, 25, -20, 33, 21,
    -2, -29, 24, -54, -6, 18, -4, -7,
    2, -26, 5, 12, -28, -32, 30, 2,
    4, -2, -16, 4, -6, -25, -12, 5,
    -13, 2, 1, 22, 17, -12, -21, 19,
    11, 40, 12, -4, 1, -22, -4, 2,
    29, -18, 27, 5, 19, -27, 48, 48,
    0, -11, -13, -7, -28, 25, 9, 18,
    -11, 10, 29, -11, 48, 25, 1, -1,
    -35, -49, -8, 4, 6, -14, -8, -16,
    -1, 8, 4, -17, -32, 19, 37, -6,
    1, 7, -8, -5, -1, 27, 5, -6,
    18, -13, 27, -31, -3, -23, 14, -8,
    -12, -20, -27, 8, 9, -9, -7, -2,
    10, 16, -34, -2, 0, -43, 0, -9,
    8, 2, 2, 0, -4, -5, 0, -21,
    -10, 6, -1, 9, 8, 65, -4, 45,
    7, -41, -17, -5, 7, -35, -19, -4,
    -25, 2, 39, -29, 20, -18, -38, -11,
    -15, -5, 1, 3, 21, -26, -4, -10,
    -23, 6, -24, 41, 21, -31, -10, -43,
    -4, 26, 18, 32, 4, -9, -8, 5,
    2, 21, -21, 9, 11, -10, 33, 10,
    1, 1, 6, 16, -16, -36, 22, -12,
    15, 13, -5, 29, -1, -30, 16, -8,
    69, 14, 21, 18, -5, 9, -8, 22,
    25, -5, -3, 5, -29, 64, -18, -3,
    -4, 1, 8, 0, -19, -1, 23, -3,
    18, 20, 9, -12, -4, 0, 54, -30,
    -31, 1, -38, 47, 10, -11, 20, -14,
    -22, 16, 20, 35, -17, 30, 54, -18,
    -13, 9, -4, -1, -10, 6, -9, -12,
    -14, 53, -4, -34, -31, -3, -10, 10,
    27, 39, -26, -52, -9, -12, 1, -12,
    21, 6, -20, -2, 3, -10, 23, 2,
    -1, -5, -2, -3, 27, 5, -6, 22,
    8, -27, -1, -31, 17, -16, -3, 3,
    -40, -17, -24, 4, 27, -11, 10, 1,
    17, -42, 8, -8, 21, 10, 9, 51,
    -1, 2, -11, -10, -42, -16, -3, 0,
    -7, 62, -8, -12, -26, -5, -14, -18,
    -3, 4, -33, -10, 23, 30, 20, 2,
    -35, -31, -5, -12, -4, -17, -18, -1,
    7, 5, -9, -4, 12, -7, -15, 8,
    39, -8, -23, -26, 0, 44, 24, -25,
    8, 29, 3, 10, -7, -13, 5, -13,
    12, -22, -11, -5, -21, -16, 2, 14,
    -6, 1, -11, 3, -50, -3, 41, -27,
    2, -10, -28, -1, -72, -17, 20, -3,
    -24, 1, 28, -5, 1, -3, 34, 15,
    32, -19, 0, 0, 4, 8, -8, 9,
    -8, 0, 4, -1, -32, -10, 13, -25,
    14, -3, -4, 13, 34, -3, -13, -48,
    -9, -33, -37, 9, 6, -22, 28, 20,
    -23, 1, 17, -7, -19, -13, -5, -35,
    -10, 1, 3, 8, -10, -2, 19, 14,
    0, 3, 20, 16, 26, -1, -22, 12,
    3, 12, -74, -5, -11, 22, -4, -6,
    17, -4, 11, 23, -11, 8, -3, -24,
    -4, 10, 6, -5, 59, -20, -4, 10,
    7, -3, -14, -9, 1, 36, 45, 36,
    -23, -6, 1, 23, -13, 26, 2, 10,
    -1, -16, 1, 2, -29, 4, -3, 20,
    0, -4, -9, 0, 17, -67, 25, 12,
    0, 8, 7, 27, 38, -54, 38, 47,
    -11, 17, 34, 0, 10, -36, 37, 25,
    -13, -22, -1, 3, 31, 2, 12, 34,
    -3, 12, 6, 1, -20, 48, -17, -12,
    -35, -21, 17, -2, -4, 28, 12, -8,
    24, -13, -10, 19, -15, -1, -32, -16,
    -2, -3, -3, -2, -51, -1, 17, 32,
    -3, -3, 0, -7, 5, -4, 37, -7,
    -22, -5, 5, 14, 3, 13, 0, 21,
    -26, -39, -40, 8, 20, 27, 5, 3,
    4, -17, -2, -29, 23, -4, -5, 10,
    -4, -1, -5, -1, -2, -12, 9, -5,
    -35, -15, 28, -8, 13, -14, -45, -17,
    -20, 28, -54, 62, -3, -8, -21, -23,
    -8, -1, -12, -14, -5, -17, 17, 20,
    6, -6, 12, 2, 0, -11, 16, 27,
    20, -23, 12, -6, -3, 15, -40, -8,
    22, -34, 10, 17, 65, -57, -1, -4,
    8, -12, -6, -16, 2, 19, -8, 0,
    1, -12, -7, 5, 4, -16, -14, 26,
    16, -35, 12, -2, -8, 13, 2, -13,
    54, 40, 39, -6, -48, -4, 24, -4,
    -11, -25, 6, 11, -9, 21, -30, -19,
    3, -6, 4, -9, 25, -19, 14, -29,
    4, 8, 59, -36, -5, -8, -4, 21,
    -7, 1, -12, 9, -17, -11, 0, -3,
    20, 8, -10, 6, -46, -23, -19, 3,
    -3, -4, -6, -4, 8, 6, 20, -7,
    26, 24, -38, -21, -14, -16, 18, -39,
    53, 24, -11, 16, 35, -15, -27, 9,
    0, 9, -17, -1, -36, 17, 15, -8,
    8, 8, -6, 9, 3, 5, -13, 26,
    -5, -4, -13, 7, -26, 70, -2, -3,
    23, -12, 24, 68, 31, -24, -23, -18,
    -4, -10, -9, 21, 3, -27, 16, -24,
    -16, -8, -2, 8, -24, -11, -22, 13,
    24, 34, 18, 23, -18, 15, -18, 19,
    20, 1, 5, -40, 5, -10, -9, -5,
    -15, -5, -1, -22, 18, 0, 1, 0,
    1, 19, 4, 5, 10, 11, 16, 16,
    -12, -2, -5, 3, -11, 1, 62, -43,
    -27, 15, -9, 52, 0, -13, 16, 42,
    26, -22, -13, -2, -22, 36, -34, 5,
    -3, -3, 4, 3, 46, -27, 24, 4,
    29, 35, 21, 59, 21, 27, -52, -62,
    -44, 96, 7, 35, -26, -11, 12, -20,
    -37, -31, 0, 8, 46, -12, 0, 36,
    2, 4, -1, 17, -3, 11, 1, 5,
    -18, -3, 14, 22, -33, 10, -34, -20,
    9, -6, 14, -62, 14, -29, 22, -10,
    -6, 13, 15, 0, -7, 27, 6, 6,
    -1, 2, -1, -1, -4, 74, 9, 28,
    32, -21, 8, -11, 51, 26, -11, -9,
    -98, -28, 46, 5, -18, 2, -3, 2,
    -26, 8, 8, -6, -34, -18, -63, 7,
    -4, -6, -15, -10, -1, -31, 34, 18,
    53, -14, 45, -9, -62, 36, -5, 4,
    2, -58, 3, 11, 8, -8, 10, -16,
    -11, -20, -10, -21, -52, -8, 17, -44,
    7, 1, -1, -1, -49, -10, 10, -7,
    41, 7, -6, 25, -38, -12, -46, 24,
    25, -48, 79, -105, -39, 8, 28, -5,
    -7, -9, -16, -25, 40, -7, -9, -20,
    -8, 1, 5, 7, -7, 10, -30, 13,
    -18, -6, 14, 30, -46, 59, 8, -10,
    39, -14, -15, -1, 4, -6, 10, 14,
    25, -21, 30, -35, 38, -36, 47, -18,
    -5, 6, -4, -9, 18, 1, -15, -35,
    -64, -32, -14, -17, 26, -23, 34, 45,
    -14, 6, -79, 10, 30, -18, 16, -22,
    16, -10, -43, 14, -17, -8, 4, 45,
    23, -6, 3, 1, -31, -15, -16, 43,
    5, -7, -33, -20, 10, -7, 16, -18,
    -23, 33, 5, 29, -27, -25, 10, -17,
    -9, 5, 12, -17, -17, -44, 14, 4,
    7, 0, -5, 10, -34, 17, 8, 3,
    -8, 43, 3, -33, 37, -25, -12, 7,
    -24, -7, 83, -48, 7, -18, -9, -33,
    -6, -11, -6, -38, 17, 0, -15, -33,
    7, -6, 10, 1, 32, -15, 5, 4,
    -16, 26, -29, -2, 34, 34, 0, 31,
    -28, 44, 30, -48, 3, -17, 10, 23,
    -22, 11, 35, -32, -17, 40, 21, 13,
    4, -4, 4, 15, 28, -17, 2, 16,
    -1, -8, 7, 66, -13, 72, 3, -4,
    71, -99, 23, -72, 15, 13, -5, -22,
    10, -7, 30, -15, 9, 13, -21, 5,
    -4, 12, -3, 6, -42, -11, 49, 2,
    -8, -4, -12, -46, 22, -9, -22, -10,
    -23, -6, 2, -66, -20, -20, 5, 22,
    -26, -15, 23, -16, 45, 11, -43, -30,
    6, 8, 2, -1, 16, 10, 44, 16,
    57, 16, 9, 45, -22, -23, -58, -6,
    29, 1, 43, -35, 14, -9, 5, -15,
    13, 18, 22, 7, -18, 8, -21, -26,
    -5, 4, -13, -5, 16, 34, 10, -42,
    8, 0, 15, 1, 0, 57, -25, 5,
    28, -22, -8, -1, 1, 10, 17, -22,
    -6, 11, -20, 19, -19, -47, -18, 66,
    12, -1, 0, -4, -4, 1, 49, 22,
    32, 25, 7, -67, -24, 5, -23, 32,
    -4, -27, 42, -11, -4, -15, -13, -27,
    -8, 37, -21, -11, 76, -15, -32, 41,
    -4, -3, -1, -2, -26, 7, 13, 29,
    20, 1, -10, -2, -41, -11, -32, -1,
    47, -23, 10, 8, 13, 35, 30, 3,
    5, 12, 16, -18, 26, 9, -26, 1,
    12, 17, 3, -4, 13, -10, -13, 7,
    -6, -38, 7, 37, -15, -65, -27, 78,
    9, 77, 1, -48, 3, -3, 14, 23,
    16, 29, -7, -12, -39, 9, -5, -61,
    1, -11, -3, -9, -17, -3, 37, -55,
    33, -12, 10, -10, 10, 55, 68, -2,
    -20, -10, -59, 3, 11, 12, -5, 19,
    5, 5, -11, 7, -36, -25, 78, 5,
    -2, 9, -3, 2, -9, -24, 12, -23,
    21, 10, -6, -59, 20, -20, -39, -13,
    36, 4, -20, 37, -13, 19, 0, 11,
    -26, -5, 24, 8, 22, -71, 11, -33,
    -5, -9, 4, 2, -22, 1, 21, 32,
    -18, -2, 25, -21, 31, -21, -19, 5,
    19, 11, -3, 5, -3, -12, 19, -12,
    4, -11, 1, -44, 0, 22, 41, 30,
    4, -2, 10, 7, 20, -11, -3, -12,
    65, -36, 30, 12, -9, 1, 41, 19,
    41, -59, 5, -19, 7, 15, -15, -7,
    -5, 8, 9, -9, -32, -3, -20, 21,
    8, 0, -4, 3, 14, -64, -5, 23,
    -15, 51, 7, 14, -42, 17, 34, -18,
    38, -59, 23, 19, -2, -35, 55, 34,
    -1, -29, -6, 2, -28, -17, -32, 75,
    6, -8, -4, -6, -13, 15, 2, -16,
    -35, -17, -2, 1, -12, -37, 41, -30,
    -23, 15, 52, -6, -41, 30, -20, -15,
    -24, 30, 18, -13, -31, 5, -3, 14,
    13, 0, -6, 4, -24, -12, 19, 19,
    -9, -23, 14, 12, 39, 15, -40, 36,
    42, -5, -3, 8, 56, 27, 33, 11,
    29, 11, 18, 1, -2, -18, -46, 29,
    0, -3, -7, 7, 8, 9, -40, -8,
    30, 15, -11, 16, -13, -20, -6, -5,
    71, 23, 36, -22, 15, -10, -1, -11,
    0, -7, 5, -28, -32, 21, 14, 11,
    1, 6, 9, 11, -2, -3, 10, -15,
    10, -1, -4, 6, 22, -25, -5, 9,
    10, 1, 33, -22, 54, -44, 30, -2,
    -3, -12, -7, -1, -14, -1, -15, -27,
    4, -10, 15, -3, 2, -36, -28, 23,
    8, 7, -11, -6, 47, 52, -34, -36,
    -26, -14, 16, 27, -25, -13, 31, 38,
    -19, -23, 14, 4, -22, -42, 22, 5,
    1, 1, 18, 0, 46, -24, -25, -66,
    19, 17, -27, -36, -33, 2, -23, 20,
    -2, -5, 48, 12, 4, -5, 14, -12,
    -32, -11, 26, 8, -45, 5, 37, -2,
    -1, -30, -5, -10, 19, 22, 19, -18,
    38, 42, 1, 52, -47, -16, 37, -3,
    14, -27, 16, -25, 7, 3, -19, 7,
    7, -3, 11, 28, -54, 27, 17, -44,
    -7, -4, -8, -7, -24, -3, -12, 3,
    19, 59, 26, 50, -18, -53, 25, -19,
    18, 36, -7, -8, 43, 3, 3, -26,
    -102, 4, -22, -26, 51, 1, -50, -26,
    -17, -40, -12, -19, -45, -18, -20, 26,
    12, -23, -59, -40, 11, 67, 42, 3,
    -11, -23, 23, 6, -27, -8, -74, -43,
    4, -28, -62, -25, -76, 6, -26, -30,
    21, 13, 16, -15, 9, 22, 23, -5,
    53, -29, 24, 18, -94, -7, 18, 21,
    -12, -43, 6, -82, 36, -33, 5, 65,
    -48, 19, 43, 34, 1, -32, 5, 23,
    3, -24, 27, -4, 52, -56, 11, 18,
    33, -71, -21, -15, -36, -75, 57, 51,
    -10, -54, -17, -13, -15, -16, 2, -3,
    -4, 18, 15, 56, -14, -34, -43, -8,
    -4, 22, -35, 26, -25, 38, -15, 13,
    -21, 22, -69, 34, 6, -88, 68, 16,
    -27, -27, -41, 38, 78, -6, 15, 11,
    -4, -9, -15, 50, 53, -1, -30, 2,
    45, -13, 32, 1, -32, 127, 15, 0,
    80, 19, -42, -53, -79, 22, 23, 20,
    97, 17, -53, -13, -45, 22, -15, -8,
    97, 32, -27, 11, 37, 46, 27, -19,
    -30, -8, -15, -14, 38, -5, 35, -9,
    -50, 25, -95, -34, 36, -8, 35, -40,
    -3, 92, -6, -51, 4, -15, 5, -9,
    -43, -3, -41, 50, 77, 27, -26, 68,
    -15, 6, -6, 52, -32, 14, 41, 9,
    -33, 18, 62, -8, -14, 17, 127, -6,
    -28, 41, -47, 42, -59, 21, 37, -43,
    7, -8, -45, 31, -50, -30, 22, 73,
    -29, 4, 14, -12, -14, 13, 65, -14,
    2, 102, 61, -40, -99, 63, -31, 49,
    -100, -4, 7, -5, 57, 12, 8, -13,
    -33, 23, 40, -45, 17, -4, -32, 11,
    -18, 17, -15, -29, -4, -29, -30, -37,
    21, 12, -53, 20, -34, 36, 18, -26,
    38, -61, 63, -76, 101, -44, 33, -37,
    -11, 19, 42, -23, 7, -12, -67, -33,
    102, 6, 34, -18, 3, -4, -32, 54,
    -23, -21, -9, -4, 18, -33, 28, 14,
    91, 16, -13, -7, -48, -56, 24, -53,
    27, -37, -4, -30, 22, 1, -31, 33,
    -26, 7, -14, 26, -32, 48, -6, 28,
    -45, -20, -4, -42, -36, -44, 62, 60,
    48, 11, -82, -28, -10, 12, 19, -81,
    -5, 45, -19, 43, -27, 8, 10, 55,
    -10, 2, 43, 2, 53, -49, 18, 9,
    -6, -35, 59, -34, -25, 35, -62, -50,
    54, 0, -40, 76, 16, 12, 75, 43,
    80, -26, -29, 99, 14, -84, 25, -7,
    2, 19, 4, -8, 47, 17, -2, 25,
    52, -17, 31, -58, -23, -22, -60, -22,
    -83, 111, -36, -14, 6, 69, -7, -20,
    -27, 54, 11, 14, -28, -10, -39, 15,
    8, 38, 6, 29, -64, -22, 79, 16,
    -13, -10, -21, -13, 27, 14, 25, -44,
    -43, -49, 7, 76, -45, -10, -19, 22,
    -29, -28, 29, 19, -1, -95, 1, -14,
    -13, -14, -18, 2, 22, 11, 57, -1,
    23, 15, 7, 29, 4, -13, -46, 49,
    13, -2, -40, 6, 15, 0, -10, -14,
    16, 12, -48, -17, 9, 2, 5, 21,
    29, 0, 8, -1, 3, 42, 80, -45,
    -3, -31, 34, 21, 36, -8, 49, -17,
    -27, -3, 83, -5, 10, 18, -28, -1,
    4, -4, 14, -2, 32, -8, 55, -65,
    16, 0, 4, -11, -32, -13, 43, 38,
    -31, -35, -31, 65, 9, -5, -15, 12,
    -19, 34, -58, 39, -10, 40, -3, 14,
    -23, 68, -39, 24, 6, 42, 51, -53,
    -52, -31, 38, -1, -22, 29, 11, 24,
    40, 60, 25, -6, -10, 50, 27, -3,
    -21, -49, -33, -2, 23, 41, 41, -7,
    43, 39, -8, 2, 63, -15, 32, -35,
    50, -1, 31, 4, -22, -24, -7, -21,
    19, 33, 13, 13, 34, -78, -18, 4,
    26, -99, -63, 11, 18, -13, -14, 68,
    15, 26, -13, 33, 23, -3, -29, -26,
    -18, -15, 3, -4, -28, 8, 20, -67,
    -36, 39, 3, -6, 18, -66, -92, -31,
    53, 13, -24, -35, 10, 23, 59, 33,
    -48, 44, 12, 35, 5, 48, -12, -15,
    17, -7, 0, -25, 19, -6, 4, -12,
    -2, 53, 16, -42, 12, -1, 16, -14,
    -11, -9, -1, -47, -38, 41, 30, 41,
    -60, -9, -78, -24, -32, 79, -53, 21,
    11, 8, -29, -13, -11, 8, 21, 54,
    93, -28, 63, 12, -26, -29, -45, 46,
    -97, -7, 51, 14, 25, -16, 21, -41,
    1, 2, -3, -15, -1, 35, -10, -52,
    37, -29, -2, 13, -4, -20, 2, 11,
    -33, 11, 48, 3, 61, 13, -91, 1,
    -127, 27, -20, 14, 17, 5, 1, 36,
    -23, 30, 13, -28, -32, -38, 14, -14,
    37, 0, -9, 3, -3, -93, -11, 10,
    31, -44, -33, -40, 68, 27, 28, -21,
    -44, -2, 20, 63, -23, -46, 44, 66,
    -13, 23, 3, 10, 15, 42, -33, -61,
    -4, -12, 2, 26, -14, -4, -11, -8,
    24, 47, 28, 17, 4, -23, -19, 33,
    -20, -2, -74, 9, 4, 26, 10, -17,
    81, -16, -7, -6, 50, 25, -10, 22,
    -16, 5, -1, -8, -69, -34, 40, -6,
    54, 7, -48, -3, 11, -12, 88, 4,
    -12, -20, -7, 16, 63, 35, 31, 9,
    -22, -1, 26, -15, -28, 35, 28, 14,
    -6, 3, -19, -3, -26, -4, -10, 9,
    37, 45, 51, 1, 36, -26, 87, 15,
    -9, -50, -26, -10, 24, -14, 20, -8,
    -38, 51, 49, 16, 28, 23, -22, -4,
    6, 7, 28, 2, 8, -12, 13, -45,
    -13, 38, -36, 12, 33, -47, 49, -8,
    -42, -31, -7, -34, 74, -34, 62, 6,
    -11, -4, -20, -26, -58, 0, -7, 47,
    12, -3, 36, -31, 55, -44, -20, -9,
    78, -4, 3, 5, -22, -20, -2, 31,
    -29, 27, -55, -63, -5, 1, 35, 94,
    43, 56, -5, -64, -4, 87, 61, 25,
    -39, -3, 34, 25, 37, -73, -11, -82,
    -41, 37, -62, -8, 15, 10, 8, 22,
    21, 10, -121, -3, -61, -16, -1, 0,
    -41, -27, 34, 26, 40, -5, -20, -4,
    -29, -100, 32, -17, 41, 17, 22, -3,
    25, -21, -51, -18, -14, -26, -111, -17,
    -42, -23, 27, 65, 8, -10, -80, 14,
    21, -13, -3, 9, 122, 7, 52, 38,
    -9, -16, -4, -7, 2, -9, -13, 2,
    17, -4, 1, -20, 31, 36, 23, -22,
    -2, 7, 1, -20, -7, -6, 15, 3,
    12, -13, 20, 14, 4, 10, -15, 8,
    -67, 37, -48, 3, -6, -7, 4, 0,
    1, -18, -15, -52, -12, 12, -11, 13,
    12, 26, -3, 15, -25, -35, -28, -26,
    -6, -3, -14, 32, 7, -8, -16, 2,
    28, 32, -15, -7, -8, 11, 19, -1,
    9, 11, 25, 2, -13, -6, -3, -12,
    -10, -7, -25, 41, 4, 23, 23, -16,
    6, 42, 3, 23, 12, -41, 18, 7,
    -20, -25, -13, 1, 19, -7, -17, -36,
    -29, 23, 20, -1, -3, 8, -3, -4,
    -15, -14, -12, -38, -72, -22, 13, -11,
    4, -4, 25, -20, -33, -27, -7, 17,
    20, -56, 0, -8, -1, 11, -1, 23,
    -34, -25, 3, 19, -17, 15, -6, -29,
    21, -21, 12, -5, -14, -32, -21, -17,
    -13, -11, -14, 3, 19, 0, 26, 8,
    28, -13, 14, 18, -4, 2, -9, -21,
    -19, 5, -16, -11, -27, -5, -19, -2,
    -11, 10, -32, 18, 22, -20, -9, -19,
    23, -6, 44, 19, -12, 2, 22, 0,
    -20, -22, 19, 7, -20, 6, -16, 8,
    10, 16, 41, -11, -14, -3, -16, -14,
    2, 3, -1, -29, 25, -27, -19, 16,
    0, 8, 25, -24, 11, 7, 6, -3,
    5, -14, 12, -8, -28, 16, -25, -20,
    7, -38, 1, 3, 2, 20, -8, -43,
    23, -14, -4, -3, 17, 35, 4, 15,
    -42, -15, -17, -7, 8, 1, -13, 2,
    -1, -3, 13, 2, 6, -40, -5, 22,
    7, -26, 31, -1, -37, -6, 30, 2,
    3, 7, 31, 8, 18, 11, 0, 27,
    13, -10, -4, -5, 4, 4, -21, 10,
    18, -44, 18, -39, 14, 9, -48, -22,
    -8, -5, -20, -25, 18, 2, 3, -3,
    -5, -32, -22, -9, 24, 0, 15, 0,
    12, 0, -33, -17, 10, 28, 7, 11,
    -15, 13, 2, -49, 10, -24, -11, 24,
    42, 0, 34, 0, -27, 1, 7, -30,
    16, -2, -32, 36, 35, -26, 15, -12,
    -1, -3, -18, 33, -37, -22, 10, -15,
    -7, -20, 8, -2, -31, -16, 14, 23,
    28, -18, 7, -39, -10, -17, 11, -5,
    -43, 25, 3, 13, 17, 37, 11, 35,
    -7, 0, 16, -6, 10, 3, 17, -7,
    -44, 7, -27, -5, -9, 15, -27, -13,
    -3, 17, 8, 7, -6, -11, 6, -9,
    1, -6, 11, -12, 7, 11, -20, 15,
    0, 24, -14, 5, -15, -39, 15, -4,
    -7, -25, -8, 6, 3, -11, 16, -6,
    -6, -56, 9, -58, 12, 2, 7, -38,
    20, 4, -4, -22, 11, 32, 6, -36,
    3, -9, 24, -37, -21, 5, -7, 21,
    -13, -7, 7, 3, -1, 29, -18, -7,
    -31, 37, -9, 31, 9, 30, 9, -1,
    -29, 6, 0, 20, -35, -49, -51, 48,
    6, 2, 4, 23, -6, -21, 13, 21,
    -11, -10, -3, 2, 4, 21, 1, -4,
    11, -12, -20, 8, -53, -11, 1, -46,
    8, -22, -26, 33, -45, 14, -15, -97,
    13, 14, -11, 22, 7, -20, -5, 5,
    0, 33, -43, 3, 9, -7, -3, 0,
    2, -28, 1, 2, 3, -16, 7, -28,
    -9, 8, 3, -7, -54, 8, 7, -1,
    -18, -15, -5, -1, -44, -6, 14, -23,
    41, -21, 13, 3, -13, -4, 26, 4,
    -14, 30, 5, 17, -16, -16, -17, 12,
    3, -1, -9, 11, 12, 60, 34, -10,
    3, -8, 21, -17, -19, -4, 0, 19,
    8, -59, -6, -1, 32, -20, -17, 6,
    9, -12, 3, -15, -13, -29, -8, -7,
    18, -17, 26, 50, -8, -1, 34, -66,
    -7, 7, 14, -8, 16, -33, 16, -6,
    11, -7, 6, -2, 29, -10, 7, 2,
    16, -5, -26, 31, 25, -33, -9, 1,
    -11, 11, -10, 15, 16, 4, -8, 39,
    -1, 10, -12, -27, -5, -39, 27, -1,
    8, 22, -4, 25, -4, -13, -2, -5,
    16, -11, -29, -7, -10, 21, -28, 17,
    6, -12, 12, -11, 8, 3, -7, 20,
    7, 0, 3, 0, 3, 11, 9, -6,
    -8, -3, -4, 6, -21, -8, 10, -6,
    -14, 34, -48, 27, 20, -8, 10, 9,
    26, 3, -7, -27, -30, 10, -47, 10,
    6, 29, 0, 17, -21, -7, 4, -6,
    20, 25, 13, -41, -6, -11, 16, -26,
    29, 7, -46, -9, 4, 8, 18, 3,
    -26, -33, -23, -28, -30, 14, 45, -4,
    -21, -12, 3, -5, -19, -9, 20, -11,
    45, 23, -9, -23, -1, 17, -15, -24,
    1, -7, -11, -35, 10, -13, -24, -19,
    -18, -27, -9, -36, 21, -9, 35, -7,
    2, -4, 10, 14, -29, -9, -8, 20,
    -6, 8, 36, 20, -27, -21, -3, 2,
    -53, -11, 9, -19, 34, 28, 8, 17,
    24, -9, 11, -12, -14, 22, 61, -14,
    12, 15, 2, -8, -8, -31, 42, 0,
    -32, 5, -24, -14, 1, 15, 27, -19,
    11, -35, -1, -10, 9, 38, 19, -9,
    -20, 7, -24, -1, 24, -15, 1, -31,
    17, -24, -10, 3, -4, -8, -28, 19,
    27, 30, -26, 16, 3, 20, -40, -16,
    -5, 17, 59, 0, -11, -8, 7, -4,
    -3, -35, -9, -14, 0, 41, 5, 45,
    18, 5, 5, -4, -22, 21, -19, 42,
    3, 13, -12, -32, -29, 21, 13, 16,
    2, -15, 10, 19, -16, 9, 33, 7,
    -2, 32, -9, 3, 26, -18, 34, 11,
    0, -17, -2, -18, 21, -48, 0, -17,
    16, -2, 4, -17, 28, -23, -6, 0,
    28, -3, 1, 1, -8, -8, 3, 27,
    -42, 50, 8, -7, 93, -65, 46, -29,
    -10, 10, -1, -6, -33, 74, 21, 24,
    -22, -1, 16, -16, 0, 14, 4, -2,
    5, 21, -2, -2, 47, 0, -3, -32,
    2, 23, -3, 5, 7, 25, 33, -3,
    19, 8, -24, 8, 0, -28, -26, 15,
    28, -8, -14, 1, -2, -4, -29, 24,
    7, 8, -24, 14, -4, -5, -1, 15,
    -19, 4, -26, 22, 29, 0, 8, -25,
    -24, 8, -20, 0, -23, 17, 17, -35,
    22, 1, -11, 0, -16, 9, -40, -6,
    3, 17, -3, 9, 4, -11, -5, 10,
    3, 21, 25, 1, 24, -60, 7, 0,
    -3, -27, 16, 3, 18, 7, 19, -6,
    11, 42, 21, 19, -6, -23, -21, -9,
    -1, -34, 10, 21, -11, -37, -9, 59,
    -14, 6, 5, -24, 17, -3, -50, 22,
    19, -9, 28, -8, 30, 0, 25, -33,
    -42, -6, 15, -43, 17, -17, 21, 4,
    14, -34, -42, 57, -2, 5, 37, 4,
    -1, 38, 3, 22, -37, -21, 6, -12,
    -16, 10, -25, -33, -2, -4, -15, -45,
    3, -5, -1, -17, -28, -2, -7, 27,
    -4, -7, -28, 4, -3, 36, 33, -14,
    -1, -25, -55, -14, 31, -6, 32, 25,
    -9, 31, 1, -8, -10, -5, 10, 1,
    7, -3, 16, -19, -1, 31, -16, 13,
    3, 42, 29, -32, 11, -31, -17, 39,
    2, -16, -31, -31, -8, 38, 20, -20,
    17, 20, -18, -1, -5, 3, 4, 0,
    20, 0, -23, -30, -5, -38, 7, 8,
    4, 28, -64, 1, -20, -4, 22, -15,
    -6, -3, 43, 5, 14, -27, -8, -11,
    -12, -2, -8, -21, -16, 17, 7, -43,
    -7, 0, 10, -8, -3, 11, -32, 18,
    8, 1, 3, 39, -47, 22, -35, -2,
    -35, 9, -41, 54, -13, -23, -51, -34,
    5, 13, 8, -16, -18, 31, 34, 18,
    -38, -4, -29, -16, -10, 2, 26, -10,
    -13, -7, 1, -8, -37, 47, -5, -17,
    31, -12, 14, -8, 25, -16, -17, -11,
    -20, 9, 17, -33, -23, -3, -6, -2,
    1, 26, 13, -34, -16, -23, -32, -15,
    -24, 9, -33, 1, -35, 20, 48, -8,
    18, -29, 7, -7, -20, 73, 38, -3,
    34, 1, 34, 29, 17, 9, 25, -57,
    -31, -15, -12, -9, -9, -5, -40, -14,
    55, 2, -9, -56, 54, 31, 32, -13,
    19, -8, -12, 61, 37, -22, -35, 14,
    -14, 10, 6, 23, -37, 9, -31, 11,
    0, -22, 22, -25, -27, -43, -8, -65,
    -8, 1, 31, 13, 10, -9, 8, -16,
    20, -43, -1, -14, 52, 4, -26, -56,
    -16, -2, 34, -24, 1, 60, -46, 14,
    -14, 8, -4, -13, 25, -24, -26, 44,
    -29, -1, 15, -27, 95, 34, 12, 53,
    39, 15, -38, 39, -11, -60, 10, -57,
    1, 0, -5, -7, -16, 3, 22, -27,
    5, -9, 16, 11, -12, -15, -12, 15,
    -9, -21, 38, -9, 21, 7, 27, 15,
    -48, 2, 7, 39, -46, 14, 23, -7,
    17, 8, 1, 1, -13, -26, 13, -38,
    11, 3, -18, -19, -25, -26, 12, -14,
    -29, 18, 21, 24, -13, 2, 28, -11,
    30, 10, -5, -26, -37, 1, -18, 69,
    -23, -11, -41, 68, 14, 12, -23, -27,
    -18, 32, 20, 10, 19, 26, 37, -36,
    18, -10, 8, 68, -6, -32, 26, -65,
    24, 3, -11, -25, 10, 66, 12, 6,
    8, 8, -10, 45, 7, 8, 8, -10,
    3, 10, 25, -26, -3, 1, 10, 4,
    10, -2, -41, -17, 4, -12, -12, 4,
    -10, 28, -8, -8, 25, -26, -26, 57,
    13, -8, -14, 29, -21, -52, -15, 15,
    -33, 9, -11, 5, 7, -28, 9, -10,
    -15, 9, 1, -13, 3, -9, 16, -27,
    30, -17, -26, 34, 5, 26, 5, -94,
    -7, 12, 12, 21, -20, -32, 14, -49,
    -1, 14, -9, 2, 9, -3, -4, 36,
    -11, -12, -6, 6, -26, -18, 4, -5,
    3, 34, -6, -37, -54, -53, -22, 28,
    -19, 19, -21, -1, -30, -26, 14, -44,
    9, 14, -1, 21, -4, -1, 22, 9,
    -11, -21, 14, -6, 10, -1, -17, 42,
    -6, 9, 5, 2, -4, -6, 7, -47,
    4, -8, 1, -11, 6, -31, 6, 0,
    -46, 4, 13, -19, -2, -32, -10, 53,
    -3, 1, 17, 10, 18, 16, 28, -3,
    -8, -32, 16, 25, -4, 5, -11, -68,
    -2, 10, -24, -5, 19, -15, 16, -3,
    -35, -10, 11, -19, 3, -11, -1, 4,
    -11, -26, -14, 58, 10, -25, 23, -18,
    -2, 15, 24, 27, -3, -27, 31, 41,
    8, -20, 22, 10, 2, -33, 1, -19,
    27, -14, 22, 36, -8, 9, -16, -26,
    -11, 31, -25, 5, -22, 16, 40, 6,
    22, -3, -17, -28, 6, 63, 9, -14,
    3, -16, 29, 2, -11, 33, 3, -24,
    -11, 16, 7, -3, -16, 8, 12, -10,
    17, -21, -15, -13, 17, -47, 39, 18,
    -1, -13, -11, -33, -3, 2, -127, 34,
    -23, -6, 13, 3, -11, -34, 20, 18,
    3, -22, 31, -15, 22, 17, 14, -10,
    -7, 7, 15, -36, -34, -22, 27, 57,
    -37, -38, -18, -15, 22, 16, 29, 8,
    -28, 4, 46, 33, 11, 1, 15, 8,
    -13, -7, 5, -19, 21, 11, 0, -25,
    -26, -14, -4, 3, 18, -7, -35, -5,
    -24, -7, -20, -39, -9, -14, 24, 41,
    -31, 10, -33, 24, 15, 5, -2, 33,
    5, -14, -19, -2, -35, -10, -4, 31,
    -18, 6, 21, -11, 0, -48, -26, -20,
    12, 0, -4, -31, 6, 75, 49, -9,
    -13, 26, 1, 52, -4, -26, 15, -27,
    -31, 21, 34, 11, 11, -24, -27, -18,
    3, 12, 19, -5, -8, 3, -20, 5,
    -19, 36, -21, 29, -33, -10, -5, -13,
    7, -18, -6, 10, 0, -23, -7, 0,
    10, 12, -17, 12, 13, -14, 17, -16,
    -21, -25, -19, 4, 3, -16, -4, -13,
    29, -17, 2, -27, 11, -1, 0, 34,
    -10, -15, -22, -2, -15, 24, 11, 58,
    -2, -5, 0, -10, 7, 20, 8, 16,
    37, -4, -20, -11, -59, -22, 35, -8,
    4, 21, -31, 51, -5, -6, -28, -10,
    -10, 17, 11, -8, 5, -23, 8, -38,
    17, -4, -23, 12, 36, 15, 7, -18,
    40, 1, -8, 0, -29, 21, 3, -21,
    -40, 81, 30, -27, 66, -75, 14, -24,
    -16, -1, -25, -8, -37, 93, -1, -3,
    4, -36, 4, 10, -23, 32, -1, 3,
    28, -23, 2, -43, 51, -40, -1, -19,
    -4, 14, 31, 17, 18, -33, 27, 51,
    23, 22, -12, -2, 14, -28, 37, -14,
    -19, 3, -19, -5, 19, -3, -21, -17,
    6, -9, -39, -18, -26, -4, 60, 5,
    -20, 20, 2, 28, -19, 30, -42, -28,
    -4, 12, -3, -14, -5, -11, 1, -50,
    15, 4, -16, 7, 5, -6, 6, -15,
    49, 4, 27, 31, 61, 6, -2, 23,
    19, -12, 36, -14, 2, 16, -40, -14,
    -16, 17, 11, 12, 13, 9, -50, -18,
    26, 17, 3, 37, 2, -20, 24, -35,
    -27, -1, -30, 9, 10, -47, -11, -45,
    -13, 11, -3, -32, 38, -28, -58, 46,
    13, 23, -28, -9, 37, 35, -69, 21,
    -127, 4, -40, -22, 39, 11, 63, 31,
    -13, 1, 68, 23, -31, 1, -1, 57,
    23, 47, -14, 14, -38, -5, 15, 16,
    8, 34, 38, -28, 5, -44, -25, -99,
    9, -34, -1, 59, -19, 5, 10, 52,
    33, -9, -27, -30, -38, -56, 67, 14,
    21, 17, -55, 24, 106, -64, -3, -18,
    -29, 7, 43, 86, 17, -19, 36, -35,
    30, -67, 42, 17, 12, 92, -46, 5,
    9, -22, -33, 82, 33, -12, 50, -46,
    -3, -3, 1, -55, -49, 108, 30, -78,
    58, 25, -19, 1, 7, 22, 1, 10,
    -15, 10, -17, -26, -3, -59, -18, -32,
    -5, 5, 50, 2, 16, 16, 20, 39,
    -24, 1, 75, 20, 55, 19, -36, -26,
    -14, 5, 24, -21, 28, 12, -10, 8,
    1, 14, -52, 16, 17, 29, -1, 11,
    -11, 40, 2, -7, 8, -13, 54, -7,
    -68, -22, -61, 51, -17, -23, -54, -29,
    -34, -28, -57, -32, -18, 43, -50, -33,
    73, 53, 8, -24, -22, -4, 8, 25,
    37, -57, -33, -31, -10, -1, 17, -4,
    20, -8, 27, -47, -31, -11, -47, -29,
    -12, -29, -18, 25, -32, -32, -10, -1,
    -46, -36, 27, -30, -16, -20, 9, 8,
    7, -23, -1, 10, 44, -62, -19, 10,
    37, 9, 0, -16, -44, 79, -59, -39,
    -4, 9, 60, -41, -65, 60, -9, 32,
    -48, -15, -11, 30, -19, -3, -39, -34,
    -34, 62, -21, 10, -1, -18, 21, -17,
    -7, -22, -9, 91, 52, -67, -68, 49,
    -28, 13, 9, -26, 33, -68, 13, 9,
    -36, -46, -43, 17, -6, -28, -55, -74,
    -39, 42, -54, 44, 56, -19, 45, -3,
    6, -34, 5, -44, 67, -31, -25, -46,
    3, 3, 3, -7, 33, 96, 56, -34,
    -29, -12, -12, -23, 30, -4, -13, 41,
    -42, 7, -13, 8, 9, 4, 22, 2,
    28, -3, -11, 40, 8, -51, -10, -115,
    -5, 41, 18, -22, 21, -17, -12, -11,
    24, -35, 42, -26, -17, -21, 6, 14,
    -23, 0, 17, -26, 31, 8, -17, -34,
    -30, 15, -35, 66, -43, 22, 59, -10,
    18, 1, 33, -31, 24, 20, -14, -38,
    23, -73, -19, 12, -57, -55, 71, -34,
    -1, -31, 11, -9, -34, 17, 7, -26,
    40, 19, 21, 26, -12, 24, 12, 46,
    -35, -1, 26, -26, -46, -46, -9, -40,
    42, -14, -69, 17, 39, 87, -1, 4,
    -17, 42, -33, -13, 36, -11, -1, 51,
    9, 34, -48, 13, -44, 112, 8, 3,
    37, -3, -34, 11, 32, -28, 20, 21,
    -10, 5, 100, 3, -33, -6, 4, 48,
    40, -46, -20, 28, -43, -37, 13, 7,
    47, 61, -61, -16, -30, -14, -43, 54,
    -18, -3, -1, -61, 27, -51, 28, 44,
    4, 7, -5, 66, -9, 6, 9, -42,
    71, -3, 51, -22, -34, 36, -28, 16,
    21, -22, -44, 2, 43, 31, 15, -112,
    34, 23, -10, -27, -19, -47, 8, -77,
    16, 12, 49, -8, -10, -19, 0, 38,
    37, 7, -36, 52, -56, 61, 79, 4,
    47, -15, -28, -9, -23, -62, -37, 0,
    -14, 15, 33, 0, -33, -35, 9, -15,
    -9, -51, 45, 41, -1, -5, -6, -11,
    -2, 36, 10, 31, -35, 53, -12, -20,
    -20, -27, -9, 14, -27, -85, 7, -26,
    47, 56, -19, 12, 2, -81, 17, -30,
    -9, -62, -66, 14, 8, -40, -21, 40,
    -33, 45, 16, 5, -2, 32, -18, 28,
    -57, -2, -23, 10, -42, 39, -15, -62,
    3, -9, -3, 17, 11, -17, 66, -15,
    -4, 41, -1, -14, -42, -5, 25, 1,
    16, -5, 25, -127, -16, -10, 27, 16,
    40, -14, 31, -2, 29, -26, 48, 19,
    56, -2, 7, 21, -4, -74, 8, 50,
    4, -19, -3, -22, -1, 5, 21, 27,
    -28, -23, 11, 28, -60, 45, -50, 14,
    40, 35, 2, -38, 18, 51, -28, 32,
    28, -25, -22, 3, -5, 51, -7, -7,
    -6, 19, -1, -19, -37, -7, 57, -9,
    63, -21, -2, -33, 17, 19, -51, -70,
    9, 11, -47, -82, -24, -31, -89, 72,
    -16, -12, -58, -40, -1, -17, -14, -7,
    2, -6, -34, 19, 4, 3, -28, 28,
    -74, 50, 60, 11, 11, 12, -5, -73,
    -62, -57, -12, 25, -57, 12, 36, -10,
    24, 8, 69, -37, -20, 16, -1, 51,
    10, -10, 18, -22, -6, 0, 8, -18,
    5, 8, 0, 23, -17, 11, 21, 25,
    -44, 7, 12, -39, -11, -12, 21, 62,
    -4, 3, -1, -51, 17, 2, 10, -31,
    -33, -20, -29, 19, 3, 10, -23, 46,
    40, -41, -37, 69, 13, -36, 14, -54,
    22, 59, -13, 18, 26, 78, 84, -31,
    -8, -5, 18, -25, 12, 65, 33, 16,
    -1, -22, 29, -25, 5, -17, -56, 23,
    -19, 35, 7, 18, 15, -3, 5, 5,
    3, 42, -50, 30, -119, 68, 1, -2,
    23, -24, 38, 0, -8, 26, -65, -28,
    -3, -21, 13, -11, 26, -18, 50, 25,
    5, -18, -43, 19, -36, 3, 29, 8,
    2, 3, -10, -23, -13, -19, -4, 26,
    19, -7, -1, 0, 9, 46, -43, 76,
    7, 3, 21, 21, 26, 4, -6, 15,
    -27, 17, -14, -15, 85, -26, -30, 16,
    43, 10, -79, 37, -6, 4, 24, -23,
    -17, 29, -51, 1, -14, -42, -3, 2,
    -54, 15, 34, -39, -6, 27, -24, -19,
    -12, 28, -20, -13, 15, 4, 7, 14,
    -58, 74, 10, -18, 50, -91, 49, 7,
    1, 35, -14, 13, -57, 100, -17, -21,
    -20, -65, -3, 39, -8, 55, -21, 1,
    29, -54, 15, 12, -18, -12, -15, 34,
    25, 10, 1, 48, 28, -52, 43, 77,
    -34, 72, 57, -1, 2, -29, 72, -20,
    6, -43, -23, -62, 17, -8, -56, -2,
    3, 13, 45, -38, 13, -8, -74, -28,
    -23, 11, -48, 13, -49, -12, -38, -53,
    1, -6, 124, -11, 20, 10, 6, -40,
    -12, 27, -49, -7, -16, -2, 66, 26,
    -42, 21, -17, -61, -45, -26, 30, -24,
    -11, -29, 18, 2, -23, 34, -16, -50,
    22, -55, -38, -18, 20, 0, -23, -26,
    -53, -16, 35, 38, -23, 32, 66, -10,
    24, 20, -5, 42, 54, -23, -25, 41,
    -2, 13, 9, -22, -61, -14, 8, -3,
    -16, -19, 4, -19, 8, -42, -1, -29,
    24, 24, -2, 4, 13, -31, 4, -24,
    -8, -19, -13, 6, -26, -19, 5, -6,
    12, 29, 11, 28, -7, -17, -20, 1,
    -14, -30, -9, 10, 18, 30, -3, 20,
    -22, 27, 6, 20, -25, -2, -25, 25,
    1, -5, -5, 14, 0, -8, 13, -4,
    -43, 15, 46, 4, -10, -6, 4, 95,
    -1, 14, 17, -6, 4, -9, -13, 35,
    4, 5, -1, 22, 14, -36, -13, -6,
    25, 19, 7, 6, -8, -17, 1, 17,
    -30, 6, -13, -8, 28, 56, 5, -2,
    -33, 26, -1, 10, -4, 14, 8, 0,
    3, 30, -14, -7, 12, 18, 12, 27,
    4, -9, 14, -26, 28, 43, -32, -28,
    -30, -36, -11, 30, 33, 26, 8, 14,
    -5, -2, 22, -15, 8, 15, 26, -35,
    19, -7, 20, -15, 4, -11, 11, -6,
    14, -10, 31, -8, 8, 43, -4, -7,
    83, 16, 12, 7, -16, -29, 24, -5,
    10, -3, -4, -16, 12, 10, -3, 17,
    4, 5, 28, 11, 42, 0, 11, -16,
    27, 5, -4, -1, -15, 3, 36, 5,
    29, -44, -31, -16, -25, -12, 9, -63,
    -26, 2, 29, -16, 11, 15, -38, 3,
    -12, -7, 2, 2, 2, -19, 15, 3,
    -7, -9, 16, 29, 7, 12, 22, -52,
    -45, -49, -8, -4, 11, -38, -45, -62,
    19, 3, -16, 1, 0, -6, 21, 25,
    23, 21, -17, -6, -11, -23, -33, 4,
    19, 28, 4, 23, 12, 26, -40, -40,
    -37, 30, -6, -49, 14, -70, 13, 21,
    -13, -6, 18, 2, -13, 57, 13, 37,
    -17, -24, 8, 37, 5, -28, 24, 40,
    -4, -9, -5, -9, 37, 5, -14, 39,
    24, -33, 5, 27, -2, -33, 2, 30,
    2, 39, -22, 6, -5, -27, -18, 5,
    -10, -22, -14, -21, -16, -45, 4, 0,
    -26, 3, 17, -16, 56, -30, -57, 16,
    20, -21, -15, 38, -3, 12, -3, -29,
    20, 13, 14, 25, -8, 19, 30, 26,
    20, -15, -18, -3, -22, 12, -45, -10,
    26, 17, -6, -8, 4, -15, 27, 25,
    40, 10, 34, -5, 27, 18, 23, -22,
    -17, 12, 10, 22, -15, -7, 21, -13,
    -37, 30, 7, 8, -17, 29, 28, -26,
    9, 1, 40, 11, 15, -36, -13, -7,
    -35, 8, -46, 6, 33, 33, 11, -5,
    -9, 7, 24, -3, -5, -20, 2, 22,
    15, -1, -3, 11, 9, 16, -16, -11,
    -9, 13, 23, -27, 28, 25, -9, 43,
    2, -36, -8, 9, -12, -15, -16, -33,
    -8, 19, -15, -2, -13, -5, 17, 16,
    -7, -6, 3, 2, -5, 31, -9, -25,
    -38, 22, 1, 0, 1, 0, -33, -25,
    -20, -14, 0, 42, -23, -38, -4, 10,
    7, 26, -17, -6, 17, -6, 29, 18,
    17, -16, -28, -19, 6, -65, 27, -46,
    0, -5, 25, 24, 19, 28, -23, 49,
    -16, -19, 16, -61, 27, -49, 2, 53,
    3, -9, 0, -1, 0, 9, -15, -8,
    -3, -10, -22, 35, 25, -8, 53, 51,
    -33, -14, 6, -10, 16, 9, 16, 20,
    15, 8, 5, 23, -10, 24, -32, 6,
    -9, 5, 8, -9, 24, 68, -26, 36,
    6, -4, -18, -1, -6, -3, 4, -17,
    -18, -25, -9, -38, -28, 15, 26, -10,
    -19, -3, -3, 66, 22, 7, 64, 16,
    6, 6, 25, 10, -3, 6, 0, -25,
    -20, -7, -21, 38, -10, -16, 46, -26,
    -9, 12, -12, -44, 69, -4, -25, 17,
    40, 17, 44, 4, -9, 71, -7, -14,
    -8, -15, -35, 2, 20, -49, -21, 0,
    12, 7, -9, -2, 25, -22, 9, -39,
    8, -1, 23, 14, 0, 6, 9, 4,
    -15, 25, 16, 13, -35, 23, 39, 16,
    -8, -2, 2, -11, 25, 2, -37, -37,
    -13, 5, 4, -3, -15, 14, -19, -3,
    -1, 10, -19, 9, 10, 20, -11, 1,
    26, 44, -11, 0, -30, 11, -27, -3,
    -16, -20, -7, 11, 5, -2, -9, 18,
    -10, -4, -15, -2, -27, -4, 11, -18,
    19, -15, 1, 18, -27, -16, -15, -11,
    -6, 33, -3, 13, 23, -18, 8, 1,
    -18, 22, 16, 3, 2, -3, 29, -12,
    -2, -4, -1, -11, -34, 24, 18, -3,
    7, 25, -16, -17, 11, 32, 13, 14,
    -32, 9, 14, -22, 15, 24, 37, -18,
    -12, -3, 27, 10, 39, -21, 0, 3,
    -3, -11, -14, -13, 61, 9, 40, -32,
    -14, -6, -2, -11, 23, 16, 28, -14,
    -23, 10, 20, -23, -36, -5, 49, -32,
    14, -10, -45, -1, -29, -11, 39, -19,
    31, -1, 7, 7, -2, -7, -2, 7,
    -22, -1, -25, -20, -7, 14, 26, -4,
    20, 18, 30, 24, 15, 9, -29, 35,
    -10, 16, -3, -59, 22, -23, -32, -17,
    -1, 42, 20, -15, -5, 6, 28, -13,
    3, 8, -12, -14, -16, 35, 31, 7,
    -33, 11, 49, -28, 57, -7, 1, -10,
    -10, 0, 11, -4, 19, -12, 13, 18,
    -24, -10, 0, 9, 15, 11, 34, -30,
    -41, 15, 18, 19, 1, 29, -33, -9,
    -20, 26, 34, 13, -4, 16, 10, 10,
    -4, -36, -56, -34, 4, -13, 31, 14,
    -23, -7, 10, 3, 11, 9, -23, -12,
    -12, -13, 10, 22, -2, -4, 31, -19,
    -7, 17, -10, 20, 55, -7, -1, 28,
    -6, -43, -25, 26, 36, 5, 2, -4,
    -5, -6, 16, 5, -27, 19, 45, -18,
    41, -41, 1, 13, 12, -14, 10, -1,
    74, -45, -3, -18, 76, -23, -35, 10,
    -16, -54, 17, 19, -2, -2, 18, 23,
    -19, 8, 19, 3, 41, -50, -23, 20,
    -14, 0, 4, 3, -18, 29, 18, -23,
    -6, 29, -60, -30, 5, -10, -47, 24,
    -10, 8, -30, 11, -11, -30, -35, -5,
    21, 20, -13, 25, 3, -43, 24, 53,
    22, -2, 14, 0, 45, -7, 53, 43,
    -13, 17, 28, 6, 10, 25, 49, 17,
    13, -6, -13, 25, 16, -7, 5, -20,
    -38, 12, -2, 9, -8, 11, -36, -13,
    5, 4, -12, -23, -23, -59, -20, 19,
    -38, 27, -3, -19, -20, 4, 29, 10,
    17, 10, 32, 11, 6, -17, -6, -7,
    -5, -16, 17, 25, -19, 36, 0, -22,
    9, 30, -6, 90, 7, 14, 11, -62,
    8, -37, 47, 51, -76, -32, -26, -24,
    -36, -29, 31, -4, 23, 8, 14, 28,
    24, -19, 3, 20, 41, -30, 59, -25,
    -22, -39, -38, -17, 34, -26, -43, 88,
    -6, 15, 14, -40, 46, -27, -43, 57,
    14, -26, -11, 21, 3, 52, 9, -18,
    -26, -13, 8, 30, -24, -22, -2, 29,
    35, -33, -21, -44, 21, 42, 20, -48,
    -34, -47, 7, -11, -49, -42, 7, -25,
    -5, 4, 21, 28, 41, 41, -53, 51,
    26, 4, 17, -16, -23, -16, -34, -20,
    7, 10, 62, 19, -29, -29, -12, 47,
    48, 19, 39, -17, 15, 87, 7, 39,
    -20, 29, 6, 44, -5, -13, 17, 3,
    -7, -16, -14, -4, 32, 19, -1, 13,
    30, -14, 15, -11, -21, 31, 16, 20,
    -23, -32, -37, 7, 2, -9, 70, 1,
    12, -5, 21, 0, 14, 24, -3, 16,
    12, -11, 14, 12, 10, 22, -6, -44,
    51, -33, 77, -16, 18, 36, 51, 28,
    -27, 7, 3, 0, 41, 9, -4, 6,
    14, 3, -20, 12, 12, -30, 24, 17,
    1, 2, 42, 8, 32, -7, -14, -52,
    41, -17, 20, -5, 4, 14, -16, -17,
    -27, -3, 35, -2, 27, 61, 34, 24,
    -39, 14, 7, -4, -13, -2, -22, 34,
    11, -14, 9, -12, -10, 21, -37, 28,
    14, -22, 13, 90, -3, -28, 7, -18,
    37, -35, 52, -83, 0, -31, 52, -81,
    33, -11, -2, 4, -4, -22, -36, 10,
    -8, -14, -26, 18, 5, -1, -45, 17,
    -8, -4, 29, 27, -30, -17, 18, -76,
    -6, -96, -20, 22, 14, 11, -1, 32,
    -2, -11, 11, -7, -3, -20, -7, 16,
    -16, 0, -3, -4, 27, 28, -35, 30,
    2, -8, 4, -23, 61, 6, 4, -23,
    -35, -17, 0, -7, -10, -16, 56, -20,
    -16, 28, -1, -3, 22, 5, 27, -19,
    -9, -32, 19, -7, 2, 4, 23, 25,
    -27, 30, 14, -19, -20, -2, 6, 57,
    41, -19, -49, -39, -44, -45, -19, 26,
    19, 12, 14, -2, 19, 4, -2, 19,
    24, 42, -18, 29, -23, 21, -12, -22,
    8, 3, 5, -27, 0, 25, -35, -1,
    -21, -9, 25, -4, 5, -6, -20, -41,
    -42, -35, 10, 22, 30, 3, -6, 14,
    2, -17, -4, 2, 22, 29, 64, -6,
    -2, -12, 35, -1, 0, -33, -48, 18,
    18, 34, -5, -24, -5, 11, -13, 33,
    2, -23, -1, 8, 21, 0, 9, -24,
    35, -21, 8, -35, -45, 27, 3, -12,
    -13, 25, 53, 8, -1, 13, 6, 50,
    55, 2, 34, -41, 19, -16, 5, -7,
    -4, 37, 2, 16, 0, 8, 15, 13,
    -21, 7, 13, -11, -7, 50, 17, -3,
    -78, 8, 6, 3, 0, 5, 0, -6,
    -24, 30, 19, -20, -26, -29, 34, -35,
    -16, 44, -45, -19, -4, 30, -43, 37,
    -16, -7, 1, 22, 19, 16, 16, -11,
    -7, 29, 45, 4, -17, 32, 14, 19,
    25, -17, -20, -5, -7, -12, 28, 34,
    24, 9, -18, -8, -3, 7, -32, 26,
    -3, -13, -2, 29, -6, 10, 27, 54,
    -53, -16, 26, -43, 34, -56, -35, 28,
    12, 14, -7, -19, -5, -2, -11, 3,
    -11, 3, 13, -22, 23, 29, 40, 16,
    7, 13, 13, 0, -38, 67, 2, 12,
    -8, 9, -36, -56, -15, -9, -20, 24,
    56, -55, 6, -26, -29, 59, 10, -53,
    1, 7, 13, 0, -21, 7, -13, 46,
    -29, 3, -26, 27, -50, 13, 27, 10,
    -23, 8, 7, -16, -5, -12, -30, -15,
    59, 60, 56, -26, -35, 25, 44, -45,
    0, 3, 9, -4, 19, -69, -18, 13,
    9, -3, 9, 6, -17, -3, 62, -12,
    -8, 18, 40, 21, 3, 38, 0, -29,
    -23, 1, 11, 13, -13, -11, 22, -60,
    14, -32, -13, -37, -11, -33, -25, 23,
    11, -3, 3, 4, 43, -38, 3, -16,
    -21, -34, -47, -3, -15, -35, -16, 31,
    -27, 25, 0, 7, -4, 5, -75, -10,
    -24, -12, 4, -2, 31, 17, 38, 22,
    0, 8, -30, 8, -28, -21, 8, -17,
    23, -6, -2, 10, 23, -14, -66, -9,
    -4, 17, 7, 24, 39, -26, -19, 10,
    -9, -26, 44, -23, 18, 8, 0, -20,
    -31, 10, 46, 1, -27, -43, 5, -7,
    -54, 26, 4, 6, 17, -16, 24, 21,
    20, 8, -20, -47, 11, 19, 51, 16,
    -3, -13, 68, 11, -25, -1, 1, 14,
    -46, -12, 1, 6, -19, -18, 9, -23,
    7, 24, -17, 9, -17, 8, 22, 26,
    6, 18, -29, -26, -77, 15, 14, -22,
    10, -8, -52, 9, -3, -25, 21, -20,
    10, 3, -21, 4, 22, 32, 9, -10,
    -13, 39, -59, -40, 10, 29, -16, -13,
    39, -13, 35, 30, 59, -1, 25, -6,
    21, -2, 1, -25, -13, 36, 0, -21,
    8, -22, 24, -5, -12, 52, 35, -11,
    0, 22, -11, 9, -12, 31, -13, 10,
    -25, 57, -14, 8, 35, 23, 8, -4,
    29, -15, 7, 4, -11, 11, -25, 13,
    -34, -13, -9, 9, 8, 21, 38, -8,
    -34, 22, 4, 33, -28, -4, -1, 0,
    21, -16, 19, -9, 7, 4, 27, -12,
    6, -46, -45, -31, 13, 7, 12, 19,
    12, 21, 14, -2, 11, -2, 1, -10,
    -11, -13, 7, 30, -15, -48, 53, 9,
    44, 33, 9, -48, -35, 8, 18, 6,
    5, 38, -20, 2, 21, 21, 14, -35,
    31, -12, 7, 5, 14, -9, -23, 14,
    21, -36, 15, 11, -2, 11, 4, -31,
    7, -21, 3, -6, 2, -36, -3, -35,
    14, -77, 5, 20, 11, -8, -14, -3,
    -11, 8, 6, 8, 37, -52, -11, 41,
    -29, 3, -22, 14, -2, 2, -2, -39,
    -19, 14, 2, 28, 12, -12, -57, -32,
    -12, 35, -37, -18, 19, -13, -57, -21,
    -29, 20, -27, -3, -11, 0, 4, 55,
    18, -5, -32, -5, 4, 12, -5, 36,
    -24, -4, -16, 29, 69, 12, -20, 10,
    14, 2, -5, 47, 4, 2, 27, -2,
    1, -2, -4, -9, -3, 15, -2, 24,
    9, -41, -27, 2, -1, -44, -17, -43,
    15, 34, -46, -10, -23, 62, 21, 13,
    23, -5, 0, 38, -60, 6, 10, 15,
    -14, -9, -15, 12, -26, 32, 1, 10,
    19, -19, -29, 122, 62, 52, 18, 20,
    -41, 75, -40, 6, -29, -34, 9, 62,
    22, 31, -6, -16, -20, -37, -41, -86,
    41, 28, 14, 90, 42, -90, 49, 2,
    4, -48, -41, 5, -11, -30, 35, -80,
    48, 19, -47, -15, -45, -35, 33, 77,
    -12, -34, -28, -37, -48, 37, -18, 30,
    -18, -43, -2, 7, -26, -4, 20, -25,
    50, -14, -5, -18, -6, 1, -17, 8,
    45, 54, -23, 5, 26, -3, 3, 22,
    25, -34, 1, 6, -14, 12, 12, 25,
    26, 31, 17, -29, -6, -68, 22, -38,
    53, 41, 67, 22, 102, -3, 67, 36,
    22, -15, 22, 23, -2, -38, 23, -103,
    -77, 16, 15, 9, -10, -33, 46, -28,
    -12, -67, 61, -6, 9, -30, 5, 50,
    25, -3, 34, -8, 30, 57, 6, 18,
    -47, 6, 76, 36, 44, 6, -99, 47,
    26, -9, 0, 21, 0, -22, 109, -46,
    -30, -8, -19, 12, 18, 18, 36, -33,
    102, -27, 103, -24, -59, 5, 56, 32,
    16, -55, -63, 89, -25, 23, -13, 98,
    6, 10, -35, 21, -62, -61, -22, -38,
    16, 30, 60, -2, 68, 16, 86, -63,
    58, -18, 68, -3, 4, 32, 76, 11,
    -11, 106, -4, 27, 1, 69, -7, 3,
    -56, 6, 24, 1, 12, -30, 57, -12,
    27, 2, 23, -28, -8, -35, -41, -39,
    -32, -15, 43, 86, 0, 34, -28, -26,
    -30, 58, -13, 20, -10, 68, -50, 27,
    11, -15, -9, 2, -5, 0, 70, -4,
    -6, -61, -9, 14, -25, -17, -67, -6,
    -23, -11, 17, 10, 16, 41, -11, 31,
    17, 17, 15, 78, -52, 103, 15, 29,
    6, 16, -54, -2, -35, -48, 57, -14,
    -20, 52, 4, -19, 1, 1, 1, 47,
    8, -1, -27, -7, 32, 30, -43, 2,
    -26, -14, -21, -53, -1, -117, 80, 40,
    -8, 22, 36, -10, -1, 53, -47, 53,
    -31, -12, -6, 11, -42, 63, 12, -10,
    -27, 10, 46, -42, -29, 6, 39, -80,
    -33, -63, 87, -17, 6, 41, -77, 19,
    22, -10, 2, 7, 37, -7, 38, 56,
    -6, 71, 12, 59, -17, 53, -38, -2,
    -20, 4, -9, 31, -12, -38, 27, -70,
    3, -68, -42, 0, 19, 39, -33, 15,
    8, -21, -5, 35, -7, -27, -3, 1,
    42, -4, -3, -9, 19, 30, 57, 45,
    0, -27, 35, -6, -107, 94, 2, -53,
    85, -69, 0, 27, 24, -101, 54, 32,
    44, -2, 10, -12, -35, -30, 18, 28,
    58, -35, 34, -16, 8, 47, -14, -32,
    -8, 52, 58, -8, 22, -47, 3, -69,
    -27, -58, -30, 17, -1, 4, 35, -6,
    8, 43, 25, 15, 28, -21, 80, -3,
    1, -4, 47, -35, 62, 7, 25, 71,
    -85, -32, 11, 12, -61, 0, -51, -40,
    -46, 98, 2, 58, -40, -65, -25, -97,
    -8, 38, -56, -41, 24, 105, 43, 23,
    -26, 8, 29, -3, 60, 65, 59, 5,
    -35, 29, 34, 1, 3, 15, 68, -9,
    -68, -28, -20, 97, 36, -36, 35, 45,
    0, 16, -29, -26, 30, -16, 5, 13,
    49, -20, 67, -17, -31, 30, 57, 42,
    -79, -28, 18, -38, 2, -2, 32, 6,
    -10, 41, 39, 12, 5, -74, 19, -23,
    -13, 36, -25, -43, 28, -23, -15, -25,
    -39, 4, 78, -33, 10, 72, 27, 26,
    -54, -15, -28, -63, 80, 21, 1, -38,
    -49, 25, -54, 42, 65, -24, -102, 22,
    -46, -23, 40, -38, 59, -11, 3, -34,
    -41, 32, -57, 4, -57, 15, 12, 50,
    1, 2, 11, -25, -33, -7, -19, -41,
    -66, 43, -117, -12, 28, 23, 46, -23,
    2, 53, -26, -11, 10, 34, 32, 12,
    44, 37, 75, -5, 9, 95, 96, -50,
    -4, 3, 30, 8, 36, 70, -14, 26,
    46, -40, -37, 6, 20, -76, -23, 23,
    14, -26, -14, 14, -56, 93, 2, -41,
    1, 3, 50, -36, -14, -25, -7, -122,
    3, -37, -54, 22, 37, 92, 3, -52,
    -21, -52, 32, -19, -6, -47, -53, -75,
    -27, -42, -8, -1, -49, 18, -72, 36,
    9, 16, -35, 11, -29, -88, -17, 0,
    22, 15, -2, 2, 5, -35, 72, 12,
    32, 14, 57, -94, 8, 33, 98, 4,
    -19, -69, 2, -29, 22, 72, -49, -43,
    -22, -12, 105, 24, -25, 0, 3, 3,
    -65, 41, 14, 30, 41, -17, -49, -23,
    69, -11, -28, 55, -31, -25, 77, 11,
    58, -26, 72, 49, 5, 46, -13, -6,
    -100, 8, -1, 6, -44, 0, -26, -62,
    -46, -3, -13, -1, 10, -44, -13, 26,
    10, -17, 2, 54, 13, -30, -50, 14,
    -21, 13, -30, -17, -13, -3, -5, -27,
    9, 19, -54, -8, -21, 25, -5, 54,
    -6, -5, -35, -56, -50, -15, 50, 22,
    53, -17, 30, 16, -21, -91, -1, -16,
    38, 36, 6, -46, 44, -18, -17, -6,
    34, -18, 7, -47, -9, 30, 54, -50,
    -28, 43, -12, -19, 71, -57, -22, 41,
    18, -26, 20, 54, -20, 5, 54, 18,
    -26, -32, 14, 9, 17, 70, -39, 13,
    -12, -35, -24, -10, 1, 28, 46, -54,
    -86, 6, -11, 39, 6, -4, -49, -23,
    -19, -17, 12, -21, 104, -11, 14, -26,
    -11, -7, -89, -40, 38, 50, 53, 28,
    71, 25, 38, 8, 13, 16, 19, -31,
    4, 8, -46, 61, 25, 8, -32, 26,
    -3, 17, 65, -1, -11, 51, -87, -42,
    -14, 5, 11, -18, 45, -6, -47, -3,
    44, -11, 20, -4, 40, 40, 7, -45,
    14, -30, 11, 1, -37, -7, -29, 63,
    -57, -31, -21, -11, -19, -58, -19, -13,
    41, -82, 33, 46, -27, 39, 27, 5,
    0, 30, 21, 4, 70, -64, -2, 36,
    -41, 6, -47, -11, -38, -79, 19, 40,
    58, -73, -64, -6, -19, 74, -70, 10,
    -9, 7, -9, 4, 16, -22, 18, 51,
    -83, 27, -41, -18, 1, -73, 7, 74,
    -27, -15, -9, -6, 15, 4, -32, -60,
    -6, -26, -37, 25, -4, 30, 43, -6,
    35, -4, -15, 28, -21, 9, 21, 12,
    -44, 14, -27, 5, -16, 8, -28, -1,
    -6, -6, -100, 22, 32, 45, -28, -72,
    -2, 4, 44, -44, -8, -38, 53, 25,
    -19, -27, 23, 18, 19, -55, 22, -36,
    27, -22, -6, 85, -40, 33, 16, -23,
    2, -12, 3, -31, 14, 1, 41, -9,
    54, 5, -9, 1, -79, -50, 19, -16,
    -12, -24, 3, 12, -5, -13, 2, 24,
    11, 3, 13, 9, -13, -24, 32, -13,
    17, -17, 24, -28, 2, -18, -26, 36,
    -14, -12, -14, 4, -29, 3, -15, -15,
    25, -8, 2, 33, 12, 9, -6, -9,
    -23, -30, 6, 4, 8, -2, -20, 0,
    1, 17, 9, 17, 5, -10, 7, -10,
    -7, 1, 13, -20, -2, 8, -20, -19,
    -5, -2, -9, 25, -7, 4, 8, 5,
    12, 23, 0, 14, -18, 24, 16, 14,
    27, 19, -22, -16, 9, 34, 16, 33,
    13, 15, 14, 16, -20, -18, 11, 1,
    -19, -8, -3, -3, 18, -13, -10, -5,
    -13, 4, 2, -7, -30, -9, 14, -2,
    10, -12, -35, -6, -13, -11, 41, 8,
    -7, -5, 32, 27, 13, 1, 23, -25,
    36, 30, 12, 11, 2, -13, -5, -1,
    -1, 13, 7, -1, -25, -13, -16, 51,
    -12, 0, -48, -12, -6, -15, -12, -10,
    17, 24, -13, 23, 39, -4, 0, -6,
    -12, -13, -58, -1, -8, 7, -16, 9,
    2, -13, 7, 2, -7, -13, 12, -6,
    -1, 4, 3, 7, 21, -3, 13, 8,
    9, -16, 15, 11, -3, 1, -17, 14,
    -8, -5, 0, -17, 0, 12, 4, -11,
    7, 0, -3, -7, 11, -22, 41, 10,
    -33, 1, 7, 7, -13, 1, -20, -40,
    -1, 3, 15, 20, -17, -2, 24, 0,
    15, 33, -16, 22, 14, 19, 19, -2,
    -1, -2, -5, -1, 15, -61, 15, 17,
    -26, 8, -8, 3, -13, -12, -23, -45,
    -1, -3, 10, -2, 3, -9, 9, 22,
    -30, -15, 10, 32, -2, 16, 14, 10,
    -12, 9, 11, 5, 5, 45, 18, 22,
    3, -41, 32, 32, -7, 17, -33, 1,
    8, 14, -10, -24, 26, -1, -2, -3,
    -2, 8, -2, 16, 8, -7, -7, -17,
    -4, -7, -25, 24, -1, -15, 23, 10,
    5, 11, 29, -1, -30, -14, 7, -21,
    0, -1, -32, 24, -17, -15, 9, 11,
    -27, 12, -33, -13, -1, 16, -13, 10,
    -4, 0, 6, -18, 58, 27, 30, 3,
    2, -32, 29, -8, 4, -28, -6, 8,
    -10, 18, -18, 24, 16, -7, 13, -47,
    -1, -1, 22, 3, 15, -13, -10, 13,
    12, -18, 5, -6, 44, 22, 15, -23,
    -13, 15, -24, 31, -20, 8, -24, 12,
    -12, -10, -17, 23, 20, -30, -12, -3,
    -9, -3, 34, -11, 2, -15, -1, 10,
    -6, -14, 5, -2, 15, -20, -36, 55,
    -5, -13, -26, -8, 2, 9, -3, -29,
    -22, -15, -47, 7, -1, 34, 22, -14,
    -9, -32, 16, 2, 7, 30, -24, 24,
    -14, -13, -5, 0, -11, -5, -17, -30,
    -44, -11, -19, -3, -44, -51, 5, -4,
    13, 14, -5, 1, 25, 8, 14, 40,
    18, -11, -10, 43, -16, 27, -17, -10,
    -4, -4, 1, 18, -10, -20, 18, 68,
    -39, 0, -7, 6, -49, 13, 9, 16,
    17, 7, 5, 5, 15, 5, 4, 2,
    -3, 17, 2, 21, 4, 17, -12, -25,
    3, -20, -27, 9, 15, 4, 21, -16,
    -26, -24, -37, -6, 0, 7, 5, 29,
    -8, -10, -5, 7, -3, 9, -9, 1,
    -2, 31, -20, 4, 6, -6, -1, 13,
    -11, 8, -10, -8, -23, 35, 2, 5,
    -28, 7, 5, -19, -11, -50, -9, -20,
    22, -27, -1, -4, -2, 1, -26, -25,
    35, 5, 27, -17, 4, 3, -26, 12,
    -3, -3, -4, -15, 9, 27, 11, 5,
    -22, -12, -1, -8, 15, -11, 23, 13,
    21, 21, -28, 19, 5, -37, 15, -15,
    -15, -13, 24, -14, 12, 7, -6, 0,
    -8, -8, -1, 6, -47, -14, 9, -10,
    -1, -35, -8, 5, 13, 19, -5, 21,
    -9, -8, -6, 6, 0, -12, -11, -15,
    6, 13, 1, -8, 18, -17, 0, 28,
    -36, -6, 42, 10, -24, -12, -2, 11,
    23, 19, -26, -5, -4, 8, 1, -1,
    -19, -2, -20, -1, 14, -6, 11, -2,
    -4, -20, 0, 3, 20, 12, -17, 10,
    3, -3, 14, -5, -11, -9, -14, 3,
    -3, 3, -39, -9, -11, 10, 19, -12,
    -19, -11, -6, -13, -4, -4, 1, -4,
    -3, 0, -34, -10, 12, 7, -1, -29,
    -4, -3, 2, 0, -13, 29, 15, -12,
    -37, 0, 21, 16, 4, -7, 26, 2,
    29, 21, 5, -20, 1, 1, -5, -17,
    33, 21, 39, -25, -31, -21, 7, 24,
    28, -1, 10, -14, -6, -15, 38, 30,
    16, 0, 29, -51, 13, -26, -5, 32,
    2, -2, -9, 4, -33, 20, 18, 6,
    -12, 6, 16, 8, -9, 34, -9, -11,
    10, -53, -10, 26, -27, 2, 16, -20,
    -1, 41, -49, 29, 7, 45, -2, -8,
    -2, 26, 5, 5, 14, -29, -8, -1,
    -29, 53, -5, -19, 8, 4, -17, -15,
    -9, 6, -9, 4, 11, 12, -1, -1,
    -32, -43, 43, -4, 26, 27, -29, 32,
    -6, -16, 9, 13, 11, -15, -40, 17,
    -15, -2, -24, 4, -13, -6, 10, 7,
    5, 10, -12, 0, 12, 20, -29, 10,
    0, 27, 22, 5, -8, 19, 4, -17,
    -25, -12, -26, 19, 22, 14, 17, 10,
    6, -45, -8, 1, -11, -9, 9, -5,
    3, -12, -9, -2, -7, 28, 23, 7,
    -35, -10, 20, 33, -16, 0, -6, -8,
    -20, 19, 8, 2, -33, -4, -19, 8,
    5, -8, -2, -9, 18, -9, -5, 14,
    -6, 12, 11, 10, 16, -21, 4, -28,
    10, -12, 6, 19, -1, -14, 14, -2,
    5, 5, 0, 7, -9, 14, -20, 20,
    18, -12, -23, 20, 4, -18, 11, -14,
    -5, 21, 4, 39, 10, 4, -28, -9,
    -36, 8, 13, -24, 7, 10, 21, -1,
    16, 0, 9, -20, -1, -40, -3, 2,
    -11, -43, 24, -29, 7, 7, -10, 2,
    13, -18, -2, -3, -51, -23, -42, -34,
    -28, 4, 2, 11, 30, 15, 19, -17,
    46, 12, -2, -24, -24, -1, -21, -15,
    12, -7, -40, -17, -7, -8, 8, 13,
    -7, 0, -3, 2, 13, -1, -7, -4,
    -35, 36, 5, -14, -8, -21, -10, -12,
    -23, 8, 0, -9, 8, 8, -13, -33,
    -4, -4, 25, 15, 17, -4, 2, -8,
    -6, -11, 6, -7, 7, 8, 19, -2,
    49, 9, -18, -45, 13, 55, -37, 31,
    60, 26, 2, -8, -85, 2, -13, -2,
    -5, -14, 14, -44, -18, -3, -9, 13,
    10, 5, 7, 22, -32, -44, 31, 37,
    16, -11, -3, -22, -17, -36, 5, -15,
    -4, -9, 10, 17, 2, 8, -5, -7,
    19, -8, -23, -18, 7, 28, 14, 4,
    5, -31, 1, 15, 16, 0, 1, -73,
    7, -18, -6, 9, 19, -34, 3, 45,
    6, 4, 1, 6, -11, 0, 10, -15,
    22, 11, -26, -34, -3, -10, 0, -16,
    7, 22, 19, -10, 23, -15, 34, 13,
    20, 14, -20, 27, 8, -17, -35, -10,
    -19, -1, -15, 1, -7, -8, 17, 12,
    -41, 6, 13, -7, -9, -2, -6, 6,
    -16, -2, 10, 6, 40, -8, 23, 31,
    23, -4, -2, 38, -43, 23, -6, 32,
    -2, 8, -24, 8, -7, 8, 19, -9,
    -28, 2, -26, -11, -21, -12, 27, 5,
    -1, 8, -8, 11, -10, 13, -21, 26,
    12, -5, -13, -41, -20, 12, 27, -3,
    -24, 5, 22, -1, 26, -16, 3, 10,
    -2, 14, -60, -14, -31, 11, -40, 10,
    -5, -13, 22, -31, -24, -6, -6, 2,
    10, 17, -29, -14, 7, -28, 17, 37,
    12, 0, -9, -5, 1, 0, -8, 14,
    -35, 5, 14, 7, 22, -6, 7, 14,
    -27, -6, -12, 3, -14, -15, -10, 24,
    -13, 8, 30, 31, -12, 33, 3, 22,
    0, -12, 12, -4, -14, -9, -17, 34,
    -5, -18, 17, 17, 36, 22, -8, -24,
    -8, -16, -14, 11, 4, 9, -28, -56,
    94, 2, 27, 23, 46, 18, 48, 18,
    -19, 6, 20, 3, 1, 22, 5, -3,
    -14, 22, -49, 33, -8, 7, 6, 10,
    14, 19, 18, -35, 16, 51, 7, -33,
    27, -4, 14, -63, 27, -12, 25, -66,
    6, -5, 24, -11, 6, 11, 3, -1,
    17, -13, 31, 11, -7, -1, -9, 2,
    7, 4, -18, 32, -20, -30, -18, 64,
    30, 36, -16, 20, 50, 0, 8, 13,
    3, 6, -3, -8, -9, -3, 7, 1,
    77, 17, 13, -13, 9, -9, -32, 8,
    -40, 1, 8, 3, -65, -16, 39, 10,
    -35, -23, 24, 29, 26, 45, 10, 47,
    2, -26, 3, -11, 1, 7, -13, -5,
    -45, 27, -29, -12, -15, -3, -11, 36,
    23, 21, -37, -26, -39, -29, 56, 22,
    5, -9, 6, -25, -11, -45, 39, -14,
    -21, 5, 2, 9, 17, -3, -26, 10,
    14, 10, 18, 87, 6, -16, 6, -14,
    -8, -4, 5, -15, -7, 66, 20, -59,
    -13, -21, 23, 1, -16, -10, 26, 12,
    -2, 16, 16, 10, -8, 17, -9, -15,
    0, -26, 14, 24, 16, 26, -29, 8,
    -7, -32, 2, -24, 30, -33, 0, 54,
    21, 5, -14, -6, 65, -2, 7, -38,
    -12, -20, -4, 5, 20, 7, -7, 12,
    13, 44, -7, 25, 1, -23, 17, -14,
    -6, 11, 22, 27, -11, -26, -3, 5,
    2, 32, 34, 28, 44, -12, 6, -11,
    28, 3, 3, 14, -10, -2, -15, -6,
    -24, -23, -14, -1, 14, -1, -20, -7,
    8, -9, -31, 13, 47, 39, 12, -29,
    -12, -2, 6, -58, -32, -41, 31, -46,
    -17, 35, -4, 8, 14, -5, 2, 6,
    13, -3, -12, -7, 20, 31, 7, 4,
    -3, 11, 7, 27, -33, 3, 32, 2,
    25, -5, 3, 31, -36, 10, 18, -14,
    26, -11, 0, 27, 1, 3, 1, -19,
    5, -53, 5, -6, 16, 30, 9, -3,
    -8, 16, 5, -31, 69, -30, 30, -42,
    -84, 1, 54, -22, -41, -31, 69, -12,
    -8, -19, -2, 3, -7, -8, 5, -12,
    -4, -8, -35, 0, 3, -1, 9, -15,
    12, -1, 2, -3, 71, 30, -10, -4,
    15, -53, -41, 2, -12, -1, -13, 93,
    -11, 7, -5, 24, 2, -10, -7, -22,
    5, 3, -9, 27, 19, 17, -11, 14,
    -37, 11, 55, -12, -27, 35, 30, -35,
    4, -17, -53, 16, -33, -14, -9, -7,
    -11, 8, 23, -6, -3, -15, -2, -6,
    32, 0, 25, 6, -10, 23, -23, 8,
    6, -18, 28, -4, -52, 6, -31, 14,
    -23, 40, 15, 27, 6, -16, -17, 17,
    7, 9, -9, 26, -1, -6, 6, -21,
    8, 17, -41, -24, 1, 11, 9, -65,
    10, -3, -2, 8, 8, 81, -8, -21,
    26, 5, -5, 9, 18, -5, 4, -1,
    12, -9, 25, -17, -4, 6, 4, -18,
    -39, 5, 10, 49, -22, -5, 4, 0,
    33, 18, -12, 2, 8, 8, 7, -4,
    -30, 2, 28, 29, 26, 17, 34, 15,
    19, 7, -8, 11, -27, 20, 7, -15,
    -4, 5, 7, -15, -11, 37, -9, 5,
    56, -43, 19, 20, 14, -1, 12, -15,
    15, -25, -35, -18, -23, 5, 38, 46,
    13, 25, -24, 9, 9, 0, -14, 20,
    1, 23, 14, -14, 2, 13, -4, 4,
    1, 33, 0, 13, -13, 17, -15, -9,
    66, -14, 12, 2, -34, 32, -44, -19,
    -15, -12, 17, 12, 7, -22, -20, -6,
    4, 26, 0, 1, -13, 11, -22, -9,
    -24, -26, 12, -6, 16, -1, 7, -6,
    -20, 21, 21, 11, -9, 5, 3, 5,
    2, -11, 22, 24, -19, 4, -2, 13,
    -20, -22, -3, -3, -20, 11, 9, 0,
    32, -7, -16, 14, 13, -8, -54, -1,
    -4, -16, 7, 9, -20, -43, -52, -48,
    13, 4, -6, 2, -20, 5, -2, -10,
    6, -26, 20, 15, 30, 6, -24, 42,
    -12, -1, 22, -13, 38, 51, 7, 11,
    7, -37, -8, -15, -15, -29, -20, -36,
    6, -3, 5, -4, 4, 14, -4, -2,
    -10, -9, -1, -18, 24, -3, -1, -37,
    -8, 20, 8, 56, 1, 7, -13, 5,
    27, -19, -16, -4, 30, 32, 28, 36,
    4, 13, 8, -7, 2, -1, -15, -3,
    31, 19, 18, -28, 5, 3, 34, -21,
    27, 14, -12, 9, 10, -32, 27, 17,
    20, -10, -17, -4, -23, 40, 12, -5,
    -11, 4, 10, -5, -15, -6, -7, -9,
    -25, 2, 19, -15, 7, -4, -28, 10,
    -9, 2, 13, 16, -11, 23, -7, 22,
    13, -2, 20, -12, 30, -31, 5, 17,
    0, -1, -1, 16, 4, -1, 11, -10,
    -7, 16, 37, 5, 32, -8, -8, -18,
    -22, 5, 10, -18, 127, -12, 47, 11,
    48, -43, 31, 38, -26, -91, 36, -51,
    124, 5, 39, 3, -73, 18, -8, 40,
    -8, 43, 17, -31, -70, 8, -22, 3,
    -16, 5, 27, 4, 14, 1, -47, -5,
    13, -64, 45, -23, -19, -38, -44, -14,
    -30, -8, 21, -12, 2, 26, 10, -3,
    8, -3, 12, 51, 30, 38, 29, -10,
    9, -37, -2, 23, -38, 36, 32, 48,
    36, -24, 25, -49, 17, 13, -24, -51,
    13, 18, -46, 16, -17, -14, 4, 33,
    24, 76, 14, -39, -21, -51, -2, 23,
    7, 22, 70, 0, 8, -62, -31, -47,
    26, -54, 52, -19, 35, 30, 5, -30,
    -67, 34, 7, 9, -9, -27, -30, 1,
    25, -4, 28, 32, 5, -12, 15, -28,
    -3, 9, 11, 15, 5, 18, 16, 17,
    6, -5, 4, 25, -10, -25, -30, -58,
    1, -2, -58, -37, -18, 17, -8, 26,
    8, 4, -31, -16, -28, -22, 34, 28,
    5, -2, -12, 20, -5, 34, -17, -53,
    18, 37, -33, -37, -4, 31, 25, 39,
    -71, -13, 33, 0, 8, -27, -14, 5,
    -40, 11, 72, -1, -50, -5, -66, 27,
    52, -12, 78, -51, 13, 20, -110, -11,
    11, -53, 14, -42, 16, -21, -35, -30,
    34, -24, 0, -27, 11, -29, 1, 8,
    30, 0, 18, 53, 27, 9, -6, 20,
    -66, 12, -2, 0, -12, 64, -18, -50,
    32, 4, -42, -35, -35, 29, -10, -43,
    30, -5, -10, -62, 15, 20, 19, 11,
    -7, -21, -53, 38, 47, 25, 33, -50,
    -37, -22, -18, 63, -79, 60, 42, 70,
    18, 36, -32, 27, -66, 0, 9, -26,
    49, -6, -16, 5, 8, -13, 3, 4,
    94, 26, 31, -8, -49, -7, -91, 5,
    15, 83, 111, -81, 9, -12, -35, 37,
    -6, 45, 44, 11, -50, 8, -51, 29,
    -21, -18, -8, 68, -9, -1, -39, -32,
    39, 57, -47, -31, -4, -19, -18, -18,
    28, 5, -30, 74, 1, -5, -36, -32,
    -22, 46, -51, -7, 12, -63, 27, 65,
    -7, -8, 23, 0, 30, 3, -8, 2,
    -4, -3, 39, 18, 4, -5, -30, 13,
    -58, 5, 30, 9, -4, -33, -31, -14,
    -2, -31, 47, 51, -16, 10, -16, -32,
    35, -28, 41, -10, -31, 23, -2, 30,
    -11, -29, -47, 28, -42, -5, -23, 60,
    55, 24, -39, -36, -16, -38, 31, -67,
    -19, -3, 25, -6, -28, 10, -34, -32,
    -7, 37, 56, -13, 24, -3, -30, 3,
    6, -4, 2, -17, 51, 20, 1, -23,
    -36, -17, 15, 13, 41, 24, -9, 9,
    -14, 35, 19, 74, -46, -31, -7, -17,
    63, -8, 45, -15, -18, -19, -28, -19,
    -11, -5, -16, -76, 39, 20, -93, 7,
    -21, -51, 25, -63, 14, 88, -24, 52,
    -2, 26, 45, -48, 10, 67, 0, 37,
    -30, -8, 27, -70, 36, -19, -17, 31,
    -17, -22, -6, -34, -5, -37, -29, -18,
    6, 19, 56, 39, 73, 43, -19, 95,
    -10, 6, 17, -17, -7, 45, 15, 9,
    30, -9, 24, 22, 2, 0, -12, -22,
    4, -4, -2, -54, 64, 0, -26, -11,
    0, -26, -71, 4, -36, -16, -76, 26,
    -12, 72, 73, 22, -31, 17, 56, 36,
    -2, 33, -16, 23, 25, -18, 1, 11,
    -14, 12, 45, -32, 27, 21, 2, -6,
    7, 10, 26, 45, -1, -44, -26, -38,
    -74, 24, 1, -18, 24, -30, -50, 17,
    17, 32, 17, -16, 19, -21, -18, 19,
    -40, 53, -43, 26, 53, 27, 38, 19,
    10, 0, 40, -23, 64, 46, -27, -42,
    54, 49, 37, -20, -12, 49, 18, 8,
    -17, -22, 13, -10, -7, 26, 0, -3,
    58, 0, 22, -11, 18, -11, 11, -19,
    26, -13, -11, 11, -4, -7, 33, -12,
    46, 24, 19, -44, 21, -21, 26, -70,
    4, 38, -1, 1, 18, 2, -4, 4,
    26, -25, 19, -3, 18, 15, 0, -7,
    -74, 7, 97, -56, 39, -50, 6, 14,
    -93, -36, 45, 3, -14, -30, -12, -23,
    3, 6, 29, -13, -38, -30, -42, 1,
    41, 37, -18, 5, 7, 56, -33, -8,
    -2, -45, 91, 0, 54, 31, 13, 21,
    -21, 1, 45, 17, 17, 43, -50, 5,
    4, 25, -6, 25, 6, 12, -13, -3,
    13, 59, 28, -9, -18, -26, -30, -99,
    15, 13, -37, 16, 18, -53, -24, 10,
    -31, 11, -9, 18, -64, -41, 0, 52,
    -39, -18, 15, 17, -1, 14, 10, -4,
    6, 5, -30, 13, -50, 1, 7, -10,
    96, 33, -7, 18, 25, -5, 24, 4,
    0, 18, 2, 68, 1, -3, -13, -6,
    12, -9, -37, -9, -31, 18, 5, -9,
    3, -12, 19, -27, -74, 53, -23, -13,
    117, -46, 34, 58, -28, -42, 6, -4,
    -8, 39, -38, -3, 71, -26, 1, -17,
    16, 1, -8, 40, 6, 16, -10, 13,
    8, -72, -28, -7, -12, 30, -8, -16,
    31, 58, -19, 23, 35, -29, -20, -18,
    -14, -6, 4, -14, 61, -17, 24, 64,
    -4, 46, 19, 14, 4, 0, -39, 0,
    36, 93, 4, -33, -7, 27, -64, 26,
    -52, -72, 30, -5, -48, -13, 27, -17,
    46, -7, -81, -1, 25, -34, 12, -3,
    14, 3, 38, 16, -37, -9, -13, -4,
    18, 19, -7, -9, -84, 2, -9, -10,
    51, -17, -30, 13, 12, -14, 10, -12,
    52, -68, -59, -64, 2, -56, -23, 10,
    54, -27, -27, 8, -18, 11, 9, 13,
    28, 1, -6, -35, 59, 9, -23, 80,
    -11, -5, 18, -82, -1, 20, -44, 40,
    -45, -33, 12, 14, 3, -23, 1, 10,
    22, 12, 6, -38, -3, 0, 3, -20,
    6, -6, -14, -21, -3, 2, -9, -85,
    -24, 32, 23, 88, -33, -7, 34, 48,
    43, -10, 1, 15, -72, -57, -30, -28,
    -54, -40, 38, 47, 27, 6, -9, -17,
    -16, 7, -7, 27, -13, 5, 26, -78,
    60, 31, -28, 29, 63, -39, -5, 28,
    2, 5, -25, -61, 39, 23, -23, -37,
    -29, 9, 7, 2, 30, -12, 4, 2,
    -64, 34, -30, 29, 11, -28, -18, -22,
    10, 28, 24, 12, 28, 19, -6, 30,
    -10, -29, 15, 76, -30, 44, 12, 1,
    -11, -25, 10, -6, -23, -13, -12, 2,
    -8, -12, 0, 49, 32, -17, -24, -41,
    -63, 32, -3, 13, -115, 38, -21, 58,
    -4, 3, 16, 7, -5, -18, 16, -22,
    -17, -14, -44, -27, -7, 2, 4, 45,
    -28, -2, 7, 1, 18, -20, -8, 6,
    19, 12, 31, -10, -21, 19, -5, -4,
    13, 9, -3, 28, -3, 10, -2, -17,
    -23, 11, -4, 25, 30, 5, 4, 17,
    -19, 6, 2, 8, -23, -21, 5, -8,
    -25, -10, 12, 15, -10, -22, 1, 8,
    -27, -1, -1, -46, -5, -27, 12, 4,
    -14, 49, -7, 69, 22, 6, -12, 22,
    35, 7, -16, 9, 30, -7, -12, 6,
    46, 20, -12, -9, 11, 15, 3, -6,
    -3, 22, -21, -8, 9, -20, 52, -10,
    4, 5, -31, 18, 1, 36, 1, 3,
    -11, 2, -10, -69, 12, 4, -19, 13,
    16, 30, -22, -19, -2, -27, -13, 3,
    -41, -8, 10, -22, 18, -5, -20, 23,
    15, 33, 33, -22, 5, 45, -19, -15,
    10, 11, 3, -26, 0, 8, 15, -10,
    -22, -5, 12, 8, 9, 1, 25, -15,
    -20, -11, -12, -13, 22, -25, 14, -24,
    -19, -2, -35, 0, 65, 5, 21, 18,
    13, 16, -22, -9, 8, 7, -9, -13,
    -13, 49, 2, -13, -26, 16, -5, 20,
    0, 29, 9, -42, 20, -18, -15, 31,
    -51, -13, 25, 36, -14, 32, -25, -4,
    17, 3, 22, 54, -10, 11, -11, 9,
    17, -15, 1, 34, 10, 0, 5, 16,
    1, -22, -16, 27, 11, -25, -23, -7,
    -21, 11, 10, -28, -53, -38, -18, 1,
    -28, -13, -9, 19, -27, 26, 11, -5,
    16, 42, 23, -9, -16, 2, 1, 3,
    -20, 29, 4, 16, -28, 34, 9, 6,
    -40, 30, 11, 15, 30, -58, -24, 4,
    2, 3, -7, 4, -16, -1, -10, 9,
    -7, 13, -10, -28, 4, 15, -34, -6,
    1, 10, 3, 39, -5, -25, 36, -5,
    -8, 11, 12, 34, 11, 6, 0, 14,
    47, 11, 17, 31, -7, -5, 13, 16,
    2, 19, -6, -5, -15, -4, -24, 12,
    -7, -25, 12, 5, 17, 15, 23, -17,
    -14, -16, -30, -19, -33, 21, -8, -7,
    13, -14, 4, -3, -2, -5, 13, -26,
    -3, -37, 9, -1, 16, -6, -12, 5,
    -14, -2, -22, 3, 16, -2, -7, 10,
    59, -9, 3, -8, -24, -11, 13, -26,
    7, -6, 37, 17, -18, 31, 2, 12,
    -17, -20, 1, -29, -6, 5, -5, -6,
    -7, 4, 19, -10, 12, 8, 20, -9,
    10, 12, 9, -20, -28, 20, 27, 0,
    30, 17, 11, -2, -9, 14, -10, 18,
    24, 47, 15, 39, -4, -18, -2, -17,
    -29, 10, 12, -27, 34, -8, 20, 34,
    -18, 21, -28, -9, 27, 13, 28, 16,
    6, 31, -6, -11, 24, 6, -4, 26,
    -18, 12, -5, -26, 12, 29, 21, -22,
    -15, 36, -18, 39, -16, -70, -12, -10,
    20, 45, 14, 11, 5, -41, -14, -37,
    -1, -13, 3, -16, -4, 46, -20, -14,
    -22, 13, -3, 6, 5, -8, -2, -25,
    13, 1, -3, 9, 1, 11, 1, 5,
    -16, 19, -67, -5, -1, 46, 12, 4,
    21, -17, 0, 11, -12, -2, 26, -4,
    7, -8, 12, 13, 6, -11, -26, 3,
    10, -11, 22, -20, -22, -42, 2, -16,
    -21, -3, -11, 18, -19, -10, -52, 0,
    15, 24, -4, 29, -5, -13, 15, 11,
    21, 12, 30, 3, -5, -4, 5, 3,
    27, -5, -15, 2, 5, 29, 21, -27,
    35, 19, -21, -36, 30, 9, 11, -51,
    4, 36, 27, 27, 32, 13, -12, -1,
    25, -21, -10, -39, -13, 6, -28, -23,
    -14, -3, 25, 12, -4, -7, -2, 5,
    14, 6, -27, 19, -24, 31, 13, -2,
    -36, -5, 16, -19, -2, 10, 5, -1,
    -32, -25, 9, -15, -3, -30, -20, 0,
    11, -3, 12, 9, -17, -53, -7, -33,
    -18, -7, 6, 7, 35, -4, 1, -13,
    20, 0, 28, -8, -4, -22, 9, -23,
    -2, 27, 37, -9, 5, 3, -22, -14,
    15, 4, 24, 10, -2, 37, -9, 13,
    -15, -26, 69, -6, -14, 15, 20, 11,
    23, 3, 23, -9, 8, 0, -2, 18,
    0, -19, 14, -15, 8, 3, 17, -14,
    -2, -4, -19, -16, 0, 23, 7, -31,
    -2, -41, -47, 12, -5, -1, 2, 7,
    17, -13, -15, -8, 2, -57, 10, -11,
    0, 22, 15, 2, 19, 2, 14, -20,
    -32, -2, -12, -6, 26, 9, -2, -11,
    17, -3, -3, 63, 25, -7, -24, 4,
    -3, 15, 26, 7, -2, 36, 5, 4,
    -26, 16, 20, 35, -9, -30, -8, 14,
    18, 26, -30, 21, -14, -13, -5, -31,
    0, -11, -22, -49, -32, -3, 21, 14,
    14, -58, 9, 6, -21, 0, 6, 1,
    -1, 37, -15, 9, 1, -6, -11, 11,
    20, 20, 11, -9, -13, 1, -4, -22,
    52, -33, -17, -6, 8, 43, -2, -27,
    15, -16, 22, 32, -14, 0, 4, 2,
    6, -22, -3, 27, 6, -26, -6, -18,
    -11, 13, 7, 18, 8, -36, 16, -37,
    18, -53, -3, -32, 46, 3, -11, 7,
    -2, -4, 6, -10, -3, 12, -5, -4,
    -1, -11, -25, 8, -16, 2, -14, 0,
    -17, -9, 18, 15, 6, -1, 9, -15,
    -22, 8, -3, -17, 1, 5, -9, 11,
    21, 9, 9, 7, 17, 19, 16, 0,
    -29, 4, 11, 5, 5, 0, 19, 0,
    0, 8, -7, 16, 8, -6, 10, 1,
    -47, 32, -4, 4, -10, 19, -15, -14,
    32, 13, 21, -30, 16, 8, 2, -6,
    -6, -3, -8, -22, 12, -7, -24, 7,
    -18, 25, 8, 4, -4, -17, -12, 22,
    41, -28, -1, 65, -3, 12, -5, -5,
    16, -2, -14, -2, 14, 27, 19, -22,
    21, 1, -16, -20, 11, -2, -6, -38,
    -10, -4, 17, -28, 7, 17, 26, -6,
    47, -56, 53, 8, 28, -20, 12, 8,
    -29, 15, 3, 23, -2, 7, 3, 23,
    -9, -8, -13, 23, 4, 1, -20, 1,
    -10, 12, 39, 9, -3, -21, 15, 9,
    8, -8, -12, -1, 2, -19, -69, -28,
    -25, -27, -6, -4, -2, -4, -7, 13,
    19, 3, -14, -4, -17, 16, -15, 5,
    -11, 8, -33, 0, -21, -3, 11, 4,
    -20, -29, 34, -13, -6, 11, -25, 1,
    -2, -14, 17, 13, -16, -27, -15, -16,
    25, 13, -7, 5, 9, 0, 2, -8,
    22, 4, 2, 22, 0, 53, 47, -25,
    -4, 3, -4, 26, -13, -12, -11, -8,
    -7, -22, -3, 15, -4, -10, -11, -14,
    12, -50, 24, 25, 2, -5, -18, -36,
    -14, 3, 25, 13, -12, 19, -6, 20,
    -10, 15, 3, 23, 44, -19, 1, 31,
    -28, -1, 18, -26, -7, -18, 1, 2,
    -39, -35, 21, 0, -20, -32, 10, -15,
    -27, -1, 8, -8, -4, -35, -36, 47,
    -24, -10, -37, 21, 3, 15, -18, 12,
    45, -4, -21, -4, 2, -14, -9, -15,
    19, -30, -25, -20, 10, 54, -12, -12,
    36, 9, -42, -27, -28, -38, -36, -32,
    12, -21, 28, -15, 13, 14, -36, -19,
    41, -9, -42, -81, 10, 17, -3, 35,
    13, -8, -41, -25, 7, -28, 19, -7,
    23, -3, -9, -16, -53, 2, 48, 18,
    28, -30, -6, -32, 18, 19, 7, -25,
    41, 30, 58, 0, 2, -3, -11, 2,
    -16, 2, -39, 15, 8, -14, -10, -17,
    28, 1, -9, 10, -18, -25, -11, -1,
    2, -11, -4, -3, 6, -23, 25, 20,
    41, -1, -10, -17, -5, 25, -54, 8,
    -43, 56, 10, -26, -18, -16, -34, -1,
    0, 30, 14, -26, 19, -29, -10, 14,
    15, -30, 4, 57, 16, -16, 1, 44,
    12, -10, 16, 94, -38, 25, -3, 14,
    15, -21, -37, 40, -5, -1, -13, -26,
    15, 13, -12, 63, 34, -68, 7, -23,
    30, -12, 4, 35, -6, -3, 21, -20,
    -1, -9, 23, 49, -3, -8, -3, 4,
    22, 54, 8, -22, -48, -7, 18, -3,
    15, 35, 31, 32, -9, -39, 3, 32,
    32, 23, -41, -23, 13, 4, -31, -26,
    -51, -4, 29, 6, 2, -4, 16, 6,
    -21, 27, -33, -36, -13, -9, 4, 6,
    4, 22, -14, -40, -29, -38, -87, -9,
    -5, 20, 23, -32, 55, -1, -29, -17,
    72, 14, -41, -27, -11, 18, 3, 25,
    45, 33, -58, -7, 3, 14, 11, 9,
    13, -7, 7, -18, -18, 11, 28, 13,
    -39, 10, 11, -8, 6, 19, -19, -4,
    21, -11, -2, 0, -21, 7, -4, 7,
    2, -37, -47, 8, 13, 4, -13, 3,
    -8, 1, -32, -13, -40, -4, -20, -6,
    -25, 0, 18, 13, 22, 16, 46, -12,
    -27, 40, 59, 4, -9, 23, 11, -10,
    -20, 48, 5, 22, 1, 13, -12, -22,
    -24, 7, -21, 26, -17, -25, 11, -23,
    -7, -21, -27, -26, -65, 22, 26, -6,
    9, -9, 3, 5, -11, -1, 14, 3,
    -2, 36, 4, -51, 0, -9, -6, -2,
    -11, -5, -1, 28, 11, -1, 0, -44,
    6, 4, -3, -34, 25, -15, -7, 2,
    42, 10, 1, -18, -4, 12, 12, 25,
    24, 52, 17, -41, -2, 8, 0, 16,
    45, 8, -16, -4, 15, -11, 52, 18,
    1, -50, -1, 40, 2, 6, 8, 7,
    -8, -16, -2, -67, 10, -10, 5, -10,
    0, -15, -13, -16, 38, -15, -16, -13,
    -31, 0, 9, -16, 24, 13, 37, 4,
    5, -9, -13, 2, -49, 43, 16, -37,
    72, 10, 7, -7, -3, 0, -4, 3,
    46, -4, 12, 41, -13, 6, -24, 7,
    17, 31, -20, 9, -46, 19, 1, -21,
    7, 30, -32, -26, -12, -27, -49, -3,
    9, 14, 30, -9, -4, -28, 9, 22,
    39, 32, -5, 3, 6, -9, 6, 9,
    22, -41, 23, -9, -6, -8, 3, -24,
    -38, -2, -9, 13, -23, 1, 36, 10,
    0, -2, 37, 51, 7, 20, 7, -10,
    38, 6, -20, 12, 26, -18, -23, -31,
    -23, 39, 25, 1, -48, 11, 33, 8,
    23, -18, 8, 18, -14, 14, -16, -15,
    -42, -2, 38, -11, 42, -14, 1, 13,
    1, -1, 96, -6, 18, -13, -33, 0,
    24, 26, -19, 35, -24, -29, -16, 11,
    -37, 29, 9, -22, -22, 7, -2, -18,
    76, 18, 15, -9, -19, -24, 3, 11,
    6, 55, 31, 48, -18, 11, -13, 27,
    3, 40, -63, 14, 32, 3, -55, -15,
    8, -12, 0, -2, 30, 18, -42, 23,
    -9, -62, 58, -22, 15, 4, -14, 15,
    31, -32, 35, -30, 12, 33, 9, -8,
    24, 1, 18, 10, -1, -22, 7, 1,
    8, -33, -11, 14, 3, 34, 14, 21,
    19, 2, -15, -39, 7, -41, 3, 4,
    -9, 24, -42, 21, 7, -9, 48, -17,
    30, 4, 14, -32, 10, 16, -24, -52,
    -8, -4, -3, -17, -5, -18, -18, 0,
    49, 47, 10, -4, 12, 6, -6, 17,
    -18, -20, 10, 21, 3, 11, 15, 7,
    -16, 0, 25, 23, -7, -6, 17, -13,
    38, 5, -12, -21, -15, 24, 14, 34,
    17, -69, 30, -22, 10, 0, -7, -11,
    -11, -2, -4, 23, -32, 6, 19, -5,
    16, -17, 0, -36, -7, 4, -17, -14,
    -9, -12, 22, 17, -9, -13, -16, -26,
    -8, -46, 41, 18, 6, 10, 9, 24,
    -2, 32, -2, 5, 18, -21, 8, -9,
    40, 11, 10, -12, -14, 10, 20, -3,
    12, -6, -16, 27, -22, 12, 2, -15,
    20, -25, 19, -61, -38, 3, -12, 2,
    -19, -18, -21, 8, -22, 10, 0, -29,
    29, -15, 7, 4, -6, -10, 54, 0,
    4, 13, -20, -21, 14, 15, 6, 13,
    13, -10, -3, 9, -1, 2, 6, -4,
    19, -17, -3, 12, 27, 40, -8, 9,
    43, 16, -14, -4, -7, -13, 33, 4,
    -20, 40, 38, 7, -27, -33, -14, -4,
    0, 12, 14, -28, -47, -11, 19, -9,
    8, -38, -3, -10, 0, 4, -46, -2,
    -23, 19, 20, -2, 13, 9, -13, -18,
    20, 11, 18, -8, -2, 1, 15, 17,
    33, 1, -25, 0, -5, 25, 11, 16,
    2, 4, -34, 2, -13, 3, 0, -4,
    15, 1, 17, 7, -38, -6, 1, 11,
    -34, 19, -5, 58, -9, -19, -20, -4,
    28, 18, -8, 39, -28, 19, 17, 17,
    -2, 19, 16, 26, 28, 7, 19, -15,
    -10, 14, -57, 20, 9, -13, 22, 5,
    -7, 9, 16, 33, 43, -19, -30, -5,
    -25, -37, 2, -7, -11, -8, 18, -29,
    -17, -9, 4, -13, -16, 35, -7, 6,
    29, 22, 21, 54, 3, 5, -25, -8,
    26, 31, 24, 44, -11, 26, -29, 7,
    -1, -6, 22, 36, -17, -17, 3, 9,
    -18, -14, -8, 7, 25, -16, -9, 5,
    21, 58, 10, 63, -20, 41, -21, 50,
    24, 37, -60, -14, -41, -24, -5, -43,
    -6, -18, -43, -18, -28, -18, 16, -23,
    5, -54, 34, 3, 2, 6, 37, -61,
    -33, -26, -35, -41, 20, -7, 40, -30,
    0, 30, 26, -84, -24, -59, 0, -68,
    -8, -6, 12, -2, -27, -18, 4, -8,
    -18, -24, 0, 18, -30, -32, 1, -14,
    8, 29, 13, 48, 19, 61, -15, -11,
    8, 10, 18, -127, -27, 15, 21, -32,
    43, -81, 7, -9, 6, -13, -6, 9,
    6, 38, 6, -127, 14, 74, -16, -36,
    -73, -56, 7, 31, 29, -29, 8, 12,
    -76, -21, 113, -27, 7, -39, -58, 45,
    -15, 16, -41, -66, -15, 4, 19, 11,
    50, 55, -13, -3, 22, -52, 10, 2,
    -21, -5, 21, 2, 41, 43, 15, 24,
    -73, -35, -19, 59, -33, 36, -8, -53,
    22, 29, 62, -25, -32, -25, -14, -46,
    7, 10, 27, 46, -21, -42, 13, -41,
    -24, 37, 12, 30, -34, -2, -52, -19,
    38, 11, 34, 55, 18, 62, -21, 55,
    43, -27, -48, -58, 15, 9, -4, 37,
    3, 69, 6, -61, -27, -71, -30, 19,
    -25, -21, 35, -32, -21, 7, 18, -29,
    -3, -11, -49, 22, 18, -4, -6, -37,
    61, 2, -8, 114, -10, -33, 14, -1,
    35, -36, -49, 15, 27, -27, -6, -36,
    -19, 5, -22, -26, -42, 63, 4, 25,
    -18, 55, 53, 10, 15, 55, 62, 5,
    -19, -16, 14, 15, 12, 2, -43, 25,
    62, 49, 34, -44, -67, -20, 7, -8,
    -45, -46, -45, 19, 17, 14, -15, -37,
    7, -26, -60, 42, -65, 32, -8, -59,
    -57, -19, 39, 0, -21, 9, 18, 19,
    -7, -45, 44, -31, -33, -26, -18, 48,
    -2, -53, 72, 26, 53, 68, 6, 22,
    -38, -74, -30, 13, 1, -97, -6, -11,
    80, -2, -31, 5, -67, 12, 23, -10,
    -3, -16, 4, -31, -1, 7, -15, 3,
    -52, -30, -25, 16, -31, -5, -52, -16,
    53, -25, -22, 11, 20, 38, -32, 30,
    72, -27, 4, 3, -11, 28, 21, 5,
    5, -39, -59, 59, -48, -14, -20, 6,
    43, 14, 32, -31, -4, 22, 36, 4,
    -28, 2, 15, 20, 34, 42, -29, -26,
    -44, 66, 53, -6, 22, 10, 15, 53,
    -9, 23, -1, 16, -12, 80, -12, -76,
    17, 37, 6, -54, -3, 20, 10, 58,
    26, -64, -22, 68, 60, -12, -12, 73,
    36, -31, 2, 3, 22, 37, -24, -13,
    -34, -7, 2, -65, 9, 15, -33, -40,
    7, 4, 40, -15, -33, 74, 19, 0,
    -2, 23, 17, -33, -37, -73, -12, 19,
    44, 39, 29, -20, -9, 11, -4, -10,
    17, -13, 23, 21, 11, 5, -28, 22,
    -53, -60, -4, -34, 9, 86, -6, 16,
    -58, -66, 33, 16, 21, 108, -46, -4,
    -26, 8, -14, -65, -11, -91, 4, -11,
    26, 23, 26, 5, -27, 17, -27, -22,
    3, 6, -36, -38, -85, -37, 17, -20,
    -29, -42, -45, 0, 8, -7, -23, 12,
    81, 12, 29, -7, 35, 3, -5, -26,
    -9, -1, 39, 85, 10, 6, -29, -11,
    1, 46, 8, 11, 9, 11, -21, -22,
    21, 30, 37, 33, -9, 36, 33, -53,
    6, 12, 46, -8, 2, 2, 2, 17,
    28, -6, -41, 29, -37, -56, 20, 18,
    11, 26, -23, -43, -15, -8, -38, -3,
    -6, 13, -42, 37, -15, 21, 46, 6,
    -18, 31, 74, 39, -3, 28, 21, 5,
    45, 13, -5, 18, 32, -11, -27, -44,
    -18, -67, -66, 15, 45, 84, 6, 17,
    3, -26, 8, 16, -88, 10, -47, -15,
    -43, -13, 73, -3, -27, 20, 4, 23,
    24, -41, 41, -14, 11, 1, -24, -9,
    -3, 31, -2, -55, -17, 11, -5, 51,
    10, 10, 17, -78, -27, 10, 26, -33,
    97, -1, 56, 0, -10, 38, -23, -8,
    42, 78, -8, -16, -22, 4, 35, 59,
    6, -27, 12, 32, -72, -42, 84, -1,
    50, -3, -42, -3, -23, 24, 11, -19,
    5, -56, 17, -32, -22, -7, -4, -12,
    36, 9, -45, -38, -15, 78, 13, -38,
    20, 4, -4, 11, 9, 13, 35, 15,
    17, 7, 56, 13, 21, 28, -18, 22,
    11, -4, -10, -82, 16, -59, 0, -13,
    19, -23, 6, 6, 46, 6, 64, -57,
    40, -28, 46, 19, -29, -10, -76, 37,
    -83, -28, -62, 16, 18, -28, -31, 29,
    50, 79, 11, -6, 1, -25, 50, -7,
    -27, 5, -7, 14, 24, 23, -5, -12,
    14, 7, -3, 37, 51, 36, -33, 11,
    -49, 17, 29, 24, -52, 33, 17, -42,
    29, -69, 25, -37, -32, -11, -41, -2,
    -48, -34, 22, 27, -19, 11, 37, -16,
    -14, 81, 34, 9, 3, -12, -7, 53,
    -34, 8, 21, -14, -38, -43, -53, 53,
    21, -42, 50, 29, 0, -32, 7, -40,
    21, 0, 1, 3, 19, -8, 14, -20,
    17, -36, -29, -19, -11, 33, 2, 8,
    28, -103, -15, 16, 32, 7, -20, -31,
    44, -4, 52, -75, 8, -29, 39, 12,
    -15, 38, 10, 22, -35, 5, -18, -33,
    -12, 39, -22, 24, -13, -45, -55, 4,
    -32, 27, 39, -47, 51, 17, 35, -20,
    -2, 5, -11, 16, -1, -8, -20, 20,
    32, -9, 16, -19, 31, 39, -11, -7,
    -9, 20, 26, -36, 3, -74, -59, -5,
    -3, -19, 29, 42, -28, -16, 22, 35,
    39, 16, -11, -17, 23, 25, 3, -11,
    18, -32, 49, 49, 15, 36, -91, -38,
    6, 14, -51, -38, -34, -3, -7, 17,
    31, -3, -38, -18, -32, -6, -39, 30,
    40, 26, -10, -1, -3, 33, 14, 2,
    -16, 15, 27, 1, 2, 44, 19, -28,
    -8, -27, 24, -29, -15, 26, 20, 0,
    30, 28, 3, -47, 38, 8, -24, -76,
    29, -1, -14, -1, 7, 14, 6, 2,
    -57, -38, -11, -41, 18, -6, -10, -24,
    31, -84, 33, -16, -10, 15, -44, 16,
    -22, 2, -55, 23, 8, -32, -9, 92,
    17, -39, 11, 4, -17, 5, 1, -127,
    5, 18, -104, -1, -14, 29, 1, -3,
    3, -57, 54, -66, 10, -27, 30, -86,
    27, -69, 18, 60, 22, 38, -28, 32,
    9, -45, 59, 7, -3, -11, 6, 42,
    -3, 29, 1, -25, 60, -54, 25, 36,
    -20, 15, 9, -8, -26, -22, -3, 34,
    5, -7, 3, 15, -14, 24, 38, -41,
    21, -4, 30, 1, -10, 1, -6, -6,
    24, 25, 23, 1, -9, -13, 0, -2,
    -10, -10, 26, 23, 16, 12, -14, -16,
    -2, -10, 9, 6, -9, 17, -21, 32,
    -16, 22, -22, 25, -6, -13, -6, 4,
    9, 21, 3, -24, 24, 0, 2, -15,
    -7, 34, -3, -9, -16, -1, 24, 9,
    -7, 16, 7, 15, 3, -20, -26, -49,
    3, -21, -11, 9, 4, 12, -4, -3,
    -33, -14, 25, 32, 11, 2, 5, 9,
    1, -33, 13, 6, 13, 32, -17, -36,
    6, -5, 9, -8, 14, 21, -11, -23,
    -41, 36, 6, -31, 10, -12, 5, 7,
    -8, 31, 23, -14, 0, 2, -9, -1,
    23, 1, -5, 23, -31, -7, -28, 1,
    3, -9, -10, -1, -14, -2, -22, -21,
    -17, 15, 23, -16, -17, 6, -9, -27,
    -45, 9, -43, -2, 23, 5, -3, -5,
    -19, 8, -7, -19, -7, 3, 28, 3,
    11, 2, -3, -4, 18, -12, -10, -15,
    -12, 40, 1, 19, -2, 13, 13, 10,
    -27, 24, 28, -34, -3, 0, 4, -10,
    -1, -23, -36, 15, 17, -12, 2, -7,
    -5, 4, -13, -4, -4, -11, 11, 26,
    -6, 23, -7, -13, -22, -9, -14, -1,
    -10, 22, -17, 32, 21, -3, -15, -6,
    7, -38, -62, 12, 7, 2, -16, 58,
    5, 4, 15, 1, -9, -27, 7, 15,
    20, -27, -12, -18, 2, -5, 1, 20,
    -33, -13, -11, -14, -6, -1, -5, 13,
    9, -19, -15, -47, -58, 28, -23, 4,
    -5, 6, 2, 0, 22, 19, 14, 4,
    -7, -31, -49, 2, -2, -27, 4, 1,
    -7, -28, -34, -45, -9, 9, -34, -6,
    -1, 50, -6, -20, 26, -34, -24, 4,
    -7, -3, -12, 13, -16, -27, 7, -7,
    17, -14, -21, 39, -1, 25, 16, 14,
    -4, -23, -12, -28, -8, 2, 20, 9,
    -28, -8, -26, -7, 55, 25, -6, 11,
    0, -5, -2, -14, -13, 20, 8, -17,
    -8, -30, 20, -4, -6, -23, 6, 20,
    36, 6, -23, -40, -6, 3, 9, -34,
    11, -4, 14, -3, 3, 6, -13, -4,
    12, -5, 4, -8, 28, -29, -28, -23,
    -43, 26, -21, 2, -8, 16, 16, -11,
    -11, -18, 7, 12, 6, 5, -6, -24,
    12, -3, 0, 22, -18, 39, 19, -7,
    -9, -8, 4, -14, 23, -1, 23, -6,
    -13, 22, -18, -2, -3, 8, -12, -6,
    -13, -10, 26, 77, -3, 5, 13, -16,
    5, 5, 1, -28, 15, 13, 11, -13,
    -3, -3, -14, 9, -17, -3, -49, -46,
    36, 14, 40, -6, -4, 8, -6, 8,
    24, 15, 23, 10, 5, 15, 13, 19,
    10, -11, 9, -18, 11, -22, -22, 18,
    2, 23, 17, 1, -14, 27, 3, -20,
    -30, 8, 0, 8, 5, 0, 1, -12,
    -27, -44, 2, -7, -2, 17, -3, 13,
    0, 15, 3, -21, -3, -12, 7, -14,
    4, 0, 9, 14, 23, 4, 31, -8,
    -7, -14, 9, -3, 13, -1, -7, -8,
    -15, 19, 50, 10, -1, 3, 5, -9,
    -19, -1, 12, 5, 5, -19, -49, 8,
    -6, -4, 0, 15, -38, -6, -5, -30,
    -4, 7, 12, -5, -6, -32, 5, 18,
    11, 54, 4, -14, 5, 8, -1, 14,
    -15, 16, 24, -16, 2, 2, 3, 22,
    8, 4, -3, 4, -12, -44, 21, -49,
    -31, 33, 28, 5, 17, 23, 5, -4,
    -7, -1, 24, 29, 5, 12, 13, -7,
    11, 4, -9, -22, 9, -4, 16, 12,
    -4, -7, 4, -4, -18, 22, -10, -4,
    38, 6, 6, 12, -4, 22, -8, -5,
    11, 3, 30, 21, -1, 6, 16, -12,
    -28, 31, 16, 23, -15, 0, 6, 31,
    -5, -28, -5, -4, 0, -21, -29, -15,
    -48, 0, 23, 25, 2, -5, 13, -33,
    15, -19, -35, 16, 4, -5, -13, -2,
    -22, -28, 5, 1, 27, -23, -51, -19,
    22, -4, -8, 3, -80, 15, -14, 6,
    19, 32, -13, -13, 24, -2, 2, 4,
    -37, -18, -5, 2, 3, 19, -1, 0,
    -19, -68, -29, -1, 5, 5, -14, 12,
    5, 0, 7, -5, -24, -20, -5, 16,
    20, -34, 33, 26, -1, -5, 3, 6,
    13, 43, 8, 27, -1, 5, 7, -13,
    -9, 36, 8, -8, -3, -24, -21, -32,
    20, 16, -13, -10, 6, -6, -45, -16,
    -1, -31, 11, -28, 6, 10, 26, 3,
    1, 15, 0, -27, 8, 20, 2, -8,
    -14, 10, 9, 11, 32, 0, -11, -9,
    4, 9, 6, 11, -17, -13, 17, -28,
    16, 12, -8, -4, -11, -7, -33, -6,
    -5, -5, 12, 13, -14, -3, 11, 12,
    -17, -25, 7, -12, 20, 16, -18, -4,
    4, -1, 11, -11, 11, 12, -21, 25,
    -24, 60, -13, -48, -9, 11, -5, -13,
    -17, -33, 2, -32, -7, -2, -8, 7,
    33, -30, -29, -16, 2, -23, 45, -8,
    -9, -12, 5, -14, 5, -3, -9, -43,
    -42, -1, 28, -12, 0, 7, 1, 14,
    -32, -8, 59, 8, 14, -7, -7, 2,
    11, 33, -59, -16, -11, -4, 39, -19,
    3, -17, 0, 3, 20, 29, -12, -26,
    17, -8, -7, 15, 13, -9, -6, 11,
    9, 16, -7, -10, 2, 11, -3, -2,
    6, -7, -42, -32, -16, -2, 0, -11,
    -4, 2, 13, -4, 4, 28, 10, 39,
    24, -15, 32, -8, -7, -51, -1, -7,
    24, -10, -7, 58, 9, -17, -3, -8,
    -13, 34, -46, -8, 23, -20, 15, 25,
    -2, 13, -10, 2, -18, -31, -27, -15,
    4, 18, 24, 10, -5, -16, 2, -5,
    0, 23, 12, 4, 24, -1, 4, 6,
    -22, -10, -4, -18, -5, 31, -24, -17,
    -4, -25, -12, -5, -8, -7, 20, -34,
    -34, 26, 34, -24, -7, 20, -6, 5,
    -15, 5, -11, -28, -16, -4, -9, 2,
    33, -7, -25, -6, -7, 9, 28, 32,
    -5, -1, 7, 11, 18, -1, 21, 15,
    -33, 18, -27, 17, -3, -5, -6, -8,
    15, -16, -1, -34, 0, -10, -4, 3,
    43, 8, 19, -32, 3, -36, 14, 35,
    4, -1, -5, -5, -25, -29, -21, 3,
    8, 4, 0, 23, 0, 3, -1, -3,
    -1, -3, -8, 54, -4, 15, -7, -15,
    -2, -5, 17, -1, -10, -11, -34, -8,
    -3, 8, -13, 25, -34, 5, 17, -9,
    -2, -25, -11, 13, -12, 3, 5, -18,
    -23, 5, 2, -31, -4, -13, 9, 3,
    18, -41, -12, -35, 6, 14, -3, -40,
    6, -19, -31, 17, 4, 3, -12, 12,
    15, 5, 26, -46, -26, -14, 5, 4,
    17, 6, -32, 22, 11, -3, 3, -6,
    3, 62, 2, 1, 31, -21, 22, -44,
    1, 31, -6, 21, -3, -24, 6, -10,
    -10, 14, 31, 68, 15, 15, 1, -10,
    -23, 55, -9, -5, 7, -7, -5, 14,
    -17, -26, -21, -35, -32, 24, 6, 30,
    -7, -9, -2, 10, -3, -20, -25, 7,
    25, 20, -22, -5, 35, -15, 21, -15,
    -14, 26, 20, 77, -3, 20, 34, -4,
    0, -13, -28, 1, 5, 1, 29, 22,
    -8, 0, 0, 13, -31, -26, -28, 2,
    8, -2, 31, -8, -15, 12, -20, -16,
    -62, -17, 16, 1, 3, 10, 7, 3,
    -31, 16, 1, -39, -14, -20, 24, 2,
    12, -5, 24, 12, 0, -18, -20, 6,
    34, 37, 12, -17, 2, 15, 14, -6,
    8, -9, 35, -27, -13, -2, 4, 1,
    15, -10, -20, 2, -15, -1, 30, 25,
    24, -53, 14, 11, -39, 10, 12, 12,
    -6, 13, -7, 15, -18, 3, -18, 7,
    13, -5, 39, 23, 25, -9, -5, -15,
    -17, 27, -43, -48, -20, 62, -26, -25,
    17, 12, -7, -34, -36, 9, -37, -22,
    4, 20, -15, 11, -5, 26, 1, 18,
    0, 26, 33, -42, -11, -4, 12, -3,
    -4, -9, -37, -38, -17, -25, 49, -12,
    0, -26, -9, 6, -6, 35, 23, -40,
    -77, 16, -62, 22, -12, 16, -8, 12,
    8, 2, -65, -49, -2, -7, -12, 2,
    7, 32, -31, 12, -7, -47, 12, -1,
    -22, -44, 7, -18, -2, -13, -5, 7,
    13, -32, -52, 9, 7, -17, 11, -2,
    -40, -13, -65, -5, -9, 9, 8, 11,
    -24, -15, 18, -10, -32, 2, -8, -12,
    6, -15, 1, -5, 13, -10, -2, -17,
    4, 11, -1, -24, -19, -23, 31, 23,
    -47, 18, 3, -10, -10, 2, -17, 1,
    -25, -9, -10, -25, 18, 13, -15, -14,
    16, 5, 10, -18, 33, 6, 2, -17,
    -5, -46, 0, 25, -3, 18, 24, 9,
    28, 42, -14, -13, -5, -13, 19, 8,
    -51, 2, -29, -48, -36, 0, -2, -28,
    8, 9, 0, -26, -5, 31, 13, 4,
    41, -28, -42, -12, -30, 8, 3, 20,
    12, 33, 16, -16, -10, -6, 20, -14,
    6, -38, -60, -53, 8, -8, -26, -14,
    -10, -16, -7, 23, -29, -21, -14, -34,
    -18, 4, -21, 7, -3, -15, 2, 2,
    24, -1, -7, 17, 16, 2, 13, 24,
    10, 0, -15, 4, -10, -26, 17, 31,
    -42, -17, 36, 10, -2, 10, -33, -25,
    -56, 20, 6, -5, 27, -9, 8, -15,
    -15, -21, 43, 81, 11, -6, 3, 10,
    3, 32, -21, -22, 10, 0, -1, 14,
    8, -4, -16, 13, 8, -14, 3, -4,
    46, -17, -15, 9, 13, 3, 15, -12,
    -10, 11, -65, -3, -7, 10, -1, -35,
    9, -32, -22, 3, 3, -6, 7, 14,
    -6, -37, 9, 8, -37, -32, 1, -28,
    1, -25, 23, -2, 7, -2, 18, 25,
    -32, 33, 19, -23, -3, -9, 3, -6,
    18, -26, 0, 6, 9, 6, 12, -21,
    -8, 21, 10, -15, 33, -19, -14, 2,
    39, -2, -7, 70, 10, 10, 2, -9,
    -4, 15, 2, -59, 2, 1, 3, -21,
    12, 18, -58, -1, -34, -38, -13, 11,
    -12, -46, 0, -7, -11, 26, -45, -7,
    35, 1, 3, 13, 13, -7, -9, 2,
    66, -90, 7, 18, -1, 7, 26, 0,
    -2, 9, 19, 19, 26, -32, -7, -11,
    -15, -47, -3, 5, 15, -49, 11, 23,
    24, 10, -24, -53, 6, -16, 11, -19,
    -24, -36, 33, -15, 0, 6, -2, 1,
    -41, -18, 36, -9, 30, -19, 2, 5,
    5, -1, 12, -2, -49, -11, -5, -18,
    7, 9, 73, -7, 63, 0, 9, -5,
    -26, -40, -5, 10, -4, 4, -15, 5,
    -25, 23, -55, -3, -15, 28, -29, -17,
    3, -2, -2, -5, -24, 11, -11, 30,
    -4, -13, -17, -14, 1, -22, 33, 7,
    -7, 37, 16, -44, -2, -1, 26, -4,
    -1, 30, 13, -17, 28, 9, -20, -8,
    18, 10, 6, -14, 19, 0, -24, 3,
    -8, 1, -9, -9, -11, -1, 22, -15,
    -40, 16, 53, 15, -1, 25, -2, 2,
    -21, 1, 15, 5, 10, 5, 5, 24,
    2, 10, 16, 7, -23, 9, 18, -44,
    7, 23, -24, -19, -6, 3, -26, -10,
    64, 2, 6, -1, 2, -8, 1, -7,
    16, -53, -1, 33, 4, 3, -21, 12,
    4, -4, 10, 33, 11, -48, -30, 35,
    20, -34, -6, -14, -31, 11, 6, -14,
    34, 17, -33, 51, 17, 4, -8, -14,
    6, -4, -6, -2, -2, 2, 11, 0,
    -19, -5, -9, -27, 11, 7, -11, -41,
    37, -22, -11, -21, 3, -14, 7, 4,
    -41, -63, 18, 24, 9, -11, -20, -21,
    14, -10, -12, -25, -23, 29, 7, -23,
    4, -10, -11, -9, -2, 23, -29, -16,
    10, -6, 5, -4, -8, -6, 11, 16,
    -19, 6, -13, -2, 0, -2, -3, 5,
    -22, -17, -31, -7, -2, -11, -9, 17,
    -10, -3, 23, -22, -18, 21, 10, 0,
    -10, 6, -17, 39, -9, -85, 0, 9,
    -61, -15, 30, -51, 19, -11, -12, -22,
    -29, 17, -32, -12, 6, -15, 15, -14,
    6, 6, 0, -28, -10, -6, -38, -12,
    11, 31, -9, -8, 11, -17, 21, -5,
    -6, 24, 10, -11, 15, -8, -1, 15,
    -3, -43, -21, 2, -11, -42, 20, 5,
    -6, -19, -6, 4, 9, -10, -6, -18,
    -1, -18, 24, -54, -12, 13, 12, -19,
    19, 22, 10, -59, 2, 22, 5, 2,
    -24, -34, 28, -14, 35, -11, -10, 31,
    5, 1, -8, 6, -23, 4, 28, -15,
    -29, -2, -10, 2, 2, -11, -5, 17,
    60, -15, 8, -24, 20, 1, 8, -3,
    10, -11, -13, -61, 13, 23, -25, -92,
    -13, -16, 5, 12, 20, -28, -5, 4,
    -28, -36, -41, -37, 28, 22, 4, 28,
    -16, 2, 3, -36, 13, -27, -30, -14,
    -43, -19, -2, 61, 22, -21, -24, -38,
    -16, 35, -24, 7, 13, 45, 50, 1,
    -18, 25, -18, 14, -13, 2, 48, -41,
    8, 46, 47, 32, -23, 47, 14, -17,
    6, -36, -16, -11, -19, -3, 17, 59,
    -1, -15, -35, 21, -22, 0, 4, 20,
    13, 46, 19, -33, -15, 10, 11, 58,
    -58, 7, -3, 19, 4, 16, -26, 16,
    -24, 34, 16, -20, -12, -46, -6, 10,
    1, 37, 1, 36, -1, -36, 2, -34,
    5, 35, -14, -34, 9, -4, 7, -33,
    -42, 40, -24, 42, 2, 3, -7, -6,
    -34, 17, 13, 9, -5, -34, -62, -61,
    8, -18, -4, 31, -19, 1, -34, 21,
    -15, -16, 31, -32, 16, -2, -16, -3,
    48, -34, 11, -28, 0, -40, 39, -4,
    -17, -8, -10, -32, 25, 38, 0, 11,
    -4, -19, 13, 7, -7, -2, -33, -15,
    -18, -16, 3, 14, -34, -16, -9, 8,
    4, 16, -80, -31, 17, 6, 53, 71,
    49, 70, 27, -11, -11, 35, -127, 26,
    22, -5, 27, 12, -12, 1, -6, 9,
    -56, -73, 30, 14, 0, -9, -2, 2,
    -16, -48, -21, -13, -18, -19, 9, 20,
    42, 14, 5, 33, -23, 48, -79, 48,
    33, -55, 55, 14, 19, 53, 3, -16,
    -25, 11, 0, -28, -3, -4, -84, -45,
    -31, -91, 15, -83, 10, 0, 16, -36,
    -8, -19, 11, 26, -18, -18, -10, -11,
    16, -12, -3, -49, -25, -32, 34, 47,
    71, -10, -18, -16, 28, 38, 42, 34,
    -80, 29, -6, 0, -12, -16, -21, -6,
    -3, -10, 4, 7, 8, 20, -41, -20,
    -13, -29, -27, 8, -28, -2, 49, -17,
    87, 26, 24, 27, 9, -38, 39, 4,
    -9, -9, 124, -11, 7, 29, -19, 17,
    14, -49, 41, -39, 0, -25, 27, 20,
    -27, -85, 5, -43, 8, 18, -31, -4,
    -65, -13, 17, 0, 8, -90, -33, -21,
    -25, -17, 12, -17, 9, 7, 9, 4,
    -21, 3, 20, -33, 17, 2, -10, 6,
    37, -10, -17, -7, 10, 20, 25, -39,
    27, 49, -12, 24, -37, -57, -29, 44,
    -41, 3, 29, -24, -23, 7, -22, 41,
    -35, 82, -10, 39, 3, -27, 11, -10,
    14, 18, -1, -24, 11, -14, -30, 1,
    74, 34, 7, 46, -9, 0, 13, 45,
    50, 29, -21, -27, -26, -17, 11, 52,
    38, 18, -25, 47, -30, 11, -6, 84,
    8, 22, 0, -15, -22, -15, -10, 81,
    -65, 39, 23, -6, -12, -2, -4, 42,
    -7, -27, 11, -28, 12, -29, -26, -14,
    -14, 42, 36, 40, 16, 51, 35, 39,
    4, -44, -19, 24, -20, -12, -12, -52,
    -22, -30, -6, 31, -6, 14, 0, 2,
    18, -34, -23, 3, -9, 1, -2, 0,
    27, -85, -4, -40, 32, 81, 44, -12,
    -50, -26, 43, 3, -14, -38, -27, -36,
    85, -18, 29, -36, 41, -60, 16, -29,
    55, 10, -12, -27, 44, -31, -14, 29,
    11, 30, 55, 2, 14, -32, -11, 12,
    19, 11, -43, 17, 0, 23, 102, -30,
    -8, 23, -3, -9, 6, 0, 17, -28,
    8, 56, -41, -23, -33, 25, 13, -44,
    29, -14, 47, -4, -24, -16, 33, -31,
    -6, -55, 6, -12, -55, 42, 6, 6,
    -33, -16, 0, 5, 38, 12, -22, 49,
    -58, -22, 30, 28, -1, -59, 1, -47,
    -23, 50, -25, 3, -13, 7, -37, -34,
    35, -11, 1, -34, 5, -10, -16, -13,
    -8, -37, -43, -18, -5, -5, 2, 24,
    -34, -33, -50, -54, -31, -18, -16, 13,
    -52, -77, -6, -4, 1, 56, 12, -3,
    -31, -98, -6, -3, -41, 127, 27, 2,
    -48, -10, -23, 9, 8, -38, -2, 20,
    -8, -8, 51, 73, -1, -6, 16, -4,
    -11, -22, 16, -46, -13, 35, -43, 6,
    -12, -76, 5, -32, -9, -99, -17, 78,
    63, 14, 9, 23, 8, -8, 9, -46,
    -37, -63, -64, 55, -5, -14, 8, 17,
    -28, 50, -51, -43, -67, 20, 37, -13,
    -39, -17, -6, 5, -31, -14, 15, 5,
    -19, 21, -30, 20, 73, -17, -9, 2,
    -100, -12, -55, 55, 2, -51, -42, 5,
    -16, -62, -41, 7, -34, -56, 66, -7,
    1, -6, 18, -6, -3, -58, 4, 6,
    11, 40, 17, 26, -7, 49, -2, 23,
    7, 31, 60, -35, -6, -3, 33, -2,
    -23, 33, 80, 44, -20, -26, 4, 3,
    22, 20, 19, -7, -29, 0, -46, 13,
    -12, 2, 4, 31, -16, 2, 45, 20,
    -4, 40, 107, 2, -17, 24, 2, -9,
    28, -5, -44, 9, -14, 18, -4, 14,
    22, 10, 27, 18, -17, 31, -8, -70,
    -1, -26, 1, -24, -22, -17, -13, -3,
    -9, -28, 10, -60, 6, -17, -24, 2,
    -31, 63, -42, -49, -19, -9, 32, 21,
    -4, -8, -10, 76, 19, -4, -59, 6,
    2, 4, -12, 2, -58, -25, 8, -19,
    -10, -22, -26, 8, 25, 8, -54, 8,
    -18, 15, 34, 30, 43, -2, -34, 3,
    4, 10, -21, -37, 1, 1, -6, -44,
    -42, 8, -4, -23, 9, 7, 22, 13,
    58, 71, -28, -1, 49, -29, -29, -21,
    -4, -39, 3, 5, 41, 11, -36, -12,
    13, 9, -6, -3, 16, 31, 7, 5,
    16, -9, -36, 8, -16, 1, 37, 8,
    63, -1, -39, -9, -37, 3, -17, 0,
    13, 20, -30, 20, 33, 14, 19, -24,
    0, -2, 10, -71, 27, 28, -17, 61,
    22, 28, -68, -20, 17, -98, 14, 32,
    30, 7, -15, -24, 7, 19, 28, -25,
    -41, 10, -44, 10, -24, -27, -34, -19,
    -6, 10, -1, -61, -19, -42, -7, 14,
    54, 45, -18, -6, -27, -29, 27, 7,
    15, 61, 17, 12, 15, -10, -8, 12,
    52, 40, -20, -33, 32, -9, 16, 29,
    8, -12, -4, 2, 46, 39, 8, -12,
    20, -14, -22, 6, -28, 21, 28, 43,
    -20, 11, -18, 71, 56, 73, -15, 17,
    -8, -48, -42, -85, -7, -12, 14, 16,
    -16, 0, -2, -9, -24, -33, -36, -24,
    33, 18, 9, -32, -9, -6, -10, 27,
    -71, -49, 37, 21, 31, 11, 29, -20,
    -28, 54, 22, -22, -1, 4, 31, 19,
    -13, -26, 39, 10, -23, -9, -20, -31,
    26, 4, 57, -33, -9, -11, -41, 8,
    39, 21, 26, 22, 9, -49, -33, -12,
    7, 16, -25, 22, 3, 2, -28, 9,
    12, -27, -8, -10, 27, -2, -1, -34,
    19, 24, -48, -10, -46, 4, -7, -26,
    21, -34, 22, -1, -6, 21, 3, 5,
    4, -1, 38, -10, 11, 8, 31, -14,
    -17, -3, -3, 4, -4, 3, -12, 19,
    -1, 5, -17, -15, -20, 32, 26, -80,
    10, -5, -3, -19, -4, -14, -20, -6,
    15, -13, -4, -10, -44, 26, 5, -18,
    -2, 25, -11, 17, -23, 10, 21, -16,
    -27, 8, 10, 17, -26, -15, 21, -12,
    2, 39, 14, -20, -14, -18, -39, 20,
    8, -3, -11, 11, -17, 17, 2, -33,
    0, -14, 26, -13, 11, 5, -28, 43,
    -8, 42, 24, 24, 9, -24, -25, -8,
    -8, -20, -10, 27, 12, 17, 6, -1,
    -12, 24, -4, -15, -23, -10, -11, -1,
    -17, -19, 13, 9, -5, -21, -11, 21,
    8, 0, 2, 10, -12, 25, -37, -8,
    5, -9, -19, 2, -7, -8, 9, -2,
    -33, -10, -9, -3, -7, 7, -12, 2,
    41, -6, -1, 1, -10, 3, -11, 16,
    4, -9, 0, -18, -10, -12, 30, -19,
    -38, 6, -23, -3, 54, -3, 14, 14,
    9, -2, 9, 5, 6, 19, -1, -15,
    -1, -11, 7, 3, -1, -40, -5, 14,
    -46, 12, 0, -2, -7, 78, -6, -47,
    -32, 24, 5, 0, -12, -3, 2, -5,
    -9, 9, 15, 11, 12, 3, 8, 7,
    -2, -9, 29, 1, -17, 1, -19, 43,
    -14, -14, 36, -53, -25, 16, -6, 9,
    -21, -19, 15, 11, -6, -14, 14, 7,
    29, -13, -51, -9, -1, 2, -18, -13,
    0, -29, 13, -11, -14, -21, -15, 8,
    27, -28, -21, -21, -15, 31, 7, 13,
    -7, 9, -18, -28, -10, 16, 3, 3,
    -37, -6, 7, -36, 7, 2, -11, 5,
    23, 15, -15, 3, 8, -12, 50, 20,
    15, 29, -2, -4, 28, 4, 42, 31,
    12, 13, 22, -35, 12, 8, 29, 6,
    -9, -13, -9, -18, -17, -2, 30, 12,
    21, -6, 6, 52, 17, 3, -7, -2,
    23, 9, -30, 1, 38, -4, 11, 0,
    -18, -5, 22, 3, -11, 3, 9, -5,
    -14, 0, 5, 7, -13, 15, -10, -15,
    -8, 25, -15, -19, 12, -15, 2, -18,
    3, 22, -9, 7, 5, -43, -7, 16,
    51, -4, 5, 11, 17, 3, 1, 1,
    14, 30, 17, 3, -22, 18, -5, 10,
    -14, -11, 9, -39, 35, 25, -9, 15,
    -3, 10, -18, 9, -33, -2, -12, -20,
    -8, 0, -17, 0, 20, -21, 16, 15,
    -16, 1, 2, -19, -11, 2, 17, 6,
    -23, 0, -12, -1, 16, -8, -25, 29,
    -4, -52, -21, -7, 23, 12, -15, -15,
    -15, 12, 0, 8, -2, -5, 3, -8,
    16, -38, 16, 35, 30, -13, 5, -15,
    6, 2, 7, 27, -6, 43, 18, -10,
    -10, 18, 0, 2, -20, -24, -20, 1,
    -9, 49, -10, -14, 4, -7, 48, -21,
    -5, -12, 7, 5, -27, -6, -18, 16,
    -1, -15, -1, 19, 21, -2, 19, -8,
    -8, -16, 8, 8, -42, -27, -43, 3,
    25, 10, 7, -5, 2, -41, 26, -11,
    21, -7, -10, 22, 11, -1, -12, 25,
    19, 11, -19, 7, -7, -36, -6, -28,
    13, 5, 0, 5, 18, -21, -26, -75,
    -13, -21, 30, 14, -17, -15, 3, -8,
    -4, -14, -7, -21, 17, 7, -6, 9,
    6, -2, 21, 11, 19, 27, -7, 31,
    53, -24, -8, 4, -4, -13, -7, 45,
    13, -17, 34, 6, 23, -50, -1, -25,
    -13, 15, -22, -22, 3, -13, -4, 2,
    -6, 11, -27, -20, -14, 15, 45, -12,
    36, -34, -31, 7, 8, 60, 61, 31,
    2, -14, -8, 2, -13, 6, 11, 29,
    -4, 2, -15, -17, 5, -23, 8, 8,
    -22, 19, -8, 31, -1, 40, 4, 39,
    28, 8, -7, 6, 38, -38, 27, 14,
    14, -1, -36, -27, -6, 3, -1, -29,
    -16, -6, 0, 15, 18, 15, -5, 1,
    1, -10, 2, 1, -57, 5, -7, 5,
    -22, -1, -1, 17, 14, -58, -8, 12,
    33, 34, 31, -1, 20, -6, 2, -3,
    -20, 24, -1, -15, 4, 6, 1, 9,
    -2, 0, -15, 1, -5, 13, -5, 0,
    -15, -33, -9, 18, 35, -5, -12, -1,
    -5, 42, -51, -7, -2, 25, 37, -9,
    0, 37, 3, -6, -6, 2, -28, 33,
    2, 0, -40, 28, -33, 12, -35, -32,
    55, 6, 0, 9, -27, 28, -5, 22,
    21, -8, -6, 31, -18, -14, -12, 4,
    5, -7, -13, 23, 17, 16, -28, 5,
    -3, 0, 6, -14, 14, 10, 29, 36,
    -8, 15, -39, 25, -6, -35, -28, -53,
    3, 18, 7, -11, -17, -7, -4, -11,
    -1, 24, 9, 3, 13, 27, 0, -41,
    -7, -3, -3, 0, 0, -1, -8, 21,
    1, -10, -13, 5, 5, 26, -53, 7,
    11, -26, -10, -11, 17, -11, -12, 16,
    -17, 16, 0, -5, 6, 10, -3, 17,
    -8, 38, 12, -20, 12, -14, 16, 1,
    -4, 41, 18, 4, 9, 13, -3, -58,
    27, -37, -35, 0, 9, 8, -15, -12,
    -26, 6, 1, 0, -8, -16, 22, 7,
    10, 9, -18, 19, -10, 41, 0, -2,
    3, -35, -5, -17, -6, 38, 38, 24,
    -1, -11, 11, 2, 30, 4, 3, 10,
    -3, 1, 32, -3, 4, -9, -24, 12,
    -15, 9, -16, -10, 14, 9, -29, -14,
    -24, 18, 20, -21, 25, -28, -31, -12,
    13, 0, 10, 13, -12, 10, -16, -7,
    0, 26, -12, -31, 17, 14, 2, 17,
    5, 0, 15, -24, 19, 29, -5, -22,
    -40, 9, 0, 12, 31, 5, 28, 15,
    16, -15, -17, -6, -14, 73, -5, 2,
    -17, 9, 15, -8, 13, 9, 4, 5,
    -19, -39, 0, 24, -1, 35, -5, -37,
    26, 8, 11, -13, 10, -9, -54, -5,
    -8, -5, -14, -36, -6, -32, 13, 9,
    28, 11, 12, -28, 11, 5, -8, -22,
    12, 0, 9, 16, 5, -7, -17, 31,
    25, 5, 14, 44, -17, 15, 12, 34,
    -1, -4, 9, 8, -8, 4, -4, 19,
    6, -6, 5, -8, -1, 13, 1, 19,
    34, 28, 42, -14, 0, -3, 25, -24,
    27, 23, 42, -23, -32, -32, 17, 16,
    6, -21, 0, 11, -24, -10, -13, -20,
    2, 20, -13, -8, 16, -5, -15, -47,
    -34, -12, 25, 5, 39, -52, 84, 19,
    4, -47, 0, -25, 9, 21, -20, -37,
    3, 22, 6, 33, -3, 23, 24, -21,
    -14, -15, 21, -7, 0, 17, 31, -20,
    12, 26, -6, 6, -20, -11, 15, 9,
    -25, 22, 0, -20, 6, 27, -24, 48,
    -6, -10, 43, 12, -4, -13, 8, -35,
    10, 19, 11, -7, 4, -65, -11, 3,
    -24, 4, -23, -26, 29, 27, 1, -21,
    -10, -15, -6, 10, -11, 19, 2, -42,
    -17, -42, -27, 20, -3, -3, -80, 3,
    -2, 21, 31, 9, -1, -15, -34, 3,
    9, 51, -26, 1, 13, -19, -48, -42,
    -30, 33, -16, -18, -25, 17, 8, 7,
    13, -27, -1, -41, 20, 23, 8, -1,
    14, -9, -30, 20, 9, -2, 1, 12,
    -7, -3, 25, -28, 11, -26, -7, -41,
    9, 8, 3, 11, 12, 23, 78, -17,
    22, -1, -5, -23, 6, 12, 0, 9,
    15, -8, -21, -23, 0, -13, 21, 17,
    13, 16, -11, 7, -4, -3, -12, -6,
    -5, -26, 20, -4, -35, 41, 11, -23,
    -44, -2, 28, -21, -24, -22, -14, 9,
    30, -14, -13, 14, 1, 16, -1, 21,
    -16, 5, -25, 3, 3, 26, -27, 4,
    -31, -51, 0, 28, -17, 17, 24, 26,
    -42, -3, -6, 3, -17, 7, 21, -7,
    1, 19, -5, -35, 3, -29, -73, -56,
    40, 13, -9, -15, 9, -7, 6, 3,
    -7, 11, 25, 15, 6, 32, 44, -67,
    0, 3, -25, 11, 2, -12, -9, -8,
    7, -2, -29, -22, 22, -7, 7, 1,
    29, 32, -25, -10, -16, -46, 38, -10,
    3, -16, -27, 63, 10, 7, -80, -27,
    16, -6, 5, 27, 38, 7, 13, 16,
    12, 12, -14, 3, 26, -23, -14, -12,
    -13, -14, -6, -2, -8, -22, -9, -19,
    -3, -20, -13, 27, -22, -9, -42, -68,
    18, 30, -17, 21, -19, 2, -5, 43,
    -7, 3, -17, -26, -1, 24, -13, -7,
    -9, 6, -3, 20, 13, 28, 10, -36,
    7, 5, 12, 37, -10, -14, -33, 17,
    -2, 17, -35, -42, -2, 5, 18, -8,
    -10, 23, 20, 20, -11, -4, -25, 14,
    -12, 8, -31, 3, -10, 19, -67, 15,
    -17, -17, -16, 19, 5, 18, 17, 16,
    13, 37, 9, 17, 28, -4, -9, -8,
    -3, -9, -6, -9, 12, 3, -38, -69,
    19, -42, 1, 36, 9, -42, -17, 38,
    -23, 14, -41, -32, 9, 11, 13, -11,
    -18, -25, -44, -21, -9, 9, 7, 2,
    -15, 16, -22, -3, -14, -13, -33, 15,
    24, -12, 13, 7, -14, 26, -9, -6,
    41, -11, -24, 5, 22, 3, 11, 69,
    16, -1, 27, -41, -12, 25, 7, -34,
    1, 4, 18, 18, 7, -48, -28, 3,
    -23, 11, 15, -19, -27, -26, 8, 19,
    5, 0, -13, -8, 1, -13, 41, 2,
    40, -41, -61, 29, -26, 13, 14, -34,
    -35, 2, -21, -23, 39, -14, -8, 19,
    4, -23, -1, -18, -41, 20, 51, 2,
    54, -21, 26, -3, -8, -26, 6, -19,
    19, 17, 23, -21, -9, -30, 10, 15,
    -15, -5, -1, 5, -6, -4, 16, 28,
    22, 17, -33, 19, 6, 26, 3, 49,
    5, -15, -20, -26, 43, -28, -3, -2,
    -27, 25, -9, -31, -8, 4, -11, 9,
    49, 10, -14, -2, -9, -7, 36, -7,
    -24, 31, -11, 49, -46, -32, -4, 18,
    4, 16, 15, -22, 41, -102, 13, -11,
    -6, -13, 11, 20, 0, -12, 24, -14,
    7, -7, 8, -12, 15, -20, -18, -11,
    54, -20, 0, -3, 3, -8, 30, 0,
    -16, 28, -5, 21, 2, 1, 12, 3,
    43, 8, 27, 5, -9, 15, 18, 51,
    -22, 6, -18, 5, -8, -38, -6, 3,
    -9, 3, -6, 15, -4, -8, -4, -9,
    5, 23, -19, 29, -18, 23, -6, 28,
    -5, 24, -27, -2, -3, 4, 3, 1,
    -11, 22, -27, 15, 30, -48, 9, -2,
    -4, -13, 25, -19, -10, 28, 47, 4,
    6, 5, 18, 22, -8, 8, 16, 26,
    46, -44, -40, 10, 21, -18, 9, -3,
    -23, 11, -31, -30, 4, 18, -38, -9,
    -1, -21, -21, -15, 1, 7, -24, 16,
    -40, 21, -3, -3, 19, 24, -3, 2,
    2, -7, -17, -15, 6, 11, 45, -2,
    -6, 14, -17, 12, -21, -4, -16, -5,
    -9, -2, 3, 11, -35, -2, -2, 8,
    -63, -7, -34, -40, 17, 46, 0, 21,
    19, 2, 21, -6, -5, -26, 0, -19,
    28, -6, -5, 10, -1, 7, 55, -14,
    21, -9, 12, 8, -28, 6, -28, 19,
    -42, -3, -7, 16, 61, -12, -21, 22,
    23, 4, -4, 9, 2, -15, -16, 4,
    9, 42, 1, 19, 51, 9, -11, 24,
    2, 0, 27, -12, -12, 31, 16, -26,
    14, 2, 16, 8, 46, -14, -24, -43,
    -20, 14, 4, 38, -6, -17, -24, 13,
    1, 2, 1, -15, -24, 0, -13, -18,
    -2, -21, 24, -21, -21, 43, -5, 13,
    -28, -32, 3, 16, -19, -39, -9, 1,
    -25, 14, -21, -14, 35, 6, -12, 28,
    -27, 0, 6, 6, -32, -9, -24, 11,
    -3, -6, -15, 23, -14, -3, -7, -12,
    -6, 16, 14, -24, 5, -7, -16, 1,
    20, 3, -29, -9, 28, 0, 2, 33,
    55, -20, -9, -29, -28, 15, -10, -27,
    -7, 14, 10, -23, 26, 20, 2, 40,
    35, 89, 22, 54, -29, -43, 8, 39,
    25, 20, -27, 14, -21, 11, 4, -28,
    17, 18, -14, -1, 12, -5, -30, 9,
    22, 6, 1, -4, -34, -8, -29, 1,
    16, -29, 7, 12, -22, 16, 3, 35,
    14, -27, -25, 16, -31, 89, -12, 14,
    -6, 0, -28, 7, 17, -23, -8, 23,
    -12, 16, -1, -43, -11, -19, 4, 15,
    0, -16, 14, 26, -24, -24, -3, -28,
    -18, -8, 29, 16, -18, -39, 3, 5,
    9, -1, -38, 8, 21, -4, 18, 1,
    -34, 3, 11, -2, -48, 14, 28, 19,
    17, -9, -39, 60, 35, 68, 11, -2,
    -39, 5, 0, -14, -7, 3, 36, 4,
    -25, 32, 7, -33, 5, -15, 14, 0,
    28, 9, 22, -4, 58, 23, -34, -27,
    32, 40, -39, 62, 10, -2, -2, 18,
    -76, 16, 18, -5, 34, 1, 3, -23,
    -16, -18, 18, 18, -35, -22, 29, -27,
    18, 46, -44, 0, -31, -32, -55, 35,
    -49, -7, 62, -20, 46, 1, -23, 52,
    -21, -47, -13, 23, 18, -14, 25, -22,
    -41, -8, -22, -3, -17, -6, -15, 0,
    36, 6, -4, -20, 30, 21, -7, -2,
    7, 11, -25, 51, -57, 13, -6, -1,
    -25, 31, -41, 24, 36, -15, 26, -11,
    24, 42, -29, 20, 38, 6, -24, 83,
    30, 4, 21, -40, 22, 6, 65, 44,
    5, -63, -12, -117, 5, 2, -31, -11,
    -22, 45, -57, -46, 1, 35, -91, -38,
    -10, -35, -5, -22, 20, 36, 15, 38,
    24, -43, -17, -3, 74, -16, 30, -3,
    -8, -5, 22, 4, 32, -32, 80, -50,
    -40, -25, -2, 40, 20, 5, -15, 28,
    4, -32, 16, 15, 5, 31, 22, 48,
    15, 8, -28, 74, 35, -19, 51, -54,
    20, 11, 22, -42, 10, 29, 33, -17,
    -26, 29, 21, 18, 0, -9, 34, 0,
    -28, 37, 9, 30, -1, -17, 12, 9,
    -36, 24, -4, 32, 3, -5, 50, 4,
    -3, -19, 62, 33, 18, 19, 55, 46,
    51, 2, 5, 22, -34, -41, -9, 20,
    28, -11, -90, -39, 18, -15, -25, -10,
    -36, 39, -47, -17, 3, 22, 52, -6,
    -15, 73, -27, 19, -34, -58, 4, -5,
    0, 18, -53, -13, 12, 6, -30, 20,
    -61, -57, -7, -3, 58, -10, -1, 38,
    -28, -3, 13, -35, -18, -26, -19, -5,
    -47, -6, -12, 118, 10, 31, -19, 19,
    12, 50, 28, 23, 25, 6, -14, 9,
    -17, -24, -1, -45, -6, -13, 17, 5,
    19, -4, 16, -3, 27, 37, 3, 0,
    -105, 2, 73, 31, 23, -32, 8, 84,
    -49, 2, -37, 22, 13, 0, 19, 13,
    47, -28, -31, 11, 48, 23, -24, -72,
    -45, 20, 15, -28, -35, -15, -19, 0,
    44, -71, 72, -30, -19, -57, 39, 14,
    -21, -41, -18, 0, -15, -9, 2, 15,
    -24, 25, 19, 64, 17, -3, 28, -25,
    -26, -7, -53, 46, 43, 0, 32, -23,
    -21, -29, -2, 86, -34, -6, 12, -102,
    55, 2, 13, -39, -6, -1, -9, 19,
    -20, -2, 21, -2, -16, -15, -15, 5,
    0, -53, 53, 25, 15, -19, -10, 47,
    2, 33, 2, 13, -16, 90, -62, -18,
    -19, 95, -22, -25, 43, 2, 5, -16,
    44, -29, 27, 2, -21, -6, 41, 46,
    -39, 5, 41, 2, 17, -25, 67, -16,
    -21, -23, 9, 5, 58, 71, 21, 73,
    -47, 39, 34, 65, 33, 25, 20, -31,
    -2, -39, -12, 16, 9, 69, -15, -15,
    11, -40, 6, -26, -27, -7, 61, -127,
    38, -5, 50, -30, 11, 75, 1, -15,
    24, -7, 10, 6, -30, 13, -11, -28,
    -8, 62, -10, -13, -51, 73, 44, 12,
    4, 24, 18, 1, -12, -72, -53, 29,
    90, 36, -44, 23, -31, 46, 19, 15,
    -8, -67, 62, 9, 3, 25, 13, -63,
    -4, 14, 21, -10, 25, -6, 32, -21,
    -10, -25, -12, -20, -21, 57, -32, 38,
    8, 8, 36, 40, 44, -9, 12, -16,
    -3, 5, -10, -3, -37, -34, -40, 41,
    20, -27, -21, 4, 14, 7, -34, 1,
    -14, -3, 2, 16, 13, 28, -23, -8,
    -1, -60, -18, -36, 8, 84, 41, 53,
    4, 30, 10, -34, -9, -2, 22, 2,
    -24, 19, 27, 32, -12, 30, -42, -6,
    26, -9, -7, -27, 22, 30, 32, -17,
    25, -20, -39, 76, -52, 52, 27, 0,
    34, -39, -25, -19, 0, 36, 33, 6,
    -22, 11, 20, -14, 22, 10, 60, -13,
    11, -23, 7, -6, 41, 29, -42, -2,
    -21, -50, 54, 7, -25, -32, -5, 38,
    -2, -33, -9, -23, -35, -7, -19, 59,
    -20, 3, 1, 87, -5, 37, 4, -31,
    -43, -22, -24, -28, 10, -64, -1, -32,
    20, -75, 17, -58, 3, 12, -66, -22,
    -19, 59, 12, 89, 19, -1, 14, 5,
    0, -14, 21, -31, -64, 41, 22, -12,
    38, -7, -22, -38, 34, -54, -42, -14,
    -1, 2, 28, -28, -9, 72, -13, -3,
    -8, -66, -33, -1, 30, 34, 21, 4,
    1, 8, 91, 10, -24, -27, 6, 40,
    -2, -29, 32, -6, -3, -48, 0, 10,
    6, -9, -9, 8, 23, -19, 18, -52,
    34, -29, 26, 7, 32, 12, -2, -12,
    31, -10, -10, -39, -1, 14, 29, -5,
    8, -29, 42, 19, 23, -10, 59, 27,
    -49, -68, -49, -10, 27, -35, -7, -39,
    -6, 1, 40, -28, 4, -28, 11, -3,
    29, -27, 13, 0, 7, -35, -41, -12,
    21, -14, -36, 11, -32, -13, 18, -12,
    -13, 4, -18, -60, 8, 23, 7, 52,
    31, -22, -38, 27, 6, -5, 12, -11,
    3, 27, -35, 9, -1, 14, -12, -1,
    21, 3, -7, 26, 29, 38, 8, 33,
    -13, -60, 10, -57, -41, 24, 3, 24,
    49, 30, -70, -59, 1, -36, -43, 14,
    -14, -17, -8, 14, 9, 14, 14, -24,
    -11, -39, -4, 6, -32, -9, -31, -8,
    -35, -21, 1, 2, 28, 19, -23, 11,
    12, 38, 29, 35, 20, 17, 27, 35,
    9, -11, -4, 7, 33, 2, -59, 10,
    -14, -7, 5, 20, -6, -12, 13, -2,
    17, 38, 53, -33, 3, -45, -16, 14,
    -12, 10, -39, -17, -1, -29, 39, 17,
    34, 34, 47, 3, -19, -5, 31, 0,
    47, -19, -28, 14, -42, -26, 26, -31,
    37, 85, -68, 29, 19, -39, -17, 6,
    20, -22, -47, -13, -12, -21, -9, 14,
    -11, 40, 30, 19, 9, 17, 26, 4,
    6, -13, 0, -15, 14, -2, 41, 13,
    5, -12, 1, 27, 34, -7, -39, 14,
    -24, -16, 27, -1, -29, 99, 15, -9,
    -31, 55, -40, 41, -78, 18, 2, -25,
    -2, -18, -6, 18, 49, 34, 13, 12,
    -10, 13, 17, -18, -1, -48, -19, -24,
    22, -12, 10, -44, -15, -10, -20, 15,
    10, -8, 59, 44, -8, -4, -21, 29,
    43, -30, -78, -51, -43, -5, -7, -22,
    -25, -32, 6, 78, -69, 30, 0, -35,
    43, 20, -52, -47, 32, 1, 47, 12,
    17, -22, -27, -3, 24, -29, 32, -48,
    -47, -19, -70, 10, -30, -15, 29, 44,
    -38, 10, 52, -2, 17, 63, -34, 18,
    96, 21, -7, -35, 40, -2, 19, -9,
    -15, 2, 5, 10, 8, -19, -12, -1,
    -3, 16, -4, 17, -24, 15, -2, -11,
    -6, 5, -32, -18, 20, 29, -26, -10,
    32, 8, 8, 6, 23, -1, 15, -15,
    5, 25, -11, 5, -12, 43, -1, -2,
    -23, -3, 13, 48, 8, 0, -10, -9,
    -2, -9, -5, 1, 7, -5, 3, 39,
    5, -9, 21, -22, 8, -1, -14, -30,
    19, 10, 22, 13, -17, -1, 3, -17,
    -4, 14, -3, -18, -12, 0, 26, 31,
    -10, -22, 9, 15, 3, 5, -21, 9,
    16, -23, -18, -3, 7, -10, 32, -2,
    14, 20, -14, 17, -1, -13, -3, 2,
    -17, 6, -33, -19, -27, -24, -12, 9,
    9, 4, -3, -1, 7, -10, -24, -10,
    12, 9, -18, -4, 0, 36, 6, 40,
    -4, -7, -17, -8, 9, -9, -10, -3,
    13, 11, 19, -30, -11, -32, -27, 20,
    -3, -19, -1, -9, -15, 2, 18, -3,
    16, 20, 3, 11, -19, -39, -21, 23,
    4, 13, -12, 9, -11, 19, 13, 14,
    16, 5, -15, 13, 1, -13, 21, -7,
    9, 11, -38, -12, -14, 2, 3, 38,
    -9, -13, -9, 19, 37, 21, -22, -11,
    -5, -13, 8, 7, -1, 1, -30, -13,
    -23, 5, -2, -30, 11, 27, -7, -9,
    -13, -24, 23, -33, -26, -2, 5, -26,
    -10, 20, 7, -19, -38, 2, -21, -17,
    -1, -4, 2, -4, 5, -2, -4, 6,
    17, 11, 12, -22, -29, 27, 21, -3,
    -3, 14, -8, -3, -3, -11, -14, -9,
    5, 15, 26, 7, 9, -12, 3, 45,
    -20, 3, -32, 7, -24, 4, 6, 16,
    -3, -29, -35, -3, -9, -7, 10, 11,
    -3, -7, 24, 15, -4, -4, -37, 6,
    -6, 6, 14, -3, -17, 8, -9, 16,
    -13, -32, 16, 10, 23, -12, 19, 9,
    -1, -3, -56, 36, -26, 0, 25, 21,
    -5, 19, -31, -4, -17, 20, -31, 9,
    4, -9, -29, 10, 14, 5, -7, -18,
    -17, -18, -2, 14, 8, 9, 11, 22,
    -14, 9, -1, -8, -24, -21, 18, 4,
    -16, -8, -13, 11, 11, 0, -3, 19,
    -6, 12, 7, 11, 10, 5, -10, 7,
    11, 2, 2, 15, 16, -9, -16, 11,
    -58, -22, -1, 25, 10, -13, 9, -6,
    -13, 5, -20, -13, -12, -18, 1, 8,
    -6, -14, 23, 12, -7, 14, 11, -16,
    28, -1, 9, 2, -17, -16, -15, -2,
    15, -2, -28, 13, -8, 0, -33, -22,
    1, 8, -1, -27, 1, 40, -20, 4,
    -6, 22, -13, 39, -15, 16, -8, 15,
    1, -4, 4, 2, -6, 2, 3, 13,
    -15, 4, -2, 22, -24, -44, 9, 7,
    -9, -17, 2, -19, -24, -2, 17, -3,
    15, -5, 6, -22, 46, -22, -12, -11,
    -12, 9, -12, -18, -16, 28, -5, 9,
    -3, -32, 4, 16, 10, 0, 3, -15,
    -6, 31, 13, -12, 42, -40, 12, 12,
    -13, 22, 5, -10, 5, -4, 7, 11,
    2, -7, 3, -3, 1, -11, 14, -2,
    -5, 7, 7, 22, 0, -1, 1, 25,
    -10, 6, 16, 10, 31, -3, 29, 44,
    21, 11, 8, -27, -23, -26, 57, -27,
    8, 17, -16, 19, 40, -11, 10, 12,
    0, 16, -11, 9, -9, -3, 10, -11,
    16, 29, -5, 29, 2, 8, 22, 35,
    -2, -6, 14, -23, 6, 7, -10, -10,
    -1, -2, 18, -5, -18, 0, 7, 7,
    11, -14, -3, -4, -24, 33, -4, 27,
    10, 5, 20, -31, -16, -24, -16, -3,
    10, -22, -3, -4, 4, 9, 17, 45,
    1, 27, 5, -3, -5, -2, 13, -104,
    -3, -8, -5, 2, -12, 16, 30, 19,
    14, 4, 4, -8, 20, 29, -21, 4,
    -6, -8, 17, 8, 12, 24, -1, 29,
    10, 21, -1, -5, -15, -23, 1, 11,
    -4, 6, -13, 3, 4, 2, 11, 1,
    -8, -5, 24, 20, -8, -2, -24, -24,
    -5, 28, -20, 4, -8, 23, -19, -5,
    -11, 2, -1, -9, 2, -1, 7, -22,
    -9, 6, 16, 11, 4, 23, 12, -22,
    26, 1, -8, 6, -1, -21, 14, -15,
    -13, 14, 31, -2, 16, 0, -18, 15,
    -14, -19, -5, 9, -3, 5, -4, -9,
    -1, 13, 12, 1, 30, -9, 8, 3,
    2, 33, -8, 6, -22, 7, -19, -10,
    -10, -9, 12, -11, -16, -15, 10, 5,
    1, -9, -4, 10, -19, 0, 2, 21,
    3, -2, -2, 11, -23, -8, 4, -13,
    36, -14, 15, -24, 13, 12, -13, 24,
    9, -5, 17, -21, 7, -11, -22, -9,
    -10, -4, 10, -21, 11, -11, 6, 25,
    19, 5, -10, 18, 5, -17, 27, -30,
    18, 0, 2, 21, 10, 15, -20, 8,
    -1, -2, -3, -22, 5, 3, 1, -23,
    3, 5, 1, 3, -6, -7, -9, -21,
    6, -17, -3, -14, -24, 4, -23, 4,
    -15, 6, 8, -10, 2, -43, -37, -2,
    -1, 4, -14, 12, -28, 13, 38, -7,
    -5, 2, -13, -5, -4, -1, 15, 22,
    -9, 9, -8, 4, -1, -7, 42, -2,
    -1, -1, 30, 6, 32, -5, -29, 21,
    -25, -2, -4, 1, -8, -11, 27, -10,
    -18, 13, -4, -4, -1, 18, 4, -16,
    -1, -5, -13, -8, 20, 5, 43, -1,
    10, -32, -3, 0, -9, -33, -19, -1,
    -3, -18, -17, 0, 11, -30, 16, -15,
    13, 10, 18, -8, -24, -12, -8, 11,
    -35, -6, -7, 7, -4, 13, -5, -2,
    17, -14, -18, 13, 8, -4, -3, 19,
    -9, -10, 7, -13, 7, 23, 23, 19,
    15, -30, 16, 4, 35, 10, 5, -2,
    -13, 17, 15, -6, -9, 2, -4, 21,
    -5, 11, 8, -4, -11, -1, -6, 21,
    15, 21, -26, 3, 23, -20, 19, 9,
    -6, 21, 5, -2, -10, 17, 4, 4,
    9, 4, -11, 25, 8, 18, -31, -5,
    7, -9, 5, 3, 4, -25, 9, -5,
    -8, -21, 6, -11, 5, -34, 6, 12,
    0, 0, 2, 7, 12, 9, -7, -7,
    -50, 15, -21, 4, -1, -14, -1, -2,
    -2, 4, -25, -9, 9, 10, -9, -22,
    36, 16, -26, -24, -13, 12, -32, 1,
    -4, -1, -4, 1, -16, 6, -2, -4,
    12, -5, -9, -12, -2, 41, 34, 22,
    32, -48, 0, 6, 25, -10, 5, 2,
    -25, 26, 5, -15, -14, -24, 16, -2,
    -14, -24, -3, 14, 5, 15, 5, 0,
    -19, -17, -8, 7, 12, -9, 37, 30,
    0, -11, 3, -6, 11, 30, 5, -15,
    29, 31, 6, 0, 20, 33, -53, -27,
    -2, 21, 3, 17, -3, 43, 6, 7,
    -39, 22, 3, 23, -21, -11, 13, -32,
    27, 6, -27, -19, -10, -9, 0, -45,
    19, 6, -13, 5, 20, -7, -20, -11,
    1, -12, 3, 10, -13, 21, -11, 3,
    8, -11, -13, -8, 24, 3, 18, -19,
    42, 31, -17, -3, 6, -16, 1, -40,
    -21, -7, 5, -36, 6, 36, 3, 5,
    17, -9, -16, -20, 10, -12, 0, 29,
    0, 12, -37, 0, 30, 4, -8, -53,
    7, 18, -30, 36, -6, -66, 25, -50,
    -26, -3, 31, 32, -14, 47, 42, 67,
    18, 2, 1, 0, 12, -4, 2, 7,
    24, 28, 4, 6, -12, -15, -18, -11,
    -10, -14, 3, -12, -3, -23, 15, 40,
    28, -9, -16, -7, -11, -10, -34, -32,
    -4, 14, 5, 8, -5, 18, -3, 7,
    -23, -32, -17, 11, 1, 11, 27, 17,
    10, -7, 41, -11, 19, -16, -53, 8,
    19, -5, 10, 21, 33, 3, -11, 0,
    -6, -70, 8, -5, 3, 10, -2, -6,
    -9, 1, -24, 4, -8, -9, -3, 2,
    3, 3, 4, -1, -8, 11, 14, 21,
    11, 1, -27, -6, -4, -6, 3, 22,
    6, 8, -15, 6, 16, 11, -4, -5,
    -20, 15, 2, -49, -28, 7, 16, 15,
    17, 34, -31, 18, -13, 4, -22, 6,
    -12, 29, -58, -1, -14, -9, 16, -30,
    1, 20, -13, -2, 17, -9, 25, 10,
    -4, -1, -62, -16, -56, -14, 23, 11,
    0, -34, 12, 4, -23, -33, -40, -5,
    -40, -18, 70, -20, 0, -27, -40, -46,
    5, -22, 16, 3, -10, 1, 2, -17,
    5, -28, -48, 33, -6, 1, 9, 3,
    24, 3, 9, -27, 21, -1, 44, 13,
    0, 12, -15, -3, -3, -5, 2, 12,
    -16, -15, -16, 6, 7, 2, -14, 5,
    -15, -31, -20, 5, 5, -17, 25, -6,
    -2, 4, 13, 10, 75, -8, -11, 13,
    8, 9, -18, -3, -18, -9, -26, 23,
    5, 21, -4, 31, 15, -17, 7, -7,
    -35, -22, 42, -18, 6, -36, -28, 7,
    3, 20, -11, -25, 36, -32, 26, -27,
    6, 40, 33, -1, 11, 2, 16, 11,
    19, 6, -1, 6, 13, 12, -14, 5,
    15, 28, -16, -11, 3, -46, 24, 2,
    59, 19, -10, 18, -50, 26, 60, 32,
    27, 7, -34, -3, 6, -1, -7, 13,
    13, -31, -4, 24, -11, -9, 4, -13,
    -7, -5, -19, 6, -14, -22, 19, 12,
    10, -10, -5, -48, -3, 34, 30, -17,
    -26, 0, -13, 3, -46, -3, 7, -13,
    1, -18, -1, -3, -1, -17, 8, -3,
    11, -2, -13, -8, -25, -3, 20, -8,
    -37, -18, -18, 21, -31, 13, 30, 5,
    -10, -9, 4, -8, 34, -30, -12, 17,
    7, -7, 5, -53, 22, -27, -20, -33,
    0, -13, 2, 26, -27, 3, 5, -9,
    -17, 9, -14, 37, -2, -15, -62, 49,
    -25, -8, 4, 4, 10, -14, -41, 35,
    -9, -32, -29, 11, 46, -7, 2, 15,
    -5, 23, -33, -19, -22, 27, -11, -8,
    37, -7, 32, 2, -2, -2, -11, -54,
    4, -24, 14, -17, -15, 5, 22, 20,
    -5, 13, -4, 13, -20, -23, 10, 10,
    -13, 30, -10, -6, -43, -12, 10, -36,
    -42, 3, 29, 5, 43, 43, -10, -8,
    37, -26, -6, 7, 24, -91, -2, 6,
    22, 16, -5, -6, -1, -2, 20, -92,
    -25, -6, 11, 14, -11, 40, 40, 2,
    -19, 13, -26, 3, -45, -21, -4, 0,
    23, -18, 10, -1, 47, -13, -56, 13,
    -7, 24, 3, -37, 21, 15, -22, 17,
    13, -6, -10, -4, -31, 11, 9, -43,
    5, 15, 18, 9, -21, -5, -27, -5,
    9, 29, -13, -8, -22, -1, 32, 48,
    -25, -16, -19, -5, 11, 5, 9, 7,
    11, -24, 2, 7, -37, 29, 35, 14,
    28, 3, 12, 27, 6, 30, 7, -9,
    -53, -1, -19, 8, 12, -10, 44, -5,
    3, 3, -10, 5, -3, -7, 0, -5,
    3, -13, 10, 19, -5, -7, 1, -24,
    2, 11, -1, 12, -14, 5, -10, -22,
    12, 35, -37, 8, -18, -40, -67, 17,
    -18, 3, -1, -1, 15, -16, 7, -19,
    -24, 2, -3, -22, 31, -30, -23, 12,
    -19, -7, 6, -4, -28, -7, -6, -7,
    -1, 3, 10, -19, 45, 11, -25, 38,
    0, 3, -5, -7, 13, 7, -13, 6,
    12, 1, 12, -4, -3, -6, 14, 11,
    14, -10, 18, -6, -40, 11, -13, -11,
    19, -13, 5, 15, 25, -14, 17, -22,
    4, 12, -6, 12, -9, -1, 16, 14,
    19, -6, -16, -3, -14, -21, 23, -38,
    -13, -20, 14, 23, 5, 37, -14, -25,
    54, -41, -7, 6, 25, -20, 4, -2,
    -9, 7, -20, -26, 1, -10, 3, -1,
    14, -12, 23, -33, -51, 3, 18, 19,
    -19, -13, 20, -7, -15, 25, -32, -11,
    30, 27, 7, -20, 43, -5, 12, 18,
    -10, 9, -43, 3, -10, 9, -6, -42,
    -5, -5, -2, -7, -3, 9, 5, 2,
    -9, -10, 4, 21, 5, 8, 2, 19,
    -15, -23, 8, -8, -2, -25, 23, -7,
    1, 14, 1, 2, 4, -13, 27, 2,
    -19, 3, -22, 30, 20, 0, 0, -8,
    -8, -7, 85, 44, 9, -27, -23, 30,
    7, -14, -2, 10, -38, -6, -39, -21,
    25, -42, -1, -6, 17, 40, -15, 4,
    0, 36, 4, -4, -20, 6, -14, 4,
    1, 23, 37, -34, 24, -31, 33, -18,
    12, 16, -17, 7, 15, -1, -28, 20,
    -10, 7, 13, 5, -4, -7, 30, -9,
    29, 3, -20, 14, -67, -26, 8, 6,
    -3, -11, -39, -10, -35, 30, -4, 19,
    -13, 2, -15, 18, 56, -28, 9, -53,
    -4, -6, 12, -10, -12, -11, -1, -32,
    -8, 17, 2, 9, -23, -24, 10, -3,
    -7, 5, 26, 2, 5, 11, 5, 2,
    4, 10, -39, -28, 17, 18, 44, 10,
    -28, -21, 17, 8, 6, 9, 9, 13,
    -13, -15, 12, -2, -39, -13, 21, 8,
    -27, 25, -22, -4, 76, -24, -19, 11,
    37, -8, 38, -35, 9, 15, 9, -37,
    -27, -15, -13, -7, 34, 20, 1, 2,
    -19, 5, 41, -39, 39, 28, 18, 4,
    -24, -33, 3, 8, -32, -19, -32, 18,
    0, -45, -85, -42, 46, -13, -38, -4,
    -18, 41, -5, 46, 13, 74, -3, -21,
    -28, -9, 3, 64, 2, 21, -19, 7,
    -31, -4, 33, 29, -22, 0, 1, -7,
    -22, 10, -9, 7, -3, 50, 35, 14,
    -27, -10, 14, -24, -20, 44, -5, 11,
    -31, -13, -6, 4, -3, 2, -7, 3,
    0, -2, 17, 9, -24, -28, 2, 50,
    64, 43, -8, 28, 15, -104, -19, 36,
    52, -13, -16, -22, 2, -19, -4, -8,
    20, -19, -14, 9, -5, -15, -15, 23,
    3, -54, 62, -48, 23, 74, -12, 73,
    26, 16, -12, -34, 16, -69, -61, -68,
    -6, -1, 14, -6, 1, 13, 14, 12,
    -5, 96, 17, 67, -10, 20, 26, 17,
    -21, 11, -57, 6, 4, -8, -9, -66,
    -20, -13, -7, -7, 57, -30, 54, -23,
    7, 14, 25, 23, 2, 1, 25, -18,
    -13, -25, 1, -22, 10, 21, -56, -9,
    -6, -1, 1, 12, 11, -11, 27, 14,
    -1, -18, 7, 37, -21, -29, 10, 22,
    -21, -108, 35, -7, 2, -12, 24, -9,
    -30, -7, 39, -34, -16, 2, 16, 7,
    53, -31, 23, -10, 18, -41, -89, 28,
    -6, -15, 35, 3, 35, -43, -10, -17,
    4, 27, -21, 30, -27, -3, -23, 3,
    -10, 14, 3, -87, 41, 12, -7, -69,
    -28, -12, -4, -19, 8, 28, -53, 8,
    -67, -62, 49, 47, 2, 16, -36, -21,
    -14, 27, 6, -13, -5, -17, 21, 0,
    -7, -67, -52, -77, 25, 33, -19, 2,
    7, 17, -46, 4, 32, 11, -26, -32,
    29, 52, -43, 2, 10, -64, 31, 17,
    -5, -25, 17, -17, -41, 21, 4, 3,
    19, 0, -15, 70, -3, 15, -21, -33,
    -15, 32, -16, -11, -52, -50, -53, 76,
    58, -14, -8, -13, -24, -13, -18, -7,
    7, 2, -42, 31, 18, 4, 22, 8,
    -60, -50, -57, 6, -22, -41, -22, -1,
    42, 0, 23, -2, -127, 12, -12, 2,
    2, -13, 66, 0, 17, 2, -40, -8,
    -3, 16, 0, 22, 18, -25, 23, -2,
    -41, -74, 70, 11, 23, 17, 18, 8,
    4, -8, 24, 30, -33, 5, -25, -24,
    -15, -28, 9, -5, 18, -48, 0, 20,
    -4, 24, 20, 34, -6, 6, 28, -7,
    27, 33, -35, -32, 48, 6, -1, -25,
    -37, -38, 1, 29, 35, -60, -77, 95,
    -21, -25, 10, -59, 6, 7, -12, -40,
    8, -49, -20, 30, -22, 24, -8, 11,
    -38, 21, -18, 19, -28, -33, 16, -13,
    9, -1, -3, -4, 12, 4, -24, -1,
    -2, 33, -29, 7, -10, 42, 26, 23,
    11, -17, 20, 22, 1, -21, 11, -24,
    33, 30, 7, 1, 21, -3, 15, 43,
    -24, -7, -11, 6, 7, 4, -46, -49,
    3, -29, 38, 0, -12, 24, 58, -20,
    11, -17, 10, -100, -22, -41, -24, -50,
    -21, -40, 25, 36, -12, -27, -10, -21,
    17, -7, -10, 30, 63, -7, 8, 13,
    21, 28, -2, 26, 26, -13, -11, 51,
    11, -53, -38, 6, 27, 3, 43, -14,
    16, -1, -32, -13, -20, -33, -43, 24,
    14, 21, 8, -37, 42, -73, -70, 34,
    10, 4, 9, 39, -2, 24, 9, -37,
    20, 11, -11, 1, 0, 10, -9, -38,
    3, 22, -39, 74, 35, -46, 14, -55,
    28, 16, -4, -7, -34, -28, 22, -16,
    -30, -11, 4, 2, -13, 15, -8, 8,
    4, 38, -22, -8, 0, 23, 19, -127,
    -49, 7, 47, -17, 10, -14, -14, 38,
    20, -17, 41, -11, 1, 31, 11, 13,
    13, -26, -25, 2, -44, -6, 21, 4,
    -10, 51, -11, -47, 3, 8, 10, 26,
    -23, 19, -33, 9, -5, -9, -63, 16,
    2, 15, -39, -31, -43, -10, 34, -5,
    10, 16, -6, -16, 9, 9, 17, 6,
    -71, -25, -22, 0, -49, -1, 5, 7,
    -10, -43, 9, 40, -4, -45, -25, 88,
    -23, -3, -17, -26, -3, -60, 14, 37,
    1, 30, -2, -6, 17, 22, 15, -35,
    -8, 2, -34, 14, -14, -31, -14, -19,
    19, -1, -25, 34, -12, 12, 62, -34,
    -23, -15, 34, -6, -11, -25, -20, -11,
    5, -22, 38, -1, -8, 37, 41, -16,
    -32, 25, 19, -19, 20, 16, -2, 4,
    -21, 2, -15, -8, -55, -24, -50, 9,
    4, 25, -2, 15, -77, -6, 68, -5,
    -23, 41, -15, -3, -76, 0, -34, -25,
    27, 5, 9, -3, -11, 9, -9, -27,
    -20, 35, -14, -2, 13, -29, -12, -6,
    18, -6, -41, 15, 21, -29, 35, 3,
    45, 13, -18, 6, -35, 7, -4, -31,
    -2, -5, 9, 7, -6, 3, -3, 17,
    -28, 18, -26, -18, -25, -13, 51, 22,
    -16, -37, 28, 14, -60, -11, 11, 16,
    -52, 11, -2, -25, -10, -20, -5, 42,
    13, 17, -16, -34, 16, -3, 13, -26,
    39, 38, 24, -52, -3, -27, -33, 12,
    -18, 6, -10, -25, -5, -16, 1, -10,
    -25, -14, -24, 11, -12, 17, -47, 35,
    -8, -6, -69, -3, -5, 49, -29, -33,
    -55, 10, 25, -11, -89, -11, 17, -5,
    -16, 14, -15, 10, 27, 18, -19, 19,
    18, -10, 30, 13, 14, 1, 31, -1,
    -12, 7, -10, -12, 11, -14, -18, 23,
    15, 20, -66, -11, -20, -3, 59, 70,
    -3, -32, -40, -29, 18, 57, 32, -16,
    0, -72, -12, -47, 4, 1, -69, 31,
    12, -55, 18, -16, 41, 33, -6, 15,
    0, 26, -4, 14, -30, 14, -8, 6,
    12, -3, -33, 0, 24, -20, 22, 1,
    0, 18, 17, -13, 8, 16, 19, 4,
    -14, 18, 11, -11, -3, -11, 36, -8,
    89, -32, -2, 22, 6, -6, 37, 6,
    27, -17, 8, 24, 36, -15, -21, 13,
    2, 0, 6, -64, 11, 17, 5, 25,
    -28, -4, 20, -2, 22, -10, -12, -16,
    -30, 37, 8, 27, 14, -46, 2, 4,
    26, -21, 19, 36, -13, 3, -9, 2,
    -23, -32, 1, -12, 6, -6, 5, 22,
    -10, -19, 35, 10, -10, 9, -38, 11,
    -62, -5, -15, -94, -12, -45, -23, -9,
    18, 27, -19, -44, -66, 18, 38, 30,
    7, 12, -68, -1, 24, -8, -1, 63,
    13, -4, -19, 39, 1, -2, -23, 33,
    37, 28, 8, -21, -43, -3, -21, 13,
    13, 7, -18, 2, 9, -24, 17, 28,
    42, 31, 13, 27, -18, 12, -6, 1,
    -10, 25, 5, 1, -22, 8, -56, 28,
    -18, -19, 9, 37, -18, 27, 34, 4,
    9, -7, -8, -10, -39, 26, -5, 33,
    15, -22, -30, 4, -11, 12, 14, 12,
    4, -2, 14, -9, 6, 1, -12, 13,
    -33, 41, -7, -30, -7, 21, -30, 2,
    14, -4, 14, -10, 56, -3, -13, 37,
    10, -51, 13, 8, 14, 45, 15, 18,
    -41, -3, -8, 0, 16, 7, -16, 31,
    1, 8, 15, 26, 38, -8, 28, 13,
    20, -16, 10, -5, 7, -29, 21, -26,
    -3, -5, 32, 14, -22, 45, -9, -3,
    -19, 3, 30, -11, 22, -23, 0, -18,
    3, -7, 13, 7, -31, 10, 18, 1,
    -11, -16, 15, -11, 55, -23, 16, -36,
    -23, 2, -1, -33, 0, -6, -12, 8,
    26, -3, -11, 9, -26, -34, -13, 14,
    -30, 23, 21, 10, 50, -4, 21, 8,
    1, 14, -22, 2, -19, -23, 43, 35,
    -12, 7, -1, 14, 31, -13, 9, -16,
    -7, -23, -30, -55, -26, -28, 2, 20,
    -18, -4, 17, -14, 3, 9, -24, 5,
    -4, 9, -6, 3, 46, -29, -21, -37,
    39, 25, 36, 2, -38, -52, -9, 2,
    14, -28, -29, 21, -14, 2, 21, -12,
    7, -5, 24, -39, 11, -42, 14, 7,
    -1, -10, 5, -28, -6, -16, 23, -38,
    10, -30, 8, -19, 0, -9, -12, 7,
    -16, -22, 7, -14, 26, -20, -9, 34,
    -33, -27, 4, 22, -29, -15, -24, 3,
    13, -32, 9, -6, 20, -11, -70, 3,
    8, -36, -23, -18, 47, -2, -37, 38,
    18, -4, -22, 33, 9, 14, -73, -12,
    23, -16, -6, -17, 26, 46, -9, 2,
    10, -9, -32, -1, -11, 12, -32, -12,
    1, -6, 7, -13, -9, 7, -8, 21,
    -4, -19, 23, 6, -16, 19, -31, -33,
    -28, 5, 28, -4, 7, 39, -9, 38,
    21, 9, -5, 7, -52, 19, -5, -46,
    45, -10, -26, -26, 57, -8, 22, -27,
    -13, -4, -3, 15, -13, 28, 25, -15,
    -2, 22, 0, 8, -35, -12, 11, 20,
    -7, 21, 0, 9, -17, -45, -12, 17,
    -20, 28, -15, 16, -20, -9, 11, -39,
    -17, 16, -21, -16, 27, -9, 20, 21,
    9, -4, -18, -35, 18, -12, 33, 25,
    -12, 18, -24, 1, -11, -60, 49, -1,
    -30, 15, 5, 26, 65, -9, 1, -34,
    13, 4, 6, -13, 2, 34, 21, -29,
    13, -5, 5, 18, -13, 20, 15, 20,
    -5, 21, 2, -5, 40, 3, -17, 16,
    -5, 4, -15, -55, 9, 2, -10, -19,
    8, 1, -20, 3, -31, 4, -1, 21,
    -2, -29, -11, -12, -4, 19, 7, -17,
    -3, -6, -12, -8, -13, -1, 31, 14,
    -12, -17, -8, 33, -5, -28, -20, 10,
    11, -5, -24, 45, 21, 1, -9, -30,
    -37, -25, 6, 20, -19, 9, 6, 15,
    -13, -1, -1, -14, -28, 33, -7, 14,
    -6, 9, -10, 37, -17, 0, -8, -19,
    9, -21, -21, 10, 17, 6, -31, 23,
    5, -4, 3, 0, 18, 4, -56, 6,
    5, 0, 1, -12, 10, -24, 34, 16,
    -6, 14, -18, 3, -6, -26, 9, 4,
    -19, 14, -8, 36, -39, -40, 19, -72,
    4, 10, 30, -13, -11, -16, 11, 25,
    20, 18, 16, 5, -12, -45, 7, -22,
    53, 2, 11, -27, -19, 1, -35, 32,
    -15, 16, -15, 11, -13, -7, -4, 6,
    -30, -15, 2, 3, 21, 20, -26, 24,
    10, 2, 23, 1, -50, 11, -33, -6,
    14, -42, -1, -28, -34, -20, -24, 2,
    -36, -14, 37, 14, 1, 4, 12, -17,
    14, 8, -10, 11, 20, 5, -22, 4,
    -9, 1, 8, 32, 8, 38, 11, -7,
    -23, -1, -5, 11, 11, 9, 1, -24,
    -29, 3, -13, 6, -6, 19, 8, 4,
    2, -22, -43, 5, -40, 12, -26, -3,
    -11, 20, -12, -17, -39, 13, 41, -2,
    -16, 7, 14, -2, -8, 3, -36, 1,
    -1, 6, -49, -8, -20, 3, 31, -7,
    -21, -27, -3, -29, 14, 0, 16, 24,
    -25, 39, -16, 6, 13, 21, 6, -50,
    9, 1, -9, 8, 14, 0, -3, 4,
    -16, -9, 3, -10, 36, 45, -15, 10,
    -8, 38, -1, -4, 64, -23, -40, 15,
    -9, 10, 19, -12, 38, 3, 34, 10,
    38, 14, 24, 5, -22, 10, 22, 8,
    -7, -7, 26, 11, 38, -24, -35, 41,
    35, 3, 9, -10, 37, -16, -18, -23,
    18, -6, 1, -12, 36, -34, 13, -38,
    4, 0, -18, 12, -11, -24, 23, 14,
    15, 35, -10, -17, -20, 19, 21, -5,
    -1, 24, 21, -19, 22, -8, 17, -29,
    14, 17, 19, -19, 22, -2, -7, -42,
    -28, 55, -21, 15, 43, 24, -33, 0,
    1, -22, 5, 6, 18, 20, 7, 8,
    14, -5, 6, -12, 2, -30, 7, 17,
    21, 18, 14, -7, -59, 11, -3, 13,
    11, 22, -50, 11, -28, -34, 29, 3,
    -34, -24, -12, -5, -14, -24, -46, -4,
    8, 9, -22, 36, -22, -24, -7, -15,
    -17, -2, 14, -1, 53, -8, -32, 21,
    15, 22, 38, -11, 20, -16, -15, 22,
    17, 12, -11, 33, -56, -3, 35, 14,
    -14, -24, 17, -15, -35, 26, -19, 25,
    9, 1, -12, 7, -20, 6, 76, 10,
    -10, -11, -7, -68, -9, 13, 22, 19,
    6, -38, 15, -4, 34, 6, 0, -23,
    15, 21, 17, 6, 4, 11, 9, 22,
    31, -25, 11, -5, 36, 5, -1, 12,
    -26, 8, -8, 0, 6, 43, -9, -38,
    7, 25, -24, -42, 58, -24, 43, -25,
    16, 4, -3, 21, 3, 12, 9, -17,
    25, 6, -9, 12, 5, -10, -13, 22,
    -16, 42, -1, 17, 11, 8, -44, 27,
    -16, -16, 6, 24, 15, -17, 4, -15,
    16, -3, 14, -18, 17, -14, 34, -4,
    45, -13, -27, -36, -11, -11, -36, -35,
    -2, 16, -46, -8, -57, 0, 54, -4,
    -16, 34, 16, 19, 31, 47, -4, -16,
    -14, 1, -9, -18, -1, -31, 5, 28,
    7, 5, 10, -1, 13, 17, -8, 30,
    5, 8, 2, 0, -14, -9, -15, 1,
    -14, 18, -41, -29, -16, -7, 17, -39,
    23, -5, 21, -14, 50, 26, -8, 36,
    -12, 3, 24, 2, 2, -26, -4, -14,
    7, 7, -23, 29, -14, 31, -7, -44,
    -14, 14, -11, -12, 6, -7, 4, 4,
    -33, -15, -26, 30, -6, -10, 4, -79,
    -3, -19, 0, -16, -4, 44, 11, -31,
    -33, -9, -24, 18, 14, 23, 61, 16,
    -5, 0, 27, -7, 21, -44, 8, -21,
    -3, 10, -23, -23, 22, -53, -34, 27,
    19, 23, 9, -23, -5, -30, -4, -12,
    21, 9, -9, 36, -27, 0, 7, -55,
    20, -16, 5, -17, -36, -11, 23, 12,
    -26, -18, -5, 7, -47, -13, -49, -20,
    16, -12, 5, 15, -3, -63, -16, -26,
    24, -2, -25, -5, -17, -45, 38, -19,
    -7, 10, -3, 1, 1, -7, 23, 27,
    16, 1, 8, 10, 14, 2, -27, 52,
    15, 15, -26, 12, 45, 0, 25, 9,
    -34, -7, 9, -40, -18, 18, 4, -23,
    -29, -10, 2, 6, -7, 5, -16, 10,
    -14, 47, 5, -4, -14, 6, 16, -29,
    8, 4, 0, 15, 42, -14, -17, -31,
    50, -2, 33, 39, -52, -19, 12, 2,
    -19, -22, 23, -51, 18, 20, 33, 16,
    -8, -3, -27, -29, 11, -12, 10, -41,
    -9, -19, 2, -7, 14, 43, -21, -23,
    23, -63, -51, 43, 24, 4, 26, 13,
    0, 12, 18, 54, 2, -38, -14, -37,
    -8, -40, 45, 5, 4, 0, -8, -21,
    13, 13, -39, -13, 26, -5, -75, 26,
    -29, -10, 57, 41, -40, -36, 17, -4,
    -27, 21, 56, 8, -1, 3, 37, 28,
    -31, -48, 8, -2, 80, 28, -35, 10,
    -11, -14, 26, -76, 2, 32, 4, 25,
    -4, -3, -14, 41, 27, 38, 27, 19,
    -4, -24, 4, -21, 15, -30, 19, 3,
    20, 25, 4, -18, 30, 18, -39, 35,
    7, -12, 8, 1, 52, 8, 71, -14,
    26, -37, -1, -21, 9, 31, 93, -18,
    -1, -29, 10, -14, 28, 8, -63, -17,
    19, 16, 7, -16, 4, 17, -13, 5,
    17, 4, 1, 31, 6, -11, -34, -50,
    -35, -3, 1, 5, 23, 16, -49, 4,
    -21, 20, -40, 3, 16, 17, 4, 5,
    -25, -36, -32, -45, 24, 11, 1, -44,
    -14, -4, 5, -4, 0, 8, -44, -13,
    -7, 1, 30, 31, -7, 7, 1, 50,
    -21, 25, 11, 14, 16, -3, -25, 17,
    0, 14, 7, 1, 1, 21, -32, -56,
    -35, -24, -18, -2, -12, 40, -5, 27,
    3, -9, 2, -17, -20, -4, 26, -31,
    33, -28, -3, -38, -10, -8, -3, 33,
    23, -1, -19, 19, 7, 28, 2, -44,
    -9, -10, 15, 30, 33, 34, -18, -27,
    -30, -24, 18, 34, 12, 6, 36, 18,
    9, -10, -32, -20, -38, 9, -2, 32,
    -30, 17, -4, 14, -58, -21, 12, 11,
    -12, 13, -19, -20, 28, -6, -38, 42,
    41, 20, -8, 0, 104, -6, -40, -37,
    13, 4, -33, 22, 11, -46, -7, -17,
    -28, -26, -6, -4, -4, 1, 7, 46,
    -11, 17, 7, -5, -45, -31, -20, -17,
    -18, 27, -20, -15, -3, -1, 12, 16,
    26, -4, -14, 19, 37, -17, 54, -35,
    51, 2, -13, 23, -23, 63, 4, 7,
    16, -8, 15, -11, 26, 12, 36, -20,
    -21, -35, 10, -7, 9, 9, 13, -18,
    31, -3, -32, 12, -28, 21, 29, -49,
    -38, 19, 4, 6, -6, 22, 30, -19,
    21, 19, -21, 6, -48, 55, 15, -10,
    -30, 10, 31, 29, -77, -2, -31, 7,
    26, 12, -6, 8, -18, -3, 40, -19,
    -26, 6, 2, 7, -4, -3, -19, 13,
    -12, -31, -8, -5, -55, -12, -29, -6,
    -21, -50, 19, 5, 10, 3, 33, 24,
    -2, -17, 33, -35, -22, -15, 11, -11,
    21, 18, -19, 32, -10, 15, -1, 50,
    12, 16, -2, 49, -23, -22, -18, 70,
    -18, 9, 3, -17, -24, 17, 3, -34,
    -22, -2, -44, 0, -33, -1, -1, -9,
    -20, 49, -5, -1, 14, 8, -57, -2,
    -20, -36, 23, -10, 31, 27, 32, -7,
    0, 29, -22, 24, 9, 37, -10, 3,
    -2, 10, -18, -14, 9, 22, -37, -29,
    -16, 2, 15, -9, -12, 43, -52, 40,
    -15, 52, 37, 17, 1, -20, -75, 4,
    -10, 32, 3, 17, 6, 32, 91, -34,
    3, 1, 8, 17, -35, 2, -30, 36,
    9, 26, -9, -34, -48, 18, -17, 43,
    0, -4, 2, -10, -37, -45, -31, -5,
    20, 4, -27, 19, -17, 8, -2, -6,
    8, -12, 4, 9, 8, 5, 44, 2,
    -1, -8, -12, -18, 5, 9, 22, 25,
    5, 3, 5, 12, -43, 17, -6, -21,
    1, -2, -22, -37, 36, -19, -24, -12,
    -10, 24, -17, 5, 4, 71, 8, 5,
    -5, -2, 21, -25, -33, 29, -11, -5,
    -7, -6, 3, 8, -70, 43, 30, 8,
    12, -12, -35, -9, -11, 4, -26, -15,
    -8, 1, -9, 25, -48, 2, -32, -30,
    -22, 19, -3, 11, 3, 19, 10, 25,
    -4, -7, 5, 4, 35, 28, -25, -10,
    -7, 9, -12, 14, -50, -17, 12, 5,
    -19, -20, -5, -2, -50, 9, -20, -4,
    -12, 13, 20, 35, -2, 6, -5, -17,
    14, -15, -30, -11, -42, -23, 26, 8,
    -13, 16, -5, -13, -2, 19, 41, 27,
    -3, 24, -34, 20, -9, -19, 14, 16,
    -15, -38, 3, -48, 22, -24, 54, -16,
    9, -7, 6, 4, 21, -8, -16, 11,
    -20, 10, -36, 33, -16, -4, 6, -38,
    13, -28, 4, 6, 37, 5, 3, -34,
    19, -4, 8, 5, 4, 24, -31, 29,
    5, -37, -18, -5, 34, 4, -11, -22,
    -5, 14, 3, -10, 2, 66, -50, -30,
    7, 2, 41, 6, 11, 11, 21, 29,
    12, 27, -6, -24, 9, 26, 7, -3,
    0, 19, -39, 8, 40, 26, -41, 36,
    11, 21, 11, 9, 1, -16, 20, 17,
    -15, -8, -14, -1, 11, -25, -38, 16,
    8, 5, 1, 4, 29, 0, 3, -28,
    -1, -6, 5, 10, 64, 12, -16, 12,
    42, 9, -21, 27, -38, 1, -19, 4,
    11, -14, 22, 8, 8, -5, -41, -32,
    3, 14, -10, -13, -22, -12, 35, 23,
    6, -7, 8, 16, 18, 18, -24, 64,
    -24, 8, 10, -5, 57, 52, 11, -23,
    119, 10, -21, 41, -27, -5, 59, 7,
    -9, 39, -6, 50, -3, 8, -8, 24,
    22, 31, -7, -24, -26, 89, -64, 89,
    48, 41, 41, -49, -17, 3, 36, 21,
    39, 64, -5, -1, -42, 8, 40, -52,
    47, 35, 61, -49, 7, -39, 29, 100,
    4, 0, 25, -6, 43, 33, -45, -3,
    -1, -34, 50, -36, 9, 50, -23, -7,
    -5, 24, -62, -6, 55, -4, -19, 15,
    -35, 18, 18, -1, -13, -10, 2, 15,
    23, -25, -23, 6, -59, 63, 73, 20,
    -59, -38, 40, -49, -46, 10, 21, -2,
    -20, 34, 18, -31, -27, -64, -22, -73,
    13, 61, 60, 49, 52, -22, 23, 50,
    16, 21, 15, -26, -51, 49, 17, 92,
    39, 1, -16, -64, -30, 39, -15, 3,
    8, -17, 14, -36, 64, 57, 35, 94,
    31, 16, 32, -32, -3, -3, -23, 1,
    31, -11, 19, -17, -62, -22, 2, 49,
    -24, 11, -17, -71, 28, -8, -13, 17,
    -17, -26, -9, -5, 19, 9, -5, 35,
    -2, -35, 22, -11, -4, 2, -43, -7,
    19, -9, -24, 16, -76, 9, 56, -72,
    -54, 23, -21, -23, 23, 38, 6, 2,
    25, 17, 4, -2, 10, 37, -57, -72,
    23, 20, -35, 78, -24, 28, -5, -9,
    37, -6, 1, 16, -60, 10, 2, -18,
    -64, -8, -16, 5, -3, 14, -72, -28,
    36, -19, 13, 38, 92, -23, -31, 34,
    -40, 122, -51, 7, -59, -19, -9, -30,
    7, 9, 26, -2, 11, 18, -23, -21,
    -41, 26, -11, -56, 28, 13, -28, 13,
    32, 5, 3, 59, -12, 51, -4, -24,
    48, 74, -59, -9, -35, 36, 104, -2,
    -10, 4, -34, 50, 37, -7, 42, -69,
    -84, 40, -1, -1, -73, 40, -27, 15,
    13, -57, 0, 31, -25, 20, -48, -17,
    31, 24, 8, -47, 20, -37, -5, -5,
    -6, 40, -14, 7, -55, 15, 47, -18,
    31, 35, -76, 67, 10, -47, -7, -38,
    41, 0, -23, -7, 39, -3, -16, 20,
    -47, 37, -62, -32, -14, -79, 36, -15,
    13, 32, 21, 4, -11, 34, -51, 82,
    17, 51, -5, -8, -80, -49, -6, -18,
    -16, 80, -75, 2, -2, -65, 9, 12,
    17, 92, 42, -10, 2, 17, -46, -16,
    -3, -16, -22, 10, -2, -18, 46, -5,
    25, 21, -27, -33, -45, 30, -31, -11,
    -41, -1, 103, 0, -37, 14, -49, 16,
    -18, -27, -32, 4, -53, 10, -6, 24,
    0, -14, -66, -63, -18, 7, -3, -21,
    -1, -7, -49, -7, 10, -1, 9, 25,
    61, -6, -5, -6, 15, -13, 25, -116,
    1, -27, -27, -34, 26, -30, -8, -34,
    6, -41, 3, -12, 42, -76, 37, 4,
    -32, 14, -19, -33, 2, -72, -82, -20,
    13, -12, -57, -30, -8, 49, -16, 53,
    -46, 8, -66, -63, 33, -4, 41, -1,
    11, 68, 12, 5, 72, -7, 10, -78,
    0, 54, -50, 1, 0, 17, -4, 23,
    -57, 7, -48, 37, 49, -16, 13, 11,
    37, -31, -35, -11, 53, -4, -34, -22,
    -10, -7, -4, 56, 29, -19, 49, -96,
    -17, 4, 46, -70, 15, 2, 15, 17,
    36, -3, 7, -24, 26, -1, -55, 55,
    111, -13, -8, -2, -68, -37, 76, -23,
    44, -5, 3, -8, 57, 37, -60, -17,
    3, 14, 16, 55, 52, 70, -19, -29,
    -25, 16, -4, -32, 65, -12, -83, 101,
    43, 63, 11, 48, 13, -55, 37, -22,
    -18, -3, 33, -42, 44, 38, -12, -23,
    -33, -36, 8, 14, 39, 12, 45, -3,
    17, -21, -19, 6, 22, 61, 18, -21,
    33, -14, -28, 1, -8, -58, -14, 19,
    22, -22, 17, -10, 50, 46, -48, -1,
    49, 4, 18, 21, 50, 0, 27, 21,
    14, -27, 42, 18, 74, 2, -8, -10,
    63, 10, 1, -34, -2, -15, 29, -29,
    7, 46, -11, 22, -12, 11, 2, -55,
    -5, 67, -53, -1, 0, 10, -58, -6,
    -17, 10, -18, 11, 23, -21, 5, 75,
    35, 10, -9, 1, -30, -7, 38, 32,
    -7, -37, -16, 24, 48, 42, -9, 12,
    19, -2, 3, -40, 85, -72, 22, -19,
    14, 4, 0, 7, 21, -29, 72, 55,
    6, 50, 17, -24, -6, -46, -18, -38,
    -23, 80, 22, -23, 32, 10, -18, 95,
    -11, 55, -44, 31, -54, 11, -14, 8,
    -25, 17, 38, 42, -40, -1, -3, -45,
    -42, 55, -9, 24, -17, 64, 69, 9,
    10, 0, -37, 37, -68, -20, -60, -19,
    -19, -26, -89, -18, 2, -7, -21, -57,
    47, -34, 15, -13, -35, -32, -15, 34,
    77, -25, 43, 25, -53, 49, 55, -26,
    5, 9, 15, 27, 56, 54, 47, 41,
    18, -10, -4, -17, -45, -21, -23, -38,
    32, 56, 11, -29, -21, -42, 4, -41,
    -14, -39, 21, 4, 8, 7, -6, 26,
    49, 49, 7, 7, 15, -111, -13, -76,
    -17, -64, -33, -47, 36, -37, 5, 25,
    33, 37, -47, -3, 108, -68, 5, 21,
    26, -84, 53, -9, -41, 55, -45, -10,
    0, -40, 14, 22, 80, -22, 70, 7,
    -1, 7, 31, 27, 5, -24, -1, -41,
    -26, 0, 17, -25, 79, -11, 7, 16,
    -12, 20, 18, 24, -9, 2, -14, -2,
    -14, -15, 21, -3, -5, 35, 24, 27,
    -16, -3, -32, 19, -18, 19, -13, 4,
    37, -8, -31, 4, 3, 31, 26, -13,
    -84, -26, -54, 8, -17, -10, -59, 37,
    5, -17, 21, -25, 109, 20, 23, 51,
    41, -26, 10, 56, 12, -19, -39, 4,
    39, -9, 70, 3, 18, -4, 9, 22,
    21, 7, -11, 11, -9, 33, -29, 8,
    -17, 1, 22, -27, 7, 19, 4, -31,
    -8, -10, -16, 53, 0, 55, 7, 25,
    11, 58, 32, 72, 7, 22, -48, -9,
    -38, -40, 8, -27, -20, -52, 26, 7,
    -43, -22, 7, 22, 37, -72, 78, -75,
    -12, -40, 3, -28, 16, -3, 29, -40,
    32, -22, -2, -6, 20, -1, 41, -7,
    27, 30, -12, -9, -3, 14, -24, -14,
    -7, 44, -29, 85, -29, 19, 108, 17,
    -18, -20, 72, 57, 21, 18, -81, 14,
    22, -19, 44, 12, -69, 23, 12, 69,
    38, 17, -20, -54, 26, 14, -42, 13,
    -17, 59, -14, 13, 4, -116, -86, -2,
    68, 6, -11, -22, -43, -29, 1, 47,
    6, -6, 4, -2, 0, 27, 31, 25,
    12, 25, -14, 16, 12, 10, 9, -16,
    -40, 16, 12, -6, 5, -16, 5, -8,
    25, 7, -18, 23, -32, -14, 33, -23,
    -1, 1, -1, 1, 2, -15, -17, 25,
    15, 6, 2, 16, 11, -5, -17, 2,
    -22, 13, -31, 13, -7, 15, 13, 1,
    -6, -21, -22, -3, 4, -11, 13, 14,
    -2, -3, -17, 1, -1, 3, 1, -33,
    6, -21, -26, -31, -5, -12, -7, 13,
    -5, 14, -12, 11, -5, 3, -1, -8,
    2, -24, 19, 29, -17, 29, -14, 13,
    5, 2, -2, -1, -17, -2, 2, 1,
    -16, 3, 2, -18, -23, 22, 9, 14,
    -12, -24, 16, 24, -14, 2, 0, -17,
    -2, 10, -9, -8, -32, -9, -15, 22,
    4, -3, 2, 3, -36, -46, -5, -3,
    -1, 9, -13, 13, 13, 7, 0, -8,
    21, 5, 15, -1, 19, 16, -5, -15,
    28, 36, -17, -2, 33, -19, -7, 24,
    -7, 5, 4, -1, 31, 23, 3, 7,
    -6, 48, -5, 15, 4, 9, -1, 1,
    4, 12, 29, -6, -3, 13, 16, 11,
    23, 26, -2, -14, -9, -42, -9, -32,
    5, 8, 1, -12, -6, -19, 19, 38,
    14, 14, 26, 14, -17, -16, 27, 3,
    36, -7, 20, 28, 1, 5, -1, 7,
    47, -10, 23, -33, -16, 29, -1, -14,
    2, 0, -12, 6, -1, 4, -23, 25,
    50, 37, 42, -20, -6, -13, 20, 5,
    -3, -1, -6, -28, -10, -24, -3, -1,
    7, -17, 9, 14, 32, 7, -7, -17,
    -2, -8, 10, 8, 61, -32, 16, 19,
    -24, -33, 23, 21, -13, -16, 4, -11,
    -40, -12, 15, 14, 7, -8, -11, 4,
    -13, 27, -11, 7, 6, -14, -16, 35,
    -11, 1, -11, 7, 20, 47, 7, -15,
    23, 13, -10, -3, 0, 54, 7, 7,
    2, -16, -22, 6, 2, -3, 11, -7,
    16, -24, -4, 20, -39, -20, -11, 5,
    -5, 3, -5, 3, -24, -7, 17, -8,
    6, 12, 1, 8, 11, -14, 7, 5,
    3, -13, -34, -1, 23, 0, -8, 8,
    8, -6, 22, -9, 22, -6, -29, 23,
    7, -6, 0, 3, -7, -5, 21, 19,
    -1, -28, -26, 9, -8, 9, -1, -1,
    -4, -3, 36, 22, -20, 11, -1, 12,
    0, 18, -27, 7, -1, -14, 17, -21,
    7, 8, 9, -2, 5, -35, -29, -14,
    17, -19, 33, 3, 6, -5, 5, 11,
    43, 63, -9, -3, -20, -7, -17, 34,
    -3, -4, 23, -36, -16, 2, 30, 1,
    0, 1, 5, -9, -15, 26, -8, -8,
    -17, 20, -6, -15, -7, -6, -7, -4,
    21, -20, 8, -48, -1, 6, -4, 5,
    -43, -11, -13, -29, 2, 7, -10, 25,
    4, -5, -3, -1, 2, -11, 17, -3,
    40, -17, -16, 28, -7, -1, 10, -4,
    -37, 1, -24, 22, 1, 5, -7, 2,
    57, 61, -19, 32, 20, 11, -19, 50,
    -14, 5, 4, -7, 33, 17, 27, -1,
    7, 2, 4, 35, 12, -13, -9, 5,
    0, -26, 6, 3, 4, 1, -7, -5,
    -27, -3, 16, 1, -4, -2, 2, 17,
    -5, -5, 2, 1, 40, -32, -8, -26,
    14, 10, 5, 12, 5, -7, 3, -14,
    1, 3, -7, -33, 8, 10, -2, 1,
    -14, 16, -15, 21, -13, 23, 34, 6,
    6, 3, -2, 6, -30, -27, 33, 22,
    8, -18, 18, -16, 18, 6, 16, 10,
    12, -7, 6, 23, -12, 2, -2, -3,
    -13, 0, -2, -17, 38, 10, 16, -27,
    1, 4, -1, 2, -23, -11, 40, -14,
    -11, -31, -10, -4, -2, 49, 9, 1,
    -30, -28, 21, 1, 43, 3, -14, 9,
    -41, 18, 10, -11, -19, 46, 6, 3,
    -9, 1, -15, -2, 2, 41, -36, -27,
    -8, -9, 1, 32, 7, 21, -8, -16,
    -18, -1, 17, -29, 6, -6, 8, -20,
    -51, -12, 6, 28, 32, -45, 19, 20,
    3, -10, 5, 6, -16, 11, 7, -15,
    -11, -8, 21, 5, -32, 9, 4, 4,
    5, 9, 31, 17, -4, -5, 30, -6,
    7, -39, 11, 10, 21, -37, 20, 11,
    11, -5, 7, 2, -14, 25, 24, 15,
    -8, 40, 26, 15, -4, -19, -8, 8,
    -7, -2, 11, -4, 5, 3, 10, 15,
    -7, 28, 28, 17, 17, -29, 2, -8,
    11, 4, 4, -5, 4, -22, -16, -21,
    24, -23, 25, 29, 1, -3, 31, 4,
    27, -6, 4, -27, 2, -12, 1, -4,
    -19, -18, 4, 15, -1, 31, -21, 24,
    1, 23, -7, -15, -25, -21, 36, 33,
    3, 33, -10, -10, -10, 7, -22, -13,
    6, 25, -2, 15, 9, -5, 5, -8,
    33, 27, -14, 32, 26, -8, -10, -2,
    2, -12, 2, 0, 46, 11, -12, 4,
    -30, -34, 9, 9, -9, 12, -4, 5,
    -19, 2, 35, 14, 20, -10, 1, -6,
    -26, -36, 56, 39, -33, -1, 5, -10,
    2, -1, 3, -5, 6, -32, 32, 10,
    15, 1, -8, 10, -7, 1, -18, 0,
    21, -9, 7, 23, -27, -5, 10, 2,
    34, -54, 3, 2, -15, 21, -26, 12,
    0, 0, -1, 6, -7, -44, -38, 15,
    12, -21, -11, 7, -14, 13, -34, 1,
    -36, 16, 18, 4, -23, 9, 3, -1,
    -12, 29, 14, 17, -13, 11, 18, 10,
    -5, 9, 1, -7, -19, 24, 16, 27,
    22, -18, 0, -35, -4, -33, -4, 4,
    -32, -44, 19, 1, -6, 7, -4, -4,
    -4, -19, 24, 25, 11, -36, 26, 6,
    -2, -1, -14, 5, -41, 11, -9, -35,
    -5, 19, 15, 26, -4, 3, 8, 2,
    17, 36, -4, -8, 6, -8, -5, 3,
    55, 20, 26, 12, 12, 14, 14, 9,
    -3, -14, 5, 2, -3, -19, 1, -26,
    13, 4, 28, -10, -2, 6, 2, -9,
    18, -16, 46, 4, -25, 9, 2, 5,
    -42, -10, -20, 7, 21, 12, -10, 12,
    1, -9, -4, -6, -13, -18, 18, -13,
    15, -4, 16, -4, -8, -7, -5, 20,
    -9, -34, 30, 38, 11, 1, 13, -6,
    -4, -12, 7, 36, 17, 18, -13, -11,
    -8, 2, 2, 0, 16, 5, -21, -39,
    4, -47, 4, 29, -1, -14, 3, 20,
    40, -9, -6, -1, -5, -7, -12, -4,
    -26, 13, 16, 6, 13, -12, -16, 4,
    3, 2, 0, -20, -5, -6, -18, -3,
    -20, -49, 48, -35, 22, 37, 10, 5,
    -29, 24, -9, 15, 0, -13, 14, -20,
    62, 2, 2, 19, -12, -47, -11, 73,
    11, -8, -22, 3, -21, -22, -29, 0,
    -33, 7, 25, 27, 8, -7, -15, -2,
    5, 2, 11, -38, 0, 24, 22, 1,
    -20, -40, -38, 0, -17, -19, 3, 19,
    -28, 4, -12, -22, 9, 17, 40, -38,
    5, 22, -6, -57, 4, 2, -2, 7,
    -13, 14, 32, 2, -13, -8, -9, -10,
    18, 30, 24, -3, 7, -5, -21, 26,
    -14, -6, 22, 38, 1, -3, -36, -4,
    -26, -35, 7, 0, -18, -8, -3, 21,
    -18, 3, 0, -12, -6, -10, 10, -18,
    -53, 18, -33, 34, -9, -25, -39, 14,
    2, -17, -23, -15, -19, -24, -21, 19,
    10, -43, 59, 0, 0, 2, -17, -13,
    -10, -20, 25, -12, 29, 1, -7, -24,
    24, 4, -33, 6, 5, 9, 86, 7,
    0, 1, -13, -4, 8, 34, 29, -22,
    10, 17, -10, -10, 1, -1, -2, 0,
    -8, 19, 13, -14, -10, 2, 5, 17,
    52, 44, -11, -71, 13, -24, 26, 7,
    -10, -4, -1, -26, -2, 22, -49, 10,
    32, -35, -4, 0, -17, -19, 34, 12,
    -26, -1, 5, -15, -4, 3, -8, 19,
    3, -35, 45, -21, -26, -78, 16, -20,
    13, -10, -14, -14, -36, 9, -51, 67,
    56, -36, -11, -34, 7, 0, -6, -11,
    4, 24, 0, -16, -20, -39, -11, 5,
    46, 24, -3, -35, -4, 59, -44, 5,
    -7, -20, 15, 10, -21, 35, 99, -29,
    18, -26, -44, -10, -2, -12, 3, 4,
    -34, 31, -36, 22, 21, -35, -9, -5,
    36, -43, 38, -6, 12, 10, -24, 2,
    -12, -2, 15, -12, 44, 18, 41, -32,
    -9, -26, -33, -52, -14, 14, 3, 0,
    -25, -1, 33, 19, -11, 2, 13, 1,
    8, 2, -19, -6, -7, -31, 2, -20,
    9, -4, -19, 9, 28, -9, 40, -16,
    -25, 17, 22, 20, -35, -5, -20, -3,
    5, 5, 30, -31, 46, 2, -18, 10,
    37, -42, -15, -2, 13, 16, -19, 27,
    14, -1, 15, -13, -1, -41, -39, -29,
    5, 17, 11, 19, -4, 21, 4, 12,
    21, -17, -16, 30, -12, 32, 19, 18,
    13, 33, -10, -57, 31, -19, -31, 9,
    9, 19, -7, -1, 70, -19, 34, 11,
    18, 51, -25, 4, -2, 0, 2, -10,
    -14, -2, -23, 28, -32, -10, -12, 49,
    20, 18, 18, 11, 67, -84, 25, 6,
    3, -1, -5, -1, 0, -4, -62, 9,
    17, -29, -5, 25, 1, 10, 2, 8,
    10, -21, -4, -4, -11, -3, -18, -2,
    0, 18, 23, -22, 1, -20, 16, -16,
    21, -7, -3, -8, -10, 23, 9, 7,
    -85, -13, 35, -12, -9, -17, -3, -11,
    -10, 19, -9, 4, 2, -4, 0, 3,
    5, 21, -9, 42, -8, 28, -2, -2,
    -24, 1, 14, -1, 16, 3, 9, 3,
    -29, 2, 6, -15, 14, -1, -8, 9,
    3, -36, 25, -2, 4, -3, -14, 7,
    -27, -19, 3, 21, 9, 7, -9, -12,
    4, -6, -3, 18, 67, 32, -20, -22,
    -3, 2, -9, 33, 0, -23, -9, 4,
    -12, -29, 12, 35, 7, -7, 0, 5,
    17, -45, -35, 17, -1, 18, 37, 14,
    -6, -14, -18, -1, 17, -9, 13, -11,
    -98, 47, 11, -5, -10, 1, 17, 0,
    -51, 2, -9, -2, -26, -20, 1, -9,
    -50, 26, 29, -15, 14, 19, -22, 26,
    25, -2, -10, -2, -77, -5, -25, 5,
    -41, -34, 2, -19, -8, 26, 2, -2,
    39, 15, 14, 6, 67, 2, -31, -3,
    -10, 14, 19, -12, 4, 53, -38, 9,
    -17, 11, -25, 25, -4, 6, -27, -7,
    -16, 25, 16, -52, -3, 29, -3, 7,
    14, 14, 38, -39, 7, 3, 1, -10,
    -50, -16, 1, 2, 36, -7, -20, -28,
    5, 17, -53, 4, 11, -6, -27, 13,
    -39, 19, 35, -17, -19, 21, 27, -1,
    -26, 20, 9, 3, -1, -25, 65, 0,
    22, -2, -23, 18, -18, 16, 6, -14,
    5, -5, 8, 6, -19, -34, -18, 0,
    -19, 29, -12, -8, -5, 6, 0, 1,
    13, 7, -12, -7, 7, -2, -2, 17,
    3, -21, -4, 25, 19, 4, -14, -56,
    -4, 0, 0, -11, -32, -12, -25, 18,
    32, -3, -25, -14, -6, 9, 30, -15,
    -12, -7, -40, 31, 4, -17, 2, -30,
    26, 4, -7, 4, 2, -13, 5, -9,
    -25, 47, -5, -4, -5, 11, 49, 0,
    5, -4, -2, 1, -10, -9, -14, -10,
    -35, -13, -39, -4, 5, -16, 30, -9,
    11, 5, 17, 40, 10, 12, 29, -7,
    10, -16, 5, -14, -20, -2, -5, -1,
    17, -7, 24, -19, -41, 2, -3, -20,
    -2, 27, -2, 31, 32, 2, -5, -17,
    -3, -32, 20, 5, -32, -53, 29, 6,
    27, 20, -4, -6, -25, -4, 25, -3,
    9, 16, -5, -4, -10, -13, -1, -4,
    -34, -26, 20, 25, -17, -14, -5, 10,
    12, -6, 29, 36, 10, -21, 25, -15,
    -3, -5, 6, -2, -25, -20, -26, 12,
    3, -14, -36, 7, 4, 10, -37, 11,
    -3, 1, -16, 24, -42, 18, 5, -8,
    56, -13, 19, -18, 9, -19, -29, -4,
    -5, 8, -4, 14, -14, -56, -26, 43,
    21, -5, 19, -22, 3, -10, 17, 1,
    -13, -31, 29, -11, -16, -6, 1, -17,
    37, -27, 37, -20, -3, -14, 53, 20,
    -3, 4, -7, 1, -1, -33, 5, -22,
    -3, -3, 4, 9, -1, 11, 1, -1,
    -2, 3, 22, 6, -8, -14, 4, 10,
    38, 35, 34, -19, -24, 19, 33, 8,
    -25, -12, 3, 6, 9, 24, -17, -43,
    -71, -31, -14, 54, -28, 10, 16, 9,
    -3, 17, 30, -22, -21, -19, 8, 4,
    34, 13, 7, 48, 6, -46, -15, -24,
    -6, 7, -3, 2, -11, -17, -11, -20,
    26, -3, -7, 26, 8, -2, 3, 6,
    -90, -1, 0, 23, 4, 2, 23, -10,
    14, -36, -45, -12, -26, 2, 39, -6,
    -2, 5, 10, -11, -9, -32, -31, 61,
    -4, 28, 4, 0, -14, -7, -4, -8,
    -14, -11, -2, -15, -24, -14, -23, 2,
    7, -19, 16, -3, -29, -35, 50, 38,
    -17, 11, -3, -42, -21, 6, -4, -26,
    -47, -14, -65, 41, -2, 52, -14, -28,
    59, 0, 33, 21, 13, -16, 19, -25,
    40, -13, 26, 27, 17, 24, 27, -7,
    28, -3, -22, -6, -3, 48, 11, -9,
    5, -6, -36, 13, 11, -5, -16, -28,
    1, 69, 28, -32, 15, 11, 29, 7,
    -48, -48, -4, -6, 16, -23, -41, -10,
    -51, 4, -6, -28, 14, 3, 12, 39,
    4, 10, -22, 81, 34, 1, -36, -42,
    -1, 16, -25, 44, -12, 14, -10, 0,
    5, 11, -29, -24, 27, 20, 28, -43,
    -23, -19, 14, 115, 6, 48, 47, 9,
    57, -24, 29, 25, 42, -44, 5, 10,
    37, 18, -25, -72, -3, -26, 11, -16,
    -15, -6, -53, 47, 32, 24, 25, 47,
    -9, -35, -40, -35, -33, -47, -29, -37,
    -28, 9, -49, 25, 22, 3, 8, 33,
    7, -15, 34, -4, 49, -2, -16, -21,
    13, 27, 35, 64, 39, -26, -52, -1,
    -21, 11, -13, -4, -17, -46, 47, -30,
    21, 5, -5, -37, -14, -22, -25, -8,
    9, 2, -43, 34, -5, -18, 14, 19,
    -40, 67, -26, -54, 56, 7, 64, -31,
    -10, -3, 10, -56, 55, 3, -11, 6,
    -42, 6, -14, -8, -19, 47, 114, 15,
    -5, 7, 13, 18, -5, 1, -27, 15,
    -64, 36, 33, -14, 31, -27, -1, 52,
    24, -35, -14, -41, 4, 42, 19, 19,
    -2, -51, -44, -20, -19, 40, -80, -11,
    23, -41, -71, -42, -49, -64, -51, -16,
    -17, 68, -63, -16, -42, 39, 53, 22,
    3, -30, 9, 37, 32, 12, -75, -7,
    48, 29, -1, -24, 11, 29, 21, -27,
    0, -18, 1, 8, 42, -50, -17, -4,
    7, 2, -56, -41, -11, -38, 7, -19,
    -13, 7, 40, -12, -49, 2, 20, -18,
    15, 24, -1, 23, -4, -80, 4, -35,
    -19, 3, 30, -40, -19, -9, 22, 31,
    90, -9, -34, 7, 3, -12, 7, -10,
    0, 2, -33, 29, 9, 1, 10, -12,
    26, 40, 36, -57, -26, 11, -46, -18,
    14, 64, 23, 59, 75, -16, -23, 6,
    41, -30, -34, 26, -54, 5, -17, -29,
    -4, 3, 19, -11, 8, 53, -63, 39,
    19, -3, 41, 48, -1, 16, -2, 11,
    41, 5, -7, 24, -26, 40, 17, 13,
    -15, 6, 30, -1, -12, 20, 57, 18,
    18, 41, -21, -15, 30, 8, 50, 0,
    -37, -35, 35, -19, 21, -11, -21, -6,
    -12, -24, 13, -73, -58, -11, -23, 77,
    70, 19, -20, -45, -62, -30, 14, 47,
    11, 11, -11, 7, -16, -1, -25, -12,
    -12, -44, 45, -41, -7, 39, -4, 21,
    -2, 64, -28, 34, -2, -16, -18, -20,
    11, -43, -8, -4, 46, 31, 52, -60,
    16, -5, -10, -8, 49, -37, -20, -72,
    99, 27, -5, -20, -7, -20, -3, -6,
    26, -40, 1, 16, 2, -18, 11, -5,
    -30, -99, -22, 25, -23, 16, -29, 41,
    -14, -10, 22, 0, -39, 15, -35, 54,
    28, 20, -29, -13, -17, 21, -11, 19,
    1, 17, -14, 8, 13, 11, -7, -8,
    -9, -27, 5, -1, -58, 14, 49, -47,
    8, -7, 3, 47, 67, -20, -4, -19,
    -15, 4, -12, 2, -1, 18, -2, 16,
    4, 20, 89, 40, -12, -20, 19, -3,
    57, -3, -49, -57, 12, -25, -41, -18,
    -14, -28, -41, -21, -8, 10, -4, -32,
    72, -2, -41, 41, -54, -1, -5, -20,
    7, -6, -15, 24, -33, -40, -8, -24,
    -29, -30, 1, 4, -62, -67, 1, -3,
    56, -6, -9, 0, 22, -6, -78, -15,
    55, 30, 28, -7, -42, -46, -16, 5,
    -45, 47, 18, 11, 83, 3, -52, -7,
    28, 53, 29, 4, -3, -37, -15, -3,
    -32, -1, -36, 35, -69, 62, 17, -9,
    22, -31, 51, 14, 4, -63, 4, -1,
    10, -25, 5, 87, 22, 8, 15, -34,
    -29, 2, 40, -58, -42, 4, 33, 3,
    12, 31, -74, -5, 27, 102, -53, -15,
    22, -32, -89, -30, 72, 9, 39, -9,
    -5, -2, -21, 5, -6, -41, 127, -8,
    -5, -80, 11, -16, -37, 52, 13, 32,
    17, -4, 36, 6, -33, 34, 53, -18,
    6, -91, 34, -36, 5, 5, 2, -18,
    25, -23, 56, 19, 0, -21, -8, 12,
    12, -50, 41, 28, -14, 59, -34, -6,
    -27, -6, -6, -23, -2, 32, -62, 37,
    -28, 38, -31, 73, -26, 1, -17, -20,
    -32, -22, -61, -27, -18, -9, 11, -48,
    -54, -15, 6, 27, -36, -55, 17, 52,
    -51, 80, -2, -8, 10, -37, -11, -17,
    38, -8, 11, 9, 18, -6, 16, 7,
    7, -18, -15, -43, -12, -11, 57, -18,
    36, 21, 54, 60, -7, -1, -9, -13,
    -2, -1, 5, -19, -6, 5, 46, -13,
    43, 14, -1, -34, -120, 9, -10, -70,
    20, 12, 20, -80, 60, 14, 5, -25,
    -2, 0, -39, 59, -25, 17, 31, -41,
    54, 40, -14, -6, -34, -14, 6, 1,
    25, 7, -9, -1, 23, -47, 12, 24,
    13, -37, -8, 17, -16, -20, -10, -3,
    -13, -37, 19, -8, -22, -28, 20, -32,
    -6, -5, 10, 6, -20, -1, 37, 20,
    -63, -4, 0, 18, 5, -1, -43, 5,
    7, -13, -4, 38, -85, 21, -2, 0,
    81, -17, -44, -7, 0, 1, -47, -20,
    -12, 1, 15, 54, 65, -68, -26, -30,
    -48, -41, -6, -14, -52, 14, 11, -27,
    -39, -9, -25, -51, -2, -4, -8, -24,
    7, -41, 60, 3, 49, 44, -41, -48,
    -14, 11, 5, -23, -1, -36, 35, -32,
    16, -38, -11, -8, 10, -6, -32, 4,
    31, -5, -14, 4, 16, -18, 3, 10,
    -12, 25, 19, -41, -10, 6, -14, 41,
    -33, -19, 6, 13, -20, -28, -6, -40,
    38, -20, 16, -52, -43, -5, -28, 8,
    11, 38, -24, 0, -27, -22, 4, -16,
    85, -22, -3, 46, -44, 39, -11, 6,
    -31, 28, -2, 6, 63, 27, -69, -5,
    -127, 29, -6, -16, 6, -4, 2, -17,
    41, 47, 67, -33, 6, 0, 21, -19,
    7, -68, 14, -34, 31, 43, -13, -50,
    -4, -23, 23, -12, 0, 13, -14, -2,
    -26, 38, 2, -2, -4, 12, 4, -22,
    -19, -14, 62, -26, -58, -22, -45, -19,
    11, 13, 44, 8, 88, 12, -19, -45,
    -1, -3, -4, -42, -16, 21, 32, 8,
    -1, -5, -5, -9, -1, 1, 1, 5,
    51, 23, -12, -3, -9, -6, -6, -14,
    4, 10, -18, 16, -11, -7, 2, 6,
    -7, 21, -39, -20, 3, 40, 14, -28,
    23, -5, -10, -2, 3, -4, 1, -5,
    -2, 25, -23, -3, 3, -20, -8, -4,
    -12, -28, 1, 15, -25, 33, -2, -5,
    -24, 2, 39, 27, -13, -13, 10, 27,
    -16, -24, -8, 6, -2, -5, 8, -1,
    -4, -14, -16, 25, -18, 41, 6, 23,
    -6, 12, 15, 3, 11, 11, 0, -1,
    -73, 30, 16, 36, -26, 26, 4, -10,
    1, 6, -4, 8, 2, 0, -1, 1,
    18, 33, -9, 3, -37, -23, 8, 1,
    -12, -4, 2, -5, -7, -15, 13, -11,
    -31, -23, -69, 14, 11, -12, -11, 49,
    4, -4, -15, 8, 2, 0, 1, 3,
    13, 15, 10, 7, -2, -16, -39, 9,
    -25, -25, 1, 11, -3, 5, -25, -2,
    8, 29, 22, 23, 13, 8, 41, 6,
    0, -11, -3, -17, -5, -2, 0, -2,
    -1, -11, 18, 7, -12, -30, -18, 24,
    18, -28, 8, -24, 32, -13, 12, 2,
    16, 21, 21, -4, -14, -19, 13, 5,
    -1, 4, 12, -13, -1, -3, -3, -2,
    -6, -23, -11, -44, -9, -20, 14, -3,
    -2, 16, 12, 2, 12, -7, 19, 12,
    -22, 0, 11, -10, 5, -9, 19, -16,
    7, -4, 0, 17, -5, -3, -3, 0,
    -6, -41, -8, 27, -2, -20, 16, 27,
    -9, 6, 11, -12, -4, -17, -11, 1,
    13, 4, -11, 27, 18, 49, 8, -10,
    -15, -2, -9, 1, 3, 2, -1, 1,
    -27, -9, -4, 0, 24, -12, 14, 8,
    -3, 9, 12, 19, 23, 2, -32, -46,
    -7, -31, 11, 11, 13, 21, -12, 13,
    -14, -5, 15, 9, 2, -1, -2, 0,
    -25, 20, -34, 9, -16, 34, 23, -13,
    12, -6, 9, -3, 12, 3, 7, 20,
    21, -7, 5, 36, 25, -32, -14, 1,
    -16, -1, 0, 2, -1, 0, -2, -3,
    -11, 57, 10, 3, 15, 2, -8, 22,
    12, -26, -1, 7, 10, 3, -31, -11,
    -3, -25, 32, -10, 36, -11, 1, 7,
    10, -4, 0, -1, 0, 1, -3, 1,
    15, 21, 6, 20, 4, 4, 16, -3,
    -24, -20, -1, -14, 32, -1, 7, 34,
    -12, -34, -37, -48, 16, 13, -29, 25,
    0, 10, -3, 15, -1, -3, 4, -5,
    -22, -54, -18, 33, 4, 29, -32, 21,
    14, 3, -21, -19, -9, -33, -16, 24,
    3, -17, 20, 23, 0, -19, 12, 0,
    5, -8, 11, 1, 0, -1, 0, 0,
    0, 34, -30, -69, 4, 9, 25, 0,
    -17, -20, 3, 13, 19, -1, 34, -16,
    -1, -25, 11, 9, 2, 29, -1, -12,
    -8, 5, -3, 14, 1, -19, -1, 0,
    39, -39, -21, -31, 18, -24, 6, 30,
    -12, -10, 8, 4, -11, -13, -3, -12,
    23, -24, -12, 2, 31, -33, -19, -39,
    17, -15, 10, -2, 1, -2, -1, -2,
    -8, 10, 5, -22, -12, 23, 32, -25,
    -5, -2, -7, 12, -13, -4, -27, -4,
    48, -4, -2, -31, 53, -8, -10, 17,
    -13, -10, -7, -6, -3, 2, 0, 1,
    -15, 18, -19, -2, -2, -9, 3, -27,
    -19, -6, -35, 2, 14, 30, -37, -4,
    6, 13, 23, 23, 13, 74, 30, 26,
    -5, -11, 11, 6, -2, -1, -2, 1,
    -2, -15, -9, -16, -18, -16, 3, -21,
    3, 0, 1, 15, -16, -19, 28, 1,
    -10, -14, 26, -14, -1, -21, 27, 9,
    7, 12, 12, 13, 0, 2, -2, -1,
    9, 32, 1, -3, 4, 32, -20, -7,
    -2, 6, -3, -24, -7, 14, 28, -21,
    -25, -20, 33, 2, -24, 21, -11, 30,
    -10, 3, -11, 2, -2, 6, 2, 1,
    -47, 16, -2, 40, -1, 27, 28, 0,
    9, 13, 13, 10, -11, -11, 33, -5,
    -19, -5, -5, 28, 31, 5, 13, 24,
    -8, 11, -4, 5, -3, -1, 3, 0,
    -41, -5, 7, -1, -51, 21, -15, -10,
    -4, 21, -41, -9, -7, 12, -13, 15,
    27, 12, -17, 22, -5, 4, -11, -8,
    -15, 4, -1, 0, -1, 21, 3, -4,
    5, -23, -1, 9, 25, 0, -58, -15,
    4, 15, 5, 7, 66, 20, -25, -2,
    23, -2, 2, 19, -4, 14, -10, 3,
    7, 4, -5, -8, -4, 3, -5, 2,
    14, -7, -13, 0, 12, -6, 16, -5,
    27, 27, -22, -10, -39, -4, 29, -15,
    34, -14, 64, -14, 11, 6, 8, -27,
    -4, 13, -1, 10, 1, 0, 1, -1,
    -4, -28, -10, -29, -1, -23, -4, -9,
    0, 2, 5, 23, -5, 11, -11, -22,
    3, 14, 6, -25, -26, -18, 15, 16,
    -10, 9, -3, 2, -1, -2, 2, -2,
    -17, -2, -32, -1, 25, 0, 8, 11,
    8, 19, 22, -18, -10, 9, -58, 14,
    -2, 4, 20, -4, -13, -21, 7, 16,
    0, 3, -6, 8, -2, -3, -1, -3,
    -1, 8, -11, 1, -9, -52, 18, 2,
    14, 15, -15, -24, -20, 17, 17, -14,
    -18, 25, 17, 32, -18, 7, 0, 20,
    1, -1, 1, -8, -3, -2, 3, 1,
    -9, 12, -3, -13, -11, -11, -20, 12,
    4, -10, -5, 19, -22, 24, 5, 18,
    -28, -1, -40, -21, -3, 21, -39, -5,
    7, -3, 24, 3, -3, -3, -2, -3,
    1, -13, -37, 4, -63, 36, 23, 34,
    -4, -16, 14, 10, -9, 12, 8, 9,
    12, 29, 29, -1, -1, -54, 11, 5,
    -9, 29, 22, 16, 3, -10, 2, -1,
    -2, -25, -3, 39, -4, -9, 2, 23,
    69, -57, 6, -16, 21, -18, -9, -23,
    -11, 26, -17, 15, -26, -1, -4, -8,
    3, -10, -1, -15, 0, 5, 0, -1,
    -9, -15, 8, -6, 6, -19, 10, 5,
    14, 1, 8, -13, -4, -15, -18, 9,
    14, -39, -7, -25, 17, -4, 20, 50,
    5, -15, 27, 13, 3, -1, -2, -13,
    38, -6, -16, -31, -2, 19, 16, -46,
    6, 22, -3, -1, 2, -15, 16, -19,
    -35, 11, 29, -29, 4, 25, 18, 9,
    10, -4, 0, 15, 0, 3, 3, 2,
    28, 16, -1, -11, 17, -7, 16, 0,
    0, -7, -12, -25, -7, -11, 15, 42,
    47, -25, 14, 30, -27, 24, -10, -12,
    5, 2, -2, 5, -2, -7, -3, 0,
    55, 10, -56, -37, 17, 9, 24, -16,
    21, -14, -36, -13, -8, -8, 11, 8,
    -14, 19, -27, 10, 6, 48, 25, 4,
    22, -16, -18, 4, -5, 1, 0, -1,
    -30, 27, -7, 1, -8, -29, 13, 17,
    -31, -30, -5, -16, -21, 12, -5, 14,
    11, 3, -60, 15, -14, -24, 8, 28,
    -8, -12, -4, -6, -2, -2, 9, -4,
    -9, -42, -15, 40, -5, 22, -17, 29,
    -13, 7, -14, 16, 12, -17, -4, -42,
    11, -16, -66, -21, 43, -14, -11, -26,
    11, 4, -18, 0, 4, 3, -4, 2,
    19, 9, 13, -18, -7, 2, 26, -14,
    -7, 5, 55, -32, -22, -6, -8, 33,
    52, -47, 4, -3, -42, -16, 10, -8,
    11, -5, 1, 28, 4, -2, 6, 2,
    -3, 23, 7, 24, -9, 0, -19, -42,
    -8, -29, -19, 12, 35, -18, -15, -2,
    -25, -11, -43, -6, -35, -40, -4, -44,
    2, 3, 4, -4, 0, 0, 2, 1,
    -19, -49, -3, -16, -30, -30, -11, 6,
    -27, -32, 15, -72, 18, -16, 5, -13,
    -21, -16, 12, 14, -39, 7, 0, -12,
    -6, -2, 13, 2, 1, -3, -5, 3,
    -4, -7, -38, -30, 1, -12, 15, -18,
    -8, -6, 34, -45, 33, -1, -8, 10,
    19, 46, -67, 46, -13, -26, 23, -3,
    24, -13, -3, 6, -7, -3, -2, -4,
    -13, -3, 5, 71, 2, 1, -10, -17,
    -18, 57, 5, 0, 7, -3, -42, 8,
    -14, -27, -36, 31, -21, -1, -13, 17,
    6, -6, 5, -8, 1, 4, 0, 2,
    -2, -6, 27, 4, -43, -50, 18, 19,
    -20, -30, 5, -4, 7, -12, -38, -45,
    -11, -19, 0, -69, 25, 17, -34, -2,
    -5, -7, -1, 1, 3, 2, -3, 0,
    -32, 32, -4, 50, -4, 24, -19, 37,
    -5, -18, 7, 7, 31, 11, 17, 16,
    68, 19, -31, 32, -20, -15, 29, -4,
    -4, -2, 14, 1, 3, -1, 1, -1,
    -32, 55, -6, -46, 13, 17, 36, -16,
    41, -24, -10, -14, -33, 8, -26, 32,
    21, 39, 7, -17, 21, 10, -18, -13,
    4, -26, 9, 9, 2, 5, -1, 0,
    4, 23, -16, -3, 29, -27, 0, -16,
    22, -47, 19, -26, -29, -18, 35, 40,
    10, 40, 0, -34, 27, 12, 32, -6,
    -5, -12, 7, -7, 2, 3, 1, -2,
    14, -36, 2, 17, -30, 3, 4, 23,
    -6, -20, -28, -44, 20, 20, -24, 6,
    15, 49, -65, -45, 22, 15, 32, -39,
    7, 7, 12, -3, -1, -2, 0, 0,
    -7, 35, -52, -45, -20, -16, 6, -27,
    -29, -16, 0, -38, 50, 26, 86, -2,
    46, 17, -5, 37, 11, 4, 13, 15,
    -6, 3, 13, 8, 4, -8, -1, 0,
    58, -22, -47, 43, 25, -3, 20, 3,
    -4, -4, -10, 60, -14, -8, -27, 12,
    -5, 18, -52, -17, -2, 0, -33, -19,
    10, -6, 10, 0, 4, -2, 0, -1,
    -44, 12, -16, -24, 18, 25, -10, -27,
    1, -9, -21, -2, 3, 16, -9, 31,
    14, 9, -31, 20, 36, -8, 36, 24,
    -14, -2, -10, -5, -4, 6, 2, 1,
    -11, 35, -16, 16, -15, -1, 27, 10,
    -27, 8, -61, 15, 42, 20, -83, -18,
    23, -44, -17, 14, 3, 1, 4, 20,
    -22, -22, -2, -2, 1, 5, -2, -2,
    -3, 11, -5, -41, -5, -4, -3, -12,
    13, 1, -31, 3, -23, -73, 53, 31,
    26, 25, 16, -6, -7, 7, 11, -8,
    4, 10, 18, 23, -1, 2, -2, 1,
    -23, 53, 12, 8, 10, 30, 25, -11,
    2, 16, -32, -2, -3, 7, 54, -23,
    -11, -4, 4, 82, -13, -38, -3, -33,
    -11, 7, -6, -8, 0, 0, -1, 3,
    -27, 18, -21, -15, 5, 21, -8, -19,
    8, 20, 15, 25, -19, 12, 19, -20,
    29, 2, -12, 35, 72, 37, 0, 13,
    5, -12, 5, 1, -2, -2, 3, 0,
    -50, 19, 3, -14, -32, 34, -23, 16,
    -3, 30, -2, 8, -3, 18, 7, 28,
    7, -31, -11, 7, -12, -54, 28, -34,
    -15, 5, -4, 1, 2, 41, 3, 1,
    2, 9, -21, 3, 13, -4, 26, -17,
    -16, 5, -9, 18, 95, 2, -16, 8,
    8, -1, -9, -5, -30, 7, -2, 15,
    14, 13, -3, -7, -1, -1, -10, 3,
    2, 28, 16, -28, -20, 10, 29, 19,
    8, 56, -6, -11, -28, -22, 13, -18,
    -17, -3, 16, 0, 41, 7, -24, 8,
    0, 2, -6, 7, -4, 3, 2, 0,
    -14, -11, -8, 21, -8, -6, 19, 8,
    3, 2, -51, 16, 6, 8, 4, -12,
    -52, -68, 0, -6, -6, 15, -1, 8,
    -8, -4, -14, 6, -2, -2, -1, -1,
    8, 5, -22, -3, 41, 11, 0, 31,
    18, -41, 29, -7, 7, 6, -54, -1,
    45, 55, 6, -6, 8, 2, 4, 15,
    10, 11, -9, 9, 2, -3, -3, -1,
    -5, 47, -1, 22, -45, 38, -7, -24,
    18, -10, -31, -19, 6, 8, -3, -7,
    22, 12, 16, 32, 11, 13, -15, 17,
    4, -14, -2, 2, 1, 0, 7, 1,
    -41, -1, 10, -13, 4, 12, 24, 13,
    5, -1, 4, 10, 11, 8, -16, 31,
    -30, -49, -72, 44, -14, 5, -2, 22,
    3, -4, 45, 4, -1, -3, -3, 4,
    21, 46, -41, 18, 51, -17, -52, 28,
    12, -33, -1, -20, -25, -1, 25, -26,
    16, 38, 31, -1, 11, -45, 38, 21,
    -13, 24, 8, 9, 6, -12, 9, 2,
    -14, -28, 1, 24, -1, -18, 46, -2,
    79, -54, 5, 22, 27, -26, 9, -31,
    -45, -5, 8, 21, -11, 5, 31, -17,
    -10, -6, -2, -4, 1, 1, 1, -4,
    37, 26, -21, 41, -36, -46, 37, 15,
    0, -13, -11, -7, -15, 9, -11, -1,
    25, -37, 67, -48, -11, -3, 30, 29,
    -4, -30, -5, 6, -1, -1, -3, -26,
    13, -9, -10, -12, -63, 20, 2, -21,
    2, 23, 17, -11, 2, -21, 34, -31,
    1, 16, 21, 18, 1, -4, 12, -17,
    -6, -4, 4, 10, -3, 2, 4, 5,
    53, -12, -19, -50, -26, -6, -24, 6,
    -31, -42, -54, -63, -2, -9, 37, 55,
    13, 2, 4, 13, 41, 5, -8, -2,
    7, -2, -19, 29, 0, 1, -6, -2,
    12, 11, -26, 33, -8, -37, 20, 14,
    -6, -51, 0, -14, 12, 12, 15, 6,
    12, 12, -17, -11, -28, 23, 37, 55,
    38, -23, -13, 27, -2, 2, -2, -10,
    -11, 25, -36, 17, 8, -26, -3, -12,
    -16, -27, 7, 14, -24, 27, 18, 7,
    16, -30, 27, 40, -30, -27, 10, -54,
    -10, -13, -14, 18, 3, -10, 9, 0,
    -13, 5, -18, 4, 24, -16, -23, -32,
    -49, -6, -19, -20, 26, -27, -1, -29,
    3, 2, -13, 8, 7, -16, 52, 25,
    6, 20, -16, -6, 10, -1, 3, 11,
    55, 4, 29, 33, 12, -19, 16, 3,
    -41, 6, 108, -61, -3, -19, 20, -2,
    -59, 2, 2, -28, -4, -12, 34, 2,
    -2, 9, -7, 66, 8, 1, 10, 5,
    -30, 3, 30, -4, -13, -5, 73, 13,
    -4, -22, 0, 31, 35, 11, -1, -4,
    42, -55, -15, 4, 34, -21, 40, -27,
    1, 8, -20, -2, 1, 3, -2, 5,
    -41, -17, 8, 6, 22, 23, 108, 21,
    -80, -49, -11, -114, 24, -17, 27, 1,
    7, 22, -55, -17, 17, -14, 8, -4,
    -9, 10, -4, 21, -11, -7, -7, 6,
    7, -1, -19, 4, -39, 46, -15, 16,
    -27, -25, 24, -65, 29, 11, 4, -2,
    27, -45, -46, -1, 29, -26, -40, 1,
    70, -19, -36, -14, -22, -4, -5, -11,
    -4, -41, -22, -49, 21, 46, -8, -6,
    -13, 94, 41, -13, 7, -13, -20, -13,
    13, 15, 98, 25, 42, -42, -25, 4,
    16, 14, 38, -20, -5, -6, 11, 0,
    -41, -40, -9, -28, 48, 39, -21, 18,
    46, 7, 29, 12, -24, -45, -17, -48,
    -85, 36, 7, -8, -40, -52, -38, -31,
    -29, -16, 23, 18, 4, 0, 7, 13,
    -36, -28, 12, 18, 31, -74, 17, -12,
    12, -27, 42, 24, -13, -3, 31, 43,
    -75, 17, 7, -39, 55, 45, 93, -25,
    33, -1, 19, -6, 0, -8, 2, -4,
    -10, 58, 35, 1, -22, -7, 17, 42,
    47, -10, -17, -8, -54, 8, -20, 31,
    0, -107, -22, -42, -1, -33, 5, -35,
    20, -59, 6, 32, -5, 6, -2, 9,
    -36, 1, 20, -31, 3, 10, 34, 3,
    74, -60, 24, -27, -12, -62, 46, 61,
    36, -19, 7, 11, -10, 32, 40, 66,
    -33, -21, 15, 4, 8, 10, -1, -20,
    -6, -35, 37, 5, 70, -7, 8, 7,
    -33, -22, -50, -17, -36, -24, -16, -18,
    -19, -6, 38, 15, 33, -16, -50, 61,
    8, 27, 5, -30, 6, 0, -5, -9,
    10, 15, -35, 38, -24, 39, -9, 18,
    -60, -31, -28, -9, 42, -24, 64, 0,
    -26, 14, 48, -9, -16, -13, 36, -39,
    12, 5, 22, 3, 11, -18, 1, -3,
    71, 4, 0, -21, 19, 9, -8, 20,
    -15, 10, 6, 43, -24, -10, -12, -1,
    44, 38, 6, -44, -56, 28, 26, -44,
    13, 2, -9, 10, -2, 9, 5, -3,
    -18, 20, 14, -6, 25, 10, -34, 63,
    -8, 2, -27, -9, 17, -5, 26, 10,
    -42, -41, 43, 47, -9, -73, 42, -43,
    -29, 28, 13, -16, 1, -7, -7, 0,
    -79, -10, 37, 2, -10, -2, 42, -19,
    -35, 31, -83, 12, 36, 35, -67, -62,
    23, 5, 19, -10, -59, -70, 1, 21,
    -70, -21, -18, -18, 4, 29, -7, 2,
    -46, 29, 26, 0, -26, -19, 30, 49,
    15, -5, -32, 2, -23, -41, 49, 26,
    -32, 76, -76, 8, -71, -16, -34, -23,
    -1, -4, 15, 33, 3, 3, -5, -4,
    0, -58, 35, 6, -16, -75, -10, -42,
    -11, 45, -37, -21, -46, -12, 70, -9,
    47, 4, -3, -22, 18, -74, 31, 54,
    6, -6, -23, -9, 5, -5, -1, 12,
    -67, -62, 46, 7, 30, -37, 26, 32,
    38, 25, 21, 27, -5, 4, 15, -81,
    14, -32, 17, -12, 17, -73, 2, -12,
    5, -73, 23, 12, 12, 2, 12, -1,
    56, 4, 26, -5, 58, -27, 31, 31,
    -10, -5, 0, 31, 17, -27, 2, 36,
    2, 45, 44, -60, 2, 45, -13, -21,
    -43, -2, -18, -6, 3, 126, -1, 1,
    31, -23, -22, 14, -15, -1, 22, 0,
    -14, 33, -14, 52, 94, -7, -6, -1,
    9, 25, -1, -2, 68, 34, -3, -34,
    -2, 10, -6, 7, 0, 1, -13, 5,
    -63, 54, 32, -65, -15, 20, 48, 12,
    -26, 68, 10, -16, -76, -4, -3, -19,
    -55, 23, 21, 9, -21, 15, -5, 11,
    4, -24, -34, 12, -21, -2, -1, -1,
    -9, 8, -10, -3, 18, -2, -14, 32,
    17, 14, -92, 17, -36, 30, -13, 14,
    30, 56, 21, -6, 58, -28, 41, -19,
    -11, -16, -13, -3, -14, 6, 0, -10,
    -11, -20, -19, -11, -75, 26, -15, -62,
    22, -67, 28, -10, 15, 27, -46, 16,
    -72, -57, -25, 39, 24, 31, 26, -25,
    28, 51, -21, 31, -13, -11, 4, -2,
    -76, 97, 1, -34, 56, -34, -15, 32,
    -3, -11, -31, -16, -25, 25, 25, -9,
    -3, 1, -25, 42, 28, -18, 18, 21,
    15, -47, 14, -1, -6, 5, 16, 0,
    1, -8, 46, 8, 28, 9, -28, 16,
    3, 8, 14, 21, 4, 28, 11, 33,
    23, 10, 100, -37, 21, -25, 77, -1,
    0, -6, 91, 38, -7, 3, 11, 9,
    -5, 25, -45, 11, -17, -8, -18, -19,
    1, -24, 14, -9, -2, 2, 17, -27,
    10, 34, -7, -20, 4, -41, 36, 66,
    0, 21, -18, 2, 3, -18, 15, 7,
    23, -21, -9, 23, -15, 1, -1, 6,
    94, -58, 30, 30, 36, -22, -5, -5,
    23, 12, -43, -78, 60, -24, 0, 46,
    -17, -6, -6, 24, 0, 18, 0, -1,
    -9, -19, -26, 6, 12, 15, -62, 9,
    -2, -5, -13, 28, -3, -10, -4, 2,
    10, 21, -88, 30, 6, -32, -46, -26,
    -33, -31, -61, 2, -12, -2, 7, -59,
    34, -15, 61, -3, 69, -4, 14, 4,
    9, 28, 40, -2, -11, -6, 11, -17,
    95, -11, -34, -25, 0, -9, 28, -3,
    -48, 9, -31, -33, -19, -6, 9, 7,
    30, 5, 30, 42, -8, 31, 8, -40,
    -4, -25, -54, -36, -26, 1, 23, 53,
    -16, -19, -13, -10, 18, -11, 15, 9,
    -7, -3, -4, -1, -1, 18, -25, 23,
    13, 5, -5, -39, -2, 1, -8, -3,
    42, 20, 38, -2, 18, 21, -5, -8,
    -54, 20, -1, 15, 8, -2, 3, 9,
    -27, 18, -13, -14, 9, -8, -7, 13,
    9, -26, -14, -22, -13, 0, 4, 19,
    6, -4, 17, -7, -29, 8, 7, -14,
    2, -11, -39, -19, 18, -22, 17, 1,
    -18, -15, 6, -3, -7, -6, -12, 17,
    2, 60, -9, -6, 8, 15, -6, 8,
    15, 1, 15, 4, -26, 30, 2, -51,
    8, -27, 38, -24, -16, -11, 5, -4,
    28, -6, -25, -6, 7, -36, -22, -30,
    -5, -8, -24, -15, -10, -18, -8, -31,
    3, 3, -14, 15, 15, 22, -7, -17,
    -30, 20, 15, -15, -1, -9, -6, -20,
    6, 14, -13, -5, -16, 0, -13, 28,
    -12, 10, -42, -17, 11, 9, -20, -6,
    24, 13, 10, -23, -24, 1, 12, 20,
    -35, 20, 34, -2, 13, 12, -4, -10,
    -9, -22, -14, -5, -15, -16, 5, 11,
    -15, -9, -7, -5, -22, -21, -16, -11,
    -12, 12, 34, 18, 32, 15, 39, -14,
    38, -49, 47, -17, 28, 3, 6, -11,
    -18, 5, -13, -13, -6, -3, -3, -17,
    -9, 2, -7, 7, 20, 19, -5, 5,
    31, 26, -26, 21, 26, -40, 22, 34,
    2, 8, 16, -36, -2, 9, 22, -17,
    11, -19, -6, -8, -11, 0, 1, 23,
    -20, -12, -53, 22, -18, -20, 11, -8,
    27, -3, -36, -45, -9, -22, -33, -20,
    -7, -3, 10, 17, 28, 15, -11, 26,
    11, 19, -9, -9, 21, -32, 26, 18,
    -44, 13, 9, -3, 43, -8, -23, -33,
    -3, 8, -15, -14, -16, 41, 19, -28,
    4, -22, 55, -10, -9, -1, -9, 40,
    -4, -7, 11, -11, -28, 0, -22, 24,
    -16, 17, 0, 18, -17, -29, -37, 1,
    19, -8, 25, -1, 27, 0, -8, 4,
    -19, -7, -28, 18, -5, -27, -21, -41,
    -12, 1, -4, 6, -9, -4, 10, 4,
    17, -22, 7, -11, -7, -14, -4, -27,
    45, -15, -12, -50, 17, 22, -51, 23,
    -14, -8, -49, -21, -25, 21, 7, 6,
    0, 2, 24, -4, 16, -9, -16, -6,
    -23, 33, -10, -45, 20, -25, 6, 2,
    17, -4, 31, 30, 21, 21, 4, 5,
    36, 36, -17, -26, -21, -26, -23, -31,
    39, -13, -10, 16, -19, -27, -2, 13,
    2, 4, 1, -4, -8, -25, -9, -3,
    0, 34, 12, -3, 23, -6, 10, -31,
    0, 7, -12, -3, -25, 9, 18, -12,
    33, -25, -3, 7, 8, -2, 2, -2,
    -11, 12, -4, 4, -1, 5, -16, 14,
    -23, 3, 20, 7, 3, -12, -43, -63,
    17, -14, -27, -31, -9, 5, -5, 28,
    -29, 11, -3, 5, 43, 15, 18, 13,
    -24, -24, 8, -9, -4, 6, 10, -7,
    1, 10, 10, -14, -1, -48, 14, -1,
    -6, 12, 17, -26, -22, 15, 6, 54,
    -8, 8, -19, 20, -1, 14, 13, -7,
    -5, 18, -11, -29, 4, -13, -24, 19,
    -39, -14, -9, 14, 5, -9, -17, -19,
    38, -13, -14, -35, 5, 19, 9, 10,
    11, -9, 13, 18, 8, 2, 17, 12,
    -2, -12, -13, -19, 0, 33, 31, 18,
    23, 7, 24, -19, 1, -10, -20, 15,
    34, -13, 15, -34, 13, -7, 8, 16,
    -6, 19, -21, 25, -15, -21, -22, -7,
    14, -41, -20, -17, 28, 4, -32, -1,
    14, 12, -1, 29, 14, -24, 11, -8,
    -39, -2, -19, -5, -12, -60, 42, -12,
    -23, 55, 32, 5, -21, 11, 3, 20,
    -35, -5, -43, -12, -10, -18, -20, 4,
    16, 24, 30, -44, -6, 4, -23, -6,
    -1, 22, 2, -3, 4, -49, 2, 5,
    9, 21, 29, -2, 20, 0, 18, 1,
    -14, 36, -17, 35, 21, -12, -1, -6,
    21, -31, 6, -29, -6, 26, 3, -24,
    -54, 10, -18, -6, 46, -18, 16, 6,
    -19, 15, 13, 24, 7, -4, 17, -7,
    -17, -25, -3, -11, 9, 29, 7, 14,
    4, -18, -9, 9, -48, -3, 15, -3,
    -3, -15, 8, 7, 1, -13, 4, -17,
    -2, -38, -3, 6, 21, -7, -5, 1,
    17, 32, 34, 21, -7, -12, 3, 12,
    15, -17, -29, -2, 26, 1, 19, 7,
    -8, 6, -18, 17, -2, -19, -6, 16,
    9, 10, 4, -17, 11, 9, -10, -10,
    15, -9, -5, 26, -6, 6, 9, 17,
    -31, 15, -13, 26, 1, -14, 5, -20,
    -30, 6, 24, -26, -20, 7, 18, 29,
    2, 2, -7, 7, -33, -1, 13, -3,
    15, -6, -2, 30, 9, 6, 5, 13,
    32, -18, 28, 28, 29, 5, -15, 13,
    0, 33, 1, 19, 28, 16, 29, 30,
    5, 22, -13, -3, -14, -12, -57, 0,
    13, 3, 5, -65, -7, 2, -5, 12,
    3, 1, -33, 1, -7, 6, 2, -11,
    20, 2, 5, 43, 0, 6, 4, 16,
    -23, 29, 6, -41, 9, 10, 0, -15,
    14, -11, -4, 3, -6, -2, -15, 18,
    25, -4, 38, -3, 48, -7, -3, -8,
    -1, -18, -32, 12, -16, 0, 15, 5,
    -7, 21, 24, 28, 6, -29, -12, -11,
    -10, 10, -14, 15, 26, 0, 15, 2,
    -31, 39, 59, 16, -1, 12, -39, 13,
    27, -9, 56, 1, 9, -20, 17, -13,
    33, 17, -1, 3, -5, 13, -2, -5,
    -6, -6, 2, 17, -3, -29, 5, 15,
    32, -18, -25, 18, 8, 30, -9, -19,
    20, -18, 27, -19, 25, 22, -15, -13,
    70, -22, 31, 5, -26, 33, -25, 15,
    -12, -7, 13, -14, 2, 0, 8, -3,
    8, 3, 9, 15, -3, -14, 14, -13,
    30, -30, 35, -2, -14, -9, -22, 3,
    -6, -2, -38, 5, -4, -14, -36, 22,
    10, 29, 13, 3, -8, -3, 20, 5,
    7, 8, 22, 18, -32, -18, -13, -24,
    49, 9, 21, -13, -13, -3, -30, 6,
    1, -8, 2, -4, 26, 9, -8, 8,
    9, -3, 21, -16, 7, 10, 21, -16,
    -27, -23, -6, -8, 43, -8, 7, 8,
    20, -30, -42, 28, -2, -28, -41, -32,
    5, -23, -3, 21, 0, 22, 11, 2,
    -10, -37, -23, 13, 29, 21, -27, 11,
    1, 24, 7, -1, 5, -28, 34, -13,
    15, 114, 42, -22, 8, 25, -27, 1,
    11, -25, 7, -17, 28, 26, -18, 18,
    -14, -21, -18, 22, -7, -13, -6, 2,
    48, -5, -37, 1, 5, 0, -25, -17,
    -8, 51, -11, 65, 7, -15, 5, -30,
    -3, 38, -44, 10, 24, -6, 9, 16,
    20, -29, 3, -41, 7, 7, 10, 6,
    -10, 20, -1, 26, -2, -22, -4, -28,
    -27, 24, 10, -6, 7, -13, 27, 4,
    -5, -39, 0, 2, -28, 7, -3, -29,
    -1, 25, 8, 18, -8, 21, 9, 55,
    30, -28, -22, 12, -29, 1, -3, -36,
    53, -1, -4, -35, -23, -15, -1, 8,
    22, -5, 16, -3, -7, -17, 5, 1,
    34, -40, 26, 8, 9, -21, 27, 4,
    6, -8, 12, 0, 17, 24, 19, 5,
    27, 29, 35, -22, -37, -18, -18, -26,
    0, 43, -9, -33, -36, -4, 7, 1,
    -7, 16, 12, 14, 11, 14, 20, 6,
    1, -10, -2, -23, 29, -34, -1, 25,
    31, -6, 31, -10, -22, -2, -11, 4,
    -3, -3, 6, 1, 13, -20, 4, 16,
    44, -5, -27, 41, 15, -24, 29, 4,
    -5, -4, 26, -22, 14, 38, -17, -19,
    9, 13, -30, 20, 20, 8, 10, 4,
    -28, 9, 14, -51, 20, -5, -20, 6,
    18, -33, 51, 1, 5, -5, -43, -20,
    -10, -20, 2, -7, -9, 0, 26, 6,
    48, 2, -83, 36, -14, 16, 11, -22,
    -10, -9, -28, -35, 3, 8, -33, -13,
    81, -35, 3, -21, -22, 4, 48, 47,
    -28, 32, 47, 33, 20, 0, -20, 17,
    49, 22, -20, -3, -16, 13, -5, 30,
    -22, -13, 16, 9, -45, 6, 7, -10,
    76, 27, -70, -1, 58, -24, 9, -18,
    26, -28, 33, -1, -38, 29, -5, 10,
    8, -7, -56, -26, -7, -28, 3, 12,
    -11, -11, -7, 12, -24, -4, -5, 35,
    2, -16, 5, 36, 19, -1, 15, 9,
    -24, 15, -31, -1, 6, 5, 30, -14,
    -75, -16, -1, 7, -21, -35, -51, -57,
    -9, 20, -21, 17, 12, 8, 31, -11,
    -23, -41, 15, 0, -5, -22, 10, -11,
    8, -10, 7, -32, 40, -25, -14, 2,
    -10, 37, 10, 4, -11, 6, -12, 18,
    19, -40, 2, 1, 12, -14, -16, 5,
    -4, 38, -7, 10, 2, -1, 28, -2,
    -17, -18, -5, -28, 1, 14, 32, -26,
    55, 23, -9, 44, -12, -21, -31, -36,
    29, -5, 17, -11, 12, -10, 0, -2,
    12, 6, -16, -8, 22, 25, 20, 11,
    -13, -36, 6, -2, 1, -4, -11, 30,
    35, -37, 22, -9, -8, 7, 23, -24,
    24, -4, 19, -5, 10, 4, 10, -21,
    1, -25, 14, 47, -4, -1, 12, 6,
    0, -1, 15, 14, -12, 12, -7, -11,
    38, 5, -12, -26, -7, 0, -14, 25,
    1, -35, -9, 9, 13, 27, 12, 0,
    -67, -41, -3, -12, -20, -4, 22, -17,
    37, 2, -27, -4, 2, 4, -14, 12,
    -15, 7, -9, 7, 3, 16, 12, 29,
    6, 10, 4, 21, -1, -3, 11, -4,
    11, -1, -71, -58, -18, -6, -27, 2,
    -38, -13, 3, 3, 4, 16, -2, 16,
    53, 30, -22, -15, 2, -1, -12, -5,
    6, 7, -14, 24, 19, -10, 4, -12,
    -2, -35, 41, -29, 16, 7, -25, -12,
    8, 10, -1, 12, 10, -9, 15, -30,
    -10, 19, -49, 76, -20, -23, 23, 13,
    -8, -20, -17, 12, 2, -8, -2, 9,
    31, 27, -4, 28, 8, 11, 5, 12,
    -3, 15, 18, 0, 41, -3, -22, 1,
    16, 6, 22, 4, -4, -59, 52, -22,
    0, 29, 16, 3, -12, -12, -5, 28,
    18, -30, -19, -13, -4, 10, 31, 15,
    -31, 14, 10, -59, 22, 39, -15, -15,
    17, -5, -5, 18, -7, -23, 20, 41,
    4, 0, -22, -5, 16, 8, 10, -21,
    2, -14, 9, -62, 5, -13, 2, -23,
    12, -25, -3, -15, -1, -8, 19, 28,
    -13, -79, -9, 34, 43, 14, -4, 5,
    -14, -37, 23, 2, 8, -17, 18, -17,
    8, -25, 5, 7, -10, -18, 21, 1,
    4, -4, -50, 27, 2, -20, -50, -23,
    7, -7, -37, 0, -6, -3, -37, -6,
    -33, -14, 39, 27, 30, 18, -7, 1,
    -2, -3, -82, -46, -6, 10, -6, 8,
    13, 5, -23, -3, 23, 7, -4, 0,
    -4, 10, -28, -2, 2, -19, -17, 17,
    -8, -16, 13, -37, 20, -1, 3, 23,
    19, -28, -21, 3, 29, -20, 0, -16,
    10, 38, 17, 14, -16, 3, -25, -17,
    18, 0, 53, -14, 17, -7, 2, 1,
    -34, -28, -5, 14, 5, 4, 0, 20,
    15, 9, 4, -19, -14, -15, 21, 0,
    3, 18, 31, 15, 20, 25, -26, -15,
    -7, -13, -4, 18, 27, 45, 12, 10,
    3, -34, -18, -11, 17, -17, -76, 7,
    8, 40, 15, 67, -29, 18, -8, -2,
    16, -11, -14, 34, 8, -26, -12, 45,
    87, -38, 32, -21, -4, -10, -11, -20,
    26, 1, 9, -30, 32, -17, 10, 8,
    26, -8, -13, -30, 5, -1, -10, -16,
    28, 1, -14, 4, 60, -25, -24, 14,
    26, -9, -44, 24, 8, -31, -18, 10,
    12, 38, 12, 24, 5, -32, -12, -7,
    -32, 9, -34, 9, 6, -3, -2, -4,
    -2, 35, 6, 36, -22, 11, 6, 4,
    33, 5, -40, -6, 11, 15, -6, 23,
    4, -8, 25, -11, -34, 6, 30, 22,
    11, -18, -3, -35, -11, -28, -53, -33,
    -43, -8, 9, -20, 18, -5, 24, 16,
    6, -8, -7, 7, 28, 31, -11, -6,
    38, -60, 28, 29, -36, 31, 3, 11,
    1, 5, -35, 9, 6, 6, -1, -6,
    49, 16, 28, 3, -6, -3, 19, 0,
    -19, 29, -57, 14, -30, -12, -19, -5,
    -6, -3, -21, 24, 27, 14, -3, -14,
    73, -20, -17, 12, -2, 13, 14, -11,
    26, 12, 10, 32, 10, 27, -55, 0,
    14, 16, 56, -7, 15, 4, -7, -11,
    -19, 10, 16, -13, 9, 2, 17, 21,
    -3, 2, 40, 23, -22, 9, -9, -9,
    16, -15, -21, -35, 45, -6, -11, 13,
    -57, -17, 66, 40, -31, -17, -42, -18,
    -27, -16, 34, 3, 10, 3, 29, -7,
    19, -8, 52, -5, -38, -36, 22, -6,
    -9, 11, 3, -5, -30, -3, 29, 16,
    27, -78, -57, 2, 6, -5, 8, -20,
    70, -11, 22, -61, 11, 23, 8, 21,
    17, -34, 14, 55, 16, 35, -10, -5,
    79, 35, 0, 30, 26, -34, 24, -12,
    19, 24, 51, -15, 18, -41, -16, -49,
    -71, 60, -65, 41, 51, 0, 17, 40,
    -19, -19, 55, 52, 14, -19, -1, -19,
    27, 16, 12, 6, -2, -5, 9, 44,
    -28, 45, 43, 52, 11, -53, 25, -54,
    39, -1, -58, -16, -15, 34, -17, -22,
    -42, -44, 25, 0, 6, -7, -8, 5,
    27, 53, -64, 13, 37, 42, 1, 83,
    -79, -8, -33, 25, -19, -17, -31, 24,
    -51, -64, 2, 7, -17, 34, 36, 3,
    -31, -54, -45, 15, 14, 16, -2, 8,
    5, 6, 1, -28, 14, 31, 27, -44,
    -25, -3, 8, 15, -14, -23, -20, -37,
    21, 54, -29, -5, -15, -27, -9, 6,
    1, -8, 31, -11, -4, 2, 30, -1,
    -11, 33, 49, -24, -14, 7, 18, 23,
    14, -61, 11, -27, -18, -13, 4, -21,
    28, -7, 38, 18, 13, -9, 27, 37,
    5, -1, 12, 12, 10, 2, -1, 0,
    -7, 7, -27, -17, -20, 7, -62, 41,
    -80, 112, -44, 6, 56, -8, -3, -26,
    -9, 2, 71, -60, 16, -23, -22, 51,
    13, 59, -19, -13, -19, 7, 8, -2,
    14, 18, -20, 5, -78, 44, -70, -46,
    -14, 50, -5, -31, -14, -3, 42, 20,
    -6, -36, 62, 39, 65, -4, -23, 4,
    -27, 25, 62, 45, -2, 11, -74, -55,
    -44, 59, 12, -20, -27, 33, 56, -5,
    -42, -24, 4, 28, -20, -20, 2, -9,
    -1, -86, 77, 37, 45, 54, -23, 12,
    0, -52, 48, -62, -52, 5, 8, 20,
    51, -31, -2, 10, 15, -76, 27, 57,
    -66, 69, -67, 19, -24, 48, 25, -6,
    10, -22, 21, -5, -6, -6, 2, 33,
    -23, -35, -48, -35, 22, 31, -7, -24,
    11, 33, -4, 25, 13, -25, -57, 16,
    2, 33, -34, -26, 31, -33, -23, -83,
    5, 37, -67, 73, -2, 5, 53, -22,
    57, -30, 39, 13, -9, 5, -31, 5,
    15, -7, 21, -25, -51, -71, -16, -85,
    2, -77, 27, -50, -22, 10, 21, 20,
    24, 8, 48, -27, -17, -10, -25, 24,
    25, -40, 21, 54, -30, 7, -36, -1,
    -6, 0, -1, -6, 21, 17, -6, 35,
    -22, -47, -4, -71, -22, -7, -33, -37,
    14, 44, 0, -2, 36, -1, -17, 1,
    0, 11, -13, 4, 0, 2, -38, -12,
    8, 16, 0, -9, 12, 18, 4, 11,
    62, -5, -24, 23, -32, 10, 9, -33,
    15, -7, 49, -83, 17, 32, -14, 22,
    -5, -53, 44, 11, 31, 15, -13, 41,
    7, 32, 10, 0, -16, 3, -1, -27,
    -27, 47, -15, 40, -1, 2, 3, 50,
    -27, -66, -32, 61, -23, 7, 18, -27,
    14, 57, -53, 29, 7, -33, -5, -12,
    13, 30, -7, 7, -54, 31, -1, 1,
    -55, 7, -50, 9, 23, 19, -3, -3,
    -11, -5, 20, 53, -24, -29, -10, 23,
    17, 13, 38, -34, -8, -9, 22, -15,
    -69, -33, 17, -37, -42, 4, 20, 8,
    -36, 5, 71, 2, -20, -10, -3, -30,
    33, 47, -12, -30, 32, -14, -3, 32,
    31, 29, -60, 21, -12, 22, -17, -16,
    23, 5, 29, 20, -37, -5, -7, 1,
    -35, -71, -38, -3, 23, -27, 20, 42,
    17, -33, -9, -44, -10, 10, 28, 3,
    -56, 0, -10, 16, -12, -72, 21, -4,
    -37, -36, 23, -42, -80, 3, 32, 56,
    36, 93, -3, -23, -21, -2, 70, -15,
    -20, -10, 68, -7, -27, -32, 4, 28,
    11, -14, 64, -13, -4, 21, 20, 14,
    -68, 7, 21, -63, 3, -13, -2, -31,
    -45, -46, 34, -9, -11, -13, 9, 9,
    -1, -5, -20, 47, -4, -2, -4, 35,
    32, -43, 34, -80, -38, 14, -20, 4,
    -18, 23, -9, -41, -36, -48, 18, -43,
    -3, 29, -13, -3, 12, 45, -35, 16,
    -34, -5, -3, -24, 1, -15, 23, 4,
    42, -49, -73, 6, -38, 31, 14, -4,
    17, 45, 59, 2, 92, 37, 33, 7,
    -58, 41, 34, -56, 15, 17, -35, 3,
    -6, 2, 31, 94, 63, 18, -20, 1,
    -6, -22, 73, -5, 6, 1, 27, 2,
    21, 18, 0, -3, 17, -9, -40, 18,
    2, 35, 27, -17, 8, 2, 24, 27,
    44, -41, 4, -43, 7, -17, -5, 39,
    -28, -41, 22, -28, -48, -7, -50, -9,
    -3, -16, 40, 33, -32, 2, -2, 3,
    26, 14, -49, 31, -31, -20, 10, 12,
    -30, -41, 13, 17, 52, 12, 12, 53,
    -20, 22, -3, -15, -29, 3, -3, 0,
    -11, -29, 2, -23, -65, -4, -2, -26,
    -34, -62, 27, -19, 69, 60, 0, 22,
    -23, -57, -11, 5, -18, 16, -127, 1,
    -4, -20, 19, -3, 32, 23, -7, 1,
    -13, -10, 2, 22, -60, -17, 10, -39,
    -58, 109, 10, 31, -15, -1, -42, -16,
    2, 34, 4, -75, 20, -34, 31, 61,
    4, 9, -7, 49, 10, 19, -13, -12,
    -24, -22, 25, -31, -106, 17, 39, -16,
    32, 4, 50, 16, -20, -47, -50, -4,
    41, 73, 29, 11, 3, -83, -28, -23,
    49, -14, 19, 6, 0, -25, -48, 9,
    -4, 44, -38, 42, -48, 14, -25, -6,
    -28, 31, 82, -17, 10, 46, -11, 9,
    36, -11, 33, -58, -51, 0, 87, 25,
    -11, -13, 7, 42, 1, 8, 47, 31,
    -5, -20, -38, 34, 20, -18, 58, -28,
    -35, -30, -19, -23, 34, 38, -18, -10,
    73, -70, 16, 28, -113, 48, 13, -16,
    12, -19, 31, 37, 0, 3, 13, 8,
    42, 87, -1, 4, 8, -12, -19, 55,
    -28, -49, -12, -9, 3, 7, -21, -4,
    -27, -6, -45, 118, 13, 60, 6, -32,
    -65, 14, 13, -2, -9, 15, -6, -19,
    6, -51, 42, 28, 46, -23, 20, 28,
    -22, -7, -51, -40, 4, 1, 18, -8,
    -14, 15, -2, 3, 7, -14, 47, 17,
    -42, -40, -52, 7, 16, 31, 12, -7,
    20, 4, 17, -8, -27, 24, -4, 13,
    -13, -21, -23, -63, -27, -20, -66, 3,
    -73, -4, 90, 39, 0, -3, 23, 7,
    -12, 43, -27, 26, 0, -24, -16, 37,
    30, 16, 18, 15, 26, 35, -9, 7,
    -1, -10, 0, 0, 1, 6, 16, 8,
    -23, 12, -20, 22, -6, 4, 7, 21,
    4, -24, 16, 11, 45, 59, -3, 16,
    9, -9, -8, 12, 0, 10, 0, 10,
    10, 2, 0, -8, 30, -13, -29, -11,
    -24, 0, 19, -21, 14, 55, 25, -20,
    3, 2, 23, -22, 13, -23, 2, 34,
    13, 15, -15, -1, -20, 4, -4, 29,
    0, -13, 2, 2, -28, -10, 0, -45,
    12, -6, 23, 11, -20, -10, -23, 7,
    -27, -20, 8, -6, 9, -9, 5, 8,
    -17, -21, 31, 0, -7, 2, 2, 4,
    7, 8, -9, 5, -3, 17, 17, -29,
    6, 4, -14, -17, -14, 28, -3, -16,
    18, -11, 13, -34, 15, 24, 33, 40,
    -22, 20, -22, 17, 6, -18, 14, -30,
    10, 4, -17, -3, 12, -1, 17, -15,
    -31, 2, -13, 9, 8, 0, -3, 6,
    3, 8, 24, -12, 1, -24, 45, 24,
    -4, -34, 49, 19, 2, -3, 38, 7,
    10, 10, -1, 6, -22, 13, 43, -3,
    19, -29, 35, -29, 11, 19, -11, 14,
    14, 8, -7, -6, -13, 2, 0, -13,
    4, 18, -20, -6, -2, -4, 7, 20,
    5, 10, -3, -5, 15, 4, 24, 20,
    -40, 20, -17, 18, 9, 8, 2, -16,
    9, -3, -6, 29, -29, 25, 21, 11,
    -2, 7, 13, -42, 2, 14, 38, 16,
    10, -14, -2, 6, 19, -23, -9, 9,
    -27, -4, -1, 31, 8, 20, 6, 17,
    -27, 11, -29, 59, 4, -11, -10, 20,
    9, 16, 18, 27, 4, 12, -40, -8,
    6, 13, 9, -2, 16, 11, -10, -23,
    -20, 20, -27, -10, 6, 4, -9, -12,
    -13, 32, -2, -18, -1, -38, 21, -3,
    9, -40, -24, -30, 15, -41, -34, 16,
    17, -9, 2, -16, 4, 10, -11, -15,
    40, 2, -15, -4, 9, 7, -3, -3,
    28, 36, 37, -27, -40, -1, 5, -29,
    22, 11, -31, -26, -17, -51, -9, -28,
    5, -5, -3, -1, -21, -4, -5, 0,
    21, 7, 48, -18, 6, 2, -15, 17,
    1, -27, 3, 5, 0, 0, 33, 0,
    13, -7, 27, 6, -22, -24, 22, -3,
    -14, -4, 2, -11, 22, 36, -9, -16,
    -13, -4, -4, -25, -7, -3, 7, -2,
    16, -10, 16, 19, -1, -26, -28, 31,
    -9, 17, 15, 7, -21, -2, -14, -3,
    -9, -5, 2, -17, -5, -1, -11, 19,
    2, -2, -15, -1, 17, 12, -7, 9,
    -6, -21, 11, -15, -6, 9, 32, 34,
    -17, -7, -49, -4, -1, -22, 24, 19,
    -1, 0, -3, 27, -12, 0, -17, -3,
    33, 9, 16, 12, 7, 4, 15, -18,
    4, 4, -3, -10, 4, 14, -8, -12,
    -16, -23, -53, -5, 0, -42, -22, 19,
    -10, -4, -2, -9, -15, -16, 30, 3,
    13, 57, -8, 30, -10, 2, -21, 1,
    1, 7, 4, -1, -1, -22, 33, 10,
    7, 37, -9, 20, 6, -34, 6, -14,
    -7, -20, 3, 20, -7, -8, -12, -20,
    -7, 16, 18, -22, 4, -22, -7, -21,
    0, -23, 6, -3, 46, 12, 3, -13,
    19, -13, 4, 0, -17, 21, 13, 45,
    -6, 2, -8, -6, 13, -6, -2, -8,
    -6, 34, 30, 12, 66, 4, 3, 6,
    -4, 3, -4, -12, 17, 4, 53, 13,
    32, -30, -20, -36, 13, -33, 9, 15,
    -3, 28, 10, 2, 19, -47, 28, -18,
    4, 26, -41, 37, 19, 2, 13, 15,
    -16, 37, 22, 33, -10, 13, 23, 17,
    5, -12, 18, 51, 15, -21, -13, -7,
    0, 11, 0, 0, -2, -21, 4, 4,
    -31, 40, -2, -7, 6, 26, 12, -31,
    19, 43, 13, -7, -12, -22, -4, -6,
    -5, 12, -9, -10, -14, -29, -48, 5,
    11, 6, 15, 2, 2, -17, -28, -12,
    14, -5, 13, -13, -4, 11, -7, 19,
    26, -1, -15, 16, 29, 22, 5, -9,
    15, 13, 0, 4, -35, -6, 12, -45,
    -16, 8, -13, -7, -1, 19, 27, 12,
    53, 17, 3, 17, -6, 10, -18, 4,
    -6, 13, -21, 8, -4, -4, -30, 41,
    -5, -19, -18, -3, 15, -28, -3, -3,
    4, 5, 5, 2, -15, 15, -16, 5,
    -6, -37, -34, -30, -5, 13, -8, 3,
    -8, -8, -21, -22, -3, 9, -1, -27,
    10, 29, 0, 7, -13, 30, 23, 0,
    8, -2, -2, 3, 8, -1, -17, 5,
    -73, 17, -20, 4, 15, -7, -5, -7,
    -13, 4, -13, -22, 16, 6, -22, -15,
    -18, 12, -26, 6, 39, 18, 11, 15,
    3, 4, 18, 5, 1, -3, 7, 9,
    1, 15, -19, -18, 7, -5, 10, -10,
    3, 4, 3, -2, -12, 26, 1, 4,
    -4, 8, -10, -1, -33, -19, -8, 16,
    -10, -15, 10, -9, 11, -5, 35, -6,
    44, 11, 14, 16, -1, 20, 6, 16,
    1, 9, 19, -1, 14, -5, -2, 7,
    -2, 11, -31, -26, -27, 8, 1, -17,
    19, -8, 6, -1, -4, 21, -42, -15,
    -31, -19, -11, -19, -3, -9, 2, -21,
    -12, 5, -19, -25, 7, -20, 12, -14,
    -16, -35, -10, -21, -25, 7, 13, 8,
    21, 0, 11, 10, -30, 1, 19, 22,
    2, -9, 1, -5, -15, -8, 9, 24,
    -11, 13, 2, 8, 3, 8, -23, 4,
    -39, -13, -16, -8, -2, 29, 31, -6,
    -11, -5, 19, -9, -20, -6, -13, 9,
    9, 23, -16, 5, 24, -8, 18, -4,
    8, 18, 0, 24, 13, -10, 11, -4,
    -13, 9, -9, 12, 2, -1, 28, -5,
    11, 12, 11, 6, 3, 28, 10, -16,
    8, -10, -20, 17, -10, 43, 15, -10,
    13, 24, 12, -1, -10, 1, 8, 27,
    -3, -34, 18, -2, 1, -11, -12, -18,
    -9, 14, 31, -3, 16, 0, 6, -33,
    -25, 13, -52, 14, -17, -23, 23, -15,
    -10, 30, 19, -23, 25, 10, 2, -5,
    -38, 0, -12, -24, -6, 10, 17, 18,
    6, -14, -1, 0, 28, -27, 24, -23,
    -18, -31, 33, 9, 0, -8, 29, 12,
    6, -2, -11, 8, 11, -13, -2, 10,
    12, -5, -15, 38, -10, -13, -5, -8,
    6, -8, 1, 13, 48, 25, -20, -19,
    -14, -11, -3, -22, 13, 17, -19, -9,
    2, -39, 11, 19, 8, 4, 16, 6,
    7, 1, -27, -9, -10, 30, -28, 37,
    -2, -13, -13, -33, 27, -3, -8, 27,
    7, -47, -12, -55, 3, -10, -16, 2,
    8, -10, -10, -24, 8, -19, -7, 17,
    62, 18, 17, 54, 27, 13, 21, 15,
    23, -8, -10, -28, 15, -21, -8, -21,
    -5, -6, -25, 13, 15, 51, 20, -17,
    24, 9, 3, -5, 29, -19, -8, -12,
    -7, -11, 9, -1, 11, 18, -40, -36,
    -1, -13, 8, -6, -7, -22, -26, 36,
    -10, -11, 40, -6, -7, 3, -45, 20,
    -23, -37, -18, 23, 4, -18, 11, -17,
    -15, 19, 3, 14, 1, -18, -10, -35,
    -8, 11, -30, 22, -20, 25, 2, 6,
    29, -18, 7, 1, -19, -13, -11, -5,
    9, 26, 20, -46, -8, 44, 10, 51,
    37, -9, -6, -43, 7, 3, -30, 31,
    5, 8, -29, 4, -31, -9, 6, 5,
    33, -7, 11, 30, -12, -9, 0, -5,
    3, -7, -6, -44, -10, -29, 67, 11,
    13, 5, -21, 3, 23, -16, -15, -13,
    -12, -11, -26, 3, 17, 6, 31, -20,
    3, 13, 42, 13, 7, -8, -3, -2,
    -13, 32, 2, -7, 20, -21, 2, 12,
    0, 22, 3, -18, -30, 4, 28, 9,
    10, -4, -3, 6, -14, -38, -25, 23,
    -12, 15, 0, 1, 14, -23, 7, -8,
    -30, 23, 24, -3, -16, -53, -10, 28,
    -30, -9, 17, -8, -9, 17, -38, 19,
    -8, 6, -18, 1, 4, -5, 17, 2,
    -18, 18, 0, 52, 12, -17, 14, 6,
    1, -15, 73, 12, 31, -8, -18, -5,
    22, 23, -13, 7, -22, 26, -26, 7,
    16, 21, -5, 9, -34, -23, -44, 7,
    -45, -21, 27, -2, -6, 6, -11, -1,
    16, 5, -33, 18, -19, -12, -30, 30,
    -28, 7, -6, -2, 4, 24, -28, -9,
    9, -6, 15, -2, -10, 25, 66, 16,
    5, -11, -4, -21, 15, -4, 0, -15,
    29, 1, -58, 3, -32, -10, 29, -3,
    22, 18, 22, -4, 17, -30, 31, 6,
    -13, -4, -5, 10, 20, 1, -3, -41,
    24, -10, -13, 0, 12, -7, 16, 23,
    -34, -17, -3, 4, -51, 8, 35, 9,
    -3, -5, 38, -28, -2, -22, -8, 2,
    11, 1, -17, -7, -10, -13, 2, -21,
    -18, -10, 4, 3, 13, -5, -10, -6,
    -26, -16, 18, -27, -20, 5, -22, 47,
    -14, -2, -21, 23, 2, 52, -8, -25,
    -24, -5, 0, -28, 67, 53, -24, 12,
    -23, -13, 25, 24, 3, -5, 4, -29,
    3, -9, 17, -7, 27, -3, 23, -17,
    5, -12, -13, 14, 28, -17, -22, 18,
    -7, -11, -17, 15, -3, 26, 36, 10,
    7, -14, -28, 3, 11, -7, 24, 3,
    25, 7, 18, -29, 14, -25, -67, 40,
    -2, 24, -18, 30, -9, 14, 1, -21,
    -4, -4, -16, -8, -32, 5, -17, -7,
    -21, 16, -10, -7, 1, -15, 3, 19,
    12, 23, -14, -19, 9, -50, 44, -3,
    -4, -7, -18, -11, 39, 12, -33, -4,
    -16, -8, 3, 9, -23, -2, 23, 1,
    10, -10, -22, 38, -19, -34, 7, -25,
    4, 2, 12, -4, 20, 30, 27, -48,
    -41, 14, 21, -7, 0, -10, 10, 19,
    -28, 2, -2, -20, 35, -11, 12, -47,
    1, 17, -25, -8, 41, 2, -2, 7,
    -11, 29, -40, -8, 19, -18, 51, 45,
    -4, 14, 26, -23, 46, 46, 17, 32,
    -28, 18, 21, -11, 11, 18, -4, -7,
    23, -13, 9, 20, 17, -8, -3, -13,
    2, -39, 6, -12, -26, -28, 51, 22,
    -21, -32, 9, 8, 26, 44, -8, 36,
    -7, 3, 11, 2, -62, -19, -16, 9,
    -18, -14, 4, -22, 1, 15, 4, -66,
    32, 10, 41, -7, -18, -22, -18, -17,
    8, 0, -2, -18, 57, -13, -3, -21,
    -1, -3, -4, -2, -9, 26, -6, 18,
    -16, -31, -9, 25, 5, 1, 1, -6,
    15, 18, 14, 24, -21, 29, 10, -27,
    -11, -24, -34, 28, -30, -12, -3, 42,
    -10, 14, 2, -2, -1, 11, -10, 19,
    -20, -2, 19, 22, -5, 7, 1, 7,
    -11, -16, 4, -12, 19, -24, -8, 39,
    10, 27, 18, 1, 69, 19, -2, -3,
    -5, 6, 8, -10, -21, -19, -23, -6,
    -4, -2, -2, 6, -10, 11, 4, 3,
    -7, -18, -29, 20, 9, 34, -13, -24,
    -5, -8, 17, -22, 14, -4, 92, 11,
    2, 4, 12, -7, -42, -18, 55, 41,
    63, 13, 33, 2, 16, 3, 7, -2,
    38, -13, -6, 16, 18, -6, -8, 17,
    -39, 35, -8, 9, -22, -27, -27, 23,
    -14, 0, 17, -7, 1, 28, 2, -15,
    -23, -19, -5, 19, -5, -14, 18, 8,
    23, 18, 20, -6, -49, 8, 4, 5,
    2, 0, -14, 5, 5, 22, 11, 10,
    2, -30, 21, 17, -2, 43, 9, -21,
    24, -9, -9, 21, -7, -1, 28, -3,
    -19, -2, 10, -36, -6, 2, -9, 15,
    -54, 19, 2, -19, -31, 15, 26, 6,
    6, -23, -10, -11, -22, -4, 13, 14,
    -8, -6, -16, -36, -10, -5, 3, 15,
    -9, 23, -13, -8, -38, -47, 31, -27,
    10, -9, -9, -1, 3, 8, 31, 6,
    15, -9, 4, 9, 2, 0, 23, 16,
    22, -13, -18, -9, -12, -3, 7, -12,
    16, -11, -30, 9, -2, -30, -7, -1,
    -10, -10, -32, -1, -4, 34, 4, -26,
    4, -16, 11, -25, 44, 8, 52, -5,
    7, 27, 11, -71, 12, -23, -12, -6,
    2, -5, -4, 4, -5, 18, 37, 39,
    -10, 28, 1, -1, 18, 28, -5, 28,
    17, 8, -11, 4, 1, 8, 19, -29,
    -10, -31, 14, 54, -16, 51, 11, 8,
    -7, 29, 10, -3, -13, 24, -2, 32,
    4, -30, -16, 16, 6, -13, -6, -12,
    4, 2, 18, 10, 48, 67, 41, -25,
    15, 11, 10, 45, 15, -14, 25, -17,
    -39, 3, 10, -11, -16, -12, -17, -6,
    7, 25, -11, -36, -37, 38, 5, 8,
    46, -9, -16, -14, 12, 5, -31, -26,
    4, -33, -23, -11, -1, -6, -12, -19,
    6, 11, 1, 4, 36, -8, 6, 6,
    -28, -23, 1, -14, -16, -11, 36, 35,
    15, 9, -3, 40, -17, -2, -19, 8,
    18, -33, 0, 16, -1, 2, 8, 18,
    -1, -11, 1, -18, -34, 24, 5, -12,
    -11, -3, -13, 15, -15, 19, 54, -5,
    -7, -33, -45, -66, 46, -17, -28, -31,
    -15, 14, 11, 2, 38, -37, 6, -2,
    -2, -30, -17, 46, -26, -3, 13, -27,
    48, -37, 2, 42, -27, -29, -7, 7,
    23, -10, -3, -31, -33, 5, 73, 0,
    8, 31, -12, -36, 26, 103, 1, -28,
    18, 34, 17, 35, -4, -38, 19, -46,
    -13, -5, 10, -14, 25, -4, -52, 69,
    9, 20, -7, -28, 25, 63, -1, 17,
    -70, -6, -26, -39, -57, -35, -29, 2,
    31, 79, -11, -11, -63, -66, 41, 32,
    22, 0, 23, 31, -44, 10, 42, 17,
    39, 16, -52, 50, 5, -21, 22, -7,
    -53, 12, 51, 29, 7, -7, 13, 15,
    30, 2, -5, 57, 10, 0, -15, -34,
    -16, 5, -5, 12, -19, -5, -21, -55,
    -13, 23, -46, 15, 25, 56, 6, 1,
    -17, 20, 30, 9, -21, -5, 1, -21,
    20, 24, 17, 17, 17, -27, -26, -36,
    -41, 2, -20, 25, -51, -20, 12, 27,
    -34, -29, -70, -1, 4, -76, -30, 29,
    -14, 13, -13, -7, -34, -26, 22, -20,
    19, -14, 49, 49, 62, 19, 38, -19,
    3, 37, 21, -22, -23, -19, 3, 37,
    24, -5, 12, -11, -26, -28, 29, 2,
    4, -46, -14, 8, 17, -5, 18, 11,
    -10, -3, -4, -44, 11, 24, 15, 30,
    -4, -12, -27, 27, -4, 7, 3, 19,
    -72, 34, -17, 39, 4, 30, 21, 18,
    21, -21, 12, -82, 17, -23, 1, -2,
    7, 46, -49, -17, 14, -42, -22, 26,
    3, -2, 28, -56, -16, 2, 52, -12,
    -1, 21, 17, -8, 57, 33, 4, 32,
    -38, -14, 19, -38, 9, 6, 14, -12,
    17, -21, -7, 3, -82, -14, -20, -53,
    15, -26, 18, -4, -18, 20, -1, -1,
    1, -13, 45, 15, 32, 0, -60, 33,
    -61, -56, 34, 29, -6, -20, 9, 6,
    -14, -42, 6, -3, -14, 39, 10, -16,
    -38, -64, 4, 40, -24, 49, 62, 18,
    -33, 9, -3, 23, 48, -6, 67, -21,
    -8, 35, -19, 17, -24, -6, 12, 8,
    2, -6, -38, 10, -30, 14, -34, -17,
    -11, -20, -30, 10, 26, -24, 18, -4,
    65, 32, -37, -26, -69, -1, -11, -9,
    12, 54, -10, -31, 1, -8, -10, -4,
    0, 29, -1, 27, -20, -18, -5, -2,
    -19, -7, 4, -10, -12, -7, -27, 30,
    -50, -3, 3, -32, -20, -15, 36, -56,
    13, -17, -12, -38, -17, -30, 29, -8,
    69, 60, 55, -44, -41, -30, 3, 0,
    -31, 23, -17, -31, 9, -49, -74, -35,
    -26, -35, -59, 35, 29, 17, -10, -26,
    -31, -77, 25, -33, 0, -20, 12, -14,
    -40, 18, -13, 40, -27, -18, -24, -16,
    -11, -15, 63, -24, -17, -24, 0, -14,
    35, -14, -57, -3, 20, -9, -31, -68,
    22, -91, 65, -1, -9, -27, -11, -23,
    2, 53, -30, -28, -23, -47, -11, -11,
    4, -7, 24, 26, 32, 70, -51, -15,
    -39, 22, -6, -13, -65, 6, -7, 8,
    -50, 16, 20, 14, 41, -71, -18, -2,
    -37, 10, -45, 54, -1, -4, 8, 7,
    42, -7, -30, -42, -21, -33, 18, -42,
    -40, -18, 23, -3, 11, -41, 1, -41,
    10, -24, 49, 24, 87, 2, -4, 1,
    -18, -10, 12, 2, 26, 10, -7, -23,
    -16, 45, -2, -27, -21, -41, -22, -29,
    -58, 11, 34, -25, -73, 9, -16, 72,
    30, 72, -14, -18, 1, -8, 6, 5,
    -17, -3, -27, 44, -9, 87, 69, 41,
    -13, 4, 53, -41, 3, 13, -35, 39,
    -24, 11, -25, 14, -34, -29, 5, 59,
    51, -48, -17, -18, 16, 23, 31, -91,
    -31, -75, -38, 30, 28, -25, 30, -19,
    -26, -87, 46, -33, -6, 127, 5, -16,
    2, -16, -1, -62, 34, 31, -2, 69,
    -49, 20, 6, -53, 10, -57, 15, -13,
    43, -19, 7, 3, 8, -19, -4, -50,
    -25, -5, -34, 27, 9, 30, -14, -22,
    -8, 34, -4, 1, -22, -57, -32, 33,
    -27, 17, -11, 34, -16, -2, -6, -4,
    47, -1, -37, -8, 25, -15, -38, 53,
    -17, -6, 15, -22, 9, 6, -10, -41,
    -21, -4, 21, -28, 19, 9, -11, 37,
    -19, 4, 36, 2, -3, -7, 20, 7,
    -9, 49, 28, 16, -12, -54, -51, 10,
    -1, -25, 66, 63, -22, -13, -74, -18,
    -1, 17, 11, 10, 127, -1, 74, -34,
    23, 1, 45, 25, -1, 11, 13, -25,
    2, 1, 37, -21, 76, -32, 12, -71,
    66, 23, 51, -29, 12, -12, -15, -25,
    -60, -27, 20, -36, 41, -2, 16, -20,
    36, -38, -2, -13, 25, 8, 0, 10,
    23, 16, 16, -41, -67, 15, -31, -5,
    15, -15, -20, -7, -51, -3, -3, 22,
    17, -43, 54, 75, -45, -17, -34, 10,
    -16, 14, -44, -35, -22, -17, 0, -14,
    -31, -10, 7, 42, -27, 70, 27, -33,
    -38, -29, -3, -21, 75, -36, 32, 5,
    0, -9, -58, -18, 6, 30, 35, 1,
    5, -16, 23, 10, 36, 21, 17, 10,
    24, -8, 9, -22, 1, -22, 30, 0,
    33, -8, 27, -33, 50, 4, 26, 8,
    0, -4, -17, 16, 62, -40, 29, 15,
    -35, 7, 33, -16, -17, 5, 2, -44,
    -29, -37, 11, 4, -13, -40, -32, -8,
    54, 4, -22, -21, -16, -4, -35, -30,
    30, -25, -1, -28, -7, 28, 10, -52,
    -7, 20, 95, 34, -3, -34, -4, -19,
    -25, -12, -7, 27, 46, -6, 33, -48,
    -16, 37, -41, -26, 28, 59, 13, 20,
    49, -14, -33, 21, -9, 46, -11, -68,
    4, -36, -1, 17, -22, 96, 53, 3,
    0, 50, 16, 23, -43, -3, -25, 83,
    16, -11, -63, -22, 62, -31, -14, -1,
    27, -35, -12, -3, 22, 32, -7, 97,
    15, -41, 14, -30, 9, -36, 94, -7,
    0, 10, -52, 6, -21, 74, -3, -17,
    27, -12, -8, -12, -16, 12, 10, 12,
    73, -16, -60, -11, -6, -49, 61, -5,
    -29, -5, -2, -2, 16, 6, 16, -52,
    31, 30, 26, 5, 27, 16, 25, -4,
    72, -22, -1, -34, -24, -25, -55, 49,
    16, 25, -8, 71, 23, -66, -20, -34,
    -39, 44, 26, 8, -3, 5, 25, -7,
    -31, 25, -19, 9, 10, -19, -28, -30,
    -14, 17, 28, 9, 14, 12, -31, -67,
    -11, -5, 41, -16, -2, -10, -16, 9,
    23, 8, -32, -2, -4, 20, -5, 13,
    -25, 15, -10, 3, 24, 13, -13, -30,
    -23, -6, 8, 0, 22, -11, 20, 10,
    10, 41, 2, 7, 3, 13, -2, 5,
    8, -54, -31, 29, -18, 10, 5, 9,
    6, 6, 2, 8, -38, -6, -2, 48,
    -12, -1, -8, 12, 29, -25, 10, -13,
    16, -15, 46, 7, -17, 23, -6, -18,
    0, 4, 4, 26, 13, -18, 11, 10,
    -32, 19, -2, -28, 41, -46, -59, -6,
    2, 12, -3, -16, 7, -7, -11, 23,
    -37, -6, 11, -21, 6, 0, 2, 5,
    4, -18, 4, -21, 34, 11, -28, 27,
    -17, -8, 22, -17, 19, -32, -23, -5,
    -3, 6, -5, 1, 1, 4, 24, -16,
    17, -38, -1, -4, -10, 7, -11, 19,
    31, 6, -10, -24, -29, -7, 15, 0,
    -12, 4, 5, 19, -4, 22, 23, -40,
    -5, -6, -14, -10, 13, -30, -5, 16,
    19, 6, 1, 28, -5, -22, -2, -7,
    -31, -17, -6, 34, 8, 7, 22, -3,
    19, -5, 16, -7, 10, 3, 35, 31,
    -1, -10, 1, -6, 3, 6, 4, -9,
    -35, 6, -28, -15, 17, 7, -4, -10,
    8, -20, 27, -9, -34, 19, -10, 0,
    -25, 9, -5, 38, 55, 31, 52, -9,
    21, 1, -10, -8, 3, -7, -2, 11,
    83, 5, -17, 3, 17, -1, -3, 12,
    -18, -28, 24, -7, -11, -34, -11, -23,
    0, 12, 19, -8, 39, -8, 14, 5,
    -7, -11, -11, 2, -5, -24, -7, -20,
    28, -3, -5, -13, 7, 2, -6, 11,
    -38, 20, -2, -30, 50, -3, -7, 46,
    16, 9, 17, -9, -23, -58, 14, 32,
    6, -15, 4, -5, 18, 39, 23, -9,
    12, -19, -1, 3, -12, 12, 1, -7,
    -15, -23, -24, -16, 4, 0, -11, -1,
    17, 31, -40, 14, -52, -42, -35, -40,
    4, -10, 7, -2, -27, -17, 5, 12,
    42, 1, -12, 0, 0, 8, 8, 24,
    -7, 10, 22, 17, 2, -11, -19, -15,
    6, -2, 0, 31, -1, 45, 5, 31,
    1, 1, 6, 12, -4, 10, -1, 21,
    -2, -5, 14, -18, -14, -4, -13, -7,
    -3, -7, 30, 19, -3, 18, -23, 2,
    -10, 26, -3, -15, -25, -22, -43, 12,
    0, -2, -17, 3, -4, 38, -28, 8,
    -8, 27, 15, -34, 14, 16, -5, 10,
    -13, -11, 30, 30, 16, 18, -30, 0,
    -39, -17, -31, -11, 24, 15, 36, -21,
    15, 7, -9, -12, -5, -17, 4, 12,
    -4, 11, 11, -50, 25, 2, -4, 17,
    -22, -5, 17, -1, 7, -8, -17, -27,
    -41, -16, 22, 46, 38, -11, 32, -16,
    -7, 0, 5, 5, -12, -2, -2, -10,
    -38, 19, -14, 40, 33, -24, 11, 0,
    39, 31, 6, 4, 5, 20, -9, -2,
    6, -18, 28, -4, 22, 16, 24, -11,
    -11, 1, 8, -2, -9, 1, 25, 24,
    -5, -7, -35, 68, 4, 25, -15, 14,
    -20, -24, -14, 8, 14, -9, 13, -11,
    -8, -6, 31, 35, 15, 12, 35, 12,
    -6, 3, -2, 2, 2, 0, -16, 9,
    28, 33, -38, 16, 23, 2, -4, 33,
    -55, -11, 12, -8, -10, 25, 0, 36,
    22, -24, 26, -11, -15, -13, -9, -10,
    -6, 5, -11, 12, -18, 11, 5, 9,
    3, 43, 1, 17, 15, 2, -1, -12,
    12, -21, 13, -11, -14, 12, -1, 9,
    4, 29, -4, -26, 19, -22, 0, -73,
    2, -5, -7, 9, 9, -12, 24, -24,
    -13, 22, -10, -24, -24, 29, 3, 23,
    -15, 17, 5, -9, 31, 25, 5, -6,
    29, -5, -33, 7, -31, -18, 1, -33,
    -19, 6, -10, 0, 27, -14, 19, 11,
    -16, 34, -17, 16, -16, -3, -2, 5,
    16, -5, -9, -24, 9, -3, 24, -16,
    -7, -22, -13, -35, 26, 1, 3, -28,
    -3, 9, -2, 8, 12, -8, 1, 21,
    -19, -3, -12, 32, 0, 7, 4, -3,
    -1, 29, 14, 2, 46, -2, -18, -10,
    48, 0, 12, -7, 29, -72, 43, -5,
    -24, 1, 21, 10, 1, 21, 33, -12,
    27, -25, -18, -25, -5, 13, -3, -7,
    -15, 5, -22, -16, -8, -2, -2, -39,
    27, 34, -31, -2, -4, 1, 41, 8,
    12, 3, 4, 6, -14, 9, -2, -14,
    -4, -7, 9, -13, 4, 11, 15, -7,
    -3, 17, -16, 21, -20, 1, 36, -14,
    -6, 7, -10, 24, 43, 6, -3, -22,
    -2, 9, 3, -4, -18, 6, 18, -9,
    4, -13, 22, 29, 7, -2, 4, -4,
    -7, -4, -48, -21, -22, 6, 20, -10,
    9, 7, 1, 27, -3, -2, -43, -1,
    12, 0, -1, -14, -25, 18, 2, 2,
    -25, -16, 10, -11, -12, 2, -19, 6,
    0, -23, 17, 22, 3, 18, 29, 38,
    2, -8, -2, 8, -28, -8, -30, -11,
    -9, 1, -4, 6, 15, 17, -13, -2,
    -12, 6, -22, 17, 13, 1, 14, 16,
    8, 16, -10, 24, -14, -27, 25, -14,
    -26, 5, 2, 22, 21, -19, -44, 1,
    -12, -9, -2, -6, -6, 25, -42, 34,
    3, 15, -1, 8, 17, -15, -4, -7,
    -11, 22, 10, -12, -1, 19, -9, -3,
    3, -26, 5, -1, 6, -9, -4, 32,
    10, 7, 9, -2, 16, 2, -9, 0,
    34, 24, -16, -37, 4, 7, 8, -14,
    0, 11, -6, -26, -10, 10, -40, 5,
    -12, -2, -25, 20, -3, 25, -11, -65,
    -6, 1, -11, 0, 14, -23, 9, -15,
    19, -38, -19, 19, 28, -59, -16, -15,
    25, 19, 0, 19, -6, 10, -28, 9,
    -15, 29, 26, -15, -6, -16, -20, 20,
    2, -13, 6, 16, -32, 58, 0, 5,
    -22, -6, -3, 70, 11, 23, -17, -8,
    -23, -21, 18, 2, -33, 56, -46, -15,
    -4, -23, 10, 14, -3, -2, 45, 12,
    7, -4, -5, -1, 2, 6, 16, -12,
    -5, -19, 16, 22, 4, 6, 18, -4,
    -36, -19, 17, 26, -19, -1, -2, 29,
    -54, 30, 4, 4, 44, -5, -23, -2,
    -1, -3, 2, 3, 20, -18, -18, -3,
    -1, -58, -9, -36, 3, -2, -17, 8,
    28, 13, 3, 2, -16, -27, -23, -7,
    18, 10, -21, 6, 3, -60, 50, 44,
    -11, 1, 9, 14, 11, 5, -8, 29,
    -20, 11, 0, -7, -5, -5, 3, -8,
    -22, -8, 20, 45, 19, 36, -22, -20,
    -13, -11, 24, 33, 5, -18, 40, -38,
    21, 5, 1, 13, 11, -5, 26, 3,
    30, 20, -8, 17, -9, 40, 37, 0,
    2, -33, -33, -20, -2, 30, -31, 89,
    -8, 2, -38, 0, 18, 11, -1, 1,
    -17, -1, 31, 14, 16, -38, 6, -12,
    -18, 18, 23, 34, 8, 17, -18, 1,
    -32, -42, 48, -8, -25, -18, 47, 51,
    3, 40, -30, -3, -26, 3, 6, -34,
    7, -3, -10, 29, 2, -17, 0, -12,
    15, 21, 48, 75, 0, 15, 24, 7,
    -36, -20, 40, -21, 35, -38, -40, -56,
    4, -10, -11, 4, -33, -32, -10, -9,
    1, 7, 4, 28, -24, -30, -18, -10,
    -43, 34, 30, -35, 1, -2, -24, 12,
    30, 14, 32, -26, -67, -19, -28, -27,
    16, 20, -57, -10, -8, 12, -44, -33,
    15, 4, -22, -3, 1, -61, 0, 24,
    26, -30, 42, 2, 1, -11, -7, 1,
    -19, -4, 3, 47, -12, 8, -22, -6,
    1, -9, -17, -12, 32, 15, -18, -17,
    -1, -25, 2, -14, 5, 5, -41, -13,
    12, 31, 30, 10, -18, 27, 16, 9,
    12, 25, -15, 17, -55, -33, -27, -29,
    -24, -42, -27, -18, 19, 36, 0, 11,
    22, -7, -5, -19, 21, -13, -17, 30,
    4, -42, 24, -106, 14, 6, -34, -26,
    31, 17, -7, -10, -44, 15, -8, -38,
    -8, 28, -34, -17, -56, 17, 3, 27,
    8, -24, -24, 18, 14, -19, -47, -17,
    -7, 74, -4, 5, 0, -23, 3, -5,
    43, 3, -7, -47, -43, 52, 31, 9,
    56, -26, 32, 15, -30, 21, -15, -35,
    8, 2, 0, 17, 16, 49, 16, -8,
    -7, 70, 32, 4, -15, -1, -13, 25,
    22, -78, -13, -13, -25, -14, -71, 24,
    14, -53, -6, 0, 10, -38, 50, 61,
    -2, 6, 3, -11, -19, -18, 6, 32,
    -39, 8, -8, 6, 5, 18, 19, 6,
    -21, 9, -2, 13, -42, 43, 18, -8,
    -5, -18, 48, -8, 63, 2, 40, -1,
    -14, 27, 15, -19, -20, 5, -16, 20,
    -26, 25, -10, 12, -7, 9, -16, -2,
    44, -2, 17, 25, -23, 3, -6, 28,
    -21, 8, 18, -43, -24, -24, -7, 27,
    -1, 19, -12, -8, -2, 19, -56, 19,
    28, 46, 17, 10, 0, -3, -10, -12,
    6, 10, 12, 10, 3, -10, -23, 43,
    19, 26, 25, -14, 18, -22, 0, -11,
    24, 13, -12, -3, -41, -29, -2, -13,
    -12, 13, 23, 81, 10, -7, -17, -8,
    -1, 35, 26, -38, -3, 1, -67, -43,
    4, 42, 13, -16, 8, 23, 18, 5,
    -12, 8, -20, -5, 0, -44, -46, -32,
    50, -38, 44, -14, -11, -7, -17, 8,
    -40, -2, -22, 2, 30, -9, 25, -4,
    -3, 12, 4, 18, 4, 7, -11, 25,
    16, 8, 3, 0, -35, -18, 24, 40,
    11, 24, 21, 50, -13, 49, -11, -4,
    25, -5, -7, -13, 21, -15, 43, -68,
    -21, 14, 17, 3, -14, -37, -24, -17,
    0, -9, 4, 1, 45, -18, -62, 15,
    -11, 14, 42, -16, 33, -2, 12, 10,
    -12, 40, -34, 51, -31, -9, -67, 17,
    -21, 14, -6, -7, -2, 10, 8, -50,
    7, -10, 9, 31, -5, 19, 45, 7,
    47, -16, -2, -33, -23, 25, -12, 11,
    -51, 85, 25, 8, 23, -28, 8, 40,
    -58, -1, 43, 0, 8, 63, -10, 55,
    -5, -23, 10, 14, -17, 15, 26, -8,
    -17, 17, 22, -34, 4, 16, -14, 18,
    29, -46, 3, -30, 58, 59, -27, -7,
    -3, -34, 14, 24, 68, 13, 20, 6,
    -44, 18, -9, -5, 64, -2, 3, 4,
    -59, 46, -43, 26, -11, -3, 12, 10,
    20, -9, -24, -18, 12, 19, 14, -32,
    10, -54, -16, 29, -6, -34, -5, 0,
    8, 20, 9, -34, 15, 20, 7, -13,
    -31, 21, -44, 4, 5, 4, 11, -1,
    31, 29, -18, 1, 58, -41, -71, -24,
    55, 73, -47, -5, 6, 101, -38, -13,
    -8, -12, 11, 8, -10, 7, 22, -1,
    5, 22, 28, -39, -6, -6, 1, 18,
    -10, 18, -10, 37, 13, -11, -11, -24,
    -1, -73, 21, -4, -17, 30, -24, -5,
    -5, 8, 10, -15, 1, 5, 1, -60,
    11, 3, 27, 102, -5, 4, 7, 15,
    3, -56, -19, -57, -41, 28, 40, 43,
    -8, -15, -1, 6, 30, -13, -14, -5,
    -23, 4, 8, -14, -9, 28, -35, -13,
    18, 8, 29, -21, 11, 0, -5, 14,
    40, 1, -24, 41, -26, 2, 27, 2,
    -31, -28, -20, -16, -22, 16, -27, -20,
    -2, 6, -2, 6, -36, 44, 32, -14,
    -36, 42, -1, -29, -17, 7, -2, 2,
    -18, -18, 45, -43, 12, -39, 5, 23,
    -36, -21, -13, -12, 31, 25, 13, -44,
    -15, -1, 9, 35, 39, 19, -1, -8,
    -21, 13, -33, -36, 12, -7, 17, -19,
    27, -23, -6, 21, -9, -14, 13, -5,
    -17, 99, -7, 4, 35, 14, -8, 13,
    -12, -3, -7, -17, -24, -3, -37, 28,
    3, 2, 45, 9, 11, -18, -18, 0,
    -6, 10, -1, 2, 23, -6, -71, -27,
    26, 6, -21, 19, -32, 7, 36, 32,
    -14, 2, 20, -8, 36, 13, 16, 5,
    -10, -24, -11, -44, 4, 7, 10, -6,
    -5, 23, -32, 15, -36, 34, 28, -6,
    -3, 8, 66, -3, -6, 11, -30, -56,
    6, 8, -16, -3, 8, 8, 2, -7,
    -9, -8, -23, -15, 46, -98, 0, 0,
    6, 16, 3, 23, 1, -21, 16, 2,
    14, 13, -9, -7, 27, -19, -1, -3,
    -5, 3, 2, 9, -11, 63, -18, -10,
    30, -22, 27, -23, 6, 2, -10, -16,
    -41, -5, -5, 34, -37, 20, 12, -1,
    -1, -3, -6, -26, 7, 29, 4, -41,
    20, -5, -8, -17, 17, 14, 17, -28,
    -35, 11, -31, 3, -13, -1, 5, -11,
    26, 21, -39, 27, -34, -1, -26, 14,
    -6, 16, -1, 4, -42, -9, 4, 35,
    9, -5, 1, 10, 8, -22, 10, 21,
    18, 71, 21, 10, 18, -10, -3, -19,
    21, -4, 29, -38, 17, -78, -25, -9,
    -21, 8, 7, -8, 61, -9, 48, 2,
    -8, 23, 10, 25, -19, 30, -15, 35,
    60, 30, -37, 47, -61, 2, 44, 29,
    -66, 29, -39, 36, 49, 10, -33, 55,
    -21, 27, -24, -1, 50, -58, -4, 82,
    36, 27, -36, 36, 11, 1, 77, 8,
    -9, 28, 33, 13, -27, 47, -3, 49,
    48, -35, -21, 23, 23, 83, 11, 50,
    -33, 9, -14, -14, 50, 28, -45, -38,
    -25, 0, 54, 4, 6, -41, 12, 0,
    43, 15, 14, -64, 7, 32, 25, -25,
    70, 34, 20, 20, -20, -73, -22, 14,
    8, -45, 18, 20, -15, 127, 41, 26,
    8, 8, 2, 38, -20, -29, 24, -11,
    18, -44, 18, 12, -18, -18, -19, 4,
    -19, 94, 37, -14, 104, -40, -81, -45,
    -21, 22, -25, 30, 6, 90, 37, 54,
    -36, 24, 55, 74, -45, -77, 13, -31,
    48, 13, 16, 39, 18, -24, 54, -5,
    -27, -30, -29, 23, 27, 22, 2, -1,
    -1, 46, 119, 10, 57, -23, 34, 38,
    25, 8, -13, 77, -1, -121, 41, 48,
    -6, -101, 10, -8, 25, 62, -12, 28,
    1, -18, 43, 86, 36, -21, -38, -21,
    -26, -6, -33, -23, -3, -29, -27, -40,
    -31, -29, -31, 18, -3, 45, -101, -12,
    23, -57, 23, -12, -11, 15, -22, 0,
    -11, 26, -49, 54, -20, -32, 37, 9,
    25, -52, -16, -36, -71, -27, -54, 0,
    21, 23, 5, -79, 23, 19, -45, 45,
    47, 48, -70, 62, 27, 28, -47, -26,
    -15, -3, 17, 21, 15, -9, -19, 48,
    -42, -56, 47, 1, -13, 15, -25, 36,
    4, -19, -72, 49, 5, -93, -74, -55,
    -39, 5, -4, -25, 24, 20, -22, -10,
    -36, 34, 4, 57, 83, 46, 42, -73,
    -39, 63, -31, 37, 59, 17, -36, 2,
    21, -20, 8, 44, -2, 73, 46, -21,
    -20, 0, -68, -2, 22, 9, -4, -46,
    40, 37, 26, -36, 23, -59, -10, -56,
    21, -15, 0, -7, 50, -22, -16, 44,
    14, 7, 20, -12, -4, 18, -9, 11,
    100, 25, 56, -70, 15, 8, -17, 26,
    45, 17, -53, 52, 6, 59, -58, -17,
    -8, 9, -14, -11, -31, -49, -63, -36,
    -37, 61, 29, -66, -6, -25, -9, 28,
    68, 3, 9, -33, -43, -3, 10, 30,
    -67, -10, -47, 1, -1, 61, 13, 13,
    -2, 32, 5, 28, -8, 23, 100, -45,
    -7, 57, -46, -27, -20, 48, -44, 16,
    -31, -3, 3, -15, 33, 25, -26, 39,
    25, 31, 5, 54, 45, 50, -24, 38,
    20, -28, -16, 17, -23, -10, -10, 33,
    5, 24, -18, 37, -38, -50, -7, 19,
    -42, 53, 1, -116, 18, -13, -16, 43,
    -33, 19, -45, 70, -6, 23, -51, -61,
    30, -31, -14, 10, -42, 3, -101, 47,
    -33, 18, -75, -3, 37, -42, -79, -20,
    -44, 8, 24, 43, 10, 13, -3, 25,
    68, -23, -60, 11, 20, 20, 54, 50,
    -55, 26, -5, 37, -13, -15, 2, -26,
    30, 13, -2, -18, -28, 5, 46, 45,
    63, 49, 34, -1, 24, 27, -3, 17,
    43, -31, -30, 20, -43, -12, 25, -42,
    16, -17, 34, -9, -36, -20, 0, -7,
    -9, 2, 33, 12, 69, -12, -70, 27,
    -37, -47, 27, 58, 91, 7, 18, -3,
    10, -37, -7, 34, 43, 65, -46, 33,
    24, 19, 49, -39, 32, -15, 77, 0,
    -16, -23, -3, 94, 0, 3, 58, 4,
    -27, -23, 42, -19, 41, -16, 22, 22,
    71, -20, 36, -3, 46, 64, -51, 16,
    -4, 52, 56, -28, -51, -9, -23, 18,
    -12, -91, 15, 10, 25, -24, 21, -39,
    -5, -29, -3, -17, 23, 1, -15, 4,
    30, 36, -63, -17, 16, 13, 10, -8,
    -16, 59, 5, 21, 18, 7, -41, 4,
    -79, 8, -45, 6, 88, -24, -6, -5,
    17, 18, -16, -10, -16, 7, 14, 7,
    24, 18, -45, 14, 13, 44, 5, 38,
    19, 90, -51, -14, 0, 41, 29, 16,
    27, -6, 10, -84, 21, 28, 40, -32,
    73, -8, 29, -4, -5, -36, 2, 8,
    -12, 54, 34, -15, 82, 0, -34, -29,
    -43, -16, -20, 1, 6, -42, 13, 31,
    -11, -27, 17, 14, 3, 51, 51, 5,
    -22, -40, -35, -10, 17, -20, -14, 49,
    17, -44, 6, -8, 19, 30, -52, 14,
    -9, 7, -37, -5, -42, -27, -71, -7,
    -13, 15, 39, -27, -9, -33, -19, -110,
    -75, 2, 45, -40, -19, -20, 16, 20,
    27, -104, 27, 22, 9, -18, -69, -38,
    -24, 21, -28, -28, 11, 0, 10, 62,
    -48, -5, -9, -30, -33, 13, -41, -12,
    21, 26, -17, 18, 26, 27, 25, 13,
    -24, 0, -26, 29, 29, 27, 54, 52,
    45, -61, 40, -32, 33, 37, 31, -1,
    -13, 4, -31, 51, -33, 37, 35, -1,
    13, -22, -11, 61, -11, 13, -34, -6,
    53, 1, 14, 27, 25, -9, -27, 86,
    -23, 49, -40, 20, 57, 38, -19, 15,
    -20, -5, -11, 50, 55, 51, -9, -23,
    74, -65, 7, -4, -13, -50, 20, 19,
    -62, -10, 47, 48, 4, 67, -8, 4,
    3, -51, -30, -11, 17, 11, 24, 26,
    -19, 19, 8, -5, -64, -6, -21, 10,
    68, -34, -26, 1, 3, -37, -20, 7,
    -28, -16, 36, -2, 1, -28, -55, -36,
    -6, -17, -3, 16, -5, -38, -51, 3,
    -24, -14, -4, -11, 50, 23, -35, 20,
    -13, 29, 19, 70, -71, -15, 24, 27,
    -3, 17, 37, 1, -55, -34, 22, -22,
    25, -2, 32, -26, 72, 20, -1, 34,
    46, 25, -7, 5, 9, 7, 1, 3,
    12, -20, 54, -26, -17, -112, -5, -36,
    11, 39, -14, -45, 8, -30, -14, -33,
    10, 31, 19, 11, -27, 29, 29, -1,
    -36, -4, 9, 4, -33, 67, -29, -13,
    17, -58, 5, 4, 7, 60, 35, 5,
    62, 28, 44, -49, -16, 41, -43, 10,
    24, 14, 101, 16, 74, 12, 2, 21,
    56, -14, -24, 15, 38, 38, 27, -7,
    -10, -8, 8, -74, 1, -33, 29, -12,
    -17, 6, 8, -30, -12, 14, -12, 19,
    -8, 43, 8, 32, -3, 18, 14, 15,
    45, -20, -23, -12, 4, -22, -7, 20,
    62, -17, 0, 30, -4, 8, 3, -1,
    -2, 9, 18, 97, -51, -23, 69, -25,
    -3, -1, -44, -53, -49, 30, -92, -2,
    21, 1, 24, -24, 25, 17, -47, 39,
    94, 19, -38, 16, -11, 15, 2, 3,
    -2, -20, -2, 13, -8, 15, 1, 18,
    -43, 18, 20, 6, 19, -7, -13, -28,
    18, -3, 14, -22, -20, 9, 43, -5,
    61, 16, 12, -83, -4, 12, 1, -11,
    -1, -10, -1, 44, 1, 8, 2, 2,
    23, -16, 21, -15, 9, -7, -2, 6,
    -3, 8, 0, 11, 0, -9, 15, -23,
    -27, 13, 10, -55, -16, -3, 16, -6,
    19, 24, 9, 25, 8, 6, 11, -6,
    2, -28, -10, -16, -5, 15, -12, -8,
    0, 3, -16, -20, 21, 28, 18, 4,
    54, -34, 71, -17, -7, 20, -7, 27,
    13, -7, -21, -4, 0, -7, -10, -1,
    -12, 9, 23, 14, -15, -10, 8, 11,
    24, -13, -15, 24, -42, 28, -3, 5,
    -53, 33, 11, 13, -10, 1, 6, -29,
    5, -11, -23, 6, -2, -3, 11, 7,
    -3, 23, -19, -18, 25, 22, -2, 25,
    11, 10, -16, 9, -6, 12, -36, -13,
    13, -1, 36, -3, -6, 17, -7, 2,
    -14, 9, -1, -2, 8, 5, 19, 13,
    -39, -11, -5, -8, -46, 20, -5, 17,
    -3, 10, -7, 33, 42, 17, -1, -6,
    28, 62, 16, 20, -3, -6, -14, -24,
    -20, -21, -3, 25, -4, -11, 3, 8,
    -4, 37, 0, -31, -3, -16, 6, 8,
    -21, 9, 29, 10, -19, 38, -14, 5,
    30, -51, -46, 109, -16, -4, -42, -1,
    -6, 0, -28, 14, -5, 25, 11, -10,
    19, 2, -32, 58, -10, 4, -9, -16,
    -4, 2, -26, -26, -30, 0, -1, 31,
    0, 75, 3, 32, 8, -18, -7, -2,
    -29, -57, 27, -12, 9, 6, 9, 1,
    2, -18, 10, -17, -18, 10, 6, -51,
    -2, -5, 21, 2, 11, 1, -20, 22,
    -4, 4, 27, -1, 11, -3, 21, -15,
    -24, 3, 11, 0, 8, 0, 0, -1,
    -21, 27, 35, 40, 5, -29, -48, 29,
    -6, 11, 11, -32, 11, 38, -4, 44,
    17, 45, -3, 19, -5, -24, -5, -33,
    20, -1, -47, -8, 13, 6, 6, -10,
    -6, -41, 7, -9, 18, -6, 1, -6,
    -31, 8, -17, -5, -20, -11, 41, 4,
    22, 60, -53, 6, -11, -7, 1, -1,
    13, -18, 38, -1, 2, -5, 9, 6,
    -23, 6, 5, -23, 12, -14, -22, -39,
    20, -15, -12, 25, -25, -16, -21, -3,
    1, -7, 51, -32, -24, 1, -7, 2,
    -21, 16, 1, -33, 3, -13, 17, 3,
    -25, 11, -12, -11, -17, 7, 40, -11,
    3, 27, -17, -17, 20, -19, -19, -13,
    -18, 10, 27, -34, 29, -8, -10, -4,
    11, 3, -29, 4, -5, 3, 3, -21,
    29, 12, 12, -26, 21, -49, -7, -5,
    -2, 1, -28, -10, 12, 5, 20, -11,
    -15, -11, 82, 12, -17, -5, -11, -14,
    15, 0, -4, 0, 7, -4, 6, 0,
    -34, 36, -27, 14, 21, -43, -1, 23,
    -4, 27, -11, -10, 34, 47, -22, -2,
    2, 13, 9, 6, -4, 5, -44, 13,
    9, -15, -27, 12, -14, 20, -3, -3,
    -38, 9, -53, 6, 36, 32, 15, 11,
    -3, 0, -8, -5, -9, 7, 5, -7,
    -42, -26, -38, -7, 7, -37, -9, 0,
    -26, 16, -16, -43, 10, 7, 25, 4,
    14, 27, -29, 8, -17, 14, 15, -10,
    2, 16, 4, -11, -17, -11, 20, 14,
    -6, -5, -1, -55, 30, -42, 5, -7,
    30, 25, 22, 47, -15, 10, -18, 0,
    -28, 62, 33, 16, 28, -12, 13, -41,
    -28, -15, 22, -11, -25, 28, -18, 27,
    71, 12, -38, -9, 11, 10, 3, 13,
    -7, 22, -6, -23, -15, -10, -4, -11,
    15, 9, 22, -22, 36, -5, -22, 14,
    -5, 23, -9, 0, -6, 5, 5, 7,
    -4, 16, -51, -26, -8, 46, 26, 3,
    7, 11, -4, -4, 3, -5, 7, -18,
    -49, 2, -22, 16, -6, -19, 10, -36,
    20, 18, 0, -5, -33, -28, 1, -1,
    15, -18, -33, -12, -12, 16, 20, -20,
    5, 19, -6, 12, 5, -12, -4, 3,
    55, 15, -14, -16, -18, -21, -10, 27,
    -20, -6, 13, -8, 37, -24, -4, -3,
    41, 20, 65, 40, -3, -6, -7, -2,
    -9, 15, -36, 9, 6, -9, 2, 3,
    24, -17, -19, -6, -33, 52, -10, 6,
    -2, 12, -20, 7, -16, -24, -37, -20,
    -67, 3, -5, 34, -9, 29, -8, -35,
    33, -5, 18, -44, 8, -10, 17, 3,
    -15, 19, -27, -25, 45, 9, -23, 41,
    -29, 15, -10, 17, -25, -9, -26, 15,
    -39, -26, -44, 43, 14, 1, 31, 1,
    32, -1, 25, 9, 12, -2, -18, 9,
    -14, -12, -2, -4, 20, 8, -29, -11,
    -13, -8, -2, -17, -3, 17, 16, -38,
    -18, -20, 3, -36, -14, -2, 7, 14,
    -3, -16, -20, -3, -2, -11, 13, -4,
    10, 45, 31, -46, 25, -28, -12, 56,
    -14, -22, -5, -21, -10, 14, -8, 25,
    24, -3, -92, 11, -18, 13, 4, -19,
    -12, 16, 19, 6, 4, 14, 2, -2,
    -10, 14, 24, 11, 33, 12, 17, -14,
    -1, -18, -9, -8, 0, -7, 24, -16,
    52, -1, 18, 6, -1, -5, -29, 11,
    -26, -17, 12, -8, 9, 2, 8, 7,
    -34, -7, 25, 13, -7, 30, 16, 13,
    2, -22, -35, -7, -6, 16, 27, 8,
    11, 5, -4, -25, -1, -38, 2, -36,
    -5, -8, 3, 29, 15, 12, 6, -10,
    17, 10, 41, 37, 17, -18, -5, 40,
    6, 11, 20, -6, 12, 19, -11, 4,
    10, -27, 8, 25, -7, 20, -6, -11,
    31, -15, 4, -13, 1, -5, 0, -6,
    48, -24, -13, -23, -25, 37, -20, 17,
    9, -8, -10, 11, 3, -3, 18, 16,
    -29, -27, -6, -43, 24, 0, -14, -1,
    -27, 11, -1, 1, -8, 7, -5, 3,
    -2, 42, -12, -5, 20, -24, 8, -37,
    13, 0, 7, -10, -3, 1, -8, 3,
    39, -3, -20, -38, -14, -11, -41, 3,
    -14, 10, -17, -24, 15, -1, -4, -9,
    -22, -6, 24, 1, -5, -19, 11, -55,
    5, -2, 11, 18, -24, -7, 13, 6,
    -23, -35, -39, 56, -28, 1, 26, 16,
    -17, -23, 21, 9, 3, 3, -15, -1,
    20, -15, -56, 12, 27, 25, 7, -9,
    11, 1, -23, -3, -26, -23, 9, -3,
    44, -18, -26, -18, 8, -3, -31, 15,
    -21, 7, -13, 9, -8, 10, 7, 16,
    10, 38, -11, 3, 3, 76, 26, -42,
    -8, 5, -40, -6, 15, 15, 13, 35,
    0, -28, 40, -85, -7, 4, -19, 27,
    -9, -24, -41, 4, 0, 15, -1, -5,
    0, 4, -3, 7, 13, 7, 22, 9,
    -3, 12, -14, 15, 5, -11, -8, 15,
    -5, -18, -19, -2, 10, -31, -15, 21,
    12, 10, -24, -32, -8, 11, 6, -9,
    -1, 10, 12, 23, -1, -38, 24, -21,
    12, -11, -4, 41, -11, -49, 10, 32,
    -10, -93, 46, -4, -19, 29, -7, -10,
    12, -54, 5, -24, 0, -12, 17, 4,
    -11, -34, 10, 28, -9, 3, -18, -22,
    -18, 7, 12, 23, 10, -19, 4, 14,
    1, 35, -19, 23, 5, 5, 8, -24,
    -17, -21, -32, -46, -8, -1, 8, -14,
    -47, -16, 30, -7, 17, -13, -67, 7,
    -18, -6, -12, -30, 8, 4, 48, -6,
    47, -28, 52, 14, -34, -5, 46, 23,
    -4, 20, -51, 5, 2, 2, 35, 9,
    17, 39, 63, 15, 30, 17, 4, -51,
    -34, 3, 5, 31, 20, 49, 30, -8,
    29, -18, 0, 70, -17, -41, 21, -5,
    -44, 13, -6, -61, 23, 7, 10, 7,
    14, -4, -29, -46, 0, 15, 28, 3,
    6, -15, 31, 18, 1, -51, 6, -7,
    -13, -21, -40, 26, -15, -10, 28, 11,
    15, -32, -30, -20, -8, 5, -8, 25,
    8, 19, 8, 40, -25, 9, 0, -42,
    1, 0, 7, -30, 22, 55, -7, -7,
    11, 15, 26, 66, -23, -34, 18, 44,
    11, 86, -7, 35, -18, 25, 18, -1,
    -50, -9, 24, 26, -3, 52, -5, -16,
    -8, -2, 6, -2, 9, -37, -26, 3,
    -7, -25, 20, 33, 28, 24, 19, 18,
    -18, -33, -15, 9, 19, 12, 15, -19,
    -7, -16, -24, -17, -5, -22, 25, -33,
    18, -10, 9, 30, -3, -7, 3, -35,
    32, 30, -28, 10, -29, 10, 26, 2,
    -17, 16, 8, 3, 9, 24, -3, 18,
    -9, -36, 11, 2, -48, 28, -18, -1,
    -11, 14, -11, -9, 3, -13, 34, 16,
    55, 11, -66, 0, -5, -38, -13, -22,
    -8, 9, -24, 37, 21, 17, 20, 24,
    7, -12, 18, 45, 5, -25, -14, 12,
    13, -3, 8, -7, -28, -22, 19, 10,
    -18, 10, -6, 11, -2, -24, 3, -27,
    -10, -32, -1, 35, 11, -14, -1, -12,
    14, -49, -6, -25, 14, -83, -26, 22,
    -1, -6, -16, 7, 48, 26, 24, 0,
    45, 6, 30, 34, 31, -11, 7, -31,
    -1, -28, 8, -12, 5, -10, 34, -13,
    -15, -27, -19, -35, 22, 42, 2, 24,
    3, 0, 11, -41, -20, 14, 23, 21,
    4, -1, 87, 42, -4, 17, 30, -22,
    34, 19, 7, -9, 10, 3, -8, -17,
    12, -4, 28, 21, 10, 0, -11, 19,
    -25, 11, 8, -11, -5, -32, 18, -5,
    18, 48, -50, -17, 37, 29, 22, 37,
    12, 11, -34, 20, 2, 14, 8, -22,
    -24, 17, -15, 11, -4, 7, 3, 14,
    20, 6, 5, -1, 14, 11, 29, -30,
    -93, 12, 15, -65, -4, -18, 20, -21,
    -16, -6, 14, -25, 5, -1, 2, -15,
    3, -40, -9, 19, -2, 21, 7, -16,
    -9, -1, -18, -18, 11, -16, 0, -17,
    -1, -8, 33, -5, -10, -11, 21, -30,
    -55, 16, -8, 5, -29, -6, -8, 18,
    -37, -29, 20, 21, -95, 20, 11, 1,
    18, 6, 18, -27, 13, 6, 22, -23,
    6, -5, -4, 14, -3, 32, 16, -4,
    32, 7, 3, 4, -2, -7, 7, -9,
    -39, -34, 13, -25, 10, -73, 17, -10,
    13, -16, 4, -4, -15, -14, 2, -7,
    12, 17, -9, -39, 14, 30, -8, -7,
    11, -8, 21, 1, 17, -5, -3, -21,
    8, 11, 1, -32, 12, -27, -13, 23,
    -6, 39, 0, -4, -12, -21, -13, -15,
    -4, 30, 21, -28, 5, -10, -9, -12,
    63, 23, -34, -5, -15, 33, -25, 16,
    8, 8, 46, 22, 31, 24, 33, -33,
    -39, 31, 3, -4, -6, 33, -47, 7,
    36, -19, 100, 17, -21, -19, 28, -12,
    -18, -5, 31, -1, 6, 2, 36, -6,
    22, 29, 43, 25, -17, 2, -1, 6,
    1, 13, 2, 9, -10, 13, -43, -10,
    -7, 18, 39, 9, 7, 46, -14, 11,
    -41, -29, -9, 37, -3, -17, 18, -18,
    -30, 15, -7, 27, 6, 18, -16, 12,
    -5, 4, 17, -11, 21, 12, -4, -16,
    -70, -42, 35, 32, 13, -5, -11, 5,
    18, 3, -32, -14, -6, 1, -6, 19,
    1, -1, -2, 33, 13, 15, -17, 35,
    12, -21, 21, 11, -18, -2, 10, 7,
    0, -34, 2, -19, 15, -25, -12, -4,
    -6, 10, -3, 14, 8, -7, 10, -25,
    6, -3, -7, -19, 14, 27, 0, -56,
    -4, -8, 8, -8, -27, -17, -1, -45,
    32, 12, -102, -11, -3, 20, 11, -4,
    3, -5, -16, 9, -1, -12, 1, -10,
    -14, -5, -33, -19, 10, -5, -4, 16,
    -25, 6, 4, 3, 7, 11, 29, 21,
    33, 47, -41, 19, 26, 1, -10, -4,
    20, -22, -37, 0, -18, 6, 18, 5,
    7, -13, 0, -9, 19, -10, -1, 25,
    2, -4, -29, -14, -21, 14, -33, -9,
    60, 10, 35, -28, 9, -24, 43, -22,
    -37, 23, 50, -15, 3, 14, 14, -6,
    -19, 61, 57, 10, -15, 28, 32, -26,
    14, 27, 6, -7, -23, 32, -6, 26,
    5, -34, 0, -18, -16, 22, 12, 13,
    16, -22, 9, 11, 15, -3, 14, -4,
    3, -34, 6, -10, -43, 14, -25, 11,
    23, -13, 13, -14, -18, -6, 21, -10,
    4, -25, -36, -35, -5, -4, -2, -1,
    26, 28, 8, 21, 1, 6, -1, -5,
    14, -16, 3, -26, -14, 20, -10, -18,
    -19, -27, 15, 16, 4, -16, 22, 12,
    46, 17, -52, -11, -11, -39, 25, -18,
    10, 6, 13, -5, 0, 1, -2, -11,
    17, -13, -27, -28, 6, 6, -23, -15,
    -4, 11, 8, 19, 6, -7, -2, 16,
    -20, -49, -13, 55, -10, -35, -3, -23,
    75, 9, 4, 42, 19, -1, 10, 22,
    9, -20, -58, 28, 6, 37, -60, 56,
    -24, -34, -2, 4, 9, -8, 29, -13,
    85, -21, 8, -29, -33, -4, -27, 10,
    13, 33, 26, -49, -2, 8, 23, 29,
    12, -79, 11, 38, -12, -72, -77, -49,
    -10, 53, -20, -21, 8, 14, 5, -17,
    29, 25, 33, -1, 23, 40, 20, 41,
    4, -35, 24, -4, -12, 9, 7, -14,
    34, -2, 12, -18, 20, 27, 23, -10,
    22, -20, -64, 36, -2, 8, 10, 44,
    -60, 11, -70, 2, 17, 21, 9, -74,
    2, -22, 34, 95, -19, 13, 11, -35,
    -42, 31, -17, 28, -23, -21, -41, -1,
    34, -16, -13, -16, 15, -2, -49, -4,
    9, -81, 71, -40, 19, -3, 8, 2,
    -37, 78, 59, 45, -5, -42, 47, -1,
    38, 15, 3, -7, 7, 36, 47, 8,
    18, 3, -37, -3, 55, 16, 45, -24,
    7, 30, 2, -41, 6, 14, 22, 39,
    2, 73, -39, 70, -15, -14, 50, -35,
    5, -24, 23, 31, -26, -19, 58, 8,
    -16, -2, 7, 14, -8, 19, -1, -5,
    -40, 10, -23, 37, 49, 26, -36, 27,
    -16, 22, 62, 20, 2, -11, 43, -4,
    28, 46, -87, 2, -3, -4, -67, 32,
    45, 2, 15, -27, -2, -2, 0, 2,
    0, 38, -50, 28, -50, 48, -8, 45,
    31, 11, -27, -10, 43, -4, 28, 40,
    2, -61, -41, -3, 19, -55, -99, -23,
    -20, 14, 71, 58, 70, -3, 10, -13,
    7, 9, 60, 3, 26, 7, -23, -24,
    0, -1, 18, -36, -33, -20, -9, 41,
    60, -39, 0, 12, 52, -37, 40, 61,
    -1, -11, 0, -45, -1, -9, -18, -17,
    47, -50, 50, -25, -13, 60, -3, -31,
    45, 22, 18, -17, -58, 8, 20, -15,
    53, 1, -16, -40, 30, -118, 3, 25,
    10, 30, -26, -16, -13, 65, 61, 29,
    -19, 17, -60, 47, -24, 3, 32, 53,
    40, -3, 13, -57, 41, 32, 12, -24,
    33, -4, 27, 38, -20, 42, -31, 33,
    -2, -104, 10, -7, 28, 28, -35, -16,
    -9, 23, -7, 30, -21, 27, -57, 26,
    -51, 65, 17, -3, -17, 23, 8, 52,
    -36, -38, 4, 17, 77, -34, 20, 71,
    -1, -3, -44, -5, -37, 12, -39, 27,
    25, 56, 20, 36, 11, 19, -10, 43,
    17, -5, 0, 3, 16, 25, 29, 46,
    -17, -21, 52, -62, -16, -15, 21, -31,
    20, -1, 9, -9, -16, -26, -25, -61,
    19, -4, 32, 57, 31, -38, -39, 45,
    54, -49, 34, -14, 3, -23, -7, -48,
    -31, -21, 31, 17, -35, -46, 1, 29,
    40, -6, 11, 23, -75, 28, -16, -19,
    9, 39, 15, 31, -1, 113, -14, -1,
    4, -1, -14, 69, -5, -37, 95, -9,
    8, -20, -36, 73, 29, 14, 33, 1,
    22, 42, 38, -16, -21, -2, -79, -50,
    -19, -17, 4, -1, 20, -43, -19, 13,
    -25, -8, 42, -2, 4, 2, -34, -31,
    -23, -10, 29, -22, 30, 52, 25, -43,
    -39, -18, 24, -15, 0, 8, 10, 38,
    -68, 57, 42, -46, 2, 6, -20, 57,
    10, 14, 25, -2, -23, 19, 17, -19,
    -13, 18, 19, 3, -39, 36, 5, 12,
    -10, -5, -8, 27, 33, 5, -18, -50,
    -77, 21, -14, -106, 27, 18, 56, 44,
    5, 7, -11, 56, 16, -22, -27, -48,
    25, 5, 52, 28, -17, 23, -69, 18,
    6, -8, 5, -21, 4, 63, -43, -6,
    58, 26, 44, 25, -6, 11, -21, -13,
    42, -13, 34, -28, -73, -13, 6, 33,
    71, -73, 15, 24, 50, -53, -5, -46,
    3, 37, -12, -38, -48, 24, 8, -12,
    -11, 9, 37, -9, 22, -3, -6, -10,
    -63, -3, 43, -30, -7, -14, 15, -28,
    -47, -13, 3, -31, -102, 73, 23, 22,
    -18, -98, -25, -16, 48, -3, -33, -2,
    -73, -16, 19, 17, 10, -19, -26, -9,
    -16, 43, 26, 18, 0, -4, -3, -44,
    7, 0, -19, -14, 36, 93, -18, 1,
    8, -42, -5, 65, 61, 3, 15, 19,
    -5, 26, 80, -9, 66, -43, 12, -16,
    26, -40, 6, 30, -16, 80, -55, 11,
    -58, -25, -8, -25, -39, 3, -79, 21,
    6, 12, -8, -2, -38, -61, 8, 5,
    47, -50, -17, 18, 3, -9, -91, -38,
    -23, 59, 16, -6, 35, 7, 69, -9,
    -7, 12, -27, 27, 67, -59, 18, -6,
    -11, -34, -36, 6, -3, 30, 74, 8,
    -34, 12, 53, 45, -46, 15, -16, 20,
    32, -12, 0, -11, -2, -28, 8, -25,
    -18, 0, 11, -14, 17, -3, 64, -30,
    -5, 34, 52, -27, -36, 19, 10, -9,
    -39, -34, 24, -5, -15, -4, -3, -10,
    36, -1, -6, -8, -17, -1, 3, 13,
    2, 23, 24, 9, 1, -29, 32, 17,
    11, -1, 14, 28, -9, -3, 0, -9,
    -7, -56, -42, -2, -67, 17, 5, -74,
    7, -8, -15, 1, 8, 11, 32, -32,
    19, -62, 1, 16, 91, -11, 6, 69,
    -57, 46, -7, -25, -1, 26, -3, -4,
    57, 6, -58, 5, 16, -5, 10, -32,
    -15, -11, 18, -4, -6, -35, -17, -26,
    95, 34, -22, -17, -16, 44, 35, 29,
    18, 12, -16, -7, -26, 15, -32, 19,
    28, 17, -12, 2, -2, -11, -19, -9,
    -20, -2, 25, -9, -18, 35, 22, 9,
    12, -27, -32, -10, -17, -12, 13, 17,
    11, -4, -22, -15, 2, 22, 23, 1,
    20, -1, 82, 26, -64, 16, 2, 14,
    25, 19, -68, -55, 24, 26, -5, -36,
    -2, 21, -21, -1, -7, -18, -47, 25,
    -22, 40, 19, 3, -21, -52, -25, -85,
    -38, -49, -42, 26, -13, -22, -54, 4,
    -5, 21, 23, -12, 14, -3, 26, -5,
    8, -14, -6, -1, 14, 26, -11, -59,
    0, -11, -11, -52, -12, -13, 31, -8,
    2, -6, -28, 22, 5, -9, -36, 1,
    19, -5, 22, -3, -14, 13, -17, -26,
    4, -5, -26, -30, -15, -58, -31, -9,
    -2, 18, -11, -13, -11, 13, 31, 2,
    -22, -24, 55, -24, 36, -37, 23, -12,
    15, -27, 2, 24, -6, -5, 13, -4,
    -26, -9, 40, 15, 46, 10, 38, 24,
    -15, 27, 6, -10, 8, -24, 2, 14,
    -57, -9, 24, -42, 24, 46, 11, -15,
    -25, 2, -39, 18, 55, -18, 52, 77,
    20, 27, 16, 89, 58, -73, 45, 38,
    -9, -24, -28, 32, 13, 55, -55, 24,
    12, -10, 1, -3, 16, 25, -22, -14,
    -14, -6, 19, 2, -8, 10, -18, 24,
    -19, 35, -23, -4, -13, -12, -77, 15,
    -47, 1, -4, -23, -10, -3, 14, -9,
    0, 5, 16, 7, -2, -1, 4, -9,
    -3, -16, -1, 13, -20, -20, -34, 6,
    -11, 4, -2, -20, -61, 35, -17, -29,
    -2, -5, -8, 12, -11, 7, -20, 16,
    4, 32, -13, 10, -12, 10, 14, 4,
    -24, -18, -7, 10, 7, 6, 4, -10,
    -7, 15, -17, -22, 14, 20, -12, -24,
    0, 25, 57, 18, 11, 7, 12, 10,
    17, -34, -32, -5, 17, 36, -29, 6,
    -1, -4, 8, -7, -4, 2, 24, 15,
    3, -8, 13, 7, -1, 19, -4, -16,
    -34, -26, 4, -7, -1, 2, -10, 17,
    -11, 2, 12, 3, -9, -20, -9, -35,
    -3, 19, 7, 13, -35, -13, 34, 31,
    0, 27, 23, -11, -7, -8, 32, -27,
    13, 25, -2, 41, 9, 0, -7, -10,
    39, 0, -1, -8, 7, -7, 1, -23,
    7, -18, 6, 3, 21, -5, 16, -13,
    -28, -11, -44, 6, 5, -3, 24, -11,
    -11, -50, -2, -9, 6, 8, 16, 13,
    -16, 32, 7, -30, -16, -2, -9, -19,
    12, 8, 4, -16, 29, -32, -3, 29,
    7, 35, 3, 3, -18, 37, 56, -65,
    24, -13, -4, 20, -20, 1, -8, 2,
    -6, 12, 21, -5, 0, 6, -9, 20,
    -2, 9, -17, 7, 3, 40, 9, -25,
    21, -21, 0, 14, 15, 15, 8, -34,
    -15, -17, -22, -19, -8, -1, -4, -6,
    16, -2, 1, 50, -21, 20, 16, 24,
    -18, -9, 5, 0, 4, 16, 7, -3,
    9, 23, 34, 24, -20, -16, 32, 48,
    -53, 41, -26, -8, -15, 3, 12, 0,
    47, 25, 13, 35, -7, 12, -20, 18,
    -12, -25, 3, -13, 9, 3, -14, -23,
    -7, 12, -5, -33, 31, -1, -25, 10,
    -25, -36, -11, 42, -1, -3, -6, 21,
    -8, -21, -8, -23, -9, -5, 25, -6,
    6, 6, -5, -5, -20, 7, 3, -26,
    35, 23, 38, -9, 56, -24, -15, 11,
    38, -1, -23, 10, 1, 1, -3, 12,
    10, 15, 13, 3, 20, 13, 5, -34,
    6, -4, 8, -8, -14, -13, 2, -1,
    -18, -10, -15, 21, -6, -21, 64, -8,
    8, -5, -11, -21, 8, -2, 4, 11,
    12, 43, -5, 13, 24, -9, 24, 13,
    4, 15, 2, -18, 31, -5, 9, -20,
    0, -37, -20, -38, 7, 2, -5, -8,
    -15, 8, 8, 3, 2, -4, -7, -1,
    14, -29, -35, -19, 10, -3, -17, -11,
    -12, -34, -25, -2, -2, -17, -14, 13,
    7, -7, 11, -13, 12, 14, 44, -19,
    11, -12, 34, 10, 1, 1, -4, 1,
    -1, 85, 27, -23, 23, 7, -12, 16,
    -7, 26, 12, -7, -12, -13, -24, 4,
    16, -33, -6, -24, -17, 2, -29, 23,
    21, -7, -12, 1, -1, 27, -11, -21,
    -8, -13, -19, 19, 9, -3, -24, -5,
    -8, -9, 2, 5, -13, 25, -11, -13,
    -6, -40, 2, -16, 31, -38, -16, -39,
    0, -15, -28, 5, 7, 14, -5, 10,
    -49, -58, 37, 6, -24, 20, -4, -5,
    6, 9, -18, 0, 21, 12, -18, 52,
    -9, -55, 41, -20, 35, -18, -72, -51,
    -11, 3, 21, 0, -15, -17, 0, -4,
    30, 7, -32, 2, 10, 5, -16, -9,
    2, -16, 8, -2, 9, -9, 14, 21,
    -1, -20, -10, -12, -25, 83, -56, -18,
    11, 8, 9, 23, -9, 10, -4, 17,
    2, -5, 1, -3, -2, 13, -2, 3,
    -4, 11, -2, 10, -16, 2, 0, -12,
    0, -5, -5, -14, 49, 42, 25, 20,
    10, 11, 29, -13, -19, 19, 8, -4,
    -3, -8, 18, -36, 13, -14, 11, -7,
    5, 4, 18, -5, 5, -1, -13, 1,
    -15, -34, 14, -12, -17, 29, 8, 68,
    14, 8, -6, -22, -4, 3, 1, -17,
    -8, -14, -22, 22, 6, -12, 14, -1,
    -20, 2, -27, 3, -6, 21, -19, 2,
    5, -7, -15, -3, 13, -35, -76, 3,
    -23, 12, -6, -2, -1, 3, 10, 0,
    -8, -13, 44, -21, 8, -23, -38, -7,
    -9, 3, 9, -3, -7, 1, 39, -2,
    -31, 15, -18, -41, 5, 11, -12, 2,
    14, -3, 30, -13, 2, 0, 3, 11,
    -34, -7, -17, 35, -15, -2, -18, 12,
    1, 9, -1, -18, 1, 4, 7, 17,
    3, -5, 22, 37, -71, -39, 19, -10,
    -7, 35, -24, 13, -12, -5, 26, 3,
    -3, -2, -10, -21, 1, 22, 3, -22,
    -2, 7, -3, 9, -7, -13, 2, 36,
    3, 12, 20, -14, 62, 28, -21, -89,
    -7, -4, 8, 2, -9, -8, -8, -9,
    16, 22, -2, 66, 43, 43, 11, 4,
    -23, -27, 11, 8, -1, 16, -18, -5,
    -23, -32, 10, 12, -7, -1, -6, -14,
    -20, 19, -16, -17, 9, -11, 1, 7,
    5, 0, -13, -20, -12, 27, 21, -4,
    0, -5, 19, -10, 8, 19, 0, -17,
    -12, 10, -12, -15, 20, -11, 32, -30,
    10, 32, 9, -6, -13, -1, -11, -14,
    -13, -22, -9, -4, 11, -7, -10, 7,
    -2, -3, 33, 10, 50, -1, 4, -10,
    6, 67, 13, 48, -10, 19, -37, -33,
    -9, 37, 24, -11, 2, 21, -17, -5,
    7, 20, -8, -3, 3, 28, 6, 41,
    -22, 1, -2, 2, -13, -4, -8, 0,
    -27, -21, -14, 4, -7, -1, 7, 2,
    -15, 17, -49, 20, -2, -9, 0, 21,
    9, 20, 33, -18, -10, 38, -17, -6,
    14, -23, 14, -9, -1, -32, 16, -18,
    -13, 80, -13, 19, -22, -26, 29, -35,
    -5, -35, 27, 7, -8, -22, -13, 1,
    28, 30, -20, 23, -23, 19, -32, 15,
    0, -3, -1, -18, 10, 10, 10, -6,
    -4, -3, 25, -14, 11, 60, -8, 44,
    -15, 27, 4, -11, -3, 21, -11, -8,
    5, 4, 0, -10, -15, 2, 16, 0,
    -6, -2, -5, -15, -12, -2, -8, -2,
    -3, -28, 0, -18, -56, 24, 28, 60,
    9, 2, -15, 26, -24, 7, 15, 30,
    -10, -27, -25, 1, 18, 1, 15, -26,
    -10, 4, -10, 0, 17, -4, 20, -8,
    -40, -17, -20, -26, -34, -20, -35, 51,
    -11, 14, -8, 3, -14, -32, 4, 9,
    -14, 32, -7, 63, -5, 32, 39, 51,
    4, -18, -20, -29, -19, 22, -57, 26,
    22, 42, 30, 12, -48, -24, -54, -18,
    11, -20, -3, 36, 2, -10, 2, -5,
    12, -41, -40, -17, -26, 7, 14, -19,
    -12, -29, -2, 19, -12, 5, -38, -21,
    0, -29, -7, 26, -8, 21, -6, -34,
    27, 5, -5, -24, -1, 5, -10, 20,
    49, 57, -24, 43, 14, -27, -12, 9,
    -54, -9, 3, 18, -17, -2, 46, 10,
    -6, -29, -6, -29, 18, -5, 25, -33,
    -23, 51, -24, 20, 8, -3, 12, 32,
    -26, 17, 46, -48, 8, -19, 18, -18,
    -23, -8, 11, -23, -13, 4, -15, -37,
    -7, -34, -24, 15, 71, 43, -1, -6,
    -33, 56, 4, -8, 7, -1, 0, 12,
    8, -37, 28, 21, 9, -12, -35, 26,
    6, 25, 15, 13, -42, -22, 4, 20,
    48, -11, -16, 24, 7, -47, 41, 10,
    25, 0, 73, -40, 15, -13, 11, 16,
    17, -29, 34, 13, -25, 4, 28, 16,
    -26, -3, -18, 2, 44, 35, 3, -9,
    -10, 7, -11, -17, -10, 49, -43, 5,
    -44, -33, 7, -14, -11, -9, -30, -13,
    15, -62, 0, -20, 9, 31, 32, 14,
    18, 33, 27, -13, -9, -5, 13, -13,
    14, -20, -30, -24, -3, 66, 30, -57,
    38, 3, -3, 37, -21, 12, -5, 8,
    -8, 40, -21, 36, -4, -11, -9, -16,
    16, 20, 19, 20, 43, 48, -19, -34,
    0, 7, -46, -44, -13, -39, 34, -3,
    38, 30, 8, 30, -8, 14, -33, -7,
    -9, -87, -36, 41, -14, 11, -40, -7,
    17, 7, 10, -30, -15, 37, 0, -11,
    14, -29, 18, -41, -30, -8, 31, 2,
    28, 16, -29, 8, -19, -27, 26, -5,
    -4, -59, 29, -54, 19, 31, -16, 21,
    -9, 2, -6, -21, 35, 21, -20, 27,
    17, -9, -1, 7, 56, -49, -18, -65,
    -11, -41, 7, 12, -15, -11, 2, 20,
    5, 12, 12, 6, -15, 9, 9, 1,
    -8, 23, -2, 4, -34, -8, -18, -45,
    -58, 25, -1, -20, 64, -39, 81, -26,
    43, -22, 13, -9, 5, -7, -9, -11,
    30, 14, 15, 17, -10, -33, -14, -5,
    25, -2, -5, -4, 1, -15, -21, -13,
    13, -52, 11, -15, -26, 17, -43, 35,
    39, 62, 19, 14, 5, 9, -2, 15,
    15, -19, 12, 28, 4, 5, 13, 4,
    -4, 17, 15, -6, 22, -34, -23, -14,
    -4, 3, -9, 2, -17, 27, -25, 55,
    2, -5, -18, -19, -11, -8, -30, -15,
    2, -9, 26, -15, -1, 19, -9, 23,
    -38, -53, -30, -7, 16, 17, -29, 1,
    10, 43, 18, -29, 22, 11, -44, 9,
    11, 8, -18, 23, 0, 5, -2, 15,
    -32, -4, 22, -28, -34, 18, -6, -33,
    -23, 0, 10, 11, 21, -7, -39, -1,
    -9, -74, -2, -28, 0, 17, -41, -10,
    32, -34, -40, 5, -19, 5, -6, -24,
    17, 13, -2, 11, 8, -13, 21, -3,
    -13, 0, -34, -5, -15, -24, 4, -3,
    -4, -24, 26, -3, -9, -12, 9, -6,
    -35, 7, 32, -19, 11, 6, -6, 18,
    -41, -3, 22, 29, 5, 17, 5, -3,
    -12, 24, -52, 3, 13, 5, -37, 48,
    -26, 4, -13, 34, 76, 0, -40, -25,
    14, 7, -45, -5, -4, -23, -11, -7,
    -67, -38, -30, -11, 11, -11, -14, -28,
    2, 33, 6, 6, 44, 34, 16, 0,
    -42, -20, 8, 15, -3, -3, -15, -5,
    -15, -20, 7, -16, 7, 15, 2, 4,
    13, -7, 27, -7, 29, 30, 18, -8,
    -2, 17, -12, 3, -4, -3, 24, -2,
    1, 5, 33, -3, 29, 13, 45, -7,
    -2, -6, -18, -24, -20, -1, 17, 0,
    1, 9, 17, 47, -26, -26, -5, -30,
    17, -1, -8, -25, -21, -10, 2, 22,
    -5, -40, 13, 2, -46, 56, 5, -16,
    22, -31, 2, 1, 2, -12, -2, 9,
    -10, 22, 2, 5, -11, -40, -12, -5,
    -60, 2, -29, -3, -7, 24, -43, 14,
    -7, -8, -33, -4, 59, -35, -25, -10,
    1, -18, 33, -7, 15, 1, 11, -1,
    0, 16, -23, -28, 0, -52, 49, 21,
    -2, 9, 21, 6, -23, 3, -11, -29,
    22, -5, -15, 14, -2, 12, -21, 10,
    -16, 2, -36, 14, -3, -9, 9, -9,
    21, 5, 24, -26, -45, -37, 1, -22,
    5, 25, 27, -49, 23, 9, -19, 32,
    0, -10, 37, 15, -33, -20, -13, 44,
    -41, -7, 15, 48, 9, -19, 12, 12,
    -6, -10, 4, -2, 24, 28, -17, -1,
    28, 12, -13, 9, -9, 3, 3, 34,
    -21, -1, 26, 1, 84, 0, 20, -11,
    27, -18, -19, 11, -8, 4, -11, -9,
    -1, 41, 2, -37, 0, 25, 6, -28,
    4, -30, 14, 18, 3, 29, -15, 36,
    -5, -19, -8, -29, 16, 16, -28, 8,
    17, 17, -1, -44, -8, 11, 19, 0,
    41, 5, 8, 3, -16, 7, -5, 25,
    -11, 10, -20, 10, -7, 15, 20, 10,
    42, 1, 23, -14, -16, -34, 1, 40,
    38, -4, 24, 8, -15, 1, -3, 1,
    20, -24, -33, 14, -11, 2, -13, 6,
    -18, 9, 48, 16, 37, -1, -17, -14,
    29, 38, -8, 60, 34, 1, -19, -21,
    -9, -22, -29, -19, 3, -18, -21, -14,
    37, 28, 1, 15, 9, -33, -1, -11,
    -36, -13, 17, -28, 4, -5, 26, 14,
    23, -35, -17, 0, -7, -23, 25, 14,
    -6, 11, 4, 49, 1, 1, -32, -3,
    13, 22, 17, 7, -34, 23, -11, 5,
    12, -20, 29, -18, 7, -47, -4, -10,
    14, 105, -25, 42, -43, 7, 42, -5,
    3, -10, 3, -7, -6, -36, -2, -12,
    -38, -19, -50, 16, -60, -27, -1, -27,
    -28, -15, 20, -8, 61, -9, 7, 2,
    -10, -48, 8, -25, -28, 20, 6, 37,
    -16, -10, -26, -22, -15, 20, 0, 4,
    -13, -12, -24, -32, 4, -1, 6, -36,
    4, 5, -23, -11, -6, -3, -30, 10,
    25, 11, 21, -52, -35, 2, 19, 27,
    23, 17, 0, -10, 13, 10, -13, 27,
    -50, 17, 7, -37, 25, -14, -28, 9,
    -19, -8, -12, -19, -9, 28, 27, 6,
    -42, -1, -3, -33, -32, 47, -68, 19,
    -8, 12, 14, -19, -9, -8, -23, 8,
    -32, -73, -29, -60, 40, 21, -37, -12,
    -18, -45, -21, -31, -12, 2, -37, 9,
    13, -14, -20, -42, -24, 4, -86, 33,
    -15, 17, -14, -2, 5, -15, 1, 7,
    17, 6, 32, -33, -41, 40, 14, 66,
    -28, -13, 6, 9, 25, 1, -32, -20,
    -10, -7, 58, -36, -3, -39, -5, -70,
    -32, -25, -6, 37, -6, 6, -19, 0,
    -111, -11, -2, -62, -3, 39, 12, -5,
    -53, -12, -15, 20, 11, -11, 57, 19,
    4, 28, -50, -6, 14, -39, 52, -3,
    42, 10, 60, -38, 21, 14, -3, 11,
    -5, 0, 29, 28, -38, -10, 30, 11,
    -49, -5, 21, -60, 9, 50, -17, 7,
    25, 30, -20, 19, 52, 40, -6, 47,
    33, -43, -30, -10, -30, 1, -2, 48,
    -15, 23, 5, -45, -24, -16, 21, -14,
    36, 20, 24, 20, 8, -23, 42, -11,
    4, 9, 76, -2, -24, -8, -46, 11,
    22, 20, -22, 17, 7, 6, 24, -3,
    -48, 33, -21, 25, 71, -25, 27, -42,
    -47, -10, -5, -7, 30, 76, 26, -14,
    -37, -17, -24, -14, -28, 35, 6, -18,
    -10, -2, 7, -12, 20, 6, 11, 11,
    -24, 99, -9, 22, 11, -32, -10, 18,
    12, 8, 47, -33, -3, 23, -8, 27,
    6, -82, -63, -12, 22, 34, -17, -19,
    -56, 8, -1, -37, -18, 19, -65, -9,
    23, 26, -35, 29, 21, -31, 17, -9,
    41, 26, 22, 29, 24, 26, 56, 73,
    -28, 7, -9, 80, 29, 5, 12, 7,
    16, -39, -79, -23, 26, -11, 15, 14,
    10, 82, 33, -68, 26, 39, -2, 15,
    21, 6, 2, -30, -48, 4, -20, 18,
    -83, 56, -5, 18, 21, -28, -52, -30,
    -67, -62, 90, -16, -32, -7, 6, -5,
    -29, 5, -7, 24, 26, -24, -10, -44,
    -32, -14, 13, -10, 58, -23, 25, -30,
    7, -72, -9, -17, 31, -29, 32, -46,
    15, 27, 20, 19, -5, -2, 6, 9,
    50, 72, -4, 49, -36, 0, -58, -10,
    -2, 32, 1, -6, -52, -21, 12, -16,
    -25, 3, 11, -14, 2, -4, 86, -19,
    -16, -29, 15, 25, 30, -23, 8, -17,
    0, -73, -20, -55, 10, 13, 12, 50,
    44, 10, 17, 6, -10, -46, -13, -28,
    15, 17, 2, -31, -19, 26, -43, 12,
    -45, -59, -34, -10, -12, 33, -11, -12,
    34, -13, 39, -40, -13, -22, -5, -14,
    -11, -6, 41, 5, 36, -24, 27, -31,
    3, -86, -37, 55, 35, -28, 6, 43,
    7, 89, 39, 56, 8, -8, 2, -5,
    4, -11, 11, 86, 2, -36, 0, -56,
    -54, -26, -66, -21, 48, -20, -10, -8,
    -5, -3, -25, 23, -50, 11, 2, 54,
    0, 63, 32, -29, -10, -1, -19, -19,
    -25, -93, -21, -12, 55, -21, 14, 3,
    -84, -9, 23, 23, 9, 35, -36, -4,
    40, -114, -3, -42, 24, 23, -32, 3,
    -18, 6, -25, 28, -18, 80, 13, -28,
    21, -2, -5, 30, -4, 21, -37, 26,
    -25, 3, -64, -22, 15, -40, 16, 7,
    -17, -43, 45, -53, 15, 33, -31, 36,
    65, -8, 42, -56, -8, -2, -2, 23,
    3, 26, -81, -48, -28, -84, -9, -29,
    -8, 43, -127, 20, 74, 8, 18, 10,
    -18, -28, -18, -19, 40, 30, 41, 10,
    -21, 15, 59, 16, 5, -31, -14, -5,
    62, 9, 27, 16, -41, 26, 7, 74,
    5, 28, -5, 2, 30, 44, -10, 28,
    -55, -57, 23, -2, -28, 3, -3, 49,
    0, -61, 16, 12, 19, -9, -1, 16,
    -13, 67, -32, -15, -19, -45, -28, -2,
    -4, 61, 6, 12, 0, -50, 59, -32,
    -56, -19, 28, -8, 6, -21, -10, 19,
    29, 5, 13, -27, -30, -5, 21, 5,
    -4, -38, -10, -37, 49, 69, -10, 44,
    20, 16, -13, -11, -36, 24, -18, 45,
    -7, -40, -28, 15, 10, 34, -21, -66,
    -2, -9, -45, 5, 22, -11, 10, -3,
    -10, -82, 51, -2, -14, 37, 33, -24,
    -84, 13, -39, 14, 3, 33, -8, 26,
    -63, 2, 16, -1, 103, 26, 37, -5,
    25, 5, -7, -18, 24, -10, -10, -15,
    8, 9, -28, -6, -28, 79, -25, -12,
    2, 32, 36, 18, -15, 30, 39, 14,
    28, 50, -19, -21, 2, -2, 41, -19,
    -12, -78, 28, 34, 18, -19, 38, 8,
    -10, -19, 50, -43, 24, 26, 24, -59,
    4, 77, 17, -89, 36, -14, -45, 27,
    9, -13, 7, 22, 36, -5, -27, 19,
    17, -12, 53, 23, 16, -15, -8, 5,
    17, 28, -24, -3, -29, 4, -23, 24,
    16, 13, -13, 29, 52, 12, 13, 29,
    6, -17, 19, -10, 18, -9, 24, 53,
    -4, 5, 13, -17, -26, 1, -7, -4,
    30, -50, -5, 11, -29, -100, 11, -20,
    -30, -39, -2, 0, -32, 83, -33, -1,
    -42, 43, -4, 7, 17, 30, 31, 66,
    -17, -11, 14, 11, 26, 14, -2, 6,
    -24, 54, -42, 36, 28, 40, 50, -6,
    -42, 13, -26, 20, 11, 18, 23, -25,
    13, -9, 64, -7, -37, -29, -91, 85,
    -16, 9, -42, -3, -22, -3, -11, 7,
    3, 29, 68, 7, -31, 29, 31, 4,
    -20, 13, 31, 22, 85, -2, -11, 6,
    0, 35, -19, 87, 16, -51, -16, -36,
    44, -14, -8, -17, 6, -33, -29, -31,
    -74, 14, -40, -18, -8, -3, -14, 8,
    -55, -34, 22, -55, 14, -3, 38, 61,
    23, -41, 29, 56, 8, -28, 22, 22,
    -30, -63, 48, -4, 19, 3, -3, -12,
    -3, -24, 11, 31, -4, 21, 22, -36,
    12, -30, 61, -15, -15, -33, 15, -6,
    27, 102, -16, 45, -46, -6, -2, -7,
    -36, -12, 23, -45, 1, -18, 38, -8,
    9, 42, -13, -68, 30, 48, -54, 41,
    -72, -12, 0, -20, 13, 0, 18, 47,
    -14, -37, -13, 11, -10, -21, 1, -5,
    -6, 36, 24, 17, 13, 16, -10, -25,
    -49, -35, 32, -9, 40, 13, 11, 11,
    23, -6, -29, 6, 2, 12, -35, 68,
    -5, 20, 58, -6, -11, 23, -72, -10,
    -47, -7, -12, -44, 5, 0, -6, 127,
    84, 14, 18, -5, 5, 47, 16, -7,
    11, -6, -4, -35, 3, -25, 30, 7,
    -31, 7, 0, -63, -54, 39, -38, -49,
    -12, -22, -30, 43, -40, -35, -9, 22,
    20, 10, 28, -23, -36, 7, 3, -11,
    10, 29, 13, -30, 4, -7, 6, -8,
    16, 3, -14, 20, -24, -9, 6, -18,
    -12, -4, 21, 2, -13, 50, 12, -17,
    -41, 23, 31, 34, 11, -8, -33, -10,
    12, 41, -31, 51, 4, 20, -13, 3,
    13, -11, -8, 0, -6, 37, 1, -8,
    44, -17, -35, 35, -10, 5, -11, -17,
    14, 7, -38, -7, -19, 7, -9, 16,
    -15, 29, 16, 30, -19, -15, 3, 6,
    -20, 30, -22, 9, 7, -4, 13, -38,
    -42, 11, 5, 35, 17, 5, -12, -32,
    34, 31, 15, 14, -2, 21, -2, 6,
    -32, -7, 3, -8, -2, -9, -7, 20,
    0, 5, -3, 38, 14, -8, -6, -2,
    17, -14, -27, 19, 14, 3, -13, 6,
    12, 23, 6, -22, -21, 14, 10, 16,
    -20, -38, -19, -3, -16, -19, -12, -3,
    -2, 7, -1, 25, -11, 3, -2, -11,
    -32, -12, -39, 36, -48, 7, -5, 16,
    -48, -13, -33, -8, 19, -8, 8, -6,
    0, 47, 4, 5, -9, -30, 27, -24,
    -10, -3, -4, -21, -3, -14, -10, -8,
    -10, 1, 16, 16, 6, 6, -25, -6,
    4, 7, -6, 5, -12, 20, 37, -1,
    23, -7, -2, -6, -19, 22, 22, -20,
    -34, -15, 9, 8, 6, 15, -2, 15,
    31, 3, -27, -30, -16, 57, 10, 32,
    2, 21, -27, -10, -36, -17, -9, -16,
    6, 16, -10, -9, 6, -44, 26, 12,
    -2, -4, -2, -3, -18, 8, -15, -6,
    13, 3, -1, 11, 2, 22, -51, 28,
    -10, -29, 7, 20, 1, -4, -3, 4,
    -49, -6, 10, -7, 13, -44, -15, -16,
    -9, 3, 12, -16, 11, 34, 1, -3,
    7, 26, 31, 17, 32, 10, 38, -8,
    -11, -4, 4, -14, 39, -22, 2, -11,
    6, 12, 35, -12, 1, -57, 30, -12,
    -14, -1, -12, 15, 5, -17, 13, 3,
    -14, -32, -3, 10, 28, -52, -24, -6,
    4, -12, 4, -7, 8, -12, -9, 27,
    -20, -6, 9, -14, 29, -12, 36, -10,
    -21, 9, -2, -2, -18, 6, -5, 3,
    0, -20, -3, 9, -14, 11, 28, 0,
    -9, -23, 16, -8, 6, 25, 5, -12,
    16, -13, 15, -3, -11, 10, 18, 0,
    12, 25, 5, 13, 25, 1, 3, 19,
    6, 29, 2, 7, 7, 0, 10, 15,
    -23, -3, 15, -6, -24, -15, -10, -23,
    31, 40, 4, 4, 21, -8, -1, -7,
    -4, -2, -7, -13, -5, 1, -11, 21,
    28, 17, -19, -9, -20, 1, -10, 53,
    32, -6, -11, -9, -20, -26, -6, -9,
    6, -14, 3, 40, -1, -8, 14, 16,
    -7, -4, 17, -18, 3, 0, -9, 0,
    -20, -44, -12, 2, 29, -8, 5, 1,
    25, -20, -8, -26, -5, 6, 9, -10,
    17, -28, -1, 3, 47, -33, 21, -25,
    -10, -11, 16, -6, -3, -1, 10, -1,
    -16, -18, 11, 17, 16, 27, -7, -15,
    -4, 9, -30, 31, 4, -14, -21, -2,
    31, -27, 28, 1, 4, -1, 5, 17,
    18, 4, 27, 4, -4, 3, 20, -44,
    27, 2, 38, -11, -16, -1, 17, -30,
    22, 1, -5, -28, 5, -12, -16, -15,
    15, 13, 39, -7, 7, -17, 49, 6,
    -24, -13, 0, -10, 9, 10, -24, 15,
    20, -4, 6, 22, -2, -28, -4, -7,
    -3, -7, 0, 12, 2, 0, -19, -4,
    -41, 27, -14, 4, 1, 9, 20, 19,
    -13, 0, 10, -15, 5, -8, -2, -20,
    14, -6, 27, 29, -8, 1, -24, -13,
    -3, 3, -1, 23, 18, 6, 16, -9,
    -34, -34, 24, 26, -8, -41, -33, 14,
    32, -2, -10, 9, 18, 19, 6, -7,
    -20, -7, 31, 0, 20, -11, -5, 3,
    -16, -2, 16, 26, -5, -5, 17, 3,
    5, -10, -21, 1, -6, 6, 24, -21,
    -1, 11, -13, -23, -11, 5, -1, -4,
    19, 13, -12, 8, -14, -13, 10, 17,
    -10, -1, 6, 5, 6, 4, -16, -18,
    8, 12, 10, 7, -8, -8, -15, -11,
    2, -9, 1, -9, 4, 24, 5, 3,
    -17, -21, 18, -18, 35, 21, -35, -17,
    5, -9, -24, -14, -1, 10, 20, 25,
    -16, 8, -3, 16, -21, 26, 18, -36,
    12, 11, 1, 3, -31, -18, -5, 20,
    5, 35, -3, 13, -30, -13, -10, 4,
    -25, 9, 27, 2, -17, -23, 3, -11,
    20, 16, 69, 4, 30, 23, -1, -9,
    15, -9, 0, -3, -18, -12, 0, 0,
    -11, 14, 4, -22, -18, -30, -11, -11,
    22, 2, 54, -12, 1, -9, -10, 3,
    7, 15, -14, 33, 11, -13, 18, -36,
    0, 10, 2, 12, -4, 3, 2, -14,
    -18, 38, -12, -10, -25, -10, -10, -8,
    10, 23, -8, 10, 5, 53, 11, 2,
    15, -7, 50, -3, -21, -2, 6, 19,
    20, 5, 7, 5, 5, 12, 7, 1,
    -17, 19, -16, -20, 38, -3, -31, 18,
    -22, -14, -9, -5, -13, 13, -22, 11,
    27, -45, -1, -16, 30, 6, -6, -36,
    13, 11, -15, 9, 2, -5, 1, -32,
    38, 27, -8, -6, -13, -15, 22, -49,
    6, -17, -2, -18, -2, 5, 18, -18,
    50, -15, -19, -17, 13, 26, 12, 23,
    5, -28, -26, -13, -15, 10, -1, 7,
    -22, 19, -12, -2, -13, -3, 5, -5,
    10, 9, -2, 21, -14, 12, 0, -2,
    20, 0, -3, -9, -1, 24, 0, 11,
    -10, 3, 24, 20, 3, 1, -6, 5,
    32, -5, -3, 15, -28, -35, 1, -15,
    -4, -11, 8, -4, 4, -22, 23, -25,
    20, -10, -17, 25, -23, 0, 3, -42,
    -26, 21, 3, 11, 27, -43, -3, 0,
    1, -1, 33, -8, -15, -23, -32, -10,
    44, 20, 11, 37, 24, -13, 4, -30,
    -2, 11, -2, 0, -9, 3, -52, 5,
    -3, -13, 21, 13, -20, 14, 22, -31,
    15, 11, -41, -11, 9, -5, 8, -30,
    14, -16, -2, 4, -24, 18, -20, 8,
    -3, -3, 27, 11, 11, 14, 31, -3,
    12, 21, 3, 6, 20, -1, 7, -8,
    8, -1, 14, -21, -25, 8, 1, 28,
    13, -19, 25, 10, -4, 33, 4, 4,
    12, 0, -32, 6, 8, 7, 9, 33,
    -1, 26, -13, -16, -13, -7, -9, -3,
    10, 33, -8, -49, -11, -29, 23, 3,
    13, 5, -2, 16, 3, -2, -8, 4,
    -25, 5, 3, -24, -2, -6, 6, 1,
    1, -8, -5, 1, -20, 55, -15, -27,
    13, -6, -30, -19, -17, 33, -8, 12,
    5, 0, 18, -4, 41, -9, 31, 6,
    3, 40, -29, -17, -17, 25, 1, 34,
    -29, 2, -11, 8, 6, 22, -14, 0,
    0, -24, 4, -1, -10, 6, -10, -1,
    4, -30, 10, 7, -14, -9, 35, 9,
    7, 0, 39, -3, 18, 20, 11, -25,
    -7, 0, -21, 2, -6, -18, 52, -2,
    -63, -38, 18, -5, 7, -14, -11, -28,
    -28, 32, 6, 28, 4, -8, 11, 12,
    17, -20, 32, -6, -33, 0, -24, -35,
    15, -12, -9, -2, 27, 20, 18, 1,
    -9, -65, 21, 16, 37, -3, -8, 2,
    -7, 2, 34, -25, -8, 5, 5, 21,
    3, -37, -22, 20, 18, 12, 8, 13,
    -4, 16, 2, 12, -32, -3, -6, 15,
    -4, 2, -20, -50, -56, -14, -10, 8,
    -8, 5, 12, -17, -14, -29, -24, -7,
    29, 27, -54, -26, 6, -2, 5, -27,
    8, 2, -9, -15, -21, -15, -3, -12,
    -13, 9, -2, 23, 19, -10, 10, -7,
    19, -19, 2, 8, 0, -2, 35, 20,
    20, 34, 47, -2, -3, 26, -5, -23,
    14, 7, -1, 6, -18, 24, 16, 19,
    12, 17, 31, 0, -4, -38, -3, 11,
    -7, 14, 20, -29, -45, 47, -2, -13,
    -56, 60, 16, -3, 1, -4, -31, -27,
    8, -9, 9, 13, -14, 21, -25, -17,
    -29, -2, 7, 9, 17, 21, -36, 26,
    19, -11, -14, 15, -36, 0, -2, -40,
    17, 18, 26, 8, 26, -4, -14, -32,
    -6, 0, 20, -19, -29, 25, 39, -22,
    58, -29, 31, -8, 10, 2, 49, -14,
    -19, 5, -18, 17, 20, -19, 10, 9,
    26, 31, 39, -42, -14, -20, -47, 14,
    -8, 12, -8, -6, 2, -1, -15, -24,
    -15, -19, 79, -7, 31, -41, -23, -29,
    -24, -6, -13, 2, 4, 18, -13, 14,
    -51, -5, 2, 10, -31, 13, 8, -25,
    8, 3, 11, -2, 0, -8, 1, -2,
    34, -11, 72, -36, -3, 22, 36, 19,
    13, -13, 52, 12, 9, 27, -8, 10,
    32, 15, 5, -48, 39, -20, 5, 11,
    -13, -3, -16, -12, -10, -34, 14, 29,
    15, 27, 11, 21, -28, 4, 19, 20,
    -17, 4, -34, -19, 12, -9, 42, 36,
    3, 11, -8, 8, -9, -4, 3, 4,
    6, -2, 5, 20, -25, -19, -24, 34,
    -38, 37, -6, 20, 1, 2, -17, 22,
    14, -32, -15, -21, -39, -18, -5, 8,
    -13, 19, 2, -8, 21, -15, 3, -40,
    22, -9, 3, -13, 9, -34, 11, 0,
    -19, -13, 21, -12, 15, -34, -16, -3,
    -15, -2, -3, -9, 15, 34, -1, -11,
    4, 4, -13, 0, 17, 2, 40, -10,
    19, 25, 3, 22, 17, -13, 7, -2,
    -37, 30, 2, 8, 19, 3, 9, -9,
    34, -7, -9, 3, 4, -18, 2, -14,
    -12, -14, -12, -8, -11, -5, 1, 4,
    -1, -1, -5, 28, 27, -12, 8, -57,
    0, 14, 34, -3, 8, -17, 28, -73,
    25, 13, 9, 0, 5, -3, 8, -15,
    2, -32, 12, -48, 24, 29, 3, 64,
    -22, 16, -18, -28, 6, -19, -14, -31,
    0, -71, -20, 10, 7, -23, -7, -20,
    20, 45, -13, -18, 28, 33, 1, -33,
    5, 13, 36, 27, -37, 19, -22, 4,
    29, 1, -21, 27, 25, -30, -13, 0,
    -82, 55, 67, -16, 17, -12, -13, 13,
    36, 11, 47, 19, 21, 30, 22, 3,
    -30, 0, 40, 22, 5, -26, -15, 10,
    -51, 3, -7, 4, 24, 5, -7, -8,
    66, -36, -20, -10, 23, 11, -10, 6,
    2, 29, 4, -26, -8, -17, -3, -27,
    32, 21, -5, -21, 7, -25, -8, -27,
    36, 3, -11, 9, -3, -1, -2, 22,
    18, -25, 36, -34, -18, 1, 8, 24,
    1, -22, -24, 14, 36, -9, -20, -24,
    17, 14, -60, 3, 22, -7, -14, 7,
    -7, 5, 0, -3, 6, 14, -9, 7,
    1, -43, 12, -4, 0, 0, -25, 0,
    13, 21, -26, 19, 12, 8, 10, -17,
    24, -24, -4, -33, -44, -24, 44, 7,
    19, -10, 2, -14, -32, -3, 0, -14,
    -7, -24, -16, -12, -18, -10, 6, 13,
    -20, 10, -4, 10, -45, 14, 14, 9,
    22, 39, -1, 27, -29, 13, 24, -26,
    9, 4, -4, -13, -22, -14, 1, -3,
    27, 3, -22, -38, -5, -17, -5, 5,
    53, -1, 32, 7, -17, 14, 5, -20,
    -24, 21, -7, 15, -4, -5, 51, 18,
    -10, -1, 5, 9, 11, 4, 4, 18,
    -30, 43, 8, 21, 6, -3, -17, 12,
    4, -7, 3, -10, -7, 36, 12, -2,
    -9, -30, 26, -28, 9, 39, 28, -27,
    8, 20, 2, -4, 40, -5, 6, -1,
    10, 24, -8, -17, 23, -31, -20, 22,
    1, -14, -8, 14, -19, 7, -27, 23,
    42, 27, -15, -16, -11, -7, 3, -9,
    25, 8, -7, 14, 2, -20, -3, -61,
    20, -24, 17, -21, -8, -8, 5, -31,
    12, -3, 15, -22, -26, -6, 0, -3,
    -17, -25, 20, 23, -2, -2, 5, 19,
    11, -8, 5, -7, -23, 10, 11, 14,
    -19, 18, -28, 9, 13, -24, -5, -6,
    32, 6, -22, -4, 5, -1, -29, 1,
    12, 0, -10, 7, 33, 9, -15, -34,
    -6, -5, 21, -4, 3, -4, 3, -15,
    -13, 33, 49, -127, -31, 4, 16, -18,
    -1, 11, -10, 8, -22, -28, 13, -30,
    -11, -1, 25, 2, 14, 18, 32, -13,
    -23, 13, -13, 12, 21, -49, -4, 2,
    31, -25, 0, -2, -17, -2, -12, -10,
    -40, -26, 16, 31, 13, 20, 15, -12,
    -63, -28, 3, 17, -6, -38, 14, -15,
    17, 34, -1, -8, 27, 11, 10, -25,
    0, -40, -22, -42, 49, -8, 4, -19,
    18, 8, -46, 4, 4, 30, -35, 37,
    13, -22, -41, 38, 11, 2, 0, 12,
    12, 8, -24, 22, -9, 2, 7, 0,
    15, -33, -1, -7, -5, -3, 22, 11,
    -31, -1, 4, -28, -37, 27, -16, -22,
    -19, 50, -40, 34, -26, 14, -19, 22,
    3, 37, -12, -13, 30, -34, -45, 19,
    -1, -30, -37, 1, 4, -36, 18, -10,
    -68, 19, -38, 2, 0, -7, -34, -2,
    45, 1, 17, -41, -6, -26, 29, 13,
    12, 35, -10, 73, -25, 88, -4, -26,
    27, -16, -34, 24, -10, 94, -6, -48,
    9, -15, -70, 8, 87, 17, 65, 10,
    4, 107, 50, -87, -13, 43, -22, -18,
    -89, -3, -24, -1, 21, 26, -31, -10,
    30, 28, 71, 29, 7, -18, -5, 0,
    8, -28, 52, 35, -28, -42, 20, -26,
    25, -14, -30, -6, -10, -56, 4, 70,
    54, -2, -55, 13, -32, -28, 53, -24,
    26, 74, 1, -4, -15, -33, 27, -64,
    30, -63, -15, -18, -20, 26, 28, 10,
    25, -54, 25, 33, 26, -43, 31, -101,
    5, -78, -13, -82, 34, 40, 8, 35,
    8, 88, 12, -44, 31, -2, -2, 9,
    0, 7, -20, 61, -9, 54, 16, 16,
    24, 20, -18, 96, -23, -33, 31, -10,
    -63, 18, 2, 62, -66, -4, -3, 37,
    -9, 14, -13, -26, -61, -13, 6, 61,
    67, 48, 30, -7, -46, -83, 16, 9,
    -107, -22, -19, 9, -6, 54, -55, -10,
    9, 21, -12, 18, -24, -11, 19, -14,
    59, 54, -13, 55, -53, 23, 3, -29,
    -59, -1, 46, -42, -41, 18, -2, 41,
    17, 36, -7, -39, 10, 0, 11, -32,
    35, -13, -11, -18, -32, 72, 44, 36,
    -19, 68, -48, -1, -45, 0, 34, 30,
    -69, -60, 65, 23, 34, 46, 27, 22,
    19, 34, -72, 4, 18, -18, 50, 6,
    35, -27, -6, -15, 0, 36, -37, 24,
    4, -5, -38, 19, -15, 48, -80, -1,
    -27, -9, 33, 14, -8, 9, 15, -49,
    57, 10, -10, 54, -57, 45, -9, -26,
    11, -20, 46, -44, -44, 14, 70, -41,
    -10, -43, 57, 19, -22, 24, 74, -38,
    -4, 43, 29, -30, -9, -63, -39, 56,
    -40, 36, -21, 45, 39, 53, 47, -93,
    -76, -53, -44, 10, -18, -7, -13, -44,
    -23, 64, -50, -22, 22, -18, -5, -44,
    -3, 4, 52, 12, -9, 25, -43, 32,
    71, 3, -2, -5, 31, 17, -28, -6,
    84, 3, 47, -24, 12, -24, 22, 12,
    57, -20, -9, 36, 28, 48, 3, 32,
    13, 1, -32, -29, 14, 30, 19, 16,
    32, 6, -62, 59, -28, 48, 45, 50,
    -8, 16, -43, 14, -2, -35, 19, 37,
    -19, 81, -12, -35, -10, -59, 17, 42,
    33, -28, 21, 46, 27, -3, 14, 20,
    -65, 9, 11, -49, 48, -42, 19, 85,
    -26, -28, 15, 7, -62, 2, -22, 38,
    -8, -20, 15, 2, -39, -16, -31, 42,
    -21, -17, 47, -10, -64, -62, -1, -15,
    69, 4, -46, -12, -21, 37, -7, -14,
    40, -39, 35, 11, 24, -66, -20, 21,
    -4, -5, 12, 39, 9, -76, -42, -7,
    20, 21, 12, 80, -24, 25, -27, -30,
    -22, 59, 4, -36, 54, 75, -2, 51,
    21, 3, -33, -15, 23, -15, -13, -10,
    32, 73, -18, 51, 47, -11, -7, 1,
    7, 10, 32, 1, 8, 10, 0, 24,
    -32, -7, 3, 15, 3, -2, 36, -34,
    4, 5, 25, 24, 33, 2, -9, -113,
    9, 18, 81, 11, 63, -22, 30, -127,
    -11, 23, 20, 32, 12, 23, 10, 55,
    5, -11, 44, -50, 77, -40, -21, -22,
    -21, 26, -48, -57, -10, -45, 3, -73,
    40, 28, 8, 4, -4, -57, -21, -69,
    3, -1, -52, 19, -21, 5, 19, 8,
    -78, 37, 64, 0, 28, 10, -29, 28,
    43, 60, -57, 2, 35, -44, -3, 2,
    1, -28, -25, 6, 62, -41, -22, 10,
    25, 11, 14, 11, 4, 6, 23, 30,
    -3, 23, -28, 26, -11, 52, 3, 3,
    -95, -6, -22, 3, 34, 20, -19, -9,
    -46, 73, -35, -7, 3, 61, -31, 1,
    -4, -13, -23, -11, -51, 1, 23, 21,
    33, 44, 5, 7, -4, 36, 26, -3,
    66, -24, 6, 2, -19, -1, 8, 30,
    28, 49, 35, -9, -12, 11, 0, 49,
    9, 8, 11, -31, 9, -11, 16, -55,
    44, -4, 30, -27, -18, 87, 13, 30,
    10, 19, 45, -2, -22, -15, -3, -4,
    18, 69, -25, 20, -53, -32, 4, -15,
    2, 7, 17, 12, 32, 12, 33, 16,
    40, 37, 45, -38, -28, 55, -56, 17,
    18, -7, -37, -6, -52, 19, -12, -7,
    3, 64, 75, 22, -25, 1, 9, 6,
    74, 22, 12, -41, -36, -6, 23, 25,
    -67, 73, -87, -4, -21, -29, -6, 17,
    -15, -4, 0, -38, -19, 6, 14, -9,
    0, 27, 34, 40, -34, -17, -19, -13,
    -49, 14, 22, -7, 42, -3, 14, 7,
    -48, -45, 33, -14, 9, 25, -20, 33,
    -36, -51, 42, 4, 12, 3, -7, 10,
    5, 11, 95, -25, -2, 18, -23, 29,
    -25, -47, 32, 11, -27, -2, -16, -1,
    -49, 6, 36, 28, -11, 14, 5, -19,
    24, 36, -9, 5, 56, -25, -5, 14,
    12, -54, 30, -43, 79, -32, -38, 27,
    64, 25, -34, -9, -55, 3, 12, 48,
    21, -18, -64, -59, -54, -8, -51, 28,
    18, -19, -17, 17, 5, -40, -17, -112,
    -106, -8, -24, 7, -26, -35, -9, -39,
    -12, 35, 24, -18, -12, -13, 2, -13,
    -33, -38, -22, -18, -22, -4, -2, -11,
    -6, 9, 10, -6, -17, 28, 21, 11,
    15, -14, 19, 6, 0, -21, -55, -27,
    0, -20, -4, 17, 13, 37, 21, -16,
    71, 32, 56, -54, 11, 6, 26, 58,
    10, 11, 14, 11, 10, -17, 2, -13,
    -31, 56, 34, 35, 17, -4, 16, -9,
    1, -17, -16, 11, 4, -40, 49, 6,
    -20, -16, -25, -21, -41, 12, -7, -20,
    10, 11, -59, 47, 31, -57, -14, -3,
    1, -14, -30, 7, -41, 15, -9, 1,
    5, -29, -42, -63, 37, 21, -45, -36,
    18, -6, 26, 45, -2, 34, 12, 47,
    -18, 1, 12, 25, 21, 21, 29, -41,
    -23, 4, 15, -27, 48, 46, 15, -46,
    -5, 13, -11, -7, 34, -2, 61, 3,
    30, -46, 30, -13, 2, -24, -39, 70,
    -5, 12, -28, 27, -37, -2, 43, -14,
    -3, -28, 5, 21, -24, 2, 42, -13,
    -29, 34, -50, 30, -8, -30, 25, 27,
    24, 6, -8, 29, 67, -17, -47, -11,
    -24, 16, 2, 13, 40, -69, -39, 43,
    -24, -42, 2, -9, 69, -102, 12, 31,
    -1, 15, -28, -12, -5, -1, -1, 20,
    -9, 9, -22, 31, -29, 10, -29, 14,
    2, -15, 1, 8, -53, 26, -22, 25,
    21, -23, 4, -10, 7, 3, 0, -7,
    -29, -27, 9, -2, -13, -27, 23, 8,
    40, 12, -28, -7, -11, -12, -35, 18,
    -30, -60, 38, -39, 27, 25, 28, -43,
    -8, -21, 6, 19, -5, -7, -14, 1,
    21, -39, 24, -41, -2, 13, 28, -22,
    -36, 15, 11, 8, -31, 22, 12, -30,
    1, 22, -4, -29, -26, -3, -16, 10,
    27, 22, 3, 15, 14, -8, -4, 16,
    4, 30, -13, -44, -5, 7, -5, -4,
    -15, -9, -5, 10, -22, 21, -18, 14,
    13, 10, 30, -1, -13, 28, -12, 24,
    -14, -1, -19, -6, 0, 4, -4, -19,
    0, 11, -20, 24, 6, -13, -26, 5,
    -20, -1, -52, 12, 4, 14, 38, -31,
    -10, 10, -10, -12, 7, 7, -44, 6,
    3, 20, -4, -3, 2, -15, -10, 3,
    26, -20, 20, 20, 25, 17, 9, -19,
    36, 4, -8, -17, 17, 4, -1, 7,
    -1, 13, 1, 16, -10, -3, -9, 14,
    0, -31, 23, -10, 5, -2, 8, 1,
    -7, -26, 12, -33, 8, -6, 2, 2,
    21, -13, -18, -1, 36, -49, -2, 34,
    42, 22, 10, -15, -22, -1, 18, 20,
    33, 15, -13, -5, -4, -15, -2, -1,
    -2, 5, 4, -27, -14, 16, -22, -8,
    44, 3, 39, 6, -34, 11, -9, -57,
    -5, 23, -24, 2, -5, -5, 13, -17,
    -3, 11, -3, -7, -2, -1, 4, 3,
    47, -5, 30, -11, 13, -3, 20, -15,
    -22, 65, 6, 0, 0, 24, -20, -10,
    17, 16, 0, 0, -13, 11, -35, -33,
    -44, 0, 0, 19, 6, 10, -11, 10,
    3, -42, 2, -44, -3, 3, -21, -7,
    17, -18, 42, 23, 4, -41, 2, 37,
    30, -27, -35, -31, -1, 30, 13, 14,
    8, -14, 2, 31, 3, 2, 2, 1,
    8, 5, -26, 28, 19, 12, -26, -9,
    25, 16, -9, -5, 15, 28, -57, -10,
    13, -7, 45, -22, -11, -35, -32, 1,
    16, 25, -4, -16, 11, 1, 7, 3,
    36, -16, 15, -20, -40, 10, -4, -19,
    -2, 29, -2, -37, 45, 61, -23, -8,
    50, -12, 15, -6, 2, -14, 10, -10,
    23, -1, 24, -20, 3, -6, -6, -8,
    -30, 11, -16, 27, 4, 19, -7, -13,
    22, 3, 9, -16, 4, 38, -3, -35,
    6, 5, -4, -21, -10, 2, -2, -21,
    6, -10, 9, -2, -8, -6, 0, 4,
    -9, -29, 5, -37, 1, -10, 4, 33,
    -9, 16, 15, 3, 27, 32, -6, 5,
    13, -4, 1, 12, 18, -8, 25, 25,
    -11, -10, -13, 6, -1, -1, -9, -7,
    -1, 9, 0, 12, -7, -30, -32, -1,
    -20, 43, 3, 12, -9, -77, -17, -13,
    15, -48, -3, 4, 11, -31, -29, -23,
    -44, -16, 6, -8, -6, 3, 4, 13,
    13, 4, -26, -14, 3, -25, 23, -12,
    -4, -31, -13, 43, -5, -20, 6, 20,
    -10, 51, 5, -10, -10, -18, 4, 20,
    -10, 11, 3, 6, -5, 4, -3, -3,
    -15, -19, 8, 12, -2, -16, 8, -20,
    22, 22, -15, 36, 14, 27, -54, 27,
    -19, 26, 0, 22, 13, 15, -8, -5,
    -19, -9, -13, -10, -13, -6, -6, -16,
    28, -23, -25, -19, -14, -12, -37, 13,
    -16, 17, -8, 5, -14, -16, 12, -31,
    -11, 4, 4, -25, -41, 39, 8, 17,
    -18, -3, -22, 0, -5, -2, 0, 6,
    -27, -12, -5, 15, -6, 3, 8, 1,
    21, -6, -8, 3, 21, -15, -7, -27,
    27, -3, 6, -23, 4, 15, 34, 0,
    -9, -26, -19, -11, -19, 5, 1, 2,
    -9, -1, 21, -5, -1, -14, 30, -14,
    14, 13, 11, -3, 11, 33, 9, -41,
    12, -13, 6, -7, 1, 11, 16, 80,
    1, -28, -3, -14, 11, 6, -11, 13,
    23, -17, 2, 16, -3, -10, -40, 4,
    4, 13, -13, -21, -68, 43, -4, 12,
    -25, -42, -16, 0, 9, 11, 5, -14,
    23, 15, 7, -6, -16, 0, 13, -6,
    -27, 22, -23, 19, 24, 9, -19, 11,
    13, -37, 13, -13, -13, 21, -9, -9,
    24, -13, 7, 12, 28, -30, -13, -8,
    11, 17, 10, 7, 2, 10, 1, 3,
    26, -25, 8, -27, -29, 29, 13, -4,
    15, -13, 25, 10, 48, -2, 53, 43,
    21, -8, -47, 8, -30, 11, 24, 0,
    27, -19, -5, 10, 1, 4, 4, -7,
    -25, 7, 17, 0, -9, 21, -2, 15,
    -5, 18, 11, 23, -5, 9, -3, 29,
    9, -23, 40, -10, -14, 14, -4, -37,
    12, -29, -7, 12, -4, -4, -7, 0,
    18, 6, 13, 41, 18, 4, 26, 4,
    -10, -7, 22, -13, -28, -33, 23, -21,
    9, -5, 6, -10, -24, -3, -28, -20,
    25, -23, 1, 16, -5, -3, -9, 9,
    -30, 42, 15, 4, -2, 8, 24, -12,
    -5, 17, 11, 5, 11, 38, -25, -9,
    23, 11, -15, -8, -9, -10, -5, 15,
    -5, -3, 28, -7, 0, -6, -6, 7,
    27, 12, 4, -2, -46, 7, 13, 11,
    8, -25, 21, -21, -20, -37, -38, 1,
    1, 2, 5, 34, -22, 25, 27, 17,
    -10, 3, 4, -4, -3, 6, -10, -2,
    31, 10, -9, -47, 10, -17, -3, 5,
    -13, -13, -9, -29, -18, -4, -79, -9,
    6, 13, 16, 15, 0, -18, -27, -37,
    -1, 2, -1, -3, 4, -2, -5, -15,
    -13, -19, -29, -31, 3, 22, 15, -23,
    -10, 43, -26, 0, 4, 24, 26, -56,
    18, 17, -5, -36, 13, 14, -21, -23,
    -11, -10, -2, 7, -10, 9, -5, 0,
    1, -21, -89, 1, -9, 16, -30, 3,
    -41, -2, -9, 15, 15, -38, 27, -5,
    -2, -25, -11, -11, 9, 22, 13, -8,
    -16, -15, -24, 13, -1, -4, -2, 3,
    5, 4, -48, -2, -32, 0, -2, 6,
    -20, -5, -33, 27, -14, 1, -16, 13,
    -14, 26, 21, -29, 14, 15, -29, 21,
    -42, -10, 25, -9, 4, 5, 4, 1,
    -32, -12, 46, 63, 8, -25, 3, -7,
    6, 56, 3, -1, -28, -11, 40, -22,
    14, -1, -18, -4, -16, -3, -15, 0,
    -35, 22, -51, -25, 1, 2, -11, 17,
    -15, -10, -37, 38, -10, -10, -19, 69,
    21, 47, 20, -13, 0, -15, -25, -5,
    -24, -20, 0, -25, -24, -55, -14, 36,
    -4, -25, -17, -10, 7, -1, -3, 4,
    -18, -6, 13, 0, 2, -3, -1, 0,
    -1, 16, -20, -11, -42, -30, -6, 29,
    -22, -57, 47, -36, -6, 17, 8, -27,
    -12, -9, 0, 8, -9, -17, 7, -7,
    47, 9, -1, 37, -6, 22, 14, -27,
    30, 13, -26, -17, 50, -7, -55, 22,
    6, 12, 6, 4, -36, -1, 3, 0,
    13, -21, -3, -16, 17, -11, -12, 23,
    64, 11, 2, 50, -22, 0, 62, 1,
    50, 28, 1, 29, 12, -38, 7, -26,
    26, -4, 11, -10, -28, 34, 6, 24,
    18, -20, -20, -16, 9, -4, -12, -38,
    -21, -28, 1, -2, -6, 6, -13, -19,
    23, 1, 19, 18, -11, 3, -50, 22,
    2, -6, 10, 22, 22, -12, 52, -27,
    0, 0, -22, 15, -5, -8, 5, 1,
    14, -28, -38, 43, 20, 48, 46, -49,
    -13, -17, 43, -25, -19, 13, 9, -8,
    -8, 9, -12, 11, -12, 10, 20, -2,
    31, 11, -32, -25, 11, 4, -4, -4,
    32, 40, -39, 35, 21, 8, -5, -10,
    17, 36, 21, 8, -15, 85, 42, 2,
    12, -5, -6, -22, 2, -13, -14, 14,
    43, 40, 17, -16, 15, 1, -7, 19,
    -35, 55, -37, -4, -36, 13, 24, 22,
    47, -36, -6, 28, -79, 34, 58, 28,
    -10, 27, 9, 14, 41, 4, 12, 0,
    -21, 3, -8, 17, 1, -1, -3, 1,
    -15, 11, 31, -12, -9, -14, 31, -41,
    -35, -62, -30, -10, 70, 48, -33, -4,
    25, -4, 28, -11, -52, 2, -42, -25,
    -35, 13, -2, -20, 7, 5, -13, 7,
    -51, -47, -32, 7, 16, -1, -11, -42,
    -6, -2, -40, -14, 21, -11, -9, -23,
    31, 2, -21, -11, -23, -11, 9, 36,
    -11, -3, -12, 2, 15, -8, -15, -16,
    -40, -25, -54, -16, 34, 25, -7, 18,
    16, -1, 4, 3, 13, -13, -47, 22,
    7, -22, 2, 5, 20, 9, 3, 0,
    -8, 11, 14, 8, 8, -12, 12, -4,
    54, 2, -8, 15, -14, 8, -19, -57,
    9, -14, 1, 0, -2, -54, 22, -23,
    43, 6, 12, -9, 9, 28, -18, -9,
    -4, -8, 4, -21, -19, -12, -4, 1,
    14, -2, 14, -52, 44, -27, 21, 29,
    -34, -4, -12, -35, -26, 4, 66, -57,
    -9, 1, 18, -31, 11, 1, -10, 7,
    -1, -18, 9, 9, -1, -7, -10, 12,
    -3, 26, -7, 14, 5, 2, 8, 11,
    22, -12, 10, -27, 0, 67, 10, -29,
    -11, -16, -1, -4, -12, -20, 22, -61,
    -9, -16, -17, -14, 9, -11, -7, -1,
    -47, 12, 10, 10, -36, 11, 12, -22,
    -12, -31, 6, 29, -20, 27, -11, 49,
    15, 26, -6, 28, -2, -8, 23, -7,
    9, 6, 13, 4, -8, 6, 0, -12,
    -16, -9, -35, -17, 8, -18, 53, 14,
    29, 6, -32, 15, 8, 18, 5, 41,
    31, 50, -12, -10, 13, -9, -26, 8,
    39, -7, 12, 11, 1, -3, 5, 8,
    11, 32, 10, 28, 18, 18, 1, -6,
    13, 5, 34, 5, 7, -3, -27, -21,
    -14, -22, -29, 39, 8, 19, -14, 20,
    12, 29, 12, -8, -1, -6, 9, -27,
    1, 40, -38, -25, -5, 26, -14, -31,
    -17, -34, -18, 8, 60, 33, -32, 42,
    -21, -5, -12, 10, 17, -19, 23, -5,
    -12, 0, 0, 11, 2, 1, 1, 14,
    -40, -19, 5, 7, 16, 1, 36, -4,
    -25, -36, 0, 27, -86, 10, -10, -13,
    6, -23, 49, -60, 73, 8, 1, -19,
    4, 26, 6, -6, -32, 1, -2, 2,
    14, -15, 13, -29, -4, 13, 35, -6,
    7, 1, 6, -7, 10, -9, -18, -2,
    22, 25, 2, 2, 32, -14, -25, -28,
    7, -34, -5, -6, 29, 3, 0, -19,
    41, 26, 23, 15, 26, -24, -38, -9,
    50, -43, 73, -9, 36, 35, -51, 39,
    -14, -5, -1, -9, 7, -8, -32, 5,
    -7, -19, -4, 3, -7, -17, 23, -9,
    -20, -51, -25, 1, -1, -19, 21, 18,
    -17, -59, 56, 7, 15, -4, 99, 19,
    14, -29, 22, -35, -17, 3, -28, 21,
    30, -22, 1, -2, 5, 5, -8, -14,
    -2, 2, 10, -16, -38, -3, -16, 12,
    -24, 14, 51, -20, -42, 40, 1, 17,
    8, -24, -54, -21, 23, 3, 2, -19,
    31, 5, -42, -10, 2, 4, -5, -7,
    24, 11, -39, -8, 5, 18, 6, -2,
    -4, 5, 1, 20, 21, 30, -54, 1,
    19, 3, 26, 18, 19, -15, -18, -11,
    -25, -9, -3, -15, -9, -4, -9, 2,
    7, 1, 12, 17, 7, -5, 31, -22,
    -3, 37, 3, 8, -40, -20, -34, 4,
    0, 0, 20, 10, 47, -26, -10, 23,
    -4, -27, 0, 1, -6, -17, -7, 2,
    22, -11, -42, 33, -16, -16, 22, -8,
    -14, -2, -21, -4, -14, -27, -16, -16,
    -14, 16, -6, -17, 40, 20, -11, 7,
    24, 31, -13, -15, 0, -8, 3, 0,
    -43, 8, 6, -3, -21, -7, 14, 16,
    22, 10, 20, 9, -7, -21, 15, 12,
    21, 10, 2, 48, -3, -3, 20, 18,
    22, -4, 28, 4, 1, 7, -7, -2,
    6, 37, 15, 45, -35, 16, -14, 41,
    25, 4, -18, -2, -11, -38, -6, -55,
    5, 10, -41, -16, -3, 6, 48, 1,
    -5, -20, -37, 26, 3, 3, -2, 0,
    12, -9, -10, -40, 4, 51, 39, -24,
    53, 28, -11, 4, -26, 6, 21, 0,
    13, -26, -29, -7, -3, 14, 19, -1,
    -1, -21, -13, -9, -7, 12, -7, -18,
    6, 19, -20, -54, -70, 7, -28, -24,
    -34, -4, -45, -9, 46, -5, -23, -32,
    -18, -20, -29, 14, 1, -26, -21, 5,
    -5, -23, -24, 3, -3, 4, 4, -3,
    17, 6, -13, -17, -26, 16, -14, 8,
    10, -3, 6, -21, 41, 27, -28, 7,
    -2, 23, 42, -56, -37, 11, 9, 33,
    19, -4, -18, -5, 4, 2, -1, 6,
    3, -26, -24, 14, -13, -28, -5, 21,
    -42, 14, -26, -9, -21, 4, -53, -7,
    -9, 2, -19, -20, -3, -25, -12, -53,
    -32, 21, -20, -8, 6, 4, 5, 17,
    -12, 21, 33, 32, 37, -35, -6, 102,
    23, -2, -18, -68, -19, 23, 83, -14,
    28, 17, -1, 13, 2, -11, 28, 3,
    35, 44, 38, -10, 9, -31, -8, 6,
    -5, 22, 2, -43, 0, -41, -15, 34,
    -23, -1, -11, 4, 16, 0, -31, 46,
    -41, -88, 68, -31, -24, -3, 33, 22,
    33, 9, 32, 10, -13, -12, 15, -24,
    36, -32, 41, 3, 21, -29, 14, -66,
    -42, -22, 3, -29, -8, -37, 38, -60,
    43, 2, 0, 30, 47, -13, -68, -32,
    -50, -39, -9, -2, 34, -33, 0, 43,
    -56, -17, 18, 50, 9, -53, 55, -8,
    10, -18, 5, 9, 29, -1, -21, -31,
    32, -23, 27, -27, 34, -19, 15, -53,
    -60, 17, -1, 4, 24, -6, -47, -82,
    31, -15, 38, 13, 32, 9, -18, 10,
    -43, 14, -6, 14, 27, -4, 67, -11,
    16, 0, -6, -28, 21, 4, -93, 45,
    1, -7, -77, 15, -4, -11, 29, 13,
    8, 37, -4, 27, 80, 49, 112, -71,
    -43, 56, -52, 3, 20, 12, -5, 40,
    -27, 18, -21, 7, -29, -25, 10, 9,
    -49, 14, -13, -39, 8, 17, -3, -2,
    11, 56, -29, -22, 32, 3, -20, 2,
    11, -52, 31, -13, -4, 54, -53, 5,
    28, -18, 88, -42, 11, 9, 23, -4,
    46, -21, 26, 41, 38, 17, -18, 31,
    6, -8, 72, -23, -31, -37, 11, 22,
    11, 49, 5, -57, 77, -55, -39, 1,
    -34, 23, -11, -12, -5, -3, -25, 61,
    50, 5, -14, -3, 0, 12, 6, 15,
    31, -8, 65, 14, -53, 3, 19, -102,
    41, 24, -21, 1, 11, 50, 4, -24,
    -22, 45, -3, 0, 2, 40, 38, 25,
    16, 0, -30, -6, -3, -16, -30, 2,
    -23, 92, 60, 39, 37, 24, 37, -60,
    30, 36, -13, 3, -77, 42, -42, 23,
    -8, 21, 12, -15, -17, -18, -33, -32,
    -1, 122, 4, 32, 38, 1, -5, -39,
    -59, 24, 11, -10, 15, 33, 2, 25,
    -17, -8, -16, -17, -95, 51, 52, -32,
    26, 2, -18, 3, 15, -24, -5, -18,
    36, 36, -48, 6, 4, -14, 32, -23,
    -6, 15, 18, 39, -51, -2, 63, -56,
    -45, 16, -14, -21, 23, -33, -74, 31,
    38, -10, 24, -17, 0, 53, -26, 0,
    8, 57, -31, 13, -34, -27, -12, 9,
    -33, 64, -7, -16, 109, -15, 41, 33,
    46, 35, -31, 88, -7, 29, 26, 103,
    14, 7, -7, -1, 12, 42, 23, -15,
    39, -17, -31, -49, 12, -31, 13, 4,
    28, -23, 35, -18, 16, 25, 31, 20,
    9, -2, -14, 66, 10, -75, -33, 66,
    5, 2, 7, 51, -2, 9, 11, 19,
    45, -7, -18, -4, 26, 13, -8, 6,
    -65, -64, -54, -3, -85, 27, 30, 2,
    -2, -101, -24, -11, -26, 62, 19, -19,
    -6, -23, -39, -25, -46, 37, -20, 22,
    -31, 27, -2, -5, -15, 5, 8, 6,
    -27, -29, -6, 33, 66, -29, 111, 16,
    -24, -19, 38, -63, 19, 9, 80, 3,
    -13, 48, 3, -36, 22, 2, 78, -20,
    27, -18, -2, -12, 2, 8, 13, 20,
    70, 40, 11, -64, 18, -1, 20, -40,
    38, -35, -29, -2, 29, -8, 21, 24,
    -43, 29, -6, 19, -29, -22, -38, -5,
    58, 4, 16, -10, 11, -3, -22, -27,
    -55, -52, 30, -4, 4, 43, -18, -5,
    -16, -17, 31, -12, 18, 100, 9, 9,
    -46, 6, -27, -1, -20, -13, -18, 3,
    -7, -5, 29, -34, -9, 9, 24, 18,
    -82, 121, 33, -14, 49, 35, 80, -12,
    70, 12, -26, 29, 59, 23, -65, -13,
    -21, 39, 22, -103, -82, -47, -20, -6,
    59, 70, 45, 3, -55, 8, 9, 9,
    5, 87, 33, 26, -11, 13, 64, -10,
    -20, 0, 24, -28, 48, -19, -9, 73,
    32, 43, 13, 31, -11, -10, 13, -19,
    1, 66, -11, 18, 31, -8, 26, -7,
    -40, 14, -27, -7, 36, -43, -27, -1,
    -12, -34, -8, -8, 62, -47, 6, -12,
    -47, -39, 19, -9, -29, -15, 73, 1,
    -49, 13, 20, 20, 28, -28, 43, -16,
    4, -15, 45, 48, 12, 13, 24, -9,
    -3, -61, -30, 1, 9, 11, -122, -7,
    25, 4, -37, -34, 19, 34, -25, 52,
    9, 14, -33, -17, 3, 5, -17, -22,
    7, -24, 2, 19, -66, 4, -23, 69,
    62, 29, 69, -40, -21, 47, -55, 7,
    -20, -5, -43, 22, 29, -27, -58, 6,
    -39, 2, -70, 19, 8, -6, -7, -14,
    -15, 46, 41, 11, 15, 41, 3, 31,
    -12, -8, -21, -21, -16, -2, 20, -55,
    19, 14, 55, 5, -8, -36, 4, 15,
    0, -22, 17, 7, -10, 24, -6, 9,
    16, 20, -20, 38, 24, 5, -4, -85,
    24, -30, -24, 10, 41, -2, -16, -15,
    -9, 2, 6, -21, -44, 55, -12, 5,
    1, 17, 22, 0, -16, -26, -11, 11,
    -19, -35, 16, 13, -10, -68, 21, -4,
    29, -16, 43, -44, -10, -88, 53, -64,
    -31, 5, -3, -5, -68, -32, -37, -22,
    -59, -4, 7, -2, -23, -27, 17, 14,
    -11, 22, 42, 11, -25, 12, 6, 8,
    -21, 10, -20, 11, -23, -37, -76, 13,
    31, 38, 19, 38, 18, -41, -48, 19,
    7, 11, -59, -7, 15, 11, 1, 6,
    -28, 61, -11, -6, -52, 8, 15, -14,
    53, -16, 43, 0, 85, 16, 6, -26,
    0, 69, -23, -22, 43, 7, 26, 21,
    38, 18, 27, -18, 2, 5, -7, -16,
    -36, 15, 3, 42, -6, 34, 45, -26,
    22, 35, 4, 35, -2, 38, -29, 16,
    41, -19, -37, -25, -2, -4, -55, 21,
    16, -3, -18, -16, -18, 16, -6, 3,
    64, 22, 60, 55, -74, -7, 15, 10,
    85, 42, 25, -21, -37, 10, 16, 38,
    -4, -36, -42, -25, -14, -14, -30, 58,
    -3, 39, 32, -29, -4, 10, 4, 7,
    3, 8, 7, 5, -50, -5, 0, 4,
    -29, -12, -30, -99, -38, -42, 23, 28,
    -25, 24, 35, -116, 23, -13, -20, -5,
    33, 0, -18, 7, -9, -8, 3, 2,
    -28, 19, -38, -3, -13, -64, 5, 19,
    26, -56, 17, -3, 78, 37, -31, -10,
    -28, 0, 12, -1, 48, 46, -6, 121,
    37, -4, 25, 14, 18, -12, -20, 12,
    6, 10, 13, 34, 21, 8, -3, 9,
    -16, 8, 25, 2, -8, -3, 4, 0,
    24, 3, -4, -10, 35, 37, -10, 6,
    -36, 59, 12, -57, -10, -38, 33, -33,
    -27, -17, -20, 16, 13, -5, -2, 2,
    -6, 9, -5, -1, 2, 17, -8, -3,
    -9, -11, -18, 8, 4, 35, 31, 15,
    -4, 7, -3, -5, -7, -1, -17, 8,
    -16, 24, -6, -5, -9, -13, -19, 16,
    -22, 6, 15, 4, -5, -7, 9, -3,
    -1, 0, 4, 9, 7, 18, -20, -19,
    14, -31, -21, -28, 22, 25, 3, 0,
    -4, -7, 19, -15, -23, -13, 14, -6,
    12, 7, 23, 6, -12, 12, 2, 2,
    16, -17, 29, 13, -9, -28, 26, -30,
    43, -27, -24, 3, 4, 3, 0, -27,
    -16, -40, 16, 7, 1, 9, 7, 6,
    -7, -10, -4, -11, 4, -2, 2, -5,
    -4, -1, 8, -6, 0, -24, 13, -12,
    23, 4, -24, 10, -12, -8, -36, -21,
    33, 10, 8, -38, 15, -3, 8, 6,
    -17, 3, 2, 27, -3, 2, 7, 5,
    -11, -2, -27, -6, -18, -5, 2, 9,
    -8, -17, 5, -14, 37, 12, -3, -13,
    16, 9, -19, 15, 9, -20, 17, 2,
    -17, 6, -3, -14, 0, -8, 20, 6,
    6, -14, 20, 3, 22, -34, -32, 34,
    2, 4, 63, 30, 18, -6, -4, -13,
    8, 15, -9, 5, -11, -2, 14, -9,
    -4, 12, -9, 16, 0, -6, 2, -5,
    -7, 12, -8, -9, -13, 32, 13, -12,
    -38, 24, -70, -59, 10, -16, -14, -4,
    23, 5, 22, 15, -22, 4, 0, 9,
    -38, 28, -9, -22, 5, -13, -12, 0,
    8, -3, 83, 31, 33, 8, -4, 1,
    -32, 0, 0, 4, -35, -16, 10, 17,
    31, 2, -7, 20, 2, -1, 13, -1,
    -27, 4, -18, 11, 3, 32, 0, -4,
    12, 0, 37, 1, -12, 16, 13, -38,
    -8, 3, 52, -26, 22, -13, 18, -16,
    11, -10, -6, -26, 8, 0, -10, 7,
    -51, 10, 5, 25, 2, -11, -6, 16,
    -20, 3, -28, -19, -53, 27, -3, -4,
    -14, 9, -56, -54, 22, -1, 3, 4,
    -23, 49, -13, -35, -26, 15, -4, 12,
    -3, -5, -9, 10, 2, 7, 11, 10,
    -3, 22, -33, 5, -8, 17, -21, -24,
    -3, -3, -21, 40, 8, -4, -17, -37,
    1, -34, -26, 12, -14, 1, -6, -11,
    31, -3, 7, -19, -5, 9, 6, -8,
    -10, -28, -20, -24, -16, 37, -2, 42,
    2, 25, 1, -1, -31, 38, 14, 4,
    14, 14, 2, -34, -6, 6, 12, 18,
    -17, -8, 8, -10, -1, 6, -7, 1,
    -12, -18, 9, -13, -19, 37, -23, 21,
    37, 12, 14, 37, 8, 14, 0, -29,
    -3, 23, 36, 70, 2, -11, 8, -17,
    -11, -2, -3, -1, -9, 1, -5, -7,
    -2, -12, 26, -5, -14, -15, 19, -8,
    -15, -20, 10, -38, -18, -44, 7, 19,
    17, 18, 17, -37, 2, 10, 6, -18,
    -23, 3, -24, 2, -5, 4, -11, -14,
    13, 5, -3, -24, -24, -37, -18, -36,
    -50, -26, -22, -14, -27, -9, -32, -16,
    -18, -16, -19, 21, -10, 8, -25, -8,
    8, 22, -15, 13, 3, 5, -6, 1,
    0, -22, -18, -10, 41, -5, -3, 35,
    14, -15, 14, -21, 4, -22, -11, 18,
    -7, -67, -17, -30, 6, 7, 8, -18,
    10, -12, 11, -13, 4, 5, 10, -3,
    -24, 4, 11, -8, -9, -31, -2, 0,
    -29, 9, -19, -3, -12, 27, 35, -12,
    32, -38, -12, -13, 27, -39, 9, 4,
    15, -3, 24, -8, 5, 46, 5, -1,
    23, -20, 2, 9, 33, -36, -27, 5,
    -23, 14, 16, 1, -21, 0, 9, 3,
    -9, -21, -1, -20, -1, -8, 3, 1,
    -18, -23, -9, 9, 0, 6, -6, -6,
    -9, 10, -5, -16, -11, -1, 19, 15,
    -17, 19, 21, -10, -13, -27, -14, -3,
    -7, 21, 3, -28, -6, -1, -14, 4,
    -3, 15, -25, -21, -37, -12, 6, 4,
    -29, 22, 3, 4, 26, 32, -24, 1,
    6, 22, 28, 16, -17, -22, 3, -24,
    -13, -16, 10, 17, 5, 0, 22, 0,
    15, -7, -3, -1, -11, 4, 6, 6,
    -2, 13, 4, -4, 12, -21, -9, -11,
    20, 9, 5, -30, 0, 9, -10, -4,
    -12, 53, 21, -25, 6, -7, 4, -4,
    10, -15, 13, 14, -5, -7, 12, -1,
    16, 13, 7, -31, 3, -25, 29, 26,
    -21, 20, 49, -22, -3, 4, -2, -1,
    12, -12, 11, 41, 6, -8, 0, 1,
    -5, -22, -13, -10, 4, -4, -9, -13,
    -6, 10, -1, 8, 12, -7, -41, 42,
    28, -23, 3, 3, -18, 5, 3, -11,
    29, -10, 41, -11, -9, -7, 3, -6,
    -14, 27, 8, -3, -4, 15, 6, -1,
    18, 30, -7, 5, 21, 13, 29, 8,
    -72, 48, -4, 25, -47, -8, 22, -33,
    -23, 27, -17, -3, 1, 7, 0, 37,
    7, 20, 11, 8, -1, -4, -8, -9,
    -17, 25, -17, -6, -25, 7, -13, 27,
    12, -35, -14, -26, 39, -2, -17, -8,
    37, -36, -34, -19, -4, -14, -16, -12,
    -6, 3, 8, 10, -9, 8, -9, 4,
    23, -17, -6, -11, -30, -14, -20, -15,
    0, 22, -47, -7, 15, 37, -11, 15,
    -18, 17, 20, -1, -11, 5, -11, -24,
    -6, -3, -14, 22, 5, 0, 5, 2,
    6, -32, 9, 17, -7, -3, -33, 9,
    -20, -18, -19, -52, 17, -39, 23, -29,
    -4, -18, -15, -9, -24, 22, 5, -5,
    -1, -7, 9, 5, 16, -45, 5, 1,
    10, 1, 23, -25, -26, 27, 2, -6,
    2, -13, -33, -18, -19, 18, 8, 0,
    15, -4, -3, -2, 16, -2, 4, 8,
    2, 11, 8, 5, 1, 8, 7, 1,
    -20, -7, 8, -3, 1, 14, 17, -13,
    35, 25, 40, -26, 17, 2, -7, 10,
    -22, -17, 59, -18, -2, 0, -1, -2,
    -11, 7, -3, -22, 7, -6, -4, 2,
    -2, -1, -11, 32, 18, -18, -23, 15,
    -20, -6, -15, 50, 63, -8, -2, -6,
    2, -40, -7, -17, -1, -10, 10, 6,
    7, 23, -1, -14, 5, -4, 0, 9,
    0, -8, 14, -5, 12, 26, -23, 12,
    -24, -26, 8, 4, -19, -53, -1, 39,
    3, -1, 8, -16, -4, -26, 28, 23,
    -26, 21, 30, -15, -13, -20, -5, 2,
    -15, 13, 1, -36, 7, -32, 22, -34,
    -21, 36, -11, 14, -16, -24, 8, -12,
    -17, -36, 3, -55, 23, -15, -4, 46,
    -3, 12, -9, 34, 3, 17, -7, 9,
    -10, 7, -35, 21, -1, 40, 7, -6,
    0, 16, -28, -32, 38, -4, -15, 78,
    12, 11, 26, -11, -11, -6, -14, 33,
    -2, 17, 6, -13, -6, -6, 7, 3,
    -17, 7, 28, 14, -24, -35, -11, -32,
    8, -3, 13, 0, 3, -21, 6, 16,
    -6, -33, -4, -9, -23, -5, -9, -28,
    -3, 13, 18, -24, -22, 15, 4, 6,
    -14, 29, 5, 28, -23, -2, 13, 57,
    20, 4, 43, 1, 11, 14, 37, 26,
    -17, -7, 8, 10, 6, -4, 18, 19,
    -29, -9, 10, 27, 5, 1, 5, -1,
    -37, 14, -7, -28, 24, 0, -1, -31,
    22, -26, -13, -27, 45, -20, 34, -2,
    -40, -4, -1, -29, 28, -3, 20, -1,
    -11, 1, -15, 31, 14, 1, 10, 13,
    21, 2, 21, 7, 0, 31, 89, -14,
    -52, -21, -7, 2, 3, 21, 20, 17,
    24, 24, 25, -33, 26, -18, -24, 12,
    -2, 2, -2, 7, -6, -3, 7, 6,
    19, 10, 8, 28, -54, -25, -51, -29,
    -16, 3, 97, 28, 30, -2, -60, -18,
    10, -6, 16, 22, -9, -2, -27, 17,
    5, 13, -23, -7, -9, -25, 8, 14,
    6, -58, 14, -10, 16, 19, -15, 32,
    -7, 5, -12, -59, 8, -17, 15, 41,
    0, 9, 50, 9, 38, 5, -6, 7,
    -64, 26, -8, -19, 3, -11, -11, -3,
    -47, 3, -51, 8, 6, -81, 29, -15,
    30, 42, -4, 18, -23, -46, 45, 17,
    31, 6, 8, 6, 4, -10, -7, 2,
    -30, 8, -19, 18, 4, 55, 15, 8,
    12, 42, 10, 23, 7, 12, 26, -28,
    -33, 3, -8, 8, -43, 61, -14, 24,
    65, 11, 19, 19, 1, -4, -13, -15,
    -98, 14, -6, 23, 10, -6, -10, 13,
    -27, 0, 3, 3, 29, 20, -8, 40,
    34, 44, -46, -33, 26, 9, -34, -20,
    11, 0, -37, -16, -17, 34, 29, 5,
    -7, -16, -17, 4, -8, 7, -9, 15,
    -29, 14, 4, -16, 17, 1, 13, -29,
    -8, 27, -35, -1, 3, 29, -25, -11,
    -36, -17, 15, 18, -9, 19, 10, -46,
    18, -10, 14, -11, 4, 5, -7, -5,
    -2, 51, 0, 26, 21, 51, 2, 10,
    -27, 13, -10, 11, 13, -3, -16, 40,
    14, -7, 15, -9, -8, 5, 0, 24,
    -11, -22, -12, -15, -5, 2, 0, 8,
    12, 9, -9, -25, 47, -13, 1, -9,
    -10, 30, 2, 17, -11, 10, 3, 10,
    -13, 13, -3, 27, 23, 10, 10, -8,
    0, -9, -7, 6, -2, 1, -12, 1,
    16, 15, 9, -12, -10, 25, -37, 7,
    -47, 43, -8, -40, 19, -4, 13, 3,
    35, 5, 8, -25, -22, 9, 0, -13,
    -13, 23, -81, -10, -6, 6, -10, -12,
    -1, 14, -8, 1, 0, -12, -8, -13,
    -27, -12, 11, 9, -18, 6, -19, -9,
    -24, -8, -10, -23, -8, 26, -34, 15,
    0, 23, 16, 20, -3, 2, -7, 0,
    7, -1, 8, -26, 23, -17, -25, -11,
    2, -9, -22, -17, 33, -75, -5, 10,
    -4, 15, -20, 9, -26, 28, 16, -16,
    40, -39, -2, -21, 18, -3, 1, -4,
    14, 18, 11, 0, 19, -17, -43, 59,
    -25, -17, -2, -53, 33, 4, -31, 38,
    -3, 50, -1, -22, 4, -3, 33, -6,
    -6, 6, 22, -2, -2, 78, -1, -2,
    -9, 9, 4, 10, -20, 15, 19, 21,
    1, 6, 19, 38, 5, 107, 16, -1,
    -26, -62, -13, -25, 5, 8, 3, 8,
    2, -17, -17, 0, 3, 13, -8, -4,
    8, -16, -17, 23, -33, 3, -4, 26,
    -32, -16, -11, 6, -12, 3, -14, -61,
    -78, -23, 19, -9, -25, 17, -19, -3,
    -18, 32, -47, -20, -57, -2, 1, -1,
    -1, 22, 25, -2, -5, 10, -28, -4,
    8, 20, 32, 9, -64, -27, -6, 2,
    14, -20, 11, 13, 4, 18, 17, 0,
    -7, 3, 12, -32, -9, 8, 15, 1,
    -8, -22, 9, 4, -3, -22, -5, 26,
    -3, -24, 3, 5, 6, 15, 5, -4,
    53, 37, 14, -14, 26, -18, -10, -46,
    -3, 3, 5, 16, 4, -4, 27, -3,
    23, -17, -23, -17, -4, 0, -11, -18,
    -46, -16, -5, -1, 5, 13, 16, 21,
    -9, 3, 21, 11, -21, -15, 17, 22,
    -25, -31, -46, -10, -5, 0, -25, -14,
    -15, -12, -3, -26, -24, 17, 7, -1,
    5, -26, -54, -1, -4, -13, -9, -1,
    33, -23, 24, 20, -1, -12, 6, -28,
    -27, 37, -12, 15, 6, 8, 12, 13,
    8, 12, -15, 5, -6, -62, -34, 4,
    -32, 20, 13, -8, -4, 6, 4, 12,
    13, 24, -18, 10, -13, 21, -2, 46,
    -23, 39, -11, 0, 0, 3, -8, -4,
    29, -6, 26, 2, 11, 46, 16, -20,
    8, -13, -20, 7, -6, -30, -2, -4,
    32, -3, -29, -24, 5, -28, -9, -6,
    -22, 2, -3, 9, -3, -3, 0, 4,
    14, -5, 16, -12, 5, 15, -14, 3,
    4, -8, -34, -8, 0, -21, 11, 13,
    -5, -2, 15, -4, 31, 4, -40, -15,
    3, 12, 6, 50, 1, 4, 5, -1,
    -15, -49, 12, -12, -10, 2, 36, -1,
    -9, -14, 38, -46, 2, 36, 60, -1,
    14, -38, -24, -5, -13, 23, -4, 8,
    -6, -22, 0, 13, 15, -44, 8, 1,
    -1, 4, 15, -13, 5, 31, 21, -3,
    -14, 12, -9, 23, -31, 9, 6, -9,
    -10, -7, -9, 5, 7, 11, -9, 4,
    15, 13, -3, 23, 23, 12, 4, -4,
    1, 15, 15, -43, 32, 0, -14, -31,
    17, -27, 21, -11, 7, 42, -26, -9,
    -34, -5, 5, -34, -3, -7, -46, 3,
    -39, 15, -21, -13, -1, -3, -10, -10,
    -2, -4, 24, 28, -22, -1, -7, 31,
    -9, 28, 0, 28, -36, 13, -50, -3,
    23, -19, 16, -23, 7, -17, 26, 1,
    7, 2, 15, -2, 9, 5, 4, 10,
    -35, 8, -4, 45, 18, -25, 25, -17,
    31, -1, 18, -4, 14, 2, 13, 5,
    -3, -32, 11, 61, 3, -69, 25, 26,
    -6, 33, 31, -21, -15, -19, -6, 13,
    41, 33, -9, 11, 2, -14, -91, -38,
    -11, -8, -25, 8, 14, 41, -40, -13,
    23, -17, 27, -41, 22, -19, -4, 23,
    -25, 18, 14, 38, -2, 16, -13, -11,
    -14, -1, 44, -65, -27, -12, 11, 3,
    -18, 23, 22, 19, -15, 27, -1, -100,
    -19, 53, 14, -75, -22, -17, 16, 75,
    -18, 33, 7, -15, -2, -11, 14, 1,
    21, 2, 20, -1, 25, -28, 26, 46,
    -10, -56, 4, -8, 21, -10, -27, -49,
    -32, -43, 41, -23, -10, 19, 43, -58,
    -5, 21, 24, -40, -29, 17, 1, 6,
    -19, -12, -18, -47, 5, -2, -37, -19,
    43, -40, 21, -16, -51, 26, 2, 66,
    64, -58, 18, -9, -20, 10, 7, -18,
    -33, -10, 21, 7, 15, -1, -2, -6,
    34, 34, -39, -13, 9, 26, 27, 41,
    60, 4, 2, 17, -39, -10, -31, 32,
    -20, -2, 13, -22, 32, -5, -4, -35,
    -45, 2, -10, 46, 7, 1, 8, 7,
    -3, 17, 33, 2, 69, -2, 6, -45,
    7, 14, -34, -12, -9, 7, -10, -15,
    54, 4, -90, 47, 10, -8, -20, 8,
    4, 5, 2, -24, -6, 5, 11, 15,
    -14, 33, 83, 12, -57, 65, 4, -6,
    32, -9, 72, -29, -20, -3, 14, 38,
    40, 70, -12, 32, -17, 9, -58, -14,
    3, 45, -13, -16, -3, -23, 9, -2,
    -71, 71, 6, 0, -52, 30, 6, -2,
    -43, -3, -4, 15, 15, 68, -26, -94,
    44, 44, 27, 3, -16, 58, 6, 39,
    -83, 32, 8, -28, -2, -15, -16, 6,
    17, 11, 26, -6, -69, 19, -7, 12,
    -44, 33, 7, -40, 26, -34, -33, -44,
    72, -44, 38, -1, 22, 13, 5, 21,
    -19, 16, -62, 4, 6, 94, 21, 13,
    44, -27, -14, 6, -39, -49, -22, 52,
    -15, 15, 15, 2, -24, -105, -67, 19,
    -9, -43, 4, 1, -12, -8, -27, -30,
    -105, 21, -8, 40, 9, 1, -12, 4,
    -18, 33, 18, -2, -21, 16, -9, 65,
    45, 64, -14, 16, 32, 20, 30, 5,
    6, 22, -48, 28, -41, 45, 55, -28,
    12, 18, -33, 14, -7, 15, -3, 2,
    -22, -8, -9, 12, 14, -57, -12, 44,
    34, 21, 16, -12, -7, 24, 51, 6,
    -34, 36, -28, -12, -38, 1, 11, -53,
    22, -18, 49, -39, 1, -1, 6, -24,
    5, 4, -3, 8, -3, -16, -12, -24,
    31, 73, -20, -44, -41, -27, 52, 27,
    -17, -32, -16, -10, -9, 29, 6, 63,
    5, 12, -24, -34, -1, 9, 4, 1,
    7, 10, -34, 6, 28, 11, -3, 48,
    -53, 19, -50, 52, 10, 30, 27, -17,
    3, -7, -12, 24, 60, 9, 16, -18,
    -37, -6, -2, -7, -10, 6, -16, 0,
    -2, -42, -52, -27, 24, -47, -21, 16,
    -29, 22, -25, 8, 0, -6, -26, -89,
    10, 3, -38, -17, -27, 6, 2, 7,
    -35, 25, -123, -6, -9, 6, -10, -17,
    -26, 24, 24, 12, 52, -1, -35, 55,
    19, -4, 53, 46, 60, 14, 59, -38,
    6, -16, 20, -45, -18, 57, -53, 13,
    -6, 16, 11, 43, -7, 13, -10, -11,
    30, 32, 8, -18, -15, 63, 31, 9,
    0, 11, 15, 27, 13, 30, -24, -40,
    -81, -48, 38, -4, -73, -7, 36, 0,
    61, -48, 1, -66, 8, -2, 9, -4,
    16, -15, 5, -4, -27, 1, -30, -24,
    20, 16, 10, 22, -33, -31, -1, 13,
    67, 51, -6, -14, 23, -16, 41, -13,
    -11, -4, 56, -8, 8, 121, 3, 4,
    -6, 56, 16, 4, -20, 20, 52, 11,
    -11, 37, -5, 14, -18, 8, 36, 24,
    -27, -37, -11, -28, 9, -8, -25, -6,
    -9, -13, -48, 40, -2, 19, -1, 1,
    57, -8, -6, -9, -71, -37, -27, 11,
    30, -38, -39, -10, 19, -67, 55, 59,
    -69, -15, 41, -30, 15, 12, -12, -6,
    -20, 21, -50, -20, -66, 2, -1, 0,
    -1, -17, 15, 0, -15, 33, 33, 26,
    40, 14, -16, 13, 56, 5, -10, -21,
    -35, 65, -13, -41, -2, -18, 18, -26,
    -14, -3, -3, -23, -15, -2, 10, 9,
    -5, 0, -72, -19, -37, -18, -56, 2,
    13, 22, 11, -2, 24, -44, 13, -12,
    -22, 44, 2, 62, 48, -41, -36, -65,
    4, 17, -9, 11, 5, -4, 38, -16,
    -18, -5, -126, -3, -4, 45, -71, -13,
    1, -23, -72, -43, 2, 21, -40, 13,
    4, -1, 38, 1, -20, 7, 37, 92,
    -29, -50, -64, -18, -6, -4, -30, -9,
    -18, -36, -6, -11, -64, -12, -35, -32,
    -34, 6, 14, -24, -9, 21, 38, 2,
    43, -17, 52, 17, 6, 5, 30, -71,
    -28, 71, 8, 21, 21, 19, 17, -9,
    6, 6, -22, -52, -15, 35, -51, 39,
    -70, -57, 37, -83, -1, 30, 51, 27,
    -10, -53, -5, 9, -35, 52, -11, 86,
    -13, 49, -37, -35, -15, 0, -12, -1,
    -9, 47, 14, 25, 10, -4, -51, -30,
    17, -58, -36, 25, 5, -1, 53, 0,
    12, -26, -12, -52, -19, -46, 15, -5,
    -11, 14, -4, 7, -7, -9, -9, 0,
    -21, 10, 5, -6, -7, 45, 21, 30,
    1, -17, 27, -4, -41, -24, -17, 28,
    5, -34, 37, 45, 16, -4, -55, -20,
    -3, 10, 20, 74, 3, 17, -3, 3,
    -32, -42, -3, -4, -6, 8, 3, -26,
    -15, 19, -35, 34, -45, 42, -78, 7,
    18, -35, 45, -14, -22, 8, -6, 32,
    34, -17, 3, 20, 24, -43, 8, 7,
    14, -26, -17, 28, 48, -29, 26, 42,
    -4, 8, 4, 16, 5, -14, 6, -12,
    -78, -35, 10, 1, 13, -11, -4, 21,
    28, 6, -19, 45, 16, 7, 2, 5,
    7, -1, 22, 6, 59, -22, -42, 9,
    -11, -12, 33, 13, -39, -45, 12, -13,
    10, -8, -48, -64, -35, 2, -114, 17,
    -50, 14, -2, -10, 6, -4, -8, -3,
    -13, 24, -12, -5, 23, 33, -7, -1,
    3, -11, 13, -3, 70, 10, 26, 30,
    25, 44, 5, 40, 13, -11, -1, -23,
    -12, 0, 64, -8, 6, 8, -2, 1,
    42, -63, 24, -56, -67, -13, 47, 21,
    -11, 7, -19, -22, -43, -4, 53, -54,
    -36, -8, 16, -4, 17, 16, -16, 1,
    10, 29, -35, 10, -29, 7, 5, 10,
    -27, -3, -9, 9, 6, -21, -7, 26,
    -74, 2, 12, -38, 24, 55, -42, 34,
    1, 3, 30, 13, 29, 38, -57, -6,
    12, -3, -10, -1, 8, -3, 14, -15,
    -6, -18, -14, 2, 4, -17, -7, -6,
    -5, 42, 21, 7, 8, -11, -15, 35,
    44, 29, -22, 38, -17, -16, -16, 9,
    -1, 8, 2, -3, 4, -39, -8, 5,
    -1, 13, 6, -11, 2, -15, 0, 2,
    -39, -1, 34, 7, 4, -63, -9, -33,
    -25, -25, 6, -23, -9, -10, -35, 12,
    -9, 8, -11, 16, 13, 0, -3, -15,
    -5, -15, 1, 2, 12, 22, 17, -3,
    -65, -7, -70, 7, -15, 46, -1, -34,
    24, 13, 10, 0, 63, 27, 30, 11,
    -7, 4, 21, -5, -1, 5, -3, -14,
    -4, -5, 19, -9, 13, -3, -21, -17,
    -49, -2, -56, 22, -21, -10, 26, 0,
    -53, 8, -9, 28, 23, 32, 2, 18,
    8, 6, 28, 23, 12, 2, -5, -12,
    -1, -4, -16, -2, 11, -12, -10, -20,
    -8, 20, -24, -50, 19, 28, 45, -13,
    -10, 45, -22, -1, -51, -19, -20, -16,
    12, -2, 17, 12, 1, -5, -5, -10,
    3, 1, 15, -20, -3, 15, -13, 0,
    -43, 37, -16, -25, 10, -6, 46, 29,
    2, 27, 18, -12, 3, -38, -25, -16,
    -1, -9, 39, 16, 0, -4, -16, 23,
    -1, 11, -4, -9, -1, 12, 3, -19,
    -7, 9, -72, 47, 22, -19, 13, 37,
    -10, 5, 15, 6, -5, -29, 1, -16,
    5, -35, 29, 13, -5, -4, 4, -3,
    3, -16, 16, 6, 0, -17, -6, 1,
    10, 20, -22, -57, 6, 1, 42, -7,
    -8, -35, -1, 34, -16, 47, -8, -31,
    -11, -2, 16, 4, 0, -6, 26, -4,
    7, -6, -16, -8, -14, 4, 13, -4,
    15, 37, 43, 10, 14, 7, -64, -47,
    71, 12, 17, 16, -28, 23, -18, 19,
    15, 18, 3, 9, 12, -22, 11, -4,
    2, 2, 3, 5, -20, -18, 1, -8,
    8, -74, 20, -11, -20, 19, -19, 15,
    5, 15, 31, -25, -28, -7, -7, 63,
    -28, -2, -11, -11, -14, -3, -9, -7,
    -3, -8, -2, -9, 7, 6, -15, -25,
    -38, 14, 11, -11, -38, 18, 49, -30,
    33, 29, 39, 10, 31, -10, 14, -31,
    15, 17, -7, 6, -9, -5, 10, -6,
    1, 9, -7, -8, -8, -4, 15, 13,
    -45, 6, -60, 28, 0, -10, 29, 28,
    -12, 25, 42, 15, 2, -38, -1, 23,
    3, -6, -9, -9, 16, -3, -1, 9,
    7, 9, -6, -17, -4, 20, 5, -2,
    8, -14, 3, 30, 16, -6, -30, 22,
    -14, -11, -1, 17, -27, -10, -10, -29,
    0, -29, 11, -18, -8, -26, -5, 1,
    8, -4, -11, 30, 1, 23, 13, 0,
    20, -27, -44, 14, 13, -22, 28, -28,
    66, 5, -23, 1, 19, -62, -8, 6,
    8, -7, 5, -38, -4, -27, -19, -1,
    14, 10, 3, 2, 30, 9, -4, -24,
    16, -42, -16, -13, -5, -2, -36, -7,
    28, -19, -5, -14, 22, -14, -5, -36,
    7, -4, 30, 24, 10, -1, -1, 4,
    -3, -3, -8, 15, -12, 19, 40, 20,
    45, 18, -29, -1, -11, -5, 28, 6,
    45, 21, -15, -13, -36, -28, -2, 21,
    7, 17, -20, 25, -2, -5, 4, 15,
    -8, 8, -12, -11, -17, -1, 11, -13,
    -42, 87, -23, 70, 7, -37, -2, -6,
    -12, -14, 0, 2, -35, -4, -26, -18,
    -2, 4, -18, -2, -3, -5, 10, -22,
    5, 4, -16, -31, 1, -6, -4, 5,
    37, 35, -18, 1, 7, -38, -6, -4,
    -18, -8, 7, 4, -6, 35, -22, 0,
    -2, -19, -1, -12, 8, -2, 27, 15,
    0, -8, 9, -6, 5, -4, 7, -24,
    -6, -67, 28, 29, 12, -24, -1, 23,
    41, -12, 12, -20, -6, -11, 11, 0,
    10, -9, -4, 5, -15, 15, -6, 5,
    7, -7, 3, -1, 1, 25, 22, 1,
    86, 26, -68, 1, -3, -2, 5, 17,
    15, 16, 26, -14, -11, 41, 1, 6,
    13, 6, 0, 7, 9, 5, -3, -25,
    -4, 15, -1, 0, 26, -8, -11, -13,
    7, 24, -42, 8, -2, 21, 4, -19,
    -17, -10, -2, 3, 28, -10, -17, 10,
    2, -34, -9, -18, -3, 12, 7, -14,
    15, -17, 6, 6, 9, -9, -8, 3,
    -35, -21, -31, -19, -19, 9, -31, -18,
    23, -3, 6, -42, -28, -4, -39, 0,
    16, -6, -10, -5, 7, 13, 14, 27,
    -1, -10, 11, 1, -25, -12, -15, -4,
    -13, 38, 3, 31, 3, -12, 10, 6,
    1, -7, -8, 29, 6, -12, -12, 9,
    -9, -14, -32, -4, -10, 3, -12, 0,
    7, -7, -6, -3, 6, -14, -32, -24,
    16, 59, -5, 30, 3, 3, 50, 25,
    -25, 42, -22, 1, -13, 5, -16, 44,
    40, 12, 22, -7, 0, 17, -13, 16,
    1, -2, 2, 0, -18, 32, 2, 7,
    -15, 5, 46, -18, -52, 19, -27, 2,
    5, 17, 35, 4, -25, 1, -71, -13,
    -12, 15, -2, 6, 14, 18, 10, -11,
    -6, -11, 4, -2, 0, -44, -12, -12,
    -15, 2, 62, 21, -14, -7, 37, -6,
    58, -25, -33, 22, 5, -17, -34, -14,
    6, -4, -21, -8, 15, -8, -10, -1,
    3, 6, -3, 4, 12, 2, -11, 31,
    38, -19, 31, 3, 4, -12, 9, -40,
    22, -16, -13, -12, 8, 16, 14, 1,
    -12, 2, -4, 0, -19, 20, 14, 7,
    -6, 12, 0, -1, -28, 49, -14, -1,
    29, 1, 17, 11, -5, 8, -14, -15,
    -14, 16, -36, 43, -27, 14, 17, -60,
    -3, 11, -14, -11, -4, 24, 21, 3,
    1, -10, -2, 18, -17, -14, -11, 11,
    -12, 6, -41, -19, 50, -16, 14, -33,
    -38, 20, -7, 21, 43, 4, -6, 64,
    19, -2, 18, -5, -11, 1, -19, 2,
    -13, 5, -9, 4, 4, 8, -17, 6,
    -9, -23, -35, -18, 25, -11, 39, -8,
    -20, -1, 23, 14, -66, -5, 43, -8,
    -19, -13, -15, -20, -5, -13, -4, 7,
    -7, -5, 5, 8, 20, 27, -7, -29,
    -18, 24, 8, -11, 24, -30, 11, 43,
    -39, -11, -10, -39, 1, -27, 2, 12,
    -8, 41, -20, -11, -71, -2, -3, 1,
    -26, 1, -18, 2, -7, 4, -9, 24,
    -33, -11, -31, 28, -19, -30, 8, -30,
    -4, 5, -36, 20, 26, 37, -40, -23,
    3, -20, 15, -12, 3, 3, -10, -6,
    -2, -18, -13, 7, 4, -12, -10, 3,
    -17, 24, -37, -26, -59, -27, -22, -13,
    -9, -15, -21, 29, -6, -30, -73, -56,
    -47, -18, 52, 25, 13, -21, 9, 11,
    7, -2, 16, -9, 11, -29, -21, 9,
    1, -42, -20, 25, 7, -70, 0, -49,
    -54, -6, 0, -7, -27, 9, -37, -38,
    8, -2, -1, 19, 11, -8, 13, -9,
    -11, -17, -9, 10, -11, 1, -25, 3,
    -1, 0, 49, 22, -14, -45, 6, 25,
    -25, 21, 41, -18, 45, 8, 68, -23,
    -8, 7, -9, -9, -7, -4, 1, 3,
    11, 4, 13, 12, -3, -14, -10, 6,
    25, 15, 40, 34, 0, -13, -33, -24,
    -40, 10, -15, -36, -24, 9, 16, 9,
    4, 8, -43, -13, 23, 17, -6, -1,
    13, -7, 2, -16, -17, 2, 37, -19,
    14, 41, 23, 3, 69, 39, -7, 5,
    -23, -17, -22, -23, -57, 4, -39, -59,
    -2, 47, 46, 11, -5, 0, 7, -9,
    9, -6, 2, -16, 22, 1, -4, 6,
    -6, 15, 2, -24, 5, 10, -11, 5,
    -20, 54, 46, -2, -20, -31, -17, 16,
    12, 10, 17, -17, -13, -14, -3, 26,
    3, 1, -3, -6, 29, 52, -36, 18,
    -33, -36, 39, 53, -88, -32, 33, 27,
    -17, 4, -31, 21, 5, -6, 8, 32,
    -24, 15, 24, -14, -10, -1, 7, -4,
    -13, -11, 15, -8, -13, -9, 33, 1,
    13, -26, -1, 23, -56, 58, -26, -5,
    19, -10, -20, -19, 1, 19, 3, -6,
    15, -18, -16, -7, -8, -1, 5, -10,
    2, -16, 3, -12, 19, 9, -13, -2,
    -13, 14, -40, -76, -8, -44, -14, 32,
    0, -31, 1, 1, 4, 28, -65, -18,
    -37, 18, 0, -18, 0, -27, 0, 7,
    -6, -4, -1, 5, 56, 4, -31, 11,
    -38, -31, -13, 15, -57, -4, 34, 6,
    9, 19, -9, 9, 13, -9, -44, 25,
    1, -2, 1, -36, -13, -13, -22, 10,
    9, -9, -2, 3, -26, 37, -7, 13,
    -42, 1, -39, -28, -15, -35, 40, 24,
    5, -16, -35, -13, 32, -10, 35, -16,
    1, -7, -17, 41, 21, -1, -14, 4,
    6, 2, -3, 9, 36, -6, -6, -58,
    70, -41, -20, 25, 6, -20, 5, 30,
    22, 13, 12, -20, -21, -18, -4, -12,
    -22, 4, 1, -17, -2, 26, 10, 7,
    4, 7, 6, -7, -21, -8, -13, -19,
    -17, 34, 8, 24, -3, -17, -14, 4,
    19, 41, 12, 24, -11, -27, 14, -12,
    -5, 30, -13, -38, 17, 7, -6, 24,
    -4, 6, 8, 20, 11, -16, -24, 24,
    9, -5, -5, 1, 4, 1, 12, -23,
    3, 2, 20, -33, 2, -105, -11, -7,
    7, -4, -18, 6, -2, -9, -8, 4,
    27, 17, 1, 5, 52, -6, -5, -9,
    17, 17, 48, 19, -2, 14, -20, -14,
    26, -47, -39, 4, 37, -26, 4, -25,
    -7, -8, 18, -19, 1, -5, -9, -9,
    -6, 7, -1, 18, 16, -17, 38, -8,
    5, 28, 9, 2, -28, -6, 26, 21,
    -34, -13, 0, 29, -9, -2, 3, 24,
    6, 44, 5, 30, 7, -10, -5, -10,
    1, -10, -10, 14, -6, 14, 23, -1,
    36, -25, -27, -31, 49, 39, -8, 3,
    -33, -22, -19, -16, -3, -3, -37, 20,
    11, 19, 0, -3, -16, 0, 28, -11,
    8, 0, -14, -28, -10, -25, 0, 4,
    -35, -18, 31, 6, 40, -5, 29, -13,
    -23, 19, 17, 33, -8, 24, 7, -44,
    -5, -33, -16, -15, -2, -5, 9, 18,
    -1, 1, 4, -6, 15, 11, 17, 29,
    -6, -28, 3, 31, 17, 19, -4, -50,
    -13, 8, 12, -3, -11, 17, -12, 7,
    18, 20, -42, -5, -6, 10, 3, -1,
    4, 7, 10, 2, 8, -15, 5, 13,
    -10, 2, -9, 8, -21, -17, 3, 18,
    24, 20, 17, 10, 19, -13, -53, -25,
    14, -32, -4, -21, -1, -3, 2, 3,
    -6, 0, -4, 3, 30, 7, 1, 6,
    8, -24, 11, -19, -1, 55, 53, -7,
    35, 34, 18, 28, 27, -8, -20, 38,
    -3, -19, -19, -4, 12, 6, 12, -10,
    5, -7, -1, -6, -1, 3, 8, -14,
    66, 13, 3, -7, -3, 1, -33, 42,
    11, -2, -13, 14, -16, 2, -31, 14,
    4, -9, 6, -15, -5, 7, 19, 13,
    -12, -3, -9, 5, 4, -24, 15, 0,
    26, 24, -17, 14, -48, -9, 2, -24,
    12, -19, 16, -1, 34, -34, 17, -3,
    -1, 3, -32, 8, -13, 1, -6, -8,
    6, -7, -1, 7, 33, -39, -70, 20,
    -25, 16, -6, -32, -8, 4, -11, -64,
    9, -25, -11, 19, -15, 10, -31, 38,
    -1, -2, 13, 17, 16, -3, -7, 6,
    2, -6, 2, 8, -4, -9, 4, 7,
    29, 13, -37, -8, -14, 20, -26, -7,
    -14, 15, 30, 0, -36, -50, -47, -20,
    -14, 32, 23, -5, 12, 17, -9, -7,
    4, -7, 3, -9, -27, -21, -9, 2,
    37, -1, 22, -1, -40, 6, 38, -26,
    -17, -23, -35, 31, -28, -38, -25, 41,
    -15, -2, -8, 6, -28, -7, -6, -6,
    -1, -2, 9, -5, 20, -5, -6, 3,
    -34, -13, 25, -8, -10, -5, -45, 19,
    -40, 9, 5, -2, 1, 53, -2, -11,
    3, -15, 32, 19, -7, 14, -5, 0,
    -18, 4, 8, -4, -18, 54, -2, 6,
    -4, 11, 30, 39, -13, 4, 32, 15,
    21, -18, 32, -66, -44, 17, -13, -32,
    -2, 19, 16, 3, 12, 9, -9, -9,
    -4, -2, -20, 0, 30, 23, -17, 32,
    -17, -8, -21, -17, 24, -15, 30, -50,
    3, 42, 19, -20, -14, -6, -12, 59,
    6, 15, -28, 4, 1, -1, -25, 16,
    12, 8, -7, 9, -1, -12, 35, 6,
    54, -8, -41, -35, 23, -27, -47, 24,
    -2, -1, 6, -37, -15, -54, 35, -21,
    13, -15, -36, -22, 19, 3, -18, -2,
    -5, 5, 11, -4, 32, -36, 12, -15,
    -6, 15, 30, -35, -51, -38, -50, -37,
    -17, 28, 7, 51, -7, -48, -4, -5,
    42, -28, 14, 20, -127, 9, -13, -22,
    -47, -10, -33, 17, -26, 25, 21, 26,
    63, 10, 57, 38, -22, -83, 50, -16,
    -8, -20, -33, -41, -15, 30, -42, 11,
    -14, -46, -18, -38, -29, -21, -10, 10,
    43, -32, 36, 21, -7, -12, -42, -48,
    -11, 21, 22, 11, -25, -9, -41, 4,
    -40, -10, 22, -17, 5, 39, -41, 18,
    39, 36, -40, -61, 24, 12, 22, -1,
    -2, -1, 25, 27, -19, -38, -24, 36,
    32, 40, -23, -5, 2, 69, -70, 39,
    -5, 13, 20, 3, -57, -5, -31, -34,
    -30, 1, -13, 17, 14, -22, -4, -9,
    -1, -4, 28, -25, 17, -52, -61, -17,
    15, -47, 36, -39, 54, -2, -35, 48,
    37, 12, 29, 20, 69, 11, 40, 3,
    12, -5, -43, 11, 17, 1, -10, 23,
    -22, 23, 4, 12, -1, 8, 60, 51,
    6, -3, 4, -28, 38, 10, -43, 31,
    29, 18, -6, -16, -1, 33, -21, 25,
    11, -5, -28, -10, 27, 25, 17, 7,
    5, -65, 31, -16, -58, -6, 64, -42,
    -33, -44, 77, -7, -14, 33, 32, 26,
    -24, -12, 42, -19, -52, 25, -57, 18,
    -6, -1, -48, 8, -29, -1, 27, -29,
    -11, -12, 26, -14, 21, 12, 55, -5,
    22, -105, -40, -15, -57, -56, -52, -18,
    58, -33, -76, -15, 5, -10, -5, -37,
    42, -12, 23, -1, -52, -13, -43, 28,
    -23, 28, 6, 13, 66, 63, -12, 51,
    -55, -16, 0, -61, 72, -9, -58, -8,
    -54, 33, 17, -14, -55, -1, 13, -10,
    46, -23, -10, -49, -15, -19, 23, -29,
    -7, -15, 8, -7, -8, 1, 99, 13,
    -24, 14, 31, -7, 58, -2, 22, 11,
    -41, 58, 49, -54, -46, -8, 45, -16,
    -37, -8, -34, 1, -26, -12, -6, -11,
    -31, 1, -15, 47, 19, 36, -15, -32,
    -39, -15, -67, 52, 14, -43, 76, -14,
    -60, 21, -35, -61, 0, 40, -9, 9,
    35, -12, 52, -55, -11, -20, -7, 26,
    -30, 10, 3, -14, 124, -23, -61, 54,
    54, 29, 54, 2, 3, -15, 42, -47,
    -25, 21, 28, 17, 1, -34, -11, -10,
    46, 14, -32, -10, -12, -6, -41, -8,
    27, -26, -19, 19, -48, 59, -30, -7,
    43, 4, -15, -36, 19, 75, -23, 43,
    -17, 65, -86, 16, 51, 22, 76, -13,
    -22, -7, -5, -52, 22, -9, -49, 3,
    -15, -50, -45, -15, 43, 14, 23, -47,
    -10, 21, 110, -17, -25, 37, -72, -57,
    -36, -21, -10, -8, -19, -29, 35, 1,
    20, -17, 31, -27, -11, 38, 23, -13,
    -13, -19, 8, -6, -74, -28, -80, -25,
    35, -39, 18, -50, -15, 9, 4, -4,
    33, 38, -7, -24, 15, -60, -5, -28,
    -55, 17, 25, 21, 19, 12, -1, 45,
    17, -2, 20, -8, 24, -1, -35, 10,
    -20, 8, 57, -33, 22, 39, -61, -31,
    -7, 17, -10, -45, 23, -114, -20, 16,
    -31, 28, -42, 14, 10, 10, 22, 0,
    23, 25, 2, -16, 58, -23, -28, -4,
    7, 29, 6, -67, 9, 16, 41, 37,
    0, -19, 17, 0, 19, -37, -24, -8,
    -34, -4, -36, 24, -5, -9, 4, 22,
    -50, 10, 30, 38, 41, 23, -2, -36,
    -24, -10, 127, -20, -90, 3, -50, -18,
    -28, -11, 55, 11, -9, -83, 10, 6,
    -49, -36, 11, 21, 2, -33, -11, 0,
    6, 6, -51, 25, 44, 45, 2, -26,
    -20, -28, 17, 1, 44, 42, 38, 0,
    -51, 48, -26, 8, -24, -9, -56, -7,
    -23, 81, -27, -1, 9, 18, 3, 2,
    10, 12, -23, -21, 7, -48, 2, 26,
    19, -2, 39, 36, 32, -30, 21, 10,
    0, 8, 22, -42, 1, 62, -40, -18,
    8, 31, 10, -56, -10, -9, 3, 10,
    14, 4, -11, -30, 6, 7, 31, 60,
    37, 74, 65, -36, -23, 29, -38, 92,
    -48, -6, 13, -28, 18, 2, -12, -13,
    -16, 42, 60, -40, 1, -6, -2, -10,
    -11, 18, -26, -15, -12, -87, -5, 2,
    -114, 3, 11, -39, 48, -5, -14, 37,
    -4, 20, -56, 13, 21, 15, -12, 31,
    33, 13, -36, -30, -10, 2, 11, 6,
    -5, -9, 12, -30, 45, 17, -44, 17,
    -11, 12, 43, -33, 30, -63, -10, 22,
    19, 65, -64, -65, 17, -27, -25, 35,
    -20, -14, -11, 57, 26, -22, 5, -21,
    37, 24, -10, -20, 32, 32, 2, -24,
    18, 27, 6, 27, -34, -52, 40, 41,
    53, -25, 1, 39, -51, -38, -3, -7,
    -35, -15, 17, 31, -17, -14, 6, -3,
    -53, -4, -5, 11, 63, -21, 18, -5,
    -1, -2, 17, -26, -6, -25, -3, -81,
    -14, 35, -11, 60, 5, -25, -3, -28,
    -8, -32, -8, 35, -38, -8, -3, -11,
    10, -31, 4, -2, 39, -40, -118, 45,
    -1, -49, 11, 54, -4, -38, -23, 38,
    -27, -24, 4, 34, -52, 8, -40, 17,
    -65, 62, -4, 24, 24, -33, -2, 24,
    53, -18, -9, -11, 23, -30, 44, 33,
    6, 65, -53, -52, 60, -9, 2, 6,
    0, -7, 5, 3, 16, -32, -53, -10,
    12, 4, -2, 0, 10, 19, -8, 14,
    -8, -18, -4, -8, -45, -13, -26, -6,
    64, -28, -9, 9, 2, -81, -56, -41,
    -32, 38, -24, -13, -45, -35, -41, 36,
    -84, 8, 58, -19, -36, 1, 2, -22,
    20, 11, -37, -8, 89, 14, -44, 44,
    75, -10, -52, 30, 24, -14, 22, -15,
    -30, -21, -47, 71, -38, 60, 22, -16,
    43, -26, 0, -33, 19, -3, -21, 12,
    13, -5, -35, -11, -40, 64, -14, -34,
    37, 13, -3, 42, 24, -19, 9, -2,
    -8, 15, 12, -11, -36, 16, 7, -65,
    -58, -71, 20, -8, 11, -6, -50, -19,
    12, -27, -60, -69, 64, 32, -13, 68,
    -84, -44, -25, 40, -51, -58, -82, 46,
    14, 54, -3, -44, 10, 16, -51, 89,
    -51, -54, 4, 5, -13, 1, 13, 7,
    22, 4, -5, 14, 47, -20, 76, 29,
    3, -23, 25, -4, 34, -5, 23, 76,
    21, 42, -3, 18, -67, -13, 28, 73,
    12, 89, 86, -9, -15, 22, 6, 20,
    -9, -16, 1, 15, 54, -90, -7, -6,
    -49, 2, -33, 4, 36, 46, -33, 55,
    2, 5, -11, 10, -14, -23, 24, 6,
    24, -34, -7, 2, 3, 8, 19, 0,
    -28, -41, -3, -5, 10, -8, 14, -51,
    -8, -32, -2, 19, 3, 6, 3, 19,
    -28, 15, 1, -5, 5, -20, 19, 6,
    21, 7, 8, -2, -16, -7, 8, 20,
    1, -20, 26, 46, -39, 10, 29, 24,
    3, -37, -18, 24, -4, 1, -10, -26,
    14, 30, 9, 16, 5, -7, -4, -16,
    5, 8, 2, -47, 5, -9, 0, 31,
    -33, -6, -21, -25, -11, 9, 0, -32,
    14, -29, -6, 1, -2, -15, -26, -44,
    -1, 17, -19, 16, 15, -19, 29, 16,
    6, -14, -6, -24, 53, 28, 2, -7,
    56, -18, 21, 41, -32, -24, 22, -21,
    -6, 50, 18, 48, -1, -19, -1, 0,
    -3, -6, -2, -24, 43, -10, 32, 14,
    28, 16, -7, -2, -26, -16, 5, -9,
    5, 25, 9, -37, -6, -20, -4, -63,
    22, 28, -7, -18, -10, 5, 20, 18,
    -7, -24, -13, 8, -31, 2, 34, 21,
    -9, -13, -6, 4, 50, 11, -7, -11,
    -46, -12, -27, 39, -14, 15, 21, -21,
    -38, 8, -20, 31, -2, -4, 9, -4,
    -10, 20, 16, -9, 1, 15, -38, -12,
    22, 10, -24, -36, -28, 3, -19, -16,
    -4, 3, -22, -9, 19, 15, -3, -28,
    -11, 7, 10, 12, 12, 7, 21, -6,
    -17, -16, -14, 4, 18, -6, -29, -6,
    -5, -22, 15, 19, 13, 8, -12, 36,
    9, -21, 17, -15, -16, -8, -10, 0,
    0, -21, -12, -45, 16, 36, -24, -10,
    -6, -59, -10, 22, -8, -19, -21, -24,
    -3, 35, 18, -9, 14, -29, -13, -4,
    -49, -20, -25, 21, -59, -27, -15, -51,
    24, -37, 3, 18, 4, 1, 15, 24,
    -6, -7, -13, 29, 7, -5, 6, -24,
    -2, -10, 28, 22, 21, 30, 9, -3,
    -11, -39, 23, -9, -15, 4, 14, -9,
    -9, 23, -2, -14, -5, -19, 41, -10,
    22, 3, 13, -14, -30, -4, -20, -26,
    -8, 2, -8, -16, -3, -41, 32, -22,
    -1, 2, -19, -21, 10, -22, 3, -26,
    -22, 26, -15, 21, -24, 10, -11, 23,
    -10, -29, 11, -14, 1, -20, -9, -8,
    -1, -4, 14, 2, -9, -25, 13, -1,
    16, -20, 19, 40, 2, -31, 22, 30,
    -21, -1, -1, -10, 5, 12, 16, 23,
    5, -17, 33, -14, -19, -14, 4, 2,
    -14, -11, 18, 9, 50, -8, 0, 53,
    39, 22, 26, 63, 10, 40, 13, 18,
    4, -8, -16, 0, 2, -2, 9, 9,
    -3, 8, 28, -30, 11, 1, -21, -2,
    -9, 8, -3, 34, 1, 3, -25, -12,
    28, 6, 38, 11, 6, 23, -28, -82,
    4, 17, 4, -19, -3, 21, -6, -6,
    8, 7, -5, 0, 26, -9, 6, 7,
    -9, -4, 2, 15, -4, 20, -5, 25,
    -6, -40, 7, -36, -3, 16, -8, 14,
    2, -23, 2, -28, 53, -16, 2, -7,
    0, -11, -14, 7, -21, 15, -16, -1,
    -9, -9, 18, 11, -2, -21, -24, -44,
    -28, 25, -1, -21, -30, -19, -13, -3,
    45, 3, 15, 18, 7, 5, 20, 22,
    -4, 9, 19, -1, -18, -21, 10, -8,
    -2, -20, -16, 12, -7, -25, -14, -38,
    -40, -26, -20, -13, -36, 1, -30, -31,
    -21, -5, -22, 11, 18, -7, -3, -7,
    -24, 20, -3, 14, -45, -14, -28, 0,
    -5, -14, 2, 0, -1, -51, -27, 52,
    -9, -12, -2, -12, -10, 46, -22, 2,
    -5, 23, 37, -61, 11, -34, -16, 13,
    -24, 0, -19, 8, 13, 7, -4, -26,
    33, 10, -16, 12, -6, 17, -7, 13,
    24, -16, -12, 4, 26, 27, 8, 5,
    41, -10, -16, -14, -1, -23, 0, -12,
    -6, 17, 33, -1, 36, -8, -2, -15,
    20, -16, -11, 1, 17, 16, -4, 1,
    2, -30, -10, -25, 28, 4, -11, -8,
    1, -10, 19, 8, -9, -2, 4, 1,
    -19, -10, 3, -2, -49, -47, 16, -6,
    3, 3, -15, -5, -9, 21, 2, 0,
    10, -4, -28, 13, 1, 10, -30, 24,
    3, -10, -25, 14, 31, -23, -17, -24,
    -10, 17, 7, -16, -9, -5, 0, -13,
    10, -26, -26, -6, -19, -17, -1, 13,
    -7, -58, 13, -14, 1, -33, -42, -7,
    6, -37, -39, -21, -17, 26, -25, 2,
    18, -3, 22, -19, -36, 8, -35, 4,
    -10, 21, 3, -28, -45, 1, -27, -21,
    57, 18, 22, -2, -44, -1, -12, -20,
    12, -46, 2, 1, -19, -4, 41, 18,
    2, 15, 9, 5, 19, 34, 30, 13,
    -7, 7, -17, 14, -32, 22, 29, -1,
    31, -7, 8, -28, -22, 1, 8, -31,
    -44, 7, 23, -24, -7, 1, -10, 28,
    4, 1, -43, -3, -3, -24, -39, -7,
    -12, -21, -21, -2, 17, 5, 23, 27,
    10, 30, -33, 5, -18, 21, 42, -5,
    22, 6, 10, -40, 21, -17, -3, 0,
    8, -3, 25, 15, -12, -29, -19, 16,
    1, 0, -4, -4, -9, 22, -22, -19,
    42, -1, 24, -20, -7, -6, -14, -38,
    3, 2, 10, 4, 0, 1, -2, 17,
    -14, 13, 20, -1, 5, -11, -19, -2,
    -7, -20, 16, 7, 3, -8, -32, 15,
    -17, -4, -18, 2, -18, 36, -8, -24,
    -17, 3, -30, -21, -2, -21, 1, 20,
    -16, -17, -12, 47, 19, 14, -39, -6,
    -10, -28, 11, -2, -10, 47, 8, -17,
    -26, 29, 32, 17, 13, -11, -8, 1,
    -28, 11, 29, -4, 13, -2, 8, -42,
    2, 12, -11, 28, -9, 4, 19, 17,
    -27, -6, 12, 4, 21, 8, 21, -27,
    -9, -41, -31, 28, 0, -2, 35, 9,
    -7, -12, -13, 9, -9, -7, 2, 9,
    31, -4, -15, -5, -8, -15, -12, -6,
    -11, -4, 7, -10, 18, 13, -1, -4,
    30, 13, 52, -7, 13, 12, -20, 17,
    -16, 15, 5, 11, -7, -30, 24, -14,
    -42, -12, 36, 16, -3, -24, -9, -15,
    6, 9, 3, -18, -16, -12, -9, -40,
    -5, -19, 42, 6, 8, 2, -35, 19,
    33, 1, -7, -40, 13, 3, 5, -17,
    -20, 21, -17, -34, 5, 35, 27, 34,
    -22, -19, -1, -21, -14, -26, -33, -12,
    18, -25, 10, -29, -42, -35, -14, -27,
    -3, -2, 8, 16, 14, -14, 38, -7,
    -7, 28, -8, 20, 27, 64, -42, 0,
    19, 37, 22, 36, 12, 15, -2, 26,
    -17, 9, -13, 22, -13, -32, 12, -1,
    -16, 47, 54, -17, -3, 11, -35, 20,
    -2, 0, -27, 43, 2, -41, 12, -8,
    4, 17, 17, 30, 1, 10, 2, -36,
    21, -17, -14, 48, 7, 20, -17, 3,
    -1, -46, 24, -12, 3, 9, -21, 10,
    -26, 24, 8, 21, 25, -16, 20, 15,
    26, 43, 16, -8, 12, -1, 3, -6,
    -18, -8, 1, 32, -17, 0, -8, 35,
    37, 57, 0, -78, 1, 49, -13, 16,
    -10, 19, 11, 33, -3, 3, -1, 18,
    -11, -38, 20, 25, 11, 11, -21, -11,
    23, 9, 7, -3, -24, 17, -20, 34,
    5, 28, 32, -6, 22, 23, 17, 46,
    19, -27, -30, 10, 8, -7, -27, -2,
    -11, 22, -7, 27, 5, -5, 19, 16,
    -23, 15, 22, -23, 10, -47, 23, -8,
    -27, 48, 4, 46, -6, 4, 10, 0,
    -18, 13, -37, 5, 22, 0, -17, 16,
    -8, -10, -13, 5, -25, -11, 22, -7,
    5, -41, 8, -8, -21, 9, -6, -9,
    41, -6, 81, 12, 26, -13, 0, 20,
    20, 6, 29, 20, 20, -15, -35, -10,
    -6, 12, -3, -18, -12, -35, 11, 14,
    2, -26, 17, -25, -20, -5, 10, 18,
    -19, 14, -5, 4, 22, 29, 0, 28,
    37, -29, -49, -26, -65, 8, 22, 17,
    14, 12, -10, -29, -3, 18, -10, -31,
    -5, 59, -6, 20, -1, -30, 8, 9,
    13, -28, -9, 12, 5, -12, 15, -10,
    -24, -9, -38, -12, 19, 75, 25, 17,
    -9, 21, -44, 8, 13, -5, 7, 29,
    -10, -49, 38, 47, -42, -35, -50, -20,
    5, 6, 36, -7, -49, -18, -16, 6,
    2, 10, -2, -10, 35, -15, -4, -39,
    13, -26, -23, -6, -4, -6, -13, -3,
    -12, -52, -47, 0, -24, -42, 2, 5,
    12, 40, 43, -55, 14, 12, 17, 10,
    -3, 51, -30, 30, -33, 21, 18, 13,
    -28, -33, -6, 11, -36, 9, -36, 19,
    -54, -11, 13, 0, -10, 5, 32, 11,
    18, 3, 28, 37, -14, 4, 36, -6,
    18, 26, 22, -27, -1, -3, -27, -53,
    22, 11, -16, 35, 6, -10, 4, -23,
    47, -11, 18, -24, -25, -7, 52, 20,
    28, -4, 7, 14, -22, -22, 30, 14,
    -41, -25, -11, -12, 5, -30, 52, 38,
    14, -1, 27, -4, -30, -34, 14, -13,
    27, 30, -25, 3, 33, 46, 35, 10,
    -15, 13, 35, 5, 26, -2, -19, -29,
    -19, 17, 2, 59, -3, 3, -3, 3,
    1, 28, 17, -41, 10, -22, 7, 4,
    -11, -33, 28, -64, -24, -25, -31, 24,
    -50, 12, 21, -11, -30, 10, 3, -6,
    -27, 6, 29, -22, 39, -8, 25, -15,
    4, -15, 2, -7, -28, -14, 38, -51,
    -35, 29, 25, -17, 5, -18, 0, -40,
    -11, -15, -5, -7, -7, -24, -38, 23,
    -15, -5, 1, 6, 20, -5, -16, -61,
    39, -1, -72, 13, 10, -31, 47, -27,
    -6, -10, 2, -1, 64, 10, -22, -15,
    9, -12, -63, -7, -3, 16, -27, 49,
    20, -1, -12, 9, -36, 24, 77, -3,
    9, -11, 30, -3, -11, 3, -6, 4,
    -21, -13, -20, -2, -46, 13, 4, -2,
    -24, -13, 16, 6, 11, 6, -6, -27,
    -8, 65, -9, -31, -46, -4, 2, 35,
    -36, -7, -14, 31, -18, -2, 27, 12,
    -35, -27, -5, 11, -19, 44, 2, -13,
    39, -14, -9, 52, 2, -24, 14, 18,
    52, -54, -2, 13, 19, 19, 2, -31,
    3, -42, 20, 0, 17, 3, 23, -11,
    -16, -16, -3, -1, 20, -41, 0, 18,
    -39, -54, -63, -15, -8, -40, -9, -7,
    -5, -29, 15, 39, 30, -25, -1, 2,
    21, -35, 1, -23, -16, 32, 18, -41,
    0, 23, 23, 24, 22, -11, -5, 35,
    12, -1, -1, 13, 29, -10, -4, 47,
    11, -2, -21, 3, -4, -7, -80, 12,
    13, 55, -11, -3, 22, 28, -17, -3,
    48, 9, -83, 7, 25, 25, 52, 34,
    14, 18, 39, 8, 70, 5, 37, -36,
    12, 1, 25, 12, -1, -32, 26, 24,
    -2, -23, 19, -10, 21, 3, 4, 5,
    -6, -56, -88, 6, 17, 29, 6, 30,
    -12, -12, 3, 4, -18, 3, 37, 2,
    7, 7, -2, 8, 13, -6, -24, 28,
    -6, 15, -23, -5, 18, -8, 4, -31,
    -22, -11, 1, 18, 34, -29, -6, -34,
    16, 3, -27, 30, -24, 4, 29, 13,
    -19, -3, -28, 14, 7, 23, 41, -16,
    23, 8, -4, -23, 8, -9, 31, -11,
    -10, -14, 30, 13, -10, -14, 21, -14,
    -32, 4, -16, -15, -1, 1, -29, 7,
    10, -4, -13, 17, -13, -10, -6, -7,
    -33, 21, -9, 24, 13, -13, -4, -17,
    1, 3, 2, -35, -25, -23, 28, 52,
    -37, 27, -46, -10, 46, 31, 21, 20,
    14, -7, -12, -20, 20, 10, 10, -9,
    -15, -13, -27, -13, -7, 12, 0, -15,
    2, 42, 2, 24, -32, -6, -18, -19,
    -22, -1, -11, -15, 1, -13, -19, -1,
    17, 9, -10, -12, 14, 13, 25, -5,
    2, -2, -5, 8, 39, 13, -10, 8,
    -24, 4, 7, -27, -20, 12, -3, -37,
    12, 10, 9, -22, -27, 12, 26, 8,
    7, -29, 28, -20, 13, -23, -18, 5,
    3, -6, -3, 15, -32, 10, 33, -20,
    4, -36, -24, -7, -23, -16, 27, -23,
    11, -22, -25, -14, -1, 17, 7, 4,
    -15, -7, -23, 15, 20, 9, 40, -8,
    -34, -6, 13, -26, 17, 3, 5, -13,
    -3, -18, -21, 8, -11, 26, 17, -24,
    9, -43, -34, -1, 14, 19, 7, -17,
    19, 9, -1, -17, -3, 25, -23, 12,
    8, 9, 7, -6, -26, -32, 34, 33,
    -24, -16, 1, -18, 6, 0, -6, 26,
    27, 29, -18, 2, -7, 9, -10, -37,
    -2, 11, 18, -13, -16, 1, -42, 22,
    23, 16, 18, -8, 12, 9, -2, -27,
    17, 10, -11, 20, -22, 6, 3, 42,
    -16, -13, 14, -3, 6, -1, 20, 11,
    -23, 8, -33, 16, -41, 6, -6, 45,
    17, 3, -16, -2, -4, 10, -12, -4,
    -15, -30, 12, -17, -16, -30, 31, 46,
    11, -2, 34, 13, 4, 0, -18, 61,
    -16, -55, 29, -61, -51, -28, 0, -57,
    34, 40, 23, -1, -25, 21, 30, -63,
    -46, 44, 21, 42, 17, 19, 15, -26,
    -15, -68, 41, 88, -1, -17, 8, 17,
    24, -2, 51, -13, 10, -1, -30, 53,
    -29, 16, 10, -1, 40, 43, -12, 48,
    0, -43, -19, -21, 7, 46, -55, -32,
    31, -29, -4, -35, -15, 18, 37, -7,
    -20, -86, 14, -36, -22, -24, 6, -36,
    25, -9, -17, 23, -9, 17, -18, -52,
    36, -46, 8, -80, -2, 6, -44, 33,
    -54, -29, -9, 21, 5, 18, 49, -24,
    58, -7, -15, -21, -10, 14, -44, 10,
    10, 9, 13, 9, -39, 17, -13, -20,
    -29, 27, -34, -48, 38, -16, -35, -49,
    -44, 22, -18, -42, 17, -56, -25, -46,
    -20, -12, -11, -12, -56, 4, 34, 2,
    2, 15, 27, -9, 38, 29, 75, 49,
    -22, -20, 15, 6, -13, -46, -32, 17,
    -3, -17, 85, 28, 35, -21, -56, 18,
    21, -12, 38, -23, 12, -9, -31, -14,
    -25, 35, 68, -5, 13, -63, -26, 22,
    -23, 43, 12, 5, -66, -39, -24, -35,
    -93, -7, -28, -75, -6, 37, 0, 17,
    -16, 68, -41, 21, 43, -33, 16, 29,
    14, -49, -12, 21, 45, 36, -63, -3,
    16, 58, 21, -27, -44, -3, -11, -23,
    16, -31, 30, 43, -39, -90, 75, -52,
    -9, 2, -8, 19, 48, -44, 22, -15,
    -5, 13, 20, -48, 38, -8, 8, 27,
    23, 0, -13, 2, 4, 39, -13, -13,
    -2, 43, -16, -55, -47, 1, 15, 18,
    44, 25, -50, 38, 24, 10, -20, -46,
    -7, -34, 14, 16, 28, -7, 22, -2,
    14, 79, 7, 10, 52, 26, 74, 33,
    -20, 52, -37, -3, 34, 16, 17, -72,
    18, -16, 33, 20, 4, 26, -64, 26,
    -3, 127, 25, -6, 9, 30, 41, 46,
    -37, 127, 98, -46, -5, -36, -7, -15,
    44, 33, -37, -16, 11, 12, -21, 41,
    -43, -17, -42, -11, 88, -22, 35, 52,
    29, -10, 0, -10, 8, 52, -45, 54,
    20, 19, -62, -5, 114, 15, -41, -49,
    20, -49, -32, -30, 6, -14, 22, 22,
    13, -66, -15, 54, 5, -15, 30, 25,
    21, -2, 19, -8, 28, 6, 28, -11,
    -24, 66, -22, -9, -24, 57, 2, -31,
    30, 5, 27, -67, 23, 48, -51, -20,
    -26, 19, 22, -69, 13, 52, -18, -54,
    27, 22, -50, -43, 42, -21, 1, -9,
    -33, 13, -43, 3, 44, 25, 23, 7,
    21, -29, -8, -23, -46, 55, 4, 50,
    21, -40, -10, 20, 35, 94, -31, 36,
    18, 3, 14, 42, -41, 29, 16, -5,
    -8, -1, 16, 11, -6, -22, -33, 43,
    33, -95, -57, 53, 15, -8, -25, 45,
    35, -46, 11, -4, -34, 26, -30, 24,
    -1, -10, -1, 17, 6, 11, 20, 40,
    8, -6, 56, -22, 44, 4, -13, 10,
    -73, 13, 16, -17, -30, 33, 9, -40,
    41, 4, 12, -38, 1, -4, 1, -87,
    -23, -3, 35, -4, -43, -14, -44, 75,
    74, -16, 29, 18, -10, 7, 3, 5,
    28, -30, -43, -19, -57, -28, 20, 29,
    7, -50, -27, -7, 25, 12, -52, 34,
    31, 19, -22, 32, 2, 16, 14, 21,
    4, 40, -23, 22, -42, 18, -34, -15,
    -4, 4, 21, 73, 43, -7, -31, 43,
    61, -29, 29, -7, 13, 44, 25, -45,
    11, -19, 19, -26, 38, -20, 19, 6,
    57, -47, 12, 10, -19, 20, 19, -57,
    3, -9, 10, 11, 20, 88, 4, 16,
    -31, -4, 55, 12, -2, -45, 22, -8,
    5, 39, -13, -11, -9, -4, -16, 11,
    0, 73, -12, -17, 67, 2, 25, 47,
    11, -62, -51, -2, 29, -22, -5, -5,
    19, 20, -7, -24, -7, -28, -8, 30,
    -22, 39, -18, 31, 18, -32, 0, -20,
    30, -50, 0, 66, 11, -24, 14, 53,
    60, 66, -1, -8, 10, 99, 19, -60,
    -9, -52, 15, -10, 45, -6, 9, -29,
    -47, -18, -35, 28, 70, 13, -21, 4,
    -3, -16, 40, 56, -6, 11, 2, -17,
    6, 40, -51, 9, -33, 9, -22, 33,
    -16, -46, -13, -12, -6, 32, -74, 35,
    -16, 47, -3, 0, 15, 39, 13, -16,
    38, 36, 97, 0, -24, -25, -38, -30,
    -30, 21, 39, -21, -8, 13, 17, -40,
    32, 42, -30, 22, 5, -43, 9, 13,
    41, 20, -64, -29, -27, -23, 27, -2,
    -6, -31, -26, -9, 71, -7, -1, 4,
    -38, 41, -19, -23, 60, 17, -37, -22,
    -95, -34, -15, -3, -1, 7, -2, 18,
    3, 16, -12, -6, -49, -26, 66, 4,
    16, -25, 6, 13, 32, -10, 52, -3,
    44, -3, -56, 3, -9, 2, -7, 5,
    -6, 68, -12, 8, 7, 62, 39, 7,
    15, -8, 49, 1, 37, 61, -20, 10,
    15, 10, 1, 66, 1, 1, 65, -10,
    4, 5, -63, -3, -43, -17, 29, 38,
    -43, -10, -27, -31, 10, -59, 39, 29,
    14, -36, 12, -30, 65, -1, -19, 37,
    -67, -21, -48, 43, 15, 29, -56, 33,
    -33, 9, -56, 16, -25, 0, -16, 0,
    30, -8, -70, 2, -48, -9, -21, -8,
    -4, 19, -32, 16, 10, -16, 48, 10,
    51, 27, 13, -13, -38, -24, -6, -32,
    41, 26, 32, -39, 10, 31, -37, 21,
    17, 18, -17, 28, -27, -50, 45, -7,
    27, -44, -22, -31, -84, -45, 17, 23,
    26, -31, 9, -38, 16, -26, 42, 39,
    92, -7, -28, 22, -20, 5, 8, 4,
    11, 9, 41, -50, 51, -1, -10, 2,
    17, 7, 5, -17, 26, -29, 37, -14,
    -22, -50, -34, 6, -19, 41, 8, -14,
    -25, -20, -34, 5, 10, -7, -49, -23,
    3, -40, -4, -31, -2, 34, -2, 26,
    -34, -8, -23, -33, 57, 69, 8, 10,
    59, 54, 47, 7, 5, 15, -23, 31,
    -25, -38, 24, 32, 17, 17, 13, 11,
    22, 26, -103, 2, 52, 23, -6, 28,
    -26, -15, -5, 3, 58, 27, -2, 18,
    -11, -30, 8, -37, -31, -50, -24, 23,
    6, -4, -23, 41, -33, 70, -34, 30,
    39, -20, 21, -30, 37, -12, 27, -42,
    -32, 41, 25, 17, 43, 42, 43, 5,
    -10, 49, 21, 45, -7, -7, -12, -57,
    19, 0, -70, 0, -42, -51, 45, -38,
    24, 12, -13, 11, 24, -3, 9, -27,
    8, 46, -26, 22, 18, -13, 23, 5,
    28, -28, 4, -1, -5, 25, 2, -3,
    34, 0, -9, 0, 23, -7, 3, -24,
    -12, -4, -23, 11, -1, 3, -21, -7,
    48, -8, 6, 2, 9, -32, -15, -2,
    -8, 9, -6, -26, 0, -40, -12, 13,
    4, 20, -13, -14, -1, 13, 2, -36,
    -3, 0, 0, 3, -5, -16, -27, -5,
    -19, 15, -12, 12, -14, 15, 8, 8,
    15, 16, -42, 13, -13, -8, 6, -10,
    -11, 3, 11, -4, -22, -20, 16, 15,
    10, -8, -7, -3, 47, 17, -10, 26,
    -21, 5, -2, 5, -9, -22, 4, -11,
    27, -47, -14, -32, 3, 7, 3, 5,
    -3, 8, -8, 11, 1, 7, -6, 4,
    20, -24, -30, -14, 17, -10, 23, -10,
    25, -8, -1, -6, 8, 2, 45, 11,
    -13, -5, 13, 9, -8, 12, 3, -2,
    -15, 6, 28, 12, 17, -5, -35, -5,
    -16, 11, -13, -7, 7, 11, 1, 2,
    -33, -11, -5, 0, -8, 25, 11, 12,
    10, -34, -3, -25, 2, -15, -16, -8,
    20, 22, 6, 9, 56, -24, 11, 2,
    0, -8, 16, 4, -20, -57, -10, 1,
    28, -5, 86, 38, 40, -15, 5, 22,
    34, -45, -19, 0, 0, 10, 3, -6,
    9, -14, -24, 17, -10, -14, -31, -23,
    -7, 12, -36, -6, 1, 17, -8, -28,
    0, 10, -22, -7, 1, 1, -3, -47,
    -25, 10, 16, -41, 11, -6, 4, 22,
    -2, -17, -3, -30, -20, 39, 1, -4,
    -3, -23, -5, 21, -25, 2, 14, 4,
    1, 0, 11, 52, 8, 13, 43, -14,
    11, -15, 33, 23, -2, -3, 5, 32,
    -4, 3, 30, 11, 19, 16, 5, -8,
    -2, -1, -3, 18, 2, 51, 7, -5,
    -51, 6, -4, -12, 35, -27, 14, -19,
    1, -7, -15, 16, -2, 13, 12, 8,
    7, -14, -16, 3, 12, 18, 7, 23,
    -11, 1, -3, -4, -12, -4, -24, -4,
    -3, 27, -24, -24, 17, 17, -52, 8,
    7, -10, -4, -21, 12, 0, 2, -21,
    10, 2, -5, -10, 14, -7, -13, 18,
    -5, 5, -17, 3, 10, -18, -7, -9,
    -33, -23, 1, 21, 5, 35, 46, 26,
    29, -8, 14, -52, -7, -6, -20, 10,
    -20, -15, -7, -17, -11, 22, 38, -17,
    -10, -33, 0, -6, 16, 8, -12, 2,
    -10, 22, 12, 5, 37, -34, -13, -15,
    -8, 11, 10, -24, -10, -11, 6, -9,
    -12, -10, -14, 1, -34, 15, -14, 15,
    -22, 11, 3, 8, -4, -17, -8, -7,
    13, -15, -69, -1, -23, -41, -64, 2,
    30, -7, 5, -3, 8, -7, -18, -13,
    -15, -4, 15, -2, 28, 22, -25, -1,
    3, -30, -1, -2, -3, -4, 44, -21,
    -17, 11, 21, 20, 13, 39, 7, 14,
    -54, -33, 52, 5, 19, -16, 9, -9,
    -15, -7, 9, -4, -2, 35, -7, -4,
    3, 11, 14, 23, -12, -8, -12, -49,
    6, 4, 21, -16, -11, -1, -5, -1,
    -25, 4, 35, 14, -13, -9, 2, -3,
    9, -6, -8, 9, -16, -14, -13, -30,
    -6, -16, -6, -3, -28, 7, -8, 5,
    -17, -72, 23, -18, 24, 31, -11, -11,
    -18, 20, -32, -15, -16, -12, 17, -9,
    2, -21, 0, -23, -11, -16, -36, 6,
    15, -6, -4, -8, -19, -31, 17, 4,
    -14, -25, -2, 12, 14, 10, -6, 18,
    -44, -2, -30, -35, 0, 8, 13, -26,
    -10, -4, -10, -16, -42, -2, -8, 31,
    23, 8, 4, -14, -14, 20, 22, -13,
    -23, 26, -42, -14, 40, -26, -28, -9,
    -13, 11, 2, 1, -27, 2, -16, 3,
    4, -53, 2, 13, 13, -20, 22, -12,
    27, -9, 12, -12, -8, 38, -7, -14,
    15, -15, 7, 9, 23, 11, 26, -1,
    41, 4, -25, -19, -20, 7, 63, -14,
    9, 6, 6, -5, 3, -20, -18, -17,
    -1, -29, -4, 18, 34, 11, 24, 1,
    3, -34, -33, 5, 10, 16, -21, 11,
    5, 20, 26, 6, -5, 7, 1, -1,
    4, 6, -1, -4, 22, 44, -8, -18,
    -3, 1, 2, 20, -7, -19, 10, 16,
    -7, -28, -10, -1, -9, 15, 0, 3,
    -9, 20, 26, 28, -4, 9, 2, 5,
    -8, 33, -8, 7, -12, 16, 24, -5,
    8, 19, 29, 9, -2, 8, 11, 11,
    -19, 7, 4, -9, 19, 9, -31, 5,
    9, 15, 24, -31, 12, 19, -9, -4,
    18, -3, 31, 3, -32, -2, 9, -7,
    12, -3, 5, -7, 10, 4, 1, -20,
    23, -14, -31, 39, 0, 0, -20, 7,
    3, 14, -10, -10, 1, -3, 2, 9,
    -3, -4, -9, 25, 1, 7, -6, 17,
    7, 1, 28, 12, 20, 3, -9, 17,
    -11, 11, -36, -26, 11, -68, 1, 14,
    -25, -22, -5, -2, 18, 16, -18, -4,
    -18, -11, -21, 3, 4, -8, 24, 14,
    11, 3, -10, -7, 16, 6, 20, 4,
    -15, 3, 16, 1, -23, 20, 7, -5,
    2, 13, 11, 28, 5, -20, 2, -2,
    17, 3, 11, 16, 2, 23, 22, 18,
    16, -2, -6, 4, 13, 3, -51, 7,
    -13, -14, -31, 6, -6, 1, 2, 2,
    38, 26, -19, 2, 12, -13, -8, -5,
    -8, 2, 9, 17, -1, 20, -4, 19,
    -22, -6, 21, 1, -27, 27, -15, -15,
    6, -2, 30, 40, -3, -17, -33, -20,
    -17, -14, -34, 2, -3, -7, -2, 8,
    3, 9, -6, -1, 5, 19, -45, -29,
    26, -25, 24, -3, 12, 6, -16, 3,
    1, 5, 6, -17, -26, 25, 11, -8,
    14, 9, 11, 28, 0, 0, -3, -21,
    1, 12, 16, 6, 4, -12, -6, -9,
    -11, 11, -8, 25, -16, -42, 28, -14,
    23, 15, -24, 27, 29, 21, -47, -9,
    18, -13, 35, -15, -4, 6, 11, -33,
    12, 5, 16, 3, -22, -56, -47, 9,
    -17, -28, -20, -8, -3, 1, 18, -12,
    12, -8, -1, -6, 24, -16, 52, 27,
    9, -9, 10, 19, -2, 1, -7, 5,
    27, -12, 3, -15, -21, -5, 17, 15,
    16, -10, -3, 2, -7, -11, 0, -24,
    10, -6, 39, -14, 23, 2, 32, -35,
    7, 6, -2, -7, 4, -11, -13, -12,
    -26, 14, 2, 1, -19, 16, -23, -38,
    -20, -2, 29, 9, 1, -8, 9, 17,
    -17, -94, -1, 48, -10, 45, 24, -10,
    -64, -15, 12, 1, -14, 19, -2, 5,
    -6, -20, 3, 5, 7, -19, -10, 14,
    5, 2, -16, 12, -11, -19, -22, -4,
    18, 1, 5, 4, 47, -13, 12, 15,
    -9, 13, 7, -5, 12, -37, 20, 9,
    12, 17, 9, 38, -17, 10, -3, 35,
    -17, 12, 28, -7, 39, 31, -18, -1,
    -23, -46, -4, 5, 42, 35, 42, 51,
    22, -13, 11, -12, 17, -24, 4, 0,
    -5, 0, -13, 46, 12, 2, -27, 15,
    14, 17, 18, 3, 17, 5, 13, -14,
    -57, 14, -19, 24, 13, -32, 28, -51,
    22, 1, -7, 5, 11, -14, -10, -3,
    7, -14, 24, 24, 21, -24, 19, -11,
    29, -9, -13, -16, -10, -10, -7, 9,
    34, 13, 35, 15, 12, 19, -16, 36,
    -34, -2, 43, -31, -43, 36, 29, 22,
    4, 4, 11, -27, 28, -13, 20, 46,
    14, 10, 10, 7, 15, 9, 36, 3,
    25, 25, -43, -10, 35, 3, 18, -2,
    -18, 6, 20, 16, -20, -34, 5, -21,
    -22, 13, -13, 20, -23, -17, -23, 11,
    -21, 13, 15, -14, -17, -12, 3, -21,
    -13, -37, -31, 3, 22, -27, 29, 26,
    2, -26, 13, 5, 10, 16, -13, 33,
    16, 12, -24, 19, 6, -28, 12, -36,
    -22, -23, 0, -4, -11, -19, 28, -11,
    8, -32, 2, 38, -35, 23, -1, 72,
    16, -15, 12, -11, 14, 0, 8, -2,
    25, 23, 7, 16, -5, -10, -29, 7,
    -10, -43, 5, -35, -10, -2, -24, 28,
    79, 31, -48, -20, -19, -14, 34, 50,
    -24, 17, 4, 0, -3, -8, 0, 6,
    -26, 0, 40, 15, 18, 23, 9, 4,
    33, 12, 19, 32, -11, 45, 28, -12,
    22, -20, -17, 62, 26, -21, -17, -13,
    -7, 26, 24, 7, -9, 8, -18, 34,
    -7, -3, -35, -5, -2, -11, -59, 1,
    -39, 2, -6, 24, 10, 21, -52, -2,
    -16, -17, -4, 18, -20, -17, 12, -42,
    9, -23, -5, -1, 10, -9, 0, -20,
    -6, 7, -19, -25, 6, 12, -8, 32,
    -36, -29, -11, -17, 19, -59, -11, -28,
    0, -8, -33, 6, -7, -15, 12, 32,
    -25, 8, -14, -35, 4, -36, -37, 16,
    -8, 15, 4, 20, -67, 1, -11, -1,
    -22, 24, 24, 25, 43, 31, 2, 6,
    26, 81, -5, -26, 2, 2, 21, 55,
    -17, 2, -29, 36, 16, -4, 21, -33,
    -20, -6, -33, 35, 6, -9, 44, -21,
    -18, 10, 3, -26, 21, -4, 8, 10,
    18, -24, -25, -29, 4, 20, -23, -1,
    8, 22, 14, 30, 10, -27, -19, -13,
    -13, 24, -15, -13, 11, -10, -7, 0,
    24, 11, -34, -5, -36, -93, 14, 6,
    -20, -11, -8, 19, -36, 6, -22, -6,
    20, 25, 1, 25, -17, -12, 28, -3,
    -9, 3, -15, -12, -6, 2, 41, -15,
    6, 26, 2, 7, -5, -8, 5, -41,
    -6, -26, -61, -5, -36, -11, 1, -31,
    -7, 4, 21, -3, 32, -2, -12, 12,
    -2, -8, 2, -15, -21, 31, -5, -10,
    -15, 12, 21, 4, -33, -35, -6, 4,
    -5, 34, 17, 5, 13, -15, -30, 5,
    -13, 15, -27, -24, -22, 9, 40, 9,
    0, -45, -31, 1, -28, 5, -21, 11,
    5, -38, -20, 31, 0, -17, -3, -9,
    -10, 57, 16, 19, 26, -25, -8, -8,
    38, -21, 9, -50, 30, 35, 8, 7,
    6, -5, -4, 5, -5, -21, 28, -47,
    -10, 10, 7, -20, -18, -22, 4, -12,
    -32, 52, -4, -30, -4, 14, 3, 1,
    8, 22, 28, -10, -34, 1, -3, 15,
    9, -27, 35, 12, 13, -3, 13, -15,
    13, 4, -2, -35, -25, 34, 1, 6,
    -29, 29, -15, -14, -3, -5, -11, 54,
    17, 12, 3, -41, -17, -4, 57, -51,
    14, -2, -7, 21, 0, 9, 4, -21,
    -16, -28, 24, 10, 21, 25, 21, 10,
    2, 20, -24, -13, 21, -65, 12, -11,
    -12, -21, 1, -6, -6, -2, 41, -8,
    -9, 22, 19, -2, 0, -24, -22, -10,
    -1, 13, 21, 11, -2, 9, -5, -4,
    -5, 5, -25, 12, -18, -9, -79, 4,
    6, 15, -22, -11, -13, -8, 4, -38,
    -3, -32, 2, 1, 0, 9, -7, -12,
    26, -5, 21, -20, 20, 6, 51, 8,
    43, -14, 22, -51, -12, -21, -23, -26,
    19, 0, -4, 38, -22, 28, -3, 7,
    0, -15, 60, -8, 41, 28, 17, -24,
    3, 8, -2, -1, -26, -18, -20, -9,
    18, 20, 19, 30, -21, 15, -16, -1,
    16, 20, -24, -10, -1, 15, 8, 22,
    21, 13, -14, 8, 11, 24, 38, -9,
    10, 7, 10, -28, 33, -2, -5, 17,
    -8, -2, -27, -34, -11, 36, -4, 29,
    -14, 12, -40, 46, -7, 12, 9, -5,
    -9, 7, -2, 16, 12, -6, -19, -18,
    4, 14, 3, -20, -22, 9, -22, 0,
    13, -16, 57, 29, -39, -12, 8, 15,
    -7, 14, -7, 10, -23, -7, -5, 4,
    14, -40, 13, 18, -8, -12, 15, 15,
    21, -6, 27, -9, 21, -13, -53, 19,
    5, 9, -31, 3, 5, 17, -6, 2,
    14, -4, -13, 8, 15, 1, 3, 4,
    26, -1, -51, -4, 26, 10, 0, -2,
    10, -4, -23, -4, 31, 12, 1, -20,
    12, -11, 3, 12, 40, -36, -38, -9,
    -7, -9, -14, 6, 8, 6, -43, 32,
    -6, 50, 1, 19, -7, -22, 29, 12,
    15, -15, 19, 4, 15, -31, -29, 16,
    4, 7, 40, 18, -18, 19, 21, 5,
    21, 13, 4, -23, 8, 16, -22, -44,
    -13, 43, 21, -3, 0, 0, -18, -20,
    -27, 16, -17, 4, -5, -28, -21, -12,
    18, 22, -28, 4, 8, 49, -45, 6,
    -2, -28, 37, 0, 36, -13, 21, -57,
    -10, -2, 5, -6, 20, -23, -15, 29,
    -11, 0, 17, 1, -13, -9, 18, -36,
    53, -22, -24, -15, -32, 6, -18, 19,
    -13, -18, 2, 17, -10, -11, -13, 14,
    15, -12, 19, 4, -7, -3, 57, -4,
    -2, 38, 32, -21, -16, -18, -18, -5,
    -50, 30, 54, -32, 7, -57, -33, 49,
    5, 11, -20, 5, 14, -13, -27, -23,
    7, -24, -1, -3, 35, -44, 23, 22,
    -24, -18, 20, 0, -40, -24, 28, 14,
    10, 72, 46, -41, -22, -47, 42, -63,
    -127, 36, -23, -14, -49, 12, 23, 61,
    6, -2, 15, -6, -29, 19, -12, 9,
    16, 55, 51, 16, 22, -27, -15, -22,
    -28, -35, 20, -56, -11, -26, 14, -15,
    -27, 21, 0, -17, 27, -43, 28, 3,
    -8, 8, 17, 48, 8, -16, 4, -63,
    35, -34, -9, 6, 14, -8, -47, -25,
    54, -25, -44, 13, 36, -58, -40, -77,
    0, -65, 3, -83, 6, -40, 11, 33,
    42, -27, -29, 36, -15, 1, 14, 1,
    -25, -12, -61, -32, 20, -5, 38, 7,
    -13, -87, -39, -4, -81, 11, 16, 113,
    25, -51, -16, 35, 15, -24, -31, -20,
    21, -63, -18, 39, 8, 40, -38, -11,
    -34, 11, 41, 14, 24, -35, 15, -26,
    30, 22, -50, -27, -52, 7, 34, -45,
    24, -4, -9, 21, -34, 32, 56, 73,
    16, -4, 19, -21, -32, -3, 15, -14,
    -34, -31, 30, 40, 23, 35, -9, 11,
    -55, 32, -40, -13, 10, -36, -37, 31,
    51, -13, -31, 29, -22, -34, 10, -65,
    38, -12, -8, 5, -35, 18, 69, -15,
    2, -29, 15, -8, -41, -33, -3, -21,
    37, -57, -33, -38, 19, 46, 15, -4,
    -9, 6, 73, 1, 1, 15, -1, 53,
    -2, -3, -91, 28, 16, 57, 85, 12,
    13, -9, 38, 23, 0, -32, 5, 23,
    -28, -21, 51, -6, -4, -20, 29, 18,
    -25, -21, -51, -14, 24, 18, 25, -33,
    -36, 19, 6, -6, 36, 14, -20, -51,
    8, 33, 52, 47, -15, 4, -2, 13,
    -51, 24, 78, -28, 87, 40, -33, -37,
    32, 22, 21, 6, -20, 13, -34, -48,
    -50, 20, 59, -25, -44, -24, -2, -17,
    -26, -33, -84, 67, 0, 72, 53, 8,
    16, -6, -16, 1, -25, -37, -21, 35,
    -7, -10, 61, -75, -14, 27, -2, 30,
    -36, -8, 15, 38, -9, -9, 30, -22,
    20, -9, 5, 15, 17, 7, -25, 9,
    -16, -8, 41, 19, -14, -28, -64, 20,
    8, -55, 3, 7, 0, -29, -2, -36,
    -24, -8, -1, -20, 26, 32, 3, 8,
    -8, -42, -26, 22, 2, -18, -31, -4,
    -14, 45, -16, 10, 32, 12, 5, 45,
    -11, 10, 6, 37, -14, -54, -17, 32,
    1, -11, -22, 4, 26, -45, -50, 41,
    -4, 2, 39, -23, 8, 20, 4, -28,
    7, -28, -28, 41, -3, -7, 23, 9,
    -11, 3, -33, -8, 48, -3, 24, -21,
    -25, 9, -22, 0, -14, -19, 19, 37,
    11, -11, 24, 40, -4, 0, -32, 3,
    14, 43, 23, 29, 36, 88, 73, 2,
    8, 20, 22, 49, 21, -17, -17, 34,
    -9, -17, -6, -9, 19, 7, 23, -27,
    34, 10, 22, 67, -16, -78, 21, -15,
    67, -61, -4, -39, -43, -43, 18, -1,
    86, -3, -39, 6, -38, 11, 52, 0,
    8, 31, -28, 9, 60, -5, -7, 29,
    -3, -19, 3, 13, -18, -16, 34, -53,
    -25, -10, 27, -40, 2, -5, 3, -8,
    10, -3, -24, 44, 75, -6, 17, 1,
    6, -7, 16, -2, -25, 15, 5, -16,
    18, -8, 31, 29, -28, -60, -24, 2,
    -20, 24, 1, 14, 25, 11, 50, 2,
    7, 35, 2, 36, -15, 50, 41, 39,
    -11, -55, 39, 39, -8, -44, 33, -45,
    8, 82, 27, -31, -2, 31, -36, 21,
    27, 4, -4, 26, -81, 44, -70, -53,
    -12, -37, -18, 7, 70, 38, 15, 24,
    -30, 48, -5, 6, 27, 34, -9, 13,
    7, -16, 6, 13, -17, -23, -34, -16,
    -4, 35, 6, -21, -79, 16, 20, -19,
    -58, 16, -23, 18, -50, 3, 16, 6,
    -35, -28, -12, 15, 0, 16, -38, -14,
    -63, 0, 38, -21, -10, 75, -14, -51,
    -27, -17, -23, -40, -20, 37, 10, 2,
    11, -35, -13, 44, 8, 14, 60, -73,
    -5, 29, 29, -7, 15, 17, 25, 14,
    -3, 34, 2, -54, 6, 6, 23, 0,
    127, -1, 8, 4, -43, 3, -6, -3,
    9, -44, 2, -45, 2, 7, 63, -7,
    0, 46, -9, 5, -45, -3, 79, 41,
    -25, -15, -17, -40, -8, 19, 0, -22,
    20, -62, 20, -27, -14, -32, 35, 26,
    31, -24, -54, -48, -12, -7, 2, -85,
    -6, 4, -11, -32, 1, -33, -28, 10,
    -66, -29, 0, -1, 15, 14, 32, 24,
    -36, 6, 7, 77, 33, -59, -27, -22,
    22, -23, -10, -19, -57, 35, -40, -17,
    -12, -13, 47, -21, 17, 16, -4, 76,
    45, 40, -5, 34, -8, -11, -31, 20,
    1, 2, 34, 16, 7, -20, -90, -4,
    32, 30, 37, -20, 2, 52, -15, 20,
    13, 17, 14, -12, -7, 25, -22, 18,
    -13, 77, -1, -22, 38, 29, 13, -17,
    6, 17, 33, 22, 29, 58, 5, -10,
    -66, 54, -42, -51, -13, -3, 9, -16,
    11, 2, -3, 31, -4, 24, -36, 8,
    -107, -22, 22, -11, -40, 18, -16, 25,
    29, -11, 28, 6, 1, 56, -21, 16,
    75, -36, -26, 6, -61, -18, -2, 19,
    -31, 3, -8, 14, -11, -19, -9, 6,
    -18, -20, 3, -5, 14, -40, -89, 0,
    -21, 50, 42, -4, -7, 23, 24, -17,
    -26, 1, -27, 2, 21, -4, 9, -2,
    15, -11, -50, -4, 12, -8, 2, -11,
    -16, 35, -7, -13, 20, 18, -28, 31,
    -44, -40, 2, 38, -52, 8, 17, 100,
    -30, 24, -33, 27, 63, 13, -84, 42,
    -4, 67, -24, 76, 15, -55, 34, 47,
    -8, -10, -26, 36, -22, -39, -14, -6,
    68, -21, 15, 5, 6, 8, 11, -26,
    47, -7, -15, 6, 9, 9, -40, -42,
    18, 45, -11, 0, -9, -22, -31, -3,
    54, 16, 74, -7, -8, 12, -2, 24,
    -53, -74, -36, -11, 16, -9, -28, 27,
    9, -13, 23, -18, 46, -64, 18, -104,
    -87, -42, 9, 6, 62, -17, 7, 0,
    4, 12, 42, 7, -10, -8, -30, 23,
    -19, -11, 2, -21, -2, 12, -4, 12,
    33, -23, 0, -8, -11, -14, 1, 10,
    21, 14, 6, 78, 30, 39, 15, -26,
    28, -55, 3, -42, -44, 9, 37, -20,
    23, 61, 23, -3, -10, 24, -65, -14,
    -67, 29, -11, -5, 16, 20, -100, 3,
    -41, 12, -42, -8, 45, 84, 7, 14,
    48, 5, 30, -25, -2, -2, 19, -1,
    -7, 4, -26, 18, 31, 8, 13, 24,
    9, 1, -3, -12, 2, -6, -1, -25,
    -11, -13, 26, -27, 35, -26, 20, -44,
    -33, -41, -13, -3, 27, 25, 5, -22,
    5, -11, 5, 18, 0, -4, -5, 16,
    5, 114, 16, -18, -18, 37, -44, 32,
    1, -65, 76, -27, -38, -9, 15, 6,
    -16, 1, 27, -64, -4, 32, 11, -22,
    3, -4, -20, -8, 0, -16, -4, -8,
    -16, -37, 0, -2, 12, 0, 10, -5,
    -25, 30, 5, 24, 21, 8, -43, -47,
    -11, 31, -20, -13, 32, -8, 17, 16,
    9, -24, 24, 0, 31, 7, 1, -3,
    9, 3, -4, 0, 3, 2, -32, -2,
    -13, 72, -7, 24, 11, 8, -16, 0,
    -38, 4, 5, 15, 10, -4, -42, 41,
    11, 9, 15, 0, -5, 6, 20, 6,
    13, -4, 12, -20, -23, -19, -39, 9,
    3, -13, -3, -60, 9, 20, 32, -40,
    21, 5, 29, 10, -32, -33, -13, 1,
    -12, -29, -10, 5, 14, -11, 2, -12,
    4, 24, 3, 8, -3, -17, -6, 23,
    -3, 14, -19, 48, 22, 30, 24, 2,
    -17, -36, 6, -10, -18, -13, -23, -23,
    13, 1, 3, -14, 8, -17, 16, -21,
    -3, 6, -5, -2, -20, 3, 43, -15,
    -23, 26, -22, 3, 7, -24, 4, -6,
    -7, 8, 3, 13, -31, -2, -11, 17,
    -36, -23, -3, 1, -7, -3, -26, 5,
    -7, 2, 8, 14, 20, -1, -11, -36,
    -24, -26, -65, 5, 2, 31, -21, -34,
    -5, 3, 19, 8, -10, 54, -18, -4,
    32, 14, 18, -12, -6, 24, -10, -2,
    2, -4, -2, -25, -19, 25, -15, 36,
    -21, 40, -13, -2, -27, 11, -9, 4,
    29, 6, 15, 6, 5, -20, 14, 25,
    9, -2, -19, -13, -1, 8, -3, 13,
    -8, 5, 28, -27, 23, -27, -6, 25,
    33, -29, 25, 7, 14, 26, -2, 8,
    -32, -2, -25, -11, -12, 8, -28, 10,
    -18, 19, -40, -8, -25, 29, 2, -13,
    -12, -9, 11, 24, -10, 16, -21, -16,
    6, -11, 10, -27, -6, 26, -11, -17,
    40, -7, 35, -10, 23, 2, -18, 4,
    -5, -18, 7, -15, 0, 7, -7, 16,
    -9, -5, 10, 18, -9, 9, 37, 27,
    31, 34, 1, 13, 24, -32, 4, -8,
    1, 3, -12, 27, -12, -19, -6, 25,
    2, 16, 7, -46, -6, 2, 24, -9,
    -1, -14, 3, 17, 21, -6, -7, 23,
    -29, 10, -17, -19, 27, 19, 12, -14,
    -11, -5, -6, -25, -12, 32, 9, -2,
    -8, -3, 9, 2, -13, 12, -8, -15,
    -1, 11, 16, 12, 19, 2, -20, -10,
    25, -36, 10, -5, 0, 18, -23, -19,
    -9, 21, -9, -4, 20, 13, 13, 5,
    -32, 4, 15, 0, 1, 28, 24, 2,
    -5, 4, -11, -14, 11, 14, 11, 15,
    3, -40, -25, -15, 4, 17, 6, 5,
    -3, -9, 12, -29, -32, -13, 9, -12,
    -43, -17, 31, -2, -5, -11, 24, -32,
    -16, -10, -28, -7, 0, 3, -47, -16,
    -7, 1, -14, 16, -38, -16, 14, -10,
    -27, -2, -3, -3, 10, -34, 6, 2,
    -3, -8, 6, -10, -8, -7, -46, 33,
    96, 1, 4, -2, 44, -9, -37, 2,
    -41, 37, 8, 1, -42, 12, 3, -32,
    21, 23, 6, 11, 27, -53, -25, 27,
    -5, 7, -8, 8, 3, -35, 0, -9,
    8, -17, 16, 17, 0, -21, -19, -16,
    16, 16, -45, 68, -10, 18, -13, 12,
    1, 27, 1, 22, 23, -8, 7, 21,
    -4, 17, -4, -9, -3, 20, -8, 6,
    8, 5, 11, -75, 19, -9, -2, 35,
    12, 1, -9, -6, -24, 9, -9, -10,
    -13, 2, -10, -20, -5, -13, -11, 23,
    13, 5, 42, 13, -12, 32, -1, 11,
    -1, 2, -13, 11, -4, 24, 4, -13,
    -6, -10, -2, -17, -25, -49, -2, -7,
    -16, -4, 9, 1, -2, 11, -13, 4,
    -8, -19, -44, -7, -35, -9, 14, 8,
    2, 6, -18, 2, 13, -13, -21, 16,
    18, -12, -19, -3, -16, -37, -1, -2,
    -30, -4, -1, 2, 27, -21, -10, 2,
    1, 13, -9, 14, 2, 0, 20, 12,
    -2, -11, -14, -6, -26, 37, -4, -12,
    -20, -29, -39, 10, -10, 3, 13, 16,
    -51, 0, -15, 2, -26, 26, -24, -1,
    1, 27, -7, 3, 21, 15, 15, -36,
    7, -1, -9, -10, 3, 9, 10, 10,
    -60, 0, -24, 21, -31, -27, -4, 17,
    1, 5, 14, -19, 4, -12, 8, -8,
    13, 9, 6, 19, 10, -23, -41, 18,
    -3, 10, 7, -22, -24, -22, -16, 20,
    19, 0, 5, -13, -30, -23, -10, 1,
    19, 41, 48, -6, 47, -4, -6, 18,
    -3, -6, -21, 3, -23, 10, 23, -8,
    -8, 23, 0, 1, -3, 45, -3, 8,
    20, 23, -30, 3, 50, -16, 28, 35,
    -8, -48, 14, -8, 8, 14, 3, 10,
    8, 37, 9, 12, -22, 0, -13, 1,
    -8, -5, -11, -13, 7, -11, -15, -1,
    11, 9, 13, -24, 17, -1, 27, -4,
    5, 21, -8, 8, -9, -1, 1, -8,
    -31, 26, 0, -6, 2, -34, -32, -18,
    -14, 35, 7, -53, -15, 7, -21, -20,
    -28, 32, 54, 22, 5, 14, 9, 6,
    -9, 5, 23, -6, 2, 0, -1, 11,
    -5, 5, 0, 27, -4, 0, -2, 21,
    -14, -10, -4, -7, -9, 0, -2, 6,
    -32, 9, 13, 15, 4, 4, -9, -10,
    15, -31, 15, -7, 16, 5, 11, 5,
    -9, 36, 3, 10, -6, 11, -16, 21,
    18, -36, 23, 13, 15, -13, 11, 0,
    29, -11, -1, -32, -8, 14, -16, 14,
    -6, -13, -1, -29, -9, 33, -11, 8,
    6, -1, 1, -12, -48, -5, 0, -9,
    -1, -3, 66, -9, -17, 7, 49, -7,
    29, 3, -1, -20, -25, -50, 5, 18,
    -14, -17, 15, 19, -4, 2, 3, 3,
    24, 15, -2, -9, -1, 0, 5, -9,
    3, -8, -8, -21, 19, 9, -5, -2,
    -51, 9, -8, -18, -3, -2, -3, -8,
    -4, -30, -19, 18, -8, -5, -8, -10,
    14, 26, -19, 22, 1, -19, -41, -4,
    -10, -10, -6, -3, -47, -38, 18, 4,
    -8, -36, 9, -33, 2, -31, 8, -14,
    74, 11, 9, -5, 6, 2, -7, -4,
    -15, -25, -3, -11, -4, -28, -24, 34,
    3, 16, -12, 1, 9, -4, 29, -15,
    0, 44, -39, -7, 13, -14, 7, -36,
    3, -13, 13, -12, 8, -9, 7, 38,
    -5, -38, 5, -4, -22, -12, -19, 18,
    -8, 108, 9, -27, -3, 42, 14, -14,
    10, -60, -15, 0, 10, -30, 26, -24,
    13, 13, -4, -30, 18, -22, -14, 30,
    -2, -13, -7, -40, 20, -13, 2, 14,
    -34, -20, -9, 11, 13, 18, 15, -15,
    -11, -20, 18, -13, -26, -28, 3, -67,
    11, 10, 2, 16, 24, 5, -27, -34,
    26, 21, 21, -3, -3, -34, -32, 33,
    1, 16, -2, 4, 17, 17, -33, -30,
    28, 17, -5, -23, 11, -8, 18, -10,
    8, -1, -17, -24, -36, 12, 6, 30,
    21, -2, -11, 24, -5, 9, -3, -12,
    0, 6, -12, -18, -6, 16, -8, -3,
    11, 4, 53, 10, 1, -22, 54, -13,
    -1, -27, 17, 5, 2, -17, 46, 11,
    47, 11, -5, 34, 42, -18, -20, 5,
    15, 10, 14, 7, -4, -30, -6, 38,
    -20, 8, -30, 70, 21, -6, -21, -14,
    16, 18, 11, 2, -27, -37, 9, 12,
    46, 13, 12, -28, -2, -50, -2, 7,
    -6, -5, 5, 7, -6, -11, -13, -39,
    -16, -8, 16, 34, 21, 38, 30, 18,
    14, -19, 19, 13, -24, -23, 2, 2,
    -14, -63, -15, 44, -15, -30, -10, -25,
    -10, -28, 26, 19, 21, -25, 35, -5,
    -50, -29, 44, -33, 31, -8, -4, -1,
    25, 28, -14, 12, 0, 29, -12, -31,
    -5, 55, 18, -33, -17, 13, -6, 16,
    -6, 25, -16, -14, 13, 15, -11, -28,
    -96, -21, 13, -49, -9, 23, -1, 25,
    -3, 6, -23, 9, 3, -12, 60, 4,
    14, -9, 12, 14, 22, -18, 17, -8,
    2, 8, 0, -4, -6, -30, -32, 4,
    20, 26, -60, 9, 3, -13, -54, -1,
    -7, 13, -12, 15, -13, 22, 35, 5,
    -23, 72, 32, 56, 9, 12, 0, -7,
    -7, -9, -14, 9, 6, 26, 3, -8,
    -111, -16, 36, 38, -28, 5, -29, -6,
    15, 26, 30, 9, 2, -20, -19, 13,
    18, -50, 2, -27, -16, 1, -15, -31,
    -1, -6, 3, -8, -7, -3, 57, 4,
    -18, -64, -41, -18, 5, 14, 7, -13,
    -15, 25, 22, -2, 32, 24, 42, 17,
    -54, -25, 32, -1, 42, 0, 16, 25,
    0, -6, 10, 3, -8, -42, 1, 11,
    -39, -1, 42, 7, 3, 26, -10, -7,
    1, -10, -14, -19, 11, -29, 19, 22,
    22, 9, 9, 51, 4, -17, 2, 15,
    -2, 5, 24, 5, 16, 26, 18, 11,
    3, -32, 43, -25, -26, 9, -12, -45,
    -22, 12, -25, -18, 9, -15, 1, 10,
    -27, 14, 25, -24, 34, -15, 23, 3,
    -9, -14, -4, -16, -10, 14, -14, -3,
    9, 56, 12, -35, -10, -2, 5, -7,
    4, -2, -20, 2, -24, -19, 8, 4,
    10, -2, 52, 6, 33, -11, -21, 15,
    -17, 10, -14, -32, -15, -5, -6, -11,
    12, 38, 7, 10, -27, -20, 4, -2,
    -31, -6, 7, -11, -1, -25, 11, -39,
    -14, 32, 8, -37, 7, -9, 34, -7,
    73, -2, -1, -9, 34, -16, -17, 16,
    -58, 72, -11, 8, -32, 5, 9, -10,
    43, 15, 30, -18, -27, 2, -3, 20,
    25, 28, -8, -8, -25, 3, 4, 11,
    -5, -24, 21, -24, -23, 25, -7, 4,
    13, -49, -31, 41, -14, 5, 20, -23,
    1, 7, 33, 7, -60, -12, -14, 15,
    -13, -3, -17, 6, -17, 18, -26, -4,
    -2, 13, 23, -79, 7, -35, 6, 19,
    -22, -15, -24, -35, 29, -2, -1, 3,
    -32, -12, 5, -12, -2, 22, 10, -41,
    -2, -23, 18, -14, 17, 29, -13, -18,
    -24, -9, -11, -1, 12, 12, 4, -12,
    21, 0, -16, -33, -14, 2, -13, -49,
    -6, -3, 17, 10, -11, -27, 25, -9,
    -7, -21, -41, -15, -74, -2, 0, -2,
    -37, 10, -15, 0, 35, -2, 8, 12,
    0, 39, 15, 15, -7, -44, -35, -1,
    -16, 8, 18, 12, 5, -31, 6, 5,
    -3, 17, 63, 1, 12, 9, 3, -16,
    -8, 7, -9, 20, -18, -10, 21, 15,
    8, 76, 29, 7, -2, -5, -18, -6,
    -27, -17, 23, 4, -1, 16, -13, -29,
    -41, -34, 13, 5, 50, 19, -4, -3,
    3, -3, 19, -2, 4, -11, -15, -21,
    12, -18, 69, 7, 20, 21, -19, 17,
    49, -19, 15, -1, -37, 30, -5, -13,
    -26, 0, 23, 4, -37, -7, 35, -35,
    10, -10, -9, -14, -21, -37, -15, -4,
    28, 10, 16, -19, -31, -6, 29, 2,
    18, 6, 7, -11, 38, 0, -34, 45,
    29, -14, -29, 8, -12, -17, -9, 12,
    -19, 13, 7, 0, 12, 24, 2, -15,
    -22, -36, 4, -14, 5, 13, 5, 1,
    -14, -33, 2, -4, -19, -33, 29, -22,
    15, -14, 10, -8, 6, 28, 14, -34,
    -1, 0, -9, -14, 6, 5, 15, 22,
    42, -32, 5, 35, 21, -6, -3, 9,
    9, 2, 14, -12, 10, -23, -33, 21,
    -14, 6, 2, -6, -22, 8, -12, -5,
    5, 70, -2, -81, 7, 1, 16, -17,
    -23, 1, 33, -20, -13, -1, -5, 14,
    16, 10, -2, 7, 22, -1, 15, -21,
    -16, -44, -14, 47, -16, -29, 14, 12,
    10, -23, 1, -5, -5, -13, -15, -2,
    -43, -19, -8, -1, -17, -37, 36, 5,
    -21, -9, 15, -10, 0, 11, -9, -4,
    -19, 32, 21, 20, -3, -4, -4, -10,
    7, -48, 13, 2, 22, 22, -7, 5,
    13, 3, -3, -1, -41, 10, -23, 5,
    -9, 6, 7, 15, 32, -14, 23, -19,
    -22, 33, 15, -30, 16, -20, 23, -39,
    -21, -10, 81, -12, 7, -12, 21, -16,
    -71, 4, 56, -31, -27, -35, -15, 39,
    31, 10, 10, 22, -24, 0, -25, -12,
    18, 5, -23, -11, -26, -3, 21, 6,
    -10, 2, 8, -25, -1, 15, -9, 27,
    -30, -13, 14, -63, 46, 37, 6, -30,
    6, 7, -9, 13, -20, -3, -15, 8,
    -1, -13, -15, 29, -43, 4, -2, 18,
    14, 3, -11, 3, 13, -11, -24, 45,
    8, 61, -16, 26, 23, -11, 7, -34,
    113, 16, 61, -5, -12, -10, 13, 48,
    31, -1, -23, -18, 7, -23, 31, -69,
    -6, -23, 9, -22, -49, -9, -31, 12,
    77, 30, 2, 38, 18, -1, 33, 54,
    18, 24, -1, -34, 3, 26, -72, 15,
    19, 6, 18, -2, -14, 5, 25, -75,
    -6, 127, -13, -22, 8, 45, -21, -4,
    48, -48, -8, 6, 32, -18, 23, 5,
    -19, 48, -66, 0, -10, -31, -34, 38,
    -21, 6, -49, -33, 22, 69, 22, -31,
    -28, -43, -17, -13, -20, 32, 43, 47,
    11, 18, -41, -33, -19, -13, 6, 30,
    13, 26, -6, 49, -3, 35, -72, 69,
    -35, -21, 25, -18, 12, 20, -34, 31,
    -10, -3, -4, 12, -18, 19, 2, 48,
    -2, 14, -97, -28, 0, -11, -8, 24,
    -35, 30, 51, -57, 20, -3, 0, -6,
    34, -61, -4, 37, 50, 13, -19, -56,
    11, 11, -6, -24, 10, -4, -10, -23,
    55, 13, 32, 62, -31, -5, -29, -33,
    -36, -65, 2, 19, 49, 33, -17, -14,
    47, -34, -66, 96, -25, 8, 13, 33,
    10, 10, 17, 5, 6, -75, -18, 4,
    -87, -20, 40, 55, 4, -9, -32, -13,
    29, 14, -46, 28, 38, 91, -7, 67,
    100, -6, -1, -49, -4, 127, 18, 20,
    -3, 2, 5, 16, 7, 12, -44, -27,
    2, -64, -19, 68, 20, 8, -15, 53,
    70, -36, -68, -35, -2, -62, 88, -12,
    -49, -80, 10, -1, -4, -33, 17, 10,
    -26, 7, 25, 4, -31, -2, 65, -11,
    35, 4, 28, -20, 45, 6, 7, -8,
    20, 14, 0, 4, 14, -44, -57, 5,
    -18, 30, 2, -18, 4, -6, 20, -14,
    -5, 5, -8, -12, -5, -7, -29, -42,
    21, -82, 8, 18, -72, 12, -44, 5,
    -34, -24, -23, 73, -21, 42, -44, -29,
    0, -36, 25, -1, -8, -37, -29, -29,
    3, 4, 13, -16, -18, -3, 20, 33,
    52, 20, 69, 9, -30, -5, 5, 7,
    12, 38, 18, 6, 4, -27, -13, -28,
    -93, 123, 14, 88, 10, 20, 22, 59,
    -3, -1, -17, 7, -28, 21, -11, -23,
    31, 52, -60, 4, -18, -6, -5, -4,
    24, 59, 26, 3, -19, 7, 19, -60,
    -1, -1, -7, -75, 32, 40, 24, -25,
    19, 21, 6, -6, 53, -1, 68, 22,
    20, 69, -10, -15, -31, 28, -29, 3,
    57, 34, 84, -31, 8, -27, 19, -19,
    -25, -7, 20, -19, -2, 47, 7, 14,
    10, 3, 18, 17, 19, -58, 14, -15,
    97, 32, -20, 30, 56, 9, 17, 32,
    13, -6, -27, -29, -19, 36, -74, -36,
    42, 5, -52, 98, -11, -2, -4, -9,
    -8, -2, 20, 7, 41, 28, 32, -2,
    -66, 43, -38, 14, -4, -20, 12, 13,
    -35, -19, -14, -80, -6, -26, -32, -5,
    -6, -9, -23, 1, -36, -42, -34, 1,
    4, -22, 29, -30, -38, 26, 8, -45,
    24, 41, -42, 7, -12, -52, -33, -18,
    -84, -3, -18, 15, -23, -43, -36, 66,
    -34, 26, 17, 3, 2, -2, -44, 91,
    -11, -14, -17, -29, -56, -39, -6, -6,
    49, -21, 18, 23, 28, 7, 7, 32,
    26, 8, -17, 36, 42, 51, -46, -3,
    -21, -39, 34, -51, 35, 30, 21, -13,
    73, 12, 2, -4, 39, 1, 15, 12,
    -25, -21, 34, 8, -4, 18, 9, -32,
    -53, 69, 65, -11, 45, 5, 13, -53,
    28, 2, 16, -64, 28, 0, -5, -27,
    1, 3, 37, -18, -21, 61, -11, 40,
    52, 33, 61, -2, 46, -25, 51, 12,
    10, -38, -32, 23, 54, -21, -14, 17,
    -26, 19, 2, 45, -49, -1, 8, 12,
    20, 1, 32, -101, 31, -42, 33, 25,
    -96, -3, 15, -12, 51, 31, -35, 13,
    -41, -4, 22, 23, 8, 10, -12, 27,
    13, -24, 47, -13, -39, -9, -19, -23,
    18, -10, -36, -5, 7, 60, 26, -58,
    16, 24, -11, 45, 1, 26, -16, -10,
    44, -1, 7, 26, -7, 55, -5, -28,
    -10, -46, -56, -68, -71, 14, 26, 14,
    -31, -4, 3, -5, 42, 87, 17, 10,
    -52, -35, 24, -16, -9, 5, 19, -40,
    -1, -17, 0, -12, 6, 16, -11, 33,
    1, 10, 91, -33, -2, -6, 16, 9,
    -29, -3, 19, 8, -9, -3, -29, -46,
    -15, 36, 20, 49, -13, -23, 48, -55,
    -37, -31, 26, 30, 15, 8, 16, -48,
    -58, -25, 1, 42, -17, 4, -28, 16,
    0, 8, 9, -7, 25, -12, -36, 30,
    -31, -18, 104, -8, -22, 31, 31, 10,
    39, -11, 51, 8, -15, 34, -1, -25,
    -19, -60, 7, -14, 31, -8, 23, -60,
    -8, -13, -5, -26, 13, -14, 18, 36,
    45, -13, -30, -31, -16, 22, 29, 28,
    -7, 1, 16, -1, 18, 9, -6, 21,
    16, -21, -28, -1, -99, -1, -23, 1,
    -4, 12, 4, -7, -30, 51, 37, -2,
    -34, -5, 7, 94, 3, 25, -14, -14,
    -31, -4, 49, 15, -8, 10, 21, -15,
    25, -63, -45, -7, 28, -46, 35, -34,
    14, 15, -22, -1, 13, 43, -28, 22,
    33, -66, -9, 14, -48, -31, 4, 34,
    -35, -26, 1, -15, -64, 8, 59, 10,
    5, -3, -24, 24, 3, -8, 38, 3,
    -9, 75, 10, -104, -40, 10, 32, -15,
    28, -47, -30, -8, -38, -14, 4, 29,
    47, -8, 44, 9, 10, -30, 7, -26,
    4, 3, -25, -6, -7, -43, -17, -2,
    -12, -39, -23, 3, -59, 36, -17, 0,
    56, -11, 14, 43, 21, -19, 32, 49,
    6, 31, 35, -42, 15, 14, 3, 1,
    34, 44, 9, 7, 8, -1, -12, 4,
    39, -19, 31, -1, -10, 42, -21, -25,
    -38, 10, -82, -47, -34, 11, 10, -31,
    -8, 0, 3, 35, -66, -38, -4, 6,
    -38, 70, -39, 16, 4, -17, -30, 22,
    6, -18, 89, 7, 20, -3, 37, -70,
    -24, 29, -70, 60, 48, 81, 47, -90,
    12, 4, 66, 4, 1, -12, -47, 6,
    67, 15, -76, -8, 33, 8, 16, -26,
    -6, -2, 7, -14, -5, 1, -9, 65,
    45, -16, -35, -71, 55, -5, 45, -16,
    -1, -22, -11, -33, 45, 18, 24, 35,
    -28, -72, -35, 39, 25, 61, 59, -12,
    4, -5, 14, 15, 29, 10, -72, -7,
    -48, 2, 3, -54, -31, -40, -7, 3,
    18, 0, 7, 6, 14, 26, -35, 24,
    -13, -11, -5, -13, 20, -14, -13, -25,
    24, 16, 7, -32, -7, 1, 17, 27,
    -5, 3, 16, 28, 13, 13, 22, 4,
    -4, -18, -33, 21, -21, -18, 18, 22,
    -7, -17, 9, 17, -14, 34, -6, 15,
    -2, 17, 5, 23, 3, -32, 34, -6,
    -13, 16, 0, -18, 30, -10, -2, -8,
    -23, 8, 2, -3, 3, -82, -3, 47,
    7, -8, -4, 7, 5, 20, -11, -4,
    -38, 9, -17, -53, 20, -17, 1, 13,
    16, -26, 14, -20, -8, 9, 17, 20,
    13, -11, 2, 6, 103, -25, 27, 10,
    -16, -7, -9, -12, 13, -13, -8, 17,
    23, -1, -2, -3, 4, 10, 9, 2,
    7, 21, 23, -6, 12, -4, 5, 6,
    -32, -11, 28, -6, -19, -42, 4, -49,
    -14, -1, -22, 14, -11, 7, 40, 24,
    11, -26, 17, -21, 22, -19, -16, 10,
    -14, -21, 24, -8, 2, 5, -10, 10,
    -6, 8, -3, -6, -6, 14, -17, 10,
    7, 10, -27, -6, 24, -11, -6, -4,
    15, 8, -48, 4, -21, 9, 7, 12,
    -6, 14, -3, 14, 2, -15, -19, 1,
    18, 11, 5, 1, -9, -51, 14, 29,
    -7, -11, 7, -3, 14, -22, 6, 6,
    11, 56, -2, 35, -27, 34, 26, -4,
    6, -7, 3, 24, -17, 6, 7, -15,
    -17, -17, -33, -32, -12, 1, 21, 12,
    -15, 22, -11, -13, -9, -11, 25, -9,
    6, 23, -30, -30, 13, 11, -34, 23,
    -7, 8, 6, -20, 20, 5, 18, 9,
    -20, -19, -10, 11, 15, -46, 58, -38,
    0, -5, 9, 6, -19, -22, -20, 34,
    -6, 6, 55, -10, -4, 48, -5, 39,
    -5, 0, -6, -11, -13, 26, -7, 16,
    3, 0, 5, -27, 19, -4, 10, -39,
    8, -19, -15, 5, 28, -10, 0, -27,
    18, -7, 1, -2, -40, -38, -16, 1,
    27, 2, -23, -6, 1, 3, -8, 1,
    1, -4, -13, -12, -27, -8, 41, -29,
    -8, -5, -15, -1, 1, -2, 9, -2,
    24, -17, 4, 23, 22, 15, -3, -13,
    1, -3, -10, 6, -9, -4, -6, -3,
    -4, 6, 16, 20, -16, 22, 1, -6,
    8, 3, 5, -9, 11, -33, 14, -7,
    0, -5, 19, 5, -20, 18, -18, 7,
    0, -9, -16, 0, 18, 17, 12, 3,
    -9, 42, 11, 12, 21, -18, 10, -18,
    8, 3, 4, -11, -2, -5, 2, -35,
    -1, 3, -63, 30, 28, -8, 1, 12,
    -5, -19, 12, 16, -6, -25, -6, 21,
    -25, 6, -12, 33, 4, -22, 2, -2,
    -8, 6, -28, 20, 20, 23, 1, -32,
    8, 27, 2, -10, -12, -1, -5, -18,
    15, 8, -14, -6, 5, -17, 14, 9,
    -9, 31, 1, 2, -35, -12, 27, -32,
    14, 17, 9, 8, -22, -6, 26, 1,
    -13, 12, -27, -26, -4, 6, -27, -21,
    22, 0, -5, 1, 5, -18, -17, 12,
    -2, 14, 18, 17, 23, 41, 2, -9,
    -20, -5, -1, 2, -1, 21, 56, -7,
    37, -28, -25, 19, 4, -8, -15, 8,
    -20, 6, -6, -13, 19, -13, -28, 8,
    -3, 10, -22, -4, 18, -3, 47, 19,
    6, -19, 11, -3, -4, 10, -22, -21,
    19, 5, 5, -24, -3, -12, -34, 19,
    30, 22, 6, 1, 21, -16, 14, 2,
    1, -16, 15, -15, 44, -48, -3, 41,
    4, -2, -22, -3, 10, 7, -9, 42,
    24, -7, 5, 5, 25, -15, -7, 18,
    2, 19, 6, 14, 13, -21, 11, -15,
    -22, -6, 33, 3, -10, -21, -14, -34,
    -38, 4, -18, 22, -5, 9, 27, 4,
    12, 12, 1, 12, 5, -35, -6, 32,
    30, 5, -11, -17, 21, 24, 12, -1,
    39, 13, -1, 4, -15, 14, -23, -52,
    -12, -12, 18, -14, 57, -2, -26, 12,
    -22, -3, -8, 25, -6, 12, -7, -12,
    -2, 3, 11, -16, -18, -1, 18, 1,
    -13, 1, 2, -4, -12, 46, 28, -15,
    -3, 7, 13, 13, -27, 14, -3, 1,
    12, 31, -24, -17, -2, -2, 33, 4,
    5, 1, 0, 30, -14, 31, 18, -5,
    -6, 19, 26, 30, -19, -19, 35, 0,
    9, 18, 5, -27, 25, -2, -1, -6,
    1, -25, -13, -10, 24, -27, -8, -9,
    2, -9, -10, -6, 2, 24, -13, 2,
    6, 3, -7, 2, 48, 27, -19, -37,
    -2, 7, -17, 4, -13, 20, -5, -6,
    -29, 9, -6, 52, -7, -1, 26, -8,
    13, -2, 14, -10, 14, -14, 23, 2,
    38, 21, -19, 12, 12, 11, 30, 19,
    8, -4, 0, 33, -14, 26, 13, -11,
    25, 24, 5, -15, 1, -12, 16, -20,
    1, -3, -27, -21, 23, 16, 2, -11,
    -24, -21, -11, -19, 67, -24, 47, -18,
    21, 0, -1, 45, -28, -25, 21, -16,
    25, 28, 3, 11, 20, -6, -10, -3,
    -7, -17, 8, 3, 2, 23, -2, -5,
    33, 15, 1, -20, 7, -4, -32, 7,
    -22, 3, -16, 20, 20, 13, 12, -2,
    -1, 13, 37, -30, -3, -15, -21, 10,
    -3, -12, 12, -3, 29, 22, -7, 4,
    16, 11, -32, -9, -12, 9, -33, 7,
    15, -18, -4, -23, 19, 9, 5, -8,
    -8, -32, 4, 26, -5, -49, 0, 6,
    -27, 19, 2, 10, 10, 9, 5, -1,
    7, -16, -16, 9, 31, 32, -1, 16,
    -5, 9, -18, 22, 8, 4, 0, -9,
    -23, 9, 11, -2, 15, 24, -16, 25,
    -2, -2, 21, 22, -6, 11, 12, -13,
    11, -9, -3, -25, 4, -46, 0, -19,
    -25, 19, -13, 5, 3, -3, -17, -28,
    10, 15, 50, -29, -40, -55, 5, 20,
    11, -17, -3, 1, 28, -2, 7, -12,
    27, -5, 21, 17, 3, -14, -21, -1,
    15, -12, 11, 18, 14, -1, -31, 10,
    32, 47, -7, -12, -8, 45, -9, 7,
    14, 1, 8, 7, -2, 12, 26, 5,
    5, -14, -41, 17, 10, 8, 1, -36,
    -39, 4, -36, 21, -14, -2, -9, -11,
    2, 20, 23, 12, -17, -12, -15, 1,
    -2, -13, -11, -27, 30, -20, 1, -12,
    4, 11, 29, 17, 35, 65, 6, 35,
    44, -11, -2, -38, 37, -3, 27, -2,
    -31, 20, 40, 21, 0, 12, -12, 16,
    12, -27, -14, -20, -17, 14, -9, 17,
    -40, -11, -2, 26, 0, 23, -3, -24,
    -16, 3, 1, -11, 36, -35, -53, -1,
    -12, -20, -15, 54, 16, -36, 2, 2,
    -14, -26, -12, -18, 8, -12, 10, -28,
    5, -21, 50, -59, -23, -40, -24, 85,
    -21, -19, 24, 2, -30, 8, 6, 8,
    5, 16, 23, 42, 12, -47, 31, -13,
    11, 15, -6, -16, -2, -2, 6, -8,
    -2, -23, 35, -12, -16, -10, -28, -80,
    31, 34, -5, 0, 23, -39, -14, 11,
    -1, 67, -23, -11, -10, 21, 18, -5,
    3, -27, 21, 18, 16, -20, 21, 51,
    13, 31, -46, -9, -76, 10, 9, -27,
    -22, 20, -12, -62, 32, 10, -10, -14,
    -4, 26, 26, -1, 22, -13, -28, -2,
    15, 35, 9, -3, 17, -46, -57, -72,
    -47, 19, -9, 1, -36, -39, 34, -2,
    -11, 2, -38, -1, -33, 23, 18, -9,
    11, 12, 12, 2, 19, 10, 3, -5,
    20, -39, 15, -3, 24, 22, -13, 27,
    -33, 23, 18, 10, 26, 24, -36, 8,
    -20, 15, 3, 0, -3, -13, 6, 16,
    40, 36, 3, 43, 7, -4, -18, 5,
    -13, 9, -24, 16, -1, 4, -19, -4,
    -35, 21, -7, 18, 13, -54, -9, -9,
    -17, -13, -11, 0, 6, -1, 27, 23,
    14, 14, 3, 35, -22, -17, -1, -10,
    2, 6, -7, 43, 3, 8, 24, 2,
    -11, -1, -46, -27, -38, -39, -82, -1,
    7, -13, -34, 5, -21, 25, 10, 29,
    -1, -40, 60, 4, -3, -1, 11, 15,
    -31, 1, 6, 6, -12, -16, 26, 42,
    -28, 14, 16, -20, -62, 46, -51, 1,
    -6, 15, -10, -26, -25, -21, -18, 48,
    85, 28, -19, -4, -1, 9, 12, 22,
    -26, 11, -28, -5, -12, 3, -11, -8,
    0, 19, 36, 55, 13, -8, 55, 62,
    18, -37, 64, -17, 11, -14, 2, -31,
    -5, 14, 11, -16, -33, -39, -15, -31,
    71, -4, 17, -28, 62, -13, 2, -31,
    27, -41, 1, -5, 17, 0, -11, -4,
    -32, 38, 22, -16, 13, 16, -3, -18,
    -42, 6, 4, 15, -21, 3, 13, -3,
    -41, -3, 25, -3, 6, -27, 22, 25,
    27, 3, -41, 8, -7, 31, -21, -18,
    22, -15, -1, -2, -22, -69, 18, 1,
    9, 26, 21, 28, 6, -12, -26, -20,
    -24, 23, -31, 2, -17, -40, 10, 1,
    -3, -15, -3, 5, 82, 14, -26, -5,
    2, 24, 23, 29, 35, -8, 26, -12,
    6, 1, 9, -2, 13, 0, 12, 15,
    6, -11, -6, 3, -10, -20, 25, 23,
    3, 18, -23, 26, -17, -15, -17, 18,
    0, 37, 32, 10, -17, 9, 4, 9,
    15, 11, 49, 20, -4, -13, 1, 21,
    9, 7, -18, 12, 9, 22, 40, 26,
    7, 9, 12, -21, 48, 11, 47, 6,
    0, 8, 17, -26, 42, -3, 4, 2,
    -17, -5, -6, -47, 9, 30, -3, 20,
    4, 1, -21, -1, -12, 3, -6, 15,
    47, -14, 19, -16, -49, 8, -50, 22,
    14, 16, 50, -11, 17, 9, 68, -10,
    -49, -7, 27, 12, -27, -3, -8, 3,
    4, 8, -13, -9, 30, 7, -3, 14,
    12, 47, 17, 25, 8, 20, 2, 25,
    -2, -7, 13, -10, -37, -24, 12, -17,
    40, 24, -25, 1, 12, 20, 8, 8,
    31, 10, -3, -25, 30, 0, 11, 1,
    40, 56, -33, 12, -42, -47, 35, -4,
    -48, -48, -4, 15, 0, 13, -30, 16,
    -3, -1, 6, -25, -3, -9, 10, 47,
    -13, -4, 27, 0, -20, -48, -22, -13,
    52, -1, 17, -12, 33, 21, -26, -11,
    -20, -18, -4, 9, -50, 15, 5, -6,
    5, 20, 20, 13, 7, -19, -10, 33,
    27, 4, -6, -9, -13, 44, 19, -10,
    4, 18, -2, 8, -6, 13, -5, -6,
    -10, -6, -30, 29, 49, -4, -7, 3,
    -15, 15, 15, -51, 7, 0, 21, -1,
    -21, -4, 13, -9, 0, -30, -2, 11,
    0, 5, 3, -12, -5, 65, -57, -2,
    -9, 2, 11, -1, -7, 11, -16, -21,
    -40, 30, -11, -18, -3, -15, -16, 17,
    -1, -13, -12, 38, -7, 3, 21, -18,
    14, -10, 12, -2, 18, 18, -31, -14,
    20, 11, 37, 4, -9, 25, 25, 10,
    -10, -1, -16, -1, 28, -56, -36, 17,
    24, -1, -7, -36, 8, -2, -22, 10,
    -9, 12, -32, 3, -33, -7, 15, 7,
    4, 7, -34, 11, -33, -7, 24, -8,
    47, -5, -12, -3, 2, -2, 11, 15,
    12, 4, 10, -2, 28, -11, 19, -21,
    17, 2, -8, -10, 21, 49, 59, 6,
    -15, -21, -5, -9, -1, 25, -14, 13,
    59, 6, -4, 9, 0, 10, -8, -21,
    -5, 15, -2, -7, 16, -8, 3, 4,
    -31, 20, 16, 1, 76, 38, -22, 10,
    -1, -43, -7, 35, -43, -81, 14, -16,
    22, 8, 34, -41, 14, -10, -2, -1,
    -9, 12, 8, 1, -51, 17, -3, 9,
    8, -10, -7, -20, 10, -11, -12, 40,
    -20, 7, 18, 23, 17, 3, -8, 3,
    -18, -32, 19, -8, -9, -28, -29, -33,
    -9, -3, 4, 12, -6, 25, -13, 12,
    14, 20, -30, -7, -41, -4, 0, 0,
    33, 12, -24, -8, -10, 50, 3, -31,
    13, -8, -32, -6, 18, -55, 13, -7,
    -27, 9, -5, 6, 24, 4, -1, 7,
    1, -18, -34, 35, 19, -21, 38, 45,
    2, 1, 34, -7, -2, 20, 9, 19,
    -20, 37, 21, -29, 1, 44, 13, 14,
    -3, -10, 20, -3, -31, -25, 0, -5,
    10, -26, -31, -15, 31, -11, 56, 8,
    -14, -8, 2, 10, -5, -13, -28, -48,
    5, 30, 0, -9, -1, -82, 12, -24,
    -1, -7, 26, -19, 30, 10, 19, -35,
    -21, -59, -24, -54, -25, 46, 25, -26,
    4, -11, -3, -15, 3, -18, -15, 7,
    -7, 24, 22, -18, 10, 46, -29, 8,
    -12, 34, 22, -10, -24, 9, 29, 17,
    -37, 24, -6, 25, -14, -54, 11, 18,
    -23, -26, -9, 11, -23, 4, -11, -11,
    4, -9, 16, 4, -27, -18, -24, 26,
    19, -6, -6, -2, -29, -49, -11, -14,
    -51, 33, 14, -1, -22, 14, -39, -60,
    18, 3, 34, 51, 13, 9, 20, 29,
    -4, 23, 50, 34, -11, -17, -21, 7,
    -9, 11, -4, -35, -16, -16, 6, 68,
    15, 19, -23, -38, 46, 27, -22, -2,
    -47, 26, -6, -33, 58, -9, -65, 20,
    9, -58, -21, -9, -21, -31, 41, -36,
    -29, -70, 4, -56, -22, -38, -23, -27,
    19, 17, 59, 70, 35, -23, 71, -105,
    8, 6, -7, 15, -28, 13, -18, -33,
    -61, 20, -23, 8, 25, -47, 28, -27,
    3, 14, -12, -1, 16, -13, 30, 24,
    8, 14, 25, 25, -19, -26, -8, 2,
    -50, -7, 15, -11, 16, -26, -22, 28,
    -3, -5, 42, 39, -35, -6, 30, 2,
    7, -19, 48, 41, 21, 13, 38, 49,
    -37, -11, 95, -21, -5, -6, -51, -51,
    -37, 85, 26, 24, 11, -10, 30, -13,
    -32, -13, -52, 9, 29, 20, 19, 4,
    28, 57, -4, -13, 3, 1, -25, -13,
    44, -6, -89, 18, -45, 84, -18, -7,
    -11, 2, 0, -34, -38, 79, -9, 17,
    -30, 8, 41, 39, 51, 8, -53, 16,
    38, -44, -4, 10, 4, 12, 51, -9,
    -25, -5, 11, 35, -2, -52, 14, 36,
    44, 14, 29, 26, -1, -21, -57, 23,
    -28, -7, 12, 26, -8, -25, -28, 4,
    -56, -21, 15, 11, -13, -42, -17, -30,
    17, -44, -50, -16, -26, 73, 66, 25,
    39, 45, -46, 32, -3, -1, 22, 14,
    -21, -5, 14, -33, 29, 0, 67, 23,
    18, 1, 14, 71, -15, -19, 51, -19,
    -35, 24, 37, 75, -28, -29, 127, -41,
    20, -19, 39, -7, 5, 28, 21, 9,
    18, 39, 30, -16, -19, 50, 28, -29,
    -53, -6, -5, 54, -35, 40, 0, 0,
    72, 1, 11, 28, 19, 6, 10, 23,
    18, 12, -15, 32, 11, -60, -15, 42,
    -31, -19, -46, 13, 51, 25, -14, 21,
    -37, -13, -28, -20, -7, 4, 7, -15,
    29, -45, -39, -8, -19, 28, -125, 5,
    -54, 14, -48, 7, -8, -32, -27, -24,
    -5, -73, -21, 19, -16, -100, -1, 0,
    127, -3, 22, -39, 31, 20, 14, -19,
    8, -8, 61, -9, -22, 39, -2, 24,
    -41, 49, -63, 1, 19, -17, 1, -47,
    8, 28, -3, -44, -6, 6, -59, 10,
    -87, -7, 44, -4, 0, 1, -31, 22,
    -1, -26, 4, 11, 36, -44, 44, -32,
    24, 11, -18, 53, 1, -39, -5, -7,
    34, -6, -1, -11, 1, 24, 13, 22,
    -79, -9, -42, -10, 20, -9, 60, 22,
    27, 19, 32, 3, -49, -31, 25, 74,
    8, -32, -14, 12, 53, 3, 31, 3,
    13, -43, 15, 20, -13, 11, 12, 13,
    12, 11, -20, -23, 27, 17, -41, 1,
    -61, -35, 0, -25, 7, -15, 18, 39,
    19, 11, 24, -46, -28, 63, -1, 44,
    -41, 11, -48, -26, 1, -22, 15, 33,
    34, 8, -12, -4, -16, 32, 31, 1,
    -34, -6, 1, -8, 37, 33, -37, -10,
    -56, 6, 67, 15, 4, 0, -7, -9,
    78, 11, 47, 8, -20, -1, 42, -35,
    -58, -13, -26, 6, 19, 5, -4, 12,
    -53, 7, -32, -3, -16, 37, 66, 60,
    4, -6, -23, -7, -18, 47, 50, -38,
    32, -25, 41, 2, 32, 9, 15, -5,
    37, -5, -2, -18, 8, 15, -23, -9,
    9, -11, -40, 3, -26, -33, 41, -75,
    -20, 4, -5, -37, -50, -14, -8, 12,
    -20, 37, -67, 54, 35, 9, -10, -5,
    26, 6, -33, -22, 13, -31, 40, 78,
    -31, -15, 61, 41, -27, 62, 0, -10,
    42, 87, 11, 18, -17, 33, -25, -4,
    -20, 16, 3, 31, -10, 11, -1, 36,
    -30, -41, 112, 6, -62, -54, -40, -22,
    -36, -37, 21, -7, -19, 34, -1, -24,
    26, -8, 65, 7, -71, 0, 27, 27,
    -38, 42, -29, 5, 38, -34, 25, 12,
    44, 9, 18, -26, 17, 14, -12, -5,
    -30, -22, 0, 19, -24, 8, -15, 48,
    -14, 9, -64, 32, 38, -28, -5, 56,
    14, -34, 4, 1, -18, 36, -9, 5,
    -64, 5, 22, -12, -26, -10, 30, 7,
    66, 12, -4, 24, 105, -76, 56, 27,
    -33, -7, -59, -13, -29, 23, -31, -32,
    -14, -65, -2, -3, -32, -38, 7, 26,
    -9, -18, 4, 58, 31, -18, -3, -29,
    27, -17, 6, -7, 23, -32, 3, 78,
    -9, -19, -11, -9, -62, -1, 13, -10,
    -28, 41, 30, -20, 22, -17, 1, -32,
    33, 0, -7, -38, -17, 18, 10, -14,
    11, 2, -24, 34, 21, -14, 59, -11,
    -28, 26, -39, 24, -42, -5, 55, -3,
    -22, -6, -1, -68, 15, 1, 7, 15,
    47, -10, 9, 20, -18, 16, -5, 11,
    -44, 21, -10, -22, -27, -35, 44, 18,
    29, -52, -10, -37, -44, 7, -49, -9,
    -41, 3, 21, 25, 18, 12, 9, -48,
    -1, 31, -19, -17, 22, -8, -30, 18,
    28, -21, -13, -8, -4, 83, -70, -47,
    26, 22, 1, -27, -62, -67, 38, -23,
    -4, -27, 36, 1, -26, 26, 28, -22,
    -28, 4, 13, 39, -53, -9, -26, 19,
    -12, -2, -31, -16, -1, -19, -18, 5,
    3, -14, -17, 7, 18, -8, -23, 42,
    -20, 35, -61, 8, 10, 19, -30, -22,
    -20, 14, -3, 16, 6, -12, 8, 2,
    7, -7, -21, -1, -12, 29, 24, -25,
    -55, 23, 37, -7, -39, 32, -21, -41,
    -6, -11, 23, -14, -42, -23, -1, 20,
    -14, 22, -3, 17, 20, -17, -1, 10,
    -24, -2, 25, 24, -4, -13, 75, -53,
    -54, 46, -3, -69, 23, 17, -7, 44,
    23, 63, -76, -22, -45, 15, -52, -42,
    -6, -4, 33, -34, 40, -20, 33, 20,
    -16, -25, 59, 4, 5, -24, -15, 1,
    2, -33, -26, -12, 2, 0, -47, -32,
    33, 39, -23, -15, -51, -78, -25, -22,
    13, -14, 14, -53, 44, -4, 17, -26,
    -8, 44, -34, -20, -82, 11, -71, 69,
    -11, 44, 42, -71, 17, -21, -30, -9,
    -21, -26, 14, -6, -59, 6, 44, 4,
    -63, 17, 29, -19, 11, 4, -39, -8,
    42, 18, 23, 47, 24, -24, -119, 11,
    22, -28, 13, -3, 29, -30, 0, 10,
    23, -1, -32, 4, -34, -5, -17, -1,
    -24, -29, 5, -13, -38, -31, -24, 5,
    15, -30, -76, -43, -60, -37, 5, 9,
    23, -17, 28, -54, 67, -36, 30, 28,
    36, -45, -94, -35, 28, 46, 42, -50,
    9, 58, -35, -57, -22, -53, 18, 36,
    4, -1, 33, -8, 0, 6, 33, 66,
    1, 15, -57, -12, 27, 26, 15, 33,
    11, 2, -20, -14, 7, -2, -4, 8,
    -5, 9, 9, -9, -1, 3, 26, -3,
    -10, 6, 15, -6, 2, 14, -5, 5,
    3, 30, 13, -9, 4, -19, -8, 82,
    -13, -23, 29, 26, -9, -8, -1, -16,
    -20, 31, 19, -8, 2, -6, 11, -4,
    13, 2, 10, 5, 6, 13, -16, 72,
    -15, -6, -34, -12, -2, -64, -26, 34,
    -16, -5, 6, 63, 4, 13, 4, -9,
    22, 16, -5, 14, -1, 4, -11, -2,
    -25, -3, 1, -19, -26, -1, 17, -19,
    14, -18, 52, 16, 51, -6, 37, 54,
    12, -37, -23, -27, -28, -8, 1, -11,
    -26, -7, 22, 7, -1, 5, 5, -2,
    3, -10, 10, 1, -33, 1, 10, -17,
    4, 5, 0, -25, -52, 2, 35, -12,
    -9, 4, -12, -16, -5, 1, 6, 4,
    -6, 7, -17, -27, 13, -20, 13, 0,
    4, -15, -8, -18, 27, -12, 9, -21,
    -23, -20, -24, -28, 14, 14, 9, 10,
    23, 8, -6, -7, -6, -1, -12, -4,
    -2, -9, -6, -1, -5, 6, 28, 4,
    23, -14, -6, -6, 5, 7, -7, 7,
    -17, 25, 36, -22, 14, 49, -7, -31,
    -23, -9, -30, 2, -1, 10, -7, 3,
    15, 29, -2, -34, -24, -6, 4, 1,
    10, 1, -28, 6, 29, 9, -5, 20,
    -31, -5, -14, 6, 7, -33, -17, -8,
    -3, 2, -15, -15, 2, -10, -9, 0,
    -4, -35, 1, 12, 6, -11, -28, -5,
    0, 22, -7, 15, 22, -31, 24, 22,
    -14, -47, 11, -7, 1, -74, -30, -39,
    -13, 24, 28, 12, 26, -30, -6, 6,
    -37, -18, -42, 0, -8, -11, -4, 0,
    -11, 7, 9, 9, 22, 1, 33, -22,
    -25, -4, 14, 8, -13, 59, -45, -39,
    -2, -12, 2, 10, -11, 4, -5, -6,
    2, 8, 25, 26, -13, -10, 12, 0,
    10, -7, 29, -19, 6, 23, 4, -1,
    5, -2, 19, -12, 13, -6, 2, 4,
    -30, 0, 18, -6, 3, -8, 17, 8,
    -22, 2, 11, 19, 9, -6, 10, 3,
    -1, -5, -3, -15, 0, -16, -18, -16,
    -19, 8, -22, 8, -56, -16, 0, 55,
    3, -1, 2, -4, 13, 4, 0, 4,
    -3, -31, 13, 7, -3, 2, 17, 12,
    2, 10, 12, 6, -18, -27, -19, 8,
    -33, -31, 0, -22, -47, -26, 30, 2,
    -4, -37, -9, 26, -1, -24, -3, -7,
    -27, -7, 0, 5, 11, -2, -1, -3,
    32, -31, -16, -17, -40, 15, 14, -11,
    -13, 18, -14, -11, -7, -59, -11, -27,
    17, -12, 22, 31, 0, 17, -6, 18,
    11, -1, 27, 4, -4, 0, 20, -6,
    15, 22, 2, 15, 22, 27, -12, -38,
    31, 13, 13, 17, -15, 0, -4, -1,
    6, -11, 12, -22, -11, -13, -11, -4,
    25, -3, 1, 8, 2, 0, -2, -11,
    5, -33, 0, 0, -12, 16, -9, -3,
    -19, 1, -21, 5, -17, 22, 8, 65,
    12, -8, -5, -21, 4, 2, -14, -3,
    17, -15, -7, -9, 13, -18, 2, 22,
    -5, 6, 0, -14, -1, 66, -48, 35,
    9, -24, 22, -17, 16, -44, -38, -12,
    3, 11, 12, -24, -4, 6, 1, -3,
    -3, -9, 26, -18, -14, 15, -9, -11,
    9, 11, -11, -6, -29, 20, 20, 14,
    8, -59, -2, 11, 55, -51, 14, -6,
    -27, 36, -36, 1, -5, 0, -5, -6,
    1, 12, 12, -9, -20, -5, -13, 27,
    -1, -5, 7, -26, 2, -19, 11, -7,
    -8, -13, -6, -10, 12, 31, -25, 10,
    20, -10, 0, 15, 8, -3, 4, -10,
    3, 1, 36, -5, 23, 5, 6, 3,
    -8, 3, 14, -1, 56, -14, -29, 26,
    6, 5, 11, -3, 11, 17, 20, 16,
    9, 5, -2, -30, -9, -23, -7, 11,
    0, -2, 12, 24, 5, 0, 9, 7,
    -3, -8, -1, -2, -7, 12, -7, 17,
    3, -5, 14, 12, -1, 10, -28, -23,
    15, 4, -8, -4, -3, -4, 5, -3,
    5, 16, 36, 14, 15, -3, 3, -5,
    -15, 2, 5, 2, 11, -19, -4, -27,
    -2, -12, -3, 4, -22, -36, 46, -19,
    -2, 6, -21, -26, 8, -8, -2, -3,
    -14, -16, 4, -20, 7, 7, 12, 3,
    -1, 18, 6, -9, 52, 2, 7, 1,
    14, 29, 9, -5, 24, 1, 4, -40,
    26, -9, 5, -20, 12, 0, -6, 1,
    -17, 9, 0, 6, -7, 1, -15, -9,
    24, 20, 34, -1, -1, -11, 34, 19,
    6, 13, -2, 20, 40, 7, 10, 25,
    15, -4, 66, 21, -1, 2, -4, 0,
    4, 11, -3, -6, 6, 3, 11, -5,
    -6, 5, 1, 2, -3, -7, 2, -27,
    12, -36, 25, -19, -14, 44, 6, -9,
    23, 4, 23, -7, 11, -2, 1, -4,
    -4, 22, 13, -6, 18, 18, 0, -18,
    4, 5, 16, 2, 15, 47, 24, 17,
    -3, 15, -30, 47, 13, -26, -8, -25,
    -45, -18, 20, -21, -11, -18, 0, 4,
    3, -10, 19, -13, 5, -16, -9, -3,
    -7, -22, 13, 11, 6, -3, 15, 14,
    13, -20, 0, -6, -3, -16, -33, -10,
    23, -9, -8, 7, -3, 5, 6, 17,
    12, -13, 38, 28, -6, 17, 13, -6,
    5, 11, 14, -12, -23, -7, -16, 16,
    -1, -26, -34, -22, -8, 34, -6, -11,
    -23, 9, 16, -3, 9, -22, 19, 1,
    -4, -49, -1, -24, 2, -3, 2, 0,
    -4, 42, -17, -9, -19, -1, -52, -21,
    0, -12, 14, -16, 6, 52, -29, -36,
    0, -5, 18, 28, 25, -20, 6, 14,
    28, -5, -11, 2, -1, 1, 11, 11,
    -1, 8, -27, 8, 2, -5, -23, 9,
    31, 1, -5, -4, 23, 10, -13, 13,
    9, -23, 20, 4, 11, -8, 1, -1,
    -36, 27, -19, -14, -22, -3, -12, -10,
    4, 2, -6, -11, 13, 7, -19, -30,
    20, 4, -4, -17, 7, -5, -29, 5,
    -45, 10, -3, 0, 2, 2, -9, 3,
    -4, 19, -24, -3, -10, 11, 0, 16,
    1, -15, 13, 8, -13, -26, 22, 13,
    -15, 19, -20, -23, -4, -53, -12, 39,
    -31, 35, -16, 11, 8, -7, -3, 8,
    -16, 14, -29, 0, -3, -1, -4, -1,
    13, 0, -13, 5, -1, -18, 34, -7,
    10, 0, 40, -9, -9, 42, 25, 41,
    17, 7, -76, -31, 19, 5, -16, 6,
    -12, 25, -5, 74, 11, 17, -4, 34,
    3, 10, -1, 9, 4, -15, 11, 3,
    17, 25, 22, 41, -3, -12, -27, -57,
    5, -5, 0, -9, 5, 3, -25, 15,
    -9, 21, -5, 14, -1, -8, 13, 5,
    6, 16, -17, 5, -9, 37, -20, -6,
    -3, -11, -21, -7, -26, -66, -46, 29,
    -10, -53, -9, 60, 12, 19, 16, 0,
    17, 19, -4, -18, -12, 13, -1, -14,
    20, -24, 5, -12, -16, -29, 46, -19,
    1, -31, 14, -5, 52, -8, -1, 19,
    -12, 11, 2, 29, -26, 10, -18, 13,
    10, -35, 29, 18, 13, -2, 23, -25,
    2, 11, 2, 10, -7, -18, -21, 28,
    20, 40, -12, 33, -27, -17, -60, 21,
    6, 22, 5, 22, -3, 8, -7, 9,
    -1, 13, -3, -15, 8, -12, 23, -6,
    3, 5, -13, -14, -21, -36, -18, -14,
    -20, -9, 4, 30, 40, -9, 4, -23,
    8, -14, 34, 14, 7, -12, 21, -12,
    -66, 8, 43, -2, 11, -7, 50, 15,
    -21, 11, 9, -17, 8, -33, 53, -56,
    27, 16, 5, -14, 9, -31, -10, 27,
    24, 24, 33, -16, 28, 3, -2, 30,
    -44, -55, -6, -19, -15, 4, 4, 5,
    -19, -19, 6, 12, 0, -18, -53, -5,
    33, -17, -37, 3, 14, -1, -13, -27,
    5, 42, -37, -27, 1, -7, -5, 0,
    -7, 37, -59, 9, -7, -16, -3, 4,
    -3, -9, 10, -1, -15, 46, 3, 66,
    6, 15, 15, -37, 18, 67, -35, 2,
    -57, -11, -1, -5, -3, -25, -9, -11,
    -3, 23, 65, -16, -36, -24, -14, 14,
    8, 2, -11, -17, -7, 48, 58, 6,
    26, -6, -62, -3, 0, 33, -18, -5,
    23, 25, -13, 3, -4, 58, -32, -5,
    4, -27, 12, 35, -16, 2, -16, 13,
    -1, 14, 30, -15, 27, 12, 21, 0,
    3, 12, 0, 37, -28, 27, -27, 25,
    -18, -5, 22, 20, 8, -4, -20, 5,
    9, 30, 21, 26, 17, 20, 5, 9,
    -18, -3, -29, -8, -31, -26, -6, 16,
    -20, 0, 29, 8, -46, -71, 49, 42,
    -4, -36, 17, 8, 1, 13, 21, 18,
    20, 56, -13, 15, -2, 8, -20, -10,
    -23, -22, 3, 12, -28, 7, -65, 43,
    23, 1, 7, -37, -10, -15, 1, 28,
    -2, -18, -13, -51, -15, -1, -3, -23,
    41, -35, -16, 19, 31, -32, -12, 37,
    6, 14, -6, 7, 17, 6, -25, 52,
    -23, 19, 16, 29, -28, -22, 35, 0,
    -11, -35, 5, -6, 13, 10, -13, 1,
    0, -19, 26, -29, -10, 16, 21, -17,
    3, 0, 1, 1, -36, 4, -23, -16,
    -25, 18, 32, -19, -14, -40, -51, -6,
    -17, 19, 3, -3, 0, -18, 0, 26,
    46, -21, 14, -12, -9, 11, -4, -6,
    -8, -83, 11, 6, -32, -20, 3, 0,
    -12, 1, -17, -7, -3, 10, 27, 1,
    42, 7, 40, -8, -8, 4, -10, -19,
    9, -18, 11, -19, 5, -7, 19, -9,
    9, -12, 10, -2, 0, -36, 19, -3,
    11, -11, 28, -76, -3, 8, -43, -29,
    -4, -9, 9, -43, -1, 11, -2, 12,
    26, -33, -24, 34, -17, -7, 31, -5,
    2, -5, 3, -7, -55, 2, -24, 25,
    10, 19, 9, 45, -11, 22, -6, -19,
    21, 6, -16, 21, 5, -1, -3, 9,
    -30, -15, -30, 3, -11, -6, -32, 2,
    -10, 0, 7, -44, 9, 5, -48, 13,
    -69, -40, 34, -4, 62, 57, 2, 5,
    -86, 11, -34, 7, -13, 10, 1, -10,
    85, 44, 5, -9, 29, -6, 6, 5,
    -2, -21, -5, -1, 4, -1, -4, -60,
    -21, 11, 8, -79, -4, 61, 19, -4,
    6, 17, -16, -8, -2, -37, 0, 26,
    -8, 11, 5, 30, 2, 14, 16, 1,
    4, -28, 1, -3, -32, -22, 6, 20,
    -28, -50, -36, -8, -14, 12, 53, -3,
    22, -48, -18, -1, -10, 12, 25, -4,
    11, 17, -96, -6, 25, -34, 1, -8,
    5, -8, 16, 5, 32, -2, 23, -69,
    0, 27, -4, 26, 2, -10, -24, -25,
    -2, 72, -15, -15, -4, 13, -11, -2,
    0, 10, 42, 0, 22, 2, 24, 6,
    22, 23, 10, -4, -53, -7, -35, 52,
    -70, -26, -1, -2, 18, 26, -12, 26,
    27, 1, -36, 31, 3, -6, 30, -10,
    -32, -16, -14, 5, -32, -1, -6, 0,
    -7, 10, -16, -6, -26, -17, -69, -28,
    -2, 8, -3, 3, 23, 0, -12, -9,
    6, 7, -3, 22, -5, 1, -20, 10,
    24, -20, 23, 22, 10, 5, -4, 5,
    -22, 1, -7, -1, 0, 63, -24, 11,
    15, -23, -4, 2, 32, -34, 10, -2,
    20, -49, 7, -24, -8, -12, -4, -13,
    0, -52, 29, -16, -3, 19, -8, -2,
    27, 1, -20, -15, 7, 41, -2, -10,
    -41, -14, 1, -4, 48, 6, 26, -20,
    39, -13, 4, 5, -6, -18, 5, -1,
    24, -16, 16, -10, -21, -7, -12, -7,
    22, -11, 28, -28, 13, 3, -30, 23,
    -17, 4, 4, 12, -25, -9, 6, -8,
    23, 4, -20, 6, -5, 11, 26, -2,
    24, -39, -18, 23, 15, -4, -2, -3,
    -27, 13, 1, 8, 18, -19, 34, -51,
    -3, -19, 14, 31, -60, 14, -31, 17,
    11, -6, -1, 14, 20, -36, 6, 4,
    -4, -19, 52, 12, 36, 1, 7, 10,
    -17, 93, 0, -3, 14, 4, -63, -7,
    13, 1, -5, -33, 3, 39, -30, 22,
    9, 2, 26, 9, 17, -13, -1, 1,
    -27, -6, -5, 0, 6, 1, 25, -4,
    6, -21, 4, 9, 6, -10, -11, 20,
    54, 13, -2, 12, -29, -22, -1, 2,
    11, -17, 41, 3, 15, 14, 4, -8,
    -5, -22, -9, -11, -34, 6, -11, -8,
    -16, -12, 4, -25, 11, 24, 23, -44,
    5, -11, 41, -1, 7, -24, 19, -6,
    20, -5, -1, -5, -6, 5, -10, -12,
    -48, -3, 44, -10, -18, 10, 22, 13,
    4, 24, -12, -19, 10, -15, -35, -3,
    28, -9, 10, -13, -14, 10, 42, 40,
    -7, 3, -8, -49, 3, 1, -15, -6,
    45, -61, 8, 5, -31, -11, -16, 11,
    38, -35, 9, 8, 47, 14, 8, -64,
    -60, -1, 30, -17, 26, -1, 21, -66,
    2, 31, 24, 74, 16, -17, -40, 5,
    6, 6, 11, 46, 30, 19, -59, 12,
    -2, 20, 4, -24, 1, 24, -56, 28,
    -43, 13, -20, -87, -56, 2, -37, -5,
    -31, 10, -27, 62, 0, -10, -20, 24,
    6, 27, 15, -29, 15, -12, 54, 4,
    -39, 9, -34, 3, -10, 45, 20, -84,
    34, 43, 42, -43, 44, -5, -27, -42,
    -24, 39, -43, -86, -12, 35, 23, 19,
    -8, -41, -14, 3, -19, 32, -1, -20,
    -6, 26, 31, 36, 13, 110, -115, 32,
    -7, 23, -21, -5, 27, -39, -65, -47,
    -19, -76, -4, -13, -31, -1, -7, -3,
    -14, -15, -18, -23, 44, -26, 93, -58,
    -8, -14, -21, -8, -57, 10, 78, -8,
    -4, -19, 19, -2, -27, -34, 21, 12,
    64, 16, -57, -39, -19, -12, -19, -6,
    -13, -3, 41, 1, -29, 7, 48, -15,
    -8, -14, 4, -30, -41, 50, 83, -50,
    17, 25, 16, 10, -53, -2, 70, 23,
    -6, 12, -31, 71, 12, -2, 30, -7,
    64, -31, -40, -26, 37, -8, 80, 16,
    13, -3, -15, 6, -10, -38, -84, -11,
    21, -33, 14, 14, 30, -20, -50, -33,
    97, -23, 20, -26, 9, -4, 25, 17,
    16, 80, 54, 56, -26, 11, 11, -17,
    5, 19, 1, -21, 2, 106, 76, 48,
    17, -9, 27, 40, -11, -53, 80, 49,
    -18, -6, 54, -12, 19, -24, 23, -3,
    16, -31, 61, -52, -36, 31, 56, 31,
    -16, -9, 7, 28, -17, -61, -19, -5,
    18, -16, 9, -22, -2, -40, -34, -10,
    33, -81, -57, -13, 11, -47, -28, -30,
    23, -60, 17, 22, -67, -32, -38, 25,
    -21, 18, -22, 27, -3, 10, -70, -19,
    -36, 3, 18, 41, 75, 40, -1, -23,
    77, 45, -34, 0, -1, 61, -14, 5,
    -18, 10, -56, -23, -36, 5, -91, -3,
    -18, 18, 34, -10, 13, -10, -24, 88,
    23, -48, 19, -16, 60, 3, 0, 12,
    9, -30, 17, 22, 15, -8, -2, 0,
    -12, -45, -23, 27, 71, 58, -16, 14,
    -3, -10, 16, -7, 16, -2, 15, -71,
    -5, -106, -3, 18, 43, -38, -98, 19,
    -5, 20, -7, 30, 13, 48, 24, -2,
    -24, -21, -2, -25, 7, 71, -13, -25,
    8, 19, 37, -8, 39, -25, 22, 6,
    28, -19, 17, 67, 21, 16, 47, -13,
    52, 0, -21, 9, -33, -11, -21, -13,
    5, -22, -54, 28, 91, -51, 36, 66,
    12, -6, 10, 25, -23, -64, -16, -7,
    51, -22, -11, 26, -57, 3, -32, -31,
    -44, 1, -19, -33, 7, 37, -14, -20,
    -20, -15, 26, -35, -53, 33, -42, -24,
    7, -16, 28, -6, 40, -42, 5, 59,
    -17, -3, 4, -3, 16, -91, -28, -47,
    11, 30, -22, -36, -12, -38, 8, 18,
    -30, 6, -58, -22, -22, 22, 16, -3,
    8, -124, 12, -5, 41, -20, 43, 49,
    14, -16, 21, -37, -40, 32, -71, 87,
    -63, -32, -18, 35, 5, 10, -9, -26,
    -3, -14, 0, -8, -35, -3, 11, -24,
    38, 15, 20, 2, 36, -8, 48, -27,
    -25, 31, -11, 100, -17, 34, 48, -51,
    13, -41, -52, 37, -13, 0, 11, 8,
    8, 4, -74, -13, -4, -53, 102, -2,
    -11, -18, 13, -6, 127, -34, 34, -1,
    -41, 46, 41, -7, -126, 72, -17, 44,
    8, -42, 5, 17, 24, 17, 24, -3,
    57, -30, -3, 31, -48, 25, -58, -7,
    -5, -2, 35, -99, -48, 15, 7, -14,
    41, -13, -22, 10, -32, 9, 6, 37,
    63, 20, 23, 26, 13, -5, 10, -12,
    -49, 29, -21, -9, 20, 3, 17, 16,
    18, 31, 0, -4, -49, 37, -31, 75,
    -38, -5, -29, 99, 36, -25, -38, -17,
    11, -22, -11, 15, -21, -108, 6, 8,
    51, 17, -13, -28, 1, -5, 32, -2,
    -13, -15, 32, -1, -17, -17, -14, -31,
    -16, 28, 52, -20, 94, 11, 27, 0,
    34, 14, -55, -11, 17, -15, -16, -3,
    -5, -19, 48, 12, 23, -9, -4, -13,
    -3, 10, 8, -6, -5, -4, -6, 11,
    10, 48, -16, -9, 0, -123, 23, 27,
    8, -28, -24, 14, -8, -1, -14, 3,
    33, 18, 3, -41, 11, -8, 17, 0,
    -6, 14, 19, 9, 30, 58, -19, 13,
    72, -28, -21, -37, 62, 24, 53, -35,
    5, -21, -54, 39, -3, 5, 75, -32,
    49, -1, -30, -1, -7, 0, -13, -21,
    18, 8, 0, -12, 56, 8, 73, -52,
    -9, 20, -4, -12, -57, 61, -19, -12,
    -7, 39, 34, -41, -4, 8, -36, -8,
    -37, -33, 45, 1, 21, -17, -4, 18,
    17, -29, -1, 3, -36, 30, -2, -44,
    -46, 26, 31, 15, -12, -84, -25, 49,
    11, 10, 17, -29, -21, 11, 5, 19,
    0, -27, -9, -19, -18, -14, -24, -52,
    -22, -10, -32, -5, -24, -3, -8, -47,
    65, -3, 3, -13, -39, 26, 28, 56,
    9, -16, -70, 37, 4, -25, -18, -5,
    -30, -7, -18, -43, -57, 10, 7, -17,
    22, -12, 11, -50, 76, 20, 21, 15,
    10, -8, 0, -1, 18, 36, 46, 19,
    -13, 9, 26, 16, 6, 11, 27, -7,
    11, -12, 23, 1, 29, -23, -15, 7,
    -6, -7, 7, -8, 39, -43, -20, 106,
    9, 54, -51, 31, -10, -17, -22, -16,
    -7, 10, -17, -60, 0, -69, -5, -7,
    -50, -19, 12, 25, 64, 16, 31, 51,
    -32, 127, 47, 17, 18, 33, -1, 3,
    49, 13, -5, 3, -20, 47, 31, 12,
    20, -7, 87, 0, 5, -12, -13, 15,
    -14, 4, 27, -72, -16, 20, 4, 12,
    -13, -50, 49, 9, -50, -3, 2, -18,
    -4, 49, 15, -41, -53, 44, -14, 8,
    0, 20, 33, -53, 10, 9, -4, -4,
    -19, -49, -36, 17, -20, 14, -62, -22,
    -20, -1, 15, -18, 28, -24, -33, -2,
    -127, 7, 8, 40, 19, 19, -13, -93,
    3, 21, 4, 6, -6, 7, -18, -23,
    119, 1, 1, 17, 3, 15, -20, 17,
    -10, 32, -30, -24, -84, 33, -37, -4,
    17, 41, -41, -6, -76, 47, -47, -19,
    22, 1, -6, 23, 38, -9, -22, 24,
    -58, 102, 19, 45, -13, -68, -34, -22,
    16, -5, 10, 3, 45, -3, -24, 22,
    11, -8, 2, -16, 0, 12, -7, 6,
    19, -3, 5, -20, 4, 39, 18, -8,
    35, 9, 10, -27, 19, -15, -30, -20,
    20, -18, 16, -18, -13, 7, 32, 12,
    -5, -24, -12, -16, 9, 8, 12, -1,
    -10, 7, -9, -12, 31, -24, 33, -38,
    5, -2, 18, 16, 5, -4, 17, -31,
    -13, -24, 24, 27, 18, -34, -12, 46,
    4, 25, 18, 27, -3, 10, 25, -40,
    -1, 13, -13, -17, -13, -15, 59, 13,
    -7, 47, -30, -42, 22, -7, 8, -28,
    -23, 16, -2, 0, 3, 15, 6, -20,
    14, 26, 2, 21, -12, 8, 8, 22,
    4, 19, -4, 1, 8, 52, 3, 33,
    -23, 3, -17, 31, 24, 3, 4, 14,
    6, -19, 30, 9, -8, 2, 21, -30,
    -7, -6, 11, 5, 3, -20, 6, 2,
    12, 30, 12, -29, -22, -2, 15, -9,
    11, 2, 47, -41, 9, -3, 16, 2,
    6, -14, 6, 15, -21, -8, -56, 29,
    15, 3, -15, 3, 21, 31, 6, 24,
    6, 19, -8, -11, 19, 49, -13, -26,
    -61, -23, 28, 36, 22, -8, 13, 13,
    23, -37, -20, -6, -38, 12, -10, 39,
    -38, -2, -9, 2, -3, 19, -32, -7,
    23, 2, 27, -11, 22, 10, -37, 34,
    9, 21, -24, 19, -2, -21, 15, -22,
    36, 3, -3, -14, -12, 5, -30, -30,
    -8, -32, 8, -22, 21, 24, 10, -19,
    -3, -2, -19, -5, -3, -20, 34, 20,
    -16, -18, -75, -11, 5, -9, -20, 19,
    -11, 31, -12, 32, -22, -4, -37, 32,
    -3, -16, -18, 16, -8, 9, 28, -24,
    -35, 22, 9, 15, -56, -41, -44, -12,
    -10, 2, 0, 2, 6, 1, -10, 7,
    5, -28, -5, -7, 1, -28, 1, -16,
    6, 1, -6, 2, 10, 6, -34, 7,
    -8, 2, 22, -19, -28, 5, -4, 5,
    1, 6, -2, -6, -14, -4, -6, -18,
    23, 7, 2, 27, 30, -16, -21, -24,
    15, -26, -20, -27, 10, 20, 5, 41,
    14, 12, -16, 5, 4, -40, 21, 9,
    -31, 23, -19, -7, 22, -9, 5, -14,
    12, 8, -3, -9, -40, 17, -6, 7,
    5, 2, -16, 3, -15, -12, -9, -7,
    7, 10, 12, -10, -25, -23, 32, -21,
    9, -18, 16, 11, -11, 28, -31, 21,
    -12, 10, -14, -5, -16, -15, 9, -19,
    -11, 0, 0, -22, 8, 20, -16, -9,
    9, 39, -10, 18, 3, 1, -2, -4,
    -44, 27, -12, 10, 1, 2, 12, -14,
    -23, 10, 10, -2, 12, 44, -10, 12,
    17, 2, -4, -15, -2, -22, -5, 38,
    2, 14, 6, -13, 36, -20, -39, 18,
    -19, 28, 26, -29, -9, 12, 17, -17,
    -27, -3, -4, 37, 62, -59, -32, -37,
    15, -26, 18, -14, 28, 22, -45, 20,
    -28, 2, -7, 29, -2, 40, -9, -14,
    -32, -34, 4, -11, -45, 29, -30, -12,
    3, 52, -6, -12, -54, -15, -22, 7,
    1, -68, -9, -22, 7, -5, 0, -35,
    11, -10, 7, -49, 19, 11, -37, -10,
    -10, -36, 23, -24, -19, 2, -8, 27,
    -13, 21, 3, 6, 27, 4, -37, -3,
    -61, -21, -5, -4, 9, 15, -14, -10,
    15, 10, -25, -18, -5, -4, -28, 42,
    -44, -22, -7, -14, 0, -25, 12, 10,
    17, 56, 25, 3, 13, 2, -5, 1,
    15, -19, 35, 0, 10, 8, -14, 12,
    -9, -10, -37, -8, 41, -14, 74, 21,
    -54, -8, 13, -24, -32, 4, -36, 0,
    4, 15, 10, 10, -10, -14, -20, 6,
    -33, 62, 11, 15, 14, 0, -3, 41,
    1, 11, -7, 4, -35, 15, 17, -26,
    18, 24, 0, 12, -10, 2, -16, -1,
    -5, 10, 5, -4, 8, -45, -17, 12,
    2, 39, 16, 2, -7, 8, 21, -14,
    -15, 4, -16, 41, 55, -8, -19, 0,
    -34, -20, 9, -10, -23, -2, 7, -53,
    -7, -1, 3, -23, -31, -11, -46, 8,
    -31, -5, 17, -5, 36, -31, -7, -7,
    -19, 13, 7, -36, 1, 42, 20, -10,
    9, -9, 21, 3, -35, 14, -29, 9,
    -2, 15, -9, -5, -7, -10, -41, -36,
    -4, -8, 1, -19, 2, -2, 4, 24,
    -26, 11, -13, 29, 22, -31, -31, -4,
    -17, -31, 6, -16, -10, 15, -17, -26,
    30, -30, 7, 12, 31, -5, -15, 20,
    -19, 42, -10, 20, -12, -3, -15, 2,
    -24, 22, 17, -22, -25, 3, -32, 9,
    15, -3, 54, -3, -4, 12, -10, 8,
    35, 5, 43, -2, 14, -4, 32, 9,
    -24, -1, -36, -12, 19, -3, 0, -17,
    8, 9, 4, -12, 24, -5, 39, 8,
    16, -32, -20, 19, 15, 4, 5, 18,
    2, 9, -26, 5, -6, 10, 1, -27,
    2, 11, 16, -29, -1, -2, -29, -15,
    9, 32, 8, -19, -6, 31, 17, -4,
    16, -69, -3, 14, -16, 28, 2, 42,
    10, 19, 37, 30, -5, 16, -10, -6,
    -3, -17, -17, -27, 10, -4, 42, -31,
    -17, 22, 14, -14, -7, -10, 19, 21,
    26, -33, 20, -25, 18, -53, 9, 25,
    -10, 12, -12, 62, 0, -6, 5, 10,
    19, 5, -14, 43, -4, -16, 16, -16,
    24, 3, 14, 5, -9, -7, 27, 9,
    -30, 14, -39, 23, 9, 4, -23, -7,
    -1, -4, 9, 16, 11, -8, -24, 16,
    24, -50, 3, 6, 16, 3, -33, -22,
    2, -29, 58, 4, 5, 23, 17, 19,
    15, 11, 22, 9, -8, -13, 10, 37,
    -17, -76, 15, -12, 21, -2, -42, 12,
    55, 31, 21, 9, -17, -2, 28, -19,
    14, -20, 7, -3, 2, 12, 47, -23,
    44, 1, -50, 20, -27, 9, -17, -1,
    -14, 18, 26, 19, 19, -6, 4, -18,
    5, -2, 5, -15, 0, 29, 2, 22,
    -23, -9, 1, 13, 5, 10, -1, -12,
    34, 0, 0, -5, 15, -22, 43, -5,
    13, 19, -7, -31, -19, -1, -43, -32,
    9, -6, -24, 19, -5, 5, 0, 15,
    -2, -1, 7, -18, 16, -2, -43, 30,
    -39, 13, 17, 29, -8, 7, 4, 23,
    -16, 28, 26, 0, -8, -24, 2, 20,
    -12, -28, -11, 23, -32, -30, 1, 14,
    25, -25, 6, -5, -10, -32, -10, 1,
    3, -27, -7, -3, 0, 19, 8, -6,
    -10, 11, 4, -6, -7, 17, 1, 43,
    -20, 39, -10, 0, 18, 4, -24, -35,
    16, 22, 4, 39, 0, -18, -24, 9,
    -37, -19, -14, 28, 20, 10, -28, -55,
    4, -8, 3, -6, 8, 1, 5, -23,
    1, -40, -34, -1, -6, 16, -31, 39,
    -26, -14, -2, -22, 17, -3, 13, -18,
    11, 14, 14, -71, -9, -22, 17, -40,
    -12, -26, 15, -2, -15, 26, -11, 11,
    -39, -29, 10, -4, -19, -13, 14, -9,
    44, 35, -22, 61, 18, -73, -16, -10,
    -51, 12, 5, 24, -5, -23, 42, 38,
    -8, -14, -14, -3, 27, 10, 47, 22,
    -19, -15, -5, 32, -21, -31, -12, -4,
    32, -62, -48, -59, -70, 24, -7, -2,
    39, 14, 10, 5, -26, -20, 15, 19,
    6, -13, -20, 46, -26, -7, 20, -14,
    4, -10, 10, 7, 13, -3, 45, 29,
    10, 6, -58, 50, 12, 6, -19, -18,
    20, 20, 15, -5, -11, -3, 16, -8,
    12, -27, 11, -8, -31, 9, 38, 21,
    -8, -8, 11, -6, -7, 10, 1, 3,
    4, 25, 41, 31, -39, -18, 14, 22,
    18, 28, 22, 41, -18, -22, -39, -7,
    4, 3, -4, -3, -51, 27, -48, 56,
    -45, -1, 1, 22, -5, -12, -11, -29,
    -12, -6, 21, -36, -8, -44, -8, -5,
    -15, -14, -24, -29, -8, 15, 0, 8,
    -13, -15, -10, 9, 24, -4, 34, 26,
    -4, -24, -6, -3, -3, -7, -23, 6,
    -7, -9, 15, 35, 1, -3, -29, 37,
    2, -22, 55, 19, -12, 40, -9, -33,
    17, 0, 5, -2, -11, -17, 9, -4,
    -3, -23, -15, 7, -27, 2, 28, -10,
    16, -29, 3, 13, -13, -39, -19, -23,
    -2, -36, -2, 54, -22, -23, 9, 3,
    -7, 25, -5, -35, 20, 2, 22, -35,
    -17, -53, 9, 15, 9, 16, 16, -22,
    26, 23, 2, 11, -15, 18, 13, 10,
    -1, -47, 31, 37, -12, -1, 2, 7,
    25, 31, -6, 2, 12, 1, 5, -22,
    -11, -17, 3, -13, -37, 8, -7, -2,
    56, -12, 11, 10, 55, -17, 19, 29,
    -45, -9, 23, -27, -19, -1, -9, -37,
    -5, 0, 4, 6, -13, 47, -25, -3,
    -16, 20, -26, 14, -17, 21, -28, 6,
    20, -27, -16, -6, -41, -24, -33, -34,
    -14, 36, -15, -6, 25, -14, -4, 18,
    12, 6, -1, -1, -6, 27, 32, 58,
    -3, 6, -3, -18, 2, 20, -30, -13,
    -9, -2, 66, -1, 30, 21, 5, 28,
    1, 35, 39, 25, -5, -25, -25, 23,
    -4, 13, -4, 16, -2, 20, 9, 37,
    15, 10, 20, 0, 28, -30, 8, -18,
    14, 24, 52, 43, 65, -30, 8, 58,
    12, 4, -7, 27, -30, 0, -7, -18,
    3, 14, -6, 29, -10, -18, 6, -21,
    -8, -70, 20, 8, 25, -5, -3, 23,
    -1, 2, 18, 11, -15, -9, -17, -10,
    9, 35, 2, -26, 0, 6, -24, -14,
    -7, 79, -3, 25, 14, -4, -41, -10,
    -4, -69, -7, 37, -38, -31, -11, -35,
    -16, -14, -5, -27, -25, -3, 39, -54,
    -5, -28, 40, -12, 32, -4, -6, -21,
    -22, -1, 16, -8, 24, 32, 14, 7,
    -41, -16, 15, -2, 13, -14, -53, -12,
    7, 5, 1, -15, 7, -37, 6, -23,
    9, 53, -6, -16, -35, 13, 0, 7,
    39, 11, -9, 16, 56, 2, 19, -18,
    -49, 32, 12, 3, -50, 14, 17, -10,
    -4, -36, -29, -20, 18, 15, -16, -2,
    36, 55, 15, -20, 12, -15, 13, 5,
    15, 25, -21, 41, -18, 10, -38, -1,
    -19, 19, -20, 44, -11, 24, -7, 27,
    -18, -2, 12, 9, -21, -6, -27, 2,
    -19, 35, -1, 2, 29, 2, 17, 6,
    25, 5, 3, -1, -3, -29, -6, -39,
    -20, -22, 3, 2, -2, 4, 22, 11,
    9, 18, 20, 23, 10, -6, 15, 0,
    -1, -42, -13, 2, -37, -1, -5, -11,
    18, -4, -2, 4, -55, 45, 70, 2,
    -7, -4, 41, -5, -1, 15, -57, -11,
    3, 8, 32, -26, 10, 5, -69, -50,
    37, -11, 27, -3, -12, 37, -19, -24,
    21, 5, 9, 5, 4, 24, -63, 4,
    15, -4, -19, -2, -24, 11, -6, 10,
    -20, 20, 22, -2, 36, -31, 14, 14,
    13, 6, -45, -36, -28, -13, -50, -27,
    -5, -12, 10, -21, 8, -3, -1, -19,
    8, 17, 9, -26, -2, -14, -17, -1,
    13, 8, 28, -19, -19, -21, -11, 5,
    71, -25, -8, 19, 16, 18, -17, 7,
    11, 10, 7, 24, 40, -25, 10, 2,
    -19, 3, -55, 3, -22, -18, 4, 27,
    -26, -6, 24, -24, 8, 9, -21, -13,
    35, -17, -9, 4, 14, 24, 16, 17,
    -19, -3, -1, -9, -30, 14, 8, 17,
    -38, -2, 7, -12, 6, -1, 6, -1,
    -9, 5, -19, 6, 5, 11, 3, 6,
    -32, -19, 19, 15, 4, 20, 17, 5,
    -2, -15, 5, -1, -44, 9, 25, -27,
    3, -15, -19, -8, 3, -14, 1, 10,
    -9, 10, -30, 17, 20, -26, 16, -4,
    33, -30, 15, -8, 17, 11, -44, 12,
    -7, 11, -11, 29, -9, -3, 23, -9,
    -25, -2, -19, 50, -7, -5, -1, -13,
    41, 25, -18, 0, 20, -28, 0, 3,
    -1, -3, -35, 26, -5, 7, -6, 1,
    -2, 0, 15, 2, 26, -6, 40, 62,
    -11, -56, 0, 0, 44, 15, -1, -20,
    27, -17, -11, -24, 58, -11, 30, 13,
    26, -2, -61, 7, 51, -15, -61, 11,
    19, -101, 10, 9, 4, 14, -29, 21,
    22, 21, 21, 1, -25, 3, 23, 25,
    8, -22, -22, -9, 4, -8, 3, -25,
    -10, -1, -15, -9, -27, -1, -21, 17,
    -4, 26, 15, -4, -39, -16, -6, 22,
    2, 40, -7, 5, 15, 7, -24, 7,
    23, -37, -3, -3, -5, 0, 0, -16,
    21, -34, -20, 19, -19, -40, 31, -18,
    20, -12, -12, -42, -48, -32, -19, -7,
    28, -14, 16, -3, -2, 3, -12, 14,
    -62, 2, 7, -9, -20, 20, 41, -16,
    -1, -23, -4, 43, 5, -25, -7, 25,
    -32, 15, -8, 4, 48, 81, 5, 60,
    -8, -8, 30, 26, -13, -19, 2, -32,
    -22, -5, -9, 62, -33, -32, -26, 28,
    17, -19, 55, 19, -2, -1, -51, 10,
    15, -9, -43, 15, 10, -34, 19, -66,
    -32, -30, -5, -18, 58, -4, 74, 3,
    58, 11, 11, 54, 55, 29, -68, 23,
    -14, 75, -71, -28, 12, -56, 20, 24,
    -21, -36, -11, -26, -34, -50, -21, -12,
    25, -99, -39, -26, 40, 6, 16, 32,
    3, 2, 40, -19, 0, -8, 31, -21,
    59, 13, -5, 22, -21, 2, -20, 11,
    -24, -11, 28, -9, 29, -22, -37, -50,
    -90, -31, 8, 6, 19, -95, -23, 50,
    -3, 33, 14, 14, 47, 17, 67, -24,
    -51, -9, 25, 20, 39, 58, -101, -28,
    -9, -4, 16, 33, 24, -18, -12, 90,
    -21, 43, 12, 13, 5, 0, 47, -1,
    -27, 6, 5, 18, -70, 45, -9, -66,
    -35, 8, 35, 63, 23, -11, -5, -33,
    11, 6, 8, 42, 14, -48, -31, 12,
    -13, -24, 42, -46, -15, 25, 7, 35,
    20, -30, 99, -36, 32, 56, -19, -7,
    13, 6, -38, 33, -11, 3, -4, 13,
    -37, -36, 15, -13, -45, -55, 47, -11,
    0, 1, -30, -20, 43, -18, 25, -18,
    12, -2, -12, 23, -1, -17, -6, 24,
    12, 52, 55, -10, -18, 37, 23, 21,
    9, 11, 4, 3, 4, -33, -16, -31,
    -26, 12, -75, -16, 35, 21, -17, 26,
    27, 72, -15, 29, -9, 9, -37, 15,
    -62, 12, -2, -29, 16, -13, -19, 20,
    24, 34, -7, 14, 8, -26, -33, 11,
    26, -26, 77, -11, -16, -40, 66, -31,
    -6, 85, -51, -14, -5, 9, 37, -7,
    -21, -35, 21, -28, 12, -56, -30, -48,
    0, -36, 15, -18, 36, 31, -20, -20,
    -18, -40, 3, 17, 39, 6, -43, 87,
    48, 81, -28, -9, 58, -27, -14, 21,
    11, 45, -49, -11, 56, 63, -45, -66,
    -21, 6, 35, -26, 41, 12, -74, 11,
    26, -36, -29, 35, 7, 33, -47, 27,
    61, 6, 9, -5, -84, 18, -13, 44,
    -12, -87, -55, 35, -14, -4, 10, -7,
    13, 21, 8, 3, -43, -26, 17, 17,
    15, -48, 11, -48, -87, -42, -15, -50,
    -36, -21, 9, -27, 36, -49, 51, -34,
    29, 22, 1, -5, 18, 6, -21, 86,
    -6, 10, 24, 29, 25, -26, 13, -46,
    -27, 21, 13, -13, -24, -33, 54, -47,
    29, 4, 61, -19, 17, -60, -35, -20,
    -36, 28, -63, 12, 19, -16, 77, -22,
    6, 9, 10, 3, 13, -8, -45, -58,
    -39, -4, 12, 19, -33, 10, 53, 29,
    39, 6, -20, -15, 46, -27, 71, 47,
    50, -9, 14, -48, -30, 91, 76, -66,
    -18, -74, -39, 32, -55, 26, -2, -48,
    10, -29, 37, -10, 25, -19, 34, -56,
    10, 6, -4, -11, 33, 7, 29, -23,
    36, 10, -32, 41, 26, 10, 23, 41,
    2, 38, -33, -11, -81, 95, -6, 104,
    -8, 72, 62, -55, -32, -1, 86, -35,
    -4, 13, -22, -63, -5, -87, 46, -28,
    -29, -41, -75, 8, 56, -77, -11, 14,
    -4, 67, 3, -7, 66, -3, 17, -33,
    12, -77, -49, 24, -7, -33, 11, -42,
    -23, -31, -57, 0, 7, 18, 24, -127,
    -8, -30, -64, -6, -29, 31, -30, -27,
    -58, 2, -5, -20, 4, -5, 49, -14,
    -57, -5, 4, -75, -8, 52, 35, 29,
    39, 30, 12, -1, -41, -5, -4, 27,
    67, -33, -33, -16, -13, -29, -16, -81,
    -9, -46, 10, 15, -45, 71, 6, 42,
    -14, -4, -2, -10, -21, 4, 20, 18,
    -15, -27, 62, -41, 8, 21, -47, -9,
    20, 62, -22, -13, 29, 15, -9, 3,
    24, 30, -9, 65, 78, 10, -52, -1,
    -31, 55, 39, 12, -5, -25, 54, -12,
    -20, -54, -1, 1, -22, -28, -19, 21,
    50, 37, -3, 32, -42, -50, -13, 22,
    5, 1, 21, 15, -52, 9, 54, -66,
    -8, 79, 34, -29, 29, -29, -19, 0,
    35, 28, 23, -84, 56, -34, -11, -10,
    9, -52, 39, 3, -9, 1, 4, 49,
    26, -31, 10, 6, -37, 6, -78, -18,
    -81, 4, -26, -6, 2, 100, 47, -6,
    47, -47, 32, -83, 19, 69, 36, -59,
    48, -19, -37, 8, 32, 23, 32, 41,
    20, 16, -37, -1, 9, 30, -13, -27,
    8, -20, 31, -19, -19, -16, 78, -42,
    -16, 5, -28, -55, -9, 30, 15, 27,
    28, -16, -2, -54, -50, -33, -10, 23,
    -15, 30, 7, 15, -84, 36, 4, -19,
    5, 35, 40, -15, 44, 26, -37, -72,
    -29, -23, -21, 44, 23, 8, 32, 29,
    -12, 55, -50, -7, -17, -21, -10, -35,
    36, 3, 9, 2, -43, 7, -72, 27,
    25, 13, -63, -7, -18, -21, 26, 40,
    63, 26, 16, -7, 49, -17, 11, -23,
    75, 31, -19, 7, 24, 21, -9, -23,
    12, 17, 8, 52, 39, -39, -4, -8,
    28, -39, 6, 0, -26, 38, 77, -8,
    36, 16, -26, 25, 41, -68, -4, 6,
    65, 64, 9, 68, 37, -18, -16, -32,
    -27, 24, 5, -20, 61, -52, 20, -28,
    9, 43, -17, -11, -22, 34, -26, 3,
    -6, -70, 1, 32, 46, 8, 45, 12,
    -27, -19, -11, 19, -44, 9, 48, -7,
    -2, 9, 4, 77, 29, 43, 4, -7,
    -22, -9, 47, 82, -10, 43, 26, -1,
    12, 2, -15, 8, -3, -70, 14, -19,
    17, -7, -3, 40, 31, 9, -13, -2,
    2, -2, 38, 26, 46, -27, 16, 5,
    -19, -89, -80, 10, 86, 31, -4, -15,
    -19, -4, -20, 7, 46, 0, 58, 13,
    24, 51, 58, 14, 15, -44, 32, 5,
    11, -127, -3, -7, 12, 15, -12, 15,
    12, 46, 66, 21, -14, -14, -7, -5,
    -35, 2, 5, -16, 6, -11, -16, -9,
    -19, 12, 72, 41, 4, 13, -15, 22,
    -4, -8, 33, 35, -22, -17, -47, -23,
    23, 20, 56, 12, 8, -63, -24, -17,
    43, -57, 1, 4, 14, -53, -6, -32,
    -6, 63, 15, 1, 25, 62, -5, 41,
    14, -1, 15, 3, 57, 32, 45, 51,
    42, -4, -12, 78, 41, -30, -97, 2,
    14, -35, -23, -18, -25, 89, 12, -58,
    33, -2, 14, -29, 10, 8, 47, -42,
    -32, 15, -61, -9, -35, 48, 11, -59,
    -7, -19, 19, 26, -12, -9, 10, 18,
    5, -68, -29, -1, 1, 32, -24, -27,
    -65, -16, -32, 2, -23, -3, 71, 24,
    21, -2, -45, 34, -17, 15, -8, 27,
    29, 9, 5, 1, -15, -21, -4, 19,
    2, -8, -2, 10, 10, -1, 13, 7,
    13, -9, 18, 5, 11, 4, -23, -52,
    22, 0, -7, 9, 13, -5, 21, -18,
    -11, 18, 11, -24, 2, -18, -5, -4,
    -8, 54, -3, -8, -25, -7, -11, 17,
    -11, -30, 23, 14, 17, 15, -13, -7,
    -33, -16, 0, -45, 25, -26, 34, 5,
    0, -5, -4, 16, 16, 3, 52, 0,
    30, 9, 15, 0, -1, 26, -5, -36,
    -29, 10, 22, -4, -38, 2, 7, -32,
    -23, 31, -46, 6, 24, 27, 13, 17,
    1, 5, 9, 12, 8, -9, -26, 4,
    -9, 4, -5, -8, 4, -4, 20, 30,
    -20, 26, -11, -17, -12, -2, 7, 9,
    26, -12, -8, -57, -12, -9, -4, -22,
    6, -26, 12, -11, -24, 37, 4, -12,
    -9, 3, -13, 8, 19, -3, 30, -14,
    22, -15, -3, -39, 9, -1, -29, 1,
    -7, 3, -14, -2, -35, 11, 21, 32,
    23, 8, -15, 20, -7, -6, -15, 4,
    0, -9, 4, 4, 9, -14, -12, 8,
    -16, -1, -14, -1, -12, 4, -24, 20,
    21, -7, -21, -28, -6, 17, -36, 0,
    17, -8, 12, -9, 17, -5, -34, 11,
    19, 13, -12, 6, 3, 28, -8, -11,
    38, 13, -26, -33, -30, -4, -36, 17,
    15, 17, 1, 33, 12, -19, -41, -8,
    -28, -6, 5, 3, -24, -24, 21, -5,
    5, 13, 7, -14, 4, -17, -9, -20,
    10, -4, 14, 16, 28, 0, -2, 71,
    5, -38, -28, -27, -1, -26, -8, -30,
    -18, -4, -30, 8, -23, 5, -3, 9,
    7, 12, 4, 5, 19, -7, 19, -30,
    -7, 28, -37, 18, 12, 28, -20, -34,
    2, 16, 8, -5, 1, -35, 31, -37,
    7, 21, 6, 4, 43, 7, 4, -2,
    0, -19, -8, 4, 3, 12, -23, 5,
    1, -4, 26, 25, 11, 7, -2, 24,
    7, -45, -19, 4, -6, -2, 8, -30,
    10, 11, -16, -2, 25, -19, -21, 8,
    10, 0, -13, -4, -11, -6, -3, -4,
    -7, 7, -16, 2, -35, 38, 26, 6,
    -1, 53, -3, 6, 20, -7, -45, -5,
    1, 22, -1, -4, -8, -1, 7, 34,
    9, -3, 10, 0, 5, -1, -32, 6,
    10, 16, 2, -29, 7, -22, -24, -18,
    -17, 37, 7, -6, 15, 20, 31, 3,
    14, -23, 6, -14, 10, 5, 40, 21,
    -3, 9, -9, 9, -30, -28, -3, -10,
    -19, -6, 11, 13, -1, -23, -22, 4,
    -31, 12, -15, -40, 17, 3, 18, -43,
    17, -1, 0, 1, 17, -41, 2, -1,
    -11, 22, 0, 5, -9, 15, -9, 14,
    29, 32, 5, 27, -14, 17, 13, 20,
    27, -23, 19, 2, -9, -63, -22, 4,
    13, 31, -25, -8, -11, -15, -6, 3,
    -7, -5, -26, 9, -8, -37, -8, 12,
    -12, -5, -32, -6, -17, -35, -25, -14,
    -22, -25, -9, 35, 45, -3, -39, 14,
    -16, 2, -6, 11, -31, -19, 6, -38,
    -1, 91, -9, 10, -27, 33, 38, -22,
    -26, 2, -15, 19, -12, 3, 35, 10,
    11, 29, -7, -21, 36, -5, 19, 7,
    12, -16, 8, -21, -30, -5, -4, 13,
    38, 23, 10, 14, -30, -46, 13, -39,
    -43, -32, -21, -27, 55, -6, 15, 43,
    13, -4, 26, -24, 13, -8, 14, 22,
    -10, 0, -1, -3, 23, 5, 21, 29,
    15, 22, 0, -7, -13, -46, -20, -36,
    45, -30, -3, -3, 7, 35, -37, 30,
    10, -20, 4, -6, 5, 22, -19, -5,
    15, -12, -4, 4, -10, -15, 10, -44,
    28, -20, -22, -24, -22, 32, -9, 0,
    14, -6, 10, -9, 41, -35, -13, -1,
    1, -8, -2, -1, -21, -21, -32, 8,
    -10, 25, -4, -15, -1, -13, 58, -26,
    1, -23, 5, -13, -9, -18, 3, 11,
    -31, 8, -36, 15, -3, -24, -7, 1,
    -7, -76, -4, -8, -14, 19, -6, -25,
    -24, 9, -6, -4, -12, -16, 3, -17,
    26, -8, -5, 5, 2, -50, 28, 5,
    3, -15, 7, -8, -4, -45, -64, 13,
    -19, -16, -9, 2, 16, 19, -12, 11,
    5, -20, 8, -8, 2, 4, 15, -11,
    -1, -9, 1, 6, 16, 2, 27, 30,
    -15, -23, 42, -8, 36, 7, -1, -7,
    3, 6, -12, 17, 28, -29, -15, -14,
    16, -3, 6, -1, 0, 0, -8, -11,
    -14, 3, -9, 7, -33, 19, -7, 32,
    -35, 8, -33, 15, 34, -21, 20, 7,
    41, -3, 12, 20, 7, -5, 30, -21,
    9, 9, -8, -19, 22, -20, -9, -28,
    -6, 6, -13, 7, 1, -3, -27, -7,
    14, -9, -15, -26, 29, 11, -46, 37,
    -5, 15, 36, 30, 3, 24, 7, 1,
    -17, 1, 33, 7, -6, 23, 1, 9,
    -6, -18, -5, -4, -11, -10, 18, -35,
    -25, 9, 42, -43, -13, -5, 8, 0,
    63, 13, -28, 2, -4, 43, -8, 21,
    12, -34, -18, -14, -25, -8, 9, 18,
    -8, -11, 6, 3, -34, 7, -3, -24,
    -5, 26, -8, -19, 35, -17, 21, -15,
    -21, -29, 13, -24, -4, -28, 38, 2,
    1, 1, -5, 4, 19, -17, -6, 2,
    -6, -25, 45, -14, 11, -7, -6, -15,
    -5, 4, 5, 6, 23, -28, -7, 9,
    -24, 20, 18, 60, 17, -34, 21, -20,
    -8, -15, -36, 2, 0, -47, 18, -26,
    16, 0, -1, 2, 8, -15, 4, -5,
    33, -30, 2, -9, -20, -29, -18, 18,
    -31, -18, 19, -2, 9, -29, -45, -11,
    1, 16, -13, 1, 43, -44, -8, -2,
    5, -98, -9, -3, -4, -17, -3, 4,
    41, -11, 41, 26, -3, -28, 16, -2,
    -18, 5, 18, 29, 12, -5, -19, 4,
    -25, -4, 29, 10, 44, 8, 25, -18,
    -4, 2, -10, 14, -51, -18, 2, 24,
    -11, 23, -5, -8, 4, -33, 28, -26,
    74, 24, -3, -2, -16, -1, 1, 15,
    -26, 8, -19, 17, 21, 31, 6, -7,
    0, -6, -2, -2, 7, -5, 23, -64,
    -22, -11, -22, -29, 19, 1, 12, -37,
    5, -20, 7, -9, -5, 26, 19, -10,
    -2, -20, -7, -6, 3, 10, -5, -29,
    1, 12, 2, -7, -25, 16, -17, 6,
    -6, 2, -24, 33, -4, 10, 29, -19,
    -57, 33, 38, -12, 17, -14, 40, -17,
    18, -1, 27, -45, 21, 30, 11, 16,
    -7, 10, -4, -9, 1, -11, -31, -63,
    54, 12, -21, -43, 5, 0, -81, 59,
    -17, -14, 9, -8, 14, -13, -4, -20,
    16, 24, -24, 41, 1, -3, 40, -11,
    -8, 56, -2, 14, -15, 19, 31, -28,
    11, -18, -13, 25, -1, -16, -27, -26,
    5, 6, 12, -31, 5, -9, -16, 4,
    -2, -14, 12, -23, 62, -4, 41, 48,
    26, 7, 29, 8, -22, 7, 60, -3,
    -4, 14, -27, -26, 15, 43, 26, -6,
    5, 49, -11, -22, 7, -2, -25, -9,
    -3, -2, -74, 2, 15, -20, -23, 8,
    -24, -3, -12, 16, -9, -19, -19, -35,
    -54, 21, 32, -42, -66, 43, 54, 15,
    -18, -15, -27, -45, 23, -22, 0, -11,
    -13, -13, 39, 21, -19, 28, 8, -6,
    -7, 4, 9, -5, -36, 2, 44, 30,
    47, -33, 23, -20, 7, -7, -6, 18,
    52, -15, -50, 2, 3, 31, -29, 22,
    -5, 24, -29, 6, -13, -3, 9, -22,
    5, 6, -4, -6, -28, -24, -73, 7,
    -15, -6, -17, 6, 1, -25, 6, 7,
    11, 10, 30, -21, -3, 7, -23, -5,
    -6, -22, -11, 19, 25, 11, -17, 14,
    24, 10, -28, 6, -4, -19, -18, -3,
    57, -55, -8, -35, 41, -44, 0, 20,
    -25, -52, -5, -52, 17, -8, -8, 21,
    16, -5, -2, -14, -2, -26, 34, -11,
    9, 18, 4, 3, -9, 61, -6, -17,
    -31, -26, 14, -11, -52, 37, -5, -14,
    23, 41, -26, -5, -6, 16, 4, 28,
    -29, 21, 4, 4, 13, 21, -17, -15,
    1, -2, -4, 0, -10, 30, -11, -6,
    -12, 14, -59, 3, -15, -9, 7, 1,
    -1, 5, 52, -2, -13, -19, 8, -42,
    -8, -22, -18, -16, 3, 14, -13, 50,
    2, -30, -12, -17, 0, 1, 4, 42,
    -14, 31, -2, -40, -29, -13, -17, 15,
    -25, -15, 2, 26, 39, -13, 1, -33,
    16, -16, -3, 22, 6, 4, -4, -2,
    -16, -12, -16, 9, -4, -41, 34, -22,
    -68, 21, -21, 4, 13, 64, -34, 6,
    2, 13, 32, 19, -20, -9, -24, 11,
    -29, 32, -23, -2, 24, 7, -62, 22,
    1, 19, 13, 16, 5, 3, -30, 18,
    -25, 24, 9, -14, -17, -17, 50, -31,
    -25, 6, 45, -36, 21, 26, 22, 16,
    -2, 11, 0, 2, -40, -23, 1, -3,
    -9, -22, -2, 3, 5, 11, -19, 28,
    -13, -35, -16, 13, -9, -23, 4, -10,
    -2, -21, 28, 48, -10, -15, -7, 1,
    -9, 5, -5, 7, 46, -18, 17, 11,
    6, 6, -18, 0, 6, -8, 12, -14,
    34, -5, -11, 20, 1, -20, 26, -15,
    45, -18, 31, -55, -41, -25, -16, -28,
    1, -6, 18, 6, -9, -3, 28, 18,
    5, 9, -9, 10, 22, 17, 16, 19,
    4, -32, -5, 25, 29, 16, -8, -33,
    4, -25, -24, -3, -16, -8, 19, 19,
    -7, -6, 10, -2, -4, 19, -30, -16,
    1, 91, -3, 19, 6, -18, 4, -37,
    -20, -4, 10, -3, 79, 13, 4, -3,
    -19, -19, 10, -29, 18, 0, -12, -7,
    3, -30, -43, 3, -45, 4, 25, 39,
    49, -3, 9, 6, -13, -37, -14, 12,
    -56, -13, -8, -33, 24, 11, -7, 19,
    -37, -2, 9, 38, 8, -16, 15, 7,
    -13, 14, 37, -27, 7, 10, 25, -7,
    -6, 7, 12, -3, 4, -9, 16, -53,
    -12, -56, -31, -49, 30, -44, 0, -74,
    -7, -18, 54, 10, -26, 6, -2, -4,
    6, -42, 29, 12, -11, 6, 16, -33,
    -3, -39, -18, -15, 5, 26, -2, 9,
    15, -9, 16, 8, 50, -53, -6, -19,
    3, 13, -9, 7, 22, -35, -46, -33,
    -11, 15, -15, -6, 16, 10, 43, -54,
    5, -32, -13, 0, 13, -11, -21, -49,
    8, 12, 4, 18, 13, 71, 9, 46,
    -5, 107, -32, 6, -10, -3, 43, -34,
    29, 24, -39, -8, -19, -8, 93, -15,
    45, 2, -8, 3, 8, 34, -24, 0,
    -9, -1, -5, -9, -20, 12, 9, 23,
    30, 33, 29, -41, -7, 29, -26, 21,
    1, 7, -38, -9, -3, 9, 3, -28,
    7, -1, 1, 2, 4, -18, -58, -35,
    -19, 28, 46, -19, -7, 24, -9, -32,
    71, 13, 7, -9, 33, 1, -11, 10,
    -27, -5, 5, -16, -15, 36, -28, 18,
    -16, 4, -18, -9, 19, 0, -22, 31,
    -1, 12, -7, 22, 30, -6, 8, -28,
    -26, -13, 26, -18, -4, -23, -12, -20,
    5, -1, 3, -9, 43, -10, 13, -7,
    5, -7, 7, 13, -37, -2, 12, 2,
    33, -7, -6, -28, 15, -20, 15, 14,
    3, 49, 12, 7, -13, -25, -13, 10,
    -27, -7, -6, 28, 1, 42, 28, 10,
    -15, 12, -5, -7, -12, 10, 22, 5,
    7, 10, 9, -17, 29, -6, 12, 4,
    -6, 6, 4, -23, 7, -4, -9, -1,
    -47, -18, -3, -8, -72, -24, 8, -11,
    -9, -2, 14, -6, 1, -5, -2, 14,
    -29, 15, -3, -22, -17, -31, 29, -16,
    16, 31, 49, -17, 17, 9, -6, -8,
    6, 0, 12, -5, -18, 12, -1, 1,
    -10, -12, 42, -18, -6, -7, 4, -17,
    38, 28, 29, -6, 3, -2, 36, 6,
    39, 7, -50, -48, -34, -4, 43, 31,
    -23, -16, 30, 8, 15, -9, -29, -14,
    -5, -8, 4, 12, 8, -54, -31, -4,
    -2, -23, 8, 11, 4, -38, -50, 1,
    8, -32, 38, -16, -3, -32, 5, -17,
    -17, 14, 9, -23, 45, -62, -32, -2,
    14, -108, -4, -11, 14, -10, 15, 7,
    3, 20, 18, 31, 29, -8, 40, 13,
    -5, 4, 55, 52, -6, -6, 0, 39,
    -2, 30, 24, 10, 40, -5, 26, -43,
    -8, 7, -25, -2, 10, -35, 14, -1,
    -85, -15, 12, 27, 20, -46, 12, -9,
    -15, 41, 2, 13, 0, -10, 39, 5,
    0, 12, -25, -17, 25, 12, 16, 3,
    27, -3, 9, -9, -24, -4, -43, -9,
    -22, 32, -56, -35, 29, 23, 15, -11,
    -10, 26, -33, 58, 47, 22, 12, 8,
    7, 16, 12, -7, -10, 13, -30, 23,
    -2, -7, -5, -2, -24, 2, -37, -45,
    -24, -7, -17, 7, 12, 1, 17, 42,
    -40, -25, 118, -12, 9, 46, -19, 17,
    -12, 21, -36, 59, 38, 14, -12, 23,
    -15, -5, 13, -16, -2, 0, 25, -15,
    42, -5, 41, -53, 21, 24, 54, -10,
    29, -1, -67, -17, 62, -57, -24, 49,
    -13, -26, 23, -17, -42, -38, 48, 0,
    -24, 79, 25, -6, 15, 10, -5, 12,
    -31, -39, -14, 65, -22, -62, -57, -33,
    109, 20, -51, 68, 2, -8, 5, 73,
    23, 10, -36, -7, 97, -5, 61, 35,
    10, -7, 21, -7, 13, 27, -4, -7,
    -19, 30, -35, -57, 5, -23, -16, 4,
    8, -49, -16, -54, 35, -52, 23, 21,
    -36, 33, 42, -29, 44, 5, -78, -1,
    -10, 15, -2, 14, -49, 19, -20, -45,
    -39, -4, -7, -72, -18, -20, -55, -74,
    -37, 37, 51, 21, -22, 3, -20, -9,
    -23, 8, -46, 20, -56, 77, -19, -4,
    -1, -3, 4, 3, 1, -32, -51, -8,
    -8, -29, -12, -20, -4, 7, 62, -13,
    -86, -5, 71, 51, -4, -53, -51, -70,
    -1, -30, -18, -7, 70, 12, 46, 0,
    15, 3, 3, -1, 7, 9, 7, 28,
    44, -33, 12, 6, 39, -5, 18, -4,
    -52, 75, -54, -49, 45, -21, 33, 29,
    -36, 22, 6, -13, -3, 6, 4, 63,
    5, 25, -44, 0, 41, -82, -25, 39,
    5, -29, -12, -83, -7, 27, 83, -19,
    -104, 57, -37, 1, -13, 47, 7, -21,
    -29, -50, 3, 8, -57, -19, 35, 46,
    3, 5, 2, 11, 20, 25, -23, 44,
    -30, -91, 19, -24, -44, -18, -43, -82,
    -14, 53, 53, -6, 18, -43, -15, -42,
    18, 3, 59, -2, -21, -12, -34, -49,
    8, 0, 12, -1, -6, -29, -9, -38,
    -49, 23, -89, -24, 12, 6, 41, -25,
    5, -21, -86, -28, -34, 28, 31, 12,
    -31, 12, 73, 56, 42, 77, 0, 7,
    6, -34, -32, -7, 11, 11, -12, -38,
    -23, 22, 29, 10, -21, -40, 75, -10,
    3, -51, 97, 11, -6, -73, -64, -29,
    18, 20, -16, 28, -23, 34, 43, -32,
    -7, -2, -34, 10, 13, -18, -54, 48,
    -25, 35, -1, -37, -3, 26, 81, -4,
    11, -41, 8, -49, 44, -62, 61, 0,
    36, -48, 32, 25, 12, 5, -46, -4,
    4, 15, 15, 4, 14, -2, 45, -59,
    27, -38, -2, -9, -36, -19, 58, -48,
    58, 17, 22, 31, -30, 49, -15, -3,
    -31, -29, 17, 18, 10, -63, 7, 11,
    -6, -16, 0, 1, 19, -6, 11, 12,
    -28, -21, 2, 9, 53, 56, 16, 33,
    -27, -53, -9, -13, 16, 23, 37, -17,
    -38, 34, 13, -18, 102, -4, 29, -18,
    -9, 3, -17, 3, -12, 20, -14, -1,
    25, 29, -49, 7, 25, 8, -20, 34,
    -22, -19, -1, 42, -10, 97, -34, -42,
    37, -67, 9, -8, 5, -56, 34, 22,
    -4, 2, -19, -9, -44, 46, 35, -9,
    12, -20, 21, 33, 1, 69, -17, 53,
    -14, 6, 74, -43, -11, 11, -36, -28,
    49, 17, 4, -45, -28, 30, -20, -11,
    13, 81, -11, 2, 21, -7, -57, -13,
    -10, 24, 5, 4, -101, 28, -25, -11,
    -59, -59, -16, 10, -21, -3, 11, -20,
    -66, 63, 15, 32, -58, -5, 72, -7,
    41, 18, 0, -2, 11, 26, 62, 16,
    -60, 6, -19, -48, -12, -46, -1, -37,
    79, 25, -16, 64, -30, 31, -67, -49,
    34, -15, 18, 9, 41, 14, 49, 21,
    0, 11, 16, 13, -18, 62, -21, 45,
    26, 2, -38, -37, -31, -22, -16, -27,
    -65, 39, -51, 45, -20, 0, 38, 5,
    -45, -20, 20, 21, -46, 7, 25, -34,
    -15, -47, -26, -27, -10, -11, -56, -6,
    -18, 42, 19, -8, -64, -29, 29, -6,
    21, 5, 3, 0, 30, 25, 24, 12,
    28, -13, -12, -55, -30, 21, 59, -50,
    -9, -38, -8, 5, 12, 55, -24, 54,
    4, -27, -12, 40, 35, 63, 50, -56,
    55, 21, 19, 41, -27, -11, -28, -15,
    -4, 5, 42, -17, -55, -25, 127, -11,
    38, 16, -12, 2, -1, 20, -3, -3,
    -37, -16, 14, -30, -13, 92, 4, 22,
    7, -65, 7, -18, 21, -103, 122, 7,
    15, 14, -17, -4, -4, -14, -9, -26,
    9, 12, 7, 5, 40, 49, -13, 3,
    -52, -13, 33, -2, -26, -4, -35, -81,
    -58, -26, 41, 24, -25, 44, 21, 45,
    -42, 8, -10, 9, 44, 72, -35, 35,
    -13, 6, -17, -4, 58, 0, -43, -86,
    -44, 33, 1, 6, -25, 8, -54, -48,
    -30, -22, -27, 11, 17, 17, -25, 18,
    -5, 24, -26, -4, 17, -58, -5, -42,
    9, -5, 24, -3, -25, -4, 21, 16,
    15, -2, -34, 14, -67, -15, 25, 1,
    47, -16, -25, 9, 2, -9, -21, 11,
    24, 15, -31, -15, -34, 41, 8, -11,
    -65, -5, 2, -38, -44, 16, 9, -28,
    5, 31, -16, 2, 26, 43, -3, -32,
    -27, -96, -2, 52, -12, -37, -32, 13,
    70, 37, -6, 16, -69, -37, 9, -59,
    8, 0, 37, -6, 19, -3, 40, 2,
    -33, 26, -11, -33, -24, 1, -50, -16,
    -23, -7, -58, 1, 8, -12, -41, -12,
    -4, -28, -3, 6, 0, 31, -8, 49,
    -2, -21, 49, -17, 40, 29, 45, -11,
    28, 19, -13, -4, -33, -12, -42, 17,
    39, -11, -45, -33, 15, -41, -81, -19,
    38, -57, 12, -18, -23, -11, -60, -52,
    -30, 2, 22, 2, 17, -77, 75, -31,
    0, -29, -29, 1, -13, -48, 5, 30,
    2, -19, 10, 1, -3, 10, 26, -47,
    5, 19, -48, 3, 47, -41, -45, -58,
    23, -127, -18, 1, 0, -2, -1, 12,
    13, 16, 34, 26, -5, 1, -31, 5,
    -36, -69, -66, -63, -28, -18, 9, -16,
    26, -13, 1, 5, 80, 42, 20, -113,
    -35, 4, 0, 6, 41, 39, -55, -25,
    -50, -22, -17, 26, 62, -28, -36, 36,
    -44, 50, 9, -20, 45, 71, -74, 3,
    1, 6, 13, -43, 25, -41, 50, -13,
    20, -2, 12, -17, 9, 40, 26, 64,
    -74, 33, -71, -58, 81, -7, -16, 30,
    64, -50, 22, 22, -64, -17, -70, 25,
    -17, -8, 35, 11, -37, 55, -33, 32,
    -10, -5, -15, -28, 7, -66, 17, 73,
    -67, -29, -22, -40, -88, -2, -7, -17,
    13, 26, -1, 2, -7, 5, 14, -3,
    -9, -8, -9, -5, -17, 12, -20, 2,
    -22, 49, -15, 41, -5, 15, 23, -11,
    -3, -3, -23, 20, 8, 18, -27, 42,
    -2, 22, 3, 13, -20, -2, 18, -25,
    -1, -17, -6, 1, 17, -23, 7, 21,
    -1, -9, 5, 0, 0, 4, -18, -21,
    10, 13, 14, 6, 10, -11, -11, -29,
    -17, -5, 1, 0, 18, -8, -12, -15,
    -9, -13, 13, -6, -35, -8, 33, -4,
    10, -2, 2, -8, 11, -26, -1, -17,
    0, 0, 44, 76, -5, 24, 8, -24,
    45, -7, -13, -3, -10, 32, -30, -48,
    -5, -11, -12, -3, -18, 7, 18, -5,
    22, 17, -29, -22, -8, 20, -10, -3,
    -42, 23, -25, 20, 2, 37, -13, 16,
    -24, 0, 1, 2, -11, -37, 7, -8,
    2, 5, -8, -1, 28, -24, 3, 30,
    -48, -31, 40, 12, -12, -7, -13, 40,
    3, 2, -54, -53, 12, -16, -5, 17,
    15, 3, -9, 2, -60, -15, 9, 2,
    -14, -11, -17, 4, 4, -31, 2, 16,
    -2, -23, -30, 22, 35, -2, 3, 1,
    -47, -2, 49, 4, -31, -29, 6, 0,
    0, -19, -1, -9, -24, 11, -8, -21,
    -7, 11, -4, -2, 25, 8, 47, 26,
    -1, 6, 25, -15, -6, -23, -7, 9,
    -51, -58, -17, -28, -4, -11, 25, 18,
    8, 8, -7, -7, -26, 1, -31, 30,
    -3, -1, 4, 11, 4, 3, 12, -1,
    43, -2, 2, 1, 15, 43, 28, 11,
    -14, -8, -14, 40, -34, -17, 4, 12,
    -8, 6, 18, 10, 39, 2, 23, 45,
    -17, 5, -2, -3, 14, 3, 11, -24,
    34, -26, 13, 0, -32, 5, 23, 4,
    19, -59, -4, -56, 40, -43, -38, -3,
    7, -13, -14, -11, 7, -11, 18, 21,
    -9, 10, 0, -13, -9, 16, 32, 35,
    1, -1, 6, -36, 11, 26, -28, 23,
    -11, -2, -19, 37, -11, 14, -1, 5,
    0, -6, -8, 1, -4, -28, -21, 6,
    -3, 4, -11, -10, 26, -40, -7, 28,
    31, 4, 27, -25, -10, -4, 9, 4,
    -30, -51, 44, 12, -8, -34, -21, -46,
    1, -8, 12, 4, 4, -17, 25, -25,
    16, -8, 8, 1, -10, -50, -23, -8,
    -3, -18, 2, 44, 15, -12, -2, 16,
    -7, 15, 62, -12, 50, 25, -12, -29,
    14, 2, -4, 18, 24, 10, -27, 7,
    -8, 7, 1, -12, -59, -7, -30, -14,
    9, -6, -21, 56, 22, 30, -22, 12,
    -46, -1, 8, -48, 18, 40, -16, 20,
    9, -18, -20, 1, 0, 9, 21, -5,
    0, 2, -6, 4, 15, -30, -39, 14,
    34, -17, -19, -34, -20, -10, 1, -2,
    0, -43, 38, 18, 30, 3, -41, -12,
    -2, -9, 4, 0, 10, 26, 3, 15,
    3, -2, 4, 9, 26, -5, -20, -7,
    -23, -20, -19, 12, 8, 2, -15, -13,
    -23, 5, -18, -46, -47, -27, 2, -4,
    8, 24, 7, 17, 18, -21, -31, 18,
    0, 9, 21, -4, -17, -12, -24, 13,
    7, -1, -31, -7, -10, 3, -10, -26,
    38, -35, -7, -26, -4, 13, 51, -44,
    11, -5, 1, -11, -15, 26, -43, -9,
    -8, 7, 0, 9, 4, 6, -21, -14,
    -3, -57, 18, -46, 15, 16, -10, 25,
    6, -26, -7, 8, -40, -14, 1, 30,
    -6, -1, -12, 11, 10, 52, -6, -4,
    1, 3, -4, 0, 5, 11, -21, 52,
    59, 6, -12, 15, -33, 41, 16, 50,
    31, -8, 36, 38, 48, -58, -5, -39,
    5, -7, 16, -3, -3, -2, 25, -3,
    -8, 6, -1, -17, -18, 19, 10, -50,
    -45, -26, -23, 7, -47, 34, 7, -9,
    16, 5, 6, -9, -25, 14, -18, -4,
    2, -3, 1, -5, 4, -8, -4, 8,
    0, 2, -3, -18, 26, -2, 31, -2,
    33, -33, 16, 17, -12, -8, 9, 17,
    -26, 50, -5, -20, -6, 8, -34, 11,
    5, -9, -11, 7, 37, -10, -10, 13,
    7, 2, -11, 9, 0, 10, -5, 7,
    -2, -15, 6, 13, -1, -7, -39, -4,
    -57, 14, -31, 14, -23, 10, -8, -16,
    14, 1, -15, -10, 7, -8, 6, 11,
    -17, 7, -13, 0, 47, -11, -2, 24,
    11, 50, -23, -28, -12, 0, -1, -6,
    0, 0, -3, 58, -50, 21, 6, 17,
    1, 4, -8, -4, -26, -34, 15, -19,
    0, 4, 1, 4, -26, -26, -47, 21,
    -40, -28, 10, 17, 14, -33, 20, -43,
    28, 25, -10, -5, 22, 9, 11, -47,
    -3, 1, 11, 9, -1, 2, 4, 10,
    3, 2, -12, 1, -1, 18, 4, -1,
    13, 22, -25, 10, -11, 16, -5, -1,
    13, 12, 16, -14, 8, -26, -24, -3,
    13, 1, -6, 14, 43, 30, 14, -16,
    1, 1, 9, -21, -27, 43, -1, -59,
    -7, 30, -39, 26, -3, 9, 31, 11,
    -9, -4, 24, 21, -36, 13, 48, -7,
    7, 3, 5, -7, -31, -7, -3, 0,
    -14, 3, 12, -3, -41, -2, -7, 14,
    -3, 1, -3, -2, 0, -11, 4, -26,
    -5, -11, -15, -23, -35, -5, -26, -38,
    -8, -11, 5, -11, -1, 1, 21, 25,
    21, 0, -1, 3, -31, 15, 59, 65,
    0, 0, 16, -19, -24, -13, 20, -21,
    18, 42, -15, 26, 11, 40, -10, -9,
    -1, -6, -7, -14, -2, 31, 14, -5,
    -2, -13, 13, 11, 19, 2, -13, 4,
    0, -15, 25, 24, -22, 9, -25, 16,
    55, -16, -7, -10, -53, -11, 60, 20,
    -15, -67, -3, -11, 12, -9, -10, 39,
    12, -12, -4, 16, 32, -102, 44, -45,
    -36, -7, -6, -56, 25, 16, -13, 1,
    0, 14, 17, -13, 38, 26, 6, -6,
    -4, -2, -9, 5, -3, 32, -36, 32,
    -8, -9, 6, -12, -24, 57, -2, 16,
    18, 12, 17, -5, -8, -13, -12, -37,
    -31, -18, 24, 5, -5, -11, 7, -18,
    4, 1, 18, 5, -27, 20, -2, 27,
    12, 4, 28, -8, 8, -5, -52, 34,
    1, 5, -34, 15, 0, -15, 36, 0,
    -37, 10, 2, 38, 36, 19, 1, 0,
    -19, -14, -1, -22, 8, -33, -21, 1,
    15, 9, 2, 0, 26, -32, 4, 40,
    4, -14, 15, 22, -15, 16, -29, -24,
    -27, -56, -11, 70, -2, -6, -48, -10,
    -9, -18, 2, 25, -8, 35, -41, -46,
    6, 1, -12, -37, -20, 19, -46, 20,
    -17, -45, -3, 5, 24, -15, -5, -5,
    21, 16, 33, -20, 5, 5, -6, -10,
    -20, 12, 13, -24, -1, -5, -18, 28,
    -13, -29, -13, 2, 3, -50, -2, -3,
    -9, 6, 8, -4, -33, -39, 8, -14,
    17, 21, 21, -11, 24, 46, 15, -26,
    -5, 1, 13, -17, 18, 23, -27, 9,
    -5, -8, 9, -4, -20, -14, 54, 5,
    4, -11, -43, -53, -31, -15, 14, -11,
    17, 21, -35, -13, -26, -1, -25, -9,
    27, 15, -5, -6, -3, -32, -48, -48,
    -4, -10, -18, -12, -21, 38, 93, 36,
    12, -40, 2, -15, 15, -6, 30, -6,
    9, 1, -18, -5, 24, 14, 13, -24,
    1, 2, 8, -1, 3, 10, -46, 19,
    -15, -6, -4, -12, 22, -23, 56, 28,
    8, 12, 30, 28, -7, -17, 2, -16,
    13, 8, -9, 2, -10, -11, 15, -6,
    -12, -14, 15, 1, -30, 24, -29, 28,
    8, -36, -34, 16, 36, -4, -11, -23,
    -22, -5, 14, 10, 29, 5, -20, 43,
    -8, -15, 35, -16, -3, -44, 20, 18,
    14, -34, -2, -7, 23, -29, 8, -11,
    19, -17, 6, -9, 65, 40, -1, 31,
    -9, -30, -8, -32, -24, -43, 5, 1,
    -11, -26, -1, -3, 1, 24, -13, 31,
    -14, -3, 8, -4, 15, -28, 35, -39,
    8, -27, -11, -19, -23, 30, 68, -3,
    17, -18, 38, 23, -9, 1, 3, 0,
    12, 14, -85, 15, 8, 3, -30, 55,
    2, 10, 11, 8, 29, -38, 50, -23,
    1, 19, 7, 19, -29, -18, -2, -13,
    29, -48, 20, 14, -11, 10, -34, -7,
    29, 29, -3, -13, 15, -4, 13, 8,
    -3, 23, 19, 21, 7, 22, -66, -19,
    -12, 13, 14, -27, -24, 21, 44, 8,
    -3, 10, 6, 9, 14, -11, 31, 9,
    18, 24, 32, -2, 27, 0, 31, 39,
    7, -11, -5, 1, -3, -42, -68, 4,
    -20, -15, 1, 3, -5, -51, -42, 18,
    42, -5, 14, 7, -18, 8, 23, -41,
    0, 3, 23, -8, 13, -11, 13, -14,
    2, 4, 11, 10, 0, 42, -18, -41,
    12, 0, -12, 0, -38, 2, -25, 10,
    -3, -26, -52, -8, 11, 19, -13, 36,
    4, 40, 5, 4, 11, 23, 19, -31,
    1, 3, 8, -18, 11, -34, -3, -34,
    -19, -5, -22, -7, -19, -73, -36, 4,
    31, 45, 18, 41, 8, -28, -19, 2,
    12, -23, 8, -42, -18, -21, 9, 23,
    -4, 5, -6, 9, -15, 1, -20, 47,
    5, -24, -10, -5, 76, -22, -27, 40,
    34, -21, 12, 12, -19, -12, -10, 29,
    14, 0, 2, 3, -21, 21, -16, 19,
    -10, -24, -1, -14, -32, -45, 10, 52,
    45, -8, 8, 11, -9, -21, -27, 1,
    -7, 33, 14, 12, -6, -7, -35, -20,
    -24, 6, -29, 0, -12, 25, 4, -23,
    -11, 22, 3, 20, -33, -8, -4, 29,
    5, -1, -8, 12, -28, 11, -53, 65,
    -61, 25, 3, -9, -12, 5, -28, 27,
    -23, -13, 7, -52, 5, 28, -8, -37,
    2, 10, 3, 18, -15, 13, -39, 33,
    -7, 9, 19, 8, 12, -20, 19, -59,
    28, 28, -6, -9, -11, 0, 0, 16,
    19, 5, -13, -9, 0, 34, 47, 26,
    2, 1, -1, -8, 23, 6, -3, -3,
    -26, 4, 4, 5, -24, 6, -13, 24,
    35, -1, -6, -47, -34, 13, 26, 25,
    9, 5, -21, -3, 17, 44, -8, -9,
    3, 4, 0, -6, -28, -22, -28, -11,
    -16, -13, -8, -20, 12, -11, -10, -63,
    -57, 45, -12, -29, 18, 33, -22, -7,
    -40, -1, -23, -15, -21, 26, 21, 4,
    -7, -3, 10, -10, 2, 3, -25, 27,
    9, 10, -4, 13, -30, 32, 7, -27,
    19, -25, 14, 25, 13, 14, 21, -39,
    17, -12, 2, 36, 10, 4, 5, -28,
    -18, 1, 13, 2, -11, -5, 52, -5,
    8, -2, -3, 0, -43, -3, 1, -18,
    -41, 6, -13, 14, -32, 14, 9, -5,
    -29, 24, 22, 6, 1, -33, -10, -29,
    13, 8, 5, -8, -12, -4, -44, 17,
    0, 0, 13, -5, 10, 29, 0, -19,
    6, -5, -1, -25, -5, 26, -14, 14,
    -15, 11, 9, 20, -2, 1, 49, -5,
    -5, -2, -6, -3, 4, -1, 16, -44,
    -5, 3, 13, 14, -17, 40, -37, 39,
    33, -17, 0, 10, 38, -22, -3, -5,
    -79, 37, -22, -16, 10, -18, 3, -63,
    7, 0, 4, 1, 33, 19, 16, 16,
    12, -4, 9, 1, 35, 13, -6, 14,
    1, 25, -4, -20, -29, 28, -1, -13,
    0, 37, -8, 3, -5, 2, -20, 9,
    7, 5, 4, 8, -20, -15, -2, 73,
    14, 15, 6, 10, 5, 95, 35, -28,
    16, 1, 5, -9, 4, 4, 18, 11,
    -13, 32, 22, 44, 23, 10, 12, -8,
    -5, 0, 7, 0, -43, -4, -20, 4,
    4, -17, 7, -5, -13, 18, -3, -18,
    -3, 41, -33, 18, 33, 6, -3, 1,
    16, -9, -23, 2, 30, -1, 10, -13,
    0, -21, -21, -14, -22, -18, 20, 11,
    42, -4, -4, 5, -20, 16, 61, 36,
    19, 20, 1, -8, -32, 1, 19, -2,
    12, -5, -50, 4, -10, 5, -12, 0,
    -8, -4, 15, 15, -12, -3, 32, 9,
    2, -1, 8, -21, -42, 4, -36, 18,
    -20, -12, 24, 9, -22, -9, -9, -27,
    40, 0, -24, 42, 20, -1, -14, 25,
    8, -84, -13, 6, -17, -15, 2, 14,
    -7, 0, 6, 7, -2, -100, 53, -22,
    14, -21, -1, -51, 38, 11, -13, 1,
    -7, 7, -23, 18, 20, 46, -4, 0,
    3, 2, -17, 8, -19, 39, -13, -3,
    5, 0, 6, 14, -1, 14, 49, -15,
    20, 34, -18, 3, 17, -17, 2, -27,
    -8, -13, -12, 18, 10, 10, -34, -25,
    22, 1, 4, -3, -12, -7, 24, 5,
    24, -4, 15, -10, 23, 17, -76, 33,
    21, -12, -20, 13, -19, -4, 28, 9,
    15, 0, 7, 32, -15, 4, 17, 45,
    -35, 14, 16, -13, -81, -21, 3, 2,
    -14, 13, 8, 10, 22, 11, -51, -38,
    12, 2, -2, 14, 5, 19, -9, -16,
    13, 19, -7, 47, 22, -50, -11, -35,
    -53, -76, 0, 23, -29, -12, -53, 14,
    -3, 6, -17, -50, 5, 6, 3, 28,
    -15, 2, 8, -25, 41, 4, 1, 34,
    -78, -28, 0, -64, -4, -20, -4, 52,
    -35, 24, 13, -7, 48, 40, 53, 11,
    -21, -34, -34, -3, -13, -14, 53, 6,
    -10, -46, 11, -43, -11, -30, -6, -33,
    -36, 35, 22, 46, 34, 84, 27, 10,
    -8, 6, 14, -41, -45, 10, 35, -30,
    2, 32, 1, 33, -37, -36, 38, -27,
    -46, -5, 75, 12, 59, 34, -13, 58,
    49, 26, -15, -81, 1, 2, -76, -11,
    18, 14, 27, 10, 19, -26, 22, 77,
    3, -8, -24, -26, -44, -1, 5, -40,
    -45, -37, 76, -2, 10, 13, -6, 7,
    71, -67, 16, 15, 82, -1, -30, 14,
    14, -13, 3, 8, 12, -18, 8, -59,
    -22, -14, 14, 13, 20, -33, 2, -11,
    51, 37, -61, -20, 45, -60, -43, 31,
    22, -29, 0, 126, 38, -57, 16, 36,
    12, -8, 17, 4, 49, -10, 6, -19,
    -34, -95, -19, 24, -15, 5, 8, -13,
    8, 7, 69, 19, -30, 24, -30, -4,
    2, 8, -8, 10, -36, -25, 49, 16,
    9, -68, -36, -24, 69, 22, 17, 23,
    48, -24, -6, -12, 19, 10, 20, -33,
    -33, -11, -54, -43, 9, -37, 34, -51,
    -14, 5, 19, 16, 13, -7, -13, 105,
    6, -25, 42, 42, -41, -26, 7, -37,
    10, -62, -37, 5, 55, -28, -10, 14,
    -72, 26, -38, 18, 8, -34, 28, -106,
    -18, -12, -29, -22, 34, 14, -67, -3,
    34, -6, -22, 17, -38, 14, -29, -33,
    45, 22, 55, 8, -39, -17, -24, -34,
    3, 26, 1, -9, 1, -53, -103, 37,
    4, 5, -63, 71, -5, -10, 28, 34,
    6, 60, 34, 14, 14, 24, 17, 38,
    -7, 2, 81, -15, -38, -63, -40, 24,
    13, -48, -37, 65, 51, -60, -42, 23,
    7, -90, -37, -1, 44, -71, 16, -9,
    15, -20, -22, -14, -28, -3, 60, 2,
    -64, -11, 45, -16, -3, -66, 8, 22,
    -104, 42, 24, -28, -65, 14, 0, 1,
    38, -6, -101, 42, 13, 19, -21, 34,
    25, 10, -6, 8, 75, 25, 80, 49,
    6, 2, -30, 8, -31, -16, 5, 17,
    51, 32, -13, -76, 22, 5, 19, -12,
    -20, 21, -53, 78, -28, 63, 30, 2,
    33, 20, 7, 4, -17, 104, 13, 18,
    -75, -6, -14, -24, -29, 7, -28, -7,
    29, 20, -29, -30, 20, -48, 4, -24,
    98, -21, 2, 25, -24, 39, 15, -127,
    -26, 41, -8, -5, 1, 8, -23, -49,
    20, -38, -39, -8, 44, -57, -11, 46,
    -57, -38, 0, -17, 21, 29, -30, -11,
    -21, 93, -52, -13, 55, 41, 15, 36,
    -18, -16, 0, -20, 38, 1, 15, -38,
    66, 19, -11, -25, -15, 11, -40, -8,
    -11, 18, 12, -35, -51, 16, 42, 5,
    47, 1, 14, 89, 49, 20, -49, -41,
    -4, 32, -8, 4, 37, 21, 9, 14,
    -22, 12, -37, -17, -16, 25, 29, 85,
    13, 4, -3, 15, 16, 16, 15, 36,
    4, -29, -1, -25, 24, 13, 1, 45,
    16, 9, -4, 42, 42, -8, 87, -19,
    -44, 29, -4, 39, 21, -68, -22, -23,
    -80, 30, -40, 36, 21, -13, 86, 36,
    -2, -9, 26, 44, 56, 50, -44, 16,
    3, 13, 12, 14, -68, 7, 22, -13,
    -3, -8, 45, -13, -7, 1, -9, -7,
    -66, 25, 22, 64, 43, -30, -33, 27,
    21, -24, -19, -9, -27, -38, 69, -26,
    -4, 69, 5, 16, -59, -29, 78, -3,
    -57, -13, -36, 0, 4, -15, 12, -67,
    108, 21, -17, -35, 17, -44, -7, 17,
    12, -57, 21, -25, -16, -30, 44, 30,
    6, 10, -4, -45, 8, 73, -2, -64,
    4, 21, -4, 18, 9, 18, -22, -33,
    -11, -41, -8, -51, 56, 13, 20, -44,
    21, -127, 4, -9, -23, 2, 15, 35,
    -76, 4, 5, 5, -51, -4, -21, 12,
    -17, -14, -9, -5, -101, -25, -31, -4,
    -8, 2, 52, 2, 35, -5, -16, -20,
    70, 38, 12, 26, 61, -70, 34, -55,
    4, -30, 6, 4, -24, -1, 28, -14,
    24, -1, 32, -57, 20, -22, 31, 4,
    49, -39, 83, -14, 11, 15, 46, 23,
    -1, -27, -12, -8, 58, -33, -40, -11,
    40, -1, 27, -30, -33, 9, 2, 109,
    31, 13, 19, 23, -106, 10, -78, -12,
    96, -48, 2, -43, -127, 7, -37, 65,
    -18, 23, -28, -15, -26, -63, -21, -45,
    0, 1, -14, -24, 16, 35, -21, 14,
    8, -8, 20, 14, 44, 63, 12, 49,
    -45, -4, 58, 5, -9, 50, -44, 0,
    1, 15, 33, 2, 12, -12, 44, 29,
    -8, 23, -5, -13, -21, 15, -9, 30,
    5, 24, 11, 32, -54, -31, 25, -8,
    13, -38, 40, -29, -47, 13, -7, -7,
    -113, 73, 19, -115, -24, 0, -10, -50,
    10, 22, -1, -1, 38, -24, 14, -28,
    91, -29, -1, 3, 9, -22, -7, -23,
    87, -21, -10, 19, -14, 50, -5, -37,
    31, -87, -45, 13, -14, 29, 59, 52,
    3, -21, -2, -29, -10, -36, 2, -11,
    35, -20, -17, -6, 13, 9, 30, 37,
    50, 25, -25, -16, 25, -8, 36, 1,
    -6, -18, -56, 33, -16, -39, 2, -10,
    -14, -11, 9, 17, 44, -29, -3, -34,
    -7, -5, -9, -53, 3, 2, 31, 44,
    26, 60, -31, -48, 42, -33, 11, 47,
    -91, 35, 55, 0, -13, 4, -19, -12,
    1, -99, -2, -9, -22, 39, -15, 32,
    22, 13, -10, -23, 42, -127, 58, -39,
    34, -34, -20, 36, -33, 28, 51, -48,
    -76, 8, -39, 24, 7, 55, -14, 8,
    15, 9, -24, 0, -1, -11, 9, 3,
    -12, -12, -29, 31, 9, 63, 47, -9,
    -4, -25, -102, -14, 50, 23, -27, 49,
    -6, -25, -10, 7, -62, 9, -1, 68,
    36, 9, -9, -3, 43, -32, -30, -8,
    37, -9, 36, 6, -45, -9, 9, 32,
    16, -35, -65, 50, 16, 13, 25, 9,
    95, -1, -31, -13, -14, 14, 57, 13,
    0, 40, 8, 4, 38, 21, 10, -25,
    13, 19, 15, -1, -53, -41, -15, 22,
    -42, -21, 25, -19, 27, 28, -38, 19,
    -39, 84, -24, -20, -2, 36, 46, 32,
    -4, -19, -11, -20, 43, 17, 30, -18,
    15, -4, -3, -4, 37, -24, -3, 1,
    -15, -9, -7, 39, -32, 36, -32, 8,
    -15, 10, -9, -25, -42, 23, 3, 26,
    -28, -23, 7, 32, 3, 4, -15, -23,
    -11, -13, -7, 3, -12, -26, 18, 1,
    9, -12, -18, 7, -22, -35, 15, 9,
    -5, -13, -4, 8, -3, -28, 32, -9,
    21, -23, -30, -34, -5, 40, 7, 20,
    2, -2, -8, 17, 10, 65, 22, 30,
    -3, 8, 9, 13, 16, 30, -24, 8,
    -8, 17, 9, -25, -20, 6, -18, -3,
    -8, 19, 9, 3, 10, -19, -23, 45,
    -7, -4, -5, 4, -11, -18, 30, -2,
    -12, 22, 23, 6, -11, -3, 21, -20,
    -5, 0, -12, -16, -19, -12, -9, 12,
    21, -41, 30, 16, -13, 25, -32, 17,
    5, 16, -2, -7, -26, -8, 11, -11,
    8, 8, 37, 4, -3, -9, 25, -20,
    -4, 12, -3, -9, -8, 9, 6, -3,
    1, 8, -22, 31, 45, -25, 26, 6,
    24, 1, 4, -8, 10, 3, 3, -9,
    -32, -32, 21, 7, -14, -9, -31, -3,
    -9, -8, 9, 16, 23, 8, -4, -5,
    -37, -11, 22, 3, 11, 3, -13, 21,
    -8, -6, -3, -7, -8, -16, 6, 14,
    11, -21, 26, 3, -16, -12, 17, 8,
    6, 4, 16, 8, 15, 11, -17, -22,
    11, 10, 24, -33, -37, -35, 26, 44,
    -6, 4, 7, 3, -42, -34, -13, -10,
    -3, -21, -34, 18, -39, 5, 2, -3,
    -1, -10, -6, -5, 14, -22, -14, -21,
    22, -4, 6, -2, -5, 30, 8, 12,
    -4, -2, 8, -3, 18, -14, 7, -18,
    32, -36, -12, -8, 30, -27, 13, -4,
    -4, -8, -25, 16, -8, 7, -2, 33,
    -22, 21, 4, 15, -37, 8, 15, 42,
    21, 2, 1, -6, 2, 20, -29, 8,
    -34, 14, -32, 27, 24, 12, -5, 15,
    -4, -3, -2, 29, 6, 3, -18, 22,
    15, 0, -27, 19, 14, 9, 6, 39,
    -13, 9, -4, 8, 16, 14, 19, 17,
    14, -18, 8, 4, 26, -33, 17, -32,
    7, -2, -2, -1, -16, 9, 6, 8,
    -59, -50, -57, 13, 31, 26, -22, 48,
    6, 18, -5, 8, -7, 1, -41, -39,
    7, -13, 33, -8, 20, -23, 13, -42,
    12, 5, -3, 6, -1, -21, 0, 10,
    -7, -15, 11, 6, 24, 31, 18, 0,
    5, -12, -2, -10, 23, 31, -22, -27,
    -13, -10, -32, -14, 13, -11, 10, -18,
    -13, 6, -10, 9, -16, -2, -2, -5,
    15, 26, 28, 36, 21, 13, 55, 14,
    -20, 0, 21, -7, -11, 15, -5, -19,
    8, -30, 25, -20, 15, 46, 35, -11,
    23, -8, -7, -1, -13, -14, 17, 16,
    24, -8, 2, 6, -5, -41, -14, -29,
    4, -8, 5, 0, 9, 46, 24, 9,
    5, -6, -13, -11, 10, -5, 11, -20,
    28, 10, -2, 9, -15, -15, 10, -15,
    -28, 0, 33, 31, -27, 52, 24, -23,
    -4, -26, 7, 6, -6, 4, 17, 26,
    33, 21, 29, -13, -13, 5, -12, 4,
    -2, -17, -8, -2, 5, 6, 9, -5,
    -18, 35, -5, -39, -25, -28, 4, -44,
    3, 1, 5, -13, 4, 5, -19, 23,
    3, -10, -18, -5, -31, -4, -3, 9,
    -8, 3, 3, 11, -10, -4, 23, 16,
    -29, -26, 1, -32, -35, -23, -15, -24,
    -9, 8, 12, -1, 10, 38, -29, -52,
    9, 0, -7, 22, 1, -1, -47, -7,
    -19, -14, -5, 23, 8, 21, 11, 5,
    28, 18, -46, -11, -31, -23, 60, -5,
    8, -17, 12, 12, -16, -33, 42, 1,
    -26, 0, 7, 20, -26, -6, 8, -7,
    -5, -8, -7, 11, 14, -14, 25, -9,
    -3, 32, 1, -14, -3, -3, -40, 14,
    0, -9, -7, -8, -19, -13, -4, 45,
    -22, 0, -7, 0, -12, -11, 28, 29,
    11, -3, 12, 8, 15, -20, -13, 15,
    -28, -55, 5, 9, 21, 14, 15, 16,
    -6, -2, -5, -13, 11, 10, 14, -25,
    10, -29, -18, 5, -9, 12, 26, 22,
    10, -4, 8, -2, 8, -2, -26, 4,
    -1, -2, 24, 11, -4, -29, -7, 2,
    13, 9, -19, 25, 13, 12, 18, 21,
    -13, 12, 2, 4, -3, -29, 11, -12,
    4, 1, 23, -1, -4, 12, 7, -32,
    34, -12, 38, 51, -39, 0, -9, 19,
    9, 2, -8, 14, -3, -45, 11, 15,
    -9, 5, 5, 11, -5, 6, 2, 0,
    11, 1, 1, 0, -16, 21, -5, 16,
    -40, -43, -42, 33, -22, 8, -15, -31,
    11, 5, -4, -4, 36, 1, -19, 30,
    18, 2, 1, -1, 7, -2, -3, -3,
    7, 5, -9, 3, -11, 30, 2, 13,
    18, 22, 26, 22, -8, 51, 36, 5,
    -15, 4, -4, -12, -9, -13, 17, 15,
    4, 16, -3, 2, 39, -64, -13, 5,
    1, 8, 2, 15, -22, 12, -21, -24,
    -19, -13, 26, -34, 30, 47, 4, -39,
    4, -2, -4, -8, 26, -13, -6, -2,
    -29, -2, -15, 11, 4, 19, -24, -13,
    -9, 8, -3, -3, 1, -18, 8, 4,
    -10, -41, -63, 0, 8, 21, 8, 10,
    -11, -8, 2, 2, 14, 46, -6, -9,
    6, -6, -3, -6, 18, 29, -3, 9,
    19, -5, -6, 3, -2, 1, 16, 3,
    -51, 14, -5, 26, -29, 35, -2, -1,
    -6, 5, -1, -6, -3, 22, -42, -11,
    -9, -14, 27, -17, -18, 16, -38, 8,
    15, 3, -6, 2, 6, -15, -5, 7,
    -8, -47, -16, 10, 9, -11, 0, 9,
    -33, 36, -6, 5, -7, 6, -21, -26,
    5, 5, 7, -2, 11, 9, -17, -8,
    2, -5, -4, -24, 15, -31, 21, -18,
    11, -3, 36, 31, -12, -34, 7, 17,
    -1, -23, -4, -16, -3, -6, 21, 7,
    -14, -26, -5, -26, -10, -3, -1, 47,
    -15, 21, -3, 7, 3, -30, 18, -11,
    -23, 4, -5, 7, 3, 22, 26, 3,
    1, 4, -7, -13, 10, 35, 7, 49,
    -18, 9, 1, 13, -41, -25, -30, 7,
    17, -3, -7, 0, -23, 1, 6, -18,
    22, 24, 11, 30, 6, 19, -16, 13,
    7, 3, 17, 11, -5, -5, -25, -33,
    9, 3, 5, 31, 34, -29, 29, 3,
    -22, -5, 1, -10, 0, 10, -11, -29,
    33, 58, 33, -39, 46, 36, -17, 43,
    8, 8, 3, 4, 15, -9, 0, 0,
    -11, 12, -29, -33, -9, 32, -92, 76,
    -20, 30, -10, -66, -10, 11, 23, 5,
    15, -23, -14, 81, 13, -9, -48, 34,
    -11, -28, 2, -8, -14, 4, 29, -45,
    6, -8, -20, 39, 8, -36, -6, 21,
    8, -17, 3, 6, 1, -32, 22, -2,
    -41, -29, 0, 52, 3, 44, -4, -44,
    -7, 0, 17, 18, -14, 32, 21, 53,
    -38, -5, 19, -37, 45, 67, -36, 42,
    -24, -5, -9, -37, -9, -33, 6, -5,
    3, -35, -7, 11, -29, 24, -51, 42,
    -10, 51, 15, 20, 8, -29, -14, -29,
    36, -54, 29, -5, 18, -30, 20, -48,
    -7, 33, -47, -14, -12, -46, 7, 1,
    2, -24, 0, -10, 6, -2, -35, 28,
    -6, 29, -3, 7, -22, -17, -80, 4,
    -6, 11, 14, 33, 6, -16, -78, 36,
    -32, 9, 1, -8, -14, -9, 16, 24,
    27, 16, -11, 3, 68, -6, -13, 5,
    28, -10, 36, -31, 60, 0, 15, -13,
    52, -15, -44, 5, 8, -1, -96, -33,
    -24, 1, -17, 6, -12, -40, -48, 1,
    9, 11, 5, 34, -4, -59, -27, 40,
    -33, -14, -2, 6, -49, 23, -19, -23,
    -12, 46, -18, -6, -33, -11, -6, 43,
    0, -12, 4, -17, 21, -21, -16, 22,
    45, 26, -25, 17, -24, -43, 6, 17,
    -9, 40, 42, -5, -51, -9, 0, -14,
    -23, -7, -56, 66, -66, 42, 13, -30,
    -6, -32, 10, -22, 7, 11, -27, -17,
    21, -10, 76, 18, -8, 44, -45, -16,
    7, -20, -17, -41, 44, -32, -4, 17,
    -34, 18, 35, -15, 41, -18, 19, -47,
    -34, 5, -63, 17, -19, -11, -31, -24,
    -20, -34, -1, -91, -58, 11, 38, -7,
    3, 4, 9, 13, -10, -3, -21, -27,
    8, -7, 67, -46, 33, 1, 29, 11,
    -17, 0, 33, 17, -10, 23, -48, 24,
    48, 29, 35, -11, -20, 20, -29, -17,
    -4, -5, 15, -4, -6, -10, -15, -3,
    7, 9, -16, -14, 60, -25, -10, -14,
    -10, 4, -3, 4, -5, -1, -6, 3,
    -42, 28, -15, 31, 28, 8, -35, 14,
    4, -26, 12, -1, 13, -33, -23, -9,
    8, 0, -58, 12, 23, 4, 32, 4,
    20, 10, -16, -4, -4, -32, -6, 18,
    7, 5, 15, 33, 20, -41, 22, 37,
    7, -5, 1, 12, 72, 17, -7, -34,
    58, -33, -16, 46, -18, -40, 69, -21,
    -50, -24, -16, 11, 20, -22, -3, -15,
    -35, 32, 8, -72, 11, -33, 0, 53,
    -5, 12, 29, 35, 18, 11, 6, -12,
    -37, 63, -8, 11, 5, 81, 37, 0,
    37, 3, -22, 2, 9, -2, -23, 14,
    46, 29, 48, 41, 11, 1, 48, 31,
    -19, -8, 7, -9, 5, 34, -13, -11,
    10, 8, -20, 44, 83, -8, 1, -40,
    74, -6, -24, -12, -24, 25, 13, 2,
    -50, -28, -16, -2, 7, 17, 13, -20,
    -1, -26, 16, 1, -6, -11, 17, -15,
    -37, 17, -21, 2, -6, -14, -14, -1,
    -17, -3, -1, 13, 44, 7, -41, -46,
    -10, -8, -42, -62, -32, -27, 45, -3,
    -10, -17, -8, -15, 31, 10, -19, -9,
    -1, 11, -6, 6, -32, 15, 2, 16,
    -8, -6, -15, -3, -14, 2, 16, 4,
    45, 59, -4, 39, -26, -50, -18, -62,
    21, 22, 3, 24, 14, 3, -44, 31,
    4, 19, -10, -19, 7, -11, -103, -9,
    -13, 9, -18, 6, 52, 23, 16, -3,
    75, -31, 27, -26, 11, -17, -56, -17,
    -13, -19, 8, 21, 9, 23, -17, 14,
    -42, 19, -26, 19, -6, -16, 41, 6,
    -13, -1, -7, -7, 5, 13, 12, 5,
    14, -22, 8, -31, -1, 26, 15, 19,
    -16, -6, 15, -8, -28, 6, -3, 5,
    9, -53, -27, 44, -29, -13, 39, 69,
    6, 7, 19, 10, 21, -2, -27, -16,
    28, 44, -70, 16, 6, 7, -7, 13,
    1, -11, 1, -3, -9, -13, -22, -10,
    22, 25, 10, 2, -11, -4, 36, 20,
    5, -9, 28, -2, -15, 38, 3, -4,
    -2, -29, -47, -18, 2, 32, -25, -19,
    -2, 8, -20, 21, 29, -34, 14, 26,
    -13, -46, -13, -39, -11, -19, 49, -29,
    14, 11, 48, -15, -18, 12, -4, -44,
    -11, -20, 2, -47, -32, -12, -6, 22,
    23, 6, -9, 21, 20, 3, -30, 41,
    31, 7, 21, 6, 1, 6, -10, 33,
    50, 9, -12, -8, -19, 8, 8, -15,
    -23, -17, 5, 23, 32, 17, 23, -15,
    12, 18, 7, 16, 4, 7, -5, -7,
    -28, 17, -12, -4, 42, 0, 3, 17,
    19, 11, -8, 19, -30, 14, 4, 7,
    9, 26, 46, 0, 20, -3, 46, -4,
    -20, 0, -7, -3, -2, -53, 8, -9,
    -40, 42, -9, -4, 30, -58, -22, 26,
    5, 6, 0, 17, -13, -2, 4, -1,
    -49, -1, -15, -19, -34, 58, 29, 4,
    -2, -1, 35, 0, 36, -11, -5, -27,
    33, -26, -6, 4, 66, 58, -9, -4,
    -12, -21, -5, -12, -14, 4, -34, 13,
    -35, 13, 8, -8, -10, -4, 2, -10,
    2, -12, 2, 18, -5, 6, -3, -18,
    -28, -6, -13, -7, 48, 14, -11, -3,
    74, -16, 0, -4, -9, 14, 5, 26,
    -47, -5, 7, 58, -59, -10, 21, 30,
    -10, 4, -2, 5, 26, 12, -75, -17,
    -31, 26, 8, 19, -48, 0, -51, 47,
    -3, -4, -8, -21, 34, -6, -12, 20,
    -16, -19, 30, -12, -11, -6, -18, 1,
    -16, 37, -14, 3, -32, -9, -22, -33,
    16, -7, 11, 2, 23, -2, -11, -61,
    -6, 8, -2, -13, 30, -34, -7, -28,
    -57, 87, -7, 24, -4, -54, 36, -47,
    7, -15, 0, -47, 9, 19, 11, -30,
    42, 47, -15, -43, 34, 3, 21, 14,
    -20, 22, 12, -4, 3, -60, 16, -37,
    -43, -2, -26, 45, -16, 11, -8, -26,
    7, -2, -21, 2, -17, 34, -53, 41,
    14, -15, -36, 5, -72, -29, -27, 12,
    42, 7, -19, 4, -9, 4, 9, -14,
    9, 41, -3, 8, -56, 81, 33, 44,
    -21, 12, 7, -17, -16, -9, -18, 5,
    16, 11, 3, 14, -18, 5, 2, -47,
    -54, 0, 0, -16, 29, 12, -28, -22,
    -25, -93, 11, 44, -61, -44, 41, -49,
    -3, 37, -29, 42, -5, 11, -59, 35,
    49, -40, 24, 13, 10, 19, -50, 82,
    -20, 20, -2, -105, -64, 35, 41, -2,
    -1, -31, 29, -86, 27, 24, 68, 8,
    14, -24, 25, 6, 30, 47, -9, -79,
    39, -13, 58, -58, -16, -33, -40, 13,
    12, -39, 18, 5, 12, -44, 45, 2,
    20, 63, -1, 43, -26, -27, 3, 33,
    -18, -31, 25, 53, -33, 64, 11, -32,
    -5, -40, -22, 19, 25, 78, -9, 15,
    -43, -22, -6, -20, -11, -27, -6, -34,
    25, 23, -26, -28, -34, -6, -46, -35,
    20, 88, 4, 41, 17, -17, 26, -7,
    -32, 15, 25, -13, -20, 5, 9, -20,
    -22, 46, -69, -15, -5, -37, 40, -49,
    -3, -6, 6, -55, 4, 46, -23, -31,
    -21, 64, 16, 26, -13, -24, -6, -20,
    -8, -11, -45, -48, -17, -57, 12, 25,
    -40, -15, 2, -12, -28, -34, 25, 29,
    21, 0, 17, -16, 22, -51, 12, 34,
    29, -33, 73, -30, 0, 45, -75, -49,
    -54, 32, -19, 2, -23, -18, -19, -30,
    2, 30, -13, -24, -47, -79, -12, 2,
    -13, 1, 69, -45, -69, 63, -35, -21,
    -75, 17, -7, 29, -2, 22, -23, 42,
    39, -17, -30, 1, -38, 5, -23, 42,
    19, -17, 5, -6, 44, -30, 8, 75,
    5, 24, 14, -24, 10, 3, 41, 88,
    -6, 127, 75, 19, -30, -2, 17, 32,
    40, 4, 79, -60, 9, 29, 14, -50,
    6, -33, 19, -26, 34, 4, -23, -16,
    -87, -42, -52, -18, 80, 46, -68, -30,
    9, -34, -20, -106, 2, 31, -92, 24,
    -7, -26, -18, 14, 58, -17, 44, -67,
    -35, 37, -88, 39, -78, 39, -82, -46,
    -59, -51, -7, 27, 0, 14, -49, 63,
    20, 12, -15, 52, -17, -15, -62, -25,
    -24, -59, -99, 36, -11, -35, -27, 75,
    -30, 9, 57, 26, 2, 26, -22, 15,
    17, 67, -34, 80, 12, 27, 11, -16,
    -11, -21, 35, -16, 39, -31, -34, 54,
    33, 29, -38, 67, 33, -44, 0, -30,
    -21, 14, -11, 7, -26, 5, 27, 12,
    -6, 59, 3, 31, 43, -33, 9, 59,
    -16, -67, 41, 1, 6, 79, -19, 6,
    -6, 3, 54, -46, 30, 23, 25, -1,
    40, 8, 4, -5, 24, -50, -11, 57,
    21, -38, -35, 8, 11, 59, 37, -16,
    17, 34, -1, 13, 31, -15, -3, -56,
    -64, -2, 59, -48, 7, -51, -20, -24,
    -63, -47, -32, -1, 22, -9, 9, 10,
    -31, 1, -59, 10, 10, 5, -60, -2,
    -14, -35, 11, 80, -5, 0, 65, 46,
    34, -14, 32, -34, 10, 45, 13, 3,
    83, 4, -39, 47, -1, -4, -34, 6,
    -25, -3, -26, -28, 7, 70, -1, 14,
    16, 10, 7, -26, 15, -10, -5, -61,
    -38, -11, 40, -77, 62, -7, -3, -46,
    101, 5, -29, -20, -86, 15, 17, -12,
    -17, -25, 6, 19, -17, 43, -37, 16,
    -15, -13, 36, -4, 3, -25, 23, 10,
    44, 11, 78, -31, 2, -14, 11, 7,
    -11, -23, 12, 4, 99, 30, -67, -51,
    -14, 80, 21, 31, -18, -32, 6, -2,
    2, 14, -18, -40, 63, -44, -60, -4,
    27, -39, 12, 9, -3, 9, 59, 13,
    -6, -14, -17, -7, -43, 47, 77, 14,
    -14, -29, -43, 103, 40, 28, -15, -22,
    13, 16, 16, 67, 26, -26, -51, -12,
    23, -2, 2, -44, -18, 17, -90, -4,
    -8, 18, -19, 29, 62, -10, 47, -24,
    4, -54, -36, -30, 3, 30, -20, 14,
    -41, 7, 24, 25, 14, -39, -10, -11,
    88, 9, 48, 17, -22, -7, 54, 5,
    -24, -16, 15, -4, 30, 5, 36, -11,
    -1, -61, -3, 4, -21, -24, 39, -39,
    -32, -10, 35, -32, -21, 11, 33, 20,
    13, 15, 23, -42, -43, -14, 81, 6,
    19, 13, 34, 32, 26, -6, -69, -46,
    39, 15, 50, -36, 6, 41, -26, -30,
    12, -21, -3, 9, 45, 42, -36, 22,
    -32, 23, 4, -19, -4, -43, 29, 20,
    -2, -14, 16, 10, 2, 65, 41, 2,
    20, 60, 75, -10, -34, -11, -3, 2,
    -19, -7, -4, 51, 82, -53, 49, 4,
    -2, 8, 25, 72, 1, 18, 7, -26,
    14, 4, 45, -6, -45, -13, 10, -79,
    -28, 38, 39, 20, 22, 3, -10, -14,
    45, -2, -2, 10, -34, -32, -38, 43,
    1, 0, 0, -9, -44, 10, -5, 46,
    37, 21, -1, -28, -68, 7, 14, -41,
    -28, 10, -32, -61, 33, 20, -25, 49,
    36, 32, 6, 48, 106, 3, 16, -15,
    14, -19, 10, -35, 69, 32, -20, 5,
    52, 14, -7, 50, -55, 21, -17, 7,
    -31, 8, -4, 69, -1, -2, -24, 2,
    -32, 0, 0, 18, 42, 0, 53, 11,
    14, -59, -2, -44, 47, -83, -34, 49,
    13, 1, -8, 14, -18, 31, 66, 14,
    -62, 17, 1, -39, 26, -53, 19, 70,
    -10, -37, 30, 10, -30, -29, 40, -25,
    -66, 74, 40, -9, 59, 62, 16, 11,
    -17, -34, -11, 2, -45, 33, -65, -1,
    20, 35, 32, -6, 17, -52, -31, -21,
    -11, -6, 2, 11, -14, 23, 13, -14,
    109, 8, 6, -1, 41, 17, 7, 9,
    127, -14, 10, 10, -16, 3, -13, 6,
    38, -22, -45, -35, -37, -28, -53, -31,
    -44, 11, -13, -21, -32, 43, -125, 16,
    72, 57, 9, 4, 1, 10, -22, 21,
    0, 11, -13, -45, 77, 0, -25, 94,
    -17, 3, 8, -15, -27, -24, 21, 20,
    -22, 46, -17, 17, -8, 2, 25, -21,
    -9, 11, 36, -24, 36, 17, 2, -63,
    -17, 18, 16, -7, 54, -31, -13, -52,
    -9, -10, -37, -25, 77, 11, 6, -44,
    36, -24, 16, -74, 1, 75, 33, -3,
    -54, -52, 55, 38, 35, -7, -3, 37,
    -21, 31, 26, -24, -17, -90, 20, -68,
    -79, -41, 53, -4, 23, 20, 0, -41,
    20, 7, 19, 10, 0, 92, -17, -16,
    -22, -11, -14, 6, -33, -5, -61, 22,
    66, -10, -70, 11, -42, -16, 24, -19,
    20, 22, 25, -55, 38, -79, 40, -66,
    -17, -16, -32, -61, 33, 29, 88, 41,
    35, -79, 61, -3, -25, 41, 7, -50,
    -48, -15, -3, -7, 60, 17, -64, -8,
    -25, 1, -4, -4, -1, -23, -4, 5,
    -21, 42, -11, -27, 27, 5, 11, 4,
    -23, 1, -1, 23, 15, -12, -1, -4,
    22, 11, 12, 33, 10, 4, -3, 7,
    3, -19, 2, -12, -4, 4, 15, -23,
    -8, -22, -8, 0, -7, 10, -21, 28,
    7, 10, 17, -12, 0, -12, -8, -7,
    -18, 22, 16, 10, -5, -2, 2, 12,
    6, 60, -21, 15, -2, -21, 16, 35,
    8, 33, -10, -29, 24, -5, -7, 17,
    -14, 26, -5, 34, 1, 14, 1, -17,
    -27, 9, -12, -30, 7, 27, -2, -1,
    26, -13, 14, 6, -4, -22, 33, -23,
    19, 25, -14, 19, 0, 3, -6, -1,
    -33, -9, 11, 5, -56, -16, -15, 24,
    34, -14, 37, -48, -6, -3, -2, -10,
    -6, -5, -1, -32, -8, 8, 33, -5,
    21, 14, -39, 20, 5, 0, 5, -2,
    -2, -14, -9, 12, 21, -7, 15, -6,
    -27, 14, -18, 6, -5, -11, 9, -8,
    8, 14, -22, -4, -4, -3, -17, -27,
    29, 3, 23, -15, 3, -6, 5, 7,
    27, -9, -12, -7, -19, 2, -10, -17,
    4, -13, -21, -38, -4, 2, -4, -10,
    9, -15, -14, 35, 32, -4, 18, 10,
    -27, -11, -12, -22, -12, -27, -19, 4,
    1, -16, 8, 5, 8, 40, -14, 8,
    10, -4, -48, -21, -16, 0, -11, -1,
    -2, 10, 1, -10, 0, -4, 12, -39,
    24, 0, -17, 20, 4, -8, 16, 8,
    -4, -10, 25, -14, -2, 7, -19, 21,
    34, 12, -3, 30, -23, 13, 0, -19,
    -16, 12, 2, 23, 4, 15, 19, -21,
    -25, -1, -20, 4, -10, -14, 17, -9,
    -9, -26, 20, 34, 0, -8, -8, -18,
    -62, 9, 26, 11, 10, -1, 0, -5,
    10, 25, 20, -2, 12, 17, -8, -6,
    -33, 7, -29, -7, -8, 2, -4, 11,
    -5, -16, 17, 14, -10, 8, -13, -10,
    -8, -34, 17, 43, 16, -3, -11, 0,
    -11, 16, 43, -46, 22, 24, -15, 1,
    12, 38, 7, -15, -13, 2, -26, 17,
    3, -24, 2, -13, 8, 15, 11, -31,
    -28, -1, 33, 20, 12, -4, -5, -8,
    18, 10, -37, -41, 6, 4, -34, -15,
    25, 0, -29, -24, 8, 8, 23, 18,
    -6, 5, 31, -11, -15, 1, -26, -8,
    -2, 4, -26, 1, -9, 5, -4, -6,
    67, 0, -4, 24, -2, -1, 27, 9,
    38, 29, 38, 36, -6, 21, -12, 5,
    23, 13, -24, 25, -21, -17, 12, -28,
    9, -12, 13, -34, -3, -2, -13, -15,
    -51, -16, -18, 27, 16, -1, -29, -32,
    25, 29, -3, 38, 1, 13, -11, -17,
    16, -15, 5, -3, -17, 4, 2, 25,
    -14, 16, -50, -23, 1, 10, -7, 6,
    15, -6, -31, 20, 17, 22, 12, 14,
    -9, 20, 8, 24, -7, 26, 8, -10,
    -5, 47, 14, -18, 23, 10, -17, 24,
    -7, 27, 32, -8, 1, -2, 5, -7,
    -50, 25, -4, -11, 4, -4, -10, 2,
    -2, 28, -24, -13, 3, 18, -6, 9,
    -6, 16, 8, -23, 6, 28, 12, -14,
    22, 27, -19, 1, 7, 2, 15, 3,
    -14, 16, -7, 15, 9, 15, -55, 15,
    -13, 12, 17, -7, -9, -16, -13, -3,
    12, -26, -1, -18, 2, -15, 11, 14,
    -6, 58, 5, -11, 7, -13, 9, 0,
    -4, -24, -24, -28, 8, 5, 7, -7,
    -1, 0, -34, 12, -6, 18, 5, 6,
    3, -5, -22, -1, -9, 13, 13, -10,
    11, -51, 1, 11, 20, 7, -12, -9,
    11, 15, -37, -23, 15, 2, -13, 9,
    -30, 12, 23, -8, -5, -18, 0, 11,
    5, -18, 41, 22, -12, 6, -3, -6,
    7, -38, 3, -13, -2, -9, 3, -6,
    1, 5, -10, -29, 13, -27, 1, -24,
    -25, -7, 10, -6, 6, 34, 14, 9,
    4, 14, 18, -2, -11, -51, -7, -8,
    -1, -34, -2, -22, -7, 8, 12, 1,
    -25, 2, -29, -8, 31, -12, 24, -6,
    5, 68, 29, 11, -19, -1, 4, -6,
    2, 5, -29, -8, 1, 12, -1, 0,
    19, -43, -38, -9, -7, -2, -2, -8,
    -3, 17, -11, -5, 8, -7, 1, 23,
    0, 13, 13, 8, -8, -16, 2, 4,
    8, -4, 0, 11, -13, 21, -11, -6,
    4, 18, 3, -10, 13, 1, 0, -9,
    64, -5, -10, 58, 2, -18, 46, -10,
    13, -18, 11, -8, -1, -6, 10, -8,
    0, -6, -3, -20, 21, 24, 2, -11,
    0, 16, 58, -17, 10, 12, 4, 3,
    -5, 1, 31, 14, -14, 15, 0, 10,
    20, -7, -23, -29, 2, 6, -17, -6,
    -3, 4, 45, -7, -7, -1, -26, 15,
    -39, -36, -42, 5, -5, -2, 1, 16,
    22, -26, -28, 34, -9, -14, -7, -8,
    -29, -27, 4, 11, 19, -15, -7, 20,
    10, 14, 12, -11, -31, -6, -23, -21,
    19, 9, -2, 6, 11, -25, -3, 6,
    9, -17, 3, 23, 7, 34, -38, 4,
    -4, -56, -9, -16, -8, -8, 2, 1,
    -10, 33, 38, -17, 3, -12, -3, -8,
    -25, 37, 10, 2, -3, -6, -9, 4,
    27, 12, -33, 14, 16, -18, 0, -7,
    -9, 25, -10, 10, -16, -4, -40, 0,
    16, 1, -15, 3, -5, -6, 12, 6,
    -8, 64, -2, 11, 20, 6, -15, -1,
    -28, 0, 25, 7, 5, 23, -37, -17,
    -1, 22, 9, -20, -22, 0, -3, 12,
    -21, 5, 14, -19, 11, -36, -17, 3,
    -8, -24, -42, 7, -4, 7, -20, -20,
    -5, 25, 14, 14, -30, 28, -26, 7,
    14, -2, -19, 62, 19, -53, -7, -5,
    9, 21, -1, -22, 12, -1, -1, 10,
    44, -1, -5, -22, 2, -5, -11, -25,
    62, -40, 6, 11, -16, -1, 7, -38,
    -23, -29, 11, -47, -8, 4, -18, -4,
    -36, 22, -12, 32, -28, -27, -11, -18,
    -24, -11, -25, -9, 7, 0, -1, -1,
    37, -4, 26, -26, 24, -9, -38, 18,
    -35, 12, -21, 36, -3, 3, -4, 41,
    -18, 6, -1, 31, -16, 7, 15, 1,
    44, -4, 10, -53, -2, 16, -10, 4,
    7, 33, 25, -22, 19, 10, 18, -22,
    -28, -23, -3, -10, -15, -10, -16, 12,
    -39, 19, -4, -14, -21, -7, 24, 4,
    -15, 0, -60, -19, 2, -6, 4, -5,
    -12, 14, 15, 10, 34, 33, -1, -1,
    7, 56, 17, 44, 2, 43, 8, -15,
    26, -6, -10, 38, 18, 5, -8, -5,
    -1, -36, 36, 30, -1, 13, 4, 10,
    3, 2, 16, 48, 6, 22, -5, -32,
    4, -2, 30, -40, 6, 14, -6, -19,
    18, 8, 15, -29, 6, -18, -11, -9,
    -43, 7, -6, -27, -1, -1, -4, -4,
    -15, 2, 16, 31, 45, -11, 34, -36,
    -17, -19, 1, 52, 10, 5, 5, -23,
    48, 7, -15, -3, 12, 20, 0, -12,
    -9, 24, -24, 15, 3, 18, -1, -11,
    13, -34, -29, -31, 1, 28, -29, -10,
    -43, 34, 43, -6, 16, -22, -2, 2,
    -7, -37, 30, -4, -50, -28, 11, 1,
    -6, -20, 24, 50, 3, 7, -4, -23,
    4, 3, -24, 25, -44, 10, -13, -40,
    22, -8, -50, -25, 23, 6, -23, 24,
    -15, 6, 11, -32, -4, 8, 3, 9,
    -13, -23, -43, 1, 17, -14, 2, 0,
    -31, 21, -10, 10, 48, 7, 10, 3,
    -23, -26, 17, -52, 4, -13, -16, 4,
    31, -11, 12, 14, -27, -6, 5, -15,
    18, -29, -7, -1, -9, 6, -14, -18,
    27, 3, -34, 10, -15, 15, 18, 2,
    -3, -6, 22, 3, -26, 16, 14, 13,
    7, 35, 20, 15, 19, -9, -31, 0,
    16, -49, -18, -19, -10, -3, -9, 19,
    -18, -12, -3, -11, 11, -16, 28, -4,
    37, 34, 19, -12, -1, 25, -23, -13,
    -24, -25, 6, 39, 6, 12, -29, -3,
    -11, -54, -23, -36, -9, 10, 7, -23,
    8, 29, 3, -4, -41, 27, -40, 12,
    52, -41, -30, 27, -10, 12, 18, -12,
    -10, 62, 41, 23, -17, -15, 14, -17,
    28, -39, -27, -27, -3, -7, -5, -11,
    10, 2, -38, -9, 7, -60, 13, 7,
    -14, -8, -88, 38, 10, -32, 39, -3,
    3, 10, -41, 1, 2, 15, -19, 6,
    -51, -17, 41, 29, 38, -3, -11, 0,
    -10, -9, 36, -13, -33, -15, 28, -1,
    7, 32, -4, 34, -10, 20, -12, 8,
    -46, 8, -36, 17, -6, -5, 40, -25,
    -33, 26, 24, -18, 13, -19, 9, -15,
    -19, -16, 9, -29, -2, 36, -2, -24,
    45, 13, 55, -13, 21, 24, 11, 23,
    3, 15, -12, -4, -4, 5, -3, -6,
    12, -47, 5, -16, -3, 21, -13, -3,
    31, 6, 35, -25, -12, 33, -15, 78,
    -29, 0, 37, -8, 6, 19, -14, -9,
    -11, 30, 5, 9, -18, -32, -1, 1,
    19, 36, -35, -10, -5, 2, -6, -8,
    18, 11, -20, 5, 2, -11, 7, -34,
    9, 51, 26, -63, -18, 43, -23, 10,
    -4, -13, 25, -46, 18, 26, 4, 7,
    -12, 28, 16, 2, 6, 11, 5, 3,
    2, 2, 27, 33, 65, 9, -9, -1,
    -13, 2, 1, -29, -17, 23, 12, -8,
    -34, 4, -20, 24, 7, -11, -16, 14,
    -3, -34, 13, -1, 11, 0, -3, -24,
    -9, 2, 15, -17, -16, 6, 0, -2,
    21, 27, -19, -3, -15, 30, 3, 21,
    2, 11, -45, 24, -5, 20, -1, -34,
    -6, 15, 19, 3, 12, 6, 1, -1,
    10, 7, 1, 7, 27, 3, 7, -7,
    13, 14, 6, -18, 8, 10, -5, -1,
    1, -9, 24, -49, 10, -23, 10, -1,
    -25, 33, 34, 23, 6, -11, 9, -11,
    -5, 12, -5, 9, -4, -31, 16, -23,
    11, -37, -3, -30, -30, 22, 4, 10,
    1, -13, 9, -13, -15, -9, 2, 0,
    -61, 0, 26, 12, 2, 9, -13, 6,
    19, -9, 39, -38, -11, -34, -7, 12,
    2, 28, 85, 10, -27, -70, -23, 0,
    -65, 34, 56, -4, 19, 30, -16, -11,
    6, -5, 37, 3, 4, -7, 3, -7,
    5, 23, 26, -10, -27, -41, 15, 23,
    2, -13, -11, 24, -1, 2, -20, 12,
    30, 32, 32, -19, -5, -34, -12, 11,
    -35, 1, 15, 39, -7, -3, 13, 7,
    17, 10, -50, -14, 55, 9, 28, -20,
    8, -3, 12, 19, 26, 11, 40, 5,
    7, 8, -18, -5, -43, -9, -19, 2,
    0, -16, 5, 9, 5, -15, 9, 13,
    -13, -21, 20, 5, -4, 16, -42, 36,
    -10, 15, 16, -12, -2, -14, -10, -9,
    11, -34, -52, 5, -1, 17, -2, -18,
    52, -1, 60, -21, 0, -9, 11, -1,
    -5, -19, -20, -16, 15, 2, 29, -6,
    3, -20, 32, -9, -6, -20, -3, -5,
    5, 23, -1, -6, -17, 49, -14, 8,
    54, 3, 33, -21, -10, 8, 5, -1,
    -5, 0, 22, 20, 8, -1, 12, -22,
    36, -21, -59, 6, 5, -4, -34, 2,
    8, -1, 17, -25, -11, -1, 5, 21,
    -17, -9, -31, 0, -9, -5, 14, 5,
    -3, -3, -27, -20, -41, 15, -13, -6,
    19, 19, -28, -17, -11, 39, 13, -17,
    -8, 22, 2, -27, 4, -14, -16, -6,
    -21, -22, 13, -43, 5, -13, -2, 8,
    -22, -2, -17, -3, -28, 13, 67, -14,
    3, 26, 9, -12, -3, -28, -13, 2,
    17, -4, 13, -25, 6, -21, -8, -5,
    6, 45, 5, 23, -4, 3, 3, 1,
    24, 4, -1, 16, 33, 10, 4, -6,
    25, 1, -5, 14, -12, -1, -27, 8,
    5, 12, 12, 17, -4, -4, -11, 9,
    8, 42, 17, 9, 17, 1, -3, 0,
    -31, -38, 15, -12, -5, 10, -7, 49,
    45, 17, 5, -34, -14, -10, 14, 12,
    -38, -11, -3, -2, 25, -50, 0, -19,
    18, -38, 21, -49, 2, 6, -17, -2,
    22, 5, -34, 18, -28, 17, 21, 23,
    19, 35, 15, 39, 20, -43, -19, -2,
    -34, 26, -4, 0, 21, 4, 13, 3,
    6, 30, -20, -26, 1, -8, 1, -24,
    27, 16, -7, -29, -7, 12, -13, 24,
    -31, -55, -8, 54, -13, 24, -22, -15,
    23, 38, -2, 73, 22, -26, 4, -12,
    -3, -26, -21, -22, -7, 8, 4, 5,
    13, 0, 6, -13, 4, -5, -38, 11,
    -9, -8, -15, -4, -5, -4, -25, 21,
    -6, -9, -8, -16, 6, -9, 3, -10,
    19, -7, 26, -30, -11, 37, -9, 4,
    2, -10, -17, 12, -48, 34, 32, 7,
    4, -22, -12, 6, 16, 11, 3, 5,
    38, 10, 5, -25, -8, -19, 21, 2,
    31, 75, -46, -51, -1, 12, 4, -12,
    -95, -34, -8, -34, 11, 3, 24, 25,
    -127, 50, 10, -65, -14, -54, -26, 11,
    14, 17, 2, -43, 40, 15, -26, -19,
    17, 35, 14, -46, 12, 0, -8, 35,
    22, -7, 15, -4, 26, 1, -5, -37,
    24, 54, -6, 93, 14, 18, -28, 43,
    30, -13, -24, 55, -6, -12, 30, -72,
    19, 45, 9, 19, 17, -9, 0, -1,
    -13, 2, 38, 0, 13, -54, -15, 24,
    -20, -14, -1, -74, -11, 10, 43, 62,
    8, -32, -25, -3, 9, -1, -6, 15,
    -10, 58, 16, -50, 7, 27, 0, 24,
    14, 10, 45, 21, 23, -21, -1, 23,
    75, -15, 42, -61, -21, 39, 1, -14,
    -30, -4, -22, -34, -95, 25, 42, 31,
    -25, -61, -2, 15, 19, 33, -18, -16,
    5, 20, -12, 49, 54, -3, -69, 16,
    -20, 1, 103, 6, -30, 2, -2, -3,
    27, 24, 17, 19, 28, 30, 11, 41,
    -12, -4, -19, -10, 22, -13, -6, 48,
    -21, 34, 28, -23, 26, -30, 8, 45,
    41, -59, 127, -15, -16, 15, 21, 11,
    -72, -1, 48, 37, -22, -13, -45, -20,
    37, 20, -70, -19, -11, 25, -34, -21,
    -22, 45, 3, -4, 60, 10, 12, 17,
    29, -7, 16, 0, -15, -8, -119, -10,
    -7, 53, -3, -6, 27, 102, -20, 3,
    -40, -38, 11, -69, 22, -14, -7, 83,
    2, -19, 23, 8, -14, 19, -33, 12,
    -3, 71, -44, 126, 32, -57, 58, 8,
    -15, 84, -3, -21, 23, -9, 12, 6,
    8, 0, 2, -18, -13, 8, 7, -12,
    -18, 14, -10, 8, -11, -3, -38, -2,
    -93, 36, 65, 33, -9, -43, -17, 43,
    2, -42, -46, -19, 11, -51, 22, -17,
    14, 31, 16, 34, 2, -2, 0, -51,
    8, 73, -7, 28, -20, -14, 52, 18,
    -1, -39, 49, -19, 14, 37, -26, 42,
    32, 4, 17, 48, 23, 7, -43, 0,
    -67, 61, 5, -36, 73, 10, -12, 27,
    39, -40, -60, 27, -14, 5, 0, -12,
    -37, -7, -2, 0, 30, -24, 33, 13,
    4, 18, -9, -11, -4, 9, 30, -50,
    35, -59, -31, 37, 21, -20, 16, -13,
    -10, 11, 12, 20, -13, -36, -11, 19,
    -37, 10, -27, 50, -42, 5, 13, -12,
    19, -69, -73, -15, 0, -9, -13, -25,
    21, -24, 58, 54, -4, 12, -22, -11,
    0, -31, -35, 10, -21, 26, -10, 2,
    57, -54, -27, 31, -1, 11, 8, 13,
    -29, -43, 12, -13, -29, -26, -12, -19,
    -9, 6, 9, 1, -23, -14, 13, -2,
    29, -20, -37, -5, 19, 20, 35, 33,
    -15, 55, 23, 41, 3, -61, 8, -11,
    -31, 32, -27, 34, 4, 67, -9, -66,
    14, -58, 58, -18, 10, 49, 7, -12,
    20, 18, -35, 50, -11, 8, 4, -58,
    82, -13, 40, 41, 31, 66, 39, -6,
    5, -85, 34, 24, -1, -22, -44, 7,
    6, -48, -43, 29, 35, -9, -5, -25,
    17, 6, 26, 49, 3, 0, -2, -30,
    -34, 13, -46, 32, 31, 29, 14, 21,
    -10, 41, -20, 39, -8, 55, -45, 14,
    -68, 1, -24, 27, 20, 10, 3, -4,
    33, -4, -20, -59, -21, 0, -6, -58,
    -15, 25, -19, 13, 3, -38, -18, 14,
    10, 26, 0, -19, 18, 85, 49, -16,
    -38, -56, 34, -49, 1, -3, 3, -25,
    -7, 30, 0, 0, 12, 49, -59, 9,
    26, -8, -48, 57, 65, -47, 18, 12,
    36, -9, 11, -35, -15, -18, -4, 7,
    -11, 28, -43, 29, -33, -5, -32, -13,
    7, 25, 27, -44, -2, 70, -15, 15,
    15, 38, 16, -4, 28, -15, 2, -17,
    48, 81, -39, -6, -41, 23, -1, -22,
    -49, 90, 10, 17, 0, 3, -2, -11,
    -25, -33, -19, 18, -18, 53, -11, -27,
    27, -66, -39, 49, -5, 34, -7, -51,
    -29, 3, -2, 20, 8, -87, -19, 57,
    8, 31, 16, 64, -21, -5, -3, -10,
    -10, -31, 41, -11, -69, -60, 12, 10,
    -1, -7, -22, 28, -7, -5, -50, -1,
    14, 28, -19, 36, 50, 24, 17, -17,
    -41, -26, -32, 26, -4, -59, 13, 109,
    16, -27, -31, -18, 3, 43, 34, 16,
    45, -29, -16, -87, -2, 22, 24, 11,
    -19, 9, -17, 27, -4, -28, 53, -4,
    21, 1, -38, 4, 2, -6, 32, -14,
    10, 5, 25, -4, -23, 28, 56, -22,
    91, -18, 32, 5, 31, -13, 16, 7,
    -16, 18, 33, 28, 8, 35, -33, -29,
    -42, 53, 42, 56, -10, 12, -2, 4,
    -12, -10, 12, 20, 1, -2, -33, -42,
    -22, -10, -34, 9, -20, -21, -39, -22,
    -19, 18, -27, 14, 3, -10, -20, 16,
    20, 11, 16, 18, -25, -15, 2, -3,
    -25, 33, 5, 46, -9, 29, 38, 1,
    -82, 81, -43, -3, 124, -31, -9, 73,
    11, -38, 18, 13, -37, -3, -11, -34,
    4, -6, -62, -16, 9, -38, -13, 13,
    -7, 26, -20, -27, 46, 0, 16, -42,
    2, 23, -18, 12, -20, 8, -10, -8,
    33, 21, -28, -6, 9, -17, 0, 4,
    -39, -56, 29, -4, 24, 39, -1, 3,
    -18, 13, 9, 16, -43, 8, 13, 13,
    -44, 8, -2, 14, 21, 3, 24, -7,
    -6, -11, -58, 4, 2, 12, 111, 12,
    6, 12, -9, 21, 29, -2, 1, -9,
    -46, -13, 49, 34, -4, 36, 1, -2,
    0, 24, -91, 106, 34, -28, -20, 15,
    41, -1, 6, 8, 5, -36, 3, -1,
    -64, -37, 33, -1, -2, -6, -2, 4,
    21, -49, -18, -23, -10, 16, -18, -18,
    42, 24, 30, 25, 0, -54, 43, -11,
    -50, 10, -3, 5, 6, -10, 1, 26,
    0, 0, 21, -9, -13, -1, 12, -31,
    -15, 29, -26, -3, -25, -26, -19, 6,
    -21, -31, -77, -26, 36, 34, 7, -10,
    -4, -21, -20, -49, 35, -20, 2, 7,
    105, 24, -22, 17, -7, 34, 7, 2,
    56, -16, 2, 24, -13, 5, 27, -26,
    -62, 36, -29, -59, -37, 1, -29, 59,
    13, -1, 16, -61, 44, 2, -22, -24,
    19, -28, 0, 3, -49, 127, -48, 0,
    -26, -16, -35, 20, 12, 3, -13, -14,
    -33, 35, 28, 43, -13, -41, 5, 46,
    -8, 4, 13, 11, 34, 49, -51, -35,
    41, -18, -9, 18, 1, 43, 4, -69,
    116, -45, -15, 6, -107, 6, 12, -50,
    13, 11, -14, 17, -11, -22, 14, -14,
    -15, 0, 12, 14, -20, -8, -35, 3,
    0, -24, 35, -9, -5, 24, 9, -12,
    -9, -10, -24, 16, 8, -26, 5, -2,
    -1, -28, -19, 1, -9, -2, -2, 1,
    -2, 11, -10, -5, 1, -11, -21, -2,
    8, 12, 19, -17, -19, 13, 5, -6,
    0, 16, -44, -56, -4, -48, -29, -5,
    -14, 30, -11, -2, 18, 4, -21, 16,
    3, 14, -14, 24, -8, 23, 47, -23,
    -12, 32, 22, 27, 0, -9, 0, -2,
    35, -12, 45, 41, -3, 23, 23, 3,
    -6, 4, 1, 2, -28, -20, 25, 26,
    -43, -32, -19, 8, 46, 5, -51, 23,
    9, -1, 17, -6, -9, -10, 14, 18,
    -3, 7, 9, 26, -7, 16, 44, 11,
    17, 4, 5, 8, 1, -1, 16, 8,
    -33, -3, 17, 9, -17, -13, -27, -3,
    26, -26, -10, -16, 7, 4, 24, -5,
    3, -57, -27, -21, 9, -5, 1, -19,
    5, -19, 12, -21, -16, 7, -8, 16,
    8, -18, 25, -10, -22, -6, 19, -28,
    10, 0, 7, -2, -21, 4, -7, 26,
    6, 1, 1, 98, -6, 12, 5, 21,
    0, -7, 0, -31, -14, 16, 13, -27,
    21, 3, -32, 6, -53, -5, -3, -38,
    -9, -30, -3, 2, 25, -19, -11, -20,
    -5, 18, -3, -60, -31, 6, 9, -19,
    5, -4, 0, -4, -5, 12, -42, 11,
    16, 14, -23, -16, -1, 26, 2, -4,
    -9, -19, -12, 3, 8, -25, 5, 12,
    21, 44, -62, 30, -48, -12, 21, 11,
    7, 4, 4, 6, 23, -11, -7, 9,
    38, 5, 33, -13, 7, 27, 22, 8,
    -5, 32, 10, -3, -23, 9, 15, 6,
    -3, 7, -12, 10, 14, 2, -6, 1,
    -23, -6, -12, -3, -24, 10, -20, -2,
    12, -28, 36, 20, -3, 6, 15, 47,
    12, -5, 16, 0, 0, 1, -27, -11,
    -82, 65, -106, -1, 6, -7, 13, -16,
    15, 1, 5, -4, 31, 14, -44, -3,
    -2, -20, -20, 14, 74, -2, 17, 15,
    15, 4, -11, -7, -6, -3, -1, 15,
    35, -13, 41, 30, -3, -9, -33, -26,
    22, 12, -1, -8, 10, 13, 3, 16,
    -14, 3, 17, -16, -20, 23, 28, 8,
    -34, -7, -18, 19, 10, -3, 15, -19,
    23, 10, 49, 21, -4, -3, -13, 29,
    2, -21, -8, -3, -15, -17, 3, -3,
    -8, 2, -2, -35, -8, 15, -67, 21,
    23, -3, -13, 23, -14, 14, -16, -25,
    -31, 21, -30, 15, -13, 3, 16, -14,
    -5, 0, 9, -1, -32, 1, 33, -47,
    -2, -35, -1, 41, -34, 3, -21, 2,
    -3, -18, 6, 1, 3, 5, 6, -22,
    20, -7, 20, -16, -7, 1, 9, 25,
    4, 4, 1, -9, -2, -9, 13, 1,
    0, 39, -9, 4, -4, 85, 13, 12,
    -8, 10, -23, -10, 4, -9, -22, -4,
    2, 9, 86, -49, -19, -9, -17, 4,
    -11, -5, 6, 2, -11, 3, 2, 25,
    20, -11, 8, 14, 12, 7, 27, 26,
    -13, -2, -16, 22, 27, 24, 0, -24,
    -76, 16, 12, -14, -4, 4, 19, -17,
    -25, 1, 6, 0, 25, -4, -49, 20,
    -5, -27, -3, -21, -60, -22, -21, 17,
    22, -8, -35, -2, 10, 8, 23, 4,
    33, -62, 3, -56, 9, -9, -6, -27,
    3, 2, -23, 4, -3, 29, 10, -2,
    30, 34, -6, 9, 18, -6, -40, 55,
    14, -9, -10, 0, 9, -6, 18, -21,
    -12, 23, -28, 24, -27, 11, 28, 3,
    0, 3, 11, 7, -2, -8, 6, -21,
    10, 2, 1, -7, 7, 46, 16, -16,
    20, 4, -4, -6, -7, 24, -10, -12,
    37, 1, -9, 3, -8, -15, -22, -12,
    -28, 3, -20, 6, -1, -8, -18, -6,
    -32, 18, 16, 11, 5, 8, 21, 20,
    24, -11, -20, -21, -51, 14, -17, 16,
    -24, -16, -2, -28, -19, 3, 31, -9,
    5, -2, 3, 11, -5, 13, -21, 5,
    -3, 9, 5, -8, 1, 5, 7, -16,
    -1, -26, -29, 19, -9, -12, 0, -2,
    -77, -23, 55, 27, 17, 9, 21, -7,
    6, 6, -5, -16, -2, -10, 14, 15,
    13, 9, -20, 12, 39, 32, 55, -4,
    18, 7, -10, 4, -6, -3, -6, -13,
    17, -14, 37, -26, -16, -7, -2, 10,
    1, 5, -13, 9, 8, 3, 35, -15,
    3, 25, -5, -19, -53, 13, -85, 38,
    -17, 15, 23, 15, 5, 22, -2, 24,
    -19, -21, -28, -1, -30, 6, -6, -17,
    10, 10, 6, 12, 15, 7, 22, 19,
    -20, -29, 1, -15, 12, -5, 19, -7,
    -5, -24, 3, 5, -25, 16, -2, -28,
    19, -37, 27, 37, -18, 5, -12, 17,
    -10, -13, -8, 14, 12, -24, -1, 2,
    4, -30, -9, 32, 14, -18, -9, 10,
    -22, -30, -4, 28, -5, -4, 9, -7,
    14, -31, 25, -39, -11, 22, -31, 8,
    -3, -4, 1, 3, 32, -51, -20, 22,
    -17, 11, 13, -49, -19, 21, 22, 3,
    -2, 9, 5, -2, -5, 18, 20, -12,
    -14, 19, -33, 22, -5, 43, 11, -16,
    15, -1, 0, 3, -24, 31, 7, -19,
    -8, 43, 13, 4, -13, 37, 17, 25,
    -3, 35, -1, 3, 12, 4, 5, -5,
    -49, 39, 34, 22, -22, -10, -8, 5,
    -17, -7, 9, -10, 14, 7, 1, -10,
    38, -1, 0, -23, 41, -22, -26, 6,
    3, 5, 11, -7, 17, 13, 19, -16,
    -16, 5,