
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rnnoise_data.h"


#ifndef USE_WEIGHTS_FILE

#define WEIGHTS_conv1_weights_float_DEFINED
#define WEIGHTS_conv1_weights_float_TYPE WEIGHT_TYPE_float
static const float conv1_weights_float[24960] = {
    0.028761977329850197, 0.014552176930010319, -0.005120974965393543, -0.05179661884903908, 0.020572597160935402, -0.007333331275731325, 0.0029668838251382113, -0.008713308721780777,
    0.05263008549809456, -0.02361108735203743, 0.02478584460914135, -0.0030046531464904547, -0.00272221933118999, 0.025731336325407028, 0.01637587696313858, 0.0027548903599381447,
    0.033130500465631485, 0.04352216795086861, 0.0027586149517446756, 0.03498448058962822, 0.0046928441151976585, -0.03959045559167862, -0.011979510076344013, -0.060653865337371826,
    0.04618219658732414, 0.01312539167702198, 0.044822391122579575, -0.0008229143568314612, 0.027556009590625763, 0.027876874431967735, 0.019249610602855682, -0.031948503106832504,
    0.028025930747389793, -0.022651417180895805, -0.023508956655859947, 0.015844140201807022, -0.05196968466043472, -0.07316631078720093, -0.007659398950636387, -0.0068879625760018826,
    0.007969102822244167, -0.021335771307349205, 0.015921801328659058, -0.007690181024372578, -0.06053060293197632, -0.02737036533653736, 0.00043878168798983097, -0.03271806240081787,
    0.011245104484260082, -0.007204823661595583, 0.018094532191753387, -0.06627125293016434, -0.03967985883355141, -0.00963631272315979, 0.01783299632370472, -0.020420877262949944,
    -0.01173012237995863, -0.011971903964877129, -0.01788458786904812, 0.034381236881017685, 0.08842619508504868, -0.002492469735443592, 0.007930024527013302, -0.041291460394859314,
    -0.01900816150009632, -0.019986024126410484, -0.05198052152991295, 0.007460824679583311, 0.018902640789747238, 0.057387035340070724, -0.08724181354045868, 0.04262072220444679,
    0.032229918986558914, 0.009374762885272503, 0.009227671660482883, 0.0012645720271393657, -0.07024884223937988, 0.01672131009399891, 0.0842929556965828, -0.01955295167863369,
    0.02647452987730503, -0.0541594997048378, 0.0038994434289634228, -0.042847976088523865, -0.02628767490386963, 0.031068772077560425, -0.01517285592854023, -0.015427704900503159,
    0.008833813481032848, -0.000909686554223299, 0.031264323741197586, 0.032025329768657684, 0.008846585638821125, 0.025657976046204567, -0.022552354261279106, 0.00789128988981247,
    0.009573794901371002, -0.012179841287434101, -0.010510796681046486, 0.015700984746217728, -0.024623718112707138, -0.09684678167104721, -0.04276975616812706, -0.005322474520653486,
    0.002328900620341301, -0.0010381377069279552, -0.00019461564079392701, -0.016561225056648254, -0.06664225459098816, 0.03637777641415596, 0.03603559732437134, 0.000670255976729095,
    -0.02864106185734272, -0.0774172991514206, 0.0340266227722168, 0.006920894142240286, -0.07020790874958038, -0.008016533218324184, -0.06141114979982376, 0.020114818587899208,
    -0.005788869224488735, -0.04844905436038971, 0.003509384347125888, 0.040159329771995544, -0.034990448504686356, 0.055863697081804276, 0.00045134476386010647, -0.024024922400712967,
    -0.053586196154356, -0.003686655545607209, 0.014195267111063004, 0.02272840403020382, 0.04937100410461426, -0.02324511669576168, -0.002359595615416765, 0.05007340759038925,
    -0.06196843832731247, 0.01774921454489231, 0.008521093986928463, -0.020772216841578484, 0.00282650045119226, -0.09006846696138382, 0.027228504419326782, -0.013654337264597416,
    0.04208993911743164, 0.059950653463602066, 0.0072158765979111195, 0.005007511470466852, 0.02171042189002037, 0.03654396906495094, 0.01950744166970253, -0.016227252781391144,
    -0.06682996451854706, 0.0060697137378156185, -0.04389263316988945, -0.027388393878936768, 0.028881052508950233, 0.063841812312603, -0.02821313589811325, -0.05242110416293144,
    0.029224663972854614, -0.014555823057889938, -0.052111901342868805, -0.034569788724184036, -0.0032840478233993053, -0.1229417622089386, -0.01634882763028145, -0.006454369984567165,
    -0.06136033311486244, 0.030776679515838623, -0.0003867529158014804, 0.02104874886572361, -0.0026768583338707685, -0.10006385296583176, 0.004628918133676052, 0.004254279192537069,
    0.01195280160754919, 0.04985276609659195, -0.0021412570495158434, -0.08758396655321121, -0.0021195716690272093, -0.005610259715467691, 0.017192315310239792, -0.06037050485610962,
    -0.052170347422361374, -0.018290817737579346, -0.0210571251809597, 0.019400229677557945, -0.012627116404473782, 0.02452600747346878, -0.0032612893264740705, 0.009680663235485554,
    -0.02326580323278904, 0.0013932631118223071, -0.018650690093636513, -0.012423739768564701, 0.015806348994374275, 0.07402116060256958, -0.10364316403865814, -0.061866093426942825,
    0.0013019691687077284, 0.03211653232574463, -0.019900847226381302, 0.016935452818870544, 0.10002265870571136, 0.0006242863601073623, -0.004544428084045649, -0.0680864155292511,
    -0.0018736233469098806, 0.031685806810855865, 0.03993142396211624, -0.02211117185652256, -0.001327818725258112, -0.03837001323699951, -0.008910870179533958, -0.014282743446528912,
    0.01349913515150547, 0.0030584512278437614, 0.025861889123916626, -0.014170055277645588, 0.014097367413341999, 0.03627922758460045, 0.03778107836842537, 0.01560965646058321,
    -0.05128810554742813, 0.011205323040485382, 0.011943448334932327, -0.021664554253220558, -0.011624534614384174, -0.05553638935089111, -0.013126764446496964, -0.01000425685197115,
    0.006266165524721146, -0.01171234529465437, 0.0020542852580547333, -0.020819760859012604, -0.03284391388297081, -0.002907627262175083, 0.004505790304392576, -0.005641542375087738,
    -0.023232119157910347, -0.028114352375268936, 0.009921222925186157, -0.006576311308890581, 0.021198071539402008, 0.013611292466521263, 0.0310449730604887, -0.03697530925273895,
    0.007778417784720659, 0.03193889558315277, 0.0029887452255934477, -0.006499296985566616, -0.007264294661581516, 0.041936080902814865, 0.03144235908985138, 0.0007941962103359401,
    0.07562375068664551, -0.003666479140520096, 0.011305456981062889, 0.033196523785591125, 0.05465741083025932, -0.011627448722720146, -0.003652628045529127, -0.041811130940914154,
    0.08152389526367188, 0.01543660182505846, 0.017005939036607742, -0.013345127925276756, -0.008417315781116486, 0.04094516858458519, -0.040185801684856415, -0.02083323523402214,
    2.5409608497284353e-05, -0.04670252278447151, 0.03427309915423393, -0.007457661908119917, 0.020254937931895256, -0.05952765792608261, -0.042913831770420074, -0.019961820915341377,
    0.027305303141474724, 0.01523765828460455, 0.041858043521642685, 0.01303965225815773, 0.011895696632564068, -0.07583028078079224, -2.6009094654000364e-05, 0.00013415247667580843,
    -0.04049777612090111, -0.02034122310578823, -0.017365388572216034, 0.042898405343294144, 0.0020487967412918806, -0.06663483381271362, 0.016285279765725136, 0.035851866006851196,
    0.031154578551650047, 0.021260429173707962, -0.016950374469161034, -0.04540620744228363, -0.01206457894295454, -0.054282933473587036, -0.030599555000662804, -0.07028026133775711,
    -0.004893098492175341, -0.04990242049098015, -0.015481886453926563, -0.012139106169342995, 0.010437673889100552, 0.0012979053426533937, 0.021589921787381172, -0.024031462147831917,
    -0.019865460693836212, 0.04823965206742287, 0.007384141907095909, 0.008529379963874817, 0.015164836309850216, -0.009519707411527634, -0.018110079690814018, 0.025269851088523865,
    -0.0024578350130468607, 0.01710856892168522, -0.04838932678103447, -0.027301153168082237, -0.013163436204195023, 0.030087674036622047, -0.005350237246602774, 0.1000196784734726,
    0.0048821005038917065, -0.0103151248767972, 0.045969970524311066, -0.015559861436486244, 0.09881899505853653, 0.026077158749103546, -0.03971399739384651, -0.09749390929937363,
    0.021873310208320618, 0.05757205933332443, 0.020980417728424072, 0.01196406502276659, 0.001378196058794856, 0.023962324485182762, -0.01758003421127796, 0.029665526002645493,
    -0.023974571377038956, 0.007079754024744034, 0.05243716388940811, 0.04668476805090904, 0.07111978530883789, 0.041351597756147385, 0.06380518525838852, 0.04758336767554283,
    -0.052738673985004425, -0.0009032295783981681, 0.010343124158680439, 0.028762103989720345, 0.008581086993217468, 0.07708700746297836, 0.07505671679973602, -0.019422240555286407,
    -0.011036328040063381, -0.018342383205890656, 0.031825922429561615, -0.005084065720438957, 0.038365840911865234, 0.03289308771491051, 0.027997927740216255, 0.005182930734008551,
    -0.035638004541397095, 0.023545965552330017, 0.004567558411508799, -0.029107291251420975, 0.11314889043569565, -0.03318929299712181, 0.005200389306992292, 0.0017349179834127426,
    -0.0048741549253463745, 0.003444504924118519, 0.050350870937108994, 0.01914859376847744, -0.010869132354855537, 0.02142651192843914, 0.043330442160367966, -0.01857980340719223,
    0.0078713558614254, -0.031409624963998795, 0.03326210007071495, 0.05896543338894844, -0.004376472905278206, 0.03401004150509834, -0.02636926993727684, 0.036737747490406036,
    -0.034079618752002716, 0.04255150258541107, -0.014482738450169563, -0.014325222000479698, 0.033144447952508926, -0.006329003721475601, -0.006427037995308638, -0.0026357241440564394,
    0.010228477418422699, -0.059970706701278687, -0.009685509838163853, -0.0017987340688705444, -0.0024542775936424732, 0.06683678179979324, 0.015498152934014797, 0.0005934096407145262,
    0.014454283751547337, 0.014686044305562973, 0.0672764778137207, -0.03938523307442665, 0.019474927335977554, 0.06345803290605545, -0.004086866043508053, -0.00029221156728453934,
    -0.06457561999559402, -0.015057874843478203, 0.05984921008348465, -0.041797295212745667, 0.0133659141138196, -0.0003187802794855088, -0.002069279085844755, 0.03250611200928688,
    -0.03742444887757301, 0.028285996988415718, -6.686801498290151e-05, -0.02144901640713215, 0.08119747787714005, -0.02891300432384014, 0.02143082395195961, -0.0007642134441994131,
    -0.0016451585106551647, 0.07023884356021881, -0.030499419197440147, 0.034194111824035645, -0.06242247670888901, 0.0304384957998991, -0.00978831760585308, -0.04078145697712898,
    -0.05753602832555771, -0.048070553690195084, 0.02027982659637928, 0.007310553919523954, 0.008506816811859608, -0.040126871317625046, 0.005100809503346682, 0.0077173179015517235,
    -0.020932501181960106, 0.004830958321690559, -0.05954292416572571, -0.03856794536113739, 0.005898099392652512, -0.005638003349304199, 0.0662064179778099, -0.05956427380442619,
    -0.01113919261842966, 0.04320116341114044, -0.03535277023911476, 0.005506537854671478, -0.11350122839212418, 0.009084638208150864, 0.040985703468322754, -0.04298485070466995,
    0.00803927332162857, -0.03595943748950958, -0.044459883123636246, 0.041108209639787674, -0.016838032752275467, 0.010471805930137634, -0.01056387834250927, -0.009818647988140583,
    0.00051303202053532, -0.02852918580174446, -0.029487213119864464, -0.01592649333178997, -0.026772137731313705, 0.057264357805252075, -0.014592290855944157, -0.03326435014605522,
    0.02776186726987362, -0.003573576221242547, -0.004530003294348717, -0.0370444655418396, -0.04108034446835518, 0.040490515530109406, 0.03588106483221054, -0.029703477397561073,
    0.00671366648748517, 0.013795807957649231, 0.005414212122559547, 0.011238934472203255, -0.06011825054883957, -0.052888114005327225, 0.03865005075931549, 0.02738853171467781,
    0.027290327474474907, -0.029989605769515038, -0.012092767283320427, 0.013856018893420696, -0.07882540673017502, 0.021345119923353195, 0.011695954948663712, -0.0032719685696065426,
    0.03676113113760948, 0.0697769895195961, -0.06038651242852211, 0.01940232142806053, -0.00340724503621459, 0.005360690411180258, 0.002507655881345272, -0.019201744347810745,
    0.06071258336305618, -0.04620663821697235, 0.014318394474685192, 0.03326820209622383, -0.04938920959830284, -0.0075268433429300785, 0.08165889233350754, 0.011286365799605846,
    0.01883428916335106, 0.027186306193470955, 0.06042440980672836, 0.007347669918090105, -0.047159694135189056, -0.07411488145589828, -0.06160685420036316, -0.015040003694593906,
    -0.004088624846190214, -0.04317403584718704, 0.03185654431581497, 0.007724021095782518, -0.023364096879959106, -0.06716904789209366, 0.03221510723233223, 0.056825730949640274,
    -0.02573096938431263, -0.005999300628900528, 0.013394934125244617, 0.0012093402910977602, -0.0026721556205302477, 0.014423881657421589, -0.0168942678719759, -0.08095493912696838,
    0.02962019294500351, 0.005776088684797287, 0.0317399688065052, 0.01935865357518196, -0.05308526009321213, -0.022150132805109024, 0.02812710776925087, 0.04067841172218323,
    -0.06650914251804352, -0.026507418602705002, 0.006508988793939352, 0.018717629835009575, -0.006113128736615181, 0.0448407344520092, 0.030025603249669075, 0.02920440398156643,
    0.008176027797162533, -0.05033755302429199, 0.006442198529839516, -0.0021581612527370453, 0.05739661678671837, -0.0013644357677549124, 0.03062908723950386, 0.016623158007860184,
    -0.031849995255470276, 0.03969740867614746, -0.02884555235505104, 0.006333290599286556, -0.022840170189738274, 0.00781974010169506, 0.03305121883749962, -0.03315902501344681,
    0.02450907975435257, 0.0036071178037673235, -0.06972909718751907, 0.007138295564800501, 0.008349338546395302, -0.05548347905278206, -0.031643953174352646, 0.06530988216400146,
    -0.007026075851172209, -0.03321336954832077, 0.021883228793740273, 0.005707230418920517, 0.08966551721096039, -0.03922181576490402, 0.028620854020118713, 0.0012385540176182985,
    -0.004554763901978731, -0.027893995866179466, -0.02830178290605545, -0.04738781228661537, -0.00285854609683156, -0.012856041081249714, 0.039920222014188766, -0.02962718904018402,
    -0.0008092658245004714, 0.04905618354678154, 0.03290571644902229, 0.017121922224760056, -0.04082111269235611, -0.020139221101999283, -0.07615304738283157, 0.041030868887901306,
    0.0024602659977972507, -0.030408116057515144, -0.009816080331802368, 0.03695087507367134, 0.0024920229334384203, -0.03315579518675804, -0.06794647872447968, -0.03839806839823723,
    0.02746495231986046, -0.009072915650904179, 0.0008338129846379161, 0.03977978229522705, 0.030314629897475243, 0.010178064927458763, 0.03039741702377796, -0.025648266077041626,
    -0.0037864064797759056, -0.005549260880798101, -0.03396424278616905, -0.016072304919362068, 0.04785776883363724, 0.010839873924851418, -0.023888297379016876, -0.03992912173271179,
    -0.05085814371705055, 0.02118692174553871, 0.04219219088554382, -0.01323696132749319, -0.02817903831601143, -0.006202164106070995, -0.06899374723434448, -0.00988589134067297,
    -0.009672285057604313, 0.057933706790208817, -0.025432802736759186, 0.05964750796556473, 0.04644961655139923, -0.008957849815487862, -0.023643122985959053, 0.0309471283107996,
    -0.06595800817012787, -0.032568495720624924, -0.047083087265491486, -0.011666402220726013, 0.04632498323917389, 0.040315043181180954, 0.0015462529845535755, 0.029013987630605698,
    -0.003085506847128272, 0.033122919499874115, 0.02111043781042099, 0.0015679337084293365, 0.07285649329423904, 0.05197061598300934, -0.0922079011797905, 0.04811270534992218,
    0.036776840686798096, -0.0031448337249457836, -0.042354099452495575, -0.0431213341653347, -0.0076853507198393345, 0.0023162509314715862, 0.03242794796824455, 0.014318783767521381,
    0.04306532070040703, 0.03307165950536728, 0.0027229615952819586, -0.02548619732260704, -0.019305726513266563, 0.004929960705339909, 0.0411553829908371, -0.01329157967120409,
    -0.0526079498231411, 0.022210363298654556, 0.011567910201847553, -0.04828454926609993, 0.03317628055810928, -0.10974389314651489, -0.015676796436309814, -0.020824842154979706,
    -0.022367414087057114, 0.04120117425918579, -0.004743869882076979, -0.011219028383493423, -0.041675738990306854, 0.052595414221286774, 0.03750082477927208, -0.02811603806912899,
    -0.03874536603689194, -0.030729833990335464, 0.012239308096468449, -0.015140478499233723, -0.03622853010892868, 0.017299924045801163, 0.021539336070418358, -0.04919463396072388,
    -0.09275306761264801, 0.04000260308384895, -0.04475389048457146, -0.020262958481907845, 0.019999096170067787, 0.017461521551012993, 0.04510759934782982, -0.03574911504983902,
    0.0037564635276794434, 0.021482327952980995, -0.030226966366171837, 0.010626747272908688, -0.055816322565078735, 0.03914734348654747, 0.007084446493536234, 0.008765279315412045,
    -0.015750188380479813, -0.0005168148200027645, 0.03758593648672104, -0.004217672161757946, -0.000705129059497267, 0.035311002284288406, -0.10029248893260956, -0.025314465165138245,
    0.008350216783583164, -0.018421422690153122, 0.11205054074525833, 0.006962763611227274, 0.07554200291633606, -0.006545390002429485, 0.0608045756816864, 0.011658317409455776,
    0.03520769625902176, 0.030010756105184555, 0.022416409105062485, -0.03684578835964203, -0.025867333635687828, 0.0590994618833065, -0.04331430792808533, -0.007721248548477888,
    -0.02633000537753105, 0.03647391125559807, 0.02260839194059372, 0.024776523932814598, -0.03985412418842316, 0.034357473254203796, -0.060546018183231354, -0.005132566671818495,
    -0.05721753090620041, -0.015996066853404045, 0.023701537400484085, -0.021919606253504753, 0.03658261150121689, 0.06554828584194183, 0.044821348041296005, 0.03793899342417717,
    0.0003874941903632134, -0.009822571650147438, -0.0455358661711216, 0.006672170478850603, 0.0033681534696370363, -0.08615994453430176, 0.05781308561563492, -0.007956881076097488,
    0.008784621022641659, -0.018022174015641212, 0.00220240349881351, -0.07009025663137436, 0.03984985500574112, -0.0013823654735460877, 0.01889651082456112, 0.005812859628349543,
    0.046899858862161636, -0.03488743677735329, 0.03169363737106323, -0.015528339892625809, -0.01511906087398529, -0.022749032825231552, 0.004300236236304045, -0.020519396290183067,
    -0.0386645682156086, -0.04362703859806061, 0.005317483097314835, -0.007211634423583746, -0.04870780557394028, -0.06088295951485634, 0.03970379754900932, -0.0889207199215889,
    0.012750251218676567, -0.04216943308711052, 0.06296046078205109, -0.0017734069842845201, -0.0676843449473381, 0.04876289144158363, -0.044957175850868225, -0.050835270434617996,
    -0.08131559193134308, -0.020784255117177963, -0.009376117959618568, 0.01660001091659069, 0.04478917270898819, -0.047155123203992844, -0.0026129046455025673, 0.011160330846905708,
    -0.04993988573551178, 0.0008818594506010413, -0.018375655636191368, 0.02579345554113388, -0.0607401467859745, 0.09246755391359329, 0.01596684195101261, -0.0610545352101326,
    0.006860231980681419, -0.008700653910636902, -0.006276698317378759, 0.02429812029004097, -0.004448354244232178, -0.022418638691306114, -0.021206248551607132, -0.00573463412001729,
    -0.06942936778068542, 0.006710798013955355, 0.01372576504945755, -0.01009361818432808, 0.02003275789320469, -0.029881557449698448, -0.042719174176454544, 0.07116830348968506,
    0.07262247800827026, 0.023181824013590813, -0.011852605268359184, 0.052050381898880005, 0.0014875080669298768, 0.05037061125040054, 0.11132630705833435, 0.016634026542305946,
    0.0324852354824543, -0.039793960750103, 0.01419718749821186, 0.04587852954864502, 0.012496390379965305, 0.03708831965923309, -0.019787101075053215, -0.07556676119565964,
    -0.04533035308122635, 0.04670441150665283, -0.007594367954879999, 0.03907795250415802, -0.002314680488780141, -0.029842033982276917, 0.058365598320961, -0.0197785422205925,
    0.05415956676006317, -0.025670234113931656, -0.011669217608869076, -0.01072712056338787, -0.0022651206236332655, 0.06246408075094223, -0.01533273421227932, 0.03220127150416374,
    -0.002323910826817155, -0.019239963963627815, 0.01376535464078188, 0.02735770493745804, 0.009071513079106808, -0.021642718464136124, 0.030501367524266243, -0.038466185331344604,
    -0.015301788225769997, 0.0020004233811050653, 0.026507044211030006, 0.03361796960234642, -0.011414628475904465, 0.04572664201259613, 0.03287259116768837, 0.015819812193512917,
    0.04658440873026848, -0.006408436689525843, 0.022424748167395592, 0.011487262323498726, 0.004748639650642872, -0.06299259513616562, -0.12343267351388931, -0.04461638256907463,
    0.011485302820801735, -0.026436109095811844, 0.00720957899466157, 0.007822359912097454, 0.010997283272445202, 0.05828501656651497, 0.01617884449660778, 0.025249464437365532,
    -0.04602918401360512, 0.0018248938722535968, 0.01039397343993187, 0.017425060272216797, -0.036438144743442535, 0.013468832708895206, 0.02587716653943062, 0.00747499568387866,
    -0.001182128326036036, 0.012046667747199535, -0.02039726823568344, -0.01775103248655796, 0.0014043570263311267, -0.013514469377696514, 0.09492281079292297, 0.010231529362499714,
    -0.00469591561704874, 0.05107371509075165, 0.01907460205256939, -0.06571147590875626, 0.03882468119263649, 0.0683865174651146, -0.02656676433980465, 0.010490347631275654,
    -0.044411372393369675, 0.007057244889438152, 0.014927772805094719, -0.021320059895515442, -0.0064846002496778965, -0.03994535282254219, 0.01185370609164238, 0.05145610496401787,
    -0.017889879643917084, 0.006339773070067167, 0.007276809308677912, -0.008535794913768768, -0.034512899816036224, 0.012872661463916302, -0.00715084420517087, -0.01078425906598568,
    -0.011800640262663364, 0.019285717979073524, -0.034604642540216446, -0.04621172696352005, 0.04138984903693199, -0.03992366045713425, -0.0399349182844162, -0.039082836359739304,
    0.01590638980269432, 0.0064524095505476, -0.016430232673883438, -0.021841304376721382, 0.04754021763801575, 0.09175240248441696, 0.05600794032216072, 0.033170077949762344,
    -0.01557499822229147, 0.04741116240620613, -0.06879302859306335, 0.01965130865573883, -0.0033410144969820976, 0.00808898825198412, 0.009587249718606472, -0.0157283004373312,
    -0.04465501382946968, -0.009741189889609814, -0.07368167489767075, 0.030940769240260124, 0.0022093839943408966, 0.004028577823191881, 0.010303165763616562, -0.017577480524778366,
    -0.008496788330376148, 0.007827816531062126, -0.010856999084353447, -0.10734977573156357, 0.0911773219704628, -0.020047128200531006, 0.01250273548066616, 0.0026938507799059153,
    0.006571335252374411, -0.04595877230167389, 0.01107921451330185, 0.052841588854789734, 0.014173210598528385, 0.06946127116680145, -0.02328973449766636, -0.048063576221466064,
    0.0006201021606102586, 0.08034060895442963, -0.09360983222723007, 0.014648985117673874, -0.003993477672338486, -0.014375543221831322, -0.036948978900909424, -0.02793644182384014,
    0.047611065208911896, -0.014615919440984726, 0.02662402205169201, 0.011319538578391075, -0.006372007075697184, -0.027947964146733284, 0.002333139069378376, -0.019141806289553642,
    0.011388619430363178, 0.0014155283570289612, 0.005955112632364035, 0.006912687327712774, -0.002923903986811638, 0.0308360755443573, -0.07730252295732498, -0.026989946141839027,
    -0.05045115202665329, 0.0037372992374002934, -0.01306357141584158, -0.027411645278334618, 0.03293800354003906, -0.012668277136981487, 0.06651423871517181, -0.03542058542370796,
    0.004253443330526352, 0.031525786966085434, -0.1030050590634346, 0.012538913637399673, -0.013955899514257908, -0.05729084461927414, 0.03731031343340874, -0.007413158193230629,
    0.010258420370519161, 0.01404649205505848, -0.02789626084268093, 0.018341366201639175, 0.02988341636955738, -0.01726834662258625, 0.017175082117319107, -0.022268671542406082,
    0.04675110802054405, -0.03459693118929863, -0.020275624468922615, 0.023935159668326378, -0.0013106070691719651, -0.005713996943086386, -0.05919264256954193, 0.015810159966349602,
    -0.062014225870370865, -0.07703247666358948, -0.02089158073067665, -0.0018394944490864873, -0.033598821610212326, -0.09100610017776489, -0.004459215793758631, 0.018759597092866898,
    0.04248335212469101, 0.03932890668511391, -0.006498688831925392, 0.052767105400562286, 0.04057019203901291, 0.006689629051834345, 0.0372052863240242, -0.06762021034955978,
    0.10554874688386917, 0.0015531935496255755, 0.03632256016135216, 0.003489541122689843, 0.04144371300935745, 0.041247930377721786, 0.01498808991163969, 0.03259486332535744,
    0.06022731587290764, -0.03747193142771721, 0.0019784243777394295, 0.03284532576799393, -0.060109399259090424, -0.013638049364089966, 0.07185046374797821, 0.028781605884432793,
    0.0038460236974060535, -0.01730916276574135, -0.008320417255163193, 0.002407700987532735, -0.05316969379782677, -0.03744235634803772, -0.03111768513917923, 0.04080604389309883,
    -0.018185243010520935, -0.073013536632061, 0.01886601559817791, -0.010911831632256508, -0.06250309199094772, -0.01683327741920948, -0.007685571908950806, 0.025270193815231323,
    -0.036042969673871994, -0.02764192223548889, 0.0012810833286494017, -0.01723305694758892, -0.005428663454949856, -0.0024459080304950476, 0.028561528772115707, 0.023801788687705994,
    0.01722720079123974, -0.00205363635905087, 0.02934127114713192, 0.004154239781200886, -0.1056210920214653, 0.07123734056949615, -0.046458132565021515, 0.06362996250391006,
    0.06527986377477646, 0.08196618407964706, -0.01613798551261425, -0.0434090755879879, -0.04050540179014206, -0.06567312777042389, 0.04368399828672409, -0.006297389976680279,
    0.03639534115791321, -0.021250518038868904, -0.0161399208009243, -0.0353546179831028, -0.009094699285924435, 0.0261178407818079, 0.03926417604088783, 0.102970190346241,
    -0.0008564994786866009, 0.00762621546164155, -0.021182801574468613, -0.04051634669303894, -0.06492817401885986, -0.017065297812223434, -0.006264265161007643, -0.044786237180233,
    -3.79251541744452e-05, -0.0026734790299087763, 0.0003290708118584007, -0.010755263268947601, -0.04752219468355179, 0.008671206422150135, 0.03763531893491745, 0.048797257244586945,
    -0.031593844294548035, 0.05026539787650108, -0.009658975526690483, 0.013704167678952217, -0.004773595370352268, -0.032979898154735565, -0.08349725604057312, -0.006766795180737972,
    -0.06148387864232063, 0.03880756348371506, 0.00403599813580513, -0.05485129728913307, 0.012574028223752975, -0.0016670837067067623, -0.0195893794298172, -0.04214939475059509,
    0.013753819279372692, -0.00960011687129736, 0.01027799490839243, 0.039055902510881424, 0.08030612766742706, 0.052043113857507706, 0.011883391067385674, 0.08196378499269485,
    -0.016670620068907738, -0.05608998239040375, -0.040748871862888336, -0.04694245383143425, -0.020383615046739578, -0.06455399096012115, 0.06589985638856888, -0.01298985444009304,
    0.029220718890428543, 0.03585970401763916, 0.010338708758354187, 0.03346563130617142, -0.00016689207404851913, 0.08505940437316895, 0.012914820574223995, 0.027030788362026215,
    -0.009809749200940132, -0.012731274589896202, -0.0016806446947157383, -0.029824305325746536, 0.019979365170001984, -0.07006306201219559, 0.06132563203573227, -0.0176494512706995,
    -0.03380151093006134, 0.052527643740177155, -0.030594728887081146, -0.02634477987885475, 0.010978051461279392, -0.06584792584180832, 0.010125742293894291, 0.028825970366597176,
    -0.012380905449390411, -0.013283688575029373, -0.05630175396800041, -0.038883864879608154, -0.021248996257781982, 0.046400174498558044, -0.04023430123925209, 0.002641326515004039,
    -0.009790131822228432, 0.03142993524670601, -0.03790237754583359, -0.011915222741663456, -0.006828446872532368, -0.0014029375743120909, -0.023198265582323074, 0.007720904890447855,
    0.011248873546719551, 0.04986710473895073, 0.019818279892206192, -0.0011762722861021757, -0.043247900903224945, 0.007699243724346161, -0.014267949387431145, -0.009929376654326916,
    0.05166475847363472, -0.015263817273080349, -0.022898560389876366, 0.050724972039461136, 0.007203332614153624, 0.03268951550126076, 0.01483137160539627, -0.043804287910461426,
    -0.0622924380004406, -0.05568043515086174, 0.015517931431531906, -0.0051406752318143845, 0.032668448984622955, -0.03816620260477066, -0.03918415307998657, 0.001620473456569016,
    -0.0012713477481156588, -0.04806716367602348, 0.048158708959817886, 0.056179746985435486, 0.013824133202433586, 0.0031838177237659693, -0.06330899149179459, -0.00962307769805193,
    0.0646621510386467, -0.008928574621677399, -0.07128424942493439, 0.03202047571539879, -0.04374270513653755, -0.009950214996933937, 0.006249572616070509, 0.009759306907653809,
    0.07681859284639359, -0.08120023459196091, -0.034121956676244736, 0.07018818706274033, -0.010567119345068932, 0.02581661380827427, -0.01335749588906765, 0.02726259082555771,
    0.018638871610164642, 0.017658855766057968, -0.0027512391097843647, -0.014275426045060158, -0.03502371162176132, 0.08342042565345764, -0.013805549591779709, 0.020345330238342285,
    -0.007881823927164078, -0.03388434648513794, -0.033544912934303284, 0.020126929506659508, 0.035066235810518265, -0.031970344483852386, 0.021897802129387856, 0.018839022144675255,
    -0.021120943129062653, 0.03297583386301994, 0.028913920745253563, 0.024178514257073402, -0.01178349182009697, 0.002939794445410371, 0.04994067922234535, 0.027554625645279884,
    0.023463191464543343, 0.0005968165933154523, 0.013513565063476562, -0.0496906079351902, -0.02823193371295929, -0.030407408252358437, -0.00011670655658235773, 0.024344690144062042,
    0.02187473513185978, -0.03519395738840103, -0.016363343223929405, -0.0045868712477386, 0.004870799370110035, 0.09014612436294556, 0.029308440163731575, 0.007710328325629234,
    0.020269248634576797, 0.02445712871849537, -0.018661033362150192, -0.04327814653515816, 0.023097608238458633, -0.060506414622068405, 0.004798072390258312, -0.012767981737852097,
    -0.015723560005426407, 0.03379116579890251, 0.019173001870512962, 0.009359700605273247, 0.0019073715666309, -0.027597784996032715, -0.008989088237285614, -0.061163920909166336,
    -0.07972432672977448, -0.028432194143533707, 0.012603961862623692, 0.0386042445898056, -0.006247157230973244, 0.06836170703172684, -0.019979937002062798, -0.003742663422599435,
    0.033954400569200516, -0.04001462087035179, -0.013511511497199535, 0.03329511731863022, -0.0327397882938385, 0.002056504599750042, 0.050790272653102875, -0.02938886731863022,
    -0.02618538960814476, -0.01809278503060341, -0.01674955151975155, 0.004848673939704895, 0.04468724876642227, 0.021832270547747612, 0.059137992560863495, 0.05219082161784172,
    -0.06160154193639755, -0.018298447132110596, -0.009882214479148388, 0.015518644824624062, 0.002418729942291975, -0.02719215303659439, 0.04728831723332405, -0.0004965156549587846,
    -0.007615065202116966, -0.012299462221562862, 0.03701566532254219, -0.014063683338463306, -0.008012921549379826, -0.023269755765795708, -0.019383829087018967, 0.00012248510029166937,
    0.02841167338192463, 0.017030054703354836, -0.00878350343555212, -0.01562442071735859, 0.015425553545355797, 0.07261689007282257, 0.049015484750270844, -0.03752188757061958,
    0.008305625058710575, 0.018608005717396736, 0.015586604364216328, -0.02655789628624916, 0.0011167364427819848, 0.0009082187316380441, 0.04184899479150772, -0.05398506298661232,
    -0.0019609504379332066, 0.004434764385223389, -0.03164182975888252, -0.053177136927843094, -0.04620886966586113, -0.007621839176863432, 0.007863161154091358, -0.08284030109643936,
    -0.0027762530371546745, -0.03256925940513611, 0.022673925384879112, -0.09184090793132782, -0.013273882679641247, -0.004481466021388769, -0.0021045608446002007, -0.031931571662425995,
    -0.032792408019304276, -0.007106750272214413, 0.021043241024017334, -0.026841945946216583, -0.014793858863413334, -0.03340629115700722, 0.04511843994259834, -0.01404991652816534,
    -0.026088783517479897, -0.0729680210351944, -0.008509041741490364, -0.003340330207720399, -0.021241135895252228, 0.020941980183124542, 0.005906545091420412, 0.013886407017707825,
    0.03343397378921509, -0.02488415129482746, 0.07349733263254166, 0.0016790570225566626, 0.03928591310977936, -0.0026148927863687277, -0.00027349297306500375, 0.0024054450914263725,
    0.01964060217142105, -0.023899206891655922, -0.017488695681095123, 0.008940321393311024, -0.01206083595752716, 0.042727433145046234, 0.01698281243443489, -0.008494678884744644,
    -0.050452474504709244, -0.0236502718180418, -0.010616782121360302, 0.01860829070210457, -0.03992748260498047, -0.007953064516186714, -0.06502329558134079, -0.004899604711681604,
    -0.024410462006926537, 0.014235560782253742, -0.016799569129943848, 0.09058752655982971, -0.016553914174437523, 0.07635907083749771, -0.04111000522971153, 0.0072355312295258045,
    -0.013239351101219654, -0.019059058278799057, -0.017061656340956688, 0.0023966480512171984, -0.06621304154396057, -0.02957204543054104, -0.039215438067913055, 0.020776616409420967,
    0.10100602358579636, -0.032313693314790726, -0.01869688741862774, -0.030608315020799637, 0.014114025980234146, 0.009743115864694118, -0.03436785936355591, 0.012818992137908936,
    -0.00703046377748251, -0.02101648971438408, 0.04511682689189911, -0.010633522644639015, 0.022726798430085182, 0.030260754749178886, 0.004130433779209852, -0.01291749533265829,
    0.05039966478943825, 0.02105618081986904, -0.01773950271308422, 0.042346104979515076, -0.026591051369905472, 0.021343713626265526, -0.08775398880243301, -0.035508763045072556,
    0.07220470905303955, 0.016655540093779564, -0.018376046791672707, -0.013267707079648972, -0.021373430266976357, 0.043666329234838486, -0.0018482055747881532, -0.006345699075609446,
    0.004361674655228853, -0.0134090855717659, -0.03840123116970062, 0.021072344854474068, 0.019497305154800415, 0.02868344448506832, 0.01453323196619749, -0.010927189141511917,
    0.00789859052747488, -0.037097103893756866, -0.042526260018348694, 0.02925744652748108, -0.03584032505750656, 0.04645601660013199, 0.022297995164990425, -0.05280041694641113,
    -0.01525899674743414, 0.04107851907610893, 0.006247386801987886, -0.04088561236858368, -0.0157956350594759, -0.03455623611807823, -0.03865528851747513, -0.06698569655418396,
    0.042772337794303894, -0.06614232808351517, -0.05996033176779747, 0.05022978037595749, -0.03746512532234192, 0.02223982848227024, -0.018033495172858238, -0.005779206287115812,
    -0.032497722655534744, 0.05012696236371994, -0.007951381616294384, 0.11788276582956314, 0.042511437088251114, -0.011926784180104733, 0.034023553133010864, 0.004699639044702053,
    0.04042506590485573, 0.022553667426109314, -0.0003658937057480216, -0.03563937917351723, -0.039968471974134445, 0.039172329008579254, -0.023860909044742584, 0.010952782817184925,
    0.010104172863066196, 0.031083833426237106, -0.016023682430386543, -0.0270137507468462, 0.04830460250377655, -0.022303961217403412, 0.019915344193577766, -0.025825759395956993,
    -0.02757040038704872, 0.02875412628054619, 0.02717755176126957, 0.007223090622574091, -0.015175274573266506, -0.02880357950925827, 0.009590732865035534, 0.029004115611314774,
    0.006650025025010109, -0.018813155591487885, 0.03519787639379501, -0.05932077765464783, -0.01456101331859827, -0.03563918545842171, 0.0050937701016664505, 0.050674330443143845,
    0.007257410325109959, 0.045432042330503464, 0.029911350458860397, 0.00398478377610445, 0.012216474860906601, -0.03368013724684715, 0.08028358966112137, -0.011542478576302528,
    0.01568462885916233, 0.06131038814783096, -0.03761785849928856, 0.003893328830599785, 0.006708769127726555, -0.07739273458719254, 0.018302617594599724, -0.05780196189880371,
    0.07869897782802582, 0.07204354554414749, 0.08839188516139984, -0.013034147210419178, 0.06516040116548538, 0.000679940392728895, 0.04299825057387352, 0.026813743636012077,
    0.029025962576270103, 0.010544001124799252, -0.012327122502028942, 0.011266952380537987, 0.01993691548705101, 0.03523848205804825, 0.017393438145518303, 0.061550743877887726,
    -0.04387383535504341, 0.016778098419308662, 0.027022140100598335, 0.004989180248230696, -0.006508420687168837, 0.008555886335670948, 0.01028978917747736, -0.06440139561891556,
    -0.0030952098313719034, -0.020527614280581474, 0.006893645040690899, -0.03688613325357437, -0.0021689815912395716, 0.0165342278778553, -0.02069745399057865, 0.01956756040453911,
    0.00347463833168149, -0.014822712168097496, 0.008671963587403297, 0.011758828535676003, 0.04632288217544556, -0.02997739613056183, -0.0014314341824501753, 0.013728942722082138,
    -0.009808731265366077, -0.029349137097597122, 0.02806086093187332, -0.010981755331158638, -0.001025406876578927, 0.05683179199695587, -0.03126068785786629, 0.012180509977042675,
    0.002171542262658477, 0.0032240524888038635, -0.019115447998046875, 0.011169688776135445, 0.02775619737803936, -0.018151773139834404, -0.020346470177173615, 0.012521959841251373,
    -0.028490260243415833, 0.018110577017068863, 0.03733532875776291, 0.03405683487653732, 0.009996011853218079, 0.019044505432248116, 0.07416696101427078, 0.030128436163067818,
    -0.06718973815441132, 0.018916942179203033, 0.10233888775110245, -0.04420926794409752, -0.004890419542789459, -0.0582645945250988, 0.034067653119564056, 0.07474907487630844,
    0.033202048391103745, -0.022927340120077133, 0.018589720129966736, -0.10520387440919876, 0.03352808579802513, 0.016912108287215233, -0.01949738897383213, -0.014621546491980553,
    -0.021863339468836784, -0.011020886711776257, -0.03881438076496124, 0.01321505568921566, 0.004861326888203621, 0.022574329748749733, 0.0166806410998106, 0.041963908821344376,
    0.005514165852218866, -0.0006257653003558517, -0.04265961796045303, 0.023735908791422844, 0.004876479972153902, 0.07734974473714828, -0.02017669938504696, -0.042493585497140884,
    0.030246499925851822, 0.02066495269536972, 0.019163616001605988, -0.003363198833540082, 0.03476128354668617, -0.020906517282128334, -0.03208506107330322, -0.014115450903773308,
    0.03432139754295349, 0.01234354916960001, 0.021612025797367096, 0.009666224010288715, -0.05072396621108055, -0.00473447423428297, 0.016301902011036873, 0.02268766425549984,
    -0.05185909569263458, -0.014455561526119709, -0.004745621234178543, 0.01575336791574955, -0.012471471913158894, 0.006413606461137533, -0.02959887497127056, 0.020530475303530693,
    0.032383523881435394, 0.03275146707892418, 0.0023741149343550205, -0.057641658931970596, 0.003924860619008541, 0.04857230931520462, -0.01584700681269169, -0.02462400496006012,
    -0.017423544079065323, -0.002226953161880374, -0.046122800558805466, -0.001300889765843749, 0.04328511282801628, -0.03955432027578354, 0.020782720297574997, -0.010514549911022186,
    -0.02234962210059166, 0.033454038202762604, -0.009717999026179314, -0.02586081437766552, -0.011248137801885605, 0.015675019472837448, 0.04472015053033829, 0.004716498777270317,
    -0.0024262231308966875, -0.0005911565967835486, 0.020639535039663315, 0.018618077039718628, 0.05514519289135933, -0.033468008041381836, -0.006523903459310532, 0.01663079857826233,
    -0.035749685019254684, 0.025343643501400948, -0.0021708959247916937, 0.04114022105932236, -0.014355863444507122, -0.011967825703322887, 0.006229046266525984, 0.029666366055607796,
    -0.010255635716021061, 0.03324592113494873, 0.015942269936203957, -0.007171658333390951, 0.0032248017378151417, 0.014300568029284477, 0.02473101206123829, -0.016710003837943077,
    -0.002837618812918663, 0.02127905562520027, 0.02007046528160572, 0.03973107412457466, 0.012740593403577805, -0.039040956646203995, -0.007685455493628979, 0.00256959511898458,
    -0.06355166435241699, -0.008141308091580868, -0.02677941508591175, 0.008125771768391132, 0.018001753836870193, 0.028845570981502533, 0.009429311379790306, 0.014351749792695045,
    -0.03608353063464165, 0.03104378469288349, -0.018743347376585007, -0.0014845330733805895, 0.017569655552506447, 0.06823187321424484, -0.04193820059299469, -0.03315366804599762,
    -0.002967850537970662, 0.003201681189239025, -0.026993706822395325, 0.007056030910462141, -0.02668618969619274, 0.06523183733224869, -0.03467590734362602, 0.009900686331093311,
    -0.012536689639091492, 0.01579190604388714, -0.022429458796977997, 0.09403640031814575, 0.026378054171800613, -0.0033889771439135075, 0.03378193825483322, -0.03737395629286766,
    -0.005179908592253923, -0.0025182818062603474, 0.006999320816248655, 0.002443550620228052, 0.008119365200400352, 0.03726758807897568, 0.013161515817046165, -0.03384090214967728,
    0.04091521352529526, -0.0303108561784029, 0.017999010160565376, -0.011167719960212708, 0.011600054800510406, -0.021618306636810303, -0.03842299431562424, 0.04824332520365715,
    0.0033485908061265945, -0.018685290589928627, -0.07385584712028503, -0.015345393680036068, 0.043225809931755066, 0.011829893104732037, 0.03274357691407204, 0.025274991989135742,
    0.021726761013269424, 0.008030939847230911, -0.008761552162468433, -0.007684520445764065, 0.016791947185993195, 0.04372464492917061, -0.005198080092668533, -0.04641910269856453,
    -0.0016785451443865895, 0.031028304249048233, 0.017131663858890533, 0.005531038157641888, 0.0010099192149937153, -0.032073717564344406, -0.007959917187690735, -0.02190818078815937,
    -0.023380082100629807, -0.03450393304228783, 0.006903232540935278, 0.0922326073050499, 0.033102117478847504, -0.036826103925704956, -0.018537601456046104, -0.02826506271958351,
    -0.006399652920663357, 0.03462729603052139, 0.07835850119590759, 0.0442439503967762, -0.0101852435618639, 0.013401897624135017, -0.016530806198716164, 0.01795181818306446,
    -0.01840432919561863, -0.009474732913076878, -0.017012907192111015, 0.035023584961891174, 0.029842494055628777, 0.031329959630966187, -0.029845034703612328, -0.028751520439982414,
    0.022173000499606133, 0.009605594910681248, 0.0008110366761684418, -0.02831905707716942, -0.09324237704277039, -0.021630704402923584, 0.018977701663970947, 0.01558760553598404,
    0.06826085597276688, 0.023491328582167625, -0.002095780335366726, -0.00476190447807312, -0.009909231215715408, -0.015198918990790844, -0.06197996065020561, -0.01908084936439991,
    -0.023549582809209824, -0.0307475458830595, -0.09245800971984863, -0.0015908502973616123, -0.03638030216097832, 0.01259780302643776, 0.02140728197991848, -0.005440273322165012,
    -0.020399248227477074, 0.013164208270609379, 0.06681586802005768, -0.02590174973011017, 0.017873592674732208, 0.032064858824014664, 0.026735659688711166, -0.020068073645234108,
    0.03130568936467171, 0.008357918821275234, 0.02428979054093361, 0.03956560045480728, 0.02860560081899166, 0.006496246438473463, 0.04317604750394821, -0.06665090471506119,
    0.020581688731908798, 0.003989023622125387, -0.029810484498739243, 0.022110765799880028, -0.002690240740776062, -0.06931125372648239, 0.021917061880230904, 0.013097966089844704,
    0.01995488815009594, -9.399076225236058e-05, -0.06552308797836304, 0.033131249248981476, 0.017894214019179344, -0.023037144914269447, -0.06042139604687691, 0.046020157635211945,
    -0.007356113288551569, 0.005955205298960209, -0.013320841826498508, -0.059339042752981186, -0.0555562786757946, 0.016428424045443535, 0.0011424398981034756, -0.02717091701924801,
    0.012430229224264622, 0.02618575096130371, 0.028170296922326088, -0.05928180739283562, 0.0228810403496027, -0.006328963208943605, 0.02641087956726551, -0.01468368899077177,
    -0.01584022492170334, 0.020319579169154167, 0.031044185161590576, 0.021130895242094994, -0.004637421574443579, -0.007878380827605724, -0.024011891335248947, 0.0727238804101944,
    -0.013667432591319084, -0.04013752192258835, -0.019546879455447197, -0.00016983224486466497, -0.0018786625005304813, 0.04771120846271515, -0.05186184495687485, -0.045603375881910324,
    -0.005448975134640932, -0.007558484096080065, -0.020519550889730453, -0.009176680818200111, 0.028627704828977585, -0.0017715221038088202, -0.027902577072381973, 0.004236587788909674,
    -0.0199371799826622, 0.0065460205078125, 0.061847932636737823, -0.0069105918519198895, -0.03507782518863678, -0.013724679127335548, 0.013878535479307175, 0.0006789832841604948,
    0.013315392658114433, 0.025327134877443314, 0.014142297208309174, -0.008681174367666245, -0.04531100392341614, 0.04709175229072571, -0.016574256122112274, 0.028413666412234306,
    0.02148422785103321, 0.019432539120316505, 0.047607287764549255, -0.0024015307426452637, -0.016109701246023178, -0.008218723349273205, 0.031261466443538666, -0.01715816557407379,
    -0.035139575600624084, -0.006890987046062946, 0.018111461773514748, -0.05379937216639519, -0.014881332404911518, -0.013624003157019615, -0.03248932957649231, -0.003578374395146966,
    -0.0199144184589386, 0.027602240443229675, -0.06154581531882286, 0.039152588695287704, -0.0069566345773637295, -2.4797054720693268e-05, -0.013436242006719112, -0.01327626220881939,
    -0.015682140365242958, -0.019110221415758133, -0.013443678617477417, 0.02310037985444069, -0.023435208946466446, -0.06650983542203903, 0.01229089219123125, 0.0864013209939003,
    0.028393927961587906, 0.02806173451244831, 0.0065280720591545105, 0.01725713722407818, 0.03969072178006172, 0.009464760310947895, 0.005915903486311436, -0.02679208479821682,
    -0.012737993150949478, -0.017390690743923187, 0.05094004422426224, -0.027861086651682854, -0.001788102788850665, 0.018645865842700005, 0.030424173921346664, 0.00037305380101315677,
    -0.020258447155356407, -0.004332000855356455, -0.04970463365316391, 0.0150079894810915, -0.01669323444366455, -0.06822345405817032, -0.014461207203567028, -0.02967892773449421,
    -0.030324669554829597, -0.03546039015054703, 0.04735603928565979, -0.028544971719384193, 0.007862190715968609, 0.04458169639110565, -0.04559289664030075, 0.02282976731657982,
    0.02718201093375683, 0.026468686759471893, -0.06896896660327911, -0.009935112670063972, 0.005464326590299606, -0.053538963198661804, 0.0649586170911789, 0.0018859920091927052,
    0.0350617915391922, -0.020914405584335327, -0.012268775142729282, 0.056581635028123856, -0.09091366827487946, 0.003633564803749323, 0.0234086737036705, -0.010344086214900017,
    -0.013197832740843296, 0.021158557385206223, -0.012253545224666595, 0.012359431013464928, 0.0004903614753857255, 0.008966506458818913, -0.011897367425262928, 0.05011151358485222,
    -0.06862892955541611, 0.025153102353215218, -0.014933858998119831, 0.02920912578701973, -0.0029083415865898132, 0.008526031859219074, 0.008773044683039188, 0.018080728128552437,
    -0.016901293769478798, 0.07887985557317734, -0.0102636544033885, 0.06207161024212837, 0.012454251758754253, -0.025009283795952797, -0.030203916132450104, 0.055515747517347336,
    0.022897012531757355, 0.003614236833527684, -0.0036723180674016476, -0.029555793851614, 0.022228499874472618, -0.008709116838872433, 0.019162489101290703, 0.04115227237343788,
    -0.014723909087479115, 0.007510652299970388, 0.0227283276617527, 0.0021210084669291973, 0.02635885216295719, -0.0018511039670556784, -0.0033395285718142986, -0.00774099538102746,
    0.043275900185108185, 0.021067991852760315, 0.04468264430761337, -0.01047165784984827, -0.013528240844607353, -0.05670860782265663, 0.017304956912994385, -0.0071942126378417015,
    -0.04870571196079254, 0.004548187833279371, 0.005342012271285057, 0.009823736734688282, -0.0648370161652565, 0.05544744431972504, -0.01533559150993824, -0.012014628387987614,
    0.01438545249402523, 0.017133353278040886, -0.0052124434150755405, 0.08564083278179169, -0.0023181361611932516, -0.005210083443671465, 0.03369264304637909, 0.002649958711117506,
    -0.009733544662594795, 0.044269829988479614, -0.02847537025809288, -0.009549625217914581, -0.06182195246219635, 0.0005633121472783387, 0.047959569841623306, -0.004691238980740309,
    -0.015926353633403778, 0.022725583985447884, -0.015211938880383968, 0.018659429624676704, 0.014850258827209473, 0.04713266342878342, -0.017579982057213783, 0.022486627101898193,
    0.02822311781346798, -0.028943028301000595, 0.017879990860819817, 0.010029742494225502, 0.011226090602576733, -0.014930257573723793, 0.013943779282271862, -0.003325480269268155,
    0.006259973626583815, 0.0010518495691940188, 0.06243562698364258, 0.009642049670219421, -0.014704450964927673, 0.0138973044231534, 0.03001384437084198, 0.0571352019906044,
    0.015602506697177887, -0.012876827269792557, 0.0026571708731353283, -0.04233468696475029, 0.02113380655646324, 0.05538354814052582, 0.024293219670653343, 0.024907661601901054,
    -0.0011551373172551394, 0.03352721035480499, -0.04114605858922005, 0.013949776999652386, 0.012313398532569408, 0.004590583965182304, -0.006613191217184067, 0.023846939206123352,
    0.025936663150787354, -0.023374076932668686, 0.001073441351763904, 0.03290802985429764, -0.055128514766693115, 0.039037417620420456, -0.03306880593299866, -0.01079483237117529,
    -0.07854656875133514, 0.028858724981546402, 0.043539997190237045, -0.04177150875329971, -0.008394550532102585, 0.0007694936357438564, -0.04401477053761482, -0.012351829558610916,
    0.030014220625162125, -0.021340318024158478, -0.000269802229013294, 0.0078077358193695545, -0.007998213171958923, 0.013482140377163887, 0.03523910418152809, -0.047515325248241425,
    0.06005531921982765, 0.04865148290991783, 0.01904936507344246, -0.03128373250365257, -0.010462568141520023, 0.01460092980414629, 0.03320419788360596, -0.02895241044461727,
    -0.002803402254357934, -0.049969326704740524, -0.006196688860654831, 0.04439974203705788, -0.026771120727062225, 0.02894839271903038, -0.006645290646702051, 0.011169002391397953,
    0.008318240754306316, 0.020813480019569397, -0.04101891443133354, 0.03569323942065239, -0.045451581478118896, -0.017856532707810402, -0.0034750644117593765, -0.07577381283044815,
    -0.03412098437547684, -0.072688527405262, 0.020237110555171967, 0.004750086925923824, -0.03256603702902794, -0.008035745471715927, -0.04665285721421242, -0.00777985667809844,
    0.03967719152569771, -0.03718467801809311, 0.04804724454879761, 0.011806159280240536, 0.010721924714744091, 0.04553317278623581, -0.05104559287428856, -0.009738273918628693,
    -0.05006192997097969, 0.005497629288583994, -0.01033610850572586, -0.017566058784723282, -0.01216973178088665, -0.051644738763570786, 0.00614643469452858, 0.012649589218199253,
    0.0030745610129088163, 0.023425202816724777, 0.03732069209218025, -0.08896561712026596, -0.010730805806815624, 0.028714632615447044, 0.03394215181469917, 0.012400375679135323,
    -0.01521387230604887, 0.05980251356959343, -0.0003054265398532152, 0.01285077165812254, 0.015809210017323494, 0.01849018968641758, -0.04647231847047806, -0.054694242775440216,
    0.061887867748737335, -0.031103363260626793, -0.007361381780356169, -0.03384976089000702, -0.0005607384955510497, 0.05824144557118416, -0.013925211504101753, 0.038909662514925,
    0.01518839318305254, 0.04560176655650139, -0.04195377975702286, -0.02351018600165844, 0.0770542323589325, 0.021393511444330215, -0.020651614293456078, 0.029548533260822296,
    -0.049224838614463806, -0.0011863878462463617, 0.0591149665415287, -0.03173142671585083, -0.008900129236280918, -0.0033615801949054003, 0.024556297808885574, -0.030952248722314835,
    -0.02137446589767933, -0.007998417131602764, -0.035140447318553925, 0.007175541948527098, -0.04954792559146881, -0.04349362850189209, -0.03337491303682327, -0.010817757807672024,
    0.013950176537036896, 0.013467998243868351, 0.016191532835364342, 0.004113311879336834, -0.04349357262253761, -0.0007447613752447069, -0.01792502962052822, 0.016912080347537994,
    0.0077653187327086926, 0.002793001476675272, 0.03145275264978409, -0.031770747154951096, -0.02240222506225109, -0.01243362482637167, 0.024600515142083168, -0.0007844115607440472,
    0.046424705535173416, 0.012603167444467545, 0.009352482855319977, 0.051368437707424164, 0.025381246581673622, -0.005412796046584845, -0.025437429547309875, 0.001396711217239499,
    -0.056419264525175095, 0.017600495368242264, -0.002671936759725213, -0.0090746209025383, 0.010864687152206898, 0.009578365832567215, -0.030595431104302406, 0.02184012159705162,
    -0.02225387468934059, -0.016039345413446426, 0.024391518905758858, -0.032547228038311005, 0.012831751257181168, -0.007536559831351042, 0.05727043002843857, 0.043008510023355484,
    0.03787239268422127, 0.016655731946229935, 0.06007176637649536, 0.04451631382107735, 0.01770717464387417, -0.023988427594304085, 0.035786982625722885, 0.021418249234557152,
    -0.00729347812011838, -0.0009154602885246277, -0.005996823310852051, 0.00911271758377552, -0.026554489508271217, -0.010862136259675026, 0.0666707456111908, 0.029630344361066818,
    0.03212297707796097, 0.0026559701655060053, 0.031001728028059006, 0.008668866939842701, 0.04623030498623848, 0.016548387706279755, 0.003499551210552454, 0.04353480041027069,
    -0.0008092155330814421, -0.026805691421031952, 0.07148716598749161, -0.0023806020617485046, -0.04104995355010033, -0.058385640382766724, 0.02797595225274563, -0.02235540561378002,
    0.05612683296203613, 0.01838141866028309, 0.03183088079094887, 0.013288957998156548, -0.020273905247449875, -0.0757894366979599, 0.016281645745038986, -0.05699045956134796,
    0.07827134430408478, -0.012206241488456726, -0.009882214479148388, 0.081601582467556, 0.01209272351115942, -0.00284825311973691, -0.020931806415319443, 0.016106819733977318,
    -0.027206886559724808, -0.013346298597753048, -0.0639362707734108, 0.049194131046533585, -0.03346250578761101, 0.03396196663379669, 0.07390742748975754, -0.04560668766498566,
    -0.0004475351597648114, 0.04516418278217316, -0.013865122571587563, -0.007581814657896757, -0.04611535370349884, 0.005133901722729206, -0.01739824190735817, 0.02060372568666935,
    0.016179833561182022, -0.061332836747169495, -0.04669664800167084, -0.005964602343738079, -0.027246152982115746, 0.013667977415025234, 0.012369402684271336, 0.04151764512062073,
    -0.012674638070166111, 0.004905040841549635, 0.09520204365253448, -0.02886081673204899, 0.002134572947397828, -7.648711471119896e-05, -0.02416084334254265, 0.02066248282790184,
    0.05975852161645889, -0.016343655064702034, -0.02418261580169201, -0.00532842893153429, 0.0225666556507349, -0.07318507134914398, 0.04731617122888565, -0.01592254266142845,
    0.025655077770352364, -0.012934135273098946, 0.007314656861126423, 0.002207574900239706, 0.043053142726421356, -0.03571443259716034, 0.013880325481295586, 0.0010343892499804497,
    0.03270988538861275, -0.050911832600831985, -0.009727485477924347, 0.07022380083799362, 0.018451623618602753, -0.00831408891826868, 0.0030187529046088457, -0.015819841995835304,
    0.05480026453733444, -0.04783763736486435, -0.018512554466724396, -0.07088293880224228, 0.03912116214632988, -0.03481505438685417, -0.0020694558043032885, 0.03526461496949196,
    0.09010796248912811, -0.0025443758349865675, -0.027903329581022263, -0.0004884257796220481, 0.003812476759776473, -0.047247882932424545, -0.00414873706176877, 0.04023215174674988,
    -0.06971900910139084, -0.009835093282163143, 0.006163976155221462, 0.1158469095826149, 0.010302466340363026, -0.0206462349742651, -0.004642631858587265, 0.02819616161286831,
    0.035566795617341995, 0.0436011366546154, -0.0009755352512001991, 0.03882424160838127, 0.068512924015522, 0.02309986762702465, -0.01647728867828846, -0.019902978092432022,
    -0.02147025801241398, -0.029246123507618904, -0.008374943397939205, 0.018158400431275368, 0.05687466636300087, -0.0037550528068095446, 0.055852096527814865, 0.07911304384469986,
    0.0031511050183326006, 0.016663100570440292, -0.046629246324300766, -0.05210018530488014, -0.025042790919542313, -0.050061337649822235, 0.03881850466132164, -0.021883809939026833,
    0.009329956024885178, 0.052841342985630035, 0.01695355214178562, 0.0023867900017648935, -0.0005248069064691663, 0.03690864518284798, 0.006586996838450432, -0.007000723388046026,
    -0.030947264283895493, 0.027210574597120285, 0.00372699205763638, -0.005445505026727915, -0.042156677693128586, 0.058672089129686356, 0.0076042297296226025, 0.0865810438990593,
    -0.066189706325531, -0.036806803196668625, -0.0006962575134821236, -0.07916571199893951, -0.02571566216647625, 0.05178308114409447, 0.01199734304100275, -0.06474173814058304,
    0.0004992216709069908, 0.0026041152887046337, -0.02672744169831276, -0.05175809934735298, -0.004139869008213282, -0.029152942821383476, -0.09195379167795181, 0.0028965340461581945,
    -0.012976892292499542, -0.019564451649785042, -0.02846466191112995, -0.02368236891925335, -0.014110224321484566, 0.01357576996088028, 0.012191755697131157, 0.017404982820153236,
    0.0057202838361263275, 0.001633807783946395, -0.016906680539250374, 3.941486284020357e-05, 0.00010910496348515153, -0.001587073551490903, 0.01095557026565075, -0.03443526476621628,
    0.008631240576505661, 0.009109465405344963, 0.06237872689962387, 0.038118984550237656, 0.006972951348870993, -0.0035793648567050695, 0.056665461510419846, -0.022496139630675316,
    -0.004585394635796547, 0.0005655891727656126, 0.003322616685181856, -0.01513845194131136, -0.002115392591804266, 0.01706334948539734, 0.05790160596370697, -0.024883275851607323,
    0.05509393289685249, -0.03495297208428383, 0.00858614593744278, -0.009009208530187607, -0.028598317876458168, -0.00209787767380476, -0.023666972294449806, 0.0016583295073360205,
    -0.004141098354011774, -0.012367835268378258, -0.04969428479671478, -0.04336089640855789, -0.03678008168935776, 0.04535403847694397, -0.0041940463706851006, -0.0011063445126637816,
    -0.0021063752938061953, 0.00445743789896369, 0.014292766340076923, 0.054111335426568985, -0.00678238132968545, -0.012866230681538582, -0.02620433270931244, 0.004246131982654333,
    -0.0728449821472168, -0.012567313387989998, 0.058182355016469955, 0.007882260717451572, 0.004561032168567181, 0.03634317219257355, -0.011142180301249027, -0.04518408328294754,
    0.04948872700333595, -0.011573689989745617, 0.007319133263081312, -0.11773625016212463, 0.0071153161115944386, -0.04304153099656105, 0.043583039194345474, 0.0014678625157102942,
    0.03291251137852669, -0.020357748493552208, -0.01583479344844818, -0.007048217114061117, -0.020251382142305374, 0.02789567969739437, 0.047345880419015884, 0.009387725032866001,
    0.023900235071778297, 0.06374695897102356, -0.011252425611019135, -0.026838814839720726, -0.006588261108845472, -0.043829914182424545, 0.01067299023270607, -0.03139965981245041,
    -0.01380032580345869, -0.017456572502851486, 0.04345178231596947, 0.024974746629595757, 0.018140340223908424, -0.004963373299688101, -0.02827775850892067, 0.04252063110470772,
    -0.04320695996284485, -0.014873810112476349, -0.0005159818683750927, -0.03589668869972229, -0.05129007250070572, -0.038056179881095886, -0.014657987281680107, -0.02850108966231346,
    0.024289211258292198, 0.0038668704219162464, 0.06598002463579178, 0.05547170713543892, -0.007468830328434706, 0.010418210178613663, 0.022438298910856247, -0.037180062383413315,
    -0.009970610961318016, 0.004223528318107128, 0.024985315278172493, 0.07508427649736404, -0.01684020273387432, 0.01813790202140808, 0.006349630653858185, 0.03319920599460602,
    0.005887496750801802, -0.04485078155994415, 0.028156090527772903, 0.04451346769928932, 0.0033958046697080135, -0.027125267311930656, 0.05927222967147827, -0.04747842997312546,
    0.008759844116866589, 0.007746146060526371, -0.010271226055920124, -0.012168907560408115, 0.016509143635630608, -0.021390341222286224, -0.04979441314935684, 0.01657617650926113,
    0.047272939234972, 0.0499926321208477, -0.046621743589639664, -0.0031662979163229465, -0.00804344192147255, -0.03609766438603401, 0.013289584778249264, 0.019764941185712814,
    -0.02352549321949482, -0.0006097474251873791, 0.04853762686252594, 0.03821341693401337, 0.0021877766121178865, 0.04857003688812256, 0.03468414768576622, 0.01905972696840763,
    0.0381007045507431, -0.022483086213469505, 0.01334192231297493, 0.03339417651295662, -0.01379275880753994, -0.04231119155883789, -0.0126105435192585, -0.050644151866436005,
    0.015337012708187103, -0.012256882153451443, 0.015876756981015205, -0.03437469154596329, 0.022000281140208244, 0.007360260467976332, 0.08070644736289978, -0.0058194659650325775,
    0.03177385404706001, -0.005633213557302952, -0.014791630208492279, 0.03660669922828674, -0.005938088055700064, 0.030546100810170174, 0.05310444161295891, 0.0877314880490303,
    -0.007474929094314575, 0.030043890699744225, -0.018258322030305862, 0.0018874171655625105, 0.024190697818994522, 0.009334470145404339, -0.08266019076108932, 0.007109728176146746,
    -0.017570735886693, 0.004397109150886536, -0.012453672476112843, 0.04018230363726616, -0.04812726378440857, 0.016723500564694405, 0.029422342777252197, 0.010345331393182278,
    -0.041441623121500015, 0.011191080324351788, -0.0029881526716053486, 0.04207257926464081, 0.006219500210136175, 0.009179780259728432, 0.037601470947265625, -0.011882741935551167,
    -0.01498327311128378, 0.009404804557561874, 0.07339262962341309, 0.0041665066964924335, -0.02215973660349846, 0.03531186655163765, -0.01994975470006466, 0.04592590779066086,
    0.037919532507658005, -0.03585171326994896, -0.0016081349458545446, 0.02049116976559162, -0.02245066501200199, 0.025874152779579163, -0.0033970961812883615, 0.04398426041007042,
    0.005554559640586376, 0.024306828156113625, -0.032697129994630814, 0.0033649744000285864, -0.012405727058649063, -0.00014443823602050543, 0.0368286594748497, -0.0162307508289814,
    -0.024578802287578583, -0.02281900867819786, 0.048810623586177826, -0.03129565343260765, 0.007418664637953043, 0.03586973994970322, -0.05463624745607376, 0.019599802792072296,
    0.0025700069963932037, -0.004600557032972574, -0.013123512268066406, -0.03366873040795326, 0.031426768749952316, 0.0008098238613456488, 0.06560179591178894, -0.015543359331786633,
    -0.004470204468816519, 0.04062057286500931, 0.04730736091732979, -0.05803364887833595, 0.01528130378574133, -0.04258975014090538, -0.011185399256646633, -0.03279867395758629,
    -0.037157781422138214, 0.006834926549345255, 0.018083306029438972, -0.038196999579668045, -0.010008694604039192, 0.02666093409061432, -0.021602395921945572, 0.06322066485881805,
    -0.0774308368563652, -0.005760209634900093, 0.021512914448976517, 0.023743854835629463, 0.00837166327983141, -0.0007591646863147616, -0.038121215999126434, -0.038176167756319046,
    -0.004099967423826456, -0.05963817238807678, -0.024980776011943817, -0.006248948629945517, -0.032301727682352066, 0.01823747716844082, 0.02017183043062687, 0.0013277872931212187,
    -0.0026277306023985147, 0.04182839393615723, 0.05683517083525658, 0.050336308777332306, -0.01984148472547531, 0.014199318364262581, -0.022075830027461052, 0.022172965109348297,
    -0.010050032287836075, -0.007005481049418449, 0.020776933059096336, -0.02629259042441845, -0.005495110526680946, 0.0156282726675272, -0.006213534157723188, 0.036715369671583176,
    0.027294479310512543, -0.059263646602630615, 0.03149959444999695, -0.002917228266596794, -0.004279740154743195, 0.040794625878334045, -0.025202596560120583, -0.02937154844403267,
    -0.03780050203204155, -0.038362883031368256, 0.024691645056009293, -0.03913882374763489, 0.003699983935803175, 0.019177528098225594, 0.004202278796583414, -0.0012328356970101595,
    -0.03692946210503578, -0.023858629167079926, 0.00696386257186532, -0.009119539521634579, 0.029855240136384964, -0.031181445345282555, 0.04549848288297653, 0.07408888638019562,
    0.061632584780454636, -0.017208123579621315, -0.03957463428378105, 0.006743958219885826, -0.04429306462407112, 0.011150444857776165, -0.01476063672453165, 0.015513711608946323,
    0.008746086619794369, 0.015492967329919338, -0.009401272982358932, 0.017293713986873627, 0.009851664304733276, -0.019125571474432945, 0.016282955184578896, -0.014206807129085064,
    0.08330659568309784, 0.006487381644546986, -0.052576709538698196, -0.023756785318255424, 0.009348270483314991, -0.05080319568514824, 0.015106361359357834, -0.03560428321361542,
    0.025716392323374748, 0.012514983303844929, 0.018332358449697495, -0.024728940799832344, -0.021095048636198044, 0.03739339858293533, 0.05249504745006561, 0.007073176093399525,
    -0.002550780773162842, -0.0036535717081278563, 0.021320095285773277, 0.01644301228225231, 0.00963548757135868, 0.006981984246522188, -0.024759331718087196, 0.0230618417263031,
    0.00641281995922327, -0.013355404138565063, 0.03611525520682335, 0.03750857710838318, 0.016756080090999603, -0.03789954632520676, 0.038564711809158325, -0.0097171850502491,
    0.027598196640610695, 0.008447685278952122, 0.013730606064200401, 0.030873628333210945, -0.058496199548244476, 0.0025660432875156403, -0.02574353665113449, -0.003827181877568364,
    0.010520828887820244, 0.03966536000370979, -0.007894612848758698, 0.028274528682231903, -0.02598600648343563, 0.07193659991025925, -0.05084485560655594, -0.039482805877923965,
    0.01660623960196972, -0.1470397263765335, 0.010587513446807861, -0.010672155767679214, 0.007681414484977722, 0.02669193595647812, -0.002096241805702448, 0.0012286534765735269,
    0.04173944890499115, -7.342601747950539e-05, -0.042292751371860504, 0.021847780793905258, -0.05363249033689499, 0.052725668996572495, 0.02330307848751545, -0.051098909229040146,
    -0.0011543785221874714, 0.08701355755329132, -0.08350955694913864, -0.013338955119252205, -0.055908508598804474, 0.024965636432170868, -0.014961520209908485, 0.024855975061655045,
    0.0048194872215390205, 0.015170386992394924, 0.03713279590010643, 0.059388693422079086, -0.001382723217830062, 0.0038810346741229296, 0.02536757104098797, -0.018616540357470512,
    0.053933314979076385, -0.008381030522286892, -0.0007114906911738217, 0.013804742135107517, 0.0036737716291099787, -0.03171606734395027, 0.03767363727092743, 0.02393793687224388,
    0.02376960963010788, -0.0002606051857583225, 0.03195509687066078, 0.0014963888097554445, 0.03650663048028946, -0.0635487288236618, 0.03889114037156105, -0.03619154170155525,
    0.01704595983028412, 0.006829227786511183, 0.05974530056118965, 0.036737434566020966, -0.10995236039161682, 0.06622975319623947, -0.06041709706187248, 0.01664210669696331,
    -0.022465916350483894, -0.008434971794486046, -0.02632967196404934, 0.02329273521900177, -0.009089060127735138, 0.02431088127195835, 0.00493665412068367, 0.010830901563167572,
    -0.06965765357017517, -0.024512432515621185, -0.007497779093682766, 0.036288224160671234, -0.07106869667768478, 0.00810754019767046, 0.04868321120738983, -0.01405325997620821,
    -0.05856383591890335, 0.055153243243694305, -0.0015936942072585225, -0.10311628133058548, -0.011969327926635742, 0.0028281109407544136, 0.015846677124500275, 0.01292095985263586,
    -0.07659771293401718, -0.021892502903938293, 0.007755568716675043, -0.05531318113207817, 0.02611038275063038, -0.0026440925430506468, 0.022733500227332115, 0.01942085660994053,
    -0.02499552257359028, 0.031324658542871475, 0.036001335829496384, -0.01847502402961254, -0.025983991101384163, -0.00013103614037390798, 0.002954525174573064, -0.028686491772532463,
    -0.00455363979563117, -0.05689103156328201, 0.0030860763508826494, -0.01958455890417099, -0.03865150734782219, 0.02873498760163784, 0.013461696915328503, 0.00242989556863904,
    0.0423470064997673, 0.011477808468043804, -0.061859190464019775, -0.06879975646734238, -0.06008005142211914, 0.032448653131723404, -0.038817040622234344, -0.08856980502605438,
    -0.02301221527159214, 0.04783235862851143, 0.0018932471284642816, 0.0016118676867336035, 0.03536977991461754, -0.00028025289066135883, 0.03124689683318138, 0.04228925704956055,
    0.018785705789923668, -0.06459793448448181, -0.034070566296577454, 0.01773892715573311, -0.05380323529243469, -0.017622172832489014, 0.0219139251857996, 0.029206056147813797,
    0.01041776966303587, -0.06928645074367523, -0.007397662848234177, 0.05818741023540497, -0.013336020521819592, -0.021603159606456757, 0.0379754938185215, -0.07053759694099426,
    -0.060859180986881256, -0.02490232326090336, 0.010591003112494946, -0.01803654246032238, -0.021460793912410736, -0.004602571949362755, 0.05905905365943909, 0.019677424803376198,
    0.03859831020236015, -0.10024543106555939, -0.00962369330227375, 0.026154005900025368, 0.02297741360962391, -0.032202690839767456, 0.010090453550219536, -0.002773151732981205,
    0.009093117900192738, -0.031491950154304504, 0.02692936360836029, 0.034938596189022064, -0.010089636780321598, 0.03762679547071457, -0.001919310074299574, 0.023970812559127808,
    0.05886487662792206, -0.0005994262755848467, -0.006504628341645002, 0.0725741907954216, 0.00075034040492028, -0.0252141784876585, 0.03607487305998802, -0.04569820687174797,
    0.022070081904530525, -0.047313496470451355, 0.05000375211238861, 0.008926913142204285, -0.05753595754504204, 0.004235676024109125, -0.016018344089388847, 0.03296925500035286,
    0.08601069450378418, -0.021588774397969246, 0.012759041972458363, -0.03502742201089859, 0.0028826810885220766, 0.0041488101705908775, 0.05334541201591492, 0.030627092346549034,
    0.014506869949400425, 0.06583762168884277, -0.018690118566155434, -0.0309101901948452, -0.002358632395043969, 0.021919377148151398, -0.003521661041304469, 0.007926545105874538,
    0.03765716031193733, 0.003845819039270282, 0.01952640898525715, -0.011704010888934135, -0.013572226278483868, -0.014767540618777275, 0.0038113188929855824, -0.00589061388745904,
    0.005176776088774204, -0.0052131470292806625, -0.06190822273492813, 0.08367162942886353, -0.015835518017411232, -0.05445044860243797, 0.044633105397224426, -0.01724325306713581,
    0.014302714727818966, 0.04962341859936714, 0.050933461636304855, 0.05165136605501175, -0.10393118858337402, 0.02119971252977848, -0.0004664711595978588, 0.004968960303813219,
    0.03292866051197052, -0.027813350781798363, -0.024134494364261627, -0.012607459910213947, -0.037979789078235626, 0.044731445610523224, -0.01229951437562704, 0.0063325148075819016,
    0.03072647750377655, -0.03924068808555603, -0.05971946567296982, -0.04984356462955475, 0.04098614677786827, -0.017840661108493805, 0.009405405260622501, -0.0386241115629673,
    -0.01695062965154648, 0.026330264285206795, -0.0422508530318737, -0.03160252422094345, 0.001974259503185749, -0.03569505363702774, 0.0029845701064914465, 0.013797415420413017,
    -0.0007320839213207364, 0.037875525653362274, -0.029685189947485924, 0.01053034607321024, -0.0004842386697418988, -0.025286203250288963, -0.01690051518380642, 0.034612081944942474,
    -0.023306800052523613, 0.005646111909300089, -0.03010050766170025, -0.06251771748065948, -0.005143553949892521, -0.03082888014614582, 0.02065679244697094, -0.062245599925518036,
    -0.005028489977121353, 0.00022678809182252735, -0.011406149715185165, -0.04302186518907547, -0.064311183989048, 0.0455663725733757, -0.027224436402320862, 0.004574006423354149,
    -0.05972542241215706, 0.03373522311449051, 0.04111267998814583, -0.011342441663146019, 0.031020179390907288, -0.00781971961259842, -0.05784401297569275, 0.025514038279652596,
    -0.04949339106678963, 0.09089633822441101, -0.015762923285365105, 0.0005649728700518608, -0.03888172656297684, 0.023265881463885307, -0.006223367527127266, 0.020428111776709557,
    -0.002615842269733548, 0.04689139500260353, 0.07285960018634796, -0.008880679495632648, -0.017647624015808105, -0.0021144102793186903, -0.04981304332613945, -0.019363638013601303,
    -0.006007856223732233, 0.005017338786274195, -0.03515096381306648, -0.05822383239865303, 0.008595290593802929, 0.022874437272548676, 0.02436664327979088, 0.0217551589012146,
    0.0027782702818512917, -0.01226641982793808, -0.04650746285915375, 0.03337443247437477, 0.003350344253703952, -0.007939567789435387, 0.025067193433642387, -0.015593457967042923,
    0.04270672798156738, -0.0397767536342144, -0.015153871849179268, 0.023207703605294228, 0.015417848713696003, 0.04279869422316551, -0.004408723209053278, 0.00771805876865983,
    0.016771644353866577, -0.02964666113257408, -0.002243022434413433, 0.08482368290424347, -0.008017508313059807, 0.017323972657322884, 0.05823097005486488, -0.042881738394498825,
    -0.03626220300793648, -0.005029554013162851, -0.014604933559894562, 0.012050770223140717, -0.0016012549167498946, -0.017432209104299545, 0.04258757457137108, 0.0034616058692336082,
    0.04020096734166145, -0.03530339151620865, -0.010494930669665337, -0.04570605605840683, 0.06505855917930603, 0.004491772502660751, -0.0247365552932024, 0.034093428403139114,
    0.026322364807128906, 0.02595868892967701, -0.0274944044649601, 0.02766232006251812, -0.021693939343094826, 0.009077304042875767, -0.022413669154047966, -0.060015466064214706,
    -0.0029735739808529615, 0.0002941489510703832, -0.024720480665564537, -0.029649537056684494, 0.0026442345697432756, -0.007015762384980917, 0.0042534396052360535, -0.06567676365375519,
    -0.002147916005924344, -0.018345532938838005, 0.043614014983177185, 0.039879050105810165, -0.057612109929323196, -0.03976157680153847, -0.0006816547829657793, 0.02717052958905697,
    -0.03533879667520523, -0.02810532972216606, -0.0417017862200737, -0.002178514376282692, -0.005007429514080286, 0.012311561964452267, -0.0257088765501976, -0.02039695531129837,
    -0.04147786274552345, 0.02035602740943432, 0.04147700220346451, 0.04272126406431198, 0.0546465702354908, 0.00707640266045928, 0.003903481876477599, -0.010679763741791248,
    0.009878815151751041, 0.0025663261767476797, 0.026088688522577286, 0.07588965445756912, 0.007246808614581823, 0.014590533450245857, -0.012944567017257214, 0.023177778348326683,
    -0.009555460885167122, -0.06080227345228195, -0.03970761224627495, 0.027852145954966545, 0.038345884531736374, 0.014051554724574089, 0.04809542000293732, 0.03038794733583927,
    0.07565397769212723, -0.05268720164895058, 0.03312515467405319, -0.017196299508213997, -0.006925174966454506, -0.049418121576309204, 0.020579831674695015, -0.010225853882730007,
    -0.021385690197348595, -0.05459499731659889, -0.07079137861728668, -0.003486429573968053, -0.016021065413951874, 0.03427840396761894, -0.019218122586607933, -0.00305933621712029,
    -0.018002688884735107, -0.025151735171675682, -0.05424772575497627, 0.001845654216594994, -0.015045730397105217, -0.017925482243299484, 0.016813967376947403, 0.05212045833468437,
    0.05779384821653366, -0.010793511755764484, 0.019150972366333008, 0.009981250390410423, -0.023678390309214592, -0.023619307205080986, -0.015907542780041695, -0.020339196547865868,
    0.04397590830922127, 0.03174891322851181, 0.03503900766372681, -0.015220815315842628, 0.059026338160037994, -0.04568609595298767, -0.003970011603087187, 0.05769619345664978,
    0.03569076210260391, 0.062432169914245605, 0.038543008267879486, -0.025845108553767204, -0.014333171769976616, -0.009520495310425758, -0.01697307825088501, 0.02764912322163582,
    -0.011643596924841404, -0.05881636589765549, -0.008896218612790108, -0.07816377282142639, -0.0023057721555233, 0.004703017417341471, 0.07806504517793655, 0.03677972033619881,
    0.01179194450378418, 0.002392815425992012, -0.03201526403427124, -0.0102461539208889, 0.04923350736498833, -0.028046656399965286, -0.002204067539423704, -0.019150380045175552,
    -0.06470251083374023, 0.040677204728126526, -0.009417485445737839, -0.10626012831926346, -0.03707569092512131, 0.03543080762028694, 0.046252474188804626, -0.02477066032588482,
    -0.07302109152078629, -0.006749675143510103, -0.009823854081332684, -0.018555402755737305, 0.01137753389775753, -0.004472725559026003, 0.014417224563658237, 0.001614000299014151,
    0.07279053330421448, 0.0005307960091158748, 0.03196810558438301, -0.00830851774662733, 0.032136742025613785, -0.01872243918478489, 0.016102999448776245, -0.006386443041265011,
    -0.028698312118649483, -0.007266782224178314, -0.017186878249049187, 0.011746564880013466, 0.058529872447252274, 0.010011338628828526, 0.023644788190722466, 0.016574949026107788,
    -0.047854676842689514, 0.0706540197134018, 0.00048490954213775694, -0.00013569903967436403, -0.037699129432439804, -0.02175569348037243, 0.018117304891347885, -0.02219981886446476,
    -0.0015924677718430758, -0.012668884359300137, 0.01165444403886795, -0.00785486027598381, -0.03883393481373787, 0.007775426376610994, 0.00370790041051805, 0.006799714639782906,
    0.057135019451379776, 0.06321875005960464, 0.00731230853125453, -0.07564715296030045, -0.021742122247815132, 0.021836325526237488, -0.016976412385702133, -0.003645370714366436,
    0.004828258417546749, -0.02775619737803936, -0.03379324823617935, 0.03035375103354454, -0.0032786496449261904, -0.014382567256689072, 0.019358353689312935, 0.0044295876286923885,
    0.02275175414979458, 0.016551563516259193, 0.08281752467155457, 0.03875381499528885, 0.029368286952376366, 0.008271663449704647, -0.03927972912788391, -0.024549275636672974,
    -0.026008576154708862, 0.008628089912235737, -0.09769817441701889, -0.015947159379720688, 0.029427584260702133, -0.005706265568733215, 0.03902252018451691, -0.009854610078036785,
    0.03839673846960068, 0.018440771847963333, 0.003401433816179633, 0.047714974731206894, 0.013513251207768917, 0.03716480731964111, 0.030083078891038895, -0.03024555929005146,
    -0.015168163925409317, 0.025155477225780487, -0.04775372892618179, -0.04544970765709877, 0.03803858533501625, 0.020978497341275215, 0.014291745610535145, 0.05065738409757614,
    0.005212108138948679, -0.007748916745185852, 0.022855274379253387, 0.008764456026256084, -0.00360294827260077, -0.0057760742492973804, 0.06190428510308266, 0.016580576077103615,
    -0.0037563075311481953, -0.04067991301417351, 0.0028110321145504713, 0.032843705266714096, -0.0038733608089387417, 0.06127109006047249, -0.007571659050881863, -0.017731234431266785,
    -0.02826423943042755, 0.05109693482518196, -0.011681192554533482, 0.05584552511572838, -0.02571585215628147, -0.05942297726869583, 0.033221956342458725, -0.021479539573192596,
    0.008447115309536457, 0.015837233513593674, 0.015445549041032791, 0.023320114240050316, 0.0037816993426531553, -0.0480562224984169, 0.003467300208285451, 0.0021706088446080685,
    0.07752548158168793, -0.018238918855786324, -0.0098467031493783, 0.09119078516960144, -0.016191359609365463, -0.08213180303573608, -0.0018665962852537632, 0.023265914991497993,
    -0.013581173494458199, 0.0018582716584205627, 0.008504237979650497, 0.013126040808856487, 0.001630172599107027, 0.013539791107177734, 0.0034844360779970884, -0.031831979751586914,
    -0.009706966578960419, 0.04089360311627388, 0.008088457398116589, 0.006204798351973295, 0.006670212838798761, 0.024222075939178467, 0.03793363645672798, 0.004415114410221577,
    0.04983394593000412, -0.057246774435043335, 0.041632045060396194, -0.01419503428041935, -0.04983523115515709, -0.025225166231393814, -0.05989035591483116, -0.033253394067287445,
    0.027149906381964684, -0.0027835788205266, -0.0501699335873127, 0.007251448929309845, -0.02271624654531479, 0.010427460074424744, -0.04319269582629204, -0.020312976092100143,
    -0.005661149974912405, 0.03144381195306778, 0.010983568616211414, 0.016768988221883774, 0.006444002967327833, -0.037663254886865616, 0.0140815619379282, 0.040161821991205215,
    0.03819867596030235, 0.01648423634469509, 0.004408487118780613, 0.0829010158777237, -0.014097757637500763, 0.02871617302298546, 0.0156865231692791, 0.025690553709864616,
    0.0006764201098121703, -0.03813638165593147, 0.041236892342567444, -0.009492498822510242, 0.023975161835551262, -0.023609375581145287, -0.03948449343442917, -0.025925399735569954,
    -0.015803055837750435, -0.02345007285475731, 0.04248378053307533, -0.00354568799957633, -0.04702576994895935, 0.01419198326766491, 0.005608867853879929, -0.04087917134165764,
    -0.018902679905295372, -0.02383253537118435, 0.03467746824026108, 0.008558621630072594, 0.03752889484167099, 0.018979491665959358, -0.06567826867103577, -0.046184178441762924,
    -0.010672662407159805, 0.05769505724310875, 0.015247557312250137, -0.008507580496370792, -0.009916240349411964, 0.006805869750678539, 0.06391946226358414, 0.03993075340986252,
    0.04303465411067009, -0.0070388163439929485, -0.03892897069454193, 0.0016466748202219605, -0.014858049340546131, 0.055432986468076706, -0.045790739357471466, -0.04547659307718277,
    0.010780874639749527, 0.008064857684075832, 0.02245914749801159, 0.010173757560551167, -0.03474965691566467, -0.011776541359722614, 0.009935736656188965, 0.04741387814283371,
    -0.062366705387830734, 0.005631095264106989, 0.06918538361787796, 0.009781725704669952, -0.011050052009522915, -0.014713245443999767, 0.012304466217756271, -0.039600271731615067,
    -0.013421042822301388, 0.0704200491309166, 0.01454738900065422, -0.04088330641388893, 0.004538733512163162, -0.00013071554712951183, 0.006527420599013567, 0.010216646827757359,
    -0.03997260332107544, -0.033182211220264435, 0.03817048668861389, 0.029659682884812355, 0.02654593624174595, 0.035638730973005295, 0.029147733002901077, 0.024233542382717133,
    0.02673645317554474, -0.04660186916589737, 0.0074005210772156715, -0.08683348447084427, -0.004528358578681946, 0.05915084853768349, 0.031894031912088394, -0.023667562752962112,
    -0.024351119995117188, -0.006671232637017965, -0.0011469607707113028, 0.004849388264119625, -0.03701203316450119, -0.01644454337656498, 0.00319300452247262, -0.03913921117782593,
    0.017110047861933708, -0.038680411875247955, 0.037040263414382935, 0.011019956320524216, 0.017403289675712585, 0.005630127154290676, 0.001673746039159596, 0.02216743864119053,
    -0.03198056295514107, 0.004687465727329254, -0.022880403324961662, 0.01603933796286583, -0.007762976922094822, -0.002487968187779188, 0.010726903565227985, 0.04649627208709717,
    -0.030804885551333427, 0.0402328260242939, -0.06270232051610947, -0.0025610460434108973, 0.005076372995972633, 0.0005597455310635269, 0.05873832479119301, 0.0029008835554122925,
    -0.043835218995809555, 0.028308745473623276, -0.009966344572603703, -0.005577233154326677, -0.04242943599820137, 0.005141822621226311, -0.03585429489612579, -0.01928493194282055,
    -0.012445470318198204, 0.005511552561074495, -0.05689040571451187, -0.07711023837327957, -0.035661209374666214, -0.05475488677620888, 0.038246024399995804, -0.02434522658586502,
    -0.0016016507288441062, -0.03189203888177872, -0.05666203051805496, 0.021589254960417747, 0.000595211808104068, 0.015248068608343601, -0.03808961436152458, -0.024615004658699036,
    -0.04769106209278107, -0.0020563786383718252, 0.08637476712465286, 0.009340825490653515, 0.045750584453344345, -0.0475347600877285, -0.033134497702121735, 0.038387399166822433,
    0.006338685750961304, -0.001859225332736969, -0.039987072348594666, 0.03356920927762985, -0.03584010899066925, -0.045529805123806, 0.016514955088496208, 0.0038228349294513464,
    -0.011607823893427849, -0.02734481729567051, 0.06738954782485962, 0.03572158142924309, -0.007103200536221266, 0.03249393776059151, -0.009863621555268764, 0.01115114800632,
    0.0038725403137505054, 0.013599496334791183, -0.013795132748782635, -0.012153799645602703, 0.0067870584316551685, -0.035965561866760254, -0.01143623236566782, 0.01572311855852604,
    -0.010832404717803001, 0.017709534615278244, 0.018637780100107193, -0.004321689251810312, 0.04474707692861557, -0.019332176074385643, 0.03110765479505062, -0.03860024735331535,
    0.04733932763338089, 0.018115829676389694, -0.07946347445249557, -0.019495615735650063, -0.02035076543688774, 0.001656799460761249, 0.027354305610060692, -0.036431167274713516,
    0.03742130845785141, -0.0417935810983181, -0.06397449225187302, 0.0679273009300232, -0.03288877010345459, 0.03198668733239174, 0.033075109124183655, 0.005774076096713543,
    0.0333353653550148, -0.0007568733999505639, -0.056538719683885574, -0.027256272733211517, -0.056633882224559784, -0.023498153313994408, -0.010555826127529144, -0.0398247204720974,
    -0.047222208231687546, 0.023290248587727547, -0.027252476662397385, -0.003223941195756197, 0.021117331460118294, -0.060563329607248306, 0.013330621644854546, -0.007691080216318369,
    0.020384928211569786, 0.007721434812992811, 0.02360653690993786, -0.02603919804096222, -0.05320928245782852, 0.01265853364020586, -0.011161474511027336, 0.011841397732496262,
    0.02098940499126911, -0.003965151030570269, 0.011951552703976631, -0.044155050069093704, 0.01884624920785427, -0.040156811475753784, 0.005816160701215267, -0.035896219313144684,
    -0.0050595845095813274, -0.038679081946611404, -0.009321087040007114, 0.032292019575834274, 0.01880607195198536, 0.04600604251027107, -0.012868336401879787, -0.03672363609075546,
    0.08328568935394287, -0.04987049475312233, -0.06067095324397087, 0.0335870161652565, 0.020613381639122963, -0.00596272898837924, -0.007518548984080553, -2.351183138671331e-05,
    -0.002862176625058055, -0.019668584689497948, 0.050977133214473724, -0.009245630353689194, 0.03740263730287552, -0.033553946763277054, -0.034318048506975174, 0.00618289178237319,
    0.09169204533100128, 0.04659493640065193, 0.02891412563621998, 0.08090975880622864, 0.01796860806643963, 0.042836807668209076, -0.02393663115799427, -0.0006877843989059329,
    0.029825108125805855, -0.028209634125232697, -0.022167816758155823, -0.043384965509176254, -0.008558066561818123, 0.010645774193108082, 0.019611932337284088, -0.010109109804034233,
    0.04319746792316437, 0.0007965867989696562, 0.07122649997472763, -0.007755436468869448, -0.016021355986595154, 0.03865327686071396, 0.031620047986507416, 0.006373108830302954,
    0.017403598874807358, 0.014969540759921074, -0.009119629859924316, -0.005137523636221886, -0.05298938229680061, 0.050764184445142746, -0.006682088598608971, -0.022647015750408173,
    -0.024264715611934662, 0.00549934059381485, -0.041733428835868835, 0.014758288860321045, -0.001643868861719966, 0.0005016243667341769, -0.0004868405230809003, 0.0056356508284807205,
    0.05370676890015602, 0.06532225012779236, -0.07422952353954315, -0.08558940887451172, -0.04129142686724663, 0.06460542976856232, 0.0349816158413887, 0.013756399042904377,
    0.016170252114534378, 0.0580192469060421, 0.05185449495911598, 0.012191385962069035, -0.011281321756541729, -0.02571590431034565, -0.071719229221344, 0.03107466734945774,
    0.01794159598648548, 0.012684129178524017, -0.012815484777092934, 0.02052118070423603, -0.028919348493218422, 0.009096878580749035, -0.03510841354727745, 0.003425223520025611,
    -0.09729858487844467, -0.028488637879490852, 0.014632939361035824, -0.07348358631134033, 0.017295975238084793, 0.021264158189296722, 0.02958928421139717, 0.011321117170155048,
    -0.023952428251504898, -0.00977389607578516, 0.03759085386991501, 0.030011901631951332, 0.042437609285116196, -0.0015670672291889787, 0.03012305125594139, 0.03928050771355629,
    -0.03289664536714554, 0.06030695140361786, -0.0004522971867118031, 0.07099170237779617, -0.04859805479645729, -0.060567956417798996, -3.1827762541070115e-06, -0.02727103978395462,
    0.033670421689748764, -0.05162356421351433, -0.0058432151563465595, 0.0034386711195111275, -0.029329106211662292, 0.05729999765753746, -0.013697688467800617, 0.014446430839598179,
    0.03747912496328354, 0.0006454201648011804, 0.0628371611237526, 0.041693512350320816, -0.050637442618608475, -0.004822134971618652, -0.024830730631947517, -0.027244416996836662,
    -0.02459898591041565, 0.022427259013056755, -0.0029056535568088293, -0.023151595145463943, 0.022544896230101585, -0.09612444043159485, -0.007660217117518187, 0.0996689572930336,
    0.008423765189945698, 0.000952911505009979, -0.04992419853806496, 0.0016302472213283181, 0.039693478494882584, -0.00595214543864131, 0.009960072115063667, 0.03867090493440628,
    0.041276413947343826, -0.10425158590078354, -0.03271014243364334, -0.01799228973686695, -0.03483933210372925, -0.0045621651224792, 0.05500077083706856, -0.027143416926264763,
    0.042884111404418945, 0.03056791052222252, 0.056001316756010056, -0.08433022350072861, -0.03950583562254906, -0.029940448701381683, -0.03437473624944687, 0.013482622802257538,
    -0.029494579881429672, -0.012540360912680626, 0.05987986549735069, -0.015264943242073059, 0.04251419007778168, 0.0077559310011565685, -0.0191603135317564, 0.014628165401518345,
    -0.00262754550203681, -0.0003396059910301119, 0.042944010347127914, 0.027593309059739113, -0.006770127918571234, 0.0077587817795574665, -0.020928483456373215, -0.012272096239030361,
    0.03228652477264404, 0.0034933793358504772, 0.027754148468375206, -0.013336527161300182, 0.09968271851539612, -0.02658088319003582, -0.028753839433193207, 0.04205586016178131,
    -0.022174891084432602, -0.017477592453360558, 0.015447854995727539, 0.0010029887780547142, -0.021996675059199333, -0.01497997622936964, -0.09242106974124908, -0.03413672000169754,
    -0.02683156542479992, 0.02332310378551483, -0.012226305902004242, -0.021100349724292755, -0.0024632583372294903, -0.023213984444737434, -0.026543622836470604, 0.03288054093718529,
    -0.030497007071971893, -0.01796555705368519, -0.07386887818574905, 0.059201065450906754, 0.09444544464349747, 0.05461537092924118, 0.020051050931215286, 0.039268624037504196,
    -0.021830789744853973, -0.020355816930532455, 0.03826536983251572, -0.00046245340490713716, -0.017995866015553474, 0.027004051953554153, 0.022844551131129265, -0.007281310390681028,
    -0.0030263718217611313, 0.09226346015930176, -0.030436445027589798, 0.055110424757003784, 0.019994555041193962, 0.028883449733257294, 0.05419895425438881, 0.03210144490003586,
    0.03625287860631943, -0.03115782141685486, -0.0018153690034523606, 0.06584805250167847, -0.026957284659147263, -0.014404026791453362, -0.05568068102002144, -0.0012743148254230618,
    0.04225493595004082, -0.06606822460889816, -0.008898945525288582, -0.1235857605934143, 0.05244694650173187, 0.05808964744210243, -0.01318117044866085, 0.010016110725700855,
    -0.014549966901540756, 0.02638811431825161, -0.004408036824315786, -0.012585438787937164, 0.008113577961921692, -0.03237542510032654, 0.02119138091802597, -0.027767756953835487,
    0.007338660303503275, 0.029332615435123444, 0.09602795541286469, -0.03230798617005348, 0.05561823770403862, 0.08865193277597427, 0.06117508187890053, 0.03593505918979645,
    0.04920186102390289, -0.04633907601237297, -0.05546692758798599, 0.019455166533589363, -0.03660708665847778, 0.04588865488767624, 0.034981876611709595, -0.023243935778737068,
    -0.009511650539934635, -0.0017429828876629472, -0.1054239422082901, 0.02724287658929825, -0.03905864432454109, 0.017773350700736046, 0.025636034086346626, -0.07221613824367523,
    -0.043157387524843216, 0.06547820568084717, 0.008572411723434925, -0.03404475748538971, 0.0002912931377068162, 0.0017727981321513653, 0.006754074711352587, 0.07384394109249115,
    -0.025208506733179092, -0.03906804323196411, -0.05526658892631531, 0.0436520092189312, 0.018128301948308945, -0.016212407499551773, 0.037973228842020035, -0.023030133917927742,
    0.03920092433691025, -0.018447190523147583, 0.02564917504787445, 0.027072524651885033, -0.02116304077208042, -0.009434564970433712, 0.010853013955056667, -0.053458813577890396,
    0.007062735967338085, 0.007307794410735369, -0.003009552601724863, -0.02546660602092743, 0.026107611134648323, 0.007873826660215855, 0.011471349745988846, -0.0035603782162070274,
    -0.015129453502595425, -0.007951421663165092, -0.00874593947082758, -0.007265465334057808, -0.05398895964026451, 0.012394298799335957, 0.010714774020016193, -0.05751959979534149,
    0.026774313300848007, 0.0008508813916705549, 0.025782166048884392, 0.028196541592478752, 0.024549176916480064, -0.014182217419147491, 0.039948806166648865, 0.009560679085552692,
    0.04634488373994827, -0.030322492122650146, -0.015083933249115944, 0.03566619008779526, 0.012545708566904068, 0.012053349986672401, 0.05226460099220276, -0.02023409865796566,
    0.03726235777139664, -0.015316723845899105, 0.09657277166843414, -0.03661305829882622, -0.08005582541227341, 0.010830973275005817, -0.01557094231247902, -0.01902998425066471,
    0.00459024403244257, -3.669491343316622e-05, -0.04239683598279953, -0.02844930998980999, 0.04265737161040306, -0.028614820912480354, 0.024912860244512558, 0.020825110375881195,
    -0.016383759677410126, -0.0663117989897728, -0.001487065339460969, -0.0026672459207475185, -0.0313008576631546, 0.02478903904557228, 0.005182826891541481, -0.08333653211593628,
    -0.029678234830498695, 0.023694708943367004, 0.02792501449584961, -0.04938482120633125, 0.1074671745300293, -0.0543048195540905, 0.020460866391658783, 0.012168736197054386,
    -0.00276958872564137, 0.010876425541937351, 0.06205899640917778, 0.08377344906330109, -0.05836738273501396, -0.04911123961210251, -0.0008645793423056602, -0.026490135118365288,
    -0.009437770582735538, -0.06673403084278107, 0.008609304204583168, -0.009613855741918087, -0.04906143993139267, 0.036242518573999405, 0.02710377797484398, -0.04514036700129509,
    0.05456662178039551, 0.00212039053440094, 0.05427068844437599, 0.07970691472291946, -0.0379721038043499, -0.038214992731809616, -0.0176466666162014, 0.05156250298023224,
    -0.056199707090854645, 0.004639090970158577, -0.07040800154209137, 0.02584940940141678, 0.005437896586954594, -0.00019199063535779715, 0.041632235050201416, -0.004469758830964565,
    -0.03381194919347763, 0.017659105360507965, 0.11359690129756927, -0.0047513642348349094, -0.015787528827786446, -0.010033324360847473, 0.007585953921079636, 0.04395170137286186,
    0.07466167211532593, -0.04996214807033539, -0.0625777617096901, -0.023714696988463402, -0.021651491522789, -0.032759297639131546, -0.02298372983932495, 0.011729211546480656,
    -0.07128220796585083, -0.0498996265232563, -0.02669239602982998, 0.004562544636428356, -0.02558685466647148, -0.013373136520385742, 0.002390125999227166, -0.07727795094251633,
    0.02247091755270958, 0.026592234149575233, -0.04613151401281357, -0.02490030974149704, 0.017854617908596992, 0.03871186822652817, 0.023996727541089058, 0.005056168884038925,
    0.04440449923276901, 0.006200358737260103, -0.0005220900638960302, 0.03736823797225952, 0.03314048424363136, -0.02803988754749298, -0.04192493483424187, 0.005546882748603821,
    -0.019238553941249847, 0.008298526518046856, 0.029773497954010963, -0.04140175133943558, -0.011702915653586388, -0.030156441032886505, -0.03508738428354263, 0.02890084497630596,
    -0.02455315552651882, -0.01611069031059742, 0.035462405532598495, -0.039136555045843124, -0.012231243774294853, 0.0005197732825763524, -0.055532656610012054, 0.007474762387573719,
    -0.06437167525291443, 0.0026842555962502956, -0.030523693189024925, -0.0476667582988739, -0.029161565005779266, -0.018499795347452164, -0.033217091113328934, -0.02608068473637104,
    0.04191794991493225, 0.013848849572241306, -0.07189124077558517, 0.03313671424984932, 0.0083775594830513, 0.021532731130719185, -0.01859661377966404, 0.00025100429775193334,
    -0.01898306794464588, -0.017963876947760582, 0.0066132089123129845, -0.0028805620968341827, 0.0024584573693573475, 0.019966214895248413, 0.011028275825083256, 0.0032670542132109404,
    0.03948575258255005, -0.0055676973424851894, 0.008248093537986279, -0.01448458805680275, -0.012370768934488297, 0.034409090876579285, 0.07204980403184891, -0.028367388993501663,
    0.0081256702542305, -0.017957888543605804, -0.002125502098351717, 0.018407462164759636, 0.010537643916904926, -0.02722862735390663, -0.066836416721344, -0.013540222309529781,
    0.037575192749500275, 0.00041133828926831484, -0.0022138473577797413, -0.004907675087451935, 0.07733304053544998, 0.02095777913928032, -0.012476223520934582, 0.02288200519979,
    -0.012575583532452583, 0.029591070488095284, -0.05715335160493851, -0.020778965204954147, -0.0458073690533638, -0.015915336087346077, 0.03839097544550896, 0.007303248159587383,
    -0.008155028335750103, 0.002927363384515047, 0.04391687363386154, 0.0031965014059096575, -0.027601191774010658, 0.004717334173619747, 0.01938597857952118, 0.047042518854141235,
    0.059178777039051056, 0.008455886505544186, -0.028258798643946648, -0.004635221790522337, -0.013818646781146526, -0.018372856080532074, -0.009159204550087452, 0.01245566550642252,
    -0.00015679554780945182, 0.00011608126806095243, 0.0716371163725853, 0.03386823832988739, 0.022575518116354942, -0.0027702362276613712, 0.024549273774027824, 0.0243462473154068,
    -0.045286789536476135, 0.034102387726306915, -0.03751170262694359, -0.028502793982625008, -0.019575946033000946, 0.0047435518354177475, 0.013736186549067497, 0.006256862543523312,
    -0.00799101684242487, -0.008305960334837437, -0.021719494834542274, -0.003659934736788273, -0.032299917191267014, -0.02462676912546158, 0.03882277011871338, -0.022755198180675507,
    -0.03418056666851044, 0.0070344856940209866, -0.054661963135004044, -0.027320148423314095, -0.015639830380678177, 0.008202587254345417, -0.04715646058320999, 0.007768637500703335,
    -0.035312775522470474, -0.01581028290092945, -0.0071306293830275536, 0.009739256463944912, 0.007521439343690872, -0.003999072127044201, -0.002296888269484043, -0.004974645096808672,
    -0.024476032704114914, 0.018585525453090668, 0.010721647180616856, -0.017993146553635597, -0.012074591591954231, 0.01526300236582756, 0.0036542867310345173, 0.002397808013483882,
    -0.030265608802437782, -0.008338254876434803, -0.00959922093898058, 0.0038450316060334444, 0.011835291981697083, 0.015837287530303, 0.0005483513814397156, -0.00277335150167346,
    0.007759888656437397, 0.029587063938379288, -0.0357707142829895, 0.015217793174088001, 0.033643338829278946, -0.025127172470092773, -0.038807451725006104, -0.039621759206056595,
    -0.01647796668112278, -0.0017233046237379313, 0.014695207588374615, 0.01576477289199829, -0.004094521515071392, -0.012538516893982887, -0.0140866469591856, 0.035720884799957275,
    -0.02456555888056755, -0.008331630378961563, 0.022224605083465576, -0.01731458120048046, 9.66196384979412e-05, 0.028439167886972427, -0.015643266960978508, -0.007428044453263283,
    0.015042467042803764, 0.041017867624759674, 0.013833488337695599, 0.02699390798807144, -0.06086492910981178, -0.0022845042403787374, 0.06776927411556244, -0.03252168744802475,
    -0.011422384530305862, 0.02044508419930935, -0.004914932884275913, -0.012528623454272747, -0.00948227196931839, 0.06340912729501724, -0.006016347091645002, 0.01629294641315937,
    0.03612317144870758, -0.020604601129889488, 0.003797889454290271, -0.024737173691391945, 0.02163761854171753, -0.0067801931872963905, 0.002510650549083948, 0.01060039084404707,
    0.0006281740497797728, -0.009787392802536488, 0.0079950001090765, 0.00064452103106305, -0.02656571753323078, -0.012796273455023766, 0.020078564062714577, -0.009406011551618576,
    0.014461452141404152, 0.00036348868161439896, -0.014403392560780048, -0.03854556381702423, -0.0004950512666255236, 0.021616537123918533, -0.013775215484201908, -0.027983786538243294,
    -0.03298438712954521, -0.014250589534640312, 0.021004773676395416, 0.00016253534704446793, 0.0038660531863570213, 0.01693505235016346, 0.002095939824357629, -0.00021481512521859258,
    0.033885303884744644, -0.03712920472025871, -0.005545156076550484, 0.028332935646176338, 0.021808592602610588, 0.008714020252227783, -0.003326861187815666, 0.026146072894334793,
    -0.006180187221616507, -0.04186190292239189, 0.003958971239626408, 0.0055432990193367004, 0.007045638747513294, -0.006789857987314463, 0.018310490995645523, -0.005549625959247351,
    0.015448703430593014, 0.005973498336970806, 0.005191733129322529, 0.0012277670903131366, 0.006735384929925203, -0.0017004815163090825, 0.008999373763799667, -0.0004038964107166976,
    -0.005269823595881462, -0.018093671649694443, 0.02488284558057785, 0.02752063423395157, -0.002166931750252843, 0.004801537841558456, -0.004597629886120558, -0.024127401411533356,
    -0.04632292687892914, 0.010588806122541428, 0.031122326850891113, -0.04341050237417221, -0.0011270481627434492, 0.002701964695006609, 0.01518746092915535, -0.02610304020345211,
    -0.014032023958861828, -0.018722830340266228, 0.02936759777367115, -0.0012086665956303477, -0.007499877363443375, -0.0288486760109663, 0.047058381140232086, 0.03174483776092529,
    0.013451769016683102, -0.008617102168500423, 0.029420390725135803, -0.006543672177940607, -0.008288444951176643, -0.0024063419550657272, 0.007264500483870506, -0.006661265157163143,
    -0.019849460572004318, 0.02111135795712471, -0.007965421304106712, -0.004620866850018501, 0.02391798235476017, 0.032535620033741, 0.0247606560587883, -0.011645916849374771,
    -0.017739281058311462, 0.008565321564674377, -0.0021685799583792686, -0.012155253440141678, 0.0008868171134963632, 0.030892500653862953, 0.019983526319265366, -0.03984507545828819,
    -0.02233305014669895, 0.004322619177401066, 0.02355244569480419, -0.005397539585828781, 0.011702285148203373, 0.01883583702147007, 0.01679595187306404, 0.0060006799176335335,
    0.03472352400422096, -0.012546208687126637, -0.01957741007208824, -0.017165960744023323, -0.004253495018929243, -0.03599008172750473, -0.024394255131483078, 0.00500088045373559,
    0.010267901234328747, 0.0021757357753813267, -0.017952408641576767, 0.021325353533029556, -0.002859287429600954, 0.030931903049349785, 0.012656671926379204, -0.018823914229869843,
    -0.004675436299294233, 0.0011288857785984874, 0.05101447552442551, 0.009328700602054596, -0.03780481219291687, -0.00887201726436615, 0.013701004907488823, -0.022742798551917076,
    0.01067014504224062, 0.01977953501045704, 0.001757710357196629, -0.008814182132482529, 0.002401375211775303, -0.029450586065649986, -0.006843134295195341, -0.023592082783579826,
    0.011850960552692413, -0.005467586684972048, -0.0015171446138992906, 0.031055079773068428, -0.026824206113815308, -0.007741452660411596, 0.004689962603151798, 0.007302066311240196,
    -0.027360886335372925, 0.04458867013454437, -0.03966716304421425, 0.010856786742806435, 0.001546255312860012, -0.03352533280849457, 0.011365989223122597, -0.009552519768476486,
    -0.023961128666996956, 0.022574184462428093, 0.017690015956759453, 0.0026878751814365387, -0.003691283753141761, -0.007725889328867197, 0.0224173441529274, 0.00795888714492321,
    0.008887900039553642, 0.013898143544793129, -0.012981289997696877, 0.0008000236703082919, -0.033212438225746155, 0.03185948729515076, 0.007392209023237228, 0.021771827712655067,
    -0.011875908821821213, -0.01630609855055809, -0.009869299829006195, 0.01146040577441454, -0.027858735993504524, -0.005209567956626415, -0.009160708636045456, -0.02996835671365261,
    0.005873693153262138, -0.0038544845301657915, 0.00538218067958951, -0.012604346498847008, -0.010706919245421886, 0.023296069353818893, 0.02967202477157116, -0.018489234149456024,
    0.033725183457136154, -0.004633658099919558, 0.02116328850388527, 0.02273673750460148, 0.003566688159480691, -0.026295628398656845, -0.03017004206776619, -0.0005976326647214592,
    0.007878408767282963, 0.002043412532657385, 0.006627644412219524, -0.0059460606426000595, -0.0045311362482607365, 0.0036899414844810963, -0.019375065341591835, -0.0037285240832716227,
    -0.02483667992055416, 0.007241113111376762, 0.009193425066769123, -0.02983037196099758, 0.0052672396413981915, -0.0008177430718205869, 0.030576732009649277, -0.01580244116485119,
    -0.027495000511407852, 0.012257160618901253, -0.03827439248561859, 0.02487882412970066, -0.021002447232604027, -0.013032237999141216, -0.002806702395901084, -0.03018598072230816,
    0.014319540932774544, 0.00032397540053352714, 0.003532619681209326, 0.00544426403939724, -0.0036727245897054672, 0.008808729238808155, -0.022111019119620323, 0.007880167104303837,
    -0.020951421931385994, 0.012394282966852188, -0.0134052075445652, 0.02290818654000759, 0.020604634657502174, 0.003262179670855403, 0.0029638579580932856, 0.01101487036794424,
    0.038849327713251114, -0.0030858279205858707, 0.03008190169930458, 0.014641287736594677, 0.006473754998296499, -0.006039435509592295, 0.02915576845407486, 0.01732156053185463,
    0.0006001847796142101, -0.013198724016547203, 0.06464075297117233, 0.0008381573716178536, 0.018104085698723793, -0.007539887446910143, -0.04364855960011482, 0.003119497559964657,
    0.001203471445478499, -0.012950432486832142, -0.014761658385396004, -0.014930465258657932, 0.02162434160709381, -0.015952447429299355, -0.006978881079703569, 0.01883368380367756,
    -0.004462871700525284, -0.018344011157751083, 0.011399582028388977, -0.022166626527905464, 0.0005603347672149539, -0.0010004203068092465, 0.021358460187911987, -0.00013537908671423793,
    -0.010611094534397125, -0.011420908384025097, 0.0169677771627903, 0.02768017165362835, 0.001941318972967565, 0.02242734469473362, -0.019883831962943077, 0.03842630609869957,
    -0.016531551256775856, 0.004575580358505249, -0.010483133606612682, 0.01293531246483326, -0.0015888786874711514, 0.01698487624526024, -0.004659717436879873, 0.01734551414847374,
    0.01162825059145689, -0.0028702730778604746, 0.02281668595969677, -0.029782161116600037, 0.004858155269175768, 0.003245019819587469, 0.030761543661355972, 0.02699180692434311,
    0.020730573683977127, -0.014892388135194778, -0.031406089663505554, 0.013043238781392574, -0.016355101019144058, -0.020322971045970917, 0.01852232590317726, 0.009383385069668293,
    0.014320814982056618, 0.013163541443645954, -0.021598372608423233, -0.0007978825597092509, 0.014068493619561195, -0.02522999607026577, -0.021377015858888626, -0.01165082398802042,
    0.012225020676851273, -0.008401482366025448, 0.00939168781042099, -0.011264958418905735, -0.01772943139076233, 0.009598111733794212, -0.011193996295332909, 0.013787063769996166,
    -0.030299650505185127, -0.004815112333744764, 0.02013922482728958, 0.013749218545854092, -0.014350214041769505, -0.023328667506575584, 0.0027879239059984684, 0.02562600187957287,
    0.013467060402035713, 0.008324678987264633, 0.01566508784890175, -0.0051681846380233765, 0.06128264218568802, -0.005017483606934547, -0.02471677027642727, 0.016533449292182922,
    0.0018759104423224926, -0.01871413178741932, 0.011930619366466999, -0.0013530644355341792, 0.00494937039911747, -0.005926515907049179, -0.00559212127700448, -0.0032097199000418186,
    -0.02024519257247448, -0.026765093207359314, -0.04549269378185272, -0.020747823640704155, 0.012455906718969345, -0.018723923712968826, -0.0036023538559675217, 0.004371641669422388,
    0.020933669060468674, -0.008596272207796574, -0.010744469240307808, -0.002723382320255041, -0.0035912205930799246, -0.021019458770751953, -0.004306865390390158, -0.014023439958691597,
    -0.018969595432281494, 9.301929094363004e-05, 0.002186581725254655, -0.031646858900785446, -0.009819813072681427, 0.016711916774511337, -0.022129826247692108, -0.015129460953176022,
    -0.011806824244558811, 0.007677529472857714, 0.008184107951819897, -0.010634844191372395, 0.004549064673483372, 0.025613103061914444, 0.06097792461514473, -0.014512698166072369,
    0.00396986398845911, 0.011996197514235973, -0.0414598174393177, 0.013145112432539463, -0.016960687935352325, -0.017030728980898857, -0.002818474778905511, -0.008466058410704136,
    0.028011124581098557, -0.01767897605895996, -0.012174759991466999, -0.008557154797017574, 0.038756322115659714, 0.0121498117223382, 0.006009803619235754, -0.020206008106470108,
    0.010278349742293358, -0.000863123161252588, -0.010061398148536682, -0.014400445856153965, 0.03507944568991661, 0.004042660351842642, 0.00481041707098484, -0.016771366819739342,
    -0.008751709945499897, 0.004591934848576784, 0.004939233884215355, 0.009414431639015675, 0.01872771419584751, -0.0017496702494099736, -0.0032556026708334684, 0.010655208490788937,
    -0.009408870711922646, -0.0113479970023036, 0.021545518189668655, 0.013090173713862896, -0.0006073588156141341, 0.005348070990294218, 0.02137143351137638, -0.017381472513079643,
    0.01374543085694313, -0.009211068972945213, 0.016321927309036255, 0.026428813114762306, 0.0020752965938299894, -0.006481531076133251, 0.0292899701744318, 0.006340374704450369,
    0.03302052244544029, 0.019043562933802605, 0.019088950008153915, -0.008678114041686058, -0.00026236739358864725, -0.012040897272527218, -0.02443579211831093, 0.012623458169400692,
    -0.009238190948963165, -0.013673662208020687, 0.019810909405350685, 0.007286116946488619, -0.004549745004624128, 0.000999764772132039, 0.018932517617940903, -0.006846706382930279,
    -0.002427679719403386, 0.010370980016887188, 0.011161302216351032, -0.011094181798398495, 0.0008948600152507424, 0.006366305984556675, -0.016538357362151146, 0.029826655983924866,
    -0.027848534286022186, 0.0008150901412591338, 0.019394343718886375, -0.006693541072309017, 0.010562963783740997, 0.0019357813289389014, -0.03256744518876076, -0.026865677908062935,
    0.005798096768558025, -0.024732394143939018, 0.0011933348141610622, 0.0022782415617257357, 0.0050000338815152645, 0.01342060137540102, 0.010175072588026524, -0.01801600307226181,
    -0.006783730816096067, -0.00891907699406147, 0.010540641844272614, 0.01732991822063923, 0.008589578792452812, -0.00873366929590702, 0.019613565877079964, 0.0021156498696655035,
    0.039604175835847855, -0.023627739399671555, -0.054914213716983795, -0.012057982385158539, -0.010926694609224796, -0.021298618987202644, 0.009638991206884384, 0.007406987249851227,
    -0.03247580677270889, 0.0006735061760991812, -0.012614745646715164, -0.008508626371622086, 0.009379491209983826, 0.020120467990636826, -0.021372584626078606, 0.00011226282367715612,
    0.009306961670517921, 0.01896047778427601, -0.01086850743740797, 0.015469557605683804, 0.028448881581425667, 0.009013279341161251, 0.004029884468764067, 0.006453605368733406,
    -0.004126609303057194, 0.008096006698906422, -0.01569906808435917, 0.01615430973470211, -0.038748905062675476, 0.004911432042717934, 0.026398053392767906, -0.007141909096390009,
    0.0003388457407709211, -0.015065153129398823, 0.018505869433283806, 0.008627909235656261, -0.01654621958732605, 0.00664242310449481, -0.020320028066635132, 0.025197122246026993,
    0.012578343041241169, -0.022190066054463387, 0.013071342371404171, 0.011722208932042122, 0.012374832294881344, 0.016098832711577415, 0.00916220247745514, -0.00470493920147419,
    -0.029023218899965286, 0.004014193080365658, -0.030335308983922005, -0.01565912552177906, 0.016282323747873306, -0.0004322436871007085, -0.0017381625948473811, 0.010249204933643341,
    0.031711433082818985, 0.0036291840951889753, -0.018402118235826492, -0.041464533656835556, -0.03352763503789902, 0.014688258990645409, 0.035764824599027634, -0.005614075344055891,
    0.001887189457193017, -0.026613106951117516, -0.01832195185124874, -0.018208015710115433, 0.006321564316749573, -0.012558361515402794, 0.005043997894972563, 0.013740289956331253,
    -0.020449675619602203, -0.029641281813383102, -0.011362195946276188, -0.020276255905628204, -0.021808860823512077, 0.008677483536303043, 0.004129043780267239, -0.01226500328630209,
    0.0006271094316616654, 0.015411018393933773, -0.0025795125402510166, 0.006330818869173527, 0.005270315334200859, 0.04086659848690033, 0.007542681880295277, -0.0031526442617177963,
    0.019633948802947998, 0.010233991779386997, 0.01691696047782898, -0.010228069499135017, 0.011966493912041187, -0.020892353728413582, -0.012794901616871357, 0.028673164546489716,
    0.003879312891513109, 0.0030815801583230495, 0.020235326141119003, 0.002376696327701211, 0.011131048202514648, -0.011125379242002964, 0.011756612919270992, -0.033287692815065384,
    0.03523341193795204, 0.00024533167015761137, 0.008284146897494793, -0.00806142296642065, 0.0147517379373312, -0.0021235961467027664, 0.0019184707198292017, 0.011124687269330025,
    -0.04505227506160736, 0.010394539684057236, 0.01697724498808384, 0.0005954577354714274, -0.008436550386250019, -0.02663087099790573, 0.015565883368253708, 0.004735677037388086,
    0.011925664730370045, 0.009746220894157887, -0.01247403770685196, -0.030945679172873497, -0.00588806439191103, 0.008519338443875313, 0.002150678774341941, -0.006888983771204948,
    -0.012051342986524105, 0.003916049841791391, 0.007806458510458469, 0.009528025053441525, 0.004412960726767778, 0.030576858669519424, 0.003418375737965107, -0.03092726692557335,
    0.03411335498094559, 0.0006554175051860511, 0.011488109827041626, -0.02359837293624878, -0.008160240948200226, -0.0030204192735254765, 0.006249760277569294, 0.029502980411052704,
    0.03555012866854668, -0.027916090562939644, 0.015956131741404533, -0.015044881030917168, -0.0071783848106861115, -0.012681069783866405, 0.0046484582126140594, -0.008593227714300156,
    0.002080701757222414, 0.0037797419354319572, -0.0036627871450036764, -0.01615576632320881, 0.0031102236825972795, -0.013497674837708473, 0.014702546410262585, 0.0074810367077589035,
    -0.013792912475764751, 0.012672613374888897, 0.02416827157139778, 0.01379319280385971, -0.00602518767118454, -0.008773814886808395, 0.005678157322108746, -0.035079117864370346,
    0.012276328168809414, 0.03881853073835373, 0.020180877298116684, -0.01738353632390499, -0.0027619150932878256, -0.00484423665329814, 0.011945848353207111, 0.010916581377387047,
    0.004108240827918053, 0.02336808852851391, 0.02062143385410309, -0.006026021204888821, -0.007832825183868408, -0.011961935088038445, 0.0068536922335624695, -0.006185637321323156,
    -0.024661915376782417, -0.0032631554640829563, -0.0034460292663425207, 0.0015306539135053754, 0.002365666441619396, -0.013077810406684875, -0.005097039509564638, -0.0014731013216078281,
    0.021720265969634056, 0.009306114166975021, 0.009656836278736591, -0.0011684505734592676, 0.005756012164056301, 0.0273646991699934, -0.008043727837502956, 0.0016820626333355904,
    -0.0024651663843542337, 0.009552745148539543, -0.012228063307702541, 0.005560647696256638, 0.0027061710134148598, -0.0070915548130869865, 0.004645270295441151, -0.0031185306143015623,
    -0.0004368101363070309, -0.006403651088476181, -0.011911102570593357, 0.020183194428682327, -0.0070878248661756516, -0.013171246275305748, -0.03329213336110115, -0.020828289911150932,
    0.00865163840353489, 0.02938295714557171, -0.02229004167020321, 0.007400985807180405, -0.0051566376350820065, 0.006801176816225052, 0.01829378865659237, -0.024297084659337997,
    -0.025030311197042465, -0.007439175620675087, 0.0252035204321146, 0.013451912440359592, 0.0001665545569267124, 0.009632090106606483, -0.013760261237621307, 0.005517562851309776,
    -0.0193982794880867, 0.007056144531816244, 0.006197100039571524, 0.008369282819330692, -0.018266770988702774, 0.022533617913722992, 0.0026999800466001034, 0.015672342851758003,
    0.014889747835695744, -0.01707090623676777, -0.005901894066482782, 0.013154120184481144, 0.02066725678741932, 0.010963951237499714, -0.031155239790678024, -0.007664967328310013,
    0.0013609761372208595, 0.02836332470178604, 0.014778402633965015, 0.006681349594146013, -0.0008877123473212123, 0.008825670927762985, -0.007968166843056679, -0.0007068808190524578,
    0.007941531017422676, -0.011915723793208599, -0.0036243468057364225, -0.01462895143777132, 0.01889796182513237, -0.004196201916784048, -0.026757504791021347, -0.005510232876986265,
    -0.008529877290129662, -0.0036756389308720827, 0.011098317801952362, -0.00047020873171277344, -0.024030355736613274, 0.0024916562251746655, -0.003690518904477358, -0.03323020413517952,
    0.004107442684471607, 0.03106108121573925, 0.0020273460540920496, 0.0020584226585924625, 0.0021151381079107523, 0.013825531117618084, -0.010364142246544361, 0.013423196040093899,
    0.019782058894634247, -0.04151713103055954, -0.014570217579603195, 0.0017684964695945382, -0.008180901408195496, 0.03449571877717972, -0.055868081748485565, 0.009215851314365864,
    0.007722486276179552, -0.011801501736044884, -0.022126875817775726, -0.027707597240805626, 0.014230968430638313, 0.021210072562098503, 0.02118472009897232, -0.0004977253265678883,
    -0.004769138526171446, -0.004714970476925373, 0.02833300642669201, 0.003465557238087058, -0.004959260579198599, -0.008453343994915485, 0.02328351140022278, -0.014295932836830616,
    0.018917694687843323, -0.012301018461585045, 0.013801174238324165, -0.023931683972477913, 0.01979457214474678, 0.024471241980791092, 0.017472486943006516, -0.007506063673645258,
    0.015065167099237442, 0.00611295597627759, 0.0004937179619446397, -0.008287385106086731, 0.012148262932896614, -0.0055374098010361195, 0.016647689044475555, 0.023235078901052475,
    -0.034981850534677505, 0.003652542596682906, -0.0246620774269104, -0.008137456141412258, 0.0024970192462205887, -0.018488069996237755, 0.007485116366297007, 0.0014675037236884236,
    0.011961783282458782, 0.008000527508556843, 0.04837678372859955, -0.026225652545690536, 0.018091006204485893, -0.0021854527294635773, 0.02269543893635273, -0.019606122747063637,
    0.03932604938745499, -0.00650274520739913, 0.008187316358089447, 0.0006069002556614578, -0.013067214749753475, -0.019088415428996086, 0.016796797513961792, 0.018518460914492607,
    0.008170763961970806, -0.019018732011318207, 0.001492928946390748, 0.0029234534595161676, -0.0206601545214653, 0.003809502348303795, -0.009623714722692966, 0.007065677084028721,
    0.010027863085269928, 0.005302418954670429, -0.009003467857837677, -0.019577980041503906, 0.007064704317599535, 0.0017771321581676602, -0.003985193092375994, -0.00379213597625494,
    0.0066346339881420135, -0.010943876579403877, 0.015253850258886814, 0.013925090432167053, 0.010074137710034847, -0.020074419677257538, -0.040419112890958786, 0.010649923235177994,
    -0.005980818532407284, 0.005856242962181568, 0.0389559231698513, 0.006688426248729229, 0.008587734773755074, -0.005407498683780432, 0.0012822606367990375, 0.015323084779083729,
    -0.0007365114288404584, -0.010806347243487835, 0.01949000358581543, 0.014074286445975304, 0.0018034314271062613, -0.0003993832506239414, -0.0034999775234609842, -0.003700537607073784,
    -0.02597229741513729, -0.02883959747850895, -0.05042005702853203, -0.0210257600992918, 0.002442957367748022, 0.019852209836244583, -0.008767922408878803, 0.005762679036706686,
    0.011390076018869877, -0.005350051913410425, -0.008002741262316704, 0.01739569380879402, 0.014460849575698376, 0.015114336274564266, 0.029477210715413094, 0.013032705523073673,
    0.006957174278795719, -0.015095754526555538, -0.023258958011865616, -0.009371955879032612, 0.012058611959218979, -0.014488359913229942, -0.01701325736939907, -0.029000628739595413,
    -0.019483990967273712, -0.004595795180648565, 0.0007908976403996348, 0.006196160800755024, -0.011172158643603325, -0.007082577794790268, 0.04353789612650871, -0.0034320037811994553,
    -0.018703941255807877, 0.0017393177840858698, 0.015793291851878166, 0.007739450316876173, 0.016328580677509308, -0.014503558166325092, -0.019196126610040665, 0.014141985215246677,
    0.0011513304198160768, 0.007675670552998781, -0.014620103873312473, 0.028686903417110443, 0.007565758191049099, 0.0005795616889372468, -0.0011737652821466327, 0.01943046972155571,
    -0.01314227469265461, 0.015816543251276016, -0.028498901054263115, 0.019961947575211525, -0.014800447039306164, -0.018182966858148575, 0.007820340804755688, -0.00913099106401205,
    0.0024369487073272467, -0.0010318997083231807, 0.015413939021527767, 0.016678843647241592, 0.011825698427855968, 0.008195632137358189, 0.011271407827734947, 0.054415926337242126,
    0.013333910144865513, -0.015282057225704193, -0.024981971830129623, 0.012106870301067829, 0.002015012316405773, 0.013296735472977161, 0.0019017677986994386, -0.0006788330501876771,
    0.019444946199655533, -0.01601051352918148, -0.01562290545552969, 0.009554139338433743, -0.004739562515169382, -0.0037387015763670206, 0.008423433639109135, 0.01026063971221447,
    0.012095248326659203, 0.01018227357417345, -0.031405773013830185, 0.013673215173184872, 0.010982821695506573, 0.007598197553306818, 0.017681431025266647, 0.005426401738077402,
    0.001147268689237535, 0.0010739408899098635, -0.01486142911016941, -0.0029761719051748514, 0.026738449931144714, -0.021740611642599106, -0.013313808478415012, -0.03274479880928993,
    0.0032669706270098686, -0.00571909174323082, 0.005658842157572508, 0.004519862122833729, 0.017712349072098732, 0.009992309845983982, 0.007468178868293762, 0.012063740752637386,
    0.030261190608143806, 0.0034650161396712065, 0.02969072014093399, 0.007675416301935911, 0.005859618075191975, -0.029676949605345726, 0.028919799253344536, -0.004030970856547356,
    0.004201025702059269, -0.005130298901349306, -0.013232621364295483, -0.014340141788125038, -0.015296459197998047, -0.007930348627269268, -0.011347931809723377, 0.005175215657800436,
    -0.0006768308812752366, -0.014757920056581497, 0.00010713237134041265, 0.01160421222448349, 0.00041714543476700783, -0.00608389638364315, -0.008197587914764881, -0.004656169097870588,
    0.01559216994792223, -0.00906657800078392, -0.03430736064910889, -0.0010231856722384691, -0.008628441952168941, -0.015598478727042675, 0.0028047426603734493, -0.015453427098691463,
    0.04092959687113762, 0.02145444229245186, -0.0009400650742463768, -0.0008606184273958206, 0.005956303793936968, -0.020396392792463303, -0.028548872098326683, -0.004218948073685169,
    0.04100729897618294, 0.012927013449370861, -1.786555367289111e-05, 0.0155673548579216, 0.002983677200973034, 0.009745048359036446, 0.006800783332437277, -0.008868684060871601,
    -0.003947006072849035, 0.03663907200098038, 0.011908557265996933, -0.005090602673590183, 0.012871377170085907, 0.04106269031763077, 0.028717245906591415, -0.009537721052765846,
    0.015209821052849293, -0.008510959334671497, 0.0011524970177561045, -0.016706157475709915, -0.030915765091776848, 0.0023169878404587507, -0.012980038300156593, -0.010448571294546127,
    -0.0036180727183818817, 0.014201359823346138, 0.021235762163996696, -0.013175474479794502, 0.002469234401360154, 0.014123452827334404, -0.016533225774765015, -0.007169357966631651,
    -0.01708647608757019, 0.006956975907087326, -0.0077987234108150005, -0.0021837742533534765, -0.019592203199863434, 0.026623157784342766, 0.001605586614459753, 0.022891124710440636,
    0.017409589141607285, -0.0010180000681430101, -0.020964452996850014, 0.009574147872626781, -0.011213444173336029, -0.03034305013716221, -0.005391836632043123, -0.01820567436516285,
    -0.0001816404255805537, -0.027457134798169136, -0.008134996518492699, -0.015129564329981804, -0.0064574652351439, 0.002054521581158042, 0.008370153605937958, -0.007490227930247784,
    0.003944984171539545, -0.009063003584742546, -0.03044590912759304, 0.023146864026784897, -0.02740888111293316, 0.005863443948328495, -0.0006563525530509651, 0.004378908313810825,
    -0.007256450597196817, 0.0035041216760873795, 0.00035948515869677067, 0.0121064567938447, -0.00911880936473608, 0.0014066437724977732, -0.006778351962566376, -0.011745205149054527,
    0.007678146008402109, 0.0010816346621140838, -0.014194834046065807, -0.009821427054703236, 0.02418314665555954, 0.005473673809319735, 0.01842241734266281, -0.02273748070001602,
    -0.001715542864985764, -0.0014379324857145548, -0.02341388911008835, 0.01035184133797884, -0.023230573162436485, -0.02581207826733589, 0.012505512684583664, -0.043947819620370865,
    0.00430286442860961, 0.014073877595365047, -0.020316964015364647, -0.012525388039648533, 0.018318498507142067, 0.025086427107453346, 0.004353317432105541, -0.0016514754388481379,
    -0.005344778764992952, -0.0016889332327991724, 0.004313962999731302, -0.0039068409241735935, -0.009016984142363071, -0.004693787079304457, 0.014100111089646816, -0.005520689766854048,
    0.015794159844517708, -0.0040855794213712215, 0.006795824039727449, -0.024688953533768654, -0.0013678950490429997, -0.005446606781333685, 0.012032712809741497, -0.01978851482272148,
    -0.009060855954885483, 0.021856697276234627, 0.03556369990110397, -0.029494252055883408, 0.006927959155291319, 0.002043089596554637, 0.02181335538625717, 0.002401787554845214,
    0.0012620233464986086, -0.006164222024381161, -0.0029219379648566246, 0.007190773729234934, -0.0024340974632650614, 0.017876040190458298, 0.03067023865878582, -0.017682058736681938,
    0.019433224573731422, -0.0269892830401659, -0.004999578930437565, -0.010801717638969421, -0.0026534278877079487, 0.011738959699869156, 0.01081337034702301, -0.003636057721450925,
    0.003396518062800169, -0.00763051537796855, -0.005953815765678883, 0.011516361497342587, 0.021851297467947006, -0.025044888257980347, -0.03383312001824379, 0.016027605161070824,
    -0.0004022633074782789, 0.0209172535687685, -0.022438233718276024, 0.024292977526783943, -0.006280530244112015, 0.004438532050698996, 0.002313873264938593, -0.0080591244623065,
    0.013622530736029148, -0.006950603798031807, 0.011987454257905483, -0.0046326834708452225, 0.005010936409235001, -0.007862278260290623, 0.013643188402056694, 0.00037797537515871227,
    0.021535079926252365, -0.003448065370321274, 0.004454861860722303, 0.006545483134686947, -0.009153753519058228, -0.004490461200475693, -0.00475590955466032, -0.02606148086488247,
    0.011620759963989258, 0.007429732009768486, -0.011965787969529629, -0.011627528816461563, -0.00673694396391511, -0.006530262995511293, 0.020323902368545532, 0.0028782961890101433,
    -0.026608340442180634, -0.023266371339559555, 0.002045644912868738, 0.0028560105711221695, 0.003953180741518736, -0.02211078442633152, -0.006216803099960089, 0.009075027890503407,
    -0.019247863441705704, -0.0029161751735955477, -0.004921778570860624, 0.006309415679425001, 0.01874452829360962, -0.00313135446049273, -0.004232441540807486, -0.012560269795358181,
    -0.028994012624025345, 0.010371727868914604, 0.006091361399739981, 0.0009566278313286602, 0.0008338791667483747, -0.024944409728050232, -0.006392346229404211, 7.309658394660801e-05,
    -0.0034609411377459764, -0.02239917777478695, 0.014393463730812073, 0.008884049952030182, -0.016885599121451378, 0.019754847511649132, 0.0188481155782938, -0.000174902452272363,
    0.0007164956186898053, 0.008692005649209023, -0.012643326073884964, -0.015453812666237354, -0.0006036302074790001, 0.008733661845326424, -0.0292188823223114, 0.01803584210574627,
    -0.01172235794365406, -0.007553992792963982, 0.014391579665243626, 0.009578574448823929, -0.015848636627197266, -0.008564714342355728, -0.012730926275253296, -0.010446915403008461,
    0.012288755737245083, 0.0045448364689946175, 0.05111328884959221, 0.0020241059828549623, 0.013057229109108448, 0.033000148832798004, -0.00742722861468792, 0.015557573176920414,
    -0.007861076854169369, -0.008892347104847431, 0.0027623139321804047, -0.0009736453648656607, -0.007213192991912365, -0.013665327802300453, -0.004717347677797079, 0.019527342170476913,
    -0.007308387663215399, 0.0038896105252206326, -0.010097524151206017, -0.0025490610860288143, -0.02431599609553814, 0.0023924147244542837, 0.015265978872776031, -0.005538247991353273,
    -0.012729352340102196, -0.000306915637338534, -0.0004813620471395552, -0.027453919872641563, 0.008929976262152195, 0.022008448839187622, -0.01260710321366787, -0.007960444316267967,
    -0.02927815541625023, 0.031596824526786804, 0.024612080305814743, 0.009589526802301407, 0.019085122272372246, 0.001956891966983676, -0.028742389753460884, 0.0165510606020689,
    -0.01612910069525242, -0.009794771671295166, 0.016062943264842033, -0.010416348464787006, -0.018216552212834358, 0.011324545368552208, 0.0025912916753441095, -0.02834601141512394,
    -0.022022899240255356, -0.023291094228625298, 0.009798316285014153, 0.005098977591842413, 0.011949513107538223, -0.01747765764594078, 0.001030698767863214, 0.02269686385989189,
    0.0031622652895748615, -0.017626525834202766, -0.011138182133436203, 0.006397174671292305, 0.00459087872877717, 0.01675395853817463, -0.0185382142663002, 0.024117639288306236,
    0.021804682910442352, -0.0029388247057795525, 0.012647099792957306, 0.0062244306318461895, -0.013097552582621574, 0.019898714497685432, 0.015004563145339489, 0.01559392362833023,
    0.008707620203495026, -0.02053930051624775, 0.02221766486763954, -0.005666722077876329, -0.026992928236722946, -0.012736362405121326, 0.0009526035282760859, 0.018515635281801224,
    -0.022644424811005592, 0.03249900043010712, -0.04210125282406807, 0.011772090569138527, -0.010679056867957115, -0.011399329639971256, 0.010404139757156372, 0.004646054469048977,
    -0.006378329824656248, 0.007809728849679232, -0.0055858539417386055, 0.014691490679979324, 0.0046911840327084064, 0.00108170451130718, 0.008551801554858685, 0.01689377799630165,
    0.03407420963048935, -0.015794724225997925, 0.014622674323618412, 0.035231638699769974, 0.004123632330447435, -0.007074843160808086, 0.009088424034416676, 0.0057947575114667416,
    -0.01972517929971218, -0.0018876964459195733, 0.01045089028775692, -5.715670340578072e-05, -0.010594626888632774, -0.004032117314636707, -0.040087707340717316, -0.0015250783180817962,
    0.033637382090091705, 0.013543123379349709, -0.0006650106515735388, 0.016322525218129158, 0.016949698328971863, -0.005372802261263132, 0.026279190555214882, -0.008892353624105453,
    0.02867034822702408, -0.003518239827826619, 0.007127020042389631, 0.012894876301288605, 0.014558198861777782, -0.011617499403655529, 0.01875891163945198, 0.006231986451894045,
    0.003988813608884811, -0.0066132927313447, -0.01824432983994484, -0.013897526077926159, -0.005199079867452383, -0.03992793336510658, 0.012914225459098816, 0.01740729995071888,
    0.031895898282527924, -0.0005856489297002554, 0.016544712707400322, -0.009834874421358109, 0.005039695650339127, 0.01175014115869999, -0.013756261207163334, -0.013411902822554111,
    -0.015452555380761623, -0.013205788098275661, -0.005449250340461731, -0.009229359216988087, -0.009598476812243462, -0.0035029808059334755, -0.008526287972927094, -0.029945168644189835,
    -0.006346260663121939, 0.014176295138895512, -0.0021881749853491783, 0.010206942446529865, -0.01339689176529646, -0.014482144266366959, 0.0032279540318995714, -0.010950340889394283,
    -0.02953692525625229, -0.0035570862237364054, -0.01609545573592186, -0.0023455482441931963, -0.004039271734654903, -0.015724902972579002, 0.01001757849007845, -0.040050629526376724,
    -0.010790267027914524, 0.01349192950874567, 0.001393166952766478, 0.012158656492829323, 0.0405803807079792, -0.009026833809912205, -0.013721868395805359, -0.002153563778847456,
    0.01507682166993618, 0.01559727918356657, 0.0025442775804549456, -0.014813956804573536, 0.01966528780758381, 0.008542760275304317, -0.006933026947081089, -0.022932143881917,
    0.009008663706481457, -0.0022114692255854607, 0.018359335139393806, -0.014021161943674088, 0.040224380791187286, 0.00669130589812994, 0.009482224471867085, -0.0069639552384614944,
    0.012133707292377949, 0.0010392689146101475, -0.010456189513206482, -0.01643431931734085, 0.013832122087478638, -0.00031373780802823603, 0.0013841860927641392, -0.007520629093050957,
    -0.014232675544917583, 0.004444094840437174, -0.004416236653923988, -0.012943829409778118, -0.007484930567443371, -0.04237375408411026, 0.032437514513731, 0.017182156443595886,
    0.021969426423311234, 0.013846793211996555, -0.010190465487539768, -0.011786812916398048, 0.006551981903612614, 0.004778578877449036, 0.003756812075152993, -0.019428784027695656,
    -0.009307821281254292, 0.026549534872174263, 0.01699915900826454, -0.009115721099078655, -0.02134265936911106, -0.005260693375021219, 0.020091891288757324, 0.006473298650234938,
    0.011028776876628399, 0.011156601831316948, -0.0014398162020370364, -0.03651103749871254, 0.009070347063243389, 0.016923805698752403, -0.0017377574695274234, 0.006801954936236143,
    0.003760715713724494, -0.004306127317249775, 0.02371964044868946, -0.010343692265450954, 0.021169044077396393, 0.005730718839913607, -0.005592240020632744, -0.002811382059007883,
    -0.009429490193724632, -0.01894453354179859, -0.013526924885809422, -0.012370350770652294, 0.0039060155395418406, -0.01025468297302723, 0.002802412724122405, 0.010982695035636425,
    -0.011725490912795067, -8.396033808821812e-05, -0.007304321508854628, -0.0018431742209941149, -0.010213395580649376, -0.014456246048212051, -0.017032401636242867, -0.0014117287937551737,
    -0.012060124427080154, -0.01472211442887783, 0.018579190596938133, -0.0036131679080426693, -0.007341846823692322, 0.02190282754600048, 0.006540638394653797, -0.018706388771533966,
    0.010269573889672756, -0.01129824761301279, 0.02453472837805748, -0.011929409578442574, 0.005189996212720871, -0.005828785710036755, 0.0015912816161289811, 0.005836427677422762,
    0.008334049955010414, 0.010693415999412537, 0.0001717717241263017, -0.00975492037832737, -0.0021592562552541494, 0.005845889449119568, 0.0024111687671393156, 0.008890118449926376,
    0.008899505250155926, -0.012419368140399456, 0.013930118642747402, -0.021515989676117897, -0.012749251909554005, -0.004721501376479864, 0.0031783850863575935, 0.011050991714000702,
    -0.0027103316970169544, 0.01827184110879898, -0.0027458895929157734, -0.023145651444792747, 0.020187601447105408, -0.00723388371989131, 0.0003910039959009737, -0.0014815315371379256,
    0.014367317780852318, 0.0030253881122916937, 0.002153475070372224, 0.00285961851477623, 0.0023801797069609165, 0.0038818034809082747, 0.016691183671355247, 0.025916216894984245,
    -0.013528396375477314, -0.0041212099604308605, -0.00687499949708581, -0.005079006310552359, -0.005851968191564083, 0.007773926015943289, -0.010549146682024002, 0.029429087415337563,
    -0.0009678324568085372, 0.008553797379136086, 0.007306496147066355, -0.007477470673620701, 0.0131759662181139, 0.008855792693793774, -0.02521841786801815, 0.0029237105045467615,
    -0.016742467880249023, 0.008022494614124298, -0.010527411475777626, 0.015417182818055153, -0.009452374652028084, -0.014035586267709732, -0.009653029032051563, 0.0404435433447361,
    0.032454781234264374, 0.011764995753765106, -0.011854822747409344, -0.007280982099473476, 0.007560207974165678, 0.0077721611596643925, -0.0241522379219532, -0.01029276754707098,
    -0.04126954451203346, -0.025113239884376526, -0.01309388317167759, 0.015517701394855976, -0.012189360335469246, -0.011647596023976803, -0.009120767936110497, 0.028332578018307686,
    0.023990964516997337, -0.0015768419252708554, -0.0354531891644001, -0.013825718313455582, 0.008732794784009457, 0.0012460635043680668, -0.00698366854339838, -0.007879951037466526,
    -0.0037688836455345154, 0.011079478077590466, -0.025362590327858925, -0.013393392786383629, 0.014886449091136456, -0.031924787908792496, 0.0050823804922401905, -0.01876767724752426,
    0.010445901192724705, 0.050999440252780914, -0.011976810172200203, 0.0027001798152923584, 0.006931619253009558, -0.007993164472281933, 0.01902943290770054, -0.012663614936172962,
    -0.0037106212694197893, 0.021281199529767036, 0.026600884273648262, 0.011236215941607952, -0.004775606095790863, -0.019568830728530884, 0.003356435801833868, 0.004674025345593691,
    0.0015223943628370762, -0.002073075622320175, 0.010563713498413563, -0.004243060946464539, 0.008263400755822659, 0.006767284590750933, -0.007694206666201353, 0.024461213499307632,
    0.006643122062087059, 0.014232243411242962, 0.01427547074854374, -0.0038508926518261433, 0.0166190043091774, 0.001257017021998763, -0.008681955747306347, 0.015222105197608471,
    -0.017078014090657234, 0.011612975038588047, -0.015706976875662804, -0.005256820935755968, -0.007880598306655884, 0.007657929789274931, -0.012461823411285877, 0.006784122437238693,
    0.019884714856743813, -0.0073640309274196625, -0.0017639010911807418, 0.006859489716589451, 0.003210746916010976, -0.027059538289904594, 0.001439864980056882, 0.012564494274556637,
    0.0013937070034444332, 0.02059621922671795, -0.006011086981743574, -0.01625906117260456, 0.009285083040595055, 0.014359715394675732, 0.008859438821673393, 0.013049020431935787,
    0.026429034769535065, 0.004041728097945452, 0.01750148832798004, 0.016968516632914543, -0.02645106613636017, 0.03290541097521782, -0.020283887162804604, 0.015341048128902912,
    0.00678877392783761, 0.0253143273293972, -0.013769147917628288, 0.009448699653148651, -0.031802963465452194, 0.0005842598620802164, -0.03738465905189514, 0.004082410130649805,
    0.014144564978778362, 0.0019883436616510153, 0.018013155087828636, -0.013546641916036606, -0.02074410393834114, -0.017157675698399544, 0.014426814392209053, -0.014694063924252987,
    0.004463146440684795, -0.017509641125798225, -2.2999749944574432e-06, 0.025379694998264313, -0.020214056596159935, -0.004623066633939743, -0.041411127895116806, 0.014429714530706406,
    0.0332762710750103, -0.03332490473985672, 0.03328099474310875, 0.006019146181643009, -0.02245255745947361, 0.002795641077682376, 0.0029894232284277678, 0.0035485196858644485,
    0.010075213387608528, -0.009697658941149712, -0.0008007889264263213, -0.02000053972005844, -0.015690527856349945, 0.011440937407314777, 0.01463659480214119, -0.025055378675460815,
    0.0003337740199640393, 0.016523834317922592, -0.015796907246112823, -0.0008075397345237434, 0.0018990993266925216, 0.011588601395487785, 0.022280428558588028, -0.005448818672448397,
    -0.006267466116696596, -0.002965132240206003, -0.026879429817199707, 0.012047754600644112, 0.02192174457013607, -0.0010388921946287155, 0.010132825002074242, 0.01915489137172699,
    0.007747613824903965, 0.0015341035323217511, -0.008785480633378029, 0.010349114425480366, 0.004264512564986944, 0.016777919605374336, 0.0025647091679275036, 0.004732802975922823,
    -0.006213534623384476, 0.012379132211208344, 0.005008770618587732, 0.00629543187096715, -0.0040715159848332405, 0.008141526952385902, -0.001622284878976643, 0.014221720397472382,
    -0.013096820563077927, -0.014503789134323597, -0.022731507197022438, 0.011849112808704376, 0.023374343290925026, 0.007674341555684805, 0.008874021470546722, 0.00012618197069969028,
    -0.0019682475831359625, -0.00029807008104398847, 0.013145274482667446, 0.025502869859337807, 0.007961627095937729, 0.007442548405379057, 0.015196682885289192, -0.005390266887843609,
    0.004911681637167931, 0.016439586877822876, -0.017605334520339966, 0.007332500535994768, 0.0054793572053313255, -0.019207864999771118, -0.01395645271986723, -0.011598614975810051,
    0.029486732557415962, -0.015819843858480453, 0.0027780248783528805, -0.0014635900733992457, -0.001117484294809401, 0.006036583799868822, -0.0007381063769571483, -0.023276014253497124,
    -0.03545866534113884, -0.008264807052910328, 0.0004958786303177476, 0.017841462045907974, -0.0010677030077204108, 0.021701283752918243, 0.004467339720577002, 0.010227152146399021,
    -0.013173205778002739, 0.002399814547970891, -0.02726311981678009, 0.019402047619223595, -0.023464664816856384, 0.0023351083509624004, -0.006049010902643204, 0.00033189301029779017,
    -0.03044520877301693, -0.013697637245059013, -0.0003070309176109731, -0.010624035261571407, 0.019940797239542007, -0.015325060114264488, 0.006234370172023773, 0.013643655925989151,
    0.005477885715663433, -0.0024715461768209934, 0.003105983603745699, -0.007974041625857353, 0.018398143351078033, -0.012745157815515995, -0.024141788482666016, 0.029182350262999535,
    -0.002634544624015689, -0.0009587733657099307, -0.008961576968431473, -0.030331287533044815, 0.01115378923714161, -0.004417544696480036, -0.010198745876550674, -0.007741180248558521,
    0.003888500854372978, 0.01067232247442007, -0.009088201448321342, -0.010366447269916534, 0.01098665501922369, 0.011471838690340519, -0.0015497507993131876, 0.02959183230996132,
    -0.007863566279411316, 0.0021564210765063763, 0.0005650112289004028, -0.016470009461045265, -0.0023085481952875853, 0.01071585901081562, -0.008050360716879368, 0.0027584724593907595,
    -0.011173057369887829, 0.008066441863775253, 0.005681107752025127, -0.004860737826675177, 0.006779412738978863, -0.027229152619838715, 0.009473972022533417, -0.002002656226977706,
    0.010990098118782043, -0.01084044948220253, 0.004848862998187542, -0.004183577373623848, 0.004158670082688332, -0.0033434107899665833, -0.005540620069950819, 0.0061713471077382565,
    0.0062065403908491135, -0.008407321758568287, 0.013687011785805225, -0.0070863100700080395, -0.02047734707593918, 0.005908224266022444, 0.012455201707780361, 0.01907402276992798,
    0.019113890826702118, -0.0013923341175541282, 0.020276719704270363, 0.002892317483201623, 0.007407359313219786, 0.026721088215708733, 0.006317139137536287, 0.006651301868259907,
    0.02453901618719101, -0.014800528064370155, 0.00902300514280796, -0.006824195850640535, 0.02226739563047886, -0.005777192767709494, -0.017560023814439774, -0.04481717571616173,
    -0.00898223090916872, -0.012622787617146969, 0.030606497079133987, -0.006148840766400099, 0.01620274968445301, -0.018168959766626358, 0.015036674216389656, -0.011371515691280365,
    -0.019774746149778366, -0.00010954556637443602, 0.012815238907933235, -0.010407992638647556, -0.006992255337536335, 0.02128497138619423, -0.006649946328252554, 0.036916401237249374,
    0.010845989920198917, -0.01632722094655037, 0.015301981940865517, -0.01052443590015173, 0.0010928873671218753, 0.010149113833904266, 0.008830219507217407, 0.016322782263159752,
    0.0015003700973466039, -0.012870554812252522, 0.006412321235984564, -0.043365076184272766, 0.00025061771157197654, -0.0018102606991305947, 0.010281450115144253, -0.0029275226406753063,
    -0.0026611953508108854, -0.020962132140994072, -0.012424520216882229, -0.0007356010610237718, 0.008093764074146748, 0.00032477499917149544, 0.011543598026037216, 0.007992204278707504,
    -0.004480259958654642, -0.0019702683202922344, 0.004851418547332287, -0.028163203969597816, -0.01663726009428501, 0.014788644388318062, 0.011431902647018433, -0.02442109026014805,
    0.019261561334133148, -0.008157446049153805, -0.010956439189612865, 0.002443804871290922, -0.007920697331428528, -0.00288509507663548, 0.022654157131910324, -0.015179690904915333,
    -0.0028905903454869986, -0.008722970262169838, -0.0004313050885684788, 0.007063661701977253, -0.003456482430920005, -0.010443903505802155, -0.008700446225702763, -0.00929957814514637,
    0.007286675274372101, 0.003345099277794361, 0.0005518114776350558, 0.01147305965423584, 0.01287219300866127, 0.0070632752031087875, -0.006434271112084389, 0.00202778447419405,
    0.016150927171111107, 0.01457266416400671, 0.021928012371063232, 0.024212995544075966, -0.017642280086874962, -0.013783592730760574, 0.013994262553751469, 0.0065503790974617004,
    0.0032871633302420378, 0.0005423275870271027, -0.009669460356235504, -0.019019583240151405, 0.022254042327404022, -0.004068142268806696, -0.01332912128418684, -0.0057710749097168446,
    0.0111409742385149, -0.006444211583584547, -0.0077395751141011715, 0.020466983318328857, 0.021609481424093246, -0.015678467229008675, -0.014939358457922935, 0.01875382848083973,
    -0.009718389250338078, -0.004827135242521763, 0.019404467195272446, 0.003549262648448348, -0.0004404385108500719, 0.004438530188053846, -0.002757040085271001, -0.0009616691968403757,
    0.011436423286795616, 0.0036314346361905336, -0.008712085895240307, -0.017700951546430588, -0.000929072848521173, -0.010295582935214043, 0.03961871191859245, -0.012443043291568756,
    -0.03922165185213089, 0.01046798750758171, -0.012561801820993423, -0.0010988496942445636, -0.009770713746547699, -0.023235324770212173, 0.027842000126838684, 0.0028437278233468533,
    0.005809456575661898, 0.0005798296188004315, 0.015610410831868649, -0.005257976241409779, 0.02896128222346306, 0.01925913244485855, 0.006610641721636057, -0.0026973190251737833,
    0.006933145225048065, 0.013213480822741985, -0.011823759414255619, 0.00698610907420516, -0.0038889737334102392, 0.02192784659564495, -0.01947890780866146, 0.013038072735071182,
    0.010495242662727833, -0.002656130352988839, -0.015263889916241169, -0.022214097902178764, -0.029666718095541, 0.004474852699786425, -0.008662930689752102, -0.008122777566313744,
    -0.013860308565199375, 0.007641182746738195, -0.030802207067608833, 0.009322562254965305, -0.006541613955050707, 0.022210141643881798, 0.000296358804916963, -0.013399491086602211,
    -0.04006968066096306, 0.00647118641063571, 0.016552433371543884, -0.010685568675398827, -0.007928146980702877, 0.001304613659158349, -0.024546507745981216, 0.01856163516640663,
    0.039523568004369736, -0.005131921265274286, -0.008021253161132336, 0.0019838756415992975, -0.019942589104175568, 0.00018540477321948856, -0.005351671017706394, -0.0208695437759161,
    0.0028607745189219713, -0.009134870953857899, -0.001265431521460414, 0.01588931307196617, 0.0110354358330369, -0.00847718957811594, -0.004127162508666515, 0.005399029701948166,
    0.009308270178735256, 0.006630475167185068, 0.028811298310756683, 0.004384334199130535, -0.0068434434942901134, -0.011143126524984837, 0.00380320125259459, -0.0024062476586550474,
    0.008128277026116848, -0.011031590402126312, 0.008526203222572803, 0.001566559774801135, -0.022642960771918297, -0.0017775309970602393, 0.01219342090189457, -0.01754673570394516,
    0.009777556173503399, -0.010077030397951603, 0.007040871307253838, -0.028256304562091827, -0.02109304629266262, -0.005668268073350191, 0.006554295774549246, -0.0021218613255769014,
    0.016028819605708122, -0.02643350325524807, -0.011606300249695778, 0.004336989484727383, 0.02176753617823124, 0.011049103923141956, -0.004392110276967287, -0.0008146546897478402,
    0.007309132721275091, -0.012785691767930984, 0.016983114182949066, 0.02937174215912819, -0.025249572470784187, -0.004220918752253056, -0.015411979518830776, 0.02004626765847206,
    0.02601001225411892, 0.003133644349873066, -0.012542388401925564, 0.0010145454434677958, -0.04114655777812004, -0.025409018620848656, 0.006681003607809544, -0.04502466693520546,
    0.027911169454455376, 0.014091214165091515, -0.03964461013674736, -0.002322735730558634, 0.0042176819406449795, -0.028089387342333794, -0.0063863168470561504, 0.004577619023621082,
    -0.00033179024467244744, 0.009855592623353004, 0.03894763067364693, -0.0013500569621101022, -0.021058721467852592, 0.004551676567643881, -0.035407789051532745, -0.003052967367693782,
    0.04327186197042465, -0.007837123237550259, -0.052251916378736496, -0.004815859720110893, -0.002030047122389078, -0.000538327032700181, -0.017831185832619667, -0.01678038388490677,
    0.024297473952174187, 0.019250480458140373, 0.004502910189330578, -0.008685209788382053, -0.008869750425219536, 0.0014526075683534145, 0.001269024913199246, -0.012528524734079838,
    -0.03337812423706055, -0.01834416575729847, -0.011617595329880714, -0.020707156509160995, 0.010175764560699463, -0.03755994886159897, 0.029434939846396446, -0.02831059694290161,
    0.04333943501114845, 0.007772226817905903, -0.005516462028026581, 0.01328328438103199, 0.04763010889291763, 0.003637295216321945, -0.01476012822240591, 0.0017781968927010894,
    -0.01288224570453167, -0.006634312681853771, -0.01173429936170578, -0.009600312449038029, -0.02131681516766548, -0.032808344811201096, 0.02230723202228546, 0.030717646703124046,
    0.05550292506814003, -0.005645638797432184, -0.006365087348967791, -0.010409877635538578, 0.004389239940792322, -0.015731172636151314, 0.02050614356994629, -0.029328931123018265,
    -0.05115484446287155, 0.010391410440206528, 0.03349805623292923, -0.02533762715756893, 0.002728354884311557, -0.0009223799570463598, -0.011274627409875393, 0.004619439132511616,
    0.009288757108151913, 0.02214318886399269, -0.019886769354343414, 0.009098725393414497, 0.002756399568170309, 0.006314178463071585, 0.011336700059473515, 0.005461625289171934,
    0.006642682943493128, -0.025556111708283424, -0.028892848640680313, 0.012976249679923058, 0.012441325932741165, 0.007146842777729034, -0.005283661652356386, -0.013386178761720657,
    -0.004718472249805927, -0.008197443559765816, -0.003718504449352622, 0.008478942327201366, 0.03053979203104973, -0.024041762575507164, -0.04940823093056679, 0.016986366361379623,
    -0.030052270740270615, 0.009958083741366863, -0.02198510803282261, -0.009652364999055862, 0.001393833663314581, -0.012750650756061077, -0.04551583155989647, -0.015628619119524956,
    -0.008596116676926613, -0.018038786947727203, 0.021422188729047775, -0.018289383500814438, 0.0027129200752824545, 0.006618112325668335, 0.018802540376782417, 0.020130325108766556,
    0.0017047605942934752, -0.010057949461042881, -0.014913903549313545, 0.0020389114506542683, -0.008023417554795742, -0.007312570232897997, 0.02504330314695835, 0.008138556964695454,
    -0.005906867329031229, 0.013964456506073475, -0.017460722476243973, 0.008716152980923653, 0.0011371104046702385, -0.019789891317486763, -0.0010677992831915617, 0.013233483768999577,
    0.0331961065530777, -0.006592290475964546, 0.021344972774386406, -0.019004520028829575, -0.006285625044256449, 0.005217495374381542, -0.0009900229051709175, -0.014645105227828026,
    -0.009632454253733158, 0.01412525586783886, 0.0028615857008844614, -0.006197827868163586, -0.00024026763276197016, 0.00016983396199066192, 0.021200135350227356, 0.004407127853482962,
    -0.03889056667685509, 0.009729751385748386, 0.005008551757782698, -0.002252155914902687, -0.000753886008169502, 0.00411040335893631, 0.03687285631895065, -0.031130094081163406,
    -0.0024506363552063704, 0.015679210424423218, 0.007290505804121494, 0.002927940571680665, 0.03699590638279915, -0.027618376538157463, 0.011607484892010689, -0.06546458601951599,
    0.0032249758951365948, 0.039047207683324814, 0.0078119500540196896, 0.017089875414967537, -0.005160963162779808, 0.0006487887003459036, -0.003468158422037959, 0.017960257828235626,
    -0.03588687255978584, -0.008604193106293678, -0.01313475426286459, 0.0023839555215090513, -0.009289033710956573, 0.02749367244541645, 0.018158506602048874, -0.016036437824368477,
    0.008616581559181213, 0.03800144046545029, -0.028538398444652557, 0.013498781248927116, 0.01602957956492901, 0.009850128553807735, -0.023961234837770462, -0.007495373487472534,
    -0.04402533918619156, 0.009541015140712261, 0.017826249822974205, -0.0004859667969867587, 6.232497980818152e-05, -0.0132716940715909, -0.014743606559932232, 0.000890512834303081,
    0.01853296160697937, -0.012241183780133724, 0.01737380400300026, 0.008278612978756428, -0.007022727746516466, 0.0002114243252435699, -0.01648765243589878, -0.0018247293774038553,
    -0.00399358943104744, -0.0036070174537599087, 0.00070680130738765, 0.01245749182999134, -0.0136563116684556, -0.021293219178915024, 0.0008535295492038131, -0.019856099039316177,
    0.003561383346095681, -0.005786665249615908, 0.008908209390938282, 0.003047878621146083, -0.013197039254009724, 0.0093808239325881, -0.013154012151062489, 0.03549855574965477,
    0.03880196437239647, -0.0027134132105857134, -0.01106572337448597, 0.007188794668763876, -0.0342443473637104, 0.0020357908215373755, -0.02320261485874653, -0.014541028998792171,
    0.007747114636003971, -0.0009652800508774817, -0.004638074431568384, -0.011328835971653461, 0.051867637783288956, -0.022924019023776054, 0.010006867349147797, 0.004031480755656958,
    0.015067444182932377, -0.010214307345449924, -0.012316087260842323, 0.029489045962691307, -0.0016307099722325802, 0.004281505476683378, -0.0020951812621206045, 0.0028302136342972517,
    0.0061546796932816505, -0.007808910682797432, 0.01467216107994318, -0.010570559650659561, 0.02153267338871956, -0.0018471956718713045, -0.01563621684908867, 0.004784142132848501,
    -0.011437742039561272, -0.024419352412223816, 0.0022580623626708984, 0.009549418464303017, 0.009515909478068352, 0.019664054736495018, -0.010001089423894882, 0.04138992726802826,
    -0.02001912333071232, -0.0005522079882211983, -0.026937110349535942, 0.006265699863433838, -0.0024341668467968702, -0.02544654905796051, 0.022087061777710915, 0.027215199545025826,
    0.01668515056371689, 0.010315774008631706, -0.002979239681735635, -0.01409988198429346, -0.003474416444078088, 0.0030523163732141256, 0.005360432900488377, 0.015570146031677723,
    0.015551222488284111, -0.03725537657737732, -0.004677289631217718, 0.006984791252762079, -0.026933442801237106, -0.015425032936036587, -0.006002599373459816, 0.014080648310482502,
    0.024263791739940643, 0.006081562489271164, 0.006340613588690758, 0.0029043967369943857, 0.021022075787186623, -0.010162019170820713, -0.04363160952925682, -0.009444265626370907,
    -0.0045194970443844795, -0.017497975379228592, 0.06845124810934067, -0.0105113685131073, 0.006903655827045441, 0.018059737980365753, -0.005822526291012764, -0.0019639269448816776,
    -0.01163067389279604, -0.00200466625392437, 0.010103940032422543, -0.011918053962290287, -0.0011447813594713807, 0.007081069517880678, -0.02554313838481903, 0.009531835094094276,
    -0.0031673857010900974, -0.019333699718117714, 0.017692308872938156, 0.0007627446320839226, 0.007469470147043467, 0.023603547364473343, 0.019774705171585083, 0.015731962397694588,
    -0.027613595128059387, 0.0017257550498470664, 0.0027762113604694605, -0.005959958769381046, -0.004635637626051903, -0.001918457099236548, -0.02357853576540947, 0.002643598709255457,
    0.012618683278560638, -0.020599091425538063, -0.043963219970464706, -0.0068488651886582375, -0.017902018502354622, 0.012533176690340042, 0.03134981170296669, 0.015166026540100574,
    0.020625753328204155, -0.008955935016274452, -0.013759691268205643, 0.003317768219858408, 0.008479833602905273, 0.00961569044739008, 0.005296358373016119, -0.0006636238540522754,
    0.008766398765146732, 0.024630259722471237, 0.011006101965904236, -0.004253496881574392, -0.030089721083641052, 0.019639933481812477, 0.008693262934684753, -0.015723029151558876,
    0.008584335446357727, 0.021081093698740005, -0.0028082048520445824, -0.011056710034608841, 0.007702439557760954, 0.03852115944027901, 0.01948676072061062, -0.01479177176952362,
    0.011760478839278221, 0.0003771460324060172, -0.002951753092929721, 0.016065657138824463, -0.07734207808971405, 0.02361329458653927, 0.004435165319591761, 0.006241767201572657,
    0.00047438780893571675, 0.008122118189930916, -0.02257768251001835, -0.007611920591443777, 0.009586988016963005, -0.0159910935908556, 0.0029226779006421566, -0.012498010881245136,
    -0.021575937047600746, 0.004192200489342213, -0.012002073228359222, -0.024474428966641426, 0.015437008813023567, -0.026040341705083847, -0.012589850462973118, -0.011647289618849754,
    -0.0156406257301569, 0.012869942001998425, -0.005177835933864117, 0.007249216083437204, -0.011151296086609364, -0.019048988819122314, 0.006506698206067085, -0.01177709735929966,
    0.04172279313206673, 0.030528122559189796, -0.007470494601875544, -0.001457259408198297, 0.0069843316450715065, 0.004366391338407993, -0.011051524430513382, -0.023798435926437378,
    -0.022097710520029068, -0.006242838222533464, -0.004519368056207895, -0.00752014946192503, -0.008018664084374905, 0.0010504957754164934, -0.008401861414313316, 0.028866484761238098,
    0.03464331850409508, -0.01593001000583172, 0.0037328144535422325, -0.014741440303623676, 0.0415070541203022, 0.0067710005678236485, 0.006912021432071924, -0.013975583016872406,
    -0.016416719183325768, -0.01945505104959011, -0.003989064134657383, -0.010908366180956364, -0.004623076878488064, -0.019184399396181107, 0.003773377975448966, -0.025546854361891747,
    -0.004550816025584936, -0.03183528035879135, -0.05000168830156326, -0.0031439578160643578, 0.003524666652083397, -0.03342708572745323, 0.017054500058293343, 0.008277465589344501,
    0.027996057644486427, 0.0010987612185999751, 0.013429485261440277, 0.011553047224879265, 0.01747526228427887, -0.015733879059553146, 0.02749972604215145, -0.005527202505618334,
    0.010070190764963627, 0.021682413294911385, -0.059338077902793884, -0.005194981582462788, -0.024796195328235626, -0.03513290733098984, -0.017897970974445343, 0.0015738134970888495,
    0.033672090619802475, -0.004035775549709797, -0.013984596356749535, 0.02438005618751049, 0.0020941677503287792, 0.0034336999524384737, 0.0027055013924837112, -0.02145071141421795,
    -0.040081147104501724, 0.002022011671215296, 0.012447777204215527, 0.011496222577989101, 0.0062963152304291725, -0.009638656862080097, -0.02521437592804432, -0.0009579892503097653,
    -0.0046922750771045685, 0.011934496462345123, 0.024020662531256676, -0.020105186849832535, -0.01738007925450802, -0.007445429917424917, -0.0254240520298481, -0.021610548719763756,
    -0.01874472387135029, -0.019868798553943634, -0.012104806490242481, 0.004180413205176592, -0.008574758656322956, -0.0075015537440776825, 0.008005303330719471, 0.009500830434262753,
    -0.0001307634374825284, -0.02845565415918827, -0.029327282682061195, 0.013880513608455658, 0.011556241661310196, -0.011208354495465755, 0.005538593977689743, -0.003688932629302144,
    -0.022653453052043915, 0.010656113736331463, 0.008138585835695267, -0.0067242830991744995, 0.0743994265794754, -0.034341104328632355, -0.029785193502902985, -0.01948893815279007,
    -0.011418487876653671, -0.0043936846777796745, 0.03566870465874672, -0.013049964793026447, -0.010068072937428951, 0.011228306218981743, -0.012984044849872589, -0.015890754759311676,
    0.0156087726354599, -0.006350500043481588, -0.014296354725956917, -0.004652347881346941, -0.030063863843679428, -0.004585854709148407, -0.008406275883316994, 0.005583301652222872,
    0.01511496864259243, 0.0009969978127628565, 0.013887100853025913, 0.012202599085867405, 0.006307815667241812, 0.007495650555938482, -0.025866638869047165, 0.007600008975714445,
    -0.027607666328549385, -0.0249183252453804, 0.021278096362948418, -0.024270378053188324, 0.000408784399041906, 0.00672423979267478, 0.011302012018859386, -0.013722348026931286,
    -0.03401859104633331, 0.0039156777784228325, -0.011824790388345718, 0.004761067684739828, -0.005385228432714939, 0.002975611248984933, -0.008096793666481972, -0.0038349174428731203,
    -0.023854603990912437, -0.009730709716677666, -0.015518959611654282, -0.010748134925961494, -0.013928652741014957, -0.007194625213742256, 0.002239665947854519, 0.020273923873901367,
    -0.0026399854104965925, 0.024473169818520546, 0.013364101760089397, 0.007232166826725006, -0.01443242747336626, 0.0065972525626420975, 0.029645537957549095, -0.018988564610481262,
    0.013742517679929733, -0.0038945942651480436, 0.02075134590268135, -0.0013043055078014731, 0.011127586476504803, 0.011511251330375671, -0.021463140845298767, 0.023929649963974953,
    -0.015474234707653522, 0.011102939024567604, -0.016432618722319603, 0.006459369789808989, 0.0035539218224585056, 0.022008737549185753, -0.02975449152290821, -0.03307732567191124,
    -0.01460824441164732, -0.019575228914618492, -0.016043411567807198, 0.01600969210267067, 0.029973136261105537, 0.02877536416053772, 0.0059970347210764885, -0.001863903715275228,
    -0.01616867259144783, -0.002507384167984128, 0.012598789297044277, 0.018787892535328865, 0.0028143790550529957, 0.003832218935713172, -0.014014455489814281, 0.020255418494343758,
    0.01454553846269846, 0.010322924703359604, -0.01922254078090191, -0.007080530282109976, -0.009477578103542328, 0.00856041256338358, 0.006683330982923508, -0.014722589403390884,
    0.009161879308521748, -0.007193054538220167, -0.02629466913640499, -0.0016146370908245444, 0.011074662208557129, -0.015207271091639996, 0.0029856027103960514, -0.0035011207219213247,
    -0.0077085234224796295, -0.004032755736261606, 0.00746409734711051, 0.01795981451869011, -0.003129045944660902, 0.0021687932312488556, -0.012338723987340927, 0.002222261857241392,
    -0.010703862644731998, 0.02263634093105793, 0.004201678093522787, -0.007305806968361139, -0.00804805662482977, 0.01012942660599947, -0.038647521287202835, -0.00411094818264246,
    0.03893181309103966, -0.0016169127775356174, 0.0001999305241042748, -0.02778872661292553, 0.0033950929064303637, -0.03695482388138771, -0.00530939782038331, 0.013618097640573978,
    0.009980734437704086, 0.019240878522396088, -0.008942549116909504, 0.017316926270723343, 0.01355066429823637, -0.0069757732562720776, -0.01138382963836193, -0.0018308899598196149,
    -0.01688021793961525, -0.016992568969726562, 0.02719222567975521, 0.03031017631292343, 0.012966644950211048, 0.012762252241373062, 0.015561512671411037, 0.017336826771497726,
    0.0031060432083904743, -0.00441844342276454, -0.018148010596632957, -0.009212855249643326, -0.020232511684298515, 0.005040498450398445, -0.0009176357998512685, 0.008103188127279282,
    0.02286943793296814, 0.00853334553539753, -0.005116104613989592, 0.010150673799216747, -0.0087871253490448, -0.012382842600345612, 0.009158916771411896, 0.023539787158370018,
    0.027650680392980576, -0.005644133314490318, -0.024543551728129387, -0.03525310754776001, 0.002844216302037239, 0.004890103358775377, -0.005052870139479637, -0.012630338780581951,
    0.013589272275567055, -0.019646665081381798, 0.00968047697097063, 0.010310369543731213, -0.009312113747000694, -0.005304396152496338, 0.0037871694657951593, -0.003471048315986991,
    0.015873705968260765, -0.004491166677325964, 0.017078280448913574, -0.013394624926149845, 0.009285718202590942, -0.002124397549778223, -0.02752896584570408, -0.008682090789079666,
    -0.0010456787422299385, -0.0027295206673443317, -0.005636509507894516, -0.006991085596382618, 0.0010418846504762769, 0.001947801560163498, -0.011174284853041172, 0.04518871009349823,
    0.0062454682774841785, -0.005088491830974817, -0.002771488856524229, -0.013875729404389858, -0.002213492291048169, 0.023265643045306206, -0.004397616721689701, 0.0010372871765866876,
    0.00915655680000782, 0.019615208730101585, -0.011944223195314407, -0.005308177322149277, 0.035053856670856476, 0.001875805202871561, -0.01262407936155796, -0.024398602545261383,
    -0.008672356605529785, 0.027269799262285233, 0.01990494504570961, -0.03709350898861885, -0.0005216195713728666, -0.0034947346430271864, -0.03665011003613472, -0.010026711039245129,
    -0.017041165381669998, -0.012055328115820885, 0.013469506986439228, 0.00046413257950916886, 0.017525389790534973, 0.00032950929016806185, -0.0021680034697055817, 0.05687838792800903,
    -0.01700718142092228, 0.010158203542232513, -0.015541973523795605, 0.02646280638873577, -0.008050858043134212, -0.01031965110450983, -0.018441148102283478, -0.009294449351727962,
    -0.024007931351661682, 0.005242065526545048, -0.008681774139404297, -0.018229369074106216, 0.005190837662667036, 0.008286251686513424, 0.004192157182842493, 0.03190441057085991,
    0.022320041432976723, 0.023373112082481384, -0.0022402936592698097, 0.002003343543037772, -0.007504070643335581, 0.015268182381987572, -0.021721359342336655, 0.009668107144534588,
    -0.024769334122538567, 0.00973835401237011, -0.010879945009946823, 0.010062068700790405, -0.026403920724987984, 0.028553970158100128, -0.0035268317442387342, -0.015061156824231148,
    -0.014564858749508858, -0.028740933164954185, 0.018865469843149185, -0.017455780878663063, -0.03696129471063614, -0.008307227864861488, -0.013461469672620296, 0.01065835915505886,
    0.001016413327306509, 0.010590440593659878, -0.024985380470752716, -0.01016806997358799, 0.011954249814152718, -0.027440575882792473, -0.035970740020275116, 0.0015837769024074078,
    0.0062982551753520966, 0.02347167581319809, -0.01835489273071289, 0.0170771311968565, -0.0022617860231548548, 0.024216335266828537, -0.0008262878400273621, 0.013005982153117657,
    -0.017467694357037544, -0.0115936528891325, 0.002856339793652296, 0.00402767164632678, 0.011071328073740005, 0.010062330402433872, -0.026578374207019806, -0.026613706722855568,
    0.025198156014084816, -0.025872603058815002, -0.03337881714105606, -0.02627282775938511, -0.009954784996807575, -0.0033822450786828995, -0.026432225480675697, 0.02255210652947426,
    -0.002937386278063059, -0.007505600806325674, -0.01486777514219284, -0.02505611442029476, 0.020808085799217224, -0.004154564347118139, -0.013549408875405788, 0.006663646548986435,
    -0.021842265501618385, -0.03073839843273163, -0.006557409185916185, -0.0011503002606332302, -0.0029273603577166796, -0.009311317466199398, -0.0007639173418283463, 0.0006957890000194311,
    0.0050424858927726746, -0.0073590329848229885, -0.034866467118263245, 0.010072244331240654, -0.003680113237351179, -0.017168423160910606, 0.025642521679401398, -0.01103117410093546,
    -0.004227448254823685, -0.004483953583985567, 0.003807182190939784, 0.0008546127355657518, 0.024562297388911247, 0.022122783586382866, 0.007038378156721592, 0.01415118109434843,
    0.004006716422736645, -0.0209959764033556, 0.008112641051411629, 0.0012157660676166415, -5.1086673920508474e-05, -0.01855144277215004, -0.006010796409100294, -0.009254096075892448,
    0.020365256816148758, -0.014381814748048782, 0.00828467309474945, -0.022254876792430878, -0.007241133600473404, -0.020366879180073738, -0.0024173434358090162, 0.0074258046224713326,
    -0.0028635987546294928, -0.0047459676861763, -0.03294478729367256, -0.026116954162716866, -0.02181737869977951, -0.0041765496134757996, -0.0021613389253616333, 0.0005686042713932693,
    0.028578445315361023, -0.003752676071599126, -0.019640078768134117, -0.013622662052512169, 0.005275630857795477, -8.045593131100759e-05, 0.016618750989437103, 0.0064293998293578625,
    0.01085669919848442, -0.026502203196287155, 0.0016713126096874475, 0.004119458608329296, -0.0022968139965087175, -0.01776224374771118, 0.029188739135861397, -0.01457445789128542,
    -0.006952350027859211, -0.007730535231530666, -0.0059506455436348915, -0.002445678925141692, -0.00549361202865839, -0.01026061736047268, 0.009810689836740494, -0.012714503332972527,
    0.03052701987326145, -0.010974694043397903, -0.017548026517033577, -0.007312112953513861, 0.014117597602307796, -0.009226968511939049, -0.012122462503612041, 0.009669137187302113,
    0.022728439420461655, 0.04501839727163315, 0.00207821954973042, 0.021708134561777115, 0.0007286237669177353, 0.02088131383061409, -0.016754457727074623, 0.024452826008200645,
    0.029363753274083138, 0.013768387958407402, 0.007005804218351841, -0.024220703169703484, 0.007685645949095488, 0.014806222170591354, -0.009478025138378143, 0.012974496930837631,
    0.003643450327217579, -0.027596788480877876, 0.01694602333009243, 0.008447292260825634, 0.009294497780501842, 0.03646697476506233, 0.006541588809341192, -0.004054144024848938,
    -0.00919785350561142, 0.013061968609690666, 0.022014886140823364, -0.005613240879029036, 0.011593812145292759, -0.0012033366365358233, 0.007003486156463623, 0.005028801970183849,
    -0.014873976819217205, 0.02132044918835163, -0.0461808517575264, -0.007880588993430138, -0.0025442177429795265, -0.0018967908108606935, 0.016448330134153366, -0.030879313126206398,
    -0.039386626332998276, -0.0053042396903038025, 0.007231138180941343, 0.02569618821144104, -0.0028646723367273808, 0.026920093223452568, 0.03135816007852554, 0.01705082133412361,
    -0.0007821121835149825, 0.0025567200500518084, -0.0356699600815773, 0.0013628832530230284, -0.023737464100122452, 0.02904359996318817, 0.0006020210566930473, 0.05631071701645851,
    0.007611296605318785, 0.005775158293545246, 0.018024837598204613, -0.0007350332452915609, -0.022788576781749725, 0.020736999809741974, -0.04403001815080643, 0.01889052242040634,
    -0.014110571704804897, 0.01683986932039261, 0.0014670571545138955, 0.006539619527757168, -0.00844106450676918, -0.03601311147212982, -0.030156850814819336, -0.009344481863081455,
    -0.022573411464691162, 0.0008121771970763803, -0.015212688595056534, 0.006675485521554947, 0.024336108937859535, 0.014726518653333187, 0.01485940720885992, -0.022965941578149796,
    0.00379133690148592, 0.01118893176317215, -6.75053961458616e-05, 0.010688984766602516, 0.012253688648343086, 0.005343745928257704, 0.011432639323174953, 0.009230433031916618,
    0.011841719970107079, -0.007037427742034197, -0.006279352121055126, 0.0397479310631752, -0.00922483578324318, 0.02111195959150791, -0.03754732757806778, 0.01035456545650959,
    -0.019485371187329292, -0.011663800105452538, -0.004221783485263586, 0.021581312641501427, -0.012528733350336552, -0.003976811189204454, -0.005190302152186632, -0.005361038260161877,
    0.008173391222953796, 0.027982937172055244, -0.004546443000435829, 0.00189999642316252, 0.0022586514241993427, -0.014630191028118134, -0.018120955675840378, 0.0012578355381265283,
    0.0007773707038722932, 0.013510284945368767, 0.005902174394577742, -0.01671537570655346, 0.00884085800498724, -0.011105909943580627, 0.04375707730650902, -0.006364756263792515,
    -0.006136940326541662, 0.0066719213500618935, 0.010089997202157974, -0.020365919917821884, 0.005397929344326258, -3.968225428252481e-05, 0.000959376513492316, -0.006420431658625603,
    -0.003940501715987921, -0.019127460196614265, 0.0048981052823364735, -0.004769145976752043, 0.0007005449733696878, -0.034679312258958817, 0.019658636301755905, -0.01003650575876236,
    -0.012826480902731419, -0.024359004572033882, -0.006967774126678705, 0.024611622095108032, 0.0007060570060275495, -0.022495273500680923, 0.012036489322781563, -0.01013308297842741,
    -0.0002002832479774952, 0.016005175188183784, -0.001826300984248519, 0.006137669552117586, -0.0031871944665908813, 0.016488201916217804, -0.051879361271858215, -0.03013615682721138,
    -0.006438414566218853, -0.022325992584228516, 0.022015981376171112, 0.017456533387303352, -0.01840011030435562, 0.030392436310648918, 0.010827344842255116, -0.026499588042497635,
    -0.01228499785065651, -0.00041460938518866897, -0.020016858354210854, -0.00772818922996521, -0.02476884424686432, 0.009269343689084053, -0.01974850706756115, 0.0014227721840143204,
    0.029194634407758713, -0.005035530310124159, -0.0057724895887076855, 0.008782943710684776, -0.013583184219896793, -0.006467806175351143, 0.0012629448901861906, -0.03660166263580322,
    -0.013351191766560078, -0.005075044929981232, 0.005817762576043606, -0.01100644376128912, 0.029641611501574516, -0.0408170223236084, 0.01819082535803318, -0.05260058119893074,
    -0.0169951431453228, -0.01751055009663105, 0.015772420912981033, -0.008432024158537388, -0.009822377935051918, -0.052928730845451355, 0.023119725286960602, 0.013575752265751362,
    -0.006681141909211874, -0.005016907583922148, -0.0057128677144646645, 0.03601409122347832, 0.008675813674926758, -0.009279798716306686, -0.020162265747785568, 0.0036805716808885336,
    0.013951011002063751, 0.019447224214673042, -0.007333604618906975, -0.0029726652428507805, 0.033597979694604874, -0.006784593220800161, 0.016608521342277527, 0.007787060458213091,
    0.02270994521677494, 0.022561222314834595, -1.958765096787829e-05, -0.023299135267734528, -0.0024003542494028807, -0.026837587356567383, -0.007195573765784502, -0.017711160704493523,
    -0.027384115383028984, -0.010816631838679314, -0.005487161688506603, -0.03385631740093231, 0.012842535972595215, 0.010227319784462452, 0.010136442258954048, -0.004760083742439747,
    -0.026192933320999146, -0.010054442100226879, -0.04077349975705147, 0.027817990630865097, 0.0049158185720443726, -0.01842130720615387, 0.025600817054510117, -0.01412375457584858,
    0.004643617197871208, -0.024620728567242622, -0.0007455521845258772, -0.011165600270032883, -0.00978935044258833, -0.009863507933914661, -0.011513224802911282, 0.024364778771996498,
    0.017767732962965965, 0.016442734748125076, 0.021758202463388443, 0.015887385234236717, -0.0406426265835762, 0.010328357107937336, -0.04545768350362778, 0.013842985033988953,
    0.023591646924614906, -0.0029030938167124987, -0.0033000281546264887, -0.01545174140483141, 0.02570827305316925, 0.0021013307850807905, 0.005442831665277481, 0.013539756648242474,
    0.0005969250341877341, -0.018111050128936768, 0.01734556257724762, 0.03234428912401199, -0.017687426880002022, 0.028729237616062164, -0.008448218926787376, 0.014083235524594784,
    -0.014874611049890518, 0.01749628409743309, 0.005943525582551956, 0.00015272825839929283, -0.0039208149537444115, -0.02067294903099537, -0.003236467484384775, -0.00851382315158844,
    -0.00532931974157691, -0.0011138833360746503, 0.007526556495577097, -0.016310980543494225, 0.018219029530882835, 0.009550985880196095, 0.013206008821725845, 0.014452891424298286,
    0.0029501542448997498, 0.003942795563489199, -0.017681507393717766, 0.006128295324742794, 0.014049981720745564, -0.03625653311610222, -0.015020271763205528, 0.014326225966215134,
    -0.023708952590823174, -0.002036617137491703, -0.03253079950809479, -0.0033646016381680965, 0.008498303592205048, -0.0042517832480371, 0.0046553658321499825, -0.0008256877190433443,
    -0.0417182631790638, -0.03251061961054802, -0.02739478461444378, -0.0090898172929883, -0.009538572281599045, 0.0001922366936923936, 0.03709530830383301, 0.031692687422037125,
    0.00405691796913743, 0.008103190921247005, 0.02050059102475643, 0.011362940073013306, -0.029157346114516258, 0.047124288976192474, -0.026708019897341728, 0.06543034315109253,
    0.01900951936841011, 0.02062610536813736, -0.00016561601660214365, 0.006127345375716686, 0.018583102151751518, -0.0027880968991667032, -0.0025921014603227377, 0.007264607585966587,
    0.008913161233067513, 0.006118795834481716, -0.008975312113761902, -0.019282367080450058, -0.00855192355811596, 0.010438492521643639, -0.026193000376224518, 0.002926293760538101,
    -0.02938922494649887, -0.012988587841391563, -0.007719654589891434, 0.006506650242954493, -0.005713562481105328, -0.007027976680546999, -0.005280594807118177, -0.026081038638949394,
    0.005198406055569649, -0.040664687752723694, 0.023878617212176323, 0.04794555902481079, 0.005277501884847879, 0.005899317562580109, -0.01839633285999298, 0.025568954646587372,
    0.005836775992065668, 0.015837840735912323, -0.00520189618691802, 0.010563836432993412, -0.005499938037246466, 0.02057199738919735, -0.014789107255637646, 0.021099844947457314,
    -0.003918514121323824, -0.009582026861608028, -0.012191670015454292, 0.022876648232340813, 0.0006862490554340184, 0.028885457664728165, -0.00034672842593863606, 0.030083300545811653,
    -0.010686561465263367, 0.028409330174326897, 0.026661604642868042, 0.029432887211441994, 0.012361333705484867, 0.00022957158216740936, -0.017893295735120773, -0.044023096561431885,
    -0.00048348421114496887, 0.02471087872982025, 0.008392620831727982, -0.014425140805542469, 0.021039489656686783, -0.019634388387203217, 0.05927739292383194, -0.0022833647672086954,
    -0.0012807768071070313, 0.015012693591415882, -0.03211263567209244, -0.015496086329221725, -0.014084599912166595, -0.030864255502820015, -0.0035011451691389084, 0.005586717743426561,
    0.01651751436293125, 0.02943992242217064, 0.014912454411387444, -0.004760999698191881, 0.005277807358652353, -0.02381109446287155, -0.019860167056322098, -0.00017695750284474343,
    -0.009135613217949867, 0.01831270195543766, 0.0206573735922575, -0.006662394385784864, -0.007326924707740545, -0.000802395457867533, 0.0028163609094917774, 0.02720906399190426,
    0.026322655379772186, -0.005443633068352938, 0.030434947460889816, -0.021176954731345177, -0.029040679335594177, -0.04064301773905754, 0.0034770662896335125, 0.044077686965465546,
    -0.00796492025256157, -0.009676487185060978, 0.00585204130038619, -0.02516109123826027, -0.008120404556393623, -0.006755399983376265, -0.01089283637702465, -0.0118873817846179,
    0.034128863364458084, -0.00850685779005289, -0.034121427685022354, -0.023295706138014793, 0.00852743349969387, 0.0010342608438804746, -0.02475452981889248, 0.017709586769342422,
    0.03365614265203476, 0.018497901037335396, 0.023133544251322746, -0.00505466852337122, 0.02182779647409916, 0.004731170367449522, -0.016307026147842407, -0.03385502099990845,
    0.021437346935272217, -0.0478561632335186, -0.0054119485430419445, 0.011960802599787712, 0.019736899062991142, -0.00452805869281292, -0.01606639474630356, -0.009561154060065746,
    0.018299346789717674, 0.030538106337189674, 0.041211508214473724, -0.0002630058443173766, 0.01192231010645628, -0.00867257360368967, -0.00048618996515870094, 0.0049737379886209965,
    -0.031815677881240845, -0.0059269145131111145, 0.009770126082003117, -0.011142647825181484, 0.030331529676914215, 0.030736232176423073, -0.02255665883421898, -0.007665057200938463,
    0.0070718866772949696, 0.022820916026830673, 0.01787058636546135, -0.0007004854269325733, -0.011469385586678982, -0.000169658349477686, 0.0032568182796239853, -0.01830408349633217,
    -0.02716253139078617, 0.0762769877910614, 0.0001971233286894858, -0.030113499611616135, -0.002987042535096407, 0.0036728554405272007, -0.017905699089169502, -0.023245248943567276,
    0.006561773829162121, -0.008351029828190804, 0.028271052986383438, -0.013331044465303421, -0.0030552134849131107, 0.011847350746393204, 0.0015975846908986568, 0.0014844911638647318,
    -0.006698248907923698, 0.005539471283555031, 0.005708049982786179, -0.013415495865046978, 0.0010302858427166939, 0.0035082984250038862, 0.0017802733927965164, -0.012379913590848446,
    0.03761269524693489, -0.016200337558984756, -0.02364279329776764, -0.003313038730993867, 0.017723623663187027, -0.006942477542907, 0.0019688974134624004, 0.000615993223618716,
    0.006386073771864176, -0.021076682955026627, 0.0012303611729294062, -0.00023103046987671405, 0.02297462709248066, 0.021253246814012527, -0.004859347362071276, 0.0035089680459350348,
    -0.0013102091616019607, -0.006026522256433964, 0.017174094915390015, 0.043278008699417114, 0.015881691128015518, 0.04357990622520447, 0.011242831125855446, 0.018547946587204933,
    -0.007980137132108212, -0.006484794430434704, -0.021503886207938194, 0.013706564903259277, -0.03455619886517525, 0.01962316408753395, -0.036885809153318405, -0.00885170977562666,
    0.020003842189908028, 0.00113719142973423, -0.01390100084245205, -0.03150254860520363, -0.001294367597438395, -0.01841825060546398, -0.027121584862470627, -0.009101120755076408,
    -0.03386574238538742, 0.0014609221834689379, 0.004005868453532457, 0.030892441049218178, 0.006184773053973913, 0.04216722026467323, -0.03327036276459694, -0.027503851801156998,
    0.001930167549289763, 0.002693590009585023, 0.03208861127495766, 0.01034848764538765, 0.00010012779239332303, 0.007776693906635046, -0.013554328121244907, 0.00598653731867671,
    -0.033377714455127716, 0.004147242289036512, -0.058572057634592056, 0.020568499341607094, -0.032293692231178284, 0.0055829440243542194, 0.018865196034312248, 0.02309241332113743,
    -0.04459431767463684, 0.004885687958449125, -0.011623325757682323, 0.0011524329893290997, -0.007335924543440342, 0.008375323377549648, 0.007642400451004505, 0.005901162978261709,
    -0.042649369686841965, 0.02256985381245613, -0.014242108911275864, -0.005509624257683754, -0.03513270244002342, 0.018295422196388245, 0.04105338454246521, 0.005756102968007326,
    -0.018852563574910164, -0.037752192467451096, -0.026048995554447174, 0.006917049642652273, -0.025870608165860176, 0.002024115528911352, -0.026657551527023315, -0.0006327047012746334,
    0.014241802506148815, 0.003547195577993989, -0.016251681372523308, 0.016407478600740433, -0.018361825495958328, 0.00595050910487771, -0.002636516001075506, 0.00972561165690422,
    -0.0014446914428845048, -0.01982954330742359, -0.037630677223205566, -0.01599939353764057, -0.013065440580248833, 0.011552723124623299, -0.017643073573708534, -0.0012633418664336205,
    -0.016453782096505165, -0.0375000424683094, 0.004286313429474831, 0.04404497146606445, 0.003467976115643978, -0.010947533883154392, 0.015517959371209145, 0.020290886983275414,
    0.015093360096216202, 0.06287039071321487, -0.02604019083082676, -0.0013148735743016005, -0.0042388043366372585, 0.002736987778916955, 0.010655359365046024, -0.009574688971042633,
    0.008734540082514286, -0.00795123539865017, -0.0017112167552113533, -0.02388789691030979, 0.0206515621393919, -0.013990750536322594, -0.007826539687812328, -0.00688999705016613,
    0.01217069011181593, 0.004410939756780863, 0.013628770597279072, 0.020541757345199585, -0.002571804216131568, -0.0011806911788880825, -0.01981201395392418, -0.01007040310651064,
    -0.010647891089320183, -0.00027002289425581694, -0.00185828295070678, 0.005720965564250946, -0.007236600387841463, -0.0006617901963181794, -0.005451220087707043, 0.014490542933344841,
    0.012942207977175713, -0.011565486900508404, -0.006108039524406195, -0.02140059508383274, 0.01860707998275757, -0.03103584609925747, 0.022553885355591774, -0.02526763640344143,
    -0.0045559038408100605, 0.00722260819748044, 0.04575929045677185, -0.004562177695333958, 0.030716173350811005, -0.0004447629617061466, 0.03104063868522644, 0.0012835919624194503,
    -0.00544805359095335, -0.024592220783233643, 0.014194294810295105, -0.0004883086658082902, 0.0015808416064828634, -0.001705980277620256, 0.007256720680743456, 0.0015945523045957088,
    0.03078456036746502, 0.015592388808727264, 0.004944740794599056, -0.025244135409593582, -0.04508515074849129, -0.04021058231592178, -0.019120223820209503, -0.0009601807687431574,
    -0.019027139991521835, 0.0403318777680397, 0.002647142391651869, -0.0030996466521173716, 0.018389690667390823, -0.009416782297194004, 0.01602802611887455, 0.002636423334479332,
    0.001883718534372747, -0.009011747315526009, 0.04335874319076538, 0.016615714877843857, -0.00019540156063158065, -0.002381332218647003, -0.0012439924757927656, -0.005367225967347622,
    0.024020632728934288, 0.013768386095762253, -0.014066471718251705, -0.012846698053181171, -0.015670550987124443, -0.01009686291217804, 0.02690446376800537, 0.012685573659837246,
    0.015258124098181725, -0.0125997643917799, -0.003984208684414625, 0.006328626535832882, -0.009743099100887775, -0.0339869000017643, 0.002801443450152874, 0.012137914076447487,
    0.0301438607275486, 0.001762831467203796, -0.014619491063058376, -0.02199699357151985, 0.0037371621001511812, -0.009758509695529938, 0.0356014184653759, -0.013115922920405865,
    0.04850797727704048, -0.005791209638118744, -0.005000098142772913, 0.016188129782676697, -0.00429023802280426, -0.004527025390416384, 0.02056470885872841, -0.012093077413737774,
    0.012854086235165596, 0.019760306924581528, -0.022697988897562027, 0.01372535526752472, 0.03819619119167328, -0.028425149619579315, 0.016897281631827354, 0.0031926438678056,
    0.018648095428943634, -0.017569465562701225, -0.00471690995618701, 0.00602038623765111, -0.0022391099482774734, -0.0029752287082374096, 0.02273477427661419, 0.00028800012660212815,
    -0.0029054952319711447, -0.0012565903598442674, 0.025736048817634583, -0.03404165431857109, 0.02271134965121746, 0.008583863265812397, -0.03134674206376076, -0.003712237114086747,
    -0.01696099527180195, 0.009845958091318607, -0.0024137014988809824, 0.004781840369105339, -0.009374733082950115, -0.021943697705864906, 0.024617820978164673, 0.002588278613984585,
    -0.011257495731115341, -0.01898685283958912, 3.107240263489075e-05, -0.008497470989823341, -0.022286374121904373, 0.013398994691669941, -0.012607567012310028, -0.031046247109770775,
    -0.029922517016530037, 0.0058561465702950954, -0.014528745785355568, -0.018303140997886658, -0.0005620655138045549, -0.02404697611927986, -0.030991073697805405, 0.024686919525265694,
    -0.0074446601793169975, 0.018102381378412247, -0.004831826779991388, 0.01659533381462097, 0.026843180879950523, -0.029792917892336845, -0.04711952060461044, -0.0027205313090234995,
    0.01358021143823862, 0.02762259542942047, -0.0038280512671917677, 0.004966459237039089, -0.02271581068634987, -0.009922453202307224, -0.034449461847543716, -0.0032357850577682257,
    0.0018347367877140641, 0.005322396755218506, -0.027472499758005142, -0.0032185774762183428, -0.035211965441703796, -0.02834266610443592, 0.0036973238456994295, 0.023256978020071983,
    0.002482691314071417, -0.011472652666270733, 0.014508035033941269, -0.006112242583185434, -0.007652143482118845, 0.008836890570819378, -0.004166426137089729, 0.01472119614481926,
    -0.007836863398551941, -0.024343304336071014, -0.01884450763463974, -0.014153232797980309, -0.021150849759578705, -0.011417376808822155, -0.0019284122390672565, 0.006512312218546867,
    0.03266149014234543, -0.022239943966269493, -0.04049801453948021, -0.0346120186150074, -0.0075073870830237865, -0.00046915130224078894, 0.03732163831591606, -0.017991788685321808,
    0.00867596548050642, -0.00607458408921957, 0.035969290882349014, -0.0074112508445978165, 0.015857115387916565, -0.025299139320850372, -0.03354969993233681, 0.004388194531202316,
    0.023262018337845802, -0.013930311426520348, 0.012229353189468384, 0.004103303886950016, 0.022307218983769417, 0.018737459555268288, -0.0265496838837862, -0.010495318099856377,
    0.0037673988845199347, 0.008069276809692383, 0.04722455516457558, 0.019398268312215805, 0.004156476818025112, 0.0030977013520896435, -0.022304918617010117, 0.016957962885499,
    -0.0056694550439715385, 0.010232124477624893, -0.000338684389134869, -0.014147553592920303, -0.025104226544499397, 0.007519917096942663, -0.0034309427719563246, 0.00406979164108634,
    -0.012986787594854832, -0.003618887159973383, 0.01382034458220005, 0.0002708836109377444, -0.016918368637561798, 0.03815309703350067, 0.013536355458199978, -0.042656708508729935,
    -0.024347061291337013, 0.038571130484342575, 0.036031097173690796, -0.026796849444508553, 0.002889385912567377, 0.0004670304188039154, -0.04590271785855293, -0.0079736839979887,
    0.030737901106476784, 0.02847295254468918, 0.02031429298222065, -0.016659846529364586, -0.0008347746334038675, -0.033105090260505676, 0.0274345763027668, 0.02610146999359131,
    0.041769206523895264, -0.01279822550714016, 0.013026523403823376, -0.013257392682135105, 0.013629002496600151, 0.005892080254852772, -0.04892205074429512, -0.016589060425758362,
    0.005298295523971319, 0.04573631286621094, 0.009344260208308697, -0.00310840574093163, 0.033377256244421005, 0.019392624497413635, -0.02386101894080639, 0.019823623821139336,
    -0.012661492452025414, 0.010307642631232738, -0.005599402356892824, 0.02255202829837799, 0.013787997886538506, 0.03843233361840248, -0.006901496089994907, -0.03225094825029373,
    0.010272914543747902, -0.0037207412533462048, 0.027706138789653778, 0.0005890038446523249, -0.04991954192519188, 0.010009247809648514, 0.04687860235571861, 0.010857531800866127,
    -0.0006695707561448216, 0.03361832723021507, 0.01051967404782772, 0.002186455996707082, 0.009270123206079006, 0.012618711218237877, -0.009927213191986084, -0.011681298725306988,
    -0.014461813494563103, -0.020038867369294167, 0.016555694863200188, 0.01723037101328373, 0.026720819994807243, -0.009576207958161831, 0.0013804310001432896, -0.005410822574049234,
    -0.00381334382109344, -0.0042436253279447556, -0.002121844794601202, 0.008531247265636921, -0.0025848897639662027, 0.005337898153811693, -0.0016935986932367086, 0.001962836366146803,
    0.0009770862525328994, 0.0058966754004359245, -0.005402364302426577, 0.0023020736407488585, -0.0022164657711982727, -0.009751423262059689, 0.005308474879711866, 0.0006843246519565582,
    -0.013227131217718124, 0.0016907734097912908, -0.010568530298769474, -0.004377217963337898, 0.0016144622350111604, 0.0026372827123850584, -0.01267897617071867, 0.006593440193682909,
    0.01617847941815853, -0.009920322336256504, 0.003949765581637621, -0.0056540523655712605, -0.004537639208137989, 0.0005006275605410337, 0.006637683138251305, 0.002893320517614484,
    -0.007373492699116468, 0.00941521767526865, -0.0013000223552808166, 0.0023364911321550608, -0.0033779561053961515, 0.005023850128054619, 0.00894605927169323, -0.002867333358153701,
    -0.001851857639849186, -0.0032417629845440388, -0.010973205789923668, -0.0013876132434234023, -0.008801826275885105, -0.00039960897993296385, -0.001180483028292656, -0.011362047865986824,
    -0.001932081882841885, 0.0007390403188765049, 0.003400468034669757, 0.0017524117138236761, -0.007821924984455109, -0.0010675727389752865, 0.003674908773973584, 4.5676864829147235e-05,
    -0.00023476372007280588, -0.00153036427218467, 0.017615092918276787, -0.0012541618198156357, 0.011442716233432293, 0.0013189070159569383, 0.00209657009691, 0.008129921741783619,
    0.003658628324046731, 0.001471423776820302, -0.008257129229605198, -0.006689134985208511, 0.0016734575619921088, 0.0035195723176002502, 0.0010216435184702277, -0.006932588294148445,
    -0.010378863662481308, 0.0051762405782938, 0.007456879131495953, -0.0017759177135303617, -0.002106994856148958, 0.0003639173519331962, 0.00393926864489913, -0.012296550907194614,
    0.01063828356564045, -0.006222931668162346, -0.0021399501711130142, -0.01035213377326727, -0.0007401621551252902, -0.0025265668518841267, -0.000511378631927073, 0.010696325451135635,
    -0.0012914935359731317, -0.006153170485049486, 0.004883685149252415, -0.0008221322786994278, 0.0004575417551677674, 0.004122159909456968, -0.009513715282082558, 0.002581039210781455,
    -0.0011155020911246538, 0.0037295983638614416, 0.007686377968639135, -0.005262674763798714, -0.0016141044907271862, -0.0002949289046227932, -0.015519905835390091, 0.0015287597198039293,
    -0.001894717919640243, -0.0048552569933235645, 0.007049635984003544, -0.0034191994927823544, -0.0014950181357562542, 0.004749198444187641, -0.0010784805053845048, 0.0011757847387343645,
    0.0014802279183641076, 0.008226681500673294, -0.001069119549356401, -0.0014060846297070384, 0.008081367239356041, 0.007446886971592903, 0.008008620701730251, -0.013974553905427456,
    -0.0016034652944654226, -0.0015028698835521936, 0.0003177018079441041, -0.006513545755296946, 0.0050275917164981365, 0.00836764182895422, -0.002076681237667799, 0.004324248526245356,
    0.051407329738140106, -0.024210110306739807, -0.021328715607523918, 0.03184857591986656, 0.020840978249907494, 0.017900686711072922, -0.02366042509675026, 0.028350355103611946,
    0.035644687712192535, -0.021474704146385193, 0.003551773726940155, 0.03273952379822731, -0.0006134295254014432, 0.00914688315242529, 0.00281871622428298, 0.00891102571040392,
    0.005917978007346392, 0.058658305555582047, -0.005913677625358105, -0.019711535423994064, -0.020787078887224197, 0.020945968106389046, 0.03900299593806267, -0.030512409284710884,
    0.04530587047338486, -0.025729572400450706, -0.00010968932474497706, -0.052469853311777115, -0.06919758766889572, -0.018352415412664413, 0.022897647693753242, -0.03195884823799133,
    0.035605259239673615, 0.003576119663193822, -0.017786316573619843, 0.005055462941527367, -0.0034378739073872566, -0.07109236717224121, 0.03675192594528198, 0.04690767079591751,
    0.018292106688022614, 0.05173509195446968, -0.04759011045098305, 0.005562948528677225, 0.017595931887626648, 0.032153334468603134, -0.022318968549370766, 0.0024201793130487204,
    -0.03092207759618759, -0.05483986809849739, -0.022269269451498985, -0.05927387624979019, -0.0013136365450918674, 0.04318155720829964, 0.02379191480576992, 0.011821872554719448,
    -0.01728248968720436, 0.013865433633327484, -0.042679790407419205, -0.0010348374489694834, -0.0035745890345424414, -0.015895269811153412, -0.022516509518027306, -0.018885420635342598,
    -0.04365462064743042, 0.04806947708129883, -0.03741297125816345, 0.01665664091706276, 0.015424697659909725, 0.009392608888447285, -0.00982369389384985, 0.06555796414613724,
    -0.07060685008764267, 0.05720170587301254, 0.01703644171357155, 0.045680105686187744, -0.06312961876392365, 0.024131404235959053, 0.05375705286860466, -0.031842343509197235,
    -0.013734220527112484, -0.010037107393145561, 0.02809503860771656, -0.023008542135357857, -0.04943422973155975, 0.026382243260741234, 0.05135669931769371, -0.012544337660074234,
    0.04151531681418419, 0.03667838126420975, -0.004333046264946461, 0.06588572263717651, 0.03897298127412796, 0.01517750509083271, -0.03992518037557602, 0.035555142909288406,
    -0.06730809062719345, -2.898213278967887e-05, 0.013261533342301846, -0.019925501197576523, -0.020263370126485825, -0.04022073373198509, -0.011212964542210102, 0.02702528052031994,
    0.011588139459490776, -0.02455422468483448, -0.015727128833532333, -0.07561872154474258, 0.034242182970047, -0.00441418681293726, -0.03958125412464142, 0.019942454993724823,
    -0.008427808061242104, 0.01420636661350727, -0.009287086315453053, -0.01719215139746666, -0.03343341127038002, 0.032677505165338516, 0.023688239976763725, 0.03161226958036423,
    -0.007516533136367798, 0.06046042963862419, -0.018639637157320976, -0.016972679644823074, 0.0463346466422081, 0.0037287904415279627, 0.027176707983016968, -0.011106758378446102,
    -0.020805153995752335, 0.026740970090031624, -0.03955831378698349, 0.06313933432102203, -0.025205537676811218, -0.014076272025704384, -0.001190077280625701, 0.01027349941432476,
    -0.025545593351125717, -0.05011880770325661, 0.036377713084220886, -0.007168237119913101, 0.062465421855449677, -0.03282800689339638, 0.053155358880758286, 0.007870598696172237,
    0.07427750527858734, -0.015441193245351315, -0.005466417409479618, 0.0649193525314331, -0.031172320246696472, -0.006216692738234997, -0.007726234849542379, -0.020817749202251434,
    -0.041746463626623154, 0.001311197760514915, -0.06859002262353897, -0.008492602035403252, 0.008732962422072887, -0.02440769225358963, -0.03297330439090729, 0.042531806975603104,
    -0.04761067405343056, 0.0346175953745842, 0.0009986277436837554, -0.014537891373038292, -0.08035043627023697, 0.01206077542155981, 0.0016053523868322372, 0.020312871783971786,
    -0.010791934095323086, 0.013355418108403683, -0.01811559870839119, 0.014004487544298172, -0.032511644065380096, 0.011844475753605366, 0.009710988029837608, -0.024997539818286896,
    -0.014178191311657429, 0.0492415651679039, 0.0008257469744421542, -0.01215784065425396, -0.019314473494887352, 0.026090197265148163, -0.033389344811439514, -0.02061065286397934,
    -0.024684986099600792, -0.003350073704496026, 0.0005002087564207613, -0.006316600367426872, 0.05280713364481926, 0.004272088408470154, 0.01898079738020897, -0.04399283602833748,
    0.011832051910459995, 0.05712370574474335, 0.0036848161835223436, -0.016358328983187675, 0.025445587933063507, -0.005844105966389179, -0.026741331443190575, -0.03947795182466507,
    -0.06986644119024277, -0.002643861807882786, 0.03304583579301834, -0.03307592123746872, -0.03196917846798897, 0.034606948494911194, 0.03820377588272095, -0.026216654106974602,
    -0.024417761713266373, 0.020681357011198997, 0.06726009398698807, -0.04260609298944473, -0.023353662341833115, -0.01802746020257473, 0.042937882244586945, -0.0712885931134224,
    0.037514448165893555, -0.013644343242049217, -0.005929651204496622, -0.06989236176013947, -0.028523927554488182, -0.011034212075173855, 0.04506088048219681, 0.015131526626646519,
    -0.06826291233301163, 0.030072733759880066, 0.002302240813151002, 0.019732443615794182, -0.012562784366309643, -0.01866879127919674, 0.05184943228960037, 0.01886860281229019,
    -0.028883444145321846, -0.01567167043685913, 0.010830995626747608, -0.05136283114552498, 0.009090449661016464, -0.004687329288572073, -0.015522626228630543, -0.004893583711236715,
    -0.04305052012205124, 0.033280011266469955, -0.03199533373117447, 0.023607270792126656, 0.04555129259824753, -0.0010887922253459692, -0.026316272094845772, -0.01979238912463188,
    -0.04379902780056, 0.04646618664264679, -0.04888627305626869, 0.03309764713048935, -0.0033319576177746058, 0.07993423938751221, 0.03618703782558441, -0.0607885979115963,
    -0.005262740422040224, -0.024586398154497147, -0.0031608031131327152, 0.07239165902137756, -0.020760614424943924, 0.008662490174174309, 0.0006471030646935105, 0.012889941222965717,
    0.022008666768670082, 0.07146193087100983, 0.04399137198925018, -0.020699884742498398, -0.0558021180331707, -0.04288242757320404, 0.020049119368195534, 0.009127290919423103,
    0.011888058856129646, 0.006392164155840874, -0.03432781621813774, 0.005200243555009365, -0.007830750197172165, 0.01188702043145895, 0.06207064539194107, 0.02341134287416935,
    0.021953536197543144, -0.019882868975400925, 0.014111921191215515, -0.09011819213628769, 0.06404594331979752, 0.007981061935424805, 0.02492469921708107, 0.039660096168518066,
    -0.03453856706619263, -0.058284372091293335, 0.025714416056871414, 0.020911049097776413, -0.007753986399620771, 0.08242147415876389, -0.038091517984867096, -0.05131973698735237,
    0.007369867991656065, 0.06856350600719452, -0.057457130402326584, -0.004115577321499586, -0.04204701632261276, -0.05818814039230347, 0.026026776060461998, -0.036396194249391556,
    -0.023922119289636612, -0.06019831448793411, 0.004357466474175453, -0.008509097620844841, 0.0008982624858617783, -0.007331404369324446, -0.005300960037857294, 0.020360613241791725,
    0.0627547949552536, -0.01002422720193863, -0.03420833870768547, -0.006317540071904659, -0.008718288503587246, -0.022282421588897705, 0.0003487584472168237, 0.015852374956011772,
    -0.07425383478403091, 0.009414933621883392, -0.06671936064958572, -0.06508078426122665, 0.034868303686380386, -0.03218641132116318, 0.014497235417366028, 0.05653761327266693,
    -0.037308722734451294, -0.1047767624258995, -0.007580517791211605, -0.027198417112231255, 0.06886200606822968, 0.09531030058860779, 0.0012503800680860877, -0.04787140712141991,
    0.006944308057427406, 0.06303339451551437, 0.006856628693640232, -0.002198763657361269, -0.007707212585955858, -0.045351725071668625, -0.00431273365393281, 0.09909041225910187,
    0.009907285682857037, 0.0027573266997933388, -0.06781307607889175, 0.015947498381137848, -0.027168169617652893, 0.03595149889588356, 0.0264727845788002, -0.035641156136989594,
    -0.0006487101200036705, 0.03271302953362465, 0.016543569043278694, -0.04080886021256447, 0.03838454559445381, 0.03157275542616844, 0.07998699694871902, -0.0019843783229589462,
    0.021996235474944115, 0.009235593490302563, -0.04310312494635582, 0.0021238483022898436, -0.03275204449892044, -0.029115328565239906, 0.07734246551990509, -0.018677301704883575,
    0.030342446640133858, -0.025652900338172913, 0.02659948728978634, 0.027126111090183258, 0.03145772963762283, 0.008122656494379044, -0.02753613516688347, 0.00949895940721035,
    -0.05650508031249046, 0.05782867595553398, -0.016170721501111984, -0.026759130880236626, -0.03632402420043945, -0.01636430434882641, 0.059260156005620956, -0.03748471662402153,
    0.04649840667843819, 0.01620093174278736, 0.011426420882344246, 0.05872589722275734, 0.05738532170653343, -2.8983746233279817e-05, 0.001054243417456746, -0.020716441795229912,
    0.0013339552097022533, 0.03616277500987053, 0.04935941845178604, -0.008126399479806423, 0.04676901921629906, 0.045878972858190536, 0.06963682174682617, 0.029403451830148697,
    -0.046785950660705566, -0.06586800515651703, -0.00744375167414546, -0.08729256689548492, -0.03582894802093506, -0.015051310881972313, 0.00676870858296752, 0.019807584583759308,
    0.003951424732804298, 0.0677809864282608, -0.02432537078857422, 0.014021974988281727, 0.02742197923362255, -0.032198917120695114, -0.0424753800034523, -0.009139805100858212,
    0.00521169463172555, -0.031196866184473038, -0.021310212090611458, 0.025507429614663124, 0.0075344545766711235, 0.03434630483388901, -0.050424523651599884, 0.03111116960644722,
    -0.0769507959485054, -0.009145734831690788, -0.03426487371325493, 0.0368683785200119, 0.09220016747713089, 0.013152052648365498, -0.03110273741185665, -0.04984772577881813,
    0.015068663284182549, 0.007981839589774609, 0.019345268607139587, -0.011699298396706581, -0.0022833358962088823, -0.047121595591306686, 0.04476407542824745, -0.07209978252649307,
    -0.0235616285353899, 0.047815676778554916, 0.004778621252626181, -0.004358097445219755, 0.028759855777025223, 0.0130510488525033, 0.008552421815693378, -0.0201884713023901,
    0.030533965677022934, 0.006793396081775427, -0.022954465821385384, -0.006036850158125162, -0.010941942222416401, 0.012320954352617264, 2.161920565413311e-05, -0.037043504416942596,
    0.01213607657700777, 0.048445381224155426, 0.012231692671775818, -0.027598462998867035, -0.048194341361522675, 0.0025289596524089575, -0.05830557644367218, -0.06987807154655457,
    0.003004647558555007, 0.04805713891983032, 0.034946199506521225, -0.004492190666496754, 0.003284851321950555, 0.045741476118564606, 0.029823461547493935, 0.02362593449652195,
    -0.035750724375247955, 0.025355717167258263, -0.11180040240287781, 0.04843568056821823, -0.06629396975040436, 0.0703313872218132, -0.06800505518913269, -0.02640903927385807,
    -2.6570456611807458e-05, 0.0020141610875725746, -0.015259334817528725, 0.04849637672305107, 0.01992899738252163, 0.03975744917988777, -0.005712512880563736, 0.05224098637700081,
    -0.0038821299094706774, -0.006614315323531628, -0.007049741223454475, -0.05230863392353058, 0.01163547858595848, 0.060316167771816254, 0.08708574622869492, 0.03341221436858177,
    0.08564474433660507, -0.010716668330132961, 0.01533775869756937, -0.040115997195243835, -0.01586156152188778, 0.03836362436413765, 0.012376125901937485, 0.035181283950805664,
    0.0625428706407547, 0.03741507977247238, 0.011090554296970367, 0.03661861643195152, 0.013780117966234684, 0.018939020112156868, -0.036022696644067764, 0.006800238974392414,
    0.04022276774048805, 0.0351109616458416, 0.050326768308877945, 0.05578883737325668, 0.06434430181980133, -0.035887088626623154, 0.004075700417160988, -0.028076978400349617,
    -0.001598767121322453, 0.06186347454786301, -0.1536632627248764, 0.017372915521264076, -0.04205239936709404, -0.03114471398293972, -0.04961594194173813, -0.02677934616804123,
    -0.023575352504849434, -0.007421654183417559, 0.021966729313135147, 0.04400646686553955, -0.060690201818943024, 0.006058224476873875, -0.04147044196724892, 0.04703453183174133,
    0.02783334068953991, -0.006895207799971104, 0.0055814143270254135, -0.024011414498090744, -0.07378184050321579, 0.021351374685764313, 0.010991018265485764, 0.017414676025509834,
    -0.006839107722043991, -0.0008817837806418538, -0.037009455263614655, -0.031621016561985016, -0.04770876467227936, -0.03596346080303192, 0.04201805219054222, 0.020679090172052383,
    -0.041154418140649796, -0.030850857496261597, -0.030846090987324715, -0.03303750976920128, -0.00722123309969902, 0.07042692601680756, -0.027852974832057953, -0.10942446440458298,
    0.015001743100583553, -0.04389575868844986, -0.02458951808512211, -0.05169891566038132, -0.0035565802827477455, 0.027074066922068596, 0.014323439449071884, 0.0740167647600174,
    -0.00927390344440937, -0.007700852118432522, 0.020352160558104515, -0.05111447721719742, -0.020918186753988266, -0.020585622638463974, -0.004332117270678282, -0.038040757179260254,
    0.028374947607517242, 0.021568818017840385, -0.004999866709113121, 0.02292228862643242, -0.02218976616859436, 0.009453325532376766, -0.008028135634958744, 0.021774915978312492,
    -0.02222725935280323, -0.015224081464111805, 0.007535061798989773, 0.036111678928136826, 0.007537826430052519, -0.057106733322143555, -0.04044970124959946, -0.006671949755400419,
    -0.00017153637600131333, 0.06726771593093872, -0.018882155418395996, 0.004311620723456144, 0.02694007009267807, -0.040680818259716034, 0.09358565509319305, -0.04826587438583374,
    -0.03225483372807503, 0.03349308297038078, -0.06339399516582489, -0.05059536173939705, -0.07099861651659012, -0.014985268004238605, -0.026900779455900192, -0.021548103541135788,
    -0.06349579989910126, -0.04988144338130951, -0.013421743176877499, -0.056247614324092865, 0.013564328663051128, -0.04190638288855553, -0.01492221001535654, 0.032806217670440674,
    -0.014227613806724548, -0.014616345055401325, -0.006907591130584478, -0.012931011617183685, 0.045349135994911194, 0.04961812496185303, 0.056525275111198425, -0.010460875928401947,
    -0.03136865422129631, -0.035395413637161255, -0.011329881846904755, 0.04945819452404976, -0.03954078629612923, 0.02747432515025139, -0.006531804334372282, -0.07471532374620438,
    -0.044219281524419785, 0.058545805513858795, -0.03685290738940239, 0.009572366252541542, 0.018501674756407738, -0.07574686408042908, -0.04834023863077164, 0.020564105361700058,
    -0.03219303488731384, -0.041295506060123444, 0.004915760830044746, -0.022218752652406693, 0.11702772974967957, 0.017390040680766106, 0.03679414838552475, -0.0024098625872284174,
    0.02600695751607418, -0.0050702826119959354, -0.023571470752358437, 0.007847855798900127, 0.04681814834475517, -0.04361854866147041, -0.11459541320800781, -0.00030322730890475214,
    0.0013486967654898763, 0.025466298684477806, -0.02163100801408291, -0.012493375688791275, 0.007055976893752813, -0.0006982602062635124, -0.07749908417463303, 0.015385545790195465,
    0.08298015594482422, 0.011885585263371468, 0.014625467360019684, 0.022515736520290375, 0.010176796466112137, 0.038552943617105484, 0.06209228187799454, 0.0970534235239029,
    -0.04761143773794174, 0.008930684067308903, 0.06310872733592987, 0.07280699908733368, -0.040520258247852325, 0.013641666620969772, 0.05430031567811966, 0.001478202291764319,
    0.05397063493728638, -0.04183531925082207, 0.006068405229598284, 0.049431562423706055, -0.10046703368425369, -0.01934131607413292, -0.019740045070648193, 0.07894408702850342,
    0.03541763871908188, 0.004525342024862766, -0.006393561139702797, -0.0012474545510485768, 0.003325799945741892, -0.06141287460923195, 0.06328924000263214, 0.01848467066884041,
    0.005658028647303581, 0.005577722564339638, -0.05444272235035896, -0.00974392332136631, -0.03013800084590912, 0.033976394683122635, -0.00016662172856740654, -0.09962526708841324,
    -0.037143345922231674, -0.00905420258641243, 0.010258371941745281, -0.06578441709280014, -0.00089451385429129, 0.016703752800822258, 0.05332909896969795, -0.00841945968568325,
    0.04230619594454765, 0.03462807461619377, -0.017524000257253647, -0.040156763046979904, -0.012005990371108055, 0.02801312506198883, -0.018372155725955963, -0.06823673099279404,
    0.011244548484683037, 0.02184685878455639, 0.07552331686019897, 0.05300862714648247, -0.04039136692881584, -0.01809372380375862, 0.04835319519042969, -0.06982295960187912,
    0.04446326568722725, -0.04025398939847946, 0.0734017938375473, 0.03867171332240105, -0.004652072209864855, -0.025469601154327393, -0.016263553872704506, -0.022072190418839455,
    -0.019610773772001266, -0.027211936190724373, -0.031499166041612625, 0.06038437783718109, 0.07606915384531021, 0.05907187983393669, -0.014466943219304085, -0.03322727978229523,
    -0.015999238938093185, 0.007925475016236305, 0.03826824203133583, -0.04127530753612518, 0.05337755009531975, 0.010523508302867413, 0.008145671337842941, -0.019353976473212242,
    0.020600970834493637, 0.008153274655342102, -0.04622776433825493, 0.013706692494452, 0.04220607504248619, -0.09892846643924713, 0.04607849940657616, 0.00392985949292779,
    0.005009224638342857, 0.03037802316248417, -0.04516806825995445, 0.01118854433298111, -0.048322055488824844, 0.00032544476562179625, 0.030280234292149544, -0.0584113746881485,
    0.04827746003866196, 0.015380221419036388, -0.07262657582759857, -0.012595726177096367, 0.05717969685792923, 0.006712327711284161, 0.013741647824645042, 0.02413344755768776,
    -0.0409364178776741, 0.05245291069149971, -0.00016498907643835992, -0.00202474114485085, -0.06430082023143768, -0.011872928589582443, 0.019426653161644936, 0.05994701758027077,
    0.04624296724796295, -0.038088470697402954, -0.011906682513654232, -0.03418882191181183, -0.027963850647211075, 0.01907462812960148, -0.014228838495910168, -0.06557240337133408,
    0.010665719397366047, -0.06257491558790207, -0.009625967592000961, -0.005880837794393301, 0.01590549573302269, 0.039576537907123566, 0.016013002023100853, -0.015259291045367718,
    -0.004911251366138458, -0.0036821356043219566, 0.013855469413101673, -0.08052807301282883, 0.02787696197628975, 0.015353459864854813, -0.05345660448074341, 0.05079253390431404,
    -0.05475344508886337, -0.07581476122140884, -0.014314688742160797, -0.04849979653954506, -0.046297069638967514, 0.11421329528093338, -0.0017194324173033237, 0.02783569134771824,
    -0.017952095717191696, -0.008662891574203968, 0.03843202814459801, -0.0022334547247737646, -0.08422845602035522, -0.047936197370290756, 0.04659021273255348, 0.07223007082939148,
    -0.007893320173025131, 0.039199501276016235, -0.053561531007289886, 0.04458528012037277, 0.007030815351754427, 0.031715232878923416, 0.005299149546772242, 0.015041718259453773,
    -0.07560765743255615, 0.005640944465994835, -0.02876846119761467, -0.014055551029741764, -0.003548475680872798, -0.011370941065251827, -0.023145265877246857, -0.002636771881952882,
    0.061638832092285156, 0.05049581453204155, 0.04438531771302223, -0.0698947086930275, 0.031903576105833054, 0.007875850424170494, 0.0013278672704473138, -0.07816025614738464,
    -0.05359870195388794, 0.03756401315331459, -0.005379847716540098, 0.02719523012638092, 0.016695234924554825, -0.09395349770784378, -0.004950550384819508, -0.042895421385765076,
    -0.003481682389974594, 0.037778906524181366, -0.03903539106249809, 0.006430141162127256, 0.023440463468432426, 0.08967477083206177, 0.1415470689535141, -0.040152695029973984,
    -0.00020559960103128105, 0.027923045679926872, -0.016404997557401657, -0.09492998570203781, -0.037249282002449036, 0.03900453448295593, 0.02724047191441059, -0.06626362353563309,
    0.05591815337538719, 0.017903730273246765, 0.011019093915820122, 0.032133061438798904, 0.053282249718904495, -0.05810050666332245, -0.06563550233840942, 0.03925005719065666,
    0.10547558963298798, -0.042082007974386215, -0.0007493929006159306, -0.03556860610842705, -0.020933054387569427, 0.07884131371974945, -0.0962185189127922, 0.03851127251982689,
    0.06086762994527817, -0.040469080209732056, -0.03255505487322807, -0.05019059404730797, -0.037538595497608185, 0.03041306883096695, -0.0009516708087176085, -0.022330280393362045,
    -0.03124796599149704, -0.0262093897908926, -0.018177790567278862, -0.09989839792251587, -0.011431380175054073, 0.052506983280181885, 0.05313296243548393, 0.018832240253686905,
    0.01651361770927906, -0.10658977925777435, 0.04297776520252228, 0.03873446583747864, 0.08099335432052612, 0.020359506830573082, -0.020212510600686073, -0.07992763072252274,
    0.008255002088844776, 0.0577266626060009, -0.026460476219654083, -0.03503154218196869, 0.011127798818051815, -0.03400987386703491, -0.04340937361121178, -0.03503963351249695,
    -0.04153072461485863, 0.0072802891954779625, -0.014676534570753574, -0.024355484172701836, -0.0348970890045166, -0.009292729198932648, 0.010334134101867676, 0.0879245400428772,
    0.013696946203708649, 0.021518371999263763, -0.022872906178236008, 0.07965958118438721, 0.0030091411899775267, 0.026105867698788643, -0.09794483333826065, 0.02200205624103546,
    -0.016291290521621704, 0.02345208264887333, 0.06361270695924759, -0.009664054028689861, -0.019374404102563858, 0.04650750756263733, -0.001327579258941114, -0.016201714053750038,
    0.050662796944379807, -0.009821023792028427, 0.014087696559727192, 0.03516899049282074, 0.06607592105865479, 0.03890206664800644, 0.03149094432592392, 0.002356099896132946,
    0.10642798990011215, -0.04165525361895561, 0.022342978045344353, -0.020602330565452576, -0.024123435840010643, -0.0380457378923893, -0.01087802555412054, -0.014901830814778805,
    -0.06787474453449249, 0.03803374990820885, -0.04672320932149887, -0.03339611738920212, 0.002565499860793352, 0.012491579167544842, 0.031007006764411926, 0.03994763642549515,
    -0.08629188686609268, 0.022786056622862816, -0.00390778249129653, -0.0012162046041339636, -0.023644400760531425, -0.06472624093294144, 0.020133446902036667, -4.754499968839809e-05,
    0.06627310067415237, 0.047442398965358734, -0.008053384721279144, -0.03329447656869888, 0.005050947889685631, 0.002446231432259083, -0.13742825388908386, -0.030862608924508095,
    -0.036971285939216614, 0.02050595171749592, -0.05753196403384209, -0.002726770006120205, -0.028538377955555916, -0.12989655137062073, -0.06759190559387207, -0.054099664092063904,
    0.016707511618733406, 0.019035840407013893, 0.009183024987578392, 0.1347634345293045, -0.022729050368070602, -0.04765325412154198, -0.009604588150978088, -0.026806248351931572,
    -0.05566169321537018, 0.009082566946744919, 0.023386510089039803, 0.04949304088950157, -0.0033945159520953894, -0.02819020114839077, 0.045067377388477325, -0.008584287017583847,
    -0.005351912695914507, -0.010844761505723, -0.005069253034889698, 0.025374725461006165, 0.043238576501607895, 0.0691441148519516, -0.07657366245985031, 0.00582928117364645,
    -0.008568801917135715, 0.03488357737660408, -0.03510376065969467, 0.0006740104872733355, -0.026887793093919754, 0.04875599592924118, 0.027009183540940285, 0.01460234448313713,
    -0.12039992213249207, -0.0405811108648777, -0.023827427998185158, 0.012927680276334286, -0.0552581362426281, -0.010201034136116505, -0.05888534337282181, 0.060063913464546204,
    -0.04303940758109093, 0.03355015814304352, 0.04616066440939903, 0.002381259109824896, -0.09937901794910431, -0.03883781656622887, 0.008396472781896591, 0.030958499759435654,
    -0.07238492369651794, 0.013853875920176506, 0.014744695276021957, 0.03392540290951729, -0.03483427315950394, 0.05428041145205498, 0.013707837089896202, -0.0464668832719326,
    -0.015687352046370506, 0.02468007244169712, -0.021972430869936943, 0.030893385410308838, 0.026551352813839912, -0.08023964613676071, -0.029040269553661346, 0.04629334434866905,
    0.12229537963867188, 0.0063292416743934155, -0.042128920555114746, -0.061147741973400116, -0.029606016352772713, -0.04059666767716408, -0.010621415451169014, 0.024975065141916275,
    -0.01430019736289978, -0.05758931487798691, -0.03453594446182251, 0.053272828459739685, 0.011219517327845097, -0.034453555941581726, -0.048442937433719635, 0.04558242857456207,
    0.03241726756095886, -0.022442251443862915, -0.01058177836239338, -0.004111586604267359, -0.03832125663757324, 0.04683555290102959, 0.09500965476036072, 0.06264688074588776,
    -0.030716944485902786, 0.03963129594922066, 0.03532848134636879, -0.009696003049612045, 0.017840024083852768, 0.013424954377114773, -0.026285959407687187, 0.023197835311293602,
    0.001839601551182568, 0.008184732869267464, 0.032157350331544876, -0.0011759306071326137, -0.014871151186525822, 0.013960608281195164, 0.0568268708884716, 0.027407458052039146,
    -0.033655546605587006, 0.042169831693172455, 0.026542752981185913, 0.05085690692067146, -0.05562524124979973, -0.02371037006378174, -0.034578874707221985, 0.08725608140230179,
    0.015972524881362915, 0.018534116446971893, -0.10749094933271408, -0.015636349096894264, -0.0014932920457795262, -0.01458746287971735, 0.03783716633915901, -0.013548090122640133,
    0.00364315090700984, 0.019413216039538383, 0.031723182648420334, -0.006254610139876604, -0.041041210293769836, -0.03976275026798248, 0.027638526633381844, -0.04877789691090584,
    0.007946135476231575, 0.025548817589879036, 0.021808214485645294, -0.19726885855197906, 0.030254395678639412, 0.018994368612766266, -0.036797765642404556, 0.01087032351642847,
    0.05258330702781677, -0.018491536378860474, 0.02685890719294548, -0.06412256509065628, 0.03495534136891365, -0.04459904506802559, -5.8395276028022636e-06, -0.022721322253346443,
    0.11972662061452866, -0.08273895829916, -0.026005204766988754, -0.024325551465153694, -0.02093213051557541, -0.0014210797380656004, -0.033137645572423935, -0.01715797185897827,
    -0.08008973300457001, 0.0045246826484799385, -0.05914507806301117, 0.010178493335843086, -0.03222713991999626, -0.07518168538808823, 0.019095635041594505, -0.04721572622656822,
    -0.041752737015485764, 0.06006446108222008, -0.0011320185149088502, -0.03816967457532883, 0.036100029945373535, 0.0014900887617841363, -0.0010636808583512902, -0.019775109365582466,
    0.009343601763248444, -0.010915292426943779, 0.020219454541802406, 0.030765635892748833, 0.13290083408355713, 0.02364034578204155, 0.06178667023777962, 0.02103121019899845,
    -0.026300301775336266, -0.06335058808326721, -0.023037737235426903, -0.028723005205392838, -0.007976512424647808, -0.04521145671606064, 0.01976807788014412, 0.0027197336312383413,
    0.0011700111208483577, 0.003833723021671176, 0.06777871400117874, -0.03861435130238533, 0.05050912871956825, -0.05747446045279503, -0.031493958085775375, 0.009050650522112846,
    0.003695949213579297, 0.08891056478023529, 0.07813026756048203, 0.067268967628479, 0.029979728162288666, 0.0380454957485199, 0.10744107514619827, -0.015456966124475002,
    0.07785608619451523, -0.09388895332813263, 0.038771070539951324, -0.04680832102894783, -0.060532547533512115, -0.021168114617466927, -0.019217826426029205, -0.017869384959340096,
    -0.048055775463581085, 0.01611216738820076, 0.03326185792684555, 0.06613893061876297, -0.005643246695399284, 0.058525875210762024, 0.04318281635642052, 0.049989793449640274,
    -0.07499055564403534, -0.006176788825541735, 0.07154791802167892, -0.007214035373181105, 0.06111479178071022, 0.06542952358722687, 0.001844715210609138, -0.0322880782186985,
    0.002867518924176693, 0.020663727074861526, 0.033752210438251495, 0.05757160484790802, 0.017133576795458794, -0.05410739406943321, -0.08298679441213608, -0.005807043053209782,
    -0.08067179471254349, 0.1374226063489914, 0.037480227649211884, -0.03091808594763279, 0.023612430319190025, -0.011085745878517628, 0.03741257265210152, -0.03770630806684494,
    -0.03532833606004715, 0.031409863382577896, 0.04777461662888527, -0.010469336062669754, -0.04892895370721817, -0.07852958142757416, -0.06150839105248451, -0.0017439991934224963,
    -0.0457366444170475, -0.02866033837199211, -0.0674629658460617, 0.06024400144815445, -0.06949514150619507, -0.039364077150821686, 0.06701745092868805, 0.06629054248332977,
    -0.006250898819416761, -0.017716826871037483, 0.0010558136273175478, 0.19328995048999786, 0.04322660714387894, 0.004267263691872358, 0.007767817936837673, 0.0352494902908802,
    -0.013904738239943981, 0.09425254166126251, -0.0343058705329895, 0.03713924437761307, 0.021328136324882507, -0.011219535954296589, -0.011548620648682117, 0.0061809225007891655,
    0.03316541761159897, -0.06469938904047012, 0.024563482031226158, -0.048180680721998215, -0.01967317797243595, 0.012833275832235813, 0.03508124127984047, 0.04583271965384483,
    -0.057185910642147064, 0.001264118473045528, 0.11056060343980789, 0.05801897495985031, 0.0022014218848198652, -0.03224486857652664, -0.02928176335990429, -0.008106847293674946,
    0.07903169095516205, 0.017484541982412338, -0.018367841839790344, 0.04018131271004677, 0.06831405311822891, 0.0030609453096985817, -0.014695441350340843, -0.02464141510426998,
    -0.0008615624392405152, 0.012502141296863556, -0.0519157350063324, -0.010120632126927376, -0.12623775005340576, -0.03587203100323677, -0.005315378308296204, -0.04858686029911041,
    -0.022911518812179565, -0.0017832077573984861, -0.0651320368051529, -0.012746470980346203, 0.03724345192313194, 0.036506906151771545, 0.041746120899915695, -0.08097895979881287,
    0.043677717447280884, -0.03418838605284691, 0.025755032896995544, 0.01576041802763939, -0.087366983294487, 0.028898868709802628, 0.009785165078938007, 0.04048686847090721,
    0.0036120708100497723, 0.023596419021487236, -0.0008128478075377643, -0.027082115411758423, 0.002765862736850977, -0.0278187058866024, -0.02970934845507145, -0.0018510279478505254,
    -0.025304928421974182, -0.06639610230922699, -0.08189204335212708, 0.011506468057632446, -0.02539411373436451, -0.05054128170013428, 0.05352345481514931, 0.03840699791908264,
    -0.08786957710981369, -0.038342420011758804, 0.03922629728913307, 0.05151406675577164, 0.043551746755838394, -0.006620881613343954, -0.0216051172465086, -0.01657325029373169,
    -0.021336566656827927, 0.09368377923965454, 0.0230603888630867, 0.034326210618019104, -0.008870077319443226, -0.10154519230127335, 0.028829006478190422, -0.008740418590605259,
    0.055259980261325836, 0.02579425647854805, 0.006605695933103561, 0.04039802774786949, -0.0011410926235839725, 0.003617100650444627, -0.03473618999123573, 0.043995413929224014,
    0.0735287144780159, -0.04508151859045029, -0.016399947926402092, 0.03302513808012009, 0.02830018475651741, 0.04035399109125137, 0.034604161977767944, -0.018693244084715843,
    0.0486176423728466, 0.02202102169394493, 0.049251899123191833, -0.08474893867969513, 0.08773234486579895, -0.04496210813522339, -0.090501569211483, -0.011508462019264698,
    -0.047104448080062866, 0.012020626105368137, 0.006320534273982048, 0.03151687979698181, -0.02442125231027603, -0.014155480079352856, -0.025562666356563568, -0.0018729552393779159,
    -0.02063938044011593, 0.09735247492790222, 0.029349900782108307, -0.2056952565908432, -0.009766277857124805, -0.061007872223854065, 0.05067586898803711, -0.031249012798070908,
    -0.05769854784011841, -0.0002647019864525646, 0.03454790264368057, 0.05873015150427818, 0.05049595609307289, -0.08005810528993607, 0.04172644391655922, 0.022190310060977936,
    -0.043876126408576965, -0.05011524260044098, -0.0075921728275716305, 0.010669633746147156, 0.005537503864616156, 0.018628833815455437, 0.09072396904230118, -0.011512142606079578,
    -0.0009027593187056482, -0.016526618972420692, -0.018152451142668724, -0.03402769938111305, 0.14986300468444824, 0.053374454379081726, 0.012577841989696026, -0.01710214652121067,
    -0.006358920596539974, -0.015252540819346905, 0.07392346858978271, 0.027843652293086052, -0.03072984516620636, -0.011117548681795597, 0.07372783869504929, -0.03055637702345848,
    -0.028080619871616364, 0.020501451566815376, -0.02270473539829254, 0.003810951253399253, 0.15867653489112854, 0.009907894767820835, -0.03994366526603699, 0.04687009006738663,
    0.024079017341136932, 0.05117262899875641, -0.06396213173866272, 0.035878002643585205, -0.012063529342412949, -0.05707283318042755, -0.10515645891427994, 0.014924155548214912,
    0.10380007326602936, -0.08726931363344193, -0.023581020534038544, -0.055305272340774536, 0.04247378557920456, 0.010529388673603535, 0.009884584695100784, -0.03660474345088005,
    -0.07331328094005585, 0.008476987481117249, -0.03725083917379379, -0.0010036020539700985, 0.045677125453948975, 0.05027102306485176, -0.14855754375457764, -0.03502902388572693,
    -0.021146493032574654, -0.07951244711875916, 0.013283908367156982, 0.005774120334535837, -0.05905620753765106, 0.05039715766906738, -0.03399335965514183, 0.05071946978569031,
    0.014992418698966503, 0.01454292144626379, -0.019621357321739197, 0.0403946116566658, -0.05287029221653938, -0.018739832565188408, 0.05537330359220505, 0.030942799523472786,
    0.031370293349027634, -0.0655837431550026, -0.028820695355534554, -0.004672261420637369, 0.018138080835342407, -0.018751882016658783, -0.016448132693767548, -0.010037628933787346,
    0.062365978956222534, -0.019917147234082222, 0.024060577154159546, 0.02819824405014515, -0.004276944324374199, -0.06214820221066475, -0.02569475769996643, -0.03704074025154114,
    0.0076987300999462605, 0.024371866136789322, -0.020444102585315704, 0.055540502071380615, -0.0003931296814698726, -0.05011522024869919, -0.08376111090183258, 0.025245141237974167,
    0.06296786665916443, 0.0009688932332210243, -0.0020682229660451412, 0.008787684142589569, -0.039558712393045425, -0.010617170482873917, 0.0701964795589447, -0.026353497058153152,
    0.01755993254482746, -0.0027204614598304033, -0.02576056681573391, -0.1030440405011177, 0.0041989292949438095, -0.03978642448782921, -0.021992582827806473, -0.056987736374139786,
    0.0678471177816391, 0.07566238939762115, 0.010637990199029446, 0.203219473361969, -0.040691882371902466, 0.03504779189825058, 0.03253782168030739, 0.033829931169748306,
    0.07794055342674255, -0.058806587010622025, 0.0727892741560936, -0.08555297553539276, -0.09864544123411179, -0.006782161071896553, 0.055608902126550674, -0.03104368783533573,
    0.024545004591345787, 0.05790797621011734, -0.009338069707155228, 0.02568422444164753, 0.011487680487334728, -0.03931349888443947, -0.005496472120285034, -0.030969971790909767,
    -0.008115041069686413, 0.024963920935988426, 0.0032294951379299164, 0.07471214979887009, 0.06141181290149689, 0.015278797596693039, 0.03737347200512886, 0.017323756590485573,
    0.02766268514096737, 0.020387273281812668, 0.031061064451932907, 0.07806652039289474, 0.02902432531118393, 0.015000580810010433, -0.006463651079684496, -0.007627380546182394,
    0.005660446360707283, 0.03808087855577469, -0.006997792515903711, -0.01038328930735588, -0.14928360283374786, 0.027901239693164825, 0.0665932297706604, -0.002167964819818735,
    -0.02379094809293747, -0.049735959619283676, 0.003994650673121214, 0.010154899209737778, -0.0035232037771493196, 0.06240462511777878, -0.05431612953543663, -0.006827709265053272,
    -0.03148922696709633, 0.06866216659545898, -0.04247977212071419, -0.050212759524583817, 0.09241880476474762, 0.031264789402484894, 0.04780710116028786, 0.004977312870323658,
    0.07785703986883163, 0.0274581890553236, 0.007027400657534599, 0.05557204410433769, 0.05287620425224304, 0.0629650354385376, 0.06175687164068222, -0.032134875655174255,
    0.02222408354282379, -0.03905754163861275, -0.020691130310297012, -0.006632613018155098, -0.021743331104516983, 0.10603128373622894, 0.00699641602113843, -0.10881206393241882,
    -0.002308064140379429, -0.042486485093832016, -0.011428756639361382, 0.024546582251787186, -0.015088842250406742, -0.03769921138882637, 0.013517627492547035, 0.04968416318297386,
    0.022438058629631996, 0.039388153702020645, 0.057105664163827896, -0.027299905195832253, 0.023466698825359344, 0.07059324532747269, -0.023424847051501274, 0.04521092399954796,
    -0.06732713431119919, 0.042688336223363876, -0.004852407146245241, 0.08350367844104767, -0.0223081037402153, -0.03743309900164604, -0.006954495795071125, 0.01859188824892044,
    0.06912742555141449, -0.010988994501531124, -0.025792710483074188, -0.04483692720532417, 0.03616798296570778, 0.0250259917229414, -0.011832364834845066, 0.058849744498729706,
    0.08268685638904572, 0.09355241805315018, 0.01029997318983078, -0.03530183061957359, 0.03021080233156681, -0.04929981753230095, 0.1149756908416748, -0.021925128996372223,
    0.07252073287963867, -0.0022362773306667805, 0.04575720801949501, 0.0760435089468956, 0.00467638811096549, -0.0565032921731472, -0.11855732649564743, 0.06210913136601448,
    -0.0010070519056171179, 0.07080915570259094, -0.033218588680028915, -0.21602863073349, 0.029164498671889305, -0.004159692209213972, -0.033164020627737045, 0.009494527243077755,
    -0.10917516052722931, 0.04714527726173401, -0.042590174823999405, -0.0022901720367372036, -0.040416352450847626, 0.013769758865237236, -0.0565866082906723, 0.04907938092947006,
    -0.04024498909711838, 0.02687009423971176, 0.006414384115487337, -0.05680953338742256, -0.0370696559548378, -0.03370102494955063, -0.058903768658638, 0.01891515776515007,
    -0.01062259916216135, 0.07350796461105347, -0.009688062593340874, -0.004229707643389702, 0.044747091829776764, -0.0400332547724247, 0.03469268977642059, 0.02647930569946766,
    0.03375047445297241, 0.01013247575610876, 0.024094345048069954, -0.013569607399404049, -0.003897773800417781, -0.051257867366075516, 0.010297223925590515, -0.013947660103440285,
    0.030363744124770164, 0.041520990431308746, 0.05510424077510834, -0.02344449609518051, 0.11342141777276993, 0.011332368478178978, -0.1120462715625763, -0.022636115550994873,
    0.013005485758185387, -0.05728315934538841, 0.038935717195272446, -0.026989981532096863, -0.062330011278390884, -0.003685879986733198, -0.0543341226875782, -0.07082425057888031,
    0.003961894195526838, -0.007451558019965887, -0.028795093297958374, -0.0007656037923879921, 0.00013457756722345948, 0.07804512977600098, -0.02211986854672432, 0.028460068628191948,
    0.08130328357219696, 0.032042246311903, -0.008379755541682243, -0.06943988054990768, -0.09382135421037674, 0.06948109716176987, 0.09860612452030182, 0.05228562280535698,
    0.08895201981067657, 0.0629696398973465, 0.0555366575717926, 0.0041411095298826694, -0.04486142843961716, -0.004929071757942438, -0.012504258193075657, -0.054836247116327286,
    -0.04266354814171791, 0.036875929683446884, 0.03823564946651459, 0.00459785433486104, 0.005096366163343191, -0.045134037733078, -0.09066025912761688, -0.00738516403362155,
    -0.01747804507613182, 0.06941921263933182, 0.012482762336730957, 0.04435696080327034, -0.04507475346326828, -0.09454282373189926, -0.005804307758808136, 0.03691224008798599,
    -0.005059579852968454, 0.04735758155584335, 0.04744389280676842, 0.053054943680763245, -0.012832683511078358, 0.061352383345365524, -0.04346292093396187, -0.004348351154476404,
    -0.009481359273195267, 0.06141947582364082, -0.02043127827346325, 0.005756373051553965, 0.03354420140385628, 0.00023597512335982174, 0.07066024839878082, 0.026649706065654755,
    0.025247761979699135, 0.030247291550040245, 0.04031425714492798, 0.0010070840362459421, 0.01233162172138691, 0.055479660630226135, -0.1151920035481453, 0.05514058470726013,
    0.03462310880422592, 0.07783496379852295, -0.025961589068174362, -0.04774681106209755, -0.020672110840678215, -0.019980963319540024, 0.009486076422035694, 0.012015977874398232,
    0.025097323581576347, 0.042506441473960876, 0.008582358248531818, 0.20652341842651367, 0.01994483917951584, -0.043533552438020706, -0.0011486830189824104, -0.06618605554103851,
    0.05291846767067909, 0.006404579617083073, -0.007344486657530069, -0.02562851272523403, 0.05350036546587944, -0.011266829445958138, -0.020418783649802208, -0.0477481447160244,
    0.013933819718658924, -0.06359714269638062, 0.012614233419299126, -0.021052973344922066, -0.003928245976567268, 0.008831985294818878, 0.00526241771876812, 0.04763174429535866,
    -0.0056794630363583565, -0.021697048097848892, -0.011378619819879532, 0.047499626874923706, -0.007459825836122036, 0.016144437715411186, -0.018846780061721802, -0.13024291396141052,
    0.03353862836956978, -0.025189710780978203, 0.00766972778365016, 0.032004404813051224, -0.06765583902597427, -0.0324070043861866, -0.006753832567483187, 0.10597202181816101,
    -0.05936657264828682, -0.002002732828259468, 0.26375994086265564, 0.011808470822870731, -0.08293143659830093, -0.011954708956182003, -0.06359317898750305, 0.03120071440935135,
    0.05229415372014046, -0.008690244518220425, 0.051251329481601715, 0.049590058624744415, 0.061349254101514816, 0.006347439251840115, 0.008560760878026485, 0.016377460211515427,
    0.06738325953483582, -0.0536620169878006, 0.014397913590073586, 0.00906202383339405, -0.03874126821756363, 0.030820678919553757, -0.003957130014896393, -0.018811944872140884,
    -0.09152045100927353, 0.016854804009199142, 0.062159761786460876, 0.1046474352478981, 0.0030245042871683836, -0.007176185492426157, -0.09204067289829254, 0.030537424609065056,
    0.042383402585983276, 0.021952057257294655, 0.10430222749710083, -0.0024830747861415148, -0.033457718789577484, -0.016786163672804832, -0.0011757849715650082, 0.04508595913648605,
    -0.06647071987390518, -0.06776251643896103, 0.04652589187026024, 0.023019570857286453, -0.037506598979234695, -0.06362024694681168, 0.08431804180145264, -0.005534360650926828,
    0.004860525019466877, -0.10293177515268326, 0.018987977877259254, 0.008591819554567337, -0.004678275436162949, -0.024014484137296677, 0.050186607986688614, -0.01808781921863556,
    0.1288433074951172, 0.03596857190132141, 0.00862449686974287, -0.04581114649772644, 0.0110697653144598, -0.017073823139071465, 0.004426141735166311, 0.008350004442036152,
    -0.041434403508901596, -0.00847234670072794, -0.002540714107453823, -0.0023838276974856853, 0.028750136494636536, 0.05714648216962814, 0.01825711503624916, 0.038139354437589645,
    -0.04210393875837326, 0.022442851215600967, 0.007860470563173294, -0.04469369351863861, -0.04352541267871857, 0.06388623267412186, -0.04261185601353645, -0.04753697291016579,
    0.03464709594845772, 0.0725826546549797, -0.0021718128118664026, -0.06214417889714241, -0.04279795289039612, -0.08626165986061096, -0.041378434747457504, 0.014440372586250305,
    0.00027237803442403674, -0.015256021171808243, 0.022285571321845055, -0.22245469689369202, -0.033392734825611115, 0.04991348087787628, 0.08685491979122162, 0.008101651445031166,
    -0.017278870567679405, 0.010128138586878777, 0.00712022976949811, -0.014818876050412655, 0.002722926903516054, -0.03645772486925125, -0.03220590576529503, -0.014626994729042053,
    0.05408504977822304, -0.05480746179819107, -0.03174431622028351, 0.0963987335562706, 0.07990814745426178, -0.0685216411948204, 0.08029726147651672, -0.070157989859581,
    -0.03939991816878319, -0.0005470300675369799, -0.004717028234153986, 0.01026975829154253, -0.05185616388916969, -0.027619533240795135, -0.026293335482478142, 0.029297025874257088,
    0.024040265008807182, -0.024191297590732574, -0.09381186962127686, 0.006812035571783781, -0.020408164709806442, 0.013130749575793743, -0.04384390637278557, 0.07904558628797531,
    0.07860342413187027, 0.06476357579231262, -0.05531657487154007, 0.009829971939325333, 0.058952029794454575, -0.06825654953718185, 0.06744996458292007, -0.020447753369808197,
    -0.03967677801847458, 0.021177159622311592, -0.05371228605508804, -0.0068451473489403725, 0.03022368811070919, 0.0027245956007391214, -0.11284139752388, -0.013098682276904583,
    -0.027921533212065697, 0.04805940389633179, 0.0554853156208992, 0.015776805579662323, 0.0003284677513875067, 0.019248440861701965, 0.00234727724455297, 0.13484372198581696,
    0.04830511659383774, 0.018835611641407013, -0.046991705894470215, -0.12302524596452713, -0.004554461687803268, -0.055142734199762344, -0.07535432279109955, -0.01051415130496025,
    0.06481018662452698, 0.043033573776483536, 0.008239894174039364, -0.04667693004012108, -0.06200315058231354, -0.018482079729437828, -0.02913632057607174, -0.013047288171947002,
    0.07668625563383102, 0.04628440737724304, 0.036194466054439545, 0.032868482172489166, -0.05753533914685249, 0.023331904783844948, 0.016503075137734413, 0.07632579654455185,
    0.01319868117570877, 0.13093401491641998, -0.04956335574388504, -0.04729880765080452, -0.04351016506552696, 0.06591809540987015, -0.04662559926509857, 0.03037048690021038,
    -0.015780363231897354, 0.020985951647162437, 0.001136020990088582, -0.02933274395763874, 0.004556742031127214, -0.050873227417469025, 0.04116220772266388, 0.05240996181964874,
    0.10287441313266754, 0.01877550594508648, -0.04169810935854912, -0.055075954645872116, -0.09243506193161011, 0.015219278633594513, -0.08346552401781082, -0.0063791824504733086,
    -0.07738224416971207, -0.024263499304652214, -0.05458121746778488, -0.016041118651628494, 0.021680377423763275, 0.016090238466858864, 0.06154061481356621, -0.02179611660540104,
    -0.014215042814612389, -0.03615913540124893, -0.08280786126852036, 0.01707475632429123, 0.02257872000336647, 0.005722064524888992, 0.034611113369464874, 0.036275945603847504,
    -0.06140534579753876, -0.012815342284739017, -0.01548086665570736, 0.19634757936000824, -0.05828910320997238, -0.011116640642285347, -0.015527800656855106, 0.09759453684091568,
    -0.07466726750135422, 0.013037239201366901, 0.003130927449092269, 0.0320671871304512, 0.01213029958307743, 0.010691920295357704, -0.05947579815983772, 0.10351824760437012,
    -0.07720033824443817, -0.03297801688313484, 0.009571194648742676, -0.08512277901172638, -0.0322686992585659, 0.06429128348827362, 0.08384491503238678, 0.009544857777655125,
    0.03829555958509445, 0.05179541930556297, 0.02429068088531494, 0.04050661623477936, -0.031621064990758896, -0.028646210208535194, -0.007112981751561165, 0.00848229881376028,
    -0.026464715600013733, -0.010235472582280636, -0.0697476863861084, -0.02709125354886055, -0.02694609761238098, -0.05126690864562988, -0.014876843430101871, 0.020391764119267464,
    0.02748425118625164, 0.035002462565898895, -0.03129458799958229, -0.0419650636613369, -0.023188380524516106, -0.018162785097956657, -0.018375741317868233, -0.004060267936438322,
    0.1258968859910965, -0.012115273624658585, 0.001961473375558853, -0.05712703987956047, 0.0662706196308136, -0.009554943069815636, -0.05435856804251671, -0.04688788205385208,
    0.03244778886437416, -0.00391578720882535, 0.019725898280739784, -0.01647653616964817, -0.0159763190895319, 0.027403367683291435, -0.02390008047223091, -0.08010967820882797,
    0.0682753473520279, 0.05620373785495758, -0.02371501922607422, 0.14214953780174255, -0.02009296417236328, -0.018306540325284004, 0.09962207078933716, 0.0038383519276976585,
    0.02186690829694271, 0.05402505397796631, -0.04997270554304123, 0.035564057528972626, -0.010864370502531528, 0.08315296471118927, 0.017732860520482063, -0.041124362498521805,
    0.061020586639642715, -0.037812553346157074, 0.01123114489018917, -0.026870302855968475, 0.03107050061225891, -0.07251298427581787, 0.024498244747519493, 0.053960416465997696,
    -0.013595311902463436, -0.11289669573307037, -0.034892842173576355, 0.03210855647921562, -0.025127390399575233, -0.039537444710731506, -0.06374475359916687, -0.01385784987360239,
    0.018007302656769753, 0.015339890494942665, 0.02839171141386032, -0.02295856922864914, 0.01522605586796999, -0.015430993400514126, 0.06508345156908035, -0.06771774590015411,
    -0.0356205552816391, 0.08313201367855072, -0.025871824473142624, -0.024575814604759216, -0.07300177216529846, -0.008875000290572643, -0.03823203966021538, 0.06371986120939255,
    0.030886825174093246, -0.007588106207549572, -0.028219450265169144, 0.08690501004457474, 0.012708554975688457, -0.03074284829199314, -0.09992051869630814, 0.03594458848237991,
    -0.055276185274124146, 0.03472162038087845, 0.033661674708127975, -0.006661116611212492, 0.02188003621995449, 0.05908244848251343, 0.060958974063396454, 0.05880163982510567,
    -0.04769439995288849, -0.005163479130715132, -0.004766547586768866, -0.18824774026870728, -0.033232662826776505, -0.06556342542171478, 0.009160283952951431, 0.02091960981488228,
    0.09263728559017181, 0.006214804016053677, -0.05659282207489014, 0.061055682599544525, 0.0007232423522509634, -0.03174382448196411, 0.08598550409078598, -0.09934598952531815,
    -0.05600076913833618, 0.04324836656451225, -0.031068429350852966, -0.0711771622300148, 0.08385851979255676, 0.07621967047452927, 0.07706372439861298, 0.02917599305510521,
    -0.07270930707454681, 0.03504866734147072, -0.06540261209011078, 0.0003693897742778063, 0.10426931083202362, 0.08922205120325089, 0.08452596515417099, -0.0006661702645942569,
    -0.05768392235040665, 0.061910953372716904, -0.04594964161515236, -0.03694886341691017, 0.011228001676499844, -0.06098582223057747, 0.06569074094295502, -0.04420040175318718,
    0.029812008142471313, -0.06400565057992935, 0.04344194009900093, -0.007674005813896656, -0.030572064220905304, 0.0009162268252111971, 0.036488957703113556, 0.07514473795890808,
    -0.05976337194442749, -0.05603658780455589, 0.10716605186462402, -0.02732713147997856, 0.01082855649292469, 0.008635231293737888, -0.03156067058444023, 0.011957863345742226,
    0.019030028954148293, -0.1192701905965805, 0.08219440281391144, 0.0575362853705883, 0.060447171330451965, 0.01250494085252285, -0.043020814657211304, 0.08779910951852798,
    -0.005447360686957836, 0.028783008456230164, 0.04718611016869545, -0.13248778879642487, -0.018232759088277817, -0.06709221750497818, -0.006715003866702318, 0.015175679698586464,
    0.06822522729635239, 0.05631000176072121, -0.050919607281684875, -0.02426118217408657, 0.00235912948846817, 0.013270760886371136, 0.050299786031246185, -0.040234196931123734,
    -0.08483946323394775, 0.008923999965190887, 0.05244269222021103, -0.003182966960594058, 0.032351717352867126, 0.07980860769748688, 0.03741353005170822, 0.0020869248546659946,
    0.011652878485620022, 0.050283581018447876, -0.041599009186029434, 0.019178329035639763, -0.056936394423246384, -0.035359129309654236, 0.08963348716497421, 0.06962897628545761,
    0.023613376542925835, -0.06564932316541672, 0.09631448239088058, 0.02961285226047039, -0.022390779107809067, 0.005298628471791744, 0.006236495915800333, -0.01707332953810692,
    -0.025382235646247864, -0.049419376999139786, -0.014453516341745853, 0.06178499013185501, -0.006365132052451372, -0.013093634508550167, 0.033508703112602234, -0.011246217414736748,
    0.0180745180696249, 0.0671091377735138, -0.04082167521119118, 0.01030636578798294, 0.0068248868919909, 0.07090163230895996, -0.058485593646764755, -0.036877214908599854,
    -0.023086905479431152, -0.021773437038064003, 0.0782587006688118, 0.014233220368623734, -0.043061356991529465, 0.0547318272292614, -0.08576300740242004, 0.017581095919013023,
    -0.003420433262363076, 0.0974162369966507, -0.016067251563072205, 0.16164082288742065, 0.06011388450860977, 0.08222965896129608, 0.0031724239233881235, 0.09278629720211029,
    -0.1296379268169403, -0.015714330598711967, 0.08399815112352371, -0.03360988199710846, -0.018473321571946144, -0.010490263812243938, 0.04045725241303444, -0.03014550544321537,
    -0.05447126924991608, 0.035783521831035614, 0.0057638827711343765, 0.21266454458236694, -0.03573315590620041, 0.024062927812337875, 0.02489231526851654, -0.007569591049104929,
    -0.02512979321181774, -0.023284442722797394, -0.020932139828801155, 0.09457683563232422, -0.04846036806702614, 0.03886059671640396, -0.021586205810308456, -0.004792475141584873,
    0.07398532330989838, -0.05903489515185356, 0.010942099615931511, -0.025701303035020828, 0.058429472148418427, -0.00944695807993412, -0.0362003892660141, 0.05482234060764313,
    -0.10044758766889572, -0.010792803019285202, 0.01599493995308876, -0.032316725701093674, 0.03811579570174217, 0.005714369472116232, 0.019073553383350372, -0.07088881731033325,
    -0.031047573313117027, 0.016999568790197372, 0.08758795261383057, -0.00036929381894879043, 0.05514632537961006, 0.01698382757604122, 0.08222277462482452, -0.012656193226575851,
    -0.032969243824481964, 0.10749230533838272, 0.11385811865329742, 0.006085470784455538, -0.038706619292497635, 0.004248062614351511, 0.06256276369094849, 0.045209214091300964,
    -0.0672941505908966, -0.06125413998961449, 0.0028868289664387703, 0.16331961750984192, -0.040813691914081573, -0.06477203965187073, -0.08298289030790329, 0.030753444880247116,
    -0.0030984943732619286, 0.03256611153483391, -0.1436406970024109, -0.030816951766610146, -0.009764084592461586, -0.041038405150175095, -0.010787867940962315, 0.06013229116797447,
    -0.0058166286908090115, -0.028974372893571854, 0.07676047086715698, -0.030331715941429138, -0.07093456387519836, -0.05027809739112854, -0.023957952857017517, 0.049694936722517014,
    -0.020554885268211365, 0.0874892920255661, 0.008288913406431675, 0.055566687136888504, 0.051519423723220825, 0.05956393852829933, 0.02547985129058361, -0.0110672228038311,
    -0.07908330112695694, -0.026586709544062614, 0.005449279677122831, 0.09537538141012192, -0.031534601002931595, -0.06377670913934708, 0.009343734942376614, 0.028256723657250404,
    -0.06257635354995728, -0.028342779725790024, -0.043912775814533234, 0.06430652737617493, 0.0690331980586052, 0.0029872471932321787, -0.01885673776268959, -0.07945708185434341,
    -0.009011671878397465, -0.005390208680182695, 0.00841971393674612, -0.016487756744027138, 0.0611664317548275, 0.06462549418210983, 0.08431889116764069, 0.10716423392295837,
    0.0762098953127861, -0.010259700007736683, 0.06351231038570404, -0.024655679240822792, -0.05701230466365814, 0.02350618690252304, 0.018799953162670135, 0.05870446935296059,
    -0.041280169039964676, 0.0925271138548851, -0.02521931193768978, -0.1529083400964737, 0.10030919313430786, -0.019529469311237335, 0.018890243023633957, 0.08701431006193161,
    0.09543319046497345, 0.01763947308063507, -0.050679080188274384, -0.059110455214977264, 0.11551237851381302, -0.0041219694539904594, 0.01111674029380083, 0.10789690166711807,
    -0.04393086954951286, -0.026558974757790565, -0.0027256361208856106, -0.13147105276584625, -0.08084333688020706, -0.013686677441000938, -0.06120399013161659, -0.09222190082073212,
    0.08163966983556747, 0.04849553853273392, -0.03533296659588814, -0.0060125174932181835, 0.052957043051719666, -0.08998967707157135, -0.030712775886058807, 0.04608627408742905,
    0.13355788588523865, 0.04918305203318596, 0.004041140899062157, -0.05474860966205597, -0.006362302228808403, -0.04795496165752411, 0.01411382108926773, 0.02058185264468193,
    -0.010364534333348274, -0.005517198704183102, 0.12490377575159073, 0.0008422976243309677, -0.07421471178531647, -0.06259632855653763, -0.019580084830522537, 0.010784732177853584,
    -0.01260258350521326, 0.036042943596839905, -0.01239866390824318, -0.044894952327013016, -0.05286041647195816, 0.0012106108479201794, -0.0003507365472614765, 0.11592672020196915,
    0.06546500325202942, 0.07877129316329956, -0.026974815875291824, 0.053705859929323196, -0.04660992696881294, 0.02664249762892723, 0.0004301450098864734, -0.08426542580127716,
    -0.07466050237417221, -0.06784398853778839, 0.04471169784665108, -0.1707484871149063, -0.11471462994813919, 0.014896550215780735, 0.05922475829720497, -0.018547886982560158,
    -0.03410260006785393, 0.03893538936972618, -0.0014199491124600172, 0.017061317339539528, -0.03947419300675392, -0.07486522197723389, -0.06141681969165802, 0.11647318303585052,
    0.14298447966575623, 0.02476915344595909, 0.03463035449385643, -0.030886640772223473, 0.04349098727107048, -0.1114056408405304, -0.11271463334560394, 0.028422588482499123,
    0.04458562657237053, -0.045131489634513855, -0.007432963233441114, 0.02492319978773594, 0.04356229305267334, -0.029378078877925873, -0.07465731352567673, -0.022050518542528152,
    -0.06511486321687698, 0.017043467611074448, 0.05586058273911476, 0.06695548444986343, 0.022893404588103294, -0.051827866584062576, -0.026524752378463745, -0.03312882408499718,
    -0.01722416654229164, 0.0173172689974308, 0.02395366132259369, -0.12133684009313583, 0.040439143776893616, -0.023403350263834, 0.016254082322120667, -0.004701876547187567,
    -0.06300859898328781, 0.018503062427043915, 0.10042047500610352, -0.013128942809998989, 0.014020395465195179, 0.07391266524791718, -0.054253656417131424, -0.04774370416998863,
    -0.008197206072509289, -0.00731410039588809, 0.07441949844360352, 0.014281012117862701, 0.0004998792428523302, -0.01405657920986414, 0.08355861902236938, -0.0934433788061142,
    0.03162563592195511, 0.0609334297478199, 0.03269842267036438, 0.13901323080062866, -0.021633414551615715, -0.026911690831184387, 0.01813523843884468, -0.02572360821068287,
    -0.05823887512087822, -0.0037019539158791304, -0.032582059502601624, -0.016649605706334114, 0.05852189660072327, 0.02824452333152294, 0.06972511857748032, -0.053201138973236084,
    0.013515161350369453, 0.02355079911649227, -0.0041556027717888355, -0.09790446609258652, 0.030951930209994316, 0.0293076504021883, -0.004505550488829613, -0.03927456960082054,
    -0.04786220192909241, 0.06800071150064468, -0.02685849741101265, 0.057874877005815506, -0.017951076850295067, 0.018269198015332222, 0.005385280586779118, 0.03212893754243851,
    0.03226197510957718, -0.01893794722855091, 0.02308293804526329, 0.015743765980005264, 0.07056571543216705, -0.027420051395893097, 0.01875970885157585, -0.004967377055436373,
    0.01428491435945034, -0.09622792899608612, 0.005033958703279495, -9.63553975452669e-05, 0.17065677046775818, 0.039680302143096924, -0.009552019648253918, -0.0017556644743308425,
    -0.10372214019298553, 0.06118008494377136, -0.03697172552347183, 0.013985136523842812, 0.06583365797996521, -0.038785919547080994, -0.03938700258731842, 0.08124342560768127,
    -0.02798115462064743, 0.01667880266904831, -0.009813294745981693, -0.06281261891126633, 0.09026641398668289, 0.01019010879099369, -0.026819145306944847, 0.0426931194961071,
    0.07492822408676147, -0.021059058606624603, 0.02686394937336445, 0.15765827894210815, -0.043474309146404266, 0.024895649403333664, 0.03653038665652275, -0.010759812779724598,
    0.03757309541106224, 0.018145164474844933, 0.06642836332321167, -0.014557786285877228, 0.006269935518503189, 0.06342442333698273, 0.04365834221243858, 0.022262629121541977,
    -0.053992003202438354, -0.012269983999431133, 0.04104969650506973, -0.04733361676335335, 0.0574880912899971, 0.07291523367166519, 0.017078181728720665, -0.030767975375056267,
    0.12641490995883942, 0.059484247118234634, -0.09830241650342941, -0.05557248741388321, -0.018517818301916122, -0.05824396014213562, -0.05042315647006035, 0.006552426144480705,
    -0.029567966237664223, -0.0483587384223938, -0.006375593598932028, -0.06721173226833344, -0.030881311744451523, 0.005587200168520212, 0.050526637583971024, -0.018834510818123817,
    -0.019609002396464348, 0.028247389942407608, 0.04410887137055397, 0.0015107225626707077, 0.044438835233449936, -0.04691106826066971, -0.034680768847465515, 0.07793255150318146,
    -0.011014454066753387, -0.07724301517009735, -0.020548634231090546, -0.10938683152198792, -0.00268640392459929, -0.07201533764600754, -0.01874399743974209, -0.09814248234033585,
    0.005661903414875269, -0.09222511947154999, -0.09110736846923828, -0.012197671458125114, -0.03708703815937042, 0.0867035984992981, -0.07293019443750381, 0.04630911350250244,
    -0.05151643604040146, 0.09566942602396011, 0.00591003755107522, -0.1413002610206604, -0.01334733422845602, 0.01329934224486351, 0.004341285675764084, 0.04228035733103752,
    0.004727047402411699, 0.00016251756460405886, 0.1196337565779686, 0.15881258249282837, -0.03567430377006531, -0.022129496559500694, -0.1099802628159523, -0.051446110010147095,
    0.0914711132645607, -0.0413975827395916, 0.06606701016426086, 0.2707784175872803, 0.01885710097849369, -0.04372028261423111, 0.02063588984310627, -0.026246830821037292,
    -0.08384723961353302, 0.08095432817935944, 0.03952993080019951, 0.041243359446525574, 0.023931168019771576, 0.08206886798143387, -0.09190462529659271, 0.08538876473903656,
    0.06459507346153259, -0.016580676659941673, 0.06494960933923721, 0.0422598272562027, 0.009092395193874836, -0.017066583037376404, -0.018460707738995552, 0.03706385940313339,
    -0.014504430815577507, -0.07991096377372742, 0.015691662207245827, -0.004023180343210697, -0.17734725773334503, -0.10335779935121536, -0.03527926653623581, -0.034441009163856506,
    0.07140857726335526, -0.029796645045280457, 0.019260400906205177, -0.06330759823322296, 0.05970223993062973, 0.06085922196507454, -0.006391461472958326, -0.02507152408361435,
    -0.049258504062891006, 0.0808880627155304, 0.028518369421362877, -0.005169737618416548, 0.01693628914654255, 0.030944086611270905, 0.05323929339647293, -0.022207731381058693,
    0.05628266558051109, -0.046690963208675385, -0.029489515349268913, -0.11780428141355515, -0.032229989767074585, 0.09269443154335022, -0.04002184048295021, 0.08672510087490082,
    0.031060675159096718, -0.07131528109312057, -0.0015497347339987755, 0.012926320545375347, 0.06637833267450333, -0.005887392908334732, 0.0011850087903439999, -0.04034966975450516,
    -0.09118423610925674, -0.008346488699316978, 0.06527253985404968, -0.1050218939781189, -0.10554590076208115, -0.09682010114192963, 0.023927146568894386, 0.07916910946369171,
    -0.00949017982929945, -0.061939921230077744, 0.07759913802146912, 0.029676463454961777, 0.09985172748565674, 0.0629831925034523, 0.09787531942129135, 0.07400070130825043,
    0.053492769598960876, 0.03437954932451248, -0.030625758692622185, -0.09151055663824081, 0.01676860824227333, 0.004211777821183205, -0.06683307141065598, -0.011476993560791016,
    0.02985887974500656, 0.11225418001413345, 0.057830050587654114, -0.0020654185209423304, 0.01897713914513588, 0.06531268358230591, -0.050446636974811554, -0.03164408728480339,
    -0.03708340600132942, -0.026040121912956238, -0.13122540712356567, 0.025187209248542786, -0.006621191743761301, -0.004575258120894432, 0.00593579513952136, 0.021532965824007988,
    0.08544733375310898, 0.04901295155286789, -0.0652153268456459, 0.045649874955415726, 0.005438594147562981, -0.019878869876265526, -0.0692475363612175, -0.051399823278188705,
    -0.0599488690495491, -0.030219251289963722, 0.022551260888576508, 0.10206028074026108, 0.06589782983064651, -0.07404988259077072, -0.017020555213093758, -0.049573399126529694,
    0.0647474005818367, 0.04736976698040962, -0.03452984616160393, -0.029956547543406487, -0.06587611138820648, 0.022562310099601746, -0.03385785222053528, 0.09655565768480301,
    -0.02467765472829342, -0.0509418360888958, -0.04800035059452057, -0.2159864604473114, 0.009603739716112614, -0.06523311883211136, 0.1338973343372345, 0.015863612294197083,
    -0.0002608975628390908, -0.08336880803108215, 0.005785519722849131, -0.005886238534003496, 0.15239453315734863, 0.05663500726222992, 0.03375135362148285, 0.0034425677731633186,
    0.04456181451678276, -0.00779507914558053, 0.07488394528627396, -0.06811874359846115, -0.06915900111198425, -0.08087556809186935, 0.09490878134965897, -0.032452065497636795,
    0.025805313140153885, -0.13233977556228638, -0.0849890187382698, 0.01236043218523264, 0.17011144757270813, -0.024345392361283302, -0.08277580142021179, 0.060453154146671295,
    0.07876066863536835, 0.03661717101931572, -0.03488071262836456, -0.09202080219984055, -0.008861585520207882, -0.04992947727441788, 0.05253998190164566, 0.06830991059541702,
    -0.010320397093892097, 0.08835786581039429, 0.03528871759772301, 0.08651218563318253, -0.007393298204988241, -0.015097439289093018, 0.01948782429099083, 0.05116473510861397,
    -0.09254348278045654, -0.13150084018707275, 0.009269027039408684, 0.10651423037052155, 0.00434534577652812, 0.04214257001876831, -0.02876286208629608, 0.06517434865236282,
    0.0014591828221455216, -0.11279014497995377, 0.044497013092041016, 0.0028348611667752266, -0.08395740389823914, -0.035157278180122375, -0.010890944860875607, 0.0685935690999031,
    0.1645732969045639, -0.016340667381882668, 0.14358089864253998, -0.06214912608265877, -0.03954172506928444, -0.07164448499679565, -0.13904154300689697, 0.11969879269599915,
    0.023513615131378174, 0.08984620124101639, -0.026695607230067253, -0.010478299111127853, -0.0476701445877552, -0.02746373787522316, -0.03131711110472679, 0.12707790732383728,
    0.0870928093791008, -0.03446611016988754, 0.003031714353710413, -0.09221305698156357, 0.01981501467525959, -0.026011349633336067, -0.09489154070615768, 0.004855541978031397,
    0.020548969507217407, 0.056024011224508286, -0.030120451003313065, -0.09380847215652466, -0.0008189457003027201, -0.034256886690855026, -0.06817251443862915, -0.01723058521747589,
    0.024828365072607994, -0.023853933438658714, -0.0668569877743721, 0.07232401520013809, 0.055214885622262955, -0.022707823663949966, 0.13094741106033325, -0.02662757970392704,
    0.037529464811086655, -0.03080923855304718, -0.06372305750846863, -0.013768406584858894, 0.017960790544748306, -0.0015783123672008514, 0.007720638532191515, 0.0713365450501442,
    0.04494832083582878, -0.05345144867897034, -0.029359053820371628, -0.06201637536287308, 0.053723301738500595, 0.07412933558225632, 0.0336371548473835, -0.1248510405421257,
    -0.13907793164253235, -0.02558370679616928, -0.035822536796331406, 0.01112139318138361, -0.020199012011289597, 0.09016703069210052, 0.026820048689842224, -0.08018340915441513,
    -0.06116925925016403, -0.06218509003520012, 0.03242148831486702, -0.051200177520513535, 0.15455347299575806, 0.12928389012813568, 0.08364621549844742, 0.07283955812454224,
    0.023573873564600945, -0.017677104100584984, -0.04500863701105118, 0.04815727844834328, 0.008308235555887222, 0.023207873106002808, 0.05535614490509033, -0.07187414914369583,
    0.04987062141299248, 0.045466553419828415, 0.03414883092045784, 0.08781850337982178, -0.05753626674413681, 0.05609211325645447, 0.0719062089920044, 0.008998697623610497,
    -0.03787754476070404, 0.017105454578995705, 0.15313978493213654, 0.025322671979665756, -0.16543085873126984, 0.041165512055158615, -0.014273376204073429, -0.042623262852430344,
    0.004305019974708557, -0.0014884211122989655, -0.010038229636847973, 0.022209174931049347, -0.046819377690553665, 0.04319804161787033, -0.028321610763669014, 0.05638737231492996,
    0.04019012674689293, -0.0327284038066864, -0.058989424258470535, 0.013628041371703148, 0.043640535324811935, -0.01432790607213974, -0.09589256346225739, 0.02560289017856121,
    -0.05342014506459236, -0.09501291066408157, 0.03471466898918152, -0.0760330781340599, -0.044997021555900574, -0.05326514318585396, 0.101577989757061, -0.031935133039951324,
    -0.012151057831943035, -0.1211792454123497, -0.03526415303349495, 0.021804967895150185, -0.0892769917845726, 0.10079333186149597, 0.04535390064120293, 0.08561287075281143,
    -0.046960391104221344, 0.010087007656693459, 0.0610763281583786, 0.05902903899550438, 0.06238330528140068, -0.07843691110610962, -0.014214390888810158, 0.027078282088041306,
    0.02597144991159439, -0.10847506672143936, 0.013251896016299725, -0.020754849538207054, -0.04121209681034088, -0.07259552925825119, -0.11249098926782608, -0.0557316318154335,
    0.009416989050805569, 0.027844099327921867, 0.04945458844304085, 0.0506194606423378, 0.0033826648723334074, 0.01703573204576969, 0.006447387393563986, -0.01745031215250492,
    -0.04347765073180199, -0.06926245987415314, -0.10674543678760529, -0.04383028298616409, 0.06552064418792725, -0.0763058140873909, 0.08791056275367737, -0.0063857766799628735,
    0.05202370136976242, -0.020432040095329285, 0.05444544553756714, 0.027886241674423218, -0.09769778698682785, 0.048612531274557114, 0.09228292852640152, -0.033711232244968414,
    -0.009749108925461769, 0.0671725943684578, 0.1504170149564743, 0.017207134515047073, 0.07063071429729462, -0.07612299174070358, 0.061305683106184006, -0.058480579406023026,
    0.09727760404348373, -0.07823104411363602, 0.025998907163739204, 0.0590844452381134, -0.012417423538863659, 0.03511109948158264, -0.05005941912531853, -0.03378131240606308,
    0.130859836935997, 0.003565863473340869, 0.09522072225809097, -0.09005168825387955, -0.061022091656923294, -0.05660272762179375, 0.049667369574308395, 0.0038991193287074566,
    0.0739428922533989, -0.013132781721651554, 0.10956927388906479, 0.28695955872535706, -0.036426980048418045, -0.03605172410607338, 0.08208132535219193, -0.00564512237906456,
    0.006878609303385019, 0.15250998735427856, 0.04591556265950203, -0.003637868445366621, 0.015431203879415989, 0.06944499909877777, 0.02996952459216118, -0.05310025438666344,
    0.028841210529208183, -0.04166115075349808, -0.04296093434095383, -0.11090712249279022, -0.05349862948060036, 0.004703141283243895, 0.0325520820915699, -0.003964017145335674,
    0.008909490890800953, 0.05959688127040863, -0.017052995041012764, 0.007587598171085119, 0.17979297041893005, -0.10050410777330399, 0.04671167582273483, 0.01812426932156086,
    0.011130697093904018, -0.03900377079844475, -0.055292535573244095, 0.04710898548364639, 0.013500576838850975, -0.020939238369464874, 0.03645864501595497, -0.057510003447532654,
    0.07826228439807892, 0.017770666629076004, -0.036792635917663574, 0.08392172306776047, 0.04655046388506889, -0.07088369131088257, 0.04433821514248848, 0.005986448377370834,
    0.013366375118494034, -0.004901787266135216, -0.06555551290512085, 0.023935673758387566, -0.003973877988755703, -0.019675368443131447, -0.00791938416659832, 0.0098762521520257,
    -0.04840988665819168, -0.019442671909928322, -0.10622538626194, -0.016638420522212982, 0.030116410925984383, 0.010081464424729347, -0.043885018676519394, 0.009079047478735447,
    -0.1642700582742691, -0.002646117703989148, 0.08142776042222977, -0.015133805572986603, -0.07935894280672073, -0.022432982921600342, 0.01077989675104618, 0.10498014837503433,
    -0.07483208924531937, 0.09590137749910355, -0.0847698524594307, 0.015262097120285034, 0.08545901626348495, 0.05132531374692917, -0.005103505216538906, -0.013761798851191998,
    -0.1706802099943161, 0.046383582055568695, -0.03026084043085575, 0.04961998388171196, 0.0395812951028347, 0.02884325385093689, -0.016042616218328476, -0.0609247162938118,
    -0.027256088331341743, -0.06163450703024864, -0.007969401776790619, 0.06439023464918137, -0.07657162845134735, 0.03777362406253815, -0.055568382143974304, 0.020134441554546356,
    -0.14033100008964539, 0.07825043797492981, 0.08630453050136566, -0.11493001133203506, -0.02733166702091694, 0.013881580904126167, -0.14048169553279877, -0.060465868562459946,
    0.054501742124557495, -0.058900926262140274, 0.07460690289735794, -0.0001673779624979943, -0.03250874578952789, 0.07400710880756378, -0.1976105272769928, -0.012661173939704895,
    0.024386964738368988, -0.028006982058286667, 0.010722956620156765, -0.07508845627307892, 0.03451225534081459, 0.0010033008875325322, 0.04262029007077217, -0.011802910827100277,
    -0.07510942220687866, 0.025347180664539337, -0.028817491605877876, 0.10501212626695633, -0.04125022888183594, -0.008149671368300915, 0.04891734570264816, 0.013685422018170357,
    -0.04737972095608711, 0.023022204637527466, 0.00022993132006376982, -0.25315535068511963, 0.046085137873888016, 0.06976622343063354, -0.05791807174682617, -0.19912153482437134,
    0.03852923959493637, 0.009611894376575947, 0.06189623847603798, -0.052897557616233826, -0.047520093619823456, 0.021269727498292923, -0.02955298125743866, -0.004817495588213205,
    -0.013278191909193993, 0.027546199038624763, -0.07346351444721222, -0.1102181002497673, 0.017084581777453423, -0.008355946280062199, 0.0008582078735344112, -0.014645015820860863,
    -0.022253792732954025, 0.03376134857535362, -0.036361586302518845, 0.018126074224710464, -0.1867893487215042, 0.11440206319093704, 0.0952882319688797, 0.021091563627123833,
    -0.11619476228952408, -0.07630491256713867, -0.010042132809758186, 0.004175483714789152, -0.020765667781233788, 0.01996060460805893, -0.06748528778553009, 0.04934721067547798,
    -0.0007720324792899191, 0.01615244150161743, 0.023999644443392754, -0.016098128631711006, -0.04610505327582359, -0.02231842651963234, 0.05965888872742653, 0.07840166985988617,
    -0.028627175837755203, 0.04654720798134804, 0.10707338154315948, 0.0012999811442568898, 0.04279829561710358, -0.029544850811362267, -0.10733217746019363, -0.13338328897953033,
    -0.007879016920924187, -0.12064023315906525, -0.048360515385866165, -0.0046454546973109245, -0.01044733077287674, 0.005247059278190136, 0.013220501132309437, 0.02990172989666462,
    0.1016690656542778, 0.0073245977982878685, 0.14002639055252075, 0.051702458411455154, -0.040937602519989014, 0.0017367159016430378, -0.01881548948585987, -0.09978706389665604,
    0.07495684176683426, -0.02328081801533699, 0.011297275312244892, -0.008328694850206375, -0.07846083492040634, -0.04789368435740471, 0.06957806646823883, 0.013853642158210278,
    -0.03876183182001114, -0.04393744468688965, -0.048155054450035095, -0.021891502663493156, -0.009991349652409554, 0.014019699767231941, -0.029153691604733467, -0.0032286422792822123,
    -0.12051035463809967, -0.03680797293782234, -0.0008752138819545507, 0.010082373395562172, 0.009523190557956696, 0.021403510123491287, -0.033993978053331375, 0.012097058817744255,
    0.05181160569190979, -0.018396710976958275, 0.026391180232167244, 0.005215869750827551, 0.11081712692975998, -0.03233710676431656, -0.14590518176555634, -0.05770917981863022,
    -0.03950701653957367, -0.08970814198255539, -0.013686448335647583, -0.05780705437064171, -0.026463918387889862, -0.004321690648794174, -0.034724656492471695, 0.04263093322515488,
    -0.06169802322983742, 0.009816866368055344, 0.009906375780701637, 0.08551502227783203, 0.08174405246973038, 0.042432695627212524, 0.09909325838088989, -0.05239194631576538,
    0.015179531648755074, -0.04028364643454552, -0.012252504006028175, -0.08746505528688431, -0.013187599368393421, 0.03636458143591881, 0.04169778898358345, -0.015738587826490402,
    -0.02346852235496044, 0.05707550048828125, -0.0010744567262008786, -0.018688978627324104, -0.030667925253510475, 0.07217209786176682, 0.045443981885910034, -0.07295660674571991,
    -0.07638946175575256, 0.0031017784494906664, 0.031748827546834946, -0.025260796770453453, -0.09242621809244156, 0.04278616979718208, -0.0451272651553154, -0.01009618490934372,
    0.07962261140346527, -0.015250766649842262, -0.021277757361531258, 0.15503725409507751, -0.032246991991996765, -0.07757936418056488, -0.018311383202672005, -0.08707068860530853,
    0.02393653243780136, -0.0017908536829054356, 0.07398100197315216, -0.023537660017609596, 0.19917291402816772, 0.05499992147088051, 0.09157032519578934, -0.040641963481903076,
    -0.15876582264900208, 0.011153397150337696, 0.08978750556707382, 0.04437908157706261, -0.05772986635565758, 0.012116129510104656, 0.02675071731209755, -0.11224114149808884,
    -0.03612527623772621, -0.1276025027036667, -0.04054709151387215, 0.04485282674431801, -0.004599795211106539, -0.009413396939635277, -0.11067556589841843, -0.002749538980424404,
    0.04773415997624397, -0.07627829909324646, -0.010572348721325397, -0.017860226333141327, -0.1146078035235405, 0.04517078399658203, 0.07048509269952774, -0.15810421109199524,
    0.17130939662456512, -0.1187104657292366, 0.0024041528813540936, 0.026071490719914436, 0.045087896287441254, 0.20741793513298035, 0.06377134472131729, 0.010350379161536694,
    -0.10128623992204666, 0.032129187136888504, 0.09924449771642685, -0.019238529726862907, 0.04587218165397644, -0.016561297699809074, 0.10332246124744415, 0.024869272485375404,
    -0.035700827836990356, 0.015462403185665607, -0.06110667064785957, 0.03970685601234436, -0.09412823617458344, -0.01237285416573286, 0.04365071281790733, -0.005497048608958721,
    -0.004669779445976019, 0.04261242598295212, 0.06387336552143097, 0.00276222568936646, 0.009621304459869862, -0.019176537171006203, 0.06587907671928406, -0.003276030533015728,
    0.0025283636059612036, -0.023023530840873718, 0.002865256741642952, -0.035982728004455566, -0.0009356485679745674, -0.06202861666679382, 0.04877476394176483, -0.01926995813846588,
    0.05935510993003845, -0.10258626192808151, 0.1342449188232422, 0.07001129537820816, -0.061831824481487274, -0.0042004152201116085, -0.025823596864938736, 0.038663242012262344,
    -0.004421846475452185, 0.08324289321899414, 0.0629916563630104, -0.025511961430311203, -0.005567576270550489, 0.09584637731313705, 0.12592092156410217, -0.05005965754389763,
    -0.09416714310646057, -0.08879461139440536, 0.026494238525629044, -0.06297353655099869, 0.046021539717912674, 0.032205600291490555, 0.07546161860227585, -0.04798802733421326,
    0.03656501695513725, 0.02009168080985546, 0.05716664716601372, 0.003927322570234537, 0.007363951299339533, 0.04080585762858391, -0.06219761073589325, 0.05743797495961189,
    0.007687382400035858, 0.02305622026324272, -0.023269709199666977, 0.2712940573692322, -0.06491080671548843, 0.033866997808218, 0.17434687912464142, 0.016459304839372635,
    -0.004362382926046848, 0.11155565828084946, 0.04434184730052948, -0.08097720146179199, -0.07686835527420044, 0.13434801995754242, 0.012229177169501781, -0.09667270630598068,
    -0.09421664476394653, -0.051806893199682236, 0.07709503918886185, -0.05837846174836159, -0.038800861686468124, 0.03496161848306656, 0.09827854484319687, -0.013322483748197556,
    -0.09957145899534225, -0.0043289512395858765, 0.012138883583247662, 0.048767492175102234, -0.16863584518432617, -0.01906011626124382, -0.0796392560005188, 0.0018755318596959114,
    0.009682421572506428, 0.06363088637590408, -0.06640397757291794, 0.09946123510599136, 0.04138016328215599, 0.012315685860812664, 0.08774400502443314, -0.18290726840496063,
    -0.003135760547593236, 0.1204412579536438, 0.08550462126731873, 0.001556977047584951, 0.07336461544036865, -0.06749248504638672, 0.004719293676316738, 0.08725947886705399,
    0.0750245600938797, -0.07466764748096466, -0.025689460337162018, -0.006449608597904444, -0.07312220335006714, -0.07238781452178955, 0.01803239807486534, -0.06216922029852867,
    -0.03556833043694496, -0.03895789384841919, -0.04227663576602936, -0.017433861270546913, -0.0901208445429802, 0.001486909226514399, -0.08628472685813904, 0.006338523235172033,
    0.04376043379306793, 0.0063643679022789, 0.06133384630084038, 0.03015294298529625, -0.012151254341006279, -0.08235084265470505, -0.057387541979551315, -0.0049729421734809875,
    0.07685716450214386, 0.07600394636392593, 0.130567729473114, -0.026770442724227905, 0.02277730032801628, 0.028024787083268166, -0.07330404967069626, -0.13966335356235504,
    0.036745671182870865, -0.02964852750301361, -0.02727118693292141, -0.14586928486824036, -0.01263618003576994, -0.047379810363054276, 0.024026386439800262, -0.01840079016983509,
    0.0013894409639760852, 0.049273405224084854, -0.06298109143972397, -0.024481121450662613, -0.045199811458587646, -0.10733853280544281, -0.10237521678209305, -0.013126494362950325,
    0.0018591622356325388, -0.02952587977051735, 0.07273773103952408, -0.006841354072093964, -0.0024273463059216738, 0.029967550188302994, 0.025786783546209335, -0.012359832413494587,
    0.02832620032131672, 0.015397231094539165, -0.09152842313051224, -0.010440033860504627, -0.0655040591955185, -0.03005666472017765, -0.06491479277610779, -0.07046474516391754,
    -0.04660920426249504, 0.013548680581152439, -0.008228511549532413, 0.06262801587581635, 0.07211440056562424, 0.026767117902636528, 0.04028356075286865, 0.0092434361577034,
    -0.0527256615459919, -0.020412283018231392, 0.009958252310752869, 0.06915179640054703, 0.04845701903104782, 0.03624650835990906, 0.05309438332915306, -0.04010012000799179,
    0.14633817970752716, -0.04924841597676277, 0.053571321070194244, -0.16539469361305237, 0.16478170454502106, 0.08091719448566437, -0.020564835518598557, 0.08028683811426163,
    -0.009346387349069118, -0.15164528787136078, -0.08865563571453094, -0.03224927559494972, -0.07260908931493759, 0.00940309651196003, 0.04431422799825668, 0.03204978257417679,
    0.15839546918869019, 0.048468537628650665, -0.02728017419576645, 0.03639090433716774, -0.037965770810842514, 0.04500611126422882, -0.0020915439818054438, -0.011434356682002544,
    -0.053498707711696625, -0.0416504442691803, -0.04114783927798271, -0.043559953570365906, 0.1717587113380432, -0.10578834265470505, -0.02723544090986252, 0.017802385613322258,
    0.022919271141290665, 0.13581913709640503, -0.10924620181322098, -0.030109714716672897, -0.07479824125766754, 0.009711453691124916, -0.04823676869273186, -0.041758980602025986,
    -0.00889431219547987, 0.08314237743616104, 0.17961135506629944, -0.019699009135365486, -0.08860249817371368, 0.06056677922606468, 0.07721017301082611, 0.1095133125782013,
    0.09561283886432648, 0.05125708505511284, 0.07044707238674164, 0.006243710406124592, 0.15590406954288483, -0.07966657727956772, -0.010635709390044212, -0.002488735830411315,
    -0.20531269907951355, -0.09407490491867065, -0.06758779287338257, -0.03322651609778404, 0.021459519863128662, -0.04968137666583061, 0.12181299179792404, 0.009381763637065887,
    -0.07517673820257187, -0.03029572404921055, 0.06556545943021774, 0.059251345694065094, 0.04837062209844589, 0.024268263950943947, -0.11571256816387177, -0.16468773782253265,
    0.025262335315346718, -0.12411834299564362, -0.0053009591065347195, -0.01274516899138689, 0.06796370446681976, -0.0355834998190403, -0.02752591110765934, -0.026061611250042915,
    0.050151094794273376, 0.019766539335250854, -0.028887823224067688, 0.14116716384887695, 0.029990214854478836, -0.041417986154556274, -0.02933174930512905, 0.044246453791856766,
    -0.06402021646499634, -0.1591472029685974, -0.014101468957960606, -0.1359120011329651, -0.03875173255801201, 0.14054745435714722, 0.08373904228210449, -0.05608990788459778,
    0.08162421733140945, 0.007154395338147879, -0.09729766845703125, 0.009102283976972103, -0.030209532007575035, -0.030675258487462997, 0.09611957520246506, -0.042983587831258774,
    0.010249004699289799, 0.04414419084787369, 0.03240048885345459, 0.01106682512909174, 0.09721769392490387, -0.09538830071687698, 0.12302691489458084, 0.060158658772706985,
    -0.03827698156237602, -0.02221035026013851, -0.0065878103487193584, -0.07587723433971405, -0.032853446900844574, -0.0460289791226387, 0.05759887024760246, 0.07367008924484253,
    0.03212150186300278, 0.03788283094763756, -0.04122201353311539, -0.038579512387514114, 0.036535121500492096, -0.1770949810743332, -0.03537220507860184, -0.049857910722494125,
    0.0698925331234932, -0.08514507114887238, 0.0345117412507534, -0.043247584253549576, -0.056027889251708984, -0.12687785923480988, -0.0063838353380560875, 0.08063971996307373,
    0.019358739256858826, 0.015408677980303764, -0.011675899848341942, -0.05039557069540024, 0.033426057547330856, -0.04385656863451004, -0.025573987513780594, 0.043216586112976074,
    0.08839276432991028, 0.007673897314816713, -0.030802635475993156, 0.024479541927576065, 0.004296933300793171, 0.043853919953107834, 0.04720597341656685, 0.047390807420015335,
    -0.065925732254982, -0.010694353841245174, -0.006254557054489851, 0.05641944706439972, -0.12828247249126434, 0.1033153161406517, 0.18412178754806519, -0.004599649924784899,
    -0.04843224212527275, -0.01138310506939888, 0.07065471261739731, -0.03461146727204323, -0.08263517171144485, -0.03093312308192253, -0.04746193438768387, 0.026295963674783707,
    -0.045024752616882324, -0.10494726151227951, -0.1308634877204895, 0.0001788055378710851, 0.04166942834854126, 0.0029093667399138212, -0.09422191232442856, -0.05761822313070297,
    0.045505646616220474, 0.059335075318813324, 0.039784643799066544, 0.00387280760332942, -0.08150733262300491, 0.05148332566022873, -0.03631170466542244, 0.05707990750670433,
    0.08923666924238205, -0.04941783845424652, 0.06808405369520187, 0.10342851281166077, 0.025629796087741852, -0.12975211441516876, 0.03293929994106293, -0.0019820432644337416,
    0.03301806002855301, 0.023595210164785385, 0.13064377009868622, -0.06935067474842072, -0.06359574943780899, 0.006312250159680843, 0.025521021336317062, 0.14193589985370636,
    -0.010102896019816399, 0.14221301674842834, -0.0501764677464962, -0.007828791625797749, 0.02977607026696205, -0.02440962940454483, 0.03949650377035141, -0.021212641149759293,
    -0.01910289376974106, -0.008925266563892365, 0.0055643487721681595, -0.12344682216644287, -0.0023722981568425894, -0.03833049535751343, 0.026227032765746117, -0.031550370156764984,
    0.012219903990626335, -0.1160425990819931, 0.009856358170509338, -0.1315152794122696, 0.013806423172354698, 0.047891341149806976, 0.010991769842803478, 0.10417801141738892,
    -0.00717468885704875, -0.032658517360687256, 0.07337544858455658, -0.03846036642789841, -0.024817615747451782, -0.01821489818394184, -0.0474255196750164, 0.12154649198055267,
    0.020163215696811676, 0.018553979694843292, 0.02397729456424713, -0.02055969461798668, 0.022269681096076965, -0.06174328178167343, 0.09547694772481918, -0.0496993325650692,
    0.10797124356031418, -0.10633054375648499, -0.012824172154068947, 0.049953021109104156, -0.042160194367170334, -0.03163477033376694, 0.05258527025580406, 0.0657229870557785,
    -0.01568382792174816, -0.05385661497712135, 0.02318401448428631, -0.052766602486371994, -0.029523281380534172, 0.09398311376571655, -0.20378006994724274, 0.12418769299983978,
    -0.004725282546132803, 0.1310717910528183, -0.055391401052474976, 0.22869448363780975, 0.030595123767852783, 0.17018169164657593, 0.20220643281936646, -0.08596792072057724,
    0.08656594902276993, -0.059495024383068085, 0.14423857629299164, 0.03974517807364464, -0.04371706023812294, 0.13721275329589844, -0.03429936245083809, 0.0054811895824968815,
    0.029495710507035255, -0.003752762218937278, 0.05731077864766121, 0.12272287905216217, 0.09681294858455658, 0.06653932482004166, 0.031036516651511192, 0.05267896503210068,
    0.0582176074385643, 0.053294070065021515, 0.0340200699865818, -0.004285073839128017, 0.052564267069101334, -0.058090098202228546, -0.0002738263283390552, -0.003766556503251195,
    0.15356746315956116, 0.10317452996969223, 0.048454396426677704, 0.08035869896411896, -0.0432257354259491, 0.004721288103610277, 0.1247071847319603, 0.07854990661144257,
    -0.0019786362536251545, -0.05022628977894783, -0.11409886926412582, 0.1312728226184845, 0.08507484942674637, 0.05259855091571808, -0.09949325770139694, -0.0413251630961895,
    0.13461539149284363, -0.04364675283432007, -0.05821240320801735, 0.00825316458940506, -0.04351510480046272, 0.03080098144710064, -0.038527511060237885, 0.10558700561523438,
    0.13811631500720978, 0.06646348536014557, -0.07631668448448181, -0.09861020743846893, 0.030750541016459465, -0.023229442536830902, -0.0863242894411087, -0.03457416966557503,
    0.01522565446794033, -0.007221001200377941, 0.036285873502492905, 0.012341600842773914, 0.033190030604600906, -0.02516397461295128, 0.13446515798568726, 0.256747305393219,
    0.01220039464533329, -0.09213995188474655, 0.07219704985618591, 0.03537771850824356, 0.074765644967556, 0.03148474916815758, -0.0279250368475914, 0.06325843930244446,
    -0.14272381365299225, 0.03997424617409706, 0.011866697110235691, -0.026755360886454582, -0.03406011313199997, 0.008960403501987457, 0.10387769341468811, -0.050069235265254974,
    0.05332423374056816, -0.018296165391802788, 0.08296691626310349, -0.06714185327291489, 0.012147409841418266, 0.2172030210494995, -0.045220497995615005, -0.08521056175231934,
    -0.025811459869146347, -0.019474107772111893, -0.045235954225063324, 0.024179374799132347, 0.08505349606275558, -0.04267651215195656, -0.021042365580797195, -0.031126052141189575,
    0.0003831922367680818, 0.014218972064554691, -0.08817137032747269, 0.0043287030421197414, -0.010569853708148003, -0.0855042040348053, -0.10094961524009705, -0.16211631894111633,
    0.059119127690792084, 0.12149037420749664, -0.005435779690742493, -0.002968773478642106, 0.08070692420005798, 0.0032210545614361763, 0.008792199194431305, 0.0244796983897686,
    0.007084610406309366, 0.05775545910000801, 0.013154754415154457, 0.17148371040821075, 0.06152777373790741, -0.03526701405644417, 0.013831482268869877, -0.09852220118045807,
    -0.10142139345407486, -0.07731006294488907, 0.022550364956259727, -0.26197201013565063, -0.024161484092473984, -0.08695414662361145, -0.19565103948116302, -0.04445870593190193,
    0.10816385596990585, 0.11445926874876022, -0.02013251930475235, -0.0473395474255085, -0.050030529499053955, 0.027485471218824387, -0.11177757382392883, -0.05069577693939209,
    -0.058247558772563934, -0.05723065510392189, 0.08853597193956375, 0.10051146894693375, 0.08800262957811356, 0.06703699380159378, 0.08775543421506882, 0.0680118054151535,
    0.0371614508330822, 0.09730500727891922, 0.017041923478245735, -0.0040756529197096825, 0.040241871029138565, 0.08704887330532074, 0.01019652746617794, -0.04245438799262047,
    -0.03976789116859436, -0.05492659658193588, -0.07567469775676727, 0.045643288642168045, 0.0488097220659256, -0.017341047525405884, 0.08152545243501663, -0.06807548552751541,
    0.10560400038957596, -0.06337839365005493, 0.031231235712766647, 0.07180685549974442, -0.0809919536113739, -0.056322429329156876, 0.06328679621219635, -0.1292128562927246,
    -0.1190003827214241, -0.11259181052446365, -0.028620881959795952, -0.015102729201316833, -0.024539051577448845, 0.0033222672063857317, 0.07751142978668213, -0.008752587251365185,
    0.028024272993206978, 0.006093298085033894, -0.027578987181186676, 0.07119183987379074, -0.10502679646015167, -0.21454766392707825, 0.07804543524980545, -0.037645868957042694,
    -0.052678268402814865, -0.032257214188575745, 0.06350401788949966, 0.012570025399327278, 0.17232057452201843, -0.16978532075881958, -0.19972991943359375, 0.004588275216519833,
    0.06052705645561218, 0.006091225892305374, 0.0047268494963645935, -0.03969622775912285, -0.10208982229232788, 0.009930561296641827, -0.012136685661971569, -0.030824612826108932,
    -0.09929023683071136, -0.045942988246679306, 0.041656672954559326, 0.029962481930851936, -0.004748541861772537, 0.05284427851438522, 0.08428887277841568, 0.00013322726590558887,
    -0.21366414427757263, 0.07206191122531891, -0.05928279459476471, 0.042675551027059555, -0.01435933355242014, 0.08084027469158173, 0.007715764921158552, -0.04487025365233421,
    -0.0635642260313034, -0.0650423988699913, 0.04742731899023056, 0.14905649423599243, -0.10913558304309845, -0.18564803898334503, -0.04157087206840515, -0.04719869792461395,
    -0.04347963258624077, -0.06350929290056229, -0.10977289080619812, 0.02851315587759018, 0.027327828109264374, -0.1171075701713562, -0.16146838665008545, 0.04357614740729332,
    0.08151991665363312, 0.17972047626972198, -0.02507832832634449, -0.02811017632484436, 0.12343335151672363, 0.015580073930323124, -0.0682048499584198, -0.06638430058956146,
    0.06428709626197815, -0.05785147473216057, 0.024647895246744156, 0.02206997759640217, 0.13383907079696655, 0.056573495268821716, -0.030923714861273766, 0.04667070880532265,
    -0.22960655391216278, -0.02560102753341198, -0.007552315015345812, 0.17260484397411346, -0.0989997610449791, -0.04372798278927803, -0.26089051365852356, -0.10607638955116272,
    -0.05546737089753151, 0.14178232848644257, -0.09845296293497086, -0.00632270285859704, -0.04699675738811493, 0.17746411263942719, -0.13813894987106323, 0.06986209750175476,
    -0.010970146395266056, 0.020940154790878296, 0.0551329031586647, -0.01548489835113287, 0.015472262166440487, 0.023693302646279335, 0.016576332971453667, 0.04064502194523811,
    -0.02200152352452278, -0.0015099061420187354, -0.013036287389695644, 0.015887482091784477, -0.013147748075425625, 0.007961045019328594, -0.014492268674075603, -0.026149196550250053,
    -0.03899138793349266, -0.0078624552115798, 0.08844709396362305, 0.007567186374217272, -0.02185908518731594, 0.018008805811405182, 0.0017450230661779642, -0.0037876502610743046,
    0.037742212414741516, 0.006931385491043329, -0.03696904331445694, -0.02096412517130375, -0.004411057103425264, 0.024176649749279022, 0.02069851942360401, 0.00883771013468504,
    -0.038999687880277634, 0.02648717164993286, -0.031219925731420517, 0.015221066772937775, -0.004594821482896805, -0.014620671980082989, 0.03300895914435387, -0.028287973254919052,
    0.015596620738506317, 0.04430463910102844, -0.03776339441537857, -0.025832682847976685, 0.03388374298810959, 0.019682906568050385, 0.030078940093517303, 0.0006225468241609633,
    0.03545788303017616, -0.041655100882053375, -0.024779103696346283, 0.0165037140250206, -0.003966784570366144, -0.016826841980218887, -0.008418887853622437, -0.028655419126152992,
    -0.02187858521938324, 0.0028994788881391287, 0.025754079222679138, 0.0017151548527181149, -0.020193271338939667, -0.0371704138815403, 0.005666576325893402, 0.027837911620736122,
    0.034391045570373535, 0.015386081300675869, 0.045833081007003784, -0.03822776675224304, 0.024526122957468033, 0.0144716277718544, 0.001495303469710052, -0.01792106404900551,
    0.018268397077918053, 0.007244094740599394, -0.026240868493914604, -0.0038177352398633957, -0.0006013128440827131, 0.048035722225904465, 0.015604435466229916, 0.01840766705572605,
    0.003628690028563142, 0.023154133930802345, -0.03364316746592522, -0.0023371889255940914, 0.030399609357118607, 0.003517837030813098, 0.03738527372479439, 0.016026560217142105,
    0.016915081068873405, -0.023103469982743263, -0.005956409033387899, -0.016523616388440132, -0.0016766522312536836, -0.027719274163246155, -0.02810734324157238, -0.01715116575360298,
    -0.020199470221996307, -0.00649377191439271, 0.02908160164952278, -0.028137657791376114, -0.017702514305710793, -0.023719441145658493, 0.061586469411849976, -0.040346529334783554,
    0.00595677038654685, 0.02572258934378624, 0.01147741824388504, 0.036033499985933304, -0.07540027052164078, -0.0008213372784666717, 0.010702399536967278, -0.018240541219711304,
    0.010902183130383492, 0.03738358989357948, -0.013377870433032513, -0.016867129132151604, 0.025731999427080154, -0.036647334694862366, -0.035611048340797424, 0.017041843384504318,
    -0.008744750171899796, -0.022584334015846252, 0.01292985025793314, 0.009209942072629929, -0.02540055848658085, 0.004191671963781118, -0.0020467382855713367, 0.029380295425653458,
    -0.007350301370024681, -0.027119910344481468, 0.01413649320602417, 0.005174124147742987, 0.012921144254505634, 0.015455898828804493, 0.0011460616951808333, 0.06888919323682785,
    0.03080405853688717, -0.005205526016652584, -0.0011078565148636699, 0.02941753901541233, 0.010461310856044292, 0.00299342954531312, -0.017744187265634537, 0.031019626185297966,
    0.00815472099930048, -0.022338882088661194, 0.02376958727836609, 0.007128715980798006, 0.030324731022119522, -0.00988131295889616, 0.008610635995864868, 0.025603825226426125,
    -0.02072695456445217, 0.028670120984315872, 0.01205811370164156, 0.007790079340338707, -0.0013137656496837735, -0.005010589957237244, 0.006110916845500469, 0.017647728323936462,
    0.024215003475546837, -0.013240628875792027, -0.028404634445905685, -0.0008837315253913403, -0.013976136222481728, 0.028964024037122726, 0.009278918616473675, -0.005129030905663967,
    -0.003872497007250786, 0.035013455897569656, -0.0412222258746624, 0.018417658284306526, 0.015914106741547585, 0.0009501763270236552, -0.06796754151582718, -0.02269381657242775,
    -0.04320096969604492, 0.022967010736465454, 0.010904110036790371, 0.008665445260703564, 0.010271468199789524, -0.013637635856866837, -0.017986038699746132, 0.020105255767703056,
    0.010166553780436516, 0.022374477237462997, -0.0013332763919606805, 0.009918015450239182, -0.004228389356285334, 0.01277920138090849, -0.00036605310742743313, 0.00017382150690536946,
    -0.013461940921843052, -0.02002076804637909, 0.011423143558204174, 0.031341876834630966, -0.00028587336419150233, 0.009588641114532948, -0.0032366998493671417, 0.020541703328490257,
    -0.034529268741607666, 0.028180791065096855, -0.006142500322312117, 0.004143268335610628, 0.005145482253283262, 0.022809581831097603, -0.027907345443964005, 0.022335078567266464,
    -0.013755337335169315, 0.0009502315078862011, 0.005425300449132919, -0.006493743974715471, 0.005626308731734753, -0.0021605174988508224, 0.00201025209389627, 0.023095227777957916,
    -0.04659540578722954, -0.009555409662425518, 0.026355668902397156, -0.013995072804391384, -0.004017282277345657, 0.0032695275731384754, 0.005993040278553963, -0.0017623782623559237,
    -0.023313285782933235, 0.03716349974274635, 0.017077868804335594, 0.018434034660458565, -0.031557124108076096, -0.008956157602369785, 0.06395404785871506, -0.017610982060432434,
    -0.0026499854866415262, -0.026610203087329865, -0.03218711540102959, 0.007228054106235504, -0.03697585314512253, 0.059214793145656586, 0.033294036984443665, 0.004370830487459898,
    0.0198268610984087, -0.019813857972621918, -0.030182044953107834, 0.00282604550011456, 0.0013799529988318682, -0.004124338272958994, 0.006069283466786146, 0.014789555221796036,
    0.03345221281051636, 0.005640876479446888, -0.041773539036512375, 0.01955321431159973, -0.01792784035205841, 0.019510900601744652, -0.015097356401383877, -0.022177694365382195,
    0.019186757504940033, -0.005288413260132074, -0.021318648010492325, -0.01616291143000126, -0.0009542020852677524, 0.005869971122592688, -0.014896106906235218, -0.05332693085074425,
    -0.012580298818647861, -0.015260128304362297, -0.004780930001288652, 0.036351196467876434, -0.009517953731119633, 0.013302681036293507, 0.008380769751966, -0.01214534044265747,
    0.021310361102223396, -0.02137117274105549, -0.026546403765678406, -0.012272837571799755, -0.007850267924368382, 0.0026398145128041506, 0.012051018886268139, -0.010450937785208225,
    -0.015626270323991776, -0.009580878540873528, 0.014418060891330242, -0.0017418693751096725, 0.015160124748945236, -0.04463692009449005, 0.01203383132815361, -0.030673084780573845,
    -0.010862227529287338, -0.005617222283035517, 0.018596621230244637, -0.007445798255503178, -0.025967178866267204, -0.012719524092972279, 0.01755884848535061, 0.022075297310948372,
    -0.04141883924603462, 0.023899339139461517, 0.04715520143508911, -0.014133094809949398, 0.011344256810843945, -0.0225730761885643, 0.02814725786447525, -0.0072275674901902676,
    0.006205049343407154, -0.0014122109860181808, -0.019730083644390106, 0.014341508038341999, 0.031857263296842575, -0.0028208536095917225, 0.014118392951786518, -0.038116298615932465,
    -0.01886998489499092, -0.002836378291249275, -0.007825224660336971, -0.024332547560334206, 0.003895750269293785, -0.00797534640878439, 0.044447705149650574, 0.0003504644555505365,
    0.004440816584974527, 0.03178104758262634, 0.05903170630335808, 0.0038371419068425894, 0.008445424027740955, 0.003515176009386778, -0.02188771404325962, 0.004116924479603767,
    -0.0169411301612854, 0.010584653355181217, 0.011156599968671799, -0.006127378437668085, 0.003080478636547923, 0.0006053340621292591, -0.0009539902093820274, -0.004237707704305649,
    -0.039517711848020554, 0.024955464527010918, -0.018942004069685936, -0.005120735615491867, -0.01787475124001503, 0.011764240451157093, 0.02045753225684166, 0.0009021667065098882,
    -0.007792084012180567, -0.000568435643799603, 0.00602881982922554, 0.00784928910434246, -0.004101203288882971, -0.004562504589557648, 0.02144119143486023, 0.01730245351791382,
    -0.003452189965173602, 0.03115849755704403, -0.026424871757626534, -0.006111837923526764, 0.0361502431333065, 0.0035869297571480274, -0.016370631754398346, -0.011445390060544014,
    -0.00405515544116497, -0.003785553388297558, -0.013359368778765202, -0.01474844478070736, 0.002390917856246233, 0.0187210775911808, 0.028683684766292572, -0.0021989301312714815,
    0.0005505188601091504, 0.008422273211181164, -0.02622157149016857, -0.0144405672326684, 0.002297724364325404, 0.004839800763875246, -0.0038464879617094994, -0.013500850647687912,
    -0.009517881087958813, -0.007931501604616642, 0.013037394732236862, 0.017469510436058044, -0.01302986592054367, -0.006892655976116657, -0.0005970756174065173, 0.0020469205919653177,
    -0.0015356797957792878, 4.950773291056976e-05, 0.006793639622628689, 0.023321418091654778, 0.0005057239904999733, 0.033156342804431915, 0.019683361053466797, 0.004625032190233469,
    0.018259070813655853, 0.004009926225990057, 0.008813748136162758, -0.01858934946358204, 0.005695708561688662, -0.0033813416957855225, -0.004098823759704828, -0.0057591102086007595,
    -0.005255209747701883, 0.018093565478920937, 0.003203420899808407, -0.023353204131126404, 0.017857417464256287, -0.005700118839740753, -0.012052268721163273, 0.0021825882140547037,
    -0.005258933175355196, 0.0026465286500751972, -0.006344281602650881, 0.006062665954232216, -0.012551954947412014, 0.046690188348293304, 0.024826763197779655, 0.010370679199695587,
    0.007343501318246126, 0.005674665793776512, -0.0008888106094673276, 0.008581520058214664, -0.00854213535785675, -0.01046692579984665, 0.006952587515115738, -0.008327726274728775,
    0.011704900301992893, 0.00623221043497324, -0.005575025454163551, -0.001681971363723278, -0.011112863197922707, 0.03786591812968254, 0.013145185075700283, 0.011694934219121933,
    -0.0034396126866340637, 0.002914219629019499, 0.027881279587745667, 0.0019392170943319798, -0.001854972797445953, 0.005738192703574896, -0.021975474432110786, -0.024389298632740974,
    0.0350380539894104, 0.003071787068620324, 0.0014948324533179402, -0.005210042465478182, 0.004054013639688492, -0.009059656411409378, 0.008435777388513088, 0.0006916935089975595,
    0.012594965286552906, -0.004245056305080652, 0.026127895340323448, -0.03482687100768089, -0.003693625098094344, 0.021208375692367554, -0.009530297480523586, -0.0130145363509655,
    -0.014109982177615166, 0.006653612945228815, -0.050744831562042236, 0.021777981892228127, 0.005586208775639534, 0.0008341979118995368, -0.03629419580101967, 0.03857697173953056,
    0.008876332081854343, -0.049497246742248535, -0.005710665136575699, 0.021544691175222397, 0.01095005962997675, 0.013579245656728745, -0.05044422671198845, -0.020714668557047844,
    -0.0014624942559748888, 0.015198628418147564, 0.007905022241175175, 0.009476672857999802, 0.022948812693357468, -0.014799916185438633, 0.019487999379634857, 0.0005207399954088032,
    0.042219553142786026, -0.01372300274670124, 0.006656852550804615, 0.006687412969768047, 0.020653745159506798, 0.017234880477190018, 0.007295976392924786, -0.023176075890660286,
    0.013120749965310097, -0.00865314994007349, 0.012658121064305305, 0.005808490328490734, 0.032925453037023544, 0.008482186123728752, -0.02323017083108425, 0.004728368017822504,
    0.028949253261089325, 0.01139778457581997, -0.011244513094425201, 0.028390828520059586, -0.008904258720576763, -0.032704077661037445, -0.018695998936891556, -0.016823342069983482,
    0.012027883902192116, -0.017333967611193657, 0.026905180886387825, -0.01224491186439991, -0.007842938415706158, -0.002955822041258216, -0.013321942649781704, -0.007878420874476433,
    -0.030758390203118324, -0.009569748304784298, 0.008728694170713425, 0.00013879736070521176, -0.004425280727446079, 0.023981163278222084, 0.018369274213910103, 0.028135528787970543,
    -0.010815939866006374, -0.002378877019509673, -0.036782123148441315, -0.02501688152551651, -0.0032857495825737715, 0.005901315249502659, -0.039944346994161606, 0.007313644513487816,
    0.01908206380903721, -0.020486963912844658, 0.03075341135263443, -0.0106638940051198, -0.00594783341512084, -8.387531852349639e-05, 0.0017859854269772768, -0.005963820032775402,
    0.016396570950746536, 0.018929485231637955, -0.04624880477786064, 0.0197224672883749, 0.0028708961326628923, 0.04316306859254837, -0.01277807168662548, 0.045865681022405624,
    0.015307694673538208, -0.02928965538740158, 0.004951018374413252, -0.00040465721394866705, -0.009479382075369358, 0.019643206149339676, -0.005192403215914965, -0.0015342754777520895,
    0.020492365583777428, -0.015562649816274643, -0.023573530837893486, -0.012053405866026878, -0.03779325634241104, -0.02564617432653904, -0.03252125531435013, -0.014558871276676655,
    -0.028611507266759872, -0.013851146213710308, 0.025397006422281265, 0.007786688860505819, -0.022879239171743393, 0.006519203074276447, 0.0253579244017601, 0.01974865049123764,
    0.004763595759868622, 0.010434460826218128, -0.002845550887286663, 0.020511522889137268, 0.041549257934093475, -0.013686766847968102, -0.015531366690993309, -0.007975893095135689,
    0.0502784363925457, -0.006446905434131622, 0.016881771385669708, 0.0054992916993796825, 0.025454439222812653, -0.001445012865588069, 0.048051197081804276, 0.015327954664826393,
    -0.021595511585474014, -0.022416405379772186, -0.05967176333069801, -0.026787718757987022, 0.017476096749305725, -0.007904699072241783, 0.007000085432082415, 0.005683444440364838,
    0.01960805431008339, -0.015098677016794682, 0.00036267118412069976, -0.02478705532848835, 0.023092592135071754, -0.028647437691688538, -0.003117347601801157, 0.01678207516670227,
    -0.007589627988636494, 0.006431439891457558, -0.0055917962454259396, -0.04037095233798027, -0.018777916207909584, 0.019902406260371208, -0.024291930720210075, -0.011492821387946606,
    -0.0202631838619709, -0.018949726596474648, 0.0390508696436882, -0.006532980594784021, -0.028230687603354454, -0.00600395305082202, 0.04561714828014374, -0.02795618586242199,
    -0.026603376492857933, 0.0006890033837407827, -0.025534849613904953, 0.004737890791147947, -0.0018568444065749645, -0.010783283971250057, -0.015304893255233765, -0.022829290479421616,
    0.02432415261864662, -0.013723737560212612, 0.020512433722615242, -0.002467058366164565, -0.008215716108679771, -0.006925194524228573, 0.01076587662100792, -0.03101874515414238,
    0.021252376958727837, -0.009005986154079437, 0.01267404668033123, -0.042582638561725616, 0.046130530536174774, 0.028174785897135735, 0.0071914480067789555, -0.0067798118107020855,
    0.01837136037647724, 0.0031922240741550922, -0.00021900214778725058, 0.03744123876094818, 0.004770827013999224, 0.021053854376077652, -0.030507998540997505, 0.011927379295229912,
    -0.015783725306391716, -0.03316709026694298, 0.049091264605522156, 0.014841222204267979, -9.406883327756077e-05, -0.01062843482941389, 0.030072040855884552, -0.007805005647242069,
    0.029907740652561188, -0.01340563129633665, 0.016323167830705643, -0.025510989129543304, -0.0013638335512951016, -0.006281199399381876, -0.003201464656740427, -0.007252541836351156,
    -0.0015978575684130192, 0.02303106151521206, -0.018120545893907547, -0.007876576855778694, 0.01640208810567856, -0.042738158255815506, 0.025054166093468666, -0.03918742015957832,
    0.009158236905932426, -0.010858078487217426, 0.013575621880590916, 0.0016372405225411057, 0.018359927460551262, 0.003701508045196533, -0.0033343140967190266, -0.01599319837987423,
    -0.008070792071521282, 0.011507331393659115, 0.017042135819792747, -0.002695166040211916, 0.004803367890417576, -0.00485982745885849, 0.0005102306022308767, 0.02597828023135662,
    -0.01706661283969879, -0.0012911193771287799, 0.010456018149852753, 0.03372158110141754, 0.04472623020410538, -0.008231043815612793, -0.031640443950891495, -0.0434950515627861,
    0.004532331600785255, -0.005997310858219862, -0.014040765352547169, -0.000958158983848989, 0.005902981851249933, 0.020524587482213974, 0.022301362827420235, 0.02275780215859413,
    -0.03417952358722687, 0.019538408145308495, 0.03199415281414986, 0.010500269010663033, -0.01857534982264042, -0.0004726310435216874, -0.03407920151948929, -0.01074601337313652,
    0.024721672758460045, -0.04902461916208267, -0.03109096735715866, -0.01703653484582901, -0.013015796430408955, -0.0016000287141650915, 0.014393683522939682, -0.0033335499465465546,
    -0.06519340723752975, -0.007335723843425512, -0.016665715724229813, -0.017660804092884064, -0.004272562451660633, 0.009841861203312874, -0.027274753898382187, 0.002246901858597994,
    0.032813966274261475, -0.008691125549376011, -0.0035090367309749126, 0.019251199439167976, -0.007422330789268017, -0.020598312839865685, 0.026226775720715523, 0.021800681948661804,
    -0.02378150075674057, 0.023796701803803444, -0.020695632323622704, 0.00762447714805603, -0.03122595138847828, -0.023450026288628578, 0.0030722084920853376, 0.008428473025560379,
    0.013010488823056221, -0.007835007272660732, -0.0025131353177130222, 0.004278924316167831, 0.0038255529943853617, -0.009160269983112812, -0.01152075082063675, 0.036699675023555756,
    0.005498192738741636, -0.021059606224298477, -0.013043348677456379, -0.010290983133018017, 0.02610832266509533, 0.024020060896873474, -0.01577925682067871, -0.023734159767627716,
    -0.014270903542637825, 0.027378173545002937, -0.010871120728552341, -0.0008625652408227324, 0.04339195415377617, -0.0036852413322776556, -0.04529712349176407, -0.01058890949934721,
    0.02111523412168026, 0.004320916254073381, -0.0022500993218272924, -0.05607760325074196, -0.036996569484472275, -0.007916147820651531, 0.017915882170200348, -0.020713921636343002,
    0.012225774116814137, -0.03371281176805496, -0.02452308125793934, 0.024742981418967247, -0.005767420865595341, -0.011196909472346306, 0.005488160531967878, -0.00016672062338329852,
    -0.028918616473674774, -0.02477823942899704, 0.016729874536395073, -0.02967034839093685, 0.009542467072606087, 0.000792910170275718, 0.018834391608834267, -0.011374501511454582,
    -0.010732704773545265, 0.025992050766944885, -0.005145943723618984, 0.01683535799384117, -0.007577148731797934, 0.026806671172380447, 0.010630029253661633, 0.018709611147642136,
    -0.021961933001875877, -0.02179097943007946, 0.02217927947640419, 0.011194574646651745, -0.028476398438215256, -0.007650986313819885, 0.010503092780709267, 0.0585651732981205,
    -0.0014470948372036219, -0.03128984943032265, -0.014167730696499348, -0.0021016860846430063, -0.0015632996801286936, 0.005923864431679249, 0.026897428557276726, -0.029581645503640175,
    0.019851548597216606, 0.005176338367164135, 0.013485604897141457, -0.024626772850751877, 0.026368524879217148, 0.0014184722676873207, -0.013089068233966827, 0.0025212697219103575,
    -0.025201648473739624, 0.009835885837674141, 0.0741860494017601, -0.013463236391544342, -0.018597478047013283, -0.03536413982510567, 0.041267745196819305, 0.00655294768512249,
    0.011285575106739998, -0.018389346078038216, -0.006426109001040459, -0.0011281127808615565, -0.0001739911240292713, -0.007729653734713793, -0.029457662254571915, 0.0008947066380642354,
    -0.027538899332284927, 0.022126592695713043, -0.03312038630247116, 0.03253699094057083, 0.005061481613665819, 0.02519729547202587, 0.01755019836127758, -0.013915032148361206,
    0.02991027943789959, 0.019635770469903946, -0.0013413050910457969, -0.05216295272111893, -0.0032099331729114056, 0.00013562191452365369, -0.004059932194650173, 0.029470372945070267,
    0.031099369749426842, 0.00916398037225008, 0.04764925688505173, 0.0078768040984869, 0.010678629390895367, -0.01680385135114193, -0.013437043875455856, 0.015497171320021152,
    -0.008082461543381214, 0.034956369549036026, -0.011787082999944687, -0.002918975194916129, -0.0010631870245561004, 0.01677376963198185, -0.02689887024462223, 0.0034678110387176275,
    -0.023614395409822464, 0.014995482750236988, 0.028769953176379204, -0.015673799440264702, -0.018511377274990082, 0.018405478447675705, -0.005770647898316383, -0.025676704943180084,
    0.0025333426892757416, 0.03182556480169296, -0.008805819787085056, 0.023601818829774857, 0.0013756266562268138, -0.024329109117388725, 0.017315031960606575, 0.025019841268658638,
    -0.004630847834050655, 0.0014550639316439629, 0.001403043163008988, -0.026418743655085564, -0.012826113030314445, 0.01797868125140667, -8.562905713915825e-05, 0.009002047590911388,
    -0.007054920308291912, -0.01029340922832489, -0.020246531814336777, -0.017829203978180885, 0.055885061621665955, -0.017084885388612747, -0.021877210587263107, -0.016241425648331642,
    0.004073113668709993, 0.02452120929956436, 0.014772238209843636, -0.003177124308422208, -0.009795093908905983, 0.021057521924376488, -0.00036520877620205283, -0.013365051709115505,
    -0.015426620841026306, 0.021473253145813942, 0.005917655769735575, 0.014371953904628754, -0.011639808304607868, 0.00990322232246399, -0.002252126345410943, -0.008512046188116074,
    -0.009077821858227253, -0.034227047115564346, -0.0007308613858185709, 0.0031287483870983124, -0.022784456610679626, 0.00307907210662961, -0.007857942022383213, -0.014168362133204937,
    -0.014146949164569378, 0.021528679877519608, -0.03177879378199577, 0.0010788899380713701, -0.0036106249317526817, -0.03689821437001228, 0.02459436096251011, 0.009403770789504051,
    -0.009473917074501514, 0.0075973705388605595, 0.015235917642712593, -0.011070547625422478, 0.01947372406721115, -0.006976172793656588, -0.019498063251376152, 0.034182749688625336,
    -0.006051370408385992, -0.0042963880114257336, 0.02097533829510212, 0.007158131338655949, -0.023742366582155228, -0.010547435842454433, -0.015076263807713985, 0.03456651791930199,
    -0.014240985736250877, -0.00031540647614747286, -0.03461746871471405, 0.003897979622706771, 0.04765762761235237, 0.028261426836252213, -0.035401131957769394, -0.027938315644860268,
    0.057968832552433014, 0.03226415812969208, 0.04946749284863472, 0.014599084854125977, -0.011635075323283672, -0.0058038798160851, 0.003453981364145875, -0.00730002298951149,
    -0.003817659104242921, -0.00823487713932991, -0.0033057916443794966, -0.008778420276939869, -0.007018753793090582, 0.04436131566762924, -0.035675909370183945, 0.00047958054346963763,
    0.02233504317700863, -0.04505252093076706, -0.017577089369297028, 0.012903011403977871, 0.0019901562482118607, -0.007522376719862223, 0.016519345343112946, -0.021089134737849236,
    -0.021539604291319847, 0.03212805837392807, 0.03835076093673706, -0.02945433184504509, 0.015161017887294292, 0.03429791331291199, 0.015027891844511032, 0.012439270503818989,
    0.06424746662378311, -0.024731894955039024, -0.035275425761938095, -0.002723139710724354, 0.0021188079845160246, 0.016313835978507996, -0.04098190367221832, 0.012997696176171303,
    0.0037586637772619724, -0.0019095371244475245, -0.010229130275547504, -0.0093682324513793, 0.03550039604306221, 0.008245950564742088, 0.03618589788675308, -0.006844405550509691,
    -0.005205237306654453, 0.018693534657359123, -0.004288787953555584, -0.019380012527108192, -0.014147927984595299, 0.00856543704867363, 0.010892731137573719, 0.01161775179207325,
    0.013911021873354912, 0.012354033067822456, -0.0075764525681734085, -0.05542585998773575, -0.014176874421536922, -0.0022605787962675095, 0.01834684982895851, -0.016315780580043793,
    0.0048266989178955555, 0.01225163135677576, 0.025611771270632744, 0.005561759229749441, 0.00245025590993464, 0.002545388648286462, 0.023509614169597626, 0.02431829459965229,
    -0.05446328595280647, -0.016447827219963074, -0.025677025318145752, -0.015732262283563614, 0.006142122205346823, -0.00515061104670167, -0.022537097334861755, 0.007767927832901478,
    0.019713014364242554, -0.0009542190236970782, 0.04127180948853493, -0.04065641760826111, 0.004058510530740023, -6.514503911603242e-05, -0.006927840411663055, -8.494444045936689e-05,
    0.046346791088581085, -0.013708478771150112, 0.02438337728381157, 0.005283402279019356, 0.0040487744845449924, -0.02205403707921505, -0.013642764650285244, 0.014948424883186817,
    0.017921410501003265, -0.0029648425988852978, -0.0014414237812161446, -0.005670484155416489, -0.049794990569353104, 0.013575637713074684, 0.007006512023508549, -0.05938349664211273,
    -0.0303350780159235, 0.005993775092065334, -0.0037180406507104635, -0.0097297178581357, -0.012946465983986855, -0.007055738475173712, -0.012323918752372265, 0.05539124086499214,
    -0.002384213963523507, 0.0008987624896690249, 0.007994631305336952, -0.008479895070195198, 0.010335655882954597, -0.003860459430143237, -0.03016851097345352, 0.0027324554976075888,
    -0.014977838844060898, -0.002962475875392556, 0.031225422397255898, -0.006438888609409332, 0.0157169122248888, -0.009661443531513214, 0.015877781435847282, 0.0363430418074131,
    -0.01366668101400137, -0.026949739083647728, -0.022691218182444572, 0.03278110548853874, 0.002778633264824748, -0.029605086892843246, 0.009408603422343731, -0.01567460224032402,
    -0.0469321645796299, -0.012504864484071732, -0.0244964137673378, 0.015990523621439934, 0.008335685357451439, -0.06674575060606003, 0.04285670816898346, -0.05203773081302643,
    0.02471720613539219, 0.01219672616571188, 0.03078472800552845, 0.005232200957834721, 0.015181322582066059, -0.010262768715620041, 0.011738985776901245, 0.042753953486680984,
    0.01319693773984909, -0.03026251122355461, -0.043365031480789185, 0.012467902153730392, 0.033775441348552704, -0.055977899581193924, -0.005037046503275633, -0.009049640037119389,
    -0.047064509242773056, -0.01559059601277113, 0.0011726729571819305, 0.016595805063843727, 0.001058211550116539, 0.002569868927821517, 0.04872763529419899, -0.0014399001374840736,
    -0.020275002345442772, -0.01004917174577713, -0.0031098173931241035, 0.040747884660959244, 0.025479977950453758, 0.009606901556253433, -0.011397307738661766, 0.028118165209889412,
    -0.006662775296717882, 0.037651948630809784, 0.015193796716630459, 0.01659926027059555, -0.0377373993396759, -0.0030087565537542105, -0.023641668260097504, 0.0010771732777357101,
    -0.01039169356226921, -0.006004663649946451, -0.03885447233915329, 0.03998267278075218, 0.009777733124792576, 0.00824861042201519, 0.017180178314447403, -0.0016511721769347787,
    -0.004047734197229147, -0.0012975011486560106, 0.016693642362952232, 0.01716572791337967, 0.041809409856796265, 0.0203322172164917, -0.00633174367249012, 0.007987460121512413,
    0.03556777536869049, -0.0015357885276898742, 0.0100692855194211, 0.02703871950507164, -0.0094382269307971, -0.003160723252221942, 0.013296266086399555, -0.001199364080093801,
    -0.03152342513203621, -0.015187535434961319, 0.04127497598528862, 0.05490398406982422, 0.01811269111931324, 0.00428376579657197, 0.024167552590370178, -0.03428155928850174,
    -0.03127564862370491, 0.02074357308447361, -0.00024269730783998966, 0.04025862365961075, 0.010424885898828506, 0.029738642275333405, 0.04506250098347664, -0.013326955027878284,
    -0.022288978099822998, -0.03687348589301109, -0.004973333328962326, -0.00205541611649096, 0.029760757461190224, -0.007414824329316616, -0.027688361704349518, -0.04795197397470474,
    -0.023658424615859985, 0.0039926497265696526, 0.0014664772897958755, 0.00836381409317255, 0.005680153612047434, 0.043024759739637375, 0.016935640946030617, -0.017708048224449158,
    0.024616573005914688, -0.012444236315786839, 0.004481594078242779, -0.0008987919427454472, 0.014755193144083023, -0.04101436957716942, 0.020111609250307083, 0.028163664042949677,
    0.005480092950165272, -0.008993486873805523, -0.03163046017289162, -0.006499508395791054, 0.0034122017677873373, 0.0005811660084873438, -0.011898295022547245, -0.023526351898908615,
    -0.01853231154382229, -0.03894193097949028, 0.006767519284039736, -0.008270945399999619, 0.006814615335315466, 0.020673351362347603, -0.016785847023129463, 0.021606868132948875,
    0.05636309087276459, 0.031911708414554596, -0.017336713150143623, -0.009644106961786747, 0.02792263962328434, 0.012110616080462933, -0.00820309016853571, -0.01863832026720047,
    -0.003443303517997265, 0.03554069250822067, 0.003557562595233321, 0.035589952021837234, -0.030768198892474174, 0.0015434538945555687, -0.04839199408888817, -0.04592987149953842,
    0.01123324315994978, -0.006536442320793867, 0.0598161444067955, -0.006821741815656424, -0.0015244788955897093, -0.008298787288367748, -0.03576144576072693, -0.01551921758800745,
    0.025072718039155006, 0.05757804214954376, 0.03901945799589157, -0.007792215794324875, -0.027135584503412247, -0.021260946989059448, 0.006929770112037659, 0.006548360921442509,
    0.01042148843407631, 0.017429981380701065, 0.0341859832406044, -0.03222987800836563, 0.007620915770530701, 0.03352450579404831, -0.010919478721916676, -0.00722136115655303,
    0.014043509028851986, 0.030849793925881386, -0.002893976867198944, -0.01839752309024334, 0.014454632997512817, -0.00666153896600008, 0.05968394875526428, -0.024730242788791656,
    -0.01567051373422146, 0.0234682597219944, 0.02865348942577839, -0.037844467908144, 0.01792282424867153, 0.026618249714374542, -0.019524531438946724, -0.0006578365573659539,
    0.02991303987801075, -0.02796573005616665, -0.018420841544866562, 0.02186727710068226, -0.03643438220024109, -0.06892634183168411, -0.0005320811178535223, -0.04292138293385506,
    -0.010237802751362324, -0.0071116103790700436, 0.01200046855956316, 0.0020870857406407595, 0.023162417113780975, 0.021856287494301796, 0.001680972520262003, -0.01486872136592865,
    -0.007182794157415628, -0.008368415758013725, -0.0028772042132914066, 0.028810417279601097, -0.03933071717619896, -0.008192994631826878, -0.04232574254274368, 0.0064205601811409,
    -0.012463976629078388, -0.01966032199561596, -0.003879669588059187, 0.009882437996566296, -0.01604709029197693, -0.0034264824353158474, -0.01057599950581789, 0.00934983417391777,
    -0.0023825210519135, 0.0017936519579961896, -0.030919604003429413, -0.011011017486453056, -0.004351170267909765, 0.007349335588514805, 0.019224902614951134, 0.004156230483204126,
    -0.02681194618344307, 0.00558348186314106, -0.013559077866375446, -0.0067667653784155846, -0.04247499629855156, -0.032408155500888824, 0.02380792796611786, -0.03104967437684536,
    -0.012165749445557594, 0.002516087843105197, -0.01161243300884962, -0.0009484231122769415, -0.01191836129873991, 0.03069685958325863, 0.00817725621163845, -0.010085496120154858,
    -0.012630530633032322, -0.01293843612074852, 0.011415112763643265, -0.0011804350651800632, 0.011596850119531155, 0.0054212212562561035, 0.009118642657995224, -0.020045414566993713,
    0.043461695313453674, 0.03346198797225952, 0.016984373331069946, -0.017768623307347298, 0.01070139929652214, 0.00703577883541584, -0.006782888900488615, -0.009500800631940365,
    -0.030961189419031143, 0.013828122988343239, 0.022989938035607338, -0.008883332833647728, -0.00266876257956028, 0.005708165932446718, 0.013230024836957455, 0.015513750724494457,
    -0.01367131806910038, -0.01895804889500141, -0.018322622403502464, 0.036768171936273575, -0.0031028904486447573, 0.03444337844848633, 0.021760519593954086, -0.02792392671108246,
    0.004965342581272125, 0.0004059066704940051, 0.025005007162690163, -0.012279266491532326, -0.0224616602063179, 0.014243516139686108, 0.01688460074365139, 0.022088022902607918,
    0.00038119734381325543, -0.01809767074882984, 0.01987902633845806, 0.006885720882564783, 0.038807447999715805, -0.00633768318220973, -0.014826166443526745, 0.023921916261315346,
    0.004023353103548288, 0.01410615909844637, -0.0019486728124320507, 0.001743085216730833, 0.0056333537213504314, -0.002820800058543682, -0.00961396750062704, -0.024299466982483864,
    -0.010100786574184895, 0.01622602716088295, -0.009419257752597332, 0.01084949541836977, -0.0005511520430445671, -0.03643583133816719, -0.0034222302492707968, 0.004582565743476152,
    0.007343982346355915, -0.00845049973577261, -0.0013701077550649643, -0.01761816255748272, -0.02413412742316723, 0.01163395307958126, -0.0011340701021254063, -0.005483304150402546,
    0.04621933773159981, 0.014083740301430225, -0.011614233255386353, 0.014535786584019661, -0.024984220042824745, -0.024564256891608238, -0.01617898792028427, -0.007576743606477976,
    -0.05554937198758125, -0.02053169161081314, 0.03137214109301567, -0.013072819449007511, -0.005313617642968893, -0.013247385621070862, 0.03849150985479355, 0.016376778483390808,
    -0.03091428428888321, 0.03590966388583183, 0.010996962897479534, -0.035526443272829056, 0.013729828409850597, 0.003419883083552122, -0.006642294116318226, 0.004636256489902735,
    -0.05448829010128975, 0.0024883330333977938, 0.01891488954424858, 0.020018842071294785, -0.005003166384994984, -0.04492267966270447, -0.024217884987592697, -0.00023198116105049849,
    0.011506750248372555, 0.012730530463159084, 0.040369078516960144, 0.0014965528389438987, -0.009751051664352417, -0.007356261368840933, 0.0127145079895854, -0.0023374080192297697,
    -0.012277921661734581, -0.01979534886777401, 0.027307547628879547, -0.006137463729828596, -0.012003829702734947, 0.008422172628343105, -0.02747512422502041, 0.07021840661764145,
    -0.00774745037779212, -0.006922083906829357, 0.009407336823642254, 0.012768631801009178, 0.019389590248465538, 0.005719590932130814, -0.06658288091421127, 0.0038102339021861553,
    6.372619100147858e-05, 0.02053576521575451, 0.04701125621795654, 0.017566734924912453, -0.03318709880113602, -0.004897597711533308, -0.03449663519859314, 0.044714394956827164,
    -0.034273259341716766, 0.015878424048423767, -0.016675949096679688, 0.005570908077061176, 0.0020385505631566048, -0.008125395514070988, -0.021069375798106194, 0.0037451747339218855,
    -0.03195761516690254, -0.004974377807229757, -0.03412695974111557, -0.016376638785004616, -0.03820140287280083, 0.001244096551090479, 0.004675132222473621, -0.017826473340392113,
    -0.03179142251610756, -0.03916625678539276, 0.001867622253485024, 0.018482649698853493, 0.02501107007265091, 0.024099551141262054, 0.013131089508533478, -0.01764046400785446,
    -0.013850394636392593, 0.03899763152003288, 0.0030364429112523794, 0.006845143157988787, 0.053073517978191376, -0.010810112580657005, 0.009553978219628334, 0.008916608989238739,
    -0.008023143745958805, -0.022666797041893005, -0.033001966774463654, -0.004650494549423456, -0.006858496926724911, 0.004382778890430927, -0.01987340673804283, -0.011428621597588062,
    -0.025584464892745018, -0.01435746531933546, 0.017813632264733315, 0.011367117054760456, -0.0016229214379563928, -0.009990205988287926, 0.0017953008646145463, 0.04483896493911743,
    -0.000807526579592377, -0.025654776021838188, -0.009594086557626724, 0.0075071752071380615, 0.01199229247868061, 0.037634868174791336, -0.04145876690745354, 0.009719843976199627,
    0.016577906906604767, 0.012828338891267776, -0.002718513598665595, 0.00451695965602994, -0.007398589979857206, -0.0035226752515882254, -0.025535207241773605, -0.004864801187068224,
    -0.03479187935590744, 0.0008194388938136399, -0.012234490364789963, -0.0021568352822214365, -0.048779819160699844, -0.05277293547987938, 0.0440368577837944, 0.022041436284780502,
    0.025913827121257782, 0.02934892848134041, -0.042254988104104996, -0.019956892356276512, 0.007360109593719244, -0.011087627150118351, -0.022833451628684998, -0.01435449905693531,
    -0.03313848003745079, -0.03929462656378746, 0.009463266469538212, 0.021840699017047882, -0.00344338221475482, 0.00048820007941685617, -0.00729023152962327, 0.016234630718827248,
    0.03854585066437721, -0.006725088693201542, 0.06513456255197525, 0.02737490087747574, 0.04097037389874458, 0.0454225018620491, -0.0017984737642109394, -0.013075311668217182,
    -0.005589793436229229, -0.012397798709571362, -0.004222717136144638, -0.003748314455151558, -0.02869023010134697, -0.060433726757764816, -0.009508313611149788, -0.010705751366913319,
    -0.0051222494803369045, 0.024570688605308533, -0.003873047884553671, 0.0016458238242194057, -0.0057402621023356915, -0.05318879708647728, -0.00487864762544632, -0.024115219712257385,
    -0.0003294471825938672, 0.0045638252049684525, -0.0041946652345359325, -0.012331301346421242, 0.008326943963766098, 0.0005502430722117424, 0.03668411821126938, 0.031300950795412064,
    0.021739087998867035, -0.031175784766674042, -0.0114483293145895, -0.0029948665760457516, -0.0064153303392231464, -0.02276698686182499, -0.0032165138982236385, 0.004106144420802593,
    0.04714405909180641, -0.0021978984586894512, 0.01287904568016529, -0.017265133559703827, -0.00421816436573863, 0.013259819708764553, -0.011161253787577152, 0.0053090909495949745,
    0.008593075908720493, 0.025933176279067993, -0.0020397042389959097, 0.012334026396274567, -0.00452421884983778, -0.007645458448678255, -0.03072076477110386, -0.02559112198650837,
    -0.008537592366337776, -0.00029587128665298223, -0.020979169756174088, -0.0006849063793197274, 0.010035543702542782, -0.00778892170637846, -0.026535850018262863, -0.039108313620090485,
    0.0024762481916695833, -0.033974189311265945, 0.004179182928055525, 0.012144459411501884, -0.00543778482824564, -0.004463736899197102, -0.01899360492825508, -0.06217890977859497,
    0.011380773037672043, 0.011721127666532993, -0.011367002502083778, -0.0005780202336609364, 0.0458318367600441, 0.018639281392097473, 0.0034879795275628567, -0.027716869488358498,
    0.03006095066666603, 0.003359756665304303, 0.005281733348965645, -0.004239444620907307, -0.0012859671842306852, 0.03298324719071388, -4.998474196327152e-06, -0.031159840524196625,
    0.020365506410598755, -0.00012667056580539793, -0.010109513998031616, -0.023474082350730896, 0.026304006576538086, 0.008428625762462616, 0.02263951674103737, -0.012642737478017807,
    -0.004036937840282917, -0.0399329848587513, -0.02826988883316517, 0.008718203753232956, 0.007533116731792688, 0.017794089391827583, 0.03251618891954422, 0.006365189328789711,
    -0.01786583475768566, -0.01735338568687439, 0.01107089500874281, 0.01947196014225483, 0.020711250603199005, -0.01781812123954296, 0.03129574656486511, -0.04398029297590256,
    0.023777853697538376, 0.009626277722418308, -0.00709167867898941, 0.05029796063899994, -0.01846364326775074, 0.0028432363178581, 0.02825053595006466, -0.000930135021917522,
    -0.02142232470214367, 0.06928230822086334, 0.03537055104970932, 0.0025913517456501722, -0.01769799366593361, 0.009186847135424614, 0.032028261572122574, 0.015657052397727966,
    0.006413225084543228, -0.010514824651181698, 0.056095320731401443, -0.031016450375318527, 0.03095044381916523, 0.012227064929902554, -0.05432271212339401, 0.008885162882506847,
    -0.01023833267390728, -0.011097933165729046, -0.008463249541819096, -0.005632133223116398, -0.012457418255507946, 0.0032678835559636354, -0.025533348321914673, -0.00726654939353466,
    0.0049599274061620235, 0.01052183099091053, 0.03208433836698532, -0.020258452743291855, -0.013296699151396751, 0.0006642346852459013, 0.011421804316341877, -0.005921517964452505,
    -0.011283076368272305, -0.005190195515751839, -0.009490042924880981, 0.01817268878221512, -0.01894480362534523, -0.011246304027736187, -0.01495278999209404, -0.0057660434395074844,
    -0.024953627958893776, -0.00021365094289649278, -0.0068095591850578785, -0.018807895481586456, 0.01503710262477398, 0.02215525694191456, 0.003770965151488781, -0.019246511161327362,
    0.017646485939621925, -0.03429540991783142, 0.040185268968343735, 0.005621324758976698, -0.0031004103366285563, -0.024673843756318092, -0.012411735951900482, 0.005002258345484734,
    0.05165249481797218, 0.0291751716285944, -0.026115894317626953, 0.0001506552071077749, -0.00213353568688035, -0.022272948175668716, -0.02874903567135334, 0.04233059659600258,
    -0.011093654669821262, -0.012879653833806515, 0.005645480006933212, 0.004026434849947691, -0.029230261221528053, -0.01586201600730419, -0.016737809404730797, 0.015735018998384476,
    -0.02935701608657837, 0.03301646187901497, 0.0007808808004483581, -0.01891471818089485, 0.027575714513659477, -0.011943584308028221, 0.00030373025219887495, -0.010002311319112778,
    0.031038571149110794, 0.009367072023451328, 0.03131760656833649, 0.004140990786254406, -0.010792513377964497, -0.016432972624897957, 0.03864575922489166, -0.01111680455505848,
    -0.008957111276686192, 0.01609857566654682, 0.006300982553511858, -0.008720006793737411, 0.002289074705913663, 0.020738786086440086, -0.007870628498494625, 0.017630917951464653,
    -0.009244300425052643, 0.03674554079771042, -0.027813613414764404, 0.012621616944670677, 0.012613230384886265, -0.01935817115008831, 0.008296267129480839, -0.004447408020496368,
    -0.015918301418423653, 0.0062939682975411415, 0.02310945838689804, 0.026195917278528214, -0.010681262239813805, -0.015101901255548, -0.015463676303625107, 0.02091498300433159,
    0.039165060967206955, 0.002267909236252308, 0.0016773869283497334, 0.00064360216492787, 0.005336579866707325, 0.018683794885873795, -0.03710992634296417, -0.016728825867176056,
    -0.046021539717912674, -0.0059005748480558395, 0.043768733739852905, -0.03279615193605423, 0.013820481486618519, 0.049107737839221954, 0.020948898047208786, -0.010333960875868797,
    0.022249268367886543, 0.017623843625187874, -0.006353412289172411, -0.006209854036569595, 0.040185220539569855, -0.0001429496769560501, -0.014500296674668789, 0.05374744161963463,
    -0.043992698192596436, -0.012924941256642342, -0.01993078924715519, -0.04315156862139702, 0.001314064604230225, -0.034926414489746094, 0.03382079675793648, -0.0036427509039640427,
    0.043327901512384415, 0.010622797533869743, -0.024288518354296684, 0.0017213537357747555, 0.02334524318575859, -0.015484513714909554, 0.03282146528363228, -0.04360472410917282,
    -0.009117159992456436, -0.027318334206938744, 0.03525650128722191, 0.010084741748869419, 0.027585241943597794, 0.009095119312405586, 0.010741016827523708, 0.014788161031901836,
    0.015314189717173576, -2.5752682631718926e-05, 0.008531039580702782, -0.010481501929461956, -0.0319371335208416, 0.005999686662107706, -0.021988654509186745, 0.022720208391547203,
    0.008074930869042873, 0.012082977220416069, 0.00992253702133894, 0.014722048304975033, 0.033571481704711914, -0.005560936406254768, -0.023359697312116623, 0.017770878970623016,
    -0.009661076590418816, -0.005676649510860443, -0.02806634083390236, 0.036414459347724915, -0.007207807153463364, -0.022466585040092468, -0.01070189569145441, 0.014905380085110664,
    0.017920957878232002, -0.006863584741950035, 0.024110984057188034, 0.00591869093477726, 0.015206408686935902, -0.007983798161149025, 0.037939757108688354, -0.02234659716486931,
    0.003542178776115179, 0.0069147334434092045, -0.020799484103918076, -0.006150932051241398, 0.017494233325123787, 0.009707087650895119, 0.004998501390218735, 0.01142006367444992,
    0.01653585396707058, 0.003350537270307541, -0.01405392587184906, 0.0054813832975924015, -0.009645446203649044, 0.003160004038363695, 0.0391167588531971, 0.004524005576968193,
    0.02015392854809761, 0.007559198886156082, -0.01944764330983162, 0.0006589859840460122, -0.012498071417212486, 0.005801457911729813, -0.057055696845054626, -0.01025403942912817,
    0.02371259406208992, -0.017243802547454834, -0.011213555000722408, -0.031122330576181412, -0.02495848387479782, 0.0008432121830992401, 0.03479953110218048, 0.006427606102079153,
    -0.02063160389661789, 0.013379030860960484, -0.003680257825180888, 0.02111504226922989, -0.006091341841965914, 0.029854536056518555, -0.03629922494292259, 0.026510119438171387,
    0.050480347126722336, -0.023661699146032333, 0.0075916266068816185, 0.0015242568915709853, -0.015929270535707474, -0.011120365932583809, -0.005150573793798685, 0.009690258651971817,
    0.007576589938253164, 0.01852334849536419, -0.009716439992189407, -0.027535831555724144, -0.048299722373485565, -0.018510794267058372, 0.018139833584427834, -0.034643758088350296,
    0.007667049299925566, 0.010524476878345013, -0.02700529247522354, -0.003008731873705983, -0.030245644971728325, 0.008782691322267056, 0.00915588065981865, -0.013861005194485188,
    -0.011580701917409897, -0.0009254462202079594, -0.020541854202747345, 0.03181293606758118, 0.01396108791232109, 0.004403610713779926, 0.016160083934664726, -0.003163378220051527,
    0.006376813631504774, -0.017149195075035095, -0.024147601798176765, -0.002479874761775136, 0.02759992703795433, -0.004943277221173048, 0.02375052496790886, -0.015141069889068604,
    0.005937561858445406, -0.01975869946181774, -0.001980073982849717, 0.0076006636954844, -0.0026358910836279392, -0.01231201272457838, -0.002688109641894698, 0.014945805072784424,
    -0.027869652956724167, -0.00790503527969122, -0.013266167603433132, -0.006016348488628864, 0.007421825546771288, 0.01794169284403324, -0.032770488411188126, 0.0016849118983373046,
    0.011231432668864727, 0.0009351598564535379, -0.01282066386193037, -0.020772671326994896, 0.012268888764083385, 0.01002130750566721, 0.055127136409282684, -0.0016334662213921547,
    -8.773047738941386e-05, -0.003599609714001417, -0.006749862339347601, -0.010641621425747871, -0.05387898534536362, -0.005842728074640036, -0.0019707472529262304, -0.026415877044200897,
    0.03485146909952164, 0.03226941451430321, -0.01726377010345459, -0.020432114601135254, 0.00484478659927845, 0.01746135763823986, -0.009254338219761848, -0.052013423293828964,
    -0.03786878287792206, -0.009270931594073772, -0.012241159565746784, 0.007039047311991453, 0.015285627916455269, 0.03721177577972412, -0.020575324073433876, 0.01856657676398754,
    -0.0023078666999936104, 0.023102283477783203, 0.018573293462395668, 0.03388757258653641, 0.01577145792543888, 0.005173729732632637, 0.0012803534045815468, -0.006682812701910734,
    -0.0035441131331026554, 0.002834140555933118, -0.00445718877017498, 0.009355004876852036, 0.0049035316333174706, 0.0270229484885931, -0.037329111248254776, 0.014218873344361782,
    -0.018503833562135696, -0.0028236659709364176, -0.0038626892492175102, 0.0035408916883170605, -0.032776836305856705, 0.031798895448446274, -0.028706369921565056, -0.0026190653443336487,
    -0.0018278566421940923, 0.007870761677622795, -0.005201239604502916, -0.013721912167966366, 0.007849784567952156, -0.018298789858818054, 0.008601994253695011, -0.03452391177415848,
    0.01063463557511568, 0.029619250446558, 0.010258660651743412, 0.0011799628846347332, -0.0018159800674766302, 0.030098166316747665, -0.01966904290020466, 0.0517885722219944,
    -0.014611988328397274, -0.027214370667934418, -0.0036694312002509832, -0.04317483305931091, 0.00022439395252149552, 0.02151375822722912, -0.0036954644601792097, 0.0011899432865902781,
    -0.01880272850394249, -0.014269399456679821, 0.01573685184121132, 0.017872462049126625, 0.005819981452077627, -0.024450726807117462, 0.023172006011009216, -0.029516005888581276,
    0.016185661777853966, 0.0066640255972743034, 0.00840978417545557, 0.006257062777876854, 0.023672888055443764, 0.010772543959319592, -0.02685139887034893, 0.006985722109675407,
    -0.008904026821255684, -0.0035834908485412598, 0.007522279396653175, 0.024679647758603096, -0.02369203232228756, -0.0018677915213629603, 0.007897501811385155, 0.022863376885652542,
    -0.0009994307765737176, -0.001738141872920096, 0.04519590362906456, -0.012079094536602497, 0.02181827835738659, 0.03193282708525658, -0.01946946047246456, 0.0062152789905667305,
    -0.007996400818228722, -0.006913650780916214, 0.009037952870130539, -0.004083622246980667, -0.0053807650692760944, -0.01127257663756609, -0.02337654121220112, -0.0529477559030056,
    -0.024215498939156532, 0.00458030728623271, 0.02845204994082451, 0.005148676224052906, -0.022860607132315636, -0.0016995539190247655, 0.01874549500644207, -0.01043348666280508,
    -0.005460051354020834, -0.011802542954683304, 0.0024298876523971558, -0.00537442322820425, 0.011445547454059124, 0.04765334725379944, -0.021253004670143127, -0.02131282165646553,
    0.029279649257659912, -0.012391967698931694, 0.011163546703755856, -0.01274577435106039, 0.0044716461561620235, 1.53786240844056e-05, 0.00038377943565137684, -0.0006782967248000205,
    -0.04008510336279869, 0.014254443347454071, -0.0026613716036081314, -0.03046613745391369, -0.023806292563676834, -0.0020031575113534927, -0.0175421554595232, 0.02132272534072399,
    0.0177481509745121, 0.0012878035195171833, 0.017795169726014137, 0.026791363954544067, 0.01706637628376484, -0.020586928352713585, -0.013754193671047688, 0.022503376007080078,
    -0.019999340176582336, -0.0037999218329787254, 0.006255635060369968, -0.01969427429139614, -0.02747173048555851, 0.02357957884669304, 0.01231670007109642, -0.03838755935430527,
    -0.011965658515691757, -0.016194947063922882, -0.015973947942256927, -0.024037815630435944, 0.01867326907813549, 0.01282122079282999, 0.021076831966638565, -0.02463654614984989,
    -0.00701237702742219, -0.027584252879023552, 0.02357613295316696, 0.004106928128749132, 0.03703370690345764, -0.014888412319123745, 0.031982723623514175, -0.02650131843984127,
    -0.007357106078416109, 0.009869053959846497, -0.033744264394044876, 0.03680173307657242, 0.001137849292717874, 0.02801576815545559, -0.017636077478528023, 0.014202339574694633,
    0.03830742835998535, -0.035652440041303635, -0.033504460006952286, -0.008834309875965118, -0.01717272214591503, -0.05647038295865059, 0.01665615476667881, 0.018517568707466125,
    -0.00714903837069869, -0.007791236508637667, 0.014496482908725739, 0.0010814694687724113, -0.004768102429807186, -0.005621615331619978, -0.0207359716296196, 0.01712888665497303,
    -0.002309281611815095, -0.0028782563749700785, 0.0018388786120340228, 0.03729547560214996, 0.0608564130961895, 0.027735356241464615, -0.012647980824112892, -0.003773651784285903,
    -0.0039635165594518185, -0.007555864285677671, 0.04358004406094551, -0.00853253249078989, -0.0036778629291802645, -0.010312161408364773, 0.0008534216322004795, -0.011467048898339272,
    0.02672535739839077, 0.021509680896997452, -0.014969589188694954, -0.03803703561425209, 0.0024738607462495565, 0.007851522415876389, 0.039916615933179855, -0.016234079375863075,
    -0.02799324132502079, -0.002042278414592147, -0.01806587353348732, 0.01406996138393879, 0.005710104014724493, -0.032439716160297394, 0.029257142916321754, 0.017777923494577408,
    0.03332832083106041, -0.0054617878049612045, 0.029220959171652794, -0.005804918706417084, 0.06287339329719543, 0.0041031548753380775, -0.009736070409417152, -0.04721039906144142,
    0.0034383859019726515, -0.010695820674300194, 0.021258333697915077, 0.005985736381262541, 0.008008592762053013, 0.0412512831389904, -0.012055843137204647, 0.011783033609390259,
    -0.004909629467874765, 0.010146095417439938, 0.018254585564136505, -0.005337088834494352, -0.022231560200452805, -0.03155926242470741, -0.01528848335146904, 0.027466248720884323,
    -0.03681211546063423, 0.01177246030420065, -0.005940348841249943, 0.008590789511799812, -0.01630743034183979, 0.02230842225253582, -0.006417679600417614, 0.03942796587944031,
    -0.02428632415831089, 0.002062033861875534, -0.03387697413563728, -0.010101343505084515, -0.002443047473207116, -0.0037777277175337076, -0.006767053622752428, 0.02438296191394329,
    0.04324169456958771, -0.026948753744363785, -0.038109295070171356, -0.02911376953125, -0.009086323902010918, -0.010800198651850224, 0.0031376287806779146, -0.023365795612335205,
    0.004984482191503048, -0.026098869740962982, 0.02400934137403965, -0.00010173863120144233, -0.0035507958382368088, 0.00348063581623137, 0.011861649341881275, 0.005958315450698137,
    -0.0018438665429130197, 0.012024263851344585, 0.016670310869812965, 0.018825961276888847, -0.002622549654915929, -0.005135697778314352, 0.00876507069915533, -0.030093898996710777,
    -0.02084772102534771, -0.020227527245879173, 0.0013603117549791932, -4.182128031970933e-05, -0.033437568694353104, -0.02067786082625389, 0.010186183266341686, -0.02831839956343174,
    0.03702405467629433, -0.01548595167696476, 0.012645261362195015, -0.014420721679925919, -0.02563311718404293, 0.03745255991816521, -0.009833481162786484, 0.022314604371786118,
    0.029533926397562027, -0.02861490473151207, -0.009184134192764759, 0.002415248891338706, 0.05090906098484993, -0.0014804231468588114, 0.014445209875702858, -0.012535946443676949,
    0.040367841720581055, 0.021926699206233025, -0.022417057305574417, -0.0023988010361790657, 0.017624787986278534, -0.007685461547225714, -0.023200534284114838, 0.011846240609884262,
    -0.0024427068419754505, 0.031108548864722252, 0.026443149894475937, 0.009750446304678917, -0.03583071008324623, 0.0005788034177385271, -0.00847907830029726, -0.04901624098420143,
    0.06701390445232391, 0.0377226397395134, -0.0008695085416547954, -0.0032080470118671656, 0.005611162167042494, -0.007740291301161051, -0.05567124858498573, -0.004044149070978165,
    0.034132521599531174, 0.022339263930916786, 0.029050156474113464, 0.008922397159039974, 0.014068404212594032, -0.0023631316144019365, -0.020878758281469345, 0.01646747626364231,
    0.06114844232797623, -0.003751075128093362, -0.04422644153237343, -0.015328767709434032, 0.020894644781947136, 0.03137511387467384, -0.02600451186299324, 0.003787186462432146,
    0.02884833887219429, 0.036264948546886444, -0.03668077662587166, -0.0024578021839261055, -0.02245662547647953, 0.031131967902183533, 0.03160497173666954, 0.006513602565973997,
    -0.016874482855200768, -0.041120946407318115, -0.0468432642519474, -0.005408059805631638, 0.0002329296403331682, -0.022946199402213097, 0.010655764490365982, -0.04968823492527008,
    0.0023043740075081587, -0.008013702929019928, -0.023219598457217216, 0.018363865092396736, -0.006503563839942217, 0.003752470016479492, 0.030303917825222015, -0.018672145903110504,
    -0.017422473058104515, -0.022304493933916092, -0.024320654571056366, 0.0016695040976628661, -0.01782900094985962, -0.04060787707567215, -0.009512988850474358, -0.0027884463779628277,
    0.08393403887748718, -0.032274436205625534, -0.0016231505433097482, 0.0009866032050922513, 0.026484062895178795, 0.017412418499588966, 0.03645802289247513, -0.04668416827917099,
    -0.05187629163265228, 0.051283519715070724, 0.024861130863428116, -0.008303678594529629, 0.00415441719815135, 0.012282083742320538, 0.03855452686548233, 0.012205173261463642,
    0.034302033483982086, 0.04086987301707268, -0.004956425167620182, -0.0019685702864080667, -0.011785255745053291, -0.017852695658802986, 0.0147391427308321, 0.029517291113734245,
    0.006301178131252527, -0.02376227267086506, -0.027672873809933662, 0.00678818067535758, -0.0036879372783005238, -0.0005676846485584974, 0.02172672748565674, -0.007870263420045376,
    -0.006212678737938404, -0.03198310732841492, 0.00030700035858899355, -0.0026660936418920755, 0.04881447181105614, -0.006177183706313372, 0.008791934698820114, 0.0032438780181109905,
    -0.013996196910738945, 0.030013885349035263, -0.0024426435120403767, -0.0032298052683472633, -0.0008989786147139966, -0.011166630312800407, 0.006855066400021315, -0.05103832483291626,
    -0.013371279463171959, -0.012331679463386536, 0.010701781138777733, -0.0016545691760256886, 0.013131863437592983, 0.036234576255083084, 0.014636212959885597, -0.007524498272687197,
    -0.004480311647057533, -0.028657536953687668, -0.015711938962340355, 0.01061594020575285, -0.027998141944408417, 0.02625245973467827, 0.014555253088474274, 0.008383030071854591,
    -9.425126336282119e-05, -0.02515207603573799, -0.011229761876165867, -0.009853987954556942, 0.0005847911234013736, -0.037121694535017014, -0.007306268438696861, 0.017250128090381622,
    0.01481642760336399, 0.03328140825033188, 0.00126161752268672, 0.012613849714398384, 0.0009496159036643803, 0.008575599640607834, 0.0057361191138625145, 0.002986724255606532,
    -0.004136624746024609, 0.0315791592001915, -0.009670418687164783, 0.020508598536252975, 0.01742134429514408, -0.00020085470168851316, -0.015616251155734062, 0.009681298397481441,
    -0.02584748901426792, -0.021956807002425194, -0.015376207418739796, -0.031614769250154495, -0.0005501974956132472, -0.013945779763162136, 0.017499063163995743, -0.01526632346212864,
    0.012282897718250751, 0.007521346211433411, 0.020601363852620125, 0.005546130705624819, 0.06502414494752884, -0.025920599699020386, -0.0038467254489660263, -0.03320259228348732,
    -0.017156371846795082, 0.026469625532627106, 0.005522275809198618, -0.014012078754603863, 0.04578613489866257, 0.04200010001659393, -0.029639018699526787, 0.03393588960170746,
    -0.06472177803516388, 0.018374128267169, -0.007305827457457781, 0.011137819848954678, 0.008573304861783981, 0.04619815945625305, 0.0005211487296037376, 0.001974897924810648,
    0.01070999726653099, 0.004309554118663073, 0.012553634122014046, 0.01214308850467205, 0.0013728286139667034, 0.044779084622859955, -0.03250884637236595, -0.0033624290954321623,
    -0.054847169667482376, 0.03742311894893646, -0.010211041197180748, -8.519053517375141e-05, -0.009077726863324642, -0.01200189534574747, -0.033086955547332764, 0.011465676128864288,
    0.017496218904852867, -0.032959070056676865, -0.023498760536313057, -0.017495010048151016, -0.022062571719288826, 0.0091988705098629, -0.030400309711694717, 0.0035593139473348856,
    -0.012890737503767014, 0.008347754366695881, 0.019479501992464066, -0.015352454036474228, 0.019758278504014015, -0.011175768449902534, 0.024161258712410927, -0.007491874974220991,
    -0.011126169003546238, 0.06659770756959915, -0.027866246178746223, -0.0006620606291107833, 0.05017479509115219, 0.04308444261550903, -0.015087530016899109, 0.004600231535732746,
    0.01669568568468094, -0.03474797308444977, -0.005651907995343208, 0.0003893609391525388, -0.00045065427548252046, 0.012107768096029758, -0.0851467028260231, 0.011017131619155407,
    0.03549662232398987, -0.004701921716332436, 0.0005710712284781039, 0.004110914655029774, -0.002708158455789089, -0.04363708570599556, 0.02363169565796852, 0.022048810496926308,
    -0.01491907611489296, -0.046293970197439194, -0.010291634127497673, 0.013299799524247646, -0.021910473704338074, -0.033636387437582016, 0.010335697792470455, -0.004723327700048685,
    0.013335095718502998, -0.007701525464653969, 0.0067917057313025, -0.023638470098376274, -0.001934367697685957, -0.012771272100508213, -0.01473911665380001, -0.0158338975161314,
    -0.019280793145298958, 0.011039286851882935, 0.02018655650317669, -0.03906994313001633, 0.023799482733011246, 0.04152970016002655, 0.002375692129135132, 0.05427047982811928,
    -0.00923463236540556, 0.04847287759184837, -0.05790530890226364, 0.010255178436636925, -0.00034477305598556995, -0.024949628859758377, -0.013333705253899097, 0.0014479568926617503,
    0.031102949753403664, -0.008460413664579391, -0.023568252101540565, -0.03078613057732582, 0.02238997258245945, 0.003893238492310047, -0.0042242566123604774, -0.023073755204677582,
    -0.022698167711496353, -0.04671373590826988, -0.0005953078507445753, -0.0038955197669565678, -0.0014179755235090852, -0.020095523446798325, 0.01586066000163555, 0.017094986513257027,
    -0.013328835368156433, 0.0057064928114414215, 0.019588196650147438, 0.00885290652513504, 0.025172147899866104, -0.004223208874464035, -0.017539475113153458, -0.038658034056425095,
    0.0334988534450531, 0.015519954264163971, 0.0031532326247543097, -0.0007051359280012548, 0.002340111881494522, 0.01241203211247921, 0.009965202771127224, -0.023042436689138412,
    0.004533541388809681, -0.004628138151019812, 0.00392010947689414, -0.010571432299911976, -0.033534396439790726, -0.019819529727101326, 0.009386508725583553, 0.003470934461802244,
    -0.02468573860824108, 0.0007636660011485219, 0.07712968438863754, -0.009151160717010498, -0.022414851933717728, -0.010434592142701149, 0.027564547955989838, 0.04430070519447327,
    -0.04071690887212753, -0.006372756324708462, 0.002220884431153536, 0.008262443356215954, -0.004571708384901285, 0.01781001314520836, -0.05525728315114975, 0.03154505044221878,
    0.007601031567901373, -0.04173887148499489, -0.04770534113049507, -0.006819627247750759, -0.04124277085065842, -0.014176655560731888, 0.0024001942947506905, 0.01621316932141781,
    0.015579341910779476, -0.005535908509045839, 0.013951976783573627, -0.016381962224841118, -0.007646785583347082, 0.03200063854455948, 0.0251615010201931, 0.02686457149684429,
    -0.014502000994980335, 0.014565497636795044, 0.05375589430332184, -0.022785352542996407, -0.005359484814107418, 0.01402333751320839, -0.007523778360337019, -0.034310292452573776,
    0.0006040674052201211, 0.016746755689382553, -0.012396302074193954, -0.0018786531873047352, 0.009111172519624233, 0.0391998365521431, -0.0016035352600738406, -0.025593677535653114,
    -0.005134494509547949, -0.020482122898101807, 0.0035864165984094143, 0.00033538960269652307, -0.04294384643435478, 0.01813281700015068, 0.012670483440160751, 0.01975337788462639,
    -0.0013357795542106032, -0.0033624584320932627, -0.02032485418021679, -0.040675338357686996, 0.010599477216601372, -0.025415098294615746, -0.011126583442091942, -0.03057967871427536,
    0.0050961608067154884, -0.004945717286318541, -0.0038053153548389673, -0.019202180206775665, 0.002877265913411975, -0.02831888571381569, -0.032393600791692734, 0.013344388455152512,
    -0.05324980616569519, 0.014296612702310085, 0.025539357215166092, 0.01403961144387722, -0.024830786511301994, -0.009829712100327015, -0.005121431779116392, -0.028736859560012817,
    0.06002664566040039, 0.062412358820438385, -0.0149797722697258, 0.03251015022397041, -0.009103937074542046, 0.018330378457903862, -0.020785754546523094, -0.008450380526483059,
    -0.03077065572142601, -0.005216971039772034, -0.005451276898384094, -0.0355871357023716, -0.03687966614961624, -0.0011693513952195644, 0.018198290839791298, -0.04532679542899132,
    0.03202037885785103, -0.01683780550956726, 0.003607111517339945, 0.005263655912131071, 0.015845097601413727, 0.026293080300092697, -0.02751750871539116, -0.016058484092354774,
    -0.026518305763602257, 0.0119060343131423, -0.009089093655347824, -0.001366045675240457, -0.01967979036271572, 0.015274657867848873, 0.031423188745975494, 0.002512190490961075,
    -0.03217075765132904, -0.025262663140892982, 0.018920473754405975, 0.0017319230828434229, -0.04438542574644089, -0.08028429001569748, 0.02729322575032711, -0.04627500846982002,
    0.027437519282102585, 0.006309694144874811, -0.013291526585817337, 0.04748115316033363, -0.005384162999689579, -0.012843524105846882, 0.04135028272867203, 0.029152000322937965,
    -0.018124867230653763, 0.001011812360957265, -0.06708177179098129, -0.00864010863006115, -0.045650165528059006, 0.007049044594168663, 0.011466731317341328, -0.008827337995171547,
    0.06115857511758804, 0.004850008524954319, 0.01947031356394291, 0.02614450454711914, 0.0019239143002778292, 0.006881133187562227, 0.00520296161994338, -0.03800412639975548,
    -0.001198992715217173, 0.020305078476667404, 0.01917112246155739, 0.035694874823093414, 0.00411849282681942, -0.025677073746919632, 0.04739620164036751, 0.011993964202702045,
    -0.009808529168367386, 0.027503512799739838, 0.030224554240703583, -0.021004339680075645, -0.017763514071702957, -0.010843331925570965, -0.025730831548571587, -0.04501950368285179,
    0.02447548508644104, -0.015065421350300312, -0.015575522556900978, 0.027056410908699036, -0.026357535272836685, 0.006085531786084175, -0.007233979646116495, 0.02416742406785488,
    -0.000457731046481058, -0.020790930837392807, 0.003574137110263109, -9.97781753540039e-05, -0.0008675828576087952, -0.02571927011013031, 0.03493523225188255, 0.01398793887346983,
    -0.009327064268290997, 0.015794025734066963, -0.032124415040016174, 0.0040707942098379135, 0.02080002799630165, -0.012083744630217552, 0.002099287463352084, -0.039843540638685226,
    0.008098225109279156, 0.04437513276934624, 0.027529150247573853, 0.027876704931259155, -0.00777814444154501, -0.0027060681022703648, 0.022152874618768692, 0.02639000304043293,
    -0.013681648299098015, 0.0205704215914011, 0.018285540863871574, 0.03332803398370743, -0.05308746173977852, -0.039327576756477356, -0.005761712323874235, -0.02702481299638748,
    0.03198365494608879, -0.009977954439818859, -0.004303838592022657, -0.014985878951847553, 0.003716782433912158, 0.0462275855243206, -0.043634578585624695, 0.004083601757884026,
    -0.02849670872092247, -0.015638375654816628, 0.05723981186747551, -0.004056926351040602, 0.010101689957082272, 0.02107373997569084, 0.05480292811989784, 0.004582220688462257,
    -0.004173668101429939, 0.0034833988174796104, -0.015058645978569984, 0.0008164676837623119, 0.01664363220334053, 0.007502203807234764, -0.013518935069441795, 0.004366823937743902,
    -0.00015590681869070977, -0.030291084200143814, -0.06704279780387878, -0.032292332500219345, 0.021510625258088112, -0.008850278332829475, 0.04375377669930458, 0.007983104325830936,
    0.0466182641685009, 0.06746769696474075, 0.011025184765458107, -0.005599914584308863, 0.030554551631212234, -0.027962202206254005, 0.002825571922585368, 0.01493758987635374,
    0.0027687097899615765, -0.011624996550381184, 0.02849646843969822, 0.0034113579895347357, 0.04254213720560074, 0.009225724264979362, -0.03058742731809616, 0.06876293569803238,
    -0.023660030215978622, 0.0012821591226384044, -0.02447633072733879, -0.01435282826423645, 0.060114648193120956, 0.03709234669804573, -0.01872352324426174, -0.016421781852841377,
    0.006110247224569321, -0.003540791105479002, -0.01759258471429348, -0.0008199021103791893, -0.004645904991775751, 0.012094362638890743, -0.04500174522399902, -0.001277809264138341,
    -0.012917590327560902, 0.0006630683783441782, 0.0032728638034313917, 0.05640670657157898, 0.0005144375609233975, -0.015912242233753204, 0.0003426919865887612, 0.018886623904109,
    0.01732644811272621, -0.012353734113276005, -0.014759153127670288, 0.006287872791290283, -0.002901352010667324, 0.026433400809764862, -0.03927700221538544, -0.035092197358608246,
    0.009118066169321537, -0.03293154388666153, -0.014986562542617321, -0.01409531943500042, 0.04058229550719261, 0.04662863165140152, 0.04044180363416672, -0.0031637183856219053,
    -0.017020152881741524, 0.02670644409954548, 0.006850787438452244, -0.028045739978551865, 0.01633302867412567, 0.013278819620609283, -0.01427534781396389, 0.007548153400421143,
    -0.007940567098557949, 0.02445087395608425, -0.029483746737241745, 0.011409902945160866, 0.03415032848715782, 0.01704355515539646, -0.013088954612612724, -0.02165863662958145,
    0.012326781637966633, -0.01824701577425003, 0.034861136227846146, -0.012759785167872906, 0.006860523484647274, -0.04395813122391701, -0.010008578188717365, 0.036318887025117874,
    -0.01982814632356167, 0.005139678250998259, -0.010186045430600643, 0.005557461641728878, -0.032355692237615585, -0.0066450778394937515, -0.05208617448806763, -0.04899698495864868,
    -0.006487892009317875, -0.005599106661975384, -0.016283679753541946, 0.030180005356669426, 0.03420455753803253, -0.005518983118236065, -0.0001939417707035318, 0.021178295835852623,
    -0.005055761430412531, 0.01015461701899767, -0.008715996518731117, 0.006776150781661272, 0.0010656064841896296, -0.0045603918842971325, -0.03758494183421135, 0.02376394346356392,
    0.02834532968699932, 0.040663834661245346, -0.026709333062171936, -0.007052044849842787, -0.0037438683211803436, 0.0014623536262661219, -0.010130171664059162, 0.011455656960606575,
    -0.02592143602669239, 0.008041265420615673, 0.016962796449661255, -0.01424417458474636, 0.009753389284014702, -0.0018308621365576982, -0.022074688225984573, -0.018954720348119736,
    -0.0026691777165979147, -0.01503294799476862, 0.03939855098724365, -0.013687030412256718, -0.029001396149396896, -0.01162770390510559, 0.00931479874998331, -0.015352853573858738,
    -0.008869145065546036, -0.014732246287167072, 0.012395854108035564, 0.0020936967339366674, 0.02797260507941246, -0.020657291635870934, -0.017506884410977364, -0.021516375243663788,
    0.019226714968681335, 0.013691083528101444, 0.0020488875452429056, -0.025229506194591522, 0.00671319430693984, -0.008822869509458542, 0.0028380132280290127, 0.044830676168203354,
    -0.026469996199011803, -0.003284338628873229, -0.023879017680883408, 0.004959459882229567, -0.028940582647919655, 0.02123400755226612, 0.0014613526873290539, 0.013896885327994823,
    0.015280244871973991, 0.005393422674387693, 0.017725931480526924, 0.023681052029132843, 0.01161759253591299, 0.005348604172468185, 0.02206430584192276, -0.02098826691508293,
    -0.03653014078736305, 0.037856727838516235, -0.01744493469595909, -0.02305239997804165, 0.0021694612223654985, -0.014213556423783302, -0.020148035138845444, -0.03015732392668724,
    -0.008641763590276241, -0.0018135557183995843, -0.016162171959877014, -0.010186238214373589, -0.0013349857181310654, -0.006371044088155031, -0.014617768116295338, 0.022368870675563812,
    -0.03651474416255951, 0.024278340861201286, -0.0037361718714237213, 0.028136491775512695, -0.01512436755001545, -0.000800112378783524, 0.005137668456882238, -0.00838122982531786,
    -0.014113622717559338, 0.03974010795354843, -0.02335285022854805, -0.00627013249322772, -0.03401538357138634, 0.04153072461485863, 0.03163981810212135, 0.008274872787296772,
    -0.025772789493203163, 0.02688004821538925, 0.008127110078930855, -0.00017532877973280847, 0.006240171380341053, 0.012690400704741478, -0.054125912487506866, 0.016258766874670982,
    -0.02053006738424301, -0.0017343774670735002, 0.018719611689448357, -0.007004355546087027, -0.017283035442233086, -0.02488800697028637, 0.023167729377746582, -0.010769125074148178,
    -0.01322034653276205, -0.009020037949085236, -0.03970462083816528, -0.04188743606209755, -0.03598508983850479, -0.01417913381010294, -0.04292007163167, 0.0074011050164699554,
    -0.01465054415166378, -0.028526069596409798, -0.0034956722520291805, -0.011949819512665272, 0.02682875469326973, -0.04102727770805359, -0.008796232752501965, 0.013297568075358868,
    -0.017406025901436806, 0.01756318286061287, -0.021082380786538124, -0.011897504329681396, 0.009158492088317871, 0.010856897570192814, 0.0020865013357251883, 0.006336532533168793,
    -0.019632689654827118, 0.0052925287745893, -0.00231216661632061, 0.029671840369701385, -0.0021159187890589237, -0.007178739178925753, -0.04005024954676628, 0.003001278033480048,
    0.01971321739256382, -0.022411508485674858, -0.029685989022254944, 0.0010391748510301113, -0.02021179534494877, 0.00040860759327188134, -0.018289752304553986, -0.0005291663110256195,
    -0.03920261561870575, 0.016012338921427727, -0.009283564984798431, -0.014810672029852867, 0.013753499835729599, -0.013064386323094368, -0.009243866428732872, 0.019212426617741585,
    -0.016619406640529633, -0.018982816487550735, -0.05084170401096344, -0.005346792750060558, -0.03334728628396988, 0.009018443524837494, 0.001836762996390462, 0.0005506009329110384,
    0.0257329810410738, 0.015648946166038513, -0.003961866721510887, -0.010283539071679115, -0.03389856219291687, 0.008209200575947762, 0.046035971492528915, -0.014155597425997257,
    0.00542483339086175, -0.008448977023363113, -0.003213416552171111, -0.02810363844037056, 0.03418249264359474, 0.008701148442924023, 0.025987165048718452, -0.03164156153798103,
    0.007515018340200186, 0.0020514805801212788, -0.023474114015698433, -0.021884802728891373, -0.01642211154103279, -0.009667578153312206, 0.015452245250344276, 0.006484576966613531,
    0.016027510166168213, -0.005449315067380667, -0.004749180283397436, 0.0026013043243438005, 0.004141144920140505, -0.016997631639242172, 0.004894215613603592, 0.00813883077353239,
    0.0316256508231163, 0.02329467423260212, -0.0023272158578038216, -0.0031173175666481256, -0.0011054429924115539, -0.037852056324481964, 0.01940874196588993, 0.04035962373018265,
    0.01516768243163824, 0.008137138560414314, -0.0018663081573322415, 0.018758822232484818, -0.008694447576999664, -0.01541453693062067, 0.0030630098190158606, 0.010082405060529709,
    0.004066260065883398, 0.0044583044946193695, -0.006143750157207251, 0.0033291697036474943, -0.026863260194659233, -0.008740134537220001, 0.00634125666692853, -0.022490493953227997,
    -0.022633535787463188, 0.05146455019712448, -0.02386166900396347, 0.006479545496404171, -0.02334238588809967, 0.0006956605357117951, 0.04749725013971329, -0.014487705193459988,
    0.015850599855184555, 0.02005915157496929, -0.016182810068130493, 0.012210979126393795, 0.004124619532376528, 0.021600212901830673, -0.018108315765857697, 0.017919035628437996,
    0.03242895379662514, 0.011457737535238266, 0.01767408475279808, 0.029727254062891006, -0.024727031588554382, -0.025764845311641693, -0.00013419144670479, 0.05120344087481499,
    -0.01967575214803219, 0.009130321443080902, -0.006116795819252729, -0.006309411022812128, -0.015644416213035583, 0.0029719395097345114, -0.020290978252887726, 0.03645120933651924,
    0.007141857407987118, 0.00021983037004247308, -0.016090959310531616, 0.006558829452842474, 0.02330888621509075, 0.04116983711719513, -0.007989919744431973, 0.001974857645109296,
    -0.007100370712578297, -0.04366185516119003, 0.03752600774168968, 0.013958100229501724, 0.02185118943452835, -0.017105650156736374, -0.018484096974134445, 0.002546316012740135,
    0.019833872094750404, 0.01583314873278141, -0.01592186465859413, -0.024900974705815315, 0.007339164149016142, 0.003070252016186714, -0.022256456315517426, -0.030997874215245247,
    0.008620546199381351, -0.02521337755024433, -0.002851559780538082, -0.0034261313267052174, 0.032590772956609726, 0.017683669924736023, 0.02781430073082447, -0.009836897253990173,
    -0.004204185213893652, -0.0031082965433597565, -0.014590867795050144, -0.0013200943358242512, -0.012418309226632118, 0.011632737703621387, 0.004679713398218155, 0.065142922103405,
    -0.010327094234526157, -0.01121942326426506, -0.03286869451403618, 0.00952230766415596, -0.0029826266691088676, -0.022650305181741714, -0.039696983993053436, -0.015102878212928772,
    -0.012612848542630672, 0.017460312694311142, 9.400897397426888e-05, 0.02979492023587227, 0.02837856486439705, -0.025684412568807602, -0.012068296782672405, -0.00941093172878027,
    -0.026988020166754723, 0.0027289369609206915, -0.006572810001671314, -0.0016416875878348947, 0.029295971617102623, 0.024882515892386436, 0.009110921993851662, -0.003358152462169528,
    0.022335384041070938, -0.05665747821331024, 0.014038716442883015, 0.010002899914979935, -0.010006283409893513, -0.015195600688457489, 0.0029957874212414026, 0.002668132307007909,
    -0.015839602798223495, 0.0013646428706124425, 0.009517960250377655, 0.007915331050753593, 0.030131375417113304, 0.016128625720739365, -0.052835941314697266, -0.02060805633664131,
    -0.01884705387055874, -0.0017787911929190159, -0.016572700813412666, -0.009693967178463936, 0.014906988479197025, 0.010293079540133476, 0.02443595975637436, 0.00976379495114088,
    0.010267626494169235, 0.020934076979756355, 0.009469537064433098, 0.01581433042883873, 0.006160853896290064, -0.026640761643648148, -0.02386409603059292, -0.01628177985548973,
    0.012560873292386532, 0.008451457135379314, 0.014330039732158184, -0.01180943287909031, -0.0360727421939373, -0.0029990696348249912, 0.08333583921194077, 0.016909897327423096,
    -0.0359681062400341, -0.02264910750091076, 0.01370670460164547, -0.033452507108449936, -0.00419649388641119, -0.04126039519906044, -0.039363499730825424, 0.016151191666722298,
    -0.009192912839353085, -0.044629983603954315, 0.005977741442620754, -0.005817343480885029, 0.0022933974396437407, -0.010036404244601727, 0.03315310180187225, -0.025778871029615402,
    0.030377104878425598, 0.015759475529193878, -0.019673151895403862, -0.02201768383383751, 0.01832195743918419, -0.0046038576401770115, 0.0050452291034162045, -0.030279560014605522,
    0.015970677137374878, 0.01918736658990383, -0.0035548885352909565, -0.031964853405952454, -0.028262635692954063, -0.0027962273452430964, -0.01706519164144993, 0.02379641681909561,
    0.010603555478155613, 0.0074085877276957035, 0.026607831940054893, 0.000259897526120767, -0.002548470627516508, 9.92861096165143e-05, -0.0021659377962350845, -0.008688965812325478,
    -0.004270926117897034, -0.008621236309409142, 0.013148698955774307, -0.03386703506112099, -0.0037843792233616114, -0.001964546274393797, -0.017003046348690987, 0.03642839938402176,
    0.008260498754680157, -0.000779234163928777, -0.03922102600336075, -0.03057013638317585, 0.0018639318877831101, -0.009777793660759926, -0.005040290765464306, -0.03743244335055351,
    0.005510348826646805, 0.044840943068265915, 0.03382253274321556, -0.009308547712862492, 0.041659895330667496, -0.058215901255607605, -0.005571083631366491, -0.009931448847055435,
    -0.037804923951625824, -0.017086682841181755, 0.0867011547088623, -0.0007030095439404249, 0.005623299162834883, -0.08495362848043442, 0.00019379817240405828, 0.03189629688858986,
    -0.014524159952998161, -0.0025191616732627153, 0.016220705583691597, -0.03458106517791748, 0.05057119205594063, 0.03856154531240463, -0.019658539444208145, 0.017298700287938118,
    0.014948644675314426, 0.0026390922721475363, -0.02902606502175331, 0.007072566542774439, 0.014088306576013565, 0.0010570433223620057, -0.0357426218688488, 0.012289922684431076,
    -0.03465386852622032, 0.0001250287750735879, -0.003487908048555255, -6.99020383763127e-05, 0.01149276178330183, 0.013160393573343754, -0.003465076209977269, -0.013759037479758263,
    -0.03176788240671158, 0.020866261795163155, 0.012443882413208485, -0.03725340589880943, 0.001629640581086278, -0.0019102520309388638, 0.015943465754389763, -0.00515355821698904,
    -0.04616696760058403, 0.039384085685014725, -0.03735857456922531, -0.0010187360458076, -0.01666230335831642, 0.029564229771494865, 0.07768458127975464, 5.3994866902939975e-05,
    0.003349955892190337, -0.03900294005870819, -0.025620926171541214, -0.01355015579611063, -0.008668975904583931, 0.026322266086935997, -0.005413807462900877, 0.030477279797196388,
    0.019447367638349533, -0.0369223915040493, -0.00645144609734416, 0.010599992237985134, 0.019501227885484695, 0.0335904024541378, -0.08694946020841599, 0.004065895918756723,
    0.014928793534636497, 0.02942986786365509, -0.010896441526710987, -0.016047364100813866, 0.0003941859758924693, -0.04016410559415817, 0.029345517978072166, -0.012248570099473,
    -0.024221930652856827, -0.0364544503390789, 0.004562243353575468, 0.0279769916087389, -0.030045045539736748, 0.005168778821825981, -0.056893181055784225, 0.009531493298709393,
    0.024125605821609497, -0.028944266960024834, 0.01700885407626629, -0.017880672588944435, -0.022971659898757935, -0.03300691395998001, 0.02701597660779953, 0.002221585949882865,
    -0.035962384194135666, 0.005910093896090984, -0.04523973539471626, -0.023868251591920853, 0.03185010701417923, 0.034713827073574066, 0.0015713096363469958, 0.01621200330555439,
    -0.017946459352970123, -0.00404128385707736, -0.008488382212817669, -0.01794675551354885, -0.014276009984314442, -0.0009327855077572167, -0.037206441164016724, 0.005828545894473791,
    -0.011128619313240051, -0.041599858552217484, 0.009325775317847729, -0.016709143295884132, 0.0316423699259758, 0.004092910792678595, 0.01705930195748806, 0.02821234054863453,
    -0.019443361088633537, -0.029413070529699326, -0.04580903425812721, -0.013190238736569881, -0.03266831859946251, 0.0047607715241611, 0.028722405433654785, 0.02308250032365322,
    -0.025280382484197617, -0.03289557620882988, 0.03475891426205635, 0.02586730197072029, -0.029898609966039658, 0.0395285002887249, 0.01478459034115076, 0.0631432756781578,
    0.060983866453170776, -0.01964103803038597, -0.018274974077939987, 0.0020437268540263176, -0.012248927727341652, 0.003163529559969902, 0.015337769873440266, -0.03134944662451744,
    0.0012222203658893704, 0.010002813301980495, 0.004813658073544502, 0.0437886044383049, -0.017087705433368683, 0.002953518182039261, -0.001175601384602487, -0.016549808904528618,
    -0.012889107689261436, -0.013718749396502972, 0.004626065492630005, -0.011091530323028564, 0.007977488450706005, 0.004765591584146023, 0.013250602409243584, 0.002639452926814556,
    0.0015033286763355136, 0.0025175914634019136, 0.011334019713103771, 0.03857623413205147, 0.0006719556986354291, -0.014991735108196735, -0.0015002869768068194, 0.015994902700185776,
    0.003880775300785899, 0.04981059208512306, -0.026465026661753654, -0.02786874771118164, 0.0376199446618557, 0.038659196346998215, -0.010751917026937008, 0.006778108887374401,
    0.02564897947013378, -0.019741008058190346, -0.029719039797782898, -0.03311001881957054, -0.005963747389614582, 0.007086548488587141, 0.01528927218168974, 0.03623231500387192,
    0.007194177247583866, 0.03342225030064583, 0.015779543668031693, 0.024194451048970222, 0.0003359000838827342, -0.017662174999713898, -0.02971477247774601, -0.033701833337545395,
    -0.005267885979264975, 0.060007303953170776, -0.00450302567332983, -0.021506929770112038, -0.04177093133330345, -0.03179088979959488, 0.04852624237537384, -0.016299664974212646,
    -0.005625388119369745, -0.020676378160715103, 0.008843797259032726, -0.049434106796979904, -0.011377443559467793, -0.01648816466331482, -0.03667989373207092, 0.008542505092918873,
    0.02399432100355625, 0.04781860485672951, -0.014224977232515812, -0.014567418955266476, 0.003946666140109301, -0.044051703065633774, 0.019971158355474472, -0.03251994028687477,
    -0.03389943018555641, 0.03709086775779724, 0.012162373401224613, 0.0006021947483532131, 0.05086519941687584, -0.010018798522651196, -0.004253199324011803, 0.03082762099802494,
    0.041878681629896164, -0.028173327445983887, 0.018290426582098007, -0.03765037655830383, -0.03327497839927673, -0.030858542770147324, 0.0016419366002082825, 0.006570730824023485,
    0.0036005089059472084, 0.0028789539355784655, -0.0010781488381326199, 0.02540311962366104, 0.010624450631439686, -0.004417900927364826, -0.023779744282364845, 0.0031183843966573477,
    0.04847265034914017, -0.002173030050471425, -0.061164818704128265, -0.006153585389256477, 0.051224127411842346, -0.014076801016926765, -0.037506092339754105, 0.016792040318250656,
    0.016733182594180107, -0.010004946030676365, -0.01063653826713562, -0.009686050936579704, 0.020189553499221802, -0.04447295144200325, -0.027088113129138947, -0.046125710010528564,
    0.021749457344412804, -0.006437419913709164, -0.05434431880712509, 0.002165639540180564, 0.017382031306624413, 0.005149879027158022, -0.013809057883918285, -0.02989673800766468,
    0.03785701468586922, 0.05734030529856682, 0.022358451038599014, -0.021455993875861168, 0.024928944185376167, 0.011411072686314583, 0.004191768355667591, 0.013078656047582626,
    -0.0013314277166500688, -0.014237438328564167, 0.0018622528295964003, -0.023411381989717484, -0.00024992789258249104, 0.01599227264523506, 0.00018457362602930516, -0.031690627336502075,
    0.014013034291565418, 0.014303695410490036, -0.010164402425289154, 0.011300813406705856, 0.0008037935476750135, -0.009891285561025143, 0.014953545294702053, -0.026157232001423836,
    -0.05017729103565216, 0.043760109692811966, 0.0013272323412820697, -0.021967539563775063, -0.015798160806298256, 0.03467407077550888, 0.000788384466432035, -0.019620653241872787,
    0.015449976548552513, 0.000977652263827622, 0.007778290659189224, -0.029429852962493896, 0.028286179527640343, 0.0017412147717550397, 0.001155869453214109, 0.051368024200201035,
    -0.042708396911621094, 0.038300689309835434, 0.024811236187815666, 0.02217242307960987, 0.003134364727884531, 0.019536491483449936, -0.011956676840782166, -0.01766907051205635,
    0.03334842249751091, -0.022731944918632507, -0.013845554552972317, -0.04219706356525421, 0.01898164115846157, 0.02828342095017433, 0.010701642371714115, 0.0026257424615323544,
    0.017214784398674965, -0.05569453164935112, -0.008387504145503044, 0.00781402736902237, 0.016017312183976173, 0.010534062050282955, -0.07131878286600113, -0.022997522726655006,
    -0.004268104676157236, 0.014555334113538265, -0.01180105097591877, 0.012288806028664112, -0.004257126245647669, 0.014646857976913452, 0.04649801552295685, 0.01731017231941223,
    -0.000647741777356714, -0.03533727303147316, -0.004165320657193661, 0.017182327806949615, -0.02994755655527115, 0.006151504814624786, -0.03568894788622856, -0.03785508871078491,
    0.009033054113388062, 0.009509900584816933, 0.004050528630614281, -0.026050100103020668, 0.02907903864979744, -0.0646410584449768, -0.03176156431436539, -0.03263029083609581,
    -0.06971664726734161, 0.0042704869993031025, 0.015463598072528839, 0.02097916603088379, 0.00997273251414299, -0.010307437740266323, -0.037632595747709274, 0.00724865822121501,
    0.032009273767471313, -0.02449137531220913, 0.029173217713832855, -0.008838561363518238, 0.0010707287583500147, -0.008963899686932564, -0.002823501592501998, -0.004460252355784178,
    -0.03660508617758751, 0.00020471151219680905, 0.0324973538517952, 0.012800995260477066, -0.03658764436841011, 0.011475367471575737, 0.06541397422552109, -0.034013450145721436,
    0.006484791170805693, 0.005272389855235815, 0.0036598832812160254, -0.008769886568188667, -0.026560507714748383, -0.008558407425880432, 0.012844898737967014, 0.0077951992861926556,
    -0.0450318343937397, 0.006872799247503281, -0.003993541467934847, -0.01392118539661169, 0.003967441152781248, -0.04179689660668373, -0.008646318688988686, 0.0075010014697909355,
    -0.02454604208469391, -0.05933688208460808, -0.006883625872433186, 0.00861311610788107, -0.021043123677372932, 0.003613380016759038, -0.024590563029050827, -0.03478434309363365,
    -0.01742432452738285, 0.018885869532823563, -0.008091624826192856, 0.02205796167254448, 0.03208470344543457, -0.0572485513985157, 0.0011100751580670476, 0.019914045929908752,
    -0.00236908090300858, -0.024856919422745705, 0.0052729505114257336, 0.01034623570740223, -0.03530239313840866, 0.01599954068660736, -0.021408047527074814, 0.027779098600149155,
    0.008337724022567272, -0.01583201065659523, 0.012814629822969437, 0.05832972377538681, 0.014389734715223312, 0.0012646779650822282, 0.045301590114831924, 0.006073087453842163,
    -0.02154661901295185, 0.0351436510682106, 0.03167062625288963, 0.02720021642744541, -0.02543393149971962, -0.031730882823467255, -0.02439633570611477, -0.06541448831558228,
    0.015077967196702957, -0.025556238368153572, 0.03681337833404541, -0.03576481714844704, -0.007389766629785299, 0.0003828074550256133, 0.022874819114804268, -0.012219906784594059,
    0.0024933156091719866, 0.0024605130311101675, 0.027421453967690468, 0.011582039296627045, 0.008299334906041622, 0.020143335685133934, -0.04992373660206795, -0.004042189102619886,
    -0.05520002171397209, 0.030324319377541542, -0.0024750512093305588, -0.0013276363024488091, -0.010601639747619629, -0.00615366455167532, 0.06725341081619263, 0.04216000437736511,
    0.0346175879240036, 0.0002198862930526957, 0.033625777810811996, -0.006541435141116381, -0.013895124197006226, -0.018519088625907898, -0.00427854573354125, -0.016166988760232925,
    -0.008732156828045845, -0.02629249170422554, -0.02596130035817623, -0.02016831375658512, 0.06303700059652328, 0.0008232397958636284, 0.020936965942382812, -0.00563351484015584,
    0.014864391647279263, 0.006222016178071499, -0.04441243037581444, -0.02002648450434208, 0.011353317648172379, -0.032599858939647675, 0.030527960509061813, -0.012074761092662811,
    -0.027562083676457405, 0.012590157799422741, -0.018484216183423996, -0.04403989017009735, -0.04652469605207443, -0.02158333547413349, 0.020110519602894783, -0.02021612599492073,
    -0.014909681864082813, 0.06173786520957947, 0.002995998365804553, 0.013006088323891163, 0.010514226742088795, -0.012351158075034618, -0.01843666099011898, -0.007941802963614464,
    -0.02411271259188652, -0.015586667694151402, 0.04553890973329544, 0.03854342922568321, 0.02612457238137722, -0.0011022916296496987, -0.02336975373327732, -0.007317816838622093,
    0.027941884472966194, 0.04526597261428833, -0.02090122550725937, -0.023630015552043915, -0.023442981764674187, -0.019161764532327652, 0.02450123056769371, 0.014555554836988449,
    -0.012913672253489494, 0.003183194901794195, 0.03271098434925079, 0.016711603850126266, -0.0066805933602154255, -0.01236477680504322, 0.03067268244922161, -0.025675786659121513,
    -0.005909706931561232, -0.027755696326494217, -0.030649079009890556, 0.015281674452126026, -0.024867065250873566, -0.013978630304336548, 0.01356571540236473, -0.04336473345756531,
    0.015072297304868698, -0.003857135074213147, 0.008692935109138489, 0.01717202365398407, -0.017050236463546753, 0.006639030762016773, 0.0108414888381958, 0.002272331388667226,
    0.028979051858186722, 0.029924917966127396, -0.029339633882045746, 0.008036418817937374, -0.020657045766711235, -0.003594087902456522, 0.007767738774418831, -0.01045336201786995,
    0.007814531214535236, 0.0781402438879013, -0.0074730319902300835, 0.012685355730354786, 0.016234057024121284, -0.0012621324276551604, 0.0027812025509774685, -0.0195754487067461,
    0.0023004866670817137, 0.027771778404712677, -0.017499733716249466, -0.02872820757329464, -0.002186013152822852, 0.010289664380252361, 0.018764007836580276, 0.02917301096022129,
    0.0013172473991289735, -0.0008049608441069722, 0.014055544510483742, 0.006549965590238571, 0.008408197201788425, 0.007385156583040953, 0.04751111939549446, -0.0011861176462844014,
    0.009664780460298061, -0.014951617456972599, -0.020020218566060066, 0.021543122828006744, -0.029821433126926422, 0.023223217576742172, -0.01897263340651989, -0.019910253584384918,
    -0.05612791329622269, -0.01741218753159046, 0.011045565828680992, -0.015199882909655571, -0.004310158081352711, -0.0033253198489546776, 0.003118026303127408, 0.015667462721467018,
    -0.03171812370419502, 0.010474479757249355, -0.035446472465991974, 0.012679464183747768, 0.03879723697900772, -0.019001828506588936, -0.005591811612248421, 0.00480291061103344,
    0.043187446892261505, 0.02025691047310829, 0.029737120494246483, -0.004874699749052525, -0.009554951451718807, -0.01774008572101593, -0.0015296167694032192, 0.02358723245561123,
    -0.023601587861776352, 0.007362090516835451, 0.005587966181337833, 0.009206066839396954, -0.04261958971619606, -0.04541279003024101, -0.0005435673519968987, 0.03926853835582733,
    0.053796421736478806, -0.01591791957616806, 0.026776274666190147, 0.01589691825211048, -0.025193145498633385, -0.03226147219538689, -0.03036446124315262, -0.01602994091808796,
    0.01959635503590107, -0.011023336090147495, 0.002583697671070695, -0.006273186765611172, -0.004340846091508865, -0.005182592663913965, 0.027264291420578957, 0.024382255971431732,
    0.022877344861626625, 0.0025020218454301357, -0.017503106966614723, -0.039968717843294144, -0.011497593484818935, -0.0043367911130189896, -0.0005637736176140606, 0.01080370508134365,
    0.004659358877688646, -0.03468722105026245, 0.005885798949748278, -0.003536154981702566, 0.014128445647656918, -0.0385189987719059, -0.0011568417539820075, 0.002012752927839756,
    0.05738416686654091, 0.018929172307252884, 0.0027556875720620155, -0.01475476287305355, 0.030392756685614586, 0.0011669716332107782, -0.020589852705597878, -0.040780939161777496,
    0.02502732165157795, 0.06127931922674179, 0.060355935245752335, -0.03060976415872574, 0.04274779558181763, 0.04702133685350418, 0.0028959449846297503, 0.052812837064266205,
    -0.03768831491470337, 0.011653141118586063, 0.011529393494129181, -0.027357015758752823, -0.022457484155893326, 0.006891453638672829, -0.029698381200432777, -0.02438870444893837,
    -0.016002677381038666, -0.018847832456231117, 0.020797058939933777, -0.012022383511066437, -0.0031662050168961287, -0.0041500115767121315, 0.022991491481661797, -0.006184824276715517,
    -0.00419232901185751, -0.020645534619688988, 0.008671223185956478, -0.01983429677784443, -0.01667802222073078, -0.005646065808832645, -0.04511634632945061, 0.003885443788021803,
    0.006397692020982504, -0.007233141455799341, -0.03227549046278, -0.02584965154528618, 0.02315177582204342, 0.000751504790969193, -0.03566544130444527, -0.006453073117882013,
    0.0006687940913252532, 0.0016048828838393092, 0.0019301442662253976, -0.011024157516658306, 0.011590680107474327, 0.01758149266242981, -0.06432957947254181, -0.023407073691487312,
    0.008882381953299046, 0.050289858132600784, 0.023810463026165962, -0.03223090618848801, 0.052291784435510635, -0.000960579956881702, -0.0037063653580844402, -0.014441756531596184,
    0.018452728167176247, -0.03362041711807251, -0.010086823254823685, 0.005420230329036713, 0.02482854574918747, 0.01707693375647068, -0.07953847199678421, -0.04796873778104782,
    0.027619432657957077, -0.025210898369550705, 0.018653960898518562, -0.03832736611366272, -0.042604878544807434, -0.00635219132527709, 0.02423650212585926, 0.007468560244888067,
    0.01607954502105713, -0.016630377620458603, -0.03018260933458805, -0.003018192481249571, -0.006230308208614588, 0.0389537550508976, -0.00477062352001667, -0.02698800154030323,
    -0.005857120733708143, -0.03135001286864281, 0.0020369680132716894, 0.051480282098054886, 0.030821142718195915, -0.024972062557935715, -0.03139511123299599, -0.042819615453481674,
    -0.0002587635535746813, 0.000432421948062256, -0.008367391303181648, 0.012958653271198273, 0.006545875687152147, 0.012383420020341873, 0.009262613020837307, 0.004293970763683319,
    0.0018997109727934003, 0.003993459977209568, -0.011019467376172543, 0.004435884766280651, 0.000383759499527514, 0.0006282415124587715, 0.010614490136504173, -0.00037477281875908375,
    0.0007642646669410169, 0.0009685960249044001, -0.016627540811896324, 0.0008296642336063087, -0.01022464781999588, -0.0023846724070608616, -0.008531429804861546, 0.003433148842304945,
    0.0041038477793335915, -0.011448513716459274, 0.00432713283225894, 0.002255525439977646, 0.0038304063491523266, -0.00892217829823494, -0.0012185935629531741, 0.0044520157389342785,
    0.008981735445559025, 0.010639375075697899, -0.01734219677746296, 0.0005918389651924372, 0.0016706457827240229, -0.006765475030988455, -0.005279834382236004, -0.005101379938423634,
    -9.131278056884184e-05, 0.00264392769895494, 0.002409803681075573, -0.0028946748934686184, -0.012408440001308918, 0.0019670205656439066, 0.005511490162461996, -0.006309470161795616,
    -0.0015011111972853541, 0.0017484178533777595, 0.018143773078918457, -0.008922046981751919, 0.0025852194521576166, -0.006536391098052263, -0.00488619040697813, 0.005777137819677591,
    0.01383886206895113, -0.002227883553132415, 0.00863158144056797, -0.0007501888321712613, 0.0031900217290967703, 0.00047414915752597153, 0.004395597614347935, 0.00394973112270236,
    -0.002815486863255501, -0.0015678196214139462, -0.014848213642835617, -0.008942179381847382, -0.0031621113885194063, -0.006464803591370583, -0.0029663355089724064, 0.002401709323748946,
    0.008381024934351444, 0.003877516370266676, 0.0060173277743160725, -0.005636937916278839, -0.007559959311038256, -0.004489677958190441, -0.00435570627450943, -0.006929023656994104,
    0.0011435652850195765, 0.0011695752618834376, 0.0028652758337557316, 0.012353015132248402, -0.003722845111042261, 0.0036167495418339968, 0.007103270851075649, -0.005119497887790203,
    0.00037730627809651196, 0.0011481695109978318, -0.008983934298157692, 0.0010820748284459114, -0.008073002099990845, 0.005014508031308651, 0.0034755615051835775, -0.006723444908857346,
    0.00459869671612978, -0.004977776203304529, 0.006476521957665682, -0.0015832697972655296, 0.0010058279149234295, 0.00198944890871644, -0.00905589573085308, 0.010890461504459381,
    0.005379042122513056, -0.00012849103950429708, 0.006536972243338823, -0.003996857907623053, 0.013470357283949852, -0.00927366130053997, -0.007739866152405739, -0.00015025904576759785,
    -0.0024562354665249586, -0.005071542225778103, 0.0036395478527992964, 0.0019059146288782358, -0.0028643959667533636, 0.005836924072355032, 0.012603970244526863, -0.013600933365523815,
    -0.008802472613751888, 0.004569114185869694, 0.004826495889574289, 0.003860383527353406, 0.02230248972773552, -0.00681966170668602, -0.0014850044390186667, -0.017367063090205193,
    -0.08096373826265335, 0.019151808694005013, 0.027686364948749542, 0.018988821655511856, -0.04804717004299164, -0.017095306888222694, 0.016372021287679672, -0.015620756894350052,
    -0.09234881401062012, 0.0442950613796711, -0.026915505528450012, -0.08179077506065369, -0.0012450381182134151, -0.0354873351752758, -0.020409636199474335, -0.024303611367940903,
    -0.03940479829907417, -0.10635875165462494, 0.0007122112438082695, -0.020233996212482452, 0.03875967487692833, 0.032817497849464417, -0.018466686829924583, 0.09134537726640701,
    -0.0887368842959404, 0.010662773624062538, -0.04312695190310478, 0.06094332039356232, 0.042523179203271866, -0.012920740991830826, -0.056830789893865585, 0.06881988793611526,
    -0.06117533892393112, 0.03607963025569916, 0.0332006998360157, -0.023120075464248657, 0.06076604872941971, 0.1491880863904953, -0.03238346800208092, -0.033933598548173904,
    -0.028004569932818413, -0.02971246838569641, 0.028537899255752563, 0.0024869893677532673, 0.03717335686087608, -0.007516595534980297, 0.025762483477592468, 0.026207301765680313,
    0.012427883222699165, 0.07151089608669281, 0.0011401701485738158, 0.1371363401412964, 0.0404587984085083, -0.03507009893655777, -0.045454204082489014, 0.003591503482311964,
    0.03577336296439171, -0.003285112092271447, 0.04507092386484146, -0.09177374839782715, -0.08431874960660934, 0.023849308490753174, 0.01690247841179371, 0.06519271433353424,
    0.06467196345329285, 0.09290245175361633, 0.08206869661808014, -0.024089815095067024, -0.08133123070001602, -0.09122677147388458, 0.09906309843063354, -0.1023089662194252,
    0.03964899480342865, -0.06518565863370895, -0.015693847090005875, -0.046481918543577194, 0.13736596703529358, -0.04127861186861992, -0.138710618019104, 0.04886898025870323,
    -0.01838012970983982, 0.070733942091465, -0.03020324371755123, 0.06625895202159882, 0.08123266696929932, -0.05927387997508049, -0.03585367649793625, 0.02817419171333313,
    -0.053158752620220184, -0.040275245904922485, -0.02505270577967167, -0.10564133524894714, -0.04000696539878845, -0.040335752069950104, 0.06727240979671478, -0.043535973876714706,
    0.05963901802897453, 0.010898330248892307, -8.443937258562073e-05, 0.00565703259781003, 0.044727567583322525, 0.13746324181556702, 0.042464688420295715, -0.024158716201782227,
    -0.025884052738547325, 0.05209193006157875, 0.03229683265089989, 0.09470588713884354, 0.025747699663043022, -0.03293146938085556, 0.0023145689629018307, -0.03212795406579971,
    0.04137144237756729, 0.06794031709432602, -0.10534034669399261, 0.006525698117911816, 0.10065355151891708, -0.03625619038939476, 0.036799754947423935, -0.04879859834909439,
    0.005962003488093615, -0.009878680109977722, 0.024300696328282356, -0.029441704973578453, -0.01526860985904932, -0.05645199492573738, -0.028232470154762268, 0.0385313518345356,
    0.07007113844156265, -0.10782502591609955, 0.056082628667354584, -0.09332381188869476, -0.015014123171567917, 0.03421330451965332, 0.005983622744679451, -0.046018604189157486,
    0.041967932134866714, 0.026413194835186005, -0.048800162971019745, -0.035486508160829544, -0.030630385503172874, 0.1325155645608902, -0.07095873355865479, 0.055741943418979645,
    -0.10362558811903, -0.03092249296605587, -0.005605533253401518, -0.07445032894611359, -0.045250892639160156, -0.079740509390831, -0.02549281343817711, 0.031143594533205032,
    0.11089693009853363, 0.0028266895096749067, 0.09001150727272034, 0.05861387401819229, -0.050647150725126266, -0.012818774208426476, 0.057707760483026505, -0.017702315002679825,
    -0.0006062472821213305, -0.027203457430005074, 0.08189616352319717, 0.08340837806463242, 0.08307792246341705, 0.11106865853071213, 0.10098689794540405, -0.0322478711605072,
    0.1035398319363594, 0.015194153413176537, 0.007668501231819391, -0.1568625420331955, 0.04712152108550072, 0.09975460171699524, -0.06910726428031921, 0.012273144908249378,
    -0.0196972843259573, -0.1797860562801361, -0.0042008403688669205, 0.1214994341135025, -0.001976005733013153, 0.0008135969983413815, 0.007167627103626728, 0.10053025186061859,
    0.08882111310958862, 0.049594100564718246, 0.04138490557670593, -0.02601025439798832, -0.017636802047491074, -0.08997838944196701, 0.02074313908815384, 0.01296416949480772,
    0.010574535466730595, 0.03799464926123619, -0.02028355374932289, 0.04730847850441933, -0.07340873777866364, -0.08395218104124069, 0.14057357609272003, 0.041899021714925766,
    0.08438000828027725, -0.04165348783135414, -0.004123862832784653, 0.0009477796847932041, -0.0764290988445282, -0.03646319732069969, -0.05355368182063103, -0.05865112319588661,
    0.06122850626707077, -0.0641954317688942, -0.11478739231824875, 0.05157428979873657, -0.010929230600595474, 0.07347231358289719, -0.05108705535531044, 0.08796525001525879,
    -0.09433731436729431, -0.01318479236215353, -0.02716950699687004, 0.15059877932071686, 0.013232842087745667, -0.020823657512664795, -0.09901706129312515, -0.013694939203560352,
    0.1274762749671936, -0.050448622554540634, -0.015914006158709526, 0.0012808924075216055, 0.03454020991921425, 0.07553641498088837, 0.0544632263481617, -0.017730077728629112,
    0.09655583649873734, 0.11153001338243484, 0.00029427246772684157, 0.041192676872015, -0.04875756427645683, -0.03215017542243004, 0.0006410863716155291, 0.06392677873373032,
    0.05482557788491249, 0.0029358796309679747, 0.02070857398211956, -0.018430186435580254, -0.08001161366701126, 0.017833774909377098, -0.017818842083215714, 0.058638427406549454,
    0.028407089412212372, -0.09484701603651047, 0.011131883598864079, -0.03496686741709709, -0.0301139447838068, -0.11550616472959518, -0.08623760938644409, 0.04862590134143829,
    -0.10604533553123474, 0.051864661276340485, 0.08337075263261795, -0.07520892471075058, 0.00606950419023633, 0.006922044791281223, 0.049460217356681824, 0.047914713621139526,
    -0.11892947554588318, -0.101386658847332, -0.07860150188207626, -0.039067383855581284, 0.06604884564876556, -0.018915995955467224, 0.028808357194066048, -0.10010643303394318,
    0.021735576912760735, 0.08608806878328323, -0.030555013567209244, -0.018983468413352966, -0.009215732105076313, 0.11996853351593018, -0.0627690777182579, -0.010684670880436897,
    -0.007249762304127216, 0.03254687413573265, -0.0977039635181427, 0.1325199455022812, -0.0994325503706932, 0.10126431286334991, -0.050173673778772354, -0.10147552192211151,
    0.07536619901657104, -0.0032332434784621, 0.029955845326185226, -0.13373051583766937, 0.024427754804491997, -0.034614719450473785, 0.045641496777534485, -0.042628295719623566,
    -0.004552666563540697, 0.0604851059615612, 0.038039885461330414, 0.1657872200012207, 0.07127880305051804, 0.16221629083156586, -0.0006286682328209281, 0.11567377299070358,
    -0.0024721117224544287, 0.17356717586517334, 0.005267044994980097, 0.051147282123565674, -0.02395252324640751, 0.04071365296840668, -0.0383751317858696, 0.05881241708993912,
    -0.04948734864592552, -0.13728001713752747, 0.07356374710798264, 0.04852379858493805, 0.02781575545668602, 0.09848159551620483, 0.058695532381534576, -0.0925910472869873,
    0.06471110135316849, -0.0038068026769906282, 0.05484830588102341, 0.1517399400472641, -0.021485935896635056, 0.020903000608086586, 0.003859531134366989, -0.13974732160568237,
    0.07004614919424057, 0.12719394266605377, -0.0165778286755085, 0.004800958558917046, -0.1821436733007431, -0.13687513768672943, 0.01556906197220087, -0.1689024269580841,
    -0.02172090671956539, -0.16842226684093475, -0.04109842702746391, -0.0774402767419815, -0.041337065398693085, 0.036136191338300705, 0.03878522291779518, -0.10682603716850281,
    -0.05917512997984886, -0.06282411515712738, -0.0025473821442574263, -0.0905207172036171, -0.1066572293639183, -0.06978657841682434, -0.12041167914867401, 0.047764770686626434,
    0.05961582809686661, -0.034378763288259506, -0.04397425055503845, -0.020928945392370224, -0.025354135781526566, -0.11182550340890884, 0.039914943277835846, 0.00885061826556921,
    -0.14476503431797028, 0.10415144264698029, 0.02253020741045475, -0.0959235206246376, -0.13529589772224426, -0.12579502165317535, -0.1345721185207367, -0.10447128862142563,
    -0.016922736540436745, 0.04986945167183876, 0.08657897263765335, -0.028852786868810654, -0.13732077181339264, 0.0778885930776596, 0.024577036499977112, 0.025599796324968338,
    0.04978432133793831, -0.10667978227138519, -0.09457841515541077, -0.007000509649515152, -0.03925693407654762, 0.00729511259123683, -0.13550588488578796, 0.041458845138549805,
    -0.12005282193422318, 0.25141072273254395, 0.09338065981864929, -0.06774614751338959, -0.038479033857584, -0.09102097898721695, 0.07261673361063004, -0.030955573543906212,
    0.017439618706703186, -0.06542764604091644, -0.04287080466747284, -0.013339909724891186, -0.0350346639752388, -0.019353032112121582, -0.06351320445537567, 0.04144883155822754,
    0.07466404885053635, 0.14922545850276947, -0.04644550383090973, 0.0945085883140564, 0.027334893122315407, -0.1418236345052719, -0.1123659610748291, -0.023949619382619858,
    0.027472352609038353, -0.10330299288034439, -0.03862966224551201, 0.0843973383307457, -0.028933783993124962, -0.07354956865310669, 0.05004410073161125, -0.02401120215654373,
    0.07697109878063202, -0.00691158277913928, -0.035455942153930664, 0.20815375447273254, 0.025458524003624916, -0.05802911892533302, -0.11907792091369629, -0.10206809639930725,
    0.09300671517848969, 0.12107616662979126, -0.05276830866932869, -0.07145407050848007, -0.1328725665807724, 0.07726849615573883, 0.07307920604944229, 0.055731095373630524,
    -0.021275203675031662, -0.1454819291830063, 0.008658266626298428, -0.02214588038623333, 0.09892719984054565, 0.013078156858682632, -0.0750679075717926, 0.15950918197631836,
    0.025439776480197906, 0.17484506964683533, 0.005252568982541561, -0.01688355952501297, -0.05016356334090233, 0.0818367525935173, -0.08209533989429474, -0.04098990559577942,
    -0.045642416924238205, -0.013816324062645435, 0.003330139210447669, 0.09637266397476196, -0.014406842179596424, 0.04786084219813347, -0.06908675283193588, 0.1290225088596344,
    -0.02031920850276947, -0.05797387659549713, 0.07093307375907898, -0.014318963512778282, 0.17028070986270905, 0.009375962428748608, 0.033731430768966675, -0.047203488647937775,
    -0.11526334285736084, -0.07411210983991623, 0.028859807178378105, -0.14062951505184174, 0.08987037092447281, -0.08476658910512924, 0.02218589000403881, 0.026380812749266624,
    0.03866100311279297, 0.0008469551685266197, 0.11797048896551132, -0.11165095120668411, 0.019136084243655205, -0.14940272271633148, 0.08214633166790009, 0.07269592583179474,
    -0.034144435077905655, 0.0510045550763607, 0.025440173223614693, 0.1281830370426178, 0.039496470242738724, -0.09537413716316223, -0.010142257437109947, -0.05836823210120201,
    0.11593160033226013, -0.009082053788006306, -0.03164985775947571, -0.021703900769352913, 0.053029004484415054, -0.08282797783613205, -0.15935742855072021, -0.05277267470955849,
    -0.13715241849422455, 0.08120967447757721, 0.03484916314482689, -0.010369556955993176, 0.15278148651123047, -0.08058848977088928, 0.034933507442474365, 0.021581556648015976,
    -0.1280384361743927, -0.12874342501163483, 0.08641431480646133, -0.08782776445150375, -0.06323522329330444, -0.03200724348425865, 0.0837692990899086, 0.022774143144488335,
    -0.10603585839271545, -0.06398896127939224, 0.02420240268111229, -0.05638554319739342, -0.017136985436081886, -0.03278706222772598, -0.027476711198687553, -0.03700490668416023,
    0.020509149879217148, 5.447778676170856e-05, 0.09250733256340027, -0.02868940681219101, 0.02341558039188385, 0.16822607815265656, 0.15088960528373718, 0.12978115677833557,
    0.05987875536084175, 0.03336659446358681, -0.05608302354812622, -0.04931512847542763, 0.07264969497919083, 0.1570984125137329, -0.07209514081478119, -0.08245621621608734,
    -0.026688016951084137, -0.05272582173347473, 0.027022110298275948, 0.08904565125703812, 0.12977425754070282, -0.09748633950948715, -0.02903239242732525, 0.10181056708097458,
    -0.046534717082977295, 0.01374690979719162, -0.03169522434473038, -0.29231810569763184, 0.17314866185188293, 0.02819070965051651, -0.03194817900657654, -0.043696966022253036,
    0.08986268937587738, 0.051917970180511475, -0.1037214994430542, -0.14803346991539001, 0.032848894596099854, -0.06838847696781158, -0.00017549980839248747, 0.09989587217569351,
    0.03642457723617554, 0.0914265438914299, 0.039736729115247726, 0.055922333151102066, -0.0654347613453865, -0.059695061296224594, -0.12177395820617676, -0.082713782787323,
    0.025517944246530533, -0.20848394930362701, -0.022227205336093903, 0.0019346268381923437, -0.03524244576692581, -0.2216077446937561, -0.12584006786346436, 0.009284489788115025,
    -0.07023544609546661, 0.021009260788559914, 0.0240196380764246, -0.032345063984394073, -0.02034289576113224, 0.09308172017335892, 0.027645446360111237, -0.22945089638233185,
    -0.006776231341063976, 0.11262813955545425, 0.0389927439391613, -0.06586765497922897, -0.0753234252333641, 0.14942075312137604, 0.03946471959352493, 0.011212669312953949,
    -0.012280956842005253, -0.015090049244463444, 0.11516879498958588, 0.024667486548423767, 0.016135282814502716, 0.08548330515623093, -0.05205170065164566, 0.10457020998001099,
    0.15191864967346191, -0.08784282207489014, 0.042179010808467865, 0.15597383677959442, 0.10240155458450317, -0.00833858735859394, 0.11496291309595108, -0.033352117985486984,
    0.056660156697034836, 0.15523652732372284, 0.041951339691877365, -0.22911080718040466, -0.0881986990571022, 0.05916288495063782, -0.0504300519824028, -0.08479730039834976,
    0.0022673867642879486, -0.022800030186772346, -0.08887424319982529, 0.03590274974703789, 0.10636458545923233, -0.05079223960638046, -0.05645982548594475, 0.25303104519844055,
    0.029522540047764778, -0.024409247562289238, -0.027523579075932503, 0.03423725813627243, -0.020851418375968933, -0.06817054003477097, 0.04688931256532669, 0.14465858042240143,
    0.09119299054145813, -0.11255263537168503, 0.09559459239244461, -0.01761269010603428, 0.03065572679042816, 0.05084152892231941, 0.1926010251045227, 0.032687194645404816,
    0.03444269672036171, -0.2095060795545578, -0.040610749274492264, -0.013576849363744259, -0.1686524748802185, -0.0767064243555069, -0.020671460777521133, -0.03683222085237503,
    0.08233744651079178, 0.15740220248699188, 0.037624556571245193, -0.04741291701793671, 0.02368084527552128, -0.038479194045066833, 0.16727501153945923, -0.2704675793647766,
    0.006872921716421843, -0.05426818132400513, 0.06704634428024292, 0.049711525440216064, -0.1278470754623413, -0.151120126247406, 0.12992945313453674, -0.011297013610601425,
    -0.17845702171325684, -0.11211144924163818, 0.01812168024480343, 0.08367417752742767, 0.07847443968057632, -0.06837613880634308, -0.12254423648118973, -0.08531103283166885,
    -0.07066165655851364, -0.036455124616622925, -0.038265589624643326, 0.3370848596096039, 0.07941801846027374, -0.05458157882094383, 0.22297663986682892, 0.0674610435962677,
    0.0330967903137207, -0.09791885316371918, -0.13761170208454132, 0.26066455245018005, 0.0902959406375885, 0.14188845455646515, 0.03138337656855583, -0.01595768891274929,
    -0.012821221724152565, -0.05718538165092468, 0.04145049676299095, 0.06011832505464554, -0.07172241806983948, -0.0031410562805831432, -0.15708300471305847, -0.006708831060677767,
    0.12171254307031631, 0.052415333688259125, -0.009299742057919502, 0.02671195939183235, 0.0603741854429245, 0.01600317656993866, 0.037394311279058456, 0.12888740003108978,
    0.2054828256368637, -0.004325393121689558, 0.019134150817990303, 0.0625806525349617, -0.00864927377551794, -0.01739487610757351, -0.09475235641002655, 0.11067195981740952,
    -0.08625969290733337, 0.0036431082990020514, 0.09741438180208206, 0.03514379635453224, 0.06482977420091629, -0.022970696911215782, 0.0444914735853672, -0.07647879421710968,
    0.09539899230003357, 0.08184482157230377, -0.051554907113313675, 0.04523267596960068, -0.04458824545145035, 0.09982647746801376, 0.10376923531293869, 0.07218889147043228,
    0.11387741565704346, 0.04543917253613472, -0.19617943465709686, -0.0729789212346077, -0.0441259890794754, -0.022983014583587646, -0.04740259051322937, -0.019263455644249916,
    -0.019626781344413757, 0.04040248319506645, 0.0346686989068985, 0.30379757285118103, -0.20045654475688934, -0.08833563327789307, 0.012813116423785686, -0.10250300168991089,
    -0.06553415954113007, -0.008797886781394482, -0.041289377957582474, 0.15579889714717865, 0.18325723707675934, -0.05650482699275017, 0.12821000814437866, -0.23024792969226837,
    0.020122433081269264, -0.11311213672161102, 0.030155666172504425, -0.011109854094684124, -0.14535346627235413, 0.037905655801296234, -0.09513319283723831, -0.07927258312702179,
    0.0510135143995285, -0.09110468626022339, 0.07682646065950394, -0.019320784136652946, 0.08528806269168854, 0.04340434819459915, -0.060688670724630356, 0.1172003224492073,
    -0.061080943793058395, 0.18023735284805298, -0.11047331988811493, 0.10021230578422546, -0.04355130344629288, -0.027933157980442047, -0.08088531345129013, 0.07213933765888214,
    0.03977333381772041, 0.07852740585803986, -0.13891859352588654, -0.03359146788716316, -0.1286652684211731, 0.122761569917202, -0.04221342131495476, 0.257633775472641,
    -0.030926909297704697, 0.1393040120601654, 0.034308627247810364, 0.14661961793899536, 0.05233202502131462, 0.15788860619068146, -0.03718527406454086, 0.17361029982566833,
    -0.10915129631757736, 0.08450032025575638, -0.0808681845664978, 0.0475444421172142, 0.1396806836128235, -0.0945931151509285, 0.05298294499516487, 0.01638914830982685,
    0.09494732320308685, -0.05534021928906441, 0.08626127243041992, -0.3367755115032196, -0.11412158608436584, 0.018831392750144005, -0.051982395350933075, -0.03235532343387604,
    0.16702090203762054, -0.047208864241838455, -0.009653007611632347, -0.16297544538974762, 0.08693986386060715, -0.18669846653938293, -0.09962651878595352, 0.0061392574571073055,
    -0.0565083809196949, 0.009415466338396072, 0.008826453238725662, -0.01052749902009964, 0.1007702648639679, 0.07225419580936432, -0.06640982627868652, -0.10060698539018631,
    0.1740969568490982, 0.1356530785560608, -0.049904488027095795, 0.011068688705563545, 0.07448732107877731, 0.24015705287456512, 0.14380711317062378, -0.04847395420074463,
    0.02026468701660633, -0.05990777909755707, 0.03583734855055809, -0.08495151996612549, 0.03691421449184418, -0.0670284554362297, -0.06746172904968262, -0.0025884374044835567,
    -0.09695888310670853, 0.055278677493333817, -0.016614515334367752, 0.09229763597249985, -0.017897631973028183, -0.07998984307050705, 0.07702888548374176, -0.07363670319318771,
    0.1175571084022522, -0.034916456788778305, 0.045336343348026276, 0.042015962302684784, -0.008354799821972847, 0.14406688511371613, -0.008948161266744137, 0.054666485637426376,
    0.05653570964932442, 0.0033071842044591904, 0.03903602808713913, -0.07456367462873459, -0.029319193214178085, -0.23306456208229065, -0.1352289915084839, 0.018052779138088226,
    -0.015443401411175728, -0.09397120773792267, 0.017149940133094788, -0.31742656230926514, -0.08607885986566544, -0.0056345583871006966, -0.004068233538419008, -0.0557316392660141,
    0.14950524270534515, 0.03185821697115898, 0.045013878494501114, -0.006312109995633364, 0.00019196694483980536, -0.07362169772386551, 0.04896045848727226, -0.026912910863757133,
    -0.15986506640911102, 0.046086497604846954, 0.06882771104574203, -0.0628437027335167, 0.03593933954834938, 2.957824654004071e-05, 0.21235813200473785, -0.03782105818390846,
    -0.04551335796713829, 0.05455346778035164, -0.15525098145008087, 0.10184898972511292, -0.050208963453769684, -0.1433364301919937, -0.030487988144159317, 0.03554009273648262,
    0.10298280417919159, 0.06272800266742706, -0.16547910869121552, 0.08821653574705124, 0.06676390022039413, -0.10653411597013474, -0.1419707089662552, 0.14288216829299927,
    0.04404130578041077, 0.07486841827630997, -0.1296987682580948, -0.025372587144374847, 0.211766317486763, 0.003597975941374898, -0.12055812776088715, -0.0008776187314651906,
    -0.016942083835601807, -0.054881900548934937, -0.011366667225956917, 0.18708080053329468, -0.0479159913957119, -0.1605122685432434, 0.15657570958137512, 0.04857349395751953,
    0.033758826553821564, -0.03959361091256142, -0.03569133207201958, 0.09164255857467651, 0.10290902107954025, 0.06126423552632332, -0.05419226735830307, -0.0754857137799263,
    0.0672706812620163, -0.07754366844892502, 0.07526873797178268, 0.3029123842716217, 0.0301409550011158, -0.00723683089017868, -0.32514622807502747, -0.018092237412929535,
    0.0296208206564188, -0.11297490447759628, 0.03480055183172226, -0.0003695983032230288, -0.07269871979951859, 0.04270807281136513, -0.021717330440878868, 0.000928684719838202,
    -0.11730841547250748, 0.03075719252228737, 0.038551878184080124, -0.04767192527651787, 0.04814997687935829, -0.16678054630756378, -0.1285550892353058, -0.03287007287144661,
    -0.07999052107334137, -0.23250558972358704, 0.0756460577249527, -0.01030466053634882, 0.11898301541805267, -0.23153449594974518, -0.0866146981716156, 0.050336286425590515,
    0.10648400336503983, -0.06906982511281967, 0.09414047747850418, -0.06461386382579803, 0.016600949689745903, -0.06246281787753105, -0.03575623407959938, -0.059194814413785934,
    0.1417417973279953, 0.04607062414288521, 0.035087961703538895, 0.2566502094268799, -0.050063129514455795, 0.13394179940223694, 0.02304212376475334, 0.03662444278597832,
    -0.23347070813179016, -0.05554404854774475, 0.024016840383410454, 0.0007741506560705602, 0.039442747831344604, -0.13786914944648743, 0.09625391662120819, 0.13157619535923004,
    0.03598145768046379, -0.10928703844547272, 0.1282976269721985, 0.08712159097194672, -0.04566911980509758, 0.1693856418132782, 0.06006718799471855, 0.1398129016160965,
    -0.08641287684440613, -0.08532839268445969, -0.014470072463154793, 0.34850814938545227, 0.08712069690227509, 0.05997525900602341, -0.015469498932361603, -0.06191900372505188,
    -0.2645712196826935, -0.04064721614122391, -0.08183955401182175, -0.14323769509792328, -0.07803558558225632, -0.12875963747501373, -0.01209784485399723, 0.24577508866786957,
    0.07880901545286179, 0.11943836510181427, 0.011652987450361252, 0.02514161914587021, -0.035822708159685135, -0.04494756832718849, 0.009050467051565647, 0.005162248387932777,
    -0.006598256528377533, 0.029271142557263374, -0.0013115731999278069, 0.04210595786571503, -0.11870954185724258, -0.06785515695810318, -0.026708371937274933, 0.07316452264785767,
    0.09628240019083023, -0.17998769879341125, -0.06044388562440872, -0.13878554105758667, 0.007076956331729889, -0.025983288884162903, -0.052073802798986435, 0.10517764091491699,
    0.07836376130580902, -0.1276875138282776, -0.006434030365198851, 0.0045205880887806416, -0.31090211868286133, -0.017865577712655067, 0.009137226268649101, -0.21059760451316833,
    0.10937166213989258, 0.022189339622855186, -0.0011570969363674521, -0.052990131080150604, -0.015710903331637383, 0.17695750296115875, 0.06305728852748871, 0.08280017971992493,
    0.03797665238380432, -0.14530353248119354, -0.037323977798223495, -0.02098347246646881, -0.07475105673074722, 0.08952710032463074, -0.005862047895789146, 0.08942870050668716,
    -0.2421227991580963, 0.09546339511871338, -0.05810338258743286, -0.22831545770168304, -0.03135308250784874, 0.022351495921611786, 0.07787778973579407, -0.06483406573534012,
    -0.10142078250646591, -0.03948158398270607, 0.12353090196847916, 0.1538415402173996, 0.06594763696193695, 0.060485389083623886, 0.11540938913822174, -0.11807970702648163,
    0.004134169314056635, -0.051777731627225876, 0.07887224853038788, -0.0401635617017746, 0.07192610204219818, -0.016148939728736877, -0.040808822959661484, -0.1276315450668335,
    0.1127215102314949, 0.26808109879493713, -0.0033798236399888992, 0.015218080952763557, 0.023861391469836235, -0.03291696310043335, -0.12680873274803162, -0.09052670747041702,
    0.03782318904995918, -0.003278052434325218, -0.036978185176849365, -0.04136380925774574, 0.014096937142312527, -0.046677760779857635, -0.10201197862625122, -0.05716077238321304,
    0.10938545316457748, -0.04166148975491524, -0.05380595475435257, 0.03450223058462143, 0.13369768857955933, 0.0165193323045969, 0.06566184759140015, 0.10322747379541397,
    -0.14763998985290527, -0.14596818387508392, 0.1870158463716507, 0.12159380316734314, 0.016571063548326492, 0.10534170269966125, -0.12768833339214325, 0.13286592066287994,
    -0.15411679446697235, 0.11259181797504425, -0.10638472437858582, 0.0346485860645771, -0.03416657820343971, 0.07462847232818604, -0.05050076171755791, 0.009271916933357716,
    -0.02424388751387596, 0.004660779144614935, 0.012272517196834087, -0.35651102662086487, 0.15902723371982574, -0.07915633171796799, -0.05941053852438927, -0.06461772322654724,
    0.3052405118942261, -0.0748111829161644, -0.07319775223731995, -0.021154139190912247, 0.05339233949780464, -0.09047065675258636, -0.08969578891992569, -0.29606083035469055,
    -0.10085485130548477, -0.009811620227992535, -0.04413986578583717, 0.0789528489112854, 0.05440978705883026, 0.09639935195446014, 0.0612378790974617, 0.07411553710699081,
    0.13673950731754303, 0.043837908655405045, 0.07548471540212631, 0.07724368572235107, -0.09411359578371048, 0.007200234569609165, 0.10088436305522919, 0.12300975620746613,
    0.01345896814018488, 0.06599020212888718, -0.03275201469659805, -0.11366505175828934, -0.13813042640686035, -0.12550088763237, -0.11588653922080994, -0.057555343955755234,
    0.05713491141796112, -0.09548082947731018, 0.08966762572526932, 0.02882392890751362, 0.36292189359664917, 0.09121690690517426, -0.04468633607029915, 0.2970789968967438,
    0.047561243176460266, -0.05147622525691986, -0.014625794254243374, -0.11707410961389542, 0.026393041014671326, -0.1921926885843277, -0.04607543721795082, 0.0929224044084549,
    0.007757956627756357, -0.024850886315107346, -0.014258080162107944, 0.1143488809466362, -0.07288163900375366, 0.20213006436824799, -0.09530970454216003, 0.0027882938738912344,
    0.004145375452935696, 0.04240668937563896, -0.06454578042030334, 0.10909537971019745, -0.139195054769516, 0.06608036905527115, 0.2575705647468567, -0.08448287099599838,
    -0.02423233911395073, -0.09860488027334213, 0.05659950524568558, -0.06701664626598358, 0.15680748224258423, 0.022727683186531067, 0.0651557445526123, -0.04375731199979782,
    0.04751270264387131, 0.04492916166782379, 0.04859296232461929, -0.026246290653944016, -0.08881749957799911, -0.06299369782209396, 0.025024203583598137, -0.0737946629524231,
    0.14805743098258972, -0.28422296047210693, -0.0973956435918808, 0.018183616921305656, -0.10062935203313828, 0.18837329745292664, 0.08971311151981354, -0.0937524065375328,
    -0.10751937329769135, 0.01678754761815071, 0.023921161890029907, -0.17012709379196167, -0.01067272201180458, 0.028790688142180443, 0.01754831336438656, -0.0033466133754700422,
    0.03530554100871086, -0.1469474881887436, -0.03691421449184418, 0.08378351479768753, -0.06083488091826439, 0.07306920737028122, 0.0077106230892241, 0.10345356911420822,
    0.10653427243232727, -0.03994549810886383, -0.12574954330921173, 0.019294580444693565, -0.04715033248066902, -0.0016481857746839523, 0.2566489577293396, 0.05431314930319786,
    -0.14936687052249908, 0.10855726152658463, 0.057281412184238434, -0.10938846319913864, 0.14379502832889557, 0.01759283058345318, -0.06922123581171036, -0.04210637882351875,
    -0.16510272026062012, 0.2037910521030426, 0.06720995903015137, 0.34060028195381165, 0.0028402169700711966, -0.05978571996092796, -0.038907960057258606, -0.16088071465492249,
    -0.10672125965356827, -0.12645316123962402, 0.04717271402478218, -0.013566031120717525, 0.1399567872285843, -0.1428566426038742, 0.018014272674918175, 0.12675489485263824,
    -0.04731089249253273, -0.060497649013996124, 0.001011605141684413, -0.0801762193441391, 0.07063652575016022, 0.08649458736181259, -0.15681599080562592, -0.04555558040738106,
    0.1657872200012207, 0.0004389523237477988, 0.028776556253433228, -0.021257003769278526, 0.04222584888339043, -0.04193209111690521, 0.011423883959650993, -0.0880223885178566,
    -0.20156580209732056, 0.06575054675340652, 0.0457657165825367, 0.02533108741044998, 0.03770457208156586, -0.004099737387150526, -0.010626140050590038, -0.0715198963880539,
    0.020492028445005417, -0.07024558633565903, 0.06748967617750168, -0.004787319339811802, -0.43909499049186707, -0.1569942682981491, 0.07518067210912704, -0.1973796933889389,
    0.07095485180616379, -0.024702712893486023, -0.08483195304870605, 0.0834943875670433, -0.06905849277973175, 0.21811410784721375, -0.04484332725405693, 0.12364193797111511,
    0.012214257381856441, 0.08905575424432755, -0.051299531012773514, 0.012733662500977516, 0.1307441145181656, 0.05694294348359108, -0.0647764652967453, -0.12546852231025696,
    0.07119723409414291, 0.06332167983055115, 0.04010611027479172, -0.001963753253221512, -0.07812364399433136, -0.03068295493721962, -0.1507927030324936, -0.019041424617171288,
    0.06116951256990433, -0.0691656619310379, 0.002022991655394435, 0.05485605448484421, 0.09283491224050522, 0.07929406315088272, -0.27742254734039307, -0.036491844803094864,
    0.01721375435590744, -0.06078092008829117, 0.050131332129240036, -0.014164714142680168, -0.15230654180049896, -0.114740751683712, -0.07547354698181152, -0.034932106733322144,
    0.08113507181406021, 0.1544889509677887, -0.04782426729798317, -0.055024392902851105, -0.10115473717451096, -0.06574688106775284, 0.0835181325674057, -0.09549868851900101,
    -0.07611088454723358, 0.030138729140162468, -0.0513610914349556, -0.04086114838719368, 0.03301846608519554, 0.04062248021364212, 0.026676053181290627, 0.02235552668571472,
    -0.18591831624507904, -0.10694056749343872, 0.033322758972644806, 0.04557228088378906, -0.024327727034687996, -0.08492986857891083, 0.027034463360905647, -0.07303991168737411,
    -0.08107683062553406, -0.00735457381233573, -0.20932501554489136, 0.06492534279823303, -0.16211062669754028, -0.09250255674123764, -0.015150923281908035, 0.004067762289196253,
    -0.07047146558761597, 0.011165539734065533, -0.033083755522966385, 0.05191670358181, 0.06826449185609818, 0.036903947591781616, -0.046898774802684784, 0.08746848255395889,
    -0.05714879930019379, 0.0014331969432532787, -0.052272506058216095, -0.3102623224258423, -0.05433826148509979, 0.08605344593524933, -0.030832359567284584, -0.018976952880620956,
    -0.11386818438768387, 0.04029972851276398, -0.03294612467288971, 0.04334862902760506, -0.01631810888648033, 0.10597255825996399, -0.07484506815671921, 0.07983430474996567,
    0.1344389170408249, 0.17327097058296204, 0.08637774735689163, 0.022006485611200333, -0.01731725037097931, -0.1817212551832199, 0.0021383294370025396, -0.06674179434776306,
    0.11921307444572449, -0.003745306981727481, 0.0743703693151474, 0.09335701912641525, 0.03317507356405258, -0.1800137311220169, 0.10606154054403305, 0.01594473049044609,
    -0.10104142874479294, -0.13240566849708557, 0.075517438352108, 0.0466490313410759, 0.20494435727596283, -0.12370765954256058, -0.042698826640844345, -0.07548484206199646,
    0.16432733833789825, -0.03957750275731087, 0.012386426329612732, -0.009503744542598724, 0.45070022344589233, 0.00589462136849761, 0.16738176345825195, -0.0054758405312895775,
    0.0029692931566387415, 0.03326046094298363, -0.1377420574426651, 0.08327935636043549, 0.034084342420101166, -0.1915510594844818, 0.15326879918575287, -0.10219157487154007,
    0.06344601511955261, 0.26968544721603394, -0.10795151442289352, 0.09679761528968811, 0.010458662174642086, 0.0527956448495388, 0.11991280317306519, 0.03378093242645264,
    -0.169296994805336, -0.04497796297073364, 0.06559647619724274, -0.09847299009561539, -0.07469122856855392, -0.047546133399009705, -0.21098308265209198, 0.09789009392261505,
    0.0475253127515316, 0.021533207967877388, -0.17132118344306946, 0.016407150775194168, -0.07899320870637894, -0.061659958213567734, 0.09645849466323853, -0.19360052049160004,
    -0.1661868542432785, 0.06884989142417908, 0.074449822306633, -0.038681644946336746, 0.14531953632831573, -0.15930484235286713, 0.03363784775137901, -0.07487618923187256,
    -0.1667393296957016, -0.10132136195898056, -0.053054433315992355, 0.03299429267644882, 0.006759768817573786, -0.11770372837781906, -0.10298386961221695, 0.050068214535713196,
    -0.1949940174818039, -0.03774417191743851, -0.0011624512262642384, -0.03169660270214081, -0.012294488959014416, 0.027855245396494865, -0.0577533096075058, -0.040275245904922485,
    -0.03537634015083313, -0.06891532987356186, 0.10484453290700912, -0.05054203420877457, 0.04778740927577019, 0.010321956127882004, 0.057984042912721634, 0.0830700471997261,
    -0.048024311661720276, -0.03169485181570053, -0.12828294932842255, -0.10053503513336182, 0.24205295741558075, 0.04198591038584709, -0.052466727793216705, 0.12584459781646729,
    -0.11553468555212021, 0.17965659499168396, 0.0594211146235466, 0.011445191688835621, -0.06730145215988159, 0.006167861167341471, 0.05522245541214943, -0.013999969698488712,
    -0.0414237380027771, -0.22190234065055847, -0.025200562551617622, 0.32325902581214905, -0.031828440725803375, 0.011056589893996716, -0.03349429368972778, -0.059625592082738876,
    0.24961143732070923, -0.004984274972230196, -0.02309783361852169, 0.18167628347873688, -0.05134109780192375, 0.008685112930834293, -0.04023094102740288, -0.2879328727722168,
    0.010604971088469028, 0.08883630484342575, 0.03248223289847374, 0.06274678558111191, -0.2155705988407135, 0.1811605542898178, 0.11883670836687088, 0.030945682898163795,
    0.06983227282762527, -0.09997633844614029, -0.04861140996217728, -0.015977976843714714, 0.20800484716892242, -0.1554591953754425, -0.032605383545160294, 0.005047008860856295,
    -0.029111899435520172, 0.03438708558678627, 0.12423627078533173, 0.06010863557457924, -0.00973556563258171, -0.02440688945353031, 0.06783903390169144, -0.008090498857200146,
    -0.00940334890037775, -0.20299144089221954, 0.03578762710094452, 0.03029611147940159, -0.4515048861503601, -0.002708670450374484, -0.175031378865242, 0.19043754041194916,
    -0.02741153910756111, -0.08154618740081787, -0.0014260649913921952, 0.06056304648518562, -0.06427349895238876, 0.1605551391839981, 0.025707706809043884, 0.015499282628297806,
    -0.05939983204007149, -0.040544625371694565, -0.19726012647151947, 0.029607322067022324, -0.21370378136634827, -0.05426090583205223, -0.19765004515647888, 0.09808628261089325,
    -0.06945747882127762, 0.0012087252689525485, 0.06497077643871307, 0.14917512238025665, -0.01759304665029049, -0.030995795503258705, 0.15135988593101501, -0.03481607139110565,
    0.04687348008155823, 0.03975510597229004, 0.07242066413164139, -0.0181018877774477, -0.04734795168042183, -0.050395768135786057, 0.1358344405889511, 0.20414920151233673,
    0.11580915004014969, -0.04921071603894234, 0.05915191024541855, 0.037152212113142014, 0.09447596222162247, -0.21695740520954132, 0.16630157828330994, -0.1565755009651184,
    -0.016840197145938873, 0.022699374705553055, -0.011588445864617825, 0.018280787393450737, 0.05485348030924797, 0.21629346907138824, -0.12605535984039307, -0.02836226485669613,
    -0.017284320667386055, -0.042687978595495224, -0.02123277448117733, 0.02299349568784237, -0.00617978535592556, -0.05680054798722267, -0.06326653808355331, -0.01695147342979908,
    -0.19717484712600708, -0.07495730370283127, 0.012980912812054157, 0.10488185286521912, -0.00884697400033474, 0.14346015453338623, -0.07458745688199997, 0.17130720615386963,
    -0.010175541043281555, -0.09840913861989975, -0.05130819231271744, 0.03610854595899582, -0.058783527463674545, 0.05793308466672897, -0.1647845059633255, 0.00444457633420825,
    0.04192480817437172, -0.024435853585600853, -0.19755356013774872, -0.015927288681268692, 0.023944959044456482, 0.26127249002456665, 0.10972770303487778, -0.11240553110837936,
    0.1333920806646347, -0.10319356620311737, -0.05812521651387215, -0.33412131667137146, -0.0869636982679367, -0.10202348977327347, 0.055435243993997574, -0.0012904084287583828,
    -0.24798105657100677, -0.09089537709951401, 0.04312215745449066, 0.04075747728347778, -0.14330027997493744, -0.07281288504600525, 0.11316842585802078, 0.22908146679401398,
    -0.11899019032716751, 0.06248848885297775, -0.05324523150920868, -0.12977179884910583, -0.016062932088971138, 0.014092456549406052, 0.07904659956693649, 0.027021976187825203,
    0.04711293801665306, -0.1589314490556717, -0.11778751760721207, 0.06164953112602234, 0.1185920387506485, 0.007837148383259773, -0.08254273980855942, 0.061721909791231155,
    -0.0807521715760231, 0.09472823143005371, 0.08401492238044739, -0.1450585424900055, 0.2015940099954605, 0.04393882304430008, 0.01912051811814308, -0.05626056715846062,
    -0.10737591981887817, 0.0644104927778244, -0.033513352274894714, -0.023074040189385414, 0.38990506529808044, -0.12607762217521667, 0.05853182449936867, -0.2562938630580902,
    -0.13401851058006287, -0.23283596336841583, 0.14241454005241394, 0.12284792214632034, -0.03643469884991646, -0.1683516949415207, 0.033343542367219925, -0.03216614946722984,
    0.022687721997499466, 0.09381028264760971, 0.05989817529916763, 0.018017711117863655, -0.07776067405939102, 0.025583691895008087, -0.040023546665906906, 0.12561184167861938,
    0.07654623687267303, 0.03128921985626221, -0.07671371102333069, -0.20568972826004028, 0.08149989694356918, 0.022486528381705284, 0.13975952565670013, -0.020840678364038467,
    -0.025066670030355453, 0.019699161872267723, 0.11521318554878235, 0.04673668369650841, 0.010059908032417297, 0.12129490822553635, -0.12199939042329788, 0.2213691622018814,
    0.12003546208143234, 0.02413494512438774, 0.03914748877286911, -0.022499924525618553, 0.18103811144828796, 0.1387932002544403, 0.17738504707813263, -0.05168695002794266,
    0.176491379737854, 0.04585745185613632, -0.07046762853860855, -0.02341328375041485, 0.06879138946533203, -0.08591115474700928, 0.2126702070236206, 0.05864937976002693,
    -0.0393420048058033, 0.007356110494583845, -0.08331938832998276, -0.13640117645263672, 0.010838422924280167, -0.004970337729901075, -0.11050446331501007, 0.041410062462091446,
    -0.06807611882686615, -0.037213362753391266, 0.004358964040875435, 0.009755010716617107, -0.09309786558151245, 0.1123153418302536, 0.010147041641175747, 0.0417257696390152,
    -0.024307234212756157, -0.09006816893815994, 0.10358953475952148, 0.0862397849559784, -0.2678329050540924, -0.07820220291614532, 0.2426532804965973, 0.11319731175899506,
    0.12580078840255737, -0.04199860244989395, -0.003407256444916129, 0.041672732681035995, 0.09665469825267792, 0.023692486807703972, 0.019847432151436806, -0.06704087555408478,
    0.13838712871074677, 0.03487948328256607, 0.02177903801202774, 0.3350437581539154, -0.07982994616031647, 0.04741338640451431, 0.039842188358306885, 0.13377822935581207,
    0.19958850741386414, 0.031086057424545288, -0.12154395133256912, -0.015939824283123016, -0.02787615731358528, -0.08855593204498291, 0.027041058987379074, -0.006780424155294895,
    -0.11972387135028839, -0.033562708646059036, -0.029702039435505867, 0.0776204764842987, 0.1104978546500206, -0.013418243266642094, -0.006199435330927372, -0.09503627568483353,
    0.07171785086393356, -0.06382796168327332, 0.09510033577680588, -0.0062761749140918255, -0.03691740706562996, -0.10960178822278976, -0.03849375247955322, -0.020351171493530273,
    -0.08075733482837677, -0.07937578111886978, -0.04527531564235687, -0.10534514486789703, 0.08380420506000519, 0.01574423536658287, 0.17844116687774658, -0.05028240382671356,
    0.16164915263652802, 0.11649647355079651, -0.13529208302497864, -0.011433692649006844, -0.30030107498168945, 0.02095222845673561, -0.10509343445301056, 0.23068122565746307,
    -0.0597483292222023, -0.03241191431879997, 0.06673694401979446, -0.18638598918914795, -0.09564924985170364, 0.14409464597702026, 0.16712886095046997, -0.038065239787101746,
    -0.010939586907625198, 0.15802101790905, -0.005649141035974026, -0.028365740552544594, 0.019892431795597076, -0.11466193199157715, -0.022434329614043236, -0.028926895931363106,
    -0.12252604961395264, -0.015549788251519203, -0.06943246722221375, 0.2582021951675415, -0.09124021977186203, 0.05482091009616852, -0.25354838371276855, 0.005588270258158445,
    -0.047131530940532684, 0.021034574136137962, 0.1363191306591034, -0.048735540360212326, 0.3135110139846802, 0.12273548543453217, -0.023325784131884575, -0.08110857754945755,
    -0.23272603750228882, 0.022627465426921844, 0.08879458904266357, 0.03669532388448715, 0.07324609905481339, 0.051764048635959625, 0.03327137231826782, 0.10026612132787704,
    0.07037319988012314, -0.12044475227594376, 0.15752792358398438, 0.012425566092133522, 0.1077638790011406, -0.09212078899145126, 0.1461651474237442, 0.019027836620807648,
    -0.10803969949483871, -0.06596104800701141, -0.07132770121097565, -0.022281572222709656, -0.022524209693074226, -0.03657057136297226, -0.12486423552036285, -0.04278075695037842,
    -0.09784096479415894, 0.00957572553306818, -0.020892111584544182, -0.039237331598997116, -0.09960038214921951, 0.009285366162657738, 0.048269543796777725, -0.07328829914331436,
    -0.0010675819357857108, -0.07570179551839828, 0.06658243387937546, 0.1801152527332306, 0.29360178112983704, -0.005859722383320332, 0.030419185757637024, -0.16015180945396423,
    0.11104229092597961, -0.0582878477871418, 0.21611496806144714, 0.006325474940240383, 0.004905985668301582, 0.026123620569705963, 0.20054246485233307, -0.012645375914871693,
    0.0128297358751297, 0.0361705906689167, 0.005712009035050869, -0.3118273913860321, -0.1036042869091034, -0.08391702175140381, -0.001823007594794035, 0.1623152792453766,
    -0.12216100841760635, -0.012101461179554462, 0.075173020362854, 0.009753860533237457, 0.03399103507399559, -0.012432261370122433, -0.18492810428142548, -0.2185051590204239,
    -0.08135682344436646, -0.06596002727746964, 0.06669533997774124, 0.12369822710752487, -0.10245775431394577, -0.03747725859284401, 0.007699219509959221, -0.16605858504772186,
    -0.036702677607536316, -0.030098987743258476, 0.04087561368942261, 0.10453895479440689, -0.09075162559747696, -0.037652287632226944, 0.13228267431259155, 0.03360835090279579,
    0.013209383934736252, -0.03967192769050598, -0.16600364446640015, -0.01901317946612835, 0.014790868386626244, 0.042347609996795654, 0.18062937259674072, -0.05332871526479721,
    -0.054844941943883896, 0.03312157467007637, -0.07681416720151901, 0.032081782817840576, 0.20168069005012512, 0.138311967253685, -0.1685703694820404, -0.03684146702289581,
    0.022530170157551765, 0.11569445580244064, 0.030173908919095993, -0.03943909704685211, -0.07275568693876266, -0.13236534595489502, 0.19278797507286072, -0.0658387839794159,
    0.12617604434490204, -0.012623208574950695, -0.20428459346294403, 0.02423665300011635, 0.047277677804231644, 0.027187073603272438, -0.12140484154224396, 0.040888555347919464,
    -0.13587190210819244, -0.019423022866249084, 0.08709284663200378, -0.2702036201953888, 0.05024627968668938, -0.0665523111820221, -0.04525693506002426, 0.11568223685026169,
    0.0800214409828186, 0.05104551091790199, 0.13194310665130615, 0.027239620685577393, 0.1535177379846573, -0.0066599855199456215, 0.14065371453762054, -0.09129231423139572,
    0.0674927681684494, -0.06304159760475159, 0.07699336856603622, -0.024053342640399933, 0.1550341248512268, 0.06358551979064941, -0.1632709503173828, -0.09857597202062607,
    -0.05097263306379318, 0.18936069309711456, 0.13308975100517273, -0.013126791454851627, -0.12791691720485687, 0.1766374409198761, -0.16657905280590057, 0.07120472937822342,
    -0.04892018064856529, -0.04754512012004852, -0.06707627326250076, 0.044836532324552536, -0.005072685424238443, -0.031455814838409424, 0.01292370818555355, 0.010997049510478973,
    0.026538003236055374, 0.049365341663360596, 0.10048329085111618, 0.029402663931250572, 0.1625087708234787, 0.05420922487974167, 0.052576638758182526, 0.019042763859033585,
    0.002756681526079774, -0.04039064049720764, -0.12582719326019287, 0.10597333312034607, -0.05237232521176338, -0.27734678983688354, -0.04354287311434746, -0.1564091295003891,
    0.04589371010661125, 0.05629687383770943, 0.2004670351743698, 0.06945658475160599, -0.18800508975982666, 0.029763903468847275, -0.005613763350993395, 0.07065024226903915,
    -0.08219661563634872, 0.02790285460650921, 0.03666263446211815, 0.29826676845550537, -0.06370976567268372, -0.04503340646624565, 0.025264902040362358, 0.2380300611257553,
    0.027139978483319283, -0.07040422409772873, 0.07995849847793579, -0.036076441407203674, -0.067018061876297, 0.057960331439971924, 0.03432562202215195, 0.2647409737110138,
    0.19793672859668732, 0.05549659579992294, -0.01529767643660307, -0.20880553126335144, -0.06580454111099243, 0.07482098042964935, 0.03672602400183678, -0.16176190972328186,
    0.060809481889009476, -0.23491236567497253, -0.02476256713271141, 0.06048457697033882, -0.03747791796922684, 0.13538801670074463, 0.1169690266251564, -0.2891958951950073,
    -0.033024322241544724, 0.12623637914657593, -0.22410263121128082, 0.13410884141921997, -0.14376957714557648, 0.07155101746320724, 0.1351127326488495, -0.04633311182260513,
    -0.1021561399102211, -0.19268681108951569, -0.0825849398970604, 0.007696745451539755, -0.12074452638626099, -0.014986432157456875, 0.1316319704055786, -0.11961933970451355,
    -0.05664270743727684, -0.008227008394896984, 0.054046664386987686, 0.04044763743877411, 0.06468678265810013, 0.10680093616247177, 0.043939780443906784, -0.13178785145282745,
    0.20804615318775177, -0.13346649706363678, -0.10660851746797562, 0.021128114312887192, -0.08024571090936661, -0.14582665264606476, 0.09208627790212631, 0.16006755828857422,
    -0.055161379277706146, 0.029708335176110268, 0.22848035395145416, 0.29029205441474915, 0.02775556407868862, -0.003479546867311001, 0.19525887072086334, -0.03145819529891014,
    -0.0024984623305499554, 0.0655103474855423, -0.10214503109455109, 0.015472735278308392, 0.1913975030183792, -0.1077771931886673, -0.2232658863067627, 0.04036000743508339,
    0.13317005336284637, 0.0493665412068367, 0.0777495801448822, -0.04661571606993675, -0.044276539236307144, -0.09594786912202835, -0.02535136602818966, -0.10870993882417679,
    0.07755844295024872, -0.14023590087890625, -0.04618441313505173, -0.03472199663519859, -0.006627310533076525, -0.06918966770172119, -0.10981207340955734, 0.02601144090294838,
    -0.034034330397844315, 0.03313460946083069, -0.060214146971702576, -0.024153394624590874, 0.027516642585396767, -0.0406634658575058, -0.04551670700311661, 0.01647256314754486,
    0.16125930845737457, 0.1124485656619072, 0.0402669683098793, 0.12488412857055664, 0.07985220849514008, 0.01916237361729145, -0.11379086226224899, 0.05660484358668327,
    0.008066123351454735, -0.2207007110118866, -0.0999797061085701, -0.09899284690618515, -0.3075118958950043, 0.01200044248253107, 0.05621355026960373, -0.043280474841594696,
    0.06866706907749176, 0.13719503581523895, -0.06717270612716675, -0.0857173427939415, -0.08478175103664398, -0.17202168703079224, 0.1255856305360794, 0.05150583013892174,
    0.020721182227134705, -0.0821116641163826, -0.0036903375294059515, -0.2755435109138489, -0.050492964684963226, 0.05086568742990494, 0.060959216207265854, 0.3542613089084625,
    0.08346256613731384, 0.09116259217262268, -0.21106331050395966, 0.04604063555598259, -0.09778601676225662, 0.09005606919527054, 0.10005144774913788, -0.09054990857839584,
    -0.10941970348358154, -0.021737826988101006, 0.014365356415510178, 0.01394711434841156, 0.028473857790231705, -0.11173797398805618, -0.2635757625102997, -0.003651231760159135,
    0.05267605930566788, 0.08164466917514801, 0.17742890119552612, 0.006134745664894581, 0.06370417028665543, -0.08199594914913177, -0.055169664323329926, -0.12876088917255402,
    0.024659045040607452, -0.014771508052945137, -0.11466088145971298, -0.06797195225954056, -0.08960028737783432, 0.06344462186098099, -0.008381715975701809, 0.0734744444489479,
    0.060916803777217865, -0.07128080725669861, -0.25079306960105896, 0.0030991958919912577, 0.02597321756184101, 0.00857020728290081, 0.1295466274023056, 0.22597435116767883,
    0.20019114017486572, -0.1115812212228775, 0.2857353985309601, 0.003855072660371661, -0.24411973357200623, -0.07472887635231018, -0.0041222237050533295, -0.10325843095779419,
    -0.08843095600605011, 0.04436826333403587, 0.09578373283147812, -0.07796865701675415, -0.11216375976800919, -0.005285270977765322, -0.11856134235858917, -0.08699407428503036,
    0.12587550282478333, 0.06194901093840599, -0.04829108715057373, -0.3613237142562866, 0.020953966304659843, 0.049805644899606705, 0.01944945566356182, -0.17748738825321198,
    -0.051667533814907074, 0.016043009236454964, -0.2152925729751587, 0.019343243911862373, 0.07579848170280457, -0.1420273631811142, 0.2913818657398224, 0.19111569225788116,
    -0.34282028675079346, 0.030328253284096718, 0.08900187909603119, -0.027674764394760132, -0.06975066661834717, -0.2902080714702606, 0.043923571705818176, -0.004103616811335087,
    0.2010573446750641, 0.13658612966537476, 0.009382477961480618, 0.04194273799657822, 0.022441990673542023, -0.12149430066347122, 0.1689518839120865, -0.06901449710130692,
    -0.02412114292383194, -0.01461017969995737, -0.11750990897417068, 0.03704935312271118, 0.034025639295578, 0.015480033122003078, 0.02500900812447071, 0.061253540217876434,
    0.06521996110677719, 0.16055893898010254, -0.05504555627703667, -0.07165445387363434, 0.11571948230266571, 0.07897645235061646, -0.055588047951459885, 0.0886947512626648,
    -0.06785143911838531, -0.007943255826830864, -0.07643242925405502, -0.1335829347372055, 0.3708108961582184, 0.029060186818242073, 0.09216545522212982, 0.009924587793648243,
    -0.034880101680755615, 0.13732466101646423, 0.13762909173965454, 0.10794433951377869, 0.09561414271593094, -0.09431279450654984, -0.01222564559429884, -0.08150702714920044,
    -0.05942845717072487, -0.20489855110645294, -0.023550935089588165, 0.2556394636631012, -0.04245690256357193, -0.03619980067014694, 0.07699723541736603, 0.20313353836536407,
    -0.18477873504161835, 0.005434924736618996, 0.024658922106027603, 0.055793773382902145, 0.011102146469056606, -0.04238973185420036, 0.10318902879953384, -0.1448056995868683,
    -0.0011383399832993746, -0.06492141634225845, -0.003948517609387636, 0.3819189965724945, -0.050409428775310516, -0.10075193643569946, -0.15289416909217834, -0.005060612224042416,
    -0.1544734537601471, 0.16664452850818634, -0.005515607073903084, -0.0846497118473053, 0.24039946496486664, 0.051664359867572784, -0.043566491454839706, -0.024060936644673347,
    -0.061661247164011, -0.1261986345052719, 0.01571095734834671, 0.04944224655628204, -0.027359038591384888, 0.04067369922995567, -0.09325186908245087, -0.10558018833398819,
    -0.08176159858703613, -0.07875583320856094, -0.2928089201450348, 0.05871110409498215, 0.0673922747373581, -0.017837125808000565, -0.12150515615940094, -0.18171371519565582,
    0.08314765244722366, -0.10010634362697601, 0.24172407388687134, -0.15913106501102448, -0.03346364572644234, 0.026142220944166183, 0.08910972625017166, -0.014149226248264313,
    -0.17833319306373596, -0.0718657448887825, 0.04433805122971535, -0.10975126922130585, 0.1300397664308548, 0.13934335112571716, -0.014392778277397156, -0.08605225384235382,
    -0.19754144549369812, 0.07775799930095673, -0.13282102346420288, 0.3768845796585083, 0.06662287563085556, -0.007858861237764359, -0.1807553470134735, -0.16526058316230774,
    0.12085812538862228, 0.05139739438891411, 0.0824989303946495, 0.010997467674314976, -0.126864954829216, 0.005902454257011414, -0.22249436378479004, 0.16394750773906708,
    -0.03329595550894737, -0.09062899649143219, 0.059063851833343506, -0.1108117327094078, 0.08278211206197739, 0.052631914615631104, -0.0025696519296616316, -0.13739000260829926,
    0.22711022198200226, -0.11362999677658081, -0.08942781388759613, -0.08264950662851334, -0.008813990280032158, 0.12894150614738464, 0.1987006664276123, -0.04279891029000282,
    0.01430774200707674, 0.07523461431264877, -0.021735697984695435, 0.10763256996870041, -0.00377094279974699, 0.11417499929666519, 0.15983662009239197, -0.08161520212888718,
    -0.09171035885810852, 0.006711788475513458, -0.033103011548519135, -0.0832572877407074, -0.09600628912448883, 0.2569526731967926, 0.03994527831673622, 0.011280474252998829,
    -0.14042620360851288, 0.08234383165836334, 0.04476846754550934, -0.060504283756017685, -0.19019056856632233, 0.024787666276097298, 0.008285961113870144, 0.012286721728742123,
    -0.08730286359786987, 0.12491767853498459, 0.042036108672618866, -0.11402345448732376, -0.07629139721393585, -0.11361893266439438, -0.15179039537906647, 0.01995641551911831,
    0.08501093834638596, -0.028233449906110764, -0.06540045142173767, -0.21675188839435577, -0.0073654125444591045, 0.14723411202430725, 0.024597015231847763, 0.12333321571350098,
    0.23681974411010742, -0.10287715494632721, 0.19165213406085968, 0.05559898167848587, 0.12682035565376282, 0.1392533928155899, -0.10814187675714493, 0.3026149570941925,
    0.2744891345500946, 0.14157624542713165, -0.06490521878004074, -0.4291304051876068, 0.012336940504610538, 0.19655171036720276, 0.18671578168869019, -0.040576111525297165,
    -0.1241563931107521, 0.02221429906785488, -0.013326209969818592, 0.13356444239616394, -0.13562510907649994, 0.12811614573001862, -0.03540729358792305, -0.04466761276125908,
    -0.17521221935749054, 0.05147894471883774, 0.0053480700589716434, 0.11371973156929016, -0.20484766364097595, 0.008409612812101841, -0.14627493917942047, 0.12083794176578522,
    -0.02998976781964302, -0.009212286211550236, -0.047663893550634384, 0.0015632607974112034, -0.16853202879428864, 0.07087170332670212, -0.24884870648384094, 0.06329207867383957,
    -0.18375639617443085, 0.09182475507259369, -0.02487928234040737, -0.09119519591331482, 0.08128134161233902, -0.0008025129791349173, 0.1329018622636795, 0.07435444742441177,
    0.1687130630016327, 0.1717604547739029, 0.010935922153294086, -0.062431104481220245, 0.10961742699146271, -0.09822480380535126, -0.12349869310855865, -0.12145643681287766,
    -0.08425400406122208, -0.012839059345424175, 0.04890703409910202, -0.3507566750049591, 0.06539887934923172, -0.003056842368096113, 0.03377222269773483, -0.02384294755756855,
    -0.05695744603872299, -0.049826692789793015, -0.07832908630371094, -0.025505730882287025, -0.131961852312088, 0.2512138783931732, -0.02246323600411415, -0.015548806637525558,
    0.2065887451171875, 0.11092565953731537, 0.0969204530119896, -0.029366139322519302, -0.042987849563360214, -0.02156628854572773, -0.060193389654159546, -0.10024388134479523,
    -0.09870914369821548, -0.023722872138023376, 0.030808497220277786, -0.030774252489209175, 0.08540253341197968, -0.008409318514168262, -0.18928569555282593, 0.08368078619241714,
    0.17834967374801636, -0.029107453301548958, -0.11439120024442673, -0.09703286737203598, 0.0076721240766346455, 0.09374000132083893, 0.10128001123666763, 0.10198193788528442,
    0.04517754912376404, -0.10054086148738861, 0.0454571507871151, 0.04758729413151741, 0.025557978078722954, 0.15058909356594086, -0.04352864995598793, -0.05686909332871437,
    0.08562883734703064, 0.2170335054397583, -0.048700932413339615, -0.039337266236543655, -0.07403578609228134, 0.07462736964225769, 0.02834905870258808, -0.12875230610370636,
    0.04270567744970322, 0.25049200654029846, 0.027033956721425056, 0.11332565546035767, -0.10747761279344559, 0.0155484015122056, 0.12991344928741455, -0.2048622965812683,
    0.009583440609276295, 0.1383717656135559, 0.04423866048455238, 0.21033142507076263, 0.13735288381576538, 0.0158891212195158, -0.028533807024359703, 0.10715653002262115,
    -0.1870173066854477, 0.10077746212482452, -0.2898991107940674, 0.0409369058907032, 0.1104125902056694, -0.013979041948914528, -0.24005256593227386, -0.1780894249677658,
    -0.16575662791728973, 0.04902850463986397, 0.07929712533950806, 0.005049696657806635, -0.13321234285831451, -0.005076736211776733, 0.013271542266011238, 0.008611205033957958,
    -0.1073891744017601, 0.11200456321239471, 0.12406782805919647, 0.1381215751171112, -0.204055055975914, 0.06074943765997887, -0.13038967549800873, -0.1482814997434616,
    -0.05341939628124237, 0.04586997255682945, 0.0346280001103878, -0.12291307002305984, 0.06186006963253021, -0.05023925006389618, 0.08990705013275146, 0.05733583867549896,
    -0.06828894466161728, 0.22548197209835052, 0.009482817724347115, 0.008414105512201786, 0.23430484533309937, 0.23335327208042145, 0.008963007479906082, 0.07297435402870178,
    -0.03331795334815979, 0.058563485741615295, -0.06630171090364456, 0.08083812892436981, -0.024326266720891, -0.00035811177804134786, 0.07150810956954956, 0.04704035818576813,
    -0.025119543075561523, 0.19679608941078186, 0.018382970243692398, -0.037802040576934814, -0.14363428950309753, -0.09765923023223877, -0.012535328045487404, -0.00012305632117204368,
    -0.021059412509202957, 0.05991372838616371, 0.1257753074169159, 0.2859075367450714, 0.12291064858436584, 0.04165247827768326, 0.1754026710987091, -0.010353362187743187,
    -0.11242171376943588, -0.07012773305177689, 0.018522145226597786, 0.02590116858482361, -0.039965543895959854, -0.005549988243728876, 0.33333852887153625, 0.2143680900335312,
    -0.2500344216823578, -0.11726614087820053, 0.10250912606716156, -0.11191321909427643, -0.13855203986167908, 0.056228600442409515, -0.04513390362262726, -0.12907205522060394,
    -0.07648596167564392, 0.12943384051322937, -0.13367044925689697, 0.05768783390522003, -0.0431329645216465, -0.09025067090988159, -0.1923142671585083, -0.13625285029411316,
    0.27036020159721375, -0.0766778215765953, 0.02559686079621315, -0.08887670934200287, 0.032160867005586624, -0.015781909227371216, -0.05082697048783302, 0.07563640177249908,
    -0.09731069952249527, 0.0632905513048172, 0.03959323465824127, -0.15525704622268677, 0.00026871898444369435, -0.04359801486134529, -0.10014412552118301, -0.000333911448251456,
    0.01230238750576973, 0.023714931681752205, -0.0997241735458374, -0.16535428166389465, 0.04957115650177002, -0.02902970463037491, -0.21477550268173218, 0.23794201016426086,
    0.014470010995864868, -0.04579661786556244, 0.12629055976867676, -0.032791148871183395, -0.16718611121177673, -0.025254014879465103, -0.14623838663101196, -0.028849899768829346,
    0.011422471143305302, -0.028830155730247498, 0.048389460891485214, -0.21664388477802277, 0.02846391871571541, 0.013207332231104374, 0.01031886599957943, -0.11863791942596436,
    0.03871412202715874, -0.053839050233364105, 0.13176561892032623, 0.08870630711317062, -0.03194476291537285, 0.10391166061162949, -0.19140587747097015, -0.1100221574306488,
    -0.23935478925704956, -0.0868014544248581, 0.02138170786201954, 0.44724082946777344, 0.012455463409423828, 0.049374908208847046, -0.13930058479309082, 0.10049781203269958,
    0.2519151568412781, 0.17085255682468414, -0.026767320930957794, 0.04002552479505539, -0.0721990242600441, 0.01576467975974083, 0.10338334739208221, -0.37152746319770813,
    0.007501548621803522, -0.09671752154827118, 0.16069473326206207, 0.02533736266195774, 0.027922306209802628, 0.10952092707157135, 0.013152861036360264, 0.06835214793682098,
    -0.01900341734290123, 0.2360266000032425, 0.1336553543806076, -0.025963513180613518, -0.30207115411758423, -0.09849807620048523, 0.169053852558136, -0.12249626964330673,
    -0.10487227141857147, 0.03378353267908096, 0.11211791634559631, -0.15737412869930267, -0.10016109049320221, -0.016618674620985985, 0.00022225444263312966, 0.09105519205331802,
    -0.0025249775499105453, -0.1872553527355194, -0.01439754944294691, 0.007044200785458088, -0.2586805522441864, -0.10947319865226746, 0.08466397970914841, 0.05497371032834053,
    0.08994988352060318, 0.09516920149326324, -0.10407188534736633, -0.21703769266605377, 0.00404404615983367, 0.08512302488088608, -0.12850421667099, -0.1362208127975464,
    0.14863541722297668, -0.0236260537058115, 0.1575630158185959, 0.015259018167853355, -0.029169045388698578, 0.09816963970661163, -0.307332843542099, -0.060146085917949677,
    -0.06627824157476425, 0.09256362915039062, 0.05046328157186508, -0.06949940323829651, 0.22383156418800354, -0.03768594190478325, 0.14215132594108582, -0.21377111971378326,
    0.23951269686222076, -0.1794724017381668, 0.19201740622520447, -0.0009861094877123833, -0.02663014642894268, 0.09454723447561264, 0.2994604706764221, -0.2155684232711792,
    0.22842328250408173, 0.0779959112405777, 0.041897762566804886, -0.0415680818259716, -0.011941527016460896, 0.013802127912640572, -0.02613101527094841, -0.06960630416870117,
    0.13966110348701477, -0.0167408287525177, 0.05199679732322693, -0.16506530344486237, -0.030687276273965836, -0.12068843096494675, -0.11980854719877243, 0.05560384318232536,
    -0.34214743971824646, 0.2566434144973755, -0.16749164462089539, -0.14918583631515503, -0.1400003433227539, -0.04375474154949188, 0.03477363660931587, -0.008455281145870686,
    0.13964807987213135, -0.01491971593350172, 0.1694314032793045, -0.06174364686012268, 0.14306138455867767, -0.1155984103679657, -0.05763036757707596, 0.08947984129190445,
    0.08744338899850845, -0.08013611286878586, -0.09100554883480072, 0.23032055795192719, 0.11443319171667099, 0.005316403228789568, 0.020278669893741608, -0.23005801439285278,
    0.11323138326406479, -0.045435238629579544, 0.151629239320755, 0.101533442735672, -0.17167608439922333, -0.02074369229376316, 0.2374349981546402, 0.23936080932617188,
    -0.058076564222574234, 0.0926000326871872, -0.05478307604789734, -0.3966279625892639, -0.08099044114351273, -0.013217364437878132, -0.19532321393489838, 0.262505441904068,
    -0.029959579929709435, 0.0947161540389061, 0.13077567517757416, 0.08854462206363678, 0.16132476925849915, 0.14481903612613678, 0.1272430419921875, -0.022974852472543716,
    -0.2518996596336365, 0.052660562098026276, 0.12533852458000183, -0.18503224849700928, -0.08654587715864182, -0.007086852099746466, -0.14220832288265228, -0.07816465944051743,
    -0.11173557490110397, 0.1988297998905182, -0.2848109304904938, 0.013723918236792088, 0.37364527583122253, -0.10144045203924179, -0.015621686354279518, 0.18091468513011932,
    0.06577075272798538, -0.029515042901039124, 0.16553187370300293, 0.07439393550157547, -0.07769253849983215, 0.021441364660859108, -0.14031025767326355, 0.1189151182770729,
    -0.0909128189086914, -0.008127840235829353, 0.06971778720617294, -0.15096187591552734, 0.049812108278274536, -0.10283178091049194, 0.015910061076283455, -0.08070801198482513,
    -0.16379983723163605, -0.11727553606033325, -0.12324874848127365, 0.14611680805683136, 0.05229487270116806, -0.03566544130444527, -0.04772217571735382, 0.10001342743635178,
    -0.016975639387965202, -0.136562779545784, 0.05954510346055031, -0.04267575219273567, 0.024327252060174942, -0.004119229502975941, 0.05116203427314758, -0.24964943528175354,
    0.17105436325073242, 0.02412768267095089, 0.10951080918312073, -0.0018878777045756578, 0.21567554771900177, -0.16877275705337524, 0.02988727204501629, 0.11206487566232681,
    -0.0933036059141159, 0.13459080457687378, -0.11691039800643921, -0.0006542115588672459, 0.13747969269752502, -0.02796880714595318, 0.13147489726543427, -0.23856505751609802,
    -0.17949964106082916, -0.015446750447154045, -0.06897914409637451, -0.0643579512834549, -0.030737590044736862, -0.02182023786008358, -0.09411235898733139, 0.043871939182281494,
    0.11305441707372665, -0.07037745416164398, 0.09078364074230194, 0.004741081967949867, -0.08962824195623398, 0.1219334602355957, -0.08941368758678436, -0.026456525549292564,
    0.1302281767129898, -0.15200664103031158, -0.020449919626116753, -0.026756227016448975, 0.26526394486427307, 0.1544928401708603, -0.15412837266921997, -0.07412564009428024,
    0.06297269463539124, 0.008144402876496315, -0.13247749209403992, 0.010635150596499443, 0.24881045520305634, -0.05181106552481651, 0.09946165978908539, 0.2696799039840698,
    -0.03334369137883186, 0.02595767006278038, 0.01695464551448822, -0.2034221887588501, 0.05437319725751877, -0.032962676137685776, 0.002941360231488943, -0.1511916071176529,
    -0.17169299721717834, 0.07466083019971848, -0.22417297959327698, 0.0515885092318058, -0.08242904394865036, -0.10577112436294556, -0.07538166642189026, -0.14774204790592194,
    0.36720511317253113, -0.041907720267772675, -0.01896047778427601, 0.020234016701579094, -0.17648480832576752, 0.030091071501374245, 0.028948500752449036, 0.05893346667289734,
    0.02965446002781391, 0.2240590751171112, -0.015929320827126503, 0.08241472393274307, 0.16253019869327545, 0.2995724081993103, -0.07692290842533112, -0.07621163129806519,
    -0.28609755635261536, 0.014555675908923149, -0.04804760217666626, 0.13863201439380646, -0.0927165299654007, 0.029603738337755203, -0.093775175511837, -0.06065579876303673,
    -0.03476225212216377, 0.04753058776259422, -0.04430795833468437, 0.007581056095659733, -0.3742268979549408, 0.10053329914808273, 0.010302318260073662, -0.09632761776447296,
    0.04391203075647354, -0.07266394048929214, -0.25390687584877014, 0.13527655601501465, 0.13518305122852325, -0.05944233015179634, 0.002614468103274703, 0.2979232370853424,
    0.06815678626298904, 0.00270937941968441, 0.1778852790594101, -0.07322034239768982, -0.3300485908985138, 0.09182696044445038, -0.12665441632270813, 0.0061047994531691074,
    0.1285926103591919, 0.007177140563726425, -0.08820096403360367, -0.13671723008155823, 0.06417502462863922, -0.0016982890665531158, 0.09039197117090225, 0.15060199797153473,
    0.13244105875492096, -0.14596310257911682, -0.017269978299736977, 0.057660531252622604, 0.080288365483284, -0.11574909090995789, 0.23018725216388702, 0.05271037667989731,
    0.043268073350191116, -0.09123269468545914, 0.1559629738330841, 0.022784527391195297, 0.06578387320041656, -0.14523345232009888, -0.1245381310582161, 0.04341128468513489,
    -0.2323777973651886, -0.0495927557349205, -0.03049527108669281, -0.004431215114891529, -0.07734184712171555, -0.050651997327804565, -0.1973976045846939, -0.015611770562827587,
    -0.09929698705673218, -0.045570556074380875, -0.06428143382072449, 0.12362959235906601, 0.03736978396773338, -0.06608977168798447, -0.023523563519120216, 0.09403440356254578,
    0.08282994478940964, -0.09020557254552841, 0.06187249720096588, 0.022762807086110115, -0.08060355484485626, 0.0921599417924881, -0.10785024613142014, -0.06903612613677979,
    0.08738775551319122, 0.21531017124652863, 0.1551610231399536, 0.23585619032382965, -0.09995555132627487, 0.05887527018785477, 0.0010078147752210498, 0.02483515813946724,
    -0.003759833052754402, 0.010547490790486336, 0.028729557991027832, 0.05817870423197746, -0.2946571409702301, -0.17933695018291473, -0.03103826940059662, 0.09097607433795929,
    -0.07258599251508713, -0.15936177968978882, 0.003857026342302561, 0.19719918072223663, -0.008587117306888103, -0.010021351277828217, -0.04747775197029114, -0.06056026369333267,
    0.18276286125183105, 0.0148851303383708, 0.13603170216083527, -0.07366713881492615, 0.045528143644332886, 0.09116397798061371, -0.14952653646469116, 0.032393284142017365,
    0.3266581892967224, -0.054714612662792206, 0.033290669322013855, 0.4110371470451355, 0.09879252314567566, -0.1665201038122177, -0.018824927508831024, -0.0877557322382927,
    0.13995175063610077, -0.18065907061100006, -0.056685920804739, 0.11904694139957428, -0.12757326662540436, 0.2536724805831909, 0.003596796188503504, -0.16551701724529266,
    -0.10631082952022552, -0.09146705269813538, -0.09434938430786133, 0.179507777094841, -0.07660160958766937, 0.025275802239775658, 0.039345309138298035, -0.1946144551038742,
    0.0002976177493110299, 0.02171340584754944, 0.18250802159309387, -0.06372352689504623, 0.36976832151412964, 0.07955439388751984, 0.014799142256379128, -0.014962051063776016,
    0.12853069603443146, 0.12733398377895355, -0.11468508839607239, -0.011626641266047955, 0.01665457710623741, 0.05181025341153145, -0.09753908962011337, 0.18110892176628113,
    0.05009510740637779, 0.07625705748796463, 0.08976058661937714, -0.023258639499545097, -0.22071577608585358, 0.16441935300827026, 0.18339510262012482, 0.09128253161907196,
    0.10790242999792099, 0.08614370226860046, -0.028622586280107498, 0.1539277732372284, 0.010858721099793911, 0.06843100488185883, 0.010459879413247108, -0.057976678013801575,
    0.13860531151294708, -0.0895376056432724, -0.12678618729114532, -0.04014945775270462, 0.19375398755073547, -0.007125880569219589, -0.3994179368019104, 0.2562124729156494,
    -0.09912804514169693, 0.10782530158758163, 0.13523252308368683, 0.02873549610376358, 0.06130803003907204, -0.07783377915620804, 0.15585778653621674, -0.07972560077905655,
    -0.20132707059383392, -0.010852614417672157, -0.052310992032289505, 0.010437527671456337, 0.05944059044122696, 0.09827321767807007, -0.07957633584737778, 0.3439311683177948,
    0.0295045655220747, -0.009578737430274487, 0.08711152523756027, -0.2194482684135437, 0.015297511592507362, 0.009051114320755005, -0.1569720357656479, -0.023209281265735626,
    0.02642548270523548, -0.11559014022350311, 0.07269895821809769, -0.171707883477211, 0.05597613379359245, -0.07765859365463257, 0.026177501305937767, 0.02267851121723652,
    -0.20760342478752136, 0.04839523136615753, 0.1537862867116928, 0.05142286792397499, -0.24074767529964447, 0.13685329258441925, 0.05238308385014534, -0.02468438632786274,
    0.060649216175079346, 0.027337243780493736, -0.0399920791387558, -0.10596802085638046, -0.1686498522758484, -0.08367065340280533, -0.07091030478477478, 0.13993681967258453,
    0.07728935778141022, -0.0523233562707901, -0.036615122109651566, -0.1447296142578125, 0.018437018617987633, 0.11915182322263718, 0.11754725873470306, 0.028507985174655914,
    -0.18286237120628357, 0.034913282841444016, 0.12390074133872986, 0.10277172178030014, 0.053314998745918274, 0.006123230792582035, 0.07593429833650589, 0.03865750506520271,
    -0.1174597293138504, -0.04619063809514046, -0.007955456152558327, -0.32775771617889404, -0.06690844893455505, 0.1726679652929306, -0.2625216841697693, -0.03977363556623459,
    -0.13459616899490356, 0.020301755517721176, 0.1667543649673462, -0.08214882761240005, -0.26404422521591187, 0.11111955344676971, 0.24476853013038635, 0.17834684252738953,
    -0.07832366228103638, 0.012029347009956837, -0.11362797021865845, -0.0035905116237699986, 0.06001729145646095, 0.10784692317247391, 0.0916450023651123, 0.11302753537893295,
    -0.13885179162025452, 0.004611477721482515, -0.20716214179992676, 0.03067506104707718, -0.3322007954120636, 0.026765793561935425, -0.18931683897972107, 0.08296877145767212,
    -0.1330072581768036, -0.07120155543088913, 0.059372760355472565, 0.07636593282222748, -0.12982149422168732, -0.047116369009017944, 0.05721282586455345, -0.0405784510076046,
    0.0216459222137928, 0.09523163735866547, -0.01236920990049839, -0.0805836021900177, -0.07274142652750015, 0.050133116543293, -0.08979078382253647, -0.06595340371131897,
    0.2542318105697632, 0.15858738124370575, 0.1315421760082245, -0.1760418713092804, -0.15728409588336945, -0.0562165230512619, -0.0662619024515152, 0.05879295989871025,
    0.04676252603530884, -0.11580619215965271, -0.032831013202667236, -0.025221848860383034, -0.15984682738780975, 0.32692256569862366, 0.40809422731399536, -0.20064787566661835,
    0.03247861936688423, -0.05801843851804733, 0.08039267361164093, 0.020222028717398643, -0.10116324573755264, 0.03324933722615242, 0.025376416742801666, -0.11619720607995987,
    -0.11226372420787811, 0.06343574821949005, -0.12555554509162903, -0.016542352735996246, -0.030248738825321198, -0.04563738405704498, 0.1845587193965912, 0.12412344664335251,
    0.024706576019525528, 0.013869201764464378, 0.06004474312067032, -0.20330606400966644, 0.0009221800719387829, -0.007225885521620512, -0.1374712735414505, 0.032266099005937576,
    -0.03278331458568573, -0.0473024956882, -0.009225188754498959, -0.2838991582393646, 0.12864820659160614, 0.023963280022144318, 0.009243147447705269, 0.08636129647493362,
    -0.177391916513443, -0.14572098851203918, -0.025141457095742226, -0.07997342199087143, 0.4338056743144989, 0.2703486382961273, -0.16508804261684418, 0.052458036690950394,
    -0.050421811640262604, -0.1787649393081665, -0.008502552285790443, 0.11148913949728012, 0.13528692722320557, -0.22665022313594818, 0.024891164153814316, 0.005051423329859972,
    0.006386241409927607, 0.3033412992954254, 0.06729546189308167, 0.13543526828289032, 0.047572288662195206, 0.06793547421693802, 0.15310408174991608, 0.16345064342021942,
    0.08787261694669724, -0.02249196730554104, -0.19476114213466644, -0.1317114681005478, 0.029627086594700813, -0.045631520450115204, 0.2819872796535492, -0.09244073182344437,
    0.05646570771932602, -0.1760491579771042, -0.00949487742036581, -0.06425192952156067, -0.26778554916381836, -0.07446517050266266, -0.15522530674934387, -0.05903526023030281,
    0.16791480779647827, 0.08256693184375763, -0.16935625672340393, -0.210408553481102, 0.015323451720178127, 0.2681399881839752, 0.07534363120794296, 0.128498375415802,
    -0.05571385473012924, 0.0444771833717823, -0.0736718624830246, -0.01937231607735157, -0.11825231462717056, 0.05675549432635307, 0.08220021426677704, 0.038144003599882126,
    0.023317059502005577, -0.028493566438555717, -0.03123517520725727, 0.019509373232722282, 0.3543640375137329, -0.19575078785419464, -0.26400190591812134, -0.05447060614824295,
    -0.2555435299873352, -0.0764438733458519, 0.08292888849973679, -0.07569429278373718, -0.011313491500914097, -0.010619385167956352, 0.13833440840244293, 0.12258898466825485,
    -0.03171328827738762, -0.2913888096809387, 0.07989811897277832, -0.09334904700517654, 0.24361033737659454, 0.06391005963087082, -0.008924364112317562, -0.01777891255915165,
    -0.07689681649208069, 0.0466955304145813, -0.1055760532617569, 0.22390781342983246, 0.07961852103471756, 0.023157356306910515, -0.055123355239629745, 0.03679024800658226,
    0.0790276899933815, -0.19756987690925598, 0.16157497465610504, 0.07442447543144226, -0.02627446874976158, -0.008454551920294762, -0.14434248208999634, -0.20380784571170807,
    -0.032118599861860275, -0.01469186507165432, 0.060343172401189804, 0.012479919008910656, 0.07307557016611099, -0.06771796941757202, -0.03596637770533562, -0.2047816514968872,
    -0.14623430371284485, -0.15882757306098938, -0.09271817654371262, -0.04419146105647087, 0.1837172508239746, -0.061085063964128494, 0.06506715714931488, -0.23723307251930237,
    -0.34715166687965393, 0.020929384976625443, -0.04256666824221611, 0.04457695037126541, -0.0030178213492035866, 0.02261381968855858, 0.15758556127548218, 0.011904114857316017,
    -0.19120588898658752, -0.017641445621848106, -0.0343514159321785, -0.23163363337516785, -0.11786788702011108, -0.26383447647094727, -0.11411596089601517, 0.0027149072848260403,
    -0.07452978938817978, 0.12316584587097168, -0.038123831152915955, -0.005589867942035198, -0.3762495219707489, 0.030720051378011703, -0.005061272531747818, -0.09068956226110458,
    0.11802317947149277, -0.004254972096532583, 0.11563707888126373, -0.11710844188928604, -0.16747111082077026, -0.17470099031925201, 0.18716709315776825, 0.1931246817111969,
    -0.0701298862695694, 0.1005367562174797, 0.07513153553009033, -0.14429932832717896, 0.05506923049688339, 0.1507188379764557, 0.030349386855959892, 0.13133621215820312,
    0.07585480809211731, -0.025421297177672386, -0.03671795874834061, -0.12109016627073288, 0.009464390575885773, 0.05241992697119713, 0.04175790026783943, 0.14689965546131134,
    -0.16118867695331573, 0.018826957792043686, -0.021827958524227142, 0.3178873360157013, -0.022620167583227158, 0.017391929402947426, 0.14851383864879608, 0.22276940941810608,
    0.20554101467132568, -0.17864306271076202, -0.0171008612960577, -0.07128266990184784, -0.013650244101881981, 0.10051088780164719, -0.13359923660755157, 0.10637268424034119,
    -0.061310674995183945, -0.006079078186303377, -0.0016228397144004703, -0.16393762826919556, -0.1532880812883377, -0.0750218853354454, -0.056449875235557556, 0.14164908230304718,
    -0.08015375584363937, 0.21816715598106384, -0.10577952861785889, -0.06335841119289398, -0.30486658215522766, 0.09874331951141357, 0.10333886742591858, 0.07138915359973907,
    0.048545993864536285, -0.006187473889440298, -0.18246839940547943, 0.24082577228546143, 0.10273087024688721, -0.02162940613925457, 0.17416714131832123, -0.1973438560962677,
    0.006978717632591724, -0.1457514762878418, -0.05648396909236908, -0.10535325109958649, 0.005104590207338333, 0.31016209721565247, 0.03732304647564888, 0.006290595978498459,
    -0.03951631113886833, -0.07635632902383804, -0.23533713817596436, -0.2075909525156021, -0.07918883860111237, 0.046455249190330505, 0.09333992004394531, 0.2037416249513626,
    -0.13286137580871582, -0.04097333550453186, -0.11620507389307022, -0.08201778680086136, 0.0917125940322876, -0.09267400950193405, -0.11825654655694962, 0.4489786624908447,
    -0.0824950560927391, 0.006507942918688059, 0.06428247690200806, 0.009590174071490765, 0.10856680572032928, -0.1789742261171341, -0.019638005644083023, -0.06733361631631851,
    -0.0461241751909256, 0.22716161608695984, 0.10918013751506805, 0.059663932770490646, -0.0027370713651180267, 0.052972931414842606, -0.13776862621307373, 0.059283219277858734,
    -0.13281981647014618, -0.0203640628606081, -0.09333617985248566, -0.1421131044626236, 0.018599065020680428, 0.052744001150131226, 0.1891859769821167, -0.019309844821691513,
    0.018662739545106888, -0.09098147600889206, 0.0008836674387566745, -0.2810252606868744, 0.056849561631679535, -0.239887073636055, -0.005123496986925602, -0.07589266449213028,
    0.16876977682113647, 0.0984281599521637, -0.13925395905971527, -0.09803102910518646, 0.22670045495033264, 0.039743319153785706, 0.05958877131342888, -0.15239500999450684,
    0.13003690540790558, -0.09235519915819168, -0.18382366001605988, 0.18047507107257843, -0.17224721610546112, 0.07530517131090164, 0.13311076164245605, 0.27095428109169006,
    -0.03935549408197403, -0.1176428496837616, -0.02199001982808113, 0.14650046825408936, 0.031234852969646454, -0.20510746538639069, -0.00596614321693778, -0.10288258641958237,
    -0.13947725296020508, 0.046158310025930405, 0.15334734320640564, -0.06838466972112656, 0.1181596964597702, 0.0608927384018898, 0.02724921517074108, -0.09675884246826172,
    -0.1280873864889145, -0.10262879729270935, 0.02438351884484291, -0.24533703923225403, 0.018230045214295387, -0.07542998343706131, 0.2140987366437912, 0.1187378540635109,
    0.08585792034864426, 0.08429532498121262, 0.1964605450630188, 0.01993572898209095, -0.05341416969895363, -0.09818495064973831, -0.003251779591664672, 0.036171600222587585,
    -0.21431316435337067, -0.008603318594396114, -0.0841606929898262, 0.24532948434352875, -0.09907061606645584, 0.07653994113206863, -0.03759748861193657, 0.17851635813713074,
    -0.005854723043739796, -0.21708323061466217, 0.008928009308874607, -0.007081580348312855, 0.24884888529777527, 0.05260574817657471, -0.04816802963614464, -0.042104028165340424,
    0.15818758308887482, 0.10005508363246918, -0.23254571855068207, 0.2360064834356308, -0.16363269090652466, -3.449676569289295e-06, -0.0047247689217329025, -0.07582774013280869,
    -0.06523328274488449, -0.13376250863075256, 0.3643088936805725, 0.06321955472230911, -0.02811914123594761, -0.09806473553180695, 0.1263210028409958, 0.09091194719076157,
    -0.07507292926311493, 0.03840786963701248, -0.03210265561938286, 0.1528150886297226, -0.18655915558338165, -0.011256189085543156, 0.03421719744801521, 0.12216794490814209,
    0.022115111351013184, -0.09826751798391342, 0.15725193917751312, 0.05107221007347107, 0.2998115122318268, 0.1308801770210266, 0.1292375773191452, 0.09181445837020874,
    -0.0010063331574201584, -0.002598794875666499, 0.06698537617921829, -0.0036290092393755913, 0.08121423423290253, -0.052615318447351456, 0.12280721217393875, 0.10907327383756638,
    0.10500636696815491, -0.20592154562473297, -0.08996081352233887, 0.007046013604849577, -0.15502047538757324, 0.018758347257971764, -0.05671170726418495, 0.2694070637226105,
    0.12922371923923492, 0.017640184611082077, -0.04532211646437645, -0.1015540137887001, -0.01696464978158474, -0.04834834858775139, 0.05369619280099869, 0.010399583727121353,
    0.13283976912498474, 0.030921773985028267, 0.01882847584784031, -0.29699668288230896, 0.09029063582420349, 0.21289272606372833, 0.04086527228355408, 0.0244076419621706,
    0.20800213515758514, 0.03448958694934845, -0.07118769735097885, -0.19199122488498688, -0.12234771251678467, 0.022983189672231674, -0.21727266907691956, 0.0007906422251835465,
    0.029131101444363594, -0.17195601761341095, 0.2779930830001831, -0.09740150719881058, 0.16412653028964996, 0.26353272795677185, -0.06367563456296921, 0.0559806153178215,
    -0.007575181312859058, 0.04768240824341774, -0.0465913787484169, -0.07255081832408905, 0.00909777358174324, -0.009976170025765896, -0.018186379224061966, 0.11506427824497223,
    0.04197786748409271, -0.021022595465183258, -0.061931345611810684, -0.23209895193576813, 0.040498241782188416, 0.0507156066596508, 0.051669150590896606, -0.13538604974746704,
    0.040845971554517746, 0.03645766153931618, 0.03836016729474068, 0.01222346443682909, 0.033129386603832245, -0.0009247438283637166, -0.021342292428016663, 0.16861243546009064,
    0.10154008120298386, 0.11682897806167603, 0.017400765791535378, 0.12883368134498596, -0.024000538513064384, -0.17746637761592865, -0.1020449623465538, -0.042489342391490936,
    -0.011559764854609966, -0.025340111926198006, -0.021766608580946922, 0.2070373296737671, -0.08004820346832275, 0.0662652924656868, -0.11764328181743622, 0.37254756689071655,
    -0.05113871023058891, -0.06767984479665756, -0.00035121862310916185, 0.07963632792234421, -0.18056930601596832, -0.0467304065823555, -0.03637181594967842, -0.0016042987117543817,
    -0.08381732553243637, -0.14025379717350006, 0.13703154027462006, 0.05511933192610741, 0.24284572899341583, 0.0078113265335559845, -0.003233942436054349, -0.20579899847507477,
    -0.13157354295253754, -0.13628676533699036, 0.09591207653284073, -0.0374983586370945, -0.1626121550798416, 0.05409221723675728, -0.04307372123003006, -0.08410239219665527,
    -0.10257067531347275, 0.0022532837465405464, 0.16878153383731842, -0.07314964383840561, -0.06007301062345505, 0.01737978123128414, -0.17905203998088837, -0.03185778483748436,
    -0.11141803860664368, -0.10122127085924149, -0.049397144466638565, 0.014296570792794228, 0.2769399881362915, -0.048489321023225784, 0.15210303664207458, -0.27514156699180603,
    0.052043382078409195, 0.029792889952659607, 0.04636799544095993, -0.1109660416841507, -0.004085574299097061, -0.14342880249023438, -0.06527206301689148, 0.24115748703479767,
    0.09603268653154373, 0.21234068274497986, -0.19253844022750854, -0.05158695578575134, 0.019435087218880653, -0.0767088308930397, 0.07374754548072815, -0.058486197143793106,
    0.1176222413778305, -0.06279455125331879, 0.05643607676029205, -0.2377931922674179, -0.003623188706114888, 0.05479588359594345, 0.019818266853690147, 0.05115623027086258,
    -0.18728195130825043, -0.07454103976488113, 0.021091025322675705, -0.2288305163383484, -0.05580746755003929, -0.15144555270671844, -0.06416898220777512, 0.13218599557876587,
    -0.16763845086097717, 0.032897911965847015, 0.21994321048259735, -0.1645222157239914, -0.05319111421704292, -0.12817052006721497, 0.18800479173660278, 0.14365892112255096,
    0.10073276609182358, 0.0439993180334568, 0.07435049116611481, 0.022476380690932274, 0.17584866285324097, 0.056203946471214294, -0.08829042315483093, 0.11111912131309509,
    0.18134377896785736, 0.07415895909070969, 0.013532519340515137, 0.03152359277009964, 0.12910610437393188, -0.0016227992018684745, 0.1536676436662674, 0.18402600288391113,
    0.07132456451654434, -0.0071497452445328236, -0.131815567612648, 0.08859733492136002, -0.0077508543618023396, -0.020918752998113632, -0.04292316734790802, 0.19305360317230225,
    0.11608697474002838, -0.04459671303629875, -0.02405139058828354, 0.19236046075820923, -0.23676198720932007, 0.30686619877815247, -0.19385358691215515, 0.012993205338716507,
    -0.25276145339012146, -0.30481070280075073, 0.08972005546092987, 0.0927281305193901, 0.18163691461086273, -0.19135130941867828, -0.10230331867933273, -0.09718631953001022,
    0.20823374390602112, -0.001263498212210834, 0.21612465381622314, -0.1452884078025818, 0.1884295493364334, -0.07833744585514069, -0.1871415376663208, 0.12035878002643585,
    -0.019659120589494705, -0.03904729336500168, -0.05278117582201958, -0.01021976675838232, 0.12374704331159592, -0.07474054396152496, 0.11154621839523315, 0.03206818923354149,
    0.04534665867686272, 0.009785756468772888, -0.0474475659430027, 0.0360381156206131, 0.07914558053016663, -0.004085837863385677, 0.05253966152667999, -0.010292884893715382,
    0.06723912805318832, 0.12132977694272995, -0.30811789631843567, -0.07513315975666046, -0.018095772713422775, 0.11212676018476486, -0.2450597882270813, -0.08909103274345398,
    -0.16381770372390747, -0.14945843815803528, 0.016430187970399857, 0.027900101616978645, 0.16027171909809113, -0.017011821269989014, -0.0705113410949707, -0.09049749374389648,
    -0.23510542511940002, 0.1331213116645813, -0.001436714781448245, -0.1284123957157135, -0.1027432531118393, 0.03496751934289932, -0.356253981590271, 0.18661655485630035,
    -0.05110383778810501, -0.06468046456575394, 0.024018611758947372, -0.11309412121772766, -0.07453349977731705, -0.00874401070177555, 0.004067190922796726, 0.0834360346198082,
    -0.046660106629133224, -0.20835809409618378, -0.23115487396717072, 0.013785255141556263, 0.006555391941219568, 0.16917303204536438, 0.05818476527929306, 0.32683858275413513,
    -0.00026829299167729914, 0.008634420111775398, 0.08215421438217163, 0.14531965553760529, 0.03882822394371033, -0.050074148923158646, 0.058646492660045624, -0.08593202382326126,
    -0.18562215566635132, -0.005510810296982527, 0.04878227785229683, -0.313330739736557, -0.09484978020191193, 0.12827642261981964, -0.018145786598324776, 0.0602533221244812,
    0.04523315280675888, -0.18779994547367096, 0.16240572929382324, 0.06729652732610703, 0.33755624294281006, 0.025242436677217484, -0.470084011554718, -0.08813831210136414,
    -0.036623403429985046, 0.07495720684528351, -0.01582205668091774, 0.014823181554675102, 0.12288198620080948, -0.3649732172489166, -0.1298261135816574, 0.153870090842247,
    -0.17036709189414978, 0.09536705911159515, -0.05716458335518837, -0.029495129361748695, 0.11216040700674057, -0.06698081642389297, 0.030278842896223068, 0.0026609250344336033,
    -0.11295785754919052, -0.030063137412071228, 0.12044577300548553, 0.07373370230197906, 0.20300164818763733, -0.022281933575868607, 0.2805922329425812, -0.11624469608068466,
    0.08314401656389236, -0.022124135866761208, -0.0003964252828154713, -0.2613676190376282, -0.009601529687643051, -0.2985105812549591, -0.048300933092832565, 0.22195756435394287,
    0.048023223876953125, -0.08967608213424683, -0.03443540260195732, 0.15767094492912292, -0.25335729122161865, -0.1389153152704239, 0.008228893391788006, -0.16768871247768402,
    -0.2552773356437683, 0.013543975539505482, 0.1844254434108734, -0.04703906551003456, 0.04024412855505943, -0.022137999534606934, -0.0007186835282482207, 0.018620120361447334,
    -0.10074220597743988, 0.016206128522753716, 0.09468996524810791, -0.012411611154675484, -0.10597629845142365, 0.04865444451570511, 0.17617040872573853, -0.008006012998521328,
    0.06708092987537384, -0.11036296933889389, -0.3266112804412842, -0.06543582677841187, -0.14764559268951416, 0.016784824430942535, 0.10634773224592209, 0.11917004734277725,
    0.11606696993112564, -0.15645748376846313, -0.15915745496749878, -0.06682517379522324, 0.04279353469610214, -0.14802570641040802, 0.09881158918142319, 0.07474539428949356,
    0.08559419214725494, -0.1306377649307251, -0.15040603280067444, 0.024825986474752426, -0.11963669210672379, -0.03661995008587837, 0.20792976021766663, -0.0706363245844841,
    -0.11462587118148804, 0.07363501936197281, 0.012611315585672855, 0.11730638891458511, 0.026623249053955078, 0.08301965892314911, 0.28077736496925354, -0.2559206485748291,
    0.038499876856803894, 0.050287626683712006, 0.06397370249032974, 0.12476587295532227, 0.09593166410923004, 0.026228195056319237, -0.08280990272760391, 0.08456476032733917,
    0.0800856351852417, 0.14961111545562744, -0.10186603665351868, 0.06360657513141632, -0.051440346986055374, -0.14430800080299377, -0.10630639642477036, 0.14968866109848022,
    -0.12724602222442627, -0.03537316992878914, -0.14216336607933044, -0.15182630717754364, 0.022998357191681862, 0.04494202509522438, 0.24539612233638763, 0.167134627699852,
    0.018034858629107475, -0.003904156619682908, -0.04319639503955841, 0.12491825968027115, -0.013219627551734447, 0.07569371908903122, -0.152510404586792, -0.1100347638130188,
    -0.005413179285824299, 0.0033104082103818655, 0.004921009764075279, 0.10070837289094925, -0.38445305824279785, -0.22527450323104858, 0.16144323348999023, 0.06713224202394485,
    -0.047295600175857544, 0.07684029638767242, 0.5526760220527649, -0.05713757127523422, -0.1688472330570221, 0.06790150701999664, -0.07779546082019806, -0.165760338306427,
    -0.0728069469332695, -0.06926967948675156, 0.07334038615226746, 0.030485691502690315, -0.009914427995681763, 0.0778791755437851, -0.08912050724029541, -0.11373944580554962,
    -0.009898176416754723, 0.07203830778598785, -0.11276479065418243, -0.00185633753426373, 0.15528756380081177, 0.10518663376569748, -0.11143023520708084, 0.05231389030814171,
    -0.11622582376003265, -0.24962574243545532, 0.024886466562747955, 0.1614452302455902, -0.024302108213305473, 0.1112697571516037, 0.16210190951824188, 0.2590510845184326,
    -0.050552185624837875, 0.11500480771064758, -0.07652158290147781, 0.08963776379823685, -0.04406869783997536, 0.12499596923589706, -0.2839652895927429, 0.32312074303627014,
    -0.04805007576942444, 0.0022802238818258047, 0.10957540571689606, 0.0790785551071167, -0.11599651724100113, 0.08197147399187088, 0.09242997318506241, 0.125822514295578,
    -0.03733134642243385, -0.09338932484388351, 0.02123759500682354, -0.03365996852517128, 0.0131303109228611, -0.016285214573144913, -0.052121590822935104, -0.030414169654250145,
    -0.19015392661094666, 0.0511229932308197, 0.17056187987327576, 0.02263450436294079, -0.06144869327545166, -0.0021070665679872036, -0.08470012992620468, -0.010448651388287544,
    0.03739749267697334, 0.017580289393663406, 0.05163536220788956, 0.10001443326473236, 0.0624082051217556, 0.11993053555488586, 0.09736371040344238, -0.04130948334932327,
    0.000998676405288279, -0.058128368109464645, -0.11788829416036606, 0.028296926990151405, 0.014475317671895027, 0.030657287687063217, 0.01129640731960535, -0.06927713751792908,
    -0.03161396086215973, 0.1070871353149414, -0.1370246559381485, -0.03220263496041298, -0.04387107118964195, 0.013930173590779305, 0.18735074996948242, 0.0010251201456412673,
    0.05518964305520058, 0.012368372641503811, 0.04044646769762039, 0.05938480421900749, 0.07159578800201416, 0.09018224477767944, -0.02032218687236309, 0.09082192182540894,
    0.01631702110171318, -0.0022238644305616617, -0.034547656774520874, -0.010050607845187187, 0.09290975332260132, 0.03507591411471367, -0.18892782926559448, -0.10768723487854004,
    -0.010133542120456696, -0.021229375153779984, 0.054625265300273895, -0.03511374071240425, -0.0009426789474673569, 0.06751900911331177, -0.04086662456393242, 0.008615514263510704,
    0.0027617020532488823, 0.08217277377843857, -0.09923118352890015, -0.04489082470536232, 0.010477645322680473, 0.05742691084742546, 0.0345623604953289, -0.06838297098875046,
    -0.009987764060497284, 0.016689328476786613, 0.05290617048740387, 0.027007101103663445, 0.061785608530044556, -0.04568072780966759, -0.05904761701822281, 0.09062869846820831,
    -0.052961159497499466, 0.14090681076049805, 0.02637593075633049, 0.05538157746195793, -0.0017294357530772686, 0.026091095060110092, 0.04022661969065666, 0.11312214285135269,
    -0.14232806861400604, -0.03631965443491936, -0.2241785228252411, -0.01742519810795784, -0.13803675770759583, 0.019967133179306984, 0.09864675998687744, -0.060203343629837036,
    0.03653276339173317, -0.03128708526492119, 0.11860048770904541, 0.04930468276143074, -0.13999652862548828, 0.05908132717013359, 0.04990251734852791, 0.02600654773414135,
    -0.049885597079992294, -0.0835876315832138, -0.08347305655479431, -0.0264896247535944, -0.06824636459350586, -0.06799729913473129, -0.028748810291290283, -0.13166168332099915,
    0.10832712799310684, 0.0431094691157341, -0.06975864619016647, 0.11557278037071228, -0.10515778511762619, -0.014496170915663242, -0.01362286414951086, -0.0009620374767109752,
    0.05453408136963844, 0.035106491297483444, 0.003916129004210234, -0.05164065212011337, 0.03388392925262451, 0.1818048506975174, 0.035733431577682495, 0.1334121972322464,
    0.13340570032596588, -0.06455570459365845, 0.014352459460496902, -0.02486129105091095, -0.013621754013001919, 0.04861696809530258, -0.06179523095488548, 0.0592803992331028,
    -0.08201345056295395, -0.04734848439693451, 0.11540551483631134, 0.09465690702199936, 0.01956942118704319, 0.0005245418287813663, 0.009983763098716736, 0.023889195173978806,
    0.021245518699288368, -0.049388591200113297, 0.14638809859752655, -0.00014427384303417057, 0.07530777156352997, -0.1646927148103714, -0.04711221531033516, 0.05675208568572998,
    0.026700584217905998, -0.06566950678825378, 0.051818910986185074, -0.035921577364206314, -0.035103004425764084, 0.05186497047543526, 0.0830921083688736, -0.02806268446147442,
    -0.1263187825679779, 0.09795738756656647, -0.17858204245567322, -0.042046863585710526, -0.05022834241390228, -0.055659592151641846, -0.1374603807926178, 0.09119682013988495,
    -0.05921380966901779, 0.010951727628707886, 0.10319183766841888, 0.05557839199900627, 0.05142641067504883, -0.07983461022377014, 0.09705355763435364, 0.022444721311330795,
    0.03213811293244362, 0.027125751599669456, 0.04131059721112251, -0.04434078559279442, -0.08943715691566467, -0.026801828294992447, -0.020648103207349777, 0.032982371747493744,
    0.005912192165851593, -0.021581478416919708, 0.22345905005931854, 0.00712477695196867, -0.007903466001152992, 0.1050107479095459, -0.04326235130429268, -0.03325389325618744,
    -0.018358737230300903, -0.00841300468891859, -0.15368585288524628, -0.05798344314098358, -0.01187988929450512, -0.019746163859963417, -0.07163813710212708, -0.1843312829732895,
    -0.0369885079562664, -0.00589135242626071, -0.02948487550020218, 0.03751630336046219, -0.018124127760529518, -0.011869700625538826, 0.024488721042871475, 0.01702195405960083,
    -0.0067087747156620026, 0.12525026500225067, 0.016285322606563568, -0.127210333943367, -0.024146543815732002, -0.055608175694942474, -0.03385036811232567, 0.07522483915090561,
    -0.07735896110534668, 0.05075521767139435, -0.22101393342018127, 0.04182878136634827, -0.10583819448947906, -0.11143813282251358, 0.13544423878192902, -0.038077834993600845,
    -0.003570848610252142, 0.06248719245195389, -0.15450187027454376, -0.018418224528431892, -0.15566124022006989, 0.08787396550178528, -0.04184659197926521, -0.01944624073803425,
    0.08931390941143036, -0.04273664578795433, -0.02273675985634327, -0.013855005614459515, -0.05998929217457771, 0.0824584886431694, 0.06779773533344269, -0.10356848686933517,
    0.10320987552404404, 0.037264615297317505, -0.07873552292585373, 0.10560004413127899, -0.0577823631465435, 0.08323956280946732, 0.09634726494550705, 0.06199212372303009,
    0.11213099211454391, -0.05932065472006798, 0.003536392468959093, -0.19467300176620483, -0.06935656815767288, 0.14417293667793274, -0.082401804625988, -0.056326091289520264,
    -0.014049139805138111, 0.0640837550163269, 0.05252154543995857, -0.024403829127550125, 0.0194141436368227, -0.018144628033041954, 0.027983512729406357, -0.019458727911114693,
    0.10364039242267609, -0.07538703083992004, -0.02181345969438553, 0.009459302760660648, -0.02962127886712551, 0.014098546467721462, 0.029686959460377693, 0.13298673927783966,
    -0.036787569522857666, -0.03500758484005928, 0.13416516780853271, 0.018389588221907616, -0.009429390542209148, -0.22568586468696594, -0.05660177394747734, 0.028133399784564972,
    0.0748642086982727, -0.009693847969174385, 0.11313749849796295, 0.008663160726428032, -0.16676247119903564, -0.003907191567122936, 0.02670229785144329, -0.04986235126852989,
    -0.1223365068435669, 0.038490306586027145, 0.01652645319700241, 0.06257376074790955, -0.07282190769910812, 0.001879671006463468, 0.01965372823178768, -0.033745139837265015,
    -0.09682128578424454, -0.004037054721266031, 0.08168096840381622, 0.01230929046869278, 0.09956302493810654, -0.05230692774057388, 0.057631947100162506, -0.051688726991415024,
    -0.03706628084182739, -0.015385597944259644, -0.08063815534114838, 0.019942687824368477, -0.10542449355125427, 0.007034176494926214, 0.13469739258289337, 0.11912720650434494,
    0.0011659153969958425, -0.041116926819086075, 0.2030307799577713, -0.05226410552859306, -0.01223270408809185, 0.04781600832939148, 0.007917256094515324, 0.011926828883588314,
    0.03094538301229477, 0.06680076569318771, -0.059505756944417953, 0.008201174437999725, -0.042008716613054276, 0.06688648462295532, -0.019372355192899704, -0.19424547255039215,
    0.03476282209157944, 0.04216861352324486, 0.005211287178099155, -0.053025778383016586, -0.0380660705268383, -0.04613572731614113, 0.039648983627557755, -0.05385727435350418,
    -0.02545606903731823, 0.12869873642921448, -0.04670349881052971, 0.0647454559803009, -0.05330827459692955, -0.047823384404182434, 0.05488782748579979, 0.09349723905324936,
    0.14545060694217682, 0.07119476795196533, 0.2003307044506073, -0.03935902565717697, 0.0719171017408371, -0.12607844173908234, 0.038672205060720444, 0.10201426595449448,
    -0.017154213041067123, 0.024000411853194237, 0.010072306729853153, 0.036894217133522034, -0.01618656888604164, 0.1519032120704651, -0.00302679929882288, 0.012800632044672966,
    -0.002724246820434928, 0.09636886417865753, 0.005835572257637978, 0.014626821503043175, -0.04336105287075043, -0.03986576944589615, 0.11167947947978973, -0.05357799679040909,
    0.04966890066862106, -0.08540823310613632, -0.0027246144600212574, -0.06687966734170914, -0.008470261469483376, -0.06884679943323135, 0.10384082049131393, -0.005778579041361809,
    0.015837112441658974, -0.02421349100768566, 0.036520931869745255, -0.015048923902213573, -0.0797693133354187, 0.1272871196269989, -0.01119327824562788, -0.02488531731069088,
    -0.006681722588837147, 0.01608429290354252, -0.038737498223781586, 0.028876833617687225, -0.018008599057793617, -0.13014920055866241, 0.050995394587516785, -0.021458076313138008,
    0.08220314234495163, 0.015076338313519955, 0.05223609879612923, -0.08893252164125443, 0.018870538100600243, -0.02449374832212925, 0.002100876532495022, 0.03181832656264305,
    0.02643391862511635, 0.08035004884004593, 0.02353658527135849, 0.06973286718130112, -0.026179127395153046, 0.17549119889736176, 0.14045844972133636, -0.020016662776470184,
    0.05696349963545799, -0.049535948783159256, -0.045280568301677704, 0.018104350194334984, -0.026235325261950493, -0.0045606475323438644, -0.05396678298711777, 0.00937630981206894,
    0.1221577376127243, 0.02680422179400921, -0.008603888563811779, -0.04560786485671997, -0.060448888689279556, 0.049324098974466324, 0.09622923284769058, -0.049845002591609955,
    0.0790405198931694, -0.0020321381743997335, 0.015522764064371586, 0.019327810034155846, 0.010299598798155785, 0.049903541803359985, -0.1194695308804512, -0.021679438650608063,
    0.03141165152192116, 0.017352204769849777, 0.021062275394797325, 0.0025976847391575575, 0.04200233146548271, 0.025544410571455956, -0.007436875719577074, -0.03003481775522232,
    0.026508651673793793, 0.004340574145317078, 0.20190837979316711, -0.09135192632675171, -0.005209148395806551, -0.008356946520507336, 0.04158201068639755, 0.001921601127833128,
    -0.13954874873161316, 0.08536426723003387, -0.01917874440550804, 0.05579488351941109, -0.0070536183193326, 0.0713287740945816, -0.13399377465248108, -0.055580366402864456,
    0.11623705178499222, -0.051414020359516144, 0.0514371320605278, -0.09393694251775742, 0.02428724803030491, -0.006832255516201258, -0.10759670287370682, -0.074940986931324,
    -0.01785634644329548, 0.16366419196128845, 0.05827055126428604, 0.058160506188869476, 0.028520911931991577, 0.10738703608512878, 0.0814206451177597, 0.04240814968943596,
    0.11821643263101578, -0.06032038852572441, 0.35785120725631714, 0.02957824245095253, 0.01226853858679533, -0.020446136593818665, 0.09288931638002396, 0.0006836102111265063,
    0.009530361741781235, -0.020618131384253502, 0.16964715719223022, -0.007607479114085436, -0.018164828419685364, 0.010675030760467052, -0.0018788942834362388, 0.0031731142662465572,
    -0.0037017345894128084, -0.008566293865442276, -0.0689607709646225, 0.000761642586439848, -0.011306247673928738, -0.05775762349367142, -0.05809937044978142, -0.04535159468650818,
    0.11066512763500214, 0.036936599761247635, 0.08514779061079025, 0.023137632757425308, 0.013880368322134018, -0.05968184769153595, -0.0012012054212391376, 0.04617486894130707,
    -0.09552482515573502, 0.044144339859485626, -0.0020024797413498163, 0.07342005521059036, 0.07568661868572235, 0.12783277034759521, 0.12226501852273941, 0.08158735930919647,
    0.039969492703676224, -0.023784000426530838, -0.06939639151096344, 0.002740219235420227, 0.015637250617146492, 0.08829489350318909, -0.03717472031712532, 0.04995407164096832,
    -0.009510071016848087, -0.07613658159971237, 0.0038258591666817665, 0.003644277574494481, -0.017163779586553574, 0.002013628836721182, -0.0009340402903035283, 0.0011091390624642372,
    0.07168630510568619, 0.09653405100107193, 0.02414902113378048, 0.04259250685572624, -0.0061703878454864025, 0.06658557057380676, -0.042641568928956985, 0.04790053516626358,
    -0.01221515703946352, -0.08113628625869751, -0.07845855504274368, -0.011645147576928139, -0.02916920930147171, 0.015099487267434597, 0.015747029334306717, 0.003197904909029603,
    0.08326712250709534, 0.0013031780254095793, -0.022726543247699738, -0.004810302518308163, -0.12844601273536682, -0.16906961798667908, -0.17282848060131073, 0.036712732166051865,
    0.05485360324382782, 0.007463659625500441, 0.0515996478497982, 0.017018893733620644, -0.058696866035461426, 0.032093584537506104, 0.014651305973529816, 1.4567461221304256e-05,
    0.0724015086889267, 0.0003203749074600637, 0.01699679344892502, -0.013706384226679802, 0.186199352145195, 0.010929041542112827, -0.15495921671390533, 0.022338977083563805,
    0.12993620336055756, -0.014638513326644897, 0.1293420046567917, 0.12340573966503143, 0.0007444028742611408, 0.017718957737088203, 0.08878819644451141, -0.020481951534748077,
    -0.03368562087416649, -0.12093719094991684, -0.019383572041988373, -0.04387349262833595, 0.0067828623577952385, -0.09571035206317902, 0.031458865851163864, -0.0020356939639896154,
    -0.0017186484765261412, -0.060072049498558044, -0.023233359679579735, -0.0009221541695296764, 0.03418701887130737, -0.08398023247718811, -0.06487210094928741, -0.09108667075634003,
    0.04775966703891754, 0.17327141761779785, 0.10834845155477524, -0.1283407211303711, 0.0585935153067112, 0.11978129297494888, -0.10862406343221664, 0.06411221623420715,
    -0.08934497088193893, -0.009932341985404491, 0.28432998061180115, -0.0002458767266944051, -0.06846121698617935, -0.007840397767722607, 0.16455960273742676, -0.056483518332242966,
    0.02124829590320587, 0.01871548220515251, -0.19641759991645813, -0.047441139817237854, -0.05545467883348465, -0.08029650896787643, -0.037364836782217026, -0.041277237236499786,
    0.06397814303636551, -0.13824379444122314, -0.018909014761447906, -0.034135039895772934, 0.018440071493387222, 0.022677520290017128, -0.004858208820223808, 0.010507636703550816,
    0.09427734464406967, 0.020657604560256004, 0.10962191224098206, -0.08566772192716599, 0.06144318729639053, 0.0826241746544838, 0.0221591517329216, 0.08791974931955338,
    -0.041455190628767014, -0.017802314832806587, -0.018264221027493477, 0.04772907868027687, -0.014749463647603989, 0.0582646019756794, 0.08505725115537643, -0.002044939436018467,
    -0.0481368750333786, -0.09300768375396729, 0.08135892450809479, 0.053361762315034866, 0.008386202156543732, 0.018845083191990852, 0.07094617187976837, -0.016679327934980392,
    0.08910930156707764, -0.12459903955459595, 0.02448934316635132, -0.01159939169883728, 0.0020688690710812807, -0.0038269071374088526, 0.03904373571276665, -0.006754065863788128,
    0.09994783997535706, 0.07814189046621323, 0.031366776674985886, -0.04366036504507065, 0.019205868244171143, -0.17414289712905884, -0.04299042001366615, -0.027765480801463127,
    -0.033644869923591614, 0.02476162649691105, 0.019528169184923172, 0.015368031337857246, -0.06720858812332153, -0.015119643881917, -0.07042687386274338, -0.059027962386608124,
    0.04930707439780235, -0.027014313265681267, 0.04634511098265648, 0.01511458121240139, -0.007489142473787069, 0.0028069973923265934, 0.07689376920461655, 0.09301775693893433,
    -0.07453862577676773, 0.0025122053921222687, 0.03827403113245964, -0.021304583176970482, 0.09609616547822952, 0.009412328712642193, -0.092330701649189, -0.08678475767374039,
    -0.01355548482388258, -0.017840338870882988, -0.022378193214535713, 0.006306760013103485, 0.08769039064645767, -0.008424920029938221, 0.029309434816241264, 0.06560394167900085,
    -0.02870774082839489, -0.011213218793272972, 0.060929324477910995, 0.054989539086818695, -0.0059727830812335014, -0.01207682117819786, -0.018446974456310272, -0.0013265818124637008,
    0.1467144638299942, -0.10070233047008514, 0.01521237101405859, 0.006246509496122599, -0.03884654492139816, -0.08798103779554367, 0.008583856746554375, 0.03855051100254059,
    -0.09928878396749496, 0.0642021968960762, -0.040088675916194916, 0.03325095400214195, -0.02372177690267563, -0.055587947368621826, -0.07607768476009369, -0.007680666167289019,
    0.10103942453861237, 0.08218766748905182, -0.05828872695565224, 0.03304406255483627, 0.1690150946378708, -0.0600043423473835, -0.022038210183382034, 0.06568115949630737,
    -0.02503947913646698, 0.11364395916461945, -0.07347894459962845, -0.013068829663097858, 0.018865231424570084, -0.12805381417274475, 0.042992934584617615, -0.03616658225655556,
    -0.01541754137724638, -0.010102137923240662, 0.035911675542593, -0.020734596997499466, -0.03370038792490959, 0.02636999450623989, -0.02225714735686779, 0.07198095321655273,
    0.01069518830627203, -0.13767527043819427, -0.011688096448779106, 0.042100850492715836, 0.06973906606435776, 0.07989182323217392, 0.11151313036680222, 0.004003612790256739,
    -0.016414452344179153, 0.03559025377035141, -0.03575092554092407, -0.15143384039402008, -0.0057940855622291565, -0.11072423309087753, -0.0750250443816185, -0.011383185163140297,
    0.07645951211452484, -0.022856438532471657, -0.03495141491293907, -0.15117289125919342, -0.1657174527645111, -0.03406533598899841, -0.00911701750010252, -0.07640720903873444,
    0.10464344173669815, -0.011712810955941677, 0.013389218598604202, -0.03522124141454697, -0.010534461587667465, -0.011653860099613667, 0.02599225752055645, -0.018735164776444435,
    0.052809715270996094, -0.05330023542046547, -0.018047846853733063, -0.0014897335786372423, -0.014875800348818302, 0.009085831232368946, 0.05535769835114479, 0.02445901744067669,
    0.06661152094602585, 0.09284009039402008, 0.028553344309329987, 0.029227696359157562, -0.021629318594932556, 0.1237562820315361, 0.027903355658054352, 0.029288796707987785,
    -0.06061629205942154, 0.04462672397494316, 0.04104553535580635, -0.01315603032708168, -0.03418692946434021, -0.01898283138871193, 0.040526535362005234, 0.0020395854953676462,
    0.09723992645740509, -0.0748729407787323, -0.02332456223666668, -0.010918575339019299, 0.11024805158376694, 0.025052310898900032, 0.08187802881002426, -0.052127353847026825,
    0.1010487824678421, -0.0015999720199033618, 0.007468048948794603, -0.03240712359547615, 0.015182564966380596, 0.03195134177803993, -0.0482422299683094, 0.030247535556554794,
    -0.061230357736349106, 0.00403242465108633, 0.029494240880012512, 0.006969110108911991, -0.04346223175525665, -0.014602224342525005, 0.11422354727983475, 0.014985181391239166,
    0.06087759882211685, 0.02966930717229843, 0.01198600698262453, -0.08637584000825882, 0.0029907263815402985, 0.024307532235980034, -0.01708214357495308, 0.029122883453965187,
    -0.09557037055492401, 0.049925338476896286, 0.06856941431760788, 0.062021851539611816, -0.04407909885048866, 0.0031649230513721704, -0.11591164022684097, -0.08244814723730087,
    0.05279684066772461, 0.008761625736951828, 0.07955263555049896, -0.12744422256946564, -0.013227531686425209, -0.08010148257017136, -0.013958588242530823, 0.022880375385284424,
    0.08728054165840149, 0.023287665098905563, 0.013776234351098537, 0.05928146839141846, 0.00367672648280859, -0.06703618168830872, 0.08171623200178146, -0.002971838926896453,
    0.10728684067726135, 0.09278633445501328, -0.40665245056152344, 0.0044551738537848, 0.054253630340099335, 0.009073791094124317, -0.029553161934018135, 0.015307305380702019,
    -0.020975766703486443, -0.04565487056970596, 0.15077447891235352, 0.0098218759521842, 6.812108040321618e-05, 0.035563282668590546, 0.027258817106485367, -0.04708589240908623,
    0.05898888036608696, 0.11605867743492126, -0.028369786217808723, 0.022930987179279327, -0.03813505545258522, -0.09797362983226776, 0.10500428825616837, 0.052795618772506714,
    0.006832377519458532, 0.050818346440792084, -0.11435279995203018, -0.16269953548908234, -0.0646166130900383, -0.020848767831921577, -0.061639003455638885, 0.011700861155986786,
    -0.004972160328179598, 0.0027391507755964994, -0.11165516078472137, -0.05467095226049423, 0.09408383816480637, -0.04514741152524948, -0.09379890561103821, 0.013141190633177757,
    -0.006572560407221317, 0.07175952941179276, 0.06798293441534042, 0.02240764908492565, 0.013191266916692257, 0.0432191826403141, -0.12070578336715698, 0.008586185984313488,
    -0.013525553978979588, -0.05579342693090439, -0.04787791520357132, 0.015331331640481949, 0.0547783188521862, -0.0015671184519305825, 0.01765105128288269, -0.05196405202150345,
    -0.025794388726353645, -0.024203641340136528, -0.027745218947529793, -0.011487487703561783, -0.09249375015497208, -0.011936563067138195, -0.020880404859781265, 0.0193619467318058,
    0.05042301490902901, 0.08594406396150589, -0.08791180700063705, 0.015841472893953323, -0.12858740985393524, -0.03304656967520714, 0.007075581233948469, -0.04254412278532982,
    -0.016096346080303192, -0.0010963482782244682, 0.002434138208627701, -0.007073942571878433, 0.03351325914263725, -0.03494098782539368, -0.10282536596059799, 0.07267046719789505,
    -0.02707136608660221, -0.008317101746797562, 0.05631459876894951, -0.011356583796441555, -0.1463342159986496, 0.11671046167612076, -0.1255197376012802, 0.05576115846633911,
    -0.018666286021471024, -0.014475217089056969, 0.04922998696565628, -0.023859120905399323, 0.061086270958185196, 0.04457704350352287, -0.09055137634277344, -0.06663155555725098,
    0.01870579458773136, -0.02117731235921383, 0.08051791042089462, 0.0547633022069931, 0.0004517269553616643, 0.014775658026337624, -0.03284504637122154, 0.020597565919160843,
    -0.01780952513217926, -0.0462174154818058, 0.09635189175605774, -0.044503550976514816, 0.06095233932137489, 0.06722961366176605, -0.1199171170592308, 0.044342540204524994,
    0.05485168471932411, -0.08042923361063004, -0.059586066752672195, 0.02337506413459778, -0.01514363195747137, -0.04979624226689339, 0.1010863184928894, -0.07260783016681671,
    0.05384879186749458, 0.060201916843652725, 0.06250876933336258, -0.07610456645488739, -0.029607275500893593, 0.0854068472981453, -0.042631275951862335, 0.06819166243076324,
    0.16412398219108582, -0.10895015299320221, -0.2490510493516922, -0.016412153840065002, -0.005287326406687498, 0.08589791506528854, -0.11075568944215775, -0.0005329751293174922,
    0.05342773348093033, 0.058496132493019104, -0.16395273804664612, 0.029680397361516953, 0.054179172962903976, -0.017136313021183014, 0.11195993423461914, -0.04372289404273033,
    0.031095661222934723, 0.08876059204339981, 0.03037692792713642, -0.04342044144868851, -0.031618665903806686, -0.032537881284952164, 0.06532853841781616, 0.08560838550329208,
    0.07162720710039139, 0.035670746117830276, -0.0056188078597188, -0.11187830567359924, 0.0625777393579483, 0.08714981377124786, 0.047532182186841965, 0.044247910380363464,
    -0.04592973366379738, 0.00911091547459364, -0.0036987699568271637, -0.00048624086775816977, 0.024802550673484802, -0.12017817795276642, 0.024850357323884964, -0.01127487700432539,
    -0.08340529352426529, 0.005867579951882362, 0.017697438597679138, 0.05804818868637085, 0.014043498784303665, -0.09332527965307236, -0.074522003531456, -0.0028511988930404186,
    0.07129118591547012, -0.013157937675714493, 0.03288209065794945, -0.09882090240716934, 0.014320632442831993, -0.011909493245184422, 0.002108161337673664, -0.057444024831056595,
    0.14605142176151276, -0.0008075223304331303, 0.08608889579772949, 0.07474589347839355, 0.017445974051952362, -0.04745636135339737, -0.019286129623651505, -0.0017204065807163715,
    0.021398086100816727, 0.0022657252848148346, -0.03150080144405365, -0.00165295519400388, -0.14901410043239594, 0.04767194390296936, -0.07785855233669281, -0.1766313910484314,
    -0.09643187373876572, -0.061968039721250534, 0.03699224442243576, -0.014686400070786476, 0.050294846296310425, -0.008732146583497524, -0.0059104859828948975, 0.03791443631052971,
    -0.05796903744339943, 0.01900855079293251, 0.020035117864608765, -0.008941175416111946, 0.017513727769255638, 0.0857488140463829, -0.06449884176254272, 0.009962053038179874,
    -0.03419078141450882, 0.016521746292710304, 0.04930221289396286, 0.0075007095001637936, 0.08930624276399612, 0.011839304119348526, -0.14130888879299164, 0.04882790893316269,
    -0.05649953708052635, 0.017066573724150658, -0.03253764659166336, 0.06913036853075027, 0.015171869657933712, -0.013516156002879143, 0.011930996552109718, -0.024521896615624428,
    -0.03762088716030121, 0.011286201886832714, 0.013350583612918854, 0.03539678081870079, 0.11329370737075806, -0.05374029651284218, 0.023134315386414528, 0.08632736653089523,
    0.020132064819335938, 0.03398886322975159, 0.05539807677268982, 0.013840618543326855, 0.028230780735611916, 0.014522172510623932, -0.0001734574616421014, 0.04276347532868385,
    -0.0018538144649937749, -0.05090661346912384, -0.08222836256027222, 0.025041503831744194, 0.16217809915542603, -0.11773161590099335, -0.028270505368709564, 0.03951476514339447,
    -0.06606999784708023, -0.10138367861509323, 0.26769793033599854, 0.023952394723892212, -0.06256242096424103, -0.012003900483250618, 0.19098727405071259, -0.02044508047401905,
    -0.06671834737062454, -0.04605085402727127, -0.0051209041848778725, 0.07103882730007172, -0.049407415091991425, -0.004462947137653828, -0.011765193194150925, 0.08923105150461197,
    -0.022220339626073837, 0.06308683007955551, -0.042971376329660416, 0.07181478291749954, -0.08068617433309555, 0.058401089161634445, 0.036574650555849075, 0.01578414812684059,
    0.09403654932975769, 0.039174795150756836, -0.016211817041039467, 0.0571836419403553, 0.019656645134091377, 0.007817864418029785, -0.01202066708356142, -0.03772800788283348,
    0.06361287087202072, 0.022510673850774765, -0.05641527101397514, 0.08302246034145355, 0.036586202681064606, -0.19082877039909363, 0.04829484969377518, 0.04467528685927391,
    0.014238180592656136, -0.061041366308927536, -0.009262289851903915, -0.04052390158176422, -0.01305787917226553, 0.05095305293798447, -0.04309467598795891, 0.013147441670298576,
    0.07129058986902237, -0.12457391619682312, -0.08275949209928513, 0.07159765809774399, -0.05453202873468399, -0.00797285046428442, 0.12344591319561005, -0.039260972291231155,
    -0.030270496383309364, 0.016636023297905922, -0.02037028968334198, 0.08089198172092438, -0.0006002886220812798, 0.07209006696939468, 0.1224772185087204, 0.04292571172118187,
    -0.0013528293929994106, 0.0008573277154937387, 0.05611357465386391, 0.010156420059502125, 0.056160956621170044, -0.06876404583454132, 0.055135250091552734, -0.19651591777801514,
    -0.06894286721944809, 0.047246016561985016, -0.029952771961688995, 0.0020751329138875008, 0.03853416442871094, 0.01329584140330553, 0.11861920356750488, -0.016392802819609642,
    0.11478131264448166, -0.002778808819130063, 0.09217070043087006, -0.00966810341924429, 0.10213518142700195, -0.059096597135066986, 0.07325126975774765, 0.03413505107164383,
    -0.01203248742967844, 0.0119584696367383, -0.007344714365899563, 0.0149946678429842, 0.022728055715560913, -0.04705020785331726, 0.057506218552589417, -0.0030966834165155888,
    -0.032613176852464676, -0.04379475489258766, -0.021634617820382118, -0.02260029874742031, -0.009854927659034729, 0.04503362625837326, -0.018113987520337105, 0.050295304507017136,
    0.07767613977193832, 0.05713549628853798, 0.04515739530324936, 0.010645921342074871, -0.04427105560898781, -0.09449118375778198, -0.05823753401637077, 0.0057014524936676025,
    0.03335025534033775, 0.10298621654510498, -0.02568378485739231, 0.0722229927778244, -0.006720796227455139, -0.005045145284384489, -0.035523220896720886, 0.0014014716725796461,
    -0.0007747539202682674, 0.006993535440415144, 0.00043553728028200567, -0.007275245618075132, 0.12372244894504547, -0.020846756175160408, -0.05202706903219223, -0.007886018604040146,
    -0.010053629986941814, 0.13651126623153687, 0.2767963111400604, -0.024482620880007744, -0.07366993278265, 0.02605045959353447, 0.022295484319329262, -0.11995424330234528,
    0.04008539393544197, -0.01221624854952097, 0.04315126687288284, -0.06325264275074005, -0.09703169763088226, 0.027426952496170998, -0.06431552022695541, -0.04937062785029411,
    0.029020987451076508, -0.00730854831635952, -0.03789309784770012, -0.03808867186307907, -0.036741625517606735, -0.05213657766580582, 0.0790458396077156, -0.054211851209402084,
    -0.03460635244846344, 0.03450244292616844, 0.08566613495349884, 0.011154204607009888, -0.006009622476994991, 0.06624088436365128, -0.015289023518562317, -0.017355572432279587,
    0.0630880743265152, -0.064203180372715, -0.0002097272517858073, -0.0023985253646969795, -0.007907768711447716, -0.1899915337562561, 0.058487728238105774, -0.06347383558750153,
    0.059747111052274704, -0.022799473255872726, -0.08451328426599503, -0.04732928052544594, 0.014119653962552547, 0.057411279529333115, 0.0307045578956604, -0.002086473163217306,
    0.01595890149474144, -0.017021646723151207, -0.07554132491350174, 0.1110551655292511, -0.03471795469522476, -0.0005201844614930451, -0.06453854590654373, 0.025848543271422386,
    0.053025905042886734, -0.046433787792921066, -0.06267029792070389, -0.02249262109398842, -0.03369976207613945, -0.03186563774943352, -0.02124693989753723, 0.08375804871320724,
    0.041219837963581085, 0.037336453795433044, -0.07966239750385284, -0.020691612735390663, 0.06579290330410004, 0.00653908820822835, 0.0388965830206871, -0.00548161193728447,
    -0.0822794958949089, -0.00230318121612072, -0.09158439934253693, 0.011550653725862503, -0.05999224632978439, -0.07514458149671555, -0.13505089282989502, -0.07145190984010696,
    0.08822571486234665, 0.007814337499439716, 0.021202361211180687, -0.01482873223721981, -0.048372309654951096, 0.02249586023390293, 0.03995275869965553, 0.008569987490773201,
    -0.00442102225497365, -0.02250281348824501, 0.03386399522423744, 0.007434793282300234, -0.009020451456308365, 0.04078257083892822, 0.1808072030544281, -0.015063405968248844,
    0.08632022142410278, 0.02781255543231964, -0.09082581847906113, -0.09602778404951096, -0.0018621212802827358, 0.01308045070618391, 0.07214623689651489, 0.0003197448095306754,
    -0.08876478672027588, 0.05954563990235329, 0.0889221802353859, -0.06211913377046585, 0.00453557725995779, -0.12145645171403885, 0.08654386550188065, -0.05911334231495857,
    -0.0383022278547287, -0.029465055093169212, 0.040302783250808716, 0.054283954203128815, 0.04198319837450981, 0.05248527228832245, 0.018982058390975, 0.046003393828868866,
    -0.02380368672311306, 0.049164190888404846, 0.04516459256410599, -0.013787462376058102, -0.06655246764421463, 0.07271938771009445, 0.04950113594532013, 0.10108515620231628,
    0.07027880102396011, 0.09781848639249802, -0.10879340022802353, 0.03868202492594719, 0.029728731140494347, 0.04016709327697754, -0.07308559119701385, -0.009479240514338017,
    0.002566581591963768, -0.016841569915413857, -0.025939228013157845, 0.04402843117713928, -0.01168310921639204, -0.04041426628828049, -0.022085409611463547, -0.021870115771889687,
    0.044803686439991, 0.07832614332437515, -0.0009396000532433391, -0.03961481153964996, -0.03226635232567787, -0.12465294450521469, 0.010260465554893017, -0.0756811797618866,
    0.0032300574239343405, -0.0074841626919806, -0.02989800088107586, 0.0031393335666507483, -0.045775964856147766, 0.008256583474576473, -0.042475681751966476, -0.05675319582223892,
    0.06878108531236649, 0.051007308065891266, 0.050738681107759476, -0.009757069870829582, -0.006821773014962673, -0.2674028277397156, 0.004315529018640518, -0.0471574142575264,
    -0.09600266069173813, 0.007659750524908304, 0.040961820632219315, 0.07258159667253494, -0.006556962616741657, -0.11168650537729263, 0.013853239826858044, 0.027042614296078682,
    -0.07337427884340286, 0.03186923265457153, -0.009439018554985523, -0.04843874275684357, 0.10361853986978531, 0.003548392793163657, -0.05985192954540253, -0.02735024504363537,
    -0.1010046973824501, -0.017338024452328682, -0.06135118380188942, 0.01434995885938406, -0.004881588742136955, -0.20173390209674835, 0.023000748828053474, -0.09479661285877228,
    -0.0243215411901474, 0.16311240196228027, 0.012832213193178177, 0.01338622160255909, -0.09629832953214645, 0.02032216265797615, -0.082381471991539, -0.062354378402233124,
    0.0686325952410698, -0.021920448169112206, 0.05281374230980873, -0.04627678915858269, -0.05184805393218994, -0.020275089889764786, 0.0669461265206337, 0.12022004276514053,
    -0.15535792708396912, -0.014972596429288387, 0.10028180480003357, -0.02715703286230564, -0.0024754777550697327, 0.06495221704244614, -0.12873491644859314, -0.029165541753172874,
    -0.06097913533449173, 0.0009660644573159516, 0.16497132182121277, -0.049338582903146744, -0.0676451250910759, 0.005426099058240652, -0.1432204395532608, 0.10176496207714081,
    -0.029470128938555717, -0.02689439244568348, -0.22222313284873962, -0.013271262869238853, -0.006079286336898804, -0.003980530425906181, 0.015041207894682884, 0.03424398973584175,
    -0.03612030670046806, -0.03414130583405495, 0.04918644204735756, -0.001517891651019454, -0.027986714616417885, 0.015161427669227123, -0.01745813898742199, 0.07819616049528122,
    -0.005936833098530769, -0.054852135479450226, -0.006655306089669466, 0.007147760130465031, -0.03832133114337921, 0.07807686924934387, 0.07162276655435562, -0.07155714929103851,
    -0.004607494454830885, 0.058607473969459534, 0.04855094105005264, 0.031921952962875366, 0.008115123026072979, 0.03894764557480812, 0.028336063027381897, 0.053515203297138214,
    0.024947764351963997, -0.08062104135751724, -0.08461262285709381, -0.03320910781621933, 0.05529019981622696, -0.009041856043040752, -0.033415768295526505, 0.013325453735888004,
    -0.03994295746088028, 0.06689941138029099, -0.043538715690374374, 0.03159044682979584, 0.05335107818245888, -0.03441455587744713, 0.049440935254096985, 0.029531532898545265,
    0.03988339751958847, -0.018364524468779564, 0.0767420157790184, 0.08596132695674896, 0.05304786562919617, 0.1342146396636963, -0.16321629285812378, 0.04204406961798668,
    0.14322726428508759, 0.006272779777646065, -0.02909816987812519, 0.08115226775407791, 0.11853355169296265, 0.012164277955889702, -0.03983703628182411, 0.07080499082803726,
    -0.014777467586100101, 0.0027826756704598665, 0.06605209410190582, -0.06536266952753067, -0.051309406757354736, -0.21084582805633545, 0.09503073990345001, 0.057315926998853683,
    -0.015729324892163277, 0.05156285688281059, -0.017094796523451805, -0.019035600125789642, 0.011589600704610348, 0.0209061112254858, -0.04647541418671608, 0.0034627157729119062,
    -0.06497681885957718, -0.09420411288738251, -0.10108688473701477, 0.05098666250705719, -0.029912814497947693, -0.0021452291402965784, 0.06150100380182266, 0.05377275496721268,
    0.012815183028578758, -0.0034358371049165726, 0.12487821280956268, 0.10263466835021973, 0.05687025561928749, 0.16640064120292664, 0.02586190029978752, -0.028846194967627525,
    0.002936938079074025, -0.06689540296792984, -4.654581061913632e-05, -0.017219889909029007, -0.07824432104825974, -0.04709920287132263, 0.022209666669368744, -0.18856894969940186,
    0.015640681609511375, 0.007451499812304974, -0.06357855349779129, 0.024098968133330345, 0.003986754454672337, -0.11516262590885162, 0.027370059862732887, -0.12337043881416321,
    0.02195972017943859, 0.011775768361985683, 0.05931345745921135, -0.010766820050776005, 0.04542120173573494, 0.03645019605755806, 0.12977245450019836, -0.031484685838222504,
    -0.03370053321123123, 0.021264612674713135, -0.11422158032655716, 0.02223365008831024, -0.029199624434113503, -0.053505998104810715, -0.1455376148223877, 0.06255237758159637,
    0.10682577639818192, 0.01992262899875641, -0.14159587025642395, 0.07838118821382523, 0.008338159881532192, 0.033560995012521744, 0.01493698637932539, -0.009686282835900784,
    0.004043885041028261, 0.02921956218779087, 0.03156920522451401, 0.005883120000362396, -0.005694448947906494, -0.0006220628856681287, -0.029490947723388672, -0.01422807015478611,
    -0.00021226513490546495, -0.019888244569301605, 0.009840318001806736, -0.03308171406388283, 0.012170301750302315, -0.013987671583890915, -0.017914244905114174, -0.06783831119537354,
    0.02829417772591114, -0.054426852613687515, -0.05438186228275299, 0.01333986222743988, 0.027329040691256523, -0.059189606457948685, 0.023148557171225548, -0.12143075466156006,
    0.007803177926689386, -0.010880935937166214, 0.006266510579735041, 0.01647099480032921, -0.04367750883102417, -0.019335156306624413, 0.13600055873394012, -0.014561055228114128,
    0.02918732538819313, -0.050935808569192886, -0.005813524592667818, -0.041024450212717056, 0.014182087033987045, 0.040098126977682114, -0.0790996178984642, -0.027178708463907242,
    0.03622620552778244, 0.03689461946487427, -0.021104179322719574, -0.016514852643013, 0.021277710795402527, 0.021003343164920807, -0.020561613142490387, 0.002805817173793912,
    0.0005583073943853378, -0.049518004059791565, -0.011775733903050423, 0.0404963418841362, 0.08584379404783249, 0.0053308699280023575, 0.05513016879558563, -0.001591723645105958,
    -0.014605866745114326, -0.05413605645298958, 0.11098716408014297, -0.002042955020442605, 0.12355813384056091, -0.17757955193519592, 0.11697427183389664, -0.02318090945482254,
    0.03626187518239021, -0.07576558738946915, 0.0027772439643740654, -0.024177782237529755, -0.005198891274631023, 0.06421161442995071, 0.014190440066158772, -0.006582140922546387,
    -0.04043717309832573, 0.001591759268194437, 0.027180984616279602, 0.006034541875123978, -0.03898992761969566, -0.010299389250576496, 0.08645310252904892, 0.019487662240862846,
    0.03060963936150074, -0.058960605412721634, 0.0978076159954071, -0.07226936519145966, 0.004638658836483955, 0.03795196861028671, -0.04881618171930313, 0.0908573716878891,
    0.06631337851285934, -0.035831518471241, -0.04353952780365944, -0.0026102636475116014, 0.04779135435819626, -0.06927426159381866, 0.02616952359676361, -0.04452307149767876,
    0.028225857764482498, -0.029594505205750465, 0.007749862503260374, 4.564155824482441e-05, 0.0148633336648345, -0.009193680249154568, -0.08384476602077484, -0.03468061238527298,
    0.08579863607883453, 0.009434419684112072, 0.04024342820048332, 0.007745059207081795, -0.04036984592676163, -0.05812002718448639, -0.04200335964560509, -0.036217015236616135,
    -0.04647184908390045, -0.03289420157670975, -0.056606475263834, 0.014905210584402084, 0.04393604025244713, 0.04279433935880661, 0.1836193948984146, 0.00862991064786911,
    0.06145447865128517, 0.009899847209453583, -0.05050402134656906, 0.01280118152499199, -0.0005207584472373128, -0.0031688909512013197, -0.01841919869184494, 0.007215352728962898,
    0.08262646943330765, 0.010158988647162914, -0.030834170058369637, -0.02946542203426361, -0.025659378618001938, -0.09902546554803848, -0.03908864036202431, 0.03452659398317337,
    -0.0018683327361941338, -0.019018834456801414, 0.011540653184056282, -0.0225833673030138, 0.010071705095469952, -0.025693049654364586, -0.07875385880470276, 0.05227835476398468,
    -0.007203063927590847, 0.017694206908345222, -0.03838189318776131, -0.03062683530151844, 0.048455286771059036, 0.010519779287278652, 0.026105966418981552, -0.03809255734086037,
    0.07185689359903336, 0.042255185544490814, -0.034551627933979034, 0.0006249914295040071, -0.07623272389173508, -0.021825574338436127, 0.057610806077718735, -0.0028991042636334896,
    -0.022270802408456802, -0.0255623459815979, -0.01694682240486145, -0.02930210717022419, 0.002363987034186721, -0.06302497535943985, -0.06664702296257019, 0.009402197785675526,
    -0.011856620199978352, 0.046931784600019455, -0.021880965679883957, -0.08200585097074509, 0.028132347390055656, -0.09815362095832825, -0.02753099985420704, -0.09400966763496399,
    -0.08824403584003448, 0.07461422681808472, -0.030062442645430565, 0.1411912888288498, -0.01913823001086712, -0.03909742459654808, 0.014854136854410172, 0.019885897636413574,
    0.04365064203739166, 0.03503100574016571, 0.022297466173768044, -0.01928212307393551, 0.060429733246564865, -0.053729280829429626, 0.053174301981925964, -0.08150345087051392,
    -0.09971698373556137, -0.03813347592949867, 0.03358941897749901, 0.006833190098404884, 0.024771615862846375, -0.017235998064279556, 0.034656353294849396, 0.021685317158699036,
    -0.01042844820767641, 0.022945942357182503, 0.09536232799291611, 0.029608294367790222, 0.11261993646621704, -0.002042875625193119, 0.03376293554902077, 0.0882844403386116,
    -0.03668946772813797, -0.018471062183380127, -0.165058895945549, -0.08060048520565033, 0.021763935685157776, -0.1214732676744461, 0.1268267184495926, -0.009686700999736786,
    0.08592893928289413, 0.1040506511926651, -0.10502888262271881, -0.014041476882994175, 0.012287361547350883, -0.00013067566032987088, 0.008985649794340134, -0.03630095347762108,
    0.025979049503803253, -0.005299314856529236, 0.1722577065229416, -0.005519762169569731, 0.053109873086214066, 0.006597498897463083, 0.11299094557762146, 0.07530597597360611,
    -0.08349189907312393, -0.003174075623974204, 0.05627966672182083, -0.016665438190102577, -0.09146370738744736, -0.003014501417055726, -0.08268729597330093, 0.12203613668680191,
    -0.04265676066279411, -0.008105686865746975, 0.06340888887643814, -0.020391616970300674, -0.0035711857490241528, 0.010213003493845463, 0.14006926119327545, 0.015789026394486427,
    0.025235679000616074, 0.01050986722111702, -0.14130909740924835, 0.03641340509057045, -0.007019790355116129, -0.01606154628098011, 0.07403280586004257, 0.020021745935082436,
    0.027485162019729614, 0.0017784503288567066, 0.0062994398176670074, 0.004480994772166014, -0.004665922373533249, -0.012146150693297386, 0.08116093277931213, 0.05777779594063759,
    0.005930477287620306, 0.046887487173080444, 0.014699514955282211, -0.018886948004364967, -0.026347467675805092, 0.002784596523270011, 0.04526872932910919, 0.024284208193421364,
    0.0038634503725916147, 0.048294998705387115, -0.05405727028846741, 0.024341173470020294, 0.0005655436543747783, 0.055959153920412064, 0.07557480782270432, 0.052368517965078354,
    0.03619455173611641, -0.0008685718639753759, 0.08075418323278427, 0.010383548215031624, -0.007818897254765034, 0.001129891723394394, -0.17052491009235382, 0.054598160088062286,
    0.032582495361566544, 0.04468947649002075, -0.012055709026753902, 0.029578983783721924, 0.0748760849237442, -0.14685934782028198, 0.12371028959751129, 0.000129584688693285,
    -0.0102987140417099, 0.0074738143011927605, 0.02908957377076149, 0.07445961982011795, -0.005039699375629425, 0.04908454045653343, -0.07601334154605865, 0.051176466047763824,
    0.08441146463155746, -0.013967214152216911, -0.05696985870599747, 0.10199929773807526, -0.11541008204221725, -0.03507182374596596, 0.012682853266596794, 0.04370327666401863,
    0.009305618703365326, 0.026737354695796967, -0.12411041557788849, -0.015878239646553993, -0.02384723350405693, -0.03450996056199074, 0.04230666905641556, -0.016830703243613243,
    -0.044183675199747086, 0.023850485682487488, -0.0010708135087043047, 0.012766839936375618, -0.023714035749435425, 0.048502929508686066, -0.0002725747472140938, -0.023755423724651337,
    0.00010635319631546736, -0.03307577967643738, -0.02518869750201702, 0.07255613803863525, 0.06169372424483299, 0.007826156914234161, 0.07214231789112091, 0.07025597989559174,
    -0.02036316692829132, 0.025633608922362328, -0.017951134592294693, 0.02510470151901245, 0.06546135246753693, 0.05468616634607315, 0.08419492095708847, -0.0323554202914238,
    -0.026575254276394844, 0.013967088423669338, -0.020360559225082397, 0.005044903140515089, -0.052302613854408264, 0.008718705736100674, -0.02378944866359234, -0.09833035618066788,
    -0.054159555584192276, 0.00956432893872261, 0.012014226987957954, -0.026835834607481956, -0.03199946880340576, -0.04725995659828186, -0.04007082059979439, -0.02728341519832611,
    -0.02449762634932995, -0.00019304097804706544, 0.10140039026737213, -0.016113432124257088, 0.031054435297846794, 0.05776019021868706, 0.06035822257399559, 0.10343414545059204,
    0.0054067764431238174, 0.007363479118794203, -0.049647342413663864, 0.007886658422648907, -0.12130601704120636, -0.03838006779551506, -0.1379748284816742, -0.02403896115720272,
    0.08634959161281586, -0.002644522115588188, -0.13386034965515137, 0.025316623970866203, 0.0007190756732597947, -0.0029492657631635666, 0.005540432408452034, 0.011354435235261917,
    -0.016533011570572853, 0.01737569272518158, 0.002574116690084338, 0.014125550165772438, 0.01249359268695116, 0.08199537545442581, -0.0002651582472026348, -0.0024659084156155586,
    -0.014837776310741901, 0.0464056059718132, -0.02509116753935814, 0.09048296511173248, 0.0111604705452919, 0.024183280766010284, 0.040197983384132385, -0.07297056913375854,
    0.05498286336660385, 0.026379339396953583, -0.009752643294632435, 0.001368887722492218, 0.004983738996088505, 0.008395957760512829, 0.008756325580179691, -0.014604572206735611,
    0.017850501462817192, -0.05911866948008537, 0.13120411336421967, -0.011248105205595493, -0.07475420087575912, -0.027888549491763115, 0.016162728890776634, 0.14556965231895447,
    0.0014614908723160625, -0.005765235051512718, 0.00890271458774805, -0.06476765125989914, -0.007491135038435459, -0.0651598870754242, 0.049347687512636185, -0.0408870168030262,
    0.04030048847198486, 0.10358733683824539, -0.0055197542533278465, -0.02870791219174862, -0.04268236458301544, 0.06591600179672241, -0.03964269906282425, 0.15893223881721497,
    0.0191084872931242, -0.07915244996547699, 0.015227856114506721, -0.09615733474493027, 0.0273022148758173, 0.06725826114416122, 0.009282127022743225, -0.002071470720693469,
    -0.04695185273885727, -0.05921347811818123, -0.04824518784880638, -0.03171740099787712, 0.10445281863212585, -0.07245387136936188, 0.0471479594707489, -0.04244527593255043,
    -0.04476122558116913, -0.02051159366965294, -0.03363349661231041, -0.015120898373425007, 0.029273904860019684, 0.00918138213455677, -0.03269300237298012, 0.013251300901174545,
    0.036253850907087326, 0.016678662970662117, -0.021640555933117867, 0.012691864743828773, -0.019149143248796463, -0.01750468835234642, 0.07159630209207535, 0.03552455082535744,
    0.018578723073005676, -0.05458459258079529, 0.08120472729206085, -0.048002272844314575, 0.059186551719903946, 0.06915443390607834, -0.08177408576011658, 0.04284563660621643,
    0.036524269729852676, -0.059932537376880646, 0.09361349046230316, -0.014653995633125305, 0.0533628948032856, 0.04558458551764488, -0.0453970730304718, -0.11296213418245316,
    0.0057299076579511166, 0.03235052898526192, -0.0639617070555687, 0.015628494322299957, 0.02116798609495163, -0.05473688244819641, -0.135389506816864, -0.06170518323779106,
    0.048646360635757446, 0.003923519514501095, 0.04032932221889496, -0.011945335194468498, -0.021726125851273537, 0.08472657203674316, -0.048797979950904846, 0.006760045420378447,
    0.005071031861007214, -0.0038532009348273277, -0.009278452955186367, 0.028997570276260376, -0.07370004802942276, 0.0389048308134079, -0.08198840171098709, 0.013044774532318115,
    -0.011121178977191448, 0.01564088836312294, -0.0629270002245903, -0.07015665620565414, 0.01931140199303627, -0.005441852379590273, -0.10063290596008301, -2.2969088604440913e-06,
    -0.005678873043507338, -0.02587355300784111, 0.007992809638381004, -0.017588436603546143, -0.002741213422268629, -0.06717120110988617, -0.0417555570602417, 0.012824642471969128,
    -0.08571557700634003, 0.013062229380011559, 0.03436507284641266, -0.020594073459506035, 0.006086400244385004, 0.1048421859741211, -0.023827331140637398, -0.06730476021766663,
    0.01286896038800478, 0.04946155101060867, -0.03618958592414856, -0.02919946238398552, 0.03746435418725014, 0.04828760772943497, -0.007873067632317543, -0.04665395990014076,
    0.021043112501502037, -0.03714105859398842, -0.1554131656885147, 0.019214658066630363, -0.047306813299655914, -0.07350778579711914, 0.0386558435857296, 0.15495425462722778,
    -0.02388335019350052, -0.015604074113070965, 0.05167621746659279, 0.00890827551484108, -0.0004955273470841348, -0.05030232295393944, -0.05052671208977699, 0.026918072253465652,
    0.027229398488998413, -0.006492557469755411, 0.015100108459591866, -0.01940874569118023, -0.029843555763363838, -0.13213160634040833, -0.040010325610637665, 0.05771055817604065,
    -0.02985418029129505, 0.03888784721493721, 0.011987552046775818, -0.0577499195933342, 0.06764067709445953, -0.035220853984355927, -0.06151409074664116, -0.013668753206729889,
    -0.038674160838127136, 0.05641649663448334, -0.006484505254775286, 0.009955177083611488, 0.19579561054706573, 0.054737698286771774, -0.05537736043334007, -0.002601458691060543,
    -0.0946791023015976, -0.02980900928378105, 0.11792370676994324, 0.05643024295568466, -0.01398816704750061, 0.043418727815151215, -0.015971237793564796, 0.0004602591507136822,
    0.04542963206768036, 0.023373613134026527, 0.1876608431339264, -0.08529296517372131, 0.035878293216228485, 0.0021617687307298183, 0.09983549267053604, -0.06708112359046936,
    -0.04343952238559723, -0.04561391845345497, -0.08530709147453308, 0.000391019246308133, -0.02488037571310997, -0.05882573872804642, 0.0904901847243309, 0.0047870902344584465,
    0.07930002361536026, 0.047752443701028824, 0.04220031946897507, 0.012756303884088993, 0.07089255750179291, 0.03768407180905342, -0.0015652375295758247, -0.13630618155002594,
    0.06632596254348755, -0.04946393892168999, -0.01605216972529888, -0.0028280385304242373, -0.01866886019706726, 0.016434354707598686, 0.18001022934913635, 0.034725528210401535,
    -0.1166497990489006, -0.014685160480439663, 0.09528067708015442, -0.026512810960412025, -0.0403125062584877, -0.06076885014772415, -0.13589873909950256, 0.0025446258950978518,
    -0.08233312517404556, -0.043817728757858276, -0.04562891274690628, -0.029059527441859245, -0.0020425531547516584, -0.007156423758715391, 0.09068271517753601, 0.027036570012569427,
    -0.0015230412827804685, -0.027004726231098175, -0.1410001665353775, 0.01892489567399025, -0.005881538148969412, 0.0002840726519934833, -0.025526123121380806, 0.05172266438603401,
    0.05332939326763153, -0.029934844002127647, -0.00293307239189744, -0.056366924196481705, -0.033699411898851395, -0.028763040900230408, 0.00510071637108922, 0.08567377924919128,
    0.053306885063648224, -0.020963778719305992, -0.051480840891599655, 0.059263113886117935, -0.08629713207483292, 0.041579119861125946, 0.047037478536367416, -0.03726065903902054,
    -0.01155600231140852, -0.006871742662042379, -0.0019775668624788523, -0.013632589019834995, 0.017608147114515305, 0.06149805709719658, 0.0005845659761689603, 0.01761206053197384,
    0.04015916958451271, -0.02444501407444477, -0.024939686059951782, -0.011051519773900509, -0.001792052760720253, -0.040393028408288956, 0.045172568410634995, 0.10140321403741837,
    0.014104722999036312, 0.03896931931376457, -0.04017084464430809, 0.009996986016631126, 0.02743508666753769, -0.012257833033800125, 0.02605513669550419, 0.003941247705370188,
    0.039619795978069305, -0.062148455530405045, 0.00510726124048233, 0.05391649529337883, 0.12356480211019516, 0.039525773376226425, -0.027937455102801323, -0.02229330874979496,
    -0.0021889947820454836, 0.09172838926315308, -0.008285962976515293, 0.025239167734980583, -0.02570383809506893, -0.03462542966008186, -0.021709365770220757, 0.09211935102939606,
    -0.033988069742918015, -0.005790604278445244, 0.039681240916252136, 0.034918248653411865, -0.11499291658401489, -0.08704236149787903, 0.01514213066548109, -0.028295541182160378,
    0.13092415034770966, 0.02220415510237217, -0.01000649482011795, -0.03781913220882416, 0.018994418904185295, 0.05877983197569847, -0.009869182482361794, -0.008329743519425392,
    0.06733594089746475, 0.08730430155992508, 0.18587236106395721, 0.04591182991862297, -0.02253030799329281, 0.0014583348529413342, 0.006399685982614756, 0.08933531492948532,
    0.08934561163187027, 0.022714009508490562, -0.07246587425470352, -4.353739495854825e-05, 0.014888845384120941, 0.11497963219881058, 0.04817052185535431, 0.04615040123462677,
    0.030624857172369957, 0.011911408044397831, -0.03762016445398331, -0.015475685708224773, -0.06288965046405792, 0.038193654268980026, 0.0566616952419281, -0.07409325987100601,
    -0.14186584949493408, -0.09321076422929764, -0.1628001183271408, 0.014076615683734417, -0.0486023835837841, -0.010613219812512398, -0.08357254415750504, -0.1037173941731453,
    0.08862128853797913, -7.160975656006485e-05, 0.04835938662290573, 0.0015376688679680228, 0.05082932859659195, -0.009480458684265614, 0.11403591930866241, 0.0470048189163208,
    -0.011202413588762283, 0.0005744974478147924, -0.1130356714129448, 0.012629223987460136, -0.02862617000937462, -0.03414071723818779, 0.16305284202098846, -0.027770116925239563,
    0.1652185171842575, 0.02131510153412819, -0.2136545181274414, 0.13139820098876953, -0.0016226193401962519, 0.020162496715784073, 0.12970870733261108, -0.03376233950257301,
    -0.05851341411471367, 0.08420480042695999, 0.0334743857383728, -0.004788307473063469, -0.0001244815211975947, -0.010576464235782623, 0.0802706703543663, -0.028914745897054672,
    -0.010160057805478573, 0.08339712768793106, 0.0362580269575119, -0.03355678543448448, 0.11689592897891998, -0.07665323466062546, -0.0027692255098372698, 0.09114178270101547,
    0.005379895213991404, -0.10511945933103561, -0.0781920850276947, 0.05816597118973732, 0.0077332137152552605, -0.0509667731821537, 0.09812846034765244, -0.0016753548989072442,
    0.04077781364321709, -0.0018383623100817204, 0.14768843352794647, 0.008339042775332928, -0.04041202738881111, 0.024855265393853188, 0.006561086513102055, 0.16229474544525146,
    -0.02296033687889576, -0.09093181788921356, -0.0036604355555027723, -0.004031740128993988, 0.01769334450364113, -0.05627109482884407, -0.01753121055662632, -0.026331201195716858,
    0.005741799715906382, -0.015393356792628765, -0.04039105027914047, -0.037051111459732056, 0.0024185588117688894, 0.04705970361828804, 0.07257947325706482, -0.05864851921796799,
    0.011210043914616108, -0.053391922265291214, -0.04007401689887047, 0.036410409957170486, -0.13437634706497192, 0.036450546234846115, 0.010435082018375397, -0.013450403697788715,
    -0.002381739905104041, -0.044860050082206726, -0.04689836502075195, -0.00805771816521883, 0.057771313935518265, -0.11564390361309052, -0.019807012751698494, 0.026137592270970345,
    -0.04661699756979942, 0.04149997979402542, -0.0006316746585071087, -0.0023943542037159204, -0.00634735357016325, 0.00017998133262153715, -0.02557922527194023, 0.003789993468672037,
    0.0011666279751807451, 0.07361674308776855, -0.015798991546034813, 0.03498886898159981, 0.058130983263254166, -0.014677844941616058, 0.03155934438109398, 0.04890386387705803,
    -0.1044016033411026, -0.0366220586001873, -0.12287507206201553, -0.10121883451938629, 0.004021496511995792, -0.04252159968018532, 0.018649620935320854, -0.021072814241051674,
    -0.018748171627521515, 0.07612011581659317, 0.07949529588222504, 0.012572047300636768, 0.03365103900432587, -0.05928812921047211, -0.04423918202519417, -0.06431375443935394,
    0.03016221523284912, 0.10543564707040787, 0.01782069355249405, 0.0013497918844223022, -0.018087659031152725, 0.07097621262073517, -0.0826030895113945, 0.09361609816551208,
    -0.00683471467345953, -0.012346518225967884, 0.06522659957408905, -0.05249154940247536, 0.05050915107131004, 0.08869580924510956, -0.09087201952934265, -0.0053601497784256935,
    -0.023308750241994858, 0.025646647438406944, 0.07160323858261108, -0.014245521277189255, 0.012583820149302483, 0.04945177957415581, -0.15185019373893738, 0.0005023523117415607,
    -0.08367305994033813, 0.008952926844358444, -0.1267508864402771, 0.007516858633607626, -0.005807298701256514, -0.018459782004356384, 0.016698068007826805, 0.0037854097317904234,
    0.05998622626066208, 0.004620921798050404, 0.014453725889325142, -0.06578390300273895, -0.117583267390728, 0.017501890659332275, -0.07445600628852844, 0.007158489432185888,
    -0.006163659039884806, 0.059959933161735535, 0.007408516947180033, 0.004507903009653091, -0.0053717270493507385, 0.03152474761009216, 0.04286360740661621, 0.01571258343756199,
    -0.09014865756034851, 0.09799889475107193, -0.030279889702796936, -0.06919292360544205, 0.12219200283288956, 0.10450897365808487, -0.0442919060587883, 0.03759248927235603,
    0.06967154145240784, -0.042962003499269485, -0.1466314047574997, -0.00030996050918474793, 0.03374330699443817, 0.048708606511354446, -0.18209052085876465, 0.07772904634475708,
    4.214713771943934e-05, 0.04615163058042526, -0.018401306122541428, 0.016041403636336327, 0.11157338321208954, -0.0071633365005254745, 0.03614480048418045, 0.002263356000185013,
    -0.006069308612495661, -0.15020015835762024, 0.048697277903556824, -0.021226931363344193, 0.003830730216577649, -0.05651241913437843, -0.03390667587518692, -0.019193097949028015,
    0.01533566229045391, -0.02608693204820156, 0.032716184854507446, -0.04856961965560913, 0.07460194826126099, -0.01549467258155346, -0.034938693046569824, -0.06187262386083603,
    -0.046645306050777435, 0.0709294006228447, -0.0590464286506176, -0.0747247114777565, 0.13060735166072845, 0.008543702773749828, 0.007775912061333656, 0.0747390016913414,
    -0.08020070940256119, 0.08999211341142654, -0.0010657260427251458, 0.01938282698392868, -0.0035968427546322346, 0.011728942394256592, -0.08156755566596985, -0.020196547731757164,
    -0.0072698090225458145, 0.0032623521983623505, -0.13392265141010284, -0.0640745759010315, 0.034972406923770905, 0.008204073645174503, 0.011245766654610634, -0.057234685868024826,
    -0.1253528892993927, -0.09123900532722473, -0.007373535539954901, -0.02115815505385399, 0.004387247376143932, -0.039310142397880554, 0.0036576404236257076, 0.029499825090169907,
    -0.04868170619010925, -0.04224952682852745, 0.07920943200588226, -0.011827377602458, -0.053576648235321045, 0.05227593332529068, -0.044791705906391144, -0.17924602329730988,
    0.07776262611150742, 0.047917380928993225, 0.027950512245297432, -0.030812369659543037, 0.01848204806447029, -0.02723374404013157, 0.11353308707475662, -0.014929811470210552,
    -0.08180626481771469, -0.0011510152835398912, 0.09581156820058823, -0.06459763646125793, -0.021162113174796104, 0.04747574031352997, -0.02346968837082386, -0.012053733691573143,
    -0.0680011585354805, -0.03027651086449623, 0.0971919447183609, -0.001264407066628337, -0.049914490431547165, -0.013270542956888676, -0.1506991684436798, 0.05602899566292763,
    -0.0012799677206203341, -0.07061384618282318, -0.07221385091543198, 0.015909740701317787, -0.0002446032012812793, -0.046191245317459106, -0.08521340787410736, 0.06230625882744789,
    0.008072637021541595, -0.023694446310400963, 0.038360223174095154, -0.029753725975751877, -0.08301399648189545, 0.01725471206009388, -0.03361894190311432, 0.010290426202118397,
    -0.006709802430123091, 0.04427202045917511, -0.052125707268714905, -0.027988744899630547, -0.10670123249292374, 0.09632328897714615, 0.05716861039400101, -0.007566007319837809,
    -0.07141696661710739, 0.07371325045824051, 0.022740773856639862, -0.0162783432751894, 0.034519221633672714, 0.06305453926324844, -0.055607493966817856, 0.029491756111383438,
    -0.007415682543069124, -0.019519150257110596, -0.058471906930208206, -0.0019967472180724144, 0.01582402177155018, -0.02598966471850872, 0.03667795658111572, 0.00995444506406784,
    -0.0005343012744560838, 0.025283917784690857, -0.0036372628528624773, 0.029469911009073257, -0.05931369960308075, 0.051052454859018326, -0.006268431432545185, 0.02112043835222721,
    0.018903084099292755, -0.05285923182964325, -0.018580574542284012, 0.06015537679195404, 0.03190750628709793, -0.10588067770004272, -0.07244741171598434, 0.031611617654561996,
    0.045157287269830704, -0.0035791906993836164, 0.05308718606829643, -0.114189513027668, 0.09497074037790298, -0.0002796072221826762, -0.04391942918300629, 0.02917354553937912,
    -0.09023117274045944, -0.051052093505859375, 0.09178849309682846, 0.012610510922968388, -0.015292578376829624, -0.0014857222558930516, 0.030164876952767372, -0.044860728085041046,
    0.17598994076251984, 0.052189234644174576, -0.025469964370131493, -0.0425306111574173, 0.008766822516918182, 0.08255374431610107, 0.0062848967500030994, 0.001720745931379497,
    0.03518214076757431, 0.1013382077217102, 0.13697728514671326, -0.05032731592655182, -0.0015009262133389711, -0.011740501970052719, -0.016122331842780113, -0.008486851118505001,
    0.0827358067035675, -0.05038171634078026, 0.03819480538368225, -0.020018447190523148, -0.00591982901096344, 0.1148473471403122, -0.02275116741657257, 0.09171878546476364,
    0.0502263642847538, -0.1625129133462906, -0.07468574494123459, 0.003594502806663513, -0.07435866445302963, 0.08247566223144531, 0.06220006197690964, -0.028671937063336372,
    -0.1676838994026184, -0.1383928656578064, -0.034693777561187744, 0.0711481049656868, -0.05480606481432915, -0.020516175776720047, -0.05625883489847183, -0.1236497163772583,
    0.11820073425769806, 0.010614694096148014, 0.021706750616431236, -0.015086528845131397, 0.0003954671847168356, -0.07524272054433823, 0.09593021124601364, -0.003123220521956682,
    -0.021727241575717926, 0.01830194890499115, -0.11646135151386261, 0.04488690197467804, -0.04816938191652298, -0.006711584981530905, 0.17417627573013306, -0.027493884786963463,
    0.19513514637947083, 0.05981241166591644, -0.17476309835910797, 0.07879214733839035, 0.02667476236820221, -0.02229304611682892, -0.016429638490080833, -0.08980505168437958,
    -0.10445456206798553, 0.034867458045482635, 0.07855357229709625, 0.03239615634083748, 0.009639596566557884, -0.005421020556241274, 0.02450931817293167, -0.01267414353787899,
    -0.0508430190384388, 0.027274535968899727, 0.04897267371416092, -0.09802396595478058, 0.06926918774843216, -0.019380277022719383, -0.10330063849687576, 0.045273732393980026,
    0.010577541776001453, -0.1094275489449501, -0.02567216381430626, 0.05837884545326233, -0.030715469270944595, -0.10576105862855911, 0.09331850707530975, 0.03133775666356087,
    0.021221278235316277, -0.000450086867203936, 0.04318489506840706, 0.00011801728396676481, -0.08620848506689072, 0.031062474474310875, 0.20124419033527374, -0.01105788815766573,
    0.00175985018722713, -0.0672454833984375, 0.04562048241496086, 0.01928144134581089, -0.09979239851236343, -0.035622864961624146, -0.08074097335338593, -0.01921343430876732,
    0.017920810729265213, 0.06434386968612671, -0.040912579745054245, -0.06811326742172241, -0.011957275681197643, -0.013243421912193298, 0.027938958257436752, -0.05844520032405853,
    -0.006880293600261211, 0.08763343095779419, 0.034875016659498215, 0.0046213180758059025, -0.08073142915964127, -0.08211226016283035, -0.04842262342572212, -0.03672841563820839,
    0.0006475797854363918, 0.01971159316599369, 0.06958092004060745, 0.05348016321659088, 0.038289546966552734, -0.045302312821149826, -0.08323420584201813, 0.005870741792023182,
    -0.039263442158699036, -0.014457660727202892, 0.06333877891302109, 0.04387496039271355, 0.006856388878077269, 0.0500611886382103, 0.05670502036809921, -0.013860952109098434,
    -0.06315871328115463, 0.014962737448513508, 0.045661620795726776, -0.05002462863922119, -0.02081073634326458, 0.008627448230981827, 0.04096607491374016, 0.0333019457757473,
    -0.030975718051195145, -0.0289491917937994, -0.15522542595863342, -0.11475671827793121, 0.03069748915731907, -0.05959375575184822, 0.08478441089391708, -0.012877460569143295,
    0.03709661588072777, 0.14294229447841644, 0.03723105788230896, 0.017338573932647705, 0.014807714149355888, -0.11565086990594864, -0.015054473653435707, 0.01673903688788414,
    0.05191020295023918, 0.004851955454796553, 0.18053504824638367, -0.02086067944765091, -0.043455496430397034, 0.04977898299694061, 0.05758792534470558, 0.1523890644311905,
    -0.027450893074274063, 0.006385378539562225, 0.0717664510011673, 0.013567125424742699, 0.13977186381816864, -0.012368333525955677, -0.12856687605381012, 0.09084764122962952,
    -0.027236664667725563, -0.02284862846136093, 0.01100223045796156, -0.044112738221883774, 0.052223097532987595, 0.038251008838415146, 0.05594884976744652, -0.013222148641943932,
    -0.019417092204093933, -0.02770962193608284, -0.168267622590065, 0.05073236674070358, -0.04406559467315674, 0.01586855761706829, 0.032819025218486786, 0.022706303745508194,
    0.10912793129682541, 0.002880876651033759, -0.05402349680662155, -0.023347267881035805, -0.054766520857810974, -0.04177670180797577, -0.09111765027046204, 0.05015672370791435,
    0.057841114699840546, -0.0035765899810940027, -0.04705486446619034, 0.0045810267329216, 0.015987085178494453, 0.06341387331485748, 0.06442346423864365, 0.010000783018767834,
    -0.006302773021161556, 0.015616378746926785, -0.06471250206232071, -0.028988076373934746, 0.06883478164672852, 0.029155859723687172, 0.004383442923426628, 0.04433785378932953,
    -0.06041831150650978, 0.029760288074612617, 0.03741086274385452, -0.002104962943121791, 0.10982299596071243, 0.06792865693569183, -0.2181956171989441, -0.05404999852180481,
    0.018918657675385475, 0.018254082649946213, -0.07164760679006577, -0.01894082874059677, 0.05714442953467369, -0.10709497332572937, 0.05432084947824478, 0.023656122386455536,
    -0.029277006164193153, -0.06895862519741058, 0.00897548720240593, 0.0328013114631176, 0.023776672780513763, 0.02194393426179886, -0.08369401097297668, -0.08059564232826233,
    0.036405812948942184, -0.08362548053264618, -0.002629989292472601, 0.08128513395786285, 0.03184933587908745, 0.016986025497317314, 0.03146382421255112, -0.029509495943784714,
    0.012293869629502296, 0.011006898246705532, -0.07420141249895096, 0.012404682114720345, -0.006696806289255619, -0.06504844129085541, -0.02025109902024269, 0.0052575175650417805,
    0.010769967921078205, 0.07259013503789902, 0.014784831553697586, -0.007332683075219393, -0.018794214352965355, 0.03489140421152115, -0.05997494235634804, -0.0220814049243927,
    0.03231970593333244, -0.044991444796323776, -0.0933639258146286, -0.01397017389535904, 0.054389696568250656, -0.00396229000762105, -0.012587220408022404, 0.026095706969499588,
    -0.12682968378067017, -0.022900260984897614, -0.06878787279129028, -0.0787290558218956, -0.02865253947675228, -0.026879003271460533, 0.00993151031434536, 0.013685218058526516,
    -0.013822479173541069, -0.02954907715320587, 0.029560571536421776, -0.00447060214355588, 0.0014434721088036895, -0.004065895453095436, 0.0044851447455585, -0.09838294982910156,
    0.03599749505519867, 0.09367118775844574, -0.013154624961316586, -0.010110978968441486, -0.012206108309328556, -0.02519129030406475, -0.05678636208176613, 0.07232832163572311,
    -0.06432362645864487, 0.007692735642194748, 0.09866300970315933, -0.011418871581554413, 0.030758608132600784, 0.08860643953084946, -0.003449325216934085, 0.054526861757040024,
    -0.05535658821463585, 0.00469403900206089, -0.05525091663002968, -0.0022809316869825125, 0.0241289883852005, -0.012732542119920254, -0.1063043624162674, -0.028048409149050713,
    -0.010745171457529068, -0.014948047697544098, -0.11956659704446793, 0.015398908406496048, -0.011480433866381645, -0.009514633566141129, -0.048110559582710266, 0.006869947072118521,
    0.01892833597958088, 0.021144473925232887, -0.03235873952507973, -0.040992531925439835, -0.04004224017262459, 0.021915040910243988, -0.07221246510744095, -0.011617341078817844,
    -0.06734808534383774, 0.047130994498729706, -0.033985912799835205, 0.06132016330957413, -0.0361187718808651, 0.03473558649420738, -0.016841741278767586, -0.0409952811896801,
    0.006071053445339203, 0.05592931807041168, -0.0010507294209674, -0.02990289218723774, 0.011919098906219006, 0.03437231853604317, -0.01885189674794674, -0.010866392403841019,
    0.009166231378912926, 0.0034189007710665464, -0.07657314836978912, -0.00895078107714653, 0.06243067607283592, -0.00645399559289217, -0.07520139217376709, -0.002399837365373969,
    0.02090056985616684, 0.012356380932033062, 0.039949946105480194, -0.04432551562786102, 0.011387510225176811, 0.02309328131377697, 0.015476386062800884, -0.026097437366843224,
    0.04242519289255142, -0.007457563653588295, 0.050619080662727356, 0.02197037637233734, -0.040666356682777405, -0.03773604705929756, -0.08400608599185944, 0.017502889037132263,
    0.03172516077756882, -0.07464372366666794, 0.05623389407992363, -0.050290849059820175, 0.07735372334718704, -0.039792779833078384, -0.0020604252349585295, 0.008285337127745152,
    -0.034485772252082825, -0.020025543868541718, -0.008412173949182034, -0.02772657200694084, -0.0036345256958156824, 0.03611738979816437, 0.006983772851526737, -0.018269043415784836,
    0.051703546196222305, 0.01160366926342249, -0.008626125752925873, -0.0182510893791914, 0.014525736682116985, 0.019179267808794975, -0.060256801545619965, -0.005423670634627342,
    0.0833049863576889, 0.001175528159365058, -0.16728642582893372, -0.02802245505154133, -0.026677917689085007, -0.007324813399463892, -0.06593158841133118, -0.0346960611641407,
    -0.05161433294415474, -0.03856801241636276, -0.018471404910087585, -0.045663341879844666, 0.00537467235699296, 0.05798158422112465, -0.0034619264770299196, 0.06029697135090828,
    0.0053503429517149925, -0.08518131822347641, -0.10013945400714874, -0.02453523688018322, -0.10909705609083176, 0.0363495834171772, -0.027946030721068382, -0.04753797501325607,
    -0.03457903861999512, -0.0020799560006707907, -0.11070728302001953, 0.03858713060617447, -0.03214011713862419, -0.01958169788122177, 0.050349004566669464, -0.0428970642387867,
    0.060408033430576324, -0.005565121304243803, 0.06548845022916794, 0.024890093132853508, -0.008995074778795242, 0.025845197960734367, 0.02438655123114586, -0.04007446765899658,
    -0.03773965314030647, 0.004685060121119022, -0.07050184160470963, 0.03134053573012352, -0.012262347154319286, -0.010550212115049362, -0.06413062661886215, -0.0070364573039114475,
    0.08260436356067657, 0.033898018300533295, -0.12376635521650314, -0.03551335632801056, 0.013881403021514416, -0.014619190245866776, -0.06327885389328003, 0.025463055819272995,
    -0.027382051572203636, 0.026007704436779022, 0.043406594544649124, -0.011975964531302452, 0.005680480506271124, -0.016511108726263046, -0.03269871324300766, 0.046649932861328125,
    -0.014978582970798016, -0.013118274509906769, 0.011054444126784801, 0.05188955366611481, 0.01408514752984047, -0.03327232226729393, -0.07707936316728592, 0.03968530893325806,
    0.01305509265512228, -0.013950156979262829, 0.03640279918909073, 0.03315012902021408, -0.01991492137312889, -0.06904434412717819, 0.005690594669431448, 0.024777108803391457,
    0.01161778625100851, 0.02440699003636837, 0.05413273349404335, 0.02216917835175991, -0.04991575703024864, -0.0017399886855855584, 0.16313382983207703, 0.05889952927827835,
    -0.005052577238529921, -0.015908880159258842, 0.03732360526919365, -0.005606852471828461, -0.05285434424877167, -0.026528924703598022, -0.047851257026195526, 0.016952166333794594,
    0.05395441874861717, 0.07775947451591492, -0.06135239452123642, -0.020582133904099464, -0.06774382293224335, -0.039648059755563736, -0.07407029718160629, 0.013031350448727608,
    -0.02663148194551468, 0.03182410076260567, 0.06042899191379547, -0.07346785068511963, -0.0671665221452713, -0.03755441680550575, -0.09343259036540985, 0.0486910454928875,
    0.01184904109686613, 0.02953154966235161, -0.06813538819551468, 0.032515306025743484, 0.02922161854803562, 0.04035494104027748, -0.05823912099003792, 0.013126838952302933,
    -0.01284070871770382, -0.04422340542078018, 0.07197445631027222, 0.005155466962605715, -0.009162730537354946, 0.05238286033272743, -0.014605882577598095, 0.007749153301119804,
    -0.018499692901968956, -0.006374558433890343, 0.011311347596347332, -0.0846320241689682, -0.025027845054864883, -0.005570933688431978, -0.01679403893649578, -0.057129427790641785,
    -0.026642605662345886, -0.06086311489343643, -0.009526516310870647, -0.0722237080335617, 0.037014614790678024, 0.0013429229147732258, 0.03218882903456688, 0.015299822203814983,
    0.018621381372213364, 0.032022278755903244, -0.008625834248960018, 0.026249805465340614, -0.012667596340179443, -0.023320632055401802, 0.020028015598654747, 0.0354648120701313,
    0.026242436841130257, 0.017207656055688858, -0.01374059822410345, 0.016580630093812943, -0.05661676824092865, 0.04548768699169159, 0.04391369968652725, 0.08519233018159866,
    0.0067116753198206425, 0.0038665172178298235, 0.06132257729768753, 0.007379587274044752, 0.07606910169124603, -0.043511342257261276, -0.0995481088757515, -0.00922131072729826,
    -0.09062641859054565, -0.016707133501768112, -0.010282160714268684, -0.007351205218583345, 0.044063881039619446, 0.01242854818701744, 0.10214713960886002, -0.04845860227942467,
    0.005947451572865248, -0.024914994835853577, -0.08531392365694046, -0.013245894573628902, -0.009180689230561256, -0.023276468738913536, -0.006057193968445063, 0.01276130136102438,
    0.036696888506412506, -0.01161367166787386, -0.010649098083376884, -0.019838666543364525, 0.014518627896904945, 0.018019961193203926, -0.08626887947320938, 0.056234557181596756,
    0.016672279685735703, -0.01812279224395752, -0.05963747575879097, 0.036928724497556686, 0.016306739300489426, 0.04280952364206314, 0.013769753277301788, -0.01020162831991911,
    -0.006568527780473232, -0.04035813361406326, -0.01894041709601879, -0.011866489425301552, 0.010027126409113407, -0.02689497359097004, -0.03973254933953285, -0.0056876614689826965,
    -0.025287257507443428, -0.00793115608394146, 0.03448214381933212, -0.011562230996787548, -0.026802219450473785, 0.03282325342297554, 0.09852137416601181, 0.08278838545084,
    -0.015322346240282059, 0.0018399279797449708, -0.06705787777900696, -0.04720819368958473, -0.0019934538286179304, -0.025016287341713905, -0.008878817781805992, -0.010886741802096367,
    -0.031407587230205536, -0.031296443194150925, -0.004871955141425133, 0.02173507586121559, 0.0024615039583295584, 0.021891463547945023, -0.012267336249351501, -0.05689635127782822,
    0.023377282544970512, 0.009312706999480724, -0.03252267837524414, -0.033898111432790756, 0.022118985652923584, -0.03587885573506355, 0.023801734670996666, -0.004757166840136051,
    -0.022220458835363388, -0.04231392592191696, -0.005393776576966047, 0.041096728295087814, -0.08596333116292953, -0.029476169496774673, -0.048102062195539474, -0.0947490930557251,
    0.06680724769830704, 0.024427885189652443, 0.05652223154902458, -0.035076696425676346, 0.027622705325484276, 0.018280887976288795, -0.01339042466133833, 0.0020179920829832554,
    -0.06642112135887146, -0.01102227158844471, 0.11540622264146805, 0.01924581453204155, -0.03327207267284393, 0.008743347600102425, 0.031033610925078392, 0.052239131182432175,
    -0.016078723594546318, -0.025641368702054024, -0.05408548563718796, -0.08832567930221558, -0.018410371616482735, 0.07314403355121613, 0.0024787408765405416, -0.05482994019985199,
    -0.01865900121629238, 0.0343908853828907, 0.05055522918701172, -0.04109525308012962, 0.041600797325372696, -0.09406767040491104, 0.014375009573996067, -0.049684371799230576,
    -0.031573690474033356, -0.014387005940079689, 0.11139924824237823, -0.0036251824349164963, -0.029568582773208618, -0.020673440769314766, -0.09132373332977295, -0.016120420768857002,
    -0.022121472284197807, 0.003436793340370059, 0.01380284782499075, -0.015327420085668564, 0.03651680797338486, 0.023331191390752792, -0.025805115699768066, 0.058559756726026535,
    -0.02025117166340351, 0.014463306404650211, -0.09475518763065338, 0.0025569593999534845, 0.051444124430418015, 0.009687927551567554, 0.04001899063587189, -0.03056802973151207,
    -0.04494037851691246, 0.03073432669043541, -0.09474186599254608, 0.01197818573564291, -0.004535175394266844, -0.010241305455565453, 0.07369744777679443, -0.02983696572482586,
    -0.02906910888850689, 0.016726350411772728, 0.03982768952846527, -0.04193992167711258, -0.004640941508114338, -0.05194593966007233, 0.010172979906201363, -0.013660261407494545,
    -0.058693286031484604, 0.035252951085567474, 0.03050725907087326, 0.007109091617166996, 0.06591883301734924, -0.014369764365255833, 0.03673018142580986, -0.019206486642360687,
    -0.009979389607906342, -0.06141466647386551, -0.0486164353787899, -0.00128141266759485, -0.04278385639190674, 0.0003182492800988257, -0.0022758247796446085, -0.010784539394080639,
    0.016938993707299232, -0.004168687388300896, -0.14581480622291565, 0.009171137586236, -0.0018147751688957214, 0.0057150376960635185, -0.19418023526668549, 0.10514399409294128,
    -0.0013889583060517907, 0.009331087581813335, 0.05285649001598358, -0.03365311771631241, 0.019595922902226448, -0.0345761701464653, 0.03570013493299484, -0.006408200599253178,
    -0.03137572109699249, -0.032036490738391876, 0.01161943282932043, 0.0475618839263916, 0.007241794839501381, -0.05284133926033974, 0.012912746518850327, 0.028736071661114693,
    0.08020841330289841, -0.07835100591182709, 0.03090665303170681, -0.0920068696141243, -0.01610635593533516, -0.0656348392367363, 0.02643182873725891, -0.045936163514852524,
    -0.02865322306752205, 0.05656859278678894, 0.05169278383255005, -0.07861631363630295, 0.04576488211750984, -0.07731195539236069, 0.013318972662091255, 0.03417925536632538,
    -0.07326142489910126, -0.010355259291827679, -0.023909712210297585, 0.027597706764936447, -0.029362302273511887, 0.03340315818786621, -0.04862631484866142, 0.0036669778637588024,
    -0.03587580844759941, -0.03254280239343643, -0.06638626009225845, 0.007110164500772953, 0.013050946407020092, -0.002810200909152627, 0.03891066834330559, -0.029432155191898346,
    -0.01842150092124939, -0.04398801922798157, -0.013013459742069244, -0.05938247963786125, 0.026527948677539825, -0.021707670763134956, 0.07472658902406693, 0.06045178696513176,
    0.01745399832725525, -0.009991355240345001, 0.04028250649571419, 0.03989315778017044, -0.06846442073583603, 0.021850069984793663, 0.008588214404881, 0.048448868095874786,
    0.08780661225318909, 0.032606091350317, -0.023914555087685585, -0.02031623385846615, -0.004198732320219278, -0.01529298909008503, 0.07217743992805481, 0.038568638265132904,
    0.036587923765182495, 0.015394074842333794, 0.11202950775623322, 0.029549429193139076, -0.019000831991434097, -0.0207231305539608, -0.022370457649230957, -0.06792832911014557,
    -0.06315927952528, -0.019379422068595886, -0.0016790092922747135, 0.013570086099207401, 0.007861140184104443, -0.04408963769674301, -0.04394852742552757, 0.013888981193304062,
    0.035671163350343704, -0.036595020443201065, -0.01010834239423275, 0.030419183894991875, -0.0065032863058149815, 0.019797395914793015, 0.0013455988373607397, 0.05428462475538254,
    0.05161293223500252, 0.06242244318127632, -0.03817569091916084, -0.11657290905714035, 0.009375224821269512, 0.001610129838809371, -0.04881091043353081, 0.009159894660115242,
    0.008523818105459213, 0.009168966673314571, -0.04369702935218811, 0.047193244099617004, -0.028907649219036102, 0.0144261559471488, -0.014426895417273045, 0.023763557896018028,
    0.01042237039655447, 0.05271711200475693, -0.030251571908593178, -0.003027839818969369, 0.06800851970911026, -0.004708647262305021, -0.07064478099346161, -0.01847534254193306,
    -0.056050121784210205, 0.009810315445065498, 0.07068611681461334, -0.015673108398914337, -0.05187659710645676, -0.05646774545311928, 0.12934139370918274, 0.02814980410039425,
    0.00890944991260767, -0.012079495936632156, -0.027619559317827225, -0.09713760763406754, -0.02634720876812935, -0.07764557003974915, -0.012207377701997757, -0.013289244845509529,
    0.005045352969318628, 0.04669434577226639, -0.03419370949268341, -0.029836755245923996, 0.019055448472499847, 0.022106295451521873, -0.08600331842899323, -0.05947793275117874,
    -0.05187423154711723, 0.02870665118098259, 0.0731038823723793, 0.02740381844341755, 0.039131056517362595, 0.003086932934820652, 0.00834705401211977, 0.08786021173000336,
    0.02652868814766407, -0.07515134662389755, 0.004156242124736309, -0.03318515792489052, -0.0696592777967453, -0.13152627646923065, -0.05703577399253845, 0.003847808577120304,
    -0.004291800316423178, -0.01356523297727108, 0.01886499673128128, -0.041559912264347076, 0.005389620084315538, -0.02628602646291256, -0.06857431679964066, -0.002902151783928275,
    0.12362217903137207, 0.006642324849963188, -0.20245862007141113, 0.018657948821783066, 0.007146097254008055, -0.013865070417523384, -0.07984744012355804, -0.016543617472052574,
    -0.059285808354616165, -0.03773045539855957, -0.03320557251572609, -0.09047062695026398, -0.0018571295076981187, -0.03985494747757912, -0.002162196906283498, -0.031678374856710434,
    -0.00027756846975535154, -0.06726188212633133, -0.14531594514846802, -0.02538328990340233, -0.017837166786193848, 0.009579955600202084, -0.07045210897922516, -0.057969946414232254,
    0.019629087299108505, 0.11314709484577179, -0.05928731709718704, 0.001874577603302896, 0.03727712109684944, 0.011340649798512459, -0.033302437514066696, -0.004410081543028355,
    -0.013852477073669434, -0.01072821393609047, 0.026072457432746887, -0.02138933539390564, -0.02945655584335327, 0.11566299945116043, 0.0017252860125154257, -0.059594083577394485,
    -0.01277076918631792, 0.027775801718235016, -0.014382570050656796, 0.005887027829885483, -0.027535414323210716, 0.04770389571785927, -0.07816671580076218, -0.046830832958221436,
    -0.05070537328720093, 0.01780516840517521, -0.011119166389107704, -0.01860881969332695, 0.015929503366351128, -0.035384416580200195, 0.007768450304865837, -0.018775777891278267,
    0.027093712240457535, 0.03744323551654816, 0.02226717211306095, -0.07743828743696213, 0.0045854938216507435, 0.0406610406935215, 0.027872074395418167, 0.043516092002391815,
    -0.05686188489198685, 0.014173227362334728, 0.03805215656757355, -0.005253197159618139, 0.03172441944479942, -0.031933095306158066, -0.03966164216399193, 0.03664664179086685,
    0.01605095900595188, -0.022694116458296776, 0.01562950201332569, -0.012734980322420597, 0.0006165218073874712, 0.019992155954241753, 0.009831784293055534, -0.0031297113746404648,
    0.04440921172499657, -0.027692383155226707, 0.048486240208148956, 0.010035298764705658, 0.038293030112981796, 0.0017105768201872706, -0.085149846971035, 0.023876722902059555,
    -0.04311571642756462, 0.04027612879872322, 0.01781219057738781, 0.058718856424093246, -0.03959672898054123, 0.008860706351697445, 0.04764796793460846, 0.021702054888010025,
    0.027523543685674667, -0.002212459221482277, -0.028988000005483627, 0.005563713144510984, -0.07413510978221893, -0.043293289840221405, -0.02848515287041664, -0.03771994262933731,
    0.0712817907333374, -0.008493909612298012, 0.0019170233281329274, -0.02553369849920273, 0.054406873881816864, -0.12350472062826157, -0.1047145202755928, -0.05758461356163025,
    -0.06142601743340492, 0.06336288899183273, -0.10063185542821884, 0.08336672931909561, 0.026888027787208557, 0.10595420002937317, -0.1051420345902443, 0.0396893173456192,
    0.07255902886390686, -0.01038598082959652, 0.10135345160961151, 0.023013178259134293, -0.028346870094537735, 0.07078801095485687, -0.028553226962685585, 0.006823861040174961,
    -0.07456786185503006, -0.05174248293042183, 0.10425953567028046, -0.023733440786600113, -0.07442346960306168, 0.019414542242884636, 0.012296019122004509, -0.027211925014853477,
    0.014890659600496292, -0.03482437506318092, -0.03369927406311035, -0.1068076491355896, -0.06227261945605278, -0.01741449162364006, -0.02371383272111416, 0.003765435190871358,
    -0.050528451800346375, 0.028506530448794365, 0.10192206501960754, 0.018538326025009155, 0.0340721495449543, -0.06885062903165817, 0.07032059878110886, -0.0011470135068520904,
    -0.039020340889692307, -0.08907105773687363, -0.045395150780677795, 0.016827402636408806, -0.05563928186893463, 0.012441140599548817, -0.0027524519246071577, -0.01756932958960533,
    0.033213499933481216, 0.013106764294207096, 0.007986188866198063, -0.03662930801510811, 0.0635434165596962, -0.058778975158929825, -0.04753193259239197, 0.03023461624979973,
    0.0011688091326504946, -0.04421175643801689, 0.012485913932323456, -0.014658954925835133, 0.008919544517993927, -0.025214532390236855, 0.08747787028551102, 0.013921943493187428,
    -0.01639397256076336, -0.039410173892974854, 0.02461865544319153, 0.01777537725865841, -0.029206573963165283, -0.01967177540063858, 0.057625602930784225, 0.014844013378024101,
    -0.0015591381816193461, 0.03291165083646774, 0.03814020752906799, -0.06937645375728607, -0.03505909442901611, -0.035561855882406235, -0.0419369600713253, -0.09420230984687805,
    0.019614441320300102, -0.013365255668759346, -0.009189382195472717, 0.0254196897149086, 0.03392059728503227, -0.0006332450429908931, 0.06706732511520386, -0.00613420782610774,
    -0.0026770643889904022, -0.024978790432214737, 0.02881792187690735, -0.030354158952832222, 0.02469577081501484, 0.02563507668673992, -0.10954882949590683, -0.008949772454798222,
    -0.020648151636123657, 0.014296851120889187, -0.098538838326931, 0.0001810241083148867, -0.002952922834083438, 0.028542209416627884, 0.03984224051237106, 0.06218143180012703,
    0.028017042204737663, -0.012721141800284386, -0.017708247527480125, -0.026497822254896164, -0.058128904551267624, -0.03831757232546806, -0.026336899027228355, -0.017077278345823288,
    -0.02349701151251793, -0.03451026976108551, 0.022331858053803444, -0.0050545018166303635, 0.04949827864766121, 0.019292563199996948, 0.03655512258410454, -0.029317444190382957,
    -0.015135043300688267, -0.0701039731502533, -0.006550569552928209, -0.0761730894446373, 0.03320934623479843, -0.0008407871937379241, 0.044031910598278046, -0.01609579101204872,
    -0.06072717905044556, -0.017392411828041077, 0.02131309174001217, -0.08264024555683136, -0.12463247030973434, -0.035966064780950546, -0.02626129426062107, -0.04404326155781746,
    -0.024521250277757645, 0.055519163608551025, -0.0016139289364218712, -0.003710957244038582, 0.0019088503904640675, -0.013754346407949924, -0.008523643016815186, -0.020022079348564148,
    -0.023651152849197388, 0.037896569818258286, 0.11483854800462723, 0.00037847933708690107, 0.025200042873620987, -0.009459462016820908, -0.03957571089267731, 0.03179699555039406,
    0.05939926207065582, 0.06646150350570679, -0.0020532398484647274, 0.026508668437600136, -0.03195301815867424, 0.045306988060474396, -0.022941259667277336, -0.00023622506705578417,
    0.0010269363410770893, -0.07363124191761017, 0.004975752905011177, -0.01832069829106331, -0.0761585384607315, 0.026327073574066162, 0.015039403922855854, -0.014152447693049908,
    -0.046868689358234406, -0.052487559616565704, -0.03427723050117493, -0.002011488191783428, -0.01730065979063511, -0.06822105497121811, 0.030064962804317474, -0.1343492865562439,
    0.007198472041636705, 0.006336626131087542, 0.007378957234323025, -0.016598662361502647, -0.018851669505238533, 0.030259329825639725, 0.04988384619355202, 0.005654082167893648,
    0.007636622525751591, 0.016376575455069542, -0.10524812340736389, -0.0016226657899096608, 0.009502594359219074, -0.029736751690506935, -0.009244290180504322, 0.013090290129184723,
    0.07029761373996735, 0.08738100528717041, -0.051222968846559525, 0.07087790966033936, 0.01685512624680996, 0.016030438244342804, 0.033482566475868225, -0.02176864631474018,
    -0.040149521082639694, 0.07347409427165985, 0.020171578973531723, -0.02356971800327301, 0.0452493317425251, 0.05004371330142021, 0.04260618984699249, 0.04293305054306984,
    -0.05005129426717758, -0.005878254771232605, 0.07732688635587692, 0.0006978004821576178, -0.014026368036866188, -0.06231579929590225, -0.015940774232149124, -0.013386627659201622,
    -0.01891164481639862, -0.04362105950713158, -0.006657930091023445, 0.06447658687829971, -0.010514375753700733, -0.0393659844994545, 0.004173139110207558, -0.03164629265666008,
    -0.02940596453845501, -0.007844872772693634, 0.07884560525417328, -0.007071676664054394, -0.03895165026187897, -0.0026034859474748373, 0.0979645848274231, 0.008048776537179947,
    -0.05655413120985031, -0.034675054252147675, 0.024796107783913612, 0.04374419152736664, 0.011655216105282307, -0.013138877227902412, 0.0072908601723611355, -0.01006237231194973,
    0.020484311506152153, 0.058618951588869095, 0.030757885426282883, 0.03313615545630455, 0.004579159896820784, -0.008989090099930763, 0.006064377259463072, 0.06238497048616409,
    0.008380383253097534, 0.03337791934609413, 0.04402361810207367, 0.02583853155374527, -0.02311975136399269, -0.09199559688568115, -0.026951884850859642, 0.02363055758178234,
    0.0754995048046112, -0.00895621720701456, 0.1535426825284958, 0.006263586692512035, 0.039525482803583145, -0.12162817269563675, -0.014243309386074543, 0.00688639422878623,
    -0.01720341108739376, -0.04757126048207283, -0.017393581569194794, 0.005259684287011623, -0.00519793014973402, 0.00011998622358078137, 0.010013227351009846, 0.006276676431298256,
    0.07452984899282455, -0.05965520441532135, -0.1646014302968979, -0.03772502765059471, 0.020549437031149864, 0.007628453429788351, 0.055539168417453766, -0.007613028399646282,
    -0.08203031867742538, -0.057335615158081055, -0.06940872222185135, -0.08975604921579361, 0.014661205932497978, -0.14424636960029602, 0.05294002965092659, 0.017609508708119392,
    0.06640934944152832, -0.004931602627038956, -0.05364297702908516, 0.018767766654491425, 0.04826289042830467, -0.05461535602807999, -0.020757893100380898, -0.038717351853847504,
    0.08287476003170013, 0.1896265596151352, 0.16829535365104675, 0.0005420259549282491, 0.02103983797132969, 0.05828630551695824, -0.026999130845069885, 0.13214637339115143,
    -0.033130623400211334, -0.008366942405700684, 0.04222235456109047, -0.0016415368299931288, -0.06077504903078079, 0.022690586745738983, -0.045536305755376816, -0.036325253546237946,
    -0.05362049862742424, -0.010623553767800331, 0.027450745925307274, 0.005825607106089592, 0.01024997141212225, 0.05055978149175644, -0.05608604475855827, -0.012583472765982151,
    -0.05756470188498497, -0.06468133628368378, 0.05343734100461006, -0.049212001264095306, -0.011621898040175438, -0.02572011761367321, -0.02517407014966011, 0.012324996292591095,
    0.10662131011486053, -0.04488430172204971, -0.022655921056866646, -0.06363477557897568, -0.0010254960507154465, -0.005381711293011904, -0.04615754261612892, 0.005837456323206425,
    -0.002121653174981475, -0.0049894340336322784, -0.02912604995071888, 0.025822456926107407, -0.01813061721622944, -0.014886952005326748, -0.050782449543476105, 0.037766944617033005,
    0.01983240246772766, 0.07782663404941559, -0.0024151229299604893, -0.056751757860183716, 0.027492500841617584, 0.03499852120876312, -0.046681806445121765, -0.02574215829372406,
    0.00939901638776064, 0.004899243824183941, -0.03528360649943352, -0.00371990236453712, 0.013999930582940578, 0.015225845389068127, -0.17678236961364746, -0.1100936010479927,
    0.03751012682914734, 0.04179253801703453, 0.0023101724218577147, -0.06870637089014053, 0.05540943518280983, -0.041811276227235794, 0.03153304010629654, 0.031965091824531555,
    0.012910480611026287, 0.018216853961348534, -0.07291065156459808, -0.023361699655652046, -0.05991698056459427, 0.013197241351008415, -0.08840090781450272, -0.050004977732896805,
    -0.016555605456233025, -0.041437335312366486, -0.029405755922198296, 0.13651566207408905, 0.08459552377462387, -0.026943663135170937, -0.03891174867749214, -0.01654471457004547,
    0.019724372774362564, -0.004687091801315546, 0.028729373589158058, 0.016240455210208893, -0.031143715605139732, 0.0993414968252182, -0.08459078520536423, -0.055306535214185715,
    -0.02347739227116108, 0.004984936211258173, -0.005472590681165457, 0.00011426688433857635, -0.003148548537865281, -0.012996893376111984, -0.008946633897721767, -0.00658292043954134,
    0.01731921173632145, 0.0005618409486487508, -0.0198968518525362, 0.007374296896159649, 0.004328225273638964, 0.0034165694378316402, -0.009584933519363403, -0.035782355815172195,
    0.02296300232410431, 0.016627421602606773, -0.004700952675193548, -0.04479816183447838, 0.0192741546779871, 0.015340692363679409, -0.014493495225906372, 0.006612589117139578,
    -0.015341761521995068, -0.014822021126747131, 0.010255897417664528, 0.0050584557466208935, 0.007283526938408613, -0.006376135628670454, 0.0020691656973212957, -0.004880658816546202,
    0.003891725093126297, -0.021040596067905426, 0.021073712036013603, -0.007637286093086004, 0.014629597775638103, -1.737415004754439e-05, -0.012508098967373371, -0.0073372176848351955,
    -0.020905937999486923, -0.0017286122310906649, -1.835128664970398, 0.03769497573375702, -0.0037818385753780603, 0.01227560918778181, 0.03522762283682823, 0.00488619226962328,
    -0.0114753944799304, -0.0030286090914160013, 0.01756061054766178, -0.0013834199635311961, -0.027843043208122253, -0.0001867145620053634, -0.012950359843671322, -0.025175390765070915,
    -0.010952908545732498, -0.009104161523282528, 0.014643805101513863, 0.016532743349671364, 0.006216408684849739, 0.003465836402028799, -0.001560034230351448, 0.0008900988032110035,
    0.008588290773332119, 0.011698361486196518, 0.3335556089878082, -0.01202467456459999, 0.001552582485601306, -0.023899216204881668, 0.007620641496032476, 0.020168185234069824,
    -0.0017067865701392293, -0.0036185369826853275, 0.0011297848541289568, -0.005775551311671734, 0.002600178588181734, -0.007815448567271233, 0.001214291318319738, 0.026932479813694954,
    -0.0030952352099120617, -0.0294389259070158, -0.013401230797171593, 0.006339362356811762, 0.008806126192212105, -0.002917814999818802, -0.0010535235051065683, -0.041476670652627945,
    -0.013183907605707645, -0.005514876917004585, 0.05576124042272568, -0.0060819340869784355, -0.007033322937786579, 0.003450947580859065, -0.061373427510261536, -0.02294125035405159,
    -0.002203133190050721, -0.01128014549612999, -0.0016745623433962464, -0.015704259276390076, 0.012381507083773613, 0.01448804046958685, -0.014018370769917965, -0.001315986504778266,
    -0.031246988102793694, -0.002108270302414894, 0.006734955124557018, -0.0021201791241765022, 0.032484252005815506, 0.0028449995443224907, -0.03890279307961464, -0.01764485612511635,
    -0.007846970111131668, -0.01040720846503973, -0.047179561108350754, 0.007772847078740597, 0.018716856837272644, 0.003669025609269738, 0.0028339321725070477, 0.048088837414979935
};


#endif /* USE_WEIGHTS_FILE */

#ifndef USE_WEIGHTS_FILE

#define WEIGHTS_conv1_bias_DEFINED
#define WEIGHTS_conv1_bias_TYPE WEIGHT_TYPE_float
static const float conv1_bias[128] = {
    -0.0021441238932311535, -0.32894864678382874, 0.09548183530569077, -0.30722156167030334, 0.28018200397491455, -0.35030078887939453, -0.19236907362937927, -0.2450951337814331,
    0.10864613950252533, -0.02748776786029339, 0.13079126179218292, -0.6387170553207397, 0.23359063267707825, -0.14069239795207977, 0.14451104402542114, -0.11523749679327011,
    0.33384713530540466, 0.060028091073036194, -0.13359297811985016, -0.17811566591262817, 0.17996005713939667, 0.4259227514266968, 0.3273550271987915, -0.1197161078453064,
    -0.26417630910873413, 0.07536523044109344, -0.024235544726252556, -0.3227907121181488, -0.2686856687068939, -0.007399209309369326, -0.26041069626808167, -0.18261554837226868,
    0.16164462268352509, 0.16191230714321136, 0.31314563751220703, 0.15133991837501526, -0.14591442048549652, -0.05618444085121155, 0.6011706590652466, 0.329529345035553,
    0.3523726463317871, 0.09686905890703201, 0.09319829195737839, -0.6119627952575684, 0.10020100325345993, -0.10926293581724167, -0.03922334685921669, 0.04302043840289116,
    -0.5074126720428467, -0.028295928612351418, -0.5935019850730896, -0.023198291659355164, -0.14094604551792145, -0.008021144196391106, 0.08842893689870834, -0.1755257248878479,
    0.13267840445041656, 0.07291877269744873, -0.24180980026721954, -0.7479541897773743, 0.0525679849088192, -0.38836637139320374, -0.04670443385839462, 0.11987932026386261,
    0.06387653201818466, -0.0868774801492691, -0.46548810601234436, -0.10940950363874435, 0.6245565414428711, -0.2369976043701172, 0.08499311655759811, -0.039595313370227814,
    0.22481967508792877, -0.22933238744735718, 0.09819784015417099, 0.1755608320236206, -0.07843621075153351, -0.1453576683998108, 0.08699674159288406, -0.7278136610984802,
    0.01486196368932724, 0.17800961434841156, -0.03768044710159302, 0.04501029849052429, -0.1626548171043396, 0.11898687481880188, 0.07406405359506607, -0.3819321393966675,
    0.06748077273368835, -0.2665127217769623, 0.02572854794561863, 0.12904220819473267, 0.010346265509724617, 0.001505914842709899, -0.00301871495321393, -0.02486334927380085,
    0.2770117521286011, -0.0598481185734272, 0.7939623594284058, 0.0701214149594307, 0.15011394023895264, 0.10847894102334976, -0.0701068863272667, -0.0012198480544611812,
    0.14812500774860382, -0.7519547343254089, -0.43431568145751953, -0.1488315761089325, -0.1485626995563507, -0.18851780891418457, 0.17886225879192352, 0.20893554389476776,
    -0.03620041534304619, 0.34974226355552673, 0.1550222784280777, -0.6523941159248352, -0.06996989250183105, -0.18372464179992676, -0.025671282783150673, 0.17935633659362793,
    -0.09095382690429688, 0.0013547145063057542, 0.007670638617128134, -0.2891836166381836, -0.2756224572658539, 0.13725140690803528, -0.30796191096305847, -0.3711496591567993
};


#endif /* USE_WEIGHTS_FILE */

#ifndef USE_WEIGHTS_FILE

#define WEIGHTS_conv2_weights_int8_DEFINED
#define WEIGHTS_conv2_weights_int8_TYPE WEIGHT_TYPE_int8
static const opus_int8 conv2_weights_int8[147456] = {
    -5, 52, 3, -12, -11, 1, 10, 15,
    -9, 3, -22, 26, 0, -5, -8, -8,
    22, -3, -4, -10, 18, -3, 8, -16,
    -16, -11, -7, -6, 3, 8, 10, -9,
    28, -10, 24, -9, -23, 23, -36, 2,
    -22, 9, -4, 17, 4, -3, -3, -4,
    4, -1, 0, 12, 8, 0, 13, 24,
    14, -6, 1, 6, -5, 4, 14, 0,
    8, 13, 21, -19, 0, 2, 6, -20,
    -4, 2, -16, -2, 9, -3, 3, -3,
    14, -2, -10, 2, 8, 2, -25, -12,
    18, -6, 14, -12, -9, 18, 24, -2,
    7, 12, -16, -7, -14, -17, 16, -47,
    27, -11, 20, 14, -2, -3, 1, 4,
    17, -4, -8, -17, -18, 5, 12, -20,
    -7, 1, -11, 7, -25, 0, 8, 18,
    46, -31, -9, 17, 24, -5, 1, -1,
    -15, 12, 1, -4, -3, 2, 0, 1,
    18, 6, -9, 7, -32, 29, 17, -28,
    10, 5, 11, 17, 8, 1, 8, 17,
    -11, -26, -11, -12, -15, -30, 10, 37,
    6, 30, 2, 14, -6, 3, 0, 1,
    -18, 9, 19, 7, 26, 19, -28, -18,
    15, -6, 0, -10, -6, -15, 8, 0,
    2, -3, 30, 21, -17, 0, 6, -46,
    -11, -23, -12, -10, -3, 1, 0, -12,
    7, -17, 4, 0, 11, 21, -4, -9,
    2, 0, -3, 9, -4, 18, 16, 3,
    4, -13, -42, 3, 23, 14, 6, -1,
    -1, -30, 3, -29, 0, -1, 1, -3,
    -18, -4, 12, 8, -25, 24, 14, -11,
    4, 4, -9, -5, 30, 7, -27, 27,
    15, 18, 28, 1, 4, 11, -33, 18,
    -25, 0, -3, 37, 1, -4, 7, 6,
    -8, 5, -16, -7, -32, 4, 14, -3,
    -8, 8, 9, -4, 9, -7, -6, -19,
    -3, -21, -4, 4, 10, -1, 32, 1,
    -18, -35, -17, -7, -3, 1, 5, -1,
    8, -11, -22, 13, -31, -34, 4, -33,
    8, 14, -6, -3, 26, 27, -7, -3,
    -18, 16, -36, 3, 0, -13, -4, 12,
    27, -20, -19, -8, 3, 3, 3, -6,
    -5, -1, -5, 8, 40, -15, 12, -2,
    1, 7, 6, 3, -6, 6, 10, -19,
    59, -36, 12, 42, 32, -18, -8, -8,
    -10, 3, -37, 0, 4, -4, 1, -5,
    -1, -3, -4, 5, 11, 15, -13, 2,
    -3, 4, 6, -19, 13, 10, 11, -3,
    6, -10, 20, -8, -8, 14, -7, 9,
    3, -39, -7, 14, -3, 1, 1, 2,
    -39, -5, 2, -1, 18, 15, 0, 14,
    0, -5, 8, 2, 14, -1, 6, 6,
    -8, -15, -43, -37, 6, -16, 23, -13,
    33, 38, -13, 45, 3, -1, 6, 3,
    -4, 6, 11, 9, 17, -5, -8, 3,
    -3, 7, 3, -5, -39, -19, 28, -37,
    -2, -3, -6, -14, -36, 13, 26, -16,
    4, -1, -19, -33, -1, 2, 5, -23,
    24, -26, -1, 11, 20, 6, -11, 5,
    14, 2, 3, 4, -17, 2, -1, -13,
    -7, 4, 13, -1, -34, 38, 7, -23,
    -3, -57, 6, -14, 1, -9, -3, -1,
    -9, -28, 8, 1, 1, -26, 15, -2,
    -4, 4, -2, -4, 15, 33, -10, -4,
    2, 7, -3, 13, -6, 18, 4, 2,
    -1, 25, 8, -32, 3, -5, 2, -1,
    11, 2, 1, 1, 17, -1, 3, -35,
    6, -3, 3, -4, 0, 18, -27, 5,
    5, -27, -7, -31, -11, 13, -23, -54,
    -22, 1, 11, -23, 74, 11, 0, -2,
    7, 5, -5, -22, 18, 26, 4, 12,
    -4, -8, 8, 9, -15, 3, -25, 4,
    -9, 44, 20, -29, -31, 25, -18, 0,
    7, -14, 8, -18, 4, -1, -3, 1,
    6, -4, -12, 1, -23, -1, -1, -15,
    8, -18, -2, 37, 4, -2, -3, 20,
    -3, -1, 16, 4, -25, -12, 7, -7,
    5, -5, -1, 8, -1, -5, 2, 0,
    4, -18, 0, 20, 26, -1, 8, 5,
    -14, -2, 18, -2, 12, -1, -6, 5,
    -18, -42, 33, 8, -5, -5, 8, 17,
    31, 11, -47, 3, 7, 9, -3, 5,
    -10, 12, -2, 11, -14, 28, -29, 21,
    0, -6, -9, 7, 26, -16, 0, -5,
    10, 16, 12, -13, -28, 7, 22, -27,
    -5, -22, -4, -18, -1, -2, -4, -9,
    15, -4, -3, 3, -17, 14, -28, 8,
    -4, 4, 15, 0, 5, 6, 14, 0,
    48, 22, 10, -11, -17, -17, 18, -17,
    -14, 13, 5, 22, 2, -3, 4, 2,
    -1, 5, 32, 13, -1, -16, -24, -2,
    -8, 5, -19, -6, -2, -3, 16, 7,
    -32, -9, 4, -15, 14, 7, 18, -43,
    38, 1, -27, -27, -1, 2, -2, -3,
    -4, -1, -8, -17, -7, -10, 5, 8,
    0, 0, 2, -8, 6, 26, -27, -9,
    -19, 31, -8, -15, -16, 7, -14, -10,
    -40, 2, -3, 22, 1, -3, 4, 5,
    4, -7, 0, -7, -35, -18, -4, -13,
    -4, -1, -3, 6, 20, 15, -10, -8,
    -25, 13, -24, -11, -11, 19, 14, 11,
    -23, 10, -1, -3, 2, 7, 0, 0,
    6, -5, -6, -7, -12, 13, 34, 1,
    -7, 0, -1, 15, 3, -13, 4, 1,
    8, -9, -10, 17, -16, 7, -9, -34,
    -7, -13, -7, 2, 0, -31, -6, -2,
    17, -10, 8, 22, -13, 3, 12, 33,
    -1, 7, 8, -8, -8, 16, -5, 14,
    9, 11, 5, -14, 10, 11, -23, 21,
    -5, 3, -60, -13, 1, -4, -2, 2,
    4, 10, 12, -19, -3, -24, 7, 20,
    14, 3, 1, -5, -36, 16, -4, -14,
    -29, -8, -2, -15, 10, -5, 11, -3,
    41, 23, 26, 4, -1, -1, -3, -4,
    7, -21, 2, 0, -10, -3, -6, -6,
    -11, 1, -2, 1, -14, -27, 1, 4,
    9, -16, 30, 11, -5, -6, 34, 13,
    3, -21, 11, -4, 2, -3, 0, 1,
    -3, 5, -6, -10, 26, -4, 7, 5,
    -2, 0, -4, -1, -31, -13, -1, 0,
    7, 18, 10, -12, 26, 8, 3, 7,
    -20, -23, -29, -2, 6, -4, -8, -2,
    -1, 15, -3, -7, 18, -13, 4, -3,
    11, 8, 0, 9, 13, -14, 5, 19,
    -29, 48, -42, 9, 3, 4, 6, -18,
    -4, -17, -11, 2, 3, -4, -8, -6,
    9, -18, 3, 22, 25, -5, 13, 13,
    8, -15, -3, 2, 4, -10, -3, 7,
    -16, -25, 13, 29, 10, -10, -14, -19,
    39, -26, -25, -25, -2, 0, 6, -5,
    4, 3, 12, 6, 12, -10, -29, 26,
    21, -1, -2, -12, -20, -31, -22, -3,
    5, 36, 3, 6, 10, 0, -12, -21,
    -40, -38, 11, 3, 0, -1, 5, -4,
    8, 5, 11, -1, -16, -8, -26, 25,
    33, -11, 13, -2, 24, 19, 17, -4,
    -20, 16, 0, -2, -15, 8, -7, -11,
    9, 4, 35, -26, 4, -1, 5, -13,
    11, 13, 23, 2, 46, -37, -2, -11,
    20, -22, 15, -8, 8, -32, -3, 8,
    -8, 1, -42, -21, -18, 19, 18, -21,
    8, 58, -12, 22, 1, -5, -2, 4,
    3, -16, -6, -33, 4, -3, 22, 19,
    5, -15, 4, 5, 21, -15, -5, -1,
    -26, -13, -15, 5, -18, 21, 9, 16,
    -13, 33, 17, 22, -2, 0, -1, 1,
    13, 1, 10, 13, 35, -30, 0, 23,
    5, -25, -1, 27, 14, -16, -11, 6,
    -39, -18, -11, 47, -12, -21, -6, -22,
    6, 18, -11, -3, -7, 3, -4, 3,
    -20, 5, 5, -3, 15, 9, 6, 12,
    0, 9, 15, -22, -26, -42, 26, -5,
    14, 5, 41, -6, -24, 45, -7, -25,
    -11, -5, 32, -8, 2, 1, -2, -7,
    -4, -4, 1, 6, 11, -27, -6, -3,
    18, -1, -23, 32, 16, -6, -4, 13,
    -5, 7, -2, -51, 10, -25, 27, 8,
    -30, 15, 12, 29, 0, -2, 11, 3,
    14, -31, 8, 18, 30, 7, -21, 11,
    20, 4, -7, 7, -55, 38, 15, 23,
    21, 15, 8, -11, 10, -18, 37, 6,
    -2, -24, 20, -22, 3, -8, 5, 2,
    -11, 2, -16, -3, -11, -5, -14, -19,
    -7, 10, 5, -5, 1, -4, -4, 5,
    -11, 6, -1, -35, -10, -14, -3, -8,
    36, 29, 14, 6, -2, -7, 6, 1,
    -1, 0, -58, -3, -4, -18, 11, 18,
    -22, -9, 8, 0, -14, 17, 7, 27,
    23, -2, -14, -3, -9, 2, -4, 1,
    14, -5, -3, -17, 8, 3, -1, -2,
    -1, 4, -6, 10, -21, 1, -13, 15,
    4, 17, 10, 7, 15, -1, 3, 17,
    29, 18, -13, -23, -20, -22, 16, -6,
    -8, -48, 4, 26, 4, -2, 3, 10,
    0, -24, 5, 1, -10, -8, 7, 11,
    30, -3, 9, -14, 34, 14, -4, -17,
    12, -42, 2, -10, -19, 11, -3, 9,
    21, -23, 7, 10, 2, -1, -2, 3,
    -35, -1, -1, -16, 31, 30, -1, 1,
    -6, 0, 0, 15, 15, -27, -11, 15,
    -10, 36, 23, 16, -3, -5, -16, 29,
    24, -22, -2, -43, -1, 1, 1, 5,
    2, -9, -3, -1, -2, -27, -5, -15,
    10, 12, 8, -4, 15, -16, 16, -4,
    20, 2, 0, -19, -37, 49, -4, -12,
    4, 13, 24, 3, 1, 3, 4, -18,
    5, -22, 18, -1, 3, -4, -13, 6,
    24, -5, 28, -1, -33, 16, -18, 10,
    1, 6, 3, 4, 10, -30, 0, 24,
    21, 3, -26, 43, -1, -1, -1, -1,
    -7, -39, 1, 16, 16, -39, -5, 3,
    -6, -2, -15, 18, -7, 5, -5, -23,
    -24, 8, -39, -14, -30, 3, -10, 32,
    32, 5, -9, -1, 1, 8, 4, -7,
    7, -1, 3, -17, -13, -7, -6, -21,
    -27, 2, 10, 4, -58, 10, -17, 34,
    14, 5, 31, 0, -25, -26, -38, -13,
    -31, -22, -6, -18, 67, 15, 1, -1,
    -5, 4, -18, -22, 1, -2, 5, 3,
    -4, -2, -1, -5, -13, 8, -15, 3,
    28, -24, 11, 22, -31, 39, -3, -3,
    58, -13, 13, -26, 1, -2, -3, 1,
    15, -11, -11, -10, -29, 1, 13, 12,
    -29, -2, -8, 36, -44, -15, 8, -33,
    0, -52, 10, 8, -10, -13, 19, -23,
    64, -13, 1, -4, 3, 0, 0, -5,
    5, -11, 9, -8, 2, 57, 28, 1,
    9, 12, 49, 9, 7, -10, -6, 9,
    -7, 11, -26, 29, 38, -47, -12, 13,
    50, -22, 27, -4, 2, 4, -4, 6,
    -39, 10, 2, -14, -20, -13, 67, 47,
    24, -34, -1, 43, 9, 26, -27, 3,
    -35, -6, 36, 27, 11, 23, -18, 1,
    -5, 52, -48, 18, 4, -1, -2, 3,
    42, 2, 9, 0, -31, 12, 26, 21,
    1, -28, 24, -10, -24, -22, -3, 2,
    -11, 56, -38, 42, -14, 5, 23, 12,
    -15, -7, -24, 25, 2, -1, -1, -2,
    -3, -8, 20, 1, -15, 15, -1, -2,
    -13, 1, -15, 5, -11, 42, -13, 0,
    -8, -28, -74, -23, -10, -34, 5, -28,
    -33, 18, -11, -13, -1, 2, 4, 0,
    -8, 9, -11, 4, 8, 57, 35, 13,
    13, 30, -4, -19, -18, 31, 6, 34,
    -23, -10, -21, -25, 21, -7, -20, -7,
    76, 1, -8, -6, 2, -1, 1, 4,
    -5, -17, 4, -13, -43, 16, -17, 31,
    -3, -4, -4, 11, -16, 9, -26, 10,
    -14, 30, -2, -5, -1, -3, 0, 5,
    8, -21, -11, -22, 3, 5, 2, 2,
    -4, 20, 0, -2, 4, -10, -1, -4,
    -37, -17, 8, 13, 0, -3, 16, 9,
    -1, 4, 2, 9, -1, -16, -16, -22,
    16, -12, -5, 5, 2, -34, -8, -1,
    3, -18, -1, -12, -22, -18, -8, -26,
    -1, 9, 2, -5, 26, 11, -3, 38,
    -28, 20, 7, -7, 18, 5, -18, -42,
    -23, 7, 33, -8, -5, -4, -1, -2,
    -8, 8, 21, -19, 7, -13, -14, -15,
    20, -18, -17, -10, 20, 43, -29, -9,
    18, 6, 13, -15, -27, -21, 17, 11,
    -80, -6, 16, 15, 5, 4, -8, -2,
    -11, 21, 10, -3, 6, -21, -2, 17,
    -17, 18, -3, -3, 3, -6, -5, 5,
    -14, 16, -15, 1, 6, 6, -1, -23,
    -33, 17, 10, 21, 0, 0, 1, -1,
    -5, -10, -11, -3, 21, 2, 17, 18,
    23, 9, 20, -26, -24, 50, 9, 3,
    11, 40, 5, 38, 1, 1, -15, 22,
    1, -34, 18, 3, 9, 6, 1, -3,
    -16, 9, 11, -3, 25, 5, -2, 7,
    20, -35, -15, 1, 26, -32, 2, 0,
    -21, -49, 18, -34, -13, -18, -20, -3,
    -11, 28, -28, 10, 3, -4, -5, 0,
    -21, -24, 22, 36, 7, 21, 27, 18,
    30, -69, 0, 27, 25, -2, -27, 15,
    16, 20, -10, -57, -72, -24, -26, 20,
    40, -57, -6, -22, 3, 1, 3, 1,
    31, -57, 11, -16, -1, -45, 12, -38,
    73, 1, 10, -10, 36, -3, -21, 5,
    -74, 30, -53, -9, 42, -3, 40, 19,
    -10, -56, -7, -30, 13, -4, -2, 0,
    43, 3, 8, 4, -43, -23, -3, -36,
    57, -29, 31, -15, -13, 13, -3, -9,
    -49, -36, 25, 7, -48, 0, 15, 3,
    8, 1, -11, -29, 12, -1, -1, -14,
    14, 24, 18, -4, 5, -32, -27, 0,
    18, -51, 12, -10, 0, 28, -17, 11,
    12, -52, 45, 4, 20, 25, 2, -11,
    -2, -76, -13, -45, 2, -8, 11, 0,
    -6, -4, 27, -26, 21, 52, -43, 18,
    -2, -52, 19, -1, 7, -11, 28, -26,
    18, -7, 15, -22, 36, 15, 8, -16,
    -20, -5, 19, 25, 10, 1, 3, 4,
    22, 9, -2, -19, 39, 2, 26, 24,
    8, -64, 1, 53, 47, 19, 10, 13,
    0, 35, -49, -2, 44, 85, -12, 5,
    -25, -23, -33, -1, -5, 0, 1, -6,
    -31, -24, 41, -57, 5, -21, -10, 9,
    -9, 12, 27, -72, 15, 53, -17, -2,
    -53, -33, -20, 5, -19, 21, -66, -4,
    -40, -16, -44, 16, -5, 1, -1, -21,
    -1, 15, 2, 9, 17, 4, 20, -13,
    59, 19, -46, 71, 25, -5, -7, -13,
    26, 47, -10, -17, 3, 36, -5, 25,
    24, 63, 16, 30, -2, -4, 8, -14,
    -24, -15, 9, -2, -30, -42, 2, 8,
    43, 8, -32, 12, 74, -35, -2, 28,
    -42, 14, 66, 26, -33, 41, -18, 5,
    78, 8, -58, -11, 1, -16, 10, 0,
    -30, 11, -38, 4, -15, 11, 24, 31,
    -17, 18, -14, -8, 3, 8, 32, 18,
    -77, -49, -22, -12, -14, 23, -71, -55,
    -12, -28, -8, 20, -18, -20, 5, 7,
    10, 14, -58, 16, 22, -3, -11, 13,
    -38, -18, -4, -24, 10, 4, -37, -76,
    39, -10, 12, -10, 33, 9, 7, -16,
    -8, 27, -16, 50, 9, 9, -6, -1,
    -16, 4, -18, 10, -35, 51, 24, -2,
    -14, 39, -1, 1, 31, 4, -7, -4,
    -31, -22, 8, -25, -35, -18, 42, 48,
    -38, 31, 60, -26, 5, 4, 2, -1,
    13, 12, -17, -5, -50, -21, -2, 53,
    49, -45, 9, -54, 36, -6, 15, -10,
    19, 49, 31, 35, -10, 54, 13, -33,
    48, 10, -41, -88, -5, 8, -5, -14,
    -76, -20, -2, -8, 4, -51, 16, 10,
    9, -12, 0, 55, 19, 22, 16, -1,
    -3, -32, -57, -34, -2, -6, -46, -73,
    1, 27, 51, 43, -5, -2, 4, 3,
    -15, -5, -4, 13, 43, -17, 72, 17,
    -17, 24, 32, -26, -19, 17, -70, -10,
    -29, -40, -13, 17, 13, -28, -24, -25,
    13, -28, -16, 25, -4, -1, 0, -20,
    -22, -11, 22, 8, -32, 24, 52, 5,
    75, 1, 55, -4, 8, -32, 14, -25,
    25, 50, -12, -27, 27, -44, -40, -24,
    -45, 91, -40, -4, 6, -2, -8, -4,
    10, -127, -2, 25, -21, 0, 34, 29,
    -6, -22, -10, 24, 8, -7, -24, -41,
    -65, 18, 87, -13, 2, -5, -29, 38,
    -36, 0, -37, 17, -11, 11, -6, -5,
    21, 1, -19, 10, -23, 8, -3, 45,
    -66, -1, 6, 6, 25, 8, 6, -1,
    42, -13, -34, -77, -6, 11, 8, -89,
    -17, 31, 8, -14, 93, 36, -2, 3,
    -21, -7, -14, -27, -26, 38, 72, 10,
    -18, -6, 9, -6, 18, -1, 12, -24,
    23, -19, -17, -3, -15, -16, -9, -43,
    -76, -7, 21, -18, 2, -3, -4, 1,
    37, 6, -8, -17, 11, -39, 29, -22,
    -64, 20, -16, 60, 58, 30, -4, 18,
    -4, 21, -1, 42, -6, 8, -37, 36,
    -38, 51, -38, 6, -8, 2, 16, -28,
    -25, -11, -10, -5, 7, -41, 2, 20,
    37, 13, 76, 10, -78, -51, -3, -4,
    -31, -42, 46, -52, -46, -50, 15, 0,
    -15, -6, 101, -21, -3, 5, -1, -3,
    -55, 13, -10, -26, -8, 39, 5, -50,
    42, -93, 4, 74, 25, -32, 7, 6,
    25, -13, -79, 14, 40, 20, -4, -9,
    42, 25, 53, -34, -1, 10, 5, -13,
    28, 26, -15, -1, 11, 26, -39, 7,
    12, -96, 40, -17, 26, -1, 34, 24,
    -35, -22, -34, 2, 31, -5, 21, -3,
    -32, 53, -24, -11, 7, 1, -3, 5,
    -10, 14, 15, 50, -48, 45, 36, -3,
    -34, 8, -24, 20, 17, -26, -3, -1,
    20, 57, 69, -6, 19, 31, -18, 21,
    -16, 43, 33, 13, -7, 0, -5, 3,
    -5, 39, -40, 7, -52, -67, -42, -16,
    20, 74, 0, -59, -15, -76, -40, 23,
    14, 13, 44, 17, 55, -26, -22, 24,
    42, 11, -49, 11, 5, -3, 1, -2,
    8, -32, -19, -22, 111, 18, 44, -19,
    -8, 5, -7, 2, 34, 20, -12, 12,
    61, -23, 22, -21, 3, 21, 8, 14,
    44, 6, 4, 30, 0, 2, 7, -1,
    -7, -6, 0, -5, 79, -6, -31, 7,
    -60, -48, 7, 4, 33, 25, -33, -7,
    -59, -29, 80, -19, 45, -20, 4, -1,
    -14, -13, 57, 19, -5, -53, -18, -1,
    12, -11, 5, -12, 31, 30, 39, -49,
    1, 11, 0, -17, 10, -20, -10, -24,
    -26, 10, 15, 18, 8, -47, -17, 2,
    4, 7, 24, -25, -3, -1, -4, -6,
    5, -6, -9, -31, -10, 18, -44, -46,
    12, -11, 4, -9, -4, 5, 40, -9,
    -48, 41, -2, 25, 32, 2, 8, -18,
    -16, 28, 12, -33, -6, -4, -5, -3,
    24, -14, -1, -5, 13, -7, 4, 15,
    -44, 51, 0, 3, 29, 35, 9, -14,
    36, 27, 36, 20, 14, 25, -20, 18,
    5, -16, -33, -61, 1, 6, -2, 12,
    -83, 42, 7, -17, -14, 8, -8, -15,
    46, 8, 43, -41, 4, -79, 38, -3,
    -2, -70, -12, -1, 55, 13, -13, -9,
    -3, -41, 9, 39, 1, 5, 5, 9,
    -10, 10, -8, 7, -80, 10, -37, -40,
    17, -70, -28, 12, -18, 57, 7, 1,
    22, -28, 78, 51, -2, 8, 43, 28,
    -27, -24, -17, 4, -8, 3, -1, -10,
    2, -6, 47, 49, -34, -8, -50, 8,
    30, -127, -1, 53, -24, 4, 31, -15,
    -29, -26, 0, -14, 6, 9, 3, 11,
    20, -69, -12, 11, 5, 59, -43, -32,
    -10, -31, 22, 9, -7, 10, 0, 12,
    -15, -8, -21, -2, 24, -39, -10, -4,
    -11, 10, 23, -26, -10, 4, 2, 0,
    6, -6, 15, 4, 16, 10, -35, -28,
    13, 9, 28, -32, 15, -5, 2, -4,
    -9, 4, 4, 6, 9, 12, 11, 1,
    9, -30, 12, -2, 7, 0, 22, -18,
    -5, -8, -5, -5, 70, -2, -8, -14,
    2, 20, -16, 13, 24, 3, 20, -21,
    -4, 0, -2, 3, -13, 20, 10, -8,
    -20, -18, 12, -5, 8, -18, 0, 43,
    0, -13, 33, 10, -5, 18, -2, -41,
    -9, 20, -1, -25, -2, 15, 0, 4,
    -12, -27, 17, 17, 2, 9, 7, -16,
    28, 19, -16, 17, 11, 5, 1, 1,
    -18, 0, -19, -2, 33, -15, -24, -18,
    22, -21, -3, -21, 5, -11, -18, 9,
    1, 0, -12, 7, 5, -1, -19, 11,
    7, 13, -5, -11, 0, 1, 4, -1,
    -8, -3, -35, 7, 17, -4, 17, -14,
    2, -9, -17, -12, 21, 15, -19, -5,
    -9, 2, 2, 3, 3, -4, -9, 37,
    9, 50, -14, -5, 4, -2, -12, 5,
    2, 2, -35, -2, -53, 10, 44, 17,
    20, -10, 4, 22, 10, -6, 20, 15,
    -28, 2, -14, -10, 12, 5, 3, 37,
    6, -8, -20, -44, -10, -10, -24, -3,
    18, 2, -1, -17, 8, -5, -3, -55,
    -34, -8, 9, -17, 10, -27, 4, -12,
    -7, 10, -7, -4, 50, 28, 17, 10,
    17, 22, -20, 2, 12, 0, -7, 7,
    -44, -26, 14, -2, 61, 2, -9, 1,
    -2, -18, 5, -8, 12, -18, -15, 22,
    -5, -5, 8, 15, -8, -10, -19, -29,
    -17, 11, -18, -16, 3, 0, -3, 6,
    3, -23, -11, -45, 47, 40, 24, 19,
    25, -41, -15, -1, 30, 6, 4, 24,
    -2, -1, -1, -18, 16, -1, -20, -13,
    25, -6, 35, -28, -10, -6, -13, -55,
    -11, 4, -1, -11, 29, -40, 18, 45,
    -16, 14, -1, -2, -11, 9, 18, 0,
    -19, -19, 13, -22, -9, -17, -20, 4,
    -34, 7, -17, 17, 3, 0, -2, -6,
    4, -8, -19, -22, -41, -3, 23, -30,
    31, 3, 10, -11, 14, 5, 20, 27,
    0, 14, -1, 10, -30, 21, -13, 15,
    -10, 50, 1, -21, -8, -17, -5, 7,
    13, -18, -5, 5, -10, 9, -2, -31,
    20, -9, 1, 14, 0, 16, 10, 10,
    9, -6, 3, 1, 19, 5, 23, -2,
    39, 7, -9, 37, 0, -8, 9, -11,
    15, 29, 2, 10, 50, -13, -23, 3,
    4, 33, 3, 12, -4, 18, -5, 8,
    12, -1, -14, 13, 14, -8, -18, 3,
    14, -5, -5, 13, -14, 37, 7, -16,
    1, 12, 38, 1, -7, 9, -3, 51,
    -2, 11, 27, 5, -21, 0, 31, 4,
    -11, 14, 13, 8, -18, -9, 17, -24,
    23, 2, 23, -24, 11, 9, 14, -3,
    -28, -17, 29, 11, 55, 74, 16, 37,
    6, -6, -14, -37, -17, -4, -7, -34,
    -5, -23, 12, -1, 16, -5, 0, -7,
    39, 7, 2, 23, 9, -6, -27, 12,
    -2, 3, -5, -22, -2, 14, -24, 10,
    -11, -14, 15, 4, -10, -2, -10, -5,
    22, 7, 18, 9, -19, 1, -17, 25,
    5, 17, 4, 48, 10, -15, -6, -9,
    2, 34, -6, -33, -12, -43, 39, 44,
    -16, 20, 23, 20, 5, 19, 4, 8,
    -3, 9, 0, -28, -20, 12, 0, 0,
    13, 24, 15, -30, 0, -14, -6, 11,
    10, -42, -19, -48, 1, 30, 32, 28,
    -13, 8, -6, 1, 2, 2, -8, 18,
    6, -10, -3, -12, 3, 29, 23, 0,
    -23, 17, 29, -32, 11, -24, -14, -13,
    96, 33, -39, 4, 52, -19, 72, -43,
    -12, 8, -22, 16, -24, 4, 27, 26,
    32, -3, -1, 3, 3, 30, 3, 25,
    -7, -12, 11, -27, -4, -12, -2, -4,
    13, 54, 0, 22, -40, -4, 27, -3,
    -19, -21, -34, -25, 7, -15, 19, 1,
    7, 2, 4, 15, 15, 6, 17, 7,
    6, 5, -6, 39, -8, 8, 2, -24,
    -17, -14, -2, 34, 1, 22, -6, 3,
    7, -28, 27, 3, 10, -2, 2, -12,
    -21, -19, 2, -11, -9, 8, -11, 8,
    -14, -32, 0, 13, 2, -3, 1, 1,
    -3, -11, -25, 5, 8, 67, -15, -15,
    -6, 34, -10, 21, -4, 0, -32, -20,
    -7, 2, -8, -7, 7, 6, -4, 15,
    -62, -23, -29, 28, 8, 3, 13, -9,
    11, 24, 23, 28, 20, 8, -30, -34,
    -5, -26, 0, -19, -28, 7, 3, -2,
    -20, 17, 4, -10, -16, 27, -13, 18,
    16, -16, -9, 31, -7, -7, 3, -20,
    -6, -20, 5, -2, -20, -46, -4, -28,
    -17, 0, -6, 1, -1, 16, 5, 3,
    -13, 7, -15, -1, -2, 12, -4, 0,
    42, -29, 26, 11, -7, -14, -6, -2,
    47, 18, 45, -16, 20, -48, -32, 33,
    -5, -26, 10, 9, -5, -11, 3, -16,
    -10, -3, 3, 8, -10, -20, -10, -18,
    -12, 18, 19, -63, 60, -27, -8, 2,
    3, 4, 29, -7, -2, -41, 9, -28,
    9, 24, 19, -15, -4, 7, 15, 1,
    2, 12, -15, 1, -1, -5, 20, 7,
    -15, -37, -37, 10, 12, 7, 2, -9,
    2, -53, 24, -7, -8, 7, 41, 20,
    1, -21, 15, -22, 8, 9, 8, 10,
    -8, -6, 4, 25, 6, -1, 19, -15,
    -20, 2, 4, -32, -11, 22, -12, -26,
    17, 48, 28, 12, 21, 37, 7, -24,
    12, 10, 4, 24, 3, -12, -35, -23,
    -3, -5, 7, 11, 1, -9, 12, -4,
    -29, 5, 29, 25, 9, -13, -7, 17,
    82, 9, 11, 12, -33, -52, 15, 2,
    -21, 4, 33, 1, 20, -15, -22, 1,
    24, 0, -9, -19, 25, 30, 16, 23,
    14, -22, -24, 39, -12, 0, 8, -4,
    29, -1, -20, -5, 70, -4, 39, 9,
    -17, 2, 10, 12, 1, 11, 22, -13,
    8, -7, -11, 15, 2, 10, 7, 2,
    -54, 7, -45, -17, -7, 11, -6, -10,
    -5, 1, 40, 6, -44, -6, -23, -37,
    11, -17, -5, 29, 11, -1, 40, 3,
    16, 18, -9, -2, -8, -36, 19, -13,
    14, -64, -13, -35, 0, -10, -3, -14,
    -6, -18, -2, 25, -10, 88, -31, 2,
    28, -35, 16, 1, -20, 6, 10, 0,
    -10, -23, -5, 6, -37, -14, -4, 32,
    -35, 8, -4, 19, 6, 3, -4, -8,
    12, 8, -6, 12, 14, -4, -27, 13,
    4, -20, 7, 4, 39, 4, 14, 14,
    -2, -7, 10, 0, -56, 27, 2, -6,
    16, -15, 16, 10, 13, 8, 16, -9,
    12, 14, -27, -11, 11, 21, -14, 4,
    -7, 18, 39, -15, -5, 23, -15, -11,
    -6, 6, -4, 2, 0, 2, -28, 16,
    1, 18, -30, 40, 12, 3, -6, 18,
    18, 15, -25, 29, 4, -27, 14, -39,
    -3, 38, 2, -12, -10, -21, -30, 0,
    2, -34, 0, 19, 13, 11, 22, 5,
    -6, -22, -27, -24, -8, 13, -6, 4,
    -13, 0, -11, 13, 50, 30, -47, 5,
    -21, -24, 13, -25, -3, -10, 9, -3,
    5, 0, -8, -4, 12, -40, 25, -4,
    24, 18, 15, 9, 3, -15, 7, -11,
    -1, -32, 7, -10, 22, -24, 6, -8,
    12, -8, -7, -4, -6, 12, 2, 31,
    -5, -7, 7, -6, 8, 1, 12, 15,
    -10, -25, 6, -17, 29, 4, 5, -20,
    -2, 6, 4, -20, -2, -31, 13, -11,
    -7, 23, -13, 27, 1, 22, 13, -19,
    -36, 4, -17, 1, -16, 6, -3, 13,
    -67, -1, -15, 24, -14, -7, 16, 6,
    21, -21, 5, 2, -70, 26, 24, -14,
    -34, 26, -14, 4, 52, -3, 6, 12,
    -11, 4, -12, -4, -33, -32, -28, 15,
    9, -2, 38, -10, 2, -8, 19, 21,
    1, -18, 14, -2, 19, -12, 45, 30,
    -39, 2, 8, 27, 13, -28, -10, 8,
    -10, -9, -4, -6, -22, 24, -23, -10,
    -19, 5, 52, 19, 3, 3, 12, 9,
    8, -21, 9, 14, -15, -1, 44, 5,
    20, 27, -3, -5, 5, 21, -27, 10,
    2, -1, 13, 0, 5, -2, -1, -13,
    -46, -3, -11, -38, 8, 2, -9, -71,
    -15, -6, 0, 12, 14, -36, -4, 37,
    -30, -21, 32, -30, -9, 3, 6, -12,
    -19, 1, 8, -17, 13, -19, -8, 18,
    29, 74, -19, -3, -14, -17, -3, -5,
    1, -31, -8, -40, -23, 16, 4, -53,
    -19, -10, 21, 19, 4, -4, 30, -10,
    1, 6, 6, 16, 20, -7, -2, -1,
    -14, 33, 6, 32, -13, -35, 0, -4,
    -11, -17, 2, -16, -12, -6, -5, -21,
    15, 24, -12, 5, 10, 1, -9, 3,
    -3, 1, 1, -1, 12, -22, 14, 25,
    37, -4, -7, 0, 15, 11, 4, 8,
    3, -4, 27, 7, 42, -7, -25, 18,
    2, 0, 5, -7, 27, 4, 15, 24,
    9, 4, -6, 17, -5, -33, 7, -43,
    -2, 23, -23, 1, 10, 52, -8, -16,
    -18, 10, 7, 11, 1, 88, 4, 59,
    7, 12, 1, -17, -5, 12, -6, -4,
    -3, 4, -1, 2, 18, 1, -1, -12,
    5, -48, -13, 17, -11, -6, 17, -4,
    -30, -7, 21, 20, 7, 46, 20, 22,
    -4, 2, -8, -14, -11, 10, 3, 28,
    -18, -15, 9, 18, 5, 7, -8, -55,
    -1, 2, 33, -45, -22, -8, -16, 1,
    23, 0, -21, -16, -21, 7, 0, -44,
    20, 2, 24, -4, 2, 6, 0, -10,
    18, -2, 16, 14, 23, -3, -24, 14,
    29, -30, 7, 38, 5, -10, 7, 1,
    7, -9, -8, 16, 0, -11, -31, 87,
    -13, -27, -11, -18, -9, 1, 2, 5,
    1, -8, -8, -20, -16, -21, -2, 17,
    11, 26, -4, -40, -2, -22, -9, -4,
    -6, -38, 0, -18, -73, -31, 10, -25,
    -2, -2, -30, -55, -31, -11, -4, -12,
    -7, 0, -2, -3, 3, -7, 65, 14,
    1, -22, -38, 6, 29, -1, 2, 2,
    55, 19, -45, -3, 20, -24, 48, 4,
    30, -1, -31, 23, -1, -17, -6, -13,
    52, -7, -1, -11, -17, 64, -5, 11,
    3, -12, 0, -9, -3, -6, 16, 1,
    11, 58, -25, -13, -104, 21, -8, -8,
    24, 30, 37, 14, -12, -2, -10, -2,
    1, 13, -2, -2, 2, -13, -15, -19,
    -9, -13, 50, 24, -5, 21, -13, 20,
    -32, -32, -7, 23, -19, -77, -14, -18,
    14, -3, -43, 31, 8, -22, 25, -3,
    -6, -25, -9, 12, 5, 31, 29, -5,
    -18, -38, -15, 43, -6, 20, 7, 2,
    23, 4, 9, 10, -4, 1, -14, -55,
    -39, -1, 1, 4, -12, 9, 20, 11,
    -5, 11, -9, -30, 27, 22, -15, -14,
    -31, -8, 5, 29, 0, -11, -12, -15,
    16, 13, 42, 20, -19, 11, 41, -16,
    7, 5, 10, -7, 7, 11, 12, 5,
    -12, 5, 11, 0, 18, -4, 33, -24,
    31, 46, 3, 25, 7, 1, -3, -18,
    -40, -18, -1, 1, 5, 38, 5, -3,
    12, -8, 11, 8, -4, 0, -11, 3,
    -6, 5, -5, -2, 3, 10, 11, -3,
    44, 32, 15, -27, 1, -4, -7, -9,
    14, 16, 13, 7, 25, -13, -2, 18,
    37, -3, 24, 0, 15, 37, 15, 20,
    3, -10, 1, 0, -42, -3, -1, -4,
    19, 9, -19, -11, 104, -15, -14, 1,
    -15, -12, -3, -17, 20, -81, 39, 55,
    1, 12, 33, 25, 15, -4, -11, 10,
    -2, 16, -1, 11, 22, 0, 7, 14,
    3, -53, -40, -18, 11, 0, 2, -20,
    29, -10, 0, -21, -11, -1, -15, -53,
    -8, -6, 46, 16, -16, 10, 16, 14,
    12, -12, 7, 14, 2, -19, -61, 8,
    -13, -16, 3, 7, 4, 1, 0, -21,
    -11, 21, 12, 13, -37, 66, 5, 13,
    15, -32, -2, -1, 21, -20, -6, 17,
    8, -3, 8, -13, -4, -8, 6, 5,
    -15, 12, -14, 25, 18, -9, 18, 11,
    20, 15, -13, 6, 34, 0, 42, -20,
    22, -4, -4, -8, -8, -19, 11, -15,
    23, 7, 12, -16, 15, 22, -37, -3,
    -45, 23, -48, -42, -3, 5, 5, 0,
    -6, 31, 6, 7, 5, 13, -8, -2,
    -15, 2, 2, 19, -2, 18, -15, 5,
    3, 13, -1, -8, -13, 34, 12, -23,
    29, 5, -60, 28, -2, -9, 15, -14,
    1, 0, 10, -30, 15, -15, 27, -18,
    -17, 18, 10, -32, -6, -31, -14, 28,
    17, 12, -18, 7, 13, 46, 37, -3,
    -19, -30, -26, 19, -34, 1, -1, 9,
    9, 49, 9, -24, 48, -16, -27, 14,
    -6, 19, -13, 16, 39, -29, 0, -28,
    -32, -11, -3, 15, 15, 15, 18, 14,
    -39, 0, 0, 12, -4, 2, -20, 6,
    -16, 8, -12, -8, 11, 15, 16, 21,
    61, -13, -56, 49, -23, -22, 15, -2,
    3, -12, 15, 3, 33, 29, -37, -17,
    49, -5, 26, 8, -22, 4, -5, -20,
    3, 28, 7, -9, 44, 2, 28, -4,
    48, -4, 30, -7, 16, -20, -48, 0,
    -13, 12, -9, -5, 23, -37, -16, 2,
    -19, 71, -13, 11, 39, 16, 3, 6,
    7, 1, -11, -20, -11, 63, 2, -4,
    -11, 47, -15, 10, 15, -4, 40, 45,
    3, -66, -6, -34, 34, -35, -23, -15,
    -35, 11, 14, -18, 1, 13, -1, 10,
    -15, -32, 16, 5, -17, 14, -14, -3,
    -1, 44, -18, 38, -1, -3, 6, 27,
    14, -27, -6, 15, -5, -63, -2, 41,
    -20, -66, 9, -27, 8, -6, -21, 6,
    13, -9, -4, 0, 60, 9, -27, -56,
    -2, 15, 29, 16, -19, -30, 45, -14,
    18, 22, 6, 16, -8, 0, 3, -35,
    -6, -66, 2, 45, -10, 3, -23, -3,
    -25, 8, 46, -34, 4, 23, 3, 19,
    -87, -42, -15, -10, 26, -45, -1, -20,
    -59, -13, -25, 4, 48, 39, 9, -28,
    40, 2, -25, 12, 2, -25, 10, 14,
    47, -20, 5, 50, 13, -31, 1, 6,
    -1, -31, -37, -10, -9, 45, 10, 5,
    10, 10, -33, 13, -9, 44, -25, 10,
    -87, -8, -15, -29, -5, 2, 12, 7,
    4, 9, -16, -14, 1, -29, 8, 4,
    40, 1, 13, 39, -7, -26, -9, -39,
    -15, 4, -12, 3, 6, -8, -12, 21,
    23, 6, 1, -12, -22, 1, 31, 2,
    24, -4, 11, 35, -6, 36, 42, -15,
    -18, -31, -7, 45, 10, -16, -28, -3,
    29, 10, 0, 14, -53, 3, 15, 44,
    -61, -33, -29, 7, -7, -1, -3, -68,
    -9, -3, 3, 24, 23, 9, -2, 17,
    56, -9, 28, -30, 7, -2, 13, -12,
    -38, -4, 13, 0, -47, 0, -29, 23,
    -12, -25, 8, -20, 5, -17, -9, 4,
    5, -11, 18, 19, 27, -57, 32, -12,
    -58, -29, -45, 1, -20, -21, 2, -35,
    -2, 4, 34, -6, -14, -13, 8, -26,
    -7, 5, -8, 49, -12, -41, -1, 1,
    -10, 50, 6, -6, 40, 54, 8, -7,
    -10, 15, 1, -25, 37, -12, -37, -4,
    -9, 61, 2, -17, -23, -23, 35, 19,
    -3, 36, -3, -8, 16, 22, -9, -16,
    15, 4, 22, -6, 17, 19, -2, -53,
    -40, -20, 20, -27, 35, -10, -25, -2,
    35, 7, -7, -7, -25, -28, 127, 2,
    21, 31, -24, 8, 2, 71, -26, -30,
    1, 1, -2, -17, -11, 51, 18, 42,
    -5, -1, -14, -28, 1, 14, -34, 22,
    -15, -1, -5, -5, 0, 39, -18, -21,
    -7, -32, -53, 36, -4, -16, 23, -12,
    -17, 26, -2, 47, -17, 35, 21, 28,
    42, -4, 41, -10, -4, 3, 36, 35,
    -20, 5, 8, 4, -6, 17, -16, -19,
    37, -3, 75, -30, -9, -22, -6, 3,
    17, 17, -27, -12, -72, 41, 10, -40,
    -20, 5, -38, -20, 13, 8, -20, 19,
    40, -11, 7, 11, 5, -5, 13, 13,
    55, -4, -47, 19, 13, -24, -19, -28,
    -7, -14, -18, -16, 2, 25, -20, 23,
    27, -24, -5, 11, 42, 33, 27, 35,
    -5, 6, -18, -5, -9, -29, 14, 22,
    23, 0, 5, -15, 11, 1, -6, -7,
    15, -16, 13, -22, -53, -4, -3, -22,
    -2, -33, 11, 2, -12, -5, 15, -3,
    -15, -3, 6, 2, -28, 7, 93, 14,
    33, 59, -7, 66, 18, -19, -11, 1,
    36, -7, -36, -22, 14, 15, 23, -16,
    -13, -27, 12, 6, -50, 16, 30, -16,
    94, -23, -24, -4, 54, -59, 41, -48,
    32, 70, -14, 66, 7, -16, 23, 2,
    7, 32, 35, 14, -21, -15, 11, -22,
    15, 23, -30, 17, 18, -23, 14, -19,
    -29, 20, 24, -11, -2, -24, -30, 0,
    67, 52, -64, 19, -10, 30, -12, -6,
    11, -7, -20, -7, 10, 22, 41, -10,
    -20, 49, 47, -12, -52, 6, -40, -46,
    12, -56, 20, 3, -7, -70, -9, -1,
    -22, 12, -95, 19, -11, 14, -4, -26,
    29, -28, -13, -37, -8, -2, 37, -27,
    -14, -23, 6, -49, 6, 25, -13, 41,
    2, 7, -17, -112, -44, -57, 36, 6,
    4, 16, 24, -31, 7, -21, 17, -20,
    44, -6, 23, -17, 8, 25, -28, -75,
    41, -9, -38, -3, 25, -23, 31, 28,
    -37, -19, 7, 11, -2, 21, -8, 32,
    -38, -91, -36, -39, 19, -3, 3, -21,
    7, 26, 39, -20, 5, 32, -11, 28,
    -10, -24, 52, -12, 51, 78, -4, 24,
    -3, 11, 11, 22, -53, -28, -18, -15,
    -62, 90, 17, -33, -7, -7, 5, -7,
    -9, 48, -1, -8, -16, 46, -65, 38,
    -6, -19, -14, -46, 15, -36, 14, 30,
    12, -6, -2, 5, -25, 13, -1, -19,
    28, 43, 10, 63, 127, -23, 0, -7,
    5, -14, -13, 27, 47, -77, 45, -8,
    -7, -39, -40, -46, 0, -23, 16, 8,
    -4, -3, 7, 12, 34, -27, -16, -89,
    0, 8, 52, 5, 9, 7, -15, -37,
    17, 29, -5, -26, -9, -1, -25, -48,
    -19, -4, -74, -7, 19, -29, -4, 25,
    7, -2, -4, -32, -34, 33, 12, -21,
    -32, 10, 2, -7, -24, 0, -12, -32,
    2, 6, 9, 11, 36, 40, 30, 27,
    -5, -11, 12, -19, 38, 45, -11, 58,
    1, 9, 0, -17, 17, 13, 29, -7,
    -6, 3, -9, -30, 27, -11, 20, -1,
    47, -9, -7, 6, 62, -38, 2, 3,
    2, 2, -25, -12, -42, -1, 38, -1,
    48, -8, 14, -26, 13, 19, 40, -12,
    -66, 39, 24, 11, 0, 0, -15, 7,
    0, -4, 25, -31, 26, 8, 38, -13,
    -17, -10, -19, 14, -5, 4, -31, -35,
    0, 3, 7, -16, -2, 12, -16, 25,
    20, 19, 6, -6, -9, -14, 5, -10,
    -8, 22, 41, 18, 9, 12, 46, -3,
    15, 40, -8, -8, -21, 42, -97, -12,
    6, 12, -17, 14, -26, -16, -7, 10,
    17, 45, -26, -18, 20, -3, 8, 28,
    -23, -18, -15, -2, -4, 1, 1, 6,
    -24, -40, -2, -20, 5, -3, -4, 2,
    3, -49, -6, 20, 12, 10, -10, 6,
    -2, 7, 1, 7, 6, 17, 8, 25,
    -37, -12, -16, -23, 17, -25, 14, 15,
    35, 4, -15, 24, -5, 6, -2, 0,
    -3, -13, -13, 15, 2, 8, 24, -4,
    13, 0, -33, -22, 3, 13, -18, -17,
    -6, -10, -15, -22, -1, 40, -29, 11,
    19, -14, -12, -37, -6, -9, -15, 2,
    5, 7, -21, 3, 3, -11, -6, 15,
    -24, 19, 8, -1, 9, -14, -15, 6,
    14, 4, -13, 13, -21, -11, -20, 6,
    -2, 24, 13, 7, -20, 0, 10, 15,
    38, -2, -24, 7, -16, 3, 7, 1,
    16, 17, -19, -5, -26, -10, -1, -33,
    46, 6, -18, 38, 39, 3, -27, 3,
    13, -1, 0, 3, 5, 10, 27, 7,
    -9, 22, -9, -3, 2, -9, -5, 15,
    34, 10, 24, -15, -1, -11, -1, 32,
    20, 7, -15, -30, 11, 5, -30, 14,
    31, -21, 6, 7, 2, -27, -20, 2,
    -12, -15, -12, 20, 13, 2, -7, 24,
    -5, -8, 18, 5, 28, 17, -21, -16,
    -42, -15, 0, 20, 15, -24, 4, 0,
    -21, -30, -6, 16, 9, -11, -13, -15,
    20, -18, -29, 16, -5, 3, -4, 1,
    -1, 16, 4, 2, 14, 14, 32, -6,
    18, 40, -9, -17, 18, 11, -9, 24,
    -25, 4, 10, -47, 2, -7, 22, 8,
    -2, -3, 5, 46, 7, 2, 14, -16,
    -5, -34, -10, -27, 5, 3, 14, 8,
    24, -13, 40, 9, 7, 9, 12, -4,
    -21, 29, 9, 27, 2, -18, -8, 17,
    -4, 33, 24, 3, -16, -10, -6, -15,
    0, 2, -9, -3, -8, -63, -17, -8,
    -21, -58, -4, 2, 2, -46, 5, -7,
    -11, -29, 28, -22, -9, 6, 1, -7,
    -1, -29, 31, 16, 3, -9, -9, -22,
    1, 4, 5, 0, -9, -15, -18, -16,
    2, -14, 10, 8, -13, -22, -9, -16,
    -13, -15, -37, -3, 3, 10, -15, 5,
    -5, -30, -12, -19, 1, -15, 6, 1,
    14, 41, 14, -29, 15, -30, -7, 11,
    -3, -5, 5, 17, -16, -15, -7, 23,
    -13, -4, 20, 7, 5, -20, -12, -16,
    12, -3, 18, 10, 0, 14, 1, 3,
    -4, 35, -7, -6, -5, 2, -22, -5,
    -29, -1, -4, -32, -22, 6, 23, -6,
    22, 25, 0, -13, 9, -10, -6, 0,
    -1, -19, -19, -2, 19, -5, -9, 3,
    32, 11, 6, 2, 3, -14, -14, -16,
    18, -17, -21, -5, -11, -3, -4, -18,
    -3, -3, 4, -25, -2, 14, -32, 0,
    -31, 3, -15, 4, -13, -7, 0, 7,
    -9, -8, -22, 8, -27, 17, 13, 7,
    -25, 13, -30, 16, 14, 4, 25, 7,
    -16, 21, 2, -13, 4, 31, -10, 10,
    -4, 10, 10, -5, -4, -5, 17, 29,
    44, 32, 6, 22, -15, -30, -9, 4,
    21, -11, 11, 24, 0, -3, 15, -4,
    -20, -20, 2, 6, -1, -7, -7, 9,
    -2, -29, -15, 2, -4, 10, 16, -12,
    0, -7, 8, 12, 6, 19, -4, -6,
    7, -5, -12, -13, -14, -32, -41, -16,
    -10, 0, 26, 5, 5, 5, -2, -11,
    -7, -3, 7, 4, 19, 3, 11, 8,
    0, -18, 6, 20, 7, 10, -9, 3,
    17, -1, 3, 9, 0, 2, -11, -20,
    15, 6, 31, -31, 1, 31, 26, 18,
    -3, -2, 10, -1, -10, 6, 4, -7,
    12, 22, -4, 13, -21, 26, -30, 19,
    47, -22, 33, -29, -33, -16, 34, 0,
    -5, -6, -1, 45, 22, 12, -3, -21,
    -5, 34, -18, 9, -25, 16, -22, -1,
    3, 23, 5, -21, -6, -4, 4, 15,
    51, -16, 3, -48, -6, 0, -27, 18,
    10, 27, -1, 4, 6, 18, -24, 5,
    -24, 14, -12, 22, 7, 8, 1, 8,
    -9, 8, -1, -6, -34, -12, 6, 9,
    2, -14, 16, -18, 5, -26, -36, -20,
    7, -20, -15, -12, 7, -11, 3, -5,
    -34, 7, 9, 17, -3, 2, 2, 3,
    -16, 27, -1, 26, -7, 1, -17, 14,
    -42, 6, -1, -10, -1, 3, 3, 12,
    4, -37, 13, -14, 10, -9, -13, 2,
    4, 6, -31, -19, 5, -5, -4, 13,
    1, 25, 12, -10, 42, 3, 7, 13,
    6, -1, 19, -28, 20, -1, 17, 5,
    -1, 0, -44, 13, 9, -8, 0, -7,
    16, 11, 7, 11, -1, 13, 2, -4,
    -32, 21, 4, -14, -22, -10, 2, 5,
    -28, 11, 1, -2, 4, -27, 7, -9,
    -18, -9, -3, 8, -8, 17, -10, -3,
    11, -23, 3, 19, 4, -10, 11, 6,
    -20, -19, -13, -6, 9, 2, -11, 12,
    -11, 17, 8, 12, 32, 39, 32, 19,
    5, -9, -8, 33, 0, 14, -5, 15,
    -15, 14, -3, -23, -16, -26, -22, -21,
    6, -30, -11, 3, -26, -3, -9, 18,
    19, -27, -12, 13, 0, -55, -37, -8,
    -31, -11, 4, -10, 13, 3, -1, 13,
    -19, -3, -17, 4, -15, 10, 13, -1,
    -13, -43, -6, 19, -5, -20, -27, 28,
    -19, 5, 2, -10, 12, -5, -7, 29,
    17, -25, -6, 22, 18, 5, 20, 9,
    -19, 9, 15, 13, -3, 35, 7, -1,
    -3, 0, -5, -16, 20, -12, -11, -22,
    7, -42, 45, 16, -3, -33, -15, 0,
    -8, -13, 21, 7, -28, -15, -13, -24,
    11, 18, -3, 1, 11, 5, -3, 7,
    46, -8, 1, 5, 19, -14, 2, 2,
    -12, 0, 14, 2, 2, 3, -6, 29,
    3, -37, -9, -15, -3, 11, -3, -5,
    9, 7, -18, 6, 4, -3, -13, 10,
    -14, 4, -20, 19, -11, -8, 23, -6,
    7, -9, -5, -58, 13, 28, -11, -21,
    -1, -28, 0, 22, 0, -8, 25, 25,
    2, 26, 22, 14, -6, 4, -29, -17,
    8, -2, -19, 2, 23, 40, 33, 4,
    -13, -47, -16, 3, 33, 24, -6, -2,
    9, 3, 21, 2, 7, 1, -19, 6,
    -3, 22, -5, 0, 15, -18, -12, 12,
    14, -17, -12, 37, 10, -38, 7, -19,
    -15, 50, -2, -12, 12, -28, -12, 38,
    -1, -33, -8, -5, 3, -1, 3, 5,
    1, -16, -17, 15, 17, -10, 6, 0,
    26, -18, -34, 6, -25, 43, -8, 14,
    35, -73, 1, 17, -12, 16, -14, -20,
    43, -51, -15, 45, -3, -16, -14, 4,
    -21, -28, 15, 16, 31, -5, 2, 15,
    0, 11, -7, -9, -43, -34, 4, 12,
    -26, 5, -30, -14, 40, -31, -37, -25,
    0, 30, 6, -1, 3, 10, 4, -7,
    -39, 32, 15, -37, 3, 9, 5, -15,
    8, 2, 14, -12, 19, 21, 37, -20,
    35, 18, 16, -1, -7, 5, -20, -1,
    -12, -27, -35, -15, 14, 4, 20, 1,
    -18, 10, -1, 5, -6, 11, 23, 32,
    10, -4, 23, 13, 0, -7, 40, 7,
    -27, -8, -14, 28, -18, -2, 24, 27,
    -5, -2, -6, 23, 0, -5, 19, 25,
    -28, 5, -36, 18, -9, -11, -15, -17,
    25, 9, -15, 6, 20, -14, -9, 26,
    33, -9, -25, -23, 48, 5, -26, 18,
    -25, 0, -18, -5, 23, 10, 2, 12,
    -32, 5, 2, -43, -17, -6, 0, -11,
    20, -12, -3, -28, -32, -30, 16, 21,
    11, -30, 10, 7, -13, 1, 37, 18,
    -19, -22, -39, 34, -9, -12, -25, -14,
    -23, 9, -4, 64, 22, -10, -17, 11,
    16, -34, -11, -11, -23, -45, 6, -11,
    12, -7, 11, 9, -17, 24, -3, -51,
    15, -20, 20, -37, -5, -2, 40, -23,
    -3, -30, 12, -1, -10, 11, 0, 1,
    5, -15, 33, -17, 52, -34, 0, 20,
    -36, 10, -8, -25, -46, -10, -21, 54,
    -50, -23, 27, -4, -51, -19, 14, 11,
    14, 13, 46, 23, 29, -6, -3, -26,
    -3, -14, -31, 11, -20, -7, -36, 24,
    -12, -25, 23, -9, 40, 8, 24, -3,
    10, 18, -6, -6, 70, 2, -13, -2,
    22, 20, -37, 13, -4, -3, -14, -14,
    -11, 0, 20, -5, -14, 7, -6, -11,
    -28, -54, 22, 12, 22, -32, -16, 38,
    -20, -6, -8, -21, 28, 24, -8, 4,
    25, -3, -9, -18, 11, -14, -15, -14,
    -12, 0, -2, 11, -18, 3, -27, 10,
    12, -7, -8, 10, 6, 13, -3, -12,
    14, 8, -12, 11, 19, 22, -1, 12,
    27, -25, -9, -34, 1, 14, 17, 7,
    -58, 15, 20, 19, 12, -15, 0, -12,
    15, 25, -4, -6, -1, 28, -13, 23,
    13, -10, 26, -27, -46, -26, 0, 8,
    23, 4, -15, 10, -8, -9, -10, 0,
    -33, 19, 3, -19, 11, 27, -14, -7,
    -23, -9, -22, -17, -34, 29, 10, -21,
    8, 12, -2, 2, -12, -22, -3, 3,
    40, -10, -39, 23, 20, -4, -28, -3,
    33, 32, -4, 7, -4, 20, -27, -30,
    37, -2, -13, 8, -5, -27, 9, 11,
    -3, 18, 21, 14, 2, 20, 11, 11,
    7, 9, 38, 6, -6, 19, -8, 8,
    -13, 11, 11, 9, 0, 35, 2, -2,
    -19, 0, -5, -18, -20, 6, -13, -13,
    2, 28, 3, -8, -2, 21, -18, 14,
    49, -7, 12, -20, -1, -3, 13, 28,
    5, 27, 0, -29, -20, -1, 0, 20,
    -3, -15, 7, 30, -8, -4, -18, -6,
    24, -12, 33, 29, 3, 1, -17, 17,
    -17, -72, -12, 13, 1, 4, 30, -3,
    -25, 5, 11, 49, 26, 13, 6, -46,
    11, -4, 12, 42, -59, -34, -52, -31,
    -23, 11, 38, 31, 2, 0, -7, 22,
    14, 6, 8, -22, -2, 9, -3, 18,
    9, 4, -12, 2, 6, -18, -7, 24,
    3, 23, 34, 36, 25, -8, 40, 18,
    10, -18, 53, 9, -4, -8, 17, 27,
    -13, -21, 22, 6, -3, 5, 8, -1,
    -10, -1, 0, 4, -47, -20, -16, 12,
    -33, -35, 8, 16, -15, -13, 62, 5,
    6, 16, 16, 14, -24, 17, -13, -16,
    41, -18, -50, 13, -11, 22, -31, -8,
    -18, 30, 51, 10, 24, -13, 7, 16,
    8, -5, -26, -16, -16, 0, -46, -11,
    5, -4, -30, 7, 30, 13, 33, 10,
    22, 22, -30, 7, -8, -14, 3, 0,
    -39, 0, 41, -18, 35, 54, 21, 20,
    21, 34, 4, -11, 32, -30, 26, -32,
    21, 5, -19, -8, -23, 1, 28, -12,
    -1, 14, -20, 29, 18, -20, -10, 6,
    -9, -16, 6, -22, 4, 7, 26, 23,
    -12, -11, 33, -45, -11, 29, 13, -2,
    -4, -16, 8, -15, 4, 8, -16, 5,
    8, -14, 6, 35, 0, 1, -39, 3,
    39, -22, -28, 1, 37, 2, -5, -30,
    1, 20, -8, -27, -6, -5, 27, 17,
    -5, 23, -4, 48, 23, -22, 37, -7,
    -30, 18, 26, 19, -19, -8, 0, 32,
    25, -50, 7, 24, -30, -16, -28, -2,
    5, -5, -23, -12, -18, 24, 26, -7,
    1, 5, -7, 11, 23, -55, 14, -37,
    17, -19, 12, -41, 31, 11, -13, 1,
    -47, 10, -9, 11, 19, -15, 4, -12,
    -25, -2, 32, -8, 49, 44, 73, -15,
    -10, -23, -8, -18, -9, 1, -24, 17,
    43, 5, -20, -9, 2, -11, -6, -9,
    -22, -10, 15, 7, -38, 22, -7, -13,
    41, 0, 29, -18, 51, -20, -64, 24,
    -22, 49, 19, 54, -2, 18, -2, -18,
    -15, 13, -10, 8, 12, -3, 14, -2,
    6, -28, -20, -25, -9, -13, -35, 21,
    3, 6, -37, -38, -4, -43, -12, -24,
    -13, -36, -12, -25, 33, 4, 10, -4,
    34, 34, -11, 44, 13, 18, 10, 4,
    17, -23, 9, 5, 22, -5, 21, -38,
    45, -26, -44, -5, 20, -25, -34, -16,
    -6, 1, 12, 1, -13, -43, 22, -9,
    -12, 14, 7, 86, 9, 17, 20, 8,
    27, -28, 3, -22, -33, 12, 2, 9,
    20, 45, -1, 5, 13, 9, 15, 38,
    14, -13, -17, 15, -21, -42, -13, 4,
    27, -31, -5, -14, 32, 13, -13, -1,
    -1, 31, -3, 19, -9, -28, 27, 6,
    22, 48, 27, 7, 33, 6, 5, -20,
    11, 8, -16, -4, 5, -8, -12, -3,
    -11, 17, 14, 11, -12, -12, 9, 2,
    -33, 2, -19, 4, -20, 28, 22, 19,
    -29, 15, 15, -23, 4, 76, -30, -18,
    -1, 91, -9, 5, -40, 18, 13, -26,
    -7, -5, 2, 9, -2, 7, -4, 4,
    21, 38, 52, -22, 1, -11, 13, -26,
    35, -10, 6, -12, -20, -13, -19, -31,
    30, 23, 15, 12, -13, 31, 53, 14,
    -17, -6, -24, -10, 0, -17, -3, 13,
    -43, -25, 15, -41, 40, -45, 1, -49,
    -47, 5, 39, -9, 16, 21, -14, 3,
    6, -12, 3, -40, -54, -1, -22, -28,
    -47, 34, -20, 6, 59, 29, -14, 34,
    -11, -38, -21, -29, 81, -15, -2, -18,
    -20, 2, 32, 28, -28, 16, -42, -57,
    -91, 18, -60, -69, 29, 23, -24, -7,
    2, -11, 25, 11, 24, 19, -13, -11,
    -19, 19, 19, 4, -17, -47, -5, -33,
    7, 5, -22, -11, 50, -58, -10, 7,
    -26, 68, -30, -17, 40, 10, 45, 5,
    -4, -29, -18, -12, -11, 6, 75, 37,
    -29, -31, -5, 1, 32, -29, -75, 20,
    -35, 15, -91, 4, 3, 26, 39, -3,
    -14, 39, -30, 10, 11, 13, 28, -16,
    13, -49, 75, -18, 16, -39, 11, -19,
    -33, -96, 1, -33, -31, -3, -33, -9,
    -22, -94, 59, -27, 31, 75, 25, 65,
    -39, 10, -18, 23, -18, -27, -2, -12,
    59, 4, -21, 49, -27, -29, -14, -8,
    6, -10, -32, 35, -18, 26, -60, -20,
    -11, -50, 34, 10, -34, -11, 4, 63,
    69, 0, 3, -12, 16, 63, -2, 20,
    -8, 54, -8, -10, 15, -14, 11, -35,
    -6, 26, 23, 26, 17, 13, 24, 27,
    24, 23, 34, 76, -7, -22, -2, -17,
    37, 19, -23, -45, 13, 15, -27, 29,
    -36, 33, 21, -29, -53, -16, 37, -84,
    48, -62, -8, 6, -94, 50, 71, 25,
    -39, 55, -20, 34, -37, -2, -25, 80,
    -3, -16, 29, 61, 35, 27, -12, -5,
    -80, 24, -22, -61, -40, -11, 56, -9,
    -33, -1, 30, 12, 19, -46, 7, 5,
    12, -41, -27, -4, 53, 31, 50, -25,
    -19, -1, -34, -17, -4, -26, 14, -9,
    -2, 6, -19, 7, 9, -10, -14, -2,
    69, 59, 26, -1, -13, 7, 20, 37,
    -21, 57, -13, 36, 113, -59, 31, 88,
    68, -55, 26, -47, -22, 46, -1, 39,
    -43, -73, 0, 42, 3, -28, -21, 71,
    -28, 6, 18, -49, -78, -12, 16, -3,
    -17, -10, -14, 35, -54, 42, 0, -38,
    -44, 31, 1, -27, 5, 1, 19, 39,
    -17, -20, -6, 47, -79, 29, 46, -1,
    -4, 39, 0, 20, -27, 8, -1, 45,
    -17, 5, 37, 14, -26, 110, 17, 8,
    26, -8, 2, 50, 85, 44, -14, -10,
    -8, 56, -4, -14, -35, -83, 4, -7,
    9, -13, 6, 30, 10, 31, -12, 25,
    35, 19, -36, 37, -1, 9, 27, -17,
    20, 10, -9, -20, 6, 43, -33, 6,
    17, 75, 55, -15, 20, 31, -71, -58,
    50, -66, 38, -7, -4, 25, 54, 42,
    28, -11, -3, -49, 62, -70, -12, -1,
    39, -31, 22, 38, -42, 20, 10, -52,
    33, -17, -10, -22, -30, 46, 21, 34,
    0, 47, 39, -14, -40, -44, 34, 7,
    25, -22, -18, 3, 18, 7, -9, -26,
    -62, -12, 9, 14, 8, -58, -3, -6,
    12, 0, 6, 6, -110, 7, -8, 41,
    -69, -29, -27, 53, -66, -1, 12, -62,
    26, 6, -45, 29, -38, 15, -16, -51,
    -33, 16, 36, 75, 2, 4, 10, 14,
    -12, 35, 40, -25, -12, 14, 14, 27,
    -21, 11, -17, 40, -49, 3, 44, -2,
    -27, -7, 28, -6, -98, -3, 26, -19,
    42, 17, 54, 30, 33, 4, -33, 31,
    -24, 3, 30, 13, -19, -4, 18, 17,
    -50, -17, 27, -43, -42, -5, 69, -25,
    -38, 40, 37, -2, -5, -65, 23, 5,
    28, 30, 11, 10, -11, 19, -6, -20,
    12, 0, -37, 18, 16, 26, 33, 34,
    51, -61, -7, 6, 26, 61, -41, -22,
    -46, -83, -90, 37, -6, 38, 29, 21,
    24, -9, 112, -50, 12, -49, -33, 78,
    -101, -3, -35, 2, 0, -38, -45, -13,
    23, -29, -59, 2, -22, -18, -36, 7,
    36, 5, -96, 1, -42, 7, -13, -13,
    -58, -33, 12, -19, -44, -8, 45, -10,
    -14, -11, 61, -3, 14, -26, 10, 35,
    -22, -2, -83, 47, 68, -43, 16, -18,
    27, -24, -57, 13, 28, -73, 52, -15,
    63, 19, -26, 32, 0, 8, -48, 40,
    -39, -30, 55, -78, 27, 45, 18, 4,
    18, 13, -38, 63, 21, -4, -9, -47,
    22, -56, 28, 7, 10, 9, -3, 31,
    8, 4, -56, 27, -11, 1, 18, -24,
    -1, -21, 17, -80, -15, -21, 5, -51,
    -19, -52, -69, 64, -72, -45, -5, 80,
    -18, 35, 10, 0, -35, -5, -38, -5,
    68, 2, 53, 21, 6, -9, 25, 13,
    -12, -46, 65, -115, 15, -24, 15, -12,
    49, -37, -12, -10, 8, 67, -37, 34,
    -12, 38, -7, -23, -100, 24, 75, 10,
    -13, 21, 34, -23, -13, 36, -36, -30,
    -13, -18, -14, 57, 29, 42, -6, -39,
    9, 13, 35, 14, 44, -46, 11, -7,
    35, -7, 21, -23, 61, 22, 28, 13,
    31, -24, 22, 2, -22, -2, 1, -10,
    -43, 23, 31, 11, -30, -8, 7, 22,
    39, 49, -1, 4, 21, 57, -19, 22,
    -2, 56, 62, 36, 38, -13, -80, -4,
    -27, -4, -9, -10, -15, 19, -17, 37,
    14, -67, 25, 5, 19, 6, -21, 21,
    17, 3, -57, -5, -11, 43, 10, -15,
    5, 14, -14, 42, -8, -23, 9, -25,
    -21, -46, 12, 31, -6, -24, -7, -21,
    -6, -6, -15, -114, 4, 9, 19, -29,
    -20, -25, 4, 34, 42, 6, -27, 18,
    -26, 42, -21, 49, 1, -44, -18, -24,
    7, -23, -30, -15, -30, -33, -24, 54,
    14, -21, -36, -64, 5, 72, 19, -3,
    15, -8, 17, -10, -17, 30, -20, -16,
    64, 8, -13, -7, -44, 15, 16, 4,
    -28, 15, -9, 5, 35, 15, -5, -19,
    -70, 17, 16, 32, 20, -18, -25, -5,
    6, 34, -18, -29, -80, -49, 37, 10,
    -48, 24, 49, -36, 8, -25, 52, -74,
    40, -3, 2, -3, 13, 37, 2, -6,
    -11, -17, 29, 9, 37, 8, 9, -9,
    26, -47, 23, 31, 33, -12, -22, -17,
    69, -14, 49, -7, -45, 15, -3, 23,
    24, -28, -22, 35, 52, -21, 33, 35,
    -31, -26, -25, -32, -74, 37, -6, -24,
    -3, -69, -16, 25, -6, -23, -62, 57,
    56, 41, 19, -21, -102, -27, -49, -29,
    8, 51, -7, 17, -19, -65, -50, 13,
    -6, 62, 5, -60, 7, 56, -29, -13,
    7, 22, -17, -8, 5, -22, -6, 21,
    18, -18, -11, 15, -1, -36, 6, 40,
    13, -3, 7, 5, 2, 5, -16, 32,
    40, -27, 1, -25, -11, -7, -1, -3,
    -21, 21, 22, -13, -12, 24, 25, -5,
    10, -5, -19, -4, 6, -11, 18, 28,
    -28, 0, -5, -2, -1, 37, 6, -5,
    0, 13, 14, -21, -19, 13, -1, 12,
    -5, -8, -9, 0, -40, -10, -16, 6,
    22, 10, 2, 12, -23, 28, 5, -11,
    -1, -8, 27, 3, -12, 5, 6, -5,
    12, -5, -3, 6, 57, 15, 43, -28,
    -1, 17, -16, -3, -10, -10, 13, 10,
    25, 3, 10, 47, -1, 27, -37, -21,
    -9, -6, 6, -13, 9, 14, -2, 1,
    -16, -20, -29, 13, -8, 33, -2, 61,
    -18, -12, 17, -6, -3, 7, 2, 12,
    29, -8, -19, -1, 13, -12, -17, 0,
    -3, 38, -41, 22, -11, -7, -27, 5,
    2, 10, 33, 6, -23, 12, -15, -16,
    -28, -14, -34, 8, -16, -1, -11, 5,
    11, -14, -4, 12, 18, -7, -8, 19,
    19, 24, -27, 3, -45, 18, 33, 14,
    -17, 15, -8, 25, 43, 32, 51, -30,
    13, -1, 5, 11, 47, 0, 6, 7,
    23, -13, 37, -1, 7, 3, -21, 29,
    37, -4, 12, 24, 25, 22, -2, -5,
    3, -14, -19, -13, -18, 18, 17, -13,
    -5, -8, 23, -11, 1, -7, 40, -7,
    -16, -47, -12, 12, -12, -15, -10, 23,
    -46, 37, -13, 4, 19, 19, -1, 23,
    -2, 31, -24, -9, -2, 34, -16, -3,
    -4, 7, -4, -20, -14, 16, -25, -5,
    -4, -8, -11, 5, -29, 3, 19, 17,
    -37, -13, -5, -7, 8, 10, -18, 25,
    24, -33, 16, 14, -16, 35, -17, -8,
    4, 19, 2, -1, -21, -10, 1, -21,
    52, -5, -21, 12, 23, -10, -5, -24,
    -16, 8, 0, -11, -3, -9, 8, -26,
    4, -32, 36, -29, 2, 0, -1, 45,
    2, -19, 1, 12, 34, 0, 0, 10,
    -15, -6, -5, 0, -16, 6, -37, 3,
    13, -4, 28, 0, -20, 9, -20, -10,
    -33, 16, -28, -38, 8, -19, 21, -12,
    -5, 31, 14, -2, 13, 11, -21, -3,
    13, 33, -12, -11, -4, 12, -24, -13,
    -1, 22, 6, -9, -2, 15, -6, -3,
    38, -36, 18, 55, -48, 12, 39, -36,
    41, -11, -6, 23, 4, -21, -10, 35,
    -7, 2, -8, -22, 17, -2, 3, -38,
    5, 3, -30, 17, -11, -2, 10, 4,
    22, -9, 18, -12, -16, 18, -39, 37,
    27, 16, 6, 13, 10, -11, -43, 22,
    -3, 6, -1, 24, -1, -2, 5, 16,
    11, 22, 24, 6, 25, -4, -17, 8,
    1, 72, 47, 9, 19, 26, -3, -10,
    16, 5, 12, 10, -16, 8, -4, -1,
    -12, 36, 11, -12, 6, 10, 0, -23,
    24, -12, -3, -3, -11, -16, 9, -6,
    -6, -39, -13, 6, 0, 8, -9, -24,
    -1, 2, -10, -8, -21, -3, 15, 0,
    -35, -23, -9, -24, -14, -27, 8, -21,
    13, 35, 13, 19, 5, 25, 22, -20,
    20, -39, 8, -2, 16, 21, 5, 34,
    18, 7, 16, 12, -18, -9, 38, 2,
    14, 9, -8, 15, 5, 6, 9, 34,
    -4, 3, -28, -13, -5, -3, 11, 14,
    -1, -7, -15, 6, 42, -11, 47, 5,
    1, 0, -3, -8, -18, -3, -16, -10,
    -3, -17, -7, 35, -37, 3, -10, -7,
    -10, 20, -16, 12, -21, 4, 24, 1,
    -12, 6, 18, -45, -58, -65, 54, 23,
    -27, 19, 3, -9, -22, -1, 26, -34,
    1, 28, -13, 13, -13, 1, 18, -6,
    -4, -21, -14, 15, 2, 2, 21, -8,
    12, 24, -33, -7, -9, -21, -3, 45,
    -4, 8, 12, 61, -24, 15, 11, 20,
    1, 7, -13, 19, 4, 18, -25, 11,
    -1, 9, -3, 13, -22, 18, 2, -8,
    12, -23, -4, -10, 58, -17, 11, -12,
    -1, -7, 4, 0, -1, 7, 2, 5,
    -15, 0, -33, -26, -6, -1, -33, -22,
    -19, -5, -28, 10, 19, -35, 23, 21,
    3, 11, 11, -11, 1, -2, -4, 32,
    6, 8, -10, -5, -5, 4, -18, -3,
    -1, 6, 28, 1, -16, 5, 35, 21,
    34, -5, -15, 4, -32, 11, -5, 17,
    -11, -1, -40, -4, -24, -19, 45, 1,
    -10, 9, -1, -7, 9, -11, 15, -15,
    0, 15, -36, -20, -13, -4, -13, 36,
    -22, 11, -3, -2, 16, -6, 19, 36,
    18, 23, -4, 21, 4, 7, 21, -22,
    -9, -7, -6, 22, 7, -16, -4, -6,
    -5, 5, -2, -4, -26, 35, 8, 15,
    -17, 26, -17, 10, 7, 13, -39, 4,
    -4, 37, -7, 12, 1, 21, -15, -18,
    21, -7, -8, -15, -1, -13, 14, 20,
    3, 47, 10, 4, 6, -11, 9, -1,
    -15, 7, -29, 0, 16, -27, -4, 3,
    -25, 24, -18, -29, -42, -19, -27, -24,
    -24, -13, -27, -8, 9, -7, 8, -9,
    -23, 24, -7, -12, -14, -35, 10, 13,
    -14, 8, 7, 23, 22, 18, 7, 13,
    -45, -34, 1, -48, 6, -30, 16, 22,
    -14, -9, 4, 2, -4, -2, -3, 8,
    18, 15, 7, -3, -25, 48, 18, -33,
    -17, 9, 19, -3, -50, 27, 37, -10,
    -5, 6, -10, 33, 28, -17, 12, 54,
    16, 18, -4, -3, -5, -26, -11, -7,
    -9, -11, 1, -12, 6, -9, -11, -18,
    7, -5, -6, -18, 4, -33, -14, 27,
    -1, 11, -3, 3, -4, 11, -3, 39,
    -13, -12, -3, 16, 2, 30, 11, 13,
    5, -24, 4, 22, 4, 7, 5, 25,
    -3, 40, -4, -3, -8, -28, -14, -3,
    -4, -9, 6, 2, -1, -13, -28, -3,
    -45, 16, 3, -4, -4, -3, 9, -10,
    17, 7, -15, 23, 11, 26, 1, 0,
    11, 32, -1, 5, -2, -10, -11, 4,
    17, -1, -42, 4, -1, -24, -42, 7,
    10, -33, -2, 17, 2, -21, 2, 12,
    12, 15, -5, -7, -24, 6, -11, -7,
    33, 5, 1, 17, 17, -7, -3, 9,
    12, -1, -30, -15, 31, -23, 17, 10,
    12, -15, 5, 10, -18, 35, -16, -19,
    -14, -13, 29, -13, -1, -9, 16, 34,
    14, 6, 20, -18, -9, 25, 6, 1,
    -27, -26, 4, -14, 6, 17, -22, 17,
    10, 27, -12, -11, 33, 17, -17, 7,
    -48, 31, 37, -22, -9, -8, 22, 19,
    31, -4, 34, -10, 17, -51, -26, 21,
    -15, 16, -9, 10, 88, -54, 16, -8,
    -21, 14, 4, -5, 1, -16, 10, -13,
    27, 13, 44, -15, -29, 24, 20, 25,
    -20, 3, -4, 0, -30, 11, -21, 31,
    -13, 64, 34, -28, -54, 0, -7, -2,
    -16, 2, 15, 0, 20, 2, 11, 3,
    -3, 4, 40, 21, 7, 19, -13, 7,
    -5, 6, 36, 6, 3, -27, 15, 3,
    -15, -46, -11, 0, 3, -9, 34, -26,
    8, -6, -7, 7, -4, -23, 28, 7,
    -20, -20, 43, 1, 17, 36, -12, 0,
    3, -35, -16, -18, -9, 0, -31, 30,
    -10, -12, 12, 9, 9, -24, 41, 0,
    -7, -21, 13, 10, -13, -20, 7, 32,
    -13, -59, -10, -13, -8, 3, -19, 14,
    -4, -31, 38, -13, -23, -14, -18, -19,
    -15, -44, 5, -34, -5, 27, 30, -3,
    -12, -4, -8, -2, -5, 6, 26, -24,
    17, 3, -7, -3, 21, -9, -14, -5,
    20, 39, -12, -2, 49, 14, -24, -4,
    -36, 23, 7, 25, 39, 10, 45, 59,
    -15, 5, -1, -3, 9, 24, 10, 39,
    -3, 3, -8, 13, 8, -23, -31, 49,
    6, -34, 22, -7, 52, -15, -25, 27,
    8, 0, 25, -4, 5, -58, -55, 18,
    -12, -31, 6, 18, 11, -33, -18, 7,
    35, 12, 16, 14, -11, 2, 5, 42,
    7, 29, 1, 6, -10, 73, 26, 3,
    -8, -17, -12, -2, 1, 43, -34, 4,
    -13, 25, -1, -14, 14, 5, 38, 0,
    0, 16, 15, -14, -8, -2, 9, -1,
    -21, 28, -39, -17, -23, 0, -2, -19,
    24, -9, -26, 0, -42, 7, -31, 28,
    7, 16, -18, -5, -34, 7, 2, 34,
    9, 45, -18, -15, 56, 3, 4, -1,
    -2, 36, -5, -25, 19, 13, 3, -28,
    -46, 12, -2, -22, 64, -2, 26, 23,
    -19, -25, 5, 6, 32, -8, 13, 0,
    21, 5, 10, 12, -30, -25, -25, 1,
    -15, -6, -13, 14, -25, -25, -18, -12,
    -17, -14, -16, 30, -87, 7, 28, 18,
    7, 2, 8, 28, -21, 7, 7, -26,
    -38, -40, -22, 24, -25, -10, 3, 12,
    -10, 9, 17, 4, -60, -42, -5, 47,
    29, 16, 35, 14, -21, -3, 41, 28,
    22, -11, 8, -1, -23, -5, -4, 22,
    15, 7, 19, -12, 29, 3, 29, -12,
    -7, 3, -11, 22, -6, -39, 26, 17,
    33, 1, 21, -4, 37, 11, 8, 4,
    14, -6, -3, -2, 10, 4, 0, -7,
    29, -13, 0, -19, 0, -29, 2, -1,
    -5, -13, 14, -26, -4, -45, -29, 13,
    -22, -6, 40, 13, -4, -1, 4, -39,
    1, -10, 13, 14, 29, -8, -2, -2,
    57, 32, -5, 9, -20, 16, 1, -10,
    23, 35, 8, 6, -12, 32, -6, -6,
    24, -28, 15, -20, -45, 4, 32, -27,
    -18, 11, -9, 1, 26, 1, 4, 25,
    -14, -1, -13, 5, 4, 3, 13, -15,
    10, 20, -13, -64, -29, -37, -29, -21,
    10, -7, 31, -16, 26, -28, -11, 8,
    -18, 3, 14, -10, -38, 0, 44, 7,
    31, 11, 0, -15, 20, -11, 26, 26,
    -5, -1, -15, -31, 20, 3, 53, -2,
    5, 5, -39, 27, 8, -42, 18, 78,
    2, 1, -15, 9, -21, -29, -15, -12,
    -4, -28, 30, -9, -41, -5, 4, 0,
    1, 16, 7, -1, 9, 22, 17, 7,
    -29, 17, 6, -39, -89, -12, 4, -1,
    -4, 14, -3, -4, -39, 19, 6, 18,
    8, -11, -12, -23, 9, 37, 1, -41,
    1, -2, -23, 1, 31, -6, 13, 1,
    -8, 11, -39, 25, -38, -21, 5, 6,
    -9, 26, -8, 72, 8, 2, 39, 17,
    26, -17, 19, 16, -2, 4, -13, 39,
    -48, 34, -3, 8, 32, 2, -34, -3,
    -26, -1, -50, -24, -25, -47, 1, 5,
    -9, 3, 5, 16, 16, -25, 25, 4,
    -10, -23, 35, 5, 2, -21, 18, -18,
    -20, 2, 46, 20, -13, 29, -16, -23,
    -17, 3, -8, 21, -13, 54, 13, 40,
    7, 14, 7, 0, -10, 15, 14, -2,
    23, -1, -17, 37, 19, 18, -5, 15,
    19, -12, 6, 7, 17, -7, -60, 46,
    -29, 5, 31, -40, -11, 21, -10, -27,
    8, 24, 0, -1, 15, -14, 3, -15,
    -21, -15, -16, 11, 13, -14, -6, 3,
    -12, -14, -47, 24, -14, 49, -7, 46,
    -1, 35, 31, 26, -16, 7, -88, -14,
    -2, 3, 20, -5, 5, -24, 21, -20,
    -8, -40, 16, -27, -38, -14, 23, 21,
    -1, 4, 12, 3, -14, 20, 12, 6,
    -31, 44, -15, -27, -31, -1, -30, 24,
    7, 12, 6, -13, 14, -5, 30, 1,
    1, -29, -4, -38, 20, 12, 3, -4,
    4, 27, -34, 16, 7, -33, 6, -15,
    -30, -30, -33, 24, -33, -7, -36, 19,
    -9, -2, -54, 4, -6, 20, -8, 10,
    16, 15, -3, 5, -20, -12, -10, -20,
    28, 25, 3, -12, 38, 38, 4, 17,
    -38, -10, 1, -11, -39, -28, 14, 10,
    -21, -14, 6, 10, -4, -30, -4, -26,
    43, 63, 19, 59, -27, 53, 38, 6,
    -4, 16, -25, -21, -12, -3, -2, 0,
    -14, -8, 13, 26, 27, 32, 16, 78,
    40, 11, 29, -11, -8, -2, 45, -8,
    -25, 13, 58, 9, 14, -29, 0, -18,
    52, -8, 13, 0, 5, 3, -30, -5,
    6, 27, -62, 20, -10, 26, 7, 34,
    -11, -23, 7, 17, -31, -7, 15, 6,
    29, -39, -10, -1, 0, 2, 27, 10,
    8, -26, -2, -4, 8, 18, -8, -6,
    -18, 10, 0, -19, 25, 18, -36, -9,
    -16, -2, -15, -16, 5, -7, 24, 9,
    1, -12, 12, -8, -17, 6, -3, -8,
    5, -7, 5, -16, -14, -8, -1, 61,
    9, 30, -19, -18, 28, 52, -25, -14,
    20, 8, -1, 5, -4, -24, -14, -8,
    -30, -20, 23, 11, -16, -4, -2, -11,
    9, 18, 24, -1, 15, 17, 8, 39,
    11, -24, 2, 28, 18, -22, 2, -11,
    30, -14, 23, -8, -18, -14, -14, 35,
    -10, -26, 25, 60, -13, -2, 40, 32,
    18, 4, -20, -17, 7, -28, -44, -47,
    3, -5, -23, 8, -33, 37, -6, 8,
    48, 20, -28, -38, 70, -14, 2, -30,
    7, -21, 40, 65, -13, 6, 15, -19,
    -26, -20, 3, -75, -24, -36, 3, -13,
    -20, 31, -6, 3, -9, -18, 5, -16,
    32, -2, -20, -14, 35, 6, -13, 11,
    -58, 22, 28, 55, -3, 21, 3, 44,
    -72, -27, -73, -21, 42, 12, -37, -64,
    8, 23, -15, -40, -47, -48, -39, -16,
    -26, 18, 57, 27, 26, -35, -4, -18,
    -57, -26, -20, 3, 26, 8, -22, 3,
    12, 7, -49, 10, 4, 18, -23, 2,
    -4, 93, 38, 5, -13, 0, 31, -21,
    -5, -21, -9, -5, 9, 26, 31, -3,
    -18, -44, 51, 5, 6, 62, 15, 28,
    -3, 38, 41, 30, -3, -17, 45, -7,
    10, 11, -77, 22, -10, -3, 12, 59,
    -22, -20, 21, -12, -33, -30, 21, 17,
    -15, -30, -7, 35, -3, 13, -18, 28,
    82, -46, 46, -57, 11, 25, 29, 26,
    -42, 38, -28, -38, 12, -47, 6, 7,
    12, -3, 16, -14, 1, 58, -40, -89,
    -21, -31, 80, -31, 3, -4, -19, 43,
    -45, -2, 10, -4, -2, 17, -11, -20,
    61, -26, -1, -19, 12, -8, 66, 9,
    -74, -21, -26, -26, -20, -15, -18, 48,
    40, 30, -47, -25, 23, -35, 19, 67,
    -71, -58, 70, 23, -39, 40, -10, -38,
    -16, 0, 22, -18, 58, -73, -41, 78,
    -43, -86, 2, -7, 35, -77, -68, 11,
    -50, 53, 16, -36, 33, 16, 12, 50,
    15, -4, -7, -31, 65, -68, -25, 15,
    -56, 17, 25, -39, -16, -46, -2, 93,
    -3, 71, 0, -13, 48, 55, 71, 18,
    60, -28, -20, 50, 24, -10, 15, -16,
    6, -20, -118, 6, 27, 6, 21, 11,
    -14, 7, -43, 29, -51, -6, -30, 13,
    21, -23, -34, 29, 47, 32, -7, -27,
    -21, -28, 45, 44, 11, -11, 23, 0,
    -3, -33, 6, -25, -30, -35, 27, 42,
    5, 2, -38, -17, 6, -14, 41, 1,
    28, -18, 36, 13, 18, 33, 4, -23,
    63, -23, -50, 35, -20, -49, -62, 6,
    -5, 13, -9, 24, -23, 15, -36, 26,
    30, -18, -38, 39, -45, 35, -15, -10,
    31, 39, -3, 72, 15, 39, 35, 31,
    26, -51, 23, 18, -34, 30, 1, 18,
    13, -19, -25, 43, 1, 13, -21, -28,
    -55, -74, 17, -26, 28, 24, 39, 65,
    -13, -13, 10, -32, -17, -10, -26, 13,
    1, 17, -75, -54, 33, -3, 45, -11,
    14, -22, 17, -33, -53, 54, 121, 8,
    -27, -56, -46, -33, 40, 35, -1, -28,
    -12, 17, -50, -10, 0, 28, 38, -18,
    9, -34, -23, -21, 20, -64, 7, 21,
    -14, 56, -30, 12, -11, 8, -3, -23,
    18, -62, 0, -11, -19, -80, -21, -7,
    -20, -9, 57, 6, 57, -2, 25, 17,
    -81, -9, -35, 43, 34, 27, -15, -12,
    60, 27, 16, 32, -6, 42, 34, -19,
    -44, -8, 7, 6, -79, 36, 7, 8,
    -24, 26, -8, 13, -49, 26, -9, 3,
    103, -74, -23, 43, -10, 1, 20, -31,
    -28, -57, 12, -42, -12, -7, -18, -42,
    -64, 70, 23, -6, -20, -75, -49, 64,
    -43, 18, -12, -11, -11, -4, 64, 39,
    72, 11, -50, -14, 44, -16, 46, 12,
    6, -2, -5, 5, 2, -32, 50, -12,
    -13, 7, -109, 61, -41, -47, 6, 6,
    -5, -5, -41, 24, -25, 45, -3, -10,
    48, -10, -25, 57, -47, 47, -11, -9,
    -3, 55, 35, -3, 26, -22, -46, -10,
    1, 19, -43, 44, -127, -2, 60, 14,
    11, -7, 4, -1, 27, -8, 11, 66,
    18, -9, 13, 52, 7, 70, -5, 13,
    24, 34, -35, 72, -1, -33, 55, 37,
    -24, -78, 14, -24, 50, 57, 37, -3,
    -21, 38, -17, 99, 3, -21, 17, 33,
    -68, -28, 72, 1, 6, 10, -48, 64,
    -46, 60, 46, 40, -16, -30, -11, 15,
    83, -12, 39, 3, 79, 40, 3, 12,
    -7, -11, -32, 32, 5, -52, 19, -8,
    -10, 88, 54, -14, -10, -3, -9, -4,
    56, 3, 62, 17, -16, -31, -41, -56,
    -50, 22, -43, -12, 70, -18, 28, -24,
    2, 38, 47, -30, -17, -46, 4, 31,
    -17, 24, 30, 56, 13, -1, 14, 63,
    0, 30, 84, 19, 19, -47, 26, 11,
    2, 55, 48, 14, -44, 40, 33, 16,
    8, 35, 13, -10, -16, 40, -45, -24,
    59, 27, 4, 66, 11, 0, -22, 33,
    15, 37, 3, 54, 20, 28, 22, -48,
    11, -50, 21, 2, 59, -24, 34, 85,
    17, 60, -8, -16, 30, 8, 14, 5,
    -39, -8, 30, 19, -55, -74, -28, 26,
    22, -15, -58, 0, -12, -20, 35, -73,
    -10, -56, 29, -8, 32, -40, 35, -25,
    27, -23, -4, -15, 10, 1, -22, 6,
    -25, -20, -30, 28, -2, 51, -2, -33,
    5, 45, -31, 41, 36, 29, 33, 7,
    47, -47, -17, 42, -6, 56, 68, 49,
    23, -2, -107, 14, -15, -27, -30, 4,
    41, -86, 31, -22, -23, -20, -11, -23,
    8, 2, -28, -54, -1, -37, -56, 11,
    23, 27, -43, -46, -4, -7, 12, -10,
    -15, -20, 3, 29, -17, 8, -19, 2,
    -63, 4, 19, -74, -9, 29, 46, -8,
    18, 12, -30, -21, 33, -75, -31, -17,
    -20, -21, 38, -18, 26, 47, -49, 28,
    74, 16, 76, -24, -8, 17, -22, 39,
    -42, 0, 49, 34, 20, 5, -6, -15,
    88, 1, -76, -12, -16, 34, -2, -83,
    0, -22, 78, -39, 11, 20, -9, -28,
    10, -30, 6, 35, 21, 16, 22, -40,
    -18, -22, -5, -33, 13, -28, 38, 13,
    -1, -56, -17, 9, 55, 51, -6, -40,
    31, 28, -18, 10, -56, -8, -36, 67,
    9, 10, -48, 19, 2, 52, 46, 0,
    10, 9, -49, -23, 16, 14, 24, -8,
    43, 13, 20, 14, -21, 10, 1, -18,
    -34, 23, -18, 35, 15, 11, -20, 60,
    7, 5, 11, -11, -7, -33, -39, 7,
    -58, 62, -36, -34, 21, 7, -28, 49,
    -57, 1, 51, -15, -34, 32, -29, -77,
    -19, 18, 16, 6, -8, -26, 49, -22,
    74, 3, -8, -12, 16, -44, 15, 40,
    -48, -14, -123, 2, -21, -26, 48, 47,
    -10, 22, -4, 22, 14, 24, 21, 88,
    12, 60, 51, -39, -20, -10, 105, -12,
    7, 2, 17, -26, -7, -3, 14, -42,
    -18, 51, 12, 33, 18, 8, 11, -4,
    14, 15, 3, -16, -30, 14, -18, -29,
    -1, -2, -5, 6, 14, 16, 17, -8,
    32, -9, 1, 11, -14, 16, -3, -22,
    24, 5, 21, 3, -9, 18, -9, -4,
    22, -4, -5, -7, 10, -18, 18, -19,
    2, 2, 0, -2, 6, 3, 9, -33,
    -2, 2, 11, -11, 2, 7, -1, 3,
    -6, 18, -19, 9, 6, 28, 14, 0,
    -2, 11, -12, 19, 0, -6, 18, 11,
    -20, 4, 2, 0, -15, 14, -2, -11,
    16, 35, -9, 1, -2, 10, 16, 7,
    11, 29, -37, -3, 3, -14, 0, -15,
    -14, 4, 16, -13, 32, -11, -4, -2,
    16, -4, -2, 0, 9, -20, 11, 3,
    -14, 2, -26, -6, -15, 2, 28, -36,
    -16, -5, 23, -27, 14, 28, -28, 12,
    -4, -11, 15, -17, 33, -43, 3, 7,
    14, 14, -5, 4, 4, -5, 26, -2,
    17, 13, -2, -33, 13, -1, -21, 37,
    -16, -11, -7, -31, 0, -7, -27, -1,
    18, 43, -12, -12, -27, -42, 4, -6,
    -29, -32, -16, 3, -21, 9, 11, -7,
    4, 9, 8, 8, -10, 35, 2, -21,
    -10, -16, -8, -30, 18, 21, -15, 7,
    23, -8, -8, 11, 32, 61, -18, 26,
    -11, -6, 1, -4, 8, 4, -6, -44,
    13, 4, -24, -8, -9, 5, 6, 2,
    6, -10, 3, 5, -6, -1, -11, -6,
    -3, -7, 20, -4, 13, 15, -8, -17,
    5, -1, 26, 0, 3, -4, 10, -3,
    21, -8, 30, 28, -10, -22, 14, 5,
    -4, 3, -2, -22, 2, -18, 28, 2,
    4, 9, -11, -27, -36, 26, -23, -1,
    -19, -3, 6, -2, 2, -4, -34, -7,
    -23, 14, 2, 3, 3, -13, 27, 6,
    -14, 3, -8, 8, 8, -24, -50, -14,
    -32, -2, 3, 15, -32, -3, -6, 5,
    11, -3, -2, 0, -12, -10, -4, 2,
    7, -10, 2, -15, 12, -12, -11, -11,
    -14, -16, 7, 15, -13, 16, 27, -16,
    35, -7, -3, 0, 0, -16, 26, 0,
    1, -2, -2, -26, 9, -5, -12, 6,
    13, -14, -21, -9, 3, 4, 2, 26,
    33, 2, -11, -11, 9, -20, -10, -1,
    -4, 9, 7, -4, -22, -1, -13, -9,
    16, -9, -15, -12, -11, -1, 5, 3,
    14, 13, -5, 13, -7, -2, 19, -22,
    16, -8, 16, -18, -10, 12, 0, -19,
    16, 47, -5, 15, -14, 29, -14, -21,
    -8, -49, -2, -13, 21, 22, 8, 36,
    26, 1, -5, -20, -15, 18, 22, -15,
    11, -5, -11, 12, -22, -18, -8, 3,
    16, 12, -15, -3, -30, 17, 11, 18,
    -8, -1, 6, -7, -2, -12, -31, 10,
    0, 9, -4, 23, -22, -6, -20, -29,
    -11, 2, 21, 18, 8, -5, 19, 4,
    26, -22, -9, -6, 1, 11, 9, 16,
    -15, 10, 9, 6, 5, 24, -18, 9,
    30, -10, 33, 1, -13, -12, -21, -30,
    -17, 1, 14, -43, 8, -19, -5, -1,
    -8, -5, -23, 2, 15, 11, 18, 7,
    10, 12, -1, 19, 0, -12, 25, 0,
    1, -1, -6, -31, 19, -1, 0, 9,
    2, 10, 30, 5, 12, 2, -5, -28,
    -7, -11, 14, -11, 7, -18, 2, 12,
    -12, 14, -14, 21, 18, 5, -5, 1,
    18, 9, 8, 25, 29, 22, -32, 17,
    0, 12, 22, 1, 5, 9, 7, 6,
    44, -14, 13, 17, 34, -6, -10, 39,
    -40, -2, 4, -29, 0, 16, 25, 3,
    21, -12, 5, -12, 43, 6, -16, 36,
    -11, 35, -14, 1, -11, 18, 5, 14,
    2, -8, -4, -12, 6, -25, 9, 5,
    -11, 6, -4, 0, -10, 19, -5, -8,
    -1, 32, 10, -15, -3, -47, 2, -5,
    -37, 4, -13, 21, 27, -17, -1, -64,
    -7, -18, 24, 25, 5, 21, 1, 4,
    7, -7, -7, -13, 20, -16, -2, 4,
    -4, -11, -18, 0, -7, 27, -23, 2,
    -5, 21, 5, 16, -6, 3, 5, -26,
    -2, 13, 2, 0, 35, -3, 16, 18,
    8, -22, 0, -2, 34, 13, -21, 10,
    2, 10, -5, 14, 4, 14, 12, -9,
    21, 1, 30, -3, -6, 8, -7, -7,
    38, 19, 5, 22, 4, 38, -1, 15,
    -12, -2, -17, -10, 14, 10, 19, -1,
    19, 32, -2, -1, -3, -38, 0, -4,
    15, 11, 1, -11, -7, -2, -10, 4,
    0, 17, -4, -6, -1, 0, -1, 0,
    11, 1, -7, -7, 16, 14, -10, 13,
    -13, -5, 10, 26, -11, 37, -2, 6,
    27, 6, -14, -26, -16, -2, 11, 2,
    2, -14, -1, -18, -10, 14, -7, 25,
    4, -8, 7, -10, 5, -15, -8, 1,
    21, -16, 0, 24, -7, -21, 28, -4,
    -11, 10, 19, -21, 30, -3, -5, 8,
    16, -10, 5, -24, 9, 6, -1, 2,
    -4, -2, -6, -4, -5, 17, 8, -1,
    16, 25, -22, -1, -2, 13, -9, -27,
    -33, 10, -4, -20, -5, -8, 20, 11,
    13, 9, 10, 3, 20, 0, -1, 4,
    9, 2, 1, -4, -18, -11, 46, 12,
    -10, -34, 13, -1, -5, -27, -7, 24,
    28, 4, -10, 2, 0, 12, -11, 0,
    0, -18, -1, -15, 33, -9, 18, -1,
    5, 39, -3, -7, -29, -8, -18, -36,
    33, 9, 16, -8, -29, 8, 1, -4,
    42, 27, -18, -30, -28, -17, 4, -18,
    -9, 11, -18, 3, 2, -11, -27, -7,
    -5, 8, -5, -7, 8, -6, 0, -16,
    3, -19, -3, 27, -20, 26, 2, -8,
    19, -26, 0, 12, -6, -8, 3, -17,
    3, -3, -17, -7, 18, -21, -26, -16,
    -18, 11, 2, 2, 14, 6, 0, 21,
    8, -6, 2, 8, 7, -23, 2, 7,
    4, 23, 4, -9, -6, 14, 4, -14,
    -13, 1, 0, 8, -12, -2, -32, -9,
    -5, 8, 8, 8, 23, 4, -26, -1,
    -8, -20, 14, -3, -14, 32, 1, -13,
    -28, -23, -9, -1, -13, 11, -19, 5,
    -17, -30, 4, 3, 2, 0, 8, 47,
    0, 2, -13, -3, 5, -10, -3, 27,
    -15, -6, -20, -16, -4, 51, 21, -18,
    40, -26, -16, 28, -11, -5, -26, 10,
    -7, -2, -9, -10, -16, 0, -3, -22,
    -1, -2, 9, -1, -2, 17, 15, 15,
    28, -24, 19, 14, -13, -8, 9, 3,
    21, 8, 15, -13, 6, 2, 8, 38,
    6, -1, 2, -18, 32, -17, 4, -21,
    -5, 3, 4, -9, 19, -18, 32, -25,
    -5, -2, -44, -6, 4, 3, -18, -38,
    -18, 10, 11, -15, -6, 8, -1, -4,
    4, -7, -4, -11, -5, 7, 15, 13,
    -11, -7, -7, -7, 20, -3, -5, -41,
    23, 0, 5, 31, -3, 24, 21, 5,
    15, 8, -21, -1, 21, 14, -23, -20,
    5, -3, -14, 28, 42, 4, -5, 30,
    0, -2, 13, 24, -10, 16, -13, -6,
    7, -19, -4, -24, 2, -20, -15, 8,
    -13, 21, -4, -29, 0, 18, 4, -2,
    -7, 8, 16, -1, -40, 9, -20, -18,
    49, 8, -2, -12, -18, -7, 52, 14,
    31, 6, -10, -25, -3, 5, 20, -28,
    -14, 12, -13, -21, 5, 68, -17, -1,
    -9, -1, 17, -14, -17, -8, 5, -55,
    14, -2, -2, 8, -7, -64, 42, -37,
    8, 2, 42, -25, 16, -6, -37, 50,
    1, -11, 23, 1, -33, 2, 16, 27,
    27, 41, -7, -7, -57, -39, 44, 38,
    -47, -30, -12, 8, -21, 13, 21, -11,
    0, -34, -25, -12, 3, 30, 23, -30,
    -5, -20, -20, -6, 15, -6, -8, 12,
    3, 14, 8, 7, -20, -36, 8, 3,
    -10, -1, -8, -21, 15, -12, -6, -61,
    -4, -11, -2, -32, -9, 2, 3, -2,
    -52, -35, 12, 24, -39, 5, 11, 3,
    -8, 3, 21, 9, -30, -7, -5, 18,
    12, 1, 8, -1, 35, -3, 30, 14,
    -28, 17, 11, 4, 23, -4, 1, 6,
    -32, 8, -11, 3, 15, -13, 39, -17,
    7, 5, -24, -40, -45, 24, -10, -27,
    -14, 1, 7, -19, 19, 6, -27, 17,
    -25, -38, 7, 23, 1, -7, -10, 8,
    -13, -6, 24, 2, 7, -31, -38, -9,
    -18, -13, 0, -1, -13, -16, 11, -24,
    10, 8, 13, -7, -5, 15, -40, 12,
    3, -3, 9, 26, 20, -5, -22, -6,
    -21, -5, 20, -12, 13, 0, 1, 3,
    16, -1, 3, 7, 31, 2, 13, 13,
    8, 0, -6, -10, 6, -5, 33, -2,
    32, 18, -10, 5, -64, 1, 0, -19,
    19, -12, -17, 24, 21, 34, 5, -13,
    6, 0, 13, -6, 26, -16, -9, -44,
    16, 5, 4, 4, -20, 14, 7, 1,
    -9, -8, -13, 4, -9, -12, 19, 1,
    6, -1, 7, -1, -3, 6, 0, -2,
    7, 50, -3, 21, -48, 37, 0, 17,
    -4, -66, 0, -20, 2, 2, 3, 20,
    17, 25, -11, -10, -12, 8, 42, -49,
    25, -16, -8, -28, 21, 23, -6, 3,
    20, 6, -20, -2, 20, -38, -16, -22,
    3, -7, -3, 4, -16, -47, -9, 18,
    -2, -10, -13, 9, -24, -4, -7, -29,
    -10, -32, 21, 12, 10, 5, 10, -4,
    24, -13, -14, -16, 15, 8, 28, -8,
    0, 14, 7, 7, 42, 28, -25, 10,
    11, 23, 21, 20, -3, 8, -16, -28,
    7, 7, -3, 27, -10, -18, -32, 8,
    -9, 0, -39, 11, -12, -19, 9, -31,
    12, 7, -7, -3, 21, -20, 3, -26,
    -26, -1, -28, 21, 17, 6, 27, -5,
    -10, 3, 10, -1, 33, -9, -13, -38,
    -4, -15, -5, -20, -5, -19, 13, -35,
    -8, -3, -12, 9, 7, -3, -22, -6,
    36, 4, -7, 22, 32, 10, -39, 17,
    3, 1, -16, -6, 23, -8, 8, 16,
    49, -14, -4, 17, 33, -2, -1, 10,
    -35, 2, 11, -15, -13, -19, 42, -1,
    -26, -4, 36, 1, 37, -21, -16, 29,
    -13, -3, 13, -49, -18, 21, 10, 20,
    5, -6, 4, -4, -2, 1, -1, 6,
    -23, -1, -2, 13, 7, -11, -6, 15,
    9, 17, 42, -13, -7, -43, -15, -19,
    -7, -29, 15, -19, 8, 9, 10, -29,
    -17, -8, 27, 16, 32, -32, -16, 26,
    -3, 6, 7, -5, 21, 3, 36, 15,
    -4, 14, 22, -12, -12, 61, -16, -1,
    7, -8, -2, -2, -45, 3, 13, -47,
    9, 23, 12, -9, 2, 59, -34, -24,
    4, -17, 11, -1, 6, -8, -7, 5,
    6, -11, 47, -26, 2, 30, 16, -1,
    19, 59, -17, -25, 4, 18, 8, 18,
    30, -1, 30, -7, 9, 14, 24, 24,
    -10, 3, -13, 7, 24, 3, -4, 39,
    4, 25, 29, -5, -20, -25, -9, -9,
    11, -22, 10, -8, 21, -2, 3, -8,
    -4, -1, 11, 10, 15, -26, 35, 1,
    13, 0, -6, 4, 14, -18, 4, 50,
    2, 26, -18, 35, -16, 8, -10, 7,
    30, -48, -5, -10, -10, -3, 5, 11,
    12, -8, -16, -15, -10, 32, -8, 4,
    -2, -1, -12, 7, 32, -11, 23, 10,
    -2, -7, 27, -2, -4, 0, 32, 1,
    15, 28, 28, -29, 8, -14, -7, -2,
    3, -9, 10, -39, 7, -24, 30, -21,
    0, 2, -1, 15, -9, 49, 27, 25,
    12, 14, -8, 7, 15, 47, -8, -24,
    -8, -1, 20, -13, 8, -15, 43, 15,
    6, 0, 17, -3, 30, 2, 0, 2,
    -6, -8, 7, -3, -15, 21, 43, 9,
    -12, -27, 1, -20, 3, -34, -9, 11,
    14, -1, 25, 31, 2, 26, -18, -29,
    -21, -26, -5, -3, 54, -2, -6, -13,
    5, 44, -14, -9, 14, -17, -21, -14,
    30, -11, 2, 8, -27, 14, -10, -6,
    18, -25, 53, 14, -24, -28, -1, -3,
    -12, 21, -2, -19, -20, -25, -3, 28,
    -5, 28, -12, -9, 17, -29, 41, 5,
    -20, 19, -8, 18, 22, 33, -2, -4,
    -40, -14, 1, -10, -19, 16, 4, -5,
    -6, -3, -21, 12, -42, 8, -23, -2,
    18, 4, 4, -2, 6, -28, -6, 1,
    34, 21, -12, 37, -2, -9, -19, -3,
    16, -21, -24, 35, -8, 26, 2, 2,
    1, 3, -6, 1, 24, 48, -25, 37,
    14, -16, 5, -6, 15, 36, -20, 1,
    -1, -11, -14, -39, -4, 44, -14, -23,
    -33, 9, 11, 14, -6, 23, -10, 6,
    -17, -3, 13, -3, -13, -1, -44, -11,
    -4, 12, -2, 9, 1, -18, -7, 60,
    -5, 7, 19, -11, 12, 65, 12, -54,
    3, 17, 44, 28, -17, 16, -7, 19,
    -11, 2, -13, -10, -6, -4, -26, 60,
    -4, -1, 6, 6, -22, 27, 33, 43,
    40, 14, 38, 0, -27, -7, 31, -13,
    -33, 77, 9, -38, -20, 24, 45, 84,
    15, 9, 1, -17, -24, 68, 53, 41,
    -16, 24, -9, -20, -11, -27, 51, 26,
    0, -1, -55, 3, -70, 7, -24, -35,
    -43, 7, -46, -30, 10, 16, 57, 12,
    -9, 2, 0, -15, -18, -7, 25, 23,
    -9, 19, 14, 8, 36, 26, 7, -69,
    23, -7, 0, -1, 3, 28, 13, 0,
    -24, 51, 8, -21, -9, -23, -21, -23,
    -15, -14, -4, 27, 5, 55, 40, 13,
    -14, -20, -28, 45, -46, -83, -9, 11,
    -9, -67, 28, -29, 9, -11, -16, 12,
    19, -3, -23, -88, -5, 19, -18, -20,
    18, 10, -1, 9, -89, 12, 42, -35,
    -10, 34, 8, -34, -15, -36, 57, 2,
    -17, -43, 48, -21, -22, 39, 70, -51,
    29, -20, -11, 15, -15, 62, -10, -1,
    7, -20, 15, -28, -42, -17, 24, 105,
    19, 6, -8, 13, -60, -51, 114, -38,
    40, -44, -39, 2, -6, -1, -76, 114,
    31, 49, 26, 103, 9, 4, -28, -26,
    26, 103, 0, -10, 24, -101, -42, -9,
    -40, 78, -41, 24, -29, -4, 41, -44,
    21, -49, 35, 54, -35, 52, 48, -22,
    14, 32, 24, 5, 21, 46, -25, 46,
    -11, 0, -8, -2, -22, -12, -4, 12,
    -5, -21, -24, -54, 33, -5, -15, -52,
    23, 51, 29, 0, -81, -48, 8, -36,
    43, -8, 9, -23, -7, -1, 23, 5,
    -5, -28, 37, -23, 7, -11, -43, 33,
    8, -27, 51, 23, 60, 31, 28, 9,
    6, -14, 20, -40, -1, -20, 2, 4,
    -2, 0, 23, 63, 12, -6, 46, -5,
    -26, 17, 5, -29, 34, 2, 27, 3,
    -11, 25, 17, -70, 47, 41, -70, 9,
    10, 43, -20, 19, 19, 9, -16, 33,
    -38, 11, -27, -3, 13, 10, -51, -2,
    -19, -2, -18, 9, 54, 8, -12, 1,
    -10, 19, 2, -5, 11, 43, -60, 23,
    -19, 10, -10, 6, 36, 15, -21, -9,
    -29, -17, -38, -29, 45, 2, -4, -17,
    22, -1, -2, 19, -6, -20, -44, -8,
    6, -18, 14, 9, 9, 11, 46, 14,
    16, -66, -14, 30, -71, 18, -10, 5,
    33, 38, 3, -28, -9, 25, 25, -9,
    12, 9, 1, -23, -17, 27, -43, -24,
    40, -27, -22, 0, -3, -13, 28, 12,
    32, -28, 97, 32, -13, -2, 8, 13,
    -18, 4, 4, -51, -21, -2, 4, 21,
    -3, 16, 1, 5, -25, 77, 0, 19,
    13, -127, 12, -24, 14, 26, -5, 39,
    -4, 61, 16, 43, -6, -3, 8, -87,
    30, -41, 43, 32, 10, 8, -23, -10,
    -2, 4, -2, 3, -27, -24, 16, 17,
    -4, 31, -3, 5, -3, -49, 27, 58,
    11, 16, 69, -3, -77, 5, 4, -44,
    -24, -39, -5, 0, -18, 0, 27, -23,
    5, 13, -40, 0, -65, -39, -35, -23,
    32, 56, -1, 22, 43, 11, -48, 6,
    3, 10, -40, 4, 1, 3, -24, -38,
    -36, -1, -60, -1, 0, -5, -58, 43,
    14, 9, -21, -19, 7, -81, -5, 27,
    -21, -4, 7, -36, 33, -13, -25, -58,
    -23, 8, 52, 43, 20, 3, 48, -6,
    21, 11, -44, -52, 36, -1, 9, -7,
    -9, -16, 7, -5, 22, -5, 60, -53,
    -15, -10, -22, 6, -3, 10, -41, 21,
    -9, 16, 34, -19, 24, 14, -101, -3,
    19, 21, 4, -34, 12, -20, 13, -13,
    62, -11, -3, 12, 36, -17, -25, 6,
    -54, -6, 15, -7, -6, -41, 41, -19,
    -25, -35, -22, 17, 40, -18, -7, 26,
    -34, 46, 34, 45, 27, 10, 19, -12,
    -9, 1, -2, -1, -9, -15, 3, 1,
    -64, -11, -13, 13, -20, 45, 10, -1,
    1, -14, -49, -47, -30, -31, 0, -35,
    -9, 87, -28, -56, 20, -7, -26, -35,
    -11, -8, 24, 24, -12, -13, -27, 34,
    16, -38, 0, 3, 27, -19, 38, 15,
    19, -22, 10, 17, -25, 64, -33, -14,
    -28, 18, 12, 0, -45, 19, -46, -36,
    -1, -15, 12, -2, 32, -34, -21, -50,
    -8, -61, 44, 14, -46, -55, 15, 23,
    20, -19, -5, 58, -3, 82, -16, 33,
    7, -44, 27, 0, 26, 9, -46, -1,
    -2, 20, -32, 4, -19, -79, 72, -74,
    -8, 31, -82, 22, 43, 30, -21, 8,
    -43, -24, -67, 26, -26, -27, -1, 4,
    -2, 10, -11, 26, -3, -16, 3, 6,
    -5, -7, -17, -23, 14, -31, 0, 21,
    20, -1, -51, 27, 0, -38, -57, 27,
    7, 32, 9, 8, -15, -15, -17, 38,
    -18, -18, 17, 25, -49, -27, -32, -11,
    11, 3, 32, 9, -10, 18, 73, 28,
    0, -2, -52, 3, 49, -97, 74, 16,
    35, -44, -22, -42, -1, -38, 22, 3,
    -9, -21, 8, 39, 30, -47, -10, -12,
    19, -5, 6, -33, -47, 4, 15, -9,
    40, 5, -11, -88, -51, 46, 19, 11,
    39, 24, -4, -19, 12, 38, -7, -68,
    42, -16, 19, 28, 8, 7, 51, 14,
    11, 33, 27, -8, -22, 13, 33, -6,
    -15, 27, 2, 19, -49, 30, 64, 35,
    31, 2, 0, 12, 21, -13, -8, 12,
    -2, -17, -1, 23, 8, 26, -12, -5,
    -10, -18, 4, 6, -42, 62, -66, -32,
    42, 62, -15, 16, 15, -10, -24, -70,
    -1, 5, 79, 48, -63, 13, -30, -2,
    -18, 23, -30, 25, -53, -2, 11, 18,
    -14, 16, -11, 3, -36, -22, 12, 35,
    -5, 69, -68, 4, 21, -66, 46, 10,
    4, 21, -17, 5, 25, 24, -2, -3,
    39, 26, 13, -17, 2, 50, 2, -17,
    -13, -11, -9, 14, 34, -15, -40, -16,
    -19, -10, 3, -11, -11, -5, -3, 6,
    37, 4, 6, 44, -27, -33, -44, -44,
    -6, -52, 55, 34, -23, 15, -13, -9,
    1, 8, 14, 20, -55, -43, 2, -42,
    15, -2, 37, 14, 29, 56, -18, -57,
    43, -20, 7, -24, -6, 60, -8, -66,
    44, 10, -30, 34, -5, -39, -21, -19,
    -11, -5, 10, 7, -31, -21, -3, -67,
    14, 10, -3, 34, -6, -53, -20, 90,
    -9, -32, 9, 80, 10, 115, 33, -58,
    -14, -40, 33, -28, -12, -32, -30, 14,
    -14, -10, -4, -2, 10, 15, 53, 8,
    12, -9, 56, 32, -15, 8, 14, 21,
    -3, -40, 0, 28, 2, 18, -4, -15,
    -6, 35, -22, -35, -43, -5, 14, -21,
    -3, -12, 7, 6, -5, 7, 4, 3,
    16, 23, -11, 1, 28, -9, -6, 19,
    -5, 9, 17, 10, -6, 10, 4, 15,
    29, -20, 7, -13, -10, 5, -8, -7,
    -11, -7, 2, -13, -4, 4, 5, 3,
    -11, -3, 0, -7, 31, -1, 24, -15,
    -15, -13, 0, 12, 5, -10, -6, 7,
    14, -27, 2, 9, 15, 4, -11, 17,
    -2, 4, 0, -3, 0, -2, 7, 0,
    -12, 11, 7, 7, 21, 52, -17, 12,
    5, -13, -1, -12, 7, 5, 19, 2,
    -19, 25, -4, -12, -5, 33, -5, 2,
    11, -13, -2, 1, 9, 1, 3, -9,
    -22, 14, -1, 11, -28, 29, -1, 2,
    -1, 27, -18, -3, -25, 5, 10, 12,
    20, -6, -41, 15, 26, -38, -17, 18,
    -6, -2, 7, -5, 0, 0, -5, 1,
    -13, -18, -7, -3, -11, -17, -7, -19,
    -26, 4, -2, 9, -24, 15, -4, 4,
    3, 33, 3, -46, -11, -3, 5, 24,
    9, -8, 11, 6, -3, 2, -3, -14,
    1, 1, 1, 1, 21, 25, 4, 10,
    38, -1, -20, -5, 6, 7, -6, 0,
    0, 8, -10, 3, -56, 9, 13, 23,
    0, 3, -9, -11, -7, 0, -2, -5,
    29, 7, -11, 13, 36, 5, 30, 17,
    -29, 16, -16, 21, 18, -1, 3, 12,
    34, 20, -8, 9, 38, -49, -4, -28,
    -12, 2, 3, 11, -8, -4, -7, 1,
    1, -1, 8, -13, 11, -26, 1, 7,
    -7, 18, 15, 4, 3, 1, -1, 2,
    19, 20, 24, -8, 5, -7, 47, 8,
    -2, -11, -11, 5, 8, -8, 4, 0,
    -9, -3, -14, 12, -23, -15, 20, -13,
    9, -30, 1, -9, 0, 9, 7, -11,
    -31, 58, 72, -3, -5, -23, 6, 25,
    -2, -11, -14, -5, -4, 3, 1, 6,
    6, -2, -4, -5, 57, -6, -7, 23,
    8, 6, -17, 0, 1, 3, -4, -6,
    21, 5, 21, 6, -5, -11, 15, 9,
    0, 7, -4, -8, 5, -3, 9, -4,
    6, -4, 11, 39, -6, -3, -21, 31,
    14, 2, -17, 0, 7, 5, 4, -8,
    -42, 47, -2, -22, -6, 5, -39, 8,
    1, -7, -16, 2, 6, -6, -7, -9,
    9, 7, 16, 1, 1, 20, 16, 24,
    24, -30, 2, 20, -1, 2, 3, 19,
    -50, 16, -8, 12, -10, 4, -11, -25,
    -11, 1, -6, 1, -9, -8, 0, 1,
    5, 6, 3, -2, 5, -1, 0, 32,
    6, 16, 1, -1, 13, -3, -14, 6,
    21, -21, 14, 34, -37, -14, -63, 19,
    9, -7, 3, 7, 14, -3, 0, 8,
    1, -7, 11, -2, -24, -15, -33, -8,
    10, -20, 5, -6, -2, -21, -15, -1,
    20, -15, 27, 15, 6, -5, 5, 14,
    -1, -2, 8, -7, -5, 1, 3, -4,
    0, 11, 3, 30, -10, 51, 9, 22,
    8, -50, 7, -2, 1, 2, -9, -13,
    54, -4, 64, -13, -23, -23, -16, -37,
    -9, -7, -1, -10, 11, 2, -1, 8,
    -4, 39, -9, -2, -13, 0, -2, 16,
    31, -2, 2, 18, -7, -15, -4, 2,
    -11, 0, 16, 6, 7, 1, -21, -3,
    -3, 4, 2, 4, 3, 4, 2, 4,
    -1, 1, 15, -6, 13, -5, -6, -18,
    -11, 0, -11, -51, 13, 17, -8, 7,
    21, -26, 31, -9, 13, 8, 13, -20,
    6, 3, 10, 6, -13, 2, 0, -1,
    1, 10, 1, 30, 3, 15, 16, 22,
    -1, 2, 1, -12, -5, -2, -1, 2,
    20, -23, -5, 42, 34, 13, -5, 25,
    10, 8, -10, -5, 5, 6, 1, 2,
    -17, 0, 3, -6, -14, 27, 10, 5,
    7, 8, -2, -4, -3, 7, 2, 13,
    54, -9, -6, -30, -21, 9, 33, 10,
    -7, 2, 5, 13, 3, 0, -1, -2,
    -16, 3, 4, 8, -8, 10, -2, 24,
    0, 8, 4, 11, 0, 0, 14, -13,
    6, 50, 37, 13, 51, -58, -2, -14,
    3, 0, 1, 3, 2, 0, -11, 2,
    -1, -7, -3, -8, -23, 13, 19, 0,
    -5, 25, 8, -14, -8, -5, 19, 1,
    -18, 6, -2, -22, -10, -10, -5, -9,
    -6, 2, 10, 7, -3, -5, -8, 8,
    18, 9, 16, 13, 39, 24, 0, -4,
    -4, -7, -4, 55, 6, 4, -3, 4,
    -9, 36, -1, -42, -26, 6, -3, 7,
    4, -2, 3, 5, -3, -8, 15, 5,
    -6, 7, -11, -38, 25, 0, -9, -21,
    -25, 11, -2, 11, -2, -6, 6, 10,
    -29, 13, -9, -10, -49, -18, -9, 21,
    3, 6, 15, -12, -6, 2, -8, -5,
    -4, -18, -1, 3, 0, -8, 5, -19,
    1, -2, -3, -34, 11, -4, -10, -3,
    53, -6, -3, 2, -4, 23, 10, -13,
    -2, 13, 1, 11, 9, -1, 14, 8,
    -3, -7, -8, 8, 2, 1, 4, -16,
    -21, -19, 18, 10, -1, -5, -13, -11,
    -16, 5, -31, -5, 11, 1, 14, 6,
    5, 6, -7, -3, 7, 1, 0, -4,
    -2, -13, 4, 14, -23, -1, -9, -33,
    -17, 47, 24, 25, -16, -11, -18, 13,
    6, -27, 14, -29, 9, -7, -12, -31,
    -11, 8, -5, 3, -10, -10, -7, 0,
    -1, 0, 21, 10, -26, -13, -17, 28,
    -16, -16, -9, 36, -6, 20, 14, -15,
    -5, -24, -16, 41, 24, -21, -3, 26,
    2, 1, 14, -14, 0, -5, 3, 0,
    14, 4, -10, -7, 51, -19, -2, -28,
    -21, 12, -18, 6, 8, -12, -13, -11,
    -24, 6, 22, -21, -28, -1, -17, -8,
    -4, 6, 1, 10, -4, 0, -2, 3,
    3, -9, -1, -4, 28, -5, 3, -1,
    -4, 33, 1, -2, -22, -7, 0, 2,
    37, 10, -16, 17, 8, 9, 22, -23,
    -1, -3, 3, 5, 1, -2, 3, -10,
    -10, -1, -6, 3, -27, -24, 11, 1,
    24, 21, -6, 14, -1, -7, 14, 6,
    66, -34, -20, 55, 13, -1, -39, 10,
    -2, -4, 10, -5, 4, 0, -7, 5,
    9, -8, 2, 9, 33, 10, -7, -22,
    12, -10, -21, -9, 5, 1, 4, 6,
    17, -17, -5, 3, 1, -8, 3, -29,
    -6, 6, -2, -3, -14, -5, 1, -6,
    0, -10, -2, 7, -2, -25, -1, -11,
    -20, -9, 16, 6, 24, -3, -17, 9,
    26, -40, 3, -14, 34, -19, 5, 15,
    -14, 10, 8, -11, 9, 7, 8, -23,
    0, 29, -10, -5, 19, -21, -9, -11,
    0, 23, -6, 7, 15, 12, 7, 1,
    2, 2, 8, 8, 50, 12, 10, -12,
    12, -3, -8, -10, 16, 0, 15, 19,
    -19, -3, 14, -7, 24, 0, 24, -31,
    -3, 13, -32, 5, 14, -21, -1, 9,
    -15, 5, -2, 9, 27, 34, 24, 25,
    -3, -8, -14, 2, 6, 17, 31, 8,
    -7, 6, -6, 6, 8, 34, -31, 20,
    7, -12, 15, 7, 6, -11, 19, -8,
    9, 12, -27, 34, 23, -55, -3, 5,
    -11, -25, -20, -1, -3, 2, -30, -6,
    -1, -5, 12, -2, 6, 29, 8, -5,
    2, 10, 2, 5, 21, 6, 1, 13,
    -5, -1, 8, -38, -10, 0, 19, -34,
    -21, 12, 1, -3, -30, 3, -2, -32,
    2, -4, 0, -1, 9, -9, -3, -19,
    -21, -13, -5, -15, -24, 0, -1, -3,
    -9, 13, 21, -39, -56, -2, 31, -28,
    13, -3, 22, 5, -4, 1, 23, 4,
    7, -10, -7, 2, -1, -17, -20, -7,
    12, 11, -3, -21, 24, -5, -19, -11,
    7, 8, -16, -10, 8, 25, -9, -47,
    1, 6, -6, -21, 20, 11, -9, -5,
    6, 16, -15, 17, 34, -5, 28, 20,
    -7, 6, 16, -1, -14, -6, 10, 0,
    -31, -32, 37, -22, -27, 32, 34, -14,
    35, -3, -3, -34, 3, 3, -13, -1,
    -13, 11, 18, -17, -23, -7, 10, 2,
    16, 2, -22, 7, 1, 3, -5, -3,
    11, -38, 10, 41, -5, 13, -25, 1,
    -11, -10, -10, -5, -6, 4, 3, 0,
    -14, -5, -12, -4, -36, -3, 9, 12,
    -20, -26, -30, -4, -30, -25, 11, 6,
    57, -12, 28, 4, -24, -30, 8, 12,
    -2, 8, -23, 13, -6, 9, 8, 3,
    -15, -7, 10, -3, 29, 20, 13, -11,
    -2, -13, -12, -8, 16, 16, -14, 8,
    17, -1, -10, -37, -27, -28, 23, -29,
    11, -4, 3, -9, -8, -1, 27, 2,
    -15, 2, 8, 74, 16, -9, -5, 5,
    -22, -3, -9, -27, 2, 15, 16, 9,
    -18, -37, 30, 41, 14, 30, -33, -5,
    -15, 4, -19, -19, 3, 32, -6, -10,
    8, 6, 21, -13, -7, 68, 13, 8,
    9, -27, 7, -6, -8, -1, 10, -12,
    -35, -10, 3, 40, -14, -26, -10, -52,
    -23, -17, -2, 3, -6, -3, -2, -4,
    0, 20, 1, 2, 1, 9, 7, 35,
    5, -2, 12, 15, 12, 18, -2, 11,
    -7, -7, 6, 41, 39, 50, 98, -19,
    4, 8, -36, 16, -8, 50, 4, -9,
    8, 14, 9, 1, -9, 20, 2, -4,
    16, 11, -21, -8, -19, -12, 0, -2,
    9, -12, 35, 49, 21, -3, -9, -9,
    -14, 0, 3, -19, 0, -3, 6, -9,
    -8, 12, -5, 28, 13, 30, 10, 5,
    26, -34, 14, -13, -2, 7, 9, 0,
    47, -25, 21, -10, -6, 1, -29, 11,
    -4, 9, 6, -16, 3, 1, -7, 5,
    0, 75, 2, 8, -14, -39, 26, -2,
    -36, -5, 8, -18, -8, -16, -4, 1,
    -3, 15, 43, 49, -14, 6, -57, -63,
    -33, -6, 0, 7, 22, -1, 5, -21,
    0, 7, 2, -3, 27, -4, 7, 23,
    3, -6, -6, -3, 15, 12, -10, -1,
    34, 7, 36, -21, 8, 4, 42, 15,
    10, 3, 19, -1, 1, 0, -13, -10,
    -7, -1, -8, 58, 4, 3, 7, 3,
    17, -21, 5, -1, -22, 14, 3, -13,
    12, 41, 15, 20, -20, -12, -7, -12,
    -1, -2, -5, 9, -14, 3, 3, -11,
    -11, 1, 3, -10, 22, -4, 5, -4,
    19, 9, -20, -6, -18, 6, 24, 12,
    15, -6, 14, -5, 5, -27, 33, 27,
    -11, 2, 12, -11, 1, -13, 5, -3,
    10, -28, -3, -3, 0, -3, 26, -9,
    24, -6, 5, -27, -5, -5, 27, 2,
    18, 25, 61, -22, 13, 40, -2, 3,
    14, 4, -13, 20, -17, 5, 8, 14,
    12, 2, -4, -7, -38, 2, 3, -3,
    -28, 3, 40, -17, -28, -5, 32, -20,
    -10, -5, -14, 10, -6, -67, 10, -53,
    13, -14, -5, -22, -8, -16, -7, -1,
    23, 20, 2, 0, 9, 12, 19, -20,
    -12, 14, 28, 36, 21, 19, 18, -3,
    30, 34, -59, -2, -7, 44, 3, 25,
    -8, -3, 10, 15, 7, -20, 16, 10,
    -2, 22, -21, -63, 25, -13, 8, -33,
    -1, -9, 6, -4, -15, -6, -4, 22,
    -10, -46, -43, 29, 31, 6, -38, -11,
    -5, -7, 13, 19, -9, 19, 2, -8,
    -19, -47, -2, -1, -5, 23, -4, -23,
    -8, 4, -10, 25, -16, -9, -13, 21,
    22, -4, 32, 7, -28, 31, -44, -35,
    -6, 0, -1, -13, -1, 33, 18, -8,
    -15, -20, -7, 1, 44, -32, -4, 28,
    3, -12, -10, 0, -12, -11, -9, 9,
    -44, -15, -12, -17, 5, 13, 36, 14,
    -4, 10, -10, -4, 7, 3, 2, -4,
    8, -28, 1, -1, -12, 7, 2, -33,
    15, 12, -2, -19, -10, 1, -5, -23,
    -24, -1, 34, 34, 20, 25, 20, -22,
    2, 10, -10, 4, 5, -18, -16, -17,
    14, -11, 27, 18, -11, 11, -3, 7,
    3, 4, 4, -9, 5, 17, -17, -12,
    27, -22, -10, 28, -18, 18, 80, 21,
    6, 0, -26, 0, 4, -6, -20, 2,
    4, 2, -7, -53, 14, -3, -35, -14,
    -8, -34, 10, 26, -27, 15, -3, -4,
    -28, 20, -2, 9, 68, -9, -5, -36,
    37, 6, 8, -5, -35, -11, -5, -5,
    -24, -16, 0, 3, 11, -42, 2, -4,
    -13, 20, 2, 2, 3, 6, 4, -2,
    29, 21, -3, 15, 2, -8, -32, -24,
    -19, -15, 26, -18, 2, 8, -2, 10,
    -1, 21, 10, -12, -17, 16, -3, 16,
    -25, 24, -2, -1, -11, 11, -19, 15,
    -7, 19, -20, -49, 14, 111, -7, 17,
    4, -8, -3, 23, 15, -15, -17, 8,
    -6, 2, -15, 1, 4, -28, -2, -21,
    14, 14, -4, -13, -9, 1, 11, -6,
    6, 6, -13, -8, 19, -30, 67, -50,
    -9, 8, -13, -6, -17, 10, 16, -14,
    -3, -22, -8, 2, -14, -9, -8, 49,
    25, 54, 18, -15, -27, 12, -9, 2,
    -56, -30, 59, 30, -19, 37, 15, 60,
    -19, 3, 8, -33, 34, 1, 7, -62,
    12, 24, -15, -7, -63, 3, -11, 38,
    20, 8, -67, -6, 12, 33, 6, 1,
    -29, -7, 38, -73, -24, -100, 49, -46,
    9, -11, -40, -16, 50, -3, 8, 29,
    -26, -4, 16, 0, -15, 31, 2, -43,
    17, 7, 77, 17, -13, 36, -5, 16,
    -88, -18, -1, -3, -55, -68, 18, -7,
    -6, 23, -26, 2, 9, 43, 63, 13,
    -10, 18, 5, 10, -41, 63, 25, 21,
    2, -26, 6, -43, -10, 27, -34, 0,
    2, -19, 6, 29, 29, 41, -2, -15,
    5, -15, -52, -4, 1, 25, -87, 1,
    6, -7, 4, -20, 15, 4, -18, 33,
    36, 5, 8, -4, 10, -27, 5, -13,
    62, 25, 73, -40, -2, -15, -11, -14,
    -22, 18, -5, -12, -74, -17, 8, -42,
    -1, 13, 1, -4, -30, -57, -12, -4,
    46, 3, 13, 6, 23, 1, -15, 7,
    43, 19, -64, 23, 58, 25, -7, -102,
    24, -8, 36, 21, 6, -10, 47, 32,
    15, -4, 2, -5, -6, 1, -8, 36,
    -58, -25, -14, -25, 14, 21, 21, 15,
    58, 68, -40, 6, 25, 24, -35, 51,
    -12, 14, 8, -26, 29, 57, -36, 0,
    14, 7, -18, 19, -23, 14, 32, 20,
    18, -32, -28, 2, -3, -6, -8, 41,
    -50, -8, 32, -10, 11, -27, -12, 19,
    66, 1, -32, -78, 14, 6, -29, -20,
    -11, 11, 23, -14, 55, -18, 20, 51,
    -22, 23, 21, 16, -6, 10, 44, -7,
    -41, -43, -36, 28, -26, 18, -21, 66,
    -65, -42, -13, -7, 0, 24, -9, 4,
    -17, -4, -18, -3, -2, 7, -3, -3,
    -17, -17, -38, 28, 71, 58, -9, 8,
    -4, 23, -21, 41, 54, 27, 7, -45,
    -14, -23, -17, 42, -2, 30, 4, -23,
    -28, -12, 10, 3, 24, 16, 6, 7,
    -1, 31, -2, 38, 36, 17, 15, -36,
    41, 28, 40, -38, 7, 30, 15, 20,
    12, -25, -5, 6, -23, -6, 38, 10,
    -30, -3, 13, 114, 40, -8, 10, -28,
    12, -30, 22, 32, 20, -14, -12, 20,
    41, 43, 37, -68, 38, -1, 35, -1,
    -22, 14, -16, -35, 7, 102, 13, 19,
    8, 3, 29, -2, 26, -8, 0, 12,
    -13, 50, 35, -14, 6, -23, 25, 59,
    86, 6, 28, -29, 32, 55, 24, 4,
    -18, -21, 0, 7, -20, 2, 0, -10,
    -12, 22, 2, -11, 18, 12, -12, 35,
    -13, -19, -37, -39, -27, 25, -21, 46,
    -47, 31, -24, 41, 20, -29, -40, 60,
    4, -6, -68, 38, 5, 99, 6, -12,
    -7, 20, 24, -2, -37, 28, -33, -49,
    24, 18, -17, 2, 39, 18, 20, -24,
    -11, -14, -7, 17, -111, -1, 59, 22,
    -31, -5, -1, -5, -2, -10, 29, -6,
    -6, 30, -16, 44, 23, 18, -23, -10,
    -25, 63, 9, 16, -16, -11, 15, 17,
    45, 8, -18, -39, 47, -2, -53, 65,
    6, 31, -5, -34, 23, 1, -14, 20,
    22, 107, 14, 17, -48, -68, 51, 9,
    -42, -2, 23, -35, 28, -19, 40, 26,
    -32, 31, 71, -23, 19, 24, -76, 67,
    -54, -8, -16, 26, 30, -1, 18, -56,
    6, -2, 11, 14, 33, 10, 15, -9,
    32, -14, -42, -16, -23, -63, 46, -18,
    -14, 27, 23, -35, -2, -22, -27, -10,
    5, 0, 30, 26, -2, 11, 3, 2,
    4, -9, -22, 67, -28, -10, 32, -26,
    -17, -9, 34, 19, 30, -45, -1, -22,
    -26, -46, 13, -41, 35, 41, 43, -51,
    -10, -31, -2, -5, -52, -10, -3, -34,
    -4, 9, 12, -16, -42, -8, 10, 4,
    10, -15, 8, -13, 33, -11, -68, -11,
    -9, -34, -55, 4, -27, -52, 27, 67,
    -41, -2, 23, -37, -26, 8, 6, -8,
    12, -29, 7, 0, -26, -3, 13, -14,
    -17, 3, 50, 21, 16, -8, -20, 11,
    39, -42, 0, -36, -14, 3, -27, 17,
    67, 26, 22, 55, -63, -12, 85, 19,
    24, 1, 5, 10, 43, 86, -12, 25,
    8, -11, 2, 10, 15, -34, -30, -2,
    35, -17, -32, -20, 16, 48, -90, 40,
    -6, 3, 8, -47, 9, -10, -10, -1,
    30, 39, 6, -2, 27, 50, 27, 3,
    -3, 15, -22, -107, -6, -9, 7, -21,
    4, -60, 20, -3, 45, -83, -8, -61,
    -7, 14, 18, 21, -2, -22, 19, -7,
    2, 41, -18, -77, 67, -29, -7, 29,
    12, -3, 21, 12, -10, -8, 0, -9,
    40, -11, -20, 29, 28, -42, 15, -25,
    -12, -33, 57, 19, -57, 8, -13, -24,
    -29, -31, -5, -18, 32, -10, -9, -9,
    -3, 34, 23, 12, 39, 12, 3, -11,
    -16, -40, -12, 56, 46, 21, -65, 17,
    -22, 13, 12, -7, 3, 111, 58, -12,
    -4, -27, -5, 8, 31, 59, 0, 15,
    1, -2, -17, -40, 1, 23, -17, 24,
    36, 3, -18, -24, -59, -2, 43, -26,
    -22, 14, -5, -10, 34, 15, -5, 7,
    8, -17, -9, -2, -62, 79, 3, -12,
    16, -36, -8, -7, 3, 15, -3, 41,
    -21, 28, 58, 71, -12, 21, -17, 44,
    5, 14, 2, -19, 13, -24, -21, -36,
    28, -9, 18, 21, -3, 12, -16, 58,
    10, 17, 4, -42, 5, -33, 32, 17,
    20, 23, 40, -4, -26, -52, -88, -41,
    18, 1, -71, 14, 15, -7, -63, 10,
    9, -11, -12, -99, 52, 14, 16, 88,
    -9, 24, 9, 5, 23, -15, 5, 16,
    -46, 46, -21, 34, -65, 15, -30, -8,
    97, 32, 4, -47, -96, -33, -7, -22,
    -8, -15, -6, 0, 8, -48, 14, -22,
    60, 0, -1, -22, 23, -1, 8, 1,
    10, -20, 34, 36, 28, -18, 87, 37,
    -11, -25, 78, -23, 6, -4, -12, -10,
    22, 23, 2, -6, -9, -1, 9, -31,
    -28, -10, 14, -1, -32, -31, -24, -52,
    -105, 101, -21, -56, -37, -54, 17, -68,
    23, -19, -24, 44, -4, 5, -4, -6,
    -5, 3, -1, 4, 20, -31, 11, 6,
    -19, 29, 43, -5, -6, -26, -39, 27,
    -28, 49, 11, 20, -19, 0, -85, 29,
    -9, 6, -48, -34, -67, 20, -2, -23,
    -2, -11, -10, 4, 8, -33, 23, 44,
    25, -45, -9, -2, 10, 9, 2, -5,
    1, 0, 9, 12, 6, -39, 6, -17,
    -18, 4, -15, -4, 4, -1, 2, -4,
    -1, -31, 9, 25, -26, -22, -13, -11,
    37, -24, 1, -16, -2, -4, 1, 0,
    0, -15, -4, 16, 0, -5, 4, 13,
    9, -37, 24, 4, 4, -3, 1, -2,
    9, -5, -7, 9, 7, 7, -6, -21,
    11, 3, 11, -14, 13, 9, 19, 11,
    20, 46, -27, 11, 5, 9, 20, -12,
    19, -2, -11, -19, 5, -2, 2, 1,
    7, 24, 6, -11, -13, -16, 7, -10,
    -6, -53, -20, 11, 19, -2, -10, 0,
    1, -5, -14, 12, 2, -37, -5, -7,
    -21, -14, 22, 9, -4, 8, 5, 4,
    -6, -4, 0, 1, -3, -33, 12, 14,
    18, -13, 22, 13, 5, 21, -19, 33,
    47, 36, 17, -1, -4, 13, -9, -12,
    14, 12, -10, 5, -3, -12, 3, -2,
    7, -19, -9, 11, 16, -37, -4, 1,
    -7, 17, 22, 6, -31, -9, -8, -5,
    -5, -13, 0, 55, 15, 12, 29, 11,
    5, 4, 14, -3, 4, 2, -4, 0,
    -5, 2, -13, 28, -14, -17, 5, -2,
    -6, 9, 26, 25, -6, 21, -14, 16,
    -8, 4, -4, -8, -7, 10, -7, 16,
    30, 32, -33, -42, -3, 2, 6, -1,
    -6, -12, -2, 7, -5, 15, -17, 0,
    1, -28, 26, 5, 0, 4, 9, -16,
    -1, 7, 13, -11, 34, -4, 8, 19,
    1, 14, -16, -4, 4, 4, -9, 4,
    28, -5, -5, 10, -10, 9, 16, -27,
    3, -7, 7, 2, 0, -15, 29, -20,
    -21, -26, 7, -1, 15, -1, 11, 20,
    -15, 8, 10, -10, 4, 2, 1, -2,
    -4, -3, 0, -1, -6, -7, -8, -20,
    -5, 34, 24, 23, 13, 10, 11, 23,
    4, -39, 51, -8, -1, 30, 23, 1,
    11, 2, 5, -10, 8, 3, -4, 6,
    -9, -24, 4, -32, -54, 5, 4, -21,
    -2, -2, -11, -16, 1, -10, 10, 4,
    11, 41, -43, -19, 13, -18, 8, -2,
    19, 19, -3, -23, 5, 0, 1, -1,
    -13, 27, 22, -13, -6, -1, 3, 12,
    -10, 4, -17, 11, -9, 10, 7, -11,
    -19, 56, -12, 16, -24, 9, 15, 14,
    -23, -1, 8, -9, 7, 0, 1, 5,
    -6, -10, -2, 5, 10, -29, 5, 27,
    -34, 3, 13, 6, -3, 1, -3, -24,
    5, -4, 9, 32, 3, 9, 6, 17,
    -3, 20, -23, 14, -1, -1, 2, 2,
    5, 8, -5, 0, -1, 15, -14, -1,
    -23, 1, -1, 12, -13, 11, -10, 18,
    32, -15, -37, -14, 7, 21, 8, 3,
    -12, 14, 6, -1, 0, -1, 4, 6,
    -21, -19, 4, -23, -17, -4, 1, 7,
    13, -52, 1, -24, -4, -4, 4, 36,
    -25, -8, -26, -6, 7, -18, 10, -27,
    34, 0, 4, 5, -3, -7, 2, -18,
    -5, 28, 31, 0, -16, -9, 38, 13,
    -21, -30, 0, -43, -21, 16, -1, -20,
    -19, -5, 22, 9, 17, 25, 15, -7,
    2, 16, -19, 26, -4, 1, -2, 6,
    -12, -5, 20, -6, -22, -13, 7, -34,
    5, 2, -3, 9, 13, -3, -5, 10,
    1, 1, 2, 37, -2, -19, 10, 30,
    10, 6, 1, 25, 0, -16, 0, 5,
    -4, 3, -5, -15, 3, 5, 22, -16,
    -12, -33, 22, -15, -4, -10, 17, 35,
    -47, 7, -44, 25, -27, -13, 26, 21,
    18, 1, -32, -17, 56, 8, -3, 2,
    -11, 8, -18, -4, 7, 0, 14, -29,
    32, -26, 6, -36, 5, 9, -5, 14,
    -13, 9, 20, 20, 13, 15, 16, -2,
    -6, -16, -3, -9, 0, 0, -2, -4,
    -17, 3, 4, 5, 14, 4, -18, -29,
    28, -3, 10, -3, 11, 26, 7, -19,
    45, 23, 25, 27, 3, 22, -34, -6,
    11, 4, -13, -19, 3, -5, -8, 13,
    -10, 0, -3, 1, -19, 10, -4, 8,
    20, -23, 24, -11, -8, -3, 27, 22,
    -22, -8, 2, -23, 19, 4, 10, 12,
    0, 11, -4, 7, 1, 2, -1, -1,
    7, 14, 10, -15, 18, 5, -8, -6,
    -4, 9, -25, -8, -9, -2, -1, 9,
    22, -16, 10, -24, 17, 44, -11, 16,
    -3, 24, 10, 0, 0, 0, -1, 9,
    -7, 0, 10, 21, -46, -2, -16, 18,
    0, -27, -5, 21, 18, 5, -6, -23,
    11, -7, 6, -6, -12, -7, 48, 11,
    11, -39, -23, -9, -4, -4, 4, -1,
    -3, -9, 9, -7, -9, 2, -19, 9,
    23, 6, -26, 35, -1, -8, 35, 22,
    -65, -4, -23, -31, -5, -8, -7, 18,
    -21, 1, 0, 6, -1, -2, -3, 0,
    -6, -18, -10, 16, -18, 19, -3, 7,
    -2, 15, 11, -7, 14, -9, 16, -1,
    12, -16, -2, -17, -14, -15, 23, 5,
    6, 27, 20, -8, 3, 2, 4, -7,
    3, 6, -10, -4, -9, 9, -28, -15,
    12, 26, 4, 8, -3, 6, 18, 17,
    -3, 5, -31, -4, 15, -9, 1, 17,
    7, -2, -16, 4, 0, 1, -3, 2,
    4, -2, 29, -7, 1, 3, 52, 11,
    -31, 30, 9, -9, 0, -5, 14, -13,
    -11, 37, 3, -15, -14, -21, 16, 22,
    5, -8, -18, 5, -8, -14, -3, 4,
    -10, 6, 22, -3, 43, -11, 10, -6,
    4, -4, -1, 10, -1, 1, -45, 8,
    21, -27, 27, -2, -19, 23, 8, -32,
    4, 15, -4, 13, -5, 0, 2, -1,
    -8, -21, 10, 13, -19, 5, 35, 10,
    -36, -32, 13, -19, -25, 3, -7, -15,
    24, -18, 40, 8, 4, -20, -10, 17,
    17, 17, 11, -18, -6, 4, -12, -4,
    -10, -7, 6, 2, -17, -12, -29, 5,
    5, 10, 25, -20, 0, -7, -10, 6,
    32, -4, 44, 5, -24, 24, -1, 4,
    23, 9, 9, 13, -4, 0, 10, 5,
    3, 20, 9, 1, -19, 9, -25, -19,
    -12, -6, 7, 3, -8, -17, -4, -15,
    10, 22, 51, 2, -14, 8, 5, 3,
    13, -6, -1, 6, 4, -4, 0, -6,
    -14, 2, -1, -13, -22, -19, 12, 23,
    -10, -10, -16, 10, 0, 11, -27, 1,
    7, -43, 2, 21, 0, -25, 9, 12,
    4, 21, 9, -24, -4, 0, -2, -5,
    13, 1, 1, 3, -3, -15, -14, -9,
    4, -7, -3, 15, -17, 32, 1, 9,
    10, 12, 12, 40, 9, -50, -17, -25,
    -27, 45, -4, -1, -8, 0, 3, 3,
    23, -21, 24, 0, 10, 5, -13, 6,
    33, -12, -16, -21, 7, 0, -17, 3,
    -28, 36, -12, 29, 29, 1, 19, 4,
    20, -15, 9, -4, 3, 0, 3, 9,
    -10, -9, -12, 6, -54, -18, 7, 1,
    8, 30, -22, -10, 6, -8, 4, 1,
    -31, 8, -38, 31, 9, 16, 9, -17,
    -27, -17, -56, -9, 0, -2, 2, 3,
    0, 4, -5, -16, -4, 4, -9, -7,
    -4, -57, 17, 11, 1, -9, 34, 5,
    26, -18, -3, -20, -10, -42, 23, -8,
    -7, 25, 20, -1, -1, -1, -2, 5,
    -5, -1, 18, 2, -10, -33, -34, 50,
    7, 16, 28, 4, 21, 24, -1, 43,
    29, -12, 23, 11, 27, 19, -16, -8,
    -17, -8, -7, 27, -1, -4, -3, -10,
    28, -8, -17, -11, 15, -10, -5, 18,
    20, 17, 22, 44, -5, 4, -25, 2,
    5, -5, -11, -36, -40, -16, 40, -7,
    25, -19, -9, -4, 1, 2, 1, 1,
    -7, -32, 7, 5, 17, -8, -33, 14,
    7, 8, -11, -6, 2, 7, -3, -11,
    -14, 26, 27, -4, -17, 2, 12, 13,
    -7, 3, -7, -3, -1, 1, 8, -6,
    -17, -32, 1, 2, -3, 4, -31, 13,
    -3, 19, 31, 13, -1, 9, 24, -3,
    -31, -13, -40, -49, -18, -11, 9, 14,
    -4, -48, -17, -25, 8, -9, -1, 3,
    3, 3, -8, 10, -14, -10, -25, -34,
    40, -10, 17, -43, -8, -9, 36, 5,
    -7, 14, -10, 15, -28, -11, 11, -6,
    8, -29, -6, 12, -6, -5, 0, -1,
    -7, 13, -12, 10, -10, -18, 28, -22,
    -27, 0, 15, 19, -16, 1, -6, -2,
    -42, -14, 18, 8, -32, -4, 47, 1,
    -13, -32, 21, 16, 13, -4, 0, 0,
    33, -29, -2, -8, -27, -17, -8, -23,
    19, 10, -9, -47, -26, -26, -24, -14,
    -41, 8, -33, -1, -36, 3, 14, -3,
    -8, -15, 5, -6, -1, -4, -8, -6,
    -8, 24, -12, -22, -24, -11, 4, -13,
    16, -49, -17, -19, -8, -52, 7, 16,
    -16, 47, -48, -17, 5, -18, 28, 8,
    15, 17, -21, -34, 7, 0, 4, 6,
    -12, 2, -11, -13, -38, -35, -21, 7,
    -5, -13, 11, -29, -25, 31, 6, 13,
    -28, -33, 15, 3, -52, 10, 2, 0,
    -2, 3, -12, 32, -2, -3, 2, -5,
    2, 17, 12, 5, -20, 4, -21, -21,
    28, -7, 17, -26, -11, -32, 6, -17,
    -21, -4, -38, -20, 9, -21, 14, -21,
    -22, 4, -2, 15, 3, 0, -6, 3,
    -23, 1, -13, 4, -21, -17, -1, 19,
    4, -33, 6, 0, -37, -22, 19, 3,
    -21, 9, -31, -32, 17, 5, 13, 13,
    -18, -27, -10, -9, 8, 5, 4, -14,
    -9, 20, 10, -4, 4, -11, -21, -8,
    -9, 9, -42, 15, -8, -16, -36, 7,
    11, 1, 9, 37, -17, -5, 19, -20,
    -21, -3, 11, 7, -5, 5, 1, 3,
    15, 9, 8, -21, -25, 0, 7, -38,
    -19, -6, 15, -32, 20, 12, 22, -18,
    -17, -19, 1, 26, 16, -8, -15, 60,
    12, 14, 6, 29, 3, -20, -3, -3,
    -19, -10, -24, -5, 7, 5, 18, -2,
    12, -3, -20, 20, 7, -9, -17, 3,
    -26, -30, -5, 45, -13, -9, 3, 12,
    5, -12, -27, 21, 76, 11, 0, -8,
    -7, -6, -3, 8, -2, 4, -4, -10,
    2, -13, 3, 23, 8, -6, -2, -19,
    -46, 18, -13, 23, 42, 16, -2, 28,
    16, -6, 16, -1, 0, -3, 1, 4,
    36, -2, 22, 13, -19, -16, -22, 28,
    -32, -23, -21, 2, 0, -13, -12, -15,
    -23, 40, 19, 23, 10, 10, 28, 9,
    -7, 10, -32, -19, 0, 1, -7, 17,
    26, 24, -29, 16, 4, 9, -37, 11,
    24, -21, -30, 1, -22, -27, 12, -18,
    -14, 11, -6, -59, -1, 16, 6, 1,
    53, 24, -37, -17, -2, -11, -4, -2,
    18, 19, 22, -26, 14, -24, -20, -9,
    13, -13, 22, -1, -8, 8, -14, -5,
    -8, -26, 60, -39, -16, 22, -8, -20,
    -28, 58, 27, -10, 6, 3, 2, 5,
    -11, 11, 8, 28, -41, -19, 12, -12,
    20, 22, 10, 15, -10, -8, -6, -73,
    45, 1, -28, 8, -11, -9, 27, -8,
    -4, -18, 19, -45, -2, -1, 7, -3,
    -25, 4, -8, 12, 10, 4, -45, 12,
    -22, -12, -72, 14, -30, -11, 8, 19,
    20, -42, 16, -26, 1, 21, -30, 9,
    -5, -69, 4, -26, 11, -2, 2, -1,
    6, 18, 0, -7, 5, -34, -18, 18,
    -19, -64, -7, 19, 36, -13, 14, -13,
    -37, -11, -4, 3, -23, -47, 7, 16,
    -23, -6, 31, 22, 2, -2, 8, 9,
    5, 2, -3, 15, -15, 27, -12, -25,
    18, 20, 14, 20, 9, 1, 17, 0,
    13, 21, 1, 42, -27, -48, 10, 14,
    -14, -12, -8, 21, 1, -10, -10, 4,
    12, -26, 23, -22, 24, 6, 32, 6,
    11, 14, 23, -11, -19, -20, 4, -9,
    -28, 24, 20, -48, -9, -27, 26, -5,
    8, -6, -16, 11, 3, -22, -3, 3,
    -3, 26, 23, 7, -2, -27, 5, -24,
    -18, 16, 5, 17, -34, 8, 0, 15,
    12, -46, 7, -15, -22, -12, -24, -6,
    18, -11, -30, -30, 5, -5, 1, 1,
    -2, -51, 0, -7, -7, -8, -9, 43,
    3, 2, 3, -27, -34, 12, -8, -10,
    16, 5, 3, 37, 4, -46, 1, -7,
    -4, -9, 5, 16, 3, -1, 2, 3,
    -1, -24, 2, 23, -30, -17, -14, 18,
    -19, 19, 3, -32, -1, -19, -1, 20,
    5, -16, -1, -7, -52, 116, 6, -34,
    19, 3, -17, 7, -7, -2, 3, -2,
    9, 10, 18, 7, 49, 10, 11, -43,
    -10, -1, -13, -3, 4, 39, -6, -9,
    -34, 36, -5, -21, -8, -36, -7, -8,
    20, -22, -24, -34, 3, -10, 2, -9,
    7, 17, -9, -18, -19, -6, -4, -10,
    1, -34, -6, 25, -6, -16, -5, 1,
    18, -4, 5, -43, -2, 20, -28, 37,
    18, -7, -73, 18, 0, -3, 3, 4,
    23, 5, -23, 30, -2, -27, 14, 7,
    -25, 72, -38, -12, 5, 14, 2, -35,
    -7, -17, 25, 9, -37, -62, -11, 21,
    34, 10, 29, 11, -7, -12, 1, 6,
    -6, 32, 34, 26, 24, 64, -9, -19,
    -42, -11, 5, 17, -1, -16, -34, -20,
    21, -29, -43, 44, -8, 22, 10, -17,
    -69, 23, 35, -26, 9, 1, -3, 0,
    -20, 17, 20, -21, 21, -52, 35, 21,
    6, 25, -35, -6, 7, -50, -6, 3,
    8, 21, 28, 28, -23, 49, 42, -7,
    -1, 18, 51, -16, 0, -8, 1, 15,
    -75, -54, -19, -5, 13, 59, -16, -10,
    -33, -19, -9, 23, -28, -19, 89, 6,
    -18, 43, 14, -14, -17, -17, 5, 26,
    2, 28, 19, 12, 2, -19, -3, 5,
    -6, -39, -15, 0, -28, 39, -16, -4,
    7, 22, -3, 34, 77, 52, -24, -46,
    -44, 0, 57, -38, 38, -27, -19, 1,
    -21, 31, 29, -25, -2, 0, -1, 1,
    19, 14, 0, -26, -9, -33, 5, 20,
    27, -27, -24, -28, -4, -26, -63, -18,
    20, -18, -2, -18, -3, -38, 7, -33,
    14, -55, -39, 44, -6, 8, -6, 0,
    -20, 20, 1, -48, 26, -26, 17, -32,
    12, -43, -12, 60, 19, -39, 45, 30,
    -14, -30, -38, 60, -14, 15, 41, 35,
    17, 0, 64, -41, 0, 9, -7, -13,
    26, 70, -27, 4, -19, -12, -42, -12,
    26, 53, 10, 11, -95, 18, -22, -21,
    127, -28, -40, 17, 56, -95, 44, 55,
    35, 5, 53, -10, 2, -20, 13, -2,
    -13, 45, 30, 19, -32, -83, -56, -19,
    15, -17, -13, -31, 37, 10, 17, -23,
    -38, 50, -18, -57, -18, 15, 11, -66,
    -47, -44, -34, -47, -7, -14, 5, 3,
    -27, 10, 4, 1, 28, 30, -11, 29,
    -30, 24, 16, -47, -19, -31, 26, -9,
    25, 17, 19, -19, -47, 46, -15, -12,
    -62, 28, -21, 10, -8, -10, 6, 5,
    44, -11, -35, -3, 37, -16, -36, 30,
    33, 5, -17, -12, -24, -2, -14, -50,
    -55, -19, -39, -4, -36, -40, 9, 11,
    18, -55, 3, 21, 12, -1, 1, -9,
    40, 41, 14, -30, 9, 14, 17, -29,
    -37, -1, 21, -61, 50, 16, -13, -11,
    39, 14, -7, -77, -31, -90, 11, 25,
    -65, -47, -20, 14, 6, 9, 8, 5,
    19, 39, 10, 13, 42, 9, 34, 41,
    17, -12, -9, -30, -27, -22, 24, 4,
    -44, 10, -3, 19, -58, -42, 23, -18,
    -6, -23, 28, 43, -3, -4, -2, -1,
    35, 2, -4, 8, 4, 48, -32, -28,
    22, 30, 13, 35, -37, -35, -17, -9,
    30, 44, -41, -1, 9, -12, 18, 24,
    35, 17, -28, -3, 4, 4, 8, -5,
    -10, 49, -24, 7, -3, 10, -10, -5,
    6, 19, -41, 14, -15, -49, 38, -3,
    21, 29, 17, -64, -18, 9, 40, -26,
    -8, -48, -29, 10, 1, -3, 0, 0,
    -25, -18, 18, -8, 5, -19, 29, -17,
    -27, 32, -85, -44, -99, -24, -82, -10,
    -42, -29, -90, -30, -69, -13, 9, 69,
    -26, 3, 3, 60, 5, -1, -2, 2,
    3, 26, -6, -19, 17, 35, -34, 61,
    12, -8, -26, -19, -60, 9, -5, 5,
    -35, -41, -20, 27, 11, -15, 0, 29,
    25, -14, 49, -9, -7, -33, -2, -7,
    -37, -9, -19, 9, -9, -1, -43, -11,
    15, 31, -34, 50, 4, 29, 29, 19,
    -96, -27, -12, 34, -29, -2, 31, 3,
    18, 2, -41, -4, 108, 21, -7, -8,
    -4, -18, 27, -9, 21, -29, -14, -15,
    -13, 43, 38, 50, -5, -6, -31, -19,
    -8, 9, 39, 14, 40, -37, -11, -13,
    -25, -15, -45, -18, 9, 2, -12, 2,
    -5, 14, 51, -18, -40, -23, -4, 8,
    79, 43, -7, 37, 42, -10, -39, -24,
    11, 26, 29, 92, 6, -17, 16, -7,
    -9, 35, 12, 14, -9, -4, -5, -1,
    -9, 6, -7, 10, 40, -38, -19, 5,
    -20, -24, 49, -59, -15, -55, -40, -62,
    -84, -1, 3, -24, -63, 88, -32, -3,
    9, 9, 95, 33, 0, 4, -5, 3,
    35, -4, 6, -14, 13, 18, 36, 7,
    -12, -39, -52, 20, -20, -11, 2, -24,
    36, 12, -10, 83, -9, -81, 44, 35,
    -4, -8, -86, -20, 9, 11, 8, -7,
    12, -6, -25, -39, 38, -20, 22, 5,
    31, 8, 35, -24, -46, 5, 42, -23,
    18, -25, -11, 19, 5, -80, 44, 85,
    -7, 44, -17, 31, -10, 10, -2, 1,
    3, -11, 31, 44, 45, -59, 11, -70,
    27, 31, 25, -24, -3, -37, -62, 29,
    10, -8, 32, -43, -9, -58, -23, 19,
    57, 72, 73, 26, -5, -1, 6, 6,
    14, 14, -15, 15, 0, 3, 46, 46,
    -12, 13, -68, 22, 10, 35, 30, -23,
    -29, -6, -38, -38, -27, -2, 8, -51,
    -47, -34, 11, -34, 14, 2, 6, 6,
    17, 0, 12, -22, 11, 19, -8, 45,
    -7, 19, 3, 32, 47, -31, 1, -3,
    22, 54, -1, 1, 34, 5, 12, 45,
    -28, 9, 36, 22, 2, 1, -3, 8,
    0, 32, 17, 26, 14, 7, 21, -27,
    33, -6, 49, -10, 1, -35, -12, -8,
    22, 47, 17, -8, 19, 4, 14, -13,
    7, 15, 67, -29, 3, -25, -15, -7,
    -6, 32, 72, -17, -58, -71, -15, 11,
    -44, -2, -19, -22, 2, -3, -32, 43,
    -9, -16, -38, -13, -10, 15, -24, 71,
    -25, 20, 4, -11, -2, -1, 3, -2,
    -8, 18, 3, 32, 16, -20, 9, 13,
    -23, 48, 0, -1, 43, 46, -18, -12,
    28, 70, -12, 21, 33, -25, -2, 6,
    13, -18, -3, 49, 8, 1, 13, -6,
    -18, -20, 0, 18, 8, -2, 3, 1,
    77, -13, -15, 34, 17, -13, -27, 38,
    -22, 44, 48, 38, -34, 89, 28, -36,
    20, -23, -74, -12, -8, 3, 2, 2,
    11, -13, -23, -20, 16, 1, 22, -4,
    -27, -7, 17, -3, 19, -4, 38, -52,
    4, 22, 12, -8, -36, -11, 1, -5,
    9, 30, 9, -12, 10, 2, -8, 9,
    -16, 34, -21, 3, -40, -3, 29, -20,
    10, 20, 14, -29, -1, -7, 67, -15,
    -29, -16, 32, 28, -19, -30, 50, 46,
    10, -57, 43, 47, 0, 2, 5, -9,
    9, -15, -23, -47, -24, 2, -12, -58,
    1, 18, -14, -22, -5, -31, 0, 23,
    -27, 2, -14, 3, -20, -6, -18, 3,
    -29, 14, -19, -11, -20, -8, -5, 17,
    11, 22, -4, -31, 11, 19, -2, -10,
    24, -8, -6, 31, -6, 21, -23, -21,
    29, 3, 1, 12, 7, 25, 15, -14,
    14, -6, 2, 13, -18, 5, 0, 10,
    -5, 18, 20, -6, 6, 11, -27, 6,
    16, -8, 13, -16, -6, 24, 19, -8,
    13, 2, -9, -5, 2, 6, 25, 15,
    3, 14, 12, -16, -7, -9, -4, -10,
    20, -1, 18, 14, 3, -26, 20, 1,
    9, 13, 18, 13, -8, -15, -38, -18,
    -7, -12, -14, 45, -19, 15, -13, 27,
    -30, -13, 9, 6, 1, -11, 25, 13,
    -8, -5, 16, 21, 1, -4, -10, -7,
    -16, 8, 8, -33, 5, -10, 8, -36,
    -1, -18, -5, -6, 16, -1, -18, 35,
    21, 7, -24, 17, 6, 1, 0, -8,
    1, -12, 5, -27, -29, -3, -5, 8,
    -6, -29, 0, -19, 27, -20, 3, 23,
    2, -11, -6, 9, -5, 8, -25, -13,
    -22, 7, -12, 10, -14, -9, -5, 8,
    42, 11, 13, 37, 5, -3, 3, 0,
    -14, 3, -5, -20, 37, -13, 6, 21,
    -1, -9, 10, 29, -3, 22, -4, -6,
    -8, 9, 19, 5, 15, 22, -9, -17,
    -68, 3, 10, -7, -13, 50, -8, 2,
    -13, 2, -33, -7, 21, -10, -4, 35,
    13, -36, 13, 12, -8, 0, 31, -2,
    11, 24, 7, -2, 19, 3, -5, 0,
    -14, 2, -1, -7, -2, 5, -8, 14,
    13, 4, 12, 8, -7, 30, -7, -18,
    13, 7, -7, 11, -34, -14, -16, -30,
    13, -15, 32, 16, 2, -19, 6, 35,
    3, 18, 18, 25, 8, -1, -28, 0,
    19, 5, 2, -4, 1, 24, 1, 34,
    3, -48, 37, 33, 1, -3, -31, -5,
    23, -13, 24, 5, 14, 17, 19, -10,
    21, 22, -17, -29, -7, 6, -38, -17,
    17, 5, -9, -2, 3, 54, -5, 7,
    -33, -6, 14, -3, -14, -4, 24, 2,
    -6, -10, 12, -6, -13, -2, 33, -1,
    -29, 12, -9, -29, 21, -19, 0, 37,
    14, 22, -1, -20, -15, -45, -3, -2,
    16, -16, 6, 22, -11, 25, -4, -9,
    19, 7, 5, 7, 29, -19, 17, 3,
    -1, 12, -15, 0, 15, -12, -13, -2,
    -19, -11, -8, 8, -15, 14, -1, -26,
    -13, 10, 0, 14, -10, -32, 5, 1,
    21, 23, 3, -16, 5, 14, -7, 14,
    -29, -37, -2, -36, 0, -27, -8, 9,
    16, 2, 9, -2, -38, 10, -5, 4,
    6, 6, -7, 11, -6, 10, 17, 5,
    12, 9, -7, 7, 4, -20, -6, -2,
    -3, -25, 20, 6, -10, 4, 17, 9,
    -5, 1, 0, 0, 24, 9, -12, 6,
    14, -25, 3, 1, -25, 8, 0, 9,
    4, -4, -11, 20, -14, 24, 9, -3,
    10, -40, -7, 7, -14, 1, 30, 13,
    10, 4, -3, 4, 35, -16, -17, -40,
    0, 19, -1, -17, 0, 14, 9, 5,
    -6, 24, 13, -8, 5, -2, 9, -13,
    4, 2, -5, -43, 4, 7, 20, 33,
    -1, 0, 2, 16, -3, 18, -2, -19,
    -2, 19, -19, -25, 22, 9, 12, 7,
    -10, -4, 9, 0, -4, -8, -5, 16,
    31, -2, 7, 2, -32, 7, 10, -10,
    -40, 1, 16, 11, -10, -16, -23, 6,
    0, 18, 32, 14, -18, 18, -3, -2,
    3, 14, 6, 25, -7, 21, -7, -10,
    7, -19, 25, -5, 3, 8, -3, 14,
    33, -9, 1, 2, -6, -23, 17, 35,
    21, -14, -4, -45, 7, -10, -11, -14,
    -2, 25, 12, 8, -6, 5, -12, -11,
    19, 0, 1, 7, -23, 8, -2, 5,
    -17, 11, -7, -7, -43, 15, 17, -24,
    -13, -8, 16, -9, -9, -20, 3, 8,
    16, 1, 5, -3, -5, 6, 3, -13,
    33, -16, -16, -22, 7, -9, 1, -26,
    -16, 10, 12, 16, -3, 10, 20, -25,
    -1, -10, 31, -33, -28, -26, -5, -19,
    -12, -43, 25, 1, 3, 13, 14, 18,
    -15, -31, -1, -15, -29, -9, -10, -16,
    -1, 18, 2, -14, 8, 39, -7, 2,
    25, 9, 4, -18, 30, -5, 3, -14,
    4, -17, -2, 0, 14, -1, 5, -7,
    -14, 15, -24, -16, 36, -3, -30, -11,
    -1, 21, -39, -6, -3, 16, -17, 27,
    24, -21, -13, -10, -4, 8, -15, -11,
    24, 30, -8, -8, -9, -17, 9, -25,
    13, -13, 27, 24, -27, 13, -5, -21,
    0, 16, 22, -2, 23, -19, 1, -27,
    -20, -36, -6, -11, 9, -15, 12, 10,
    5, -9, 6, -9, 3, -10, -3, -30,
    1, -12, -3, 37, 6, -16, 6, -5,
    -4, 28, 18, -24, -6, -1, 22, 8,
    -16, -8, 4, 8, -1, -26, -20, -31,
    -24, -6, -7, -29, 12, 16, -5, 23,
    -26, -17, 18, 40, 9, 6, 3, -31,
    -11, -2, -28, 11, -4, -5, -4, 10,
    47, 10, 6, -5, -3, 18, -1, 23,
    7, 14, -12, 2, 2, 2, 1, -4,
    37, 9, -19, 20, 3, -9, -12, 9,
    -5, 36, -30, -5, -11, -17, 5, -35,
    -11, -4, 25, 0, -17, -7, 11, 9,
    4, 26, 0, -5, -24, 8, 0, -5,
    -7, -23, 4, 5, -28, -26, 12, 1,
    2, 1, -4, -52, 5, 3, 37, 2,
    9, -29, -32, -2, 15, 7, -9, 5,
    -14, 0, 8, 21, -7, -2, -3, -4,
    8, -11, -31, 32, -7, -13, -11, -23,
    38, 23, 11, 11, -9, 16, -10, -4,
    21, 4, 24, -15, 6, 14, -9, 7,
    0, -25, -16, 9, 3, -5, 26, 9,
    -81, 23, 19, -15, 49, 16, 3, 20,
    7, -7, 9, 18, -55, -2, -10, -1,
    -26, -8, 19, -7, -5, 30, -11, -12,
    -3, -26, 1, 4, -16, -14, 18, 18,
    -1, -9, 10, -32, 1, -30, -24, 23,
    -4, -21, -20, -30, -40, 8, 13, -38,
    -6, -19, 20, -23, -11, -9, 27, 43,
    -7, 7, 12, 18, 10, -5, -13, -16,
    -5, 15, -33, 31, -13, 26, -35, 20,
    -2, -2, -17, 3, -6, 15, -18, -22,
    -45, 2, -45, 32, 10, 14, -19, 5,
    7, 23, 10, -7, -4, -6, -7, 4,
    -15, 29, 24, 16, -29, 5, 17, -11,
    -17, 2, -14, -21, -35, -15, 10, -25,
    16, -4, -18, 57, -18, -2, 3, 38,
    -10, -14, 11, 20, 4, -19, -7, -27,
    37, 28, -9, -19, -20, 7, -1, 0,
    21, 12, -3, 4, -4, -19, -18, 0,
    -13, -6, 20, 19, 10, 20, 32, 20,
    -34, -5, 28, -1, -23, -4, -4, -11,
    -79, 5, 21, -14, -33, 0, -20, -1,
    0, -32, -26, 6, -38, -21, -21, -8,
    -16, 24, -12, -4, -10, -8, 22, 11,
    -23, -8, -7, -6, 17, -12, -12, -8,
    7, -41, -92, 5, -12, -20, -29, 0,
    8, -35, 8, -15, 0, -10, -3, 14,
    -4, -45, -8, 7, -1, 25, -1, -2,
    15, -10, -9, -29, -6, -14, -13, 53,
    24, 5, -63, 38, 4, -23, -16, -7,
    8, 6, 11, -14, 17, 27, 9, -20,
    -40, -11, 5, 32, -32, 23, -3, 41,
    -36, -6, 14, 16, -18, 4, -9, 9,
    25, -19, 14, -4, 1, -22, 6, -10,
    -26, -12, -29, 4, 40, -21, -23, -20,
    7, 8, 8, -49, -18, 58, -5, -27,
    15, 29, -27, -1, 18, -26, 7, -28,
    65, -18, 26, -39, 3, -21, 22, 33,
    8, 3, 9, -8, 12, 1, -15, 20,
    9, 0, 7, -23, 10, 4, 4, 4,
    -42, 16, -16, 12, 11, 15, -4, -4,
    -30, -36, 33, -52, 25, -28, 7, -17,
    36, 15, -33, -26, -21, 19, -21, -14,
    6, 28, -15, 23, -42, -12, 38, 4,
    1, -3, -21, 27, -21, 2, 18, 5,
    36, 30, -12, 36, -42, 13, -8, 43,
    11, 10, 4, -23, 26, 20, -30, 16,
    4, 19, -13, -1, -12, -16, -5, 3,
    -11, 11, -8, 26, 2, 0, 11, -6,
    -54, 20, 15, 18, -19, 14, -33, 19,
    -54, -20, -35, -29, 34, -28, -15, 27,
    -7, -18, 1, 16, -2, -33, 4, -11,
    19, -1, 5, -49, 15, 14, -19, 4,
    60, 9, -3, -24, -4, 14, 81, 0,
    34, -21, 27, 10, -13, 14, 13, -19,
    -51, 12, -9, -13, -10, -1, -8, -4,
    -20, 9, 3, 7, -8, 29, 3, -29,
    -60, 13, -15, -14, -8, -10, -19, 24,
    4, 49, 3, -62, 0, -11, 19, 9,
    31, -7, -8, -38, -7, -22, -29, 2,
    0, -27, 28, 7, -4, -7, 13, 24,
    24, -60, -17, 54, 21, -14, -26, -31,
    -5, -14, -11, -10, 9, 10, -9, -12,
    4, -1, 7, -20, -8, -27, 5, -26,
    -5, 78, 13, 25, -6, 4, 14, 4,
    -28, -10, -5, -58, 29, 20, 0, 1,
    1, 2, -12, 17, -3, 44, 19, 26,
    -3, 5, -10, 37, -13, 5, -10, -18,
    8, 9, -34, -2, -1, -14, 19, 24,
    -31, -51, -34, 30, 6, 12, 14, -31,
    -10, -39, 12, -6, 19, 5, -11, 3,
    16, 19, -7, -11, -49, -3, -33, -1,
    -28, 6, 43, 3, 4, 0, 13, -29,
    2, 9, -10, -13, 28, 17, -20, 15,
    32, 29, -17, -47, 23, -5, 11, -46,
    38, -7, -23, 0, -19, -42, 12, -6,
    8, 18, 12, 2, -9, 3, 7, 8,
    17, 45, 30, 21, -17, 13, 29, 1,
    -63, 1, -5, 19, -22, 7, -18, 28,
    33, -2, -27, -32, -5, -5, 13, 0,
    14, -6, 16, 6, -20, -7, -4, -7,
    -34, 13, -13, 55, -33, 4, 3, -10,
    -50, 40, -12, 12, -7, 3, -70, 12,
    3, -34, -30, 46, -5, -14, -30, 6,
    -19, 19, -25, 0, -7, 0, -6, 22,
    9, 4, 29, 20, 7, 4, 17, 17,
    1, -2, 5, 2, 22, 15, 10, 4,
    -11, -2, 9, -43, -6, 27, -10, -13,
    17, 19, 0, -26, -16, -19, 14, -15,
    15, -26, -5, 9, -31, -34, 4, 25,
    -33, -8, 45, -13, -23, -44, 16, -1,
    11, -12, 18, -32, 2, 27, -18, 8,
    31, -22, -11, -13, 14, 10, 15, -6,
    54, 70, 3, -3, -39, 17, -19, -42,
    -20, -21, -2, -5, -1, -31, -18, -34,
    -3, -61, 33, -7, -24, -33, 0, 10,
    -4, 4, -6, -13, -2, -20, -10, -9,
    66, -63, 14, -23, 39, 30, -7, 34,
    3, -33, 12, -62, -6, 19, -15, 5,
    12, -18, -28, 44, -6, 14, -20, 61,
    71, -13, -2, -36, -9, 6, -42, 21,
    -4, -15, -44, -42, -3, 32, 29, -29,
    -22, 21, -3, 8, -33, -24, 44, 11,
    6, -11, -28, 14, 7, -11, 10, -23,
    9, 41, -1, -48, -2, 2, -11, -12,
    -28, 36, 14, 20, -9, 27, -16, -63,
    34, 3, 18, 31, 21, -26, -16, -1,
    -1, 12, 1, -1, -6, -10, 16, -13,
    -33, -11, 25, -43, 18, 6, 26, -8,
    7, -54, 44, 33, -17, -30, 2, -42,
    -14, 5, -6, -19, 8, -21, -17, 6,
    -24, 21, -11, -7, -5, 2, 2, -10,
    -3, -18, 10, 7, 15, 4, 5, 4,
    -22, 10, 8, -1, 7, 12, 8, 15,
    11, -10, -15, 28, -13, -62, -1, -10,
    38, -1, 11, 12, 16, 36, -11, 3,
    -11, 2, 23, -18, 8, -11, -8, -2,
    14, -36, 7, 17, 17, -10, -26, -3,
    -17, 34, 21, -14, 1, 0, 26, 11,
    -22, -16, -12, -38, 2, -28, -17, -29,
    9, 19, 0, 34, -3, 0, -4, 35,
    36, -4, -25, 16, 1, -54, -13, -9,
    -10, 2, -32, -6, -9, 9, -20, -16,
    23, -14, 26, 7, 2, 13, -13, 21,
    -23, -33, -28, -15, 13, -20, -4, -36,
    13, 13, -44, -19, -4, 15, 9, -18,
    47, 31, 16, -7, -24, -27, -4, 10,
    52, -19, -2, -1, 7, -8, -17, 8,
    -22, -6, -5, -3, -2, -4, 11, -5,
    5, 9, -6, 34, 15, 9, 7, 21,
    -36, -3, 20, -15, -3, 11, 53, 27,
    -66, 26, -6, -24, 23, 1, -23, -4,
    -12, -3, -9, 14, 3, 15, -4, -12,
    10, -32, -4, -61, 7, -1, 20, 14,
    -14, -21, -30, 27, -1, -31, -41, -51,
    -1, 22, 7, 26, 40, -5, -8, -11,
    -27, 21, -11, -13, -6, -3, 6, -31,
    -49, 7, 41, 3, -24, 18, -33, -8,
    -16, 31, 1, 18, 6, 49, -40, 26,
    -11, -35, -10, 23, 8, -14, 25, -38,
    24, 11, -9, 40, 1, -7, 28, 19,
    0, -4, 26, -17, -7, 6, -67, -13,
    -20, 0, 13, 33, 47, -21, -44, 6,
    20, -3, -56, 78, 18, -9, -1, 4,
    26, -79, 12, -10, 25, -14, -24, 37,
    -32, 17, 21, 21, -37, -18, 6, -22,
    -38, 25, -26, 23, 34, -27, 12, 53,
    -79, 30, 29, -48, -28, -9, 1, 27,
    11, -32, -10, -10, -41, 3, -33, 15,
    19, -18, 17, 25, -6, -8, -45, -17,
    -12, 10, -12, 28, 47, -6, 14, 14,
    -77, -40, -66, 27, 9, 10, 4, -1,
    37, -26, -19, 3, -9, -16, -10, -34,
    -47, 34, 88, 18, -19, -34, 51, 15,
    9, -42, -5, 2, 5, 28, 5, 65,
    -7, -78, 9, 9, 79, 50, 9, -12,
    38, -28, -44, 18, -16, 27, -1, 108,
    1, -13, 95, -96, -4, -18, 19, -32,
    -56, -2, 53, -50, 41, 22, -23, 60,
    -25, -34, -25, 20, 13, 1, 7, -28,
    -5, 5, 1, 15, -13, 41, 13, -36,
    -15, -23, -15, 2, -10, -63, 45, -60,
    6, 2, 13, -8, 5, 7, 15, -59,
    1, 24, -21, -98, -17, 111, -44, 24,
    41, 27, -15, -10, 46, 46, -25, -5,
    -33, -3, 0, 27, -11, 34, 26, -15,
    10, 3, -45, -17, 28, 54, -8, -17,
    19, -50, -43, -86, -21, -44, -3, -20,
    42, -4, 14, -76, -32, 12, -51, 20,
    -15, 37, -10, 42, -22, -72, 63, 6,
    22, -10, -24, -19, 34, 21, -24, -39,
    -9, 95, 43, 60, -6, -15, -14, -16,
    -27, -26, -26, -8, 12, -25, 23, 12,
    52, 52, -46, -11, 30, 13, -31, -16,
    -99, 14, -54, -8, -15, 26, 9, 1,
    12, 76, -84, -23, -32, 17, 8, 33,
    15, -1, -25, 41, -6, 41, -27, -46,
    14, -20, 4, -53, -9, -10, 14, 12,
    72, 14, -60, 20, -25, -104, 0, 12,
    -18, 7, -40, 13, 8, -31, 44, 19,
    -9, -24, 16, 43, -16, 75, -57, 28,
    -46, -83, -16, 14, 69, 4, 127, -21,
    53, -22, 0, -15, 33, 5, 17, -11,
    29, -28, 50, -6, 31, -1, -2, -9,
    36, 2, 28, -19, -28, -35, -8, 1,
    35, -18, -5, 79, 41, -38, 20, -30,
    11, 15, 4, -39, -48, -78, 5, -5,
    90, 0, 7, -8, 27, 32, -43, -14,
    -24, -29, -23, 8, 24, -11, 18, 0,
    50, 74, -5, -23, -1, 6, -27, 51,
    29, -7, 16, -6, 1, -11, -44, -84,
    24, 4, 73, 3, 14, 2, -19, 13,
    -32, -23, 2, -56, -4, 57, -11, 23,
    63, 25, 8, 23, 47, 5, 10, 5,
    -20, -1, -66, 13, -41, 103, -26, -26,
    2, 5, 12, -57, 26, 30, -12, -65,
    -40, 1, -13, -16, -49, -10, -51, 21,
    -10, 39, 50, 7, -4, -30, -19, -19,
    -14, -27, 46, 3, -32, 0, -3, 33,
    -57, 6, -23, 4, 38, -6, -5, -12,
    -26, 33, -7, 23, -33, -96, 60, -40,
    -76, -20, -22, 3, 46, -20, -60, 0,
    2, -3, -56, -42, 64, 21, 33, -29,
    60, -42, -16, -5, 35, -28, 15, 30,
    33, -59, 18, 21, 30, 11, 8, -7,
    57, 5, 16, 27, -33, -74, -16, -43,
    -1, -2, 14, 23, 5, 5, -34, 30,
    -103, 9, -28, -88, 44, 15, 10, -23,
    -49, 8, -1, -49, 18, -21, 23, -46,
    93, 19, 21, 9, -90, 11, 27, 61,
    -60, -7, -18, 13, 69, 51, -126, 50,
    32, -40, -24, 35, -1, -42, -7, -34,
    10, -5, -7, 23, -37, 8, 11, -63,
    24, -42, -52, -24, 4, 13, 24, -10,
    -43, -86, -7, 6, -27, -26, 7, 67,
    -28, -27, 15, -83, 7, 7, -11, 29,
    -54, -27, 29, -7, -18, 89, -11, 4,
    31, -66, -32, 26, 45, 7, -1, 1,
    -3, 10, -10, 22, 29, -2, 106, 11,
    23, -67, 10, -11, 0, 43, 18, -23,
    -17, 10, 36, -7, -28, 33, -29, 15,
    -83, -14, 19, 11, -27, 0, -16, -36,
    -11, 35, -44, -7, -2, 2, 50, -32,
    -35, -83, 40, 50, 60, -44, 24, 6,
    -11, -70, 34, -5, 32, -49, 22, -14,
    13, 30, 38, 28, 42, 10, 15, 39,
    22, 16, -60, 50, -45, -20, -1, -17,
    5, 37, -41, 16, -16, 8, -9, -38,
    -11, 73, 6, 21, 19, 43, -1, -38,
    7, 74, 14, 38, 14, 31, 13, 45,
    -21, 68, -4, -2, 39, 10, 17, -17,
    24, -30, 18, -34, -1, 42, -25, -46,
    -2, 72, 68, 61, 3, 15, 57, 18,
    -7, 20, 2, 5, 1, -19, -2, 0,
    21, 19, 14, -27, 32, 84, -48, 25,
    69, -61, 107, 18, 4, -6, 41, -13,
    9, 88, -17, 13, -22, 58, 44, 18,
    2, 15, -36, 1, 97, -36, 0, -36,
    5, -26, 45, -17, -80, 23, -37, -14,
    -17, -8, 4, -34, 34, -4, 34, 73,
    9, -6, 17, 32, -29, -40, -12, -18,
    14, -4, -13, -17, -17, 19, -26, 9,
    33, 51, -58, -11, -42, -45, -9, -9,
    -24, 40, 4, 32, -23, -63, -16, -26,
    26, -1, 0, -6, -13, 20, 5, 17,
    -49, 26, 9, -16, -7, 16, -19, -33,
    23, 30, 0, 60, -3, -40, 16, -40,
    -6, -32, 2, 2, 4, -32, 11, 32,
    70, -23, -69, -52, -57, 39, 4, 6,
    47, -25, -32, 9, 49, -22, -22, 17,
    14, 1, 17, 30, -57, 46, 57, 30,
    20, 41, 14, 38, 6, -41, 7, -20,
    -8, -11, -1, 18, 5, 4, 15, 49,
    -2, 4, 18, -45, 44, 29, -20, 120,
    53, -4, 1, -25, 48, -21, -5, -13,
    -75, 12, 6, 0, 1, -10, -18, 2,
    14, 15, -21, -44, 17, -55, 3, -19,
    50, 32, -36, -19, 28, -53, 8, -9,
    -54, 3, 16, 14, 3, -30, 27, 28,
    -18, 34, -3, -19, 24, -10, 51, 6,
    -30, -4, -14, 23, 1, 33, -54, -10,
    -38, 89, 16, 16, 29, -18, 36, 58,
    12, 15, 20, 29, 18, 74, -44, -33,
    24, -32, -13, -11, -41, 14, -19, -33,
    31, -9, -19, 9, 8, 40, 14, 53,
    80, -6, -2, 23, 28, -11, 26, 3,
    13, 31, 7, -26, 8, 70, 24, -78,
    46, -6, 4, 71, 4, -10, 11, 31,
    46, -27, 41, 38, 6, 3, 7, 62,
    2, -36, 0, 37, 9, -6, -45, 33,
    23, -1, 14, 29, -28, 22, 7, -5,
    -15, -19, 3, -18, -10, 6, -8, 0,
    6, 8, -1, 15, 10, 25, -14, 22,
    -3, -9, -22, 14, 5, 28, -3, 2,
    -14, 11, 18, 0, 0, 7, -2, 4,
    33, -24, -7, 3, -26, -5, 24, 13,
    -23, -1, 5, -7, 18, 0, -1, 12,
    -7, -2, -4, 1, -25, -19, -13, 17,
    -13, 29, 14, -3, -1, -15, -3, -6,
    8, -5, -8, -7, 18, -22, 4, -18,
    18, 29, 13, 12, 2, -16, -9, 16,
    7, -13, -22, 7, -7, 8, -10, 15,
    -4, -3, -24, 11, -2, 31, 13, 5,
    12, 0, -19, -12, 37, 25, 3, 5,
    10, -17, -17, -17, 46, -26, 27, -36,
    7, -24, 18, 1, 7, 0, -26, -14,
    3, -21, 38, 0, 24, -27, 33, 8,
    13, 26, -7, -9, -1, -10, -3, -11,
    -19, 4, -7, 10, 18, -14, 0, -17,
    -16, 31, 5, 5, -20, 7, 5, 28,
    -19, -19, 19, 18, 20, 13, 7, 1,
    11, -2, -21, -11, -5, 29, 16, -2,
    -1, 7, -37, 10, -15, -5, 29, 7,
    33, 3, -5, 31, 10, -7, 13, 7,
    -24, -1, -14, -9, -17, 12, 30, 5,
    11, 26, 5, -16, -8, 22, 4, 26,
    4, 10, -1, 6, 41, -46, -18, -5,
    31, -6, -9, 10, 17, -7, -14, -16,
    9, -10, 4, 7, 33, -6, 28, 26,
    -4, -3, -1, 23, -23, 17, -12, -7,
    -27, -21, 6, 25, -19, -8, -34, -28,
    -5, -9, -7, -1, -15, -18, -12, 31,
    -8, -33, -16, -16, 9, 5, -5, -1,
    -16, -5, -11, -4, -12, 13, -1, 24,
    -4, -8, 2, 5, -29, -5, 10, 19,
    -3, -22, -17, 31, -2, 27, -23, 16,
    19, 20, 6, -9, 33, 39, 68, 18,
    -7, 6, -1, -9, 5, -25, 8, -26,
    -14, -22, -39, -1, -12, -33, -18, -21,
    8, -15, 4, -30, 5, 0, -16, 12,
    -34, 4, -9, 1, -26, -3, -8, -21,
    -29, -2, 0, 40, 0, -4, -16, -41,
    16, 1, 3, 0, 2, -11, -9, -19,
    1, -4, 2, 6, -13, 1, -6, -19,
    -8, -15, -3, 8, 46, -37, 6, -9,
    -15, -5, -3, 22, -13, 40, -11, -29,
    4, 7, -2, 26, -3, -24, 7, 7,
    -8, 19, 2, 21, 0, -10, -12, 31,
    12, -21, 7, 11, -3, -1, -1, -10,
    11, 5, -8, -16, 8, 22, -12, 8,
    -11, -7, -15, 10, 2, -17, 2, 31,
    -4, 36, -10, 37, -18, -2, -1, 0,
    27, -9, -16, 18, -15, -35, 2, -31,
    20, -2, 18, 11, 7, 31, -24, 25,
    39, -18, 3, -7, -11, 8, -44, 8,
    11, 10, -19, 14, 4, -17, -15, 10,
    -12, -22, 19, 5, -17, 4, -7, 6,
    -4, 12, -12, 10, 3, -2, -2, 1,
    -8, 1, -14, 6, 25, 13, 32, -7,
    6, 30, 11, 8, -2, 10, 4, -33,
    -24, -22, -4, 6, -28, 9, -24, -33,
    -22, 18, -13, -51, -3, 40, -9, -6,
    -12, -5, 7, 11, -16, 10, 1, -17,
    -7, -11, 5, 7, -19, -15, -1, 6,
    23, -12, 3, -20, 4, -6, 7, -18,
    -29, -8, 14, 33, -15, -1, 12, 9,
    4, -5, -10, 3, -6, 0, 12, -20,
    11, 10, 12, -14, -18, -21, 7, -10,
    -13, -7, -16, 0, -13, 3, -12, -24,
    -7, 37, 51, 11, 45, -2, -11, -10,
    14, 25, -23, 9, 2, 1, -16, -16,
    33, 20, -11, 8, -44, -39, -10, -16,
    -12, -20, -15, 0, -3, -9, -25, 11,
    2, 13, -21, -10, 7, -22, -3, -14,
    -5, -2, 0, 10, 2, -6, -8, -2,
    0, 2, 5, -3, -16, -6, 4, 12,
    -14, 3, -2, 44, 22, 28, -20, 15,
    5, 29, -11, -24, 2, 17, -9, 9,
    -27, -17, 1, 17, -12, 1, -40, -9,
    6, 6, 11, 22, -25, -5, -7, 26,
    2, -30, -9, -30, 25, 23, 7, -2,
    2, -41, -6, -65, -12, 28, -30, -10,
    -13, -6, 25, -4, 21, 45, -3, 10,
    -5, 3, -27, 15, -4, -6, -9, -19,
    -16, 15, 1, 5, -2, -27, -6, -9,
    -25, -14, -19, -7, -4, -8, 17, 17,
    -11, 7, -21, -15, -29, 31, -6, 30,
    18, -11, -7, 16, -7, -2, -11, -16,
    -24, -19, -24, 22, -10, 1, 20, 22,
    15, -11, -44, -13, -9, 12, 21, 55,
    10, 15, -9, 4, 0, -28, 22, 13,
    -25, 2, 14, 0, -6, -15, 15, 3,
    -7, -5, -21, -4, 20, -2, -13, -42,
    -20, -2, -9, -3, -1, 4, 5, 10,
    -12, 9, -11, -14, 27, 33, 4, -14,
    11, 17, -4, 3, -8, 8, 11, -19,
    2, 12, 14, -22, 18, 38, 12, 20,
    0, 35, 25, -5, -1, -27, -18, 42,
    9, -5, 13, -10, 13, -9, -25, 24,
    -6, 17, -9, 23, 12, -7, 4, 19,
    -13, 2, 7, -10, -26, 5, -22, 4,
    -31, -5, 8, 7, -9, -20, 12, 21,
    -27, 33, -9, 35, 4, 0, 24, 6,
    11, 1, 2, 2, -5, -12, -3, -3,
    30, -35, -3, -24, 13, -3, -11, 22,
    -4, 21, -2, 15, -1, -5, 14, -31,
    2, -1, 2, 4, 19, 8, -5, -13,
    -3, 17, -12, 24, 13, -17, 5, 18,
    10, -4, -2, -8, -13, 13, -9, 17,
    -2, 18, 4, -25, -15, 8, 14, -4,
    -3, 2, 23, -10, 1, 14, -15, -11,
    3, -19, -9, 1, -15, 8, -20, -17,
    23, 0, -12, 6, -15, -43, -10, 9,
    4, 0, -13, 16, -5, -4, 2, 27,
    -1, 11, -9, 15, 2, -18, -10, 26,
    -1, 8, 13, -7, 11, -9, -11, 1,
    -21, 6, 3, 11, -11, -22, 27, -14,
    11, -5, 44, 28, 8, 10, -26, -33,
    13, 10, -1, 12, -1, 22, -32, -20,
    11, -20, 6, 7, -6, 8, 2, -9,
    -35, -23, -18, -29, -5, 5, 40, -1,
    -9, 0, -10, 12, -46, 26, 47, -1,
    0, 10, 18, -1, 2, 21, -12, 15,
    8, -9, -13, -8, -21, 19, 11, -12,
    -1, -9, -23, 4, 25, 0, 30, 5,
    -2, 45, 35, -11, -2, 8, 0, 35,
    11, 35, 28, 3, 30, -5, 42, 6,
    -8, -20, 9, -1, 4, 13, 15, 17,
    -8, 20, 37, -51, 22, 31, 2, 22,
    -11, -4, -18, 20, 48, 23, 13, -31,
    -8, 17, -4, -10, 30, 60, -2, -21,
    5, 0, -18, -2, -15, 50, 17, -15,
    40, -4, 6, -41, -29, -5, 1, 26,
    -42, -19, -21, 28, 2, -25, -7, 2,
    -15, 3, 12, 0, -13, 3, -8, -23,
    7, -1, -12, -2, -3, -3, -20, 4,
    8, -2, 15, -6, 14, -11, 35, 8,
    -23, -7, -30, 6, 11, 7, 28, -11,
    -13, 28, 19, 15, 19, -3, -2, 0,
    13, 4, 4, -1, 14, 14, -2, 24,
    -17, -9, -14, -4, -2, -6, -8, -36,
    -26, 0, -14, -1, 33, 19, 14, -34,
    -3, -2, 12, -13, 22, -31, -9, -82,
    22, -5, 9, 13, -8, 18, -25, 6,
    14, 35, -21, 23, -6, 51, 5, 19,
    -3, 6, 5, 4, -10, -10, -4, 8,
    13, 5, 21, -34, 22, -3, 3, 13,
    -3, 9, 12, 5, 10, -6, -7, 6,
    8, -28, -22, 7, 14, -10, -7, -13,
    -18, -23, 2, 8, 18, -9, -26, 28,
    4, -13, -24, 37, -27, -2, 28, 7,
    26, -23, 3, 3, 22, -17, 16, -8,
    -6, 29, -19, 5, 2, -31, 25, 13,
    -38, 15, 11, 26, -11, -44, -24, 14,
    1, 38, -13, 21, 26, -32, -13, -18,
    13, 10, 9, 12, 2, -1, 22, 11,
    -6, -3, -4, -26, -22, -19, 28, 35,
    8, 27, -12, 8, -3, -8, -19, -31,
    -22, -27, -9, -8, 1, -8, -22, 12,
    1, 25, -16, 13, 45, -31, -11, 14,
    -10, -26, 11, -21, -2, -15, 2, 6,
    -40, 18, -7, -24, -30, -2, 10, -35,
    -16, -1, -2, -22, -49, 30, 17, 8,
    14, -17, -11, 24, 0, 36, -13, -13,
    3, 9, 3, 8, -40, -18, 24, 28,
    -10, -6, 26, -11, 7, 10, -13, 16,
    17, 12, -26, -19, 10, -10, -30, 16,
    9, 2, 6, -8, 14, 24, -6, 25,
    -5, -12, -23, 3, 35, 23, -5, 31,
    -12, -11, 4, 27, 33, 11, -6, -27,
    28, 12, -3, 9, 37, -14, 7, 24,
    6, -4, 11, -10, -2, 0, -18, -11,
    -60, -41, -8, -10, -2, -2, 35, 27,
    -25, 39, -18, 26, -28, -8, -19, 0,
    -46, -17, -7, -9, -17, -15, 37, -34,
    -5, -4, 33, 20, -40, -16, -6, -20,
    -28, -12, 4, 8, 18, 0, -2, -15,
    -19, 0, -21, 12, -17, -41, -15, 13,
    -5, -5, -3, -11, -15, -41, -3, -3,
    12, 46, 6, 1, -11, 5, -2, -7,
    0, 25, 7, -3, 37, 41, -20, 17,
    26, 22, 10, -26, -40, -20, -54, 14,
    16, -2, -19, 17, -23, -5, -14, -23,
    3, -15, -1, 0, 5, -7, -24, 4,
    -39, -21, 32, 0, -5, -34, -1, 29,
    30, 3, -10, 2, -17, 24, 31, 8,
    -15, -12, -10, 16, -3, -23, 7, 9,
    -14, -8, 4, 41, 10, 0, 2, -39,
    4, 37, 22, -5, 7, 41, -6, -16,
    34, 34, 10, -12, -42, 28, -7, -11,
    21, -2, 2, -32, -2, 75, -41, -27,
    -10, 6, -2, -2, 4, -18, 9, 5,
    -7, 12, -16, 34, 26, 15, 23, -11,
    7, 6, 0, 26, -1, -1, 25, 36,
    11, 1, 2, 39, -4, -2, -1, 4,
    11, 3, 6, 17, -24, -42, -10, 6,
    11, -2, -2, 15, 23, -25, -34, -12,
    -5, 11, -3, 14, 19, 10, 50, -46,
    -6, 29, 15, -17, 13, -22, 16, -18,
    41, 15, 5, 4, -70, -20, 3, -6,
    -8, -10, -8, 13, -24, 3, 9, 25,
    -11, -19, -5, -4, 38, -19, 0, -18,
    20, 20, -12, 59, 50, -4, -1, 1,
    31, 1, -1, -16, 30, -11, 6, 23,
    38, -32, 7, -20, -32, 5, 30, 3,
    33, 58, 4, 26, -9, -45, -5, 10,
    -5, 25, -15, -1, -7, -37, -30, -27,
    1, 10, 13, -5, 14, 6, -18, 2,
    11, -1, -34, -26, -6, 0, 58, -20,
    -10, -30, 6, -26, 28, 24, -77, 32,
    -28, -9, 9, -1, 29, 49, -10, -11,
    7, 0, 4, 10, -10, -11, 25, 16,
    -45, 14, -47, -10, -4, 9, 6, -55,
    -16, 39, -25, 92, -15, -26, -4, 9,
    -1, -2, -21, -2, -2, 53, -40, 2,
    25, -5, 14, 3, -26, 0, -4, -4,
    -15, 12, -6, 31, 40, 22, 25, -51,
    -21, -4, 6, -9, -28, -15, 4, 26,
    3, -9, -32, 19, -4, 28, -44, -29,
    -12, -12, 19, 2, 4, -6, 13, 19,
    -41, -15, -41, 26, 22, -15, -18, 33,
    6, 29, 10, -12, -28, -19, -42, 25,
    -9, -7, 1, -33, -15, -46, 51, 9,
    10, 3, 0, 0, 30, 4, -3, -6,
    3, -43, 17, -43, -25, 16, 16, -14,
    -7, 14, 35, 3, -15, -3, -20, -31,
    1, -32, 0, -8, 5, 20, -8, -39,
    6, -11, -18, 31, 14, 21, -2, -11,
    8, -3, -2, 13, -22, -29, -1, -14,
    -23, 13, -8, -7, 0, -8, -6, -31,
    -8, 21, -7, 38, -5, -11, -1, 11,
    -16, -11, 4, 5, 2, -10, -24, 1,
    28, -43, 11, 25, 0, -29, 18, -24,
    25, 0, -22, 12, 20, 6, 35, -2,
    -8, -5, 14, 40, 9, -27, -44, -14,
    -8, 11, -6, -6, 3, -26, 10, 14,
    -22, -10, -17, -2, -10, -36, -18, 31,
    2, -22, -10, -30, 7, -18, -17, -2,
    -10, 25, -29, -18, 1, 31, 8, -53,
    -15, -6, 3, 24, 8, 16, -8, -10,
    -5, 0, 5, -3, -18, -17, -1, -4,
    -71, 17, -26, 26, 30, 17, 5, 3,
    8, -17, -12, 15, -59, 44, 6, -11,
    -6, 3, 13, 5, 2, -6, -19, -6,
    -33, 16, 50, -1, 23, 30, -17, -35,
    -29, 34, 17, 5, 28, -29, 26, 0,
    11, 8, 27, 15, -39, 30, -14, 13,
    -9, -14, -14, 6, -33, -29, 23, 15,
    -7, -39, -29, -8, -6, -10, -7, -3,
    41, 7, -9, 14, 2, -44, -29, -5,
    11, 16, -10, 8, -4, -35, 24, 27,
    10, -31, 2, 2, -13, -8, 9, 22,
    -24, -9, -34, 32, -27, 37, 37, 29,
    -11, 9, 4, 29, -8, -32, -13, -3,
    2, 48, 18, -25, -19, -22, -2, 3,
    8, 3, -28, -18, 3, 33, 33, 29,
    8, 19, 0, 2, 40, -32, -29, 3,
    9, -6, -15, 73, 37, 13, -10, -12,
    -9, 18, 22, -48, 111, 9, 15, -54,
    41, -22, -6, -5, 42, 70, -1, 1,
    -13, 11, -22, -10, -21, -1, -6, 43,
    59, 0, -39, -31, 50, 31, 2, -3,
    15, -14, 5, -1, -7, -28, -3, 10,
    -11, -5, 8, -25, 13, -19, -5, 9,
    -26, -4, -16, 8, 3, 68, -41, 14,
    27, -39, 7, 18, 18, -26, 47, -13,
    -6, 18, 11, 21, 42, 39, 60, 11,
    17, 14, 16, 36, 15, 18, -13, 39,
    15, -67, 59, -20, -8, -9, -32, -6,
    -15, -54, 44, 46, 18, -28, -8, -121,
    -12, 19, 19, 13, -3, -5, 8, 15,
    -21, -36, -26, 29, -19, 13, 1, -39,
    28, 58, 2, -18, -31, 11, -26, -29,
    0, 16, -13, 8, -13, -19, 6, 17,
    -41, 6, 45, -72, 16, -20, 7, 3,
    4, -15, -9, 3, -4, -17, -2, 7,
    26, 15, -47, -20, -17, -27, -18, 3,
    -13, 25, -24, -30, 13, -59, 62, 20,
    4, -19, -31, 49, -89, -30, 47, 7,
    -15, -114, 12, -9, -4, -57, 34, 3,
    5, -55, -40, 8, 8, 45, -15, 1,
    -13, 37, 33, -48, -4, -13, 16, -80,
    -15, 21, -20, -32, -11, -3, -13, 15,
    -5, 18, 45, -34, -7, 0, 51, 6,
    -48, 8, 21, -21, 5, -17, 51, -59,
    -1, 42, 21, 5, -49, -12, -33, 18,
    -52, -54, 35, -20, 0, 26, -36, 38,
    -7, 12, -10, 5, -1, 26, -9, 25,
    22, 5, -29, 19, 27, 25, 70, -32,
    40, -9, 28, -10, 57, 38, -65, 15,
    -29, -21, -5, 5, -78, -43, 42, -21,
    1, -18, 13, -2, -1, 21, -11, 8,
    -36, 55, 79, -29, -2, 68, -8, 39,
    28, 23, -3, 56, -12, 11, -40, 39,
    58, 7, -13, 4, 29, -30, -30, 27,
    0, 8, 5, -4, 33, -23, 38, 35,
    38, -50, -16, 45, 10, -23, 29, 1,
    5, -9, -19, -23, 41, -20, 6, 4,
    43, -35, 42, 5, -4, 9, -18, -10,
    11, -8, 2, -11, -4, -16, -5, 12,
    19, 1, -11, 76, 31, 88, 6, 58,
    -37, 4, -14, 7, -80, 8, 43, 11,
    -61, 18, 10, 45, -13, 72, 12, -46,
    -7, 0, 15, 1, -5, -1, 10, 19,
    -44, 23, -11, -15, -37, -21, 25, 13,
    -26, 14, -9, -9, 6, -64, -11, -37,
    21, -15, -15, -61, 20, 6, 5, 5,
    -2, 22, 20, -27, 8, 37, 3, -13,
    -25, 47, -42, 18, 16, 35, 15, 10,
    -36, -76, 92, -25, -33, 84, 34, -51,
    23, -11, -35, 27, -64, -40, 66, -6,
    17, 2, 16, -15, 9, 2, -23, -2,
    66, -29, 14, -1, 2, -22, 60, 18,
    -48, -44, -3, 3, 1, 43, 2, -3,
    -4, -22, 9, 16, -3, -116, 19, 48,
    -14, 17, -2, 61, -8, -38, -1, -51,
    18, 111, 48, -5, 60, 3, 9, 59,
    -36, 20, 3, 10, 1, 79, -31, -17,
    1, 28, -3, -25, -30, -20, -65, -19,
    0, 1, 16, 30, -42, 35, -16, -8,
    -11, 1, -26, -23, 30, 15, -36, -49,
    -35, 15, 21, 61, 70, 11, -11, -39,
    90, 21, 15, 86, -25, -1, -12, 24,
    -4, 0, 13, 6, 7, -46, -6, -3,
    26, -23, -3, 22, 29, -80, 1, -4,
    35, 32, 64, -1, 55, -12, 51, -11,
    -14, 47, 1, -9, -1, -46, 14, -4,
    72, 8, 1, 11, -100, -29, -3, -7,
    12, -6, -6, 17, 86, -16, 10, -50,
    -11, 26, -4, -4, -67, -6, -29, -17,
    57, -6, -38, 43, 77, -52, -9, 22,
    14, -5, -4, -4, -22, -16, -6, 5,
    40, 51, -3, 0, 34, -15, 16, 12,
    -42, -37, 0, 1, 26, 29, 50, 3,
    -37, 16, -65, 24, 7, 29, -93, -21,
    14, 0, 5, -18, 7, 1, -12, 6,
    36, -51, 52, 1, -10, 2, -66, 34,
    10, 7, -60, -50, -2, 5, 29, 27,
    -1, 27, -37, -16, 75, 52, 72, 10,
    22, 18, -19, -7, -14, 12, 11, -19,
    -41, 24, 56, 13, -7, 18, -35, 43,
    -11, -22, -11, 20, 28, -64, -9, 16,
    7, 24, -17, 24, -67, 64, -26, -29,
    3, -23, 35, -19, 27, -32, -7, 23,
    8, 45, 12, -53, 15, -61, 4, 43,
    -32, -66, -5, -8, 28, -10, -52, 38,
    37, 8, 7, -6, 9, 2, -33, 31,
    -2, 5, 4, 15, -4, 17, -2, -40,
    10, 33, -2, 39, 38, -47, 31, 53,
    -16, 4, -89, -40, -9, 69, -14, 13,
    -27, -12, -33, -18, -8, 61, 7, -4,
    23, -4, -7, -19, -14, -2, -22, -12,
    41, -11, 37, -1, 16, -127, -11, 8,
    -38, -35, 72, 27, -12, 32, -38, -54,
    13, -22, 22, -18, 30, 99, 33, -76,
    -3, -3, -4, 4, -3, -1, 17, -49,
    -3, 1, 22, 29, 16, 42, 4, 18,
    32, 44, -2, -34, 8, 14, 1, 41,
    45, 10, -25, 15, 51, -101, 18, 7,
    13, -22, 1, 17, -3, -25, -8, 1,
    -16, -41, 21, 50, 26, 7, 23, 21,
    27, 6, -13, -69, 1, 0, 18, -21,
    0, 10, 22, 84, -6, -17, -36, 30,
    24, 1, -20, -12, -9, -37, 19, 11,
    13, -64, 64, 17, -6, -67, 49, 16,
    -5, 1, 8, 21, 16, 17, 66, -75,
    19, 29, -31, -7, -5, 0, 24, 67,
    -1, -7, 42, 37, 7, 18, 14, -6,
    -63, -14, -5, -25, 44, 8, 0, -26,
    38, 33, -7, -11, 38, -40, 8, -29,
    1, -20, -1, -2, 48, 1, -9, 29,
    -10, 5, 38, -9, 15, -43, -39, -14,
    73, 10, -98, -7, 25, 9, -29, -1,
    -7, 39, -50, 36, 45, -40, 13, 81,
    6, -1, -7, 57, -86, 77, 17, 26,
    18, -9, -32, -20, -16, -4, -13, -3,
    45, 45, 31, -7, 65, 32, -44, -12,
    -25, -1, -41, -21, 88, 4, 3, 5,
    -28, 103, -13, 60, 12, -32, -10, -37,
    -7, -9, 18, -10, 9, 5, 20, 2,
    7, 8, -35, 2, 21, -81, -39, 48,
    4, 19, 5, 54, -19, 0, 19, -53,
    -1, 127, -4, -22, -44, 33, -16, -81,
    8, 17, -17, -28, 12, -24, 0, -7,
    16, 7, 1, -14, 1, 39, 16, 7,
    14, 35, 29, 22, 11, 23, -10, -6,
    10, 52, 7, 6, -8, -24, 5, -28,
    -23, -22, 26, -4, -19, -9, -1, 5,
    -28, 18, 7, 28, 2, 12, 3, -5,
    -22, 28, 12, 16, -23, 15, 11, -13,
    -29, 34, 16, 8, 23, -4, 12, -12,
    5, 1, -1, -28, -3, 7, 13, -8,
    0, -55, -13, -6, 22, 13, -6, 51,
    -23, 6, -2, 18, 15, 12, 19, -67,
    -10, 26, 13, -26, 17, 17, -1, -4,
    -16, -13, 9, 15, -4, 1, 1, -7,
    2, -12, 13, 2, -1, 21, -17, 12,
    18, -8, 5, 4, 9, -27, -15, -10,
    13, 4, -18, -13, -4, 5, -4, 31,
    -5, -7, 4, -10, -5, 1, 8, 33,
    -27, 30, -5, -12, -26, 5, 17, -2,
    -10, -2, 22, 9, -17, 5, -4, 12,
    -59, -19, -4, -36, 18, -19, 35, 6,
    8, -13, -3, -21, -2, 5, -1, 9,
    2, 33, 22, 12, -1, -30, -8, 1,
    -23, 7, -1, -12, 31, -6, 36, 7,
    -4, 38, 18, -1, 0, -19, -26, 17,
    7, -12, -21, 8, 5, 4, -9, 0,
    -10, -18, -11, -13, -27, 3, -3, -7,
    5, 10, 1, -2, -20, 10, -3, -31,
    9, -16, 6, 12, -38, -7, 10, 52,
    -2, -8, -2, 1, 5, 8, -3, -7,
    -4, 10, 15, -27, -14, -16, 31, -6,
    28, 16, 2, 2, 32, 10, 35, 20,
    8, -2, 22, 1, 18, 6, 11, 23,
    18, -18, 2, -23, -20, -6, 3, 3,
    -13, 4, -13, 11, 6, -25, 1, -15,
    11, 8, -31, -8, -25, -10, -43, 7,
    -15, 6, -46, 31, 2, 3, 1, -3,
    1, -15, 5, 3, 14, -16, -8, 20,
    -14, -10, 6, -21, 20, 24, -10, -8,
    -10, 11, -27, -7, 10, 14, -21, 6,
    6, 24, -38, 5, 27, 12, 2, 37,
    -17, -1, -32, -5, 11, -10, -33, -6,
    14, -26, -15, 1, -17, 1, -17, -4,
    1, 11, -19, -19, -3, -6, 33, -25,
    0, 7, 19, 11, -21, -2, 24, -27,
    29, 10, 0, 10, -8, 7, 5, -19,
    5, 1, 1, 9, -10, -10, 14, -1,
    32, 25, 10, 2, -16, -21, -15, -22,
    -2, 27, 9, 14, -2, -23, 9, -20,
    -2, -5, 9, 0, 4, 8, -7, 17,
    -10, 5, 1, 22, 23, 33, -17, -10,
    3, -27, 4, 14, -6, 56, 10, -8,
    4, 22, 15, 11, -5, 1, 8, -9,
    -13, -10, 7, 4, 3, -2, -1, 4,
    26, 23, 13, 15, 29, 5, -2, 11,
    34, -31, -13, -19, 26, -6, -23, 7,
    30, 0, -37, 18, -25, 2, -7, -25,
    -36, -6, -20, 5, 17, -3, -7, -1,
    -4, 0, 4, -15, -9, -47, -8, 43,
    -13, 36, -15, -20, 18, 4, 8, -31,
    -17, 20, -6, -15, -29, -4, -18, -8,
    -10, 20, 13, 8, 3, 12, -6, 7,
    2, -18, -2, -9, 1, 8, -38, 27,
    23, -8, -6, 48, 32, -12, -5, -44,
    21, -23, 1, 9, 0, -9, -19, -23,
    -8, 9, -12, 6, -3, -11, 14, 13,
    22, -2, 27, 9, 8, -24, 6, 1,
    15, -1, 4, -3, -5, 19, -29, 2,
    5, 8, 18, -18, 4, 9, -26, -31,
    -1, 5, -12, 2, 10, 9, 5, -16,
    13, 8, -3, -3, 7, 25, 6, -15,
    -2, -6, -22, -26, -12, -13, 28, -9,
    -27, 39, -20, 33, -14, -26, 5, 15,
    12, 24, 4, -2, 10, 17, -3, -7,
    -5, 19, -16, -12, 17, -10, -6, 18,
    -12, 5, -12, -13, -1, -6, 17, -31,
    -14, 22, 11, -12, 46, 0, 20, -3,
    37, -13, 5, 23, -4, -3, -6, -6,
    -2, 17, 13, 4, 6, -20, -2, 46,
    -26, -2, 36, 17, -27, 2, -28, -49,
    -40, -9, 3, 10, 9, -2, -1, -14,
    -33, 3, 11, -9, 1, 4, 18, -1,
    10, 35, 12, 31, 4, -28, -13, -13,
    -23, 8, -7, -3, -8, -46, -8, 8,
    -22, 4, 3, 16, 14, -7, -17, -37,
    -6, 6, -3, -2, 9, -12, -2, -7,
    -7, 20, -21, 4, -11, 15, -13, -9,
    29, -12, 14, -21, -12, 2, -5, -30,
    20, 13, -16, 40, -19, 26, -10, -28,
    1, 7, -5, -4, 7, -3, -5, 8,
    24, 2, 17, -7, -15, -16, 15, 21,
    -11, 0, 17, -29, -4, -19, 5, 18,
    -43, 46, -21, -24, -6, 1, 13, 32,
    -10, -4, 9, 3, 8, -3, -1, 6,
    19, -5, 7, -9, -4, 44, -21, -9,
    -22, 12, -19, -20, 18, -1, -17, 11,
    22, 17, -8, -7, -1, 7, -16, 11,
    -10, 5, -16, -3, 0, -7, -2, -6,
    -11, -16, -24, 19, 4, -5, -10, -5,
    19, -20, -11, -3, -18, -8, -6, 23,
    10, -18, 10, 36, 31, -5, -1, 15,
    16, 10, 20, 14, -11, 1, 11, 16,
    -2, 5, 33, -5, -8, 22, -15, -11,
    0, -23, -1, -2, 8, 51, 15, 17,
    -41, 0, 5, 1, -19, -1, -15, -24,
    15, 3, 17, -6, 11, 16, -5, 11,
    -21, 8, 6, 11, -2, 37, -17, 10,
    33, -13, 8, 8, -5, 31, -44, -15,
    1, -16, 13, 10, 30, 0, 1, 16,
    -3, -11, -8, -11, 3, 10, -10, -1,
    13, -15, -20, 9, 38, 44, 21, 9,
    -4, 1, 3, 3, -13, 32, -2, -3,
    -6, 34, 7, -21, -14, 21, 36, 15,
    -2, -16, 13, -32, 6, -5, -9, 20,
    7, -1, 0, -9, 0, -29, -35, -5,
    24, 44, -17, -19, -30, -51, 47, -10,
    21, 16, 4, 9, -14, -26, -12, 11,
    3, -7, -9, 6, -2, 16, 8, 25,
    0, -17, -17, 20, -15, 8, -13, 24,
    0, -15, 1, 8, -60, -18, 38, -36,
    29, -31, -40, -5, -47, 4, 5, -4,
    -1, 8, 9, 6, 20, -21, -7, -6,
    17, 20, -22, 4, -3, -13, 34, -11,
    25, 8, -28, 8, -11, -2, 15, 32,
    -39, 1, -6, -13, -43, -12, -7, -41,
    -3, -17, 13, -2, -4, 17, -16, -16,
    18, 11, 23, 15, 8, 27, -11, 12,
    8, 7, -1, 10, 35, 13, -33, 32,
    6, 3, 10, -23, -31, -7, -3, 25,
    -9, 6, 3, -12, 10, -5, 8, 12,
    1, 24, -3, 2, -9, 31, 5, 16,
    47, 19, -1, -35, -3, 33, -15, -19,
    21, -13, 7, -21, 19, -59, -8, 5,
    13, -49, -11, -12, -37, 46, 4, 1,
    20, 16, -11, 6, -17, -7, 23, -16,
    22, 15, 15, 6, 28, 7, 7, -55,
    -16, -5, 29, -42, -20, 11, 3, 19,
    32, 11, -2, 16, 3, 4, 22, -7,
    2, 20, -34, -35, 47, 16, 1, 79,
    8, 5, -17, 8, -9, 5, 17, -66,
    9, -9, 11, -31, 9, -12, -5, 16,
    3, -6, -3, 34, -1, -1, -5, -6,
    19, 2, -15, 20, -1, -5, -5, -4,
    9, 26, 8, 20, -23, -83, 62, -26,
    19, 12, 32, 2, 5, -12, 12, 39,
    9, 3, 9, 25, -14, -10, 1, 6,
    -30, -35, -14, 19, 17, 7, 19, 14,
    16, 29, -3, 40, 21, -24, 8, -25,
    32, 9, -36, 14, 3, 33, -7, 12,
    -3, -2, -20, -4, 2, 1, -14, 27,
    6, -7, -1, -5, -23, -5, -14, -6,
    -11, -9, 3, -25, 31, -17, 0, -20,
    23, -2, -33, -36, -23, 21, 1, 8,
    -17, 8, 12, -32, 24, 6, -15, -5,
    -4, 21, -5, 10, 5, -38, 11, -29,
    12, -19, 4, 7, -5, -12, 21, -37,
    25, -22, 11, 31, -8, -11, -23, 11,
    -1, -7, -10, -19, -3, 0, 12, 0,
    -10, 9, 10, -4, 10, -33, 18, 9,
    -43, 1, 0, -10, -10, -17, 26, 31,
    -29, -1, 1, -16, -3, 13, 7, -60,
    -52, -12, 10, -39, -13, -8, 12, 11,
    4, -10, 2, 32, -4, -2, -1, -23,
    2, 8, -9, -4, 8, 10, -27, -19,
    -11, -1, 18, 23, 18, -7, -8, -30,
    31, 2, 10, -18, 33, 0, -6, 3,
    -22, 21, -21, -15, 4, -36, -38, 2,
    20, -10, 7, 18, -18, 8, -14, 5,
    8, 41, 13, -18, 30, -30, 5, -14,
    -26, -37, 9, 4, -9, -1, -54, 1,
    -29, -37, 28, -14, -16, 7, -23, 25,
    -18, 15, -15, -3, -4, 5, 15, -3,
    -10, 5, 0, -6, 16, -4, -3, -10,
    20, 6, -11, -8, -16, 7, -2, 1,
    -44, 8, 9, -19, -1, -5, 24, 1,
    -7, 15, 25, 9, -15, -13, 3, 17,
    -42, 12, 14, 3, 4, 15, -26, 16,
    5, 5, -19, 9, -10, 14, -15, 12,
    -5, 13, 4, 10, 40, -12, 3, -22,
    3, -46, 5, -19, 17, 66, 7, 11,
    -2, -9, 31, -11, -28, -45, 2, -9,
    -14, -41, 9, -19, 3, 13, -1, -9,
    44, 10, 41, 20, 8, -30, -19, -3,
    -14, 17, -17, 20, 37, 27, -28, 14,
    -12, 1, 11, 35, -24, 9, -42, 30,
    -14, 17, 24, 2, 33, 7, -20, 3,
    -31, 2, -11, 4, -15, 2, 9, 67,
    4, 36, 18, 15, 34, 53, 26, -29,
    -29, -3, 18, 18, -6, -8, -17, -8,
    1, 4, -1, 12, 9, 19, 1, -6,
    28, 22, -24, 11, -34, 27, -57, 23,
    -4, -1, 6, 25, -5, -24, -8, 8,
    -51, -3, -29, -7, -5, -45, -7, -52,
    20, -30, 9, -20, -8, 17, 18, 9,
    24, 3, 4, -17, -18, -28, -3, 2,
    14, -5, 1, 31, -18, 35, 29, -10,
    -10, -1, 3, 14, 22, 1, -13, 30,
    4, -8, -10, 20, -2, 8, -2, -12,
    -6, -33, -13, 10, 16, 60, -15, 13,
    7, -11, 0, 0, -14, -2, -23, -8,
    -13, 3, 8, 20, -6, 17, 22, 28,
    11, 33, -6, 11, 0, 13, -4, 20,
    14, -42, -3, -36, -64, 9, 11, 1,
    -21, 15, -11, 18, -21, -12, 9, -11,
    32, 12, 31, -23, -18, 58, -1, 3,
    -37, 33, 6, 36, -2, 4, 1, 16,
    -5, -2, -11, 9, 24, 8, 32, 61,
    12, -14, 13, -9, 37, -45, 8, -30,
    3, -20, 28, -25, -29, 31, 8, -12,
    -26, 12, 17, 11, 22, -4, 13, -16,
    -18, -5, -5, 9, -24, 2, 36, -39,
    2, -7, 16, -16, -34, -30, 14, 8,
    -16, -38, 0, -43, -1, -11, -14, -7,
    -12, -17, 8, -20, -13, -14, -21, -20,
    -3, -24, -13, -4, -10, -18, 6, 19,
    -8, 2, 26, -7, -19, -49, -18, -9,
    -8, -34, -30, -30, -43, 25, -10, 7,
    -49, 16, 20, -16, 6, -31, 3, -5,
    9, -27, 24, 3, 42, 1, 7, -14,
    21, 10, 15, 24, -11, -52, -16, -16,
    -46, -3, 7, -35, -2, 14, 8, 46,
    7, 7, -21, 56, -3, 3, 10, -22,
    18, 11, 18, 13, 17, -39, 29, 1,
    -26, -38, -28, 17, 22, -21, -24, -10,
    5, -7, 37, -8, 29, -15, 0, 56,
    17, -4, -28, -2, -21, 2, -18, -5,
    -12, -45, -30, 22, -46, 51, -3, -18,
    -16, -24, -7, -18, 23, 1, -11, 2,
    20, 18, -13, 7, -36, 2, -16, 10,
    -10, -6, 10, -2, -9, -24, 6, 12,
    14, -28, 24, -7, -35, -5, -12, -9,
    27, -39, -8, -10, 3, 28, 28, 14,
    18, -13, 5, -5, -12, -37, 5, -13,
    -24, -27, -1, -1, 12, 11, -6, 3,
    -14, -4, 23, 4, 14, 9, 3, 7,
    -7, -6, 11, -19, 45, 55, -46, 5,
    -20, -25, 25, 29, 6, -1, 3, -26,
    -6, 12, -1, -28, 10, 13, -5, 9,
    -6, -6, 38, -10, 58, 8, 2, -37,
    13, -3, 5, -26, -21, 30, 23, -38,
    -20, -8, -18, -48, 26, -10, -48, 35,
    -13, -9, -15, 2, -12, -8, 3, 7,
    -7, -9, -10, 14, -16, 12, -53, 28,
    -32, 17, -13, 23, -3, -12, 45, -18,
    -28, -51, 7, 5, -6, 25, 1, 12,
    7, 0, -15, 9, -25, 6, 12, 15,
    -24, 2, -6, 6, 45, -37, 0, -2,
    -34, -7, -1, 21, 5, -20, -1, -24,
    4, -12, -30, 18, -14, 5, 29, -18,
    -5, 26, 9, 20, 36, -30, -9, 1,
    -25, -4, -2, 15, -28, -3, 26, -19,
    14, 4, 7, -7, -38, 29, 11, -2,
    -51, -14, 32, -38, 8, 18, -7, 29,
    -6, 10, -11, -1, -6, 19, 6, -3,
    2, 3, -24, 0, 6, 12, 65, 7,
    10, -3, 15, -10, 25, 15, 3, 51,
    -6, 8, -1, -7, 3, -24, -9, 5,
    9, 15, 20, -1, -8, -15, 5, 5,
    -17, -30, -23, 7, 25, 10, 0, -21,
    -41, -51, -23, 37, 29, -11, -26, -103,
    -34, -85, 33, 12, -1, 125, -2, 63,
    -21, 44, -12, 30, -50, 75, 5, 29,
    30, 6, -4, -3, 12, -2, 1, -30,
    -4, 35, 30, 4, 21, -12, -6, -42,
    -11, 41, -7, -62, 18, 36, 3, -21,
    -10, 0, 13, -5, 33, 18, 10, -3,
    35, -15, 55, -22, -2, 40, -71, 87,
    -17, 11, 6, -13, 16, -16, -1, -76,
    43, -15, -1, -3, -64, -62, 17, 8,
    -1, 20, -22, 5, 4, 21, -18, -12,
    24, 26, 84, 4, -1, 5, 39, 6,
    20, -24, 24, -26, -12, -91, -16, -13,
    -27, 8, 15, 45, -16, -68, -3, -13,
    -15, 4, -42, -19, -1, 21, 13, 16,
    56, 5, -16, 2, 10, -14, -2, 1,
    25, -21, -20, 18, 70, -29, 31, -33,
    47, -44, -17, -23, -14, -17, 0, -15,
    -68, -6, -3, 1, 8, 16, -29, 21,
    7, 24, -4, -40, -12, -43, -6, 39,
    -4, 25, -11, 18, 12, -16, 13, -41,
    -58, -35, 16, 51, 26, 22, 40, -8,
    7, 29, -41, 39, 20, 11, -21, -34,
    -19, 17, -35, 25, 45, -2, -25, 24,
    -34, 6, -11, 0, 28, 14, 62, -37,
    -28, 62, 24, 2, 13, 17, -21, -31,
    -21, 1, 1, 14, 14, 19, 34, 2,
    41, -23, -17, -5, -14, -2, -1, 1,
    25, 25, -30, 5, -66, -44, 3, 7,
    24, -24, -43, -32, 28, -35, 12, -3,
    71, 20, 32, 50, 2, -10, 35, -9,
    -9, -17, 18, -8, 33, -39, 12, 9,
    5, 11, -6, 15, 5, -11, -51, -49,
    -53, -9, 27, -34, -21, -1, 14, 16,
    -20, -3, 2, 20, 46, -13, -7, -2,
    13, 27, -20, 40, 22, -9, -35, 5,
    -8, 21, 42, -25, -9, 43, 21, 81,
    -29, -8, 24, -9, -25, 5, -34, -64,
    49, 80, -12, -1, -6, 15, -109, -20,
    7, 2, 40, -35, -21, -14, -1, 49,
    -39, -20, 11, 32, -63, 19, -12, -10,
    36, -17, -5, 8, 8, -17, 15, 0,
    -38, -29, 11, 16, 0, 18, -17, -4,
    -8, 21, 6, 2, 33, 52, 1, -2,
    37, -11, 26, 43, -11, -11, 16, 13,
    -7, -87, 0, -78, -34, 8, 7, 42,
    -15, -48, 27, -63, 1, 8, -23, 27,
    -21, -20, -30, -20, 22, 21, -24, -9,
    23, 42, -49, -16, -60, 48, -26, 3,
    0, -45, 9, -21, -17, 38, -5, 21,
    67, 43, 38, 55, -26, 18, 2, 7,
    -19, -58, 17, 8, 21, -52, -5, -10,
    -50, -1, 46, -4, -15, 25, 17, 17,
    2, 1, 34, -96, 51, -47, 45, 2,
    -12, 22, 17, 13, 34, -5, -18, 15,
    4, 14, -8, 9, -8, -2, 41, 88,
    57, -27, 21, 9, 1, 95, 29, 13,
    30, -15, 4, -14, 47, -32, -8, -28,
    28, -9, 9, -9, -5, 25, 2, -17,
    -10, -3, -38, -1, -7, 19, -17, 7,
    -8, 9, 47, -28, -9, -21, 28, -9,
    19, -10, -15, -77, -31, 70, -37, 33,
    -7, 13, -46, -1, -15, 14, 21, 22,
    19, 10, -13, 15, -13, -25, -2, 20,
    74, 4, 19, -26, -23, 13, 17, -21,
    37, 4, -53, -17, -29, 4, 2, -19,
    37, -3, 28, -22, 6, 16, -10, -24,
    2, 38, 28, -5, 12, 41, 45, -30,
    6, 11, 15, -47, -42, 16, -28, -4,
    -8, 25, 14, -3, -14, 24, 19, 17,
    -10, 1, 37, -44, 13, 10, -9, 26,
    3, 35, 7, -47, 30, 32, 16, -13,
    9, -29, -3, -17, 18, -3, -17, 53,
    -18, -15, 53, 76, 18, -73, 15, -32,
    -2, -18, -14, -18, 6, 17, 12, 10,
    1, 35, 8, 10, -34, 22, -20, 58,
    -70, -59, 12, 12, 28, -29, 7, -30,
    -20, 72, 0, -39, 34, 58, -30, 10,
    86, -4, -44, -5, 23, 14, 16, -16,
    -4, -29, -24, -55, -13, -32, -9, 3,
    -20, 4, -18, 40, -59, -29, 35, 6,
    -25, 37, -22, 43, 29, 63, -37, 1,
    5, 40, 20, 31, -59, -11, -25, -47,
    4, -8, -17, -6, -17, -1, 9, 27,
    -32, -13, 13, 7, -14, 5, -43, 26,
    -30, 60, 5, -33, 18, -18, 2, -4,
    37, -52, -26, 36, 20, -62, 4, 10,
    35, 26, -47, 27, -2, 9, -28, -4,
    6, 7, -18, -20, 11, -28, -23, 0,
    -51, 53, -24, 37, -33, 25, -30, -99,
    -20, 1, 4, -63, 14, -14, 56, -8,
    16, -7, -49, 10, -47, -35, -34, -2,
    -36, 23, -73, 7, 44, 14, -14, 6,
    -30, 43, -39, -15, 20, -2, -18, -76,
    -24, 18, 47, -33, -17, 16, -18, 7,
    48, 81, 19, -6, 14, 6, -14, -18,
    -55, 53, -10, 17, 59, 15, -18, -34,
    -11, -18, -21, -30, -11, 13, 23, -12,
    -1, -37, -45, 11, 4, -22, 3, 12,
    19, -22, -3, 15, 24, 6, 0, 33,
    7, 27, 5, -17, 46, 23, -10, 33,
    -18, 26, 6, 9, 41, 9, 11, 26,
    -9, 111, -10, -4, 2, 33, -16, -1,
    74, 3, -10, 9, -19, 39, 22, -10,
    -62, 17, 28, 26, 31, 33, -72, 16,
    2, -87, 8, 3, -30, 4, 9, -3,
    -43, 35, 7, 66, -3, 9, -8, -8,
    22, -8, -54, -12, 49, 9, 63, -69,
    30, 17, 0, -18, -24, 11, -4, -50,
    -57, 35, 30, 75, 16, 27, 29, 49,
    -18, 15, 15, 30, 10, -17, -8, 16,
    8, -3, 13, -3, 39, -1, -43, 6,
    34, -45, -6, 12, 14, 9, 69, -18,
    56, 4, 13, -12, -14, -20, 15, -3,
    -10, -9, -22, -16, -10, 21, 15, 6,
    11, 6, 18, 43, -17, -9, 4, 25,
    -11, 6, -37, -24, -22, -47, 36, 13,
    -17, 49, 45, -14, 77, 18, -28, 13,
    80, -20, -36, -47, 44, -49, -17, 14,
    46, -37, 33, -22, 38, -16, 5, 26,
    12, 11, 34, 11, -21, 57, -2, -4,
    51, -16, 6, 84, -20, -18, 12, 36,
    2, 24, 21, 45, -10, 51, 14, -13,
    8, -11, 40, 6, -7, -39, -17, 22,
    -17, 53, -21, -22, 20, 22, -2, 1,
    0, 53, -22, -23, 5, -43, -31, -12,
    -23, -26, 28, 4, -15, -30, 22, 31,
    11, -13, -6, -3, -31, -32, 37, 13,
    -7, 7, 13, 16, -14, 20, -10, 0,
    4, 31, 4, -22, 31, -5, -28, -5,
    -34, -15, -18, -22, 1, 7, 4, -33,
    -1, 2, -6, 7, 9, 23, 8, -9,
    -5, 10, -11, 7, -13, 7, -12, 18,
    -15, 6, 13, 2, -29, 18, -47, -12,
    7, 20, -14, 19, -8, 21, -24, 9,
    -10, 0, 4, -63, -2, -35, 4, -8,
    -8, 7, 5, 15, -1, 2, -3, 11,
    7, -5, 42, -1, 11, 10, 24, 21,
    36, -16, -10, -14, 19, -4, -9, 15,
    2, 9, -2, -9, -2, 16, -26, 16,
    -15, -8, 4, 8, 25, 17, 20, 14,
    11, 9, -32, 20, -9, 1, -11, -15,
    2, -6, -5, 15, -21, 19, 11, -1,
    -5, 2, -3, 2, -1, 1, 2, -16,
    14, 8, -6, -10, 3, 15, -43, 10,
    11, -28, -2, 7, -39, 3, 5, -8,
    -14, -50, -22, 10, -21, 26, 4, -18,
    8, 12, 8, -11, 7, 5, -43, -9,
    3, -20, 16, 6, 9, -16, 7, -3,
    -5, -15, -18, -30, 4, 9, 48, -11,
    -11, -14, -41, 8, -7, 2, 40, -9,
    -7, 11, -10, -1, -2, -13, -25, 39,
    26, -1, -20, -17, -37, -3, 18, -19,
    -7, -20, 24, 17, -12, -1, -8, -56,
    4, 16, 25, 26, -31, 27, 1, -13,
    -16, -3, -14, -3, -19, -9, -9, 1,
    12, 16, 10, 7, 1, 6, 24, -25,
    -4, 13, 4, 29, -31, 13, 7, 13,
    34, -22, -4, 1, -8, -9, 20, 3,
    1, 1, -10, 5, -1, 12, -20, 10,
    -16, 30, -17, -13, 40, 21, 53, 18,
    2, -7, 4, -5, 18, 17, -26, -10,
    -6, 12, -3, -20, -4, 31, -8, -14,
    -6, 7, 0, -6, 36, 6, -11, -9,
    0, -5, -8, 12, -5, 33, 32, 14,
    -4, 44, -7, -3, -5, -5, -3, 13,
    -2, 4, 4, -1, -10, -9, 11, 3,
    10, 3, -3, -1, -37, 15, -6, 3,
    3, -3, -10, 5, -3, 1, -8, 1,
    6, 6, 7, -21, 39, -10, 21, 2,
    11, -7, 40, 7, 15, 21, -2, 16,
    3, -13, 0, -3, -2, 19, -9, 5,
    20, -2, -17, -16, -11, -23, -44, -6,
    -30, 11, 8, 4, 37, -12, 10, -16,
    1, 13, -8, 15, -3, 13, -27, -3,
    4, 1, 0, 27, -6, -17, -11, -27,
    -10, 6, 0, 8, 29, -10, 7, 15,
    10, -5, 2, -17, -11, -19, -8, -6,
    14, 28, 6, 53, -11, -23, 9, 5,
    4, -3, 5, 1, -41, 29, 4, 31,
    -10, 6, -5, 8, 28, 14, -26, -12,
    4, -33, 22, 0, 22, -30, 31, -19,
    -5, -3, 30, 37, 30, 8, 6, 3,
    1, 9, -4, -89, -8, 18, -2, 23,
    -2, 11, -9, -3, -8, -14, 3, -3,
    -16, 23, -11, 18, -1, -21, -33, -4,
    5, 3, 54, 9, 0, 10, 23, -15,
    10, -6, 3, -2, -4, -2, -6, 0,
    -11, -9, -11, 11, -1, 9, 16, -7,
    11, 31, -2, -15, 4, 11, -2, 29,
    5, -27, 13, -33, 18, 3, 13, 34,
    11, 51, -3, -2, -14, 10, 24, 5,
    1, -2, -5, 1, 7, 2, -12, -33,
    -31, -4, 12, -10, -9, 10, -15, -17,
    2, -12, 7, 8, 18, -3, 25, 17,
    -18, -5, -4, -8, -10, 32, -6, -5,
    11, -19, -12, 11, -18, -24, 21, -33,
    -5, 0, 24, 11, 34, -10, -37, 11,
    -5, 13, -21, -11, 17, -5, 20, 26,
    -6, 3, -1, 5, -13, 10, -5, -17,
    -14, 8, -4, 20, 15, -49, 18, 4,
    9, 0, 20, 8, -22, -32, -16, -8,
    13, 15, 27, 12, -14, -16, 16, 27,
    15, -7, 5, -12, -8, 14, -8, -11,
    -1, 11, 18, 5, 32, -1, -1, 3,
    -27, -14, -19, 4, -27, 7, 13, 4,
    -4, 13, 3, 15, 7, -9, 2, 7,
    3, 4, 0, 5, -16, -22, 14, -10,
    -12, -20, 13, -7, 7, -1, 21, -11,
    6, 11, 34, 23, -14, 52, -22, 32,
    -4, -8, 0, 17, -13, 3, 14, 3,
    -24, 9, -5, 4, 24, 24, 8, 28,
    24, -16, 19, -4, -11, -34, -36, -26,
    -4, -6, 21, -13, -26, -7, 1, -13,
    -33, -19, -7, 20, -37, 0, 0, -12,
    -6, 6, 2, 14, 19, 0, -19, 12,
    -24, -12, 6, 1, -6, -14, 15, 27,
    -15, -8, 20, 1, -2, 22, 57, 15,
    11, 6, -32, 2, -17, 0, -12, 16,
    -4, 6, 0, 4, 0, 20, 27, 4,
    -11, -13, 22, 7, 15, 13, 0, -8,
    23, -13, 11, 29, 38, -22, -12, -16,
    -12, 16, -36, 0, 38, 5, 3, -10,
    5, -3, -1, 19, 9, 7, 9, 24,
    1, -18, 7, 9, -15, -18, 3, 18,
    -24, -6, 11, -6, -41, -13, -10, -11,
    14, -9, -16, 5, -2, -30, 8, -9,
    -2, 2, 3, 6, 8, -18, 23, -5,
    10, 1, 19, -3, 24, 33, -23, -3,
    12, 8, 22, 14, 16, 29, 4, 32,
    -52, 18, 11, -31, 36, -31, -4, 10,
    2, -20, 5, -16, -1, 33, -5, 0,
    -13, 21, 10, 2, -24, -3, 9, 32,
    43, 12, 1, 1, -16, -16, -10, -20,
    9, 12, -18, -34, 10, 4, -21, -34,
    -10, 1, 4, -7, -5, -2, -9, -4,
    -5, 17, -4, -1, -14, -13, 42, 12,
    -9, 1, -13, -3, -6, -6, 2, 3,
    1, -22, 2, -12, 15, -4, -41, 23,
    -12, -7, -21, -9, 8, -10, 10, 18,
    16, -15, 4, 2, -18, 23, -16, -2,
    -18, 10, -6, 1, -5, -13, 15, -23,
    -4, 2, -9, 28, 31, 29, 16, 7,
    8, -6, 9, 9, 8, -5, -41, -4,
    -34, 1, 11, -43, -9, -10, 29, -23,
    -25, 16, -21, -1, -26, -5, -14, 11,
    2, 33, -26, -25, 13, -4, -19, 3,
    -14, -10, 13, 1, -14, 5, 15, -5,
    7, 1, 7, -11, 0, 9, 0, -12,
    -15, -33, 28, 23, 14, 22, 16, 21,
    8, -3, -9, 16, -5, 33, -7, -4,
    9, -3, -7, 2, -1, 11, 2, 2,
    5, 11, 7, 10, 12, -4, 8, 11,
    19, 11, -14, -23, 29, 42, -13, -58,
    48, -27, 19, -6, 2, 14, -18, -3,
    1, -1, -13, -14, -29, -42, 29, 19,
    -14, 20, -37, 8, 4, -19, -6, -35,
    42, -1, -2, 2, 15, -11, 5, -58,
    41, 18, -24, 3, -23, -20, 49, -27,
    -11, -1, 1, 1, 27, 26, 39, -58,
    4, -5, -36, 5, 6, 22, 3, -31,
    -5, 1, -6, -16, -24, -46, 3, 2,
    0, -14, -14, -3, -33, -2, -1, 17,
    -10, -16, -6, -90, -16, -9, 21, -30,
    -16, 1, -1, 3, -7, -27, -29, 26,
    -11, 34, 28, 2, 7, 1, -8, 21,
    42, 31, 13, 5, -7, 21, 25, 0,
    15, 4, -7, 22, -5, 3, 17, -24,
    -9, 8, -35, 8, 5, 18, -17, -36,
    -11, 26, -26, 19, 18, 30, 5, -17,
    20, -36, 6, 7, -2, 4, -4, 3,
    8, -2, -8, -6, 3, -7, -26, -26,
    -34, -22, 10, 8, 3, -3, -11, -19,
    -25, 28, -11, -37, -5, 31, -13, 20,
    -15, -50, -26, 14, -30, -8, 20, -24,
    6, 9, 8, 11, 8, 6, -47, 47,
    16, -16, 0, -11, -24, -9, -3, 2,
    1, 17, 26, 12, -6, 12, -9, -8,
    1, -7, -26, 53, 21, -16, 0, -12,
    1, 0, 10, -2, -6, 23, 13, 30,
    -20, 14, -15, -9, -3, 22, 7, 8,
    31, 31, 6, -21, -16, 14, -44, 22,
    7, 44, -1, 14, -28, -10, 4, 43,
    -2, -5, -5, 12, -8, -13, -5, -11,
    47, 28, 21, 2, -7, -8, 12, -37,
    42, -11, 9, 3, 6, 0, 25, -27,
    3, -21, -27, 3, 12, 18, 14, -23,
    -7, -19, 11, 11, 5, -15, 5, -1,
    9, 9, 8, -14, -29, 13, 5, -35,
    8, -37, 37, -2, -9, 10, 15, 20,
    -33, 12, 0, -12, -9, -10, 13, -10,
    -12, 17, -5, 2, 52, -6, 0, -7,
    1, 5, 7, -6, -12, -15, 22, 13,
    -5, 11, -5, -6, 17, 27, 2, -42,
    7, -29, -15, 37, 30, 17, -9, -15,
    -6, -9, -9, 4, 7, 46, 32, 11,
    -22, -13, 14, 1, 15, 4, 14, 47,
    18, 0, 2, -39, 67, 14, -5, 21,
    -2, -11, 23, 6, 12, 3, 0, 5,
    -4, -1, 16, -20, -41, 77, 0, 5,
    12, -30, -10, -23, 27, 29, -31, -38,
    5, -27, -3, -13, -4, -3, 6, 21,
    -4, -10, -27, -10, 20, -4, -14, 0,
    4, -9, -2, 10, 7, -15, 15, -2,
    2, 3, -15, 2, -4, -4, 17, 15,
    -11, -34, -2, -15, 26, 5, -4, 44,
    2, 19, 6, 29, 7, -8, 7, 19,
    4, -1, 7, 1, 20, -15, 4, 19,
    -10, -24, 4, -16, 4, 19, -43, -12,
    -28, 7, 7, -10, 2, -11, -72, 47,
    -7, 4, 2, 23, 24, -22, -8, -1,
    -6, -14, 0, -94, -30, -3, -18, 5,
    6, 1, -2, -19, 11, -21, 36, -15,
    -7, 42, 28, -1, 40, 19, 9, 10,
    -19, -7, 51, -6, 5, 27, 12, 5,
    13, -5, 18, 3, -41, 0, 3, 1,
    2, -6, -4, 16, -11, 14, 28, -52,
    -12, -30, 12, 47, -1, -1, -24, 12,
    14, -12, 19, -28, -5, -19, 19, 21,
    -6, 49, -4, -4, -24, 25, 13, 36,
    -9, -17, 5, -25, -2, 0, -2, -10,
    3, -12, 4, 2, 53, 5, 17, 27,
    -10, -13, 1, -1, -4, 1, -2, 26,
    -18, -8, -7, 10, -56, 51, -4, -21,
    10, -31, 11, 1, -8, -3, 11, -19,
    3, -4, 12, -19, 5, -14, 8, -22,
    -13, -24, -61, 16, -18, -22, 12, 0,
    2, -16, 12, -6, -18, 7, -4, -57,
    15, -2, -7, 24, 17, 30, 17, 21,
    31, 11, 24, 33, 33, 4, -17, -11,
    -63, 2, 14, 47, 36, -25, 17, 35,
    -9, 0, 5, -6, -5, 27, -12, -27,
    -2, 4, 0, 1, -23, 3, 11, -22,
    42, 3, -11, -16, 40, -32, 25, -2,
    -10, -30, 0, -2, 49, -6, -31, -12,
    -8, 0, -7, 13, 5, -3, 14, -43,
    6, -7, -44, 20, 15, -33, -8, 0,
    13, -2, -58, 25, -14, -27, -17, 26,
    4, -28, 21, 34, 22, -6, -45, -7,
    -5, -1, 5, -9, 5, 7, -6, 0,
    2, -12, 14, 19, -4, -36, -19, -21,
    -19, -5, -15, 42, 23, -15, 3, 15,
    -26, -3, -12, 6, -5, 14, -30, 34,
    2, 2, -2, 4, -12, 2, 16, -29,
    -42, -9, 8, 10, 14, -16, -4, 18,
    -25, 24, 2, 64, -10, -37, -17, -8,
    5, 7, -18, 7, -10, -13, -19, 46,
    -3, -3, -2, 4, 10, 25, 11, -7,
    2, -24, -2, 8, 9, -7, 0, 22,
    -9, 8, -26, -21, -17, -41, 0, -3,
    2, -6, -4, -19, 17, 21, 9, -7,
    -7, 3, -21, -2, 50, 29, 0, -5,
    -1, -10, 12, -21, -6, -11, 7, -19,
    6, 9, 31, -5, 42, 3, -11, 7,
    -24, 14, 9, -6, 48, -30, 9, -2,
    7, -11, -3, 0, 25, -3, -10, -13,
    32, 1, 7, 5, -14, 23, -25, -5,
    27, 21, -5, 33, 10, 2, 14, 8,
    -49, -14, 8, -20, 2, -17, 3, 12,
    2, -1, -17, -10, 24, 33, 14, -19,
    -16, 30, 16, 11, 19, -13, 7, -33,
    27, 6, -29, 24, 2, -16, -28, 20,
    -17, 21, -8, -14, 24, 28, 0, 54,
    -5, 3, -12, -4, -29, -23, -39, 30,
    -9, 14, 16, 20, -1, 8, -24, 13,
    -1, 21, 1, 26, -8, -47, -24, -34,
    11, -10, -27, -4, -18, 0, 7, 15,
    -21, -4, -19, -3, -1, -1, 10, -5,
    11, 14, -11, 21, 16, 10, -9, 18,
    16, 5, -9, 7, 8, 32, 10, 7,
    16, 15, -4, 20, -5, -19, 8, -8,
    -2, 6, 11, -5, 23, 7, 13, 37,
    -5, -21, 3, -7, 7, 21, 8, -1,
    -31, -6, -40, -21, 4, -34, 31, 10,
    21, 11, 18, -36, -12, 19, -16, 12,
    -5, 14, -3, 10, -2, -50, -10, 24,
    3, 14, 7, 6, 28, -14, 26, 1,
    23, 5, 34, 7, 40, -57, 34, -20,
    15, -4, -24, 0, 15, -36, 30, 7,
    -4, 7, -6, -12, 16, 13, 20, -14,
    -14, -19, -22, 35, 8, 16, -10, -40,
    2, -46, 11, -15, -1, -41, -31, -14,
    34, -23, 49, 30, 6, -12, -50, 43,
    -9, 8, -1, -7, -81, -10, 78, 23,
    47, -13, -98, -25, 23, -12, 42, -5,
    -12, -13, -8, -12, -44, 9, 12, -2,
    25, 29, -52, -15, -80, -4, 43, 24,
    1, -7, -2, -4, 57, 35, 46, -45,
    8, -18, -77, 62, -33, -24, 24, -1,
    6, -14, -52, -20, 11, -73, 16, -1,
    50, -64, -1, -16, 20, -9, 8, 13,
    -10, -13, 11, -97, -31, 28, 37, -43,
    -4, -33, -22, 21, -34, -26, 53, 23,
    3, -23, -1, -20, -19, -5, -73, 20,
    43, -7, 59, -2, 10, 0, -18, 7,
    -2, 1, 7, -5, 9, 30, 30, -6,
    7, 25, -38, 22, -28, -13, 41, -54,
    16, -64, -4, -76, 18, 53, -2, 2,
    6, -8, 38, -20, 48, -13, 37, 4,
    5, -5, 14, -28, -28, -47, -43, 8,
    4, 31, -32, 12, 3, -26, 9, 1,
    37, -15, 5, 20, 35, -38, -42, -45,
    26, -79, -98, -23, 41, 42, -6, 40,
    34, 0, 12, -4, 3, -9, -13, 87,
    -2, 37, 46, 23, -1, 14, -73, -6,
    -7, -4, -11, -14, -3, 4, -37, 2,
    -3, -7, -62, 49, -3, 43, -58, -51,
    -4, -22, 0, 14, -36, 51, 60, -13,
    4, 36, -31, -1, 34, -29, 7, 11,
    -11, -21, -19, 0, -8, -45, -92, 18,
    43, 28, -20, 64, -25, 29, -63, 4,
    -4, -15, -15, -16, -28, -36, -28, -31,
    -25, 86, 6, -59, 45, -80, -15, 20,
    15, -21, -43, -24, -46, -43, 4, 4,
    -39, 7, -12, -10, -7, 12, -20, 33,
    -2, 6, 18, 3, 51, -37, 13, 0,
    13, 39, 38, 36, 3, 17, 8, -27,
    2, 25, -34, 20, -16, 56, -25, 20,
    -36, 30, 6, 11, -11, -23, -20, 41,
    8, 23, -2, 15, 37, -38, 41, -23,
    -96, 0, 31, -23, 31, -57, -4, -42,
    -10, -38, -7, -29, 38, 62, 0, -37,
    45, -22, -36, 72, -20, 14, 24, 8,
    4, -17, 15, 0, -11, 30, 45, 23,
    -62, -67, 16, 3, 35, 74, -8, 31,
    11, 27, 5, 6, 55, 21, 1, -1,
    94, -28, 65, -10, -22, 15, -44, 47,
    3, 3, -6, 8, -127, 36, -25, -12,
    -24, -51, -57, -33, -2, -4, 67, 62,
    -48, 7, 63, 66, 11, 115, -8, 9,
    5, 73, 1, -57, -33, -22, 24, -5,
    -7, -13, 7, 25, -7, -20, -10, 12,
    -32, 17, -5, -27, -23, 29, -11, -19,
    -19, 62, 71, -24, 31, -40, 95, 25,
    50, -5, 50, 18, -2, 71, 15, -42,
    -8, -10, 7, -10, 75, -72, 84, 0,
    -49, 22, 25, -43, -6, 5, -38, 47,
    6, 53, -44, 14, 28, 17, -12, 7,
    -29, 24, 18, 27, -49, -33, 15, -9,
    12, -11, -3, -126, -57, -13, -53, -4,
    49, 18, -36, 27, -27, 17, 27, -2,
    3, -43, 0, 4, 61, 22, 17, -23,
    12, 2, 60, -35, -12, 14, -68, 37,
    -18, 11, -1, 8, -27, 41, 42, 32,
    2, -5, 32, -16, -49, 37, -25, -87,
    -1, 5, -41, -42, -6, -2, -14, -23,
    -12, 15, -15, -24, -50, 29, -17, -59,
    -11, 77, 1, 4, 38, 10, -8, 86,
    54, -13, -10, -30, -70, -15, 23, 37,
    -8, -8, -20, 60, 2, 13, -50, 24,
    -10, 6, -13, 47, 0, 26, -32, -9,
    -41, -19, 21, -3, -71, 33, 10, -12,
    29, -31, 12, 26, -21, 43, -30, 1,
    41, 41, -16, -23, -21, -77, 75, -48,
    -5, -37, -33, -7, 24, 16, -80, -41,
    23, -10, -3, 3, -25, -38, -18, -72,
    36, -61, -21, 31, 36, -22, 7, -55,
    -46, 15, 47, -6, 47, -6, -11, -16,
    33, -43, -2, 119, -69, -42, 34, 35,
    -20, -16, -23, 13, -90, 43, -58, -33,
    13, -13, 16, -11, -10, 6, -34, -45,
    -16, -19, 68, -26, -50, -50, 12, 9,
    11, -32, 36, 72, -17, 103, 6, 32,
    30, -8, 2, -13, 17, -16, -21, -58,
    20, -2, -95, 0, -77, -20, -4, -53,
    -71, 28, -5, -15, -19, 4, 16, -7,
    7, -49, 23, 42, 16, 12, 35, -37,
    4, 6, -7, -5, -12, 17, 36, -68,
    -35, 5, -14, -5, 52, -7, 13, 76,
    7, -45, -10, 0, 39, 45, 73, 7,
    20, -24, 56, 6, -14, -43, 26, -8,
    3, -10, -1, 3, -12, 0, -7, -62,
    -100, 18, 8, -12, 17, -8, 1, -97,
    -13, -38, -8, -47, 5, -33, -49, 4,
    -5, -29, -47, -3, 49, -7, -9, 0,
    2, 10, -10, -9, 0, 38, 23, -54,
    -3, 1, -84, 44, -16, -4, 30, 51,
    11, -11, 10, 0, 17, -26, -49, -36,
    29, -2, -48, -68, 29, 3, 47, -44,
    17, 3, 7, -15, 65, 28, 10, 1,
    -103, -25, -30, 29, -70, 83, -11, -56,
    -87, 22, -48, 19, 37, 53, 22, -8,
    33, 33, 33, -9, -69, -10, -8, 0,
    23, 9, -20, -5, 51, -93, 14, 0,
    72, -17, 11, 0, 3, -35, -28, 11,
    -39, -48, -1, -22, 12, 51, 29, 5,
    -2, -19, -33, -47, -32, -39, -3, -18,
    19, 9, 5, 11, 12, 70, -27, -78,
    -15, 40, 29, -6, 54, -4, 2, -83,
    -45, -9, 18, 25, 7, 9, -35, 29,
    15, 11, 24, 17, -30, -21, 11, 31,
    -1, 3, 9, 13, -36, -36, -62, 39,
    -22, -11, -44, -30, 15, -15, -3, -39,
    16, -46, 26, -14, 59, -123, -3, -20,
    52, -74, 7, -2, 23, 22, -38, -91,
    3, 6, -30, -21, -2, -40, 34, 21,
    8, 14, 8, 37, -23, -17, 4, -47,
    -9, -1, -27, -18, -13, 46, 13, 25,
    20, 51, -1, 12, -24, -29, -14, 14,
    12, -7, -18, 12, 34, 48, -4, -1,
    2, 56, -32, 18, 29, 5, -8, 30,
    29, -14, 15, -33, 3, -6, 19, 27,
    34, -11, 37, 23, 22, -13, 5, 15,
    -9, -25, 3, -21, 9, -101, -19, 29,
    35, 88, -43, 57, -1, -25, -9, -19,
    -52, -18, -36, -23, -39, -90, 46, -58,
    0, -60, -60, -69, -6, 41, 26, -13,
    0, 0, -20, 20, 67, 25, 46, -23,
    -27, -25, -7, -31, -6, 10, 35, -42,
    -20, 11, 30, 21, 26, -120, -37, 24,
    48, -67, 37, 61, 17, 33, 78, -29,
    7, 0, -8, -21, 0, -6, -17, 16,
    13, 10, 0, -21, 0, -6, -3, -13,
    5, -16, 7, 14, -30, -21, -5, 11,
    44, -2, 2, 18, -31, 47, 10, -12,
    4, -16, -17, -5, -2, -7, -6, 14,
    21, -7, 7, 5, -9, -20, -15, -16,
    6, 8, 4, 11, -18, 6, 10, -12,
    -25, 6, 5, -25, -28, 9, 30, -9,
    27, 11, -13, 5, -16, 2, -17, -6,
    9, 2, 30, -20, 19, -16, -21, -10,
    -2, -16, 6, 10, -39, -5, 33, -3,
    -26, 19, -1, 19, -19, 40, -55, -22,
    -1, 12, -7, 14, 19, 2, 10, -27,
    -13, -40, 13, 18, 37, 8, -5, -1,
    -6, 2, 7, 5, -10, -2, 0, -10,
    7, 0, -14, -11, 22, 1, 3, 6,
    -6, -12, -3, 5, 19, -36, -55, 7,
    15, -19, -3, -4, 5, -12, 10, -2,
    -5, -5, 8, 2, -8, -1, 6, 6,
    21, 5, 35, -5, -8, 27, -18, 22,
    19, 10, -5, 14, -20, 3, 14, -32,
    22, -15, -27, 3, 0, -15, -1, -6,
    -9, -6, -20, 4, 4, -11, -2, -12,
    -6, -15, 14, -10, -35, 9, -24, -3,
    2, -27, -12, 8, 15, -46, 18, 9,
    15, 10, 14, 27, -6, 12, 9, -1,
    14, -4, -8, 0, 13, 22, -30, -43,
    7, -1, -11, -17, 28, 7, -58, -14,
    23, -21, 22, 10, 32, 20, -16, -15,
    16, 3, -11, -4, 9, -11, 20, 27,
    -10, -11, -8, -9, -21, 23, 10, -10,
    -3, -25, 24, 4, 10, -5, 8, 1,
    0, -8, -1, 3, 5, -12, 0, -8,
    -8, 26, 0, 21, -3, 10, -18, 14,
    -21, -17, 18, -4, 6, -7, -26, -13,
    -11, -24, -17, -3, -16, -6, 8, 12,
    -21, 6, -7, 2, -4, -15, 2, -6,
    -12, 6, 14, 27, -13, 25, 6, 11,
    -10, 2, -9, -17, -12, -1, -39, -13,
    22, 10, -18, -4, 10, -19, -7, 21,
    -1, 9, 4, -2, -17, -1, 3, -23,
    -8, 12, 6, -9, 20, -11, 17, 4,
    12, 14, 8, -5, 13, 34, 23, -3,
    -20, 11, 7, 1, -40, -1, -7, -2,
    -7, 24, 2, 10, 24, -8, 2, -17,
    5, 12, 15, -13, -18, -18, -4, -10,
    16, -7, -10, 17, -4, 10, -12, 7,
    7, -32, -1, -8, -14, -16, -16, -36,
    -4, 16, -23, 7, 23, -10, -20, 2,
    -17, -5, -10, 13, 20, 15, 3, -11,
    8, -5, 1, 24, 52, -12, -4, -2,
    20, 27, 9, -12, -20, -37, -12, 20,
    13, -21, -19, 8, -1, 2, 11, 7,
    -1, 4, 18, 4, 19, 11, -14, 17,
    -15, 10, 14, 5, 10, 2, 9, 2,
    -16, -8, -12, 3, -4, -10, -37, 3,
    -6, -21, 23, 5, -12, 0, 4, 28,
    -2, -11, 24, 5, 0, 7, 0, 18,
    4, 18, -18, -18, -7, -2, 15, -40,
    0, 13, -21, -15, -17, -14, -11, -17,
    -4, -3, -14, 9, 34, 4, 15, 17,
    5, -2, 6, 8, -5, 4, 0, 5,
    8, 2, 8, 8, -26, -26, 2, -7,
    17, -5, -16, 35, -11, 22, 18, -9,
    5, -10, 7, -24, -23, -11, -11, 1,
    0, 7, 30, 10, 0, 8, 11, -13,
    11, 4, 1, -13, -29, 8, -6, 13,
    10, -6, 40, 6, -26, 10, -25, 2,
    10, -10, 13, 1, -19, -31, 8, -13,
    18, -11, -41, 28, -12, 2, 0, 13,
    12, 10, -1, 4, -9, 26, -19, 7,
    -35, 34, -14, -10, -15, 4, 37, 21,
    24, -5, 8, 10, -24, -27, 1, -44,
    14, 14, -13, 5, 2, -7, 5, -11,
    0, 8, -1, -13, -26, -10, -22, 0,
    -34, -9, -1, 11, 23, -3, -1, 25,
    -16, -22, 19, -7, 19, 11, 10, 6,
    -29, -9, 31, 6, -19, -10, 8, 9,
    3, 6, 5, 15, 5, 5, -21, -6,
    -24, -19, -14, 29, 5, 6, 18, -42,
    7, -18, 4, 23, 20, -26, 8, 5,
    -26, -27, -4, -11, 4, -4, -23, -15,
    -2, -7, 7, 2, 0, -3, -24, -29,
    1, 5, -20, 10, 29, 58, 11, 26,
    -4, -6, 8, 8, -14, -32, 12, 25,
    18, 23, 10, -4, 5, -7, 8, 19,
    18, -2, 5, 0, -1, 4, 21, -5,
    19, 15, -4, 0, 13, 20, 14, -11,
    5, -5, 27, -4, -8, 9, 7, 10,
    2, -9, -29, -18, -5, -1, 14, 8,
    4, 6, -10, 3, 7, 9, 3, 20,
    -15, -10, 23, 2, 34, -11, 24, 45,
    -6, -20, 13, -23, 22, 11, 27, 12,
    -42, 9, 2, 21, 2, 1, -8, -17,
    -8, 4, 2, -14, -6, 33, 6, 14,
    22, 10, 8, 21, -17, -26, 15, 16,
    -10, -7, -2, -4, -12, -37, 16, 11,
    -4, 14, 16, 4, -28, -8, 1, 33,
    2, -2, 0, 11, -11, 20, -3, -1,
    -2, -18, -11, -6, 9, -8, 12, -14,
    8, 14, -15, 8, 18, -22, 24, 17,
    -2, -39, -20, -7, 9, -10, 13, -9,
    -12, 1, -1, -6, 3, 11, 12, 30,
    -5, 6, -2, 9, -8, 12, 3, -7,
    -10, -12, -10, 17, 19, 3, 12, 4,
    -15, -29, -3, 11, -28, -5, 5, 3,
    -7, 9, -6, 3, -9, 48, 14, -14,
    20, 7, -13, 4, -10, 6, 9, 39,
    20, 7, 7, -15, 24, -47, -2, -11,
    21, 18, -2, 8, 17, 8, -7, 8,
    7, -18, -6, -8, 3, 25, 0, 10,
    9, 3, -12, -8, -1, -4, -6, 1,
    4, -19, 24, -5, -9, 11, 1, 1,
    25, 14, 3, -9, -5, -15, 0, 16,
    12, 6, 15, 1, -26, 29, -4, 41,
    -26, 20, -11, -4, 4, 7, 22, 8,
    7, 29, 6, -1, -17, -15, -11, -2,
    14, -13, 8, -3, -22, -15, -10, -8,
    16, 3, 2, 4, 0, 15, 13, 16,
    2, 22, 1, 23, -19, 10, 39, -3,
    -12, -34, 22, -23, 9, -14, 3, 7,
    5, 1, 39, 19, -11, -7, 30, 23,
    31, 1, -16, -5, 1, -11, -10, 12,
    -39, 6, -21, -6, 15, 19, -60, 14,
    -15, -1, -20, -1, 6, -15, -15, 15,
    -27, -31, 7, -50, -12, 10, 1, 25,
    0, 2, 9, -9, 26, 23, 5, 0,
    -15, 31, -15, 7, 24, -30, 8, 0,
    -26, 7, 1, -18, 26, 43, 4, 16,
    -39, -31, 9, 23, 1, -9, 8, 27,
    4, -56, 9, 7, -6, -35, 5, -3,
    27, 22, -4, -10, 42, 37, 2, 7,
    -14, -41, -10, -3, -29, 1, -38, 68,
    -42, -15, -12, 30, -24, 6, -13, -9,
    7, 13, 15, 13, 7, -9, 26, -17,
    -32, -14, -20, 0, 21, -15, 25, 27,
    4, 4, -44, -7, 11, -31, -1, 16,
    -7, 17, -2, -45, -8, -2, 10, -10,
    3, -28, 16, 15, -16, -42, 7, -7,
    4, 1, 42, 5, -18, -42, 7, -35,
    -2, 5, -10, 6, -8, 12, 11, 16,
    -32, 5, -41, 85, -13, 18, 13, -17,
    -10, 31, 30, 10, 11, 13, -15, 16,
    -6, 17, 2, -14, -20, 16, -10, -17,
    -3, -21, -10, 8, 61, -28, -34, 30,
    -15, 16, -15, -6, -28, 43, 0, -11,
    -4, 3, -13, -26, -14, 31, -12, -29,
    -13, 19, 15, -33, 7, -28, 23, -13,
    6, -4, -2, 7, 29, -24, 51, -76,
    19, -17, 10, 4, 43, -15, -15, -5,
    -7, 11, -27, -18, -4, -24, -27, -2,
    34, -20, -25, -2, -11, -10, -2, -2,
    15, 3, -16, 14, -33, -35, 20, -9,
    0, 16, 16, 46, 34, 10, 19, 34,
    -6, 0, 7, 12, 11, 30, -20, 12,
    -10, 12, 14, 59, 14, -56, -24, 6,
    -15, 0, -5, -5, 27, 33, -21, 12,
    21, 19, 5, 38, -12, 2, 17, 0,
    -34, -1, 6, 1, -60, 45, 37, 6,
    39, 1, 38, -17, -101, 37, -14, 45,
    -3, 13, -1, 16, 5, 19, 13, 7,
    -6, 3, -1, 13, -8, -27, 18, -23,
    10, -6, 5, -7, 9, -31, -6, -31,
    -11, 10, -40, 9, 8, 56, 20, -16,
    -3, 18, -17, -49, -38, -6, -10, 3,
    11, 12, -7, -25, 24, 2, 27, 18,
    11, 3, -17, -28, 35, 18, 6, 2,
    17, 9, 1, 5, 22, -4, 55, -5,
    21, 12, -5, 5, -29, 4, -19, 19,
    -19, -7, -24, -49, 26, -10, 20, -8,
    4, 16, -5, -8, -17, 1, 4, -3,
    -14, 5, -4, 3, -85, -33, 6, -2,
    -6, 51, -8, -2, 57, -65, -3, 20,
    3, -7, 16, -34, 25, -22, -8, -21,
    13, -14, 9, 7, 3, 21, 2, 43,
    -40, -6, -19, -12, 2, 6, 9, 25,
    -1, 13, -31, 0, -32, 20, -14, -30,
    13, 26, -14, 23, 17, -18, 8, -11,
    3, 6, -5, 9, 52, 21, 13, 23,
    9, 9, 15, 4, -7, 22, 1, -8,
    -14, -4, -16, 27, -24, -55, 21, 11,
    23, -7, -5, 12, -2, 6, -22, -5,
    2, -12, 32, -30, 18, -5, 67, 18,
    -2, 61, -16, 29, -34, -54, 29, -15,
    25, -16, -10, -24, 33, -25, -35, 16,
    42, -15, -15, -29, -26, -18, 16, -12,
    9, 15, -19, -33, -14, -12, 20, -28,
    -11, 15, -15, -15, -25, -12, -5, 3,
    3, 17, 13, -6, 24, 18, 5, 80,
    -14, -26, 17, 32, -6, -25, 1, 26,
    5, 4, 12, 17, -9, 16, 6, 25,
    3, 0, -23, 13, -72, 1, -25, 4,
    8, -2, -6, 18, 12, 4, -16, -39,
    -4, -10, 18, -35, 33, 8, 0, -2,
    12, 2, 9, -5, 6, -2, 25, -6,
    -7, -8, 32, 0, 46, -2, 6, -21,
    -14, 1, 20, -9, 21, -9, 55, -2,
    2, -19, 15, 26, -14, -5, -11, 4,
    19, -2, -23, -23, -7, -6, 26, -40,
    -31, 10, 13, 27, -25, 11, 4, -12,
    8, -27, 10, -14, -33, -5, 12, -72,
    15, -56, 13, -2, 45, 21, -5, 22,
    4, 10, -7, -5, 0, -20, -24, -48,
    5, 17, -20, 24, 56, 14, -21, -25,
    -22, -13, -14, -30, 1, 50, 24, 18,
    29, 57, -13, 33, 22, 15, 14, -9,
    10, -5, -9, 17, 4, -44, 12, 14,
    0, -28, 14, 16, 34, -22, -50, 18,
    -9, -10, -15, 18, 37, -8, 4, -66,
    35, 13, -36, 2, 31, 9, 26, 11,
    -18, -11, 4, -4, -5, -36, -39, 15,
    17, 37, -11, 13, -37, 4, 41, -35,
    -10, -22, -6, -2, 8, -14, 22, -26,
    27, -8, 35, 17, 2, 20, -10, 24,
    -14, 6, -7, 19, 5, 20, -38, -20,
    22, 1, 13, 10, 27, 37, 4, 28,
    5, 26, -12, 15, 42, 3, 31, 1,
    3, 17, 29, 11, 8, -8, -1, 10,
    4, -2, -19, -1, -45, -16, -15, 3,
    -6, -16, 31, -5, -24, -14, 27, -57,
    32, -28, -20, -3, 27, 29, -36, 15,
    35, -1, 28, -17, -36, 6, -43, 7,
    14, 12, -16, -26, -6, 20, 3, -21,
    28, 21, 5, 7, 10, 42, 12, -14,
    25, -15, -37, 20, -5, 7, 50, -6,
    -7, 40, -1, 23, 25, 6, 7, 0,
    -9, -11, -4, 7, 25, -7, -9, -16,
    -14, -8, -7, 7, 21, 28, 20, -12,
    19, -16, 24, 23, 43, -15, -17, 16,
    8, 8, 3, 6, 15, 35, -1, 5,
    -11, -3, -11, -4, 22, 14, 27, 21,
    7, 43, 24, -24, 36, -21, 40, 2,
    -2, 7, -9, 7, -4, -38, 10, 24,
    -33, -2, -10, 23, -1, -16, -25, -8,
    2, -3, 14, 0, -7, 70, 59, -12,
    17, 20, -6, -19, 22, 21, -25, 19,
    6, -33, -42, -20, 23, -20, 27, 15,
    9, -47, -6, 29, -7, 31, -17, 28,
    10, -5, 21, -3, 12, -4, 23, 18,
    1, 8, -16, -7, 29, -9, 12, 22,
    37, 12, 20, 5, -13, -14, -11, -8,
    11, -35, -3, 12, 55, -2, 19, 6,
    -5, -2, 11, -4, 4, 10, 1, 2,
    -27, -9, 10, -2, -40, -33, -12, 5,
    2, 8, 43, 7, -41, -14, -33, 60,
    -14, -28, -24, -32, 24, 5, -45, 19,
    24, 22, -1, 25, -1, 31, 12, 11,
    33, 2, 19, 17, -1, 29, -36, 47,
    15, -16, 5, -11, -58, -13, -12, 17,
    -49, 55, -10, -34, 18, -2, 11, 27,
    9, 8, 2, -17, 3, -12, -11, -5,
    -21, -10, -3, -27, 13, 2, 3, -33,
    12, -5, -11, 5, -4, -87, -55, 11,
    14, -14, -4, 11, 3, 6, -23, -14,
    -3, 14, 5, -2, 2, -15, -33, -9,
    -6, -1, -20, 31, 37, 24, 8, 32,
    -38, 27, 6, -34, 61, 3, 19, -33,
    26, -87, 2, -6, 28, 44, 3, 8,
    2, -67, 20, 25, 41, 57, -32, 34,
    -10, 13, -5, 9, -30, 73, -14, 10,
    -17, -51, 48, -1, 37, 32, -46, 30,
    29, 11, 14, 49, -2, -25, 11, 41,
    15, 11, 33, 26, -4, -37, -15, 32,
    -59, -18, -50, -21, 62, 13, 0, -3,
    -23, -19, 27, -18, 3, -24, 33, 36,
    -3, -3, -73, -28, 7, -29, 24, -28,
    11, -42, 36, 15, 70, 59, -57, -7,
    10, 27, -15, 0, 40, -28, -23, -31,
    -28, 55, 1, -17, -68, 12, -21, -14,
    -40, 2, 0, 54, -74, -55, 3, -33,
    14, 45, 13, 16, -23, 44, 18, -29,
    8, 3, 43, -31, -3, 21, 17, 9,
    20, -62, -7, -10, 14, -24, -29, 35,
    -29, 17, 2, -11, 0, 26, -24, 3,
    -21, -35, -11, -37, 29, -26, 28, 76,
    20, 17, 12, -28, -14, -62, 21, -5,
    -3, -37, 33, 25, -33, -96, 112, -95,
    -58, 14, 26, 24, 12, -64, -40, -15,
    0, 8, -23, -61, -43, 0, 73, 34,
    13, -11, -13, -1, -8, -30, 64, -14,
    44, -28, 18, 41, -18, -41, -43, -16,
    -21, 22, -17, 22, -45, -40, -1, 82,
    16, -64, 13, 37, -43, -15, 38, 2,
    -1, -2, -8, 115, 18, 18, -2, -30,
    -5, 6, 15, 35, -26, -15, -15, -6,
    -40, 27, 22, -92, 27, -33, -32, -12,
    -38, 1, -11, 127, 77, -70, 4, 27,
    14, 22, 33, -74, 59, 7, -9, 14,
    34, 22, -6, 6, -32, -22, 25, -26,
    -33, -27, 7, -29, -25, -13, -16, -34,
    -20, 24, -33, 22, -3, -41, 33, 31,
    -34, 42, -9, -7, 59, -17, 11, 23,
    -38, 30, -12, -112, 16, -32, -5, 33,
    -36, -9, 52, -23, -25, -20, 13, 12,
    71, 19, -9, -23, 75, -6, -8, 72,
    34, 16, 20, -27, -7, 36, -12, -66,
    29, 8, -5, -18, -108, -10, 5, 47,
    23, -2, 18, 22, -14, 2, -6, 38,
    -24, 13, -11, -13, 37, 5, -25, -10,
    20, -9, -27, 2, -13, -16, -25, 9,
    27, -31, 6, 28, 72, -20, -42, -16,
    28, -8, -23, -58, -21, 4, 14, -5,
    -11, -25, 59, -7, 12, -76, 6, -55,
    14, 17, -5, 12, 3, -28, -3, -53,
    5, -29, -127, 4, -11, 52, -14, -57,
    12, 63, -35, 50, -21, -25, -79, -19,
    29, 22, -10, 13, -35, 25, -20, -26,
    -13, -14, 127, 0, -14, 13, 24, -80,
    0, 18, -64, 63, 25, -41, 10, 51,
    -27, 36, -23, 15, -3, -30, -49, 46,
    -3, -22, 23, -37, 2, -22, -73, -10,
    -17, 67, -22, -29, 36, 24, 41, -7,
    9, 4, -13, -25, 27, -26, 1, 66,
    17, -16, -35, -4, 5, -13, 6, -40,
    3, 0, -7, -30, 41, 2, -1, -18,
    -17, -25, 27, -3, 14, -50, 48, -29,
    3, -26, -2, 19, 8, -23, 9, 51,
    68, -38, 75, -14, 21, 12, -2, 43,
    15, -21, -76, 32, 48, 14, 12, 53,
    2, -39, -25, -54, 25, 20, -32, -97,
    59, 6, -49, 60, -67, -5, -19, 18,
    22, 5, 37, 13, -37, -4, -12, -5,
    42, 7, 15, -4, 18, -6, 21, -17,
    17, -23, 38, -11, -94, -9, 15, 7,
    -9, -1, -9, -9, 3, -62, 88, 24,
    11, -49, -28, 9, 7, 3, -6, 19,
    11, -25, -27, -40, 23, -31, -36, 6,
    -24, 34, 15, 4, 44, 61, -36, 11,
    -22, -38, 20, -18, -40, -14, 34, -77,
    -37, 35, 0, -53, -58, -17, -20, -57,
    17, 0, -4, -2, 14, 3, 33, 62,
    12, 22, 7, 47, 1, -2, -37, 103,
    -7, -23, -67, -25, -7, 19, -8, -2,
    -47, -82, 0, 0, 24, 22, 28, -10,
    62, 6, -44, 27, 8, 8, 58, -9,
    34, 38, 44, 26, -54, 4, -7, 15,
    -2, 45, 4, -5, 1, -5, 7, 19,
    16, -3, -23, 7, -13, -40, 11, 13,
    -69, -6, 35, -2, -15, 44, 21, 29,
    5, 4, 6, -13, -36, -5, 4, -11,
    5, -3, 20, 5, -32, -84, 12, -29,
    24, 11, -37, -60, -5, 16, 87, 25,
    24, 10, -29, 40, 21, -10, -23, 33,
    -9, -20, -3, 47, -29, -44, 35, -6,
    24, 54, -28, 9, 54, -9, 62, 34,
    -14, 24, -4, -34, 2, -26, 13, -54,
    14, -16, -18, 4, 60, -17, 1, -65,
    -35, -12, -28, 55, -14, 20, -11, -26,
    44, -10, 1, 32, 6, 2, -19, -43,
    68, -46, -92, 60, 2, -25, 53, -30,
    14, 56, 35, -41, -49, -24, -103, 25,
    13, 33, 11, -28, -4, 21, -77, 21,
    71, 34, -39, -20, 12, 6, 11, -25,
    -24, -66, -53, 27, -13, -6, -8, -59,
    -9, -2, -7, 21, -68, 25, 94, 0,
    -13, -25, 10, -5, 4, 42, -10, -15,
    1, 15, 19, 55, 57, -24, -26, 32,
    -16, -11, 31, 0, -3, -19, 24, -7,
    -11, -9, -8, -10, -30, -40, -3, -25,
    0, 49, 15, -45, -11, -11, 8, -4,
    13, 11, 4, 0, -14, -34, -5, 11,
    -4, 11, 12, -11, 16, -38, -35, 21,
    -12, -54, -17, 31, 26, -20, -16, -32,
    28, 9, 38, 6, 22, -27, -53, -64,
    -28, -10, -41, -1, 59, -19, -13, -34,
    -1, -14, -2, 44, 5, -22, 27, 4,
    7, -12, 23, -16, 46, -15, -29, -51,
    -16, -24, -23, 25, -56, 27, -26, -15,
    54, 39, 24, 14, 19, -36, 4, 25,
    -4, -26, 32, -23, -3, 34, 26, -11,
    -32, -4, -17, 19, 56, 6, 8, 7,
    -3, 2, 18, 8, -25, 1, -8, -25,
    -47, -23, 2, 30, 16, 19, 5, 37,
    -72, 54, -12, -28, 38, 26, 33, 18,
    17, -9, -55, 27, -6, -15, 11, -48,
    34, -25, -44, -10, -23, -10, 44, 11,
    48, 3, 40, -14, -24, -70, 27, 20,
    -27, -2, -53, 46, -11, 0, -13, -6,
    14, 42, 42, -28, 23, 18, -7, -12,
    -10, -12, -3, -68, -72, 77, 41, 36,
    35, -15, -16, 31, -32, -96, -101, 22,
    34, -23, -98, 56, 5, -7, 16, 31,
    -18, 18, 15, -8, -30, 4, 12, -4,
    2, 16, 3, 20, 5, 39, -21, -13,
    33, -19, 2, 45, 23, 10, -17, 23,
    31, 5, -3, -1, 30, 29, 8, 14,
    -4, 33, 18, -7, 1, 7, -4, 10,
    -9, -36, -16, 37, 30, -4, 6, 32,
    18, -27, 11, 4, -10, -28, -5, 33,
    7, -2, 19, -5, 9, 2, -13, 37,
    42, 5, -16, 27, 11, 3, 12, 2,
    -2, -1, 17, 25, -7, 30, 36, -9,
    18, -24, 4, 1, -4, -12, 21, -7,
    -1, -11, 20, 10, -8, 14, -21, -8,
    15, 3, 26, 11, 1, 9, 2, 7,
    -50, 4, -37, 15, -6, 18, 7, 3,
    3, -4, 29, -1, -6, 9, -12, 26,
    -19, -26, 14, 12, -6, 15, 11, -1,
    0, 5, 22, 0, -12, 13, -7, 8,
    -9, 29, -22, -12, 24, -11, 5, -33,
    -21, -32, -36, 9, -10, 16, 1, 5,
    -3, -19, -11, 36, -3, 16, 10, 2,
    -15, 22, -16, 22, 0, -15, 3, -11,
    -6, 19, 9, 1, 8, -22, -18, -35,
    -14, 7, 7, -26, 4, 5, 15, 23,
    -2, 10, 2, -17, 8, -5, 11, 4,
    39, 1, 0, 16, 3, -20, -16, -1,
    9, -11, -5, -10, 8, 22, 9, -7,
    27, 13, 8, 42, -4, 1, 9, -2,
    45, 5, -3, -8, -29, -32, 2, -15,
    -14, 17, 12, 29, -7, -6, 6, 8,
    48, 4, -37, 12, 16, -3, 9, 0,
    30, -1, -25, -20, -23, -5, 1, 21,
    30, -1, -6, -19, 1, 24, -7, -11,
    -13, -15, 14, -10, 20, -3, 6, 9,
    -2, -8, 23, 28, 24, 34, -19, 26,
    -19, 2, -27, 17, -45, 3, 12, -8,
    -7, 8, -56, -2, -12, -5, 11, -1,
    4, 1, 5, 24, 2, 4, -21, -14,
    6, -51, 2, -14, -3, 54, -19, 24,
    -7, -15, 11, 22, -3, -14, -18, -1,
    -25, 11, -19, -25, -28, -22, 0, -29,
    -10, -5, 10, 2, 16, 15, -4, 12,
    -3, -55, -17, -15, -1, -8, 4, -15,
    -10, 4, 20, -2, -4, -17, -3, 8,
    29, -2, 3, -7, 17, -8, -19, 16,
    -27, -29, 17, 12, 3, 9, 6, 4,
    -46, 2, -19, 3, 28, -37, -6, 11,
    31, 18, -3, 19, -6, 0, -6, -2,
    14, 8, -24, -9, 27, -16, -5, -10,
    1, -1, 6, -17, -4, 0, 1, -6,
    2, -8, -21, 16, 21, -28, 24, -5,
    0, 0, 8, 43, -4, 13, 6, 7,
    26, 7, -7, 43, -18, 7, 16, 24,
    -16, 12, -10, 8, 29, -7, -31, -10,
    -1, -22, -4, 12, 5, 36, 7, -9,
    -13, 22, 21, 21, 0, -17, 14, -44,
    29, -10, 2, 32, -2, 19, -35, -13,
    28, 8, -6, -18, -1, 13, -1, 13,
    -21, 24, -15, -21, -39, -25, -6, 9,
    9, 20, 23, 5, 1, -15, -13, -3,
    -6, -37, 14, 2, 12, 11, -42, -5,
    16, -1, 13, 13, -3, 0, 8, 1,
    16, 46, -10, 9, -6, 29, 5, 10,
    24, -7, 7, -29, -6, -3, 11, -6,
    -1, -2, 9, -5, -14, 7, 19, 10,
    2, -1, -14, -15, 3, -6, 8, 17,
    36, -31, 5, 64, -26, 31, 7, 13,
    -35, -7, 1, -26, 2, -3, -8, 1,
    11, -12, -7, 8, 7, -15, 3, -42,
    27, 10, -15, -14, 0, 1, 0, 17,
    -34, 1, -4, -4, 24, 27, 17, 3,
    -9, 7, 17, 3, 10, 1, -28, -8,
    19, 13, -15, 40, 12, 1, 12, -19,
    -7, 21, 6, -4, -18, 10, 7, -10,
    -8, 16, 22, 5, -6, -23, -1, 14,
    -51, -1, -3, -3, -14, 8, 8, -2,
    -39, 8, -15, -24, 15, 15, -2, -16,
    10, 14, -6, -22, -5, -4, -19, 21,
    -8, 31, -21, 0, 9, 0, 10, -12,
    28, 22, 15, -17, -4, 4, -6, 4,
    6, 33, 22, -30, 33, 0, 4, 5,
    9, -19, -25, 1, -5, -7, -3, 5,
    -42, 26, -20, 16, -21, -16, -15, 14,
    12, -11, 8, 13, 13, 16, -34, 14,
    -12, 8, 6, -7, 3, 40, 11, -2,
    9, 1, 24, -26, -12, -7, -6, -10,
    -2, 17, -13, 14, -26, -9, -25, -18,
    12, -27, 20, 27, 19, 14, 19, -2,
    17, -4, 21, -18, -19, -2, 13, 19,
    -10, -15, 14, -19, 7, 15, 11, 8,
    9, 30, 7, 3, -9, 27, -9, 11,
    -22, 36, -3, 14, 16, 26, -5, -32,
    -27, 12, -4, -9, 27, -13, -20, -16,
    19, 18, -27, 4, -16, 4, -9, -8,
    -6, 2, -1, -6, -11, -4, -15, -23,
    -18, 6, 1, -9, -14, 4, -5, -11,
    -2, 25, 12, 2, 3, 9, -1, 11,
    4, 13, 22, -2, 13, 8, 0, 4,
    -36, 5, 22, -5, -1, -4, 19, 16,
    -44, 6, -19, 22, 0, 19, 10, -3,
    37, 34, 1, 1, -4, 2, 17, 0,
    -27, 3, -9, 35, -2, -7, -4, -5,
    23, 29, 16, -11, -24, -5, 12, 22,
    -41, -17, 17, 8, 9, 6, 7, 13,
    -18, 5, -8, 2, -17, -14, 4, 4,
    -6, -40, -27, -14, -1, -12, -1, 7,
    -13, -4, -4, -9, 18, 0, -21, 19,
    -2, 17, 12, -43, -40, -23, 13, 38,
    -25, -9, 10, -10, 6, 7, -1, 35,
    -33, 13, -9, 0, 10, 11, -7, 4,
    -4, 25, 47, -20, 4, -34, -14, 5,
    12, -45, -14, -10, -15, -3, -25, -3,
    7, -3, -22, 29, -26, -14, -7, 30,
    -3, 22, -16, -1, 2, 10, -6, 4,
    -2, -3, -41, -25, 5, 24, 21, 8,
    -7, 23, -8, 27, -22, -2, -3, 21,
    46, -5, 5, 8, -5, -14, 15, 20,
    -8, 14, 3, -14, 1, 4, -2, 3,
    28, 40, 4, 15, -27, -41, -11, 2,
    13, -6, -4, -2, 17, -3, 0, 2,
    32, -11, 24, 14, 39, 32, -30, 5,
    -28, -9, 27, 36, -5, 8, 9, 12,
    18, 34, -24, 20, -17, 41, 19, 13,
    -12, -6, 6, 6, 6, 32, 1, -6,
    11, -31, 14, 11, -14, 16, -29, -6,
    6, -12, -2, 21, -2, -2, 2, -8,
    -13, 54, -67, -25, -57, -18, 16, 6,
    -22, -38, 21, 13, -16, -20, -13, 18,
    -9, -1, 17, -22, 0, 5, -36, 1,
    -6, -3, 11, -13, 1, -9, -8, -1,
    9, -11, 18, -11, 11, 22, -14, -8,
    74, -9, -27, -5, 22, -26, -21, -12,
    40, 12, -20, -43, -33, 52, 19, -26,
    21, 13, 18, -3, 11, 3, 0, 0,
    -56, 26, -17, -17, 0, -12, 28, -27,
    96, -118, 59, -32, 18, -18, -20, -41,
    45, -14, 53, 7, 17, 19, -16, -11,
    37, -2, -21, 0, -7, -4, 3, -4,
    51, -4, -5, -12, 29, 10, 26, -30,
    24, -84, 44, -6, 0, 32, -35, -24,
    -21, -40, -10, 14, 17, -2, -50, -5,
    -17, 13, 1, -14, -7, 4, 8, 0,
    7, -26, 8, 3, -18, -16, -34, 6,
    -7, -21, 28, 0, -10, 4, 18, 9,
    -1, 16, -11, 17, -26, 7, -35, 13,
    2, 5, -2, -8, -5, -5, 5, 1,
    -39, 9, -24, -7, -1, -29, 4, 20,
    2, -61, -67, 31, 27, -17, -24, -43,
    -11, 23, -33, 23, -22, 38, -15, 19,
    -11, 5, -10, 23, 3, -8, -7, -4,
    56, -8, -24, 37, 42, -33, -16, -3,
    -13, -7, 23, -32, -2, -14, 12, -20,
    -28, -13, -36, -22, 5, 1, 30, 30,
    28, -12, -8, 16, 11, 4, -11, -2,
    15, -19, -9, -34, 1, -23, 13, 20,
    58, 48, -17, 72, 11, -23, -8, -18,
    34, 30, -11, 11, 63, 66, -62, -8,
    12, -8, 19, 14, -12, 6, -8, 0,
    10, 16, -12, 20, 33, 17, -12, -16,
    84, 24, -23, 5, 9, 46, 21, 21,
    -34, -36, -5, 14, 0, -39, 3, -2,
    -25, -11, 1, 18, 2, 5, 8, -3,
    -25, -14, 2, 1, -22, 16, -18, -10,
    -26, 14, -11, 4, 11, -4, -25, 18,
    18, 9, 23, -14, -33, 12, 30, -6,
    4, -25, -6, 13, -1, -5, 3, -4,
    36, 6, 38, 46, -17, 32, -51, 17,
    10, -20, 10, 10, 2, 4, -3, 6,
    77, -5, 49, 20, 1, -17, -1, 23,
    19, 22, 16, 5, 5, 0, -10, 2,
    5, 8, -18, 23, 24, 7, -19, -24,
    -14, 10, 11, 0, 9, 24, 2, 22,
    -1, 3, -23, -11, 16, 4, 2, 0,
    12, -7, 5, 27, -6, -5, 14, 1,
    -1, -5, -8, -24, -10, 2, 10, -37,
    29, -22, -7, -6, -15, 7, -18, 23,
    5, -8, -29, 25, -20, 46, 5, -57,
    -22, 16, 7, 27, -13, -22, -4, -1,
    29, -7, -29, -11, 14, -46, 17, 4,
    10, 6, 19, 31, 1, -22, 10, -11,
    -26, 26, -4, 54, -23, 15, 1, 12,
    -15, -21, -10, -12, 11, 2, -77, -4,
    4, 16, 15, -9, 10, 3, 21, -4,
    -39, -9, 55, 4, 11, 53, -1, -3,
    15, 23, -32, 12, 22, 10, -16, -13,
    21, -10, -7, -20, -19, 16, -9, 8,
    -44, -69, 15, -3, -29, -14, 23, 8,
    52, -8, 51, 27, 29, -2, 31, -7,
    10, 4, -15, 20, -71, -23, 18, -4,
    7, 17, -11, 26, -9, -6, 0, -3,
    -1, 18, -7, -18, -24, 15, -1, -1,
    1, 14, 44, 25, -35, -6, -3, 61,
    -6, -10, 30, 15, 2, 28, 12, -8,
    -2, -18, 2, 18, -7, 4, 9, -18,
    -36, -20, 28, 29, -20, -21, -21, 3,
    -86, -9, -21, -19, -26, -3, -13, 13,
    3, -7, 5, 67, 13, -4, 5, 20,
    -7, 1, 9, 13, -5, -4, 19, 11,
    -69, -5, -43, -1, -47, 4, 9, 17,
    -3, -20, -35, -11, -3, -9, 4, -10,
    31, -31, 1, 34, -2, -17, 0, -31,
    -24, 4, 15, -22, -4, 14, 4, -6,
    7, -11, 19, 26, 9, -14, -39, 22,
    -51, -18, -27, 80, 29, 1, 33, 5,
    -9, 47, -30, 7, 59, -15, 20, 5,
    -12, -21, -9, -19, 1, -5, 4, 12,
    4, -16, 14, 5, -16, -13, 34, 25,
    55, -3, 34, -7, -54, 3, 31, -14,
    -3, -16, -4, -11, -11, -25, -11, -23,
    1, 23, 6, 23, 5, 3, 9, 3,
    21, 23, 20, -9, -20, 69, -5, 3,
    43, -103, -5, 57, 29, 11, 33, 36,
    16, -57, 26, -13, 23, 26, -42, 4,
    -22, -4, 62, -9, 10, -4, 12, -9,
    3, -27, -12, -11, -46, -3, 0, 14,
    -11, -64, 62, 5, 20, 0, 17, -15,
    -8, -1, 25, -10, 13, 23, -90, -35,
    4, 3, 5, 21, 8, -13, -25, -7,
    -29, 5, -3, 20, -13, 19, -2, 22,
    -36, 0, -44, 11, -38, -6, 14, -2,
    16, -9, 59, -13, 11, 6, 7, -4,
    13, -2, -15, -13, -15, 0, 5, -4,
    -21, -11, -1, 2, -45, 19, -17, 16,
    1, 106, 34, -73, -32, -6, -21, -18,
    4, -66, 10, -15, -44, -45, 26, 28,
    -5, -5, 12, -6, 11, 12, 7, -9,
    2, 49, 5, 15, -6, -10, 33, -59,
    -33, 10, -11, 18, -16, -7, 16, 8,
    6, -25, -15, 15, -20, -30, 22, 0,
    20, -16, -8, -3, -10, -13, -4, 2,
    39, -34, 31, 36, 13, -19, 14, 22,
    -55, -39, -14, 17, 26, 2, -7, 3,
    9, 2, 9, -24, 49, 1, -30, 25,
    3, -9, -12, -15, 9, 3, -16, -1,
    4, -3, -21, -10, 24, -21, -40, 11,
    -6, 17, -2, -30, 27, -26, 26, -9,
    9, -24, -14, -10, -16, -7, -25, -9,
    13, 30, -22, 7, 2, 15, 7, 1,
    -7, -8, 25, 6, 4, -49, -22, 20,
    18, -41, 20, -1, -7, 22, -31, 16,
    -3, -40, -27, -12, -1, 21, -25, -9,
    12, 18, -27, -24, -5, 15, 18, -13,
    10, -44, 1, 1, 0, 12, -2, 5,
    -26, 53, 8, 6, 46, -29, 1, 3,
    -54, -16, -7, 0, -16, 38, 2, 17,
    -17, 15, -2, -15, -3, -12, -1, 4,
    30, 3, 14, 16, 70, 29, -8, 15,
    43, -6, 37, -24, 41, 10, 13, -7,
    -1, -26, 39, -26, -26, -29, 4, 24,
    -7, 21, 23, 13, 10, 0, -8, 1,
    -27, -1, 13, 20, 33, -18, 12, 19,
    20, -49, -31, 0, -32, 6, -17, -17,
    -25, -18, -39, -33, 11, 21, -11, 22,
    6, -10, 12, 27, -11, -10, -12, -5,
    -31, -71, 22, -19, -34, -36, -30, -15,
    -11, -79, 32, 63, -15, 25, 10, 38,
    12, 20, 2, 10, -5, 13, -12, -61,
    7, -22, 16, 18, -2, 14, -5, 16,
    3, -26, 19, 15, -13, 1, -25, -30,
    51, -35, -58, 54, -6, -18, -10, 17,
    20, -34, -25, 76, 63, -12, 53, -20,
    -16, -40, 48, -4, 42, -6, 8, 12,
    30, 17, -5, 4, -28, 49, 34, -6,
    97, -127, 48, -23, -71, 37, -38, 20,
    -17, -9, 0, -19, 23, 11, 30, -26,
    77, -26, 26, -12, -63, 81, -62, -24,
    19, 53, 11, -11, 38, 7, 27, 39,
    27, -64, 31, -4, -38, 27, 22, -26,
    24, -4, 41, 23, 29, -18, 69, -14,
    -20, 66, 0, -7, 3, 4, 37, 3,
    -25, -25, 15, -5, -12, 41, 5, -17,
    -13, -4, 35, 8, -2, -62, 28, -10,
    -12, -28, 31, -27, -1, -21, 5, -12,
    -18, -45, 20, 2, -7, -17, 12, -14,
    5, 18, 43, 44, -58, -2, 45, 47,
    9, -90, -84, 82, 13, -43, 16, 13,
    -47, 9, 0, -39, 35, -6, -7, -1,
    -23, -74, 6, -9, -8, 21, -3, -1,
    -14, -35, 17, -44, -2, 22, -8, 90,
    -5, -9, 55, -77, 5, 11, 4, -33,
    -12, -20, -13, -72, -41, -23, -12, -3,
    -30, 1, -12, -12, 7, 4, -19, -27,
    18, 89, 1, -27, -8, -21, -7, 92,
    45, -22, -9, 18, -7, -18, 6, 19,
    18, -90, 60, -42, 20, 1, -22, -30,
    -59, 97, 21, 4, -3, 0, 6, -33,
    -8, -7, 16, -33, -26, 29, 13, 64,
    53, 66, 5, -12, 35, -42, 17, -9,
    -3, -3, 12, 1, 7, 27, -11, 28,
    -21, -19, -48, -12, 38, 4, 2, -23,
    29, -6, 64, 35, 94, 24, -20, -74,
    3, 67, -25, 1, -22, 9, 16, -11,
    -41, 42, -40, 19, 14, -14, -59, 1,
    18, -66, -33, -23, -10, -31, -4, 0,
    -7, 52, -34, 45, -5, -82, -10, -45,
    -1, -33, 21, 31, 23, -33, -8, 18,
    4, -11, 39, 76, 39, 38, -2, -7,
    28, 15, 1, -9, 13, -3, 18, 30,
    -22, -4, -26, 17, -30, 22, -24, 4,
    -2, -46, 42, 15, -9, 16, 4, 17,
    -3, -40, -14, 11, -66, -2, -9, -25,
    -5, 13, 49, 39, -43, -18, 16, 10,
    -13, -34, -30, -19, -16, -24, -1, -58,
    31, -43, -22, -79, -2, -18, 11, 4,
    9, -5, -29, -68, -17, 2, 32, 17,
    -99, 53, 9, 62, -4, -16, -25, -19,
    45, -95, 2, -6, -37, 6, 13, -36,
    12, -12, 16, 27, 2, -1, 65, 11,
    -22, 1, 59, -20, 18, -30, 17, -5,
    -13, -19, -10, -22, -12, 14, -127, 35,
    -26, 44, -8, -36, -20, -8, 8, 40,
    -29, 30, 62, -9, 38, 14, -3, -11,
    -27, -16, 25, -12, 4, -45, 39, 43,
    42, -21, 48, -16, -14, 46, 34, 35,
    -19, 22, -30, -13, 28, 23, 33, 0,
    -3, 13, 37, 27, -2, 34, 37, 18,
    23, 15, -41, -9, 6, -9, -9, 21,
    11, -5, -19, 24, -30, 0, -3, 6,
    0, -15, -16, -20, 2, 0, 16, 23,
    40, 21, 64, 29, -25, -38, -29, -51,
    -40, 15, 22, 70, 31, 11, -6, -8,
    77, -43, 40, 53, -39, -15, 22, -47,
    -4, -17, 15, -42, -25, -55, -45, 30,
    -77, 8, -41, -28, -36, -4, 36, -2,
    23, 19, 10, -41, -10, 9, -21, 27,
    9, -4, 24, 87, -23, -3, 70, 22,
    -9, 5, -21, 7, 68, -17, 63, -30,
    9, -35, 4, 38, -19, 26, -18, 4,
    8, 37, 63, 44, -21, -22, -37, -12,
    -45, 7, 21, -35, -18, 31, -4, -4,
    26, -16, 5, -28, -36, -15, -25, -5,
    -33, -29, -18, 84, -61, 29, 27, 21,
    99, 30, -11, -29, 2, 23, -23, -10,
    -95, -4, -40, -27, 14, 3, 74, 15,
    -37, 40, 11, -82, -29, -15, -22, 18,
    36, -27, 39, 32, -17, 26, 3, -51,
    -29, -14, 5, 35, 12, 3, -17, 5,
    -47, 67, -11, 26, -5, -17, 15, -5,
    -12, 1, 18, 22, 29, 32, 36, -41,
    35, -44, 0, 57, -30, -15, -17, -41,
    -20, -1, 14, -38, -39, 0, -10, 37,
    22, 3, 103, -41, 20, -20, 24, -11,
    41, 68, 47, -19, 10, 69, 22, -74,
    -23, -38, 35, -34, -15, 28, 45, 30,
    14, 0, -65, 27, 12, 3, 16, 76,
    20, 42, 10, 54, -4, -39, -19, 32,
    -39, 5, 40, -35, -38, -32, 8, 14,
    6, 2, 8, 12, -3, -12, -16, -5,
    -15, -72, 2, -16, -5, -4, -59, 13,
    17, -7, -16, 2, -14, -36, 0, -2,
    -3, 39, 2, 38, -6, 24, 20, 15,
    3, 26, 33, -49, 13, -37, 7, 57,
    -15, 33, -2, -36, 77, 32, 27, -27,
    2, 5, -44, -85, 23, 20, 3, -48,
    6, 6, -20, 15, -41, -21, -45, 70,
    3, 43, -6, -20, -13, 31, 10, 17,
    -3, 23, -42, -6, -11, 15, 5, 14,
    87, -37, -33, -43, -22, -19, -15, 5,
    30, 17, 20, 54, 17, 17, -29, 11,
    -29, -16, -42, 50, 21, 35, 3, 17,
    67, 55, 10, -18, -21, 39, -17, 13,
    10, -40, 4, 30, -3, 12, -27, 7,
    -38, 4, 4, -16, -1, -36, -9, 19,
    -18, 1, -9, -70, 36, -7, -19, -28,
    25, -6, -40, -5, 4, 0, -9, -20,
    30, 47, 15, 38, -3, 14, 2, -28,
    -22, -13, 40, -38, -50, -24, 0, -59,
    36, -51, 38, 7, -41, 39, 72, 53,
    25, 26, -3, 5, -25, 4, 86, 34,
    19, 26, -38, -24, -9, 22, -8, -21,
    -3, 17, 59, 70, -24, 0, 17, 55,
    -21, 38, -22, 3, -55, -17, 15, -4,
    -14, 10, -23, -56, 24, -58, -18, 4,
    -52, 7, -8, 36, -33, -19, 14, -12,
    -71, -7, 2, -31, -69, 11, 13, -6,
    4, 7, 29, -5, -5, -29, -72, -57,
    34, 26, -24, -3, 25, -5, -11, -38,
    -9, 57, 23, 9, 56, 16, -26, -22,
    -29, 32, -7, -38, -21, 13, -17, 52,
    -22, -30, -26, 23, 7, -49, -26, 15,
    -95, 108, 30, 40, 34, -27, 0, -8,
    -8, -73, -36, 11, -13, -37, -54, -25,
    47, 77, 33, 33, 19, -30, -17, 72,
    44, -73, 41, 63, 4, -29, 0, -6,
    -55, 81, -44, -15, 61, -17, 50, -15,
    31, -13, -30, 47, 6, -12, 17, 71,
    19, 14, 47, -8, -11, -118, -35, 18,
    26, -12, -23, -34, 27, 29, 5, 3,
    -19, 28, 12, -19, -6, -29, 26, 20,
    -4, -33, -6, -13, 14, 15, -8, -15,
    32, -15, -31, -46, -14, 17, -2, -25,
    -36, -10, 5, 35, -5, 18, 9, -13,
    20, -6, -18, 33, 34, -41, 9, 18,
    6, -1, -22, 10, -25, 0, 15, 0,
    17, -21, -14, 35, 8, -34, -2, -4,
    2, -19, -53, 4, -7, 35, -5, 12,
    4, -7, 20, 35, 15, -71, -14, 17,
    1, 11, -6, 21, 37, -54, 5, 4,
    5, -16, 49, 33, -29, 0, 20, -52,
    9, 10, 17, 0, -5, 36, 8, -21,
    -5, -9, 30, 14, -23, 45, 22, -27,
    -10, 12, -8, 13, 24, 11, 19, -7,
    3, 9, -4, -16, 9, 16, 5, -3,
    -15, -5, -9, 27, -27, -6, 30, -14,
    9, -15, -5, 8, 0, 72, -41, -12,
    -9, -5, 8, -27, 4, 5, 21, 13,
    -4, 31, 21, 29, 23, 14, -10, -7,
    -15, 0, 13, -28, -17, 2, 21, -6,
    -54, 0, 23, 12, -6, -8, -67, 16,
    11, -10, 13, 25, -11, -7, 15, -12,
    -4, -3, 3, 9, -4, -13, 6, -38,
    -25, 32, -26, 2, 41, -22, -6, -33,
    -37, -10, -3, -16, 26, -21, 10, 53,
    6, 4, -4, 20, -6, -31, 2, -24,
    17, -1, -24, 31, 5, -24, 0, 11,
    9, -10, -9, -4, -38, -10, -19, 36,
    3, -9, -20, -14, -20, -39, 13, -52,
    -41, -11, -7, 2, -20, 15, -15, 44,
    -23, 22, 32, 12, -12, 4, -19, -9,
    1, 11, -14, -20, -6, 18, -18, -45,
    -4, 13, 13, 0, -58, -9, 23, -22,
    -15, 25, 6, -17, -6, 14, -33, 15,
    12, 3, 23, -1, -26, 8, 11, 18,
    -13, -11, 18, 29, 25, 0, -11, 4,
    -6, -38, 14, 18, 3, -47, 24, -20,
    12, -11, -10, -3, 31, 31, -22, 19,
    -29, -9, -27, 14, 0, 0, 16, 19,
    -18, -22, 6, 24, 34, 14, -21, -1,
    7, 18, 1, -13, 46, 29, -14, 43,
    -4, 30, 9, 28, -11, 1, 10, 11,
    16, -7, 6, 2, 7, 10, -9, 3,
    -19, -23, -8, 3, -2, 25, -7, 11,
    -7, 6, -12, 0, -9, -14, -19, 25,
    0, -39, -20, 19, -32, 13, 31, 26,
    18, 18, 13, 31, -1, -28, -21, 1,
    -43, -1, -3, -17, -2, -11, 10, -4,
    -3, -23, -3, -18, -24, -13, 23, 48,
    -25, -19, -1, 0, -10, 15, -8, 20,
    -14, -20, -2, 6, -10, -1, 6, -6,
    -16, 10, 18, -3, 30, 6, -32, 27,
    28, 1, -14, 7, -8, 45, -109, -1,
    -26, 7, 35, 5, 17, -7, -20, 28,
    -35, 40, 29, -21, -18, -3, 1, -18,
    -25, -5, -17, -1, 23, 18, -6, -39,
    3, 1, 3, 16, 6, -28, 15, -1,
    16, 3, 26, 15, -4, 35, -4, -9,
    7, -30, -18, 22, 18, -4, -34, -95,
    41, 52, 3, 31, 16, -50, 31, 35,
    -5, 8, -12, 5, -18, -32, -12, -3,
    -43, 5, -11, 30, 8, -11, -30, -9,
    -26, -10, -22, -7, 5, -13, 2, 8,
    18, 9, -22, -9, 17, -2, 31, -15,
    -21, -4, 0, 14, 34, -22, 7, 51,
    -20, -7, -1, -7, -47, -16, 19, 5,
    17, -20, 14, -15, -1, -37, -6, -8,
    15, 11, -22, 11, -11, 0, -2, 5,
    34, -16, -19, -29, 29, 39, -19, 21,
    -15, -14, 2, -32, 16, 1, -5, 28,
    -9, 23, 20, 8, -18, -38, -8, -6,
    22, 10, 2, -10, -19, 27, 1, 14,
    1, -32, -2, 14, -23, 21, 67, 48,
    -2, -15, 5, -2, 4, -25, -19, 5,
    46, -9, -25, -3, 6, 4, 8, 2,
    32, 6, 9, -9, -44, -2, -35, 16,
    16, 2, 10, -24, 30, -34, 10, -27,
    21, -9, -5, -3, -34, -22, -5, 2,
    4, 6, 16, 24, -2, -7, 12, -35,
    -20, 16, 2, 6, -51, -2, -25, -24,
    4, 12, -6, 16, 33, 1, 46, -21,
    -28, -47, -49, -5, 5, 9, 5, 4,
    11, 18, 38, -5, -4, -19, 5, -9,
    -7, -27, -34, 10, 12, 6, -7, 65,
    21, -11, 7, -22, 9, 23, 91, -10,
    -11, -3, -50, 29, 47, 3, 31, 34,
    3, 24, -10, -35, -4, 10, 3, 6,
    31, -30, -7, 14, 6, 7, 22, 17,
    27, -1, -33, 35, -1, -17, -28, -2,
    -9, -10, -43, -16, 38, 23, 0, -45,
    6, -27, -51, 2, 26, -9, -3, -24,
    34, -10, 17, 41, -8, 26, -1, -44,
    14, -10, -10, 18, -31, -14, -12, -34,
    -8, 18, -20, -11, 13, 3, -1, -14,
    7, 22, -13, -8, 17, 1, -3, 10,
    -39, -48, 4, -7, 26, -9, 0, 6,
    1, -17, 15, -10, 16, -10, 49, -8,
    8, -5, 33, -18, 14, -27, -25, -9,
    6, 30, 30, 0, 7, -6, 3, -6,
    23, -21, 23, -16, 1, -18, -13, 33,
    15, 16, 22, -11, 14, 13, -24, -43,
    21, 16, -15, -2, -24, 24, -28, 3,
    9, 5, 11, -49, 2, -8, -2, -13,
    -6, 2, -5, -1, -19, 9, 8, -18,
    38, 17, -16, 6, -40, 11, 3, -25,
    24, -6, 19, 17, -7, -16, 5, 12,
    11, 30, 17, -3, 20, -36, 10, -10,
    -44, 9, 18, 17, 26, -7, -70, 13,
    0, -27, -4, -34, -39, -65, 15, -7,
    2, -3, 21, -27, 4, 30, 22, -20,
    3, -6, -9, 8, -14, -5, -19, -10,
    12, -14, 9, -6, -2, 3, 11, 34,
    4, -13, -24, 26, -12, 39, 8, -4,
    14, 11, 1, 1, 27, 21, -25, -17,
    7, -3, -58, -10, -13, -4, -17, -5,
    -68, -19, -13, -21, -6, 9, -9, -2,
    25, 33, -4, -14, 14, -37, 68, 44,
    22, -24, 13, -20, -5, -5, 0, -22,
    19, 0, -1, 11, -7, -13, 9, 0,
    7, 20, 9, -6, -3, 2, -18, 3,
    -7, -3, -11, -30, 12, -20, -31, -56,
    -33, 44, -8, 8, -13, 6, 9, -15,
    11, -24, -8, -8, -41, -6, -2, 6,
    13, 12, -2, 8, 34, 25, -10, -9,
    -3, 7, -2, -4, -1, -35, 27, 51,
    -3, 3, 37, -20, 17, 15, -8, 16,
    -19, 11, 4, 0, -20, 9, -2, -2,
    -3, 0, -14, -57, -30, 7, 16, -49,
    13, 47, 23, 48, -43, -86, 11, -24,
    -6, -6, -18, 6, -90, 26, 21, 48,
    0, 31, -26, -5, -37, 18, -10, -17,
    -16, 19, -1, -2, -11, -4, 2, -22,
    21, -14, 16, 17, 87, 33, 31, -14,
    8, -3, -4, 26, -20, -13, -16, 20,
    30, 28, -36, 48, -9, -34, -7, 1,
    -22, -18, -31, -16, 2, 17, 50, 9,
    -18, -21, 12, 48, 35, -3, 34, 4,
    17, 5, 7, 7, 1, -15, 18, 15,
    -7, 32, -42, 29, -17, -4, -10, -76,
    8, -4, -8, -19, 9, 9, -12, 34,
    2, 24, 8, -44, -33, 19, 28, -4,
    9, -1, 9, 14, -9, 0, 2, -25,
    -17, -24, -29, -20, -7, -10, 8, -4,
    5, -8, 8, -17, 13, -42, 2, -18,
    6, -12, 5, 0, -84, -28, 0, -74,
    2, -3, -24, -11, -16, 13, 15, 33,
    -22, -16, 48, 22, 14, -7, -11, 2,
    -8, 14, 10, 28, -5, 7, -51, -51,
    -11, 6, 17, -15, 5, -6, 24, -81,
    0, 14, 0, 31, 17, -23, -18, 14,
    -31, 10, 10, -14, -1, -26, 9, -20,
    39, -15, -51, -12, -25, -16, 27, -32,
    19, 1, 7, -7, 9, 71, -37, 4,
    37, 0, 0, 25, -27, 42, 16, 32,
    -20, 17, -2, 26, -20, 15, 17, 6,
    -3, 26, -1, 19, 7, -13, -25, 19,
    -8, 18, -4, -11, -43, 21, 15, 29,
    39, 17, -2, 5, 34, 14, -12, 14,
    5, -16, 43, 13, 13, 7, -3, -8,
    -1, 27, -26, 4, 26, -5, -59, 13,
    -11, 28, 1, -5, -37, 4, -8, -18,
    4, 12, -3, 8, 14, 17, 7, -1,
    45, -20, 2, 1, 17, 4, -5, -16,
    -12, 31, 33, 6, 13, -23, -3, -16,
    3, -11, -10, 24, 26, 46, 43, 17,
    -12, 12, 17, 23, 6, 33, -18, -8,
    -17, -8, -54, -11, 10, 19, 3, 8,
    -3, -26, 34, -6, -11, -1, -1, -35,
    35, 26, 11, 9, -76, 5, 14, 8,
    -37, -28, 1, 37, -5, -13, -16, -3,
    -35, -21, 7, -5, -7, 1, -7, 19,
    -13, 29, -9, 18, 1, 3, -4, 39,
    -9, -7, -3, 6, 4, 11, -24, 3,
    -64, 2, -19, -105, 27, 35, 1, -48,
    7, 5, 0, -42, -14, 13, 4, -5,
    18, 2, -13, -8, 34, 6, 9, 0,
    31, -26, -1, -15, -25, 20, 11, 15,
    24, 25, -8, -12, 18, 19, 2, 30,
    -21, -15, 13, -23, -15, 5, -2, 13,
    -4, -10, 12, -22, -50, 4, -8, 30,
    -3, -9, -3, -3, -6, 19, 125, -11,
    -25, 13, 11, -31, -16, 13, 2, 30,
    5, 25, 71, -5, 5, 1, 6, 0,
    12, 22, 0, -28, 22, 19, 3, -30,
    -8, 0, -3, 38, -25, -44, -27, -21,
    -16, 8, 5, 3, -3, -24, -13, -29,
    25, -26, 13, 20, 7, -29, -12, -83,
    16, 33, -5, 4, -27, -35, 7, -10,
    17, 6, 8, -16, -6, -25, -8, -28,
    4, -8, 27, -27, -17, 13, -17, 32,
    52, -20, -20, -6, 26, 7, -4, 4,
    9, 6, 3, -34, -10, -4, -6, 22,
    28, 8, -8, 3, -29, -19, -38, 42,
    -43, -7, 22, 10, -33, -19, 32, -8,
    4, -32, -2, -24, 4, -42, -9, 1,
    14, 24, 8, 7, -19, 37, -16, 26,
    20, -2, -3, -30, -7, 43, 54, -29,
    -21, -15, 22, 11, -21, -4, -5, 27,
    -2, 16, 13, -12, -21, -57, 12, -6,
    50, -47, -32, -7, -10, 19, -2, -6,
    10, -12, -2, -2, -7, -73, 40, -76,
    -11, -46, -16, 47, 9, -59, 8, -32,
    19, 10, -43, 28, 22, -13, 5, 18,
    -8, -16, 27, -9, 19, -22, -42, 13,
    1, 7, -4, -17, -18, 21, -5, 5,
    -17, -51, -29, -25, -6, -28, -19, -14,
    1, 15, -17, 35, 19, 0, -2, -15,
    6, 6, 6, 48, 45, -14, 3, -38,
    -16, 8, -11, -3, 3, 121, -7, 15,
    10, 17, -16, -18, 0, -12, -52, -3,
    17, 18, 14, 1, 16, -10, 4, -1,
    -1, -6, -42, 19, 37, 22, 13, 25,
    18, 0, -14, 24, -22, -22, 30, -49,
    -38, -22, 10, -28, 37, 12, 9, 15,
    4, 3, 48, -9, 8, -18, 9, -33,
    -16, 16, -15, -3, 3, -4, -3, 31,
    -11, -1, -37, 49, -8, -18, -9, 69,
    -3, 45, -42, 10, 12, 9, -6, -20,
    37, -32, 24, 34, 2, -2, -1, 0,
    2, 9, 8, -6, 56, 12, 37, -42,
    2, 20, -31, 3, -9, 78, 95, -52,
    -22, 16, -47, 9, 24, -17, -9, 7,
    15, 34, -40, 0, -6, -7, 13, 7,
    -13, 0, 13, 1, 31, 57, -1, 13,
    15, -41, 6, -16, 31, -75, 4, 34,
    -56, 8, 34, 32, -10, 6, -24, 2,
    22, -26, 15, 2, 2, -16, 10, -15,
    53, 3, -16, -17, -12, -27, -17, -13,
    -5, 16, 4, 15, 2, 32, -12, -12,
    25, -16, -5, 30, 14, 13, -6, -6,
    30, -4, 7, 10, 5, 14, 9, 1,
    16, -25, -21, 4, -43, 6, 2, 8,
    29, 29, -26, 9, -14, 40, 11, 27,
    -14, -17, 5, -12, -26, 37, -26, 27,
    3, 32, -34, -28, -15, -48, 10, 3,
    -3, 24, -16, 6, 43, -41, -4, 3,
    2, 20, 7, -19, -92, 68, 43, -41,
    -29, -7, 16, -15, 11, 1, 11, -18,
    -48, 5, 0, -25, -20, -12, -10, 7,
    17, -15, -20, 7, 23, -66, 22, 5,
    18, -10, -13, 9, 25, 10, 16, -8,
    -29, -52, 7, 8, 30, 22, 1, -11,
    -6, 4, -54, 9, -16, 14, -32, 8,
    -10, 16, -42, -1, -41, -27, 8, 22,
    5, 46, 7, 0, -19, -9, 27, 3,
    -43, 14, 5, 15, -13, -28, -2, -3,
    -11, 28, 8, -7, -14, -2, 2, 11,
    28, 6, 22, -6, -8, -15, 39, -20,
    0, -20, -13, -2, 6, 6, 15, -9,
    20, 28, -9, 26, 30, 14, 16, 16,
    -22, 7, -42, 20, -30, -3, 12, -14,
    -30, -18, 1, 5, 33, 47, -27, 35,
    -3, -4, -17, -23, -11, 25, -11, -7,
    24, 20, -28, -4, -25, -30, -4, 6,
    -11, 5, -34, 37, 1, 2, -30, 12,
    -30, 61, -80, 16, -122, 33, -7, -17,
    -27, 116, 16, 59, 7, 16, -23, 44,
    -61, 30, 20, 45, 27, -38, 2, -43,
    30, 57, -24, 2, 1, -2, 12, -22,
    4, 34, -3, 17, 16, 5, -5, 6,
    -48, 10, 24, 5, 27, 57, 14, 26,
    15, -1, 34, -7, -10, -8, 5, -7,
    8, 58, -56, 91, 5, -23, -15, -6,
    22, 35, -34, 12, 15, -54, 3, 17,
    -21, -47, -32, 11, -7, 3, 46, 28,
    25, 9, 2, 15, -43, 28, -1, 34,
    19, 12, 8, 39, 7, 2, -10, -78,
    52, 7, 52, 6, 1, 16, -33, 28,
    11, -30, -8, -72, 47, -8, -62, 22,
    20, -3, -1, -9, -44, -41, 58, -22,
    -10, -12, -108, 4, -1, -4, 9, 11,
    47, -36, -21, -19, 51, -58, -11, -17,
    -13, 71, -31, 24, -35, 50, 37, 43,
    -13, 6, -13, -1, 65, 57, -20, -68,
    -43, 85, 45, 24, 11, 32, 0, 2,
    -36, 9, 25, -31, -4, 41, 0, 46,
    20, -22, -59, -63, -20, 22, -15, -43,
    8, 32, 1, -36, -28, -43, 8, 13,
    -22, -29, -26, -41, 24, -5, -3, -11,
    -23, -28, -3, -44, 41, -7, -7, 14,
    53, 31, -21, 12, -19, -28, -49, -31,
    36, -21, 11, 15, 17, -5, 7, 44,
    -40, -79, 97, 20, 15, 7, -18, -6,
    53, -14, -9, 36, -11, 55, -3, 29,
    -47, 35, 13, -39, -20, 34, -27, -5,
    35, -50, 4, -22, -41, 17, -2, -43,
    44, 9, 53, 0, -31, 29, -13, -28,
    13, 3, -21, 31, -56, 16, 13, 57,
    27, 1, -3, -11, 20, 9, -8, 37,
    -11, -43, 0, 45, -10, -2, 26, -67,
    20, -108, 16, -5, 8, 9, -7, -27,
    -2, -103, -20, 24, -45, -28, 43, -41,
    8, 2, -51, -33, -67, 13, 31, 18,
    78, 46, 33, -7, -9, 1, 18, -36,
    -36, 32, -84, -13, 10, -4, 11, 47,
    35, -15, 24, 11, -32, -25, -20, -16,
    -18, 18, -27, 45, -78, -16, 7, -20,
    101, -27, 11, 17, 27, -12, 37, 40,
    -81, -12, -13, 36, 21, 35, 20, -9,
    -67, -7, -33, 14, 13, -31, -41, 19,
    -2, 13, 27, 13, -29, -65, 22, 49,
    -44, -41, -16, 40, 7, 7, -54, -21,
    -91, 33, 11, -78, 6, 8, 4, 7,
    -1, 9, -45, -28, 39, 3, 1, -31,
    14, 10, -22, -38, -40, -10, 22, 15,
    39, -4, -20, 10, -18, -54, -40, -8,
    14, 5, 5, -39, -21, -23, -7, 14,
    0, 41, -13, -66, 18, -6, -34, -20,
    56, -14, -6, 37, 21, -42, 76, -40,
    33, -51, 10, 6, 3, 31, -39, 4,
    68, -1, 12, -21, -13, -23, 0, 8,
    13, 30, -10, 6, -3, 24, 10, -20,
    -22, -19, 29, 24, -47, 48, -27, -5,
    25, -5, 7, -21, -6, -29, 16, 5,
    13, -12, -33, 49, -5, -26, -7, -94,
    99, 10, 31, -13, 10, -16, 35, -90,
    -9, 85, 40, -20, 20, -47, -21, 8,
    34, 24, 16, 43, 16, -69, 56, -43,
    9, -16, -17, 1, 10, 28, -11, -26,
    8, -15, 12, 31, -44, 14, -20, 37,
    16, 21, 27, 12, 28, 9, 62, 23,
    -15, 2, 3, 3, 62, -22, -23, 74,
    -19, -30, 74, -19, -15, -36, 0, -23,
    39, 1, 31, 21, 10, 14, -32, 11,
    24, 12, -24, 42, 5, 5, -55, -7,
    -13, -42, 12, 4, 35, -36, -5, 11,
    -16, 73, -57, 29, -8, -39, 12, -4,
    -14, 8, -30, 37, 24, -44, -16, -17,
    5, -17, 9, -3, -52, -21, -54, -6,
    -98, -31, 6, -11, 54, 75, 21, 17,
    7, 57, -99, 8, 0, 5, -2, 12,
    -20, 8, 109, 11, 2, -21, 5, 31,
    23, -23, 16, -5, -7, -39, 22, 64,
    7, -51, 26, -15, 7, 24, 16, -29,
    48, 81, 13, 40, -14, -2, 20, -8,
    10, 40, 42, -14, 33, 6, 55, 29,
    -57, -16, -27, -54, -54, -1, -22, 32,
    6, -5, 48, 29, 30, -43, 41, -52,
    21, -3, 44, -34, 27, -25, 11, -13,
    -13, -5, -15, -60, 5, -12, 21, 26,
    46, -74, -6, 31, 35, 65, -11, -25,
    11, 18, -19, -61, -52, -14, 5, -61,
    0, 0, -7, -2, 15, 4, -14, -24,
    78, 34, 62, 15, -12, 41, -47, -15,
    -14, -15, 2, -49, 14, 21, 37, -45,
    76, -4, 23, -2, 38, 9, -4, 73,
    33, -15, 43, 13, -3, -11, -6, 1,
    64, 15, 15, 4, 13, -8, -41, 29,
    -17, 4, 24, 9, 44, -21, -37, 27,
    59, -37, 30, -13, 4, -20, 20, 17,
    -17, -15, 36, 38, -8, 12, 18, -6,
    -49, 31, 51, -2, -53, 14, 23, 6,
    -40, -58, -44, -21, -61, -35, -58, 18,
    19, 5, 73, 29, 45, -6, 53, -49,
    2, 3, -10, 7, 7, -10, 37, -10,
    -24, -27, -38, -19, 14, -26, -4, -32,
    15, -26, 32, 15, -70, -4, 53, 9,
    -31, 8, 19, 31, 48, -70, 45, 19,
    17, -38, 20, -28, 19, 0, -6, -1,
    -16, -60, -19, -22, -71, -24, -6, -41,
    -47, 39, 23, -21, -5, 62, 9, 33,
    12, -30, -4, 11, 1, 30, 1, -43,
    12, 47, -41, -32, -21, -64, 21, -16,
    45, -6, -19, 4, 23, -9, 11, -8,
    5, 1, -53, -76, -44, 47, 4, -57,
    -26, -14, -1, 27, -32, -32, -50, 51,
    -3, 68, -51, -28, -10, 11, 1, 23,
    -5, -124, -22, -7, -73, -56, 5, -8,
    -1, 34, -7, 9, -36, -32, -40, 5,
    -57, -5, 11, -5, 0, 2, 11, 16,
    -51, -18, -58, 3, -5, -8, -17, -9,
    -4, -10, 5, -35, 53, -17, -6, 19,
    22, 13, -8, -13, 14, -36, 27, -73,
    -13, -34, -2, 31, 6, 51, 2, 55,
    -44, 34, 53, -42, -15, -23, -5, 21,
    -41, -21, 82, -39, 4, 2, 66, 29,
    -39, -11, 15, 5, -10, 23, 42, 55,
    -68, -54, 80, -37, -9, 33, 6, -19,
    2, 46, -13, 122, -13, 8, 1, -6,
    -7, 1, 57, 30, -25, -33, -19, 29,
    5, -24, 15, -12, 73, 0, 31, -46,
    28, 10, -8, 24, 12, 54, -15, -37,
    -25, 96, 16, -14, -5, 0, 0, -5,
    -3, -7, 13, -12, -26, -7, 26, 29,
    -18, 18, 21, 6, 20, -4, 17, -15,
    -11, -5, 20, 6, -9, 4, -11, -11,
    -4, 13, 10, 22, -1, 9, 34, 16,
    -9, 3, 20, -8, 0, 21, 21, 12,
    -4, 23, 23, -14, 1, 0, -1, 0,
    24, -8, 22, 29, -14, 0, 2, -3,
    -11, -6, -13, -13, 4, 3, -11, -17,
    10, -20, -5, -1, -56, 8, -45, -26,
    16, 2, 0, 11, 18, -24, 11, 1,
    -38, 11, 45, -16, 0, -26, 18, -16,
    -2, -4, 67, -1, 8, 26, -16, 8,
    0, 14, 27, 6, 18, -24, 11, 5,
    15, -4, 14, -8, -8, 1, -13, 5,
    5, -7, -6, 42, -5, -9, -1, -10,
    -26, 1, -24, -12, 17, 10, -15, -1,
    21, 12, 10, -12, -17, -14, 16, -6,
    -28, -23, 12, -15, -16, 9, -5, 11,
    -7, 1, 2, 14, -4, 12, -10, 27,
    -42, -26, 6, -7, 40, -20, 11, 15,
    -1, -7, 23, -6, 0, -26, -2, -15,
    15, 5, 18, -6, 3, 12, 17, -23,
    -20, -4, -19, -21, -17, 10, 25, -20,
    -26, 15, 35, 30, 31, 2, -17, 13,
    -8, 7, 8, 12, -6, 30, -56, -30,
    14, -24, -12, 23, -15, 8, 10, -20,
    9, -3, -10, -11, 17, 22, 8, 13,
    6, 53, 22, 31, 4, 2, 26, -4,
    -2, -7, 0, -24, 39, 0, 12, 21,
    -16, -20, -1, 4, -14, 4, 1, 0,
    0, 32, -3, 5, 18, 20, -9, 21,
    11, -7, -1, -33, -3, -8, 13, -16,
    6, 12, 13, 4, 27, -30, -33, -2,
    9, 13, -12, 18, -14, 10, -7, 25,
    -13, 18, -14, 6, 19, 19, -25, 15,
    10, -9, -26, -1, 19, -5, -1, 3,
    0, -14, 16, -9, 18, -9, 33, -32,
    -12, -6, -56, -27, 5, 16, -15, 3,
    -1, 20, -9, -8, -2, -12, 2, -11,
    4, -28, -28, 13, -10, -15, 6, -1,
    4, 31, -20, 3, -6, 34, 3, 11,
    -28, 15, -9, -4, 17, -10, 24, -19,
    20, 5, -2, 14, 13, -3, -1, -7,
    -31, 12, 14, -11, -32, 44, -19, -13,
    8, -18, 1, 23, 7, 4, -3, 15,
    8, -13, -17, 27, -7, 7, -10, -25,
    5, 16, -10, -11, -11, -10, -8, -3,
    8, -33, 22, 5, 19, 15, 19, -5,
    -11, 5, -10, -24, 15, -9, -4, -15,
    -4, 7, -1, 24, -30, 12, 6, 9,
    12, 23, 0, -8, -5, 2, -1, 9,
    5, -1, -18, -16, -7, 7, 2, 6,
    5, 1, -9, 10, 50, -2, -18, -14,
    18, -5, -15, -5, 16, -4, 25, 16,
    24, 0, -3, -9, -9, 5, 6, -25,
    -12, 44, 11, 21, 9, -14, -40, -4,
    17, 12, -9, -14, -42, 61, 29, -7,
    2, -5, 19, -13, -3, -18, -1, 1,
    9, -5, -30, 8, 1, -1, 11, -8,
    -15, 5, 23, 1, -1, 19, -2, 9,
    -13, -3, -16, -11, 23, -30, 9, 23,
    19, -4, -16, -4, 9, 14, 10, 19,
    -29, 36, -28, -20, 3, -18, -14, -18,
    1, -13, 17, 32, 25, 15, 3, -7,
    17, 14, -8, 0, -34, 3, 30, 5,
    7, -2, 15, 7, -19, -4, 2, -7,
    -31, -15, -18, -9, -26, -1, -6, -2,
    -3, -11, -8, 29, -14, -22, -9, -6,
    -5, 5, 12, 5, -7, 31, -42, -19,
    -3, 22, 4, -33, 13, 6, -15, -6,
    2, -6, 25, 20, -15, -9, -34, 13,
    -29, 7, -14, 8, -12, -17, 0, 3,
    6, -1, 8, -39, -40, 20, -19, -12,
    51, 21, -26, 8, 3, -12, 0, -4,
    -64, -2, -21, -9, -18, -12, -5, 18,
    15, -17, -13, -9, 5, -18, 13, 24,
    -5, -13, 6, 4, -12, 18, 7, 47,
    -21, -22, -5, -18, 16, -14, 1, -20,
    29, -21, -7, 6, 5, -10, 4, -25,
    -26, -37, 3, 2, -15, -11, 18, 38,
    4, 7, 2, -14, -13, -25, 1, 16,
    -8, 20, 33, -9, 3, -7, -18, 0,
    -6, -10, 7, -4, 35, 16, 23, 10,
    12, -5, -3, -1, 11, -23, 1, -34,
    6, -10, 1, 4, 16, 23, -5, 14,
    -12, 2, 3, 18, -9, -14, 0, -4,
    -4, -12, -21, -29, 11, -31, -8, -1,
    -4, -8, -15, 8, 29, 8, 40, 24,
    -2, -19, 6, 1, -23, -17, -21, -25,
    -9, 14, -27, -7, -19, 1, 8, -8,
    -38, -11, -48, 6, -10, 1, -12, 11,
    -26, 26, 2, 4, 0, 5, 27, -19,
    -14, -4, 35, -7, -20, 0, -30, 10,
    -5, 7, -17, -43, 25, 16, -9, 6,
    2, -2, -1, -14, 4, -4, 21, -8,
    -14, 30, -5, -2, -3, 0, 3, -28,
    0, 2, -10, -12, 39, 6, -8, 23,
    31, -16, -4, 3, 7, -27, -8, 5,
    36, -2, 30, 36, -9, -9, 2, 12,
    16, -20, -9, 10, 4, 7, 4, 37,
    -2, 7, 4, 4, 25, 6, 33, -15,
    7, -4, 1, -24, 11, -3, 8, -13,
    -47, -16, -6, 0, -15, -16, -4, 11,
    13, 14, 26, 40, 0, -4, -5, 11,
    7, -10, 4, -3, 4, 28, -40, -28,
    -2, 8, -38, -30, 11, -8, 12, -32,
    -36, -13, 11, -10, -5, 21, -10, -58,
    -11, -15, 27, -30, 12, -15, -12, -4,
    -7, -13, -26, 4, -13, -14, 44, -53,
    8, 9, -2, -41, -3, -12, -12, 5,
    6, 58, 38, 11, 0, -1, 25, 1,
    -24, -29, -2, 30, 18, -20, 14, -24,
    5, 14, 0, -15, -4, 0, -10, 46,
    -2, 12, 15, -5, -2, 14, 14, -26,
    20, -15, 2, 8, 5, -24, 0, 13,
    22, -43, -11, -14, 14, -5, -11, -2,
    -28, -30, -3, -11, 48, 4, -22, 15,
    -9, 0, 24, 13, 10, -19, 0, 5,
    -16, -4, 43, 1, 1, -5, -18, -3,
    -59, -17, -5, -30, 18, -4, 18, 1,
    -17, -3, 16, -10, -29, 11, -8, -2,
    -8, -17, -17, -31, -1, -2, -29, 3,
    7, -3, 27, -13, -1, -2, 16, -14,
    -9, 20, 41, 25, -11, -3, 41, 1,
    -7, 12, -11, -11, 3, 9, 10, -17,
    -9, -2, 5, 13, -5, 20, 7, 6,
    -1, -22, -6, -5, -16, -2, 14, 8,
    12, 27, -22, -20, -5, -18, -7, 0,
    -13, -10, 12, -4, 30, -49, 5, 35,
    -39, 93, -6, -31, 22, 32, -9, 24,
    -12, -4, -7, -17, 5, -2, -11, -16,
    -8, 38, -4, 13, -30, -8, 5, 23,
    7, 18, 45, 1, 17, 13, 14, -1,
    -30, -10, 23, -2, 2, 8, -12, 21,
    -16, -26, -39, -17, -13, 17, 4, 8,
    -15, -13, -18, 1, -21, -9, -31, 10,
    -4, -3, -9, 3, 22, -17, -16, -7,
    -5, -2, -27, 22, -22, 14, 3, -3,
    -19, -28, -9, -4, 14, 11, -1, -30,
    9, -8, 25, -11, -5, -20, 5, 19,
    1, 14, 7, -4, 16, 2, 12, 16,
    1, -14, -11, 6, -6, -3, -18, 2,
    13, 2, 77, -29, -3, 1, -38, -3,
    3, -49, 58, -18, 10, -11, -3, -21,
    25, 8, 16, 3, -27, 10, -22, -27,
    16, 7, -17, 42, -39, -29, 2, 25,
    7, 0, 10, 7, -8, -5, 18, 5,
    3, -5, 8, 25, 31, -3, -3, 24,
    -5, 2, 11, 1, 32, -5, 10, -27,
    10, -25, -18, 20, -1, -10, 20, -23,
    -17, 6, 18, 33, 7, -5, 36, -10,
    -49, 18, 0, 4, 12, 20, 0, 4,
    -3, 2, 3, 7, 0, -10, -27, -5,
    37, 0, 18, 5, 3, 9, 2, -32,
    4, 14, -15, -18, 26, -10, 17, 19,
    -19, 27, -53, -12, 24, -15, 17, -9,
    3, -23, -3, -3, 42, 7, 15, -20,
    -35, 28, -35, 7, 25, -24, -14, 34,
    -16, -9, 35, -3, 39, 19, -14, 7,
    -17, 41, -15, 26, -23, 1, -10, -16,
    15, 3, 9, -14, 27, -6, -43, -4,
    7, 15, 1, 6, -7, -10, 27, -3,
    -11, 36, 4, 48, 1, 5, 18, 8,
    -27, 23, -34, 4, 15, 5, 0, 15,
    40, -11, 14, 1, -12, -2, -20, 17,
    -15, 22, -51, -43, 20, 29, 10, 10,
    1, 21, 3, 8, 8, -5, 5, 7,
    -26, -12, 12, 30, 8, -17, 10, 5,
    15, 34, -22, -5, -23, -6, 2, 37,
    -14, 12, 2, 21, -31, -2, -9, -7,
    -12, 10, -10, 38, 22, -1, 17, 3,
    -18, 9, -4, -18, -5, 35, -20, 0,
    14, -3, 11, 16, -48, 19, 13, 13,
    -27, -2, 12, -32, -4, -19, -3, 18,
    9, 16, -24, -22, 13, -10, 1, -3,
    -16, 31, 20, -12, 28, 2, 10, 0,
    -10, -3, -8, -3, 36, 2, -8, -17,
    12, -26, -14, -12, -14, -2, 30, 8,
    -13, -22, 19, 6, -1, -8, -4, -5,
    -19, 75, -15, 7, -1, -9, 5, -8,
    -3, 28, -6, 4, 15, 55, 24, 12,
    24, 9, -6, 2, 19, -1, 41, 4,
    -40, -13, -24, -58, -14, 11, -30, -12,
    -4, 23, -18, -36, 9, -20, -24, -5,
    11, -1, -13, -13, -11, -24, 2, -11,
    12, 20, -29, -3, 3, 1, -14, -21,
    79, 11, -12, -14, 12, -2, 9, -5,
    -37, 12, -19, 10, -1, 5, -4, 0,
    1, -10, -17, -3, 31, -14, 5, -39,
    7, 30, -23, -59, 25, -8, -12, 36,
    -19, 27, -15, 2, -2, -9, -7, 5,
    22, -10, 2, 51, 35, 4, 22, -15,
    3, -1, -25, 17, -32, -16, 3, 26,
    -38, -9, -3, -22, -19, 1, -19, 5,
    -17, -5, 20, -30, -25, -2, 17, -1,
    -11, 3, -19, -19, -1, -2, -10, 0,
    -3, 1, -7, 6, -15, 22, 33, -13,
    -9, -16, 4, 20, 11, -13, -4, -13,
    47, -3, 25, 36, -16, -4, 8, -2,
    19, -1, -36, 32, 18, -23, 18, 4,
    -15, 28, 9, -1, -34, 72, -7, 33,
    44, -36, -21, 29, -50, -13, 3, -4,
    -15, -13, 11, 14, 0, -2, -9, -22,
    -46, 19, -11, -10, -11, -5, 22, 34,
    -5, -8, -13, 6, -24, -17, -20, 1,
    -11, 15, -14, 13, -15, -17, -32, 3,
    -29, -15, 19, -11, 0, -14, -24, -5,
    1, -3, 6, -19, -12, -6, 38, 38,
    -14, 5, 17, -1, -21, 5, 4, -42,
    -6, -37, -2, -18, 23, 7, -21, 20,
    8, -13, -60, -14, -17, -11, -32, -3,
    -57, -10, 11, 12, 18, -14, 11, -23,
    3, 2, 8, -24, -3, -37, 40, -55,
    -12, -28, 9, 46, -3, 9, -17, -2,
    -11, -2, 14, 30, 13, -3, -16, 16,
    9, 37, 4, -12, 5, 9, 23, 20,
    18, -16, 11, -2, -15, 30, 24, 23,
    -9, 25, 30, -19, -12, -14, -26, 25,
    -65, 39, -6, -72, 1, 3, -13, -14,
    30, 53, -29, -33, 26, -1, 4, -2,
    -18, -18, 16, 21, 4, -19, 6, -2,
    14, -26, 10, -42, 15, 13, 10, -21,
    -27, -33, -6, -14, -15, 0, 18, 5,
    -30, -14, 12, -40, -2, 13, -14, 11,
    30, 6, -16, -6, -28, -20, -23, 19,
    -6, -14, -1, -16, 24, -14, -7, 10,
    -4, -25, 32, -14, 9, -24, 2, -10,
    -52, -10, 0, 16, -16, -3, 25, 2,
    -37, 21, 1, -7, -6, 16, 13, 38,
    12, -2, 21, 6, -12, 7, 7, 10,
    -2, 1, -32, -4, -1, -29, -3, 31,
    13, -7, 5, 37, 2, 14, -10, 27,
    0, -18, -7, -13, 1, 15, -19, -45,
    11, 11, -31, 2, -13, -10, -23, -10,
    14, -5, -8, 11, -9, 20, -5, 1,
    -24, -46, 17, 37, -16, -9, 3, -28,
    -9, -18, -6, 9, 13, 4, -3, 26,
    -27, 25, -8, -37, -10, 1, 67, 3,
    -3, 43, -7, -59, 13, 1, -1, 5,
    24, -19, 21, -70, -13, -10, -60, 2,
    -5, -4, 11, -16, -3, -15, 7, 12,
    -54, -30, 7, 13, 10, -12, 7, -6,
    -37, -7, 8, 24, -8, -9, 3, 13,
    -83, 12, 2, 15, 4, 26, -11, -8,
    -2, -14, 3, 5, -9, 43, 10, 47,
    4, -23, 6, -44, -18, -14, 39, -15,
    9, -8, -8, 0, 10, 5, -3, 15,
    -33, 18, -16, 13, 39, 4, -5, 23,
    -29, -14, -18, -9, 7, -4, -19, 38,
    1, -10, -32, 6, 0, -2, -28, -5,
    11, 52, 2, -2, -1, -17, -10, -23,
    -28, 23, 23, 0, 9, -6, 7, 5,
    -9, 16, -7, -26, 15, 20, -29, -14,
    -28, 17, 11, -40, 11, -14, -51, 2,
    -5, -37, -15, -13, -14, -18, -26, -3,
    16, 13, 4, 21, -25, -16, 5, -20,
    -43, 8, 23, -34, 62, -53, -11, -45,
    -47, -49, 5, 30, -22, 5, -1, -26,
    -31, -91, -58, 33, 27, -4, -60, 41,
    6, 7, -4, -76, 14, -79, -12, 3,
    16, 84, 34, -19, -85, -27, -19, -6,
    21, -69, 38, 10, -13, 26, -27, -17,
    -20, -9, -74, 42, -35, 56, 32, -4,
    19, 17, 28, -64, -49, 0, -14, -7,
    -35, 50, -19, 41, 47, -3, 43, -17,
    -6, 36, 16, 2, -25, -8, -42, 27,
    11, -78, -48, -11, 19, 21, -40, -18,
    48, 54, 17, -11, 7, -40, -1, 19,
    22, -25, 48, -14, -40, -5, 55, 13,
    8, 3, 22, -4, -19, 19, 40, -50,
    28, -17, 9, 44, 31, 30, -29, 2,
    10, 15, 25, 38, -9, -25, -17, -12,
    24, -36, 52, -57, 45, 43, -22, 10,
    -52, -33, -28, 3, 56, 40, -1, -24,
    -19, 38, 25, -51, 51, 56, 14, 32,
    -73, 45, 9, -11, -21, -5, -25, 12,
    13, -6, 34, -16, 35, 9, 42, 45,
    -35, 29, 27, -55, 12, -58, -1, -11,
    43, 41, 55, -3, 21, 4, 48, -59,
    -18, -8, -43, -14, -28, 18, -1, -27,
    16, 44, 19, -28, -14, 3, 13, 14,
    -20, 28, 7, 42, 9, -23, -12, 37,
    -32, -69, 20, -23, 15, -60, 37, -30,
    21, -52, -6, 36, 16, 42, 5, -24,
    -42, -3, -15, 14, 35, -5, 3, -72,
    18, 68, -118, -11, -8, -1, -5, -38,
    54, 9, -19, -58, 66, 9, -36, 4,
    29, -58, 3, 95, -16, 42, 0, -23,
    6, -22, 29, 3, -52, 42, 39, 17,
    -16, 14, 38, 21, 12, 9, 19, -42,
    -16, 0, 25, -27, 6, 41, 70, -15,
    -55, -22, -26, -3, -9, 12, 50, -13,
    -17, -22, -17, 15, -59, 27, 37, 42,
    35, -28, 36, 39, 25, -43, 19, -29,
    18, 30, -25, -63, 18, -86, 8, -21,
    95, -22, 60, 69, -35, 37, 49, -3,
    110, 19, 12, -4, 25, -26, -37, 47,
    11, -23, -9, 27, 70, -11, -20, -4,
    -68, -27, -46, 12, 31, -8, -25, 15,
    10, 27, -21, -50, 0, 12, 16, -40,
    41, 12, 8, 3, 59, 1, -11, -108,
    81, -9, 4, 28, -45, -11, -5, 15,
    -27, -50, -65, 18, 48, -2, -9, 23,
    19, -35, -9, 100, 61, -24, 0, 4,
    -27, -6, -6, -23, -16, 30, 8, 20,
    8, -16, 32, 15, -50, -3, 23, -9,
    -103, 28, 9, -21, -27, -26, -34, -55,
    -6, -40, -27, -24, -14, -36, 20, 14,
    4, 28, -24, -21, -30, -17, -39, -6,
    -61, -19, -25, -56, -36, -17, -102, -27,
    -22, -35, 51, -15, -55, 37, -91, -38,
    -9, 6, 78, 25, -21, 0, 4, 29,
    -15, -11, -21, -12, 53, 2, 3, -12,
    10, -26, -37, -2, 22, -8, -7, 2,
    76, -14, -49, 18, 25, -5, -12, 21,
    20, -22, 21, 12, 20, -8, 22, -23,
    19, -5, -7, 53, -109, 30, 31, 36,
    -43, 9, -31, 57, -56, -10, -7, 4,
    -19, -91, -37, -68, 27, -8, 24, 24,
    -37, -57, 28, 17, 9, -12, 14, -9,
    13, -17, -17, 45, 83, -1, -32, -90,
    31, 0, 28, 46, 26, 10, 18, 21,
    38, 4, 60, 24, -16, 12, -2, 25,
    27, 9, -4, 59, 16, -9, -24, 26,
    8, -14, 1, 0, -1, -20, 80, -17,
    -26, -25, -14, -40, 8, 30, -2, 25,
    9, 32, 92, -19, 18, 26, 19, 38,
    -19, 14, -3, -4, 15, -49, 11, -15,
    29, -13, 49, 30, -37, -13, 38, -9,
    -116, 44, 25, -69, 23, 8, 26, 30,
    69, 19, 28, 17, -27, 77, 0, 29,
    43, 84, -42, 22, 13, -20, 8, -4,
    -9, 31, -30, 21, 82, -12, 8, -34,
    9, -39, -3, 12, 42, -4, 12, 35,
    6, -20, 26, 5, 57, 5, 37, -10,
    -17, 37, -34, -59, -4, -50, -2, 7,
    -2, 11, 10, -13, 28, 5, -93, 1,
    83, 1, -19, 5, 9, 38, 21, -35,
    -63, 8, -14, -10, 3, -24, 5, -56,
    16, -40, -32, 32, 80, 0, -54, 28,
    -2, 6, 11, -102, -6, -13, -27, -19,
    -28, 6, -43, -3, -5, 33, 23, -16,
    5, 25, -49, 61, -9, 26, 57, -29,
    7, 33, 14, 48, -20, -5, -6, 29,
    42, 8, 11, -11, 2, 7, 17, -8,
    34, -40, -12, 6, -21, -3, -9, 6,
    -127, 17, -23, -26, 90, 18, 11, -8,
    29, -14, 19, 50, -50, 23, -67, 54,
    2, -4, 56, -10, 6, -39, 29, -25,
    -7, -38, -36, -30, 7, -55, 18, -9,
    -43, -5, -21, 26, -66, -22, 56, 6,
    -65, -33, 29, -85, -27, 0, -30, -10,
    45, -36, 61, 9, -15, 58, 49, -39,
    -26, 1, 65, -6, -53, 33, 70, -34,
    -17, -1, -12, -38, -22, 5, 40, -9,
    53, -32, 4, -29, 53, -99, -43, -34,
    -20, -22, -2, 1, 7, -10, -14, 5,
    -92, 12, 1, 30, -2, -40, -20, -14,
    44, 18, 9, 14, -46, -75, 7, 109,
    -12, 41, -13, 8, 16, 57, 12, 40,
    8, -38, -19, -45, 11, -31, -22, 81,
    -14, 29, 10, 61, 6, -20, 0, 10,
    43, 28, -15, -21, 11, 20, -19, -43,
    8, 19, 23, 34, -20, 24, 16, 41,
    -1, 6, 55, 6, 38, 21, 51, -10,
    30, 65, 43, 35, 34, 0, -100, -23,
    -32, -20, -40, 20, 42, 2, 28, 1,
    -20, -1, 56, -5, -72, -5, 60, 42,
    -39, -20, 10, 7, 34, 58, -1, -27,
    -16, -10, 24, -19, -22, 27, 13, 6,
    9, -65, 0, -50, -39, 11, 24, 32,
    -22, 21, 14, 24, 54, 44, -3, -5,
    59, 17, -5, 45, -103, -26, 4, 21,
    -103, 8, 29, -5, 55, -9, -35, 36,
    -22, 41, -50, 24, 34, 24, 45, 29,
    30, -23, -12, -1, 5, 18, -12, -31,
    -45, 4, 3, -80, 37, 12, -1, -17,
    58, -69, 26, 10, -13, -18, 48, -36,
    -19, 41, 21, 29, -51, -22, -13, -61,
    11, -29, -35, -3, 12, 15, -55, 25,
    -23, 37, 11, 5, 24, 41, 44, 16,
    34, -13, -46, -6, -17, 82, 61, -29,
    -10, -18, -13, 33, -1, -32, 5, -2,
    -26, -41, 30, 13, 17, -42, -83, -46,
    16, -54, 26, 38, 19, -28, -23, 26,
    -1, -5, 7, -9, 26, -11, -7, -15,
    14, 14, 1, -46, -10, 4, 0, -16,
    3, -30, 21, -19, -1, -29, -15, -5,
    -11, -13, 21, -33, -21, -9, -25, 21,
    10, -5, 1, -1, -26, 4, 12, -50,
    -20, -12, -27, 13, 2, 1, -3, -1,
    -23, 16, 4, -1, -6, -13, -9, -15,
    20, 9, 34, 6, -1, -1, 0, 38,
    6, -9, -2, -35, -2, -43, -9, 27,
    1, 16, 20, 11, -11, 19, -11, 12,
    -7, 8, -1, -6, 23, 0, 5, -18,
    20, -8, -1, -16, -24, 3, 11, -18,
    18, -7, 6, -15, -17, 1, -42, -30,
    11, 7, -10, -12, -3, -33, 29, -10,
    18, 57, 4, -21, 3, -5, 0, 3,
    21, -5, -41, 38, -15, 4, 10, -8,
    5, 15, 11, -6, -14, -15, 26, -27,
    1, -12, 4, 0, -4, -14, -5, -24,
    13, 22, 7, 20, 9, -4, 5, -2,
    13, -10, -11, 13, 12, 9, 2, 18,
    -1, -2, 9, -8, -7, 9, -10, 6,
    5, -21, 20, -12, 5, 5, 20, -15,
    -7, -41, -13, -15, 13, -2, 6, -4,
    42, -14, -4, 20, 22, -18, -31, 3,
    -8, -2, -4, -1, 6, -40, -5, -8,
    -39, 8, -14, -13, 6, -7, -23, -14,
    -13, 10, 21, 17, 18, -13, -13, 20,
    16, -14, 9, 5, 26, 0, -9, -6,
    -15, 3, -1, -19, -17, -7, 9, 11,
    36, -6, -37, 25, 14, -19, 4, -3,
    -10, 9, 3, -20, 2, -8, 15, 1,
    19, -22, 4, 0, 0, 14, 27, 23,
    -21, 0, -10, 7, -16, 2, -10, 19,
    28, 8, 15, 22, 8, 2, 9, 3,
    29, -13, 18, -19, -1, -8, -22, 0,
    1, -36, 12, -24, -34, -35, -7, -4,
    -2, 2, 7, -6, -17, 29, -9, 0,
    -6, 30, 21, 9, -8, 17, 9, -1,
    35, 36, -42, -18, -14, 10, 4, 10,
    21, -5, 10, -50, 10, -43, 16, 39,
    14, -8, -6, 11, 25, 4, -2, 35,
    0, -1, 4, -3, 9, 17, -11, 18,
    23, -5, -10, -3, -4, -7, 2, -27,
    1, -11, -23, -35, 2, -28, -45, -17,
    1, -5, 8, 10, -35, -18, 28, 10,
    13, -38, -1, -7, -26, 4, -12, -3,
    13, 0, 14, -17, 2, 0, 24, 16,
    -27, -1, -11, -18, 27, -38, 9, -6,
    -22, 15, -2, 7, 8, 45, -5, 1,
    4, 2, -8, 3, 12, 3, -18, 12,
    -3, -25, 6, 10, -4, 23, 3, -2,
    3, 23, -6, 28, 0, 16, 0, -1,
    -14, 15, 2, -1, -8, -11, 5, -16,
    3, -4, 10, 12, 0, -13, 11, -24,
    39, -26, -30, 29, -5, -19, 7, -10,
    -29, -34, -18, -1, 21, 15, 36, 25,
    -4, -6, 2, -13, 10, -5, -35, 33,
    22, 24, 0, -4, 14, 12, -12, -36,
    -26, -1, 5, -3, -14, -9, 16, 2,
    -2, 6, 22, -33, 9, 30, 26, -13,
    -9, -8, -9, -3, -5, -24, -25, -47,
    20, 16, 1, 4, 7, -4, 10, 3,
    21, -13, -16, 43, 23, -17, -1, -3,
    1, 29, -29, 17, 1, -5, -13, 3,
    9, 6, -7, -7, 2, -15, 7, -10,
    35, -4, -31, 3, -35, -12, -8, 6,
    4, -10, 0, 3, -4, 3, 11, 13,
    2, 14, -12, 57, 23, 24, 1, 11,
    -6, -9, 3, 7, 0, 0, 27, 8,
    30, -17, 16, 10, 12, -5, 24, -12,
    -28, -25, 12, -4, -8, -7, 3, 25,
    2, 11, 7, -9, 24, -19, 21, 2,
    17, 13, 0, 6, -32, 9, -6, -18,
    34, 25, -5, 27, 0, -4, -18, 12,
    13, -5, -10, -9, 11, -7, 12, -11,
    13, 14, 6, 10, 25, 26, -51, -21,
    2, 6, -4, -26, -16, 9, 12, 21,
    12, 0, 0, 14, 2, -2, -16, 28,
    13, -10, -12, -6, -4, -10, -13, 14,
    -27, -1, -8, -24, 53, 16, 13, 43,
    1, 21, -7, 2, 15, 20, 29, -3,
    -9, 0, 51, -1, 24, 9, -28, 15,
    -7, -50, 16, -17, -1, 1, 0, 1,
    -1, -4, -16, -8, -36, -6, -48, 20,
    -4, 11, -10, -7, 40, 14, -9, 0,
    12, 2, -15, -28, 22, 8, -6, -3,
    3, -8, 41, 23, -20, 20, -4, 7,
    -13, 20, 47, 1, 9, 21, 30, 3,
    -18, -10, 4, -1, 5, -16, 17, -12,
    1, 11, 25, 5, 3, 9, 18, -21,
    -5, 42, -21, -6, 19, 18, 2, -49,
    -45, 14, -29, -22, 18, 15, 35, 20,
    1, 14, -9, -7, 1, -26, 4, 2,
    -14, 5, 11, -3, 6, -19, 2, -6,
    -12, 66, 1, -13, -20, -12, 10, 5,
    7, -1, -11, 10, -1, 2, -12, -5,
    10, -3, 5, 2, 19, 69, -13, 8,
    8, 5, 19, 24, 11, -14, -8, 5,
    -22, -2, 8, -16, -2, -12, -10, 17,
    -32, -17, -12, 5, 12, -36, -14, -39,
    -4, 7, 12, -2, -12, 27, -7, 6,
    0, 4, -18, 8, 13, -4, -4, -6,
    5, 0, 5, -11, 16, -22, -6, 6,
    -35, -43, 16, 14, -30, 17, -7, 26,
    5, -34, -12, -13, 18, -16, 5, 25,
    -3, -28, -4, -38, -17, -18, 11, -4,
    14, -17, 5, 4, 11, -14, 11, 6,
    8, -7, 10, 0, 10, 1, -14, -24,
    -11, -1, 4, 1, 6, 5, 7, 26,
    2, -10, -18, 0, 0, -13, 28, -1,
    -8, 32, -1, -55, 2, 3, -1, 16,
    -15, -1, -10, 45, 3, -17, -13, 25,
    1, 10, 13, -11, 18, -16, -1, -14,
    -16, 7, -27, -5, -13, 13, 4, 1,
    -4, 31, -31, -9, -16, 0, -3, -17,
    -9, 11, 2, 49, -8, 23, -8, -7,
    -3, -20, 0, -9, -16, 5, 34, 38,
    -42, 15, 14, 0, 1, -12, 14, 20,
    -27, -3, 13, -21, -13, 22, -13, 10,
    6, -23, -7, -4, -11, -8, -27, 22,
    -7, -16, -19, -3, -2, -12, 13, -7,
    -9, -19, -19, -3, -6, 8, -7, -12,
    42, -9, -4, 4, -7, -20, 8, 4,
    -44, -47, -7, -2, 8, -16, 14, -23,
    -9, -5, -3, -7, 13, 10, 5, 10,
    3, 14, -14, -19, -26, 17, -24, 15,
    -22, 34, 2, -9, 7, 0, 7, 2,
    -21, -41, 13, -2, 12, -17, -6, -19,
    21, -76, -9, -12, -8, 8, 17, 11,
    -33, 32, 20, -14, 5, -23, 35, -66,
    9, 20, 27, -9, 2, -3, -8, 6,
    26, -14, 39, 8, 42, -3, 0, 8,
    7, -2, -2, -9, -67, -1, 6, -2,
    14, 10, 34, -2, 27, -11, 16, -12,
    23, 11, -12, -7, -2, -13, 5, 10,
    13, -27, 1, 17, -1, -21, 1, 18,
    9, 5, 4, -26, 12, -11, -23, -1,
    -18, 4, 15, 0, -8, 28, -42, 19,
    38, -25, -2, -2, 50, -2, 36, 7,
    -9, 35, -8, 5, 14, 13, -8, -17,
    11, 5, 27, -5, 10, 36, -39, -27,
    -10, -24, -24, 3, -2, -35, 19, -8,
    20, -14, 41, -34, 0, -17, -7, 23,
    10, -19, 8, -3, 15, 55, -5, -10,
    1, 2, 6, -17, -17, 44, -22, 30,
    -29, 12, -7, 7, -29, -24, 0, -28,
    -22, -22, 41, 29, 7, 27, -2, 17,
    21, 36, 11, -31, -32, 13, 45, 10,
    -18, 6, 21, -15, 5, 18, 4, 25,
    5, -16, -28, 8, -11, 4, 41, -39,
    -36, -20, 2, -6, 41, 10, 27, 6,
    34, 14, -47, 0, 62, 34, -23, 2,
    4, 9, -14, 7, 49, 13, -23, 32,
    67, 14, -11, -2, 34, -50, -64, -24,
    -23, 26, -24, -20, 7, -28, -6, -3,
    -32, -1, 15, 8, -31, 28, 49, -28,
    -7, 6, 8, -19, 46, 38, -8, 21,
    -91, 30, 9, 36, 31, -17, -1, -23,
    22, -45, 14, -15, -18, 24, 10, -12,
    13, 3, -22, -90, -76, -25, 8, -1,
    -32, -3, 2, 14, -25, -19, 17, 15,
    42, 1, 17, 26, 2, -33, -7, 5,
    -6, 8, -49, 10, -23, -9, 2, 3,
    7, -21, 33, 42, -49, -35, 51, 64,
    1, -4, 35, 21, 33, -10, 18, 1,
    -20, -7, 25, -1, 13, 22, 7, -7,
    -56, 36, -46, 24, 2, 0, -8, -9,
    -50, 26, 26, -21, -2, -6, -1, -2,
    8, -15, 7, -11, 5, 31, -18, -3,
    13, 49, 3, -5, 22, 13, 0, 6,
    -56, -20, -9, 6, 20, 4, 5, -39,
    36, 16, 27, 29, 39, 16, -28, -26,
    10, 2, 15, -4, 8, -12, -15, 44,
    -5, 26, -23, 44, -55, -23, -11, -49,
    6, 9, -17, -67, 20, -31, 70, -1,
    -34, 0, -17, 12, 9, 22, 11, -6,
    -29, 8, 2, 18, 54, 22, -10, 18,
    28, 2, -12, 31, -11, -7, -4, 29,
    -26, 44, -6, -8, -14, -1, 7, 4,
    -24, -1, -25, 7, -3, 27, -6, -55,
    -5, 0, 7, -4, -17, 36, -4, 34,
    -21, 20, 38, 36, 24, 5, 11, -30,
    -22, -28, 11, -4, -6, -2, 24, -1,
    -67, -24, -18, 27, 0, -9, -2, 22,
    7, -12, 14, 1, -30, 7, 5, 24,
    -63, 7, 18, -6, 13, 12, -5, -34,
    -2, -50, 24, -3, 1, 15, 17, -2,
    -35, 9, 8, -46, -48, 33, 18, 57,
    0, -6, -24, 16, 12, -16, -2, 60,
    -17, -4, -1, 18, 18, -6, -6, -50,
    54, 20, -1, -14, -11, -11, -1, -11,
    -22, 22, 21, 42, -6, -6, -12, -33,
    8, 6, -16, 1, 20, 5, -6, 4,
    -42, -10, -7, -27, -47, -8, -14, 20,
    -47, -16, -9, 4, -1, 6, 18, 16,
    10, 26, -22, 34, -7, 12, 3, 4,
    0, -3, 2, -12, -12, -14, 28, 43,
    14, 4, -16, 23, 13, 2, 39, 1,
    -2, -26, 3, -24, -8, 17, 14, 45,
    -11, 54, 25, -26, 31, -46, 3, 5,
    23, 4, 4, -23, 8, -2, -2, 45,
    -10, -52, -2, 12, 12, 54, -24, 21,
    -26, -31, -11, 2, -27, -21, 8, 14,
    -6, -2, -6, 14, 4, -21, 11, -14,
    15, -4, -3, -24, 62, 42, -17, -29,
    20, -47, 16, 3, -12, -39, -35, 10,
    -31, 13, -4, -20, 14, -19, -10, 2,
    -16, -35, 20, 0, 56, 6, -27, 66,
    7, 21, -1, 21, 22, -18, -61, 33,
    9, -2, -46, -4, 0, -22, -63, 10,
    -3, -1, -35, -22, 4, 14, 2, 10,
    38, 5, -15, 27, 10, 26, -4, -24,
    -1, 27, -34, -2, -2, 12, -10, 30,
    5, 0, -13, -7, 25, -28, -14, -22,
    29, -58, 16, -66, 17, 11, 7, 19,
    -11, 12, 6, 20, -17, -15, -25, -1,
    -15, -4, -3, 19, -9, 30, -25, 27,
    -7, -30, -12, -40, -4, 3, 20, -8,
    -19, 20, -5, 5, 24, 12, 28, -38,
    -48, -8, -21, -8, -21, 34, 13, 30,
    -6, 15, -8, 4, -35, 36, 5, -16,
    -28, 6, 28, -10, -16, -30, 5, -2,
    -4, 29, 45, 20, -32, -31, -10, -2,
    5, -3, -28, -49, 16, -5, 4, 40,
    12, -5, 2, -5, -10, -26, -13, 15,
    20, 0, 4, -5, -17, -31, -10, -3,
    -73, -24, 2, -6, -8, -18, 6, -8,
    20, -26, -5, -14, -7, 10, -9, -23,
    -5, 5, 10, 2, 4, 21, -6, 14,
    6, 26, -5, 7, 10, -3, -3, -18,
    -2, -23, -13, 25, 19, -5, 2, 8,
    1, -85, 0, -19, -44, 17, -46, -25,
    1, -31, -2, 10, -3, -24, -26, 31,
    9, -6, -11, -10, -1, -18, 10, 6,
    -46, -24, 6, -8, 22, -11, 25, 6,
    -5, -14, -23, -3, -16, 13, -5, -33,
    -6, 0, -1, 10, -9, -21, 21, 25,
    -9, -8, 44, -9, -12, 4, 63, 15,
    36, 68, 16, -24, 6, 10, -39, 11,
    38, -11, -31, 7, -37, 0, -1, 12,
    5, -1, 1, -8, 9, 6, 9, 14,
    -24, 0, 1, 17, -42, -30, 2, -8,
    5, -9, -13, 16, -5, 1, -1, -6,
    -9, 40, 51, -10, -24, 63, 17, -30,
    -43, 21, 11, -9, -32, -32, 29, -34,
    -3, -8, 4, 16, 20, -22, 46, 70,
    -28, -18, -15, -3, 12, 41, 0, 16,
    27, 26, -32, -11, 32, -36, 0, -2,
    6, -8, -15, -14, 5, -37, 14, -6,
    46, 14, -2, -47, 20, -3, -14, -2,
    -7, 49, -13, 36, -15, -3, -2, -3,
    18, 43, 0, -9, -5, -19, -14, -24,
    -3, 9, -6, 16, 5, -62, -46, -21,
    4, -1, -3, 37, -16, 42, -44, 41,
    14, 21, -13, 10, 4, -4, 18, 21,
    4, -14, 11, 20, -62, 86, 29, -30,
    17, -127, -12, -23, 34, 88, -32, -31,
    -24, 4, -15, 43, -29, -32, 87, -27,
    -31, 24, 10, -15, 27, 25, -21, 23,
    13, -17, 3, 12, 65, 0, -48, -33,
    -12, -4, -5, -6, 39, 21, -10, 41,
    -72, -20, -22, -11, 17, -16, 20, -14,
    -37, -12, -30, -2, -14, -6, 32, 13,
    71, -16, 13, 26, -8, 52, -48, 9,
    0, 8, 10, -37, 35, 26, -31, -13,
    10, 2, 55, -11, -22, 7, -32, 15,
    75, -55, 16, 5, 96, 14, 58, 6,
    -17, 99, -75, 53, 13, -51, 3, 56,
    -6, -17, 19, 8, 17, 38, 11, 53,
    9, -5, 106, 10, 10, -48, 48, 5,
    -45, -13, -78, 25, 35, -5, 27, 33,
    -21, 18, 16, -9, 26, 17, 22, -19,
    6, 7, 17, -23, 36, -10, -49, 2,
    17, -8, -8, -15, -47, -39, 21, 6,
    21, 68, 55, -3, 25, 0, 12, -37,
    59, -41, 7, 13, -27, -61, -30, 9,
    -24, -5, 39, -18, 18, 18, 7, 32,
    4, 13, -14, 39, -8, -14, 47, -46,
    -34, -4, -73, -14, 30, 0, 10, 38,
    46, -91, -14, -38, -20, 15, 99, -10,
    -9, -2, -21, 7, -56, 30, -9, -44,
    0, 34, 8, 14, 40, -97, -106, 1,
    -59, -70, 29, 31, -29, -3, -22, 38,
    -8, -89, -46, 127, 62, -48, 67, -26,
    2, 13, -2, 8, 18, -54, 4, 6,
    32, 3, 23, -84, 51, -9, -10, 8,
    -3, -45, -60, -60, -24, 60, 33, -39,
    9, -60, -44, -61, 32, -19, -75, -54,
    -67, -17, -1, 5, -59, 73, 36, 11,
    33, 13, -50, -32, 10, -43, -22, 7,
    -18, 23, 7, -33, -44, -12, -8, 65,
    70, -4, -14, 37, 45, -28, -80, 22,
    0, -11, 38, 16, -1, -7, -53, 5,
    -9, 67, -1, -14, 13, 30, 10, -8,
    -28, 73, 34, -17, -21, 33, -26, -24,
    -82, 4, -8, -33, 54, 24, -56, -30,
    1, -27, 15, -30, 2, 55, 31, -38,
    12, 2, 9, 62, 21, 7, -21, -16,
    72, 13, 19, -3, 40, -7, 18, -38,
    -26, -10, -1, 17, -78, -4, -9, 18,
    -1, -3, 20, -19, 3, -48, -75, 16,
    2, 75, -8, -9, -82, -38, 3, -47,
    37, -22, -35, 50, 77, -35, 127, -12,
    8, -91, 21, -26, -57, -32, -49, 37,
    -22, -9, 9, 26, 20, 6, -12, 12,
    -26, 18, -55, 57, 10, -14, 15, 38,
    22, -14, 59, 16, -44, 6, 4, -12,
    12, -61, 33, -9, 19, -42, 23, 26,
    -24, 10, 16, 2, 16, 7, 35, -52,
    -15, 5, -26, -68, 50, -30, -25, -12,
    -78, 0, -12, 32, -7, -9, 72, 8,
    -38, 45, -10, 6, 47, -17, 2, -45,
    10, -11, 16, 2, -4, 12, 11, -27,
    -34, -58, 24, 21, 9, -2, -20, -38,
    120, -82, 53, -2, -3, 93, 24, 9,
    -66, 78, -9, 0, -46, 4, -8, -1,
    5, -31, -20, 13, -11, 22, 88, 17,
    -13, -29, 19, -84, 9, -26, -28, -22,
    -22, 75, 39, -56, 31, 8, 27, -53,
    -66, -8, 20, 29, -80, -7, -9, -55,
    17, -5, -6, 12, -56, 21, 15, 4,
    -53, -11, 38, 8, -62, -14, -4, -4,
    10, -2, -14, -9, 1, 4, 1, 21,
    15, 20, -14, 52, 23, 23, 48, -9,
    -1, 4, 15, -29, 23, -40, -74, 21,
    -8, 59, -30, -40, 10, 1, 60, -22,
    34, -28, -9, -3, 1, 15, -1, 40,
    45, -74, -6, -23, -10, -20, -33, 17,
    31, -15, -2, -20, 84, -38, -8, -21,
    -38, -36, -84, 43, 12, 83, 3, 2,
    -51, -72, 48, -1, -63, 38, -1, -16,
    67, 14, -49, 65, -15, 77, 4, -9,
    13, 7, -23, -20, -58, 43, -16, -41,
    -25, 49, -9, -3, -5, -37, -49, 1,
    17, -6, 54, -14, -10, -62, -21, -8,
    37, -65, -19, 60, -96, 84, 40, -15,
    23, 22, -17, 38, -68, 18, -19, 12,
    65, 64, 45, -56, -6, -45, -62, 29,
    77, -38, -14, 49, 15, 48, 43, -1,
    42, -3, -60, 54, 56, -41, 33, 7,
    2, 50, -15, -8, -5, 41, -4, -75,
    18, 10, -61, 11, 15, -34, -17, -44,
    -29, 2, 60, 35, 56, 29, 25, 3,
    -7, 57, -28, -40, -24, -103, 84, 32,
    -12, 1, -20, 32, -14, -16, -17, -108,
    -25, 44, -2, -23, 3, 7, -9, 1,
    2, -6, 13, -26, 7, 42, 51, -88,
    -85, 14, 36, -14, 56, -31, 79, 41,
    -7, 6, -2, 8, 22, 17, -31, -27,
    -20, 20, -72, 34, -15, -53, 37, 14,
    28, -55, -88, -28, -54, -19, -14, -20,
    9, 2, -41, -57, 31, 47, 13, -34,
    26, 8, 0, -2, 0, 59, 31, 8,
    -33, 14, -52, -47, -61, -18, -7, 0,
    -3, 56, 2, -36, 19, -80, -1, 29,
    17, -83, -3, -21, 26, 86, -7, -47,
    -2, -7, 24, -5, 10, -21, -29, 9,
    1, 29, 11, -23, 4, 5, -25, -59,
    18, 16, -5, -44, -14, 11, 18, 11,
    18, -54, -42, -37, -26, -34, -55, -44,
    18, -35, -2, 12, 67, -65, -45, -8,
    31, 61, 17, 42, 2, -30, 4, 16,
    -17, -51, -3, 10, 21, -30, 112, -21,
    50, 13, 6, -56, 45, 7, -106, 45,
    -13, -6, 16, 22, -42, 20, -27, 42,
    6, -4, -3, 21, -41, 10, 80, 25,
    63, -59, 49, 56, -2, 19, -46, -27,
    10, -70, -66, -26, 69, 56, -20, -22,
    20, -17, -4, -12, -17, 4, -2, 55,
    -36, 1, -23, -18, -68, -26, -15, 28,
    -64, 4, 11, 29, -24, -7, -15, -39,
    24, -31, 49, 34, 4, -47, 74, -1,
    -49, 31, 2, -15, 65, 64, -53, 12,
    -26, 40, -14, 11, 18, -48, 28, 101,
    29, -6, 21, 22, 36, 28, -7, 26,
    15, 36, 54, 45, -93, -6, 58, -10,
    -4, -21, -19, 6, -21, 40, -51, -30,
    -1, 81, 20, 48, 40, 31, -44, -19,
    34, -62, -59, -4, 5, -56, -3, 10,
    -32, 1, 0, -15, -65, 13, 82, -13,
    -2, 18, 2, 16, 23, 73, 112, 0,
    -1, 51, 54, 21, -34, 76, -54, 20,
    -11, -29, -28, 71, 17, 11, -18, 27,
    -4, 5, 1, 47, -1, 21, -11, -10,
    7, 3, -9, -13, -13, 5, 21, -12,
    0, -10, -12, 36, 20, 5, 1, 2,
    7, -27, 0, 4, 9, -2, 0, -11,
    9, -7, 8, 10, -33, -23, -24, 4,
    27, -1, -4, -17, 16, -5, -11, 7,
    -29, 3, 2, -1, 0, -26, -26, 46,
    0, 14, -3, 6, 19, 3, -16, -10,
    -18, -10, -12, 20, -12, -6, -14, -12,
    0, 15, 1, 21, 23, 5, 1, 18,
    -32, 13, 4, -7, -13, -15, -9, 66,
    8, 26, 2, 13, 27, -13, -11, -15,
    7, -9, 11, -2, 5, -7, -10, 35,
    -18, 19, -15, -5, 5, 9, 9, 3,
    -4, -46, -13, 7, -13, -1, 7, -19,
    -26, 2, 15, 16, 11, -12, 20, 38,
    -18, -4, 20, -6, 23, 15, 9, 0,
    -11, -1, -19, 8, 8, 8, 7, -5,
    -3, 20, 0, 38, 2, -7, -3, -13,
    -6, 12, -10, 2, 29, -32, 14, 3,
    2, -9, -4, 38, 30, -9, -20, -6,
    6, -12, 5, 2, 2, 1, 14, -9,
    3, -6, -12, -28, -25, -5, 30, 15,
    26, -8, -6, -3, -18, 11, -11, 11,
    21, 15, -26, -4, 6, -27, -5, 0,
    9, -1, 5, 7, -17, 5, -10, 6,
    -7, 4, -17, 2, -16, -20, 23, 18,
    -7, -9, 2, -10, 5, 1, 0, -4,
    -18, -13, 6, -24, -28, 9, -4, 22,
    -1, 7, -10, -3, 8, 7, -11, -10,
    -15, 15, -3, 0, 58, -24, -7, 29,
    -7, 3, -1, 10, -3, -1, -10, -23,
    -28, -40, -1, 20, 3, 7, 19, 56,
    10, -1, 10, -3, -11, -3, 9, 5,
    -22, -10, 3, -21, 10, 34, 13, 19,
    -11, -13, 3, 37, -9, -2, 1, 5,
    -18, -6, -30, 3, -16, 16, 12, -6,
    3, 6, 8, -12, -1, 1, 13, 5,
    -10, -16, -32, -21, 34, 15, 26, 4,
    -15, -10, -11, -15, -29, -13, 10, 23,
    6, 4, -11, -3, 8, -13, 17, -15,
    -21, 10, 7, 5, 11, 19, -6, 8,
    2, -3, 16, -21, -21, 6, -19, 15,
    10, 0, 3, 9, -10, 8, 5, -39,
    15, 11, -3, 27, -6, 5, -20, 18,
    -30, 23, -19, 11, -8, 6, 0, -5,
    7, 9, -18, -2, -33, -13, -2, -6,
    11, 27, -15, 9, 12, -26, -4, 5,
    -54, -3, -1, 36, -6, -23, 5, -23,
    -18, -2, -4, -15, -17, -5, 3, 12,
    -26, 4, -2, 23, 0, -23, 8, 1,
    -2, 1, 3, 9, 21, -16, 3, -26,
    5, -6, 0, 12, 28, 1, -22, 10,
    -9, 4, 15, -9, -8, 9, 4, -11,
    18, 0, -8, 12, 18, -31, -11, -13,
    9, 12, -2, 7, -29, 26, 8, -3,
    -10, 50, 10, 15, 7, 21, -20, -11,
    1, -15, -25, 28, 10, -6, 1, -6,
    -27, 14, 39, -8, 16, 9, 20, -16,
    -27, -3, 2, -9, -14, -54, 9, 15,
    -31, -29, -17, 12, 10, -32, -2, -2,
    34, 0, 10, 21, -2, 3, -6, -6,
    12, 4, 13, 26, 3, 7, -27, 28,
    32, -15, 8, -1, -6, 33, -28, -31,
    -17, -1, -9, -14, -13, 2, 9, 17,
    -14, 4, -16, 5, 17, -6, -16, 4,
    5, -21, 10, -3, 39, -2, -14, 20,
    -1, 7, 7, -19, -2, -22, -17, 5,
    -13, 6, -28, -6, -15, -26, 7, -8,
    -5, -7, 12, 11, 13, 3, -8, -5,
    13, 13, -8, -28, 11, 5, -18, -1,
    1, 10, 20, -1, -37, 31, -25, -11,
    -41, 8, 3, 29, 43, -9, 18, 47,
    -11, -10, 8, 26, 12, -5, -9, 28,
    -6, 38, 1, -19, -27, 8, -3, 44,
    -2, 10, 4, -19, 7, -60, -12, -25,
    -43, 10, 25, -17, 2, -5, -3, -2,
    35, 20, 1, -26, 1, -1, -5, 7,
    8, 12, -23, 15, 41, 16, -13, 19,
    19, 7, 3, -1, 21, -34, -30, -5,
    -20, 2, -36, -17, 10, 3, 14, 26,
    -23, 1, 34, 1, 5, 12, 8, 1,
    18, -15, -26, 9, 12, -13, 15, 26,
    1, -19, -10, 3, 8, -10, -12, -2,
    40, -8, 15, -21, -15, 12, 8, -11,
    -10, 25, -20, -18, 3, 3, 14, 9,
    15, 3, -43, -6, 6, 0, 28, 13,
    5, -2, 3, -19, 18, -46, -22, 2,
    -9, 2, -40, -38, 33, 17, -3, -1,
    -3, 5, 16, -1, -13, 1, -9, -5,
    -12, -1, -17, 0, 0, 5, -23, 27,
    -8, 1, -8, 10, -11, 11, 1, 15,
    -26, -14, -5, 5, -19, -41, -19, -18,
    -3, -8, -11, -36, 1, -5, 5, -5,
    -36, 2, -11, -13, 34, -11, -31, 23,
    13, -5, 6, 7, 18, -3, -21, 12,
    6, 38, 1, 4, -8, 33, 1, 35,
    13, 21, 12, -7, 9, 5, 13, -2,
    3, -2, -3, -2, 2, 22, 4, -4,
    4, 5, -6, 12, 10, 15, 2, 3,
    4, 22, 18, -19, 11, -10, -12, -5,
    17, -4, -4, -1, -22, 5, -1, -9,
    -6, -4, 19, -6, -14, -11, -14, -7,
    -17, 17, 4, -3, 15, 6, 8, 7,
    18, 25, -19, -6, -28, 22, 22, 29,
    -3, 8, 10, 20, 1, -19, 5, 4,
    24, 17, 9, 15, 38, -31, 25, -8,
    -38, 17, -5, 12, 13, 41, -6, 0,
    -6, 6, 5, -55, -3, -22, 46, 22,
    -2, -5, 3, 9, 14, 0, -7, 1,
    14, -26, -4, -12, 3, 12, 7, 6,
    -2, -3, -26, 5, -4, -21, 2, 48,
    33, 14, 27, -6, 7, -23, 22, -1,
    -6, -6, 8, -3, 0, 21, 4, -4,
    28, 24, -9, 20, -8, 2, 8, 16,
    2, 8, 2, 3, 2, -11, -6, 1,
    -10, -6, 27, -3, 17, -3, 2, -5,
    -12, 12, 17, -31, 3, -8, 4, -8,
    19, 14, -1, 2, 4, 33, -17, -6,
    18, 16, -14, -5, -9, 1, 17, -4,
    14, 20, 1, -5, -4, 3, 3, 23,
    8, 5, -10, 4, -4, -9, -4, -19,
    20, 23, 7, -8, -18, 0, 18, -4,
    0, -10, -16, -25, -21, -6, 32, 0,
    15, -21, 33, -4, 6, 14, -6, 32,
    -6, -2, 4, 19, 8, -23, 5, -10,
    8, -29, 14, 3, 20, -34, 35, 4,
    13, -5, 2, -10, -13, -2, 14, 10,
    -52, 25, 19, -42, -32, -33, 14, -24,
    23, 15, 6, -33, 22, 2, 12, -15,
    -18, 39, 6, 5, 43, 53, 0, 27,
    -16, -3, 6, 13, -42, 25, 5, 3,
    -25, -15, 40, -20, 19, -1, -28, 8,
    27, 2, -3, 13, 21, -21, -12, -11,
    -8, 18, 10, -7, -44, 7, 7, 73,
    -9, 1, -19, -9, -21, 2, 20, -20,
    -37, -13, -32, 16, 0, 0, 28, -12,
    -15, 7, -1, 25, 26, -18, -8, 7,
    2, -9, -44, -9, -19, -26, 22, 71,
    15, 17, 35, 1, -2, -12, -21, -11,
    -25, -10, -27, -4, -13, -23, -8, -20,
    2, -12, -28, -2, 2, -6, 14, 1,
    7, -2, -5, -6, 37, 45, 5, -28,
    -19, 29, 2, 16, -6, 11, -6, -15,
    8, 49, 20, -30, 21, 17, -6, -24,
    -20, -22, -17, -31, 6, -7, 12, 1,
    29, 1, 4, 22, -1, 35, -16, 8,
    0, 16, -5, 8, -13, -14, -2, -7,
    -17, -6, -45, 7, 10, -11, 12, -15,
    -20, 5, 31, 4, -9, 8, 13, -14,
    14, 1, 9, -12, 8, 1, 10, -25,
    10, -1, 10, 29, -43, 29, -5, -1,
    12, -59, 36, 10, -41, -55, 26, 4,
    12, -20, -25, -15, 18, 9, -15, 11,
    -5, -17, 4, 13, 12, -45, 0, 30,
    -2, 7, 24, -11, 34, 13, -6, -1,
    -51, -26, 22, 1, 43, 52, -2, 8,
    -9, -4, -11, 28, 7, 2, -23, -3,
    -11, -4, 24, 11, -44, -33, -13, 58,
    7, 2, 7, 19, 6, -16, -7, -38,
    2, -4, -35, -3, -31, 27, -43, -28,
    -6, 23, -29, 1, -10, 10, 1, 4,
    -18, -17, -14, 0, 5, 33, 16, -25,
    16, 1, -4, 9, 23, -9, 11, 20,
    13, 0, 1, -11, -23, -5, -7, 4,
    1, 11, 18, 15, -13, -19, 12, -25,
    -25, -11, -11, -13, 39, 33, -34, 4,
    -21, 8, 14, 6, -13, -22, 16, 22,
    24, 6, 19, -16, 1, 18, 50, -18,
    -22, 6, 13, 14, 14, 35, -4, 7,
    -4, -1, 11, 1, -15, 6, -20, 4,
    7, 2, 6, 10, 2, -1, 1, 8,
    7, -15, 6, 3, 12, 98, 13, -29,
    -12, 50, -2, 5, 3, 5, 5, -13,
    21, -12, -30, -5, 11, -18, 2, 4,
    5, -23, -6, -12, 8, 68, -19, 36,
    24, 5, 8, 13, 8, 2, 15, 6,
    -15, 7, -2, -10, -22, -10, 11, 24,
    15, 10, 6, -17, 0, 10, 6, -28,
    -2, -1, -5, 3, 8, -6, 12, 8,
    19, -2, 48, -3, -20, 21, 6, -9,
    -6, 28, 13, -4, -7, 10, -3, -1,
    48, 6, 21, 0, -52, -24, -28, -24,
    13, -12, 6, -16, -25, -14, -23, 55,
    0, 5, 37, 21, 1, -47, -47, -6,
    -2, -4, 8, 32, 39, -4, 0, -10,
    20, 17, 1, -18, -37, -13, -36, 14,
    -16, -4, -15, -3, -25, -9, 28, -7,
    -29, 14, 2, -47, -51, -11, -4, 0,
    9, 0, -11, 4, -2, -4, -13, -8,
    3, 21, 1, 7, 19, 19, -38, 21,
    -8, 3, -14, 4, -10, -27, -35, -11,
    -16, 4, -26, 2, -8, 8, -13, -51,
    -9, 3, -9, -16, -2, 0, -32, -1,
    -15, -17, -5, -19, 64, -1, 13, 2,
    -5, 9, -2, -25, -52, -18, -21, 19,
    -37, 24, 38, 7, -11, 43, 30, -38,
    -7, 14, 31, 0, 8, -3, -10, -9,
    25, 1, -1, -2, 33, -4, -1, -10,
    -3, -21, 42, 15, -45, 10, 7, 9,
    56, 51, 23, 0, -9, -45, 2, -91,
    -13, -7, 6, 10, -8, 6, 4, 44,
    -4, -21, -9, 22, 51, 35, 4, 1,
    11, -10, -5, 23, 21, 0, -4, 2,
    12, -45, -34, -32, 17, 3, 25, 0,
    -7, 6, 9, 1, 4, 25, 16, -5,
    -12, 10, -16, -3, 36, 20, 2, -6,
    7, 9, 3, -8, 15, -15, -21, 5,
    25, 5, -31, -9, 11, 10, -5, -5,
    -27, -7, 40, 5, -1, -16, -6, 5,
    17, -10, 15, 2, -54, 3, 62, -34,
    29, 7, -13, 4, 4, -16, -40, 9,
    -6, -15, 2, -50, -6, -11, -6, 27,
    2, -12, -14, -10, 11, -26, 24, 9,
    -14, -2, 28, 16, -7, -1, -50, 11,
    7, 8, 4, 12, 27, -17, -5, -31,
    -2, -28, 44, -12, 25, -31, 63, -10,
    -8, 2, 12, -2, -2, 20, 1, 11,
    0, -14, -9, 17, 40, 6, -11, 11,
    -14, 6, 21, -17, 19, -7, 5, 48,
    -31, -13, -21, -9, 40, 43, -25, -37,
    -15, 13, 2, -14, 12, 4, 9, -13,
    0, -17, -32, 27, -5, -5, 0, 6,
    -25, 16, -28, -27, -15, 14, 1, -9,
    50, -21, -1, -1, 2, 102, -18, 14,
    -7, 38, 39, 2, 4, 1, 18, -5,
    -7, -20, 1, 14, -8, 12, 18, 3,
    -21, -8, -9, 23, -7, 23, 35, -18,
    -5, 8, -15, -21, -5, -23, -9, 8,
    3, -28, 14, 5, -30, -19, -10, -15,
    12, -20, 4, -11, -6, -6, -12, 19,
    18, -7, -4, -15, 15, 29, 6, -4,
    18, 30, -12, -22, 15, -37, 14, -20,
    7, -1, -9, -20, 8, -39, -6, -1,
    31, 20, -19, -32, 13, -37, 12, 1,
    8, 23, -8, -28, -20, 65, -33, -29,
    -23, 9, -17, 50, 4, 4, -3, 24,
    10, -14, -56, 0, 3, -9, -8, 5,
    -3, 9, 5, 14, 13, -6, 7, -31,
    -1, 9, 29, -17, 7, 3, -59, 12,
    12, -12, 22, 1, 31, 14, 37, -3,
    -26, -10, 2, -2, -3, 28, 6, -15,
    16, 14, -5, 25, -55, -4, 6, 18,
    -1, 3, 8, 17, 7, -2, 3, 2,
    -21, 41, -9, 56, 21, -11, 40, 49,
    11, 14, 10, 22, 10, -2, 4, -15,
    12, 12, 9, -35, -50, 38, -42, -15,
    8, 11, 14, 2, -15, -47, 6, -5,
    -25, -39, -17, 33, 58, -11, 11, 3,
    -1, 16, 1, -13, 12, -11, -10, -9,
    -15, -26, 15, 17, -22, -22, 37, -53,
    7, 16, -2, -7, -2, 15, 26, -7,
    -24, 65, -29, -17, 35, 32, 70, 41,
    -18, 30, 9, 5, -4, -31, 17, 10,
    11, -21, -3, 18, 20, -8, 57, -20,
    -14, -1, -15, -6, -22, -3, 7, 37,
    87, 15, -24, 39, 125, 4, 13, 42,
    26, 55, 4, -73, 15, 9, 28, -9,
    -2, -12, -32, -27, 56, 59, 14, 99,
    -19, -41, 8, -32, -6, 55, 3, 25,
    -19, -1, -25, 29, 20, -12, 21, -17,
    1, -11, 10, 14, 44, -43, 9, 4,
    -40, -23, 6, -8, -64, 30, 26, 46,
    25, -7, 25, 13, -32, 12, -10, -41,
    5, 3, -1, 12, 11, 7, 25, -28,
    -20, 49, 39, 21, 27, -62, 7, 7,
    -2, 3, -33, -14, -4, -21, -23, 82,
    1, -44, -30, 11, 32, 35, -6, -2,
    -28, -11, 22, 26, -23, 46, 16, 3,
    2, -9, -42, 3, 8, -13, -6, -15,
    24, -3, 17, -41, 13, 116, -21, -26,
    4, -5, 21, 10, 40, -20, -34, -68,
    -8, -23, -18, 2, -39, 86, 2, -24,
    -31, -40, -4, -39, 12, -42, 7, 19,
    28, -52, -5, -35, -24, 111, -10, 11,
    29, -35, 18, -18, -45, 11, 5, -6,
    9, 25, 61, -60, 10, 2, 11, 37,
    -12, -8, 45, 38, -12, 2, 40, -20,
    21, 108, 23, 23, 16, -13, -45, -41,
    9, 19, 19, -11, -24, 69, -20, -36,
    -21, 45, 22, 6, 18, 19, 13, -6,
    27, -9, -15, 0, 64, 14, -47, 38,
    -47, -26, 8, 19, 12, -58, 47, 7,
    10, 18, 22, 6, -15, -11, -19, -14,
    -13, 42, -7, 46, 13, -22, 69, 4,
    22, 0, -12, 28, 31, -3, -55, 18,
    64, 24, 2, 9, 42, -15, -35, 78,
    -34, 49, -6, 10, -21, -25, 21, 19,
    20, 13, -22, -14, 23, 36, -27, -45,
    -25, 8, -49, -6, -20, 28, -6, 8,
    -25, 4, 11, 49, 41, 40, 22, -25,
    -30, 12, -22, -54, -48, -2, -19, -2,
    -2, 14, -1, -32, -28, -19, -22, -16,
    5, 46, -30, 5, -38, -18, 3, -26,
    58, -36, 67, -25, 96, -41, -75, -24,
    15, 27, 32, -16, -32, -35, 31, 17,
    -20, 6, -20, -12, 17, 8, -39, -2,
    -28, -3, 56, 5, 20, 45, -17, 7,
    -3, -9, 10, 53, 1, -22, -17, 4,
    -22, -1, -6, 11, 20, -13, -5, 31,
    -32, -81, 0, -2, 2, 23, 14, -56,
    -7, 63, -3, 16, 35, -14, 9, -11,
    -29, -25, -35, -59, 46, 9, 37, -23,
    4, -5, 10, 0, 12, -10, 3, -12,
    12, 27, 35, -1, 10, 0, 3, 4,
    14, 8, 1, -41, 0, -8, 31, 43,
    -3, 70, -58, -7, 31, -11, -21, -97,
    -12, -10, 0, -23, -44, 0, -47, 6,
    -25, 26, -44, 7, -47, 92, -50, -31,
    27, 40, 16, -20, 12, -6, -20, -27,
    -21, 19, -27, -5, -72, 6, -91, 29,
    -5, 0, 0, -14, 127, -23, -29, -26,
    9, -36, -11, 15, -56, -38, 7, -38,
    -3, -10, 49, 26, 63, -6, 17, -6,
    1, 3, -31, 2, -30, -31, -54, -24,
    30, 20, 9, 6, 8, 0, -9, -4,
    69, 20, 16, 31, -31, 32, -43, -1,
    27, 13, -5, -54, 9, 1, -24, 11,
    -55, -21, 3, -20, -9, 15, -75, 63,
    11, -2, -24, -16, -6, 43, -58, -36,
    -36, 29, -43, 54, 41, -36, -28, 21,
    -3, 9, 6, -6, -30, -9, -27, -29,
    21, -23, -40, 37, 120, -20, 69, 4,
    10, -4, 4, 0, 1, -22, -25, -11,
    -1, -50, -7, 7, -28, -20, -65, 32,
    7, 3, 10, 15, 9, -17, -11, -15,
    -1, 15, 12, -16, 13, -3, 5, -10,
    -8, 3, -5, 3, -48, -6, -23, -17,
    -35, -5, 31, -33, -89, -7, -31, 17,
    -37, 14, 1, 16, -26, 21, 10, 61,
    23, 19, 2, 5, 40, 43, 28, 3,
    -27, 22, -6, -5, -59, 5, 29, 27,
    68, 61, -15, 17, 32, -4, -3, -52,
    -26, -5, 11, -11, 27, 30, 16, -5,
    25, -29, -42, -14, 100, -5, 13, -11,
    0, -19, -3, 13, -15, 24, 15, 21,
    -20, -22, 36, 27, 21, 34, -36, 10,
    -24, -34, 42, 16, -12, -52, -23, 48,
    5, 25, 0, 6, -102, 20, 55, -75,
    -34, -38, 13, -15, -16, 16, 37, 13,
    -35, -22, 25, 61, -9, -33, 59, -47,
    4, -31, -3, 25, 17, -59, 48, 3,
    1, 22, -17, 7, 24, -4, -71, 89,
    30, -17, 12, 7, 31, 84, -44, 16,
    8, -25, -57, 36, -28, 11, -65, -45,
    -1, -17, 2, -2, 13, 67, 1, 6,
    -18, -4, -54, -13, 78, -1, 48, 6,
    -16, 40, 12, 6, -8, 8, -40, -33,
    36, 23, 33, 0, -6, -64, 19, -28,
    -15, 37, 6, 9, 1, 37, 15, -3,
    1, 16, 7, -41, -48, -20, 57, -34,
    5, 12, 15, 0, 39, -25, 21, -17,
    -65, -39, 16, 26, -33, 39, -41, -48,
    12, 51, 41, 3, 13, 1, 19, 8,
    2, 54, 34, 43, -12, 13, -21, -28,
    51, 6, -20, 3, 32, -10, 32, -20,
    -1, -29, -28, 11, -32, 7, 2, 24,
    37, -10, 4, 2, -80, -49, 3, -21,
    -6, 8, 3, -19, -49, -19, 8, 66,
    24, 1, -15, 9, -46, 40, 5, -2,
    -34, -26, -34, -21, -5, -33, 40, 48,
    4, -19, -15, -68, 1, -28, -20, -14,
    14, 21, -40, -36, 9, -59, 8, 48,
    100, 29, -12, 21, 36, 47, -1, 32,
    13, 24, 19, 34, 0, 53, -5, 40,
    19, -26, -30, 26, -5, -15, 6, -4,
    4, 21, -50, 15, 56, 3, 45, -48,
    0, -16, -9, -38, 29, -7, 62, -61,
    -85, -25, -12, 49, -28, 25, 28, 25,
    -87, -42, -12, 8, -12, 52, 0, 8,
    27, -43, -15, -18, 18, 3, 2, -13,
    0, 9, -4, 3, -58, 39, 21, -35,
    29, -3, -22, -21, -44, -13, -18, -26,
    8, -4, -10, 43, 3, -3, 16, -26,
    4, -2, -14, -6, -43, 27, -52, -26,
    -13, -5, 4, 33, -54, -2, -11, -70,
    -11, 52, 16, -26, -28, -19, -30, -12,
    7, 9, 25, 2, 54, -29, -26, -7,
    -1, -14, 1, -40, -46, 43, 60, -101,
    -5, -5, 26, -8, -47, 9, -7, 43,
    2, 51, 10, -26, 34, -80, -1, -5,
    -43, 9, 22, -32, -2, -85, 17, 21,
    -4, 42, -46, 15, 30, -63, 14, 23,
    -1, -19, -33, 9, 10, -18, 35, 17,
    -33, -9, 5, 36, -4, 70, -63, -61,
    3, -48, 22, 20, 16, 12, 4, -13,
    12, 15, 11, -4, 11, -25, 9, 0,
    7, -8, 30, 7, 26, -8, 7, 28,
    11, -2, 13, 0, 14, 6, 22, 29,
    6, -21, -5, -7, -10, 4, 1, -13,
    2, -6, -7, -2, 12, -10, 2, 6,
    -10, 2, -6, -13, 3, 30, 35, -13,
    -21, 9, 17, -3, 56, -15, -12, -60,
    15, -20, -47, 6, 15, 1, 0, -1,
    -10, 7, 19, 75, 19, -3, -4, -5,
    -14, 1, 18, 52, -19, 2, -17, -24,
    -1, -19, 21, -9, -30, -12, -16, -32,
    -21, -19, -16, 12, 6, 15, -25, 7,
    26, -2, 4, 9, -6, -17, 7, -1,
    -12, 2, 1, 3, -46, 6, 19, -3,
    15, -9, -3, 16, 26, -7, -70, 49,
    -6, -9, 12, 25, -1, -25, 0, 25,
    3, -3, 6, -4, -14, 5, 0, -17,
    5, 7, -8, -15, -19, -9, -3, -2,
    -14, -50, -20, 1, 30, -43, -17, -20,
    10, 19, 16, -24, 16, 32, 11, -12,
    1, 12, -2, -3, 64, 42, 9, -2,
    -42, -9, -6, -4, 18, 6, -14, 12,
    -4, 16, -4, 11, -38, 40, 52, 36,
    33, -22, -12, -7, 17, 9, -2, 14,
    -19, -12, 28, -7, 12, -6, 19, 12,
    -7, 4, -4, 13, -22, -1, 23, -30,
    15, 11, -14, -7, 34, -2, -4, -1,
    -4, -1, 11, 17, 24, 11, -7, -21,
    -21, 6, 7, 16, 2, 2, -24, 14,
    -11, 1, 8, 14, 30, 6, -20, 2,
    28, -7, 18, -14, -9, 27, 64, -2,
    1, 33, -50, -19, -5, 3, -16, -11,
    3, 11, -5, -26, 5, 3, -4, 5,
    7, 2, -7, -12, 14, 15, 28, 7,
    5, 10, -9, 4, 4, 57, 66, -6,
    28, -44, 8, 29, -3, -12, -9, 0,
    16, 22, -23, 17, 16, -9, 2, 4,
    5, -22, 3, 27, -24, -48, 18, -28,
    -21, -15, -9, -4, 35, -50, -2, -9,
    0, 11, 2, -9, -21, -10, 5, 6,
    17, -8, -19, 2, 14, -4, 2, 18,
    0, 2, -12, -10, 27, -1, 0, 0,
    19, -4, 14, -25, -61, -5, 22, 20,
    2, -32, 21, -28, -22, 8, -2, -32,
    7, -7, -9, 13, -14, 15, 5, 1,
    15, -9, -29, -3, 32, -8, -7, -13,
    7, -1, 1, -21, -17, 34, 8, -43,
    1, -3, -2, -20, 0, 26, 3, 3,
    2, 13, -2, 3, 10, 67, -2, 10,
    -7, -29, 1, 8, -37, 17, -14, -9,
    -17, -4, 12, -25, -9, -7, 7, -15,
    -3, -3, 35, -16, 5, -2, -11, -9,
    -4, 4, -27, -17, 14, 1, -7, 6,
    20, 2, -15, -2, 18, -24, 4, 12,
    2, 44, 21, 12, 3, -60, -23, 35,
    8, -51, -8, -15, -14, -21, -5, 2,
    -17, -9, 4, 20, -1, 12, -13, -23,
    3, 6, 13, -20, 3, -10, -10, -22,
    -2, 15, -16, -4, 33, 40, -24, -42,
    -28, -35, 9, 13, -14, 8, -7, 7,
    -8, 16, -16, 5, -8, -10, -10, -5,
    -5, 13, 2, 1, -2, -7, 19, 9,
    -9, -9, 7, -13, -14, 11, -55, -33,
    15, -20, -3, -25, 3, -1, 7, 12,
    -26, -1, -19, 1, -9, -2, 4, -12,
    -9, -9, -19, -1, 20, -10, -21, -1,
    -12, 1, 10, -23, 1, -79, 15, 62,
    -15, 5, -34, -10, -4, -6, -15, 35,
    -2, -4, 2, -10, 41, 14, -11, 41,
    17, 10, -9, -31, 19, 3, -2, 9,
    16, 16, 18, 17, 5, -56, 43, 58,
    -17, -52, -25, -4, 4, -17, 6, 4,
    3, -3, -3, 15, 1, 19, 2, 2,
    6, -6, 6, 10, -30, 18, 1, 7,
    -4, 11, -26, 4, 59, -29, 50, -90,
    10, 11, -56, 8, 3, -15, -8, -3,
    -38, -9, 17, 35, 6, 3, 9, 15,
    8, -18, -14, 14, 18, -3, 6, -17,
    6, 21, 25, -15, -5, 1, -14, -19,
    10, -15, -20, 3, 18, 0, 3, -18,
    -14, -36, -7, -8, 22, 9, -5, 2,
    -17, 4, 14, -11, -12, 24, -11, 31,
    -12, -11, 23, 2, -6, -39, -29, -32,
    -26, -3, 3, 42, 14, -26, 18, 12,
    32, 1, -12, -31, 24, -1, 8, 6,
    -21, -3, -6, -20, 24, -48, 15, -16,
    5, 6, 16, 9, 41, 36, -48, -7,
    -12, 35, 3, 6, -4, 13, -9, -11,
    6, 10, -28, -13, -7, 0, 6, 1,
    2, 11, 5, 32, -6, 1, 34, -4,
    -1, 3, -12, -5, -40, -14, 56, -17,
    20, -44, -2, -45, 0, 18, 7, -3,
    4, -22, -22, -35, -6, -1, -9, 4,
    -1, 18, 1, -19, -15, -39, -1, -3,
    3, 22, -11, -19, 51, -83, -3, -24,
    -2, -30, 18, -24, -3, 19, -1, 10,
    -6, 17, 39, -4, 6, -5, 14, 17,
    0, 5, 13, -74, 1, -6, 9, 16,
    1, -16, 15, 8, -37, -19, -12, 1,
    -1, -16, 18, 28, 21, -2, -6, -5,
    12, 9, -28, 6, 1, 8, -13, 2,
    -5, 1, -6, -6, 40, -1, 15, 21,
    47, 37, 1, -12, -22, -57, 19, 29,
    10, 3, -20, 19, -1, 7, 19, -3,
    -10, -28, 12, -12, -24, -17, -1, -2,
    28, 6, -20, -22, -4, -8, -7, 14,
    0, -5, 10, -11, -18, 3, 36, 31,
    -7, 39, 5, 8, -8, 10, 7, 7,
    -16, 4, -1, -18, -7, -24, -9, 5,
    6, 17, -2, -15, 5, 8, 4, 40,
    -18, -13, 14, 11, -51, 25, 43, -32,
    16, 7, -1, 3, 22, -4, 2, 5,
    15, -17, -24, 10, -1, -6, -20, 9,
    1, 11, -17, 8, 9, 1, -7, 3,
    -12, 18, 20, -18, -35, -13, 5, -47,
    42, 33, -7, -3, -18, -4, -15, -28,
    -14, -6, 5, 24, -4, 4, -4, 2,
    -20, 3, 1, 1, 29, 3, 16, 18,
    15, -7, -3, -3, -24, 10, 51, 39,
    1, 26, 2, -28, -22, -13, 26, 8,
    2, 26, 9, 3, 11, 5, 7, -16,
    11, 7, 0, 5, 39, 17, -13, 12,
    7, -2, 21, 27, -72, 6, -23, -9,
    1, 3, -4, 0, -3, -8, -23, 4,
    -24, -23, 14, 10, -4, -11, -5, -2,
    -7, 7, 0, -19, 8, 11, -13, -24,
    -17, 29, 8, -14, 66, 15, -59, 7,
    2, -24, 13, -30, 31, -16, 7, -38,
    21, 11, 19, 6, 14, -18, 2, 14,
    26, 31, 12, 7, -50, 18, 21, -46,
    -39, -3, -3, 6, 27, 21, -2, 47,
    47, -32, 25, 8, -2, 8, -12, -9,
    7, -1, -21, 13, 5, -17, -6, -4,
    1, 7, -10, 13, -13, 15, -11, -20,
    -9, -12, -13, 4, 10, 43, -16, -41,
    -10, -1, 124, 2, 31, -8, -2, -2,
    -7, 5, -7, 81, 10, 6, -11, -15,
    -8, 13, 5, 61, -32, 49, 4, -51,
    -43, -19, 16, -10, -3, -21, 42, 7,
    1, -42, 68, -29, 0, 13, -16, 4,
    4, 18, 6, -1, 20, -31, 14, 1,
    31, 0, -9, -12, 8, -24, 41, -1,
    1, -4, -2, 10, -62, -18, -62, 47,
    -14, -24, -7, 16, -6, 7, 4, 5,
    10, -16, 31, -22, 3, -28, 3, -19,
    -10, 6, 9, 14, 7, 0, 7, 52,
    1, 2, -21, 38, -20, -9, 55, -26,
    55, 8, -43, -13, -22, 13, -1, 4,
    0, -6, 11, 1, 55, 14, 13, -13,
    -58, -22, 7, 13, 0, -36, -3, 34,
    -11, 21, -7, 18, -82, 61, -27, -17,
    45, 45, -3, 21, 40, -6, 15, 13,
    -32, -1, 21, 11, -3, 9, 16, 22,
    -24, 2, -15, -24, 15, 23, -21, -32,
    33, 9, -49, -40, -57, -51, -42, -31,
    -9, 2, 16, 24, -16, 13, 8, -19,
    -21, 8, -9, -1, 20, 19, -30, 26,
    -21, 20, 0, 12, 10, 1, -12, 14,
    -10, -7, 11, 35, 3, 9, 60, -19,
    17, 16, -10, -17, 1, -13, -21, -14,
    22, 17, 12, -11, 13, -7, -16, -2,
    15, 3, 6, 16, -7, 7, -40, -29,
    -17, 11, -10, -17, 8, 13, 66, 20,
    60, -37, -26, 78, -14, -4, 17, -14,
    -5, 2, 7, 18, 9, 0, 10, 15,
    -11, 3, 4, 10, 62, -21, 20, -25,
    48, 5, 12, 14, 27, -8, -8, -11,
    -74, 17, 10, 20, 17, -4, 9, 4,
    0, -2, -2, -3, -13, 3, 2, 12,
    21, 6, -27, 11, -16, 12, 4, -6,
    23, -6, -1, 21, -54, -13, -6, 40,
    -11, 11, 6, -24, -21, 27, 7, 4,
    -4, -17, 32, -21, -22, 22, 11, -8,
    6, 3, -7, 12, -3, 8, -4, 60,
    0, -8, -9, -9, -45, -20, 12, -4,
    14, 7, -12, 1, 4, -19, 2, -8,
    7, 28, 0, 1, -2, 93, -7, 21,
    11, -49, 0, 11, 10, 31, -10, 0,
    6, -29, 12, -23, 37, -50, 88, 15,
    -34, 6, -10, 31, -3, -10, 7, 4,
    10, -24, -19, -17, 13, 9, -15, -3,
    -1, -9, -2, -1, -1, -39, 71, -84,
    6, 29, 15, 15, 27, -40, -12, 6,
    -54, -10, 43, -25, 19, -12, -4, -3,
    6, 0, 1, 25, -19, 13, -17, -19,
    13, 15, 30, -15, -21, -6, -3, -22,
    -17, 6, -24, 8, 54, 31, -5, 39,
    -22, -22, 28, -6, 3, -3, -7, -1,
    -3, 21, -5, -23, 4, -8, 1, 6,
    -36, 51, 9, 3, 38, -20, 1, -14,
    -27, 11, 26, -7, 28, 11, -16, 7,
    -38, -17, -1, 37, -17, 0, -15, 2,
    -6, -14, -14, 5, 6, -11, 11, -9,
    -11, -9, -16, 5, -30, 17, -6, -55,
    7, 3, -13, -23, 7, -6, 4, 3,
    -23, 11, -41, -1, -7, 9, -16, 50,
    16, 1, 8, 15, 57, 9, -6, 48,
    26, 5, 9, -53, 13, 20, 7, 12,
    -23, -16, 4, 31, -91, -16, 11, 20,
    -41, -49, -15, -8, -15, -43, 7, 3,
    -1, -23, -1, 12, 6, 13, 2, 2,
    -1, -4, 11, 11, 29, -33, 0, -10,
    -3, 50, 0, -7, -27, 29, 20, -39,
    -45, -78, -28, -34, -3, 0, 8, 5,
    15, 4, -11, 12, 2, 19, -2, 6,
    31, -28, -20, 31, -41, 26, -11, 20,
    -4, -36, -22, 23, 0, 31, -64, 2,
    57, 20, -16, -25, 1, 4, -30, -6,
    -33, -12, 10, 2, 5, 10, -6, -18,
    -1, 23, 12, 1, 11, -36, -64, 31,
    18, 33, -26, -15, 33, 23, -49, 16,
    -27, -76, -6, -26, 26, 5, -1, 27,
    34, 32, 11, 0, 16, -15, 36, -7,
    -11, -8, -22, -12, 26, 75, -4, 21,
    -25, 6, -23, -5, 35, -30, -63, -8,
    3, -15, -64, 46, -3, 0, -14, 20,
    8, 14, -20, -23, -2, -15, 12, -10,
    -6, 10, -6, 32, -3, -25, -56, 6,
    19, -3, 17, 12, 4, -1, 57, -57,
    -28, 26, 5, -20, 14, 22, -6, -8,
    27, -6, -33, -9, 5, 12, -7, 14,
    -1, -8, -4, -39, 9, -2, -10, -21,
    -4, 5, 10, -29, 48, -78, 8, -16,
    -4, 17, 5, 14, -13, -5, -1, -7,
    -21, -24, 23, 19, -14, -10, 10, 41,
    14, -7, 0, -2, 55, -6, 5, 10,
    6, -25, -9, -9, -44, 1, -11, -37,
    1, -30, 16, 2, 16, -5, 1, 5,
    -9, 14, -22, 0, 5, 11, -1, 10,
    3, -16, -11, -12, 24, -20, 2, -24,
    19, 6, 14, 11, -28, -51, -2, 98,
    -7, 13, -32, 46, 7, 7, 23, 11,
    -3, -48, 23, -3, -10, -35, 19, 7,
    15, -3, -21, -21, -2, -12, -23, 34,
    1, -4, 2, 21, -32, -38, 76, 17,
    -12, 17, -25, -29, -18, 17, 23, 13,
    0, -5, 17, -19, -14, -34, 9, -2,
    -6, 7, 13, -21, 13, -36, 4, -5,
    13, 24, -6, -24, -51, 37, 56, -9,
    66, -36, 0, 19, -20, 14, 3, 3,
    6, 9, -16, 4, 13, -11, -21, 9,
    11, 16, -29, -9, 1, 27, 4, 2,
    29, -34, 60, 10, 3, -28, 32, -20,
    -35, 24, -1, -11, 1, -18, -21, 24,
    9, 4, -1, 6, 4, 9, -14, -6,
    11, 4, 5, -4, 15, -14, 43, 69,
    6, -14, 1, 16, 54, 18, -1, 7,
    26, -29, 13, -21, 3, 12, 34, 1,
    13, 1, -5, -5, 2, -7, -6, -3,
    13, 16, -7, -7, 39, 73, 7, -22,
    -5, -6, 0, 18, 18, -24, -91, 56,
    1, -6, 28, -25, -6, -20, 5, 12,
    11, 11, -3, 31, 5, 16, -35, -5,
    -5, 0, -5, -9, -30, 19, -26, 29,
    27, 5, -5, 19, 76, 39, -53, 42,
    -6, -6, -10, 34, 27, -36, 2, -26,
    15, -16, 29, 20, -5, -36, 3, 3,
    12, 66, -1, -12, -39, -34, -13, -5,
    -11, 6, -12, 35, -21, 24, 2, 26,
    -62, 0, -23, 29, 16, 3, -21, -5,
    -9, -6, -26, 18, -4, 10, 11, 2,
    4, -8, -5, 6, 20, -1, 55, -10,
    -50, 27, -6, 4, -39, -44, 68, -30,
    24, 14, -26, 12, 24, 35, -4, -5,
    15, -1, 6, 123, 20, -12, -17, -14,
    6, 11, 0, 61, -1, -25, -23, -49,
    55, -35, 6, -1, -22, -9, 3, 3,
    -3, 7, -26, 61, -1, -13, -24, -17,
    -30, 34, 35, -39, -9, -23, -4, 35,
    53, 35, -8, 27, 8, -36, -48, 17,
    -13, 4, -3, 1, 16, 20, -69, 93,
    -20, 31, -22, 3, 1, -17, -4, 1,
    -17, 13, 27, 16, -9, 16, 3, -25,
    4, 21, 11, 1, -14, 27, -3, -35,
    44, 85, 25, -45, 27, -52, -19, 10,
    -30, -34, 3, -8, -27, -85, 4, -47,
    -41, 31, 20, -1, 76, 53, -4, 0,
    -37, -92, -22, -12, 32, -47, 34, -37,
    -18, 28, 12, -29, -58, -13, 2, -68,
    11, -48, -26, 12, 20, -59, 24, 5,
    10, -25, -5, -16, -1, 32, 0, -2,
    12, 10, -5, -9, 31, 19, 42, 57,
    4, 26, 2, 12, 11, -6, 56, -12,
    -7, 13, 34, -72, 1, -27, 11, -42,
    -5, 54, -15, 19, 5, 12, -9, 13,
    11, -14, 25, 28, 27, 8, 52, 29,
    -27, 29, -14, 54, 6, 69, 30, -51,
    32, 20, -31, 10, 24, -16, 4, 11,
    -15, 10, -27, -22, 4, 10, -16, -62,
    -36, -3, 6, 36, -21, -32, -51, -78,
    -7, 1, -33, 20, -59, 51, 29, 26,
    -21, 13, -50, -19, -54, -25, 17, 3,
    -2, -23, -1, -24, 7, -24, -1, -5,
    -5, -19, -33, -4, -26, 17, -22, 37,
    -54, 12, -22, -22, -4, -44, 40, 40,
    81, 18, 18, 12, 37, 9, -24, 6,
    -23, 15, -5, 24, 21, 16, 8, 17,
    -13, -12, -27, 1, -45, -5, -5, 37,
    27, -42, -32, -10, -89, 34, -21, -38,
    11, 65, -10, 19, -29, 35, -25, -16,
    -23, -2, 65, -5, 8, -6, 7, -9,
    8, -24, -28, -7, -22, 42, -9, -29,
    -12, 106, 21, 13, -45, 20, 26, -16,
    -80, -42, 2, -8, -27, -102, -17, -10,
    41, 53, -5, -23, 14, 75, -5, 0,
    19, -85, 4, 11, 48, 9, -1, -31,
    -23, -7, 33, -36, 21, 15, 87, -11,
    49, 17, -67, 23, 7, -9, -18, 43,
    28, 15, 4, -26, 10, 19, -13, -19,
    -1, -8, -1, 12, -34, 46, -85, 17,
    -38, -50, 55, 0, -44, -54, -31, 12,
    10, 15, -31, -31, -4, 40, 21, -1,
    17, -13, 5, 58, 3, 36, 2, -18,
    5, 81, 20, -25, 10, 33, -18, 14,
    33, -20, -22, 23, 4, -25, 17, -15,
    4, -35, 67, 34, 30, -16, 3, 30,
    -16, 33, -17, -29, -24, -4, 6, 13,
    -9, 59, 21, -7, -8, -52, -8, -2,
    -7, 4, 13, -59, -4, 36, -30, 15,
    24, 14, -16, -41, 17, 9, -26, 30,
    -7, -30, 25, -14, -24, 7, -7, -4,
    -15, 1, -8, -12, -11, 10, 36, 36,
    30, 1, 4, -70, -20, -20, -52, 28,
    -3, 33, 9, 106, 9, 12, -8, 88,
    44, 38, 2, 17, 59, 21, 2, 58,
    32, 19, -16, -44, -2, 19, -18, 14,
    22, 17, 10, -26, -41, 2, -14, 5,
    29, -44, 48, 26, 15, -14, -8, 11,
    -53, 31, -9, 22, -26, 16, -6, -4,
    22, -28, -4, -19, -27, 44, 0, 1,
    -19, 16, -19, -2, 0, 3, 44, -51,
    66, 63, -18, -23, 69, 47, 15, -27,
    27, -3, -21, 55, 17, -11, 14, 1,
    10, 11, -4, 55, 49, -28, 45, 17,
    -15, -2, 32, 16, 49, 29, 63, -44,
    38, -23, 12, -25, -22, -7, -2, -5,
    -60, -7, 47, 32, 22, 5, -6, -19,
    -6, -11, 29, 3, 44, 23, 53, 18,
    -4, -21, 53, -63, -6, -16, 16, -46,
    -15, 86, 44, 44, -17, 1, 30, -30,
    59, -20, -11, 53, 24, -7, 3, -2,
    8, 11, -62, 2, -25, -36, 7, -26,
    -9, -41, 17, 16, -53, -2, 21, 32,
    20, 57, 44, 15, 10, 22, -22, 41,
    47, 8, -32, -23, 6, -24, 10, -10,
    0, 31, -13, 52, 31, -16, -56, -14,
    -68, -12, 25, -60, -14, 85, 23, -19,
    59, -29, -5, 18, -15, -2, 16, 8,
    23, 11, 14, -3, 20, -5, -7, 6,
    4, -17, 13, -40, -3, 17, -62, -1,
    -32, -14, 10, 48, 49, -6, -12, -26,
    8, -10, 33, -2, -7, -12, 6, -28,
    -14, 19, -34, -9, -7, -6, 1, 15,
    31, -3, -8, -49, -40, 45, -40, 13,
    24, -9, -13, 11, 107, 18, -25, -17,
    -1, 36, -6, -21, 27, -27, 12, 16,
    -22, 24, -31, 16, 19, 6, 5, 6,
    17, 3, -9, -22, 28, 34, 16, -17,
    -21, -9, -14, 4, -14, -53, 27, 10,
    -25, -38, 5, 24, -17, 3, 19, 25,
    -6, -87, 38, 5, 21, -31, 1, -12,
    44, 15, -41, 1, 34, -12, -9, 28,
    24, 4, 29, 40, -51, 28, -37, 14,
    9, -10, 2, -8, -2, 13, 45, -20,
    14, 8, 15, -29, -18, -23, 2, 8,
    18, 20, 5, -49, 14, 20, 46, -21,
    -33, -28, -14, -20, 14, -44, 42, 87,
    -20, -6, 13, -14, 26, -15, 20, -12,
    5, 10, -24, -16, 12, 5, -27, 8,
    -5, 3, -34, 13, -24, -29, 4, -2,
    10, 6, -36, 9, 4, 21, 20, 18,
    -2, -17, 31, -1, 43, -34, -15, 49,
    16, -7, 0, 5, 7, -1, 5, 1,
    11, 2, 5, 33, 30, 82, 15, 54,
    23, 65, -18, -22, -16, 22, -7, -31,
    -20, 36, 7, 18, -48, -33, 32, 8,
    29, 51, -9, 15, 5, 8, 5, 12,
    -14, 0, 37, 25, -25, -50, -3, 36,
    10, 44, 25, -26, 24, 97, 24, 8,
    -24, 14, 37, 41, -3, 34, 20, -15,
    -13, 10, 19, 21, 1, 17, -24, -2,
    -9, -4, 25, 1, -21, -2, 24, -28,
    43, 4, 22, 38, 4, -4, 4, -4,
    8, 18, -23, 13, 13, 24, 7, 11,
    10, 29, -44, 7, -2, -15, 11, 3,
    -27, -38, 16, -10, -2, 29, -10, -21,
    -7, 12, 4, -4, -22, 6, 18, -32,
    -21, 10, -20, 21, 6, -13, -11, 1,
    -8, 3, -29, 10, -10, 4, -8, 15,
    25, -37, 30, -4, -9, -15, 0, -15,
    -42, -7, -3, -8, 5, -14, 4, -10,
    18, -26, -30, 0, 34, 13, 13, 1,
    19, -36, -38, -35, -22, -44, 12, 8,
    -20, -22, -18, 3, -12, -1, 21, -4,
    9, -32, -9, -18, 8, 14, -16, -3,
    11, 6, -17, 16, 7, -33, -17, -42,
    -24, -8, 38, -13, 1, 6, 32, 3,
    4, 4, 1, 25, -13, 19, 18, 5,
    8, -28, 13, 2, -15, 8, 0, 24,
    -25, -4, -13, -6, 9, -17, 16, 12,
    6, 4, -24, 22, 9, 12, -2, -2,
    14, 15, -23, -6, 17, -9, 3, -5,
    -7, -2, -4, -6, 2, 13, -24, -5,
    -8, 15, 0, 15, 38, 13, 10, 29,
    31, 24, 12, -2, 4, -6, 27, 27,
    -18, -32, -1, -39, -2, 8, 4, -20,
    27, 20, 12, -7, -4, -6, 7, -5,
    13, -16, 11, -4, 8, -14, 12, 13,
    -21, -10, -34, -21, -24, -9, 6, -9,
    0, 7, 10, 14, 7, 9, 34, -8,
    -20, -3, -16, -6, 9, 19, -3, 14,
    18, -3, 12, 4, 23, -6, -23, 29,
    25, 4, 1, 16, -22, -11, -13, 15,
    25, 36, -69, -20, 26, -8, -10, 8,
    -9, -42, -34, 6, -3, 14, -8, 10,
    11, -10, 6, -2, 32, -7, 8, -10,
    -2, 12, -6, -13, 12, 7, -24, -22,
    -22, 4, 2, -12, -30, 15, 11, -23,
    9, -12, -31, -26, -6, -3, 3, -6,
    -7, 20, -34, -24, 11, 15, -23, 16,
    -47, -5, 34, -17, -21, 17, -14, 1,
    -21, -35, 63, 20, 1, 25, -7, 8,
    33, 12, 3, -27, 20, -29, 16, -2,
    25, -25, -13, 10, -27, -5, -12, -7,
    -2, -54, -22, 6, 18, -9, -7, -2,
    -8, -21, -30, -19, -1, 6, -13, 8,
    23, 27, 27, -14, 11, 2, 0, 15,
    10, 36, 14, 21, -17, 4, 31, 12,
    -1, 11, -23, -17, 29, 5, 6, -30,
    -19, 17, 29, -6, -31, -9, 6, -2,
    19, -11, 7, -16, -5, 0, 3, 33,
    15, -9, 1, 21, 10, 61, 9, 0,
    -25, 20, -5, 25, -22, -25, 25, 14,
    49, -13, 33, -21, -7, -6, 0, -14,
    -4, 8, 11, 7, -1, -2, 7, -25,
    7, -17, -21, 10, -3, -9, -7, 1,
    -3, 6, 17, 1, -14, -15, -13, 37,
    -13, 14, 2, -4, 19, 1, -5, 15,
    13, 3, 9, -10, -39, 0, -8, -19,
    7, 7, 3, -23, 14, -53, 3, -1,
    -30, 22, -31, 8, -1, 10, -16, -7,
    -12, -15, -10, 27, 32, -2, 0, 3,
    3, 17, -38, -7, -11, -1, -6, -13,
    17, 7, 5, 1, 16, 11, -11, 8,
    17, -17, 6, 12, -35, -14, -10, -11,
    31, 26, 12, -6, 22, -8, 5, -17,
    -10, 13, -11, 36, -12, -3, -14, -17,
    -1, -21, 30, 8, -22, -14, -8, -11,
    -4, 12, -8, -61, -26, -4, -9, -8,
    -29, 26, -11, 33, 23, 33, 12, 28,
    -6, 30, 5, -2, 8, 11, -21, 11,
    17, -15, 31, 4, 16, -8, 20, 28,
    -3, 0, 12, -15, -17, 2, 0, 3,
    15, 9, -17, 18, -13, 2, 7, -13,
    -19, 20, -11, -6, 2, -8, -12, 6,
    -13, 6, -17, 17, -19, -26, 3, 15,
    15, 14, 9, -1, -16, -9, 11, 29,
    -28, 12, 16, 21, -10, 1, 29, 9,
    -11, -14, -39, 1, 8, -29, -3, -11,
    -36, -6, 26, 25, -7, -20, -7, -4,
    7, 3, -45, 3, 3, 1, -10, 12,
    11, 53, -7, -46, -34, 20, 29, 15,
    -8, -5, -29, -34, -16, 16, 2, 15,
    -15, 24, 10, 29, -10, 10, 0, -19,
    0, 20, -20, 0, 45, -4, -13, 9,
    12, -49, 51, 38, -13, -3, 17, -1,
    31, -12, 15, -1, -1, 23, 7, -4,
    10, 7, 6, -15, 28, -4, 20, -24,
    -15, -14, -19, -31, -5, 4, 32, 11,
    8, -18, -2, 3, -1, 7, 0, -19,
    -10, 25, -31, -10, -15, -22, -1, -1,
    34, 14, 15, -10, -14, 10, -12, -40,
    -39, 11, 7, -21, -7, -26, 29, -4,
    33, -16, -38, -1, 13, -12, -12, -4,
    -11, 5, -3, 18, -19, -7, 6, -11,
    -4, -25, -22, -26, -25, 3, -11, 17,
    -35, 42, -13, 9, 17, 10, -42, -2,
    14, 15, 31, 23, -11, -3, -3, -14,
    9, 7, -24, -9, -8, 2, 7, 0,
    11, -12, 4, -15, 1, 16, -12, 27,
    28, 8, -21, 20, 4, 17, 2, -8,
    -12, -13, 4, -34, -11, 10, 1, -39,
    -20, 1, 21, 7, -27, 17, 14, -17,
    -9, 21, -17, -10, -9, -30, 0, -13,
    16, -2, -18, -7, 2, 19, -5, -31,
    -1, -1, 0, -21, 11, 2, -19, -15,
    14, 0, -14, -27, -13, -5, -7, -5,
    -10, -9, 5, 21, -62, -20, 27, 4,
    23, 15, -6, -24, -16, 24, -11, -24,
    17, 31, 35, -13, 12, 6, 11, 21,
    7, -2, 23, 10, -20, -7, 31, 14,
    14, -1, -9, 2, -13, -18, 21, -24,
    -33, 14, -24, 12, 1, 0, -30, -1,
    -18, -10, 44, 14, -4, 14, 4, -5,
    -1, 28, 10, -19, -8, -2, 0, -19,
    12, 9, -24, -22, -11, 0, -30, -11,
    20, 4, 47, -4, 23, 16, -4, 31,
    -11, -20, -21, 17, -6, -38, -13, 14,
    -18, 9, -4, 2, -10, 2, 5, -12,
    25, -13, -2, 7, -6, 6, 0, 2,
    11, -14, 0, -6, -11, -18, 20, 17,
    10, -9, -20, -9, -13, -3, 10, -4,
    26, 3, 8, 13, 10, -3, 2, -29,
    31, 25, -3, 21, -10, 18, -9, -1,
    31, 43, -10, -3, -21, 0, -13, -22,
    9, 14, -1, 27, 10, -13, -10, 2,
    5, -7, -10, -40, -11, 8, 4, 7,
    -2, -10, -1, 9, -9, 1, 16, 11,
    -29, -38, 5, -11, 1, -45, 14, 9,
    30, 30, 51, 13, -12, 35, -11, 0,
    -39, 64, -11, -30, -13, -19, -2, -12,
    43, -27, 2, 3, -8, 39, 2, 9,
    7, 37, -6, 18, 3, -10, -19, -27,
    68, -61, 30, -15, 18, -42, -6, 2,
    -21, 1, 6, -21, -9, 8, 32, -45,
    -26, 7, -14, 12, 1, 11, -1, 7,
    -29, 12, -56, 19, 19, 16, 24, -22,
    16, 8, -5, -25, -29, 17, -2, 16,
    7, -10, 26, -27, 1, -31, -4, -15,
    15, 22, -33, -16, 35, 22, -24, 14,
    4, -64, -26, -40, 35, -28, 44, 9,
    26, -20, 50, 16, -12, 26, -23, 10,
    -15, -10, -10, -1, 5, 4, -51, -6,
    14, 18, 8, 26, -9, -13, -23, -37,
    -31, -14, 12, -18, -21, -12, 26, -29,
    -23, 32, -46, 4, 3, -16, -17, 5,
    32, -4, -10, 33, -19, -8, 13, 9,
    -12, -18, 5, 0, -19, 1, 4, -13,
    4, -6, -2, -6, 14, -32, 9, -10,
    43, -6, -38, -43, -16, 4, -7, -2,
    -8, 1, 28, -5, -12, 12, -2, -15,
    9, -9, -14, -4, 22, 9, 4, 5,
    43, 20, 15, -51, 13, -38, 53, 33,
    22, 23, 9, -11, 51, 11, -20, 17,
    26, 13, -7, -21, 8, -11, 24, -6,
    9, -8, -4, 18, 28, -7, 35, -27,
    6, 28, 13, -18, -8, 18, -30, -9,
    7, -25, -17, -25, -5, -14, 4, -36,
    15, 9, -26, 14, 11, 27, 15, 25,
    -7, -10, 2, -11, 5, -28, -1, 17,
    6, 11, 6, 5, 51, -6, -8, 41,
    10, 22, -47, -15, -24, -7, -7, -3,
    -43, 6, -33, -14, 38, 26, -4, 8,
    -9, -22, 12, 22, 37, 0, -1, 0,
    -37, 49, -16, -29, -32, 0, 1, -22,
    -19, 41, -29, -12, -37, -3, 12, 13,
    -6, -19, -24, 4, -28, -9, 1, 23,
    30, 30, 14, -5, 2, 5, -9, 14,
    -41, 29, 33, -21, -27, 5, 1, -13,
    -32, -75, 53, 8, 9, -3, -5, 12,
    45, -3, -30, 19, 41, -14, 6, -6,
    -6, 8, -24, -10, 14, -12, 3, -8,
    -22, -9, -18, 17, -13, -2, -2, 17,
    -15, -19, 13, -25, -26, 14, -6, -7,
    -6, -6, 31, 16, 3, 30, 8, 21,
    6, -11, 3, 5, -15, 15, 18, -18,
    -51, -69, 4, 73, -31, 32, 13, -4,
    59, -35, 21, 16, -42, 5, 2, -5,
    9, 8, 4, -21, -29, -1, -1, 50,
    -9, -9, 2, 8, -7, 0, 12, 12,
    -30, 7, 7, -7, -3, 18, 28, 2,
    34, -7, 17, -40, -5, 4, -12, -10,
    10, -21, -16, -25, 6, -4, 12, -50,
    -16, -2, -26, 21, 2, 10, 11, 13,
    -53, -21, 43, -6, 15, 12, 22, -39,
    -64, -7, 35, -41, 27, -2, 26, 6,
    -20, 11, -32, 1, -62, 4, 13, -10,
    1, 14, 3, 11, 11, -4, -3, 8,
    70, -2, -50, -29, 14, -44, -2, 3,
    -13, -19, 17, 19, -33, 26, -5, 20,
    -35, 43, -26, -27, 1, -4, -15, -8,
    11, -37, 7, 7, -6, 15, -25, -10,
    -31, -1, 28, -30, 6, 4, -37, -39,
    4, 29, 12, -31, -12, 0, -13, -17,
    -54, 22, -19, -14, -60, 3, -17, -13,
    17, -5, 31, 15, -8, 0, -19, -5,
    28, 51, -12, 1, -34, -1, -18, -15,
    -3, 28, -38, 16, 1, 13, 2, 18,
    -2, 25, -30, 9, 9, -1, -34, -2,
    11, -16, 5, 1, 7, -4, 24, 61,
    -53, -6, 59, 11, -2, -13, -45, -42,
    41, 47, -20, 17, -10, 6, 20, -16,
    -86, -43, 26, -43, -6, -6, -39, -1,
    5, -11, -4, 7, 19, 1, 14, 29,
    26, -60, -2, -49, -44, -15, 18, 20,
    -11, -11, 13, 24, 9, 6, -4, 14,
    11, 62, 28, -11, 14, -45, 15, 1,
    -26, -27, -12, 24, -2, -6, -4, -8,
    -5, -39, -18, -5, -47, 33, 35, 9,
    -14, -25, -7, -40, 13, 12, 3, 28,
    -58, -21, -19, 10, -9, -5, -4, 15,
    9, 22, 0, -6, -4, 10, -4, -8,
    5, 47, -75, -54, -12, -5, 11, -4,
    38, -9, -36, 29, -29, -4, -7, -16,
    -7, -22, 9, 14, 14, 41, 26, -26,
    8, 12, 0, 24, 28, -8, 35, -7,
    -27, 23, -28, -7, 9, 7, 28, -54,
    4, 13, 41, -31, 4, -14, 11, -8,
    46, 31, 3, 6, -3, -37, -19, 7,
    6, 4, -43, 7, 10, 10, 20, -6,
    -51, 51, -41, -36, -6, 9, -68, -20,
    19, -2, -32, -13, -14, 8, -45, 28,
    1, 11, 54, 21, -33, -14, 43, 13,
    -11, -20, -5, -8, 20, -4, -7, 8,
    -36, 25, -52, -40, -9, 26, 36, -7,
    6, 58, -24, -6, -4, 21, 23, 26,
    -18, 46, -12, -23, -3, 5, 10, 8,
    12, -15, -4, 15, -14, 22, -1, 2,
    61, -8, -51, -5, -17, 32, -9, -19,
    -19, -40, 28, -43, -11, -7, 9, -10,
    -4, -26, -10, -15, -20, 24, 10, -14,
    17, 14, -6, -17, -4, 0, -3, 0,
    11, 15, -9, 11, -31, 4, -2, -11,
    9, 26, -4, 1, 27, -3, -19, 9,
    4, -47, -29, -30, 14, -5, -12, -45,
    13, 17, 2, 6, -18, -7, 12, -6,
    36, 63, 11, -5, -1, 7, 5, 36,
    31, 17, 0, -28, 16, -6, -7, 16,
    -6, -3, -66, -10, -3, -5, 31, -1,
    7, 0, -12, -30, -5, -25, -22, -34,
    -14, 33, 1, 17, 0, 21, -5, 1,
    -5, -1, -5, 49, -4, 3, -7, -15,
    -40, 48, 14, -7, -8, 10, 4, -16,
    0, -18, -13, -6, -2, -25, -7, -2,
    -9, 61, 32, -32, -51, 28, 6, -49,
    18, 48, -7, 28, 8, -9, -10, 17,
    15, -19, 31, -17, 10, -2, 36, -26,
    -10, -1, -1, -2, -36, 2, 8, 13,
    -2, 23, 11, -4, -17, -11, -18, -18,
    44, 60, -4, 44, -8, 11, 1, 38,
    37, 8, 31, 13, 26, -18, -1, -66,
    13, -2, 5, -7, -15, 0, 22, -3,
    5, 35, 8, -1, 10, -4, 28, 7,
    28, 5, 2, 21, -14, -13, 16, -29,
    -4, 11, 54, -52, -14, 40, 22, 37,
    14, -26, -24, 2, -7, -19, 14, 2,
    -8, -96, -43, -31, -27, -30, 27, 17,
    18, 30, -47, -35, -3, 4, -10, 6,
    23, -69, -17, 28, -32, -21, 22, -32,
    -67, -62, 15, -43, 92, -37, 6, -33,
    49, 24, -28, -57, -20, -109, 2, -18,
    -15, -33, 9, 35, 1, -16, 5, 11,
    -37, 17, -33, 15, -23, -7, 76, -64,
    25, 26, 51, -18, 3, 2, 8, -19,
    -7, 0, -44, -26, 0, 74, 10, 42,
    20, 52, 1, -3, -61, 40, 52, 57,
    -15, 74, 39, -5, -2, -9, 4, -11,
    -32, 0, 21, -4, 66, -38, 4, 26,
    50, -26, -8, -29, -3, 28, -23, 24,
    60, -17, 0, 26, -36, 6, -3, 14,
    -8, 32, -37, -5, 3, -9, -40, -4,
    -30, 16, 15, 16, -18, 70, 15, 41,
    -15, 43, 22, 31, -18, 8, -28, -49,
    9, -51, -15, 32, 1, 12, -20, -15,
    -34, -62, -25, -24, -49, -27, 35, 14,
    16, 5, -5, 7, -28, 12, 32, -20,
    33, 8, -9, 22, -2, -27, 4, 26,
    -11, 27, -40, 43, -79, 56, -9, 17,
    43, -4, -17, 31, -15, 11, -9, -20,
    -2, -15, -25, 1, -1, -57, -5, -47,
    33, -12, 52, -43, 16, -52, 29, -49,
    62, 67, 48, -16, 47, 0, -67, 31,
    7, 17, 27, -18, -1, -13, 51, 1,
    12, 25, 9, 23, 97, 23, 49, -32,
    31, 37, 70, -47, 8, 49, 25, -16,
    23, 28, 12, -33, -36, -22, 2, 26,
    29, -9, 32, -26, 23, 62, 32, 50,
    -23, -1, -18, -5, -40, -9, 28, -6,
    -6, -4, 13, 9, -50, -16, 17, -5,
    22, 15, 7, -17, -9, 17, -18, -29,
    22, -32, 21, -10, 66, 37, -41, 4,
    -5, 11, 21, -10, 13, -23, -10, -57,
    13, 6, -38, 47, -20, -26, 32, -31,
    14, 19, -28, 60, -13, -53, 1, 28,
    20, 14, 32, 10, 4, -19, -22, 34,
    -17, 51, 16, -2, -15, 8, 22, 6,
    -29, 44, -13, 5, 14, -27, 19, 20,
    -86, -41, 19, -23, -6, 7, -9, 13,
    -12, -14, 11, -5, 75, 5, 2, 3,
    2, 21, 23, 14, 59, -12, 17, -17,
    -102, 30, -39, -23, 42, 8, 34, 35,
    -37, -6, 7, -19, -27, 2, -16, -10,
    -15, 9, -26, -4, 4, 49, 14, 42,
    -12, 39, 6, 36, 19, -17, -34, 1,
    -10, -30, -17, 78, -10, -57, 26, 3,
    -61, -10, 6, 11, -100, -29, 20, 7,
    -6, 1, -3, 46, -26, -20, -26, 78,
    -23, 22, -12, 16, -2, -97, -9, 0,
    -9, 24, -3, 21, -63, 25, 5, 8,
    -10, 95, -10, -44, 46, 17, -7, 8,
    -1, 33, 36, -3, -1, -2, 17, -76,
    -5, -9, 38, 37, -27, 3, 24, 27,
    -97, 36, 48, -36, 52, 0, 3, 49,
    -53, 1, -11, 5, 35, 27, 5, 32,
    -43, 7, 27, -25, -90, 5, 11, -10,
    -17, -19, 26, 15, 20, 29, -8, 39,
    23, -41, -38, 9, -51, 29, 18, 37,
    -26, 2, 15, 19, 9, 47, -1, 27,
    -29, -31, 47, 19, 11, -9, -14, -24,
    -57, -39, 34, -12, 27, -54, -17, -47,
    -25, 13, 45, 24, 53, -35, 1, -9,
    35, -2, 29, 12, 29, -12, -54, -37,
    82, 15, 8, 38, -94, -6, -25, -27,
    -13, -9, 25, 29, -26, -8, -19, 0,
    41, 65, -8, 63, 56, 9, 2, -26,
    38, 29, -7, -12, -9, 0, 39, -12,
    -29, -8, 13, 9, 2, -22, -44, -8,
    -31, -6, 17, -25, 29, 17, -12, 60,
    -46, 40, 5, 38, -12, 8, 12, -1,
    94, 34, 19, 66, 0, 17, -8, -26,
    73, 49, 34, -27, -4, -25, -45, 29,
    14, -39, -27, -31, -5, 31, 17, -22,
    27, -75, 30, -27, 11, 78, 14, 19,
    -55, -57, 13, 15, 8, 61, -64, -5,
    -27, -69, -33, 12, 16, -66, 8, 19,
    -49, -18, -50, 38, -101, -8, 43, 10,
    -6, -5, 32, 15, 26, -40, -67, -12,
    -7, 7, 85, -40, 31, 83, 8, 40,
    4, 27, -2, 9, -12, -17, 7, 45,
    -5, -24, -45, -9, 48, -43, -5, 6,
    14, 25, -39, -36, -13, 52, 46, -7,
    -8, -10, -62, 3, -14, -62, 11, 2,
    -23, -1, 25, 13, 22, 85, 31, -60,
    6, -15, -13, 11, -50, 81, -32, 22,
    -16, 14, 26, -3, -15, -51, -103, 28,
    61, -41, 38, -21, 3, 4, -15, -11,
    21, 8, -22, 57, -9, -41, -46, 9,
    -16, -11, -26, 4, -2, 19, 2, 127,
    -1, 49, 52, -49, 53, 29, 76, -24,
    -10, -3, 68, -35, -14, 58, -17, -28,
    -26, 18, -93, -18, -74, -24, 93, 28,
    -27, 16, 11, -4, 30, 6, -84, 5,
    -6, 26, 36, -38, -58, 46, -3, 34,
    -9, 31, 17, 24, -27, 73, 8, 10,
    43, -17, -20, 15, -29, -17, 17, 2,
    34, -12, 11, 15, 9, -28, -29, -64,
    -10, 99, -39, 35, -12, -5, 21, -1,
    -72, -38, 6, 65, -72, -50, -30, 45,
    40, -20, -13, -12, -44, 21, 42, -6,
    20, -4, 3, 18, -21, 1, 19, 12,
    -31, 45, -26, 17, 1, -46, -13, 21,
    -32, 45, 27, 11, -38, -63, 30, 1,
    -29, 23, -7, 15, 13, -4, -5, -90,
    5, 66, 18, 2, 21, 1, 16, -15,
    29, 70, 5, -18, 53, 18, 16, -56,
    21, -31, -29, 11, 0, 13, -12, -19,
    -21, -11, 15, 18, -5, 0, 84, 3,
    -10, 18, -39, -49, 5, 25, 40, 33,
    34, 11, -28, 53, -27, 23, -33, -52,
    -15, 12, -11, -48, -4, 43, 53, -37,
    53, -72, 27, 19, -15, 3, 4, -4,
    16, 4, -2, 16, -17, -51, 7, -20,
    46, 14, 45, -23, 7, -50, 12, -42,
    -37, -13, -14, 9, -39, -76, -13, 46,
    -2, 59, -11, 15, 12, -2, 28, -34,
    -9, 31, 4, 1, -62, 40, -14, 48,
    1, 18, -20, -2, 40, 1, -11, 10,
    0, 32, -22, 34, 3, 37, -97, 30,
    -32, 4, 4, -34, 42, -21, -15, -98,
    22, -38, -19, -28, 5, -65, -5, 42,
    47, -17, 20, 9, -20, 6, -44, -23,
    50, 55, -4, 62, 71, -87, 42, 50,
    9, -89, -114, 89, -28, 56, 63, 66,
    13, 35, 14, 11, 7, 31, -4, -17,
    12, -47, 74, 1, 31, 0, -55, -8,
    5, 46, 70, 12, 20, 51, 79, -37,
    -21, -5, -4, -36, -22, -40, -3, -7,
    -14, -4, 2, -26, 0, -8, -11, -1,
    39, -8, 2, 16, 22, 9, -16, -22,
    7, -31, -4, 35, -22, -4, -4, 9,
    26, 4, -29, 15, 40, 4, -1, -26,
    -39, -22, -14, -9, -3, -4, -8, 17,
    -33, -6, -19, -13, -26, -12, 7, -9,
    35, -22, -28, 0, 4, -7, -3, -3,
    55, -11, 34, 32, 11, -6, 33, 18,
    15, -13, -10, 4, -9, -16, 5, 4,
    1, -20, 29, 42, 7, 11, -26, 21,
    -31, -23, -10, -7, -10, -2, -12, 15,
    -22, -5, 53, -2, -9, -11, 9, -4,
    5, 19, -2, 7, -11, 6, -5, 1,
    -30, -6, 6, -38, 29, 10, -17, -15,
    13, -21, 8, 23, -3, -15, 11, -31,
    21, -39, 25, -22, 18, 12, -22, 30,
    23, 16, -12, -12, 4, 7, -19, 9,
    -20, 23, 20, -23, -10, 25, -29, 14,
    -18, 5, -29, -18, -3, 7, -2, 4,
    -32, -8, -14, -7, -4, 1, -16, -24,
    -3, -34, 17, -24, 8, 9, 4, -11,
    6, -43, -24, 32, 14, 29, -2, -4,
    -12, -51, 6, -20, 1, 11, 6, 1,
    -11, -44, 63, 49, 4, 45, -35, 16,
    -19, 17, 10, 8, 8, -13, 1, 17,
    10, -10, 14, -23, -5, 23, 34, -14,
    30, 0, -32, 16, 18, -2, -13, 9,
    0, -15, 22, 12, 13, -11, -2, -29,
    31, 9, -1, -18, -14, 6, -22, 5,
    7, 9, 42, 17, -7, 3, 1, -16,
    9, 5, -23, -27, -22, 2, -2, -5,
    64, 44, 36, -29, 29, -30, 46, 1,
    12, 17, 0, -21, 11, -1, 6, 5,
    -6, 1, 1, 20, 2, 25, 44, 4,
    0, 12, 22, -41, 6, 3, 8, 2,
    -3, 31, 23, 25, 16, -5, 15, -14,
    4, 14, 7, 13, 10, -11, -1, -3,
    -14, 20, -27, -29, 12, 7, 3, -31,
    15, -11, 19, 10, 2, 11, -21, -1,
    -21, -13, -14, 5, 68, 21, 36, 24,
    -5, -10, -12, -10, -12, -2, -5, -8,
    -3, -44, 28, 14, -24, -13, 3, 9,
    -1, 6, 6, 3, -17, 4, -10, 28,
    3, -3, 15, -14, 2, -60, -3, -2,
    -8, -13, 6, -18, 9, -2, -6, -14,
    16, 11, -2, 28, 9, -1, -5, 17,
    8, -17, -18, 2, 2, 3, -16, 2,
    34, -8, 16, -8, -39, -13, -2, -13,
    -3, -5, 0, -4, 13, -9, 6, -2,
    52, -37, 3, -24, 6, 3, -3, -14,
    -3, -5, 8, -4, -7, -5, 3, -1,
    -39, -13, 32, -32, -38, -9, 2, 1,
    -4, 10, 7, 2, -2, -4, -5, -10,
    34, -15, -5, 8, 23, -22, 5, 47,
    -39, 27, 7, -9, 13, 3, -7, -9,
    -1, -33, -1, 17, 18, -9, 61, 51,
    -17, -4, -2, 9, -1, 9, 4, -10,
    -22, -50, 25, -31, -12, 3, 8, 14,
    5, 23, 10, 47, -1, 1, -9, 3,
    15, -1, -39, -29, -15, 13, 2, 12,
    17, 27, -16, -16, 0, 3, 7, -2,
    -24, -17, -14, -10, 21, -3, 0, 21,
    1, 20, -1, -7, -1, -7, 2, 5,
    33, -25, -33, -46, -2, -2, -11, -9,
    20, 3, -5, 12, 1, 0, 14, -16,
    -12, -3, 42, 43, -2, 12, 12, 60,
    5, -10, -16, 1, 10, -13, 10, -10,
    -3, -1, -5, -19, 12, 35, 25, 21,
    -7, -8, -2, 12, 4, -3, 9, -11,
    29, 25, -5, 39, 12, -1, -7, 20,
    15, 24, 4, 25, 15, 1, -10, 24,
    -16, 2, 27, 0, 12, -14, -7, 2,
    2, -15, -13, -20, -18, 8, 22, -9,
    -31, -1, -26, -15, 6, -28, -13, -59,
    -25, 29, 1, 19, -5, 11, -10, -2,
    33, -40, -16, 88, 73, 20, -56, 5,
    4, 22, -4, 13, 0, 17, 9, -19,
    -18, 13, 28, 43, 10, 32, -5, -9,
    -12, 26, -2, -18, 3, 2, 6, 26,
    -26, -37, 31, -15, 8, 41, 42, 6,
    -3, 22, 21, -36, 11, -5, -6, -2,
    60, -22, 12, 17, 14, -7, -46, 12,
    -7, 10, 26, 6, 11, 14, 1, -1,
    -16, 21, 16, 6, -12, -15, -17, 24,
    -18, -17, 9, -6, 1, -18, -9, -3,
    -5, 5, -53, 45, 30, -20, -46, 11,
    9, -16, -9, 18, -18, -1, -4, 8,
    26, -9, -26, 10, -34, -37, -1, 17,
    14, -5, 10, 8, -1, 17, -7, -5,
    14, -41, 12, 9, 8, -26, -16, -20,
    22, -6, -18, 25, -12, 16, -3, -7,
    19, -14, -48, -14, 4, -12, 36, 62,
    4, 6, -16, -18, -3, 10, -17, -12,
    22, 10, -26, -15, 7, -8, -10, 5,
    -18, 7, 15, 14, 0, -4, -4, 4,
    1, 14, 7, 0, 4, 17, -21, -15,
    -14, 0, -1, 10, -18, -12, -6, -1,
    10, -23, -3, 24, -26, -19, -3, -10,
    -18, -11, 8, -8, 2, -1, -14, 8,
    -28, -2, -36, 25, 17, 45, 18, 22,
    6, -5, 10, -21, -2, -16, 0, 12,
    -42, -11, 9, 28, 21, 33, 15, 47,
    5, -10, 3, 26, -9, 8, -11, -7,
    -17, -47, -3, 55, -41, -14, 18, -37,
    21, 2, 21, -13, 5, -2, 2, 14,
    -22, 11, -26, 2, -30, -20, 0, 24,
    39, 5, 12, -10, -3, 3, 3, 4,
    29, 21, 31, -2, -2, -13, -19, -9,
    8, -10, 17, 21, 15, -11, 23, 3,
    21, 37, -23, 32, 12, -28, 35, -31,
    11, 14, -15, -8, -9, -22, -6, 22,
    -14, -3, -63, -27, -44, 52, 9, 5,
    -4, 2, -10, -6, 9, 0, 8, 22,
    -13, -7, -3, -21, -21, -19, -6, 19,
    -9, -12, 8, 5, -11, 0, -1, 0,
    -1, 18, -10, 2, 30, 23, 18, 1,
    -13, -1, 1, -15, 3, 5, 0, -2,
    -12, -27, -24, -1, 17, -15, -19, 9,
    6, 37, 11, 0, -2, 6, 1, 4,
    7, 22, -20, -9, 4, -26, 1, -8,
    1, -6, 3, -9, 7, -2, -7, -8,
    -4, -6, 2, -9, 17, -3, 36, 14,
    18, 28, -8, -4, -15, -5, -8, -2,
    28, -14, -13, 14, -9, -4, 12, -15,
    1, 18, -3, 17, -4, -26, 9, 8,
    -12, -5, -33, 9, -13, 0, -25, 15,
    -7, -6, 17, -51, 2, -9, -7, 8,
    -23, -4, 6, 4, -10, 31, -15, -5,
    -12, 13, 3, -13, 15, 2, -18, 16,
    17, 3, 16, 8, 40, -30, 7, 6,
    -30, -5, 22, 0, -3, -9, 0, 18,
    11, 8, -24, 14, 15, -1, -16, 0,
    -41, 7, 42, 3, -4, -9, -10, 36,
    9, -36, -13, -26, -21, -9, -19, -14,
    5, -8, -8, -35, -13, 3, -6, -12,
    19, -9, 47, 39, 30, 2, 0, 5,
    -29, -25, -28, 5, 1, -14, 9, 2,
    -40, 48, 51, 23, 17, 22, 7, -14,
    2, 8, -4, -11, -15, -13, 17, 12,
    29, -19, 52, 19, -4, 3, 21, 7,
    -1, -23, -2, -8, -4, 15, -4, 10,
    8, -50, 32, -27, 13, -22, -38, 25,
    -19, -32, -21, 55, 2, -14, 2, -40,
    18, -7, -2, -24, 2, -27, -11, -9,
    -33, 3, 21, -38, -3, -4, -11, 17,
    9, -53, 29, -6, -34, 16, -32, -73,
    -29, -4, -19, -17, 1, -4, -4, -19,
    -56, -35, -25, -21, -9, -4, -9, 11,
    -18, -19, -10, 17, 5, 1, 35, -7,
    -25, -7, 16, -40, 42, 42, -15, -4,
    5, -28, -23, 27, 10, 22, -1, -11,
    -9, -21, 29, 43, 34, 28, 0, 25,
    18, -35, -34, 14, 9, -13, -1, -6,
    -19, -42, -16, -70, -31, 31, -67, -9,
    17, 4, 0, -17, 2, -22, 1, 19,
    -41, 9, 12, 43, 3, -2, -4, 25,
    29, -8, 6, 19, 14, 1, -27, 7,
    30, -11, 19, -38, 64, 5, -3, -21,
    49, 1, 8, 20, -15, 5, 0, -1,
    56, 13, 34, -9, -19, -20, -3, 12,
    -17, 19, 6, -15, -1, -4, 18, 3,
    3, -11, 2, 53, 41, -17, -2, 25,
    -14, 4, -3, -7, -3, 9, -8, 14,
    -2, 17, 43, -29, 9, 10, 10, -9,
    51, 16, 8, -21, 2, -3, 5, 7,
    7, 12, -22, 25, -1, -30, -18, -19,
    20, 43, 4, -13, 2, 7, -9, 0,
    -26, -13, 1, 22, 38, -4, -2, -4,
    22, 0, -5, -14, -13, -1, -1, -3,
    -46, -26, 12, 38, -3, 5, -20, 10,
    22, -13, 34, 27, 13, 1, -7, 10,
    8, -4, -17, -14, -26, -8, -17, -17,
    23, 8, 44, 6, 27, -6, -17, -19,
    -26, -30, 40, 4, -47, 4, -41, -42,
    -3, -31, -15, -52, 18, -16, -23, -4,
    21, -16, 10, -10, -11, -10, -17, 12,
    31, 24, 11, 33, -3, 6, -4, -12,
    -5, -60, 4, -31, 14, 40, 12, -47,
    17, -10, -14, 33, -4, -15, 2, -20,
    -44, -29, 19, -4, -8, -9, -5, 30,
    3, 17, 1, -23, -14, 9, -16, -5,
    -23, 56, 18, 60, -48, -57, -44, -14,
    2, 4, -3, 5, 0, 12, 1, -34,
    19, -4, -39, 2, 31, -20, 36, 15,
    30, -24, 5, -15, 18, 2, -10, -24,
    -50, 7, 0, -21, -43, -9, 20, 8,
    24, 35, 1, 4, 2, -9, -11, -6,
    10, -3, 26, 22, 15, -4, 8, 13,
    6, -9, -40, -20, 20, -4, 13, 22,
    -25, -15, -52, -37, 8, -27, 0, -107,
    34, -28, 22, -34, -1, -10, 11, -17,
    41, -13, 20, -35, 1, 0, 17, -35,
    19, 9, -2, 2, -8, 3, 5, -6,
    1, -3, 51, 27, -41, 2, -18, 42,
    -12, 2, -14, 5, 20, -5, 11, 3,
    9, 3, -64, -14, -2, 10, 28, 20,
    -21, 3, 18, 4, 19, -3, 28, 4,
    42, -15, 5, 57, -3, 74, 21, -5,
    -8, -3, 9, 29, 13, 20, 4, 12,
    15, -12, 22, 16, 21, -24, -10, -2,
    20, 31, -21, -21, -18, -3, 27, -12,
    -52, 28, -37, 59, -43, -17, -19, 22,
    -21, -68, 7, 2, -7, 19, 0, -4,
    45, -22, -4, 67, 41, 25, -51, 8,
    7, 7, -22, 10, 16, 14, 12, -18,
    -8, 19, 22, 38, -45, -59, 12, -14,
    -9, -1, -6, 4, -11, -2, 14, 8,
    -3, -5, -1, -5, 0, 41, 0, 26,
    -14, 1, -4, 3, -4, -5, -2, -10,
    -15, -68, 12, 28, -39, 51, -105, 27,
    18, 51, -26, 30, -20, 19, 11, -1,
    -40, -23, 13, 25, -7, -7, -8, 12,
    10, -2, -43, 3, -7, -21, -7, -17,
    23, -15, -28, 15, 8, -28, 40, -40,
    34, 3, -21, 45, -32, -1, 12, 8,
    5, -5, -26, 11, 8, 6, 2, -10,
    -15, 22, 7, -7, 16, 15, 14, -4,
    24, -78, -35, 27, 8, 14, 27, -20,
    -12, 3, -12, -18, 6, 18, -2, -6,
    22, 28, -39, -31, 1, 9, 47, 8,
    3, -25, 9, -1, -2, 7, 1, -18,
    31, 65, -2, -27, 6, 14, 40, -36,
    -7, 4, 22, -14, -19, 8, -10, 10,
    -54, 21, -15, 9, -1, -4, -27, 9,
    23, 30, 11, -14, -21, -3, 4, 12,
    -18, 7, 14, 3, -55, -30, 11, 23,
    22, -27, -19, -55, 20, -22, -4, 18,
    -6, 6, -4, 21, 28, 55, 18, -13,
    -12, 37, 23, -5, 5, -17, -12, 17,
    -20, 20, -7, -9, 27, 7, 10, -9,
    29, 8, 15, 6, -4, 17, -8, -2,
    -15, -20, -1, 13, -25, -15, -34, -2,
    17, 6, -5, 43, 8, -24, -4, -9,
    -13, -23, -27, 9, -18, -34, 29, 31,
    42, -11, -14, 16, 19, 4, 32, 11,
    12, 5, 41, -40, -8, -29, 16, -25,
    -9, 3, 27, 40, 18, 4, 18, 0,
    14, 43, -10, 49, 2, -25, -86, 18,
    0, 15, 39, 18, -7, 6, -12, 41,
    -32, -36, -48, 23, 13, 23, -7, 2,
    -9, -4, -6, 6, 12, -1, 9, 16,
    16, 4, -42, -38, 11, 48, -32, -5,
    -1, -6, -2, -2, -7, 11, -8, -16,
    0, 14, -26, -10, -6, -26, -12, 13,
    33, -11, -4, -4, 15, 4, 2, 21,
    -3, -25, 0, -42, 6, 17, 16, 5,
    4, -4, 1, -1, -2, 17, -2, 20,
    31, 4, -7, -18, 12, 32, 26, -3,
    23, -14, 23, -29, -7, 15, -22, 5,
    -14, -2, 3, -11, -25, -21, -32, -43,
    -7, 0, -20, 15, -7, -24, 9, 8,
    29, -7, -2, 3, -4, -27, 3, 25,
    -8, -8, -22, -7, -5, -30, -7, 6,
    13, -18, 8, -42, 0, 1, -16, 20,
    -17, -33, -39, -6, -5, 7, 2, 1,
    -7, 6, -7, 32, 5, 124, -13, 24,
    5, 2, -15, -9, 45, 2, -32, -1,
    -16, 27, 70, -28, -26, -21, 8, -21,
    39, -13, 1, 65, -25, -36, 12, 65,
    38, 9, 21, 27, -3, -9, -5, -22,
    51, 21, -25, -30, -26, -9, -30, 49,
    39, 62, -47, -3, -43, 10, -22, -16,
    -12, -23, 29, -9, -21, 18, -7, -2,
    -4, -56, 21, 35, -14, -33, 32, 8,
    45, 36, 5, 3, 17, -30, 16, -5,
    -15, -8, 5, 56, 9, 13, 26, 6,
    17, -52, 23, -15, -28, 3, 33, 2,
    19, 6, -10, -11, 13, 45, 1, -11,
    -52, -4, 18, 22, 10, 39, -22, -18,
    39, 21, -29, -26, -17, 46, 33, 17,
    60, -34, 55, -10, -18, -34, 11, -63,
    -24, -25, 19, -11, -10, -25, 28, -29,
    4, 22, -19, 15, 19, 15, 5, 23,
    -7, -1, 48, -29, 29, -64, 7, -20,
    42, -28, -14, 4, -41, -22, 7, -30,
    -60, -10, -37, -19, -13, 3, -8, 24,
    -2, -85, 20, -4, 8, 8, 40, -45,
    25, -15, 25, -44, 30, -52, 24, -8,
    7, 52, 33, -25, 38, -10, 3, -24,
    -31, -26, 21, 23, -30, -17, 30, 17,
    -22, 27, -38, -42, 18, -28, -7, 3,
    -9, 30, -47, -63, -54, -20, -17, 7,
    -3, -7, -8, -8, 34, -77, -11, 10,
    -54, 15, 30, 6, 0, -56, 37, 49,
    -5, -54, 16, 0, 23, 9, -39, -9,
    -60, -17, 13, 1, 59, -2, 13, -45,
    -13, -35, -66, -3, 2, 25, 45, 17,
    30, 13, 63, -25, -50, 22, -34, -15,
    33, 9, 25, -2, -41, 9, 27, 10,
    26, -1, 5, 99, -27, -4, -28, -20,
    -4, -1, -65, 52, -7, 7, -44, -23,
    28, 10, 31, -55, 47, 38, 8, 1,
    -77, -52, 9, 18, -9, -12, 29, -11,
    3, -25, -32, -7, -22, 25, -36, -12,
    25, -21, 30, 40, 0, 21, 11, -13,
    41, -5, 36, 30, -9, -13, 9, -27,
    39, 9, -8, 4, -29, 5, -7, 4,
    19, 35, -16, 74, 42, 10, -6, 16,
    -21, -8, 5, 32, 30, 9, -8, 52,
    45, -20, -8, 18, 32, -24, 12, 16,
    -15, -6, -45, 42, 66, 1, -10, 11,
    35, -42, 20, 4, 11, 27, -42, 8,
    -25, 11, 5, 42, 10, -31, -76, -26,
    44, 6, -18, -17, -4, -30, 14, 21,
    -32, 48, 30, -16, -31, 5, -2, -11,
    -8, -14, -26, -14, 58, -17, -23, -28,
    -15, 122, 26, 27, 27, 6, -1, -9,
    -28, -9, 17, -28, 13, 0, -36, 5,
    10, -4, 3, 12, -36, 37, -51, 34,
    27, 51, 24, -23, -9, -56, 44, 31,
    -10, -44, -42, 40, 48, 24, -7, -15,
    0, 4, -28, -15, -17, -46, 12, 11,
    -53, -53, -1, -2, 53, -19, -18, -35,
    61, -33, -12, -50, -9, 21, -24, 11,
    -83, -10, 49, 10, 7, -23, -2, -2,
    -4, 24, -2, -41, -48, -26, -55, 46,
    -33, 2, 14, 70, 23, 2, 4, 8,
    7, 49, -20, -48, 8, -16, 14, -5,
    -2, -48, 13, 63, 10, 4, 12, -28,
    17, 9, 40, -35, 12, 17, 21, -28,
    -20, -5, 2, 32, 16, 4, 3, 13,
    2, 11, -5, -68, -38, 14, 1, -21,
    48, 14, 33, 61, 16, 1, 2, -6,
    13, 12, -70, 0, -19, 48, 21, 15,
    1, 19, -16, 37, 26, -17, 58, 3,
    42, 54, 44, 8, -1, -24, 6, 13,
    5, 41, -7, -38, 16, 10, 2, 11,
    8, -38, 10, -23, -2, 26, 11, -28,
    8, -37, 15, -8, 34, -18, 53, -35,
    48, -39, -41, 5, -92, 127, 14, 22,
    -20, 9, -23, -1, -27, 12, 4, 4,
    -21, -76, 6, 77, 18, -10, -9, -5,
    -62, 11, 44, -10, 34, 4, 4, -41,
    11, -23, 35, 35, 62, 12, -3, -32,
    -15, 5, 10, -38, -13, -34, 31, 6,
    -46, -2, -39, 7, -8, 68, -4, 33,
    14, 29, -70, 11, 1, 2, 17, -5,
    -4, -73, -36, 14, 38, -1, 102, 0,
    -29, -33, 22, -47, -74, 31, 31, -2,
    -13, -19, -28, 6, 54, -6, -20, 35,
    -5, -14, 26, -20, -5, -68, -14, 8,
    49, 14, -62, 27, 16, 70, 82, -38,
    24, -64, 36, -82, -65, -64, 57, 57,
    1, -7, -25, -17, 13, -20, 52, -1,
    -15, 25, 8, -51, 30, 19, 41, -20,
    9, -27, -37, -33, 18, -21, -25, 52,
    50, -4, 34, -68, 17, 18, 33, -9,
    24, 2, -106, -23, 16, -11, 3, -4,
    -11, 57, 12, 26, 17, -19, -32, -26,
    -16, -64, -86, 32, -5, -65, 15, -11,
    37, 92, 65, 38, -52, 4, 4, 18,
    -49, 14, -16, -14, -18, 18, -31, -13,
    -30, 3, 37, -30, -11, 7, 2, 8,
    -1, -18, 13, 26, 59, 12, 64, 10,
    25, -3, -35, 24, 34, -37, -15, -5,
    -3, -6, 32, 28, -8, 97, -7, -34,
    -22, -37, -14, -21, 7, -6, -18, 17,
    -6, 3, 13, -6, -16, 40, 17, 22,
    -7, -46, -7, -23, 3, 21, 5, 6,
    -13, -25, 13, 7, 57, -11, -36, 35,
    -20, -33, -48, -7, 10, -32, -15, 4,
    -47, -6, -80, 18, 102, -72, 12, -22,
    -68, -14, -71, -32, 60, 5, 42, 18,
    11, 2, -35, -12, 40, 48, -37, 33,
    8, -7, -34, -49, 26, -12, 15, 1,
    0, 53, 22, -27, -11, 5, 52, -18,
    11, -4, -103, 12, -25, 12, -2, 86,
    -78, -4, -47, 25, 40, 27, -32, -23,
    -29, -13, 13, 2, 19, 16, 11, -10,
    9, 2, -73, -56, -9, 24, -38, 53,
    78, 16, 8, -31, -9, 30, -18, -14,
    58, -19, -58, -5, 74, -35, 13, 0,
    -1, 65, 30, -37, 9, 10, 50, 79,
    43, -48, 6, 18, -18, -24, 1, -27,
    -3, -19, 20, -22, 10, 32, 13, 3,
    -13, 47, 31, -5, 9, 48, 35, -11,
    -20, 1, -43, -21, -18, 15, -31, -12,
    61, -52, 14, 10, 29, -59, -12, 8,
    -5, 69, 9, -98, -29, -57, 43, -9,
    68, -56, -45, 24, -15, -1, 33, 56,
    -5, -10, 13, -66, -35, -22, -58, -7,
    11, -1, 19, -56, -21, -8, 50, 26,
    -16, 84, 0, 39, -1, 2, 0, 12,
    -9, -6, 4, 1, 11, -25, 9, 9,
    1, -6, -21, -4, 1, -22, 15, -20,
    -18, -53, 4, -8, 9, 6, 1, 6,
    9, 12, 9, 3, 6, 12, 11, 27,
    4, -8, -11, -17, -10, 11, 11, -27,
    12, -5, 0, 1, 4, 10, -10, 11,
    25, 7, 11, 9, 1, 8, 13, 6,
    -5, -17, -19, 13, 46, 43, -39, -13,
    4, 10, 1, 5, 16, 23, 26, -13,
    10, -9, 6, 4, 16, 11, -40, 12,
    -17, -15, -18, -9, -3, -1, 3, -1,
    2, -9, 3, -9, -14, -4, -13, 34,
    6, 0, 0, 7, 16, -7, 24, 29,
    -11, 6, -3, -15, 13, 12, 38, -16,
    2, 19, -9, 30, 10, -1, -12, -11,
    -6, -10, 18, -7, 9, -49, 2, 16,
    6, 14, 5, 8, 5, 7, 2, -3,
    9, -4, 7, 19, -19, -5, 16, 38,
    27, -7, -11, -3, -11, -2, -3, -5,
    0, 2, 12, 7, -34, -15, -9, 37,
    5, -4, 0, 1, 6, -22, 8, 1,
    4, -1, 0, 5, -8, 9, -12, 17,
    -25, -24, -21, -7, 7, 22, 19, -2,
    -6, 3, 8, 1, -49, -27, 33, 22,
    14, 12, -8, -19, -18, -46, -25, 4,
    -3, 20, 1, -1, 2, -8, -27, -24,
    0, 13, -18, -12, 13, -6, 2, 13,
    0, 27, 9, -26, 13, -27, -8, -21,
    -13, 10, -1, -5, -22, 13, -17, -33,
    5, 27, -19, 7, -20, 5, -12, 5,
    -29, 3, 18, -3, -11, -10, -1, -4,
    -8, 7, -11, -1, 29, 17, 19, -5,
    7, -9, 3, 8, -26, -19, 3, -2,
    0, -11, 3, -4, 1, -29, -16, -1,
    18, -13, 35, -8, -12, 11, -5, 10,
    -3, 9, 0, 8, 47, 22, 40, 10,
    7, -9, 9, 6, 1, -19, -3, 8,
    10, -7, 1, -13, 12, 0, -32, -7,
    1, -13, 8, -12, -6, -7, 4, 10,
    -5, 6, 4, -7, -22, 37, -28, -12,
    -5, 23, 7, -1, 1, -9, 40, 4,
    12, -8, 6, -38, 13, 35, -10, 7,
    2, 25, 6, -4, -11, -15, 4, -1,
    5, 6, -5, -4, 16, -27, 0, 21,
    -6, 11, -3, 7, -28, -1, 5, -9,
    -35, -1, 0, 20, -47, 26, -8, -12,
    15, 43, -10, 23, -2, -5, -5, 6,
    -6, -17, -7, 4, 11, -7, 3, 7,
    -1, 5, 4, 13, 24, 26, 1, -7,
    -1, 7, -2, 11, -15, -1, 2, -5,
    13, -33, 7, -5, -3, 10, 6, -1,
    3, -6, 2, 5, 11, -40, 21, -21,
    10, -1, 15, -8, 5, 21, -18, -22,
    -17, 0, 9, -8, 4, -27, -26, -6,
    -3, 19, 1, 31, 1, 24, -4, 12,
    13, -9, 16, 9, -31, -42, 8, -25,
    0, -1, 1, -15, 10, -13, -11, 9,
    0, -26, 40, 27, 0, -3, 8, -7,
    -5, -12, 16, 5, 1, 2, 8, 4,
    13, -8, 0, 6, -16, 12, 13, 28,
    -18, -3, -5, 5, 4, 25, -8, 4,
    1, 4, 5, -1, 10, 1, 3, 30,
    -7, -53, 20, -12, -12, 9, 10, -20,
    -2, 8, -1, 10, -30, 16, 14, -68,
    11, -4, 4, 1, 8, 32, -7, 31,
    -9, -18, -10, 17, -2, -23, -28, 41,
    -25, -10, -7, 30, 0, 3, 6, -7,
    -5, 5, -3, 3, -24, -6, 3, 23,
    6, 6, -6, -4, -34, -7, 13, 15,
    -19, 1, -2, -5, -2, 22, -23, -28,
    15, -2, 2, -18, 0, -17, 16, -1,
    -7, -4, -13, 0, 6, -9, 9, 19,
    0, -5, -10, 24, 35, -8, 42, -24,
    16, 15, -17, -13, -15, 30, -3, -1,
    17, 27, -15, 18, -8, 4, 16, -2,
    3, -3, 1, -3, -26, 32, -27, -51,
    -2, 3, 15, 1, 6, -54, 4, -20,
    35, -15, -28, 1, -30, 3, -40, 2,
    0, -10, -7, 7, -14, -7, -7, 17,
    -8, -1, -2, 5, -43, 14, 2, 13,
    -4, 19, 1, 7, 29, -13, -23, 5,
    -7, -17, 17, 5, -3, -13, 10, 6,
    -4, -50, -14, 0, 2, -10, -12, 10,
    16, 20, -11, 11, 17, -20, -18, -5,
    11, -1, 6, -5, -24, 18, -9, -22,
    -34, 4, -12, 42, 15, 24, 18, 4,
    -39, 37, 16, 15, 6, -19, 5, -15,
    12, -11, 7, -1, -18, -33, -17, -2,
    -2, -8, -3, -8, 7, -17, 31, 19,
    -13, -10, 6, -2, 49, -1, -24, 3,
    5, -3, -35, 60, -1, -8, -5, 17,
    -1, -3, 10, -1, 8, -11, -22, 34,
    -3, 9, -2, -7, 42, 0, -31, -31,
    -26, 8, -11, 35, -19, 21, 20, -14,
    -34, -4, -24, 29, -6, -10, 9, 8,
    2, -5, 0, -17, 34, -24, -1, -30,
    10, -11, -6, -4, -36, -39, -28, 35,
    -4, -4, -8, -16, 15, 39, 6, -2,
    0, -1, 2, 7, -23, 21, -11, 13,
    17, 4, -24, -14, -1, -7, -8, -43,
    -8, -1, 3, -4, -31, -21, -29, 36,
    1, -19, -16, 5, -5, 6, -2, -20,
    13, -3, 7, 2, 2, 2, -2, -4,
    -2, 1, -7, -1, 5, 24, 50, 20,
    -2, -10, -4, -5, -21, -9, 31, 34,
    22, -35, -12, -15, 9, 16, 5, -14,
    -21, -4, -8, -22, 3, 2, -3, -6,
    0, 11, -8, -11, 21, -27, -39, -36,
    -1, -3, -5, 3, -6, 24, -21, 12,
    -1, 40, 1, 26, -30, 16, 18, -30,
    2, -20, -15, 18, 4, 8, 2, -12,
    1, -3, -4, 8, 21, 10, 8, 0,
    -4, -1, -1, 3, 13, -26, -4, 15,
    -24, -12, -38, -33, 23, 11, -20, 2,
    -13, 11, 28, 23, 8, -10, -6, 9,
    11, 6, 8, 4, -39, -22, -23, 20,
    2, -9, -14, 8, -44, -19, 13, -44,
    -21, 19, 21, 17, 41, -15, 21, 39,
    2, 40, 7, 3, -13, -4, 2, 1,
    9, -6, 0, 5, -34, 17, 39, 27,
    3, -2, 3, 9, -24, -38, 1, -27,
    4, -28, 12, 27, 2, -25, -28, -5,
    26, -6, -26, 9, 0, 5, 21, 11,
    -2, 4, -11, -12, 18, -5, 14, 13,
    23, -3, 0, 3, -10, 31, -26, 44,
    13, 21, -10, -18, 13, 8, 8, 13,
    16, 9, -16, -24, 14, -9, 0, -4,
    17, -9, -9, 8, -1, -27, -41, 8,
    17, -4, 8, -12, 29, -21, 1, 31,
    -19, 27, -22, 36, -7, 51, 48, 16,
    -47, -40, 7, 13, 14, 12, 4, -18,
    -1, 2, 13, 21, -39, 5, -3, 13,
    20, 9, 8, -18, 26, -14, 30, -45,
    -8, 4, 4, 13, 5, 14, 3, 13,
    0, 0, 7, -16, 13, -5, 20, -2,
    -17, -8, -12, 17, -56, -7, -55, -4,
    -4, -3, -17, 2, -32, 57, -7, 13,
    -17, 10, 11, -2, 4, -15, -33, 19,
    -19, 13, 4, -9, -1, 28, -1, -12,
    21, -20, -6, -15, 65, -39, 46, -5,
    4, 3, 2, 2, 11, 5, -3, 26,
    9, 6, -13, 1, -4, 0, -21, -33,
    -30, -20, -15, -6, 0, -4, -11, -8,
    -4, 8, -9, -12, -2, 34, 33, -10,
    -3, -3, 20, -32, -18, -10, 23, 7,
    -17, 6, -7, -15, 3, -60, 63, 66,
    4, -26, -14, 16, -10, -4, -2, -15,
    1, -11, 18, 12, 19, -10, -38, 36,
    3, -2, 31, -20, -19, -37, 44, -26,
    12, -20, 10, 8, 9, -7, -18, -34,
    -6, -4, -15, 6, -1, 1, 25, 6,
    -2, 2, -15, -6, -6, -10, -33, 97,
    23, 30, -29, -15, 16, 1, -35, -24,
    16, 16, -13, -2, 31, -67, -1, -23,
    -10, 4, -28, -13, 20, -17, -31, 6,
    6, 2, 11, -22, -55, -24, 36, -12,
    9, -37, -7, -4, -46, -12, -7, -22,
    32, -12, 6, 8, -26, -3, -27, 31,
    41, 13, 7, 23, 28, 5, -2, -1,
    -3, 23, -4, 8, -24, 26, -23, 19,
    -15, 8, 17, 7, 7, 34, 29, -9,
    -6, 0, -33, 3, 10, -16, -9, 8,
    -10, -7, 8, -28, -12, 0, 5, -1,
    0, 4, -17, -2, 62, 46, -58, -1,
    2, -2, 6, -2, 22, -10, 32, -4,
    -2, -23, -23, 25, 32, 6, -30, 11,
    -6, 40, -8, -37, 3, 16, 3, -8,
    14, 10, -5, -2, -109, 12, -15, 9,
    -19, 34, 6, -3, 55, -18, -10, 3,
    -14, -27, 3, 0, 36, 3, -5, 4,
    15, 6, 10, 10, -16, -16, 16, 12,
    -1, 15, -19, 1, 31, -20, -13, 5,
    -5, -10, 1, -4, -47, 31, 2, 50,
    -17, -5, -31, 48, -23, 10, -1, 87,
    -2, -22, 0, 0, -1, 4, 1, -51,
    -7, -8, -1, 10, 67, -45, -43, 26,
    3, 0, 8, -5, -6, -34, 9, 4,
    19, 9, 15, 5, 2, -1, 11, 25,
    10, -15, 11, 11, -11, -5, 4, -2,
    11, -2, -1, 0, -19, 24, 15, 31,
    -3, 2, 16, -8, 11, 8, -16, -68,
    6, -19, -10, -14, 57, -48, 4, -5,
    5, 8, -9, -21, -9, 2, -15, -12,
    0, 10, 11, 4, 1, -23, -21, -11,
    33, 3, 8, -7, -35, 23, -15, 9,
    5, -20, 25, 15, 13, 10, -37, 2,
    20, -17, 28, 5, 5, 2, 23, 19,
    11, 3, -2, 11, -32, -14, 3, 12,
    -15, -1, -5, -17, 30, -14, -21, 7,
    11, 1, 13, 17, 46, 3, -18, -3,
    14, -12, 23, 3, -22, 15, 19, -22,
    2, 5, -13, -26, -26, 12, 32, 15,
    11, 2, -7, 13, 28, -8, 10, 39,
    16, -9, 12, 20, -11, -18, -7, 3,
    -17, -3, 5, -17, 4, 11, 10, -20,
    3, 10, -15, 2, -23, 11, 5, -34,
    3, 7, 1, 4, -3, -22, 1, 2,
    -27, 24, 12, -11, 2, 30, -40, 24,
    5, -7, 8, -21, -8, 1, 7, -6,
    -4, 13, -10, -13, 3, 24, -37, 16,
    -13, 22, -22, 56, -24, 24, 52, 23,
    3, 10, 9, 3, -33, 62, -28, 15,
    1, -27, -6, -19, -6, -1, 0, -19,
    -11, -4, -6, -11, 34, -52, 15, -11,
    -6, 33, 12, -17, 36, 4, 6, -21,
    -23, 3, -34, 30, -51, 19, -42, 0,
    63, 2, -15, -12, 10, -44, -3, 10,
    -19, -3, 5, 8, -17, -28, -12, 14,
    -10, 13, -16, -2, -43, -43, 8, -39,
    -5, 13, 1, 5, 25, -50, 66, -15,
    1, 13, 17, 3, -4, -6, -47, 13,
    -4, 8, 4, -7, -6, 71, 58, 57,
    18, -23, 19, -17, -35, 37, -24, 33,
    -15, 13, -6, 6, 10, 34, 41, 12,
    -3, -1, -1, 7, 3, -23, -28, -19,
    8, -19, 1, 28, -4, 88, 78, 20,
    -1, 23, 5, -4, 25, -5, 26, 15,
    4, -13, -5, 5, 58, 31, -8, 25,
    -9, 30, 0, 11, -9, -14, 1, 7,
    -6, 2, 4, 5, -54, 4, -56, -30,
    -7, 3, 2, -41, 16, -16, 20, 48,
    -23, 9, 21, -4, -16, -31, -32, 12,
    -33, 3, 26, 2, -2, -9, 13, -3,
    -2, 13, 5, -6, 40, 28, -34, -46,
    5, -25, -5, -5, 46, 56, 3, -6,
    -10, -6, 11, -4, 6, -34, 8, 11,
    0, 7, -14, -13, -28, 21, 1, 3,
    -6, -8, -56, -6, -21, 32, 16, 4,
    -32, -10, 9, 21, -15, 28, 35, 13,
    -5, 13, -23, -14, -24, 20, 26, -1,
    18, 35, 11, -1, 2, 8, -1, -7,
    -8, -1, 0, -21, -1, -29, 18, 14,
    -4, -10, -8, 12, 3, -36, 5, 20,
    -17, -55, -21, -33, 4, 10, -22, 5,
    -20, 4, 18, 10, -2, 5, 6, 4,
    4, 8, 8, 5, -26, -14, 22, -34,
    1, 5, -17, -2, 19, 1, 45, 55,
    39, 16, -10, -3, 8, -19, 16, -23,
    -15, 4, 20, 18, -5, 9, 26, -2,
    5, 4, -8, -4, 11, -40, -24, -28,
    -18, 4, -1, 7, 20, 13, -4, -5,
    11, 2, -44, -11, -15, 14, -33, 13,
    -15, 6, 19, 18, -30, -10, -4, 7,
    19, -5, 10, 3, 24, -51, 2, -5,
    16, 1, -17, -17, 9, 9, 37, -5,
    1, -1, -21, -17, 46, -11, 16, 50,
    50, -11, 7, -5, -20, -11, -5, 18,
    9, -10, 9, -20, 56, 27, 21, -24,
    -21, 13, 13, 18, 35, -20, -23, -45,
    2, -3, 2, 21, -33, -13, 5, 22,
    -4, -6, -24, 16, 32, 9, 13, 6,
    -3, 8, -18, 15, 16, 20, -38, -5,
    11, -9, -8, -41, 25, 9, 26, 23,
    -8, 16, -2, -1, -3, 14, -28, -6,
    -20, 16, 0, -20, 7, 21, 5, -3,
    10, -10, -22, 1, -35, 54, 44, 76,
    10, -6, 18, -29, -4, 30, -11, -67,
    4, 40, -26, 12, 11, -24, 49, 39,
    -12, 37, 1, 26, 22, 9, -3, -45,
    -42, -17, 5, 79, 19, 40, 31, 28,
    62, -10, 14, 3, -15, -7, -54, 13,
    -9, -14, -40, 6, 4, 3, 46, 12,
    4, 6, -20, 9, 46, 0, 29, -8,
    -33, -33, 22, 38, -50, 46, 82, 9,
    -12, -35, -20, -2, 18, -37, -47, 26,
    40, 33, -8, 38, 32, 55, 34, 26,
    -43, 61, -17, 6, 4, 59, 11, 9,
    16, -58, -23, -29, -22, -5, -8, 8,
    -4, 7, 5, 8, -49, -22, -62, 10,
    -17, 39, -27, 15, -49, 11, -5, -3,
    -7, -37, -5, -42, -2, -14, 41, 5,
    1, 16, -5, -5, 26, 103, -3, -43,
    18, -5, 54, -71, -13, -88, 33, 1,
    -9, 8, 4, 28, -16, -15, 42, 18,
    -6, -86, -8, -21, -17, 23, -12, -3,
    -27, 11, 23, 40, -56, 36, -25, -29,
    22, -4, 49, -30, 13, 9, 24, 8,
    -12, -39, 70, -7, -20, 5, -27, -37,
    25, 34, 17, 70, 8, -25, 36, -8,
    -34, -3, -29, -35, -33, 23, 29, -56,
    14, 29, -46, -1, -4, -3, 52, -56,
    35, 12, 2, -20, -16, -29, -36, 54,
    -63, -9, -31, -13, 30, -21, -53, 0,
    9, 6, -7, 6, 94, 0, -32, -78,
    25, -35, -19, 1, 9, 88, -8, 49,
    48, -35, 0, 13, -2, -11, 11, 10,
    42, -29, -27, 55, 52, -35, 20, -2,
    13, 44, 1, -14, 70, -101, 31, 27,
    -29, 22, 21, 1, -6, 14, -46, -1,
    -71, -20, -20, -23, 24, -36, -12, -22,
    -14, 23, 9, 26, 14, -22, 22, -11,
    -32, -11, -43, 5, -6, 51, 64, 7,
    40, 8, 2, -25, -127, 70, 31, -110,
    -30, -9, -73, 53, 24, -23, -32, -6,
    24, 75, -30, 8, -2, 2, 7, 4,
    62, 28, 13, -1, 64, -69, -20, -53,
    -28, 56, -1, -3, -4, -22, -25, 42,
    -49, -32, 9, 39, 58, -7, -29, 29,
    -6, 2, 4, -15, -6, 0, 22, -6,
    -34, 11, -56, 5, 5, 34, -51, -24,
    -18, -36, 6, 9, 20, 41, 16, -26,
    -39, -38, -43, -35, 51, 18, -28, 40,
    17, -46, 29, -3, -12, 4, -13, -70,
    -30, -7, 14, 30, -7, -18, 6, 41,
    35, -7, -7, -21, -33, 35, 8, -35,
    19, 25, 28, -13, 11, 2, -28, -4,
    -8, 35, 2, 32, -16, -24, -12, -20,
    53, -4, 10, 12, -37, 15, -10, 94,
    -25, 22, 12, 19, -11, -7, -6, 15,
    22, -61, -10, -34, 35, -54, -70, 53,
    23, 2, 14, -24, -17, 13, -24, -27,
    48, 10, 19, 14, -29, -13, -18, -71,
    89, 13, 11, -16, 62, 29, -27, -33,
    -12, -12, 5, 53, 3, -17, 37, 14,
    42, 9, -1, -16, 6, 6, 15, 27,
    25, -1, 6, 15, -19, -82, 19, -13,
    -30, -6, -13, 19, -63, -1, -27, -23,
    27, 24, 3, 36, 9, -27, -11, -35,
    -78, 49, -7, 47, -42, 7, 29, -62,
    28, -9, -26, -34, -8, 51, 13, -74,
    44, -6, -30, 50, -42, -12, -86, -35,
    0, 2, -17, 27, -59, 9, -17, 3,
    -14, 9, 15, -43, 8, 15, 10, -28,
    -10, 10, -19, -4, 52, 19, 17, 68,
    4, 0, 13, -5, 6, 21, -10, 8,
    0, 3, 26, 26, -14, 24, -42, -8,
    -33, -65, 75, -45, -1, 11, 24, 0,
    -15, 24, -3, -3, 37, -29, -2, -16,
    25, 55, -45, 76, 5, -45, 28, 20,
    -2, 29, 31, 40, -29, 55, -26, -13,
    -5, -86, -5, -11, -26, 16, 2, 4,
    6, 8, -12, -26, -21, 52, 41, 14,
    -8, 63, -1, -21, 14, 4, -60, 2,
    13, 48, 14, 49, 6, -35, -88, 0,
    108, -24, -38, -22, 14, -82, -28, 11,
    -15, 14, 21, 9, -22, -53, -30, 11,
    -8, 9, -52, -1, -54, -26, -10, 9,
    -22, 2, 17, 16, 15, 15, 10, 20,
    -27, 106, 9, 40, -21, -18, -105, -24,
    -5, 28, 16, 5, -17, -14, -39, -33,
    8, -56, 36, -39, 14, 32, 73, -11,
    -39, -10, -14, -14, -8, 35, 31, 90,
    81, -59, 0, 10, -15, -60, -32, -41,
    0, -11, -11, 99, 17, 1, 7, -33,
    -9, 62, 12, 6, -31, 56, -28, -63,
    58, 37, 38, 43, 31, 2, 39, 33,
    -14, 7, 27, -106, 23, -12, 4, 1,
    -18, 11, 18, 2, -32, 36, 92, 1,
    8, 28, 43, -49, -74, 20, -45, 102,
    -42, 18, 28, -42, -21, -36, -38, -5,
    25, -53, 49, -31, -12, -31, -7, 4,
    27, 3, -11, 12, 31, -86, 15, -13,
    22, -19, -16, 1, -14, 16, -42, -27,
    -35, -15, 46, 15, 43, 5, 19, -4,
    -2, 39, 19, 5, -59, 54, 8, -23,
    -50, 21, -127, 13, 55, -77, 18, -30,
    -54, -18, 18, 50, 44, 0, 59, 55,
    -14, -25, -52, 5, -68, -1, 57, -37,
    40, 89, 14, 29, -7, 2, -10, -10,
    -14, 32, -4, -48, -18, 51, 54, 25,
    -3, 1, 10, 54, -41, -57, -34, -8,
    -9, -56, -31, -4, -1, 15, 7, 14,
    3, -29, 22, 65, -1, -1, -8, 27,
    -4, 17, 25, 31, -3, 50, -2, -25,
    -17, 5, -27, -1, -11, 6, 10, -6,
    62, 3, -27, -58, -3, 15, 32, 43,
    42, -6, -31, -40, 7, 10, 26, 5,
    -9, 34, -20, -1, -48, -28, 34, -49,
    -9, 16, 0, 23, 42, 46, -9, 13,
    0, -6, -32, 38, -11, 15, -66, 0,
    27, 28, -4, -17, -80, -13, 1, -9,
    -5, -57, 2, -10, 74, -29, 15, -45,
    21, -17, 3, -22, 12, 33, -4, -32,
    -13, 42, 22, 1, 24, 17, -55, 14,
    126, -17, 63, -28, -38, -22, -18, 49,
    11, -17, 14, -73, -9, -26, -42, -81,
    -52, 28, -5, 47, 85, 44, -14, 53,
    -23, -4, 11, 34, 76, 17, 1, 26,
    -17, 29, 16, -37, 51, 28, 15, -9,
    -14, 12, -37, 50, -41, -29, 12, -22,
    17, -28, -37, -92, -3, -30, 30, -5,
    12, 17, 65, 64, 11, 32, -26, -53,
    4, -57, 26, 14, 38, 4, 6, -23,
    -4, -24, -62, 2, -21, -47, 98, -72,
    -1, 18, 3, -22, 4, -7, 22, 48,
    -12, -4, 11, -24, -34, 35, -44, -9,
    -1, -8, -7, -11, -12, -9, -4, 0,
    -24, -7, -29, -26, 33, 43, 3, 6,
    22, 1, -25, 13, 4, -5, -5, -12,
    -20, 15, 3, 18, -13, 0, -34, 25,
    -11, 19, -6, -23, -1, 1, 2, -11,
    41, -68, 7, -49, -11, 3, -1, -3,
    4, -22, 10, -36, -31, -17, -21, -19,
    -16, -8, -7, 34, 0, 20, 12, 29,
    2, -5, -3, 15, 1, -13, -2, -4,
    19, -6, 20, 17, -3, 9, -13, 33,
    16, 48, 11, -17, 12, -34, 40, 2,
    12, -20, 13, -21, -6, -52, -8, 4,
    -20, 18, -9, 20, 0, 1, 10, -3,
    -1, -11, -9, -6, -13, -19, -5, -32,
    -27, 16, -22, 8, 30, -10, 15, 21,
    21, 2, -7, -12, -17, 4, 0, -13,
    21, -19, -11, 9, -2, -14, -7, -13,
    58, -37, -44, -13, 17, 12, 9, 3,
    -10, -40, -9, 15, 12, 41, -11, -31,
    2, -1, -1, -10, -7, -61, 13, -38,
    8, -6, 26, 19, -7, 0, -9, 15,
    -8, -16, -21, -35, -25, 0, -18, -5,
    -14, -14, 8, 25, 14, -6, 3, -27,
    37, -37, -7, -22, -46, 30, -8, -35,
    -12, -17, -2, 20, 16, 7, -23, 6,
    28, 15, 17, 21, -18, -6, 1, -2,
    22, 8, 45, -31, -37, -7, 7, 5,
    0, 18, 0, 23, -27, 6, -21, 24,
    -22, 17, -33, -29, 16, -2, -6, -6,
    -4, 4, -10, -1, -15, -10, 4, -6,
    43, 28, 1, -8, -12, -46, 4, 18,
    8, 13, 1, -12, 11, 21, -17, -37,
    -27, -23, -14, -17, -2, -10, -6, 5,
    7, 25, 49, -31, 17, 23, 11, -5,
    -28, -12, 18, 11, 10, -35, -11, -10,
    -23, 3, -1, 7, -25, -9, -43, 27,
    25, -14, 3, 29, 8, -6, 6, -17,
    28, 24, 36, 17, 9, 24, -32, 6,
    27, -13, 23, -19, -9, 31, -25, 26,
    2, 24, 11, 6, -21, -21, -5, -7,
    -6, 4, 8, 2, 10, 2, -2, 3,
    28, 8, 39, -7, 4, 4, -13, 26,
    -8, 7, -3, 16, 13, -4, -6, -51,
    29, 6, 12, -25, 25, 17, -48, 27,
    6, -4, -13, 14, -20, 7, -14, -18,
    -36, -17, 28, 6, 12, 11, 13, -9,
    0, -10, -24, 7, 29, -26, -8, 9,
    3, 2, 6, 20, 21, -10, 32, -2,
    -2, 7, 24, -34, 6, 2, 3, 3,
    -12, -15, -13, -8, -1, -7, 8, 4,
    9, 21, -28, -15, 5, 8, 21, 6,
    9, 3, -27, 47, -11, 7, -5, 9,
    -24, -9, 11, -33, -12, -1, 15, 4,
    1, -18, 14, 9, -11, -1, -7, 11,
    -21, 9, -38, -31, 22, 5, 18, 8,
    9, 9, 11, -8, -4, -14, 33, -36,
    -20, 1, -6, 2, -25, -9, 3, 26,
    27, 2, 1, 7, 18, -7, -4, -4,
    -22, 3, 7, -8, 7, -13, -24, 18,
    -19, 3, -7, -15, 23, 8, 35, -7,
    5, 37, -24, -4, -7, 3, 4, 9,
    -5, 20, -11, 32, -10, 18, -40, -18,
    28, -14, 24, -31, 13, -2, 13, -23,
    22, -24, -8, 3, -19, -29, -48, 1,
    -42, 1, -25, -25, -23, -5, 1, 3,
    40, -1, -94, 31, -17, -16, 20, -18,
    0, -1, 10, 18, 18, 48, -31, -21,
    12, -2, -13, -1, 32, -8, -4, -12,
    11, -7, 3, -3, 5, 6, -7, -1,
    6, -25, 11, 1, -5, 14, 21, -10,
    -5, 5, -12, 21, -2, -12, -23, -16,
    12, 21, -4, 1, -22, -36, 23, 53,
    2, -23, 25, -6, -10, 3, -6, 9,
    -9, -30, 34, 40, 22, 26, -4, 19,
    -26, 4, 34, 22, 14, 2, -12, 18,
    -9, 3, 8, 49, -2, 48, 43, 57,
    -10, -41, -6, -17, 9, 7, -5, -4,
    50, 29, -2, 19, -16, -6, 10, 53,
    20, 9, 40, 10, 32, 29, -27, 11,
    -27, -21, -11, 25, -18, 23, 43, 54,
    76, 5, -5, 27, -8, -10, 7, 3,
    -12, 43, 11, 7, -12, 17, -6, -25,
    21, -18, 7, 21, -25, 20, 18, 54,
    4, -17, 2, 2, 6, -14, -5, 10,
    24, -3, 13, 1, -9, 3, 3, 13,
    -16, 18, 0, -95, 13, -2, -3, 16,
    -36, 32, 10, -5, -38, -46, 0, 33,
    -9, 39, -4, -14, 10, 49, 30, -14,
    -12, 9, 4, -46, -12, 15, 2, -7,
    35, 27, 16, 2, 10, 9, 11, 10,
    20, -17, 9, -9, 14, 8, 18, 6,
    12, -14, -5, 11, 30, -9, -14, -32,
    24, -2, 29, 29, -5, -19, -5, 9,
    -18, -55, 29, 36, -6, -16, 3, 12,
    -24, -10, 9, 8, 23, -13, -50, 18,
    5, 3, 12, 6, 30, -19, 23, -4,
    -25, 17, 4, -14, 2, 8, -11, 6,
    1, -4, 40, -23, -17, -3, 5, -29,
    -2, 0, 15, -32, 16, 10, 39, 10,
    19, 8, 24, -24, 3, -27, -23, -6,
    5, -5, -13, 17, -2, 17, 0, 5,
    -5, 9, -58, 38, -2, 15, -4, 32,
    12, -4, 8, -21, -8, 25, 14, 13,
    -7, 14, 8, -5, 2, -39, 29, -17,
    19, -19, -30, -21, 6, 17, 4, 6,
    -19, -24, 17, -29, -1, 7, -11, -20,
    -28, 8, 3, -5, -10, -9, -4, 9,
    -9, 17, -38, -10, 22, -14, -37, -28,
    2, 23, 26, -36, 13, -1, 18, 2,
    24, -36, 33, 4, 16, 5, -5, 14,
    18, -12, 10, -14, 6, -3, 7, 28,
    21, -7, -22, -5, 27, 36, 2, 45,
    26, 8, 29, 10, -16, 2, -5, 5,
    -52, 16, -15, -20, 8, 19, -39, -2,
    3, -29, -32, 15, 36, 2, -33, -4,
    29, -17, -12, -3, 48, -9, 17, -38,
    32, 8, 2, -1, -10, 5, 3, -10,
    11, 16, -4, 21, 3, 13, 19, 9,
    21, -21, -13, 0, 32, 8, -4, -6,
    -7, -18, -31, 5, 16, 33, -17, 3,
    -34, 28, 0, -15, 5, 7, -13, -8,
    21, -5, 1, 14, 24, 13, -23, 22,
    0, -3, -1, -20, 23, -7, 16, 8,
    -3, -9, 5, -16, 25, -19, 17, 30,
    -12, 45, 9, -19, -5, 8, -2, 17,
    2, -1, -26, -6, 1, -2, -7, 9,
    -9, 32, 17, 12, 4, 28, 15, -47,
    16, 0, -15, 7, -29, 36, -23, 10,
    32, -16, -6, 80, 9, -5, -12, 7,
    16, -16, -22, -19, 30, 29, -3, -4,
    11, 7, -45, 10, 2, -30, -10, -36,
    -32, 8, -10, 0, -6, 21, 6, 11,
    -36, -21, -54, 15, -1, 2, -8, -30,
    66, -73, -6, -30, -4, -24, -34, -1,
    -12, -3, -21, -22, -12, -28, 30, -10,
    -11, -66, -20, 33, -13, 7, -46, 15,
    32, -9, 25, -17, 10, -14, -9, -2,
    -10, 31, -17, 39, 28, 21, 8, 43,
    -3, 11, 1, -21, 27, -29, 29, -38,
    0, -6, 1, -5, 11, -6, 32, -58,
    -43, 37, 67, 2, -2, 12, 12, 1,
    5, -30, 17, 5, -7, -3, 18, 0,
    -28, -7, -9, 5, 4, -2, -24, -29,
    51, -7, -20, -42, 11, -17, 11, 11,
    22, 33, -10, 36, -5, -9, 4, -9,
    63, 4, -46, -38, 27, 3, 3, -6,
    15, -58, 35, 20, 17, 42, 2, -27,
    -8, -17, -11, 8, 4, -46, 30, -52,
    91, 26, 8, 84, -2, 1, -9, 19,
    -1, 7, 46, -33, -28, -18, -7, -1,
    14, 17, -7, -20, 15, -2, 10, -19,
    30, -27, 42, 19, -13, 5, 15, -54,
    -31, -52, 5, 55, 23, 9, -25, 4,
    -20, -20, -50, -45, -11, -16, 5, -9,
    -21, 28, 0, 14, 23, 6, -3, -4,
    -14, 45, 0, -36, 23, -44, 1, 11,
    -27, -5, 0, 26, 9, 12, -20, -14,
    -30, 15, 0, -15, 5, 15, 22, -12,
    -10, 20, 8, -18, 15, 29, -20, -19,
    -26, 14, 4, 0, -44, 18, 6, -30,
    12, 12, 27, 50, 9, 0, 19, -5,
    19, 34, 45, 1, -8, -28, -10, -1,
    -14, -13, -15, -31, 34, 12, -16, -8,
    -27, 1, -31, -42, -33, 18, -16, 29,
    37, -18, -11, -13, 6, -17, 0, -26,
    13, -50, 0, -29, -29, 31, -15, 34,
    -1, 17, -28, -32, -45, 17, 21, 21,
    6, 3, 14, 6, -37, -7, 13, 42,
    59, 14, 3, 5, 8, 13, -11, 11,
    22, -9, 31, -5, 1, -5, 1, 8,
    -52, -20, 13, 16, -62, 56, -19, -40,
    17, -22, 4, -34, 42, -25, -43, -26,
    5, 7, -52, -25, -38, -3, -3, -14,
    33, -38, 0, -38, -16, -17, 14, -25,
    11, -13, -29, -11, 16, -27, -9, 12,
    -8, -5, -5, -1, -17, 24, 38, -6,
    1, 32, 15, -11, -1, 6, 7, 7,
    -35, -5, 34, -43, 2, 4, 5, 1,
    17, -14, -10, -43, -25, 37, 26, 11,
    -40, -24, -18, 30, 0, 24, -4, 53,
    -40, -39, -35, 7, -33, -18, -9, -4,
    -32, -17, -37, -19, 4, 5, -22, -11,
    13, -28, -17, -59, 1, -10, -10, -10,
    -1, -13, -3, -5, -27, -11, 21, -57,
    27, 9, -4, -16, -24, 1, -16, 21,
    25, 8, -5, 10, -12, 4, 8, 26,
    -34, 0, 8, 11, 3, -1, -6, 27,
    -29, 11, -4, -16, -3, -10, 20, -29,
    -18, -22, 9, 70, -7, 10, 3, 30,
    42, -13, 10, 5, -15, 7, -44, -1,
    -12, -9, 12, -38, 19, 14, 33, 14,
    -29, -9, -11, 13, 20, -22, -47, 16,
    39, -4, 30, -45, -35, 5, 0, 16,
    11, -14, -125, -4, 1, -19, 18, -40,
    -10, 11, 27, 15, 5, 28, 4, -16,
    0, 10, 26, 13, 29, -42, 46, 13,
    16, -18, -13, -39, -3, 11, -6, -6,
    33, -21, 6, 17, 6, 25, -5, 19,
    -30, -99, -22, -6, 32, 15, -4, 3,
    38, -1, -7, 5, -13, 71, 61, 47,
    18, -5, 29, 16, -19, -2, -2, 10,
    21, 3, 29, 59, 14, 4, -17, 29,
    11, 25, 17, 25, 42, 14, -17, -6,
    14, 14, 22, 42, -11, -17, 15, -6,
    -37, -24, -39, -13, 4, 21, -1, -9,
    7, -6, -9, 3, 1, 21, 14, 58,
    24, 18, -37, 21, 2, 35, 47, -18,
    -23, -42, 0, -11, 0, 27, 9, -11,
    3, -7, 31, -44, -16, -37, 27, 12,
    6, 21, -7, -11, 24, 11, 23, 2,
    6, -31, -10, 29, -48, 2, -31, -34,
    4, 0, 9, -24, -15, -95, -3, -43,
    2, 45, 61, 56, -16, 9, -23, 12,
    -3, 43, 39, -59, -14, 23, 8, 11,
    2, 41, -7, 12, -26, -1, -23, 33,
    -68, 47, 1, -2, 2, 13, 72, -28,
    18, -38, -10, -43, -16, 19, -4, -9,
    72, -40, -43, 19, 28, 19, -30, -4,
    -4, 11, 0, -64, 13, 36, 28, 4,
    -1, -15, 2, 34, -33, -4, 2, -2,
    24, -42, -30, 58, -23, -31, -24, -21,
    1, -47, -4, -17, 22, -21, -14, 14,
    29, -13, 8, -18, 55, 35, -32, 7,
    -33, -11, 19, -7, 13, -28, 55, -61,
    4, 9, 5, 22, 2, 19, -19, -1,
    47, 17, 67, -4, -21, -2, 6, -13,
    22, -1, 8, -3, 48, 15, 19, -2,
    29, 27, 11, 22, 2, 34, -13, 39,
    0, -22, -8, -19, 6, 18, -5, 14,
    54, 22, -54, 56, 0, 9, -11, -10,
    -27, -22, -4, 17, 1, 34, 4, -1,
    5, 25, 19, -59, -27, -29, 14, -51,
    13, -35, -47, 26, 3, 16, 9, 14,
    4, -27, -6, -35, -7, 5, -20, -19,
    -13, -6, -3, 12, -11, -8, 11, -43,
    7, -15, -10, 0, -26, 81, -31, -25,
    -19, 22, 19, 4, 33, 5, 32, 3,
    -2, -86, 31, 10, 23, 1, 11, -3,
    22, 13, 7, 10, -19, 6, 14, 19,
    15, 6, -14, -9, 44, -16, 5, 17,
    -5, -7, 36, 9, -9, -2, -4, 13,
    1, 12, -10, -4, 11, -19, -29, -7,
    2, -6, -12, -11, 10, 27, -9, 58,
    6, 16, -32, -31, 31, -20, -3, -29,
    -29, -8, -38, 48, -14, 6, -14, -28,
    50, 24, -14, 47, 14, -11, 16, -4,
    -21, -2, -16, -12, -37, 0, 42, -10,
    -10, -11, 16, -16, -47, 41, -15, 30,
    -58, -43, 5, -4, -17, 14, -9, -26,
    -28, -9, -4, -54, 6, 35, -15, 14,
    -2, -6, 20, 4, -31, 12, 18, 43,
    -32, 21, 35, 3, -2, 37, 27, -50,
    -11, -6, 23, 34, 2, 26, -7, 35,
    23, 38, -22, -31, -8, 18, 35, 10,
    45, -16, 17, 10, -10, 93, -6, -110,
    -42, -20, -17, 4, 0, -4, 29, -27,
    43, 2, 0, -24, 0, 7, -11, 33,
    -4, -5, -21, 35, -18, 29, -2, -33,
    4, -1, 0, -11, 34, -24, 2, 48,
    -29, 30, -8, -45, -64, 28, 37, 4,
    15, 0, 74, 25, -3, -9, -21, -32,
    39, -46, -19, -67, 0, -10, -39, -6,
    -10, -20, 44, 1, 38, -23, 38, -2,
    2, -106, 20, 55, -2, -41, 24, 13,
    -38, 17, -70, -8, 14, -8, -10, 0,
    -20, 54, -14, 54, 53, 18, 4, 55,
    -44, 65, -6, 7, 24, 11, -54, 24,
    -14, -8, 56, -14, 20, 109, 31, -33,
    35, 29, -32, 0, -8, 25, 1, 2,
    -13, 28, 39, 5, -7, -15, 61, -6,
    -8, 0, 15, -35, -7, -62, 10, 21,
    74, -6, -35, -74, -50, 37, 20, -38,
    -43, -4, -10, 63, -8, -47, 1, -18,
    72, 39, -28, -44, 41, -17, 7, -7,
    -20, -45, 37, -14, -34, 48, 114, -14,
    10, -5, 0, 4, 9, -19, -45, 4,
    -2, 17, -8, 14, 6, -1, -2, 22,
    4, -1, 8, -28, -35, -2, -15, 40,
    -1, 14, -39, -22, 34, -1, 22, -1,
    44, -2, 35, 65, -2, -19, 50, 25,
    -1, -40, -22, 49, 43, 16, -46, 6,
    -29, -47, -45, -33, -36, -34, -2, 23,
    -55, -24, 22, -7, -38, -10, -34, 48,
    -36, 15, -29, -39, -59, -5, 12, 27,
    49, 14, 20, 18, 4, 23, -37, -29,
    -11, 19, 12, -15, 91, 38, 20, 21,
    -62, 14, -14, 3, -13, 47, 4, 7,
    2, 27, 37, -11, 35, -11, -8, 0,
    -16, 28, -19, 15, 33, 21, 27, 3,
    27, 5, 56, 6, 4, -36, -34, -21,
    -26, 37, -70, 14, -72, 59, -13, 18,
    -23, -26, 5, -47, 46, 32, 59, -42,
    20, -18, -31, -41, 16, -15, -13, -51,
    -16, -26, 1, -18, -4, 18, -27, 14,
    -29, 30, -20, -2, -58, -20, -26, 3,
    -13, -2, -1, -21, -12, -1, -41, -7,
    -50, -9, -9, 0, 10, 21, -1, 7,
    54, -12, 53, 2, 3, -53, 30, 31,
    45, 44, -22, -12, 100, -73, 2, 10,
    52, -57, -9, -9, -21, -17, 1, 48,
    -59, -9, 22, -29, -51, -7, -7, -9,
    29, -4, 13, -17, -5, 21, -3, 7,
    25, 9, -4, -44, -18, -26, -83, -33,
    -42, -3, -22, -6, -25, 3, -7, 44,
    11, 12, -27, -29, -18, 3, 10, -10,
    -42, 31, -6, -80, 43, 13, 14, 16,
    3, -36, 3, 10, 10, -46, -19, -15,
    -88, -23, -15, 82, 66, -26, 55, -8,
    65, -20, 80, 49, -41, -9, -6, -9,
    -13, 10, -28, 27, -3, -26, -24, -38,
    -12, -20, 14, -5, 41, 54, 4, -16,
    -48, -27, -17, -1, -7, -28, -33, -28,
    32, 49, 33, 5, -49, 3, -46, 10,
    15, 6, -24, -5, 53, -17, 24, 29,
    25, 1, 5, 40, 13, 38, -15, 45,
    -114, 9, -17, 7, -77, -15, -6, -5,
    -7, 20, 48, -6, -14, 6, 2, 80,
    39, -4, 16, -20, 22, -3, -47, -50,
    -48, -28, 9, 20, -32, 12, 7, -36,
    -81, -5, 3, 55, 27, -11, -11, 46,
    26, -17, -9, -11, -57, 11, 16, 22,
    -11, 5, -105, 12, 23, -21, 31, -38,
    -29, -13, -17, 6, 6, -6, 20, -32,
    -18, 24, 67, -7, -46, -15, 70, 8,
    -28, 44, 20, -46, -3, 31, 15, 10,
    22, -10, 19, 22, 16, 39, -16, -19,
    55, 11, -8, -37, 11, -57, -14, 9,
    37, -38, -13, 15, 25, -26, 76, -33,
    -41, 54, -12, -21, -54, -24, -1, 27,
    55, -17, 41, 34, 6, -6, -30, 55,
    52, -4, -16, 1, 17, -1, -82, -24,
    31, 14, -3, 68, 7, -33, -38, -26,
    -23, 52, 10, -16, -2, 16, -15, -9,
    -3, -44, 13, 23, -9, -30, 8, 92,
    27, -12, 16, -4, -29, -52, 45, 41,
    -5, -63, -64, -26, -36, -34, -89, 7,
    -13, 41, -14, 1, -46, -45, 39, 19,
    0, 9, 30, 52, -12, 24, 32, 31,
    -5, 63, 12, -41, 14, -1, -39, -5,
    10, -17, 7, -38, -12, 41, -81, 58,
    4, -90, -66, -19, -7, 11, -27, 17,
    8, 70, 7, -27, 11, -4, 11, 54,
    37, 40, -28, 23, 52, 19, -9, -28,
    -102, 27, 21, -6, -35, 12, -33, -58,
    8, 37, 1, 65, -39, 27, 30, 8,
    28, -65, -48, -7, 22, -11, -44, 7,
    22, -21, -5, -40, -20, 2, -13, -22,
    -51, -60, -26, 24, 39, -40, -52, 51,
    12, 17, -6, -14, -61, -63, -66, -63,
    34, 0, -2, 7, 30, -24, -23, 16,
    31, 13, -22, -30, 48, 81, 7, 9,
    -39, 31, 56, -45, 3, 35, 20, -43,
    11, -8, -73, 86, 0, 37, -19, -2,
    17, -40, 54, 4, -53, 29, -5, -20,
    3, -16, -6, 9, 37, -57, -3, 1,
    46, 7, 19, 93, -68, 13, 59, 8,
    -35, -42, 31, 17, 26, 46, 0, 50,
    67, 47, -38, 40, -7, 28, 1, -36,
    -109, 15, 5, -10, 44, -41, -91, 7,
    1, 18, 3, -58, -21, 10, -15, 25,
    19, 46, 2, 12, -5, 17, 7, 31,
    -3, -36, 10, -70, -15, 6, -6, 10,
    9, 26, 41, 22, 17, 34, 14, -61,
    15, -15, 24, 22, -89, 32, -54, 16,
    -14, -4, 8, -8, 62, 26, 35, 11,
    24, -48, -29, 21, 55, -27, 39, 4,
    14, -14, 25, -15, -10, 9, 9, 13,
    103, 26, -6, -40, -47, -22, 21, -82,
    -29, 14, -1, -3, -19, -26, -1, 3,
    2, 4, 8, 6, 26, -31, -49, -25,
    -69, 23, 15, 10, -11, -25, 16, -11,
    -45, 50, -59, -54, 5, 69, -3, 8,
    -7, -46, 7, -110, -41, 15, -32, -42,
    66, 19, -13, 77, 60, -26, 33, -10,
    -33, 12, 19, 31, 46, -8, 68, -7,
    -10, -39, 76, -32, 39, -56, -18, -43,
    67, 9, 34, 11, -23, 20, 4, -39,
    -35, -5, 12, -59, 25, 9, 20, 22,
    -5, 19, -30, -6, -2, -22, 67, 9,
    -43, 33, 72, -13, -26, 44, 68, 60,
    46, 47, -5, 9, 9, 36, -28, 94,
    2, 43, -12, -51, -31, -43, 8, 100,
    11, 16, 6, -22, -9, 49, -5, -14,
    10, 11, -22, -6, -16, 10, 12, -17,
    19, 4, 11, 12, -6, 1, -36, -10,
    -5, -25, -20, 12, -2, 23, 3, -4,
    -16, -3, -16, 21, -17, 6, -32, 36,
    -21, 6, -16, 27, 12, -14, -7, -14,
    13, -23, 26, -12, 14, -13, -25, 27,
    13, 11, 0, -8, -2, -16, 0, -29,
    -3, 8, 20, -14, 5, -21, -24, -13,
    14, 13, 12, 18, -3, -9, 1, 1,
    22, -27, -16, -14, 39, -14, 18, -6,
    14, -17, 30, 0, 1, -6, 30, -14,
    16, 19, 8, -2, 2, -3, 28, -26,
    41, -7, 23, -22, -19, 15, -6, 9,
    -15, 15, 1, 15, -34, -1, 24, -2,
    -8, 7, 4, 0, 9, -8, 1, -13,
    -4, 12, -8, -38, -33, 21, -30, -26,
    1, 29, -41, 26, 11, -3, -22, 0,
    0, 9, 3, 5, 17, 13, -4, -5,
    4, 21, -25, -10, 6, 18, -2, 7,
    -16, -7, 21, 37, 26, -2, -1, 59,
    15, -6, 18, -16, 4, -6, 31, 17,
    26, 25, -16, 12, -4, 4, 25, 10,
    -2, 0, -17, 76, 0, 1, 13, -41,
    1, -26, -22, 26, -1, -26, 2, -19,
    4, 0, -11, -16, -10, 21, 0, -31,
    9, 17, 4, 33, -12, 27, 22, -15,
    28, -2, -10, 14, -11, -14, 29, 18,
    -1, 22, 6, -40, 15, 3, 37, 11,
    -38, 27, 10, 8, -21, 4, -10, 26,
    18, -1, 1, 1, -8, -12, 8, 11,
    26, 15, 17, -13, -29, -8, -10, -2,
    -39, -23, 1, 8, -8, -2, -9, 25,
    -6, -4, -4, 37, 12, 55, 7, -3,
    -16, -12, 23, -11, 0, 37, 10, 20,
    -33, -12, 8, 17, 13, -6, 20, 5,
    -2, -6, 3, -9, -17, -11, -39, -41,
    -1, 28, -8, -25, 3, 33, 28, 28,
    25, -14, -36, -2, -2, 3, 5, 1,
    -19, -15, 6, -16, 10, -7, 3, 14,
    -13, 12, -6, 8, -4, -12, -4, -8,
    17, -30, 9, 19, 26, 12, 12, 12,
    2, -2, -17, -12, 9, -8, 25, -4,
    -37, -25, 12, 31, -3, -11, -14, 13,
    -4, -10, 6, -8, -22, 17, 3, 2,
    -27, -4, -17, -3, -10, -23, 14, -5,
    -30, 22, -12, -18, 7, -34, -26, 1,
    23, -1, 6, 7, -14, -24, -15, -12,
    12, -4, -6, 6, 4, 15, -21, 10,
    -18, 38, 11, 39, 12, 5, -9, -13,
    9, -32, 13, 36, -40, 8, 3, 7,
    38, 17, 7, 26, -22, 25, -5, 9,
    -1, 11, 4, 5, 22, 9, -12, -20,
    30, -31, 11, -7, -3, 1, 21, -13,
    54, -24, 3, -10, 16, 10, 25, -48,
    -31, 17, -2, -17, 4, -20, -22, -21,
    2, 20, 17, 18, -2, 30, 7, -11,
    -4, -7, -2, -3, 37, -14, -21, -7,
    17, -20, 24, -19, -8, 19, 12, 8,
    6, -7, 47, 36, 3, -9, -9, -3,
    8, 9, -18, 7, 15, -11, -6, 17,
    4, -14, 38, -19, -2, 46, -15, 21,
    10, 25, 3, 22, 0, 7, 22, -7,
    10, 20, 11, 19, -13, -16, -5, 7,
    42, 14, 15, -10, 43, 1, -17, -20,
    16, 4, -1, 25, 13, -1, 16, 10,
    18, 13, 0, 36, 21, 9, -8, -25,
    10, -12, 22, -8, 41, -5, 7, -33,
    17, -15, -10, -43, 5, 41, -5, -21,
    14, 7, 10, 15, 26, -34, -3, 20,
    5, 14, -11, -13, 13, -4, -8, 6,
    14, 8, 2, 4, 9, 0, 3, 8,
    8, 23, 1, 1, -29, -19, -16, 6,
    -10, 4, 13, 20, 3, -24, -3, 11,
    7, 0, 12, 29, -58, -19, 0, -16,
    17, -17, 23, -19, -4, -15, -19, -17,
    2, -7, -4, -21, -38, -14, 9, 7,
    15, 0, 15, -17, 1, -6, -16, 8,
    19, 7, 1, 25, 8, 9, 5, 13,
    -11, 19, -5, 7, 2, 10, 8, 0,
    -24, 13, -20, 29, -32, 22, 6, 19,
    2, 33, -18, 26, 14, 15, -10, 15,
    -33, 0, -38, -32, -10, -1, 5, 22,
    71, 21, 9, 72, 15, 17, 13, 5,
    13, -12, -22, -10, 28, -27, 13, -18,
    -21, -16, 4, -60, -9, -3, -9, 17,
    11, -15, 3, -20, -8, 7, 12, -8,
    -10, 18, -28, 8, -3, -28, -8, 15,
    -13, -3, -31, -45, 12, 29, -34, -61,
    -20, 18, 5, 18, -10, -3, 8, 7,
    -20, 10, -25, -17, -9, -38, -8, -5,
    4, -31, 38, -10, 6, -25, -8, -34,
    -2, 20, -10, -1, -18, -14, 8, -36,
    27, -8, 11, -19, 6, -5, -7, -7,
    -25, -17, -42, -8, 19, -15, -31, -10,
    14, 9, 6, -1, 0, 5, 21, -4,
    -19, 14, 29, -15, 41, 23, -4, 12,
    23, 21, 4, -9, -33, -28, -23, -2,
    -6, -24, -16, -46, 6, 11, 18, 17,
    -7, -2, -3, -14, -13, 30, 19, 6,
    15, 15, -5, -17, 6, 14, -2, -15,
    -42, -7, 2, -23, 0, 15, -22, 23,
    21, -20, -6, -12, -27, 22, 15, 5,
    -28, -1, 2, 10, 9, 6, -4, -8,
    -8, -36, -18, 5, -25, -36, 19, 29,
    0, -4, 18, -3, -22, -20, 3, 47,
    8, -6, 13, -11, -10, 47, 6, 17,
    -44, 27, -5, 45, -3, 3, -20, 17,
    -27, -37, -24, -23, -23, -2, -16, -40,
    -12, 14, -9, 32, -4, 38, -15, 39,
    -14, -14, 19, 9, 4, -44, -18, 26,
    29, 10, -56, -41, 14, 4, 11, -17,
    -9, 20, 8, -24, 42, 2, 16, -1,
    -3, 12, 0, -4, -13, 3, 1, 15,
    12, 33, -1, -6, -12, -19, -11, -6,
    -39, 6, -23, 9, 10, 17, 1, 1,
    -10, -2, 1, 32, 24, -20, -12, 16,
    -14, -15, 5, -7, -8, 18, 23, -18,
    53, -4, 0, -14, 6, -23, -6, -3,
    15, 55, -24, 0, 20, 10, -23, -9,
    -8, 10, -41, -26, 3, 44, 4, 11,
    7, -19, -13, 5, 9, 6, 30, 26,
    28, 17, -4, 18, 2, 21, -32, -29,
    17, -39, 4, 1, -1, -32, 19, -12,
    -10, -33, 0, 15, -7, -10, 35, 5,
    9, -16, 26, 7, -2, -3, -13, -19,
    8, -12, 23, 60, -21, 14, 29, -37,
    -24, -6, -27, -1, -3, -25, -30, 12,
    -10, -29, -19, -12, 10, 14, -19, -6,
    -21, 58, -11, -51, -35, -6, 11, -21,
    8, -56, -20, -24, -22, -32, -21, -20,
    30, -22, 8, -1, -9, 18, -5, -14,
    24, -10, -22, 8, 1, -3, -11, 10,
    -45, -2, -28, -19, -22, -1, 7, -10,
    34, 12, 29, -19, 21, -9, 1, -3,
    16, -2, -14, 16, -12, -13, 35, 0,
    13, 9, 8, -15, 4, 27, -20, -5,
    -38, -36, 14, 3, 3, -15, -3, -10,
    37, 4, -14, -9, 34, -12, -40, -15,
    -20, 19, -37, -9, 20, 4, -2, 15,
    17, -6, 33, 7, -11, 37, 16, -21,
    -17, -19, 11, 6, 12, -33, -3, -19,
    3, 18, 16, 20, -9, 29, -6, -13,
    10, -22, 21, 10, 14, 11, 23, 3,
    40, -44, -30, 28, 10, 21, 3, -13,
    -1, 7, 12, 3, -9, 13, -34, 5,
    -1, -17, 2, -38, -10, -11, 19, -38,
    -9, -21, -1, 29, -4, 19, -12, 4,
    -5, -21, -20, 25, 5, -21, 21, 2,
    40, -53, -16, -7, -1, 3, -24, 3,
    -31, 6, 18, -7, 6, 31, 13, 42,
    -9, -21, 4, 12, 16, -14, 5, -55,
    -30, 46, 24, 17, 9, 16, -11, -10,
    34, 10, -55, -5, -14, -45, -26, 11,
    8, 1, 3, -20, 8, 20, -14, 14,
    5, -21, 13, -15, -9, -5, 0, -10,
    -51, 18, 3, 3, -14, -16, 12, 1,
    -58, 45, -5, 43, -20, 31, 30, 15,
    -6, 20, -25, -17, 36, -4, -6, -58,
    -22, -5, 20, -6, 38, -27, 4, 9,
    34, 31, -25, 13, 0, 12, -3, -7,
    1, 10, 41, 2, 1, 24, -31, 15,
    32, 3, -37, -13, -7, 26, 37, 16,
    9, -12, 30, 3, 3, -17, 1, 18,
    -4, 41, -27, 17, 16, -3, 4, -3,
    -25, -23, 12, -3, -3, 0, -11, -17,
    4, 1, 17, 17, 14, 11, -49, -30,
    14, -36, -36, -9, 1, -21, -7, 27,
    -36, -9, 12, 9, -15, 7, -3, 10,
    -17, 29, -22, -11, 32, 18, 2, 37,
    -1, -10, -27, 15, 40, 0, -7, 23,
    0, 16, -3, 6, -2, 11, -7, -14,
    -9, -43, 11, 2, -14, 21, -12, -2,
    -44, -24, 2, -7, -23, 27, 1, -13,
    -1, 64, 2, -33, 50, 24, -44, -50,
    -36, -39, -19, 20, -59, 42, -21, -48,
    -4, 23, 14, -7, -14, -12, -33, -6,
    15, 48, -15, 29, 23, 9, 17, 11,
    -5, -45, 13, 44, -8, -27, 5, -18,
    -26, -17, -2, 4, 1, 11, -17, 14,
    -48, -36, 28, -7, 12, 5, -26, 5,
    -17, -17, 9, -26, 24, 16, 12, 18,
    15, 24, 14, -7, -26, -42, -45, -28,
    5, -8, 6, 4, 9, 31, 22, 13,
    -23, -3, -24, 53, -20, -5, 7, -3,
    -15, 10, -30, 27, 21, 10, -7, 1,
    2, 25, -30, -9, 5, -7, -8, -20,
    -16, 5, -28, 4, -31, 8, 5, 0,
    24, -16, 17, -41, 21, -4, -10, 6,
    -19, 16, 33, 22, -12, 12, -7, 1,
    41, 2, -12, -10, -16, -11, 29, -19,
    55, -54, 31, -65, 24, 21, 16, -1,
    -57, 13, -21, 22, 7, -4, -12, 27,
    -8, 6, -22, -32, -12, 3, 19, -16,
    -37, -5, -28, -16, -11, 0, 16, -12,
    -32, -5, 1, 30, -67, -6, -13, 36,
    0, -18, -1, -26, 5, -14, 39, -12,
    23, -10, 22, 51, 2, -10, -19, 23,
    14, 10, -9, 18, 5, 5, -30, -9,
    25, -28, 10, 20, -22, 16, 51, 26,
    3, 9, -16, -16, -16, 11, -14, 1,
    5, -44, 14, 24, -3, -19, -9, -35,
    -67, -7, 15, 10, 50, -1, 7, -11,
    -15, 53, 6, 13, -15, 25, -32, 0,
    -45, 29, -19, -49, -25, -11, 1, -12,
    24, 33, 19, 22, 12, -34, 8, -7,
    18, 40, 21, 10, 26, 22, -1, 11,
    -30, 36, 4, -6, -13, -29, -6, -2,
    6, -16, 45, 14, -28, -2, 9, -13,
    -4, -28, 24, 16, -14, -19, -4, 2,
    -7, 10, 30, 11, -35, -27, -68, -8,
    -30, -29, 15, -25, 61, 6, -6, -37,
    15, 2, 16, 24, 17, -32, -8, -3,
    17, -10, -1, -29, 32, 2, -12, -5,
    -55, 20, 17, 30, 4, 42, 52, -21,
    -32, -12, 10, 9, -4, -7, 16, -61,
    -9, -43, 24, 4, 18, 6, -28, 2,
    11, 25, -27, 26, -19, -17, 2, -16,
    4, 6, 3, 43, -20, 32, 3, -1,
    25, -18, 15, 35, 8, -29, 20, 23,
    32, -15, 10, 14, -4, -12, 23, 4,
    22, 0, 55, -61, 29, -19, 28, 27,
    10, 45, 27, 0, 7, -52, -26, 74,
    27, -14, 31, 54, 3, -30, 5, -7,
    -34, -35, -40, 10, 5, -12, 1, 6,
    5, 22, 14, -10, 4, 28, -21, -5,
    11, -4, -48, 12, 0, 31, 41, 14,
    13, 20, -11, 8, -29, 43, 2, 0,
    -8, 12, 3, -19, -4, -31, 10, 18,
    -2, -10, 14, -3, 7, -5, -10, -3,
    -49, -28, 9, 0, 9, 29, -26, 21,
    0, 13, 20, -3, -7, 8, -15, 9,
    -12, -36, -11, -27, -23, -38, 28, 11,
    -15, -5, 6, 21, -1, -7, 0, 34,
    31, -12, 18, -6, 10, 54, -34, 0,
    -13, -3, -25, -35, -4, 1, 2, -10,
    2, -26, -13, -26, -10, -7, -25, -49,
    20, 2, 59, 44, 11, -9, 7, 1,
    -32, -20, -15, 1, 14, -38, 0, -6,
    -1, -46, -2, 2, -3, 2, 8, -14,
    -23, -22, -7, 26, 4, 9, 20, 3,
    -20, -25, -15, 17, 22, -3, -5, 6,
    -23, -23, 10, -15, 70, 16, 22, -2,
    -7, 8, -17, 9, -27, -45, -1, -9,
    24, -45, -20, 11, -40, -2, 10, 3,
    -8, -32, -40, -15, -10, -3, 8, -13,
    -34, 61, 11, -3, -32, -10, -51, 0,
    -9, -17, -6, -11, -39, 1, 39, 8,
    30, 23, -34, -9, 7, 11, 18, -10,
    41, -13, 47, -35, -8, -2, 16, -20,
    36, -13, -31, -5, 33, -1, 27, -47,
    1, 7, 16, -17, -21, -33, -13, -22,
    1, -16, 18, -34, -3, 1, 32, -17,
    2, 56, -10, 0, 1, -3, -22, 27,
    21, 48, 78, 41, -12, 15, -17, 10,
    -12, -19, -2, 5, 8, 16, -68, 19,
    -58, 56, 4, -47, -7, -42, -27, 26,
    -26, -27, -12, -21, 27, -10, 16, -54,
    23, 19, -15, -23, 4, -24, -2, 13,
    50, 47, 64, -58, 81, -14, -16, 55,
    3, 7, 18, -61, 43, 29, 31, 8,
    53, -22, -27, 31, -39, -4, 9, 12,
    -76, 44, -24, -30, -40, -36, 46, 33,
    16, 3, -23, -51, -11, -43, 47, 56,
    -14, -21, 17, -12, 14, -35, 50, -28,
    35, 27, -74, 1, -3, 2, -47, -16,
    -48, 49, 31, 9, 18, -50, -10, -9,
    -33, -14, -31, -17, -8, -10, -30, 8,
    -26, 5, -27, -44, -25, 48, 11, 14,
    -59, 38, -6, 25, 6, 65, -2, 45,
    35, -15, -62, -31, 52, 26, -21, 19,
    -26, 62, 6, -3, -8, 26, -14, -24,
    9, -45, 7, -27, 6, 9, -48, -24,
    -11, 2, 35, -39, -24, 21, -40, 5,
    -50, -79, 64, -27, -45, 3, 34, 8,
    51, -58, -2, 4, -29, -34, 17, 34,
    -35, -16, -19, -70, 26, -5, 13, -127,
    -20, -107, -15, -12, -3, 20, 8, 19,
    6, 16, 20, 30, 41, -5, -17, -9,
    -53, -4, 31, 4, -20, -23, -1, 22,
    -23, -55, 13, -29, 15, 39, -26, -37,
    -33, -47, -18, 58, -45, -41, -4, 11,
    35, 42, 18, -30, 19, -43, -58, 16,
    -57, -33, -37, -79, 12, 18, -20, 0,
    -17, 14, -79, 69, -29, 5, 2, 16,
    44, 40, -12, -90, 19, -82, 6, 20,
    17, -2, -21, 8, -13, -32, 44, 71,
    -14, -20, -2, 48, -16, -9, -11, -56,
    28, 22, -20, 7, -32, 6, -1, -57,
    23, 2, -19, -70, 5, -36, 19, 24,
    -16, 69, -3, 53, -48, -5, 0, -20,
    76, 39, 13, -49, -59, 16, 26, -28,
    45, 10, -9, -34, 24, 16, 8, 35,
    31, 0, 30, 8, 15, 22, -2, -16,
    -36, 66, 37, 1, -52, -3, -96, -12,
    -75, 17, -29, -8, 30, 31, -30, -41,
    23, 28, 34, -37, -24, 0, 12, 16,
    6, 66, -51, -23, -13, 36, -32, 13,
    64, -28, 40, 21, 23, 5, -45, 30,
    56, 70, 25, -12, -15, 14, 6, -15,
    -6, 50, 56, 64, 20, -13, -20, 16,
    26, 49, 26, 16, 45, 3, -34, 20,
    30, 7, 39, 55, -8, -9, 6, 28,
    34, 84, 15, -39, 24, 6, 15, 74,
    0, 16, -36, -7, 21, -11, 48, -16,
    18, 31, -8, -22, -27, -2, 3, 14,
    -8, 45, 57, 28, 44, -1, -85, -9,
    -17, 32, -42, -6, -9, -32, -108, -21,
    27, 28, 47, -27, -24, -2, 27, 15,
    -45, -7, -44, 75, -25, -23, -36, 30,
    -46, 29, -21, -19, 42, 35, -8, 47,
    8, -21, 4, -34, 4, -42, -16, -58,
    38, -29, 26, 4, -19, -4, 2, 15,
    -10, -33, 20, 5, 19, 29, 44, -20,
    -29, 8, 2, -23, -46, 13, 24, 17,
    6, -12, -1, -34, 37, 18, 33, 22,
    -7, 3, 23, 13, 34, -69, -6, 5,
    -20, 53, -8, -6, -44, -30, 2, 38,
    16, 27, -36, -9, 2, 7, -26, -12,
    -33, -22, 49, 75, 14, 17, 8, 41,
    5, 14, 20, 37, -87, 1, -33, 67,
    24, 3, -10, 36, 38, 2, 53, -14,
    3, 2, 40, -8, -36, -28, -16, -86,
    -4, 10, -20, -109, 47, -13, -46, -9,
    -44, 89, -14, -42, -9, -10, 31, -36,
    -16, 38, 4, 21, 10, 36, 14, 1,
    13, 3, 5, -9, 29, 3, -47, 5,
    27, -13, 43, -6, -14, -4, 16, 6,
    -36, -4, -33, 14, -10, 13, -31, -9,
    23, 106, 13, -47, 22, 24, -22, -39,
    38, -32, 19, 40, -29, 28, -2, -35,
    17, 47, 33, -9, 61, -14, -102, 22,
    49, 53, -1, -35, -49, 7, -10, -22,
    26, -5, -30, 37, -62, 12, -27, -35,
    37, 19, -13, 19, -68, -5, 0, -1,
    -32, -12, -61, -20, 36, 13, 16, 29,
    -15, -12, -32, 23, 32, -17, 18, -28,
    -47, 11, 3, -21, 53, -20, -36, -2,
    17, 56, 74, 14, -22, -5, 5, 50,
    18, 7, -38, -34, -35, -3, -7, 75,
    81, -16, 88, 13, -31, -22, 8, -12,
    18, -45, 25, 39, 16, 41, 49, 22,
    4, 40, 37, -13, -13, 66, -5, 1,
    60, -41, 0, 39, 4, 9, -5, 18,
    14, 50, 36, -30, 2, -78, -1, 83,
    -7, -91, -3, 15, 1, -8, 16, -17,
    29, -40, -50, -33, -5, 86, 8, -3,
    -41, 2, -3, -75, -38, 4, -1, 12,
    19, -7, -38, -7, 7, 2, -20, -20,
    -34, -20, -98, 10, -70, -3, -48, 0,
    -37, -47, 11, -17, -45, 13, 46, 67,
    -48, 10, 3, -16, -37, 53, -28, 15,
    42, 8, -53, -5, -22, 7, -32, -24,
    -6, 42, 10, -58, 43, -2, 17, 11,
    67, 20, -23, 25, -57, 27, -20, 24,
    114, -4, 42, -10, -60, -43, -25, -37,
    -10, 31, -19, 11, -33, -39, -14, 19,
    30, -6, -5, -38, 45, -30, -9, -7,
    30, 55, 22, 8, -3, 12, 22, 7,
    61, 47, -2, 1, 39, 39, 17, -24,
    23, -4, -61, 12, 17, -18, 25, -36,
    23, 32, -14, -27, 27, 37, -66, -63,
    4, -10, -19, -15, 47, 82, -20, -51,
    15, -11, -16, -12, -6, 12, 14, -13,
    9, -13, 52, 15, -54, 56, 31, 38,
    27, -27, 12, -16, 15, 2, 15, 10,
    -15, 20, 1, -26, -20, -42, 47, -23,
    7, 17, 68, 33, -31, 29, 60, 33,
    65, -18, 6, 24, -11, -33, 10, 6,
    -31, 10, 11, 18, 30, -14, 22, -13,
    -12, 16, 20, 36, -26, -16, -8, -3,
    6, 78, -8, 1, -16, 17, -2, -4,
    -5, -18, 5, -8, -52, 44, 66, -6,
    -8, 48, -55, 15, 0, -2, 13, 38,
    34, 43, 5, -46, -22, 13, 2, -33,
    43, 4, 48, 23, 25, 25, -11, -9,
    2, 12, 70, 18, -37, -50, 10, 12,
    23, -10, -4, -32, -3, -66, -22, 4,
    -33, 46, -15, -10, -19, 35, 15, -14,
    -24, 39, -40, -17, 8, 3, 52, 21,
    57, 72, 44, 42, -37, 26, -35, -17,
    7, 26, -25, 5, -14, -47, -10, 61,
    -41, 53, -31, -31, 31, 17, 11, -52,
    -34, 12, -25, -24, -13, 36, -8, -24,
    3, 41, -4, -21, -15, -8, 31, 26,
    -30, -2, -1, 4, -5, 11, -4, -15,
    -3, -9, -11, -6, -23, -14, 6, -4,
    14, 38, -4, 9, 8, -12, 7, 10,
    2, -29, -13, 13, -20, 20, -13, -8,
    4, -22, -6, 3, -19, 6, -22, -10,
    9, -8, -25, -3, -4, -14, -1, 11,
    5, -11, 15, 15, -9, 21, -4, -23,
    6, 4, 12, 22, 22, -13, -41, 3,
    5, -10, -29, 1, -12, -12, -2, 6,
    18, 1, 46, -11, 2, -15, -3, 28,
    -13, 8, -8, 16, 7, 2, 2, 26,
    -9, 1, -1, -21, -8, 4, -3, -27,
    -19, -15, 19, -6, -6, -13, 3, 5,
    3, 4, 17, 9, -5, -7, -7, 17,
    -9, -5, 9, 5, -4, -21, 13, -1,
    17, 9, -7, 19, 12, 30, -9, 18,
    12, -14, -4, -10, 16, -4, -16, -15,
    -10, 7, -5, 23, 15, -6, 0, 17,
    -7, -8, -9, -14, 3, -3, 9, -4,
    0, -8, 4, 15, 17, 7, -9, 9,
    10, -8, 4, -11, -3, -3, 5, 5,
    4, 6, -4, 30, 10, -18, 14, 32,
    10, 3, 7, -2, 38, -3, 1, -2,
    4, 3, -8, 2, 2, 26, 4, -1,
    9, 18, -7, -3, -11, -18, 18, 4,
    -29, 35, 26, -7, -6, -7, 9, -2,
    13, 2, -11, 3, -18, 12, -1, 4,
    3, 4, -8, 5, 12, -19, 10, -29,
    6, -3, -4, 3, -9, -16, 12, 9,
    28, -19, 16, -1, -15, -19, -7, 15,
    17, 10, -12, -33, 17, -10, 19, -50,
    10, -17, 18, -21, -16, -17, 1, 16,
    -11, 18, -4, -1, 1, 21, 3, -11,
    3, 15, -31, -14, 2, -9, 15, 3,
    13, 46, 30, 7, -14, -16, -13, 1,
    -25, 4, 6, 8, -26, -12, -28, -35,
    1, -8, -28, -5, -5, -7, -1, 18,
    6, 31, 24, -9, -1, -6, 7, 7,
    -5, -5, 0, 5, 10, -1, -16, 13,
    9, -30, 6, 4, 3, 14, -1, 17,
    -13, 9, 11, 13, 4, 10, -21, 16,
    2, 0, 18, -4, -7, -5, 15, 7,
    -23, -16, -18, -15, -8, 43, 24, -15,
    4, -21, 7, 10, 5, -25, -18, -2,
    12, 14, -3, -21, -5, 3, -14, -3,
    17, -1, -9, 37, -3, 23, 11, 53,
    -30, -12, -12, -15, 12, -39, -10, -9,
    5, 4, -5, 3, -19, -7, -11, -6,
    25, 21, -17, -2, 11, 1, -8, 0,
    -2, -31, -9, 24, -2, 2, -2, 8,
    23, -27, -8, -6, 15, 32, 9, 20,
    20, -38, 6, -16, 8, 18, -30, 11,
    3, 8, 22, 8, -9, 4, -7, 5,
    12, -10, 9, -4, -1, -10, -7, 2,
    -14, -2, -3, -4, -11, 46, 1, 13,
    -10, -9, -6, 5, -21, 31, -15, -9,
    -9, -9, 6, 28, -18, -6, 0, 23,
    -33, -33, 27, 7, -15, -13, 4, -2,
    9, 13, -8, 17, -43, -3, 27, -13,
    29, -3, -5, -8, 15, -25, 29, 21,
    4, -12, 2, -28, -7, 10, 2, -1,
    -18, 31, 2, -32, -18, 7, -16, -8,
    40, 20, -2, -8, -1, 4, 10, 15,
    -1, -10, -23, -28, 13, 3, -1, -16,
    -27, -1, -35, 10, -10, 5, -3, -3,
    16, -8, -17, 1, -10, -10, -2, 13,
    12, 2, -1, 12, 24, 7, 18, -5,
    -15, -3, -5, 23, 6, -17, -15, 5,
    5, 2, -19, 1, 1, -16, 10, 13,
    -21, -13, -4, -33, 9, -16, 12, 19,
    11, -27, 16, -9, 14, 16, -17, -5,
    -18, -20, 5, 22, 6, 1, 10, 8,
    -2, 9, -9, 20, 0, -9, -6, 27,
    -18, -37, 3, 0, 12, -5, 0, 17,
    9, -25, -6, 5, 1, -19, -24, 5,
    12, -4, 0, -17, 5, -3, 42, -18,
    28, 16, 16, -31, 8, -10, 14, 16,
    28, -18, -15, -52, 16, 0, 2, 25,
    -29, 18, 14, -5, -10, -13, 45, 10,
    17, -17, 1, 17, -14, 17, -21, -27,
    -5, -5, 0, -6, -6, 2, 4, 15,
    -4, -29, 31, -5, 25, -8, 10, 9,
    -5, 14, 3, -10, 39, -5, -12, 21,
    -4, 2, -24, -24, 12, -14, -2, -26,
    -11, -12, 7, -8, 0, -3, -10, -19,
    -26, -39, -14, -14, 4, -4, 29, 2,
    8, 3, -9, -3, -28, -5, -22, 9,
    0, 17, -1, -13, 3, 3, 23, -10,
    -15, 26, 7, 24, 7, 2, 7, -8,
    -18, -20, -22, 27, -4, 2, 12, -1,
    22, 18, 3, 19, -13, -23, 3, -27,
    -23, 10, 11, -1, 7, 17, -20, -17,
    -2, 10, 5, -19, 9, -13, -2, -8,
    -2, 8, -25, -6, -11, 0, 20, -16,
    -4, -7, -9, -4, 66, 1, 11, -23,
    9, -11, 22, -13, -4, 5, 0, 13,
    39, 8, 20, 8, 8, -18, 10, 7,
    -1, -9, -4, -13, -1, 16, -3, -7,
    5, -8, 20, -21, 7, -12, 6, 34,
    1, -20, -1, -13, 16, 46, 9, 6,
    -3, 13, -27, -6, 2, 14, 3, 11,
    -12, 15, 4, 37, -2, -6, -13, 11,
    11, -5, -4, 20, -3, 32, -11, 3,
    7, -31, -14, 2, -4, -16, -10, -32,
    -10, -6, 0, -22, -12, 5, -2, -20,
    -12, -28, -14, -24, 0, 35, 20, -2,
    -6, -14, 1, 7, -5, 8, -6, -25,
    -42, 3, -6, 16, -12, 2, -13, -19,
    -14, -2, 26, 4, -6, -3, 14, -4,
    8, 16, 16, 23, -31, 10, -13, -31,
    3, 24, 11, -14, -14, 35, 8, 17,
    -20, -10, -2, 14, 6, 25, 3, -13,
    -8, -34, 11, 21, 8, 20, -2, 6,
    8, -43, 4, 16, -14, 1, -8, -10,
    -13, 19, -14, 11, -16, -5, 7, -1,
    16, -3, -2, 16, -29, -19, 16, -11,
    -15, 15, 13, 0, -9, 5, 3, -3,
    0, 24, -4, -9, -15, 4, 9, 3,
    -2, -11, 9, 8, 4, -29, -13, -22,
    -2, 15, -18, 14, 28, -3, -3, 2,
    -1, 9, 11, 15, -1, 17, 3, -1,
    14, 8, 38, 1, 15, 10, 9, 15,
    27, -1, 13, 4, -32, -5, -10, -47,
    -13, -22, 23, -2, 6, 6, 12, -8,
    2, -29, 15, 19, -4, 8, 15, 6,
    -7, 1, 11, -10, 18, -2, -34, 8,
    -4, -16, -4, -8, 9, 13, -45, 21,
    10, 43, 7, -7, 3, -17, 51, -36,
    29, -48, -20, -21, -1, -1, -1, -3,
    44, 68, -14, 47, 24, -23, 3, 21,
    14, -52, 3, 23, 53, 13, -2, -4,
    0, 7, -17, 14, -35, 7, -14, -5,
    26, -26, -18, 13, -9, 1, -10, -11,
    -13, -23, -19, 42, 17, 5, -17, 25,
    20, -4, -3, 8, -25, 13, -4, -13,
    13, -10, 8, 25, 11, 18, 73, 16,
    19, 18, -5, 2, -8, -15, -1, 9,
    0, -38, -26, -3, -10, -26, -32, 36,
    1, 5, 0, 34, -3, -4, 42, 23,
    4, -58, -2, -2, 0, -6, 65, -27,
    12, 4, 0, 35, -5, 2, 1, 1,
    7, -15, -55, -19, -12, -18, -20, -2,
    -24, 13, 22, 37, 3, -18, 27, -7,
    19, 22, -6, 1, 2, -28, -18, -6,
    18, 4, -30, 31, 7, 3, -2, -9,
    23, 14, 18, 1, -16, -39, 22, -11,
    40, 39, 10, -9, 8, 4, 12, 2,
    -19, 43, 17, -13, 8, -18, -21, 0,
    2, 0, 41, 19, 12, 2, -10, 12,
    -31, 21, -3, 20, -10, -15, 0, 4,
    -8, -14, 3, -26, 29, -2, -6, -6,
    6, -38, 6, -66, -25, -41, 7, -12,
    16, 41, -15, -9, -20, 5, 15, 7,
    17, -34, 13, 10, 6, -1, -11, 11,
    5, -33, 8, -14, -29, -10, 15, -24,
    -7, -22, -13, 14, -38, -16, -13, 11,
    8, -16, -1, 16, -4, 9, 23, -5,
    -20, 0, -5, -7, -11, 20, 12, 7,
    -84, -10, 34, -15, 16, -9, 18, -46,
    -22, 19, 26, 14, -15, -8, -33, 1,
    -24, 15, 39, 21, 9, 15, 2, 16,
    -3, 1, 4, 7, 23, 23, -3, -20,
    50, 10, 6, -23, 14, -4, -16, -4,
    -19, -25, -14, 7, 28, 10, 33, 14,
    -7, -2, -14, 21, 5, 4, 5, 7,
    -37, -1, 10, -17, 14, 8, -44, -30,
    -7, -37, 18, 14, 3, -5, -33, 42,
    7, 8, 8, -13, -24, 16, 5, 2,
    -6, 16, -1, -13, -1, 17, -5, 1,
    5, -11, -5, 23, -13, -22, 16, 15,
    53, 13, -25, -5, -74, 32, 11, -15,
    -35, 42, -6, -45, 8, -50, -19, 32,
    -3, 17, -28, -26, 8, 9, -22, -14,
    -41, 22, -5, 24, 12, 23, 9, -11,
    31, 27, -41, 17, -20, -44, 8, -22,
    -8, -10, -4, -9, 36, -21, -8, -7,
    -24, -5, -25, 12, -2, 4, -6, 3,
    -2, -44, 4, -18, 2, 10, 11, -17,
    17, -35, 6, -19, 43, 11, -19, -12,
    -28, -28, 0, 10, -18, 11, 18, 8,
    18, -21, -40, 12, -16, 6, 8, 0,
    -9, -45, 20, 59, 25, -9, 42, -29,
    -6, 4, 12, 22, -32, 76, 52, 69,
    22, -6, -16, -19, 47, -3, -14, 6,
    -37, -4, 6, 23, -13, -12, -7, 10,
    -11, 6, 15, -9, 47, -7, -8, -2,
    -1, 15, -6, 16, -62, 0, 14, -31,
    -17, 15, 25, -30, -16, 16, 6, -2,
    11, -32, 5, -7, -14, -1, 10, 11,
    -7, 25, 19, -11, 26, 21, -2, -18,
    -3, -43, -4, -4, 12, 7, -15, 4,
    -10, -3, -31, -25, -21, -4, -28, -1,
    -36, -3, -13, 4, 7, 5, 2, -13,
    1, -1, -3, 2, -2, -19, -15, -26,
    -12, -19, -10, -22, 30, -1, 26, 23,
    -8, 19, 26, 1, 34, -25, 3, 16,
    2, -29, -15, -24, -4, -4, 0, 9,
    4, -20, 22, 11, 1, -7, -6, -3,
    30, -11, 12, 11, 8, 11, 3, 9,
    -10, -27, -10, 19, -1, -33, -1, 28,
    5, -7, -9, -13, 17, -5, -14, 23,
    -15, 27, 2, 22, 25, 7, -12, 12,
    0, 37, -6, 11, 5, -2, -43, -9,
    -8, 37, 13, 16, -5, 3, -1, -6,
    18, 27, 31, -10, 27, -13, 14, 2,
    -48, -18, -4, -22, 21, -11, -16, 44,
    -13, -7, 8, 17, -32, -62, 40, 5,
    -46, -9, -10, -63, 77, 26, 10, 38,
    -26, -12, 24, 14, -8, 0, -3, 15,
    -53, -18, -26, -12, -28, -26, -10, -2,
    -10, 5, -39, -23, 38, 11, 27, -22,
    -20, -31, 7, -24, -1, 14, -7, -12,
    -32, -14, -22, -7, 12, 3, 4, -14,
    -13, -12, -13, 15, 0, -2, 17, 28,
    -69, -18, 35, -28, -18, -14, -38, -17,
    36, 25, -21, -29, 14, 11, -70, -21,
    4, -19, -11, 33, -13, 4, -15, -6,
    -17, -14, -15, -16, -41, -7, 7, 9,
    37, -9, 9, 33, -52, -49, -16, 3,
    20, 56, 13, -30, 31, 17, 0, -27,
    24, 52, 22, 15, -9, -4, 0, -8,
    -13, 26, -22, -7, 28, 54, -26, -4,
    14, -12, -24, 5, 45, 25, -28, -24,
    22, 27, 22, -25, -12, -20, 6, 12,
    -7, -15, 11, 17, -12, -19, -5, 1,
    3, -5, 20, -19, 33, -44, -15, -16,
    -11, -12, 7, 20, -4, 9, 11, 13,
    37, -3, -3, -5, -46, -7, 5, -10,
    26, 16, -9, -6, -6, 15, 6, 31,
    53, -15, 11, 11, 32, 3, 0, 5,
    10, -30, 2, -31, 32, 4, 5, -11,
    21, -37, -38, -12, 5, 1, 21, 23,
    -8, -10, 10, 8, 15, 19, 5, -5,
    16, -31, -26, -23, 16, 38, 25, -15,
    11, -20, 3, -37, -6, -17, 15, -16,
    7, -30, -18, 6, 11, -7, 18, 16,
    14, -19, -22, 3, -16, 9, 2, -2,
    26, -14, -25, -8, -68, -14, 14, 3,
    16, -14, -43, 18, -10, 51, 20, 17,
    23, 22, 2, 11, 19, -31, -5, 0,
    -3, 19, 7, 4, 19, -1, -1, 21,
    -25, 4, -1, 9, -41, 20, -15, -6,
    -14, 12, -13, 5, 46, -15, 6, -5,
    6, 22, -10, 31, 52, 6, 4, 44,
    -18, -6, 25, 37, -15, 0, -28, -29,
    5, 21, 16, 17, 19, 24, -12, 1,
    -31, 14, -7, 34, 9, -8, -2, 18,
    -24, 31, -2, -33, 12, 4, 22, -12,
    0, 30, -28, -13, -9, 0, 11, 2,
    -38, 15, -35, -26, 8, 32, -16, -5,
    0, -2, -13, -14, -60, 9, -13, -53,
    12, -14, 34, 20, -9, 20, -28, 2,
    -10, -9, 24, 15, -22, 5, 17, 8,
    -4, -14, -37, 46, 0, -29, -42, 34,
    -21, -17, 27, -18, -8, 18, -31, 39,
    -39, -43, 23, 67, 12, 21, 64, -15,
    -33, 14, 6, -21, 16, -8, -3, 74,
    18, 54, -30, 26, 41, -37, -29, 10,
    -51, -27, 26, 6, 77, -10, 10, 20,
    -8, 5, 35, -1, 10, 0, 1, 39,
    -38, 25, 40, 50, -16, -4, 45, -3,
    5, -57, -57, 34, 31, -4, -17, 27,
    -32, -1, 88, -46, -29, -21, -4, 23,
    -46, -31, -12, 4, -17, -25, -19, 5,
    -13, 25, 13, -10, 1, -65, -4, -15,
    8, 27, -42, -29, -16, -71, 5, 46,
    -17, -11, 23, -2, -6, 7, 17, 17,
    91, 38, 50, 25, 14, 43, -98, 22,
    0, -14, -11, -38, -10, 32, -9, 5,
    0, 5, 69, -45, -2, -18, 15, 16,
    -1, 14, -13, -16, -20, -24, -1, 47,
    -42, 26, 1, -24, -28, -27, -4, 48,
    -27, 42, 34, -11, -35, 30, 7, 34,
    -26, -30, 69, -6, -3, -21, 15, -35,
    -13, -24, 6, 11, 7, 10, 12, 5,
    -13, 79, -43, -10, 38, 20, 48, -5,
    20, 20, -8, 54, -28, -9, -46, 12,
    -19, 17, -15, 1, -23, -9, 34, -59,
    11, -9, -26, 30, 45, -28, -33, 2,
    -44, 56, -17, -19, -24, 5, -54, 1,
    -24, -62, 56, -15, -6, -29, 0, 5,
    -59, -70, -54, 23, -23, -10, -3, -15,
    -25, 56, 25, -16, -74, -55, 13, 8,
    33, -20, 4, -43, 9, -6, -10, 9,
    4, -38, 53, 17, 34, -2, 46, 9,
    43, -10, 21, 10, -9, 26, -15, 49,
    25, 12, 39, 52, 14, -10, 18, -55,
    -15, -5, -7, 14, 0, 4, 69, -8,
    37, -7, -3, -20, 37, -1, -21, -11,
    55, 1, -6, -4, 32, 29, 15, -13,
    -28, 11, -16, 17, 36, -2, -3, -12,
    64, 23, 8, 28, 26, 34, 37, 21,
    -19, -17, 5, 36, 73, 15, 26, -1,
    29, 20, 4, -7, -8, 30, -89, -40,
    -3, 76, 19, 2, 24, -7, -45, 16,
    2, 17, -13, 1, 0, 35, 24, -1,
    -13, -5, -11, 34, -51, 27, -20, -3,
    -21, 1, -6, 48, -33, -29, 15, 26,
    -21, -29, 18, 50, -70, 58, 9, -24,
    16, -77, 47, 53, -1, -9, 9, -21,
    -18, -26, 11, 2, -2, -6, 5, 24,
    -17, -73, 2, 8, -23, -27, 6, -93,
    15, -46, 40, -2, -5, -63, 15, -18,
    -4, -4, 3, -16, -1, -7, -9, -56,
    1, 4, -6, -24, 20, 8, -8, 34,
    -14, 26, 9, -5, 7, 12, -1, -38,
    33, 96, -100, 27, 56, -9, -47, -6,
    -15, 60, -36, 32, 71, -18, 1, 19,
    38, 27, 16, -13, -7, -28, 45, 62,
    18, 34, -45, -14, -6, -5, 72, -74,
    30, -23, -20, -9, -47, 107, 11, 12,
    5, 0, 1, 9, -35, -45, 7, 18,
    53, 5, -62, 6, -11, 2, -27, 20,
    47, -3, -15, 3, 15, -15, -19, 19,
    -8, -9, -12, -6, -57, 16, 38, -27,
    15, 38, 30, 23, -13, 81, -1, -8,
    -14, 62, -20, 38, -32, -25, -11, -22,
    62, 23, 7, -5, 4, 22, 6, 45,
    -9, 38, 6, 9, 19, -16, -16, 34,
    -9, 8, -9, 26, 3, 4, 10, -19,
    54, 0, 4, -32, -33, -1, 21, -6,
    -39, -24, -25, 11, 12, -15, 5, -46,
    -23, -17, -46, -45, 54, -4, -1, 25,
    -44, 4, -37, -22, 15, -9, -52, -18,
    -23, -11, 27, 2, -8, 15, -18, 6,
    6, -23, 44, 9, 26, 2, -50, -12,
    -8, -32, 3, -41, -13, -1, 0, -15,
    10, -8, -12, -57, 68, 22, -23, 29,
    18, 5, -109, -5, 24, 5, -43, -26,
    32, 21, 16, 41, -26, -16, -15, 14,
    -27, -48, -32, -28, 13, -32, -80, -13,
    -10, 53, -30, 27, -5, -28, -8, 9,
    -36, -14, -66, -3, 34, 2, 66, -3,
    -47, -33, -3, -5, 60, 27, -15, 72,
    76, -11, -52, -39, -18, -84, 7, -2,
    44, -9, -39, 10, -59, -70, 39, 27,
    27, 18, -10, -42, -27, 27, 1, 67,
    -1, -7, -27, 10, -84, -11, -13, -38,
    -7, 17, -18, 8, 52, -16, 13, -2,
    -18, 44, -39, 26, -26, -21, 13, 31,
    -11, 13, -39, -90, -1, 31, 3, 41,
    38, -2, -16, 70, -9, -23, -92, 63,
    2, -52, -52, -5, -9, 12, -3, 9,
    12, -20, 17, 17, 40, -6, 21, 17,
    57, -14, -17, -88, -47, 23, 1, -13,
    1, -37, -6, -28, -46, -1, -43, -18,
    -16, -20, 10, -74, -44, -55, 4, 1,
    22, -6, -58, -9, -17, -70, 34, 3,
    20, -91, -24, 19, -62, 2, 12, 23,
    18, -24, -24, 40, 49, 66, 18, -31,
    -32, -6, 60, 6, 85, 25, -4, -24,
    -20, 8, -75, 48, -31, 1, -36, -30,
    -36, 10, 3, -28, -54, -8, -74, -4,
    -44, -65, -19, -24, 6, -18, -23, -5,
    27, -19, -57, 39, 8, -31, 20, 0,
    -40, -18, 14, 6, 42, -52, 2, 25,
    -12, -11, 38, -11, -52, 36, 34, 24,
    -9, 37, 33, -32, 65, -20, 16, 13,
    -1, 56, 32, -17, 50, 8, -4, -10,
    17, 42, 27, 14, 0, 35, 13, -20,
    38, 17, 15, -16, 8, 43, 0, -6,
    40, -41, -9, 25, 13, 35, 39, -4,
    -14, 13, 37, -4, 32, -6, 20, -3,
    -18, 31, 16, 0, 28, -24, -27, 36,
    -21, 50, 40, 17, -25, 1, 21, -4,
    -21, -32, 58, -51, -68, -20, 20, 7,
    -16, -8, 47, -14, -14, 43, -59, 10,
    -25, -52, -17, -12, -6, 2, -11, 32,
    42, 2, 10, -45, 16, -20, -10, -4,
    32, -15, 3, 19, -18, 45, -37, 10,
    55, 24, -16, 29, 18, 17, -10, 1,
    -25, 10, 4, -29, 22, 11, 34, 45,
    7, -9, -5, 34, -48, 20, -40, -89,
    8, -28, 5, 19, -4, 24, -62, -5,
    8, -15, 38, -1, -7, -21, -4, 12,
    28, -13, -20, 17, -49, -36, -48, -7,
    8, 44, 29, 12, -2, 8, -5, 49,
    13, 39, -41, -18, 10, 29, -15, 4,
    -21, 8, 19, 7, -71, -17, -19, -84,
    14, -22, -14, 40, -6, -17, -15, -68,
    -15, 25, 28, -17, -43, 35, 9, 8,
    19, 9, -35, 69, 30, -8, 36, 2,
    -54, 10, -11, -13, 5, 11, -48, 51,
    18, 53, -45, 1, 7, -27, 9, -5,
    10, -22, -7, -16, -10, 9, 2, -11,
    -6, 21, -7, 17, -10, 5, -3, -2,
    -2, 20, 10, -3, 3, 19, 1, 12,
    19, 0, -7, 15, 1, 7, -3, -4,
    31, -10, 7, -21, -25, 10, -4, -24,
    -2, -20, -13, 0, -20, 2, 2, -7,
    0, 0, 4, 22, -20, -12, -6, 16,
    8, -25, 31, -30, -20, -8, -12, -20,
    2, 10, 8, -6, 7, -59, -5, 8,
    0, -3, 15, 31, -28, 19, 7, 25,
    -8, 17, 9, -3, -8, -11, -9, 45,
    -5, -57, 4, 8, 15, -6, 15, 11,
    0, 19, -22, 23, 4, 7, -10, 13,
    3, 1, 18, 28, -13, -2, -16, -3,
    4, 26, -22, 5, 22, 24, -1, -12,
    -5, 7, -22, -19, -1, 9, -22, -12,
    3, 22, 13, 7, -31, 14, 17, -13,
    4, 6, 2, -11, -6, 12, -15, -9,
    -3, 2, -4, -3, 11, -5, 32, 2,
    11, 11, 18, 13, 12, 18, 0, -8,
    -15, -37, -10, -30, 10, 9, 2, 30,
    -14, -47, 22, 25, -10, -2, 10, -18,
    6, -19, 1, 24, 1, 38, 13, -3,
    3, -5, 25, -22, 11, -9, -15, -2,
    13, 0, -2, 4, -2, -4, -9, -29,
    14, -11, 10, -15, 5, 11, -20, 2,
    -19, 12, 10, -5, -2, 11, -6, 41,
    31, 1, -1, -12, -21, 8, 2, -17,
    -15, -9, 28, -21, 2, 6, 26, 11,
    0, -5, 20, 34, -17, -10, 10, 2,
    8, -21, 5, 14, 4, -11, 0, 19,
    -9, 46, -13, 6, -15, -4, 6, 17,
    9, 17, -5, -32, 5, 7, -7, -34,
    1, 28, -26, -34, -10, -4, 19, 8,
    11, -3, -7, -10, -8, 19, -14, 37,
    -27, -1, -11, 26, -9, 4, 20, -8,
    3, -1, 24, 32, 30, 14, -10, 40,
    -11, 42, -36, 15, 6, -2, -29, -12,
    -5, -13, -6, 21, -1, -17, -4, 5,
    -1, -64, 5, -12, 10, 20, -15, -12,
    27, 2, 13, 20, 6, -18, 22, -2,
    -9, -33, -19, -1, 17, 10, 11, 16,
    -16, -9, -17, -26, -29, -24, 23, -15,
    -44, 0, -22, -25, 6, -2, 0, -15,
    -2, 8, -16, -4, -3, 29, -18, 3,
    4, 17, -6, 0, 8, 1, -4, 8,
    6, 10, -2, -4, -25, 11, -8, -4,
    -23, 26, 2, 16, -12, 11, 5, 12,
    -10, -42, -1, -6, 3, -5, -26, -5,
    23, -16, -10, 12, 0, 1, -3, -13,
    -11, -22, -7, 10, 0, 10, 2, 3,
    17, -26, 7, -10, -6, 13, -24, -6,
    -22, 16, 15, -21, 9, -28, 17, 32,
    -17, -22, -15, 28, 1, -2, -21, 3,
    9, -13, 13, -8, 4, 14, -8, -14,
    17, 24, -9, -55, 2, 27, -7, -7,
    7, 27, -50, 23, -33, 15, 13, -2,
    -1, 14, 19, 25, 27, -8, -21, 5,
    7, 13, -26, -20, -20, 11, -5, -14,
    -30, -9, 10, 37, 18, -15, 14, 22,
    -22, -10, 2, 9, -27, -21, 2, 43,
    -23, 25, 4, -39, -6, 3, 10, 26,
    -10, 9, 4, -6, -5, 11, -37, -16,
    24, 9, 16, -34, 2, 6, -10, -9,
    -17, 2, -7, 6, 1, 7, 70, 13,
    -9, -17, 13, -22, -12, -5, 1, 19,
    -14, -1, 12, 2, 6, -18, -1, -11,
    14, -25, 0, -7, -9, -14, 0, -17,
    17, -16, -2, -12, -6, 7, 8, -4,
    35, -5, -4, -25, 1, 8, 16, -3,
    -13, -5, 0, -24, 35, -16, -18, -8,
    -14, -6, 30, 1, 8, 3, 16, 4,
    -14, 9, 8, 25, 18, -40, -6, -4,
    -17, -15, -14, 9, -4, 3, -2, -14,
    -13, -18, -6, -17, 1, -23, 15, 9,
    55, 7, 11, -30, -24, -14, 3, -75,
    -10, 15, 16, -31, 10, -37, -5, 38,
    -2, 7, -13, 16, -13, -3, -5, 13,
    -2, 5, -5, -8, -18, 22, 31, 68,
    -36, 61, -39, 29, -2, -7, -17, -14,
    29, 4, -5, -5, -8, 12, 9, 1,
    -53, -14, 2, 48, -9, 8, -7, 14,
    -7, 12, 3, -3, 3, 9, 21, 2,
    6, -26, -16, -36, 5, 5, -23, -17,
    -30, 4, 9, -1, -16, -2, 1, 19,
    -6, -7, -10, 8, 13, 0, -16, 25,
    -11, -8, 5, 17, 0, -29, -10, -2,
    11, 8, 46, -25, -7, -4, -6, 2,
    12, 29, 13, 50, 0, -27, 12, -26,
    29, 12, 0, -25, 7, 9, 12, -13,
    -3, 13, 18, 8, 31, 27, -23, 14,
    29, 4, 16, -31, -13, -2, 34, 2,
    19, -23, -5, 24, -9, 11, 5, -20,
    14, -50, -3, -3, -20, 10, 1, -14,
    7, -3, 13, -2, 8, -8, -13, -18,
    8, -24, -29, 20, 2, 8, 2, 19,
    -25, -11, -17, -43, -15, 10, 12, -47,
    25, -7, 8, -16, -1, -10, 16, 9,
    0, 1, 9, -5, 15, 5, 22, 28,
    -28, 39, -54, 11, 18, 22, 17, 3,
    -27, 9, 11, 0, 8, 3, -9, 2,
    -23, 11, -32, 3, 9, 11, 9, 17,
    -2, 12, -3, 0, 19, 0, 2, 19,
    -4, -40, 6, 73, 15, 10, -12, -12,
    38, -33, 7, 8, 5, 3, -1, 15,
    7, -5, 13, -2, -19, 42, -4, 6,
    -6, -11, 2, 8, 8, -30, 21, 8,
    29, 26, 13, -36, -30, -17, -4, 4,
    -21, 14, -6, 43, 5, 20, 5, -33,
    -7, 12, -41, -9, -4, 4, -17, -19,
    -4, -16, -12, 11, 6, 15, 3, -20,
    7, -22, 35, -21, 11, 33, 32, -5,
    -49, -47, 30, 10, 17, 32, 4, 5,
    26, -10, -7, 10, -8, 22, 8, 9,
    1, -1, 20, -2, 2, -8, -33, 15,
    -20, -47, 27, -43, 1, -11, -10, 7,
    -23, 8, -2, 18, -19, -7, 26, 4,
    2, 31, 17, 3, -3, 17, 25, 8,
    16, -12, 8, 20, -8, -6, -19, -4,
    11, 32, -10, -4, -8, 4, 0, -10,
    -14, -4, -1, 19, 1, 30, 13, -27,
    4, 15, 20, 15, 10, -1, -15, -3,
    -3, 12, 13, -11, 12, 24, 16, 2,
    16, -33, 11, 10, -27, -4, -10, -12,
    1, 4, 0, 6, 39, 8, -32, -26,
    10, -11, 10, 2, 0, 15, -9, 5,
    -3, 6, -10, 5, 15, -21, 17, 29,
    11, -20, -55, 10, -34, -15, 25, -17,
    -11, -5, -2, 4, -7, 22, 24, 33,
    16, -24, -15, 0, 11, 14, 3, 30,
    55, -7, 14, -24, 13, 3, 3, 6,
    -17, -1, -11, -4, 13, 2, 6, -11,
    -35, -22, 2, 8, -17, 7, -15, 6,
    -6, 14, -7, -4, -35, -30, 4, 21,
    -3, -15, 19, 24, -19, -16, -21, 43,
    -1, 14, 4, -2, -19, 1, -17, -18,
    -53, 17, -15, -7, -25, 29, 5, 9,
    15, -1, 1, 21, -16, 2, 21, 7,
    -4, -7, 20, -5, 4, 8, 13, 64,
    -14, -1, 23, 28, 0, -3, 3, 6,
    0, -18, 27, -6, -16, -6, 5, 3,
    7, 29, 30, 16, -3, 1, 12, -30,
    -2, 11, 3, -39, -8, 37, -10, -28,
    -1, 14, -6, -13, 16, 26, -30, -9,
    2, 3, -3, 19, -42, 19, 35, -3,
    -16, -13, 13, 15, 29, 6, 3, 30,
    -4, 2, -1, 11, -22, -13, 38, 3,
    -2, -21, -25, -33, 10, 20, -8, -15,
    -20, -14, -27, -15, 13, -5, -6, 12,
    -8, -41, 26, -12, 5, 1, -24, -8,
    18, -38, -7, -19, -8, 34, 15, -14,
    -22, -4, 0, 9, 18, 31, -33, 3,
    -32, -6, -51, 40, 23, -6, 53, -61,
    -40, -3, -17, -23, 17, 8, 11, 10,
    13, -31, -2, 8, 6, -47, 27, 49,
    -17, 0, 1, -28, 11, 11, 4, -43,
    -10, 14, 3, -14, -66, 16, 13, 0,
    -20, -22, 0, -26, -10, -3, 3, -7,
    -10, 1, 16, 4, -20, -11, -13, 64,
    -30, 26, -13, 7, 11, -12, 5, 19,
    -7, -10, -21, -26, 10, -10, -4, 8,
    19, -2, 16, -55, -5, 16, 16, -19,
    -21, 12, 2, -32, -5, 23, -3, 2,
    8, -6, -26, 3, 6, -8, 18, 8,
    -10, 13, 7, -22, 7, 26, 14, 30,
    48, -15, 8, -1, -5, -2, -14, -3,
    31, -2, 1, -5, 21, -5, -25, 10,
    14, -17, 3, -18, 34, 29, -9, -18,
    -23, 11, 1, 24, -16, -17, 8, 4,
    -4, 2, -18, -1, 16, -7, 4, 8,
    -4, 8, -17, 8, -6, 1, -9, -1,
    3, 16, -2, -14, 0, 7, 2, 7,
    -14, 19, -9, 15, -15, 11, -19, -3,
    21, -34, -14, 61, -21, -8, 13, 27,
    10, -25, 23, 3, -1, 12, 8, -24,
    10, 26, 12, 16, -24, 9, 3, 24,
    6, 24, -5, 36, -25, -10, -35, -24,
    -11, 0, -10, 11, 0, 8, -9, -9,
    8, -22, 1, 1, -1, -5, -5, -23,
    -19, 7, -24, -8, -1, 29, -21, 21,
    23, -7, -10, -4, -25, -34, 37, 21,
    -6, 12, -10, -33, -28, 18, -14, -12,
    4, -19, -23, 7, -9, -27, -15, -40,
    2, -8, -11, -54, -10, 27, -1, -9,
    -1, -29, -13, 10, -59, 12, -8, 12,
    2, -4, -2, 12, -23, -29, 16, 6,
    23, -21, -2, -35, -22, 4, -4, 7,
    -46, -13, -16, -8, 20, -14, 6, 2,
    13, -3, -10, 12, 1, -29, -7, 8,
    29, -20, 1, -28, 7, -1, -16, 5,
    -24, 12, -3, -19, -15, 21, -32, 24,
    -13, 12, 3, -5, -8, 9, -21, 25,
    8, 5, 19, 0, -39, -12, 74, -42,
    11, -1, -16, 11, 64, -9, 10, 6,
    -36, -1, -18, 17, 35, -8, -11, -5,
    0, -2, 34, -8, -4, -5, 18, -19,
    23, 5, 0, -53, -5, 31, -9, 20,
    12, 2, -19, 12, 0, 6, -13, -9,
    -11, -16, 7, -35, 54, -33, -31, -13,
    -50, -28, 34, -36, 24, 4, 15, 2,
    22, -5, 7, 4, -11, -46, -21, -56,
    -19, 57, -29, 6, -8, 29, 3, 1,
    29, 23, -13, -25, -16, -8, 5, 25,
    10, -22, 37, -9, -14, -40, 5, -100,
    13, 9, -1, 5, 11, -8, 4, 15,
    -55, -31, 13, -22, -2, -22, 5, -9,
    20, -5, 10, -1, 28, 30, 4, 77,
    -3, 25, -33, -3, 3, -3, -16, -19,
    -8, 33, -18, -15, -11, 44, -14, -31,
    5, -33, 21, -12, -7, 1, 9, -15,
    -4, -52, 15, 17, -31, 9, 21, 8,
    -4, 16, -14, 8, 11, -4, -4, -24,
    -3, -38, 33, -18, -25, -16, -38, -5,
    -38, 65, 0, -28, -16, 14, 4, -17,
    2, -33, -34, 2, 6, -7, -17, 27,
    4, -30, 17, -6, -7, -4, -4, 11,
    -11, 5, 8, -32, 26, -50, 6, -12,
    9, 22, -20, 28, 22, -6, 0, -20,
    0, 6, -22, 1, 31, -21, -44, -6,
    28, -49, -7, -24, -27, -14, 3, 22,
    -30, -15, 26, -14, -21, 13, 13, -18,
    -24, -46, -46, -13, -12, 5, -28, 21,
    6, -23, -7, 25, 34, 25, 3, -43,
    7, 39, -15, 4, -5, -12, 1, 11,
    15, -1, -11, -19, -5, -15, 7, -2,
    25, 4, 14, -22, -18, 7, -9, 0,
    1, -5, 13, -44, 4, 15, 37, 15,
    -41, 33, -44, -23, 6, 0, 15, -9,
    -1, 27, 18, -19, 41, 10, -5, 14,
    -44, -9, -8, 6, -2, 1, 16, -10,
    -9, -22, 28, -3, 20, 10, 15, 3,
    5, -66, 21, 63, -4, 10, -17, -20,
    0, -19, 22, 15, -22, 17, 19, -15,
    -6, -1, -10, 0, -33, 29, 4, -13,
    -3, -4, 21, -4, -1, -39, -19, 29,
    7, 10, -7, -22, -38, -17, -32, 12,
    -27, -13, -2, 50, -5, 61, 49, 13,
    -7, -12, 19, -9, -21, -2, -35, 0,
    11, 4, 22, -21, 7, 16, 13, -4,
    24, 16, 36, -32, 14, 48, 31, -22,
    5, -16, 6, -4, 33, -16, -3, 11,
    14, 4, 12, -8, -28, 0, -3, -17,
    41, -21, 10, 2, -20, -13, -36, 12,
    -18, 14, 0, -24, -21, -12, 30, 1,
    13, -14, -9, -36, -38, -7, -11, 28,
    -10, 17, -4, -14, 0, -6, 0, 11,
    32, -9, -1, 30, 11, -2, -14, 37,
    25, -2, -31, -32, -17, -14, -9, -3,
    -25, 11, -21, -12, -38, 24, -15, 1,
    9, 31, 17, 3, 4, 0, 8, -2,
    17, -11, 26, -11, 17, 9, 33, -14,
    7, 5, 7, 31, -45, -12, -30, 6,
    -14, 29, -23, 12, -31, 68, -31, -33,
    -3, 1, -31, -2, 4, 17, 4, -16,
    8, 3, 18, -11, 6, -4, 39, 15,
    68, -13, -43, -8, -30, -25, 28, -10,
    -14, 40, -14, 27, -10, 15, 36, -34,
    21, 73, 39, -52, 23, 15, 11, -18,
    -24, -4, 12, 31, 39, 2, 21, -25,
    -8, -26, -35, -10, 2, 5, 13, 6,
    -74, -23, 14, 7, -47, 15, -7, 11,
    -5, -8, 7, -52, -20, -42, 10, -18,
    20, 0, -35, 36, 28, -12, 3, 27,
    28, 24, -35, 8, -29, 14, -15, -21,
    -67, -16, -13, 18, -49, 0, -22, -3,
    -30, 63, -11, -9, 54, -25, 0, -1,
    -30, -20, 0, 18, 15, -61, 37, 92,
    -36, 14, 5, 30, 1, 1, -4, 7,
    -8, -83, -4, -59, -21, 63, 31, -17,
    -28, -82, 11, -68, -18, 21, 47, 15,
    -19, -68, 39, -39, -15, 12, 6, -37,
    0, 9, 8, 35, 19, 16, -31, -10,
    23, -40, -10, -21, 6, -12, 52, -4,
    12, 18, -36, 30, -8, -59, 13, 13,
    1, -32, -12, 21, -18, -36, -1, 9,
    -18, -43, -15, 54, 30, 18, -7, -5,
    1, 59, 8, 50, 37, -34, -26, 4,
    25, 30, -49, 68, -28, -10, 3, 14,
    17, -14, 43, -36, -44, -15, -6, -57,
    -27, 51, -21, 8, 14, 35, -41, 14,
    -60, -43, -34, 3, -25, 10, 29, 93,
    -74, 19, 5, 45, 18, 4, 8, -41,
    -13, 27, -14, -32, 18, -22, 43, -1,
    44, -13, -6, -40, 7, 11, 0, -52,
    -4, 29, -55, -3, 35, -26, -25, 6,
    3, -28, -8, -8, 37, -23, 0, 15,
    -18, 25, 22, 2, -70, 42, -29, 60,
    -71, 33, -9, -5, -7, -25, 6, 17,
    -9, 21, -11, 32, 22, -17, 11, 8,
    48, -8, 46, 27, -6, 3, -12, -27,
    18, 12, 2, 1, 15, 20, -14, -14,
    -40, -27, -54, -20, -1, 11, 20, 5,
    41, 25, 1, -18, 61, 64, -16, -9,
    1, 62, -20, -9, -8, 10, 6, 23,
    -35, -27, -19, 38, -11, 31, -22, 2,
    4, -34, 24, -26, 15, 23, -9, -25,
    -68, -1, 28, 26, 16, 9, -20, 8,
    -14, 45, -18, -7, -12, -2, -4, -26,
    56, -6, 36, 9, -27, -12, 3, -15,
    -82, -21, -25, -90, 1, 18, -1, 25,
    13, -11, 32, 21, 41, 44, -7, 77,
    -27, 33, 6, 26, 18, -21, 11, -20,
    9, -19, -41, -14, 31, 4, 52, -44,
    53, -14, 25, -11, -32, 0, 8, 38,
    7, 72, -1, 31, -23, 1, -63, 51,
    24, 34, 0, 43, -1, -13, 4, -10,
    9, 33, -32, -2, 10, -24, -4, -24,
    -30, 29, -79, -50, -9, 19, -30, 37,
    8, -35, -8, -38, 27, 32, -115, 8,
    -25, 17, -4, 11, 6, -44, 28, -41,
    -30, 23, 5, 32, -24, -28, 76, -63,
    -6, -2, -24, -30, -3, 35, 11, -17,
    -32, -68, 19, 2, 64, -14, 31, 6,
    3, -11, 21, -27, 12, -11, -13, -12,
    10, -10, 4, -15, -30, -6, -5, 47,
    58, -19, 14, -63, 15, -19, 12, -9,
    -58, 68, -35, 48, 14, -25, 2, 7,
    -86, -30, -21, 47, -15, -20, -64, 10,
    28, 7, 67, 30, -8, 44, -25, 6,
    37, 6, -7, -29, -3, 15, -28, 11,
    29, 7, 52, -23, -65, -13, 127, -17,
    -9, 6, 12, -48, -19, 5, -60, -69,
    -43, 2, -51, -33, 14, -21, -16, 8,
    20, -31, -44, -10, -23, -20, 43, -20,
    15, 2, 33, -53, -55, 12, 53, -41,
    -53, -34, 86, -26, 15, -1, -9, 5,
    2, -35, 39, -1, 85, -9, -45, -5,
    -6, 24, 44, 49, 40, -8, 9, -14,
    -38, -1, -7, 31, 35, -41, -33, 1,
    -26, 4, -26, 5, -8, -51, -5, 11,
    -20, -23, -8, 40, -21, 21, -3, 52,
    -20, -4, 41, -43, -17, -28, -6, -123,
    61, -4, -47, 16, 29, -43, 6, -14,
    -22, -18, -47, -17, -16, -32, 25, -24,
    -4, -12, -48, -8, 74, -10, -13, 89,
    8, -16, 29, 13, 9, 3, -9, -11,
    -48, 76, -30, 12, 3, -60, 21, 16,
    55, 22, -5, 33, -28, 6, 19, 3,
    46, -41, -61, 22, -38, 14, 36, -2,
    -13, -20, 19, 9, 13, 1, 3, -17,
    28, -97, 19, -19, 23, -28, -2, 94,
    53, 65, 38, -62, -23, 8, -19, 32,
    -19, -16, 20, -39, 3, -15, -11, 5,
    0, -34, -18, 16, -21, -7, -12, 12,
    0, -10, -13, -116, -11, -1, 36, -22,
    -81, -16, -1, -27, -2, -17, -13, 31,
    8, 35, 30, 21, 23, 11, -14, -3,
    12, 4, 6, 46, -42, -9, -4, 10,
    -27, 30, 46, 8, -12, -13, -36, 24,
    -94, 39, 45, -22, 19, -3, 30, -16,
    45, 52, -41, -6, 26, 16, -8, -15,
    -15, 53, -33, -7, 18, -15, -5, 24,
    -3, 43, 33, 12, -32, -8, -2, 13,
    127, -24, 87, -17, 4, 75, -35, -23,
    -46, -65, 50, 0, 32, 12, 7, -40,
    -12, 9, -31, -51, 12, 6, 26, -4,
    38, 27, 7, 1, -23, -6, -7, 1,
    6, 68, 11, 1, -12, -4, 3, -17,
    13, -8, -16, 17, -12, 10, -4, 67,
    21, -68, 9, 20, -21, 19, -1, -20,
    -50, -46, 21, 4, -36, 49, 11, 31,
    -28, 28, -2, 39, 0, -1, -37, 18,
    -68, -61, -7, -30, 25, -72, -13, 29,
    -12, -19, -10, -34, -43, -26, -23, 24,
    -12, -10, -5, 32, 9, -9, -86, -11,
    -42, 36, -2, -24, -18, 26, 9, 23,
    23, -10, 39, -42, -24, 53, 11, 11,
    21, 22, 26, 44, 6, 42, 44, -22,
    44, 66, 5, -16, -13, -10, 2, -13,
    1, 67, 28, -6, 45, -24, -15, -49,
    -9, -41, 13, 36, -32, -9, -43, -31,
    -35, -17, 48, -43, -18, -9, 7, 3,
    72, -22, 6, -46, -12, 25, 84, 5,
    -27, -70, -14, -46, 25, -5, 6, -19,
    18, 49, -45, 8, 4, 9, -42, -2,
    18, -12, -45, 19, -3, -23, -25, -9,
    -11, 15, -21, -43, 36, -90, 45, -31,
    13, -43, 0, -32, 7, -6, 7, -37,
    -5, 17, 33, 25, 24, 57, -4, 16,
    11, -36, -22, -32, -42, -6, -36, 11,
    -5, 2, 4, 26, -1, -12, -19, 73,
    4, -45, -25, -48, -28, -20, -9, 7,
    25, -35, -15, -10, -1, -5, 9, -34,
    -11, -2, -10, 21, 20, 34, 2, -19,
    -9, -19, 22, 34, 34, -8, -13, 15,
    16, 10, -8, -32, -12, 49, -29, 17,
    -16, 5, -9, 12, -46, 17, 5, -13,
    11, 10, 14, 12, 9, -23, 5, -4,
    32, 40, 2, 4, 8, -10, 4, -29,
    26, 31, -11, -26, -15, 25, -30, -2,
    -8, -1, 3, 0, 17, -12, -15, 9,
    -15, 1, -15, 3, 32, -28, 11, -22,
    14, -35, -5, 5, -7, 27, -33, 0,
    4, 43, -4, -5, 28, -16, 21, 39,
    -32, 11, -4, 13, -1, -12, 9, 23,
    16, -7, 10, -11, 8, -16, -8, 13,
    -3, 0, 1, -2, 5, -51, -47, -20,
    -2, -26, -54, -12, 9, -31, -44, 8,
    -21, -10, -17, 15, -15, 6, -6, 5,
    -2, -12, 7, -8, 31, -7, 19, -4,
    -17, -3, -16, -10, -2, 11, 21, -18,
    -26, 33, 5, 9, 5, -5, -20, 26,
    -7, -5, 9, -19, -1, 3, -3, -2,
    -8, 15, -2, -4, -11, 10, 15, -20,
    3, 12, 13, -5, 10, 8, -15, 7,
    0, 6, -6, 10, -13, 28, -11, -33,
    -28, -12, -15, -10, 26, -21, 37, -2,
    30, -1, -5, -4, -9, 7, 16, -14,
    10, 4, 4, -15, 3, -1, -42, -5,
    18, 4, -20, 0, 36, -14, -19, 32,
    17, 0, -24, 10, -10, -3, -4, 10,
    2, 36, -5, 11, 14, 9, -19, 3,
    -29, -1, -25, 16, 0, 11, 18, 35,
    -13, 11, -28, -11, -44, -4, 12, 28,
    6, 11, 6, -11, -32, -9, -22, -22,
    13, 18, -1, 5, -9, 25, 14, 11,
    19, 2, 25, 18, -15, -15, -29, 1,
    -11, -16, -13, -12, 11, 1, 12, -20,
    39, -18, -18, 6, -35, 38, 22, -10,
    5, 4, -9, 19, 1, 27, 9, 19,
    -10, 8, -28, -5, -12, 1, -7, 16,
    -15, -51, 15, 20, -18, -33, -17, 37,
    8, -3, 9, -10, 23, 34, 2, 25,
    18, 0, -13, 6, 11, -21, -22, -13,
    -10, -10, 10, 26, 42, -15, -12, -11,
    26, -6, 1, -1, 60, 12, 28, 8,
    -5, 4, 23, 2, 21, 0, 17, 13,
    40, 16, 4, -21, -7, -4, 6, 1,
    0, 44, 25, 17, 12, -17, -11, 27,
    -7, -16, 20, 12, 12, 23, 3, 6,
    39, 3, 17, 13, -6, 11, -41, 31,
    1, 2, 4, -18, -20, 20, 28, -30,
    20, 37, 29, 21, -1, 0, -12, 30,
    -7, -16, 12, 12, -28, 3, -4, -35,
    9, -36, -6, -9, 14, -3, -10, -7,
    -6, 24, 8, 8, -9, 0, 5, 5,
    11, 8, -5, -39, 12, 1, -2, -24,
    12, 23, -10, 13, 14, -5, -23, 1,
    8, 16, -2, 11, -16, 1, 2, -15,
    -10, 13, -6, -4, 32, -22, -31, 27,
    3, 64, -9, 6, -27, -25, 10, -17,
    2, 1, -23, -32, 31, -21, -25, 4,
    -27, 18, -8, -12, 10, 16, 22, -6,
    -19, 14, 2, -18, -1, -10, -35, -27,
    -6, -19, -10, 18, -31, -15, -8, 5,
    -15, -17, -11, 24, 24, -14, -46, 12,
    1, -12, 1, 17, -12, -7, 21, -11,
    9, -18, 4, -12, -6, 19, 6, -5,
    14, -16, 4, -17, -22, 13, -11, -18,
    6, -7, 21, 8, 5, 6, -63, -46,
    -11, -8, 10, 12, 13, 0, 9, 4,
    3, -14, -24, 6, 16, -3, 14, 16,
    18, -8, 9, 48, -13, -7, -22, -15,
    9, 28, 20, 19, 7, 9, 21, 21,
    -30, 12, 1, -5, 20, -30, 21, -22,
    18, 4, -33, 26, 9, 28, 29, 33,
    8, -6, -9, -34, 7, 4, -22, 6,
    15, 16, -17, 6, -14, 1, 37, -13,
    -2, 20, -11, -14, 30, 9, 10, 15,
    -10, 8, 13, 6, -1, -13, 15, -30,
    -52, -11, 25, -9, 3, 45, 9, 9,
    -3, 2, -5, -1, -15, 58, 30, 31,
    -41, 26, -3, 2, 12, -5, -3, -9,
    -11, 29, -18, 23, -17, 8, 10, -36,
    -2, 25, -50, 2, -21, -7, -37, 21,
    -3, 12, 2, -4, 18, 7, -16, 35,
    -11, -10, -21, -10, -28, -15, -11, -2,
    11, -22, -1, -10, -8, 7, 7, 15,
    46, -15, 36, 4, -10, -21, -52, 12,
    -9, 15, -19, 21, 46, -12, 16, 15,
    2, 20, -7, -11, -32, -19, -10, -15,
    18, 2, 12, 6, 31, -21, 12, 6,
    -20, -11, -4, -16, -15, -22, -19, -25,
    -11, -19, -5, 4, 19, 64, -15, -3,
    22, 22, -10, -12, 24, 19, -13, 6,
    -5, -2, -23, -9, -28, -26, -9, 6,
    -5, 1, 5, -19, 38, 18, -16, -17,
    -2, -11, 31, 32, -21, 11, -29, 2,
    12, 24, 8, -1, 6, -25, -14, -19,
    -30, 1, 16, -6, -3, 18, 20, 8,
    12, -6, 16, 32, 0, 3, 15, 8,
    -40, -25, 16, -4, -9, 2, 23, -10,
    -6, 13, -10, 24, 7, -27, 4, -9,
    -27, 8, 8, -12, -10, -4, -25, -6,
    23, 48, 20, -3, 4, 18, 17, -23,
    -20, 19, -1, 13, -18, -24, -12, -16,
    -18, 11, 3, -9, 10, -4, -19, 10,
    -8, 5, 0, 36, -9, -24, -44, 18,
    1, -8, 11, 6, 38, -53, -14, 21,
    18, 11, -19, 27, -27, 35, 13, 10,
    -29, 36, 7, -16, 10, -14, -2, -5,
    9, 20, 8, -8, 14, -4, 11, 37,
    -7, -6, -23, -18, 24, -5, 1, 1,
    0, 2, -20, -12, 19, -23, -22, 11,
    21, -8, 10, 22, 4, -2, -13, 3,
    -13, -20, -9, -2, -10, -22, 12, -11,
    13, 15, 0, 9, 34, 13, 45, -4,
    -16, -9, 6, -22, -15, 29, -7, 4,
    4, -30, -9, 5, -13, 6, -12, 18,
    -13, 14, -9, -21, -5, -14, -23, -16,
    -2, -7, -21, 18, 38, 24, 4, 21,
    40, -10, -24, 4, 76, 32, -8, -27,
    -11, 0, 18, 0, -24, -14, 7, -29,
    29, 35, -8, 19, -12, 19, 9, 12,
    -11, 40, 9, 13, -9, 4, 21, 3,
    -3, -7, -38, -1, -4, 10, -3, 7,
    3, -11, -9, 10, -4, -6, -12, -15,
    4, -21, 12, 11, -6, 4, 6, 13,
    -7, 16, 13, -15, 4, -52, 13, 12,
    -16, -4, -20, -24, 7, -47, -4, -30,
    22, 0, 21, -15, 7, -4, -19, -31,
    26, 35, -5, 20, -20, 7, 21, -22,
    -6, -43, 1, 3, 11, 15, -26, -18,
    45, -41, -39, -15, 8, 82, 54, -41,
    -29, -4, -7, -43, 11, -45, 21, 4,
    -26, -1, 16, 13, 7, -3, 3, -10,
    -7, 17, 10, 1, 20, -10, -1, -12,
    -28, 13, -15, -20, 34, 29, -8, 3,
    34, -4, -13, -37, 41, -8, 19, -10,
    -14, -18, -21, -1, 35, -16, -9, -17,
    -6, -14, -3, 10, 20, 15, 16, 28,
    20, -22, 22, -6, 7, 30, -8, 2,
    -5, 9, 17, 29, -9, 16, 8, 53,
    17, 5, -66, 4, -1, -6, 26, -18,
    -26, -20, -21, 19, 5, -23, -41, -20,
    16, -25, 31, -17, -15, -69, -22, -2,
    -2, 4, -2, 83, 3, 41, -40, 14,
    16, 18, 14, -1, 24, -29, 14, -3,
    -13, 31, -8, 16, 27, 29, 17, 0,
    3, -13, 20, -25, -1, -36, 30, -47,
    20, -9, -2, -5, -17, 0, 5, -27,
    -23, -14, 26, -25, -14, 30, 19, 10,
    29, -21, -16, 0, -2, 6, 3, 29,
    -9, -21, -5, -30, 17, 12, -30, -53,
    -35, -14, 4, 13, -25, -39, 22, -15,
    -12, 10, -40, -24, -6, 3, -33, 10,
    -7, -24, -13, 55, -8, -9, 17, -22,
    6, -35, -2, 12, -11, -7, 19, -14,
    -3, 16, -7, -1, -15, 3, 10, -14,
    85, -33, -36, 0, 10, 15, -28, 16,
    24, 35, 9, -16, -21, 4, 38, 8,
    -22, 37, 2, 0, 21, 4, -17, 25,
    17, 31, 39, -19, -4, -10, -4, -21,
    -30, 7, 2, 26, -34, 11, 17, -9,
    38, -9, 22, 25, 15, 29, -39, -3,
    -25, -10, -40, -28, 14, 19, -3, 8,
    7, 2, -16, -7, -10, 7, 2, -30,
    5, -28, -5, -33, -6, -11, -7, 17,
    -1, -16, -9, -19, -30, 17, 16, 1,
    -20, 3, 2, -19, -25, -8, -57, 1,
    23, 27, -29, 30, -3, 19, 22, -39,
    -7, 0, 20, -4, 23, -4, 8, -3,
    12, 5, 7, 12, 13, 13, 6, -17,
    -43, -10, -23, 6, -2, 1, 13, 13,
    22, -2, 12, -45, 36, 4, -5, 18,
    -37, 28, 20, 15, 26, 42, 13, 27,
    -32, 51, 7, -13, -9, 5, -26, -15,
    54, 51, 32, 89, -5, -8, -29, -34,
    -55, 9, 22, -5, -11, -15, -6, 33,
    -34, -1, 9, -10, -14, 19, 40, 3,
    30, -19, -19, 13, -1, 10, 9, -22,
    8, 28, -2, 14, 11, 13, 13, -1,
    -43, -19, -22, 19, -10, -21, -14, -27,
    -18, 12, -40, -24, 25, -18, -36, -27,
    23, 25, -47, 39, 23, -29, 5, -20,
    5, -10, 43, 20, -11, 37, 62, -39,
    -4, 8, 2, -6, 7, 32, 39, -2,
    6, -2, -3, -4, -1, -2, -4, 22,
    -7, 8, 5, -1, 0, -41, -1, -27,
    41, -51, -45, 10, -14, -18, 29, -4,
    -21, -27, -30, -14, 46, 8, 9, 6,
    -2, 15, -8, 19, -3, 2, -14, -26,
    11, -42, 6, -1, -27, 28, 13, -8,
    -25, -8, -48, -20, 26, -5, -6, 47,
    4, -4, -43, -19, -31, -31, 15, 16,
    60, -7, 9, -12, -6, 15, 12, -33,
    -7, -7, -1, 21, -9, 15, 11, -4,
    -19, -3, -26, -15, 0, -1, 7, 24,
    -65, -2, -3, 9, 34, 0, -10, -7,
    8, 21, -3, 17, 4, 11, -14, -2,
    4, -15, -8, 24, -29, -31, -22, -31,
    -5, 60, -15, -34, -6, 0, 47, -15,
    -32, 7, 28, 0, 12, 35, 0, -2,
    -25, 11, -4, 21, 0, -1, 25, 7,
    13, 6, -25, -4, -30, -3, -28, -32,
    -28, -1, -8, -33, 23, -2, 22, -49,
    5, 0, -6, -8, -21, -1, 9, -11,
    22, 70, 33, 6, 34, 8, 25, -50,
    -7, -1, -4, -3, -15, 5, 16, -20,
    -30, 18, 26, 24, 31, -25, -32, 23,
    -6, 30, 18, -1, 17, 9, 33, -16,
    -27, 7, 4, -4, 1, -8, 17, 22,
    17, -31, -20, -1, -7, 33, 15, -14,
    -24, -16, 26, -18, 4, 76, -40, 8,
    6, 11, -14, -5, -19, 55, -25, -4,
    19, -14, -6, 8, 21, 22, -14, 31,
    -1, -23, -7, -14, -11, -42, 20, -62,
    -24, 10, 74, 7, 17, -35, -28, -65,
    11, -18, -22, -3, -26, -24, 1, 18,
    25, 31, 50, -25, 18, -3, -9, 3,
    -1, -10, 18, 1, -3, -54, -9, -17,
    38, -7, -2, 31, -2, -76, -14, -20,
    -11, 18, 31, -17, -9, 16, 14, 7,
    7, -8, -11, -56, -14, 31, 15, 27,
    -11, -8, -4, 29, 6, -21, -3, 3,
    44, -17, 64, 18, -6, -42, -32, -77,
    13, -14, 45, 9, 2, 35, 4, -26,
    22, 18, 24, 11, 27, 11, -7, -11,
    12, -1, 13, 21, -24, 57, 5, -3,
    -29, 13, -4, -5, 66, 57, 37, -24,
    -23, 19, -14, 19, 15, -43, 4, -9,
    9, 33, -11, -19, -12, -7, -2, -6,
    19, 28, -1, -29, -5, -10, 7, -32,
    -22, 3, 36, 38, 38, -29, -5, -10,
    8, 24, 11, 14, -4, 12, -6, 26,
    -3, 4, -9, 0, 10, -22, -40, 13,
    -24, 37, 10, -62, 29, -46, 38, -29,
    -13, 56, -1, -29, 9, 54, 18, 44,
    -33, 34, 3, 7, 10, 16, 39, 13,
    0, -4, -13, -11, 12, -30, -27, 36,
    22, -30, -8, 46, 1, 6, -2, 11,
    11, -23, -30, 17, -18, 20, 52, 34,
    21, -38, 17, 18, -19, 28, -3, 10,
    -50, 20, 4, -7, -7, -10, -2, 0,
    -26, 11, -16, -21, -3, 16, 19, 2,
    -38, -7, -8, -30, 31, -16, -4, 0,
    57, -37, -7, 2, 2, 6, -7, -10,
    -5, 24, -13, -28, 3, 6, 23, 14,
    -5, -17, 22, 14, 34, 0, -13, 22,
    27, 1, -36, 14, 14, -19, -40, -15,
    -12, -7, 7, 20, 12, 48, 23, -3,
    -22, -3, -27, 6, 39, -13, 16, 21,
    37, -71, -36, 8, -18, 30, -28, 5,
    3, 26, 28, -18, -26, -34, -14, -57,
    13, -2, -9, -19, -2, 26, -3, -7,
    -29, 32, -4, -21, 0, -12, 25, 32,
    -15, -37, -73, 5, -6, 11, 38, -3,
    3, 8, 15, -7, 10, 19, -25, 5,
    8, 30, 27, -29, -7, 30, -17, -26,
    37, 1, 8, 20, -15, 43, 8, -2,
    43, -75, -21, 14, 17, 70, -31, 21,
    -67, 65, -58, 1, 34, -36, 28, -24,
    39, 31, -13, -28, -68, -17, 33, -38,
    18, 34, -8, -23, 1, 10, 34, 54,
    19, -31, 86, 13, -93, 23, 4, -22,
    -15, -72, 35, -52, -24, 38, -14, 32,
    -18, -56, -7, -21, 14, 3, 40, -20,
    -35, -9, -6, 22, 12, -6, 8, -37,
    33, -37, 5, -7, -1, -8, 28, 4,
    85, 20, -30, 12, 84, -33, -3, -31,
    34, -22, -44, 21, -34, 7, -66, 61,
    17, -3, 2, 3, 16, 20, 10, 9,
    5, 15, 31, 25, -3, -18, -41, 20,
    -20, 58, -10, 46, 3, -10, 4, 17,
    -13, 62, -9, 127, 4, -8, -20, -4,
    10, -2, -45, -22, 9, 13, 13, 45,
    -25, -62, 23, 12, -13, 10, 23, -16,
    24, -44, 5, -40, -16, 32, 46, 5,
    9, -23, 7, 50, 46, -6, 36, 19,
    21, 11, -34, 42, 9, -50, 7, 75,
    -41, -49, 41, 9, 43, 36, 32, 58,
    33, -86, -11, 7, -87, -33, 16, -44,
    -8, 52, -25, 54, -43, 9, 36, 22,
    1, 85, 4, 15, 20, -18, -6, -16,
    -51, -27, -25, 14, -98, 7, 20, 67,
    61, 68, 18, 78, -6, -6, 67, 44,
    -74, 42, 13, 18, -24, -4, -50, 35,
    -25, -21, -4, 9, 13, 33, 43, 27,
    -7, -10, -8, 85, 29, 35, 42, -5,
    54, 35, -24, -39, -127, 70, -25, -52,
    13, -27, -14, -66, 12, 20, -22, 35,
    -4, 5, 41, -33, 9, -19, -32, -9,
    -39, 31, -49, -49, 26, 34, 5, 36,
    40, -41, 4, 38, 18, -35, 16, 9,
    -51, -27, 28, -21, -30, 35, -13, -25,
    -6, 24, 6, 8, -63, -5, -28, -32,
    -13, 15, 50, -33, -45, 23, 1, -49,
    -12, 44, -31, -32, -35, -35, 57, -21,
    1, 14, 32, 58, -17, -24, 7, -71,
    -10, 29, 18, -14, 3, -25, -54, -16,
    48, -40, -2, 1, 19, -39, 24, -79,
    -20, -49, -1, 20, -38, -16, -69, 24,
    -40, 6, 21, -34, 2, 27, 11, 13,
    21, 14, -29, 32, -28, 6, 15, -18,
    -19, -28, 15, 33, -18, -67, -1, -12,
    -48, -46, -51, -56, 34, 76, 21, -11,
    12, -87, -5, -37, -13, 3, 41, -20,
    38, 2, -4, -18, 2, -20, -17, 4,
    36, -61, -87, 42, -31, -18, -43, 19,
    -3, -32, -59, 12, -21, -24, 18, -52,
    -41, 36, 21, -2, -36, 43, -98, -31,
    -10, 47, 41, -22, 21, 2, -31, 31,
    78, 13, -59, -47, 30, 25, -2, -27,
    -39, -64, 13, 42, -25, 31, 87, 24,
    -41, 0, 92, -17, 36, -91, -30, -29,
    -7, 0, 1, 15, -3, 7, -44, 14,
    23, -37, -19, 6, -22, 0, -72, -57,
    17, 29, 9, -9, -2, 14, -67, 53,
    25, -69, -6, -11, 23, -46, -8, 4,
    24, -16, 13, 29, 9, 19, -12, -30,
    6, -9, -35, 75, -98, 52, 17, 65,
    56, -20, -19, -29, -60, 19, 4, 23,
    -51, 38, -33, 11, -11, 38, 30, 37,
    -39, -3, 3, 25, 27, 4, 9, -59,
    25, 15, 1, 12, 31, 14, 9, 11,
    71, -4, -29, 30, 85, -2, 52, -25,
    61, -6, 6, 1, 64, 17, -13, 1,
    -41, -35, 23, 1, -2, -7, -29, 43,
    -8, -15, -10, -11, -60, -39, 36, -14,
    -44, -27, 2, -4, 4, 95, -44, 49,
    -28, -21, 18, -37, -7, 22, -16, -44,
    8, 8, 27, 4, -34, 5, -34, -11,
    -36, -10, -55, -74, -61, 14, -23, -2,
    -11, -52, -45, 70, -109, 76, 8, -60,
    -10, -11, -8, 21, -16, -21, -7, 14,
    4, 15, -9, 2, 11, 27, -19, -59,
    1, 31, -29, -2, 19, 38, -49, -5,
    7, -58, 0, 22, 11, 20, 14, -17,
    -13, -34, 3, -5, 2, 19, 19, 31,
    6, 16, 62, -5, -8, 61, 46, -12,
    -3, 20, -13, 41, 24, 56, -1, 19,
    47, 31, -48, -37, -48, -45, -1, -32,
    33, -52, -23, -16, -51, -20, -32, -26,
    -19, 20, 19, -6, 20, 29, -16, 10,
    21, -72, -35, 47, 28, -63, -63, -53,
    24, 31, 3, 26, -80, 14, 44, 13,
    33, -28, -8, -35, 50, -19, 32, -22,
    -13, -46, -31, 32, 33, 96, -46, -13,
    5, 53, 0, -6, -4, -49, 48, -1,
    -33, 17, -54, 15, -34, 11, -3, 5,
    -31, -38, 3, -72, 13, -16, 13, -51,
    -32, -45, -2, -10, -5, -34, -15, 60,
    20, 8, 14, 61, 13, -21, 52, 9,
    -4, -36, 9, -4, -25, -2, -65, 44,
    -21, -11, -78, -39, -59, 46, 59, 23,
    74, 55, 35, -10, -27, 12, -42, -30,
    -33, 0, -39, -42, -7, -28, 9, -20,
    1, 4, 24, -17, -59, -4, -47, 55,
    1, 23, 34, -6, 5, 23, 62, -4,
    18, 28, -33, 30, -16, -27, 29, -10,
    -62, 15, 47, -25, -14, 69, 51, 26,
    56, 31, 45, 26, -11, -68, 28, 10,
    39, -49, 4, 9, 4, 7, -6, 39,
    16, 33, -11, 8, 10, -26, -10, -14,
    24, 58, 24, 53, 2, -57, 55, 16,
    -41, 86, -62, 55, 19, 69, -16, -41,
    -78, 25, 8, -44, -33, -15, 21, 9,
    17, 20, -17, 31, 5, -40, 38, 6,
    49, -21, 32, 86, -2, 65, 7, 91,
    -16, -67, 6, -32, -40, 56, -64, 21,
    18, 2, 29, 29, 10, -4, -53, -49,
    -47, 35, 13, 11, 18, -48, 7, -16,
    32, 25, -39, -60, 4, -1, 11, 5,
    -4, -10, -12, 3, -16, 30, -36, 26,
    -2, -12, -6, -4, 11, 24, -4, -16,
    -37, 31, 6, -16, -16, -31, -19, 5,
    -40, -15, 7, -25, 5, -18, -1, 8,
    -1, -28, 32, 16, -103, -16, 7, -51,
    10, 23, 28, 3, 11, 19, -9, -27,
    -19, 4, -43, -33, 36, 29, -18, 50,
    89, 0, 4, 31, 30, -42, 18, 17,
    -75, -37, 75, -5, 31, 16, 39, 5,
    -2, 14, -21, -67, 39, -56, -1, 31,
    0, -6, -79, 14, 6, -33, 34, 18,
    47, -37, -6, -71, 5, -47, 26, 17,
    -7, -99, -39, 14, -23, 31, 31, -27,
    -18, 6, -71, 1, 19, 47, 50, -12,
    25, -6, 27, -17, -17, -42, -6, 10,
    -8, -30, -8, 10, 8, -20, 1, 0,
    7, 11, 4, -8, -3, 4, -10, -23,
    14, 38, 7, -46, -33, -43, -22, 21,
    8, -3, 8, -19, 30, 2, 6, -8,
    -1, -4, 21, 3, 0, 2, -8, -3,
    -6, -8, 8, 7, -12, -17, 10, -4,
    -18, 20, 11, -32, 4, 14, 49, -12,
    6, -10, -25, -2, 1, -6, 2, 8,
    2, 12, -19, 15, 13, -7, -1, 7,
    -14, 4, -18, -5, 9, -5, -2, -5,
    20, -8, 19, 13, -12, -11, -53, 6,
    9, 7, 9, 19, -20, 26, 44, 16,
    2, 8, -14, 2, 3, -4, 21, -6,
    4, 13, -3, 15, -5, 19, -27, 7,
    6, -17, 17, -9, 18, 16, -2, 8,
    -10, -19, 4, -23, -2, 21, 31, 24,
    1, -10, -1, -11, 10, 6, 8, -2,
    -9, 28, -12, -6, 26, -10, 1, 8,
    -5, -6, -39, 5, -15, -1, 54, -21,
    1, 7, 37, 20, 22, 4, -9, 1,
    10, 15, 25, -8, -1, -6, -13, 26,
    -11, 9, -7, 2, 0, 5, -15, -13,
    6, 0, 7, 2, 7, -13, 21, 13,
    -30, -12, 22, -6, -24, -5, 15, -28,
    17, -21, -12, 23, 1, -20, -2, 11,
    11, 1, -14, 24, -12, 27, 16, -21,
    -13, 42, -18, -6, -18, 36, -8, -34,
    9, 17, -4, -1, -22, 1, -29, -30,
    1, -4, -1, -8, 10, -15, 2, -19,
    5, 2, -25, 24, 12, -3, -15, 7,
    7, 17, 50, 12, -40, -41, 20, -17,
    -18, 8, -36, -30, 21, -53, 19, -1,
    7, -22, 14, -14, 17, -41, -3, -5,
    -12, -8, -1, 16, 14, -9, 31, 9,
    -16, 16, -29, -34, -26, -14, 38, -28,
    1, -12, 1, 8, 7, 22, -16, -14,
    6, -47, 17, -5, 6, 13, 6, 2,
    -16, -12, -13, -5, 8, -14, 5, 18,
    -22, 28, -28, -14, 2, -25, -19, 32,
    -17, -2, -14, -23, 16, 0, 16, 19,
    -19, 9, 12, 1, -4, 1, -4, -11,
    -19, -8, -6, -4, 3, 3, 16, -16,
    7, -2, -12, 11, 43, 36, -3, 15,
    -27, 5, -7, -10, 16, -1, -1, 20,
    -11, 0, 17, -27, 9, -7, 8, 19,
    -18, 25, -14, -33, -3, -3, -14, -4,
    3, -21, -16, 4, 13, -27, 0, 10,
    4, 4, -6, -15, -12, 7, -11, 8,
    20, -15, -9, -2, 4, 4, 4, -3,
    9, -13, 4, -3, -9, -14, 2, -13,
    -10, 11, -6, 9, 5, -50, 11, -25,
    9, -10, 28, -19, -5, 9, 2, -7,
    -4, 20, 11, -15, 0, -10, -4, 0,
    8, 6, -30, 1, 1, -26, 26, 13,
    23, -8, 27, 6, 34, -7, -10, 21,
    -2, -13, -11, 19, -16, 23, 6, 8,
    -29, -35, 11, 17, -19, -14, 1, -4,
    15, 9, -26, -8, 38, -6, -4, 17,
    20, -35, -11, 11, 40, -2, 15, -2,
    1, 38, 5, 1, 14, 31, 2, 18,
    11, 21, 11, 18, 15, -10, -4, -11,
    14, -24, -1, -5, -9, -11, -6, -8,
    -36, 9, -29, -13, -18, -18, -8, 24,
    5, 0, 5, 10, -2, 8, -3, 18,
    23, 4, -5, 25, 22, 4, -3, 1,
    -1, 1, -6, 8, 15, -15, -6, 6,
    -6, -10, -1, 28, 5, -30, -6, 3,
    1, -7, 10, 3, 14, 16, 15, -7,
    10, 13, -21, -10, -2, 22, -10, 18,
    -2, -17, 10, 14, 4, -19, 10, 9,
    9, -50, -24, 1, -15, 22, 18, 0,
    -24, 6, 12, -14, 20, 4, 0, -7,
    -13, -7, -18, 2, 22, 4, 4, -14,
    -7, 7, 13, 3, 31, -2, 2, -1,
    22, -9, 14, 6, 25, 27, 3, 6,
    44, 20, -15, -12, -9, 25, -15, -13,
    23, 14, -24, 36, 16, -11, 7, 10,
    -2, 3, 6, 12, 21, -7, -6, -18,
    18, -12, 29, 5, 6, 15, -16, 23,
    -15, 10, -2, -11, 4, 24, -22, -26,
    -14, 7, -6, 14, 3, -1, 21, -20,
    4, 14, 16, -12, -3, 2, 10, -22,
    -14, -45, -18, 18, -3, -17, -1, 7,
    1, 8, 1, 23, -26, -10, 4, -4,
    2, -18, -4, 27, 8, 5, 18, 12,
    -1, -5, 5, 8, 1, -5, -8, -1,
    -12, -9, -17, 1, -11, -10, -41, 5,
    5, -17, 13, 10, 20, -23, 21, -30,
    4, -2, -21, 7, 4, -14, 0, -16,
    13, -5, 19, 13, 6, 8, 21, 32,
    -10, 17, 9, 5, -1, 2, 19, -10,
    16, -7, 3, -4, -1, 18, -17, -16,
    1, -10, 11, 25, 15, 12, 4, -10,
    4, 10, -14, 14, -11, -17, -10, 5,
    -1, 29, 38, 26, 10, -2, 43, -10,
    -1, 8, -8, 0, 2, 3, -24, -19,
    3, -13, -24, -17, -3, 10, 11, -9,
    9, -5, -4, 13, -1, -1, 25, 0,
    2, 16, -27, 3, -27, 5, -31, -7,
    6, 11, -12, 1, -4, -22, -6, 5,
    -4, -23, 14, 8, 15, 5, 14, -17,
    29, -6, -4, -3, 9, 10, 1, 9,
    -22, 19, -2, 18, 26, 14, 38, 1,
    2, -11, 7, -18, 6, 32, -4, -3,
    -20, 27, 32, 22, -5, -6, -12, 6,
    -5, 15, 15, 13, 4, -6, 18, 3,
    3, -21, -19, 33, -8, 9, -8, -7,
    -4, 4, 5, 23, 2, -4, -3, -18,
    -24, 17, -12, 21, 4, -1, 1, 16,
    -16, -4, -3, 31, 27, -5, 19, -16,
    14, -9, -4, 30, -9, 15, -3, -51,
    26, -8, 3, -13, 25, 52, -13, -2,
    -18, -20, -21, -13, -7, 2, 6, -13,
    8, 20, -4, 9, 11, -13, 0, 4,
    -25, -17, -29, 8, 3, 38, 13, 12,
    -35, -6, 23, 18, 24, -17, 14, 0,
    14, 18, -24, 34, 0, -2, 2, 0,
    -15, 1, -19, -19, -7, 0, 11, -11,
    -36, 6, 36, -39, -14, 2, 18, 2,
    9, -13, 4, 3, 7, -8, -16, -4,
    3, 7, 0, 2, -6, -25, -7, -35,
    -14, -6, -28, 5, 15, 3, 1, 7,
    9, -31, 48, -4, 18, 22, -21, 15,
    27, 7, 17, 24, 11, -17, -2, 8,
    24, -3, 26, 3, -18, 17, -13, -4,
    -1, 3, 5, 20, -5, 10, -40, -5,
    5, -22, 9, -23, 16, 28, -8, -14,
    18, 2, 12, 22, 22, -38, 34, -34,
    -1, 10, -22, -28, 27, -20, -2, 2,
    16, -13, -5, 52, -11, 15, -15, -4,
    14, 19, -4, -13, -11, 26, -16, 7,
    -6, -3, -4, -14, 17, -11, -1, 4,
    6, -14, 27, 2, -8, 7, -9, 24,
    6, -6, -22, -11, -12, -8, -1, -12,
    36, -16, 5, -32, 42, -18, 30, 11,
    2, 17, 33, 8, 5, 38, 16, -2,
    33, -15, 3, 15, 11, 3, 1, 16,
    9, 16, -31, -3, -6, 46, -34, 3,
    5, -26, 38, -3, 5, -29, -12, 0,
    -1, 28, 20, -3, 14, 14, 46, 20,
    1, -16, 6, 7, 9, 10, 7, 6,
    21, -30, 25, -33, 3, -12, -9, 15,
    -6, -15, -23, -30, 1, -53, 45, -42,
    12, -18, 9, 1, -60, -3, 15, 33,
    19, -22, -24, 33, 12, 20, 8, -15,
    12, 1, 6, 8, -2, 6, 4, -26,
    -22, -7, 4, 23, 2, 11, 2, 21,
    28, 3, -17, -16, 40, -18, -4, 9,
    11, -15, -30, 1, 24, 14, -25, 14,
    7, 3, -15, -28, -19, 0, -8, 14,
    -31, 1, 46, -49, 13, 2, -37, 1,
    7, -7, 18, 5, -5, 23, -4, -30,
    13, 13, 4, 57, -14, -30, 16, 15,
    -3, -11, 8, 23, 6, -4, -15, -21,
    12, 24, -40, -68, -5, 67, 18, 68,
    -12, -12, 10, -12, -22, -16, -31, -23,
    2, 9, -27, 0, 13, -21, -4, -38,
    18, -4, 24, -9, -52, 9, -5, 24,
    -14, 38, 8, 25, 30, 18, 48, -78,
    -27, 17, 7, -7, 20, -57, 19, 1,
    -6, -3, 10, -4, 18, -21, 17, 3,
    17, 4, 13, -22, 10, -45, 4, 7,
    -19, 37, -40, -9, -1, 26, 53, -11,
    26, -11, -2, 0, 35, 3, 28, -2,
    -11, -3, 7, 12, -6, -23, -10, 1,
    17, -16, 3, 22, 18, 4, -3, 7,
    -31, 11, -19, 26, -42, -20, -62, 18,
    -35, 7, 3, 2, 10, 13, 6, 8,
    21, 17, -12, -7, 16, 4, -16, -15,
    32, -5, 3, 14, 10, -6, 4, -2,
    14, 23, 34, 11, 27, 17, -13, 15,
    -1, 24, 3, 40, 3, -4, -1, 45,
    12, 32, -3, -14, 4, 4, 19, -5,
    -33, 26, -7, -22, 23, -25, -34, 19,
    62, 0, 4, -4, -82, -2, -13, -74,
    6, 22, -15, 5, -23, -4, -4, 10,
    -3, 4, -13, 19, -1, -7, -5, -15,
    0, 5, -3, 2, 40, -3, 1, 11,
    12, -6, -26, -26, 12, -44, -2, -9,
    -36, -1, -16, 7, 9, 22, 5, 6,
    27, -10, 11, 44, -21, 16, -33, 13,
    29, 17, 15, -27, 53, -20, 25, 11,
    -2, 15, 19, -2, -26, 0, 34, 38,
    -30, 11, -33, 7, -18, 24, 1, 13,
    24, 1, 2, -13, -12, 6, -14, -14,
    -14, -12, 8, -26, -4, 12, 25, -3,
    57, -17, -36, 36, 36, -3, 2, 0,
    -15, -10, 2, 5, 36, -6, -12, 14,
    4, -20, -4, 4, 16, -12, -22, -20,
    2, -5, -13, -11, 16, 3, -3, -10,
    -48, 32, -1, 41, -50, -20, -15, -39,
    40, -1, 21, 17, -5, -15, 17, 25,
    -37, 11, -8, -2, 24, -3, 17, -2,
    4, 3, 18, 21, 23, -17, 10, -3,
    -29, -27, -27, 2, 11, -16, -18, 33,
    21, 14, -28, 23, -2, 26, -1, 2,
    -18, 11, -19, -25, 12, -5, 6, 12,
    -2, 6, 2, -19, 0, -17, -19, 4,
    14, -15, 3, 5, -1, -18, -21, -7,
    -28, -8, 5, -51, 13, -12, 1, -22,
    -26, -32, -12, -18, 16, 10, 6, 10,
    -10, 18, 6, 0, 15, 10, 3, 54,
    -58, -37, -5, 37, 32, -10, 18, -18,
    17, 31, -5, -18, -35, -22, 3, 7,
    24, 12, 12, 10, 7, -16, 25, 16,
    -14, -20, 20, 17, 7, 12, -16, 6,
    24, 10, 67, -5, 22, -86, 11, -7,
    -26, 17, 24, -23, -7, 36, -16, 3,
    7, -25, 4, -4, 2, 4, 23, -40,
    -22, 26, 7, -32, 25, -28, -14, 24,
    32, -26, -34, 52, -49, -27, -2, -44,
    6, -11, -2, 44, -25, -23, 9, 19,
    14, -14, 21, 15, 4, 19, 23, 20,
    19, 11, -10, -12, -7, -18, -2, -31,
    -6, -66, 19, -54, -28, -9, -63, 4,
    -8, -2, 5, -13, 2, -9, 1, 3,
    -1, -11, -3, 12, 4, -25, 3, -3,
    4, -8, -40, 20, 9, -34, 14, 25,
    22, 23, -3, -19, -56, -48, -30, -4,
    14, -13, 14, 24, -54, -18, -2, -27,
    18, 61, 36, 34, 29, -8, -19, 1,
    11, -39, -16, 43, 1, 30, 51, -2,
    -19, 68, 26, -23, 64, -2, -26, -7,
    15, 34, -10, 12, -6, 6, -47, 16,
    12, -14, -11, 11, 2, 21, 16, 1,
    11, -26, -11, 2, 2, -33, 12, 2,
    -12, -5, -27, -5, 22, -1, -20, 32,
    -18, 14, 5, 11, 8, -32, 20, -15,
    -29, 0, -3, 23, 21, 6, 6, -25,
    -8, 40, -15, 15, -7, -30, -4, 0,
    -20, -16, 20, -2, 24, 3, 2, -20,
    -1, -20, -4, 7, -1, 64, 9, 35,
    -10, 4, 4, 12, 1, -24, -18, -9,
    30, 15, -12, 8, -25, -6, 34, -14,
    8, -17, -22, -23, 2, 44, -13, -40,
    16, -18, -32, 6, 19, 2, 4, -26,
    -12, -27, -40, -19, -16, -10, -6, -2,
    -21, -21, 0, 14, -6, -25, 13, -10,
    -12, 20, 36, 3, -55, 16, 37, -24,
    19, -11, 8, 3, -23, 7, -11, -3,
    8, -2, 6, 17, -2, 7, -8, 4,
    80, 49, -1, -1, 4, 12, -7, -7,
    -45, 6, -18, 13, 38, 41, 34, 10,
    -25, 25, -13, 25, 73, -55, -22, -17,
    17, 25, -2, -5, -1, 6, 8, 10,
    -35, -9, 2, -10, 29, -15, 20, -24,
    11, 8, 63, -26, -10, -9, 18, 1,
    -5, -11, 5, -6, -14, -3, 0, 10,
    30, -56, -9, -6, -3, 3, 6, -31,
    -30, -4, -3, -9, -16, 34, -20, -4,
    -15, -33, 17, 13, -14, -15, -17, 37,
    25, 42, 44, -29, 7, -32, -19, -9,
    39, -58, 20, 6, -8, 23, -7, -1,
    -1, -22, 33, 10, 15, 27, -27, -9,
    19, -61, -34, -19, -35, -16, 7, 32,
    -27, -3, 5, 61, -81, -48, 58, 1,
    -10, 56, 18, 13, 44, -8, -10, 37,
    -1, -2, -1, -25, -36, 9, -8, -27,
    -36, 20, -47, -44, -18, 17, 4, -5,
    43, 9, 14, -8, -41, -42, 59, 23,
    11, 18, -18, -18, -39, -23, -48, 58,
    35, 4, -4, -24, -34, -20, 16, -3,
    74, 10, 53, -39, -62, -23, -24, -28,
    3, 28, -10, 25, 15, -15, -2, -22,
    -36, 35, -30, 18, 2, 17, -17, 15,
    47, 8, -35, -3, 33, -5, 27, -7,
    14, -117, 26, 10, -38, -6, -9, -13,
    -25, -22, -4, -21, 17, 4, 22, -8,
    1, -61, 33, -2, 5, 0, 9, 12,
    -18, -14, -40, 3, 25, -7, -10, -27,
    4, -53, 10, 0, 20, 30, -24, 24,
    34, 28, -18, 38, -83, 16, 36, 35,
    -2, 2, -10, -31, 1, 18, 19, -37,
    20, -6, 14, 6, 16, 18, 11, -64,
    -51, -64, -4, 50, -96, 1, -16, -58,
    38, -46, -14, 45, -22, 20, -36, 56,
    -39, -5, -24, -25, 13, 10, -66, 42,
    -27, -40, -5, -23, 13, -9, 6, -18,
    -51, -3, 97, -88, 65, 41, 20, 38,
    62, 67, -52, 32, 12, 17, 42, -1,
    -7, 23, -9, -120, -54, -75, 21, 45,
    25, 41, -16, -26, 11, 53, -7, 1,
    15, 30, -51, -39, -46, -58, 24, 13,
    10, 12, 49, -11, 11, 29, -14, -44,
    -27, -12, -37, 3, 36, -47, -17, -76,
    -51, -4, 13, -15, 43, 5, 45, 27,
    3, 43, -45, -2, -55, -22, 46, 15,
    13, 12, 33, -9, -21, -56, -1, 19,
    -4, 46, -5, 15, -3, -15, 21, -1,
    22, -4, 5, 12, -21, 9, 0, -6,
    -33, 17, -7, 1, 33, 7, -17, 25,
    -75, -14, 19, -13, 22, 1, 80, 3,
    48, -18, 11, 39, 5, -15, -19, 22,
    22, -3, 11, 7, -7, 51, -22, 13,
    7, 59, 12, -41, 54, 23, -44, 24,
    43, 23, 2, -16, 31, 25, -1, 7,
    -14, -1, 13, -43, 23, 5, -23, -1,
    -38, -4, -7, 29, 16, -7, -9, -2,
    -1, -42, 2, 18, -28, 50, -44, 36,
    83, -19, -50, 9, -1, 14, 19, 18,
    -2, 34, -21, 7, -9, 32, 13, -23,
    6, 33, -17, 47, -18, 14, -46, -83,
    61, -10, 9, -16, 68, -6, -13, 1,
    11, -20, 20, -6, 14, 2, -45, 33,
    -16, 16, 57, -13, -10, -16, -37, 0,
    1, 4, 13, -27, 36, 17, -17, 13,
    -40, 24, -63, 11, 40, -11, 25, 10,
    2, 48, -45, 26, 29, 17, 48, 10,
    -26, 18, 43, -47, -37, 38, -52, -39,
    -42, -33, 17, 0, -18, -10, -20, -9,
    7, -96, 95, 6, 33, 45, -3, -76,
    14, 43, 7, -20, 15, 4, -54, -6,
    10, 52, -25, -37, -11, 21, -28, -15,
    -6, 17, -11, 8, 20, -4, 19, -24,
    92, 21, -24, 20, -11, -59, 35, -16,
    39, -59, 38, 13, 35, -34, -48, -4,
    36, -47, -14, -20, 73, -21, -35, -33,
    2, 7, -7, 24, -1, 12, -12, -8,
    -68, 16, -4, 17, -25, 47, -28, 15,
    2, 7, -1, -23, 1, -29, 9, -27,
    7, 11, -32, -59, 22, -8, 47, -45,
    -14, -8, 29, 12, -11, -20, -15, 4,
    -70, -15, -67, -15, 22, -12, -49, 22,
    1, -20, -41, 22, 11, 46, 46, -36,
    32, -32, 23, 12, 12, -1, 3, 0,
    11, 2, -15, 29, -4, 9, -50, -13,
    26, -24, -8, 10, -8, -3, 1, 21,
    21, -60, -15, 52, 35, 28, -8, -68,
    -26, -13, -20, -18, 35, 17, -6, 23,
    33, -50, -18, 36, 4, 13, -33, 18,
    -56, -63, -37, 28, -14, -60, 81, -42,
    6, 22, -18, 8, -68, -26, 3, -13,
    -25, 33, 28, -39, 11, 0, 1, 11,
    -21, -43, -6, 13, 6, 16, 9, 9,
    -12, 82, 47, -36, -9, -72, -27, 11,
    71, 21, -2, 23, 9, 37, 3, 3,
    33, 10, 32, -38, -13, 7, 44, -22,
    19, 15, -52, 22, 9, -5, -40, -13,
    -19, -51, -44, 101, 77, 52, 55, -18,
    5, -14, 13, 31, 0, -54, -38, 61,
    -2, 48, 24, -44, 1, 60, 25, 16,
    -3, 6, 45, -5, 18, 19, 26, 4,
    16, -100, 23, -7, -54, 45, 39, 30,
    -22, -30, -1, 13, -37, 2, -18, 5,
    -4, -7, 5, 2, 6, -22, -7, -5,
    -6, 19, 52, -67, -18, 25, -34, 5,
    -23, 61, 8, -9, 8, 19, 6, -62,
    -3, 20, -10, 7, -26, 21, -32, -39,
    -46, -16, -13, -18, 4, -28, -16, 15,
    17, 7, 6, -19, 14, -37, 1, 2,
    9, 120, 61, -73, 64, -17, 12, -75,
    70, -42, -1, -9, -54, 22, -66, 6,
    26, -10, 35, 13, -8, 30, 24, 0,
    -12, 22, -11, -27, 14, -9, -6, -14,
    62, 33, -38, -1, -28, 42, 33, -4,
    4, 25, 4, 25, -16, 21, 30, -32,
    6, 50, -13, 12, 22, 26, 15, -32,
    -30, 11, -16, -10, 5, 18, 2, 8,
    -67, -39, 17, 64, 5, -8, -22, -87,
    4, -22, 23, 10, -7, 71, 18, 25,
    -14, -66, -33, -30, 14, -18, -15, -2,
    3, -24, -41, -30, 15, -5, 13, 14,
    -7, -64, -54, 36, -8, -21, -12, -38,
    -33, -40, 48, -47, -10, 32, -49, -4,
    -16, 24, 29, -18, -51, 1, 13, 0,
    -9, 13, 25, -19, -10, -8, 8, -62,
    10, -21, -6, -4, 29, -44, 21, 20,
    -65, 15, 17, 39, -74, 3, -36, -26,
    22, -7, -8, 32, 32, 28, -23, 6,
    -18, -50, -4, 1, -13, 2, -16, -5,
    -50, -6, -38, -6, 2, 26, -3, 27,
    -13, -21, -6, -22, 22, -64, -44, -3,
    11, 5, 8, 6, -14, 28, 5, 41,
    21, -6, 32, -11, 21, -32, 9, 24,
    -48, 18, 18, -35, -57, 20, 4, 43,
    22, 8, -7, -54, 8, 6, -1, 49,
    -11, 51, 9, 39, 7, 16, 6, -29,
    -2, -41, 16, -19, -5, 17, 27, -15,
    59, -105, 9, 106, -43, -71, 19, -8,
    12, -7, -30, 11, -16, -59, -11, -34,
    -25, 27, -7, -96, -9, 20, 23, -15,
    -2, -24, 37, -69, 16, -13, 23, 12,
    41, -115, -7, -1, -32, 13, 9, 53,
    4, -5, 33, 1, 17, 51, -29, -20,
    21, 2, 12, 4, 50, 23, 15, 5,
    -9, -33, -8, -4, -2, -5, -12, 14,
    3, 14, -15, 58, -3, -43, -11, 28,
    11, -1, -2, 5, 30, -17, -9, 17,
    -9, -3, 21, -17, -17, -13, 24, 13,
    4, 12, 11, -11, 0, -29, 20, 7,
    33, 2, -10, 16, -15, -5, 4, 6,
    -6, 3, -9, -4, 12, -5, 9, -28,
    1, -1, -1, 2, 3, -5, 9, -21,
    28, -10, -4, 24, -9, 36, -35, -4,
    3, 46, 3, -30, 3, 14, 1, 43,
    7, 10, 17, 1, -33, 14, -42, 5,
    -10, 36, 15, -2, -8, -1, -28, -19,
    -1, -3, 11, 9, 0, 22, 2, -23,
    -18, 50, 48, 6, 0, 49, -31, 23,
    21, -6, -4, 2, -6, -4, -5, 18,
    8, -30, 22, 6, -3, 8, 13, 19,
    -7, 10, -15, 15, 16, -5, -4, -1,
    -7, -16, -13, -24, -1, -30, -3, -7,
    16, -10, 9, 27, -6, 5, 31, -26,
    32, -48, -24, -34, -11, 26, 0, 12,
    -23, 7, -9, 8, 11, 2, -4, 3,
    17, -3, -40, 47, -6, -23, -20, 18,
    3, -9, -6, 0, -35, 9, 4, -2,
    -3, -33, 14, 16, 44, -12, -27, -14,
    -16, -3, -5, -9, 36, -10, -1, 32,
    36, -19, -34, -44, -2, 6, -1, 29,
    -13, -7, -13, -14, 1, 11, -1, 15,
    6, -10, 2, -3, 22, 9, 2, 8,
    8, 1, 15, -1, 9, 21, 20, 8,
    7, -48, -16, 0, 13, -6, -17, 12,
    7, -15, -4, 6, -4, 13, -9, 5,
    22, -12, 19, -38, -19, 9, -18, 0,
    1, -15, 17, 4, -5, -7, 14, -9,
    0, -68, 19, -17, -10, 1, -11, -8,
    4, -5, 7, 13, 34, 12, -21, 3,
    9, 10, -18, 30, -1, 4, -14, -29,
    -5, -2, 21, -24, 11, -39, 6, 16,
    -9, -15, -21, -6, 29, 2, 11, -1,
    4, -8, 5, -6, 5, -7, 17, 6,
    21, 1, 6, -1, 12, 36, -27, -11,
    -11, -1, 4, 11, 7, 24, 10, 4,
    1, 45, 21, 3, -4, 10, -23, 6,
    10, -23, -1, -17, 8, 15, 1, 4,
    -11, 41, -4, -64, 15, 8, 8, 8,
    10, 1, -5, 2, 0, 2, 14, 2,
    10, -7, -18, -39, 14, -15, -2, -6,
    -5, -7, -9, -19, 4, -6, 6, -7,
    -28, 1, 7, 17, 32, 9, -13, 27,
    3, 11, -2, -13, 17, -13, -57, -2,
    36, -10, 0, 42, 16, 4, 6, -11,
    -4, -4, -2, 26, -8, 0, -18, 3,
    14, -13, -26, -39, 37, 19, -35, 35,
    12, 10, 5, 10, -6, 6, 8, -7,
    -12, -42, -3, -40, -10, -2, -8, -17,
    3, 8, -14, -26, 17, -4, 12, -1,
    -9, 32, -21, 24, -20, 20, -2, -9,
    -17, 1, 11, 104, 6, -26, 30, 13,
    -43, -3, 46, -39, -13, -5, 13, 99,
    -10, -10, -5, 12, 13, 16, 23, -4,
    1, 33, 13, 30, 5, 31, 3, 5,
    -3, -10, 0, 11, 33, 5, 21, 19,
    8, -10, 17, -20, -9, -10, 16, -6,
    0, 4, 6, 0, -3, 13, 38, 15,
    -5, 3, -29, -6, 18, -8, 4, -7,
    5, 37, 22, -8, 25, -4, -17, -16,
    -11, 11, -33, -49, -7, -4, 9, 11,
    1, -13, -18, 5, 17, -4, -7, -3,
    -9, -11, -2, 6, 14, 15, -35, -9,
    -20, 19, 12, 6, -18, 10, -12, -9,
    -3, 43, -9, 10, 12, -8, -8, 25,
    2, -10, 6, -8, 8, 27, 2, 8,
    8, 31, -7, 29, 16, 40, -33, -8,
    15, -8, -4, -9, -17, -17, -9, 39,
    -30, 40, -5, -54, -19, 8, 4, -4,
    -4, 6, 0, 1, 15, -14, -10, 9,
    -7, 12, -18, 12, -7, 13, 34, 10,
    3, 8, 4, -17, 20, 15, -3, -10,
    60, -7, -34, -37, 3, -8, -15, 4,
    -14, -6, 3, 13, -31, -24, 18, 17,
    -33, 18, -12, -12, -22, 27, -17, 17,
    -4, 3, -7, 9, -14, -14, -14, 3,
    1, -1, -29, 45, 17, -16, -2, 4,
    6, -22, -10, 2, -10, 2, -5, 13,
    19, -19, -9, 5, 23, 1, 3, 37,
    4, 0, -2, -2, -23, 2, -22, -19,
    -13, -42, 17, 59, -15, 0, -10, 26,
    -8, -8, 16, -1, 32, -11, -7, 15,
    2, -13, -6, -39, 2, 9, 32, -27,
    9, 8, -15, 4, -15, 15, 3, 5,
    -42, -26, 60, 10, 7, -14, -26, -1,
    -4, -11, -25, -12, 21, -18, 23, 23,
    30, -32, 4, -4, 14, 14, 25, 15,
    -15, -10, -6, 1, 19, -5, -31, -6,
    64, 41, 78, 28, 0, 6, -20, 12,
    22, 5, 0, 3, 12, 1, -7, -9,
    -14, 9, 8, 16, -2, -13, -52, 3,
    -4, 3, -3, 12, -6, -13, -12, -13,
    33, -36, -1, 12, 8, -8, -7, 2,
    10, 3, -6, -1, 28, -5, 10, -5,
    12, -20, -23, -13, -32, 22, 36, -24,
    2, 20, 26, 1, -25, -21, -1, -1,
    31, 27, 44, -45, -12, -18, -1, 1,
    1, -7, 1, 25, 11, -39, 11, -11,
    48, -18, 24, 9, -20, 17, 13, -17,
    -6, 24, 0, 6, -9, -13, 9, 30,
    -39, 34, 12, 16, 1, -14, 21, -1,
    -11, -9, -3, 1, 1, -3, -1, -2,
    -3, 1, 20, -5, 2, -5, -16, -13,
    10, -11, -2, 9, -3, 5, 13, -10,
    2, -43, 1, 0, -12, -1, -10, -14,
    4, -5, 7, 1, -4, 1, 22, 8,
    2, 27, 6, -14, -14, 9, 0, -17,
    5, 13, 1, 12, -2, 27, -4, 14,
    0, 42, 6, -25, 1, -4, 2, -9,
    -10, -6, 2, -5, -7, -10, -3, -11,
    -59, 24, -18, 4, 9, -3, -41, -8,
    24, 12, -2, -9, -1, 12, -19, 12,
    57, -15, 28, 32, 3, 19, -5, 16,
    -7, 9, 10, 15, -11, 8, 2, 22,
    25, -4, -20, -34, 18, -16, -9, 17,
    15, 0, -14, 7, 2, -44, 3, -29,
    -7, 20, -56, -4, -12, -4, 15, -7,
    -1, 10, -7, -23, 4, 52, 4, 7,
    35, 5, 8, 39, 3, 9, 9, 22,
    8, -14, -7, 0, 9, -18, 28, -1,
    -9, -14, 48, -19, 6, -2, 15, -1,
    -17, -2, 21, 16, 4, 15, -7, 35,
    -24, 10, 23, -17, 17, -14, 7, 6,
    14, -17, -6, 22, 50, 4, -1, -30,
    -17, 2, -40, 42, -20, -32, 1, 9,
    18, 7, -9, -1, 5, -14, -5, 14,
    -29, 2, -31, -11, -30, 12, 34, -8,
    7, 14, 12, -1, 30, -55, 25, 16,
    27, -8, 42, 51, -29, -2, 2, 24,
    2, 10, 19, 3, 30, 22, 3, -31,
    -12, -18, -43, -14, 14, 10, -34, -5,
    10, -13, -11, 28, -9, 40, 12, 6,
    40, -1, -5, -49, -26, 3, -32, 44,
    1, -6, 35, -6, -8, -16, -36, 29,
    -28, -3, -13, 27, 29, 25, -19, 2,
    -1, 7, -8, 3, -6, 0, 12, 4,
    -7, 21, 24, -23, -14, 11, -5, 17,
    17, -11, -5, -3, 9, -7, -17, -18,
    24, 0, 12, 13, -15, -9, 0, 15,
    -4, 26, 6, 12, 6, -16, 9, -39,
    2, -10, -2, -42, -8, -5, -12, -7,
    16, 10, -9, 35, 5, 0, 6, 0,
    53, -14, 6, 5, -35, -4, 20, 10,
    -14, 20, -15, 8, 14, -6, 14, 23,
    28, 9, -18, -9, 10, 24, 5, 9,
    6, -12, -27, -1, -1, 28, -3, -1,
    2, 23, 18, -20, 49, 4, -12, -20,
    10, 6, 1, -11, 13, -4, 0, 12,
    2, -55, -32, 21, -3, -34, -3, 23,
    -41, -4, -6, -4, 39, 9, -1, 1,
    29, 52, 20, 8, -16, -25, 13, 7,
    -31, 25, 16, -15, 21, -15, 32, 1,
    43, -14, -10, 18, 25, -12, -18, 32,
    13, -23, -6, 1, -26, -6, -26, -4,
    -15, -1, -34, 5, 11, -5, -22, 1,
    7, -24, 20, 3, 10, -1, -19, -18,
    -12, 6, -12, -10, -3, 5, 8, 10,
    -1, -12, 6, -2, 17, 15, -22, -21,
    -11, 33, 17, -21, 24, 9, 1, -12,
    -3, -11, 0, -8, 0, -26, -1, -6,
    -13, 9, -14, -17, -9, -9, 14, -9,
    13, -13, -2, -5, -34, -13, -7, -3,
    -9, 4, 14, -23, -43, 22, -23, -25,
    4, -6, 18, 6, -4, 28, 9, -14,
    13, 7, 7, -4, 1, -8, -3, 5,
    31, -24, 8, -35, -32, 20, 5, 12,
    17, -17, -5, 29, 26, -20, 21, 21,
    15, 19, 2, 0, -35, -43, 19, -20,
    -32, 29, -39, -62, -5, 12, -2, -1,
    10, -9, -14, -4, 7, 7, -13, -8,
    -35, 26, 3, -33, 7, -4, 0, 41,
    18, 13, 4, -26, 24, -24, -77, -4,
    47, -5, -38, -14, 12, 16, -5, -27,
    15, 11, -5, 54, 0, -1, -13, -10,
    -1, -6, -14, -15, 34, 13, -17, -1,
    -3, 1, 11, 16, 14, 35, -10, -7,
    32, 13, 10, -32, 3, -13, 5, 11,
    2, 2, -20, -14, -15, -7, -14, -3,
    24, -11, -10, 17, -7, -6, -19, -23,
    -27, 1, 21, 105, -22, 3, 33, 4,
    45, -36, 4, -28, -7, -7, 8, 104,
    -4, -6, -14, 33, 43, -29, 31, 15,
    8, 18, 5, 31, 1, 18, 0, -12,
    7, -7, 10, -12, 16, -10, 20, -11,
    7, -24, -12, -37, -5, -19, 6, -9,
    -12, -12, 10, -3, 6, 24, 23, 3,
    -2, -6, -17, -53, -25, -4, -24, -22,
    12, 41, 9, 5, 1, 14, -3, 29,
    -8, 27, -9, -24, -11, -11, 3, -16,
    3, -23, -28, 4, -4, -24, 5, 34,
    18, 30, 31, 6, 21, 37, -4, 1,
    -28, 19, -8, 11, -8, 1, 1, -25,
    9, -5, 24, 6, 44, 20, -13, -1,
    16, 6, 0, 23, -40, -25, -18, 42,
    4, -69, -3, 16, 15, 12, -21, -27,
    4, 2, -5, 6, -16, -12, -42, 47,
    16, 4, -23, -37, -20, -11, -4, 4,
    -15, 33, 4, 10, -27, 23, 5, -2,
    -10, -19, -7, 5, 4, -15, -25, 7,
    -2, -13, 9, -10, -13, -20, 7, -3,
    49, -15, -15, -2, 9, 8, -30, -23,
    -16, -24, 41, 32, 10, 24, 78, 22,
    65, 25, -19, -22, -32, 11, -10, 10,
    25, -10, -4, 9, 2, 48, 18, 29,
    -56, -14, 25, -15, 6, -19, 1, -9,
    7, -21, -5, -7, -19, 25, 0, 9,
    33, -20, 44, -3, 23, -24, 4, 28,
    9, 19, -6, -6, 10, -10, -20, -20,
    -24, -24, 31, -3, 18, -1, -13, 7,
    -9, -1, 11, -10, 14, -11, 6, 25,
    -2, 2, 18, -19, -9, 18, 3, 33,
    -2, 12, 3, 1, -29, 23, -43, 30,
    -43, 35, 46, -6, 6, -1, 2, -10,
    13, -39, -29, 10, 25, 37, -21, -3,
    -21, -14, -5, 25, -21, -4, 18, -4,
    -9, 3, -21, 11, 47, 14, -38, -3,
    -4, -20, 9, -2, 0, -1, -9, 9,
    4, -3, 9, -7, 2, -16, 11, 18,
    -28, -42, 8, -9, 6, -17, -57, 16,
    -2, -19, 3, 14, 45, 23, -16, 0,
    -23, 8, 3, 4, 7, -6, 4, 6,
    -10, 6, 5, -5, 14, 43, 20, -3,
    41, -7, -22, -8, -6, 0, 16, 22,
    -3, 5, 20, -1, -11, -5, 17, -4,
    22, 19, 35, 19, 9, -6, -7, 12,
    0, -14, 0, 11, 11, -45, -8, 5,
    1, -25, 30, 42, -9, 19, 8, 13,
    -1, 38, 3, 0, -8, -22, 13, 15,
    -20, -24, 13, 12, -5, -6, 10, 2,
    -9, -1, 7, 10, -20, -10, 4, 9,
    -1, 3, -68, 15, 19, -10, -2, 17,
    7, -14, -10, 2, -15, -9, 26, -5,
    43, -29, 25, -17, -10, 4, -11, 1,
    31, -7, 3, -3, -31, 1, 25, 13,
    -66, 30, 18, 6, 54, -12, 9, -6,
    -9, -7, -5, 7, 48, 16, 6, 11,
    -35, 13, 11, 8, -11, -16, 37, -4,
    2, -11, -26, -3, 2, 32, 13, -9,
    41, -16, -5, -20, -20, 10, -20, -14,
    -1, 21, -4, -5, 1, -2, 31, -6,
    0, 32, 28, 9, 12, 0, 13, 12,
    -19, -4, -4, 12, -27, 0, -2, 26,
    -35, 38, 27, -18, 14, 10, 8, 20,
    16, 1, -23, 8, -19, 7, 0, -34,
    -22, -6, 9, 25, 13, 5, 6, -2,
    -12, 19, 0, -19, -4, 0, 1, 12,
    -27, -68, -28, -19, 3, 34, 19, -32,
    2, -9, -33, 1, 14, -6, 19, 24,
    8, -39, 29, 24, -8, 2, 2, 27,
    -18, -9, 45, 23, 10, 36, 18, -35,
    15, -51, 3, -8, -10, -17, -39, -49,
    -28, -7, -15, 45, 31, 29, 12, -35,
    21, 36, -84, 24, -15, -6, -11, 20,
    24, 8, -14, 15, 23, 10, 25, -29,
    -54, 6, 50, 25, 49, -52, -7, -42,
    8, 4, 30, 7, 10, -98, 36, 24,
    22, 16, 29, 49, 4, -4, -5, -3,
    4, -11, 23, -3, -8, 22, 63, -15,
    -44, -13, 32, -23, 15, -13, -3, 23,
    -9, -11, -1, 25, 0, -57, 13, -14,
    -3, 82, -51, -13, 8, -3, 11, 101,
    0, -10, 56, -14, 14, 2, 43, -4,
    12, 43, -66, 14, 0, 17, 76, 2,
    -8, -9, -2, 7, -14, 48, 1, 23,
    -17, 24, -61, 14, 19, 1, -15, 28,
    39, -31, -3, -17, 39, 24, -40, -52,
    12, 6, 5, 47, 110, -19, -50, 19,
    1, 10, -2, 3, 17, -32, 20, 23,
    -48, -11, 52, -16, -11, 6, -14, 4,
    9, 16, -23, 42, 12, 14, 17, 23,
    -3, 18, 33, 17, -17, -19, 40, 52,
    -12, 23, -24, 5, 38, -42, 14, 33,
    -31, -10, 10, -30, 39, 49, -5, -8,
    25, 0, -45, 25, -12, 1, -56, 16,
    46, 41, 14, 18, -6, 5, -36, 9,
    -11, 0, -12, -8, -10, 1, -6, 75,
    -13, -62, -11, -11, -11, 0, -16, -13,
    -61, -11, -28, -7, -28, 13, 11, 1,
    -20, -10, -52, -12, -105, -20, 14, 5,
    1, 16, 8, -11, 3, -13, 29, -13,
    59, -16, -17, 39, -12, -6, -10, 6,
    2, -34, -26, 1, -41, 29, -10, 18,
    -12, -6, -68, 11, 32, 41, 18, -16,
    0, -13, 32, -4, 30, 4, -14, 14,
    -43, 27, -26, 26, 1, 8, 22, 52,
    10, -11, 8, -3, -3, 9, -16, 49,
    18, 42, 67, -3, -44, -11, 45, -13,
    -1, 8, 6, -10, -52, -11, -1, -41,
    58, -13, 7, 51, 2, -1, 17, 17,
    5, -13, -8, -4, 31, 23, 37, -10,
    -36, 40, -19, -4, 65, -1, 45, 12,
    16, -11, 22, 15, 41, 38, -1, 2,
    55, -52, -12, 3, 20, 6, 14, -2,
    21, -40, 4, -30, -31, 12, 2, 12,
    44, 15, -10, 92, -14, -5, -34, -8,
    5, 7, -10, 11, -34, -41, 12, 12,
    -4, -53, 14, -16, 12, -3, -20, -7,
    23, -19, -13, 26, 12, 1, -37, 33,
    14, 26, -29, -16, -29, -26, -10, -46,
    23, 16, -3, -21, 31, 0, -122, 6,
    51, 3, 21, -77, 5, 35, -3, -31,
    12, 9, -16, 114, -23, 27, -5, -14,
    11, 9, 50, 42, -4, -58, -26, -55,
    -7, 3, 1, -10, -51, 91, -83, 36,
    -65, 49, -50, -40, 9, -1, 3, -8,
    4, -5, -41, -11, -12, -21, 3, -19,
    -7, -18, 57, 59, 11, -16, -43, 23,
    1, 7, 25, 104, 1, -6, 24, 7,
    17, -33, -27, 18, -9, 28, 10, 119,
    0, 5, -15, 66, -19, -1, 44, 54,
    38, -21, -26, -73, -14, 34, 56, 73,
    13, 4, 19, -15, 8, 5, 21, 38,
    -17, -48, -52, 80, -1, -29, 18, -1,
    -16, -14, 19, -16, -22, 33, 34, 18,
    -55, 6, -19, 21, 25, 1, -55, 2,
    13, 54, 9, 7, 46, -1, -6, 21,
    71, 2, 6, -77, -11, -25, -2, -7,
    10, -16, -34, -7, -25, -67, 68, 1,
    -19, -20, -23, 0, 19, -48, 21, -1,
    -33, 13, 3, 12, -4, 33, 28, -6,
    35, -50, 20, 31, 72, 21, -15, 9,
    5, 9, 6, 17, -6, -41, -34, -15,
    -41, -15, -21, 44, 41, -25, -46, 68,
    -13, -9, 2, -12, 0, -7, -18, 65,
    -105, 1, -24, 56, -7, 6, -3, 16,
    -14, 91, -11, 6, 4, -16, 31, 20,
    -6, 67, 17, -19, 35, 22, -13, 63,
    -6, -5, 12, -6, 30, -67, 18, -6,
    13, 81, 51, 7, -10, 8, 21, -21,
    -42, -28, 68, 61, 12, -6, 21, 18,
    13, -35, 93, 36, 8, -20, -3, -25,
    20, -24, -12, 5, 0, 7, 3, -2,
    5, -52, 21, 65, 2, -35, -17, 3,
    4, -21, -20, -14, 4, 6, -63, -45,
    -23, 54, 9, -24, -4, 44, 22, -24,
    2, 3, -4, -13, 2, -37, 44, -34,
    14, -36, -69, 29, -14, 18, -1, 8,
    -26, 29, 38, -17, -28, -4, 5, -6,
    15, 23, 4, 65, 6, -29, -16, 2,
    2, -1, -3, -46, -19, 68, 10, -37,
    54, 59, 54, 47, 7, 2, -1, 0,
    30, -76, -61, 19, 21, 55, -18, -14,
    -14, 31, 16, 22, -5, 41, -8, -18,
    -11, -14, -6, 12, 76, 53, 17, -1,
    -7, 1, 110, -42, -28, 5, -13, 10,
    24, -11, -1, 9, 44, 46, 103, 26,
    27, 16, -52, 45, 91, -20, 52, -11,
    -20, 4, 6, -1, 56, 6, -3, -1,
    -87, -13, 64, -2, 6, 7, -10, 29,
    -17, 6, 13, -32, 18, -13, 8, 19,
    10, 22, 8, 0, 66, -4, -26, 47,
    -3, -9, 16, -1, -39, 1, 24, -11,
    -62, 23, 1, 59, -10, 5, -2, 7,
    -3, -11, -2, 15, 14, -61, -7, 47,
    -51, -3, -26, 8, 5, 1, 10, 7,
    19, 46, 7, -15, -38, -48, -9, -11,
    -5, -96, 45, 84, -23, -47, -11, 4,
    -19, -22, 7, -2, 12, -14, -73, 27,
    5, -40, -45, 50, 61, -65, 0, -6,
    4, -29, -2, 4, -16, -31, -40, -21,
    100, -28, 44, 15, 4, -1, 15, -16,
    32, 1, -1, -7, -1, 9, 25, 19,
    76, -15, -3, -16, -14, 53, 19, 25,
    -7, -8, -10, 4, 40, 36, 2, 27,
    3, -30, 2, 88, 4, -17, 101, -26,
    -15, 1, -77, -9, 1, 7, -53, -33,
    -43, -18, -12, -13, 14, 33, 47, 32,
    -12, 23, 4, -5, 8, -1, 4, 32,
    59, 1, -38, -53, -3, -14, -5, -2,
    -21, -8, -33, 24, 9, -29, 49, -52,
    -19, 68, 27, 33, -43, -57, 80, -54,
    -3, -7, -23, 3, 5, 1, 18, -56,
    -4, 67, 50, -1, -19, 1, -10, 12,
    -38, 47, -1, -31, -20, -14, -9, 8,
    -28, 61, -43, -49, 54, -13, 4, -33,
    6, 5, -31, -2, -17, -6, 3, 14,
    13, -7, 44, -28, 6, -9, 12, -3,
    17, 24, -34, 44, -18, -12, -24, -15,
    -18, 17, 6, -11, -2, 15, -5, -5,
    -16, -37, 18, 18, 26, -22, 29, 7,
    1, -4, 3, -5, -13, 1, 6, 20,
    -34, 42, -3, -4, 0, -4, 31, 31,
    1, 6, -16, -19, 4, 8, 2, -4,
    -14, 12, 6, -1, 7, -13, -23, 14,
    -4, 3, -3, -4, -22, 5, 6, 1,
    -54, -2, -27, 25, -16, -21, -18, 5,
    5, -8, 2, -18, 17, -2, 12, 5,
    -45, 19, -26, 19, 8, -4, 1, 23,
    2, -5, 6, -3, -1, -15, 21, 19,
    17, -47, -34, -28, 6, -18, -12, 26,
    -36, 0, -18, -1, 14, 10, -8, -5,
    -17, 0, -7, 5, -7, -7, -11, -5,
    -8, -17, -5, -4, 8, -14, 14, 14,
    10, 13, -18, 0, -22, 32, -28, -3,
    4, -14, 7, 15, 4, 3, 4, 17,
    -1, 5, 19, 20, 4, -19, 30, -27,
    -5, -2, 8, 5, -17, -2, 12, -4,
    -27, -10, -4, 27, -40, -9, -16, 6,
    10, 30, -19, 3, 2, -10, 7, 8,
    -15, -30, -27, 36, -1, -3, 28, 3,
    -10, -34, -4, 1, -21, -9, 9, -21,
    31, 9, -38, -17, -20, 56, 2, 12,
    24, 4, 7, 1, -10, 9, 0, 2,
    25, 8, -43, -13, 4, -18, 2, -14,
    5, -3, -7, -1, 15, -1, -23, 15,
    16, 29, 9, 20, -9, -7, -4, -20,
    24, 3, 25, 16, -12, -1, -15, 5,
    31, 3, 27, 34, 21, -9, 7, 38,
    -5, -9, -1, 4, -19, -21, -23, 1,
    -23, -13, 5, -37, -7, -24, -19, 15,
    -21, -6, 0, 22, -5, 6, 9, 12,
    -25, -39, -36, -12, 6, 5, 4, -14,
    1, 2, -4, -8, 6, 7, 16, 20,
    -58, -14, -16, -72, 13, -20, -16, -9,
    1, 12, -7, -4, -3, 10, -12, -8,
    5, -29, -37, 15, 4, -15, -18, 14,
    4, -3, 2, 3, -16, 15, 7, -9,
    10, 18, -6, 5, -7, -5, -15, 29,
    -19, 2, 8, 13, -1, -3, -4, -16,
    -4, 11, 26, -2, 21, 22, -19, 81,
    1, 2, -7, 12, 3, 13, 27, 20,
    32, -57, 4, 20, 0, -21, -33, 26,
    20, -34, 59, 31, -6, 4, 21, 16,
    1, -8, 21, -11, -14, 20, 18, 14,
    8, 0, 5, 6, -6, 12, -4, 6,
    34, 10, 30, 10, -22, -60, -8, 2,
    -22, 6, -2, -7, -12, -2, 1, -6,
    2, -19, 6, 11, 16, -4, -2, 0,
    -1, -24, 0, 1, -14, -5, -8, -6,
    15, -15, -2, 6, -5, 8, 20, -21,
    -34, -15, 30, -11, -5, 13, -1, 4,
    -9, 20, -29, -16, -12, 3, 11, -4,
    0, -7, 0, 0, -21, -14, 6, -21,
    40, -15, 14, -7, 10, 14, 24, 5,
    -14, 15, 6, 51, 7, -4, -8, -11,
    -9, 26, 12, 12, 31, -38, -16, -33,
    -2, 10, -5, -6, -5, 27, -19, -3,
    -9, -8, 28, -29, 3, -18, 17, 24,
    0, 2, -23, 0, 6, 7, 1, -13,
    10, 26, 15, 13, 11, 41, -2, 2,
    8, 3, 4, 6, -2, 25, -27, -10,
    25, 0, 6, -39, 35, -15, -24, 27,
    -14, 10, 0, -21, -1, 3, 1, 14,
    -13, -5, 1, 17, -3, -20, -1, 26,
    4, 1, -4, 6, -18, 3, 16, 0,
    10, 38, -22, -13, -13, 42, -17, -4,
    6, 24, 15, 24, 7, 3, -10, -24,
    -15, 21, -10, 0, 46, -17, 6, 77,
    1, -3, 3, 26, -11, -18, 25, 6,
    -59, 4, -13, -7, 1, 9, -12, -37,
    21, 5, -19, 4, 4, 1, -5, 3,
    -44, 40, -1, 21, -12, -9, -11, 9,
    6, -4, -2, 0, 9, -10, -17, -21,
    -58, 14, -19, 26, 42, -4, 2, -8,
    -17, 4, -2, -24, 5, -7, -6, 3,
    -24, 1, -30, 22, -26, -6, 0, 59,
    -1, 4, 7, 3, -4, 13, -38, 8,
    -24, 33, -58, -7, 19, 31, 15, -49,
    -1, 15, 3, -6, 12, 12, 1, 12,
    2, 11, -12, -11, -5, -12, 11, -5,
    -7, 1, 6, 1, 23, 12, -30, 26,
    -29, 4, 15, -23, -11, -1, 4, -15,
    21, -5, -3, 13, -16, -4, -4, 0,
    15, 1, 33, -20, 20, -4, 9, 8,
    -8, 15, -11, -3, 24, 31, 4, 6,
    34, -17, 7, 32, 6, -45, -1, 33,
    11, -3, 28, -55, -3, 4, 4, 28,
    -27, -10, -13, 22, 15, -27, 5, -11,
    4, 1, -1, 0, 21, -10, -13, -10,
    5, 40, -14, -4, 18, 11, 2, 6,
    -3, -11, 18, -23, 0, 1, -9, 3,
    5, 0, -48, -2, 0, -8, -21, 6,
    -5, 0, -4, -6, -11, -9, 3, 11,
    -1, -22, -50, -17, 26, 8, -32, -47,
    6, 15, -4, 35, -11, 2, -1, 12,
    -21, -13, -33, 7, 20, -13, 18, -4,
    7, 2, 4, 9, 0, -9, 8, 33,
    -3, 6, 20, -14, 27, -7, 14, -32,
    -23, 13, -4, 4, -5, -7, -4, -4,
    -19, -5, 16, -12, -4, 8, -6, -18,
    4, 6, -3, -2, -9, -19, -4, 21,
    -5, 38, 0, 29, 2, 31, 18, -22,
    22, 31, -11, 29, -14, -4, -5, 5,
    33, 28, 7, 36, -41, -14, 32, 12,
    -13, -7, 6, -5, 3, -26, 16, -13,
    -20, 17, -20, 7, 9, -18, -6, 1,
    -11, 0, 2, 21, 5, 4, 1, 5,
    -5, 10, -3, -29, -4, 19, 5, -26,
    3, 3, 2, 0, 0, 10, 0, -10,
    -36, 12, -16, 21, -14, -14, 25, 12,
    -13, -23, 1, -9, -3, 1, 1, -13,
    -7, -37, 1, 20, 7, 18, -40, 28,
    -2, 13, -7, -2, 0, 5, -10, 11,
    36, 11, -22, -19, -47, -36, 6, -24,
    -16, -20, 16, -1, 14, -4, -8, 3,
    1, 25, 20, 0, -25, 28, -2, 26,
    -2, -8, 9, 7, -10, -22, 16, -4,
    -1, 0, -21, 4, 6, 1, 2, 10,
    15, 9, 7, 7, -2, 10, -2, -1,
    36, -4, 2, -12, 6, 0, 13, -23,
    -3, -6, -1, -9, -16, 5, 25, 17,
    29, -11, -23, -9, -3, -20, -26, 10,
    8, -15, 29, -4, 0, -6, -2, -1,
    32, -42, 38, 22, -20, 13, 1, 5,
    -2, 6, 0, 2, -6, 10, -11, 9,
    12, 49, -38, 28, 33, -57, -1, -27,
    17, -17, -7, -14, 19, 9, -1, 9,
    23, -25, 14, -30, -44, -40, 8, 24,
    1, -8, 0, 11, -25, -33, 18, -14,
    33, 23, -29, -23, 10, 20, 23, 2,
    24, 0, -8, -27, -6, 4, -2, -10,
    -2, 5, 11, -9, -22, -11, -3, 4,
    -15, 0, -3, 14, -10, -9, -1, 3,
    25, 16, -48, 14, 46, -17, -1, -20,
    11, -9, -8, -13, 13, 4, 16, 1,
    5, -5, 37, 19, -15, -3, -31, 27,
    6, -4, 4, 6, 6, -12, 23, 11,
    18, -17, 40, -10, 9, 37, 48, 50,
    18, 6, 45, -10, 0, 16, -2, -23,
    14, -9, -21, -5, -10, -19, 19, 6,
    -29, -33, -5, 12, 24, -34, -17, 1,
    29, -48, -27, 30, -27, 31, 3, -7,
    14, 1, 7, 5, -3, 4, 7, 8,
    -10, -9, 24, -16, 24, -10, -8, -11,
    2, 8, -2, 9, 20, 6, -7, 11,
    -32, 8, 26, 58, -36, -1, -2, 17,
    -25, 41, 20, -12, 4, -5, 0, 15,
    11, 20, -28, -25, 19, -6, 24, -17,
    -15, -23, 5, 3, 23, -14, -41, -3,
    -5, -38, -12, -34, 33, 15, -34, -28,
    -18, 4, 0, 12, 5, -23, -1, -7,
    14, 21, 18, -15, 12, -14, -25, -5,
    5, -24, -6, -9, 6, 48, -9, 56,
    45, -39, -42, 29, -41, -7, 19, -10,
    42, 37, 28, 5, -11, 33, -22, 9,
    56, -39, -43, 12, 2, -1, -13, 21,
    0, -7, 1, -4, -59, -39, 25, 23,
    22, -17, 9, -75, 19, -10, -9, -18,
    -24, -6, -13, 37, 11, 1, 6, -16,
    -18, -24, -9, 11, -30, 17, 31, -1,
    7, 2, 8, -1, -45, 11, 54, 14,
    3, -36, -8, -27, -15, -46, 23, 12,
    5, -8, -6, 5, 6, -8, -19, -12,
    8, -10, -34, 5, -8, -5, 7, 26,
    1, 1, 0, 2, -9, -17, 31, -6,
    4, 5, 26, 33, 43, -2, -21, 9,
    -7, -15, 38, -1, 32, 7, -1, -13,
    -26, 7, 16, -6, -29, 23, -16, 69,
    -3, 3, -5, -1, -52, 10, 17, 2,
    21, -48, -11, 7, 40, 1, -23, 11,
    -3, -33, 75, 38, 0, -32, 15, 18,
    -44, -19, 22, -40, 14, 16, 1, 12,
    5, 0, -5, 4, -28, 71, -20, -47,
    22, 21, 13, -9, 5, -39, -2, -11,
    -13, 51, 2, -8, -15, -23, -1, -10,
    -17, 36, 26, 13, 10, 17, 1, 8,
    -5, -31, 1, -1, 0, 44, -13, 20,
    23, -37, 4, -34, -5, -2, 23, -15,
    -7, 26, 20, 20, 4, 3, 8, -8,
    -12, -31, 9, -11, -21, 1, -28, -8,
    -11, -8, 1, 3, 11, 8, 7, 32,
    10, 9, 32, 11, -14, 18, 8, 9,
    -20, -28, 22, 60, 3, -9, 7, -9,
    -36, -16, 4, -4, 6, -7, 5, -6,
    -1, 6, 4, 4, 18, 27, 14, 16,
    -14, -21, -22, -39, 6, -83, -18, -9,
    16, 7, -9, 2, -6, -10, -2, -20,
    42, 5, -24, -5, 5, -12, -14, 18,
    -4, -5, 5, 2, -9, -7, -4, -10,
    -22, 2, 7, -45, -2, -8, -78, 21,
    20, 20, 35, 1, 9, 4, 3, 13,
    -47, -3, 4, 36, 31, -8, -1, 26,
    14, -1, -1, 8, -1, 8, -12, -8,
    60, -17, 7, 10, -15, 9, 1, -21,
    -8, 27, -14, 1, 6, 16, 25, -20,
    3, 6, 21, -10, 58, 7, 9, 84,
    -3, -6, 2, 36, -28, -31, -47, 17,
    -11, 26, 14, 8, 19, 44, -3, -7,
    -13, 20, 2, -44, -26, 10, -6, 6,
    -34, 53, 22, -23, 6, -7, 6, 0,
    -4, -12, -1, 16, 29, -9, -16, 34,
    -3, 8, 1, -10, -41, 10, 42, 7,
    -32, -36, -12, -11, -23, -15, 6, 12,
    29, 15, -43, -3, -23, 23, -6, 45,
    5, 6, -3, 1, 21, 42, -53, 2,
    -11, 35, 44, 35, 25, -53, 7, 12,
    11, -22, 13, 12, -7, 15, -7, 20,
    26, 21, 34, 5, -42, -44, 9, -4,
    -13, -3, -3, -4, 37, -22, 21, -15,
    -33, 39, 28, -14, -14, 3, 4, 0,
    30, 20, -2, 12, -31, -26, 14, 0,
    32, 34, -54, -65, 5, 0, 18, -15,
    -16, 8, -8, -9, 6, -13, -14, 47,
    21, -13, -7, 31, -1, 0, 22, 83,
    -14, 13, -7, -70, 10, -4, 13, 26,
    1, 3, -26, 59, -11, -15, -20, -28,
    10, -7, -4, -12, -4, 33, 20, -43,
    -21, 28, 11, -3, -4, 28, -33, -10,
    -18, -10, -22, 6, -24, -1, -27, 5,
    40, 5, 24, 6, -12, 4, 6, 18,
    2, 12, 5, 0, 59, 13, 9, -24,
    71, -36, -20, -11, 20, -20, -36, 6,
    9, -26, -16, 49, 3, -26, 0, -12,
    7, 15, -26, -13, -16, 1, 3, -13,
    -11, 11, 3, -2, -17, 4, -7, 11,
    40, 24, -28, 15, -2, -34, -8, -13,
    -2, 16, -1, -4, 0, -1, -4, -7,
    8, 0, 12, 18, 2, 10, 7, -31,
    0, -1, 1, 0, -13, -43, -3, 20,
    40, -11, -10, -12, 10, 28, -3, -16,
    0, 29, 18, 21, -5, -4, 16, -8,
    9, 10, -18, 7, -19, -20, 19, 13,
    -19, -5, 1, 2, 1, -45, -36, 21,
    39, 59, 8, -34, 4, 16, -26, 6,
    -11, -6, -14, 76, 6, 13, 1, 60,
    1, 13, 12, -5, 6, 26, -31, -21,
    7, -1, -5, 13, 9, -42, -67, -62,
    16, 4, 4, 0, 10, -15, 13, 3,
    11, -19, -9, 8, 18, 26, -5, -51,
    20, -46, -2, -16, 7, 9, -31, 19,
    -7, -1, -4, 6, -38, -18, 0, 15,
    -34, -17, -15, 7, -44, 26, 21, 14,
    15, 33, 9, 6, 20, -6, 12, 6,
    -36, -3, 11, 28, -30, 34, 5, 7,
    -7, -9, 7, 4, -51, 42, -35, -23,
    -1, 41, -5, 21, 36, -21, 7, 44,
    29, 9, -22, -1, -3, -16, 0, -1,
    -5, -92, 8, -4, 25, -21, 42, -17,
    4, -3, -7, -8, -24, 12, 12, -29,
    18, -21, 3, 37, -12, -12, 7, 34,
    -13, 1, 14, -20, -16, 14, 2, -19,
    -6, 33, -5, -19, -15, 0, 12, -4,
    1, 2, 6, 12, 32, 10, 0, -41,
    -9, 106, -11, 56, -3, 100, 16, 9,
    -22, -14, -16, -8, 36, 0, 0, 21,
    12, 42, -45, 11, -26, -51, 41, 0,
    -11, -25, 5, 28, 34, 10, -17, 2,
    11, -18, -59, 31, -23, 10, -10, -3,
    -16, -15, -17, -27, 8, 2, -8, -11,
    -58, -5, -32, -14, -5, 34, 9, 13,
    -26, 1, 4, 17, -28, 1, 4, 38,
    45, 9, -23, 5, -31, 62, 89, 7,
    35, 8, -17, -16, 13, 21, 12, 5,
    -14, -43, -9, 6, 32, -18, -35, 46,
    16, -19, 22, 4, 20, 1, 19, 3,
    11, 9, 24, 31, 52, -53, 69, -75,
    37, -68, -1, -2, -9, 27, 5, -28,
    22, 40, -23, -36, -16, -101, -18, 24,
    -70, -59, -13, 15, -5, 27, -31, -33,
    81, 20, -22, 83, 32, -64, 13, 28,
    -7, 50, -6, -9, -3, -22, 6, 4,
    24, -34, 13, 39, 6, 27, 1, -31,
    2, 3, -2, -13, 47, 11, -40, 32,
    6, -14, 13, 43, 70, 37, 17, 64,
    -15, 127, 8, 14, 8, -17, 1, 23,
    -1, 1, 3, 60, 15, 74, 21, -5,
    -16, 3, 11, 21, 4, -10, 8, 72,
    -50, -78, 23, -2, -15, -78, -15, 6,
    12, 15, 3, 14, -21, -20, -1, -2,
    73, -42, -33, -49, -2, -6, -9, -40,
    9, -27, -23, -11, -3, 46, -4, 16,
    8, -36, 8, 29, -4, -1, 9, 82,
    49, 30, 46, 10, 3, 42, -30, 17,
    -37, 10, -69, 18, 4, -6, -25, 3,
    -16, -27, -26, -24, 93, 15, 37, -33,
    98, -37, 27, 43, -3, 9, -31, 53,
    -36, -7, -7, 69, 17, 3, -13, -21,
    16, 8, 46, 29, 18, -18, 31, 47,
    1, 5, 8, 67, 9, 3, 27, -34,
    62, -13, -56, 62, -5, 77, -11, 36,
    35, -11, -41, -19, 13, 12, -35, -5,
    -24, 17, 29, -12, -22, -58, 15, -4,
    -17, -4, -7, -8, 28, -13, -9, -24,
    23, 54, 7, -35, 3, -2, -3, 20,
    -16, 0, 25, -17, 40, 1, 0, -8,
    17, 13, 0, -38, 33, 34, -27, 9,
    -10, 5, -9, -17, -19, 4, 34, 1,
    -39, 4, 46, 23, -3, -86, 52, -54,
    28, -31, 99, -10, 1, -36, 12, -13,
    51, 6, -38, 54, 17, 29, 20, 30,
    25, 15, 5, 11, -9, -53, -55, 42,
    -24, 53, -8, -9, 0, 115, -1, 20,
    -16, 115, -13, -18, -20, -30, -5, -12,
    -7, 1, 4, -14, 8, 10, 12, -9,
    -2, -44, 2, 7, 27, -12, -37, -25,
    18, -56, -105, 21, 42, -66, -29, 1,
    -10, 45, 46, 17, 4, 7, 35, 12,
    0, 35, 20, -5, 2, 10, 9, -19,
    -26, -39, 7, 13, 28, 3, -7, -48,
    6, 17, -39, 23, -8, -8, 0, -32,
    -16, -108, -12, 58, 8, 4, 8, -15,
    5, -1, -19, -17, 40, -4, -7, -10,
    3, 44, 27, 4, 5, -36, 14, -5,
    6, 5, -65, 52, -79, -10, -46, 9,
    53, 25, -11, 59, 5, 15, -1, -35,
    -20, -5, -2, 13, -19, -26, -15, -1,
    7, -4, -13, -16, -18, -31, 6, 72,
    -16, -3, 16, -56, 34, -12, -39, -68,
    5, 12, 27, 9, 10, 3, 3, 15,
    -11, 14, 4, -35, 20, -36, -30, 2,
    52, -3, -3, 28, 14, 7, -16, -11,
    67, -72, 30, 41, -43, -53, 74, -51,
    -17, 25, -6, 29, -11, 22, 21, -16,
    24, -5, 9, 3, 90, 39, 23, 95,
    -1, -2, 2, 28, 43, 29, 18, -42,
    28, -33, 0, 70, 1, 20, -32, 14,
    -9, 17, -4, -21, -40, -10, 0, -5,
    66, -67, 90, -3, -13, 15, -8, 20,
    -14, -21, 0, 5, -49, 48, -32, -18,
    -9, 51, 8, -18, 38, -5, -47, -8,
    -62, -17, -20, -20, 13, -39, 2, 5,
    37, -31, -5, -2, 0, 15, 53, 45,
    -1, 9, 3, 0, -56, -4, -14, 6,
    41, 27, 88, -32, -1, 30, 48, 2,
    25, -27, -7, -6, -48, 29, 13, 0,
    19, -17, -41, -8, -36, -29, 12, 28,
    -25, 10, -15, 20, -17, 76, -19, 7,
    14, 34, -17, -17, 114, -127, -24, -26,
    43, 7, 8, -7, -41, -55, 36, 5,
    -27, 11, -3, 35, 40, -15, 1, -7,
    0, 13, -21, -37, -27, -37, 41, -19,
    64, -7, 44, -61, -25, -21, 3, -109,
    15, 0, -9, -100, 16, -8, 11, 2,
    -24, -8, 4, 4, 36, -35, -53, -67,
    10, -10, -17, 4, 56, -45, -13, 14,
    37, 24, 4, 3, -9, 6, 105, -28,
    -7, -17, 29, 22, -25, -6, -33, 19,
    50, 30, 5, -24, -13, -11, -38, 36,
    -5, 16, 7, -3, 14, -39, 1, 44,
    61, -63, 21, -18, 76, 22, 10, 22,
    -10, -8, 5, 37, 5, -23, 0, -33,
    -1, -16, 8, 13, 18, 31, -6, -2,
    2, 2, 0, 65, 48, 15, 3, -65,
    8, 30, -39, -59, 69, 46, 3, 13,
    9, 13, -3, 15, 2, -12, 5, 10,
    -6, -21, -16, 49, -19, 0, -12, -14,
    2, -18, 3, 0, -24, 17, -10, 14,
    65, -100, -17, 25, 5, -3, -2, -9,
    -47, 47, 3, 27, 0, 3, 18, 18,
    -8, -17, -51, -29, -22, -64, 4, -27,
    -31, -1, 9, -4, -17, -42, -17, -80,
    56, -19, 18, -56, 33, -20, 59, -67,
    -7, -40, -17, 43, 13, 9, -10, 127,
    -23, 16, -48, 12, -14, 42, 16, 6,
    -2, 2, -4, 8, -14, 22, -27, 83,
    0, 17, -37, 17, -23, -32, 9, -7,
    -9, 4, 11, 15, 9, 39, 1, -108,
    -67, 21, -14, -26, 63, 36, -12, -30,
    -3, 16, 5, 3, -6, 7, -11, -8,
    -31, -62, 22, -70, 120, -59, -48, -28,
    -9, 10, -14, 12, 6, 11, 16, 2,
    -2, -37, 19, 7, 37, 9, 26, 11,
    3, -59, -1, -6, 31, -41, 31, 33,
    -27, 30, -66, 8, -21, 26, 74, -16,
    6, 14, -1, -2, 12, -47, 21, -9,
    21, 91, -16, -14, 72, -4, 17, 32,
    -6, 0, 6, 5, -24, -38, -15, 8,
    -46, -83, -56, 6, -59, -29, 30, -33,
    1, -24, 10, -1, -8, 11, 22, -23,
    -39, -25, -49, -80, -19, 13, 40, 7,
    -5, 9, 12, 32, 7, 7, 14, 29,
    -13, -14, -42, -8, 9, 55, 2, -12,
    -15, -15, -18, 6, 2, 28, 4, 7,
    -7, 1, 6, 1, 4, -16, -9, 31,
    32, -21, -17, 41, -45, 28, -1, -10,
    -4, -23, -2, 43, 5, -7, -3, -1,
    -4, 15, 10, 0, -6, -9, -8, -2,
    0, -6, 1, -4, 3, 9, 2, 16,
    -11, -18, 23, 16, 28, 8, 21, 20,
    16, -14, -30, 11, 30, 15, -24, -30,
    13, 14, -19, 34, -6, -22, 9, -1,
    1, -7, -5, -2, 7, -6, -15, 17,
    -22, 9, -4, 1, 45, 3, -38, 10,
    9, 23, -24, 15, 16, 26, 0, -14,
    0, -26, 12, -2, 17, 13, 1, 5,
    3, -4, 1, 2, 14, -23, 21, -19,
    21, -27, 7, -24, -18, 15, -27, -16,
    -4, 4, 28, -51, 7, 8, -6, 15,
    3, -7, 1, -4, -8, -8, -14, 23,
    0, 4, 2, -3, 6, 6, 19, -38,
    3, -16, -10, -21, 21, 19, -21, 19,
    -31, 3, -27, 76, 8, -32, 3, -22,
    31, -6, 7, 19, 11, 10, -17, -12,
    1, 0, -4, -12, -2, 4, 9, 5,
    -5, -9, -6, -14, -16, -3, 6, -16,
    -3, 20, 24, 25, 29, 4, -7, 21,
    22, 39, -7, -3, 0, 1, 1, 17,
    4, 6, -9, 0, -13, -19, 5, -14,
    -19, -32, -5, 47, 19, 60, 22, -11,
    29, -9, 10, -20, 5, 8, -26, -21,
    63, -46, 7, -6, 4, -6, 1, 5,
    0, -2, -10, 8, -21, 31, 4, -20,
    -12, 7, -21, -21, 33, -24, -6, 12,
    -34, -9, 35, -12, 6, 15, 27, -29,
    14, -24, -22, 24, -1, -3, 0, 28,
    3, -5, 2, 2, -9, -2, 17, 34,
    3, -16, 41, -6, -44, 25, 24, 17,
    23, -3, -12, -34, 31, 5, 54, -12,
    28, -11, -21, -46, -20, 5, -9, -2,
    0, 2, 3, 0, -9, 7, 1, -33,
    -5, -26, -23, -32, 1, -32, -28, -15,
    -32, -36, -2, -10, -17, -30, 2, 25,
    -39, 13, -37, -1, -18, -29, 6, -13,
    4, -1, -2, 1, 18, 29, 0, -3,
    15, -10, -28, 17, 6, 6, -26, -19,
    -15, 13, -3, 25, -14, -3, -20, -29,
    -8, -27, 20, -14, 4, -1, -2, 6,
    4, 6, 2, 7, -4, -9, -23, 9,
    -25, 35, -4, 18, 7, 5, -9, -5,
    7, -8, 1, -37, -7, 8, 15, -33,
    17, 16, 17, -33, -10, 20, -14, -14,
    -5, 4, 11, 11, -7, 17, 4, -7,
    -9, 27, -1, 15, -26, -18, -21, -11,
    -12, 23, -1, -19, -44, 8, 25, -22,
    -5, 29, -31, 11, 8, -4, -26, 9,
    2, 1, -1, 4, -3, 11, 18, 0,
    -34, 39, -34, 17, -12, -5, -23, -13,
    14, -7, 9, -2, 29, 67, -20, -3,
    -12, 7, 57, 24, 3, 9, 15, -10,
    5, 5, 3, 0, -4, 5, 9, -7,
    13, -26, -19, -17, 28, 17, 18, 14,
    -2, 3, 14, -2, 46, 57, 28, 27,
    -40, 63, 3, -5, 4, 30, -8, -3,
    -7, 0, -1, -10, 14, -17, 8, -13,
    -17, -19, 18, -6, 2, 20, -2, -41,
    36, -4, 14, -5, 11, 32, 39, 6,
    -11, 18, -1, 7, -19, 1, 1, -1,
    -6, -1, -2, -5, -8, -25, -12, -13,
    31, -17, -2, -3, -18, -2, -33, 9,
    24, 32, -28, -15, -5, -7, 47, 12,
    -17, 3, -16, 18, -15, -12, -11, 29,
    -1, 3, -2, 2, 2, 7, -19, -20,
    -16, 10, -14, -23, 10, 16, 13, -5,
    12, 14, 54, 39, 49, 34, 38, 15,
    -4, 34, 19, 1, 5, 0, 4, -19,
    3, 12, 9, 2, -6, -13, 4, -14,
    -1, -21, 4, -16, 13, 23, -7, 5,
    10, -17, 3, 10, -8, 14, -25, -30,
    5, -3, 7, 32, 16, 13, -9, 20,
    -4, 5, -1, -5, 13, 1, -16, 6,
    11, 1, -21, 11, 9, 1, 45, 2,
    -8, 9, -4, -29, 12, 25, 15, 10,
    -9, -21, -22, -41, 27, 5, -37, -15,
    -1, 7, -3, 5, -11, 15, 8, -5,
    31, 34, 16, -20, -15, 2, 11, -26,
    -28, 25, -5, 9, -39, 32, -38, 33,
    38, -36, 16, 52, 6, 7, -1, 18,
    3, -4, 5, -4, -22, 1, -26, -1,
    33, 4, -17, -21, -4, -34, 23, -48,
    4, 20, -4, -11, -9, -16, 9, -24,
    12, 1, 4, 4, -4, 5, -12, -4,
    0, 15, -4, -4, 5, 7, -24, 19,
    11, -34, 14, 7, -10, 0, 22, 24,
    -4, 19, -41, 22, 34, 14, 91, 12,
    -4, -10, -32, -6, -4, 3, -13, -11,
    -4, 3, -2, -3, 9, 22, -13, -18,
    13, 28, 11, 35, -30, -52, -20, 18,
    -12, -27, -12, -4, -9, 2, -10, 8,
    -7, -12, -22, -6, -15, -3, -6, 14,
    -7, 4, -7, 5, 7, -1, 2, 8,
    35, -58, 10, -33, 18, 16, 1, -2,
    20, -1, -39, -22, 20, -36, 17, 11,
    7, 6, -34, 46, 11, 0, 5, -2,
    -2, 5, 7, -2, 18, -12, 21, 8,
    -7, -27, -5, -28, -33, -21, -9, -40,
    -3, -34, 7, 31, 14, 18, -25, 15,
    -27, 20, 22, -7, -22, 2, 21, 19,
    7, -4, -9, -4, -10, 13, 5, -13,
    24, 44, -12, 30, -6, 0, -11, -15,
    -10, 6, -10, 8, -12, -9, 35, -33,
    5, 27, -1, 50, -5, 7, 18, -20,
    2, -3, -5, 0, -18, -23, 25, -8,
    4, -36, -2, 11, -13, -5, -25, 2,
    10, -2, -6, 11, 23, -11, 45, -31,
    -5, -16, -13, -33, 22, 13, 23, 13,
    -5, 7, 2, 3, 6, -26, -12, 2,
    24, -4, 17, 26, 21, 10, 2, -21,
    14, 22, 12, -3, -30, 10, -35, -15,
    -7, 0, -9, -8, -5, -5, 1, 13,
    -5, -2, -4, -4, 3, 14, -14, -10,
    35, 9, -51, -21, 6, -36, 28, -24,
    -14, 74, -10, 3, 31, -15, -41, 13,
    20, -6, 12, 18, -10, 0, 22, -9,
    4, 2, -5, 1, -6, 4, -3, -2,
    14, -30, -8, -7, 14, 12, -17, 21,
    -11, 31, 37, 8, 7, 16, 17, -2,
    -16, -17, -16, 9, 6, -14, 7, 18,
    -4, 1, 0, 3, -13, 10, 11, -27,
    -2, -43, -30, 70, -19, -1, 0, -20,
    11, 8, -57, -9, -22, 25, 9, 6,
    -8, -56, -42, 7, 13, 22, 4, 37,
    -6, -4, -2, -8, -9, 21, -7, -32,
    -38, 0, 5, 0, 19, -17, 1, 22,
    -2, -41, -39, 28, -45, -14, 47, -38,
    -32, -4, 19, -10, -12, -7, -5, 0,
    -7, -3, 2, -1, 17, -1, 24, -16,
    -13, 11, 12, 28, 43, 4, -7, 8,
    25, 1, -20, 16, -36, 18, -35, -48,
    30, 25, -42, 29, 7, -4, -22, 4,
    2, -8, -5, -4, -35, 19, -57, 9,
    -18, 34, -37, 8, 28, -21, 0, 30,
    11, 49, 2, 10, 8, 16, 10, -16,
    11, -15, 48, -7, -2, 1, 24, -2,
    0, 1, -2, -1, 16, 27, 27, -15,
    18, -46, 87, 5, 13, -24, 16, -39,
    4, 10, -4, -40, -17, -55, -13, 5,
    -8, -50, 21, -22, 31, 5, 2, 12,
    2, -1, 0, -1, -17, -52, 7, 0,
    -4, -15, 7, -19, -11, 13, 16, -42,
    12, -6, -7, 41, -27, -12, 25, 18,
    27, -8, 19, -20, -21, 19, -11, 27,
    5, 0, 1, 5, -19, -35, -6, 11,
    6, -7, -34, 22, 21, 11, -12, 10,
    -2, 21, 21, 20, 35, -9, 22, 48,
    -18, 23, 7, -22, 13, -17, -32, -11,
    14, 12, 3, 1, -4, 52, 7, 30,
    -48, 11, 42, -12, 46, -40, 12, -34,
    -8, -23, -23, -23, 58, -30, 45, 19,
    34, -15, -15, 32, -3, -19, -7, -13,
    4, 0, -7, 5, -80, -18, -17, -13,
    44, 17, -21, -53, -35, 13, 6, 20,
    -54, 12, 58, -2, -19, -1, 34, 42,
    4, -4, -42, -3, 17, 11, 1, 17,
    -5, 1, -2, 0, 17, -10, 14, 5,
    29, -19, -46, -9, -66, 5, 21, -25,
    29, 8, -14, -54, 33, -3, 19, -40,
    31, 37, -30, -3, -41, 5, 0, -20,
    1, 2, 0, -3, 21, 12, -6, -4,
    29, 31, 1, -10, 34, 14, 10, -17,
    -32, -12, -17, 9, 11, -10, 4, 23,
    -19, -28, -22, 11, -12, -11, -7, 0,
    0, -1, 5, -2, 4, 6, 22, 4,
    -15, -42, -38, -19, 12, 29, -19, -2,
    -42, -11, -11, 39, 1, -32, 21, 2,
    -20, -34, 16, -33, 5, 0, -1, -50,
    3, -5, 0, 5, 20, 9, 14, 21,
    24, 44, -27, -44, 35, 10, 17, 24,
    -5, -1, -16, -53, -27, -8, -14, 2,
    22, 3, 17, -6, -9, 27, -22, -17,
    5, 0, 30, 7, -27, 6, 8, -10,
    -14, 56, -19, 14, -25, -12, -5, -3,
    -34, 29, 6, -11, 29, 26, -68, -1,
    7, -52, 5, 11, -7, -25, -14, -11,
    9, -10, 4, -1, 12, 5, 12, 7,
    -28, 10, -5, 49, 0, 6, 13, -10,
    56, 15, 26, 0, -5, 24, -1, 1,
    43, 12, -2, 23, -8, 11, 14, 3,
    12, 1, 2, 0, 24, -28, 4, -3,
    -18, 8, -43, -4, -12, 6, 21, 10,
    1, 15, 26, -43, 22, -15, 16, 14,
    20, 30, 3, -13, -6, 16, -11, 0,
    -1, -3, 3, -6, 1, -13, -18, -49,
    3, -15, -2, -76, 5, -20, -36, -30,
    72, 4, -14, 30, 9, 22, 25, 17,
    10, 16, -6, -23, -12, -9, -11, 6,
    -2, 2, 0, -6, 17, -8, -15, 25,
    -3, -17, -11, -21, -8, 2, -14, -13,
    18, 8, 7, -12, -2, -8, 2, 24,
    5, -16, -32, 1, 9, -19, 17, 28,
    -5, 4, -6, 0, 7, -20, -2, -38,
    -54, 38, 12, -22, 5, 11, 25, -7,
    62, 10, 51, 44, 17, -2, 21, 27,
    -59, -13, 23, -50, 2, 10, 1, 32,
    10, 4, 16, -1, 56, 34, 23, 5,
    3, -34, -16, -15, -3, 38, -28, -35,
    -2, 26, -30, -14, -36, 38, -9, -9,
    -22, 18, 47, 59, 4, -25, 6, 1,
    -2, 1, -6, -2, -7, -18, -42, -1,
    -65, 28, -44, 13, -10, 4, -1, 13,
    -21, 41, -19, -24, -36, -32, -35, 12,
    -3, 0, 41, 0, -2, 7, -16, 6,
    0, 6, -8, -3, 7, 11, -20, -19,
    53, 39, 16, -30, -60, 11, 38, 35,
    -35, 18, 6, 25, 28, -9, -21, 119,
    36, 1, -23, 76, -4, 2, 49, -11,
    0, 3, 2, 5, 2, -19, 7, -13,
    -2, 11, 22, -20, 9, 18, -6, 10,
    -29, 34, -9, -5, -18, -3, 82, -42,
    10, -15, 7, 20, -2, 22, 16, -27,
    1, 6, 4, 3, -2, -18, 33, 18,
    37, -38, 8, -10, -25, 38, 0, 15,
    -1, 0, -44, -34, -37, -2, 47, 19,
    63, -33, 46, -29, -15, -12, -19, 12,
    -8, 1, 3, -6, -11, -27, -2, -2,
    41, 7, -37, 47, 14, 4, -25, 40,
    16, -13, -9, -15, -35, -80, -1, 39,
    -1, -3, 4, -14, -46, -8, 3, 33,
    1, -4, -6, 1, 33, -40, -1, 12,
    -15, 11, 16, -15, -36, 32, -19, -4,
    54, 19, -40, -21, 2, 21, 1, -4,
    0, 41, -3, 5, 26, 10, 5, -1,
    -3, 2, -2, 3, -16, -4, 13, 5,
    -16, -2, -10, -33, -14, 27, 7, 9,
    -12, -37, 0, 48, -7, -23, -13, 46,
    14, 7, 27, 65, -17, -5, 13, 0,
    6, 2, -4, -1, 11, 4, 23, 2,
    22, 61, -9, -42, 23, 2, -24, -19,
    -15, 9, -51, -7, -40, 28, -17, -16,
    44, -11, 49, 38, -17, 22, -1, -1,
    0, 4, 2, 8, -5, 13, -36, -10,
    8, 13, 3, -1, -19, -7, -35, 0,
    -8, 26, -9, 17, -12, 2, 29, -1,
    6, -54, -19, -16, 9, 9, 16, 1,
    -5, -1, -1, 3, 1, 21, -24, -10,
    7, -26, -6, 6, 22, 8, 6, -34,
    -14, 16, 19, 32, -9, -53, 19, 45,
    11, 12, -14, -2, -9, -11, 12, -3,
    1, -6, -5, -10, 11, -1, -20, -12,
    7, 11, -36, 35, 14, 31, 20, 26,
    -27, 86, 12, 6, 32, 8, -26, 27,
    0, 44, 5, 3, -11, 20, -9, -15,
    9, -2, -1, 16, 34, -29, -34, -25,
    -28, 8, 22, 4, 14, 39, 31, 26,
    0, 46, 31, -45, 0, -11, 5, 37,
    24, 20, 34, 3, 1, 5, -12, 11,
    -6, 3, -1, -4, -4, 15, 1, -31,
    -9, -32, 31, 27, 5, 11, 8, -18,
    8, 42, -77, -20, 56, -46, 12, 60,
    -23, -17, -54, -31, -13, -38, 28, -19,
    -21, -2, -10, -4, 99, 30, -6, 6,
    28, 37, 29, -44, -34, 12, -41, 70,
    -15, -39, -54, 31, 39, -15, 28, -35,
    -30, -15, -18, -2, -16, -11, -19, -2,
    18, -24, 3, -12, -38, -11, -21, 18,
    52, -14, 57, -88, 1, 33, 12, -49,
    14, -2, -80, 17, -1, 6, 63, -26,
    24, 15, -55, 64, -7, 19, -25, 18,
    4, -1, 3, 4, 26, 7, 5, 2,
    20, -29, 7, -4, -49, -44, 27, 12,
    17, 35, -45, -37, -2, 68, -11, 17,
    -24, -9, 32, -39, -45, 12, 57, -7,
    -2, 7, 5, -1, -34, -8, -7, -15,
    -44, -40, -56, -4, 17, -17, 78, -52,
    36, 33, -12, -49, 38, -15, -9, -59,
    -7, -121, 67, -51, 16, -65, 6, 2,
    15, 5, -6, -11, -16, -51, 10, 56,
    -44, -49, 7, -29, 14, -13, -21, -13,
    -7, 26, -2, -15, 37, 20, -24, -81,
    -45, -6, 37, 33, 22, -27, 1, 14,
    -3, -5, 21, -5, 24, -63, -19, -64,
    -25, -88, 84, 32, 4, 3, 15, 11,
    13, 18, 8, 7, 51, -5, 61, -25,
    -2, -4, 3, -24, -4, -17, 6, 20,
    -5, -3, -23, -27, 8, 58, 11, -39,
    16, -42, 38, -38, -8, 20, -21, 15,
    -1, -7, -36, -18, -3, -22, 30, -30,
    50, 6, -44, 44, -38, 17, -3, 15,
    -6, 14, 4, -4, 41, -7, -40, 8,
    2, -3, -41, 17, 23, -19, 15, 87,
    -64, 39, 83, 13, -54, -11, -38, -20,
    31, 57, -47, -2, -26, 17, -8, -39,
    -6, 3, 1, 4, -30, 2, 6, -37,
    -22, -9, -7, 47, 31, 5, -7, 1,
    32, 8, 5, -40, 33, -27, -71, -1,
    8, 53, -4, 20, 24, 35, 17, 18,
    -1, 0, -3, -3, -37, 41, -58, 52,
    25, 15, 26, 48, 32, 97, -9, 16,
    -15, -30, -18, -22, 13, -1, 11, -34,
    44, -50, 35, 30, 34, -6, 13, -24,
    12, -7, 9, 5, 71, 34, 30, 40,
    -9, -32, 21, 13, -50, -42, -18, -6,
    2, -4, -6, 44, 15, 70, 31, -17,
    40, 54, -3, -19, -14, -28, -35, -22,
    1, 12, -1, -10, 18, -23, 3, -10,
    -30, -31, 12, -28, -45, -34, 28, 32,
    3, 28, 3, -84, 4, -11, 27, -12,
    65, -24, -16, -43, 27, -44, 19, -6,
    4, -1, 127, -4, -41, -16, 57, -11,
    -57, 70, -28, -29, 1, 55, -19, 47,
    -38, 62, -14, -23, 11, -33, -25, -34,
    -43, 12, 37, -56, -5, 10, -18, -33,
    -3, -8, 4, -7, -11, 28, 23, 3,
    73, -71, 80, 49, 20, 43, -1, -47,
    45, 9, 34, -3, -52, -77, 17, -9,
    95, 7, -34, 20, 61, -7, 2, -21,
    -3, 1, -8, 5, 37, -20, 22, -14,
    -32, 32, -40, -10, -45, 7, -14, 11,
    30, 0, 13, -32, -8, -60, 0, 0,
    62, 40, 13, -16, 4, -11, 10, 6,
    2, -3, 5, -4, 43, -26, -51, 60,
    -94, 37, -40, -62, -52, -36, -29, 103,
    70, 11, -28, 72, -71, 12, 10, -34,
    47, 23, 14, -3, 19, -16, -7, -30,
    4, -3, -26, 16, -22, -15, -23, -46,
    -41, -20, -14, -28, -22, 7, -1, -20,
    40, -1, 20, 12, 3, 29, -15, -10,
    9, -31, -21, 4, -26, -75, 68, 11,
    5, -16, 12, 3, 38, 4, -22, -11,
    -78, -22, -70, 34, -23, -23, 33, -34,
    90, 0, 67, 62, -9, 65, 7, -9,
    3, -5, 9, 79, 7, -26, -23, 16,
    -2, 5, 8, 4, -32, 35, 54, 50,
    63, -87, -52, 39, 46, -49, -48, -7,
    32, 10, -23, -26, -57, -29, 40, 35,
    -63, -27, 17, 89, 17, -8, -21, 22,
    -3, -4, 1, 1, 51, 16, 46, 16,
    27, 42, -41, 29, 2, -25, -3, 33,
    -42, 32, -14, -11, 7, 6, 12, 24,
    70, 18, 9, 60, 20, -1, -3, 14,
    -6, 8, -4, -9, 27, 2, 51, 2,
    -68, -25, -36, -31, 2, 43, -60, 42,
    -44, 23, 26, 44, 24, 1, -13, -11,
    16, 28, -8, 73, 0, 26, -43, -5,
    -1, 10, 19, 4, -14, 1, 37, -1,
    18, -78, -20, -5, 40, 42, -56, 47,
    0, 0, 18, -19, 3, -85, -64, 98,
    39, -31, -75, -18, -13, 7, -10, 67,
    9, -33, -12, -2, 41, 18, -2, 8,
    -31, -28, -22, -49, -59, 44, -50, -2,
    0, -23, -29, -44, 37, 16, -37, 25,
    127, -56, -2, -7, 17, 31, -27, 21,
    4, 14, 2, -19, -9, -8, 22, -27,
    -6, 19, -9, -55, -12, 31, 36, -59,
    14, -20, -17, 27, 6, 35, 39, -51,
    -2, 43, 33, -23, 44, -5, 42, -8,
    0, -4, -1, -13, 10, -27, -22, -30,
    0, 0, -3, -14, -7, 24, -28, 30,
    36, 60, -55, -8, 16, 38, -18, -5,
    8, 18, -31, -3, 25, -12, 9, 3,
    -3, 4, -8, 20, -46, 24, -15, -38,
    9, -29, -58, 5, -11, 33, 1, 28,
    5, -33, -3, 74, -16, -81, 18, 26,
    49, 17, 20, 8, 39, 19, 18, 59,
    3, -6, 0, -3, 0, -23, -10, 14,
    34, 52, -50, 34, 13, 20, 5, 56,
    -16, 20, -23, 11, 36, 9, 1, 50,
    44, 1, 29, 83, -2, -32, 60, 69,
    12, -22, 0, 11, 0, 41, -9, -93,
    22, 69, -17, 11, 26, -11, -32, -60,
    43, -3, -1, -11, -3, -32, 31, 1,
    -10, -64, -22, 6, 16, -13, 15, 27,
    -9, 4, -3, -7, -23, -33, -11, -11,
    0, -54, -10, -26, -14, -45, -24, 0,
    12, -7, 19, 6, -15, -35, -33, 20,
    17, -13, 49, 10, -4, 15, -21, -10,
    10, -14, -3, -3, 15, -15, 24, 12,
    -11, 63, 29, -56, 37, 32, 37, -53,
    -53, 116, 23, -24, -2, 38, -20, 6,
    38, 17, 24, 11, 3, -29, 4, -34,
    -21, 4, 12, -3, -26, 32, -13, 11,
    -32, -54, 1, -28, 39, 41, 32, -35,
    -4, 35, 0, -62, 45, 41, 41, 64,
    34, -28, -56, 45, 13, -17, -27, 6,
    14, -17, -19, -27, 11, 8, 17, 28,
    -25, 32, -20, -50, 25, -73, -4, -26,
    5, 2, 1, 20, 11, -26, 20, 35,
    -22, 0, 0, 0, -27, 6, 9, -21,
    -26, 39, 4, 3, 1, 31, -29, -8,
    8, 9, -9, -30, -1, -32, -28, 5,
    -15, 22, 28, 9, -5, 16, 19, 25,
    4, 4, -10, 19, 9, 10, -2, 7,
    8, -10, -10, 0, -32, -2, -29, -10,
    1, 13, 28, 2, 1, 26, 24, 0,
    1, 13, -2, 27, -10, 24, 6, 13,
    3, -19, -3, 2, -23, 18, 12, -10,
    -25, -4, 4, 39, 6, -32, -3, -19,
    -11, 18, 12, 19, -4, 10, -27, 3,
    -5, 21, 1, -13, 23, -3, 4, 7,
    8, 3, 14, 8, -14, 8, 21, 3,
    -80, -8, 3, 44, -21, -15, 12, 15,
    13, -15, -15, 20, 17, -39, -32, -18,
    -2, 11, -10, 24, -16, 24, -25, 39,
    7, -25, -2, -5, -22, -26, 7, 4,
    -9, -4, -3, 12, 0, 17, -38, -13,
    -51, -9, -19, -14, 4, -7, 19, -13,
    -24, -26, -17, 11, 15, 14, -4, 40,
    16, -4, -4, 10, -10, 10, -16, -6,
    25, 14, -7, -11, -1, 29, 3, -14,
    -15, -4, -1, 16, -24, 7, 37, 48,
    12, 5, 11, 8, 32, 4, -51, -26,
    -4, -10, 10, 7, 0, 12, -1, -23,
    -2, 1, 3, 22, -22, -24, -7, -14,
    -22, 45, -18, -47, 3, -16, 4, -29,
    -2, -14, 21, -14, -22, -15, 18, 3,
    -12, -7, -16, -3, 23, 6, 32, -22,
    -1, -18, 23, -4, -4, 6, 24, -6,
    -25, 34, 26, -19, -20, -13, 12, 42,
    36, 4, 2, -40, -17, 16, -9, 21,
    15, -15, -13, 8, 4, 12, 5, -3,
    -1, 11, 10, -7, 25, 41, -21, 14,
    9, -4, -9, -16, -15, 15, -65, -12,
    -9, 3, -21, 18, -5, -37, -18, -39,
    -3, 10, -15, -1, -10, 36, 17, -1,
    -3, 14, -10, 23, -13, 14, 9, -22,
    8, 24, -16, -8, -51, 20, -12, -17,
    -26, -4, 1, 28, 17, 19, -17, -12,
    -10, 3, 1, 3, -1, -2, 12, 0,
    -7, -6, -4, 24, -3, -18, 3, 11,
    -23, -23, -2, -8, 1, 15, -9, 7,
    -6, 23, 10, 31, 24, -36, -20, 40,
    4, 4, 21, 18, 7, -1, -25, -28,
    -5, -13, -6, -4, -5, -4, -22, -20,
    -3, 8, 19, 8, -8, -52, 4, 29,
    11, -10, -5, -16, 2, -23, -13, 13,
    0, 8, -12, -4, 5, -3, 0, -6,
    -2, 2, -8, 6, -12, 12, 10, 12,
    26, -23, 15, 26, 16, -29, -11, -12,
    11, -14, 4, 17, 8, -40, -22, 8,
    -1, 22, -11, 14, 6, 8, -1, 11,
    -13, -2, -2, -5, -18, 44, -17, 4,
    10, 25, 16, -15, -1, -2, -9, 7,
    -10, -35, 23, 0, -33, 32, 20, 0,
    1, 18, 16, 4, -28, 8, -16, -16,
    -5, 38, -19, 20, 13, 3, 7, -20,
    2, -3, -7, -14, 16, -12, 7, 12,
    -2, 18, -21, -6, -4, -41, 9, 20,
    -10, 1, -2, -14, -32, -25, -9, -8,
    -5, 9, -1, 15, 1, 10, 16, -8,
    -8, 14, 15, 16, -3, -30, 6, 25,
    -12, -28, 2, 1, 10, -21, 27, -9,
    -11, -3, 2, 3, -5, -48, 15, -4,
    16, 4, 17, 4, -4, 5, 32, -15,
    -3, 11, -12, -6, 14, 28, 8, -14,
    12, 8, 24, 7, 25, 5, -11, -25,
    -12, -24, 1, 0, 18, 7, 2, 21,
    12, -12, 2, 2, 17, -8, 7, 8,
    -21, -2, 12, -18, 21, -14, 23, -2,
    -14, -14, 0, -8, -35, 2, 7, -1,
    -8, -10, -10, 10, 1, -1, -14, 9,
    49, 18, -1, 12, -6, -3, -1, -32,
    17, 4, 4, -5, -31, -39, -2, -32,
    3, 1, 2, 76, -35, -12, -17, 33,
    -29, -11, 3, 25, 9, -20, 10, 22,
    -16, 14, 0, 25, -13, 1, -11, -5,
    -14, -32, -26, 32, 23, 39, 17, 12,
    7, -14, -21, -2, 17, -21, -42, -11,
    1, -16, 3, 8, -8, -16, -2, -10,
    3, -25, -9, -19, 8, 5, 8, 15,
    2, -3, -14, 38, -9, 63, 35, 1,
    -8, -20, 13, -7, -13, 17, 10, -1,
    7, -5, 1, 35, 1, -18, 17, 5,
    -4, 23, -44, 5, -4, -13, -30, 18,
    -23, 1, -2, -4, -15, 29, -2, -5,
    25, 3, 9, 10, 1, -20, 4, 11,
    -5, -5, -14, -2, 0, -5, -4, 18,
    -2, 12, -9, -14, -3, 0, -1, 0,
    6, -16, 20, 4, 13, 4, 39, -6,
    -30, -2, -2, 9, -16, 12, 11, 3,
    -9, 3, -13, 1, 15, 6, -10, -11,
    -3, -11, 18, -14, 7, 4, 13, 19,
    7, 44, -4, -10, 9, 1, -9, -13,
    13, 14, -4, -22, -54, -4, 10, 39,
    24, 22, -6, 5, 4, -11, 3, 14,
    -6, 2, 8, 4, -14, -37, 6, 14,
    -20, -14, -12, -12, -6, 54, -10, 6,
    -5, -10, -22, -14, 2, -7, 21, 9,
    9, -4, 5, 8, -4, 14, 25, 4,
    -17, 6, -20, -5, 13, -6, -18, 10,
    4, 10, -20, 27, 15, 24, 5, 8,
    -12, -22, 27, 28, -12, -5, -7, 18,
    -11, 20, 3, -30, -10, -34, 9, 36,
    23, -32, 36, -5, 6, -32, 3, -33,
    -17, 25, -13, 5, 14, -59, 16, -9,
    8, 26, -9, -26, 10, -13, -32, -18,
    10, -14, -5, -28, 1, -16, 13, 25,
    -3, -13, 12, 29, 1, -5, 3, 22,
    12, 33, -22, -4, 17, 20, -37, 4,
    -11, -16, -45, -4, 33, 13, 18, -5,
    19, 5, -2, 6, 15, 20, -27, 14,
    -13, -26, -53, -6, 7, -5, 47, -18,
    -14, 23, 5, -3, 30, 9, -11, -8,
    3, 0, 6, -28, 40, 10, 18, -12,
    14, 10, -3, -11, 3, -6, -9, -23,
    6, -4, 36, -8, -3, -21, 8, -2,
    0, -17, -8, 3, 0, 43, 1, -18,
    28, 41, -10, 19, -20, 13, -18, -18,
    -16, 8, 16, 12, -14, -21, 0, -11,
    6, -7, 2, -3, -27, -1, 6, -14,
    20, 1, -24, 15, -21, 5, -48, 24,
    -11, -19, -9, -18, -1, 21, -2, -23,
    -17, -12, 19, -5, -12, -11, 10, -10,
    -1, -8, 22, -17, -23, 11, 2, 22,
    13, 38, -20, -18, 50, 26, 44, 23,
    32, -12, 1, 8, 22, 29, 4, -19,
    11, -13, 2, 0, -2, 7, 20, -1,
    -15, 11, -12, -5, -37, -15, 15, -19,
    -20, 18, 13, -25, -6, -9, -19, -107,
    20, 34, 25, -14, 44, 13, 35, -21,
    6, -3, -13, 23, 22, 13, -18, -6,
    -6, 1, 7, 5, -1, -13, -6, 1,
    -8, 18, 14, 6, 20, 2, 0, -7,
    14, 1, 30, 30, 13, 7, -47, 4,
    -3, -3, 27, -1, -50, -4, 16, 28,
    -46, 12, -9, 41, -3, 7, 15, -37,
    -7, 18, 8, -2, 43, 42, -43, -14,
    -4, 21, 0, -11, -26, 2, -37, -33,
    -5, 8, -26, -12, -27, 12, -4, 4,
    8, 2, -10, 69, -12, 6, 10, 28,
    -3, 20, -26, 10, -12, 34, -5, 6,
    -5, -3, 8, -5, 3, -30, -16, -25,
    -11, -12, 13, 9, -30, -33, 18, -14,
    -4, -6, -3, 17, -17, 19, -22, 16,
    -11, 20, 1, -2, 24, 5, 15, -53,
    -8, -37, -7, -28, -28, 35, 44, -1,
    4, -10, 2, 9, -21, 5, -31, -4,
    9, 15, -19, -12, 13, 16, -26, -1,
    0, 1, 24, -41, -26, 26, 13, 23,
    16, 19, 9, -25, 37, 66, 2, -21,
    -7, 22, 12, -6, 25, -30, -5, -43,
    2, 6, -11, 8, -21, -16, -14, 14,
    -13, 15, 28, -16, -37, 34, 26, 9,
    -46, 6, 23, 19, 16, -25, -14, 29,
    5, 13, -19, 2, -27, -7, 28, -13,
    -6, 9, 25, 12, -9, -33, 17, 8,
    -11, 9, 20, 3, 79, 6, -2, -104,
    10, 16, 1, -40, -34, 53, 14, -30,
    8, -1, -12, -8, -15, 6, -4, -3,
    7, -3, -15, -35, -4, 7, 14, -2,
    -24, 13, 12, -20, -10, 51, -34, -12,
    7, 13, -10, 11, 4, 33, -36, -55,
    -23, 18, -6, -11, -31, 9, 1, -7,
    -25, 10, -26, 8, 15, 0, 24, 6,
    -1, 11, -33, -19, -34, 7, -13, -50,
    -2, 0, -6, 27, 25, 10, 37, 31,
    5, -3, 16, 3, 3, -6, 16, -4,
    -8, -12, -9, 19, -5, 9, -14, -20,
    17, -2, 9, -11, 10, -14, 30, -21,
    -13, -38, 12, 27, 9, 37, -25, -20,
    -20, 14, 9, 19, -11, -39, -4, 7,
    -7, -11, 12, 15, 8, 48, 2, -5,
    -3, -14, 17, 18, 12, 31, -3, -32,
    13, -14, -6, -43, 0, -26, -27, -12,
    -11, 3, -6, -16, 4, -9, -1, -19,
    4, -38, 5, 4, -12, 22, 0, 21,
    -22, -31, 3, 20, -17, 26, -3, -21,
    15, -22, 32, -20, 20, -2, 26, -33,
    -7, 4, 29, 0, 1, 29, 19, 28,
    -1, 25, 4, -9, -11, 9, -6, 33,
    -2, 14, -4, -27, -48, -22, -19, 62,
    -10, -37, 20, 1, 81, -11, -30, -10,
    -16, -11, 10, 4, -32, -2, 1, -15,
    4, -19, -27, 18, -16, -2, 3, -32,
    23, -11, 16, -33, 90, -8, 50, -2,
    -19, 35, -23, 8, 35, 28, 37, -1,
    15, 3, 10, 19, -17, -41, -15, -19,
    -7, 9, 11, 2, -2, -12, 2, 15,
    -38, 43, -6, 17, -18, 26, -4, -82,
    -22, -36, -4, -18, 53, -16, -2, -26,
    18, 1, 12, -13, -32, -31, 5, -14,
    -14, -7, 13, 13, 9, 16, 5, -